<?php 
/**
*
* PHP EMAIL VALIDATION
* This script performs real time email verification.
*
* @author Rowland O'Connor <https://plus.google.com/+RowlandOConnor>
* @version 1.0.0
*
* IMPORTANT DISCLAIMER
* This script is provided AS IS for educational purposes only.
*
* Script is NOT designed for industrial application and has 
* several known key deficiencies in error tolerance 
* and accuracy / coverage of email address queries.
*
* No warranty or support is provided. Use of this script 
* is at your own risk.
*
*
* USAGE WARNING
* Many hosting companies do not allow SMTP send 
* operations. Please get permission from your hosting provider 
* before deploying this script.
*
*
* LICENSE
* This script is licensed under Apache 2.0 (http://www.apache.org/licenses/).
*
*
* For further details, please see accompanying readme.txt.
*
*
* Source code at
* https://github.com/Roly67/php-email-validation
*/
?>

<?php
/* CONFIGURATION */

/*
$FROM Appears in the MAIL FROM:<> part of the SMTP conversation
It is VITAL to set this to your valid domain otherwise email 
verification might not work.
*/
$FROM = "ankit@intricaretech.com"; // <-- !VERY, VERY, IMPORTANT. DON'T FORGET TO SET.

/*
$EMAIL_REGEX is used for Regex validation of the email address.
You can use your own, but the default one below is pretty comprehensive 
and should be good enough for most purposes.
*/
$EMAIL_REGEX="^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,4})$";

/*
$TCP_BUFFER_SIZE defines the in memory buffer size used for SMTP conversations.
Default of 1024 is fine in most cases.
*/
$TCP_BUFFER_SIZE = 1024;
?>

<?php
/*
Presentation HTML
*/
?>
<p><strong><a href="https://github.com/Roly67/php-email-validation" target="_blank">PHP Email Validation</a></strong> script.</p>
<p>Example script to verify emails in real time using <abbr title="Personal Home Page">PHP</abbr>.</p>
<p><strong>Notes:</strong></p>
<ul>
<li>Provided &quot;as is&quot; for educational purposes only.</li>
<li>
	Performs two layers of validation:
	<ol>
		<li><strong>Syntax</strong> using server side regular expression.</li>
		<li><strong><abbr title="Simple Mail Transfer Protocol">SMTP</abbr></strong> connects to remote mail servers.</li>
	</ol>
</li>
<li>Source code and documentation at <a href="https://github.com/Roly67/php-email-validation" target="_blank" rel="nofollow">Github</a></li>
</ul>
<form action="" method="post">
	<input type="text" id="emailtoverify" name="emailtoverify" value="<?php if(isset($_POST["emailtoverify"]))
echo($_POST["emailtoverify"])?>" />
	<input type="submit" value="verify" />
</form>

<?php

/*POST back handler*/
if(isset($_POST["emailtoverify"]))
{
	$result = VerifyMail(trim($_POST["emailtoverify"]));
	
	// SMTP code 250 shows email is valid.
	if (substr($result[0],0,3) == "250")
		  echo("<strong>Result</strong>: Email is OK"); 
		else 
		{
		  echo("<strong>Result</strong>: Email is bad"); 
		  
		  // The reason why it's bad.
		  echo("<br/><br/> <strong>Description</strong>: ".$result[0]);
		}  
		
	echo("<p><strong>Server log:</strong></p>");
	$log = $result[2];
	$log = str_replace("<","&lt;", $log);
	$log = str_replace(">","&gt;", $log);
	$log = str_replace("\r","<br/>", $log);
	echo($log);
}


/*
Description:
Verifies email address

Parameters:
$Email - Email address to verify

Returns:
Array containing email verification result.
*/
function VerifyMail($Email) 
{
	global $FROM; // FROM address. See settings section above
	global $EMAIL_REGEX; // Email syntax verification Regex
	global $TCP_BUFFER_SIZE; //TCP buffer size for mail server conversation.

	// $HTTP_HOST gets the host name of the server running the PHP script.
	$HTTP_HOST = $_SERVER["HTTP_HOST"];
	
	// Prep up the function return.
	$Return = array();  

	// Do the syntax validation using simple regex expression.
	// Eliminates basic syntax faults.
	if (!eregi($EMAIL_REGEX, $Email)) 
	{ 
		$Return[0] = "Bad Syntax";         
		return $Return; 
	}
   
	// load the user and domain name into a local list from email address using string split function.
	list ( $Username, $Domain ) = split ("@",$Email); 

	// check if domain has MX record(s)
	if ( checkdnsrr ( $Domain, "MX" ) )  
	{ 
		$log .= "MX record for {$Domain} exists.\r"; 
	
		// Get DNS MX records from domain
		if ( getmxrr ($Domain, $MXHost))  
		{              
		} 

		// Get the IP address of first MX record
		$ConnectAddress = $MXHost[0]; 

		// Open TCP connection to IP address on port 25 (default SMTP port)
		$Connect = fsockopen ( $ConnectAddress, 25 );
		
		// Rerun array element index 1 contains the IP address of the target mail server
		$Return[1] = $ConnectAddress;
		  
		// Successful connection to mail server.
		if ($Connect)   
		{
			$log .= "Connection to {$ConnectAddress} SMTP succeeded.\r"; 
			
			// look for a response code of 220 using Regex
			if ( ereg ( "^220", $reply = fgets ( $Connect, $TCP_BUFFER_SIZE ) ) ) 
			{ 
				$log .= $reply."\r";
				
				// Start SMTP conversation with HELO
				fputs ( $Connect, "HELO ". $HTTP_HOST ."\r\n" ); 
				$log .=  "> HELO ". $HTTP_HOST ."\r"; 
				$reply = fgets ( $Connect, $TCP_BUFFER_SIZE );
				$log .= $reply."\r";                  

				// Next, do MAIL FROM:
				fputs ( $Connect, "MAIL FROM: <". $FROM .">\r\n" ); 
				$log .=  "> MAIL FROM: <". $FROM .">\r"; 
				$reply = fgets ( $Connect, $TCP_BUFFER_SIZE );
				$log .= $reply."\r";    
				
				// Next, do RCPT TO:
				fputs ( $Connect, "RCPT TO: <{$Email}>\r\n" ); 
				$log .= "> RCPT TO: <{$Email}>\r"; 
				$to_reply = fgets ( $Connect, $TCP_BUFFER_SIZE );
				$log .= $to_reply."\r";  
				
				// Quit the SMTP conversation.
				fputs ( $Connect, "QUIT\r\n"); 

				// Close TCP connection
				fclose($Connect); 
			} 
		} 
		else 
		{ 
			// Return array element 0 contains a message.
			$Return[0]="500 Can't connect mail server ({$ConnectAddress}).";         
			return $Return; 
		} 
	} 
	else 
	{
		$to_reply = "Domain '{$Domain}' doesn't exist.\r";    
		$log .= "MX record for '{$Domain}' doesn't exist.\r"; 
	}
        
	$Return[0]=$to_reply;
	$Return[2]=$log;

	return $Return;
}

exit;
include('config.php');
define("MIN_DELAY", 35);
define("MAX_DELAY", 75);
define("DONT_SEND_MESSAGES", 0);
define("MAX_ERROR_COUNT", 3);
define("SEARCH_LIMIT", 1000);
define("PROFILES_PER_PAGE", 10);
define("SEARCH_LIMIT_SALES", 2500);
define("PROFILES_PER_PAGE_SALESNAV", 25);
define("LINKEDIN_API_RESPONSE_LEN", 20);
define("ACCEPTED_WAITING_DELAY", 1000 * 60 * 60 * 24);
define("MS_DAY", 864E5);
define("MS_MINUTE", 6E4);
define("CURRENT_ERROR_COUNT", 0);
define("WAIT_SECONDS", 10);
define("LAST_ERROR", '');
define("TASK_LIMIT_TIME_PERIOD", 864E5);
define("TASK_MAX_EXECUTION_TIME", 6E5);

$userId = 39960; 

$userQry = mysqli_query($con, "SELECT usrprfl.linkedin_email, usrprfl.linkedin_password, usrprfl.firstName, usrprfl.lastName, usr.csrf, usr.cookie, usr.first_name, usr.email, usr.portal_id, usr.geoUpdate, usr.proxyIp,usr.proxyPort, usr.proxyUsername, usr.proxyPassword, usr.userAgent from user_profile usrprfl, user usr where usrprfl.user_id = usr.id AND usr.id=" . $userId);

$user = mysqli_fetch_assoc($userQry);

$proxyIp = $user['proxyIp'];
$proxyPort = $user['proxyPort'];
$proxyUsername = $user['proxyUsername']; 
$proxyPassword = $user['proxyPassword'];
$userAgent = $user['userAgent'];
$csrf = "ajax:7743998455800627691";//$user['csrf'];
$cookie = 'lang=v=2&lang=en-us; bcookie="v=2&830d7ad7-1483-48a0-8ce9-f97c7996705d"; bscookie="v=1&20240430094434229475f8-ac07-4b3e-8a4b-5c9875aa4610AQE6g8GfTOwEiwkRsfB1WIOXnC4AtOFL"; li_alerts=e30=; li_gc=MTsyMTsxNzE0NDcwMjgwOzI7MDIxSKBe0E07w2T/P7tNDSP8aXOSXJPiq1cFjd/KJLz1veA=; AMCVS_14215E3D5995C57C0A495C55%40AdobeOrg=1; AMCV_14215E3D5995C57C0A495C55%40AdobeOrg=-637568504%7CMCIDTS%7C19844%7CMCMID%7C53694080950329492732948257394239476249%7CMCAAMLH-1715075081%7C7%7CMCAAMB-1715075081%7C6G1ynYcLPuiQxYZrsz_pkqfLG9yMXBpb2zX5dvJdYQJzPXImdj0y%7CMCOPTOUT-1714477481s%7CNONE%7CvVersion%7C5.1.1; liap=true; JSESSIONID="ajax:7743998455800627691"; lidc="b=TB90:s=T:r=T:a=T:p=T:g=3993:u=1202:x=1:i=1714470290:t=1714540390:v=2:sig=AQHnQmpp8oT-xhdfDnmqnYtOocj9BrgM"; timezone=Asia/Calcutta; li_theme=light; li_theme_set=app; dfpfpt=bd7accaafcfc4d7aa78270dcfe68429f; fptctx2=taBcrIH61PuCVH7eNCyH0FWPWMZs3CpAZMKmhMiLe%252bEQlY0oDlhpuaKgE77y%252bQDjGGYXF8dFkFXgcFF2Qajp7aPsTF4lVONZ8VGtq9sUOCbPmc8ep94h92ZPXHS4ilkhDzWb6E590CUyPebj%252btjELJhN0M0G%252bE8zcndKxLAMqs6LNSxHPXCLVP1BsPoVXWBtJBiGZ5Hk%252fsxFCjgwgohNM3uDODiEHCtUWDzU4HPRc8MZFFOd987x2U4qdHT3E9nJVUNaYM155AtevCaElYcXx3O2RPt2%252fmLksrz%252fw6KXuMPFmA1SJ4On14ZVlPix5BscG%252b%252beEmNwdGrpHnl2Qtqfdr4tEX271%252bk0lzhjrXdPjb4%253d; li_at=AQEFAakBAAAAAA9nnNIAAAGPLmSDMQAAAY9SjJ-wTgABTHVybjpsaTplbnRlcnByaXNlQXV0aFRva2VuOmVKeGpaQUFCeGRtUFFKU0E5ZFhwSUpyWldqNlNFY1JnNHBKckFUTTBmR2U1TXpBQ0FJMzlCaFE9XnVybjpsaTplbnRlcnByaXNlQXV0aFRva2VuOmVKeGpaQUFDMXJXZHMwQTBaOTJqSXlDYVRUVjJGU09Jb2JkL2R6V1lJZXFkN2MvQUNBRENEd2gyXnVybjpsaTplbnRlcnByaXNlUHJvZmlsZToodXJuOmxpOmVudGVycHJpc2VBY2NvdW50OjIyMDI1OTQsMjcyMzU2NzU5KV51cm46bGk6ZW50ZXJwcmlzZVByb2ZpbGU6KHVybjpsaTplbnRlcnByaXNlQWNjb3VudDo5NTI1OTAzNCwxNTkzMTA1MzIpXnVybjpsaTptZW1iZXI6MTU2Nzc0MDkwfATmwk5EWe5WKM1Fjtv_4fyMqSZ3InEJVXiBxnGkK5RMFVrrnS-Ef47aj3PK97C9nG5mHgOKek0ddM3OYooKRnf8Z6iElYOCyaVn3qVnRvcqBBobVMHPVrZxrvUVxVgXi-2Yx95qYxTwf-7FUGQfHsp4dadYeakKuUjP07lkE7ug62336i0Yt4MM-VJDkFikE84yKg; li_ep_auth_context=AONhcHA9c2FsZXNOYXZpZ2F0b3IsYWlkPTIyMDI1OTQsaWlkPTU0MjA2Mjk3LHBpZD0yNzIzNTY3NTksZXhwPTE3MTcwNjI0MDc3NzYsY3VyPWZhbHNlLHNpZD02NzYxNzQ0MDcsY2lkPTM0MjE3NjA0fGFwcD1zYWxlc05hdmlnYXRvcixhaWQ9OTUyNTkwMzQsaWlkPTEwMzExMjEwNixwaWQ9MTU5MzEwNTMyLGV4cD0xNzE3MDY0MDk4NzYxLGN1cj10cnVlLHNpZD0zNTcyNjQyMDcsY2lkPTc4NDMxNzMwNwHRAZM1IOVI5LOAmS5C4qYjb9qqXQ; __cf_bm=Y3PUcsoSmJ97hxQ9nT1nU3dCS7DXKI3Rc_nK28Us3x0-1714472112-1.0.1.1-CVLDqArWFrP9lUNZSY.lIKYZRC5nuyzG5LW0br8QdjnRK748bLE8Yqv69y.RI1NY06YLzSchHUgx.n9KQIOlqw; li_a=AQJ2PTEmc2FsZXNfY2lkPTM0MjE3NjA0JTNBJTNBNjc2MTc0NDA3YgClfDg_IR3o2N-NaUMEQw25uP0; li_mc=MTszODsxNzE0NDcyMTg1OzI7MDIxYD8KCtGK7PbMsfAdzTyqsjV9vOKauCS/3j8Q/x1kxYg=';//$user['cookie'];
$geoLocation = $user['geoUpdate'];  

#$linkQry = mysqli_query($con, "SELECT link from ext_links where id=256983");
#$link = mysqli_fetch_assoc($linkQry);
#$link['seqId'] = 213322; 
#$aExtLinkArr['link'] = $link['link']; 
$aExtLinkArr['link'] = "https://www.linkedin.com/sales/search/people?page=2&query=(recentSearchParam%3A(id%3A3366708298%2CdoLogHistory%3Atrue)%2Cfilters%3AList((type%3ALEAD_LIST%2Cvalues%3AList((id%3A7188887225663696896%2Ctext%3AWed%2520Developers%2CselectionType%3AINCLUDED)))%2C(type%3ARELATIONSHIP%2Cvalues%3AList((id%3AS%2Ctext%3A2nd%2520degree%2520connections%2CselectionType%3AINCLUDED)%2C(id%3AO%2Ctext%3A3rd%252B%2520degree%2520connections%2CselectionType%3AINCLUDED)))))&sessionId=TG1OthsvQOW%2BG5fjhQEqcg%3D%3D&viewAllFilters=true"; 

if(strpos($aExtLinkArr['link'], "search/people?") !== false){
	echo "1";
	$splitedString = str_replace("%2520", "%20", substr($aExtLinkArr['link'], strpos($aExtLinkArr['link'], "?") + 1));
}elseif(strpos($aExtLinkArr['link'], "list/similar-leads/") !== false) {
	echo "2";
	$splitedString = str_replace("%2520", "%20", substr($aExtLinkArr['link'], strpos($aExtLinkArr['link'], "?") + 1)); 
}else{
	echo "3";
	$splitedString = str_replace("%2520", "%20", substr($aExtLinkArr['link'], strpos($aExtLinkArr['link'], "#") + 1));
}
$splitedString = str_replace("%2526", "%26", $splitedString);
$splitedString = str_replace("%25C3", "%C3", $splitedString);
$splitedString = str_replace("%25A9", "%A9", $splitedString);
$splitedString = str_replace("%25C4", "%C4", $splitedString);
$splitedString = str_replace("%2593", "%93", $splitedString);
$splitedString = str_replace("%25C2", "%C2", $splitedString);
$splitedString = str_replace("%25AE", "%AE", $splitedString);
 

$splitedString = str_replace("(", "%28", $splitedString);
$splitedString = str_replace(")", "%29", $splitedString);

parse_str($splitedString, $queryString);
$logHistory = (isset($queryString["logHistory"]))?$queryString["logHistory"]:'';
$page = (isset($queryString["page"]))?$queryString["page"]:'';
(isset($queryString["logId"]) && !empty($queryString["logId"])) ? $logId = $queryString["logId"] : $logId = 0;
$searchSessionId = $queryString["searchSessionId"];
$searchSessionId = str_replace(" ", "+", $queryString['searchSessionId']);

/* $searchSessionId = str_replace("+", "%2B", $queryString['searchSessionId']);
$searchSessionId = str_replace("=", "%3D", $queryString['searchSessionId']); */
$resID = $queryString["rsLogId"]; 
$sessionId = (isset($queryString["sessionId"]))?$queryString["sessionId"]:0;
$sessionId = (!empty($sessionId))?str_replace(" ", "+", $sessionId):0;
$sessionId = (!empty($sessionId))?str_replace("/", "%2F", $sessionId):0;
//print_r($queryString);exit;
unset($queryString["viewAllFilters"]);
unset($queryString["sessionId"]);
//unset($queryString["geoIncluded"]);
//unset($queryString["keywords"]);
unset($queryString["logHistory"]);
unset($queryString["page"]);
unset($queryString["logId"]);
unset($queryString["searchSessionId"]);
unset($queryString["rsLogId"]);
unset($queryString["_ntb"]);
unset($queryString["selectedFilter"]);
echo "else<br>";
$qryStrng = '';
$filters="";
$filterPad=""; 
$keywords="";
//print_r($queryString);exit;
foreach ($queryString as $key => $val) {
	$val = str_replace("&", "%26", $val);  
	$isss=$isss+1;
				//echo $isss."::::".$key."=>".$val."</br>";
	if ($key == 'keywords') {
		$val = str_replace(',', '%2C', trim($val));
		$val = str_replace(':', '%3A', trim($val));
		$keywords="keywords:".$val;
	} else if ($key == 'company') {
		echo "In Company:::<br>";
		print_r($val);
		$company = str_replace(":", "%3A", trim($val));
		$companies = explode(',', $company);
		$list = "";
		foreach ($companies as $k => $v) {
			$v=str_replace("&", "%26", $v);
			$v1 = explode('%3A', $v);
			if (array_key_exists(1, $v1)) {
				$list .= "(text:" . rawurlencode($v1[0]) . ",id:" . $v1[1] . ")";
			} else {
				$list .= "(text:" . rawurlencode($v1[0]) . ")"; 
			}
			if (count($companies) != $k + 1) {
				$list .= ',';
			} 
		}
		$qryStrng .= $key . ":(scope:" . $queryString['companyTimeScope'] . ",values:List(" . str_replace("&", "%26", $list) . ")),";
	} else if ($key == "searchWithinMyAccounts") {
		$qryStrng .= "searchWithinMyAcct:true,";
	}else if ($key == "savedSearchId") {
		$sharedSearchData= explode(",",$val);
		if(isset($sharedSearchData[0]) && isset($sharedSearchData[2])){
			$qryStrng .= "savedSearchId=".$sharedSearchData[2]; 
		}else{
			if($user['id']==33039){
				//file_put_contents("querystring.txt",print_r($sharedSearchData,true).":::newstring\r\n",FILE_APPEND);
			}
			$qryStrng .= "savedSearchId=".$sharedSearchData[0];
		}
	} else if ($key == "sharedSearchId") {
		$sharedSearchData= explode(",",$val);
		if(isset($sharedSearchData[0]) && isset($sharedSearchData[2])){
			$qryStrng .= "sharedSearchId=".$sharedSearchData[2]."&sharerSeatId=".$sharedSearchData[0];
		}
	} /* else if ($key == "excludeSavedLeads") {
		$qryStrng .= "excludeSaved:true,";
	} else if ($key == "excludeViewedLeads") {
		$qryStrng .= "excludeViewed:true,";
	} else if ($key == "excludeContactedLeads") {
		$qryStrng .= "excludeContacted:true,";
	} */ /* else if ($key == "seniority") {
		$qryStrng .= "seniorityLevel:List(" . str_replace(":", "%3A", trim($val)) . "),";
	}  */else if ($key == "crmContacts") {
		if(trim($val)=="EXCLUDE"){
			$qryStrng .= "crmContacts:false,";
		}else if(trim($val)=="INCLUDE"){
			$qryStrng .= "crmContacts:true,";
		}
	} else if ($key == "titleTimeScope" || $key == "companyTimeScope" || $key == "radius" || $key == "countryCode") {
		
	} else if ($key == "zips") {
		$qryStrng .= "postalCode:(" . $key . ":List(" . str_replace(":", "%3A", trim($val)) . "),countryCode:" . $queryString['countryCode'] . ",radius:" . $queryString['radius'] . "),";
	}else if ($key == "connectionOf") {
		$qryStrng .= $key . ":List(" .trim($val). "),"; 
	} else if ($key == "bingPostalCode") {
		$qryStrng .= $key.":(zips:List(" . str_replace(":", "%3A", trim($val)) . "),radius:" . $queryString['radius'] . "),";
	} else if ($key == "firstName" || $key == "lastName") {
		$qryStrng .= $key . ":" . str_replace(":", "%3A", trim($val)) . ",";
	} else if ($key == "title") {
		$title = str_replace(":", "%3A", trim($val));
		$titleList = explode(',', $title);
		$list = "";
		foreach ($titleList as $k => $v) {
			$v1 = explode('%3A', $v);
			$v1[0] = rawurlencode($v1[0]);
			$v1[0] = str_replace("(", "%28", $v1[0]);
			$v1[0] = str_replace(")", "%29", $v1[0]);
			if (array_key_exists(1, $v1)) {
				$list .= "(text:" . $v1[0] . ",id:" . $v1[1] . ")";
			} else {
				$list .= "(text:" . $v1[0] . ")";
			}
			if (count($titleList) != $k + 1) {
				$list .= ',';
			}
		}
		$qryStrng .= "title:(scope:" . $queryString['titleTimeScope'] . ",values:List(" . str_replace("&", "%26", $list) . ")),";
	} else if ($key == "spotlight") {
		$qryStrng .= "spotlightParam:(selectedType:" . $val . "),";
	} /* else if ($key == "spotlightGroup") {
		$qryStrng .= "spotlights:List(" .trim($val). "),"; 
	}  */else {
		if (preg_match('(pastCompany)', $key) === 1) {
			$val=str_replace("&", "%26", $val); 
			$val=str_replace(":", "#######", $val);
			$replaceArray = array(",", " ", "#######");
			$replaceArrayValue = array("),(text:", "%20", ",id:");
			$finalAns = str_replace($replaceArray, $replaceArrayValue, $val);
			$arrString = (":List((text:" . str_replace("&", "%26",$finalAns) . ")),");
			$qryStrng .= $key . $arrString;
			/* $replaceArray = array(",", " ", ":");
			$replaceArrayValue = array("),(text:", "%20", "id:");
			$exVal=explode(':',$val);
			$val=str_replace("%25","%",rawurlencode($exVal[0])).":".$exVal[1];
			$finalAns = str_replace($replaceArray, $replaceArrayValue, $val);
			$arrString = (":List((text:" . $finalAns . ")),");
			$idString = str_replace("id", ",id", $arrString);
			$qryStrng .= $key . $idString; */
		} else {
			$val=rawurlencode(trim($val));    
			$val=str_replace("%28", "(", trim($val));
			$val=str_replace("%29", ")", trim($val));
			$val=str_replace("%2C", ",", trim($val));  
			$valueFind = $key . str_replace(":", "%3A", trim($val)) . ",";
			if (strpos($valueFind, "tag:")) {
				$qryStrng .= str_replace(":", "%3A", trim($val));
			} /* else if (strpos($valueFind, "relationship")) {
				$qryStrng .= str_replace(":", "%3A", trim($val));
			}  */
			else if ($key == "relationship") {
				$val = str_replace("%2C", "%2c", str_replace(",", "%2c", $val));
				$includedRelationships = explode("%2c",$val);
				$filters.=$filterPad."(type:RELATIONSHIP,values:List(";
				$rpad = "";
				foreach($includedRelationships as $includedRelationship){
					$filters .= $rpad."(id:" . $includedRelationship . ",selectionType:INCLUDED)";
					$rpad = ",";
				}
				$filters.="))";
				$filterPad=",";
			}else if (strpos($valueFind, "group:")) {
				$qryStrng .= str_replace(":", "%3A", trim($val));
			} else if (strpos($valueFind, "postedContentKeywords:")) {
				$key = str_replace("postedContentKeywords", "postKeywords", $key);
				$qryStrng .= $key . ":" . str_replace(":", "%3A", trim(str_replace("%25","%",rawurlencode($val)))) . ",";
			} else if (strpos($valueFind, "memberSince:")) {
				$qryStrng .=str_replace(":", "%3A", trim($val));
			}else if($key=="companyIncluded") {
				$val = str_replace("%2C", "%2c", str_replace(",", "%2c", $val));
				$includedCompanies = explode("%2c",$val);
				$companyTimeScope='CURRENT_COMPANY'; 
				if(isset($queryString['companyTimeScope']) && !empty($queryString['companyTimeScope']) && $queryString['companyTimeScope']!="CURRENT_OR_PAST"){
					$companyTimeScope=$queryString['companyTimeScope']."_COMPANY";
				}
				$filters.=$filterPad."(type:".$companyTimeScope.",values:List(";
				$cpad = "";
				foreach($includedCompanies as $includedCompany){
					$includedCompany = str_replace("%3A", "%3a", str_replace(":", "%3a", $includedCompany));
					$cid = explode("%3a",$includedCompany);
					$filters .= $cpad."(id:" . $cid[1] . ",text:". $cid[0] . ",selectionType:INCLUDED)";
					$cpad = ",";
				}
				$filters.="))";
				$filterPad=",";
			}else if($key=="companyExcluded") {
				$val = str_replace("%2C", "%2c", str_replace(",", "%2c", $val));
				$includedCompanies = explode("%2c",$val);
				$companyTimeScope='CURRENT_COMPANY'; 
				if(isset($queryString['companyTimeScope']) && !empty($queryString['companyTimeScope']) && $queryString['companyTimeScope']!="CURRENT_OR_PAST"){
					$companyTimeScope=$queryString['companyTimeScope']."_COMPANY";
				}
				$filters.=$filterPad."(type:".$companyTimeScope.",values:List(";
				$cpad = "";
				foreach($includedCompanies as $includedCompany){
					$includedCompany = str_replace("%3A", "%3a", str_replace(":", "%3a", $includedCompany));
					$cid = explode("%3a",$includedCompany);
					$filters .= $cpad."(id:" . $cid[1] . ",text:". $cid[0] . ",selectionType:EXCLUDED)";
					$cpad = ",";
				}
				$filters.="))";
				$filterPad=",";
			} else if($key=="seniorityIncluded") {
				$val = str_replace("%2C", "%2c", str_replace(",", "%2c", $val));
				$includedseniorities = explode("%2c",$val);
				$filters.=$filterPad."(type:SENIORITY_LEVEL,values:List(";
				$spad = "";
				foreach($includedseniorities as $includedseniority){
					$filters .= $spad."(id:" . $includedseniority . ",selectionType:INCLUDED)";
					$spad = ",";
				}
				$filters.="))";
				$filterPad=",";
			}else if($key=="profileLanguage") {
				$val = str_replace("%2C", "%2c", str_replace(",", "%2c", $val));
				$profileLanguages = explode("%2c",$val);
				$filters.=$filterPad."(type:PROFILE_LANGUAGE,values:List(";
				$spad = "";
				foreach($profileLanguages as $profileLanguage){
					$filters .= $spad."(id:" . $profileLanguage . ",selectionType:INCLUDED)";
					$spad = ",";
				}
				$filters.="))";
				$filterPad=",";
			}else if($key=="schoolIncluded") {
				$val = str_replace("%2C", "%2c", str_replace(",", "%2c", $val));
				$schoolIncluded = explode("%2c",$val);
				$filters.=$filterPad."(type:SCHOOL,values:List(";
				$spad = "";
				foreach($schoolIncluded as $schoolIncl){
					$filters .= $spad."(id:" . $schoolIncl . ",selectionType:INCLUDED)";
					$spad = ",";
				}
				$filters.="))";
				$filterPad=",";
			}else if($key=="schoolExcluded") {
				$val = str_replace("%2C", "%2c", str_replace(",", "%2c", $val));
				$includedgeoIncluded = explode("%2c",$val);
				$filters.=$filterPad."(type:SCHOOL,values:List(";
				$spad = "";
				foreach($includedgeoIncluded as $includedgeoInc){
					$filters .= $spad."(id:" . $includedgeoInc . ",selectionType:EXCLUDED)";
					$spad = ",";
				}
				$filters.="))";
				$filterPad=",";
			}else if($key=="companyType") {
				$val = str_replace("%2C", "%2c", str_replace(",", "%2c", $val));
				$includedgeoIncluded = explode("%2c",$val);
				$filters.=$filterPad."(type:COMPANY_TYPE,values:List(";
				$spad = "";
				foreach($includedgeoIncluded as $includedgeoInc){
					$filters .= $spad."(id:" . $includedgeoInc . ",selectionType:INCLUDED)";
					$spad = ",";
				}
				$filters.="))";
				$filterPad=",";
			}else if($key=="excludeSavedLeads") {
				$val = str_replace("%2C", "%2c", str_replace(",", "%2c", $val));
				$includedgeoIncluded = explode("%2c",$val);
				$filters.=$filterPad."(type:SAVED_LEADS_AND_ACCOUNTS,values:List(";
				$spad = "";
				foreach($includedgeoIncluded as $includedgeoInc){
					$filters .= $spad."(id:SL,selectionType:EXCLUDED)";
					$spad = ",";
				}
				$filters.="))";
				$filterPad=",";
			}else if($key=="includedSavedLeads") {
				$val = str_replace("%2C", "%2c", str_replace(",", "%2c", $val));
				$includedgeoIncluded = explode("%2c",$val);
				$filters.=$filterPad."(type:SAVED_LEADS_AND_ACCOUNTS,values:List(";
				$spad = "";
				foreach($includedgeoIncluded as $includedgeoInc){
					$filters .= $spad."(id:SL,selectionType:INCLUDED)";
					$spad = ",";
				}
				$filters.="))";
				$filterPad=",";
			}else if($key=="companySize") {
				$val = str_replace("%2C", "%2c", str_replace(",", "%2c", $val));
				$includedgeoIncluded = explode("%2c",$val);
				$filters.=$filterPad."(type:COMPANY_HEADCOUNT,values:List(";
				$spad = "";
				foreach($includedgeoIncluded as $includedgeoInc){
					$filters .= $spad."(id:" . $includedgeoInc . ",selectionType:INCLUDED)";
					$spad = ",";
				}
				$filters.="))";
				$filterPad=",";
			}else if($key=="tenureAtCurrentPosition") {
				$val = str_replace("%2C", "%2c", str_replace(",", "%2c", $val));
				$includedgeoIncluded = explode("%2c",$val);
				$filters.=$filterPad."(type:YEARS_IN_CURRENT_POSITION,values:List(";
				$spad = "";
				foreach($includedgeoIncluded as $includedgeoInc){
					$filters .= $spad."(id:" . $includedgeoInc . ",selectionType:INCLUDED)";
					$spad = ",";
				}
				$filters.="))";
				$filterPad=",";
			}else if($key=="yearsOfExperience") {
				$val = str_replace("%2C", "%2c", str_replace(",", "%2c", $val));
				$includedgeoIncluded = explode("%2c",$val);
				$filters.=$filterPad."(type:YEARS_OF_EXPERIENCE,values:List(";
				$spad = "";
				foreach($includedgeoIncluded as $includedgeoInc){
					$filters .= $spad."(id:" . $includedgeoInc . ",selectionType:INCLUDED)";
					$spad = ",";
				}
				$filters.="))";
				$filterPad=",";
			}else if($key=="titleIncluded") {
				$tmScope="";
				if(isset($queryString['titleTimeScope']) && !empty($queryString['titleTimeScope'])){
					$tmScope=",selectedSubFilter:".$queryString['titleTimeScope'];
				}
				$val = str_replace("%2C", "%2c", str_replace(",", "%2c", $val));
				$includedgeoIncluded = explode("%2c",$val);
				$filters.=$filterPad."(type:TITLE,values:List(";
				$spad = "";
				foreach($includedgeoIncluded as $includedgeoInc){
					$filters .= $spad."(text:" . $includedgeoInc . ",selectionType:INCLUDED)";
					$spad = ",";
				}
				$filters.=")".$tmScope.")";
				$filterPad=",";
			}else if($key=="titleExcluded") {
				$tmScope="";
				if(isset($queryString['titleTimeScope']) && !empty($queryString['titleTimeScope'])){
					$tmScope=",selectedSubFilter:".$queryString['titleTimeScope'];
				}
				$val = str_replace("%2C", "%2c", str_replace(",", "%2c", $val));
				$includedgeoIncluded = explode("%2c",$val);
				$filters.=$filterPad."(type:TITLE,values:List(";
				$spad = "";
				foreach($includedgeoIncluded as $includedgeoInc){
					$filters .= $spad."(text:" . $includedgeoInc . ",selectionType:EXCLUDED)";
					$spad = ",";
				}
				$filters.=")".$tmScope.")";
				$filterPad=",";
			}else if($key=="geoIncluded") {
				$val = str_replace("%2C", "%2c", str_replace(",", "%2c", $val));
				$includedgeoIncluded = explode("%2c",$val);
				$filters.=$filterPad."(type:REGION,values:List(";
				$spad = "";
				foreach($includedgeoIncluded as $includedgeoInc){
					$filters .= $spad."(id:" . $includedgeoInc . ",selectionType:INCLUDED)";
					$spad = ",";
				}
				$filters.="))";
				$filterPad=",";
			}else if($key=="industryIncluded") {
				$val = str_replace("%2C", "%2c", str_replace(",", "%2c", $val));
				$includedindustries = explode("%2c",$val);
				$filters.=$filterPad."(type:INDUSTRY,values:List(";
				$spad = "";
				foreach($includedindustries as $includedindustry){
					$filters .= $spad."(id:" . $includedindustry . ",selectionType:INCLUDED)";
					$spad = ",";
				}
				$filters.="))";
				$filterPad=",";
			} else { 
				//if($user['id'] == 21196){
				if(!in_array($key,array("companyExcluded","spotlightGroup","excludeSavedLeads","excludeViewedLeads","excludeContactedLeads","titleExcluded","companyIncluded","companySize","doFetchHeroCard","functionIncluded","industryIncluded","relationship","seniorityIncluded","seniority","titleIncluded","spellingCorrectionEnabled","yearsOfExperience","seniorityExcluded"))){	 
					$qryStrng .= $key . ":" . str_replace("=", "%3D",str_replace("&", "%26",str_replace(":", "%3A", trim($val)))) . ","; 
				} 
				/* }else{
					$qryStrng .= $key . ":" . str_replace("=", "%3D",str_replace("&", "%26",str_replace(":", "%3A", trim($val)))) . ","; 
				} */
			}
		} 
	}
} 
//if($user['id'] == 21196){
	$qryStrng = str_replace("query:","",rtrim($qryStrng,","));
//}	
if(!empty($keywords)){
	if(!empty($filters)){
		$filters="filters:List(".$filters."),".$keywords;
	}else{
		$filters=$keywords;
	}
}else{
	if(!empty($filters)){
		$filters="filters:List(".$filters.")";
	}else{
		$filters=$keywords;
	}
}
 
if(!strpos($qryStrng, "filters")!== false && !empty($filters)){
	$qryStrng .=$tmpFilters="(".$filters.")";
}
if ($geoLocation == 1) {
	$qryStrng = str_replace("geoV2", "bingGeo", $qryStrng);
}
if (!empty($sessionId)) {
	$sessionId = str_replace("=", "%3D", trim($sessionId));
	$sessionId = str_replace("+", "%2B", trim($sessionId));
	$qryStrng .= "&trackingParam=(sessionId:" . $sessionId . ")";
}elseif(!empty($searchSessionId)){
	$searchSessionId = str_replace("=", "%3D", trim($searchSessionId)); 
	$searchSessionId = str_replace("+", "%2B", trim($searchSessionId));
	$qryStrng .= "&trackingParam=(sessionId:" . $searchSessionId . ")"; 
}
 
$qryStrng = str_replace("%3A", ":", $qryStrng);  
$qryStrng = str_replace("%u200B", "", $qryStrng); 
$qryStrng = str_replace(" ", "%20", $qryStrng);
$qryStrng = str_replace('"', "%22", $qryStrng);
$qryStrng = str_replace("'", "%27", $qryStrng);
$qryStrng = str_replace("“", "%93", $qryStrng);
$qryStrng = str_replace("”", "%94", $qryStrng);
$qryStrng = str_replace("%257C", "%7C", $qryStrng);
$qryStrng = str_replace("é", "%C3%A9", $qryStrng);
$qryStrng = str_replace("®", "%C2%AE", $qryStrng);
$qryStrng = str_replace("%252B", "%2B", $qryStrng); 
$qryStrng = str_replace("%25", "%", $qryStrng); 
 
$postdata = "q=searchQuery&start=" . $link['start'] . "&count=" . PROFILES_PER_PAGE_SALESNAV . "&query=" . $qryStrng . "&decorationId=com.linkedin.sales.deco.desktop.searchv2.LeadSearchResult-7";  

if($user['id']==33039){
	//file_put_contents("querystring.txt",print_r($qryStrng,true)."\r\n",FILE_APPEND);
}
$length = strlen($postdata);
$curl = curl_init(); 
if($length <= 4000){  
	//if(strpos($qryStrng,"sharedSearchId=")){
	if(strpos($qryStrng, "sharedSearchId=") !== false){
		$curlUrl = "https://www.linkedin.com/sales-api/salesApiLeadSearch?q=sharedSearchId&&start=" . $link['start'] . "&count=" . PROFILES_PER_PAGE_SALESNAV . "&" . $qryStrng . "&decorationId=com.linkedin.sales.deco.desktop.searchv2.LeadSearchResult-7";
	}elseif(strpos($qryStrng, "savedSearchId=") !== false){
		$curlUrl = "https://www.linkedin.com/sales-api/salesApiLeadSearch?q=savedSearchId&&start=" . $link['start'] . "&count=" . PROFILES_PER_PAGE_SALESNAV . "&" . $qryStrng . "&decorationId=com.linkedin.sales.deco.desktop.searchv2.LeadSearchResult-7";
	}else{
		$curlUrl = "https://www.linkedin.com/sales-api/salesApiLeadSearch?q=searchQuery&start=0&count=" . PROFILES_PER_PAGE_SALESNAV . "&query=" . $qryStrng . "&decorationId=com.linkedin.sales.deco.desktop.searchv2.LeadSearchResult-14"; 
	}  			
	if($user['id']==25202){ 
		//file_put_contents("curlUrl.txt","curlUrl:::::\r\n".$curlUrl,FILE_APPEND); 
	}
	if($user['id']==33579){ 
		//file_put_contents("testurl.txt","SALES API URL :::::".$curlUrl."\r\n",FILE_APPEND); 
	} 
	//echo $curlUrl;exit;
	curl_setopt_array($curl, array(
		CURLOPT_URL => $curlUrl,
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => "",
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 30,
		CURLOPT_HEADER => 1,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_2TLS,
		CURLOPT_HTTPPROXYTUNNEL => 1,  
		CURLOPT_PROXY => "$proxyIp",
		CURLOPT_PROXYPORT => "$proxyPort",
		CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
		CURLOPT_CUSTOMREQUEST => "GET",
		CURLOPT_HTTPHEADER => array( 
			"cookie: $cookie",
			"csrf-token: $csrf",
			"x-http-method-override: GET",
			"Host: www.linkedin.com",
			"User-Agent: $userAgent",
			"Accept-Language: en-US,en;q=0.5",
			"Accept-Encoding: gzip, deflate, br",
			"content-type: application/x-www-form-urlencoded",
			"x-li-lang: en_US",
			 "x-restli-protocol-version: 2.0.0",
			"Origin: https://www.linkedin.com"
		)
	));
}else{
	$curlUrl = "https://www.linkedin.com/sales-api/salesApiLeadSearch";
	if($user['id']==33579){ 
		//file_put_contents("testurl.txt","SALES API URL :::::".$postdata."\r\n",FILE_APPEND);
	}
	curl_setopt_array($curl, array(
		CURLOPT_URL => $curlUrl,
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => "",
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 30,
		CURLOPT_HEADER => 1,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_2TLS,
		CURLOPT_HTTPPROXYTUNNEL => 1,
		CURLOPT_PROXY => "$proxyIp",
		CURLOPT_PROXYPORT => "$proxyPort",
		CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
		CURLOPT_CUSTOMREQUEST => "POST",
		CURLOPT_POSTFIELDS => $postdata,
		CURLOPT_HTTPHEADER => array(  
			"Host: www.linkedin.com",
			"User-Agent: $userAgent",
			"Accept: */*",
			"Accept-Language: en-US,en;q=0.5",
			"Accept-Encoding: gzip, deflate, br",
			"Content-Type: application/x-www-form-urlencoded",
			"X-LI-Lang: en_US",
			"X-RestLi-Protocol-Version: 2.0.0",
			"Csrf-Token: $csrf",
			"X-HTTP-Method-Override: GET",  
			"X-Requested-With: XMLHttpRequest",
			"Content-Length: $length",
			"Origin: https://www.linkedin.com",
			"Referer: https://www.linkedin.com/sales/search/people",
			"Cookie: $cookie"
		)
	));
}
$res = curl_exec($curl);
print_r($res);exit; 
$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
$headers = substr($res, 0, $header_size);
$res = substr($res, $header_size); 
$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
exit;