<?php
header("Access-Control-Allow-Origin:*");
header("Access-Control-Allow-Credentials:true");
header("Access-Control-Allow-Methods: OPTIONS, GET, POST");
header("Access-Control-Allow-Headers: Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
include('config.php'); 
include('common_functions.php'); 

//Ankit + Trupal
function checkResponse($timestamp, $userId, $csrf, $cookie, $proxyIp, $proxyPort, $proxyUsername, $proxyPassword, $teamid, $hubspotApiKey, $hubspotId, $hubspotOwnerId, $hubspotStatus, $source, $createdAt=0){
	include('config.php'); 
	ini_set('max_execution_time', '0');
	$toStore = '';
	$curl = curl_init();
	
	if($createdAt>0){
		$linkUrl = "https://www.linkedin.com/voyager/api/messaging/conversations?createdBefore\x3d".$createdAt;
	}else{
		$linkUrl = "https://www.linkedin.com/voyager/api/messaging/conversations?createdAfter\x3d".$timestamp;
	}

	curl_setopt_array($curl, array(
	CURLOPT_URL => $linkUrl,
	CURLOPT_RETURNTRANSFER => true,
	CURLINFO_HEADER_OUT=>true,
	CURLOPT_ENCODING => "",
	CURLOPT_MAXREDIRS => 10,
	CURLOPT_TIMEOUT => 30,
	CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	CURLOPT_HTTPPROXYTUNNEL => 1,
	CURLOPT_PROXY => "$proxyIp",
	CURLOPT_PROXYPORT => "$proxyPort",
	CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
	CURLOPT_CUSTOMREQUEST => "GET",
	CURLOPT_HTTPHEADER => array(
		"cookie: $cookie",
		"csrf-token: $csrf",
		"x-restli-protocol-version: 2.0.0",
		"User-Agent: Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36",
		"Accept-Language: en-US,en;q=0.9",
		"x-li-lang: en_US",
		"Accept-Encoding: gzip, deflate, br",
		"TE: Trailers",
		"Host: www.linkedin.com",
		"Origin: https://www.linkedin.com"
		)
	));
	$res = curl_exec($curl);//print_r($res);
	if (curl_errno($curl)) {
		$error_msg = curl_error($curl);
		//echo 'Curl Error: '.$error_msg;
		addLogHistory($error_msg, 0, $userId, 1);
		curl_close($curl);
	}else{
		$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		if($http_code == 200){
			curl_close($curl);
			//echo '<pre>';
			$conversationJsonResponse=json_decode(mb_convert_encoding($res, 'UTF-8', 'UTF-8'));
			//print_r(json_decode(mb_convert_encoding($res, 'UTF-8', 'UTF-8')));exit;
			//echo '<br>Json decoded response check';
			if(!empty($conversationJsonResponse->elements)){
				//echo '<br>Json decoded response OK';
				$total_elements=count($conversationJsonResponse->elements);
				//echo '<br>Total elements: '.$total_elements;
				//echo '<br>First response element createdAt: '.$conversationJsonResponse->elements[0]->events[0]->createdAt .'<br>Timestamp: '.$timestamp;
				//if(1==2){
				if($conversationJsonResponse->elements[0]->events[0]->createdAt != $timestamp){
					$i = 0;
					foreach($conversationJsonResponse->elements as $element){
						//echo '<br>In for '.$i.'<pre>';
						//print_r('personId: '. explode(':', $prtcpnt['com.linkedin.voyager.messaging.MessagingMember']->miniProfile->objectUrn)[3]);
						//print_r($element->participants[0]);
						if(!empty($element->participants[0])){
							$prtcpnt = (array)$element->participants[0];
							//print_r($prtcpnt);
							//echo '<br>In string if';
							//print_r(explode(':', $prtcpnt['com.linkedin.voyager.messaging.MessagingMember']->miniProfile->objectUrn)[3]);
							//$particpnt = (array)$element->receipts[0]->fromParticipant;
							//$personIdToCheck = explode(':', $particpnt['string'])[3];
							$personIdToCheck = explode(':', $prtcpnt['com.linkedin.voyager.messaging.MessagingMember']->miniProfile->objectUrn)[3];
							$activeTaskQry="SELECT * FROM `completed_tasks` task, `ext_sequences` seq WHERE task.personId = '".$personIdToCheck."' AND seq.id = task.seqId AND (seq.status = 'Active' OR seq.status = 'Paused') AND seq.user_id = ".$userId;
							$activeTasks=mysqli_query($con,$activeTaskQry);
							if(mysqli_num_rows($activeTasks) > 0){
								//echo '<br>Person Id: '.$personIdToCheck;
								/* if($createdAt>0){
									$tmstmp = $createdAt;
								}else{
									$tmstmp = $timestamp;
								} */
								
								$details=explode(':',$element->entityUrn);
								$entityUrn=$details[3];
								
								$curl = curl_init();
								curl_setopt_array($curl, array(
								CURLOPT_URL => "https://www.linkedin.com/voyager/api/messaging/conversations/".$entityUrn."/events?createdAfter\x3d".$timestamp,
								CURLOPT_RETURNTRANSFER => true,
								CURLOPT_ENCODING => "",
								CURLOPT_MAXREDIRS => 10,
								CURLOPT_TIMEOUT => 30,
								CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
								CURLOPT_HTTPPROXYTUNNEL => 1,
								CURLOPT_PROXY => "$proxyIp",
								CURLOPT_PROXYPORT => "$proxyPort",
								CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
								CURLOPT_CUSTOMREQUEST => "GET",
								CURLOPT_HTTPHEADER => array(
									"cookie: $cookie",
									"csrf-token: $csrf",
									"Host: www.linkedin.com",
									"User-Agent: Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36",
									"Accept-Language: en-US,en;q=0.5",
									"Accept-Encoding: gzip, deflate, br",
									"x-li-lang: en_US",
									"x-restli-protocol-version: 2.0.0",
									"Origin: https://www.linkedin.com",
									"TE: Trailers"
									)
								));
								$res = curl_exec($curl);
								$thread = array();
								if (curl_errno($curl)) {
										$error_msg = curl_error($curl);
										addLogHistory($error_msg, 0, $userId, 1);
								}else{
									//echo '<br>In else part for';
									if(!empty($res)){
										//echo '<br>Response not empty';
										$json_response=json_decode(mb_convert_encoding($res, 'UTF-8', 'UTF-8'));
										if(!empty($json_response->elements)){
											//echo '<br>Json OK';
											//$total_elements=count($json_response->elements);
											foreach($json_response->elements as $ele){
												//echo "<br>Here 1";
												$createdAt= $ele->createdAt;
												$entDgts=explode(':',$ele->entityUrn);
												$entUrnWithChar=explode(',',trim($entDgts[3],'()'));
												$entUrnType = trim(substr($entUrnWithChar[1],0,1));
												$entUrnDigit=$entUrnWithChar[0];
												$subType=$ele->subtype;
												
												$details=array();
												$details['createdAt']=$createdAt;
												$details['type']=$entUrnType;
				
												if($entUrnType=='I'){
													//echo "<br>Here 2 In I";
													$miniProfile= $ele->from;
													$miniProfile=(array)$miniProfile;
													$miniProfile=$miniProfile['com.linkedin.voyager.messaging.MessagingMember']->miniProfile;
													if(!empty($miniProfile->objectUrn) && !empty($miniProfile->entityUrn)){
														//echo "<br>Here 3 In I mini profile found";
														$objUrnArr=explode(':',$miniProfile->objectUrn);
														$objUrn = $objUrnArr[3];
														$entUrnArr=explode(':',$miniProfile->entityUrn);
														$entUrn = $entUrnArr[3];

														if($subType == 'MEMBER_TO_MEMBER'){
															//echo "<br>Here 4 In I subtype 'MEMBER_TO_MEMBER'";
															//$getBlaclistRecord=mysqli_query($con,"SELECT * from ext_blacklist where liId='".$objUrn."' and userId = '".$userId."' limit 1");
															//if(mysqli_num_rows($getBlaclistRecord) > 0){
																//addLogHistory('Received response from '.$miniProfile->firstName .' '.$miniProfile->lastName ,0, $userId);
															//}else{
																/* $msg = makeLink("https://www.linkedin.com/messaging/thread/".$entUrnDigit,$miniProfile->firstName .' '.$miniProfile->lastName . ' Added to blcklist.');
																addLogHistory('Received response from ' . $msg, 0, $userId);
																
																$timeStamp= round(microtime(true) * 1000);
																$profileId="https://www.linkedin.com/profile/view?id\x3d".$entUrn;
																echo $addInToBlacklist="Insert Into ext_blacklist(liId,liProfileId,firstName,lastName,threadId,profileLink,timestamp,seqId, userId) values('".$objUrn."','".$entUrn."','".$miniProfile->firstName."','".$miniProfile->lastName."','".$entUrnDigit."','".$profileId."','".$timeStamp."',0,'".$userId."')";
																$qryExcute=mysqli_query($con,$addInToBlacklist);
																$blacklistId=mysqli_insert_id($con); */
																//$blacklistId=73;
																
																//$taskQuery="select * from ext_tasks where personId='".$objUrn."' limit 1";
																$taskQuery="select * from completed_tasks where personId='".$objUrn."' AND userId = '".$userId."' ORDER BY id DESC limit 1";
																$taskData=mysqli_query($con,$taskQuery);
																if(mysqli_num_rows($taskData) > 0){
																	//echo "<br>Here 5 In I tasks";
																	$task=mysqli_fetch_array($taskData);
																	$taskSeqId = $task['seqId'];
																	/* echo "UPDATE ext_blacklist SET seqId='".$taskSeqId."' where id='".$blacklistId."'  and userId = '".$userId."'";
																	$updateBlacklist=mysqli_query($con,"UPDATE ext_blacklist SET seqId='".$taskSeqId."' where id='".$blacklistId."'  and userId = '".$userId."'");
																	$qryExcute=mysqli_query($con,$updateBlacklist); */
																	
																	
																	$msgDetails=array();
																	$msgBody='';
																	$eventContent=(array)$ele->eventContent;
																	if(!empty($eventContent['com.linkedin.voyager.messaging.event.MessageEvent']->body)){
																		$msgBody=nl2br($eventContent['com.linkedin.voyager.messaging.event.MessageEvent']->body);
																	}
																	if(empty($msgBody)){
																		$msgBody=nl2br(str_replace('"','',$eventContent['com.linkedin.voyager.messaging.event.MessageEvent']->attributedBody->text));
																	}
																	array_push($msgDetails,$msgBody);
																	$msgType=$subType;
																	$msgBody = htmlspecialchars($msgBody);
																	$details['msg']=$msgBody;
																	
																	if(!empty($taskSeqId)){
																		//echo "<br>Here 6 In I Sequence";
																		//echo '<br>Sequence Id: '.$taskSeqId;
																		$seqQry="select * from ext_sequences where id='".$taskSeqId."' limit 1";
																		$sequence=mysqli_query($con,$seqQry);
																		//echo '<br>Sequence Count: ' . mysqli_num_rows($sequence);
																		if(mysqli_num_rows($sequence) > 0){
																			//echo "<br>Here 7 In I Sequence found";
																			$respArr = array();
																			$profileArr = array();
																			$respObj = array();
																			if(!empty($miniProfile->picture)){
																				$picture = (array)$miniProfile->picture;
																				$artifacts = $picture['com.linkedin.common.VectorImage']->artifacts;
																				$artifactsArr = array();
																				if(!empty($artifacts)){
																					foreach($artifacts as $artifact){
																						array_push($artifactsArr,(array)$artifact);
																					}
																				}
																				if(!empty($picture['com.linkedin.common.VectorImage']->rootUrl)){
																					$picture = array('com.linkedin.common.VectorImage' => array('artifacts' => $artifactsArr, 'rootUrl' => $picture['com.linkedin.common.VectorImage']->rootUrl));
																				}
																			}
																			
																			$sequences=mysqli_fetch_array($sequence);
																			$msgDetailsArray=(array)$miniProfile;
																			$msgDetailsArray['seq_id'] = $taskSeqId;
																			if(!empty($picture)){$msgDetailsArray['picture'] = $picture;}else{$msgDetailsArray['picture'] = array();}
																			$msgDetailsArray['seq_name'] = $sequences['name'];
																			$msgDetailsArray['seq_type'] = $sequences['msgSeq'];
																			$msgDetailsArray['status'] = $sequences['status'];
																			$msgDetailsArray['responsestatus'] = true;
																			$linkedinPublicId = $msgDetailsArray['publicIdentifier'];
																			$msgDetailsArray['subtype']= $msgType;
																			if(strpos($sequences['zaptouse'],"Response") > 0){
																				$msgDetailsArray['responsestatus'] =true; 
																			}
																			$msgDetailsArray['person_id'] = $objUrn;
																			$msgDetailsArray['zapirestatus'] = $sequences['zapireStatus'];
																			$msgDetailsArray['msg'] = $msgDetails;
																			
																			$taskQuery="select * from completed_tasks where personId='".$objUrn."' AND seqId = '".$taskSeqId."' AND userId = '".$userId."' ORDER BY id DESC limit 1";
																			$task=mysqli_query($con,$taskQuery);
																			//echo '<br>Task Count: ' . mysqli_num_rows($task);
																			if(mysqli_num_rows($task) > 0){
																				//echo "<br>Here 8 In I task found";
																				$task=mysqli_fetch_array($task);
																				$personEmail = '';
																				
																				$personJsonTask = preg_replace('/\"description\"\:\".*?\"\,/s', '"description":"empty",',$task['person']);
																				$pubId = json_decode(mb_convert_encoding($personJsonTask, 'UTF-8', 'UTF-8'))->longId;
																				
																				$currentCompany='';
																				
																				$curl = curl_init();
																				curl_setopt_array($curl, array(
																				CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/".$linkedinPublicId."/profileView",
																				CURLOPT_RETURNTRANSFER => true,
																				CURLOPT_ENCODING => "",
																				CURLOPT_MAXREDIRS => 10,
																				CURLOPT_TIMEOUT => 30,
																				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
																				CURLOPT_HTTPPROXYTUNNEL => 1,
																				CURLOPT_PROXY => "$proxyIp",
																				CURLOPT_PROXYPORT => "$proxyPort",
																				CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
																				CURLOPT_CUSTOMREQUEST => "GET",
																				CURLOPT_HTTPHEADER => array(
																					"cookie: $cookie",
																					"csrf-token: $csrf",
																					"Host: www.linkedin.com",
																					"User-Agent: Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36",
																					"Accept-Language: en-US,en;q=0.5",
																					"Accept-Encoding: gzip, deflate, br",
																					"x-li-lang: en_US",
																					"x-restli-protocol-version: 2.0.0",
																					"Origin: https://www.linkedin.com",
																					"TE: Trailers"
																					)
																				));
																				$res = curl_exec($curl);
																				if(curl_errno($curl)) {
																					$error_msg = curl_error($curl);
																					addLogHistory($error_msg, 0, $userId, 1);
																				}else{
																					if(!empty($res)){
																						$companyRes=json_decode($res);
																						if(!empty(trim($companyRes->positionView->elements[0]->companyName))){
																							$currentCompany=$companyRes->positionView->elements[0]->companyName;
																						}else{
																							$currentCompany=='';
																						}
																					}
																				}
																				curl_close($curl);

																				$curl = curl_init();
																				curl_setopt_array($curl, array(
																				CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $pubId . "/profileContactInfo",
																				CURLOPT_RETURNTRANSFER => true,
																				CURLOPT_ENCODING => "",
																				CURLOPT_MAXREDIRS => 10,
																				CURLOPT_TIMEOUT => 30,
																				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
																				CURLOPT_HTTPPROXYTUNNEL => 1,
																				CURLOPT_PROXY => "$proxyIp",
																				CURLOPT_PROXYPORT => "$proxyPort",
																				CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
																				CURLOPT_CUSTOMREQUEST => "GET",
																				CURLOPT_HTTPHEADER => array(
																					"cookie: $cookie",
																					"csrf-token: $csrf",
																					"Host: www.linkedin.com",
																					"User-Agent: Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36",
																					"Accept-Language: en-US,en;q=0.5",
																					"Accept-Encoding: gzip, deflate, br",
																					"x-li-lang: en_US",
																					"x-restli-protocol-version: 2.0.0",
																					"Origin: https://www.linkedin.com",
																					"TE: Trailers"
																					)
																				));
																				$res = curl_exec($curl);
																				if(curl_errno($curl)) {
																					$error_msg = curl_error($curl);
																					addLogHistory($error_msg, 0, $userId, 1);
																				}else{
																					//echo "<br>Here 9 In I res";
																					if(!empty($res)){
																						//echo "<br>Here 10 In I res found";
																						$profileContactInfoRes=json_decode($res);
																						(!empty($profileContactInfoRes->emailAddress))?$personEmail .= $profileContactInfoRes->emailAddress:$personEmail='';			  
																						$msgDetailsArray['person_email'] = $personEmail;
																						array_push($respArr,$objUrn);
																						$msgDetailsArray['li_ids'] = $respArr;
																						$respObj['profiledata']=$msgDetailsArray;
																						$respObj['profile_arr_status']=$msgDetailsArray['zapirestatus'];
																						$msgDetailsArray['currentCompany']= $currentCompany;
																						$msgDetailsArray['sessionId']= base64_encode ($userId.'/'.$teamid);
																						$msgDetailsArray = http_build_query($msgDetailsArray);
																						//print_r($msgDetailsArray);
																						$curl = curl_init();
																						curl_setopt_array($curl, array(
																						CURLOPT_URL => API_ADDRESS."/Response_zapier_22nov2019.php",
																						CURLOPT_POSTFIELDS => $msgDetailsArray
																						));
																						$res = curl_exec($curl);
																						//print_r($res);
																						$err = curl_error($curl);
																						curl_close($curl);
																						
																					}
																				}
																				//curl_close($curl);
																			}
																		}
																	}
																}else{
																	//echo "In update blcklist";
																	/* $updateBlacklist=mysqli_query($con,"UPDATE ext_blacklist SET seqId='0' where id='".$blacklistId."'");
																	$qryExcute=mysqli_query($con,$updateBlacklist); */
																}
															//}
														}elseif($subType == 'INVITATION_ACCEPT'){
															//echo 'In invitation accept';
															/* addLogHistory('Invitation accpeted by '.$miniProfile->firstName .' '.$miniProfile->lastName ,0, $userId);
															onInvitationAccepted($objUrn, $createdAt, $cookie ,$csrf ,$userId, $teamid, $hubspotApiKey, $hubspotId, $hubspotOwnerId, $hubspotStatus, $proxyIp, $proxyPort, $proxyUsername, $proxyPassword); */
														}
													}
												}elseif($entUrnType=='S'){
													//echo "<br>Here 2 In S";
													if(!empty($ele->eventContent)){
														$msgBody='';
														$eventContent=(array)$ele->eventContent;
														if(!empty($eventContent['com.linkedin.voyager.messaging.event.MessageEvent']->body)){
															$msgBody=nl2br($eventContent['com.linkedin.voyager.messaging.event.MessageEvent']->body);
														}
														if(empty($msgBody)){
															$msgBody=nl2br(str_replace('"','',$eventContent['com.linkedin.voyager.messaging.event.MessageEvent']->attributedBody->text));
														}
														$msgBody = htmlspecialchars($msgBody);
														$details['msg']=$msgBody;
													}
													$curl = curl_init();
													curl_setopt_array($curl, array(
													CURLOPT_URL => "https://www.linkedin.com/voyager/api/messaging/conversations/".$entUrnDigit,
													CURLOPT_RETURNTRANSFER => true,
													CURLOPT_ENCODING => "",
													CURLOPT_MAXREDIRS => 10,
													CURLOPT_TIMEOUT => 30,
													CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
													CURLOPT_HTTPPROXYTUNNEL => 1,
													CURLOPT_PROXY => "$proxyIp",
													CURLOPT_PROXYPORT => "$proxyPort",
													CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
													CURLOPT_CUSTOMREQUEST => "GET",
													CURLOPT_HTTPHEADER => array(
														"cookie: $cookie",
														"csrf-token: $csrf",
														"Host: www.linkedin.com",
														"User-Agent: Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36",
														"Accept-Language: en-US,en;q=0.5",
														"Accept-Encoding: gzip, deflate, br",
														"x-li-lang: en_US",
														"x-restli-protocol-version: 2.0.0",
														"Origin: https://www.linkedin.com",
														"TE: Trailers"
														)
													));
													$convRes = curl_exec($curl);
													if(curl_errno($curl)) {
														$error_msg = curl_error($curl);
														addLogHistory($error_msg, 0, $userId, 1);
													}else{
														$miniProfile=json_decode($convRes)->participants[0];
														$miniProfile=(array)$miniProfile;
														$miniProfile=$miniProfile['com.linkedin.voyager.messaging.MessagingMember']->miniProfile;
														
														if(!empty($miniProfile->objectUrn) && !empty($miniProfile->entityUrn)){
															
															$objUrnArr=explode(':',$miniProfile->objectUrn);
															$objUrn = $objUrnArr[3];
															$entUrnArr=explode(':',$miniProfile->entityUrn);
															$entUrn = $entUrnArr[3];
															
															$totalEventCount=json_decode($convRes)->totalEventCount;
															if($totalEventCount <= 2){
																$getTotalEventCount="SELECT * FROM completed_tasks  WHERE personId='".trim($objUrn)."' AND status ='Complete' AND type='Connect' LIMIT 1";
																$extTasks=mysqli_query($con,$getTotalEventCount);
																$extTasksData=mysqli_fetch_array($extTasks);
																if(!empty($extTasksData)){
																	addLogHistory('Invitation accpeted by ' . $entUrn.'(' . $objUrn . ', ' . $miniProfile->firstName . ' ' . $miniProfile->lastName . ')' ,0, $userId);
																	onInvitationAccepted(trim($objUrn), $createdAt, $cookie, $csrf, $userId, $teamid, $hubspotApiKey, $hubspotId, $hubspotOwnerId, $hubspotStatus, $proxyIp, $proxyPort, $proxyUsername, $proxyPassword);
																}
															}else{
																$getTotalEventCount="SELECT * FROM completed_tasks WHERE personId='".trim($objUrn)."'";
																$extTasks=mysqli_query($con,$getTotalEventCount);
																if(mysqli_num_rows($extTasks) <= 2){
																	addLogHistory('Invitation accpeted by ' . $entUrn.'(' . $objUrn . ', ' . $miniProfile->firstName . ' ' . $miniProfile->lastName . ')' ,0, $userId);
																	onInvitationAccepted(trim($objUrn), $createdAt, $cookie, $csrf, $userId, $teamid, $hubspotApiKey, $hubspotId, $hubspotOwnerId, $hubspotStatus, $proxyIp, $proxyPort, $proxyUsername, $proxyPassword);
																}
															}
														}
													}
													curl_close($curl);
												}
												if(!empty($details)){
													$thread[]=$details;
												}
											}
											
											/***************************************Store last 20 active sequence conversation to db**************************************/
											$msgCnt = count($thread);
											$threadDetails=mysqli_real_escape_string($con, json_encode($thread));
											$getConversationQry=mysqli_query($con,"SELECT thread from conversations where threadId='".$entityUrn."' and userId = '".$userId."'");
											if(mysqli_num_rows($getConversationQry) > 0){
												if($msgCnt == 20){
													$conversationInsert = mysqli_query($con,"UPDATE conversations SET thread = '".$threadDetails."' WHERE threadId = '".$entityUrn."' AND userId = '".$userId."'");
												}else{
													$conversationRes = mysqli_fetch_assoc($getConversationQry);
													$dbConvrstn = json_decode(mb_convert_encoding($conversationRes['thread'], 'HTML-ENTITIES', 'HTML-ENTITIES'));
													$i=0;
													foreach($dbConvrstn as $tmp){
														if($tmp->createdAt > $timestamp){
															unset($dbConvrstn[$i]);
														}else{
															$dbConvrstn[$i]->msg = htmlspecialchars($tmp->msg);
														}
														$i++;
													}
													$dbConvrstnCnt = count($dbConvrstn);
													$allEle = 20 - $msgCnt;
													$rmEle = $dbConvrstnCnt - $allEle;
													if($rmEle > 0){
														$tmpArr = array_slice($dbConvrstn, $rmEle);
													}else{
														$tmpArr = array_slice($dbConvrstn, 0);
													}
													foreach($thread as $arr){
														array_push($tmpArr, $arr);
													}
													$threadDetails=mysqli_real_escape_string($con, json_encode($tmpArr));
													$conversationInsert = mysqli_query($con,"UPDATE conversations SET thread = '".$threadDetails."' WHERE threadId = '".$entityUrn."' AND userId = '".$userId."'");
												}
											}else{
												$conversationInsert = mysqli_query($con,"INSERT INTO conversations (personId,threadId,thread,userId) values('".$personIdToCheck."','".$entityUrn."','".$threadDetails."','".$userId."')");
											}
											/***************************************Store last 20 active sequence conversation to db**************************************/
											
											$participant = (array)$element->participants[0];
											echo 'Before log messages participant';
											if(!empty($participant)){
												echo 'Before log messages in participant';
												$participantMiniProfile = $participant['com.linkedin.voyager.messaging.MessagingMember']->miniProfile;
												if(!empty($participantMiniProfile)){
													$participantObjUrn=explode(':',$participantMiniProfile->objectUrn);
													$participantMiniProfileArray = array();
													$participantMiniProfileArray['firstName'] = $participantMiniProfile->firstName;
													$participantMiniProfileArray['lastName'] = $participantMiniProfile->lastName;
													$participantMiniProfileArray['id'] = $participantObjUrn[3];
													$participantMiniProfileArray['fullName'] = $participantMiniProfile->firstName . ' ' . $participantMiniProfile->lastName;
													$participantMiniProfileJson = json_encode($participantMiniProfileArray);
													
													$conversationDetails = array();
													$p = array();
													$elemns = (array)$json_response->elements;
													for ($e = 0; $e < count($elemns); $e++){
														$f = (array)$elemns[$e];
														if("MEMBER_TO_MEMBER" == $f['subtype']){
															$conversation = array();
															(preg_match('/fs_event:\(\d+,([SI].+)\)/', $f['entityUrn'], $matche)) ? $conversation['id'] = $matche[1] : $conversation['id'] = '';
															$conversation['timestamp'] = $f['createdAt'];
															$messageBody = (array)$f['eventContent'];
															$messageBody = $messageBody["com.linkedin.voyager.messaging.event.MessageEvent"]->body;
															if (empty($messageBody)){
																$messageBody = (array)$f['eventContent'];
																$messageBody = str_replace('"','',$messageBody["com.linkedin.voyager.messaging.event.MessageEvent"]->attributedBody->text);
															}
															if(!empty($f['from']) && !empty($f['eventContent'])){
																$from = (array)$f['from'];
																$miniProf = $from['com.linkedin.voyager.messaging.MessagingMember']->miniProfile;
																$eventContent = (array)$f['eventContent'];
																$eventContent = $eventContent['com.linkedin.voyager.messaging.event.MessageEvent'];
																if(!empty($miniProf) && !empty($eventContent)){
																	$conversation['text'] = $miniProf->firstName . ' ' . $miniProf->lastName . ' said:\n' . $messageBody;
																}
															}
															array_push($conversationDetails, $conversation);
														}
													}
													echo 'Before log messages';
													logMessages($participantMiniProfileJson, $conversationDetails, $cookie, $csrf, $hubspotApiKey, $hubspotId, $userId);
												}
											}
										}
									}
								}
							}
						}
						if($i == 0 && $source == 0){
							$toStore = $element->events[0]->createdAt;
							//echo '<br>In if part: '.$toStore;
						}
						$i++;
					}
				}else{
					//echo '<br>In else part: '.$timestamp;
					$total_elements = 0;
					$toStore = $timestamp;
				}
				//}
				/* if($conversationJsonResponse->elements[0]->events[0]->createdAt != $timestamp){
					foreach($conversationJsonResponse->elements as $element){
						if(isset($element->participants[0])){
							$prtcpnt = (array)$element->participants[0];
							$personIdToCheck = explode(':', $prtcpnt['com.linkedin.voyager.messaging.MessagingMember']->miniProfile->objectUrn)[3];
							$activeTaskQry="SELECT * FROM `ext_tasks` task, `ext_sequences` seq WHERE task.personId = '".$personIdToCheck."' AND seq.id = task.seqId AND seq.status = 'Active' AND task.step != 0";
							$activeTasks=mysqli_query($con,$activeTaskQry);
							if(mysqli_num_rows($activeTasks) > 0){
								$event = $element->events;
								$eventContent = (array)$event[0]->eventContent;
								if(!empty($eventContent['com.linkedin.voyager.messaging.event.MessageEvent']->body)){
									$msg = $eventContent['com.linkedin.voyager.messaging.event.MessageEvent']->body;
								}else{
									if(!empty($eventContent['com.linkedin.voyager.messaging.event.MessageEvent']->attributedBody->text)){
										$msg = $eventContent['com.linkedin.voyager.messaging.event.MessageEvent']->attributedBody->text;
									}else{
										$msg = '';
									}
								}
								echo '<br>'. $event[0]->createdAt .': '.$msg;
							}
						}
					}
				} */
				
				//echo '<br>Total Elements: '.$total_elements.' | Created At: '.$createdAt.' | Timestamp:'.$timestamp;
				if($total_elements >= 20 && ($createdAt > $timestamp || $createdAt == 0)){
					//echo '=================================================================================<br>';
					$lastElement = (array)$conversationJsonResponse->elements;
					$lastElementEvent = end($lastElement)->events;
					$createdAt = $lastElementEvent[0]->createdAt;
					checkResponse($timestamp, $userId, $csrf, $cookie, $proxyIp, $proxyPort, $proxyUsername, $proxyPassword, $teamid, $hubspotApiKey, $hubspotId, $hubspotOwnerId, $hubspotStatus, 1, $createdAt);
				}
			}else{
				//echo '<br>Response blank: '.$timestamp;
				$toStore = $timestamp;
			}
		}else{
			$request=json_encode(curl_getinfo($curl));
			errorHandling($userId, $http_code,$request);
			$toStore = $timestamp;
		}
	}
	//echo '<br>To Store: '. $toStore;
	return $toStore;
}

 

//Ankit + Trupal
function onInvitationAccepted($objUrn, $createdAt, $cookie, $csrf, $userId, $teamid, $hubspotApiKey, $hubspotId, $hubspotOwnerId, $hubspotStatus, $proxyIp, $proxyPort, $proxyUsername, $proxyPassword){
	//echo '<br>'.'IN onInvitationAccepted';
	include('config.php');    
	$getTotalEventCount="select * from completed_tasks  where personId='".$objUrn."' AND status in ('Complete') LIMIT 1";
	$extTasks=mysqli_query($con,$getTotalEventCount);
	$extTasksData=mysqli_fetch_array($extTasks);
	if(!empty($extTasksData)){
		$personJsonTask = preg_replace('/\"description\"\:\".*?\"\,/s', '"description":"empty",',$extTasksData['person']);
	    $SeqId = $extTasksData['seqId'];		
		if(empty(json_decode(mb_convert_encoding($personJsonTask, 'UTF-8', 'UTF-8'))->profileLink)){
			$pubId = json_decode(mb_convert_encoding($personJsonTask, 'UTF-8', 'UTF-8'))->longId;
		}else{
			if("https://www.linkedin.com/profile/view?id\x3d".$objUrn){
				$pubId="view?id=".$objUrn;
			}
		}
		
		/* Curl for the Contact Details */
		$curl = curl_init();
		curl_setopt_array($curl, array(
		CURLOPT_URL =>   "https://www.linkedin.com/voyager/api/identity/profiles/".$pubId."/profileContactInfo",
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => "",
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 30,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_HTTPPROXYTUNNEL => 1,
		CURLOPT_PROXY => "$proxyIp",
		CURLOPT_PROXYPORT => "$proxyPort",
		CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
		CURLOPT_CUSTOMREQUEST => "GET",
		CURLOPT_HTTPHEADER => array(
			"cookie: $cookie",
			"csrf-token: $csrf",
			"Host: www.linkedin.com",
			"User-Agent: Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36",
			"Accept-Language: en-US,en;q=0.5",
			"Accept-Encoding: gzip, deflate, br",
			"x-li-lang: en_US",
			"Origin: https://www.linkedin.com",
			"TE: Trailers"
			)
		));
		$convRes = curl_exec($curl);
		if(curl_errno($curl)) {
			$error_msg = curl_error($curl);
			addLogHistory($error_msg, 0, $userId, 1);
		}else{
			if(!empty($convRes)){			
				//$integration_settings=mysqli_query($con,"select access_key from intigration where user_id='".$userId."' LIMIT 1");	
				//$getJson=mysqli_fetch_assoc($integration_settings);	
				//$integration_data=json_encode($getJson);
				/* Hubspot contact created */
				$firstName = json_decode(mb_convert_encoding($personJsonTask, 'UTF-8', 'UTF-8'))->firstName;
				$lastName = json_decode(mb_convert_encoding($personJsonTask, 'UTF-8', 'UTF-8'))->lastName;
				$respArr=array();
				$profileContactInfoRes=base64_encode($convRes);
				array_push($respArr,$objUrn);
				$msgDetailsArray['person_id'] = $objUrn;
				$msgDetailsArray['profileContactInfo']=$convRes;
				$msgDetailsArray['profilefnamehub']=$firstName;
				$msgDetailsArray['profilelnamehub']= $lastName;
				if($hubspotStatus){$hubspotSts = 'on';}else{$hubspotSts = 'off';}
				$msgDetailsArray['hubspot_auto']= $hubspotSts;
				$msgDetailsArray['hsApiKey']= $hubspotApiKey;
				$msgDetailsArray['hsPortalId']= $hubspotId;
				$msgDetailsArray['hubspot_owner_id']= $hubspotOwnerId;
				$msgDetailsArray['sessionId']= base64_encode ($userId.'/'.$teamid);
				$msgDetailsArray = http_build_query($msgDetailsArray);
				$curl = curl_init();
				curl_setopt_array($curl, array(
				CURLOPT_URL => API_ADDRESS."/onAcceptanceBlacklistHubspot.php",
				CURLOPT_POSTFIELDS => $msgDetailsArray
				));
				$res = curl_exec($curl);
				$err = curl_error($curl);		
			}
		}
        curl_close($curl);
	}
	
	/* Zapier Start */	
	//Need to confirm with Status Not Started Or complete	
	$getExtTasks="SELECT * FROM  ext_tasks  WHERE personId='".$objUrn."' AND status in ('Not Started') AND triggerOnInvitationAccepted='1' AND triggered='false' AND  0 < seqId  LIMIT 1";
	$extTasks=mysqli_query($con,$getExtTasks);
	if(mysqli_num_rows($extTasks) > 0){
		while($getTaskDetails=mysqli_fetch_assoc($extTasks)){
			$noSteps=$getTaskDetails['step']-1;
			$selectSteps="SELECT * FROM ext_steps WHERE seqId='".$getTaskDetails['seqId']."' AND `order`='".$noSteps."' ORDER BY `order` ASC ";
			$selectStepsData=mysqli_query($con,$selectSteps);
			$stepsDetails=mysqli_fetch_assoc($selectStepsData);			 
			if(!empty($stepsDetails)){
				$personJson = preg_replace('/\"description\"\:\".*?\"\,/s', '"description":"empty",',$getTaskDetails['person']);
				addLogHistory('Triggering. #'.$getTaskDetails['id'] ,0, $userId);
				$datetime=round(microtime(true) * 1000+(86400000* $stepsDetails['delayDays'])+($stepsDetails['delayMinutes']*60000));	
				//Need to confirm triggered is true or false
				if(empty(json_decode(mb_convert_encoding($personJson, 'UTF-8', 'UTF-8'))->profileLink)){
					$pubId = json_decode(mb_convert_encoding($personJson, 'UTF-8', 'UTF-8'))->longId;
				}else{
					if("https://www.linkedin.com/profile/view?id\x3d".$objUrn){
						$pubId="view?id=".$objUrn;
					}
				}
				$curl = curl_init();
				curl_setopt_array($curl, array(
				CURLOPT_URL =>   "https://www.linkedin.com/voyager/api/identity/profiles/".$pubId."/profileContactInfo",
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 30,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_HTTPPROXYTUNNEL => 1,
				CURLOPT_PROXY => "$proxyIp",
				CURLOPT_PROXYPORT => "$proxyPort",
				CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
				CURLOPT_CUSTOMREQUEST => "GET",
				CURLOPT_HTTPHEADER => array(
					"cookie: $cookie",
					"csrf-token: $csrf",
					"Host: www.linkedin.com",
					"User-Agent: Mozilla/5.0 (Windows NT 6.1; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36",
					"Accept-Language: en-US,en;q=0.5",
					"Accept-Encoding: gzip, deflate, br",
					"x-li-lang: en_US",
					"x-restli-protocol-version: 2.0.0",
					"Origin: https://www.linkedin.com",
					"TE: Trailers"
					)
				));
				$convResZap = curl_exec($curl);
				if(curl_errno($curl)) {
					$error_msg = curl_error($curl);
					addLogHistory($error_msg, 0, $userId, 1);
				}else{
					//print_r(json_decode($convResZap));die;
					$convResZap=json_decode($convResZap);
					if(!empty($convResZap->emailAddress)){
						$email= $convResZap->emailAddress;
					}else{
						$email='';
					}
					if(!empty($convResZap->phoneNumbers)){
						$phoneNumbers= $convResZap->phoneNumbers;
					}else{
						$phoneNumbers='';
					}	
					
					$seqIdNew=$getTaskDetails['seqId'];
					$getseqname="select * from ext_sequences where id='".$seqIdNew."' LIMIT 1";
					$exQuerySeq=mysqli_query($con,$getseqname);
					$stepsDetails=mysqli_fetch_assoc($exQuerySeq);
					$seq_name=array();
					$seq_name['seq_name'] = $stepsDetails['name'];
					$seq_name['seq_id'] = $seqIdNew;			
					//$personJson= $getTaskDetails['person'];			
					$profiledata=array();			
					/* $articat=json_decode($getTaskDetails['person'])->picture;
					$artifact=(array)$articat; */
					//print_r($artifact['com.linkedin.common.VectorImage']);die;			
					$profiledata=$getTaskDetails;
					$profiledata['person']=json_decode($personJson);
					/* $profiledata['person']['email']= $email;
					$profiledata['person']['phoneNumbers']= $phoneNumbers; */
					
					/* $profiledata['person']['picture']['com_linkedin_common_VectorImage']=(array)$artifact['com.linkedin.common.VectorImage']; *///print_r($profiledata);die;
					/* $personDecodeData=(array)json_decode($personJson);			
					$personDecode['person']=$personDecodeData; */			
					/* Note :  pending -> com_linkedin_common_VectorImage  , Phone , email */			
					$profiledata['seq_name']['name']=$stepsDetails['name'];	
					if(!empty($stepsDetails['name']) && $stepsDetails['zapireStatus']==true && strpos($stepsDetails['zaptouse'],"Accept") > 0){
						$zapData['sessionId']= base64_encode ($userId.'/'.$teamid);
						$zapData['type']='InvitationAccepted';
						$zapData['profiledata']=json_encode($profiledata);
						$curl = curl_init();
						curl_setopt_array($curl, array(
						CURLOPT_URL => API_ADDRESS."/zap.php",
						CURLOPT_POSTFIELDS => $zapData
						));
						$res = curl_exec($curl);
						if(curl_errno($curl)) {
							$error_msg = curl_error($curl);
							addLogHistory($error_msg, 0, $userId, 1);
						}
					}
				}
				curl_close($curl);
			}	
		}	
	}
}

//Ankit + Trupal
function logMessages($participantMiniProfileJson, $conversationDetails, $cookie, $csrf, $hubspotApiKey, $hubspotId, $userId) {
	echo 'In log messages';
    $participant = json_decode($participantMiniProfileJson);
	if(!empty($participant)){
		echo '<br>1';
		if(!empty($participant->fullName) || !empty($participant->email) ){
			echo '<br>2';
			if(!empty($participant->email)){
				echo '<br>3';
				$curl = curl_init();
				curl_setopt_array($curl, array(
				CURLOPT_URL => "https://api.hubapi.com/contacts/v1/contact/email/". $participant->email ."/profile?hapikey\x3d".$hubspotApiKey,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_CUSTOMREQUEST => "GET",
				CURLOPT_HTTPHEADER => array(
					"Content-Type: application/json"
					)
				));
				$res = curl_exec($curl);
				echo '<pre>';
				print_r($res);
				if (curl_error($curl)) {
					$error_msg = curl_error($curl);
					addLogHistory($error_msg, 0, $userId, 1);
				}else{
					$hubshptParticipant = array();
				(!empty($res->contacts[$f]->vid)) ? $hubshptParticipant['vid'] = $res->contacts[$f]->vid : $hubshptParticipant['vid'] = '';
				}
				curl_close($curl);
			}elseif(!empty($participant->fullName)){
				echo '<br>4';
				$curl = curl_init();
				curl_setopt($curl, CURLOPT_URL, "https://api.hubapi.com/contacts/v1/search/query?q\x3d" . urlencode($participant->fullName) . "\x26hapikey\x3d".$hubspotApiKey);
				curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET'); 
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
				
				$res = curl_exec($curl);
				echo '<pre>';
				print_r($res);
				$hubshptParticipant = array();
				
				if (curl_error($curl)) {
					echo '<br>5';
					$error_msg = curl_error($curl);
					addLogHistory($error_msg, 0, $userId, 1);
				}else{
					echo '<br>6';
					try{
						echo '<br>7';
						$res = json_decode($res);
						if(1 <= $res->total && count($res->contacts) > 0){
							echo '<br>8';
							for($f = count($res->contacts) - 1; 0 <= $f; $f--){
								(!empty($res->contacts[$f]->vid)) ? $hubshptParticipant['vid'] = $res->contacts[$f]->vid : $hubshptParticipant['vid'] = '';
								break;
							}
							if(empty($hubshptParticipant['vid'])){
								echo '<br>9';
								$b['error'] = "More than one contacts found on Hubspot with the same name (" . $participant->fullName . ")";
								$b['link'] = "https://app.hubspot.com/sales/".$hubspotId."/contacts/list/view/all/?query\x3d" + urlencode($participant->fullName);
							}
						}else{
							echo '<br>10';
							$b['error'] = 'Cannot find Hubspot contact: ' . $participant->fullName;
							addLogHistory($b['error'], 0, $userId, 1);
						}
					}catch(Exception $e){
						echo '<br>11';
						$b['error'] = 'Cannot find Hubspot contact: ' . $participant->fullName;
						addLogHistory($b['error'], 0, $userId, 1);
					}
				}
				curl_close($curl);
			}
		}
	}
	
	if(!empty($hubshptParticipant['vid'])){
		if(!empty($conversationDetails)){
			foreach($conversationDetails as $conversationDetail){
				$engagement = array('active' => 1, 
				'type' => 'NOTE', 
				'timeStamp' => (!empty($conversationDetail['timestamp']))?$conversationDetail['timestamp']:round(microtime(true) * 1000), 
				'uid' => (!empty($conversationDetail['id']))?$conversationDetail['id'].':'.$hubshptParticipant['vid']:'');
				$associations = array('contactIds' => array($hubshptParticipant['vid']));
				$metadata = array('body' => str_replace('/\n/g','\x3cbr\x3e',(!empty($conversationDetail['text']))?$conversationDetail['text']:''));
				$hubspotConversationStructure = array('engagement'=>$engagement,'associations'=>$associations,'metadata'=>$metadata);
		
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, "https://api.hubapi.com/engagements/v1/engagements?hapikey\x3d".$hubspotApiKey);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST'); 
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
				curl_setopt($ch, CURLOPT_POST, 1);
				curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($hubspotConversationStructure));
				$res = curl_exec($ch);
				if(curl_errno($ch)) {
					$error_msg = curl_error($ch);
					addLogHistory($error_msg, 0, $userId, 1);
				}
				curl_close($ch);
			}
		}
	}
}
?>