<?php
require '../aws_php_sdk/vendor/autoload.php';
use Aws\S3\S3Client;
use Aws\Exception\AwsException;
function getBrowser($useragent) { 
  $u_agent = $useragent;
  $bname = 'Google Chrome';
  $platform = 'windows';
  $version= "116";

  //First get the platform?
  if (preg_match('/linux/i', $u_agent)) {
	$platform = 'linux';
  }elseif (preg_match('/macintosh|mac os x/i', $u_agent)) {
	$platform = 'mac';
  }elseif (preg_match('/windows|win32/i', $u_agent)) {
	$platform = 'windows';
  }

  // Next get the name of the useragent yes seperately and for good reason
  if(preg_match('/MSIE/i',$u_agent) && !preg_match('/Opera/i',$u_agent)){
	$bname = 'Internet Explorer';
	$ub = "MSIE";
  }elseif(preg_match('/Firefox/i',$u_agent)){
	$bname = 'Mozilla Firefox';
	$ub = "Firefox";
  }elseif(preg_match('/OPR/i',$u_agent)){
	$bname = 'Opera';
	$ub = "Opera";
  }elseif(preg_match('/Chrome/i',$u_agent) && !preg_match('/Edge/i',$u_agent)){
	$bname = 'Google Chrome';
	$ub = "Chrome";
  }elseif(preg_match('/Safari/i',$u_agent) && !preg_match('/Edge/i',$u_agent)){
	$bname = 'Apple Safari';
	$ub = "Safari";
  }elseif(preg_match('/Netscape/i',$u_agent)){
	$bname = 'Netscape';
	$ub = "Netscape";
  }elseif(preg_match('/Edge/i',$u_agent)){
	$bname = 'Edge';
	$ub = "Edge";
  }elseif(preg_match('/Trident/i',$u_agent)){
	$bname = 'Internet Explorer';
	$ub = "MSIE";
  }

  // finally get the correct version number
  $known = array('Version', $ub, 'other');
  $pattern = '#(?<browser>' . join('|', $known) .
')[/ ]+(?<version>[0-9.|a-zA-Z.]*)#';
  if (!preg_match_all($pattern, $u_agent, $matches)) {
	// we have no matching number just continue
  }
  // see how many we have
  $i = count($matches['browser']);
  if ($i != 1) {
	//we will have two since we are not using 'other' argument yet
	//see if version is before or after the name
	if (strripos($u_agent,"Version") < strripos($u_agent,$ub)){
		$version= $matches['version'][0];
	}else {
		$version= $matches['version'][1];
	}
  }else {
	$version= $matches['version'][0];
  }

  // check if we have a number
  if ($version==null || $version=="") {$version="?";}

  $ua=array(
	'userAgent' => $u_agent,
	'name'      => $bname,
	'version'   => $version,
	'platform'  => $platform,
	'pattern'    => $pattern
  );
  return array('Sec-Ch-Ua:"'.$ua['name'] .'";v="' . floor($ua['version'])  . '", "Chromium";v="' .floor($ua['version']) . '", "Not?A_Brand";v="24"','Sec-Ch-Ua-Mobile:?0','Sec-Ch-Ua-Platform:"'.$ua['platform'].'"','Sec-Fetch-Dest:empty','Sec-Fetch-Mode:cors','Sec-Fetch-Site:same-origin','Cache-Control:no-cache','Pragma:no-cache');
}
function gthdr($userId,$header,$useragent){
	//if(in_array($userId,array(39362))){ 
		$nwheader=getBrowser($useragent);
		$header=array_merge($header,$nwheader);
	//} 
	return $header;
} 
function postscheduling($user){
	include('config.php');
	$userId = $user['id'];
	$proxyIp = $user['proxyIp'];
	$proxyPort = $user['proxyPort']; 
	$proxyUsername = $user['proxyUsername'];
	$proxyPassword = $user['proxyPassword'];
	$userAgent = $user['userAgent'];
	$cookie =$user['cookie'];
	$csrf =$user['csrf'];  
	$timezone =$user['TimeZone'];
	$publicIdentifier =$user['publicIdentifier'];
	$postData = mysqli_query($con,"SELECT * FROM `post` WHERE userId=".$userId." AND scheduledDateTime IS NOT NULL AND status=0 AND CONVERT_TZ(scheduledDateTime,'".$timezone."','UTC') < now()");  
	if(mysqli_num_rows($postData) > 0){
		while($post=mysqli_fetch_assoc($postData)){
			if($post['visibleToConnectionsOnly']){
				$visibleToConnectionsOnly='true';
			}else{ 
				$visibleToConnectionsOnly='false';
			}
			if($post['mediaType']==1 || strpos($post['fileName'], '.gif')){
				//Image
				$recipes='';
				$mediaCategory='IMAGE';
			}elseif($post['mediaType']==2){
				//Video
				$recipes=',"recipes":["urn:li:digitalmediaRecipe:feedshare-video-captions-thumbnails-ambry"]';
				$mediaCategory='VIDEO';
			}elseif($post['mediaType']==3){
				//Video
				$recipes=',"recipes":["urn:li:digitalmediaRecipe:feedshare-document-preview","urn:li:digitalmediaRecipe:feedshare-document"]';
				$mediaCategory='NATIVE_DOCUMENT';
				$documentTitle=$post['documentTitle'];
			}
			#$mediaTypes=$post['mediaTypeFamily'];
			$urn=$post['mediaUrn'];
			$fileName=$post['fileName'];
			$allowedCommentersScope=$post['allowedCommentersScope'];
			$postContent = preg_replace("/<p[^>]*?>/", "", $post['postContent']);
			$postContent = str_replace("</p>", "<br />", $postContent);
			$postContent=html_entity_decode(str_replace('"','\"',str_replace(array('<br />','<br>','<br/>'),'\r\n',$postContent)));
			$postContent = str_replace("	", " ", $postContent);
			$postContent = str_replace(array("\r\n", "\n", "\r"), '', $postContent);
			$postContent = strip_tags($postContent);
			//$kennectedUsrs = Yii::$app->db->createCommand("SELECT id from user where email LIKE '%kennected%' or id in (19386,14884,14926,14905,16839,19916)")->queryColumn();
			if($post['mediaType'] !=0){	
				if(1==1){
					try {
						$credentials = new Aws\Credentials\Credentials('AKIA2BIJALKAVZ7OR3IK', 'LHnhwkBth6yHymhRTk8aNdBtj2+Ra4Rslj1UPDhH');
						$bucket="linkedfusionpostmedia";	
						$s3Client = new S3Client([
							'region' => 'us-east-1',  
							'version' => 'latest',
							'credentials' => $credentials
						]);
						$getObject = $s3Client->getObject([
							'Bucket' => $bucket,
							'Key'    => $fileName
						]); 
						$fileURL = $getObject['@metadata']['effectiveUri']; 
						$keyName = basename($fileURL); 
					
						if($post['mediaType']==1){
							$mediaUploadType='IMAGE_SHARING';
						}elseif($post['mediaType']==2){
							$mediaUploadType='VIDEO_SHARING';
						}else{
							$mediaUploadType='DOCUMENT_SHARING';
						}
						
						$fileSize=$getObject['ContentLength']; 
						$contentType=$getObject['ContentType']; 
						$mimTypeDataArr=explode('/',$contentType);
						$mimeType=$mimTypeDataArr[1];  
						$postBodyUpload="{\"mediaUploadType\": \"".$mediaUploadType."\", \"fileSize\": ".$fileSize.", \"filename\": \"".$fileName."\"}";
						$curl = curl_init();
						$hdr=array( 
							"cookie: $cookie",
							"csrf-token: $csrf",
							"Host: www.linkedin.com",
							"User-Agent: $userAgent",
							"accept: application/vnd.linkedin.normalized+json+2.1",
							"Accept-Language: en-US,en;q=0.9", 
							"Accept-Encoding: gzip, deflate, br", 
							"content-length:".strlen($postBodyUpload),
							"content-type: application/json; charset=UTF-8",
							"referer: https://www.linkedin.com/feed/?trk=hb_signin",
							"origin: https://www.linkedin.com"
						);
						curl_setopt_array($curl, array(
							CURLOPT_URL => 'https://www.linkedin.com/voyager/api/voyagerMediaUploadMetadata?action=upload',
							CURLOPT_RETURNTRANSFER => true,
							CURLOPT_ENCODING => "",
							CURLOPT_MAXREDIRS => 10,
							CURLOPT_TIMEOUT => 30,
							CURLOPT_HEADER=>true,
							CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_2TLS,
							CURLOPT_HTTPPROXYTUNNEL => 1,
							CURLOPT_PROXY => "$proxyIp",
							CURLOPT_PROXYPORT => "$proxyPort",
							CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
							CURLOPT_CUSTOMREQUEST => "POST",
							CURLOPT_POSTFIELDS => $postBodyUpload,
							CURLOPT_HTTPHEADER => gthdr($userId,$hdr,$userAgent)
						)); 
						$res = curl_exec($curl); 
						$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
						$headers = substr($res, 0, $header_size);
						$res = substr($res, $header_size);
						$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

						if($http_code == 200 || $http_code == 201 ){
							$response=json_decode($res); 
							if(isset($response->data->value->type) && $response->data->value->type=='SINGLE'){
								$uploadUrl=(isset($response->data->value->singleUploadUrl))?$response->data->value->singleUploadUrl:'';
								$mediaT=(isset($response->data->value->singleUploadHeaders))?(array)$response->data->value->singleUploadHeaders:'';
								$mediaTypes=$mediaT['media-type-family'];
								$urn=(isset($response->data->value->urn))?$response->data->value->urn:'';
								$file_path=$fileURL;
								$image = fopen($file_path, "rb");
								$curl = curl_init();
								$hdr=array(
									"cookie: $cookie",
									"csrf-token: $csrf",
									"User-Agent: $userAgent",
									"accept: */*",
									"Accept-Language: en-US,en;q=0.9", 
									"media-type-family: ".$mediaTypes,
									"Accept-Encoding: gzip, deflate, br",
									"content-type: ".$mimeType, 
									"content-length:".$fileSize,
									"referer: https://www.linkedin.com/feed/?trk=hb_signin",
									"origin: https://www.linkedin.com"
								);
								curl_setopt_array($curl, array(
									CURLOPT_URL => $uploadUrl,
									CURLOPT_RETURNTRANSFER => true,
									CURLOPT_BINARYTRANSFER => true,
									CURLOPT_ENCODING => "",
									CURLOPT_MAXREDIRS => 10,
									CURLOPT_TIMEOUT => 30,
									CURLOPT_HEADER=>true,
									CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_2TLS,
									CURLOPT_HTTPPROXYTUNNEL => 1,
									CURLOPT_PROXY => "$proxyIp",
									CURLOPT_PROXYPORT => "$proxyPort",
									CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
									CURLOPT_PUT => true,
									CURLOPT_INFILE => $image,
									CURLOPT_INFILESIZE => $fileSize, 
									CURLOPT_CONNECTTIMEOUT =>2,
									CURLOPT_HTTPHEADER => gthdr($userId,$hdr,$userAgent)
								));  
								$res = curl_exec($curl); 								
							}
						}
						//unlink($tempFilePath);
					} catch (S3Exception $e) {
						#die('Error:' . $e->getMessage()); 
					} catch (Exception $e) {
						#die('Error:' . $e->getMessage());
					}
				} 
				if($post['mediaType']==3){
					$postBody="{\"visibleToConnectionsOnly\":".$visibleToConnectionsOnly.",\"commentsDisabled\":false,\"externalAudienceProviders\":[],\"commentaryV2\":{\"text\":\"".$postContent."\",\"attributes\":[]},\"origin\":\"FEED\",\"allowedCommentersScope\":\"".$allowedCommentersScope."\",\"media\":[{\"category\":\"".$mediaCategory."\",\"mediaUrn\":\"".$urn."\",\"title\":{\"text\":\"".$documentTitle."\"}".$recipes."}]}";  
				}else{
					$postBody="{\"visibleToConnectionsOnly\":".$visibleToConnectionsOnly.",\"commentsDisabled\":false,\"externalAudienceProviders\":[],\"commentaryV2\":{\"text\":\"".$postContent."\",\"attributes\":[]},\"origin\":\"FEED\",\"allowedCommentersScope\":\"".$allowedCommentersScope."\",\"media\":[{\"category\":\"".$mediaCategory."\",\"mediaUrn\":\"".$urn."\",\"tapTargets\":[]".$recipes."}]}"; 
				}
			}else{
				$regex = '/https?\:\/\/[^\" ]+/i';
				preg_match($regex, $postContent, $match);
				if(!empty($match) && isset($match[0])){
					$curl = curl_init();
					$hdr=array(
						"cookie: $cookie",
						"csrf-token: $csrf",
						"User-Agent: $userAgent",
						"accept: application/vnd.linkedin.normalized+json+2.1",
						"Accept-Language: en-US,en;q=0.9", 
						"Accept-Encoding: gzip, deflate, br", 
						"referer: https://www.linkedin.com/feed/",
						"x-restli-protocol-version: 2.0.0"
					);
					curl_setopt_array($curl, array(
						CURLOPT_URL => 'https://www.linkedin.com/voyager/api/contentcreation/urlPreview/'.rawurlencode($match[0]),
						CURLOPT_RETURNTRANSFER => true,
						CURLOPT_ENCODING => "",
						CURLOPT_MAXREDIRS => 10,
						CURLOPT_TIMEOUT => 30,
						CURLOPT_HEADER=>true,
						CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_2TLS,
						CURLOPT_HTTPPROXYTUNNEL => 1,
						CURLOPT_PROXY => "$proxyIp",
						CURLOPT_PROXYPORT => "$proxyPort",
						CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
						CURLOPT_CUSTOMREQUEST => "GET",
						CURLOPT_HTTPHEADER => gthdr($userId,$hdr,$userAgent)
					)); 
					$res = curl_exec($curl); 
					$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
					$headers = substr($res, 0, $header_size);
					$res = substr($res, $header_size);
					$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
					$articleUrn="";
					$mUrn="";
					if($http_code == 200){
						$response=json_decode($res,true); 
						$articleUrn=explode(',', explode('(', $response['data']['*update'])[1])[0];
						$mUrn="{\"mediaUrn\":\"".$articleUrn."\"}";
					}
					
					$postBody="{\"visibleToConnectionsOnly\":".$visibleToConnectionsOnly.",\"commentsDisabled\":false,\"externalAudienceProviders\":[],\"commentaryV2\":{\"text\":\"".$postContent."\",\"attributes\":[]},\"origin\":\"FEED\",\"allowedCommentersScope\":\"".$allowedCommentersScope."\",\"postState\":\"PUBLISHED\",\"media\":[".$mUrn."]}";
					
				}else{
					
					$postBody="{\"visibleToConnectionsOnly\":".$visibleToConnectionsOnly.",\"commentsDisabled\":false,\"externalAudienceProviders\":[],\"commentaryV2\":{\"text\":\"".$postContent."\",\"attributes\":[]},\"origin\":\"FEED\",\"allowedCommentersScope\":\"".$allowedCommentersScope."\",\"media\":[]}";
					
				}
			}
			$curl = curl_init();
			$hdr=array(
				"cookie: $cookie",
				"csrf-token: $csrf",
				"Host: www.linkedin.com",
				"User-Agent: $userAgent",
				"accept: application/vnd.linkedin.normalized+json+2.1",
				"Accept-Language: en-GB,en;q=0.9,en-US;q=0.8,mt;q=0.7,hi;q=0.6,ms;q=0.5,gu;q=0.4", 
				"Accept-Encoding: gzip, deflate, br", 
				"content-length:".strlen($postBody),
				"content-type: application/json; charset=UTF-8",
				"referer: https://www.linkedin.com/feed/",
				"origin: https://www.linkedin.com",
				"authority: www.linkedin.com"
			);
			curl_setopt_array($curl, array(
				CURLOPT_URL => 'https://www.linkedin.com/voyager/api/contentcreation/normShares',
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 30,
				CURLOPT_HEADER=>true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_2TLS,
				CURLOPT_HTTPPROXYTUNNEL => 1,
				CURLOPT_PROXY => "$proxyIp",
				CURLOPT_PROXYPORT => "$proxyPort",
				CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
				CURLOPT_CUSTOMREQUEST => "POST",
				CURLOPT_POSTFIELDS => $postBody,
				CURLOPT_HTTPHEADER => gthdr($userId,$hdr,$userAgent)
			)); 
			$res = curl_exec($curl);  
			echo "NormShare Res"."<br>"; 
			print_r($res);
			$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
			$headers = substr($res, 0, $header_size);
			$res = substr($res, $header_size);
			$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			if($http_code == 201){
				//Delete post from aws
				/* $credentials = new Aws\Credentials\Credentials('AKIA2BIJALKAVZ7OR3IK', 'LHnhwkBth6yHymhRTk8aNdBtj2+Ra4Rslj1UPDhH');
				$bucket="linkedfusionpostmedia";	
				$s3Client = new S3Client([
					//'profile' => 'default',
					'region' => 'us-east-1',  
					'version' => 'latest',
					'credentials' => $credentials
				]);
				$deleteObject = $s3Client->deleteObject([
					'Bucket' => $bucket,
					'Key'    => $fileName
				]);  */
				$response=json_decode($res);  
				$postUrl=(isset($response->data->status->urn))?$response->data->status->urn:'';     
				$toastCtaUrl=(isset($response->data->status->toastCtaUrl))?$response->data->status->toastCtaUrl:''; 
				$activityUrl=explode('/',$toastCtaUrl);
				$activityUrl=end($activityUrl);
				
				$updatePost = mysqli_query($con, "UPDATE post SET status = 1,activityUrl='".$activityUrl."',postUrl='".$postUrl."',postResponse='".addslashes($res)."' WHERE postId = '" . $post['postId'] . "'");
				
				include "../api/class.phpmailer.php";
				include "../api/class.smtp.php";
				$first_name=$user['first_name'];
				$email=$user['email'];
				$linkedin_email=$user['linkedin_email'];
				$firstName=$user['linkedinfirstname'];
				$lastName=$user['linkedinlastname'];
				$portalId=$user['portal_id'];
				$flag_pd = 0;
				$getPortalQry = $con->query("SELECT * FROM `portals` WHERE `id` = " . $portalId . "  LIMIT 1");
				if ($getPortalQry->num_rows > 0) {
					$flag_pd = 1;
				}

				if ($flag_pd == 0) {
					$getPortalQry = $con->query("SELECT * FROM `portals` WHERE `portal_url` LIKE '%app.linkedfusion.io%'  LIMIT 1");
					if ($getPortalQry->num_rows > 0) {
						$flag_pd = 1;
					}
				}

				if ($flag_pd == 1) {
					$portalData = $getPortalQry->fetch_assoc();
					$GLOBALS['portal_url'] = $portalData['portal_url'];
					$GLOBALS['sitetitle'] = $portalData['sitetitle'];
					$GLOBALS['sitelogo'] = $portalData['sitelogo'];
					$GLOBALS['sitefavicon'] = $portalData['sitefavicon'];
					//$GLOBALS['adminEmail'] = 'dhaval.thakor@intricare.net';
					$GLOBALS['adminEmail'] = $portalData['adminEmail'];
					$GLOBALS['emailFromName'] = $portalData['emailFromName'];
					$GLOBALS['link1_gettingStartedWithInvitationSequences'] = $portalData['link1_gettingStartedWithInvSeq'];
					$GLOBALS['link2_gettingStartedWithInvitationSequences'] = $portalData['link2_gettingStartedWithInvSeq'];
					$GLOBALS['link3_support_home'] = $portalData['link3_support_home'];
					$GLOBALS['link4_site_demo'] = $portalData['link4_site_demo'];
					$GLOBALS['siteburl'] = $portalData['siteburl'];
					$GLOBALS['smtp_host'] = $portalData['smtp_host'];
					$GLOBALS['smtp_username'] = $portalData['smtp_username'];
					$GLOBALS['smtp_password'] = $portalData['smtp_password'];
					$GLOBALS['smtp_port'] = $portalData['smtp_port'];
					$GLOBALS['smtp_encryption'] = $portalData['smtp_encryption'];
					$GLOBALS['supportEmail'] = $portalData['supportEmail'];
					$GLOBALS['notificationEmail'] = $portalData['notificationEmail'];
					$GLOBALS['prospectPageUrl'] = $portalData['prospectPageUrl'];
					$GLOBALS['siteUrl'] = $portalData['siteUrl'];
					$GLOBALS['seqStopppedAfterSendThousandReq'] = $portalData['seqStopppedAfterSendThousandReq'];
					$GLOBALS['zapierEmail'] = $portalData['zapierEmail'];
					$GLOBALS['integrationUrl'] = $portalData['integrationUrl'];
					$GLOBALS['scheduleDemoUrl'] = $portalData['scheduleDemoUrl'];
					$GLOBALS['sampleCsvFileUrl'] = $portalData['sampleCsvFileUrl'];
					$GLOBALS['savedSearchWorkAroundUrl'] = $portalData['savedSearchWorkAroundUrl'];
					$GLOBALS['incomingWebhooksUrl'] = $portalData['incomingWebhooksUrl'];
					$GLOBALS['zapierIntegrationUrl'] = $portalData['zapierIntegrationUrl'];
					$GLOBALS['loginPageImgUrl'] = $portalData['loginPageImgUrl'];
					$GLOBALS['becomeAffiliateUrl'] = $portalData['becomeAffiliateUrl'];
					$GLOBALS['helpCenterUrl'] = $portalData['helpCenterUrl'];
				} else {
					$GLOBALS['portal_url'] = 'https://app.linkedfusion.io';
					$GLOBALS['sitetitle'] = 'LinkedFusion';
					$GLOBALS['sitelogo'] = '';
					$GLOBALS['sitefavicon'] = 'https://app.linkedfusion.io/web/img/favicon.ico';
					//$GLOBALS['adminEmail'] = 'dhaval.thakor@intricare.net';
					$GLOBALS['adminEmail'] = 'support@linkedfusion.io';
					$GLOBALS['emailFromName'] = 'LinkedFusion';
					$GLOBALS['link1_gettingStartedWithInvitationSequences'] = 'https://intercom.help/lead-connect/en/articles/2245293-getting-started-with-invitation-sequences';
					$GLOBALS['link2_gettingStartedWithInvitationSequences'] = 'https://leadconnect.freshdesk.com/support/solutions/articles/42000034241-getting-started-with-invitation-sequences';
					$GLOBALS['link3_support_home'] = 'https://leadconnect.freshdesk.com/support/home';
					$GLOBALS['link4_site_demo'] = 'https://calendly.com/leadconnect/demo';
					$GLOBALS['siteburl'] = 'https://nikit.intricare.net/cloud_theme/basic/web/';
					$GLOBALS['smtp_host'] = 'email-smtp.us-east-1.amazonaws.com';
					$GLOBALS['smtp_username'] = 'AKIA2BIJALKAXALFE57C';
					$GLOBALS['smtp_password'] = 'BJb4aofQuAnYEAEhZB2GywFvot/8l70a6ZfvDro7RWR4';
					$GLOBALS['smtp_port'] = 465;
					$GLOBALS['smtp_encryption'] = 'ssl';
					$GLOBALS['supportEmail'] = 'support@linkedfusion.io';
					$GLOBALS['notificationEmail'] = 'notifications@linkedfusion.io';
					$GLOBALS['prospectPageUrl'] = 'https://app.linkedfusion.io/web/prospect';
					$GLOBALS['siteUrl'] = 'https://linkedfusion.io';
					$GLOBALS['seqStopppedAfterSendThousandReq'] = 'https://intercom.help/lead-connect/en/articles/2298948-sequence-stoppped-after-sending-around-1000-requests';
					$GLOBALS['zapierEmail'] = 'zapier@linkedfusion.io';
					$GLOBALS['integrationUrl'] = 'https://s3-us-west-2.amazonaws.com/intricare-assets/Email-Assets/Integration.png';
					$GLOBALS['scheduleDemoUrl'] = 'https://meet.linkedfusion.io/';
					$GLOBALS['sampleCsvFileUrl'] = 'https://s3.amazonaws.com/leadconnect.io/Book1.csv';
					$GLOBALS['savedSearchWorkAroundUrl'] = 'https://leadconnect.freshdesk.com/support/solutions/articles/42000045886-why-saved-searches-are-not-supported-and-work-around-';
					$GLOBALS['incomingWebhooksUrl'] = 'https://intercom.help/lead-connect/articles/3045454-incoming-webhooks';
					$GLOBALS['zapierIntegrationUrl'] = 'https://intercom.help/lead-connect/articles/3046113-zapier-integration';
					$GLOBALS['loginPageImgUrl'] = 'https://app.leadcrm.io/web/app-assets/images/pages/login.png';
					$GLOBALS['becomeAffiliateUrl'] = '';
					$GLOBALS['helpCenterUrl'] = '';
				}
				$mail = new PHPMailer(); // create a new object
				$mail->IsSMTP(); // enable SMTP
				$mail->SMTPDebug = 1; // debugging: 1 = errors and messages, 2 = messages only
				$mail->SMTPAuth = true; // authentication enabled

				$mail->Host = $GLOBALS['smtp_host']; //"email-smtp.us-east-1.amazonaws.com";
				$mail->Username = $GLOBALS['smtp_username']; //"AKIA2BIJALKAXALFE57C";
				$mail->Password = $GLOBALS['smtp_password']; //"BJb4aofQuAnYEAEhZB2GywFvot/8l70a6ZfvDro7RWR4";
				$mail->SMTPSecure = $GLOBALS['smtp_encryption']; //'ssl';
				$mail->Port = $GLOBALS['smtp_port']; //465; // or 587
				$mail->SetFrom($GLOBALS['adminEmail'], $GLOBALS['emailFromName']. " Alerts");
				
				$mail->Subject = $GLOBALS['emailFromName'] . ": Your Scheduled LinkedIn Post Is Live Now";
				 
				$mail->IsHTML(true);

				if ($GLOBALS['sitelogo'] == '') {
					$portal_logo_html = $GLOBALS['sitetitle'];
				} else {
					$portal_logo_html = '<img width="240" height="44" src="' . $GLOBALS['sitelogo'] . '" class="custom-logo" alt="' . $GLOBALS['sitetitle'] . '" itemprop="logo">';
				}
				
				$first_name = $first_name;
				$toEmail = $email;
				$linkedin_email = $linkedin_email;
				$linkedin_firstName = $firstName;
				$linkedin_lastName = $lastName;
				$mail->Body = '<!doctype html>
				<html>
				<head>
				<meta name="viewport" content="width=device-width" />
				<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				<title>Cancel Subcription Request</title>
				<style>
				img {
				border: none;
				-ms-interpolation-mode: bicubic;
				max-width: 100%; 
				}
				body {
				background-color: #f6f6f6;
				font-family: sans-serif;
				-webkit-font-smoothing: antialiased;
				font-size: 14px;
				line-height: 1.4;
				margin: 0;
				padding: 0;
				-ms-text-size-adjust: 100%;
				-webkit-text-size-adjust: 100%; 
				}
				table {
				border-collapse: separate;
				mso-table-lspace: 0pt;
				mso-table-rspace: 0pt;
				width: 100%; }
				table td {
				  font-family: sans-serif;
				  font-size: 14px;
				  vertical-align: top; 
				}    
				.body {
				background-color: #f6f6f6;
				width: 100%; 
				}      
				.container {
				display: block;
				margin: 0 auto !important;
				
				max-width: 580px;
				padding: 10px;
				width: 580px; 
				}      
				.content {
				box-sizing: border-box;
				display: block;
				margin: 0 auto;
				max-width: 580px;
				padding: 10px; 
				}      
				.main {
				background: #ffffff;
				border-radius: 3px;
				width: 100%; 
				}
				.wrapper {
				box-sizing: border-box;
				padding: 20px; 
				}
				.content-block {
				padding-bottom: 10px;
				padding-top: 10px;
				}
				.footer {
				clear: both;
				margin-top: 10px;
				text-align: center;
				width: 100%; 
				}
				.footer td,
				.footer p,
				.footer span,
				.footer a {
				  color: #999999;
				  font-size: 12px;
				  text-align: center; 
				}      
				h1,
				h2,
				h3,
				h4 {
				color: #000000;
				font-family: sans-serif;
				font-weight: 400;
				line-height: 1.4;
				margin: 0;
				margin-bottom: 30px; 
				}
				h1 {
				font-size: 35px;
				font-weight: 300;
				text-align: center;
				text-transform: capitalize; 
				}
				p,
				ul,
				ol {
				font-family: sans-serif;
				font-size: 14px;
				font-weight: normal;
				margin: 0;
				margin-bottom: 15px; 
				}
				p li,
				ul li,
				ol li {
				  list-style-position: inside;
				  margin-left: 5px; 
				}
				a {
				color: #3498db;
				text-decoration: underline; 
				}      
				.btn {
				box-sizing: border-box;
				width: 100%; }
				.btn > tbody > tr > td {
				  padding-bottom: 15px; }
				.btn table {
				  width: auto; 
				}
				.btn table td {
				  background-color: #ffffff;
				  border-radius: 5px;
				  text-align: center; 
				}
				.btn a {
				  background-color: #ffffff;
				  border: solid 1px #3498db;
				  border-radius: 5px;
				  box-sizing: border-box;
				  color: #3498db;
				  cursor: pointer;
				  display: inline-block;
				  font-size: 14px;
				  font-weight: bold;
				  margin: 0;
				  padding: 12px 25px;
				  text-decoration: none;
				  text-transform: capitalize; 
				}
				.btn-primary table td {
				background-color: #3498db; 
				}
				.btn-primary a {
				background-color: #3498db;
				border-color: #3498db;
				color: #ffffff; 
				}      
				.last {
				margin-bottom: 0; 
				}
				.first {
				margin-top: 0; 
				}
				.align-center {
				text-align: center; 
				}
				.align-right {
				text-align: right; 
				}
				.align-left {
				text-align: left; 
				}
				.clear {
				clear: both; 
				}
				.mt0 {
				margin-top: 0; 
				}
				.mb0 {
				margin-bottom: 0; 
				}
				.preheader {
				color: transparent;
				display: none;
				height: 0;
				max-height: 0;
				max-width: 0;
				opacity: 0;
				overflow: hidden;
				mso-hide: all;
				visibility: hidden;
				width: 0; 
				}
				.powered-by a {
				text-decoration: none; 
				}
				hr {
				border: 0;
				border-bottom: 1px solid #f6f6f6;
				margin: 20px 0; 
				}      
				@media only screen and (max-width: 620px) {
				table[class=body] h1 {
				  font-size: 28px !important;
				  margin-bottom: 10px !important; 
				}
				table[class=body] p,
				table[class=body] ul,
				table[class=body] ol,
				table[class=body] td,
				table[class=body] span,
				table[class=body] a {
				  font-size: 16px !important; 
				}
				table[class=body] .wrapper,
				table[class=body] .article {
				  padding: 10px !important; 
				}
				table[class=body] .content {
				  padding: 0 !important; 
				}
				table[class=body] .container {
				  padding: 0 !important;
				  width: 100% !important; 
				}
				table[class=body] .main {
				  border-left-width: 0 !important;
				  border-radius: 0 !important;
				  border-right-width: 0 !important; 
				}
				table[class=body] .btn table {
				  width: 100% !important; 
				}
				table[class=body] .btn a {
				  width: 100% !important; 
				}
				table[class=body] .img-responsive {
				  height: auto !important;
				  max-width: 100% !important;
				  width: auto !important; 
				}
				}      
				@media all {
				.ExternalClass {
				  width: 100%; 
				}
				.ExternalClass,
				.ExternalClass p,
				.ExternalClass span,
				.ExternalClass font,
				.ExternalClass td,
				.ExternalClass div {
				  line-height: 100%; 
				}
				.apple-link a {
				  color: inherit !important;
				  font-family: inherit !important;
				  font-size: inherit !important;
				  font-weight: inherit !important;
				  line-height: inherit !important;
				  text-decoration: none !important; 
				}
				#MessageViewBody a {
				  color: inherit;
				  text-decoration: none;
				  font-size: inherit;
				  font-family: inherit;
				  font-weight: inherit;
				  line-height: inherit;
				}
				.btn-primary table td:hover {
				  background-color: #34495e !important; 
				}
				.btn-primary a:hover {
				  background-color: #34495e !important;
				  border-color: #34495e !important; 
				} 
				}
				</style>
				</head>
				<body class="">
				<table role="presentation" border="0" cellpadding="0" cellspacing="0" class="body">
				<tr>
				<td>&nbsp;</td>
				<td class="container">
				  <div class="content">
								<div style="text-align:center;">
				' . $portal_logo_html . '
				</div>
					<!-- START CENTERED WHITE CONTAINER -->
					<table role="presentation" class="main">

					  <!-- START MAIN CONTENT AREA -->
					  <tr>
						<td class="wrapper">
						  <table role="presentation" border="0" cellpadding="0" cellspacing="0">
							<tr>
							  <td>
								<p>Hey ' . $first_name . ',</p>
								<p>Great news! 🙂</p>
								<p>Your scheduled post has successfully been published on your LinkedIn account.</p>                                       
								<p>Check your recent post here: https://www.linkedin.com/in/'.urlencode($publicIdentifier).'/recent-activity/shares/</p>                                       
							  </td>
							</tr>
						  </table>
						</td>
					  </tr>                                   
					</table>                                    
					<div class="footer">
					  <table role="presentation" border="0" cellpadding="0" cellspacing="0">
						<tr>
						  <td class="content-block">
							<span class="apple-link">&copy; ' . date('Y') . ' ' . $GLOBALS['sitetitle'] . '. - All Rights Reserved</span>
						  </td>
						</tr>
					  </table>
					</div>
				  </div>
				</td>
				<td>&nbsp;</td>
				</tr>
				</table>
				</body>
				</html>';
				$mail->AddAddress($toEmail);
				$mail->addBcc("trupal@intricare.net"); 
				if (!$mail->Send()) {
					echo "Mailer Error: " . $mail->ErrorInfo;
				} else {
					echo "Email Sent Successfully";
				}
			}else{  
				$request=json_encode(curl_getinfo($curl)); 
				$request=curl_getinfo($curl);   
				$request['cookie']=$cookie;
				$request['csrf']=$csrf;
				$request['proxyip']=$proxyIp;
				$request['proxyPort']=$proxyPort;
				$request['proxyUsername']=$proxyUsername;
				$request['proxyPassword']=$proxyPassword;   
				$request=json_encode($request);
				$updatePost = mysqli_query($con, "UPDATE post SET status = 2 WHERE postId = '" . $post['postId'] . "'");
				$sql = $con->query("INSERT INTO error_handling (seqId,userId,taskId,response,request,mailSent,statusCode)VALUES (".$post['postId'].",'$userId',0,'$res','$request',1,'$http_code')"); 
				
				include "../api/class.phpmailer.php";
				include "../api/class.smtp.php";
				$first_name=$user['first_name'];
				$email=$user['email'];
				$linkedin_email=$user['linkedin_email'];
				$firstName=$user['linkedinfirstname'];
				$lastName=$user['linkedinlastname'];
				$portalId=$user['portal_id'];
				$flag_pd = 0;
				$getPortalQry = $con->query("SELECT * FROM `portals` WHERE `id` = " . $portalId . "  LIMIT 1");
				if ($getPortalQry->num_rows > 0) {
					$flag_pd = 1;
				}

				if ($flag_pd == 0) {
					$getPortalQry = $con->query("SELECT * FROM `portals` WHERE `portal_url` LIKE '%app.linkedfusion.io%'  LIMIT 1");
					if ($getPortalQry->num_rows > 0) {
						$flag_pd = 1;
					}
				}

				if ($flag_pd == 1) {
					$portalData = $getPortalQry->fetch_assoc();
					$GLOBALS['portal_url'] = $portalData['portal_url'];
					$GLOBALS['sitetitle'] = $portalData['sitetitle'];
					$GLOBALS['sitelogo'] = $portalData['sitelogo'];
					$GLOBALS['sitefavicon'] = $portalData['sitefavicon'];
					//$GLOBALS['adminEmail'] = 'dhaval.thakor@intricare.net';
					$GLOBALS['adminEmail'] = $portalData['adminEmail'];
					$GLOBALS['emailFromName'] = $portalData['emailFromName'];
					$GLOBALS['link1_gettingStartedWithInvitationSequences'] = $portalData['link1_gettingStartedWithInvSeq'];
					$GLOBALS['link2_gettingStartedWithInvitationSequences'] = $portalData['link2_gettingStartedWithInvSeq'];
					$GLOBALS['link3_support_home'] = $portalData['link3_support_home'];
					$GLOBALS['link4_site_demo'] = $portalData['link4_site_demo'];
					$GLOBALS['siteburl'] = $portalData['siteburl'];
					$GLOBALS['smtp_host'] = $portalData['smtp_host'];
					$GLOBALS['smtp_username'] = $portalData['smtp_username'];
					$GLOBALS['smtp_password'] = $portalData['smtp_password'];
					$GLOBALS['smtp_port'] = $portalData['smtp_port'];
					$GLOBALS['smtp_encryption'] = $portalData['smtp_encryption'];
					$GLOBALS['supportEmail'] = $portalData['supportEmail'];
					$GLOBALS['notificationEmail'] = $portalData['notificationEmail'];
					$GLOBALS['prospectPageUrl'] = $portalData['prospectPageUrl'];
					$GLOBALS['siteUrl'] = $portalData['siteUrl'];
					$GLOBALS['seqStopppedAfterSendThousandReq'] = $portalData['seqStopppedAfterSendThousandReq'];
					$GLOBALS['zapierEmail'] = $portalData['zapierEmail'];
					$GLOBALS['integrationUrl'] = $portalData['integrationUrl'];
					$GLOBALS['scheduleDemoUrl'] = $portalData['scheduleDemoUrl'];
					$GLOBALS['sampleCsvFileUrl'] = $portalData['sampleCsvFileUrl'];
					$GLOBALS['savedSearchWorkAroundUrl'] = $portalData['savedSearchWorkAroundUrl'];
					$GLOBALS['incomingWebhooksUrl'] = $portalData['incomingWebhooksUrl'];
					$GLOBALS['zapierIntegrationUrl'] = $portalData['zapierIntegrationUrl'];
					$GLOBALS['loginPageImgUrl'] = $portalData['loginPageImgUrl'];
					$GLOBALS['becomeAffiliateUrl'] = $portalData['becomeAffiliateUrl'];
					$GLOBALS['helpCenterUrl'] = $portalData['helpCenterUrl'];
				} else {
					$GLOBALS['portal_url'] = 'https://app.linkedfusion.io';
					$GLOBALS['sitetitle'] = 'LinkedFusion';
					$GLOBALS['sitelogo'] = '';
					$GLOBALS['sitefavicon'] = 'https://app.linkedfusion.io/web/img/favicon.ico';
					//$GLOBALS['adminEmail'] = 'dhaval.thakor@intricare.net';
					$GLOBALS['adminEmail'] = 'support@linkedfusion.io';
					$GLOBALS['emailFromName'] = 'LinkedFusion';
					$GLOBALS['link1_gettingStartedWithInvitationSequences'] = 'https://intercom.help/lead-connect/en/articles/2245293-getting-started-with-invitation-sequences';
					$GLOBALS['link2_gettingStartedWithInvitationSequences'] = 'https://leadconnect.freshdesk.com/support/solutions/articles/42000034241-getting-started-with-invitation-sequences';
					$GLOBALS['link3_support_home'] = 'https://leadconnect.freshdesk.com/support/home';
					$GLOBALS['link4_site_demo'] = 'https://calendly.com/leadconnect/demo';
					$GLOBALS['siteburl'] = 'https://nikit.intricare.net/cloud_theme/basic/web/';
					$GLOBALS['smtp_host'] = 'email-smtp.us-east-1.amazonaws.com';
					$GLOBALS['smtp_username'] = 'AKIA2BIJALKAXALFE57C';
					$GLOBALS['smtp_password'] = 'BJb4aofQuAnYEAEhZB2GywFvot/8l70a6ZfvDro7RWR4';
					$GLOBALS['smtp_port'] = 465;
					$GLOBALS['smtp_encryption'] = 'ssl';
					$GLOBALS['supportEmail'] = 'support@linkedfusion.io';
					$GLOBALS['notificationEmail'] = 'notifications@linkedfusion.io';
					$GLOBALS['prospectPageUrl'] = 'https://app.linkedfusion.io/web/prospect';
					$GLOBALS['siteUrl'] = 'https://linkedfusion.io';
					$GLOBALS['seqStopppedAfterSendThousandReq'] = 'https://intercom.help/lead-connect/en/articles/2298948-sequence-stoppped-after-sending-around-1000-requests';
					$GLOBALS['zapierEmail'] = 'zapier@linkedfusion.io';
					$GLOBALS['integrationUrl'] = 'https://s3-us-west-2.amazonaws.com/intricare-assets/Email-Assets/Integration.png';
					$GLOBALS['scheduleDemoUrl'] = 'https://meet.linkedfusion.io/';
					$GLOBALS['sampleCsvFileUrl'] = 'https://s3.amazonaws.com/leadconnect.io/Book1.csv';
					$GLOBALS['savedSearchWorkAroundUrl'] = 'https://leadconnect.freshdesk.com/support/solutions/articles/42000045886-why-saved-searches-are-not-supported-and-work-around-';
					$GLOBALS['incomingWebhooksUrl'] = 'https://intercom.help/lead-connect/articles/3045454-incoming-webhooks';
					$GLOBALS['zapierIntegrationUrl'] = 'https://intercom.help/lead-connect/articles/3046113-zapier-integration';
					$GLOBALS['loginPageImgUrl'] = 'https://app.leadcrm.io/web/app-assets/images/pages/login.png';
					$GLOBALS['becomeAffiliateUrl'] = '';
					$GLOBALS['helpCenterUrl'] = '';
				}
				$mail = new PHPMailer(); // create a new object
				$mail->IsSMTP(); // enable SMTP
				$mail->SMTPDebug = 1; // debugging: 1 = errors and messages, 2 = messages only
				$mail->SMTPAuth = true; // authentication enabled

				$mail->Host = $GLOBALS['smtp_host']; //"email-smtp.us-east-1.amazonaws.com";
				$mail->Username = $GLOBALS['smtp_username']; //"AKIA2BIJALKAXALFE57C";
				$mail->Password = $GLOBALS['smtp_password']; //"BJb4aofQuAnYEAEhZB2GywFvot/8l70a6ZfvDro7RWR4";
				$mail->SMTPSecure = $GLOBALS['smtp_encryption']; //'ssl';
				$mail->Port = $GLOBALS['smtp_port']; //465; // or 587

				$mail->SetFrom($GLOBALS['adminEmail'], $GLOBALS['emailFromName']. " Alerts");
				
				$mail->Subject = $GLOBALS['emailFromName'] . ": Post scheduling failed";
				 
				$mail->IsHTML(true);

				if ($GLOBALS['sitelogo'] == '') {
					$portal_logo_html = $GLOBALS['sitetitle'];
				} else {
					$portal_logo_html = '<img width="240" height="44" src="' . $GLOBALS['sitelogo'] . '" class="custom-logo" alt="' . $GLOBALS['sitetitle'] . '" itemprop="logo">';
				}
				
				$first_name = $first_name;
				$toEmail = $email;
				$linkedin_email = $linkedin_email;
				$linkedin_firstName = $firstName;
				$linkedin_lastName = $lastName;
				$mail->Body = '<!doctype html>
				<html>
				<head>
				<meta name="viewport" content="width=device-width" />
				<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				<title>post schedule failed</title>
				<style>
				img {
				border: none;
				-ms-interpolation-mode: bicubic;
				max-width: 100%; 
				}
				body {
				background-color: #f6f6f6;
				font-family: sans-serif;
				-webkit-font-smoothing: antialiased;
				font-size: 14px;
				line-height: 1.4;
				margin: 0;
				padding: 0;
				-ms-text-size-adjust: 100%;
				-webkit-text-size-adjust: 100%; 
				}
				table {
				border-collapse: separate;
				mso-table-lspace: 0pt;
				mso-table-rspace: 0pt;
				width: 100%; }
				table td {
				  font-family: sans-serif;
				  font-size: 14px;
				  vertical-align: top; 
				}    
				.body {
				background-color: #f6f6f6;
				width: 100%; 
				}      
				.container {
				display: block;
				margin: 0 auto !important;
				
				max-width: 580px;
				padding: 10px;
				width: 580px; 
				}      
				.content {
				box-sizing: border-box;
				display: block;
				margin: 0 auto;
				max-width: 580px;
				padding: 10px; 
				}      
				.main {
				background: #ffffff;
				border-radius: 3px;
				width: 100%; 
				}
				.wrapper {
				box-sizing: border-box;
				padding: 20px; 
				}
				.content-block {
				padding-bottom: 10px;
				padding-top: 10px;
				}
				.footer {
				clear: both;
				margin-top: 10px;
				text-align: center;
				width: 100%; 
				}
				.footer td,
				.footer p,
				.footer span,
				.footer a {
				  color: #999999;
				  font-size: 12px;
				  text-align: center; 
				}      
				h1,
				h2,
				h3,
				h4 {
				color: #000000;
				font-family: sans-serif;
				font-weight: 400;
				line-height: 1.4;
				margin: 0;
				margin-bottom: 30px; 
				}
				h1 {
				font-size: 35px;
				font-weight: 300;
				text-align: center;
				text-transform: capitalize; 
				}
				p,
				ul,
				ol {
				font-family: sans-serif;
				font-size: 14px;
				font-weight: normal;
				margin: 0;
				margin-bottom: 15px; 
				}
				p li,
				ul li,
				ol li {
				  list-style-position: inside;
				  margin-left: 5px; 
				}
				a {
				color: #3498db;
				text-decoration: underline; 
				}      
				.btn {
				box-sizing: border-box;
				width: 100%; }
				.btn > tbody > tr > td {
				  padding-bottom: 15px; }
				.btn table {
				  width: auto; 
				}
				.btn table td {
				  background-color: #ffffff;
				  border-radius: 5px;
				  text-align: center; 
				}
				.btn a {
				  background-color: #ffffff;
				  border: solid 1px #3498db;
				  border-radius: 5px;
				  box-sizing: border-box;
				  color: #3498db;
				  cursor: pointer;
				  display: inline-block;
				  font-size: 14px;
				  font-weight: bold;
				  margin: 0;
				  padding: 12px 25px;
				  text-decoration: none;
				  text-transform: capitalize; 
				}
				.btn-primary table td {
				background-color: #3498db; 
				}
				.btn-primary a {
				background-color: #3498db;
				border-color: #3498db;
				color: #ffffff; 
				}      
				.last {
				margin-bottom: 0; 
				}
				.first {
				margin-top: 0; 
				}
				.align-center {
				text-align: center; 
				}
				.align-right {
				text-align: right; 
				}
				.align-left {
				text-align: left; 
				}
				.clear {
				clear: both; 
				}
				.mt0 {
				margin-top: 0; 
				}
				.mb0 {
				margin-bottom: 0; 
				}
				.preheader {
				color: transparent;
				display: none;
				height: 0;
				max-height: 0;
				max-width: 0;
				opacity: 0;
				overflow: hidden;
				mso-hide: all;
				visibility: hidden;
				width: 0; 
				}
				.powered-by a {
				text-decoration: none; 
				}
				hr {
				border: 0;
				border-bottom: 1px solid #f6f6f6;
				margin: 20px 0; 
				}      
				@media only screen and (max-width: 620px) {
				table[class=body] h1 {
				  font-size: 28px !important;
				  margin-bottom: 10px !important; 
				}
				table[class=body] p,
				table[class=body] ul,
				table[class=body] ol,
				table[class=body] td,
				table[class=body] span,
				table[class=body] a {
				  font-size: 16px !important; 
				}
				table[class=body] .wrapper,
				table[class=body] .article {
				  padding: 10px !important; 
				}
				table[class=body] .content {
				  padding: 0 !important; 
				}
				table[class=body] .container {
				  padding: 0 !important;
				  width: 100% !important; 
				}
				table[class=body] .main {
				  border-left-width: 0 !important;
				  border-radius: 0 !important;
				  border-right-width: 0 !important; 
				}
				table[class=body] .btn table {
				  width: 100% !important; 
				}
				table[class=body] .btn a {
				  width: 100% !important; 
				}
				table[class=body] .img-responsive {
				  height: auto !important;
				  max-width: 100% !important;
				  width: auto !important; 
				}
				}      
				@media all {
				.ExternalClass {
				  width: 100%; 
				}
				.ExternalClass,
				.ExternalClass p,
				.ExternalClass span,
				.ExternalClass font,
				.ExternalClass td,
				.ExternalClass div {
				  line-height: 100%; 
				}
				.apple-link a {
				  color: inherit !important;
				  font-family: inherit !important;
				  font-size: inherit !important;
				  font-weight: inherit !important;
				  line-height: inherit !important;
				  text-decoration: none !important; 
				}
				#MessageViewBody a {
				  color: inherit;
				  text-decoration: none;
				  font-size: inherit;
				  font-family: inherit;
				  font-weight: inherit;
				  line-height: inherit;
				}
				.btn-primary table td:hover {
				  background-color: #34495e !important; 
				}
				.btn-primary a:hover {
				  background-color: #34495e !important;
				  border-color: #34495e !important; 
				} 
				}
				</style>
				</head>
				<body class="">
				<table role="presentation" border="0" cellpadding="0" cellspacing="0" class="body">
				<tr>
				<td>&nbsp;</td>
				<td class="container">
				  <div class="content">
								<div style="text-align:center;">
				' . $portal_logo_html . '
				</div>
					<!-- START CENTERED WHITE CONTAINER -->
					<table role="presentation" class="main">

					  <!-- START MAIN CONTENT AREA -->
					  <tr>
						<td class="wrapper">
						  <table role="presentation" border="0" cellpadding="0" cellspacing="0">
							<tr>
							  <td>
								<p>Hey ' . $first_name . ',</p>
								<p>Your scheduled post did not get published on your LinkedIn account.</p>
								<p>This could happen due to various reasons. To check your scheduled post, kindly visit: '.$GLOBALS['portal_url'].'/web/scheduleposts</p>                                      
							  </td>
							</tr>
						  </table>
						</td>
					  </tr>                                   
					</table>                                    
					<div class="footer">
					  <table role="presentation" border="0" cellpadding="0" cellspacing="0">
						<tr>
						  <td class="content-block">
							<span class="apple-link">&copy; ' . date('Y') . ' ' . $GLOBALS['sitetitle'] . '. - All Rights Reserved</span>
						  </td>
						</tr>
					  </table>
					</div>
				  </div>
				</td>
				<td>&nbsp;</td>
				</tr>
				</table>
				</body>
				</html>';
				$mail->AddAddress("trupal@intricare.net");  
				$mail->addBcc("ankit@intricare.net"); 
				if (!$mail->Send()) {
					echo "Mailer Error: " . $mail->ErrorInfo;
				} else {
					echo "Email Sent Succressfully";
				}
			}
		}
	}	
}