<?php
include('config.php');					  

// Report all PHP errors (see changelog)
error_reporting(E_ALL);

define("MIN_DELAY", 35);
define("MAX_DELAY", 75);
define("DONT_SEND_MESSAGES", 0);
define("MAX_ERROR_COUNT", 3);
define("SEARCH_LIMIT", 1000);
define("PROFILES_PER_PAGE", 10);
define("SEARCH_LIMIT_SALES", 2500);
define("PROFILES_PER_PAGE_SALESNAV", 25);
define("LINKEDIN_API_RESPONSE_LEN", 20);
define("ACCEPTED_WAITING_DELAY", 1000 * 60 * 60 * 24);
define("MS_DAY", 864E5);
define("MS_MINUTE", 6E4);
define("CURRENT_ERROR_COUNT", 0);
define("WAIT_SECONDS", 10);
define("LAST_ERROR", '');
define("API_ADDRESS",$GLOBALS['portal_url'].'/api');													
define("TASK_LIMIT_TIME_PERIOD", 864E5);
define("TASK_MAX_EXECUTION_TIME", 6E5);

//Ankit + Trupal
function addLogHistory($text, $seqId, $userId = 0, $errorLog = 0) {
    include('config.php');
    if (!empty($text) && !empty($seqId)) {
        //$text = str_replace('\\', '\\\\', $text);
        $text = mysqli_real_escape_string($con, $text);
        $addLog = "Insert Into ext_log(`text`,`seqId`,`userId`, `errorLog`) values('" . $text . "','" . $seqId . "','" . $userId . "','" . $errorLog . "')";
        $qrExcute = mysqli_query($con, $addLog);
    }
}

//Ankit + Trupal
function makeLink($msg1, $msg2) {
    if (!empty($msg1)) {
        $term = $msg1;
    } else {
        $term = 'url';
    }
    return '<a target="_blank" href="' . $term . '">' . $msg2 . "</a>";
}

//Ankit + Trupal
//function sequenceError($seqId, $msg, $userId) {
//    include('config.php');
//    $updateSequence = mysqli_query($con, "UPDATE ext_sequences SET status = 'Error', subStatus='' WHERE id = '" . $seqId . "'");
//    seqLogNewStatus($seqId, 'Error', $userId);
//    if (!empty($msg)) {
//        addLogHistory($msg, $seqId, $userId);
//    }
//}

function sequenceError($seqId, $msg,$userId) {
    include('config.php');
    $taskQry = mysqli_query($con, "SELECT errCnt from ext_sequences WHERE `id` = '" . $seqId . "'");
    $task = mysqli_fetch_assoc($taskQry);
    if ($task['errCnt'] <= 2) {
        $errorCnt = $task['errCnt'] + 1;
        $updateSequence = mysqli_query($con, "UPDATE ext_sequences SET errCnt = '$errorCnt' WHERE id = '" . $seqId . "'");
    } else {
        $errorCnt = $task['errCnt'] + 1;
        $updateSequence = mysqli_query($con, "UPDATE ext_sequences SET status = 'Error', subStatus='',errCnt = '$errorCnt' WHERE id = '" . $seqId . "'");
    }
    seqLogNewStatus($seqId, 'Error',$userId);
    if (!empty($msg)) {
        addLogHistory($msg, $seqId,$userId);
    }
}

//Ankit + Trupal
function seqLogNewStatus($seqId, $status, $userId) {
    $lseq_sts1 = 'Sequence # ';
    $lseq_sts2 = ' new status: ';
    addLogHistory($lseq_sts1 . $seqId . $lseq_sts2 . $status, 0, $userId);
}

//Ankit + Trupal
function requestWithdraw($user, $taskId, $seqId, $message) {
    include('config.php');

    $csrf = $user['csrf'];
    $cookie = $user['cookie'];
    $proxyIp = $user['proxyIp'];
    $proxyPort = $user['proxyPort'];
    $proxyUsername = $user['proxyUsername'];
    $proxyPassword = $user['proxyPassword'];
    $userAgent = $user['userAgent'];

    $taskQry = mysqli_query($con, "SELECT * from ext_tasks WHERE `id` = '" . $taskId . "'");
    $task = mysqli_fetch_assoc($taskQry);
    if (!empty($task)) {
        $requestId = $task['requestId'];
        if (!empty($requestId)) {
            $personId = $task['personId'];
            $link = 'https://www.linkedin.com/voyager/api/relationships/invitations?action=closeInvitations';
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $link,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_HTTPPROXYTUNNEL => 1,
                CURLOPT_PROXY => "$proxyIp",
                CURLOPT_PROXYPORT => "$proxyPort",
                CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => "{\"inviteActionType\":\"ACTOR_WITHDRAW\",\"inviteActionData\":[{\"entityUrn\":\"urn:li:fs_relInvitation:" . $requestId . "\",\"validationToken\":\"dummy\",\"genericInvitation\":false,\"genericInvitationType\":\"CONNECTION\"}]}",
                CURLOPT_HTTPHEADER => array(
                    "cookie: $cookie",
                    "csrf-token: $csrf",
                    "x-http-method-override: POST",
                    "Host: www.linkedin.com",
                    "User-Agent: $userAgent",
                    "Accept-Language: en-US,en;q=0.5",
                    "Accept-Encoding: gzip, deflate, br",
                    "content-type: application/x-www-form-urlencoded",
                    "x-li-lang: en_US",
                    "x-restli-protocol-version: 2.0.0",
                    "Origin: https://www.linkedin.com",
                    "TE: Trailers"
                )
            ));

            $res = curl_exec($curl);
            if (curl_errno($curl)) {
                $error_msg = curl_error($curl);
                addLogHistory($error_msg, $link['seqId'], $user['id'], 1);
            } else {
                if (!empty($res)) {
                    $tasksQry = mysqli_query($con, "SELECT * from ext_tasks WHERE `personId` = '" . $personId . "'");
                    if (mysqli_num_rows($tasksQry) > 0) {
                        while ($task = mysqli_fetch_assoc($tasksQry)) {
                            $seq = mysqli_fetch_assoc(mysqli_query($con, "SELECT * from ext_sequences WHERE `id` = '" . $task['seqId'] . "'"));
                            $seqName = $seq['name'];

                            $taskPerson = json_decode(mb_convert_encoding($task['person'], 'UTF-8', 'UTF-8'));
                            unset($task['person']);
                            $profiledata = array();
                            $profiledata = $task;
                            $profiledata['person'] = $taskPerson;
                            $profiledata['seq_name']['name'] = $seqName;

                            if ($seq['zapireStatus'] == true && strpos($seq['zaptouse'], "Withdraw") > 0 && $task['type'] == "Connect") {
                                $zapData['sessionId'] = base64_encode($user['id'] . '/' . $user['teamid']);
                                $zapData['type'] = 'Withdraw';
                                $zapData['profiledata'] = json_encode($profiledata);

                                $curl = curl_init();
                                curl_setopt_array($curl, array(
                                    CURLOPT_URL => API_ADDRESS . "/zap.php",
                                    CURLOPT_POSTFIELDS => $zapData
                                ));
                                $res = curl_exec($curl);
                                $err = curl_error($curl);
                                curl_close($curl);

                                $personArr = (array) $taskPerson;
                                foreach ($personArr as $key => $val) {
                                    if ($key != "firstName" && $key != "lastName" && $key != "picture" && $key != "trackingId" && $key != "occupation") {
                                        if (!is_array($val)) {
                                            $personArr[$key] = $val . "00000";
                                        }
                                    }
                                }
                                $updateTask = mysqli_query($con, "UPDATE ext_tasks SET person='" . json_encode($personArr) . "', personId = '" . $task['personId'] . "00000'  WHERE id = '" . $task['id'] . "'");
                                addLogHistory($message, $seqId, $user['id']);
                            }
                        }
                    }
                }
            }
            curl_close($curl);
        }
    }
    return true;
}

//Ankit + Trupal
function salesNavInvitaion($user, $link, $queryString, $resID = 0, $logId = 0, $searchSessionId = 0, $logHistory = false) {
    include('config.php');
    ini_set('max_execution_time', '0');
    $csrf = $user['csrf'];
    $cookie = $user['cookie'];
    $userDetailsQry = mysqli_query($con, "SELECT * from user WHERE `id` = '" . $user['id'] . "' AND `teamid` = '" . $user['teamid'] . "'");
    $userDetails = mysqli_fetch_assoc($userDetailsQry);
    $geoLocation = $userDetails['geoUpdate'];
    $qryStrng = '';

    if (strpos($link['link'], "Included=") !== false) {
        $qryStrng = '(';
        foreach ($queryString as $key => $val) {
            if ($key == 'keywords') {
                $val = str_replace(',', '%2C', trim($val));
                if (!empty($val)) {
                    $val = str_replace("(", "%28", $val);
                    $val = str_replace(")", "%29", $val);
                    $qryStrng .= $key . ":" . str_replace(":", "%3A", $val) . ",";
                    if (strpos($qryStrng, ",keywords:")) {
                        $qryStrng = str_replace("%252C", "%2C", $qryStrng);
                    }
                } else {
                    $qryStrng .= $key . ":" . str_replace(":", "%3A", $val) . ",";
                }
            } else if ($key == 'companyIncluded' || $key == 'companyExcluded') {
                $includedValues = ',companyIncluded';
                $excludedValues = ',companyExcluded';
                if (!array_key_exists("companyIncluded", $queryString)) {
                    $includedValues = '';
                }
                if (!array_key_exists("companyExcluded", $queryString)) {
                    $excludedValues = '';
                }
                if ($key == 'companyIncluded') {
                    $company = str_replace(":", "%3A", trim($val));
                    $companies = explode(',', $company);
                    $list = "";
                    foreach ($companies as $k => $v) {
                        $v1 = explode('%3A', $v);
                        if (array_key_exists(1, $v1)) {
                            $list .= "(text:" . rawurlencode($v1[0]) . ",id:" . $v1[1] . ")";
                        } else {
                            $list .= "(text:" . rawurlencode($v1[0]) . ")";
                        }
                        if (count($companies) != $k + 1) {
                            $list .= ',';
                        }
                    }
                    $includedValues = ",includedValues:List(" . $list . ")";
                }
                if ($key == 'companyExcluded') {
                    $company = str_replace(":", "%3A", trim($val));
                    $companies = explode(',', $company);
                    $excludedList = "";
                    foreach ($companies as $k => $v) {
                        $v1 = explode('%3A', $v);
                        if (array_key_exists(1, $v1)) {
                            $excludedList .= "(text:" . rawurlencode($v1[0]) . ",id:" . $v1[1] . ")";
                        } else {
                            $excludedList .= "(text:" . rawurlencode($v1[0]) . ")";
                        }
                        if (count($companies) != $k + 1) {
                            $excludedList .= ',';
                        }
                    }
                    $excludedValues = ",excludedValues:List(" . $excludedList . ")";
                }
                if (!strpos($qryStrng, "companyV2")) {
                    $qryStrng .= "companyV2:(scope:" . $queryString['companyTimeScope'] . $includedValues . $excludedValues . "),";
                } else {
                    $qryStrng = str_replace(",companyIncluded", $includedValues, str_replace(",companyExcluded", $excludedValues, $qryStrng));
                }
            } else if ($key == "searchWithinMyAccounts") {
                $qryStrng .= "searchWithinMyAcct:true,";
            } else if ($key == "doFetchHeroCard") {
                $qryStrng .= "doFetchHeroCard:false,";
            } else if ($key == "excludeSavedLeads") {
                $qryStrng .= "excludeSaved:true,";
            } else if ($key == "excludeViewedLeads") {
                $qryStrng .= "excludeViewed:true,";
            } else if ($key == "excludeContactedLeads") {
                $qryStrng .= "excludeContacted:true,";
            } else if ($key == "seniorityIncluded" || $key == "seniorityExcluded") {
                $includedValues = 'seniorityIncluded';
                $excludedValues = 'seniorityExcluded';
                if (!array_key_exists("seniorityIncluded", $queryString)) {
                    $includedValues = '';
                }
                if (!array_key_exists("seniorityExcluded", $queryString)) {
                    $excludedValues = '';
                }
                if ($key == "seniorityIncluded")
                    $includedValues = "includedValues:List((id:" . str_replace(",", "),(id:", str_replace(":", "%3A", trim($val))) . "))";
                if ($key == "seniorityExcluded")
                    $excludedValues = "excludedValues:List((id:" . str_replace(",", "),(id:", str_replace(":", "%3A", trim($val))) . "))";

                $both = "";
                if (array_key_exists("seniorityIncluded", $queryString) && array_key_exists("seniorityExcluded", $queryString))
                    $both = ",";

                if (!strpos($qryStrng, "seniorityLevelV2")) {
                    $qryStrng .= "seniorityLevelV2:(" . $includedValues . $both . $excludedValues . "),";
                } else {
                    $qryStrng = str_replace("seniorityIncluded", $includedValues, str_replace("seniorityExcluded", $excludedValues, $qryStrng));
                }
            } else if ($key == "titleTimeScope" || $key == "companyTimeScope" || $key == "radius" || $key == "countryCode") {
                
            } else if ($key == "zips") {
                $qryStrng .= "postalCode:(" . $key . ":List(" . str_replace(":", "%3A", trim($val)) . "),countryCode:" . $queryString['countryCode'] . ",radius:" . $queryString['radius'] . "),";
            } else if ($key == "postedContentKeywords") {
                $qryStrng .= "postKeywords:" . str_replace(":", "%3A", trim($val)) . ",";
            } else if ($key == "firstName" || $key == "lastName") {
                $qryStrng .= $key . ":" . str_replace(":", "%3A", trim($val)) . ",";
            } else if ($key == "titleIncluded" || $key == "titleExcluded") {
                $includedValues = 'titleIncluded';
                $excludedValues = 'titleExcluded';
                if (!array_key_exists("titleIncluded", $queryString)) {
                    $includedValues = '';
                }
                if (!array_key_exists("titleExcluded", $queryString)) {
                    $excludedValues = '';
                }
                if ($key == "titleIncluded") {
                    $title = str_replace(":", "%3A", trim($val));
                    $titleList = explode(',', $title);
                    $list = "";
                    foreach ($titleList as $k => $v) {
                        $v1 = explode('%3A', $v);
                        //$v1[0] = rawurlencode($v1[0]);
                        $v1[0] = str_replace("(", "%28", $v1[0]);
                        $v1[0] = str_replace(")", "%29", $v1[0]);
                        if (array_key_exists(1, $v1)) {
                            $list .= "(text:" . $v1[0] . ",id:" . $v1[1] . ")";
                        } else {
                            $list .= "(text:" . $v1[0] . ")";
                        }
                        if (count($titleList) != $k + 1) {
                            $list .= ',';
                        }
                    }
                    $includedValues = ",includedValues:List(" . $list . ")";
                }
                if ($key == "titleExcluded") {
                    $title = str_replace(":", "%3A", trim($val));
                    $titleList = explode(',', $title);
                    $excludedList = "";
                    foreach ($titleList as $k => $v) {
                        $v1 = explode('%3A', $v);
                        //$v1[0] = rawurlencode($v1[0]);
                        $v1[0] = str_replace("(", "%28", $v1[0]);
                        $v1[0] = str_replace(")", "%29", $v1[0]);
                        if (array_key_exists(1, $v1)) {
                            $excludedList .= "(text:" . $v1[0] . ",id:" . $v1[1] . ")";
                        } else {
                            $excludedList .= "(text:" . $v1[0] . ")";
                        }
                        if (count($titleList) != $k + 1) {
                            $excludedList .= ',';
                        }
                    }
                    $excludedValues = ",excludedValues:List(" . $excludedList . ")";
                }
                if (!strpos($qryStrng, "titleV2")) {
                    $qryStrng .= "titleV2:(scope:" . $queryString['titleTimeScope'] . $includedValues . $excludedValues . "),";
                } else {
                    $qryStrng = str_replace("titleExcluded", $excludedValues, str_replace("titleIncluded", $includedValues, $qryStrng));
                }
            } else if ($key == "spotlight") {
                $qryStrng .= "spotlightParam:(selectedType:" . $val . "),";
            } else {
                if (preg_match('(Included|Excluded)', $key) === 1) {
                    $keyName = str_replace(array('Included', 'Excluded'), "V2", $key);
                    if (preg_match('(Included)', $key) === 1) {
                        if (!strpos($qryStrng, $keyName)) {
                            $qryStrng .= $keyName . ":(includedValues:List((id:" . str_replace(",", "),(id:", str_replace(":", "%3A", trim($val))) . "))),";
                        } else {
                            $qryStrng = preg_replace('/' . $keyName . ':\(/i', $keyName . ":(includedValues:List((id:" . str_replace(",", "),(id:", str_replace(":", "%3A", trim($val))) . ")),", $qryStrng);
                        }
                    }
                    if (preg_match('(Excluded)', $key) === 1) {
                        if (!strpos($qryStrng, $keyName)) {
                            $qryStrng .= $keyName . ":(excludedValues:List((id:" . str_replace(",", "),(id:", str_replace(":", "%3A", trim($val))) . "))),";
                        } else {
                            $qryStrng = preg_replace('/' . $keyName . ':\(/i', $keyName . ":(excludedValues:List((id:" . str_replace(",", "),(id:", str_replace(":", "%3A", trim($val))) . ")),", $qryStrng);
                        }
                    }
                } else {
                    if (preg_match('(pastCompany)', $key) === 1) {
                        $replaceArray = array(",", " ", ":");
                        $replaceArrayValue = array("),(text:", "%20", "id:");
                        $finalAns = str_replace($replaceArray, $replaceArrayValue, $val);
                        $arrString = (":List((text:" . $finalAns . ")),");
                        $idString = str_replace("id", ",id", $arrString);
                        $qryStrng .= $key . $idString;
                    } else {
                        if (strpos($val, "ACCOUNT")) {
                            $qryStrng .= $key . ":List(" . str_replace(":", "%3A", trim($val)) . "),";
                            if (strpos($qryStrng, "listV2")) {
                                $qryStrng = str_replace("listV2", "list", $qryStrng);
                            }
                            if (strpos($qryStrng, "listType:List")) {
                                $qryStrng = str_replace("),listType:List(ACCOUNT)", ",includeAll:false,excludeAll:false,scope:", $qryStrng) . $val . "),";
                            }
                            if (strpos($qryStrng, "scope:,")) {
                                $qryStrng = str_replace("scope:,", "scope:", $qryStrng);
                            }
                        } else if (strpos($val, "LEAD")) {
                            $qryStrng .= $key . ":List(" . str_replace(":", "%3A", trim($val)) . "),";
                            if (strpos($qryStrng, "listV2")) {
                                $qryStrng = str_replace("listV2", "list", $qryStrng);
                            }
                            if (strpos($qryStrng, "listType:List")) {
                                $qryStrng = str_replace("),listType:List(LEAD)", ",includeAll:false,excludeAll:false,scope:", $qryStrng) . $val . "),";
                            }
                            if (strpos($qryStrng, "scope:,")) {
                                $qryStrng = str_replace("scope:,", "scope:", $qryStrng);
                            }
                        } else {
                            $qryStrng .= $key . ":List(" . str_replace(":", "%3A", trim($val)) . "),";
                        }
                    }
                }
            }
        }
        if ($geoLocation == 1) {
            $qryStrng = str_replace("geoV2", "bingGeo", $qryStrng);
        }
        if (!empty($logId) && !empty($searchSessionId)) {
            $qryStrng .= "recentSearchParam:(doLogHistory:true,id:" . $resID . "),searchHistoryParam:(doLogHistory:" . $logHistory . ",id:" . $queryString['rsLogId'] . "),trackingParam:(sessionId:" . $searchSessionId . "),doFetchFilters:true,doFetchHits:true,doFetchSpotlights:true)";
        } else {
            $qryStrng .= "recentSearchParam:(doLogHistory:true),searchHistoryParam:(doLogHistory:" . $logHistory . "),trackingParam:(sessionId:" . $searchSessionId . "),doFetchFilters:true,doFetchHits:true,doFetchSpotlights:true)";
        }
    } else {
        $qryStrng = '(';
        foreach ($queryString as $key => $val) {
            if ($key == 'keywords') {
                $val = str_replace(',', '%2C', trim($val));
                if (!empty($val)) {
                    //$val = str_replace("(", "%28", $val);
                    //$val = str_replace(")", "%29", $val);
                    $qryStrng .= $key . ":" . str_replace(":", "%3A", $val) . ",";
                    if (strpos($qryStrng, ",keywords:")) {
                        $qryStrng = str_replace("%252C", "%2C", $qryStrng);
                    }
                } else {
                    $qryStrng .= $key . ":" . str_replace(":", "%3A", $val) . ",";
                }
            } else if ($key == 'company') {
                $company = str_replace(":", "%3A", trim($val));
                $companies = explode(',', $company);
                $list = "";
                foreach ($companies as $k => $v) {
                    $v1 = explode('%3A', $v);
                    if (array_key_exists(1, $v1)) {
                        $list .= "(text:" . rawurlencode($v1[0]) . ",id:" . $v1[1] . ")";
                    } else {
                        $list .= "(text:" . rawurlencode($v1[0]) . ")";
                    }
                    if (count($companies) != $k + 1) {
                        $list .= ',';
                    }
                }
                $qryStrng .= $key . ":(scope:" . $queryString['companyTimeScope'] . ",values:List(" . $list . ")),";
            } else if ($key == "searchWithinMyAccounts") {
                $qryStrng .= "searchWithinMyAcct:true,";
            } else if ($key == "excludeSavedLeads") {
                $qryStrng .= "excludeSaved:true,";
            } else if ($key == "excludeViewedLeads") {
                $qryStrng .= "excludeViewed:true,";
            } else if ($key == "excludeContactedLeads") {
                $qryStrng .= "excludeContacted:true,";
            } else if ($key == "seniority") {
                $qryStrng .= "seniorityLevel:List(" . str_replace(":", "%3A", trim($val)) . "),";
            } else if ($key == "titleTimeScope" || $key == "companyTimeScope" || $key == "radius" || $key == "countryCode") {
                
            } else if ($key == "zips") {
                $qryStrng .= "postalCode:(" . $key . ":List(" . str_replace(":", "%3A", trim($val)) . "),countryCode:" . $queryString['countryCode'] . ",radius:" . $queryString['radius'] . "),";
            } else if ($key == "firstName" || $key == "lastName") {
                $qryStrng .= $key . ":" . str_replace(":", "%3A", trim($val)) . ",";
            } else if ($key == "title") {
                $title = str_replace(":", "%3A", trim($val));
                $titleList = explode(',', $title);
                $list = "";
                foreach ($titleList as $k => $v) {
                    $v1 = explode('%3A', $v);
                    $v1[0] = rawurlencode($v1[0]);
                    $v1[0] = str_replace("(", "%28", $v1[0]);
                    $v1[0] = str_replace(")", "%29", $v1[0]);
                    if (array_key_exists(1, $v1)) {
                        $list .= "(text:" . $v1[0] . ",id:" . $v1[1] . ")";
                    } else {
                        $list .= "(text:" . $v1[0] . ")";
                    }
                    if (count($titleList) != $k + 1) {
                        $list .= ',';
                    }
                }
                $qryStrng .= "title:(scope:" . $queryString['titleTimeScope'] . ",values:List(" . $list . ")),";
            } else if ($key == "spotlight") {
                $qryStrng .= "spotlightParam:(selectedType:" . $val . "),";
            } else {
                if (preg_match('(pastCompany)', $key) === 1) {
                    $replaceArray = array(",", " ", ":");
                    $replaceArrayValue = array("),(text:", "%20", "id:");
                    $finalAns = str_replace($replaceArray, $replaceArrayValue, $val);
                    $arrString = (":List((text:" . $finalAns . ")),");
                    $idString = str_replace("id", ",id", $arrString);
                    $qryStrng .= $key . $idString;
                } else {
                    $valueFind = $key . str_replace(":", "%3A", trim($val)) . ",";
                    if (strpos($valueFind, "tag:")) {
                        $qryStrng .= $key . ":List(" . str_replace(":", "%3A", trim($val)) . "),";
                    } else if (!strpos($valueFind, "relationship")) {
                        $qryStrng .= $key . ":List(" . str_replace(":", "%3A", trim($val)) . "),";
                    } else if (strpos($valueFind, "group:")) {
                        $qryStrng .= $key . ":List(" . str_replace(":", "%3A", trim($val)) . "),";
                    } else if (strpos($valueFind, "postedContentKeywords:")) {
                        $key = str_replace("postedContentKeywords", "postKeywords", $key);
                        $qryStrng .= $key . ":" . str_replace(":", "%3A", trim($val)) . ",";
                    } else if (strpos($valueFind, "memberSince:")) {
                        $qryStrng .= $key . ":List(" . str_replace(":", "%3A", trim($val)) . "),";
                    } else {
                        $qryStrng .= $key . ":" . str_replace(":", "%3A", trim($val)) . ",";
                    }
                }
            }
        }
        if ($geoLocation == 1) {
            $qryStrng = str_replace("geoV2", "bingGeo", $qryStrng);
        }
        if (!empty($logId) && !empty($searchSessionId)) {
            $qryStrng .= "recentSearchParam:(doLogHistory:true,id:" . $resID . "),searchHistoryParam:(doLogHistory:" . $logHistory . ",id:" . $queryString['rsLogId'] . "),trackingParam:(sessionId:" . $searchSessionId . "),doFetchFilters:true,doFetchHits:true,doFetchSpotlights:true)";
        } else {
            $qryStrng .= "recentSearchParam:(doLogHistory:true),searchHistoryParam:(doLogHistory:" . $logHistory . "),trackingParam:(sessionId:" . $searchSessionId . "),doFetchFilters:true,doFetchHits:true,doFetchSpotlights:true)";
        }
    }
    trySalesRequest($user, $qryStrng, $link);
}

function chekBlaklistUsersSales($post_blacklistCompany,$post_msg,$post_searchData,$post_sessionId){
	//header("Access-Control-Allow-Origin:*");
	//header("Access-Control-Allow-Credentials:true");
	//header("Access-Control-Allow-Methods: OPTIONS, GET, POST");
	//header("Access-Control-Allow-Headers: Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");

	include "config.php";

	// Here we have to check Blacklisted users from db and change the search result and return it...
	$data = $post_searchData;
	$session_id =$post_sessionId;

	$return_array= array();

	if($session_id != '' ){
		$session_id1 = base64_decode($session_id);
		$session_id1 =explode("/",$session_id1);
	}
		if($session_id1[0] == 364 || $session_id1[0] == 390 || $session_id1[0] == 396 || $session_id1[0] == 818 || $session_id1[0] == 932 || $session_id1[0] == 933 || $session_id1[0] == 593)
		die();

		$searchData = explode(",",$data);
		$return_array = '';
		$check_onAccept = $con->query("SELECT * FROM `user` WHERE id ='".$session_id1[0]."' AND `addBlaklist_OnAcceptance` = '1' ");
		$checkForAcceptance = "";
		$check_BlackList = $con->query("SELECT * FROM `user` WHERE id ='".$session_id1[0]."' AND `skip_Blacklist` = 0 ");
		if ($check_onAccept->num_rows > 0 ){
				$checkForAcceptance .= " AND is_accepted = 1 ";
			}
			$msg = 0;
			if (isset($post_msg))
				$msg = $post_msg;
			
		// Create array of linkedinpublicid to search in blacklist table
		$linkedinpublicidArr = array();
		foreach($searchData as $checkData){ 
			
			$linkedinpublicidArr[] = $checkData;
		}
		//End
		
		// Select linkedinpublicid from blacklist table
		if(!empty($linkedinpublicidArr)){
			$StrlinkedinpubIds = implode(",",$linkedinpublicidArr);
			$sql = $con->query("SELECT linkedinpublicid FROM blacklist where  `deleted_at` IS NULL And  linkedinpublicid  IN (".$StrlinkedinpubIds.") And teamid ='".$session_id1[1]."' $checkForAcceptance ");
			
			// If linkinpublicid found remove from array.
			if($sql->num_rows > 0)
			{
				while($row = $sql->fetch_assoc())
				{	
					$rpos = array_search($row['linkedinpublicid'], $linkedinpublicidArr);
					unset($linkedinpublicidArr[$rpos]);  
				}
			}
			
			// final string to pass
			$StrlinkedinpubIds = implode(",",$linkedinpublicidArr);
			
		} 
		
		//End
		 
		// Blacklist company 
		if(isset($post_blacklistCompany)){
				$sql = $con->query("SELECT `company_id` ,`company_name` FROM `blacklistcompany` WHERE `user_id` = '".$session_id1[0]."' or  `user_id` = '".$session_id1[1]."' ");  
				$blacklistcompany = [];
				if ($sql->num_rows > 0){
					while($row = $sql->fetch_assoc()) {	
					$row['company_name'] = mb_convert_encoding($row['company_name'], 'UTF-8');

						$blacklistcompany[] = ["company_id" => $row['company_id'],"company_name" => $row['company_name']]; 
					}

					return json_encode(['blacklist' => $StrlinkedinpubIds , 'blacklistcompany' => json_encode($blacklistcompany)]);
				}else{
					return json_encode(['blacklist' => $StrlinkedinpubIds , 'blacklistcompany' => json_encode($blacklistcompany)]);
				}
		}else{
			//print_r($StrlinkedinpubIds); 
			return $StrlinkedinpubIds; 
		}
	   // End 	
}

//Ankit + Trupal
function trySalesRequest($user, $qryStrng, $link, $count = 0) {
    include('config.php');
    ini_set('max_execution_time', '0');
    $csrf = $user['csrf'];
    $cookie = $user['cookie'];
    $proxyIp = $user['proxyIp'];
    $proxyPort = $user['proxyPort'];
    $proxyUsername = $user['proxyUsername'];
    $proxyPassword = $user['proxyPassword'];
	$userAgent = $user['userAgent'];
    $timeStamp = round(microtime(true) * 1000);
	
    if (!empty($link['total']) && ($link['total'] < $link['start'] || $link['start'] > SEARCH_LIMIT_SALES)) {
        $updateLink = mysqli_query($con, "UPDATE ext_links SET status='Complete',`start`=0  WHERE id = '" . $link['id'] . "'");
		$sql = $con->query("SELECT * FROM `ext_links` WHERE `seqId` = '".$link['seqId']."' AND `status` IN ('Active', 'Not Started')");  
		if ($sql->num_rows == 0){
			addLogHistory('Reached end of the search results, please enter a new search query.', $link['seqId'], $user['id'], 0);
		}
    } else {

        $qryStrng = str_replace("%u200B", "", $qryStrng);
        $qryStrng = str_replace(" ", "%20", $qryStrng);
        $qryStrng = str_replace('"', "%22", $qryStrng);
        $qryStrng = str_replace("'", "%27", $qryStrng);

        $curlUrl = "https://www.linkedin.com/sales-api/salesApiPeopleSearch?q=peopleSearchQuery&start=" . $link['start'] . "&count=" . PROFILES_PER_PAGE_SALESNAV . "&query=" . $qryStrng . "&decoration=%28degree%2CentityUrn%2CfirstName%2ClastName%2CfullName%2CobjectUrn%2CgeoRegion%2Chighlight%28com.linkedin.sales.profile.profileHighlights.MentionedInTheNewsHighlight%21_nt%3Dcom.linkedin.sales.deco.common.profile.highlights.DecoratedMentionedInTheNewsHighlight%28articleName%2Ccount%2Csource%2Curl%29%2Ccom.linkedin.sales.profile.profileHighlights.ProfileHighlights%21_nt%3Dcom.linkedin.sales.deco.common.profile.highlights.DecoratedProfileHighlights%28sharedConnection%28sharedConnectionUrns%2A%7Efs_salesProfile%28entityUrn%2CfirstName%2ClastName%2CfullName%2CpictureInfo%2CprofilePictureDisplayImage%29%29%2CteamlinkInfo%28totalCount%29%2CsharedEducations%2A%28overlapInfo%2CentityUrn%7Efs_salesSchool%28entityUrn%2ClogoId%2Cname%2Curl%2CschoolPictureDisplayImage%29%29%2CsharedExperiences%2A%28overlapInfo%2CentityUrn%7Efs_salesCompany%28companyPictureDisplayImage%2CentityUrn%2Cname%2CpictureInfo%29%29%2CsharedGroups%2A%28entityUrn%7Efs_salesGroup%28entityUrn%2Cname%2ClargeLogoId%2CsmallLogoId%2CgroupPictureDisplayImage%29%29%29%2Ccom.linkedin.sales.profile.profileHighlights.RecentPositionChangeHighlight%21_nt%3Dcom.linkedin.sales.deco.common.profile.highlights.DecoratedRecentPositionChangeHighlight%28companyUrn%2CcompanyName%2Cduration%2Ctitle%29%29%2CsharedConnectionsHighlight%2CteamlinkIntrosHighlight%2CopenLink%2Cpremium%2Cteamlink%2CpendingInvitation%2CprofilePictureDisplayImage%2Cviewed%2Csaved%2CcrmStatus%2CtrackingId%2CrecommendedLeadTrackingId%2ClistCount%2CcurrentPositions%2A%2Ctags%2A%2CpastPositions%2A%2CmatchedArticles%2A%2CfacePiles%2A%29";

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $curlUrl,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
			CURLOPT_VERBOSE => 1,
			CURLOPT_HEADER => 1,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPPROXYTUNNEL => 1,
            CURLOPT_PROXY => "$proxyIp",
            CURLOPT_PROXYPORT => "$proxyPort",
            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array( 
                "cookie: $cookie",
                "csrf-token: $csrf",
                "x-http-method-override: GET",
                "Host: www.linkedin.com",
                "User-Agent: $userAgent",
                "Accept-Language: en-US,en;q=0.5",
                "Accept-Encoding: gzip, deflate, br",
                "content-type: application/x-www-form-urlencoded",
                "x-li-lang: en_US",
                 "x-restli-protocol-version: 2.0.0",
                "Origin: https://www.linkedin.com",
                "TE: Trailers"
            )
        ));

		$res = curl_exec($curl);//print_r($res); 
		$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
		$headers = substr($res, 0, $header_size);
		$res = substr($res, $header_size); 
        if (curl_errno($curl)) {
            $error_msg = curl_error($curl);
            addLogHistory('Error processing link: ' . $link['link'], $link['seqId'], $user['id'], 1);

            $pg = $link['pagesFetched'] + 1;
            sequenceError($link['seqId'], 'Error processing link ' . makeLink($link['link'], "url") . ', page ' . ($link['start'] / PROFILES_PER_PAGE + 1) . '. You can try to continue.', $user['id']);
            logError('Error processing link: ' . $link['link']);
            $updateLink = mysqli_query($con, "UPDATE ext_links SET status = 'Error' WHERE id = '" . $link['id'] . "'");
        } else {
		$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		if($http_code == 200){
            if (!empty($res)) {
                $searchData = '';
                $isMsg = 0;
                $getseq = "select * from ext_sequences where id='" . $link['seqId'] . "' LIMIT 1";
                $exQuerySeq = mysqli_query($con, $getseq);
                $sequence = mysqli_fetch_assoc($exQuerySeq);
                if (!empty($sequence)) {
                    $isMsg = $sequence['msgSeq'];
                    $resObjArr = json_decode($res);

                    if (!empty($resObjArr->elements)) {
                        foreach ($resObjArr->elements as $key => $value) {
                            if ($key == 0)
                                $searchData = $searchData . explode(':', $value->objectUrn)[3];
                            else
                                $searchData = $searchData . ',' . explode(':', $value->objectUrn)[3];

                            if ($key == count($resObjArr->elements) - 1) {
                                $sessionId = base64_encode($user['id'] . '/' . $user['teamid']);
                                $postFields = array("blacklistCompany" => 1, "msg" => $isMsg, "searchData" => $searchData, "sessionId" => $sessionId);
								/*
                                $curl = curl_init();
                                curl_setopt_array($curl, array(
                                    CURLOPT_URL => API_ADDRESS . "/chekBlaklistUsersSales.php",
                                    CURLOPT_RETURNTRANSFER => true,
                                    CURLOPT_ENCODING => "",
                                    CURLOPT_MAXREDIRS => 10,
                                    CURLOPT_TIMEOUT => 30,
                                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                    CURLOPT_CUSTOMREQUEST => "POST",
                                    CURLOPT_POSTFIELDS => $postFields,
                                    CURLOPT_HTTPHEADER => array(
                                        "accept: application/json",
                                    )
                                ));

                                $resBlacklist = curl_exec($curl);
								*/
								
								$resBlacklist = chekBlaklistUsersSales($postFields['blacklistCompany'],$postFields['msg'],$postFields['searchData'],$postFields['sessionId']);
								/*
                                if (curl_errno($curl)) {
                                    $error_msg = curl_error($curl);
                                    addLogHistory($error_msg, $link['seqId'], $user['id'], 1);
                                } else {
									*/
                                    if (!empty($resBlacklist)) {
                                        $include = explode(',', json_decode($resBlacklist)->blacklist);
                                        $currenttime = round(microtime(true) * 1000);
                                        $timeStampcnt = 0;
                                        foreach ($resObjArr->elements as $k => $v) {
                                            if ($timeStampcnt == 0) {
                                                $currenttime_new = $currenttime;
                                            } else {
                                                $rendomTime = rand(45, 180);                                                
                                                if ($timeStampcnt == 1) {
                                                    $currenttime_new = $currenttime + $rendomTime;
                                                } else {
                                                    $currenttime_new = $currenttime_new + $rendomTime;                            
                                                }
                                            }
                                            if (in_array(explode(':', $v->objectUrn)[3], $include)) {
                                                $getSteps = "select * from ext_steps where seqId='" . $link['seqId'] . "' ORDER BY `order` LIMIT 1";
                                                $exQuerySteps = mysqli_query($con, $getSteps);
                                                $step = mysqli_fetch_assoc($exQuerySteps);

                                                if (!empty($step)) {
                                                    $v->id = explode(':', $v->objectUrn)[3];
                                                    $v->longId = explode(',', explode('(', $v->entityUrn)[1])[0];
                                                    $v->url1 = "https://www.linkedin.com/sales/profile/" . explode(')', explode('(', $v->entityUrn)[1])[0];
                                                    $v->url = "https://www.linkedin.com/in/" . $v->longId;
                                                    $v->fullName = $v->firstName . " " . $v->lastName;
                                                    $v->publicIdentifier = '';
                                                    $curlForTrackingId = curl_init();
                                                    curl_setopt_array($curlForTrackingId, array(
                                                        CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $v->longId . "/profileView",
                                                        CURLOPT_RETURNTRANSFER => true,
                                                        CURLOPT_ENCODING => "",
                                                        CURLOPT_MAXREDIRS => 10,
                                                        CURLOPT_TIMEOUT => 30,
                                                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                                        CURLOPT_HTTPPROXYTUNNEL => 1,
                                                        CURLOPT_PROXY => "$proxyIp",
                                                        CURLOPT_PROXYPORT => "$proxyPort",
                                                        CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                                                        CURLOPT_CUSTOMREQUEST => "GET",
                                                        CURLOPT_HTTPHEADER => array(
                                                            "cookie: $cookie",
                                                            "csrf-token: $csrf",
                                                            "x-http-method-override: GET",
                                                            "Host: www.linkedin.com",
                                                            "User-Agent: $userAgent",
                                                            "Accept-Language: en-US,en;q=0.5",
                                                            "Accept-Encoding: gzip, deflate, br",
                                                            "content-type: application/x-www-form-urlencoded",
                                                            "x-li-lang: en_US",
                                                            "x-restli-protocol-version: 2.0.0",
                                                            "Origin: https://www.linkedin.com",
                                                            "TE: Trailers"
                                                        )
                                                    ));
                                                    $resTackingId = curl_exec($curlForTrackingId);
                                                    (!empty(json_decode($resTackingId)->profile->miniProfile->trackingId)) ? $v->trackingId = json_decode($resTackingId)->profile->miniProfile->trackingId : $v->trackingId = $v->trackingId;
                                                    (!empty(json_decode($resTackingId)->profile->miniProfile->publicIdentifier)) ? $v->publicIdentifier = json_decode($resTackingId)->profile->miniProfile->publicIdentifier : $v->publicIdentifier = '';
													
													(!empty(json_decode($resTackingId)->profile->miniProfile->firstName)) ? $v->firstName = mb_htmlentities(json_decode($resTackingId)->profile->miniProfile->firstName) : $v->firstName = '';
													(!empty(json_decode($resTackingId)->profile->miniProfile->lastName)) ? $v->lastName = mb_htmlentities(json_decode($resTackingId)->profile->miniProfile->lastName) : $v->lastName = '';
													$v->fullName = $v->firstName . " " . $v->lastName;
													
													$crnttmsmp = strtotime('+1 minutes', ceil(round(microtime(true) * 1000)/1000)) * 1000;
													
                                                    $addTask = "INSERT INTO ext_tasks (`seqId`, `linkId`, `stepId`, `step`, `startTime`, `personId`, `status`, `type`, `delayDays`, `delayMinutes`, `delayType`, `person`, `triggered`, `userId`) VALUES ('" . $link['seqId'] . "', '" . $link['id'] . "', '" . $step['id'] . "', 0, '" . $crnttmsmp . "', '" . $v->id . "', 'Not Started', '" . $step['type'] . "', '" . $step['delayDays'] . "', '" . $step['delayMinutes'] . "', '" . $step['delayType'] . "', '" . str_replace("'", "\'", json_encode($v)) . "', 'false', '" . $user['id'] . "')";
                                                    $taskQryExcute = mysqli_query($con, $addTask);
                                                }
                                            }
                                            
                                            $timeStampcnt++;
                                        }
                                        //Note: add blacklist company from admin panel to extension.
                                    }
                                //}
                                //curl_close($curl);
                            }
                        }
                    }
                }
                $link['status'] = 'ACTIVE';
                /* if(strpos($qryStrng,"spotlight:List(RECENT_POSITION_CHANGE),") || strpos($qryStrng,"spotlight:RECENT_POSITION_CHANGE,")){
                  $RECENT_POSITION_CHANGE_CNT = json_decode($res)->metadata->decoratedSpotlights->orderedSpotlights[1]->count;
                  $link['total'] = $RECENT_POSITION_CHANGE_CNT;
                  $link['pagesFetched'] += 1;
                  $link['start'] += PROFILES_PER_PAGE_SALESNAV;
                  $lsearch_page = "Search page";
                  addLogHistory($lsearch_page . ' ' . makeLink($link['link'], '#' . $link['pagesFetched']), $link['seqId']);
                  if($link['pagesFetched'] == 1){
                  addLogHistory("Total people found: " . $link['total'] . "  (<a target='_blank' href='https://intercom.help/lead-connect/en/articles/3727785-search-results-count-in-sequence-does-not-match-with-actual-results-on-linkedin-search-query-geography-filter-solution'>  Different Count from LinkedIn? </a>)", $link['seqId']);
                  $updateLink = mysqli_query($con, "UPDATE ext_links SET status = '" . $link['status'] . "', total='" . $link['total'] . "', pagesFetched='" . $link['pagesFetched'] . "', start='" . $link['start'] . "'  WHERE id = '".$link['id']."'");
                  }
                  }else if(strpos($qryStrng,"spotlight:List(MENTIONED_IN_THE_NEWS),") || strpos($qryStrng,"spotlight:MENTIONED_IN_THE_NEWS,")){
                  $MENTIONED_IN_THE_NEWS = json_decode($res)->metadata->decoratedSpotlights->orderedSpotlights[2]->count;
                  $link['total'] = $MENTIONED_IN_THE_NEWS;
                  $link['pagesFetched'] += 1;
                  $link['start'] += PROFILES_PER_PAGE_SALESNAV;
                  $lsearch_page = "Search page";
                  addLogHistory($lsearch_page . ' ' . makeLink($link['link'], '#' . $link['pagesFetched']), $link['seqId']);
                  if($link['pagesFetched'] == 1){
                  addLogHistory("Total people found: " . $link['total'] . "  (<a target='_blank' href='https://intercom.help/lead-connect/en/articles/3727785-search-results-count-in-sequence-does-not-match-with-actual-results-on-linkedin-search-query-geography-filter-solution'>  Different Count from LinkedIn? </a>)", $link['seqId']);
                  $updateLink = mysqli_query($con, "UPDATE ext_links SET status = '" . $link['status'] . "', total='" . $link['total'] . "', pagesFetched='" . $link['pagesFetched'] . "', start='" . $link['start'] . "'  WHERE id = '".$link['id']."'");
                  }
                  }else if(strpos($qryStrng,"spotlight:List(RECENTLY_POSTED_ON_LINKEDIN),") || strpos($qryStrng,"spotlight:RECENTLY_POSTED_ON_LINKEDIN,")){
                  $RECENTLY_POSTED_ON_LINKEDIN = json_decode($res)->metadata->decoratedSpotlights->orderedSpotlights[3]->count;
                  $link['total'] = $RECENTLY_POSTED_ON_LINKEDIN;
                  $link['pagesFetched'] += 1;
                  $link['start'] += PROFILES_PER_PAGE_SALESNAV;
                  $lsearch_page = "Search page";
                  addLogHistory($lsearch_page . ' ' . makeLink($link['link'], '#' . $link['pagesFetched']), $link['seqId']);
                  if($link['pagesFetched'] == 1){
                  addLogHistory("Total people found: " . $link['total'] . "  (<a target='_blank' href='https://intercom.help/lead-connect/en/articles/3727785-search-results-count-in-sequence-does-not-match-with-actual-results-on-linkedin-search-query-geography-filter-solution'>  Different Count from LinkedIn? </a>)", $link['seqId']);
                  $updateLink = mysqli_query($con, "UPDATE ext_links SET status = '" . $link['status'] . "', total='" . $link['total'] . "', pagesFetched='" . $link['pagesFetched'] . "', start='" . $link['start'] . "'  WHERE id = '".$link['id']."'");
                  }
                  }else if(strpos($qryStrng,"spotlight:List(COMMONALITIES),") || strpos($qryStrng,"spotlight:COMMONALITIES,")){
                  $COMMONALITIES = json_decode($res)->metadata->decoratedSpotlights->orderedSpotlights[4]->count;
                  $link['total'] = $COMMONALITIES;
                  $link['pagesFetched'] += 1;
                  $link['start'] += PROFILES_PER_PAGE_SALESNAV;
                  $lsearch_page = "Search page";
                  addLogHistory($lsearch_page . ' ' . makeLink($link['link'], '#' . $link['pagesFetched']), $link['seqId']);
                  if($link['pagesFetched'] == 1){
                  addLogHistory("Total people found: " . $link['total'] . "  (<a target='_blank' href='https://intercom.help/lead-connect/en/articles/3727785-search-results-count-in-sequence-does-not-match-with-actual-results-on-linkedin-search-query-geography-filter-solution'>  Different Count from LinkedIn? </a>)", $link['seqId']);
                  $updateLink = mysqli_query($con, "UPDATE ext_links SET status = '" . $link['status'] . "', total='" . $link['total'] . "', pagesFetched='" . $link['pagesFetched'] . "', start='" . $link['start'] . "'  WHERE id = '".$link['id']."'");
                  }
                  }else if(strpos($qryStrng,"spotlight:List(COMPANY_FOLLOW),") || strpos($qryStrng,"spotlight:COMPANY_FOLLOW,")){
                  $COMPANY_FOLLOW = json_decode($res)->metadata->decoratedSpotlights->orderedSpotlights[5]->count;
                  $link['total'] = $COMPANY_FOLLOW;
                  $link['pagesFetched'] += 1;
                  $link['start'] += PROFILES_PER_PAGE_SALESNAV;
                  $lsearch_page = "Search page";
                  addLogHistory($lsearch_page . ' ' . makeLink($link['link'], '#' . $link['pagesFetched']), $link['seqId']);
                  if($link['pagesFetched'] == 1){
                  addLogHistory("Total people found: " . $link['total'] . "  (<a target='_blank' href='https://intercom.help/lead-connect/en/articles/3727785-search-results-count-in-sequence-does-not-match-with-actual-results-on-linkedin-search-query-geography-filter-solution'>  Different Count from LinkedIn? </a>)", $link['seqId']);
                  $updateLink = mysqli_query($con, "UPDATE ext_links SET status = '" . $link['status'] . "', total='" . $link['total'] . "', pagesFetched='" . $link['pagesFetched'] . "', start='" . $link['start'] . "'  WHERE id = '".$link['id']."'");
                  }
                  }else{ */echo 'response :: ';
                //print_r(json_decode($res));
                $link['total'] = (!empty(json_decode($res)->paging->total)) ? json_decode($res)->paging->total : 0;
                $link['pagesFetched'] += 1;
                $link['start'] += PROFILES_PER_PAGE_SALESNAV;
                $lsearch_page = "Search page";
                addLogHistory($lsearch_page . ' ' . makeLink($link['link'], '#' . $link['pagesFetched']), $link['seqId'], $user['id']);
                echo "In link update";

//                if ($link['pagesFetched'] == 1) {
                addLogHistory("Total people found: " . $link['total'] . "  (<a target='_blank' href='https://intercom.help/lead-connect/en/articles/3727785-search-results-count-in-sequence-does-not-match-with-actual-results-on-linkedin-search-query-geography-filter-solution'>  Different Count from LinkedIn? </a>)", $link['seqId'], $user['id']);
                echo "In links to update";
                echo "<br>";
                echo "UPDATE ext_links SET status = '" . $link['status'] . "', total='" . $link['total'] . "', pagesFetched='" . $link['pagesFetched'] . "', start='" . $link['start'] . "'  WHERE id = '" . $link['id'] . "'";

                $updateLink = mysqli_query($con, "UPDATE ext_links SET status = '" . $link['status'] . "', total='" . $link['total'] . "',fetchStarted='" . $timeStamp . "', pagesFetched='" . $link['pagesFetched'] . "', start='" . $link['start'] . "'  WHERE id = '" . $link['id'] . "'");
//                }
                //}
            }
		  }else{
			$request=json_encode(curl_getinfo($curl));
			$request=curl_getinfo($curl);   
			$request['cookie']=$cookie;
			$request['csrf']=$csrf;
			$request['proxyip']=$proxyIp;
			$request['proxyPort']=$proxyPort;
			$request['proxyUsername']=$proxyUsername;
			$request['proxyPassword']=$proxyPassword;   
			$request=json_encode($request);
			
			$response=json_encode(array('headers'=>$headers,'body'=>$res));
			errorHandling($user['id'], $http_code,$request,$response,$link['seqId'], 0);
		  }
        }
        //curl_close($curl);
    }
}

//Ankit + Trupal
function errorHandling($userId, $http_code,$request,$response,$seqId=0,$taskId=0){
	$postdata['request']= $request;
	$postdata['text']= $response;
	$postdata['seqId']= $seqId;
	$postdata['userId']= $userId;
	$postdata['taskId']= $taskId;
	$postdata['statusCode']= $http_code;
	
	$curl = curl_init();
	curl_setopt_array($curl, array(
	CURLOPT_URL => API_ADDRESS."/error_handling.php",
	CURLOPT_POSTFIELDS => $postdata
	));
	$res = curl_exec($curl);
}
function getWebhookProfiles($post_sessionId='',$post_seqId=0){

	//header("Access-Control-Allow-Origin:*");
	//header("Access-Control-Allow-Credentials:true");
	//header("Access-Control-Allow-Methods: OPTIONS, GET, POST");
	//header("Access-Control-Allow-Headers: Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
	//include "class.phpmailer.php"; // include the class name
	//include "class.smtp.php"; // include the class name
	include "config.php";

	$session_id = '';
	if(isset($post_sessionId)){
		$session_id =$post_sessionId;
	}

	if($session_id != '' ){
		$session_id1 = base64_decode($session_id);
		$session_id1 = explode("/",$session_id1);
		//$userid = Yii::$app->session->get('userid');
	/*	$sqlmsg = "SELECT profile_link,id FROM `webhook_profiles` where user_id = '".$session_id1[0]."' AND seq_id = '".$_POST['seqId']."' AND status = '0' LIMIT 10";
		
		// ** send email for test //
		
			$mail = new PHPMailer(); // create a new object
			$mail->IsSMTP(); // enable SMTP
			$mail->SMTPDebug = 1; // debugging: 1 = errors and messages, 2 = messages only
			$mail->SMTPAuth = true; // authentication enabled
			$mail->Host = "smtp.mailgun.org";
			$mail->Username = "postmaster@mail.leadconnect.io";
			$mail->Password = "340442b84c1122db5006e74635a69187-a909d4a1-1e8c6e95";
			$mail->SMTPSecure = 'ssl'; 
			$mail->Port = 465; // or 587
			$mail->SetFrom("notifications@leadconnect.io","LeadConnect Notifications");
			$mail->Subject = "Call Webhook Api";
			$mail->IsHTML(true);
			$mail->Body = $sqlmsg;
			$mail->AddAddress('dhaval.thakor@intricare.net','');
			if(!$mail->Send()){
				echo "Mailer Error: " . $mail->ErrorInfo;
			}
			
		//** End email  **/
		
		$webhooks = $con->query("SELECT profile_link,id FROM `webhook_profiles` where user_id = '".$session_id1[0]."' AND seq_id = '".$post_seqId."' AND status = '0' LIMIT 10");

		$res = array();
		$ids = [];
		if($webhooks->num_rows>0){
			while ($r = $webhooks->fetch_assoc()){
				$res[] = utf8_encode($r['profile_link']);
				$ids[] = $r['id'];	
			}	
			$upd_pro = $con->query("UPDATE webhook_profiles SET status = '1' WHERE `id` IN (".implode(',',$ids).")");
		}
		return json_encode($res);
	}
	
}

//Ankit + Trupal
function getWebhooksFromDB($user, $sequence) {
    $csrf = $user['csrf'];
    $cookie = $user['cookie'];
    $proxyIp = $user['proxyIp'];
    $proxyPort = $user['proxyPort'];
    $proxyUsername = $user['proxyUsername'];
    $proxyPassword = $user['proxyPassword'];
	$userAgent=$user['userAgent'];
    $sessionId = base64_encode($user['id'] . '/' . $user['teamid']);
    $postFields = array("sessionId" => $sessionId, "seqId" => $sequence['id']);
	/*
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => API_ADDRESS . "/getWebhookProfiles.php",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => $postFields,
        CURLOPT_HTTPHEADER => array(
            "accept: application/json",
        )
    ));
    $resWebhooks = curl_exec($curl);
	*/
	$resWebhooks = getWebhookProfiles($postFields['sessionId'],$postFields['seqId']);
	/*
    if (curl_errno($curl)) {
        $error_msg = curl_error($curl);
    } else {
		*/
        $resWebhooksDecode = json_decode($resWebhooks);
        if (!empty($resWebhooksDecode)) {
            foreach ($resWebhooksDecode as $key => $val) {
                if (strpos($val, "sales/people/")) {
                    $lId = explode('sales/people/', $val)[1];
                    $lId = explode(',', $lId)[0];

                    $curlProfile = curl_init();
                    curl_setopt_array($curlProfile, array(
                        CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $lId . "/profileView",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
						CURLOPT_VERBOSE => 1,
						CURLOPT_HEADER => 1,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_HTTPPROXYTUNNEL => 1,
                        CURLOPT_PROXY => "$proxyIp",
                        CURLOPT_PROXYPORT => "$proxyPort",
                        CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                        CURLOPT_CUSTOMREQUEST => "GET",
                        CURLOPT_HTTPHEADER => array(
                            "cookie: $cookie",
                            "csrf-token: $csrf",
                            "x-http-method-override: GET",
                            "Host: www.linkedin.com",
                            "User-Agent: $userAgent",
                            "Accept-Language: en-US,en;q=0.5",
                            "Accept-Encoding: gzip, deflate, br",
                            "content-type: application/x-www-form-urlencoded",
                            "x-li-lang: en_US",
                            "x-restli-protocol-version: 2.0.0",
                            "Origin: https://www.linkedin.com",
                            "TE: Trailers"
                        )
                    ));

					$resProfile = curl_exec($curlProfile);//print_r($res);
					$header_size = curl_getinfo($curlProfile, CURLINFO_HEADER_SIZE);
					$headers = substr($resProfile, 0, $header_size);
					$resProfile = substr($resProfile, $header_size); 
                    if (curl_errno($curlProfile)) {
                        $error_msg = curl_error($curlProfile);
                        addLogHistory($error_msg, $seqId, $user['id'], 1);
                    } else {
						$http_code = curl_getinfo($curlProfile, CURLINFO_HTTP_CODE);
						if($http_code == 200){   
							$profile = json_decode($resProfile);
							if (!empty($profile->profile->miniProfile)) {
								$publicIdentifier = $profile->profile->miniProfile->publicIdentifier;
								$profileId = "https://www.linkedin.com/in/" . $publicIdentifier;
								sendWebhookInvitations($user, $profileId, $sequence['id']); 
							}
						}else{
							
							$request=json_encode(curl_getinfo($curlProfile));
							$request=curl_getinfo($curlProfile); 
							$request['cookie']=$cookie;
							$request['csrf']=$csrf;							
							$request['proxyip']=$proxyIp;
							$request['proxyPort']=$proxyPort;
							$request['proxyUsername']=$proxyUsername;
							$request['proxyPassword']=$proxyPassword;   
							$request=json_encode($request);
							
							$response=json_encode(array('headers'=>$headers,'body'=>$resProfile));
							errorHandling($user['id'], $http_code,$request,$response,$seqId, 0);
						}
                    }
                    curl_close($curlProfile);
                } else {
                    sendWebhookInvitations($user, $val, $sequence['id']);
                }
            }
        }
    //}
    //curl_close($curl);
}

//Ankit + Trupal
function sendWebhookInvitations($user, $profileId, $seqId) { 
    include('config.php');
    $csrf = $user['csrf'];
    $cookie = $user['cookie'];
    $proArr = explode('/', $profileId);
    $proxyIp = $user['proxyIp'];
    $proxyPort = $user['proxyPort'];
    $proxyUsername = $user['proxyUsername'];
    $proxyPassword = $user['proxyPassword'];
    $userAgent = $user['userAgent'];

    if ($proArr[3] == "in")
        $pubId = $proArr[4];

    if (!empty($pubId)) {
        $pubId = urlencode($pubId);

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $pubId . "/profileView",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
			CURLOPT_VERBOSE => 1,
			CURLOPT_HEADER => 1,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPPROXYTUNNEL => 1,
            CURLOPT_PROXY => "$proxyIp",
            CURLOPT_PROXYPORT => "$proxyPort",
            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "cookie: $cookie",
                "csrf-token: $csrf",
                "x-http-method-override: GET",
                "Host: www.linkedin.com",
                "User-Agent: $userAgent",  
                "Accept-Language: en-US,en;q=0.5",
                "Accept-Encoding: gzip, deflate, br",
                "content-type: application/x-www-form-urlencoded",
                "x-li-lang: en_US",
                "x-restli-protocol-version: 2.0.0",
                "Origin: https://www.linkedin.com",
                "TE: Trailers"
            ),
        ));

        $profileViewResponse = curl_exec($curl);
		$profileViewResponse = curl_exec($curl);//print_r($res);
		$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
		$headers = substr($profileViewResponse, 0, $header_size);
		$profileViewResponse = substr($profileViewResponse, $header_size); 
        if (curl_errno($curl)) {
            $error_msg = curl_error($curl);
            addLogHistory($error_msg, $seqId, $user['id'], 1);
			$lerr_fetch_link2 = "Error fetching link: ";
			$p2 = $lerr_fetch_link2;
			sequenceError($seqId, $p2, $user['id']);//02-07-2020
        } else {
			$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			if($http_code == 200){
            $profileView = json_decode($profileViewResponse, true);
            $profId = $profileView['positionGroupView']['profileId'];
            $memberId = explode(':', $profileView['profile']['miniProfile']['objectUrn'])[3];
            $trackingId = $profileView['profile']['miniProfile']['trackingId'];
            $personId = $memberId;
            if (!empty($trackingId) && !empty($profId)) {
                $person = array("id" => $personId, "publicIdentifier" => $pubId, "person_id" => $personId, "longId" => $profId, "trackingId" => $trackingId, "entityUrn" => "urn:li:fs_miniProfile:" . $profId,"firstName" => mb_htmlentities($profileView['profile']['miniProfile']['firstName']), "lastName" => mb_htmlentities($profileView['profile']['miniProfile']['lastName']), "objectUrn" => $profileView['profile']['miniProfile']['objectUrn']);  

                $getStep = "select id from ext_steps where seqId='" . $seqId . "' ORDER BY `order` LIMIT 1";
                $exGetStep = mysqli_query($con, $getStep);
                $step = mysqli_fetch_assoc($exGetStep);
                if (!empty($step)) {
                    $getLink = "select id from ext_links where seqId='" . $seqId . "' ORDER BY `order` DESC LIMIT 1";
                    $exGetLink = mysqli_query($con, $getLink);
                    $link = mysqli_fetch_assoc($exGetLink);
                    if (!empty($link)) {
						
						$crnttmsmp = strtotime('+1 minutes', ceil(round(microtime(true) * 1000)/1000)) * 1000;
						//round(microtime(true) * 1000)
						
                        $addTask = "INSERT INTO ext_tasks (`seqId`, `linkId`, `stepId`, `step`, `startTime`, `personId`, `status`, `type`, `delayDays`, `delayMinutes`, `isWebhook`, `person`, `triggered`, `userId`) VALUES ('" . $seqId . "', '" . $link['id'] . "', '" . $step['id'] . "', 0, '" . $crnttmsmp . "', '" . $personId . "', 'Not Started', 'Connect', '0', '1', '1', '" . str_replace("'", "\'", json_encode($person)) . "', false, '" . $user['id'] . "')";
                        if (!mysqli_query($con, $addTask)){
                            $err = "Error occured while adding webhook task.";
							addLogHistory($err, $seqId, $user['id'], 1);
						}
                    }else {
                        $err = 'Error occured while adding webhook task LinkID.';
                        addLogHistory($err, $seqId, $user['id'], 1);
                    }
                } else {
                    $err = 'Error occured while adding webhook STEP task.';
                    addLogHistory($err, $seqId, $user['id'], 1);
                }
            } else {
                $err = 'Unable to get profile ID and tracking ID in person profile';
                addLogHistory($err, $seqId, $user['id'], 1);
            }
		}else{
			$request=json_encode(curl_getinfo($curl));
			$request=curl_getinfo($curl);
			$request['cookie']=$cookie;
			$request['csrf']=$csrf;							
			$request['proxyip']=$proxyIp;
			$request['proxyPort']=$proxyPort;
			$request['proxyUsername']=$proxyUsername;
			$request['proxyPassword']=$proxyPassword;   
			$request=json_encode($request);
			$response=json_encode(array('headers'=>$headers,'body'=>$profileViewResponse));
			errorHandling($user['id'], $http_code,$request,$response,$seqId, 0);
			}
        }  
        curl_close($curl);
    } else {
        $err = 'Invalid profileId.';
        addLogHistory($err, $seqId, $user['id'], 1);
    }
}

//Ankit + Trupal
function csvProfile($user, $seqId) {
    include('config.php');
    $csrf = $user['csrf'];
    $cookie = $user['cookie'];
    $proxyIp = $user['proxyIp'];
    $proxyPort = $user['proxyPort'];
    $proxyUsername = $user['proxyUsername'];
    $proxyPassword = $user['proxyPassword'];
    $userAgent = $user['userAgent'];

    echo '<br/>LINE:' . __LINE__ . ':::In csvProfile';
    $getSequences_Csv = $con->query("SELECT *, t2.id as csvProfileId  FROM csvfiles t1 JOIN csvprofiles t2 ON t1.id = t2.csvfile_id where t1.db_seq_id=" . $seqId . " AND t2.isDeleted=0 ORDER BY t1.id ASC LIMIT 10 ");
    //$UpdateGetSequences_Csv = $con->query("UPDATE csvfiles t1 JOIN csvprofiles t2 ON t1.id = t2.csvfile_id SET t2.isDeleted = 1 where t1.db_seq_id=" . $seqId . " ORDER BY t1.id ASC LIMIT 10 ");
    if ($getSequences_Csv->num_rows > 0) {
        $currenttime = round(microtime(true) * 1000);
        $timestampCnt = 0;
		$del = [];
        while ($row_Sequences_csv = $getSequences_Csv->fetch_assoc()) {
			$del[] = $row_Sequences_csv['csvProfileId'];
            echo '<br/>LINE:' . __LINE__ . ':::within csvProfile';
            /* Normal Csv profile of linkedin salas profile */
            if ($timestampCnt == 0) {
                $currenttime_new = $currenttime;
            } else {
                $rendomTime = rand(45, 180);                
                if ($timestampCnt == 1) {
                    $currenttime_new = $currenttime + $rendomTime;
                } else {
                    $currenttime_new = $currenttime_new + $rendomTime;                            
                }
            }


            if (strpos($row_Sequences_csv['csvprofile'], 'sales/people/')) {
                $lId = explode('sales/people/', $row_Sequences_csv['csvprofile'])[1];
                $lId = explode(',', $lId)[0];
                $curlProfile = curl_init();
                curl_setopt_array($curlProfile, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $lId . "/profileView",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 30,
					CURLOPT_VERBOSE => 1,
					CURLOPT_HEADER => 1,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    )
                ));

				$resProfile = curl_exec($curlProfile);//print_r($res);
				$header_size = curl_getinfo($curlProfile, CURLINFO_HEADER_SIZE);
				$headers = substr($resProfile, 0, $header_size);
				$resProfile = substr($resProfile, $header_size); 
                echo '<br/>LINE:' . __LINE__ . ':::within csvProfile resProfile<pre>';
                print_r($resProfile);
                if (curl_errno($curlProfile)) {
                    $error_msg = curl_error($curlProfile);
                    addLogHistory($error_msg, $seqId, $user['id'], 1);
                } else {
					$http_code = curl_getinfo($curlProfile, CURLINFO_HTTP_CODE);
					if($http_code == 200){
						if(!empty($resProfile)){
							$profile = json_decode($resProfile);
							echo '<br/>LINE:' . __LINE__ . ':::within csvProfile profile<pre>';
							print_r($profile);
							if (!empty($profile->profile->miniProfile)) {
								$publicIdentifier = $profile->profile->miniProfile->publicIdentifier;
								$profileId = "https://www.linkedin.com/in/" . $publicIdentifier;
								sendCsvInvitations($user, $profileId, $seqId, $currenttime_new);
							}
						}
					}else{
						$request=json_encode(curl_getinfo($curlProfile));
							$request=curl_getinfo($curlProfile); 
							$request['cookie']=$cookie;
							$request['csrf']=$csrf;														
							$request['proxyip']=$proxyIp;
							$request['proxyPort']=$proxyPort;
							$request['proxyUsername']=$proxyUsername;
							$request['proxyPassword']=$proxyPassword;   
							$request=json_encode($request);
							$response=json_encode(array('headers'=>$headers,'body'=>$resProfile));
							errorHandling($user['id'], $http_code,$request,$response,$seqId, 0);
					}
                }
                curl_close($curlProfile);
            } else {
                /* Normal Csv Profile of linkedin */
                echo '<br/>LINE:' . __LINE__ . ':::within csvProfile profile';
                $profileId = $row_Sequences_csv['csvprofile'];
                sendCsvInvitations($user, $profileId, $seqId, $currenttime_new);
            }
            $timestampCnt++;
        }
		$deleteProfiles = $con->query("UPDATE csvprofiles SET isDeleted = 1  WHERE `id` IN (".implode(',',$del).")");
    }
}

function mb_ord($char, $encoding = 'UTF-8') {
	if ($encoding === 'UCS-4BE') {
		list(, $ord) = (strlen($char) === 4) ? @unpack('N', $char) : @unpack('n', $char);
		return $ord;
	} else {
		return mb_ord(mb_convert_encoding($char, 'UCS-4BE', $encoding), 'UCS-4BE');
	}
}

function mb_htmlentities($string, $hex = true, $encoding = 'UTF-8') {
	return preg_replace_callback('/[\x{80}-\x{10FFFF}]/u', function ($match) use ($hex) {
		return sprintf($hex ? '&#x%X;' : '&#%d;', mb_ord($match[0]));
	}, $string);
}
//Ankit + Trupal
function sendCsvInvitations($user, $profileId, $seqId, $currenttime_new) {
    include('config.php');
    echo '<br/>LINE:' . __LINE__ . ':::in sendCsvInvitations';
    $csrf = $user['csrf'];
    $cookie = $user['cookie'];
    $proArr = explode('/', $profileId);
    $proxyIp = $user['proxyIp'];
    $proxyPort = $user['proxyPort'];
    $proxyUsername = $user['proxyUsername'];
    $proxyPassword = $user['proxyPassword'];
    $userAgent = $user['userAgent'];

    if ($proArr[3] == "in")
        $pubId = $proArr[4];

    $pubId = urlencode($pubId);

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $pubId . "/profileView",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
		CURLOPT_VERBOSE => 1,
		CURLOPT_HEADER => 1,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_HTTPPROXYTUNNEL => 1,
        CURLOPT_PROXY => "$proxyIp",
        CURLOPT_PROXYPORT => "$proxyPort",
        CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
            "cookie: $cookie",
            "csrf-token: $csrf",
            "x-http-method-override: GET",
            "Host: www.linkedin.com",
            "User-Agent: $userAgent",
            "Accept-Language: en-US,en;q=0.5",
            "Accept-Encoding: gzip, deflate, br",
            "content-type: application/x-www-form-urlencoded",
            "x-li-lang: en_US",
            "x-restli-protocol-version: 2.0.0",
            "Origin: https://www.linkedin.com",
            "TE: Trailers"
        ),
    ));

	$profileViewResponse = curl_exec($curl);//print_r($res);
	$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
	$headers = substr($profileViewResponse, 0, $header_size);
	$profileViewResponse = substr($profileViewResponse, $header_size); 
    if (curl_errno($curl)) {
        $error_msg = curl_error($curl);
        addLogHistory($error_msg, $seqId, $user['id'], 1);
    } else {
	$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
	if($http_code == 200){
        $profileView = json_decode($profileViewResponse, true);
        $profId = $profileView['positionGroupView']['profileId'];
        $memberId = explode(':', $profileView['profile']['miniProfile']['objectUrn'])[3];
        $trackingId = $profileView['profile']['miniProfile']['trackingId'];
        $personId = $memberId;
        $person = array("id" => $personId, "publicIdentifier" => $pubId, "person_id" => $personId, "longId" => $profId, "trackingId" => $trackingId, "entityUrn" => "urn:li:fs_miniProfile:" . $profId, "firstName" => mb_htmlentities($profileView['profile']['miniProfile']['firstName']), "lastName" => mb_htmlentities($profileView['profile']['miniProfile']['lastName']), "objectUrn" => $profileView['profile']['miniProfile']['objectUrn']);
        $getStep = "select id from ext_steps where seqId='" . $seqId . "' ORDER BY `order` LIMIT 1";
        $exGetStep = mysqli_query($con, $getStep);
        $step = mysqli_fetch_assoc($exGetStep);
        echo '<br/>LINE:' . __LINE__ . ':::step';
        print_r($step);
        if (!empty($step)) {

            $getLink = "select id from ext_links where seqId='" . $seqId . "' ORDER BY `order` DESC LIMIT 1";
            echo '<br/>LINE:' . __LINE__ . ':::qry::' . $getLink;
            $exGetLink = mysqli_query($con, $getLink);
            $link = mysqli_fetch_assoc($exGetLink);

            if (!empty($link)) {
				
				$crnttmsmp = strtotime('+1 minutes', ceil(round(microtime(true) * 1000)/1000)) * 1000;
				//round(microtime(true) * 1000)
				
                $addTask = "INSERT INTO ext_tasks (`seqId`, `linkId`, `stepId`, `step`, `startTime`, `personId`, `status`, `type`, `delayDays`, `delayMinutes`, `isCsv`, `person`, `triggered`, `userId`) VALUES ('" . $seqId . "', '" . $link['id'] . "', '" . $step['id'] . "', 0, '" . $crnttmsmp . "', '" . $personId . "', 'Not Started', 'Connect', '0', '1', '1', '" . mysqli_real_escape_string($con, json_encode($person)) . "', 'false', '" . $user['id'] . "')";
                echo '<br/>LINE:' . __LINE__ . ':::qry::' . $addTask;
                $taskQryExcute = mysqli_query($con, $addTask);
            }
        }
	}else{
		$request=json_encode(curl_getinfo($curl));
		$request=curl_getinfo($curl); 
		$request['cookie']=$cookie;
		$request['csrf']=$csrf; 							  
		$request['proxyip']=$proxyIp;
		$request['proxyPort']=$proxyPort;
		$request['proxyUsername']=$proxyUsername;
		$request['proxyPassword']=$proxyPassword;   
		$request=json_encode($request);
		$response=json_encode(array('headers'=>$headers,'body'=>$profileViewResponse));
		errorHandling($user['id'], $http_code,$request,$response,$seqId, 0);
	}
    }
    curl_close($curl);
}

//Ankit + Trupal
function doTask($user, $sequence, $task) {
    echo '<br/>LINE::' . __LINE__ . 'In doTask';
    include('config.php');
    $lstart_task = "Starting task # ";
    $currentTimestamp = round(microtime(true) * 1000);
    addLogHistory($lstart_task . $task['id'], 0, $user['id']);
    if (!empty($task['person']) && !empty($task['personId'])) {
        if (mysqli_query($con, "UPDATE ext_tasks SET status = 'Active', timestamp='" . $currentTimestamp . "' WHERE id = '" . $task['id'] . "'")) {
            performTask($user, $sequence, $task);
        } else {
            mysqli_query($con, "UPDATE ext_tasks SET status = 'Error', timestamp='" . $currentTimestamp . "' WHERE id = '" . $task['id'] . "'");
        }
    }
}

//Ankit + Trupal
function performTask($user, $sequence, $task) {
    include('config.php');
    ini_set('max_execution_time', '0');
    $csrf = $user['csrf'];
    $cookie = $user['cookie'];
    $sessionId = base64_encode($user['id'] . '/' . $user['teamid']);
    $userEmail = mysqli_fetch_assoc(mysqli_query($con, "SELECT email from user WHERE `id` = '" . $user['id'] . "' AND `teamid` = '" . $user['teamid'] . "'"));
    $userEmail = $userEmail['email'];
    $currentStep = $task['step'] + 1;
    $currentZapWebhookUrl = '';
    $proxyIp = $user['proxyIp'];
    $proxyPort = $user['proxyPort'];
    $proxyUsername = $user['proxyUsername'];
    $proxyPassword = $user['proxyPassword'];
    $userAgent = $user['userAgent'];

    $step = mysqli_fetch_assoc(mysqli_query($con, "SELECT * from ext_steps WHERE `id` = '" . $task['stepId'] . "'"));
    if (!empty($step))
        $currentZapWebhookUrl = $step['webhooks'];

    $lbk_skip = ' is in Blacklist. Skipping.';
    $lenrol_another_seq = ' is enrolled in another sequence';
    $lenrol_another_seq1 = '. Skipping.';

    $personJson = mb_convert_encoding($task['person'], 'UTF-8', 'UTF-8');
    $personJson = preg_replace('/\"description\"\:\".*?\"\,/s', '"description":"empty",', $personJson);
    $person = json_decode($personJson);

    if (!empty($person)) {
        if (!empty($person->publicIdentifier)) {
            $person->url = "https://www.linkedin.com/in/" . $person->publicIdentifier . "/";
        } else {
            if (!empty($person->snPublicLink)) {
                $person->url = $person->snPublicLink;
            } else {
                if (!empty($person->authToken))
                    $person->url = "https://www.linkedin.com/sales/profile/" . $person->id . "," . $person->authToken . "," . $person->authType;
            }
        }

        $blackListQry = mysqli_query($con, "SELECT * from ext_blacklist WHERE `li_id` = '" . $task['personId'] . "' ORDER BY id ASC LIMIT 1");
        (!empty(($blackListQry))) ? $blacklist = mysqli_fetch_assoc($blackListQry) : $blacklist = '';
        $taskWithPersonIdQry = mysqli_query($con, "SELECT * from ext_tasks WHERE `personId` = '" . $task['personId'] . "' AND `status` IN ('Active' , 'Complete') AND seqId > 0 AND seqId != '" . $task['seqId'] . "' ORDER BY id ASC LIMIT 1");
        (!empty(($taskWithPersonIdQry))) ? $taskWithPersonId = mysqli_fetch_assoc($taskWithPersonIdQry) : $taskWithPersonId = '';
        if (!empty($blacklist)) {
            taskSkip($sequence['id'], $task['id'], makeLink($person->url, $person->fullName) . $lbk_skip, $user['id']);
        } else if (!empty($taskWithPersonId)) {
            $seq = mysqli_fetch_assoc(mysqli_query($con, "SELECT * from ext_sequences WHERE `id` = '" . $taskWithPersonId['seqId'] . "'"));
            if (!empty($seq)) {
                taskSkip($sequence['id'], $task['id'], makeLink($person->url, $person->fullName) . $lenrol_another_seq . ' "' . $seq['name'] . '"' . $lenrol_another_seq1, $user['id']);
            }
        } else {
            if ($person->fullName == '')
                $person->fullName = $person->firstName . " " . $person->lastName;

            //No use
            if ($task['salesNavigator']) {
                $salesNavArr = array();
                $salesNavArr['action'] = $task['type'];
                $salesNavArr['recipient'] = json_encode($person);
                $salesNavArr['cookie'] = $cookie;
                $salesNavArr['message'] = $step['message'];
                (!empty($userEmail)) ? $salesNavArr['email'] = $userEmail : $salesNavArr['email'] = '';
                $salesNavArr['sessionId'] = $sessionId;

                $curlUrl = API_ADDRESS . "/salesNavigatorAction";

                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => $curlUrl,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_POSTFIELDS => $salesNavArr,
                    CURLOPT_HTTPHEADER => array(
                        "accept: application/json; charset\x3dutf-8",
                        "x-requested-with: XMLHttpRequest",
                        "x-restli-protocol-version: 2.0.0"
                    )
                ));

                $res = curl_exec($curl);
                if (curl_errno($curl)) {
                    $error_msg = curl_error($curl);
                    addLogHistory($error_msg, $sequence['id'], $user['id'], 1);

                    $lsend_fail = " sending failed to ";
                    $sale_invite1 = "Seems like an invitation to ";
                    $sale_invite2 = " has already been sent.";
                    $linvitation = "Invitation";
                    $lmessage = "Message";
                    $http_status = curl_getinfo($curl, CURLINFO_HTTP_CODE);

                    if (409 == $http_status && $task['type'] == 'Connect') {
                        taskSuccess($sequence['id'], $task['id'], $sale_invite1 . makeLink($person->url, $person->fullName) . $sale_invite2, $user['id']);
                        taskSuccessNew($user['id'], $sequence['id'], $task['id'], $sale_invite1 . makeLink($person->url, $person->fullName) . $sale_invite2);
                        createNextTask($user['id'], $task);
                    } else {
                        if (403 == $http_status) {
                            taskEnrollmentsLimitReached($sequence, $task, 0, '', $user['id']);
                        } else {
                            if (401 == $http_status) {
                                taskNotAuthorised($sequence, $task);
                            } else {
                                taskError($task, ($step['type'] == 'Connect' ? $linvitation : $lmessage) . $lsend_fail . makeLink($person->url, $person->fullName) . ". " . substr($error_msg, 0, 100));
                            }
                        }
                    }
                } else {
                    if (!empty($res)) {
                        $linvitation = 'Invitation';
                        $lmessage = 'Message';
                        $lconn_err = 'Already connected with ';

                        $response = json_decode($res);
                        (!empty($response->message)) ? $message = $response->message : $message = $step['message']; //$task['message'] as per extension code but in task there is no field with name message

                        if (!empty($response->alreadyConnected)) {
                            taskSuccess($sequence['id'], $task['id'], $lconn_err . makeLink($person->url, $person->fullName), $user['id']);
                        } else {
                            taskSuccess($sequence['id'], $task['id'], '<span class="popup-target" title="' . $message . '">Sent ' . ($task['type'] == 'Connect' ? $linvitation : $lmessage) . "</span> to " . makeLink($person->url, $person->fullName), $user['id']);
                        }

                        if (!empty($response->alreadyConnected)) {
                            taskSuccessNew($user['id'], $sequence['id'], $task['id'], $lconn_err . makeLink($person->url, $person->fullName));
                        } else {
                            taskSuccessNew($user['id'], $sequence['id'], $task['id'], '<span class="popup-target" title="' . $message . '">Sent ' . ($task['type'] == 'Connect' ? $linvitation : $lmessage) . "</span> to " . makeLink($person->url, $person->fullName));
                        }
                        createNextTask($user['id'], $task);
                    }
                }
                curl_close($curl);
            }

            $logQry = mysqli_query($con, "SELECT * from ext_logs WHERE `seqId` = '" . $sequence['id'] . "' AND !text > 0 AND LOWER(`text`) NOT LIKE '%search%' ORDER BY id DESC LIMIT 1");
            (!empty($logQry)) ? $log = mysqli_fetch_assoc($logQry) : $log = '';

            $companyJSON = '';
            $profileJSON = '';
            $blackListed = 0;

            $postdataForGetLiProfileInfo = array();
            $postdataForGetLiProfileInfo['person'] = json_encode($person);
            $postdataForGetLiProfileInfo['cookie'] = $cookie;
            $postdataForGetLiProfileInfo['csrf'] = $csrf;
            $postdataForGetLiProfileInfo['from'] = 'newPerformTask';

            $curlUrlForGetLiProfileInfo = API_ADDRESS . "/getLIProfileInfoAdv.php";
            $curlGetLiProfileInfo = curl_init();
            curl_setopt_array($curlGetLiProfileInfo, array(
                CURLOPT_URL => $curlUrlForGetLiProfileInfo,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => $postdataForGetLiProfileInfo,
                CURLOPT_HTTPHEADER => array(
                    "accept: application/json"
                )
            ));

            $resForGetLiProfileInfo = curl_exec($curlGetLiProfileInfo);
            if (curl_errno($curlGetLiProfileInfo)) {
                $error_msg = curl_error($curlGetLiProfileInfo);
                addLogHistory($error_msg, $sequence['id'], $user['id'], 1);
            } else {
                try {
                    $pubid = $resForGetLiProfileInfo;
                    (!empty($userEmail)) ? $f = $userEmail : $f = "";

                    $e = json_encode($person);

                    if (!empty($person->snPublicLink))
                        $pubid = explode(',', end(explode('/', $person->profileLink)))[0];

                    $curlProfileActions = curl_init();
                    curl_setopt_array($curlProfileActions, array(
                        CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $pubid . "/profileActions",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 30,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_HTTPPROXYTUNNEL => 1,
                        CURLOPT_PROXY => "$proxyIp",
                        CURLOPT_PROXYPORT => "$proxyPort",
                        CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                        CURLOPT_CUSTOMREQUEST => "GET",
                        CURLOPT_HTTPHEADER => array(
                            "cookie: $cookie",
                            "csrf-token: $csrf",
                            "x-http-method-override: GET",
                            "Host: www.linkedin.com",
                            "User-Agent: $userAgent",
                            "Accept-Language: en-US,en;q=0.5",
                            "Accept-Encoding: gzip, deflate, br",
                            "content-type: application/x-www-form-urlencoded",
                            "x-li-lang: en_US",
                            "x-restli-protocol-version: 2.0.0",
                            "Origin: https://www.linkedin.com",
                            "TE: Trailers"
                        )
                    ));
                    $resProfileActions = curl_exec($curlProfileActions);
                    echo '<br/>LINE::' . __LINE__;
                    if (curl_errno($curlGetLiProfileInfo)) {
                        $error_msg = curl_error($curlProfileActions);
                        addLogHistory($error_msg, $sequence['id'], $user['id'], 1);
                    } else {
                        $resDataProfileActions = json_decode($resProfileActions);
                        $curlProfileView = curl_init();
                        curl_setopt_array($curlProfileView, array(
                            CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $pubid . "/profileView",
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => "",
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 30,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_HTTPPROXYTUNNEL => 1,
                            CURLOPT_PROXY => "$proxyIp",
                            CURLOPT_PROXYPORT => "$proxyPort",
                            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                            CURLOPT_CUSTOMREQUEST => "GET",
                            CURLOPT_HTTPHEADER => array(
                                "cookie: $cookie",
                                "csrf-token: $csrf",
                                "x-http-method-override: GET",
                                "Host: www.linkedin.com",
                                "User-Agent: $userAgent",
                                "Accept-Language: en-US,en;q=0.5",
                                "Accept-Encoding: gzip, deflate, br",
                                "content-type: application/x-www-form-urlencoded",
                                "x-li-lang: en_US",
                                "x-restli-protocol-version: 2.0.0",
                                "Origin: https://www.linkedin.com",
                                "TE: Trailers"
                            )
                        ));
                        $resProfileView = curl_exec($curlProfileView);
                        echo '<br/>LINE::' . __LINE__;
                        if (curl_errno($curlGetLiProfileInfo)) {
                            $error_msg = curl_error($curlProfileView);
                            addLogHistory($error_msg, $sequence['id'], $user['id'], 1);
                        } else {
                            $resDataProfileView = json_decode($resProfileView);
                            $profileArr = array();
                            (!empty($resDataProfileView->profile->firstName)) ? $profileArr["firstName"] = $resDataProfileView->profile->firstName : $profileArr["firstName"] = '';
                            (!empty($resDataProfileView->profile->lastName)) ? $profileArr["lastName"] = $resDataProfileView->profile->lastName : $profileArr["lastName"] = '';
                            (!empty($resDataProfileView->profile->headline)) ? $profileArr["occupation"] = $resDataProfileView->profile->headline : $profileArr["occupation"] = '';
                            (!empty($resDataProfileView->profile->locationName)) ? $profileArr["locationName"] = $resDataProfileView->profile->locationName : $profileArr["locationName"] = '';
                            (!empty($resDataProfileView->profile->location->basicLocation->countryCode)) ? $profileArr["countryCode"] = $resDataProfileView->profile->location->basicLocation->countryCode : $profileArr["countryCode"] = '';
                            (!empty($resDataProfileView->profile->location->basicLocation->postalCode)) ? $profileArr["postalCode"] = $resDataProfileView->profile->location->basicLocation->postalCode : $profileArr["postalCode"] = '';
                            $profileArr["companyName"] = "NA";
                            (!empty($resDataProfileView->profile->summary)) ? $profileArr["summary"] = $resDataProfileView->profile->summary : $profileArr["summary"] = '';
                            (!empty($resDataProfileView->profile->industryName)) ? $profileArr["industryName"] = $resDataProfileView->profile->industryName : $profileArr["industryName"] = '';

                            if (!empty($resDataProfileView->profile->miniProfile)) {
                                $profileArr["occupation"] = $resDataProfileView->profile->miniProfile->occupation;
                                if ($task['isCsv'] || $task['isWebhook']) {
                                    (!empty($resDataProfileView->profile->entityUrn)) ? $longId = explode(':', $resDataProfileView->profile->entityUrn)[3] : $longId = '';

                                    $personProfileArr = array();
                                    (!empty(explode(':', $resDataProfileView->profile->miniProfile->objectUrn)[3])) ? $personId = explode(':', $resDataProfileView->profile->miniProfile->objectUrn)[3] : $personId = 0;

                                    (!empty($resDataProfileView->profile->firstName)) ? $personProfileArr["firstName"] = $resDataProfileView->profile->firstName : $personProfileArr["firstName"] = '';
                                    (!empty($resDataProfileView->profile->lastName)) ? $personProfileArr["lastName"] = $resDataProfileView->profile->lastName : $personProfileArr["lastName"] = '';
                                    $personProfileArr["fullName"] = $resDataProfileView->profile->firstName . ' ' . $resDataProfileView->profile->lastName;
                                    (!empty(explode(':', $resDataProfileView->profile->miniProfile->objectUrn)[3])) ? $personProfileArr["id"] = explode(':', $resDataProfileView->profile->miniProfile->objectUrn)[3] : $personProfileArr["id"] = 0;
                                    (!empty($resDataProfileView->profile->miniProfile->publicIdentifier)) ? $personProfileArr["publicIdentifier"] = $resDataProfileView->profile->miniProfile->publicIdentifier : $personProfileArr["publicIdentifier"] = '';
                                    $personProfileArr["person_id"] = $personId;
                                    (!empty($longId)) ? $personProfileArr["longId"] = $longId : $personProfileArr["longId"] = '';
                                    $personProfileArr["url"] = $person->url;
                                    (!empty($resDataProfileView->profile->miniProfile->trackingId)) ? $personProfileArr["trackingId"] = $resDataProfileView->profile->miniProfile->trackingId : $personProfileArr["trackingId"] = '';
                                    (!empty($resDataProfileView->profile->miniProfile->occupation)) ? $personProfileArr["occupation"] = $resDataProfileView->profile->miniProfile->occupation : $personProfileArr["occupation"] = '';
                                    (!empty($resDataProfileView->profile->entityUrn)) ? $personProfileArr["entityUrn"] = $resDataProfileView->profile->entityUrn : $personProfileArr["entityUrn"] = '';

                                    $personNew = json_encode($personProfileArr);
                                    $updateTask = mysqli_query($con, "UPDATE ext_tasks SET person = '" . $personNew . "', personId='" . $personId . "' WHERE id = '" . $task['id'] . "'");

                                    $person = json_decode(mb_convert_encoding($personNew, 'UTF-8', 'UTF-8'));
                                    $e = $personNew;
                                    $task['person_id'] = $personId;
                                }
                            }

                            $companyArray = array();
                            if (!empty($resDataProfileView->positionView->elements)) {
                                $companyArray["companyId"] = 0;
                                (!empty($resDataProfileView->positionView->elements[0]->companyName)) ? $companyArray["companyName"] = $resDataProfileView->positionView->elements[0]->companyName : $companyArray["companyName"] = '';
                                (!empty($resDataProfileView->positionView->elements[0]->description)) ? $companyArray["description"] = $resDataProfileView->positionView->elements[0]->description : $companyArray["description"] = '';
                                (!empty($resDataProfileView->positionView->elements[0]->locationName)) ? $companyArray["locationName"] = $resDataProfileView->positionView->elements[0]->locationName : $companyArray["locationName"] = '';
                                $companyArray["industries"] = 'NA';
                                $companyArray["url"] = 'NA';
                                $companyArray["companyPageUrl"] = 'NA';
                                $companyArray["industries"] = 'NA';
                                $companyArray["headquarter"] = 'NA';

                                (!empty($resDataProfileView->positionView->elements[0]->companyName)) ? $profileArr["companyName"] = $resDataProfileView->positionView->elements[0]->companyName : $profileArr["companyName"] = '';
                            }

                            if (!empty($resDataProfileView->positionView->elements)) {
                                echo '<br/>LINE::' . __LINE__;
                                if (!empty($resDataProfileView->positionView->elements[0]->company)) {
                                    if (!empty($resDataProfileView->positionView->elements[0]->company->miniCompany)) {
                                        $comapnyId = explode(':', $resDataProfileView->positionView->elements[0]->company->miniCompany->entityUrn)[3];
                                        $companyArray["companyId"] = $comapnyId;
                                        $curlGetCompanyInfo = curl_init();
                                        curl_setopt_array($curlGetCompanyInfo, array(
                                            CURLOPT_URL => "https://www.linkedin.com/voyager/api/organization/companies/" . $comapnyId,
                                            CURLOPT_RETURNTRANSFER => true,
                                            CURLOPT_ENCODING => "",
                                            CURLOPT_MAXREDIRS => 10,
                                            CURLOPT_TIMEOUT => 30,
                                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                            CURLOPT_HTTPPROXYTUNNEL => 1,
                                            CURLOPT_PROXY => "$proxyIp",
                                            CURLOPT_PROXYPORT => "$proxyPort",
                                            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                                            CURLOPT_CUSTOMREQUEST => "GET",
                                            CURLOPT_HTTPHEADER => array(
                                                "cookie: $cookie",
                                                "csrf-token: $csrf",
                                                "x-http-method-override: GET",
                                                "Host: www.linkedin.com",
                                                "User-Agent: $userAgent",
                                                "Accept-Language: en-US,en;q=0.5",
                                                "Accept-Encoding: gzip, deflate, br",
                                                "content-type: application/x-www-form-urlencoded",
                                                "x-li-lang: en_US",
                                                 "x-restli-protocol-version: 2.0.0",
                                                "Origin: https://www.linkedin.com",
                                                "TE: Trailers"
                                            )
                                        ));
                                        $resCompanyInfo = curl_exec($curlGetCompanyInfo);
                                        if (curl_errno($curlGetCompanyInfo)) {
                                            $error_msg = curl_error($curlGetCompanyInfo);
                                            addLogHistory($error_msg, $sequence['id'], $user['id'], 1);
                                        } else {
                                            $resCompanyData = json_decode($resCompanyInfo);
                                            (!empty($resCompanyData->industries)) ? $companyArray["industries"] = json_encode($resCompanyData->industries) : $companyArray["industries"] = '';
                                            (!empty($resCompanyData->url)) ? $companyArray["url"] = $resCompanyData->url : $companyArray["url"] = '';
                                            (!empty($resCompanyData->companyPageUrl)) ? $companyArray["companyPageUrl"] = $resCompanyData->companyPageUrl : $companyArray["companyPageUrl"] = '';

                                            (!empty($resCompanyData->companyPageUrl)) ? $person->companyPageUrl = $resCompanyData->companyPageUrl : $person->companyPageUrl = '';
                                            (!empty($resCompanyData->url)) ? $person->companyPage = $resCompanyData->url : $person->companyPage = '';
                                            (!empty($resCompanyData->staffCount)) ? $person->staffCount = $resCompanyData->staffCount : $person->staffCount = '';
                                            (!empty($resCompanyData->description)) ? $person->description = $resCompanyData->description : $person->description = '';
                                            (!empty($resCompanyData->industries)) ? $person->industries = json_encode($resCompanyData->industries) : $person->industries = '';
                                            (!empty($resCompanyData->included)) ? $person->included = $resCompanyData->included : $person->included = '';
                                            //(!empty($resCompanyData->specialities))?$person->specialities=json_encode($resCompanyData->specialities):$person->specialities=='';
                                            (!empty($resCompanyData->companyPageUrl)) ? $person->companydomain = $resCompanyData->companyPageUrl : $person->companydomain = '';

                                            if (!empty($resCompanyData->universalName)) {
                                                $companyArray["universalName"] = $resCompanyData->universalName;
                                                $blacklistCompanyQry = mysqli_query($con, "SELECT * from ext_blacklistcompany WHERE `companyId` = '" . $companyArray["universalName"] . "' OR `companyId` = '" . $companyArray["companyId"] . "' AND userId = '" . $user['id'] . "' ORDER BY id ASC LIMIT 1");
                                                if (!empty($blacklistCompanyQry)) {
                                                    $blacklistCompany = mysqli_fetch_assoc($blacklistCompanyQry);
                                                    if (!empty($blacklistCompany)) {
                                                        taskSkip($sequence['id'], $task['id'], makeLink($person->url, $person->fullName) . " is in Company Blacklist( " . makeLink("https://www.linkedin.com/company/" . $blacklistCompany['companyId'], $blacklistCompany['companyName']) . " ). Skipping.", $user['id']);
                                                        $blackListed = 1;
                                                        return;
                                                    }
                                                }
                                            }
                                            if (!empty($resCompanyInfo->included)) {
                                                foreach ($resCompanyInfo->included as $included) {
                                                    if (!empty($included->headquarter))
                                                        $companyArray["headquarter"] = json_encode($included);
                                                }
                                            }
                                        }
                                        curl_close($curlGetCompanyInfo);
                                    }
                                }
                            }

                            $curlNetworkInfo = curl_init();
                            curl_setopt_array($curlNetworkInfo, array(
                                CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $pubid . "/networkinfo",
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => "",
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 30,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_HTTPPROXYTUNNEL => 1,
                                CURLOPT_PROXY => "$proxyIp",
                                CURLOPT_PROXYPORT => "$proxyPort",
                                CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                                CURLOPT_CUSTOMREQUEST => "GET",
                                CURLOPT_HTTPHEADER => array(
                                    "cookie: $cookie",
                                    "csrf-token: $csrf",
                                    "x-http-method-override: GET",
                                    "Host: www.linkedin.com",
                                    "User-Agent: $userAgent",
                                    "Accept-Language: en-US,en;q=0.5",
                                    "Accept-Encoding: gzip, deflate, br",
                                    "content-type: application/x-www-form-urlencoded",
                                    "x-li-lang: en_US",
                                    "x-restli-protocol-version: 2.0.0",
                                    "Origin: https://www.linkedin.com",
                                    "TE: Trailers"
                                )
                            ));
                            $resNetworkInfo = curl_exec($curlNetworkInfo);
                            echo '<br/>LINE::' . __LINE__;
                            if (curl_errno($curlNetworkInfo)) {
                                $error_msg = curl_error($curlNetworkInfo);
                                addLogHistory($error_msg, $sequence['id'], $user['id'], 1);
                            } else {
                                $resDataNetworkInfo = json_decode($resNetworkInfo);
                                $degree = $resDataNetworkInfo->distance->value;
                                $person->degree = $degree;
                                (!empty($resDataProfileView->profile->miniProfile)) ? $e = $resDataProfileView->profile : $e = '';
                                (!empty($e->longId)) ? $e->longId = $e->longId : $e->longId = explode(':', $e->entityUrn)[3];
                                $e->connected = "DISTANCE_1";
                                ($e->connected == $resDataNetworkInfo->distance->value) ? $e->connected = 1 : $e->connected = 0;
                                (!empty($resDataProfileActions->primaryAction->action)) ? $actn = $resDataProfileActions->primaryAction->action : $actn = '';
                                if (!empty($actn)) {
                                    $actn = (array) $actn;
                                    (!empty($actn['com.linkedin.voyager.identity.profile.actions.InvitationPending'])) ? $e->invitationPending = 1 : $e->invitationPending = 0;
                                }
                                (!empty($e->invitationPending)) ? $e->invitationPending = $e->invitationPending : $e->invitationPending = 0;
                                $e->trackingId = $resDataProfileView->profile->miniProfile->trackingId;
                                $eduArr = array();
                                $expArr = array();
                                if (!empty($resDataProfileView->educationView->elements)) {
                                    foreach ($resDataProfileView->educationView->elements as $ele) {
                                        if (!empty($ele->degreeName))
                                            array_push($eduArr, array('degree_institution' => $ele->degreeName, 'educations_details' => $ele));
                                    }
                                }
                                if (!empty($resDataProfileView->positionView->elements)) {
                                    foreach ($resDataProfileView->positionView->elements as $ele) {
                                        if (!empty($ele->companyName))
                                            array_push($expArr, array('company' => $ele->companyName, 'companydesc' => $ele));
                                    }
                                }
                                $e->educations = $eduArr;
                                $e->experiences = $expArr;
                                (!empty($resDataProfileView->profile->locationName)) ? $e->locationName = $resDataProfileView->profile->locationName : $e->locationName = '';

                                $msg = substituteTags($user['id'], (!empty($step['message'])) ? $step['message'] : "", json_encode($e));
                                //$msg = (!empty($step['message']))?$step['message']:"";
                                $zcMsg = '';
                                $zcArr = explode(':', $msg);
                                $zcMsg = $zcArr[0];

                                if ($userEmail != 'hugo.yuk@gmail.com')
                                    $body = "{\"trackingId\":\"" . $person->trackingId . "\",\"message\":" . json_encode($msg) . ",\"invitations\":[],\"excludeInvitations\":[],\"invitee\":{\"com.linkedin.voyager.growth.invitation.InviteeProfile\":{\"profileId\":\"" . $person->longId . "\"}}}";
                                else
                                    $body = "{\"emberEntityName\":\"growth/invitation/norm-invitation\",\"trackingId\":\"" . $person->trackingId . "\",\"message\":" + json_encode($msg) . ",\"invitee\":{\"com.linkedin.voyager.growth.invitation.InviteeProfile\":{\"profileId\":\"" . $person->longId . "\"}}}";

                                if ($blackListed == 0) {
                                    if (empty($e->fullName))
                                        $e->fullName = $e->firstName . " " . $e->lastName;

                                    $lconn_err = "Already connected with ";
                                    $lconn_msg = "Connect. Just test, did not send invitation to ";
                                    $linv_already_sent1 = "Invitation to ";
                                    $linv_already_sent2 = " has already been sent, pending.";
                                    echo '<br/>LINE::' . __LINE__;
                                    if ($task['type'] == 'Connect') {
                                        echo '<br/>LINE::' . __LINE__;
                                        if ($e->connected) {
                                            taskSuccess($sequence['id'], $task['id'], $lconn_err . makeLink($person->url, $e->fullName), $user['id']);
                                            taskSuccessNew($user['id'], $sequence['id'], $task['id'], $lconn_err . makeLink($person->url, $e->fullName));
                                        } else {
                                            if ($e->invitationPending) {
                                                taskSuccess($sequence['id'], $task['id'], $linv_already_sent1 . makeLink($person->url, $e->fullName) . $linv_already_sent2, $user['id']);
                                                taskSuccessNew($user['id'], $sequence['id'], $task['id'], $linv_already_sent1 . makeLink($person->url, $e->fullName) . $linv_already_sent2);
                                                createNextTask($user['id'], $task);
                                            } else {
                                                if (DONT_SEND_MESSAGES) {
                                                    taskSuccess($sequence['id'], $task['id'], $lconn_msg . makeLink($person->url, $e->fullName) . ".", $user['id']);
                                                    taskSuccessNew($user['id'], $sequence['id'], $task['id'], $lconn_msg . makeLink($e->url, $person->fullName) . ".");
                                                    createNextTask($user['id'], $task);
                                                } else {
                                                    $sendInFrontEnd = 0;
                                                    if ($sendInFrontEnd) {
                                                        //Send in front end, not needed anymore. Old functionality.
                                                        openInviteTab($sequence, $task, $pubid, $e, $msg);
                                                    } else {
                                                        $curlInvitation = curl_init();
                                                        curl_setopt_array($curlInvitation, array(
                                                            CURLOPT_URL => "https://www.linkedin.com/voyager/api/growth/normInvitations",
                                                            CURLOPT_RETURNTRANSFER => true,
                                                            CURLOPT_ENCODING => "",
                                                            CURLOPT_MAXREDIRS => 10,
                                                            CURLOPT_TIMEOUT => 30,
                                                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                                            CURLOPT_HTTPPROXYTUNNEL => 1,
                                                            CURLOPT_PROXY => "$proxyIp",
                                                            CURLOPT_PROXYPORT => "$proxyPort",
                                                            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                                                            CURLOPT_CUSTOMREQUEST => "POST",
                                                            CURLOPT_POSTFIELDS => $body,
                                                            CURLOPT_VERBOSE => 1,
                                                            CURLOPT_HEADER => 1,
                                                            CURLOPT_HTTPHEADER => array(
                                                                "cookie: $cookie",
                                                                "csrf-token: $csrf",
                                                                ":authority:www.linkedin.com",
                                                                "Accept-Language: en-US,en;q=0.5",
                                                                "Accept-Encoding: gzip, deflate, br",
                                                                "x-li-lang: en_US",
																"user-agent: $userAgent",
                                                                "x-restli-protocol-version: 2.0.0"
                                                            )
                                                        ));
                                                        $resInvitation = curl_exec($curlInvitation);
                                                        if (curl_errno($curlInvitation)) {
                                                            $error_msg = curl_error($curlInvitation);
                                                            addLogHistory($error_msg, $sequence['id'], $user['id'], 1);

                                                            if (empty($e->fullName))
                                                                $e->fullName = $e->firstName . " " . $e->lastName;

                                                            $linv_fail = "Invitation sending failed to ";
                                                            $lseems_like = "Seems like ";
                                                            $lan_invit1 = " an invitation";
                                                            $lan_invit2 = " to ";
                                                            $sale_invite2 = " has already been sent.";
                                                            $lmsg_text = "Message. Just test, did not send message to ";

                                                            $http_status = curl_getinfo($curlInvitation, CURLINFO_HTTP_CODE);

                                                            if ($http_status == 409 && $http_status == 406) {
                                                                taskSuccess($sequence['id'], $task['id'], $lseems_like . ' <span class="popup-target" title="' . $msg . '">' . $lan_invit1 . '</span> ' . $lan_invit2 . makeLink($person->url, $e->fullName) . $sale_invite2, $user['id']);
                                                                taskSuccessNew($user['id'], $sequence['id'], $task['id'], $lseems_like . ' <span class="popup-target" title="' . $msg . '">' + $lan_invit1 . '</span> ' . $lan_invit2 . makeLink($person->url, $e->fullName) + $sale_invite2);
                                                                createNextTask($user['id'], $task);
                                                            } else {
                                                                if (403 == $http_status) {
                                                                    taskEnrollmentsLimitReached($sequence, $task, WAIT_SECONDS, '', $user['id']);
                                                                } else {
                                                                    if (401 == $http_status) {
                                                                        taskNotAuthorised($sequence, $task);
                                                                    } else {
                                                                        if (0 == $http_status) {
                                                                            taskNetworkError($sequence, $task, $user['id']);
                                                                        } else {
                                                                            taskError($task, $linv_fail . makeLink($person->url, $person->fullName) . ". " . substr($error_msg, 0, 100));
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        } else {
                                                            $headerSize = curl_getinfo($curlInvitation, CURLINFO_HEADER_SIZE);
                                                            $header = substr($resInvitation, 0, $headerSize);
                                                            $headersArr = explode("\r\n", $header);
                                                            $headersArr = array_filter($headersArr);
                                                            $headears = array();
                                                            foreach ($headersArr as $key => $val) {
                                                                $headerVal = explode(':', $val);
                                                                if (count($headerVal) == 2)
                                                                    $headears[$headerVal[0]] = trim($headerVal[1]);
                                                            }
                                                            (!empty($headears['X-RestLi-Id'])) ? $requestId = $headears['X-RestLi-Id'] : $requestId = '';

                                                            if (empty($e->fullName))
                                                                $e->fullName = $e->firstName . " " . $e->lastName;

                                                            $lsent_invite1 = "Sent invitation ";
                                                            $lsent_invite2 = "to ";

                                                            taskSuccess($sequence['id'], $task['id'], '<span class="popup-target" title="' . $msg . '">' . $lsent_invite1 . '</span> ' . $lsent_invite2 . ' ' . makeLink($person->url, $e->fullName), $user['id']);
                                                            taskSuccessNew($user['id'], $sequence['id'], $task['id'], '<span class="popup-target" title="' . $msg . '">' . $lsent_invite1 . '</span> ' . $lsent_invite2 . ' ' . makeLink($person->url, $e->fullName));
                                                            createNextTask($user['id'], $task, $requestId);

                                                            $seqQry = mysqli_query($con, "SELECT * from ext_sequences WHERE `id` = '" . $task['seqId'] . "'");
                                                            if (!empty($seqQry)) {
                                                                $seq = mysqli_fetch_assoc($seqQry);
                                                                if (!empty($seq)) {
                                                                    (!empty($seq['serverDbId'])) ? $serverDbId = $seq['serverDbId'] : $serverDbId = 0;
                                                                    $seqName = $seq['name'];
                                                                    $zaptouse = $seq['zaptouse'];
                                                                    $zapireStatus = $seq['zapireStatus'];

                                                                    $postdataForSendLIInvitationNew = array();
                                                                    $postdataForSendLIInvitationNew['serverDbId'] = $serverDbId;
                                                                    $postdataForSendLIInvitationNew['seqName'] = $seqName;
                                                                    $postdataForSendLIInvitationNew['person'] = json_encode($person);
                                                                    $postdataForSendLIInvitationNew['sessionId'] = $sessionId;
                                                                    $postdataForSendLIInvitationNew['profileActions'] = $resProfileActions;
                                                                    $postdataForSendLIInvitationNew['profileView'] = $resProfileView;
                                                                    $postdataForSendLIInvitationNew['networkinfo'] = $resNetworkInfo;
                                                                    $postdataForSendLIInvitationNew['companyJSON'] = json_encode($companyArray);
                                                                    $postdataForSendLIInvitationNew['profileJSON'] = json_encode($profileArr);
                                                                    $postdataForSendLIInvitationNew['from'] = 'newPerformTask';

                                                                    $curlUrlForSendLIInvitationNew = API_ADDRESS . "/sendLIInvitationNew.php";
                                                                    $curlSendLIInvitationNew = curl_init();
                                                                    curl_setopt_array($curlSendLIInvitationNew, array(
                                                                        CURLOPT_URL => $curlUrlForSendLIInvitationNew,
                                                                        CURLOPT_RETURNTRANSFER => true,
                                                                        CURLOPT_ENCODING => "",
                                                                        CURLOPT_MAXREDIRS => 10,
                                                                        CURLOPT_TIMEOUT => 30,
                                                                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                                                        CURLOPT_CUSTOMREQUEST => "POST",
                                                                        CURLOPT_POSTFIELDS => $postdataForSendLIInvitationNew,
                                                                        CURLOPT_HTTPHEADER => array(
                                                                            "accept: application/json"
                                                                        )
                                                                    ));

                                                                    $resForSendLIInvitationNew = curl_exec($curlSendLIInvitationNew);
                                                                    if (curl_errno($curlSendLIInvitationNew)) {
                                                                        $error_msg = curl_error($curlSendLIInvitationNew);
                                                                        addLogHistory($error_msg, $sequence['id'], $user['id'], 1);
                                                                    } else {
                                                                        taskSuccessNew($user['id'], $sequence['id'], $task['id'], '<span class="popup-target" title="' . $msg . '">Sent invitation</span> to ' . makeLink($person->url, $e->fullName));

                                                                        if ($zapireStatus == 'true' && strpos($zaptouse, "Invitationsent")) {
                                                                            $task['seq_name'] = $seqName;
                                                                            $task['person'] = json_encode($person);
                                                                            $postdataZap = array();
                                                                            $postdataZap['profiledata'] = json_encode($task);
                                                                            $postdataZap['sessionId'] = $sessionId;
                                                                            $postdataZap['type'] = 'invitationsent';
                                                                            $postdataZap['from'] = 'newPerformTask';

                                                                            $curlUrlForZap = API_ADDRESS . "/zap.php";
                                                                            $curlZap = curl_init();
                                                                            curl_setopt_array($curlZap, array(
                                                                                CURLOPT_URL => $curlUrlForZap,
                                                                                CURLOPT_RETURNTRANSFER => true,
                                                                                CURLOPT_ENCODING => "",
                                                                                CURLOPT_MAXREDIRS => 10,
                                                                                CURLOPT_TIMEOUT => 30,
                                                                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                                                                CURLOPT_CUSTOMREQUEST => "POST",
                                                                                CURLOPT_POSTFIELDS => $postdataZap,
                                                                                CURLOPT_HTTPHEADER => array(
                                                                                    "accept: application/json"
                                                                                )
                                                                            ));
                                                                            $resZap = curl_exec($curlZap);
                                                                            if (curl_errno($curlZap)) {
                                                                                $error_msg = curl_error($curlZap);
                                                                                addLogHistory($error_msg, $sequence['id'], $user['id'], 1);
                                                                            } else {
                                                                                
                                                                            }
                                                                            curl_close($curlZap);
                                                                        }
                                                                    }
                                                                    curl_close($curlSendLIInvitationNew);
                                                                }
                                                            }
                                                        }
                                                        curl_close($curlInvitation);
                                                    }
                                                }
                                            }
                                        }
                                    } else {
                                        echo '<br/>LINE::' . __LINE__;
                                        if ($e->connected) {
                                            echo '<br/>LINE::' . __LINE__;
                                            if (DONT_SEND_MESSAGES) {
                                                $lmsg_text = "Message. Just test, did not send message to ";
                                                taskSuccess($sequence['id'], $task['id'], $lmsg_text . makeLink($person->url, $e->fullName) . ".", $user['id']);
                                                taskSuccessNew($user['id'], $sequence['id'], $task['id'], $lmsg_text . makeLink($person->url, $e->fullName) . ".");
                                                createNextTask($user['id'], $task);
                                            } else {
                                                echo '<br/>LINE::' . __LINE__;
                                                $askMsgConfQry = mysqli_query($con, "SELECT askMsgConf from user WHERE `id` = '" . $user['id'] . "'");
                                                $askMsgConf = mysqli_fetch_assoc($askMsgConfQry);
                                                if (!empty($askMsgConf['askMsgConf'])) {
                                                    echo '<br/>LINE::' . __LINE__;
                                                    $postDataMsgConf = array();
                                                    $postDataMsgConf['message'] = json_encode($msg);
                                                    $postDataMsgConf['sessionId'] = $sessionId;
                                                    $postDataMsgConf['recipient'] = json_encode($e);
                                                    $postDataMsgConf['email'] = $userEmail;
                                                    $postDataMsgConf['cookie'] = $cookie;
                                                    $postDataMsgConf['csrf'] = $csrf;
                                                    $postDataMsgConf['from'] = 'newPerformTask';

                                                    $curlUrlForMsgConf = API_ADDRESS . '/storeLIMessage.php';
                                                    $curlMsgConf = curl_init();
                                                    curl_setopt_array($curlMsgConf, array(
                                                        CURLOPT_URL => $curlUrlForMsgConf,
                                                        CURLOPT_RETURNTRANSFER => true,
                                                        CURLOPT_ENCODING => "",
                                                        CURLOPT_MAXREDIRS => 10,
                                                        CURLOPT_TIMEOUT => 30,
                                                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                                        CURLOPT_CUSTOMREQUEST => "POST",
                                                        CURLOPT_POSTFIELDS => $postDataMsgConf
                                                    ));
                                                    $resMsgConf = curl_exec($curlMsgConf);
                                                    if (curl_errno($curlMsgConf)) {
                                                        $error_msg = curl_error($curlMsgConf);
                                                        addLogHistory($error_msg, $sequence['id'], $user['id'], 1);

                                                        $lmsg_fail = " Failed to send a message to ";
                                                        $lmsg_invalid_req = "Invalid Request";

                                                        $http_status = curl_getinfo($curlInvitation, CURLINFO_HTTP_CODE);
                                                        if (403 == $http_status) {
                                                            taskEnrollmentsLimitReached($sequence, $task, WAIT_SECONDS, $lmsg_invalid_req, $user['id']);
                                                        } else {
                                                            if (401 == $http_status) {
                                                                taskNotAuthorised($sequence, $task);
                                                            } else {
                                                                if (0 == $http_status) {
                                                                    taskNetworkError($sequence, $task, $user['id']);
                                                                } else {
                                                                    taskError($task, $lmsg_fail . makeLink($person->url, $person->fullName) . ". ");
                                                                }
                                                            }
                                                        }
                                                    } else {
                                                        if (empty($e->fullName))
                                                            $e->fullName = $e->firstName . " " . $e->lastName;

                                                        $lmsg_sent = "Message sent";
                                                        taskSuccess($sequence['id'], $task['id'], '<span class="popup-target" title="' . $msg . '">' . $lmsg_sent . "</span> to " . makeLink($person->url, $e->fullName) . ".", $user['id']);
                                                        taskSuccessNew($user['id'], $sequence['id'], $task['id'], '<span class="popup-target" title="' . $msg . '">' . $lmsg_sent . "</span> to " . makeLink($person->url, $e->fullName) . ".");
                                                        createNextTask($user['id'], $task);
                                                    }
                                                    curl_close($curlMsgConf);
                                                }else {
                                                    echo '<br/>LINE::' . __LINE__;
                                                    if ($zcMsg == 'Zapier') {
                                                        echo '<br/>LINE::' . __LINE__;
                                                        $postDataZapSteps = array();

                                                        $profileData = array('objectUrn' => $e->miniProfile->objectUrn, 'firstName' => $e->miniProfile->firstName, 'lastName' => $e->miniProfile->lastName, 'occupation' => $e->miniProfile->occupation, 'publicIdentifier' => $e->miniProfile->publicIdentifier, 'url' => $person->url, 'id' => $person->id, 'experiences' => array(), 'fullName' => $e->fullName);

                                                        $postDataZapSteps['profiledata'] = json_encode($profileData);
                                                        $postDataZapSteps['sessionId'] = $sessionId;
                                                        $postDataZapSteps['current_step'] = $currentStep;
                                                        $postDataZapSteps['current_zap_webhook_url'] = $currentZapWebhookUrl;
                                                        $postDataZapSteps['from'] = 'newPerformTask';
                                                        $postDataZapSteps['seqname'] = $sequence['name'];

                                                        $curlUrlForZapSteps = API_ADDRESS . '/steps_zap.php';
                                                        $curlZapSteps = curl_init();
                                                        curl_setopt_array($curlZapSteps, array(
                                                            CURLOPT_URL => $curlUrlForZapSteps,
                                                            CURLOPT_RETURNTRANSFER => true,
                                                            CURLOPT_ENCODING => "",
                                                            CURLOPT_MAXREDIRS => 10,
                                                            CURLOPT_TIMEOUT => 30,
                                                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                                            CURLOPT_CUSTOMREQUEST => "POST",
                                                            CURLOPT_POSTFIELDS => $postDataZapSteps
                                                        ));
                                                        $resZapSteps = curl_exec($curlZapSteps);
                                                        if (curl_errno($curlZapSteps)) {
                                                            $error_msg = curl_error($curlZapSteps);
                                                            addLogHistory($error_msg, $sequence['id'], $user['id'], 1);
                                                        } else {
                                                            taskSuccess($sequence['id'], $task['id'], '<span class="popup-target" title= Data sent to Zapier >' . " Data sent to Zapier </span> of " . makeLink($person->url, $e->fullName) . ".", $user['id']);
                                                            taskSuccessNew($user['id'], $sequence['id'], $task['id'], '<span class="popup-target" title= Data sent to Zapier >' . " Data sent to Zapier </span> of " . makeLink($person->url, $e->fullName) . ".");
                                                            createNextTask($user['id'], $task);
                                                        }
                                                    } else {
                                                        echo '<br/>LINE::' . __LINE__;
                                                        $curlMessage = curl_init();
                                                        curl_setopt_array($curlMessage, array(
                                                            CURLOPT_URL => "https://www.linkedin.com/voyager/api/messaging/conversations?action=create",
                                                            CURLOPT_RETURNTRANSFER => true,
                                                            CURLOPT_ENCODING => "",
                                                            CURLOPT_MAXREDIRS => 10,
                                                            CURLOPT_TIMEOUT => 30,
                                                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                                            CURLOPT_HTTPPROXYTUNNEL => 1,
                                                            CURLOPT_PROXY => "$proxyIp",
                                                            CURLOPT_PROXYPORT => "$proxyPort",
                                                            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                                                            CURLOPT_CUSTOMREQUEST => "POST",
                                                            CURLOPT_POSTFIELDS => "{\"conversationCreate\":{\"eventCreate\":{\"value\":{\"com.linkedin.voyager.messaging.create.MessageCreate\":{\"body\":" . json_encode($msg) . ",\"attachments\":[]}}},\"recipients\":[\"" . $e->longId . "\"],\"subtype\":\"MEMBER_TO_MEMBER\"},\"keyVersion\":\"LEGACY_INBOX\"}",
                                                            CURLOPT_HTTPHEADER => array(
                                                                "cookie: $cookie",
                                                                "csrf-token: $csrf",
                                                                ":authority:www.linkedin.com",
                                                                "Accept-Language: en-US,en;q=0.5",
                                                                "Accept-Encoding: gzip, deflate, br",
                                                                "x-li-lang: en_US",
                                                                "user-agent: $userAgent",
                                                                "x-restli-protocol-version: 2.0.0"
                                                            )
                                                        ));
                                                        $resMessage = curl_exec($curlMessage);
                                                        if (curl_errno($curlMessage)) {
                                                            $error_msg = curl_error($curlMessage);
                                                            addLogHistory($error_msg, $sequence['id'], $user['id'], 1);
                                                        } else {
                                                            echo '<br/>LINE::' . __LINE__;
                                                            $lmsg_sent = "Message sent";
                                                            $publicId = $e->miniProfile->publicIdentifier;
                                                            if (($sequence['msgSeq'] == '1') && ($task['step'] == '0')) {
                                                                $SeqNameF = $sequence['name'];
                                                                $CompanyDomainF = $person->companydomain;
                                                                firstDegreeData($user, $publicId, $SeqNameF, $CompanyDomainF);
                                                            }
                                                            $e->companydomain = $person->companydomain;
                                                            $e->seq_name = $sequence['name'];
                                                            $e->seq_id = $sequence['id'];
                                                            $e->msg_sent = json_encode($msg);
                                                            if ($sequence['zapireStatus'] == 'true' && strpos($sequence['zaptouse'], "Response")) {
                                                                $postdataZap = array();
                                                                $postdataZap['profiledata'] = json_encode($e);
                                                                $postdataZap['sessionId'] = $sessionId;
                                                                $postdataZap['type'] = '1st Degree Message';
                                                                $postdataZap['from'] = 'newPerformTask';

                                                                $curlUrlForZap = API_ADDRESS . '/zap.php';
                                                                $curlZap = curl_init();
                                                                curl_setopt_array($curlZap, array(
                                                                    CURLOPT_URL => $curlUrlForZap,
                                                                    CURLOPT_RETURNTRANSFER => true,
                                                                    CURLOPT_ENCODING => "",
                                                                    CURLOPT_MAXREDIRS => 10,
                                                                    CURLOPT_TIMEOUT => 30,
                                                                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                                                    CURLOPT_CUSTOMREQUEST => "POST",
                                                                    CURLOPT_POSTFIELDS => $postdataZap,
                                                                    CURLOPT_HTTPHEADER => array(
                                                                        "accept: application/json"
                                                                    )
                                                                ));
                                                                $resZap = curl_exec($curlZap);
                                                                if (curl_errno($curlZap)) {
                                                                    $error_msg = curl_error($curlZap);
                                                                    addLogHistory($error_msg, $sequence['id'], $user['id'], 1);

                                                                    $lmsg_fail = " Failed to send a message to ";
                                                                    $lmsg_invalid_req = 'Error';

                                                                    $http_status = curl_getinfo($curlInvitation, CURLINFO_HTTP_CODE);
                                                                    if (403 == $http_status) {
                                                                        taskEnrollmentsLimitReached($sequence, $task, WAIT_SECONDS, $lmsg_invalid_req, $user['id']);
                                                                    } else {
                                                                        if (401 == $http_status) {
                                                                            taskNotAuthorised($sequence, $task);
                                                                        } else {
                                                                            if (0 == $http_status) {
                                                                                taskNetworkError($sequence, $task, $user['id']);
                                                                            } else {
                                                                                taskError($task, $lmsg_fail . makeLink($person->url, $person->fullName) . ". ");
                                                                            }
                                                                        }
                                                                    }
                                                                } else {
                                                                    
                                                                }
                                                                curl_close($curlZap);
                                                            }
                                                            if (empty($e->fullName))
                                                                $e->fullName = $e->firstName . " " . $e->lastName;

                                                            $lmsg_sent = "Message sent";
                                                            taskSuccess($sequence['id'], $task['id'], '<span class="popup-target" title="' . $msg . '">' . $lmsg_sent . "</span> to " . makeLink($person->url, $e->fullName) . ".", $user['id']);
                                                            taskSuccessNew($user['id'], $sequence['id'], $task['id'], '<span class="popup-target" title="' . $msg . '">' . $lmsg_sent . "</span> to " . makeLink($person->url, $e->fullName) . ".");
                                                            createNextTask($user['id'], $task);
                                                        }
                                                    }
                                                }
                                            }
                                        }else {
                                            $lmsg_not_con = "Message. Not connected with ";
                                            $lskipping = ", skipping.";
                                            $linvit_for = "Invitation for ";
                                            $lwithdrawn = ",is Withdrawn.";
                                            taskSkip($sequence['id'], $task['id'], $lmsg_not_con . makeLink($person->url, $e->fullName) . $lskipping, $user['id']);
                                            requestWithdraw($user, $task['id'], $sequence['id'], $linvit_for . makeLink($person->url, $e->fullName) . $lwithdrawn);
                                        }
                                    }
                                }
                            }
                            curl_close($curlNetworkInfo);
                        }
                        curl_close($curlProfileView);
                    }
                    curl_close($curlProfileActions);
                } catch (Exception $e) {
                    $lerr_proc = "Error processing ";
                    taskSkip($sequence['id'], $task['id'], $lerr_proc . makeLink($person->url, $e->fullName) . ". " . $e->getMessage(), $user['id']);
                }
            }
        }
    } else {
        addLogHistory('Person not found.', $sequence['id'], $user['id'], 1);
    }
}

//Ankit + Trupal
function taskNetworkError($sequence, $task, $userId) {
    include('config.php');
    $lnet_sts_err1 = 'Task #';
    $lnet_sts_err2 = ' network error. Please check';
    $lnet_sts_err3 = 'the status page';
    $lnet_sts_err4 = ' network error.';
    $timeStamp = round(microtime(true) * 1000);

    if ("network" != LAST_ERROR) {
        addLogHistory($lnet_sts_err1 . $task['id'] . $lnet_sts_err2 . ' <a target="_blank" href="' . API_ADDRESS . 'status">' . $lnet_sts_err3 . '</a>.', $sequence['id'], $userId);
    } else {
        addLogHistory($lnet_sts_err1 . $task['id'] . $lnet_sts_err4, 0, $userId);
    }

    $updateTask = "UPDATE ext_tasks SET timeStamp='" . $timeStamp . "' , status='Not Started' WHERE id='" . $task['id'] . "'";
    $taskQryExcute = mysqli_query($con, $updateTask);
}

//Ankit + Trupal
function taskSkip($seqId, $taskId, $msg, $userId) {
    include('config.php');
    $currentTimestamp = round(microtime(true) * 1000);
    $updateTask = mysqli_query($con, "UPDATE ext_tasks SET status = 'Skipped', result='" . $msg . "', timestamp='" . $currentTimestamp . "' WHERE id = '" . $taskId . "'");
    addLogHistory($msg, $seqId, $userId);
    //processContinue();
}

//Ankit + Trupal
function taskSuccess($seqId, $taskId, $msg, $userId) {
    include('config.php');
    $currentTimestamp = round(microtime(true) * 1000);
    $updateTask = mysqli_query($con, "UPDATE ext_tasks SET status = 'Complete', result='" . $msg . "', timestamp='" . $currentTimestamp . "' WHERE id = '" . $taskId . "'");
    addLogHistory($msg, $seqId, $userId);
    //processContinue();
}

//Ankit + Trupal
function taskSuccessNew($userId, $seqId, $taskId, $msg, $enrolled = 1) {
    include('config.php');
    $seqQry = mysqli_query($con, "SELECT * from ext_sequences WHERE `id` = '" . $seqId . "'");
    if (!empty($seqQry)) {
        $seq = mysqli_fetch_assoc($seqQry);
        if (!empty($seq)) {
            $stepsQry = mysqli_query($con, "SELECT * from ext_steps WHERE `seqId` = '" . $seqId . "'");
            if (!empty($stepsQry)) {
                $steps = mysqli_num_rows($stepsQry);
                if ($steps > 0) {
                    $tasksQry = mysqli_query($con, "SELECT * from ext_tasks WHERE `id` = '" . $taskId . "'");
                    if (!empty($tasksQry)) {
                        $task = mysqli_fetch_assoc($tasksQry);
                        if (!empty($task)) {
                            $step = '';
                            if ($task['step'] == 0 && $task['type'] == 'Connect') {
                                $step = $task['step'] + 1;
                            } else if ($task['step'] > 0 && $task['type'] == 'Message') {
                                $step = $task['step'] + 1;
                            } else if ($task['step'] > 0 && $task['type'] == 'Zapier') {
                                $step = $task['step'] + 1;
                            }

                            if (!empty($step)) {
                                $postdata = array();
                                $postdata['person_id'] = $task['personId'];
                                $postdata['seq_id'] = $seq['serverDbId'];
                                $postdata['step'] = $step;
                                $postdata['totalsteps'] = $steps;
                                $postdata['userid'] = $userId;

                                $curlUrl = API_ADDRESS . "/update_steps.php";

                                $curl = curl_init();
                                curl_setopt_array($curl, array(
                                    CURLOPT_URL => $curlUrl,
                                    CURLOPT_RETURNTRANSFER => true,
                                    CURLOPT_ENCODING => "",
                                    CURLOPT_MAXREDIRS => 10,
                                    CURLOPT_TIMEOUT => 30,
                                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                    CURLOPT_CUSTOMREQUEST => "POST",
                                    CURLOPT_POSTFIELDS => json_encode($postdata),
                                    CURLOPT_HTTPHEADER => array(
                                        "accept: application/json; charset\x3dutf-8",
                                        "x-requested-with: XMLHttpRequest",
                                        "x-restli-protocol-version: 2.0.0"
                                    )
                                ));

                                $res = curl_exec($curl);
                                if (curl_errno($curl)) {
                                    $error_msg = curl_error($curl);
                                    addLogHistory($error_msg, $seqId, $userId, 1);
                                } else {
                                    $response = json_decode($res);
                                }
                                curl_close($curl);
                            }
                        }
                    }
                }
            }
        }
    }
}

//Ankit + Trupal
function createNextTask($userId, $task, $reqId = 0) {
    include('config.php');
    echo 'In create Next Task<br>';
    $request_withdraw_days = 45;
    $sequencesQry = mysqli_query($con, "SELECT * from ext_sequences WHERE `id` = '" . $task['seqId'] . "' ORDER BY `id` ASC LIMIT 1");
    $sequencesRec = mysqli_fetch_assoc($sequencesQry);
    if (!empty($sequencesRec['requestWithdrawDays'])) {
        $request_withdraw_days = $sequencesRec['requestWithdrawDays'];
    }
    $withDrawTime = $request_withdraw_days * ACCEPTED_WAITING_DELAY;
    $exQuerySeq = mysqli_query($con, "select * from ext_sequences where id='" . $task['seqId'] . "' LIMIT 1");
    $sequenceData = mysqli_fetch_assoc($exQuerySeq);
    $sequenceName = $sequenceData['name'];
    $stepsQuery = mysqli_query($con, "select * from ext_steps where seqId='" . $task['seqId'] . "' ORDER BY `order`");

    $stepArray = array();
    while ($stepData = mysqli_fetch_array($stepsQuery, MYSQLI_ASSOC)) {
        array_push($stepArray, $stepData);
    }
    if (!empty($stepArray[$task['step']]) && !empty($stepArray[$task['step'] + 1])) {
        $step = $stepArray[$task['step']];
        $stepIncrement = $stepArray[$task['step'] + 1];
        $newTask = mysqli_fetch_assoc(mysqli_query($con, "SELECT * from ext_tasks WHERE `seqId` = '" . $task['seqId'] . "' AND stepId='" . $stepIncrement['id'] . "' AND  personId='" . $task['personId'] . "'  ORDER BY `id` ASC LIMIT 1"));
        $currentTimestamp = round(microtime(true) * 1000);
        if ($step['type'] == 'Connect') {
            $startTime = $currentTimestamp + ($step['delayDays'] * MS_DAY + $step['delayMinutes'] * MS_MINUTE);
            $triggerOnInvitationAccepted = 1;
        } else {
            $startTime = $currentTimestamp + ($withDrawTime * MS_DAY);
            $triggerOnInvitationAccepted = 0;
        }
        if (empty($newTask)) {
            $steps = $task['step'] + 1;
            $addTask = "INSERT INTO ext_tasks (`seqId`, `linkId`, `stepId`, `step`, `startTime`, `personId`, `status`, `type`, `delayDays`, `delayMinutes`, `triggerOnInvitationAccepted`, `person`, `triggered`, `salesNavigator`,`userId`,`requestId`) VALUES ('" . $task['seqId'] . "', '" . $task['linkId'] . "', '" . $stepIncrement['id'] . "', '" . $steps . "', '" . $startTime . "', '" . $task['personId'] . "', 'Not Started', '" . $stepIncrement['type'] . "', '0', '0', '" . $triggerOnInvitationAccepted . "', '" . str_replace("'", "\'", $task['person']) . "','false','" . $task['salesNavigator'] . "', '" . $userId . "','" . $reqId . "')";
            $taskQryExcute = mysqli_query($con, $addTask);
        }
    }
}

//Ankit + Trupal
function taskEnrollmentsLimitReached($sequence, $task, $d = 0, $msg = '', $userId = 0) {
    include('config.php');
    $lreach_enrol1 = "Reached enrollments limit.";
    $lreach_enrol2 = " will be waiting till ";
    $timeStamp = round(microtime(true) * 1000) + (1000 * $d);
    addLogHistory((!empty($msg)) ? $msg : $lreach_enrol1 . " " . "Task #" . $task['id'] . $lreach_enrol2 . $timeStamp . " (" . date('m/d/Y H:i:s', $timeStamp) . ")", 0, $userId);

    $updateTask = "UPDATE ext_tasks SET waitTill='" . $timeStamp . "' , status='Not Started' WHERE id='" . $task['id'] . "'";
    $taskQryExcute = mysqli_query($con, $updateTask);
}

//Ankit + Trupal
function firstDegreeData($user, $publicId, $SeqNameF, $CompanyDomainF) {
    include('config.php');
    $userId = $user['id'];
    $csrf = $user['csrf'];
    $cookie = $user['cookie'];
    $accessKeySql = $con->query("SELECT access_key FROM intigration where `user_id`='" . $userId . "'");
    $integrationAccessKey = $accessKeySql->fetch_assoc();
    $accessKey = json_decode($integrationAccessKey['access_key']);
    $hubspotApiKey = $accessKey->hubspot_key;
    $hubspotId = $accessKey->hubportal_id;
    $hubspotOwnerId = '38393594';
    $teamid = $user['teamid'];
    $sessionId = base64_encode($userId . '/' . $teamid);
    $proxyIp = $user['proxyIp'];
    $proxyPort = $user['proxyPort'];
    $proxyUsername = $user['proxyUsername'];
    $proxyPassword = $user['proxyPassword'];
    $userAgent = $user['userAgent'];

    $linkUID = '';
    $curl_profile = curl_init();
    curl_setopt_array($curl_profile, array(
        CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $publicId . "/profileView",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_HTTPPROXYTUNNEL => 1,
        CURLOPT_PROXY => "$proxyIp",
        CURLOPT_PROXYPORT => "$proxyPort",
        CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
            "cookie: $cookie",
            "csrf-token: $csrf",
            "x-http-method-override: GET",
            "Host: www.linkedin.com",
            "User-Agent: $userAgent",
            "Accept-Language: en-US,en;q=0.5",
            "Accept-Encoding: gzip, deflate, br",
            "content-type: application/x-www-form-urlencoded",
            "x-li-lang: en_US",
            "x-restli-protocol-version: 2.0.0",
            "Origin: https://www.linkedin.com",
            "TE: Trailers"
        ),
    ));

    $profileViewResponse = curl_exec($curl_profile);
    if (curl_errno($curl_profile)) {
        $error_msg = curl_error($curl_profile);
        addLogHistory($error_msg, 0, $user['id'], 1);
    } else {
        $profileView = json_decode($profileViewResponse, true);
        $profId = $profileView['positionGroupView']['profileId'];
        $fName = $profileView['profile']['miniProfile']['firstName'];
        $lName = $profileView['profile']['miniProfile']['lastName'];
        $linkUID = explode(':', $profileView['profile']['miniProfile']['objectUrn'])[3];
        $occupation = $profileView['profile']['miniProfile']['occupation'];
        $publicIdentifier = $profileView['profile']['miniProfile']['publicIdentifier'];
        $fullName = $fName . ' ' . $lName;
        $hfname = $fName;
        $hlname = $lName;
        /* picture details */
        $picture = $profileView['profile']['miniProfile']['picture'];
        $artifacts = '';
        $profileImg = '';
        if (!empty($picture)) {
            $artifacts = $picture['com.linkedin.common.VectorImage'];
            $profileImg = $artifacts['artifacts'][3]['fileIdentifyingUrlPathSegment'];
        }
        /* educationDetail */
        $educationView = $profileView['educationView']['elements'];
        $educationDetail = array();
        $companyDetail = array();
        if (!empty($educationView)) {
            foreach ($educationView as $ele) {
                if (!empty($ele['degreeName'])) {
                    $degreeName = json_encode($ele['degreeName']);
                } else {
                    $degreeName = '';
                }
                if (!empty($ele['fieldOfStudy'])) {
                    $fieldOfStudy = json_encode($ele['fieldOfStudy']);
                } else {
                    $fieldOfStudy = '';
                }
                if (!empty($ele['schoolName'])) {
                    $schoolName = json_encode($ele['schoolName']);
                } else {
                    $schoolName = '';
                }
                array_push($educationDetail, array('degreeName' => $degreeName, 'fieldOfStudy' => $fieldOfStudy, 'schoolName' => $schoolName));
            }
        }

        /* companyDetail */
        $positionView = $profileView['positionView']['elements'];
        if (!empty($positionView)) {
            foreach ($positionView as $ele) {
                if (!empty($ele['companyName'])) {
                    $companyName = json_encode($ele['companyName']);
                } else {
                    $companyName = '';
                }
                if (!empty($ele['locationName'])) {
                    $locationName = json_encode($ele['locationName']);
                } else {
                    $locationName = '';
                }
                if (!empty($ele['title'])) {
                    $title = json_encode($ele['title']);
                } else {
                    $title = '';
                }
                array_push($companyDetail, array('companyName' => $companyName, 'locationName' => $locationName, 'title' => $title));
            }
        }

        /* Contact Info */
        $curl_contact = curl_init();
        curl_setopt_array($curl_contact, array(
            CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $publicId . "/profileContactInfo",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPPROXYTUNNEL => 1,
            CURLOPT_PROXY => "$proxyIp",
            CURLOPT_PROXYPORT => "$proxyPort",
            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "cookie: $cookie",
                "csrf-token: $csrf",
                "x-http-method-override: GET",
                "Host: www.linkedin.com",
                "User-Agent: $userAgent",  
                "Accept-Language: en-US,en;q=0.5",
                "Accept-Encoding: gzip, deflate, br",
                "content-type: application/x-www-form-urlencoded",
                "x-li-lang: en_US",
                "x-restli-protocol-version: 2.0.0",
                "Origin: https://www.linkedin.com",
                "TE: Trailers"
            ),
        ));

        $contactResponse = curl_exec($curl_contact);
        if (curl_errno($curl_contact)) {
            $error_msg = curl_error($curl_contact);
            addLogHistory($error_msg, 0, $user['id'], 1);
        } else {
            if (!empty($contactResponse)) {
                $contactView = json_decode($contactResponse, true);
                /* emailAddress */
                if (!empty($contactView['emailAddress'])) {
                    $email = $contactView['emailAddress'];
                } else {
                    $email = '';
                }
                /* phoneNumbers */
                if (!empty($contactView['phoneNumbers'])) {
                    $phoneNumbers = $contactView['phoneNumbers'][0]['number'];
                } else {
                    $phoneNumbers = '';
                }
                /* birthDateOn */
                if (!empty($contactView['birthDateOn'])) {
                    $birthDateOn = $contactView['birthDateOn'];
                } else {
                    $birthDateOn = '';
                }
                $contactInfo = array();
                if (!empty($contactView)) {
                    foreach ($contactView as $ele) {
                        if (!empty($ele['websites'])) {
                            $websites = json_encode($ele['websites']);
                        } else {
                            $websites = '';
                        }
                        if (!empty($ele['ims'])) {
                            $ims = json_encode($ele['ims']);
                        } else {
                            $ims = '';
                        }
                        if (!empty($ele['twitterHandles'])) {
                            $twitterHandles = json_encode($ele['twitterHandles']);
                        } else {
                            $twitterHandles = '';
                        }
                        array_push($contactInfo, array('websites' => $websites, 'ims' => $ims, 'twitterHandles' => $twitterHandles, 'birthDateOn' => $birthDateOn, 'profileImg' => $profileImg));
                    }
                }
                $postdata = array();
                $postdata['fullName'] = $fullName;
                $postdata['hfname'] = $hfname;
                $postdata['hlname'] = $hlname;
                $postdata['locationName'] = $locationName;
                $postdata['linkUID'] = $linkUID;
                $postdata['occupation'] = $occupation;
                $postdata['publicId'] = $publicId;
                $postdata['email'] = $email;
                $postdata['phoneNumbers'] = $phoneNumbers;
                $postdata['contactInfo'] = json_encode($contactInfo);
                $postdata['educationDetail'] = json_encode($educationDetail);
                $postdata['companyDetail'] = json_encode($companyDetail);
                $postdata['sessionId'] = $sessionId;
                $postdata['hubspot_auto'] = 'on';
                $postdata['hsApiKey'] = $hubspotApiKey;
                $postdata['hsPortalId'] = $hubspotId;
                $postdata['hubspot_owner_id'] = $hubspotOwnerId;
                $postdata['SeqName'] = $SeqNameF;

                $curlUrlForGetLiProfileInfo = API_ADDRESS . "/1stDegreeData.php";
                $curlGetLiProfileInfo = curl_init();
                curl_setopt_array($curlGetLiProfileInfo, array(
                    CURLOPT_URL => $curlUrlForGetLiProfileInfo,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_POSTFIELDS => $postdata,
                    CURLOPT_HTTPHEADER => array(
                        "accept: application/json"
                    )
                ));

                $resForGetLiProfileInfo = curl_exec($curlGetLiProfileInfo);
                if (curl_errno($curlGetLiProfileInfo)) {
                    $error_msg = curl_error($curlGetLiProfileInfo);
                    addLogHistory($error_msg, 0, $user['id'], 1);
                }
            }
        }
    }
    curl_close($curl_profile);
}

//Ankit + Trupal
/* function taskError($task, $msg) {
  include('config.php');
  if(!empty($task['errorCount'])){
  $errorCount=$task['errorCount'];
  }else{
  $errorCount= 0;
  }

  $errorCount=$errorCount+1;
  $task['result']=$msg;
  $task['timestamp']=round(microtime(true) * 1000);
  $d = round(microtime(true) * 1000) + (3E5 * $errorCount);

  if($errorCount >=MAX_ERROR_COUNT){
  $task['status'] = 'Error';
  CURRENT_ERROR_COUNT++;
  $d = round(microtime(true) * 1000) + 18E5 * CURRENT_ERROR_COUNT;
  if(CURRENT_ERROR_COUNT >= MAX_ERROR_COUNT){
  $d = 0;
  sequenceError($task['seqId']);
  }
  }

  $seqUpdate=mysqli_query("UPDATE ext_tasks SET errorCount='" .$errorCount. "',result='".$task['result']."' , timestamp='".$task['timestamp']."' WHERE id='" .$task['id']. "' ");
  if(!empty){
  $seqUpdate=mysqli_query("UPDATE ext_sequences SET pausedTill='" .$d. "' WHERE id='" .$task['seqId']. "' ");
  }
  addLogHistory($msg,$task['seqId']);
  //processContinue();
  } */

//NR sendMessageToSettings starts
function sendMessageToSettings($bMsg = '') {
	/*
    include('config.php');

    $blakQry = mysqli_query($con, "SELECT * from ext_blacklist");
    if (mysqli_num_rows($blakQry) > 0) {

        while ($aExtBlackArr = mysqli_fetch_assoc($blakQry)) {
            //echo '<pre>'; print_r($aExtBlackArr);

            $taskQry = mysqli_query($con, "SELECT * from ext_tasks where personId=" . $aExtBlackArr['liId'] . " ORDER BY id ASC LIMIT 1");
            if (mysqli_num_rows($taskQry) > 0) {
                $dExtTaskArr = mysqli_fetch_assoc($taskQry);
                mysqli_query($con, "UPDATE ext_blacklist SET seqId=" . $dExtTaskArr['seqId'] . " WHERE id = " . $aExtBlackArr['id']);
            } else {
                mysqli_query($con, "UPDATE ext_blacklist SET seqId='0' WHERE id = " . $aExtBlackArr['id']);
            }
        }
    }
	*/

    //jscode skipped code starts
    //chrome.runtime.sendMessage({
    //action: "message2settings",
    //message: b
    //})
    //jscode skipped code ends
}





//NR 13May2020 starts
function startsWith($str, $begnString) {
    $len = strlen($begnString);
    return (substr($str, 0, $len) === $begnString);
}



//NR getTaskStartTimeAsUserWorkingTime starts
function getTaskStartTimeAsUserWorkingTime($bSeqArr) {
    include('config.php');
    echo $startTime = $timestamp = round(microtime(true) * 1000);

    echo '<br/>' . $server_time = date('Y-m-d H:i:s', ($startTime / 1000));

    echo '<br/>' . $current_server_timestamp = round($startTime / 1000);
    echo '<br/>' . date('Y-m-d H:i:s', $current_server_timestamp);

    $seqWorkingHourId = $bSeqArr['working_hour_id'];

    $whQry = mysqli_query($con, "SELECT * from ext_working_hours WHERE `id` = " . $seqWorkingHourId . " LIMIT 1");
    if (mysqli_num_rows($whQry) > 0) {
        $whArr = mysqli_fetch_assoc($whQry);

        echo '<br/>wh_sst:' . $wh_sst = date('Y-m-d') . ' ' . $whArr['server_start_time'];
        echo '<br/>wh_sst_timestamp:' . $wh_sst_timestamp = strtotime($wh_sst);
        echo '<br/>wh_sst:' . $wh_sst = date('Y-m-d H:i:s', $wh_sst_timestamp);

        echo '<br/><br/>';
        echo '<br/>wh_set:' . $wh_set = date('Y-m-d') . ' ' . $whArr['server_end_time'];
        echo '<br/>wh_set_timestamp:' . $wh_set_timestamp = strtotime($wh_set);
        echo '<br/>wh_set:' . $wh_set = date('Y-m-d H:i:s', $wh_set_timestamp);

        //echo '<br/>wh_set:'.$wh_set = date('Y-m-d').' '.$whArr['server_end_time'];
        //1589155200 <= 1589181754 && 1589158800 >= 1589181754
        if ($wh_sst_timestamp <= $current_server_timestamp && $wh_set_timestamp >= $current_server_timestamp) {
            echo '<br/><br/>AAAAAAA:' . $current_server_timestamp * 1000;
            return ($current_server_timestamp * 1000);
        } else {

            if ($current_server_timestamp < $wh_sst_timestamp) {
                echo '<br/><br/>Today Day<br/>';

                echo '<br/>wh_sst:' . $wh_sst = date('Y-m-d') . ' ' . $whArr['server_start_time'];
                echo '<br/>wh_sst_timestamp:' . $wh_sst_timestamp = strtotime($wh_sst);
                echo '<br/>wh_sst:' . $wh_sst = date('Y-m-d H:i:s', $wh_sst_timestamp);

                echo '<br/><br/>BBBBBB:' . $wh_sst_timestamp * 1000;
                return ($wh_sst_timestamp * 1000);
            } else {
                echo '<br/><br/>Next Day<br/>';

                echo '<br/>wh_sst:' . $wh_sst = date('Y-m-d') . ' ' . $whArr['server_start_time'];
                echo '<br/>wh_sst_timestamp:' . $wh_sst_timestamp = strtotime($wh_sst . "+1 days");
                echo '<br/>wh_sst:' . $wh_sst = date('Y-m-d H:i:s', $wh_sst_timestamp);

                echo '<br/><br/>CCCCCCC:' . $wh_sst_timestamp * 1000;
                return ($wh_sst_timestamp * 1000);
            }
        }
    } else {
        echo '<br/><br/>DDDDDDDD:' . $current_server_timestamp * 1000;
        return ($current_server_timestamp * 1000);
    }
}

//NR getTaskStartTimeAsUserWorkingTime ends
//NR createFirstTasks starts
function createFirstTasks($user, $bSeqArr, $aExtLinkArr, $dArr) {
    include('config.php');
    echo '<br/>in createFirstTasks<br/>';
	echo '<br/>LINE:'. __LINE__ .'::user::';print_r($user);
	echo '<br/>LINE:'. __LINE__ .'::bSeqArr::';print_r($bSeqArr);
	echo '<br/>LINE:'. __LINE__ .'::aExtLinkArr::';print_r($aExtLinkArr);
	echo '<br/>LINE:'. __LINE__ .'::dArr::';print_r($dArr);
    //echo '<br/>dArr:::<pre>';
    //print_r($dArr);
    $seqId = $bSeqArr['id'];


    ini_set('max_execution_time', '0');
    $cookie = $user['cookie'];
    $csrf = $user['csrf'];
    $proxyIp = $user['proxyIp'];
    $proxyPort = $user['proxyPort'];
    $proxyUsername = $user['proxyUsername'];
    $proxyPassword = $user['proxyPassword'];
    $userAgent = $user['userAgent'];
    $userId = $user['id'];

    //$taskStartTime = getTaskStartTimeAsUserWorkingTime($bSeqArr);
    $taskStartTime = round(microtime(true) * 1000);

    //$stepQry = mysqli_query($con,"SELECT * from ext_steps WHERE `seqId` = ".$seqId." order by `order` ASC");
    $stepQry = mysqli_query($con, "SELECT * from ext_steps WHERE `seqId` = " . $seqId . " order by `order` ASC LIMIT 1"); //11May2020 (Only first step's entry will be inserted)
    if (mysqli_num_rows($stepQry) > 0) {
        while ($stepArr = mysqli_fetch_assoc($stepQry)) {
            echo '<br/>stepArr:::<pre>';
            print_r($stepArr);

            $g = $stepArr;
            $lout_of_net = " is out of network."; //chrome.i18n.getMessage('lout_of_net');

            if (isset($dArr['salesNavigator'])) {
                echo '<br/>LINE:' . __LINE__ . '::::within createFirstTasks for salesNavigator<br/>';die;
                foreach ($dArr['results'] as $c) {

                    if ($c['badges'] && 0 == $c['badges']['distance'] || $c['member'] && "OUT_OF_NETWORK" == $c['member']['authType']) {
                        $p2 = ($c['member'] && $c['member']['formattedName'] || "LinkedIn Member") . $lout_of_net;
                        addLogHistory(0, $p2, $user['id']);
                    } elseif ($c['member'] && $c['member']['memberId']) {
                        $d = $c['member'];
                        $flagshipProfileUrl;

                        $d['fullName'] = $d['formattedName'];
                        $d['id'] = $d['memberId'];
                        $d['distance'] = $c['badges'] && $c['badges']['distance'] || -1;
                        $d['canSendInMail'] = $c['privacy'] && $c['privacy']['canSendInMail'] || !1;
                        $d['snUrl'] = "https://www.linkedin.com/sales/profile/" . $d['id'] . "," . $d['authToken'] . "," . $d['authType'];
                        // d.snUrl = "https://www.linkedin.com/sales/people/AAEAAADDD5MBj4LGyhK1NXPhglqkVrHTckYO4m0,6-XP,NAME_SEARCH";



                        $currentTimestamp = round(microtime(true) * 1000);
                        $curl = curl_init();
                        /* curl_setopt_array($curl, array(
                          CURLOPT_URL => $d['snUrl'],
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => "",
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 30,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => "GET",
                          CURLOPT_POSTFIELDS => "{}",
                          CURLOPT_HTTPHEADER => array(
                          //"accept: application/json",
                          "cookie: $cookie",
                          "csrf-token: $csrf"
                          )
                          )); */

                        //new headears starts
                        curl_setopt_array($curl, array(
                            CURLOPT_URL => $d['snUrl'],
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => "",
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 30,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTPPROXYTUNNEL => 1,
                            CURLINFO_HEADER_OUT => true,
                            CURLOPT_PROXY => "$proxyIp",
                            CURLOPT_PROXYPORT => "$proxyPort",
                            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                            CURLOPT_CUSTOMREQUEST => "GET",
                            CURLOPT_HTTPHEADER => array(
                                "cookie: $cookie",
                                "csrf-token: $csrf",
                                "x-http-method-override: GET",
                                "Host: www.linkedin.com",
                                "User-Agent: $userAgent",
                                "Accept-Language: en-US,en;q=0.5",
                                "Accept-Encoding: gzip, deflate, br",
                                "content-type: application/x-www-form-urlencoded",
                                "x-li-lang: en_US",
                                "x-restli-protocol-version: 2.0.0",
                                "Origin: https://www.linkedin.com",
                                "TE: Trailers"
                            ),
                        ));
                        //new headears ends

                        $curl_res = curl_exec($curl);
                        echo '<br/>curl result:<pre>';
                        print_r($curl_res);
                        $curl_err = curl_errno($curl);

                        if ($curl_err) {
                            addLogHistory($error_msg, 0, $userId, 1);
                            curl_close($curl);

                            $lpro_skip1 = "Skipped "; //chrome.i18n.getMessage('lpro_skip1');
                            $lpro_skip3 = ". Error fetching profile."; //chrome.i18n.getMessage('lpro_skip3');
                            $p2 = $lpro_skip1 . '' . $d['fullName'] . '' . $lpro_skip3;
                            addLogHistory($seqId, $p2, $user['id']);
                        } else {
                            curl_close($curl);
                            $c = json_decode($curl_res, true);
                            $e = '';
                            //c.match && (e = (c.match(/<code id="streamed-content-content"><!--(.*?)--\x3e/) || [])[1] || "");

                            try {

                                $e = json_decode($e);
                                //js: e = JSON.parse(e);
                            } catch (Exception $p) {
                                
                            }

                            if ($e && ($e['profile'] || $e['publicLink'])) {
                                $d['snPublicLink'] = $e['profile']['publicLink'] || $e['publicLink'];
                                $d['profileLink'] = $e['profile']['profileLink'] || $e['profileLink'];

                                if ($g && $d['snPublicLink']) {

                                    $tskQry = mysqli_query($con, "SELECT * from ext_tasks WHERE `seqId` = " . $seqId . " AND stepId = " . $g['id'] . " AND personId = " . $d['id'] . " ORDER BY id ASC LIMIT 1");
                                    if (mysqli_num_rows($tskQry) > 0) {
                                        $c = mysqli_fetch_assoc($tskQry);
                                    } else {

                                        $person = json_encode($d);
                                        $person_db = mysqli_real_escape_string($con, $person);
										
										$crnttmsmp = strtotime('+1 minutes', ceil(round(microtime(true) * 1000)/1000)) * 1000;
										//round(microtime(true) * 1000)
										
                                        mysqli_query($con, "INSERT INTO `ext_tasks` SET userId=" . $user['id'] . ",seqId=" . $seqId . ", linkId=" . $aExtLinkArr['id'] . ", stepId=" . $g['id'] . ", step=0, startTime='" . $crnttmsmp . "', personId= " . $d['id'] . ", status='Not Started', type='" . $g['type'] . "', delayDays=" . $g['delayDays'] . ", delayMinutes=" . $g['delayMinutes'] . ", delayType='" . $g['delayType'] . "', person='" . $person_db . "', triggered='false' ");
                                    }
                                }
                            } else {

                                $html = str_get_html($c);
                                //$html = JSON.parse($($.parseHTML(c)).filter('code').last().prev().prev().prev().html()).flagshipProfileUrl

                                if ($html) {
                                    //flagshipProfileUrl = JSON.parse($($.parseHTML(c)).filter('code').last().prev().prev().prev().html()).flagshipProfileUrl;
                                    $d['snPublicLink'] = $flagshipProfileUrl;
                                    $d['profileLink'] = $flagshipProfileUrl;

                                    $tskQry = mysqli_query($con, "SELECT * from ext_tasks WHERE `seqId` = " . $seqId . " AND stepId = " . $g['id'] . " AND personId = " . $d['id'] . " ORDER BY id ASC LIMIT 1");
                                    if (mysqli_num_rows($tskQry) > 0) {
                                        $c = mysqli_fetch_assoc($tskQry);
                                    } else {
 
                                        $person = json_encode($d);
                                        $person_db = mysqli_real_escape_string($con, $person);
										
										$crnttmsmp = strtotime('+1 minutes', ceil(round(microtime(true) * 1000)/1000)) * 1000;
										//round(microtime(true) * 1000)
										
										
                                        mysqli_query($con, "INSERT INTO `ext_tasks` SET userId=" . $user['id'] . ",seqId=" . $seqId . ", linkId=" . $aExtLinkArr['id'] . ", stepId=" . $g['id'] . ", step=0, startTime='" . $crnttmsmp . "', personId= " . $d['id'] . ", status='Not Started', type='" . $g['type'] . "', delayDays=" . $g['delayDays'] . ", delayMinutes=" . $g['delayMinutes'] . ", delayType='" . $g['delayType'] . "', person='" . $person_db . "', triggered='false' ");
                                    }
                                } else {

                                    $lpro_skip1 = "Skipped "; //chrome.i18n.getMessage('lpro_skip1');
                                    $lpro_skip2 = ". Cannot find public profile link."; //chrome.i18n.getMessage('lpro_skip2');
                                    $p2 = $lpro_skip1 . '' . $d['fullName'] . '' . $lpro_skip2;
                                    addLogHistory($seqId, $p2, $user['id']);
                                }
                            }
                        }
                    }
                }
            } else {
                echo '<br/>LINE:' . __LINE__ . '::::within createFirstTasks<br/>';
                $startTimeCnt = 0;
                //NR:This case is tested.DONE;
                foreach ($dArr['results'] as $c) {

                    if ($startTimeCnt == 0) {
                        $taskStartTime_new = $taskStartTime;
                    } else {
                        
                        $rendomTime = rand(45, 180);
                        if ($startTimeCnt == 1) {
                            $taskStartTime_new = $taskStartTime + $rendomTime;
                        } else {
                            $taskStartTime_new = $taskStartTime_new + $rendomTime;                            
                        }
                    }
                    echo '<br>LINE:' . __LINE__ . ':::dArr[results] as c::<pre>';
                    print_r($c);
                    if ($c['person'] && $c['person']->id){
                        $d = $c['person'];
                        echo '<br>LINE:' . __LINE__ . ':::d::<pre>';
                        print_r($d);
                        //$x = $c->temp;
                        //$x = $c[0];
						
						$x = '';
						if(isset($c[0])){
							$x = $c[0];
						}
                        $d->fullName = (isset($d->fullName)) ? $d->fullName : $d->firstName . " " . $d->lastName;
                        echo '<br>LINE:' . __LINE__ . ':::G::<pre>';
                        print_r($g);
                        if ($g) {
							
							if($bSeqArr['msgSeq'] == 1){
								$taskTbl='completed_tasks';
								//$tskQry = "SELECT * from ".$taskTbl." WHERE `seqId` = " . $seqId . " AND stepId = " . $g['id'] . " AND personId = " . $d->id . " ORDER BY id ASC LIMIT 1";
								
							}else{
								$taskTbl='ext_tasks';
								//$tskQry = "SELECT * from ".$taskTbl." WHERE `seqId` = " . $seqId . " AND personId = " . $d->id . " ORDER BY id ASC LIMIT 1";
							}

                            $tskQry = "SELECT * from ".$taskTbl." WHERE `seqId` = " . $seqId . " AND stepId = " . $g['id'] . " AND personId = " . $d->id . " ORDER BY id ASC LIMIT 1";
                            echo '<br/>LINE:' . __LINE__ . ' ::qry:::' . $tskQry . '<br/>';
                            $tskQry = mysqli_query($con, $tskQry);
                            if (mysqli_num_rows($tskQry) > 0) {
                                $c = mysqli_fetch_assoc($tskQry);
                                echo '<br/>LINE:' . __LINE__ . ' ::row found<br/>';
                            } else {
                                echo '<br/>LINE:' . __LINE__ . ' ::row not found<br/>';

                                if (($bSeqArr['msgSeq'] == 0 && $g['type'] != "Message") || ($bSeqArr['msgSeq'] == 1)) {
                                    //NR:20APR2020 above condition added

                                    $person = json_encode($d);
                                    if($x!=''){
										$x = json_encode($x);
									}
                                    $timestamp = round(microtime(true) * 1000);

                                    /*
                                      $tskQry = "INSERT INTO `ext_tasks` SET userId=".$user['id'].",seqId=".$seqId.", linkId=".$aExtLinkArr['id'].", stepId=".$g['id'].", step=0, startTime='".round(microtime(true) * 1000)."', personId= ".$d->id.", status='Not Started', type='".$g['type']."', delayDays=".$g['delayDays'].", delayMinutes=".$g['delayMinutes'].", delayType='".$g['delayType']."', person='".$person."', triggered='false', temp='".$x."', timestamp='".$timestamp."', result='', triggerOnInvitationAccepted=0, isCsv=0, isWebhook=0, salesNavigator='', requestId='' ";
                                      echo '<br/>LINE:'.__LINE__.' ::insert qry:::'.$tskQry.'<br/>';

                                      mysqli_query($con,"INSERT INTO `ext_tasks` SET userId=".$user['id'].",seqId=".$seqId.", linkId=".$aExtLinkArr['id'].", stepId=".$g['id'].", step=0, startTime='".round(microtime(true) * 1000)."', personId= ".$d->id.", status='Not Started', type='".$g['type']."', delayDays=".$g['delayDays'].", delayMinutes=".$g['delayMinutes'].", delayType='".$g['delayType']."', person='".$person."', triggered='false', temp='".$x."', timestamp='".$timestamp."', result='', triggerOnInvitationAccepted=0, isCsv=0, isWebhook=0, salesNavigator='', requestId='' ");
                                     */

                                    //11May2020 : $taskStartTime replaced;
                                    $person_db = mysqli_real_escape_string($con, $person);
									if($x!=''){
										$x = mysqli_real_escape_string($con, $x);
									}
									
									$crnttmsmp = strtotime('+1 minutes', ceil(round(microtime(true) * 1000)/1000)) * 1000;
                                    $tskQry = "INSERT INTO `ext_tasks` SET userId=" . $user['id'] . ",seqId=" . $seqId . ", linkId=" . $aExtLinkArr['id'] . ", stepId=" . $g['id'] . ", step=0, startTime='" .  $crnttmsmp . "', personId= " . $d->id . ", status='Not Started', type='" . $g['type'] . "', delayDays=" . $g['delayDays'] . ", delayMinutes=" . $g['delayMinutes'] . ", delayType='" . $g['delayType'] . "', person='" . $person_db . "', triggered='false', temp='" . $x . "', timestamp='" . $timestamp . "', result='', triggerOnInvitationAccepted=0, isCsv=0, isWebhook=0, salesNavigator='', requestId='' ";
                                    echo '<br/>LINE:' . __LINE__ . ' ::insert qry:::' . $tskQry . '<br/>';

                                    //mysqli_query($con, "INSERT INTO `ext_tasks` SET userId=" . $user['id'] . ",seqId=" . $seqId . ", linkId=" . $aExtLinkArr['id'] . ", stepId=" . $g['id'] . ", step=0, startTime='" .  $crnttmsmp . "', personId= " . $d->id . ", status='Not Started', type='" . $g['type'] . "', delayDays=" . $g['delayDays'] . ", delayMinutes=" . $g['delayMinutes'] . ", delayType='" . $g['delayType'] . "', person='" . $person_db . "', triggered='false', temp='" . $x . "', timestamp='" . $timestamp . "', result='', triggerOnInvitationAccepted=0, isCsv=0, isWebhook=0, salesNavigator='', requestId='' ");
                                }
                            }
                        }
                    }
                    $startTimeCnt++;
                }
            }
        }
    }
}

//NR createFirstTasks ends
//This function is use for process sequences created by RAVI Bhuva on 08-April-2020
function processSequences($user) {


    //if ($user['id'] != 14883) {
        include('config.php');
        $userId = $user['id'];
        $b = round(microtime(true) * 1000);
        $a = $b - TASK_LIMIT_TIME_PERIOD;
        $time = $b - TASK_MAX_EXECUTION_TIME;
        $sequencesQry = mysqli_query($con, "SELECT * from ext_sequences WHERE id=1470 and `status` = 'Active' and `user_id`='" . $userId . "' ORDER BY lastRunTime limit 1");
        if (isset($sequencesQry) && mysqli_num_rows($sequencesQry) > 0) {
            $c = mysqli_fetch_assoc($sequencesQry);
            $sequencesData = $c;
            $updateSequences = mysqli_query($con, "UPDATE ext_sequences SET lastRunTime='" . $b . "' WHERE id=" . $sequencesData['id']);
            $taskQry = mysqli_query($con, "SELECT * from ext_tasks WHERE `status` = 'Not Started' and `step`=0 and userId ='" . $userId . "' and seqId=" . $sequencesData['id']);
            //if ($taskQry->num_rows == 0) {
            
            processLinks($user, $sequencesData);
            
            //}
			
			//25May2020 starts(sequence status complete)
			/*$seqId = $sequencesData['id'];
			$LinkQry1 = mysqli_query($con, "SELECT * from ext_links WHERE `seqId` = " . $seqId . "");
			if (mysqli_num_rows($LinkQry1) > 0) {
				$total_links = mysqli_num_rows($LinkQry1);
				$completedLinkCnt=0;
				while($LinkRes1 = mysqli_fetch_assoc($LinkQry1)) {
					$LinkQry2 = mysqli_query($con, "SELECT * from ext_links WHERE `id` = " . $LinkRes1['id'] . " and status='Complete' ");
					if (mysqli_num_rows($LinkQry2) > 0) {
						$TaskQry3 = mysqli_query($con, "SELECT id from ext_tasks WHERE `linkId` = " . $LinkRes1['id'] . " AND (`status`='Not Started' || `status`='Active' || `status`='Paused') ");
						if (mysqli_num_rows($TaskQry3) > 0) {
							//yet some tasks to be scheduled
						}else{
							//no scheduled task found
							$completedLinkCnt++;
							
						}
						
					}
				}
				
				if($total_links==$completedLinkCnt && $completedLinkCnt>0){
					$lseq_comp = "Processing of the sequence is completed.";
					echo '<br/>LINE:' . __LINE__ . ':::qry::' . "UPDATE ext_sequences SET status='Complete', subStatus='', progress='', step='' WHERE id = " . $seqId;
					
					$updateTask = mysqli_query($con, "UPDATE ext_sequences SET status='Complete', subStatus='', progress='', step='' WHERE id = " . $seqId);
					seqLogNewStatus($seqId, 'Complete', $user['id']);
					//sendMessageToSettings("SequenceUpdated");

					addLogHistory($lseq_comp, $seqId, $user['id']);
					
				}
				
			}*/
			//25May2020 ends
			
        }
    //}
}



function subscriptionCheck($user) {
    echo '<br>LINE:::' . __LINE__ . ':::user::<br/>';
    print_r($user);
    $email = $user['email'];
    $userId = $user['id'];
    $teamid = $user['teamid'];
    $sessionId = base64_encode($userId . '/' . $teamid);
    $postFields = array("email" => $email, "sessionId" => $sessionId);
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => API_ADDRESS . "/check_subscription.php",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => $postFields,
        CURLOPT_HTTPHEADER => array(
            "accept: application/json",
        )
    ));
    $resSubscription = curl_exec($curl);
    echo '<br>LINE:::' . __LINE__ . ':::resSubscription::<br/>';
    print_r($resSubscription);


    if (curl_errno($curl)) {
        $error_msg = curl_error($curl);
    } else {
        $resSubscriptionDecode = json_decode($resSubscription);
        return $resSubscriptionDecode;
    }
}

function substituteTags($userId = "", $msgText = "", $personInfo = "") {

    include('config.php');
    $personData = json_decode($personInfo, true);

    $killwords_suffixQry = mysqli_query($con, "SELECT * from user where id=$userId");
    $killwords_suffix = mysqli_fetch_assoc($killwords_suffixQry);

    $newR = "(" . str_replace(",", "|", $killwords_suffix['killWordsSuffix']) . ")";

    if (isset($personData['firstName']) && $personData['firstName'] != "") {
        $firstName = preg_replace($newR, "", $personData['firstName']);
        $firstName = preg_replace("/[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0077}\x{E006C}\x{E0073}\x{E007F})|[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0073}\x{E0063}\x{E0074}\x{E007F})|[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0065}\x{E006E}\x{E0067}\x{E007F})|[\x{1F3F4}](?:\x{200D}\x{2620}\x{FE0F})|[\x{1F3F3}](?:\x{FE0F}\x{200D}\x{1F308})|[\x{0023}\x{002A}\x{0030}\x{0031}\x{0032}\x{0033}\x{0034}\x{0035}\x{0036}\x{0037}\x{0038}\x{0039}](?:\x{FE0F}\x{20E3})|[\x{1F441}](?:\x{FE0F}\x{200D}\x{1F5E8}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F466})|[\x{1F469}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F469})|[\x{1F469}\x{1F468}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F468})|[\x{1F469}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F48B}\x{200D}\x{1F469})|[\x{1F469}\x{1F468}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F48B}\x{200D}\x{1F468})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B0})|[\x{1F575}\x{1F3CC}\x{26F9}\x{1F3CB}](?:\x{FE0F}\x{200D}\x{2640}\x{FE0F})|[\x{1F575}\x{1F3CC}\x{26F9}\x{1F3CB}](?:\x{FE0F}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FF}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FE}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FD}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FC}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FB}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F9B8}\x{1F9B9}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F9DE}\x{1F9DF}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F46F}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93C}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FF}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FE}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FD}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FC}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FB}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F9B8}\x{1F9B9}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F9DE}\x{1F9DF}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F46F}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93C}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{200D}\x{2642}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2695}\x{FE0F})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FF})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FE})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FD})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FC})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FB})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F8}\x{1F1F9}\x{1F1FA}](?:\x{1F1FF})|[\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F0}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1FA}](?:\x{1F1FE})|[\x{1F1E6}\x{1F1E8}\x{1F1F2}\x{1F1F8}](?:\x{1F1FD})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F7}\x{1F1F9}\x{1F1FF}](?:\x{1F1FC})|[\x{1F1E7}\x{1F1E8}\x{1F1F1}\x{1F1F2}\x{1F1F8}\x{1F1F9}](?:\x{1F1FB})|[\x{1F1E6}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1ED}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F7}\x{1F1FB}](?:\x{1F1FA})|[\x{1F1E6}\x{1F1E7}\x{1F1EA}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FE}](?:\x{1F1F9})|[\x{1F1E6}\x{1F1E7}\x{1F1EA}\x{1F1EC}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F7}\x{1F1F8}\x{1F1FA}\x{1F1FC}](?:\x{1F1F8})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EB}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F0}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1F7})|[\x{1F1E6}\x{1F1E7}\x{1F1EC}\x{1F1EE}\x{1F1F2}](?:\x{1F1F6})|[\x{1F1E8}\x{1F1EC}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F3}](?:\x{1F1F5})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1EE}\x{1F1EF}\x{1F1F2}\x{1F1F3}\x{1F1F7}\x{1F1F8}\x{1F1F9}](?:\x{1F1F4})|[\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}](?:\x{1F1F3})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F4}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FF}](?:\x{1F1F2})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1EE}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1F1})|[\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1ED}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FD}](?:\x{1F1F0})|[\x{1F1E7}\x{1F1E9}\x{1F1EB}\x{1F1F8}\x{1F1F9}](?:\x{1F1EF})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EB}\x{1F1EC}\x{1F1F0}\x{1F1F1}\x{1F1F3}\x{1F1F8}\x{1F1FB}](?:\x{1F1EE})|[\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1ED})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EA}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}](?:\x{1F1EC})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F9}\x{1F1FC}](?:\x{1F1EB})|[\x{1F1E6}\x{1F1E7}\x{1F1E9}\x{1F1EA}\x{1F1EC}\x{1F1EE}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F7}\x{1F1F8}\x{1F1FB}\x{1F1FE}](?:\x{1F1EA})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1EE}\x{1F1F2}\x{1F1F8}\x{1F1F9}](?:\x{1F1E9})|[\x{1F1E6}\x{1F1E8}\x{1F1EA}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F8}\x{1F1F9}\x{1F1FB}](?:\x{1F1E8})|[\x{1F1E7}\x{1F1EC}\x{1F1F1}\x{1F1F8}](?:\x{1F1E7})|[\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F6}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}\x{1F1FF}](?:\x{1F1E6})|[\x{00A9}\x{00AE}\x{203C}\x{2049}\x{2122}\x{2139}\x{2194}-\x{2199}\x{21A9}-\x{21AA}\x{231A}-\x{231B}\x{2328}\x{23CF}\x{23E9}-\x{23F3}\x{23F8}-\x{23FA}\x{24C2}\x{25AA}-\x{25AB}\x{25B6}\x{25C0}\x{25FB}-\x{25FE}\x{2600}-\x{2604}\x{260E}\x{2611}\x{2614}-\x{2615}\x{2618}\x{261D}\x{2620}\x{2622}-\x{2623}\x{2626}\x{262A}\x{262E}-\x{262F}\x{2638}-\x{263A}\x{2640}\x{2642}\x{2648}-\x{2653}\x{2660}\x{2663}\x{2665}-\x{2666}\x{2668}\x{267B}\x{267E}-\x{267F}\x{2692}-\x{2697}\x{2699}\x{269B}-\x{269C}\x{26A0}-\x{26A1}\x{26AA}-\x{26AB}\x{26B0}-\x{26B1}\x{26BD}-\x{26BE}\x{26C4}-\x{26C5}\x{26C8}\x{26CE}-\x{26CF}\x{26D1}\x{26D3}-\x{26D4}\x{26E9}-\x{26EA}\x{26F0}-\x{26F5}\x{26F7}-\x{26FA}\x{26FD}\x{2702}\x{2705}\x{2708}-\x{270D}\x{270F}\x{2712}\x{2714}\x{2716}\x{271D}\x{2721}\x{2728}\x{2733}-\x{2734}\x{2744}\x{2747}\x{274C}\x{274E}\x{2753}-\x{2755}\x{2757}\x{2763}-\x{2764}\x{2795}-\x{2797}\x{27A1}\x{27B0}\x{27BF}\x{2934}-\x{2935}\x{2B05}-\x{2B07}\x{2B1B}-\x{2B1C}\x{2B50}\x{2B55}\x{3030}\x{303D}\x{3297}\x{3299}\x{1F004}\x{1F0CF}\x{1F170}-\x{1F171}\x{1F17E}-\x{1F17F}\x{1F18E}\x{1F191}-\x{1F19A}\x{1F201}-\x{1F202}\x{1F21A}\x{1F22F}\x{1F232}-\x{1F23A}\x{1F250}-\x{1F251}\x{1F300}-\x{1F321}\x{1F324}-\x{1F393}\x{1F396}-\x{1F397}\x{1F399}-\x{1F39B}\x{1F39E}-\x{1F3F0}\x{1F3F3}-\x{1F3F5}\x{1F3F7}-\x{1F3FA}\x{1F400}-\x{1F4FD}\x{1F4FF}-\x{1F53D}\x{1F549}-\x{1F54E}\x{1F550}-\x{1F567}\x{1F56F}-\x{1F570}\x{1F573}-\x{1F57A}\x{1F587}\x{1F58A}-\x{1F58D}\x{1F590}\x{1F595}-\x{1F596}\x{1F5A4}-\x{1F5A5}\x{1F5A8}\x{1F5B1}-\x{1F5B2}\x{1F5BC}\x{1F5C2}-\x{1F5C4}\x{1F5D1}-\x{1F5D3}\x{1F5DC}-\x{1F5DE}\x{1F5E1}\x{1F5E3}\x{1F5E8}\x{1F5EF}\x{1F5F3}\x{1F5FA}-\x{1F64F}\x{1F680}-\x{1F6C5}\x{1F6CB}-\x{1F6D2}\x{1F6E0}-\x{1F6E5}\x{1F6E9}\x{1F6EB}-\x{1F6EC}\x{1F6F0}\x{1F6F3}-\x{1F6F9}\x{1F910}-\x{1F93A}\x{1F93C}-\x{1F93E}\x{1F940}-\x{1F945}\x{1F947}-\x{1F970}\x{1F973}-\x{1F976}\x{1F97A}\x{1F97C}-\x{1F9A2}\x{1F9B0}-\x{1F9B9}\x{1F9C0}-\x{1F9C2}\x{1F9D0}-\x{1F9FF}]/u", "", $personData['firstName']);

        if (preg_match("/\{\s*first\s*name\s*\|\s*(.*?)\}/", $msgText)) {
            $msgText = preg_replace('/\{\s*first\s*name\s*\|\s*(.*?)\}/', $firstName, $msgText);
        }
    } else {
        preg_match('/\{\s*first\s*name\s*\|\s*(.*?)\}/', $msgText, $matches);
        if (!empty($matches)) {
            $firstNameText = explode("|", $matches[0])[1];
            $firstNameText = str_replace('fallback:"', "", $firstNameText);
            $firstNameText = trim(str_replace('"}', "", $firstNameText));

            if (preg_match("/\{\s*first\s*name\s*\|\s*(.*?)\}/", $msgText)) {
                $msgText = preg_replace('/\{\s*first\s*name\s*\|\s*(.*?)\}/', $firstNameText, $msgText);
            }
        }
    }

    if (isset($personData['lastName']) && $personData['lastName'] != "") {
        $lastName = preg_replace($newR, "", $personData['lastName']);
        $lastName = preg_replace("/[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0077}\x{E006C}\x{E0073}\x{E007F})|[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0073}\x{E0063}\x{E0074}\x{E007F})|[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0065}\x{E006E}\x{E0067}\x{E007F})|[\x{1F3F4}](?:\x{200D}\x{2620}\x{FE0F})|[\x{1F3F3}](?:\x{FE0F}\x{200D}\x{1F308})|[\x{0023}\x{002A}\x{0030}\x{0031}\x{0032}\x{0033}\x{0034}\x{0035}\x{0036}\x{0037}\x{0038}\x{0039}](?:\x{FE0F}\x{20E3})|[\x{1F441}](?:\x{FE0F}\x{200D}\x{1F5E8}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F466})|[\x{1F469}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F469})|[\x{1F469}\x{1F468}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F468})|[\x{1F469}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F48B}\x{200D}\x{1F469})|[\x{1F469}\x{1F468}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F48B}\x{200D}\x{1F468})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B0})|[\x{1F575}\x{1F3CC}\x{26F9}\x{1F3CB}](?:\x{FE0F}\x{200D}\x{2640}\x{FE0F})|[\x{1F575}\x{1F3CC}\x{26F9}\x{1F3CB}](?:\x{FE0F}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FF}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FE}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FD}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FC}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FB}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F9B8}\x{1F9B9}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F9DE}\x{1F9DF}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F46F}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93C}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FF}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FE}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FD}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FC}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FB}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F9B8}\x{1F9B9}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F9DE}\x{1F9DF}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F46F}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93C}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{200D}\x{2642}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2695}\x{FE0F})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FF})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FE})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FD})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FC})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FB})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F8}\x{1F1F9}\x{1F1FA}](?:\x{1F1FF})|[\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F0}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1FA}](?:\x{1F1FE})|[\x{1F1E6}\x{1F1E8}\x{1F1F2}\x{1F1F8}](?:\x{1F1FD})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F7}\x{1F1F9}\x{1F1FF}](?:\x{1F1FC})|[\x{1F1E7}\x{1F1E8}\x{1F1F1}\x{1F1F2}\x{1F1F8}\x{1F1F9}](?:\x{1F1FB})|[\x{1F1E6}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1ED}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F7}\x{1F1FB}](?:\x{1F1FA})|[\x{1F1E6}\x{1F1E7}\x{1F1EA}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FE}](?:\x{1F1F9})|[\x{1F1E6}\x{1F1E7}\x{1F1EA}\x{1F1EC}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F7}\x{1F1F8}\x{1F1FA}\x{1F1FC}](?:\x{1F1F8})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EB}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F0}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1F7})|[\x{1F1E6}\x{1F1E7}\x{1F1EC}\x{1F1EE}\x{1F1F2}](?:\x{1F1F6})|[\x{1F1E8}\x{1F1EC}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F3}](?:\x{1F1F5})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1EE}\x{1F1EF}\x{1F1F2}\x{1F1F3}\x{1F1F7}\x{1F1F8}\x{1F1F9}](?:\x{1F1F4})|[\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}](?:\x{1F1F3})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F4}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FF}](?:\x{1F1F2})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1EE}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1F1})|[\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1ED}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FD}](?:\x{1F1F0})|[\x{1F1E7}\x{1F1E9}\x{1F1EB}\x{1F1F8}\x{1F1F9}](?:\x{1F1EF})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EB}\x{1F1EC}\x{1F1F0}\x{1F1F1}\x{1F1F3}\x{1F1F8}\x{1F1FB}](?:\x{1F1EE})|[\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1ED})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EA}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}](?:\x{1F1EC})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F9}\x{1F1FC}](?:\x{1F1EB})|[\x{1F1E6}\x{1F1E7}\x{1F1E9}\x{1F1EA}\x{1F1EC}\x{1F1EE}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F7}\x{1F1F8}\x{1F1FB}\x{1F1FE}](?:\x{1F1EA})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1EE}\x{1F1F2}\x{1F1F8}\x{1F1F9}](?:\x{1F1E9})|[\x{1F1E6}\x{1F1E8}\x{1F1EA}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F8}\x{1F1F9}\x{1F1FB}](?:\x{1F1E8})|[\x{1F1E7}\x{1F1EC}\x{1F1F1}\x{1F1F8}](?:\x{1F1E7})|[\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F6}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}\x{1F1FF}](?:\x{1F1E6})|[\x{00A9}\x{00AE}\x{203C}\x{2049}\x{2122}\x{2139}\x{2194}-\x{2199}\x{21A9}-\x{21AA}\x{231A}-\x{231B}\x{2328}\x{23CF}\x{23E9}-\x{23F3}\x{23F8}-\x{23FA}\x{24C2}\x{25AA}-\x{25AB}\x{25B6}\x{25C0}\x{25FB}-\x{25FE}\x{2600}-\x{2604}\x{260E}\x{2611}\x{2614}-\x{2615}\x{2618}\x{261D}\x{2620}\x{2622}-\x{2623}\x{2626}\x{262A}\x{262E}-\x{262F}\x{2638}-\x{263A}\x{2640}\x{2642}\x{2648}-\x{2653}\x{2660}\x{2663}\x{2665}-\x{2666}\x{2668}\x{267B}\x{267E}-\x{267F}\x{2692}-\x{2697}\x{2699}\x{269B}-\x{269C}\x{26A0}-\x{26A1}\x{26AA}-\x{26AB}\x{26B0}-\x{26B1}\x{26BD}-\x{26BE}\x{26C4}-\x{26C5}\x{26C8}\x{26CE}-\x{26CF}\x{26D1}\x{26D3}-\x{26D4}\x{26E9}-\x{26EA}\x{26F0}-\x{26F5}\x{26F7}-\x{26FA}\x{26FD}\x{2702}\x{2705}\x{2708}-\x{270D}\x{270F}\x{2712}\x{2714}\x{2716}\x{271D}\x{2721}\x{2728}\x{2733}-\x{2734}\x{2744}\x{2747}\x{274C}\x{274E}\x{2753}-\x{2755}\x{2757}\x{2763}-\x{2764}\x{2795}-\x{2797}\x{27A1}\x{27B0}\x{27BF}\x{2934}-\x{2935}\x{2B05}-\x{2B07}\x{2B1B}-\x{2B1C}\x{2B50}\x{2B55}\x{3030}\x{303D}\x{3297}\x{3299}\x{1F004}\x{1F0CF}\x{1F170}-\x{1F171}\x{1F17E}-\x{1F17F}\x{1F18E}\x{1F191}-\x{1F19A}\x{1F201}-\x{1F202}\x{1F21A}\x{1F22F}\x{1F232}-\x{1F23A}\x{1F250}-\x{1F251}\x{1F300}-\x{1F321}\x{1F324}-\x{1F393}\x{1F396}-\x{1F397}\x{1F399}-\x{1F39B}\x{1F39E}-\x{1F3F0}\x{1F3F3}-\x{1F3F5}\x{1F3F7}-\x{1F3FA}\x{1F400}-\x{1F4FD}\x{1F4FF}-\x{1F53D}\x{1F549}-\x{1F54E}\x{1F550}-\x{1F567}\x{1F56F}-\x{1F570}\x{1F573}-\x{1F57A}\x{1F587}\x{1F58A}-\x{1F58D}\x{1F590}\x{1F595}-\x{1F596}\x{1F5A4}-\x{1F5A5}\x{1F5A8}\x{1F5B1}-\x{1F5B2}\x{1F5BC}\x{1F5C2}-\x{1F5C4}\x{1F5D1}-\x{1F5D3}\x{1F5DC}-\x{1F5DE}\x{1F5E1}\x{1F5E3}\x{1F5E8}\x{1F5EF}\x{1F5F3}\x{1F5FA}-\x{1F64F}\x{1F680}-\x{1F6C5}\x{1F6CB}-\x{1F6D2}\x{1F6E0}-\x{1F6E5}\x{1F6E9}\x{1F6EB}-\x{1F6EC}\x{1F6F0}\x{1F6F3}-\x{1F6F9}\x{1F910}-\x{1F93A}\x{1F93C}-\x{1F93E}\x{1F940}-\x{1F945}\x{1F947}-\x{1F970}\x{1F973}-\x{1F976}\x{1F97A}\x{1F97C}-\x{1F9A2}\x{1F9B0}-\x{1F9B9}\x{1F9C0}-\x{1F9C2}\x{1F9D0}-\x{1F9FF}]/u", "", $personData['lastName']);
        if (preg_match("/\{\s*last\s*name\s*\|\s*(.*?)\}/", $msgText)) {
            $msgText = preg_replace('/\{\s*last\s*name\s*\|\s*(.*?)\}/', $lastName, $msgText);
        }
    } else {
        preg_match('/\{\s*last\s*name\s*\|\s*(.*?)\}/', $msgText, $matches);
        if (!empty($matches)) {
            $lastNameText = explode("|", $matches[0])[1];
            $lastNameText = str_replace('fallback:"', "", $lastNameText);
            $lastNameText = trim(str_replace('"}', "", $lastNameText));

            if (preg_match("/\{\s*last\s*name\s*\|\s*(.*?)\}/", $msgText)) {
                $msgText = preg_replace('/\{\s*last\s*name\s*\|\s*(.*?)\}/', $lastNameText, $msgText);
            }
        }
    }

    if (isset($personData['fullName']) && $personData['fullName'] != "") {
        $fullName = preg_replace($newR, "", $personData['fullName']);
        $fullName = preg_replace("/[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0077}\x{E006C}\x{E0073}\x{E007F})|[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0073}\x{E0063}\x{E0074}\x{E007F})|[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0065}\x{E006E}\x{E0067}\x{E007F})|[\x{1F3F4}](?:\x{200D}\x{2620}\x{FE0F})|[\x{1F3F3}](?:\x{FE0F}\x{200D}\x{1F308})|[\x{0023}\x{002A}\x{0030}\x{0031}\x{0032}\x{0033}\x{0034}\x{0035}\x{0036}\x{0037}\x{0038}\x{0039}](?:\x{FE0F}\x{20E3})|[\x{1F441}](?:\x{FE0F}\x{200D}\x{1F5E8}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F466})|[\x{1F469}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F469})|[\x{1F469}\x{1F468}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F468})|[\x{1F469}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F48B}\x{200D}\x{1F469})|[\x{1F469}\x{1F468}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F48B}\x{200D}\x{1F468})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B0})|[\x{1F575}\x{1F3CC}\x{26F9}\x{1F3CB}](?:\x{FE0F}\x{200D}\x{2640}\x{FE0F})|[\x{1F575}\x{1F3CC}\x{26F9}\x{1F3CB}](?:\x{FE0F}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FF}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FE}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FD}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FC}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FB}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F9B8}\x{1F9B9}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F9DE}\x{1F9DF}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F46F}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93C}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FF}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FE}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FD}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FC}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FB}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F9B8}\x{1F9B9}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F9DE}\x{1F9DF}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F46F}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93C}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{200D}\x{2642}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2695}\x{FE0F})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FF})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FE})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FD})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FC})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FB})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F8}\x{1F1F9}\x{1F1FA}](?:\x{1F1FF})|[\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F0}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1FA}](?:\x{1F1FE})|[\x{1F1E6}\x{1F1E8}\x{1F1F2}\x{1F1F8}](?:\x{1F1FD})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F7}\x{1F1F9}\x{1F1FF}](?:\x{1F1FC})|[\x{1F1E7}\x{1F1E8}\x{1F1F1}\x{1F1F2}\x{1F1F8}\x{1F1F9}](?:\x{1F1FB})|[\x{1F1E6}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1ED}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F7}\x{1F1FB}](?:\x{1F1FA})|[\x{1F1E6}\x{1F1E7}\x{1F1EA}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FE}](?:\x{1F1F9})|[\x{1F1E6}\x{1F1E7}\x{1F1EA}\x{1F1EC}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F7}\x{1F1F8}\x{1F1FA}\x{1F1FC}](?:\x{1F1F8})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EB}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F0}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1F7})|[\x{1F1E6}\x{1F1E7}\x{1F1EC}\x{1F1EE}\x{1F1F2}](?:\x{1F1F6})|[\x{1F1E8}\x{1F1EC}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F3}](?:\x{1F1F5})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1EE}\x{1F1EF}\x{1F1F2}\x{1F1F3}\x{1F1F7}\x{1F1F8}\x{1F1F9}](?:\x{1F1F4})|[\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}](?:\x{1F1F3})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F4}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FF}](?:\x{1F1F2})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1EE}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1F1})|[\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1ED}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FD}](?:\x{1F1F0})|[\x{1F1E7}\x{1F1E9}\x{1F1EB}\x{1F1F8}\x{1F1F9}](?:\x{1F1EF})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EB}\x{1F1EC}\x{1F1F0}\x{1F1F1}\x{1F1F3}\x{1F1F8}\x{1F1FB}](?:\x{1F1EE})|[\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1ED})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EA}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}](?:\x{1F1EC})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F9}\x{1F1FC}](?:\x{1F1EB})|[\x{1F1E6}\x{1F1E7}\x{1F1E9}\x{1F1EA}\x{1F1EC}\x{1F1EE}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F7}\x{1F1F8}\x{1F1FB}\x{1F1FE}](?:\x{1F1EA})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1EE}\x{1F1F2}\x{1F1F8}\x{1F1F9}](?:\x{1F1E9})|[\x{1F1E6}\x{1F1E8}\x{1F1EA}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F8}\x{1F1F9}\x{1F1FB}](?:\x{1F1E8})|[\x{1F1E7}\x{1F1EC}\x{1F1F1}\x{1F1F8}](?:\x{1F1E7})|[\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F6}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}\x{1F1FF}](?:\x{1F1E6})|[\x{00A9}\x{00AE}\x{203C}\x{2049}\x{2122}\x{2139}\x{2194}-\x{2199}\x{21A9}-\x{21AA}\x{231A}-\x{231B}\x{2328}\x{23CF}\x{23E9}-\x{23F3}\x{23F8}-\x{23FA}\x{24C2}\x{25AA}-\x{25AB}\x{25B6}\x{25C0}\x{25FB}-\x{25FE}\x{2600}-\x{2604}\x{260E}\x{2611}\x{2614}-\x{2615}\x{2618}\x{261D}\x{2620}\x{2622}-\x{2623}\x{2626}\x{262A}\x{262E}-\x{262F}\x{2638}-\x{263A}\x{2640}\x{2642}\x{2648}-\x{2653}\x{2660}\x{2663}\x{2665}-\x{2666}\x{2668}\x{267B}\x{267E}-\x{267F}\x{2692}-\x{2697}\x{2699}\x{269B}-\x{269C}\x{26A0}-\x{26A1}\x{26AA}-\x{26AB}\x{26B0}-\x{26B1}\x{26BD}-\x{26BE}\x{26C4}-\x{26C5}\x{26C8}\x{26CE}-\x{26CF}\x{26D1}\x{26D3}-\x{26D4}\x{26E9}-\x{26EA}\x{26F0}-\x{26F5}\x{26F7}-\x{26FA}\x{26FD}\x{2702}\x{2705}\x{2708}-\x{270D}\x{270F}\x{2712}\x{2714}\x{2716}\x{271D}\x{2721}\x{2728}\x{2733}-\x{2734}\x{2744}\x{2747}\x{274C}\x{274E}\x{2753}-\x{2755}\x{2757}\x{2763}-\x{2764}\x{2795}-\x{2797}\x{27A1}\x{27B0}\x{27BF}\x{2934}-\x{2935}\x{2B05}-\x{2B07}\x{2B1B}-\x{2B1C}\x{2B50}\x{2B55}\x{3030}\x{303D}\x{3297}\x{3299}\x{1F004}\x{1F0CF}\x{1F170}-\x{1F171}\x{1F17E}-\x{1F17F}\x{1F18E}\x{1F191}-\x{1F19A}\x{1F201}-\x{1F202}\x{1F21A}\x{1F22F}\x{1F232}-\x{1F23A}\x{1F250}-\x{1F251}\x{1F300}-\x{1F321}\x{1F324}-\x{1F393}\x{1F396}-\x{1F397}\x{1F399}-\x{1F39B}\x{1F39E}-\x{1F3F0}\x{1F3F3}-\x{1F3F5}\x{1F3F7}-\x{1F3FA}\x{1F400}-\x{1F4FD}\x{1F4FF}-\x{1F53D}\x{1F549}-\x{1F54E}\x{1F550}-\x{1F567}\x{1F56F}-\x{1F570}\x{1F573}-\x{1F57A}\x{1F587}\x{1F58A}-\x{1F58D}\x{1F590}\x{1F595}-\x{1F596}\x{1F5A4}-\x{1F5A5}\x{1F5A8}\x{1F5B1}-\x{1F5B2}\x{1F5BC}\x{1F5C2}-\x{1F5C4}\x{1F5D1}-\x{1F5D3}\x{1F5DC}-\x{1F5DE}\x{1F5E1}\x{1F5E3}\x{1F5E8}\x{1F5EF}\x{1F5F3}\x{1F5FA}-\x{1F64F}\x{1F680}-\x{1F6C5}\x{1F6CB}-\x{1F6D2}\x{1F6E0}-\x{1F6E5}\x{1F6E9}\x{1F6EB}-\x{1F6EC}\x{1F6F0}\x{1F6F3}-\x{1F6F9}\x{1F910}-\x{1F93A}\x{1F93C}-\x{1F93E}\x{1F940}-\x{1F945}\x{1F947}-\x{1F970}\x{1F973}-\x{1F976}\x{1F97A}\x{1F97C}-\x{1F9A2}\x{1F9B0}-\x{1F9B9}\x{1F9C0}-\x{1F9C2}\x{1F9D0}-\x{1F9FF}]/u", "", $personData['fullName']);
        if (preg_match("/\{\s*full\s*name\s*\|\s*(.*?)\}/", $msgText)) {
            $msgText = preg_replace('/\{\s*full\s*name\s*\|\s*(.*?)\}/', $fullName, $msgText);
        }
    } else {
        preg_match('/\{\s*full\s*name\s*\|\s*(.*?)\}/', $msgText, $matches);
        if (!empty($matches)) {
            $fullNameText = explode("|", $matches[0])[1];
            $fullNameText = str_replace('fallback:"', "", $fullNameText);
            $fullNameText = trim(str_replace('"}', "", $fullNameText));

            if (preg_match("/\{\s*full\s*name\s*\|\s*(.*?)\}/", $msgText)) {
                $msgText = preg_replace('/\{\s*full\s*name\s*\|\s*(.*?)\}/', $fullNameText, $msgText);
            }
        }
    }

    if (isset($personData['industries']) && !empty($personData['industries'])) {
        for ($i = 0; $i < count($personData['industries']); $i++) {
            if ($i == 0 && !empty($personData['industries'][$i])) {
                $personData['industries'][$i];
                if (preg_match("/\{\s*indu\s*stries\s*\|\s*(.*?)\}/", $msgText)) {
                    $msgText = preg_replace('/\{\s*indu\s*stries\s*\|\s*(.*?)\}/', $personData['industries'][$i], $msgText);
                }
            }
        }
    } else {
        preg_match('/\{\s*indu\s*stries\s*\|\s*(.*?)\}/', $msgText, $matches);
        if (!empty($matches)) {
            $industriesText = explode("|", $matches[0])[1];
            $industriesText = str_replace('fallback:"', "", $industriesText);
            $industriesText = trim(str_replace('"}', "", $industriesText));
            if (preg_match("/\{\s*indu\s*stries\s*\|\s*(.*?)\}/", $msgText)) {
                $msgText = preg_replace('/\{\s*indu\s*stries\s*\|\s*(.*?)\}/', $industriesText, $msgText);
            }
        }
    }

    if (isset($personData['locationName']) && $personData['locationName'] != "") {
        if (preg_match("/\{\s*loca\s*tion\s*\|\s*(.*?)\}/", $msgText)) {
            $msgText = preg_replace('/\{\s*loca\s*tion\s*\|\s*(.*?)\}/', $personData['locationName'], $msgText);
        }
    } else {
        preg_match('/\{\s*loca\s*tion\s*\|\s*(.*?)\}/', $msgText, $matches);
        if (!empty($matches)) {
            $locationNameText = explode("|", $matches[0])[1];
            $locationNameText = str_replace('fallback:"', "", $locationNameText);
            $locationNameText = trim(str_replace('"}', "", $locationNameText));
            if (preg_match("/\{\s*loca\s*tion\s*\|\s*(.*?)\}/", $msgText)) {
                $msgText = preg_replace('/\{\s*loca\s*tion\s*\|\s*(.*?)\}/', $locationNameText, $msgText);
            }
        }
    }

    if (isset($personData['experiences']) && !empty($personData['experiences'])) {
        for ($i = 0; $i < count($personData['experiences']); $i++) {
            if (!empty($personData['experiences'][$i]) && $i == 0) {
                $personData['experiences'][$i]['company'];
                if (preg_match("/{\s*company\s*(\d+)\s*\|\s*(.*?)}/", $msgText)) {
                    $msgText = preg_replace('/{\s*company\s*(\d+)\s*\|\s*(.*?)}/', $personData['experiences'][$i]['company'], $msgText);
                }
            }
        }
    } else {
        preg_match('/{\s*company\s*(\d+)\s*\|\s*(.*?)}/', $msgText, $matches);
        if (!empty($matches)) {
            $companyText = explode("|", $matches[0])[1];
            $companyText = str_replace('fallback:"', "", $companyText);
            $companyText = trim(str_replace('"}', "", $companyText));
            if (preg_match("/{\s*company\s*(\d+)\s*\|\s*(.*?)}/", $msgText)) {
                $msgText = preg_replace('/{\s*company\s*(\d+)\s*\|\s*(.*?)}/', $companyText, $msgText);
            }
        }
    }

    if (isset($personData['educations']) && !empty($personData['educations'])) {
        for ($i = 0; $i < count($personData['educations']); $i++) {
            if (!empty($personData['educations'][$i]) && $i == 0) {
                if (preg_match("/{\s*edu(?:cation)?\s*(\d+)\s*\|\s*(.*?)}/", $msgText)) {
                    $msgText = preg_replace('/{\s*edu(?:cation)?\s*(\d+)\s*\|\s*(.*?)}/', $personData['educations'][$i]['degree_institution'], $msgText);
                }
            }
        }
    } else {
        preg_match('/{\s*edu(?:cation)?\s*(\d+)\s*\|\s*(.*?)}/', $msgText, $matches);
        if (!empty($matches)) {
            $educationsText = explode("|", $matches[0])[1];
            $educationsText = str_replace('fallback:"', "", $educationsText);
            $educationsText = trim(str_replace('"}', "", $educationsText));
            if (preg_match("/{\s*edu(?:cation)?\s*(\d+)\s*\|\s*(.*?)}/", $msgText)) {
                $msgText = preg_replace('/{\s*edu(?:cation)?\s*(\d+)\s*\|\s*(.*?)}/', $educationsText, $msgText);
            }
        }
    }
    return $msgText;
}

//Use: entry in ext_nomoreprospect and client get email: "Sequence is out of Target Audience"
function noMoreProspect($user, $seqData) {
    include('config.php');
    $getEmailID = $user['email'];
    $userId = $user['id'];
    $seqID = $seqData['id'];
    $seqName = $seqData['name'];


    $nomoreProspectQry = mysqli_query($con, "SELECT * from ext_nomoreprospect where seqId=$seqID and seqName='$seqName' and userId=$userId");
    $nomoreProspectData = mysqli_fetch_assoc($nomoreProspectQry);

    if ($nomoreProspectQry->num_rows > 0) {
        echo "Already exist in DB. No Need to email";
    } else {
        $addTask = "INSERT INTO ext_nomoreprospect (`seqId`, `seqName`, `userId`) VALUES (" . $seqID . ", '" . addslashes($seqName) . "', " . $userId . ")";
        $taskQryExcute = mysqli_query($con, $addTask);

        $postFields = array("seq_seqID" => $seqID, "seq_Name" => $seqName, "user_email" => $getEmailID, "user_id" => $userId);
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => API_ADDRESS . "/sendNPMail.php",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $postFields,
            CURLOPT_HTTPHEADER => array(
                "accept: application/json",
            )
        ));
        echo $resSubscription = curl_exec($curl);
    }
}

// Ravi Bhuva ends
// Ankit + Trupal
function fetchFromDb($user, $sequence, $task) {
    echo '<br/>LINE::' . __LINE__ . ':: in fetchFromDb<br/>';
    include('config.php');
    $cookie = $user['cookie'];
    $csrf = $user['csrf'];
    $proxyIp = $user['proxyIp'];
    $proxyPort = $user['proxyPort'];
    $proxyUsername = $user['proxyUsername'];
    $proxyPassword = $user['proxyPassword'];
    $userAgent = $user['userAgent'];
    $sessionId = base64_encode($user['id'] . '/' . $user['teamid']);

    $postDataArr = array();
    $postDataArr['sessionId'] = $sessionId;
    $postDataArr['seqId'] = $sequence['id'];
	echo '<pre>';
	print_r($postDataArr);
    $curlUrl = API_ADDRESS . "/getCsvProfiles.php";
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => $curlUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => $postDataArr,
        CURLOPT_HTTPHEADER => array(
            "accept: application/json; charset\x3dutf-8",
            "x-requested-with: XMLHttpRequest",
            "x-restli-protocol-version: 2.0.0"
        )
    ));

    $res = curl_exec($curl);
	echo '<pre>';print_r($res);
    if (curl_errno($curl)) {
        $error_msg = curl_error($curl);
    } else {
        echo '<br/>LINE::' . __LINE__ . ':: within fetchFromDb<br/>';
        if (!empty($res) && strpos('[]', $res) != 0) {
            $responseData = json_decode($res);
            foreach ($responseData as $key => $value) {
                if (strpos($value, "sales/people/")) {
                    echo '<br/>LINE::' . __LINE__ . ':: within fetchFromDb<br/>'; 
                    $lId = explode('sales/people/', $value)[1];
                    //$lId = explode(',', $lId)[0];
                    $curlProfile = curl_init();
                    curl_setopt_array($curlProfile, array(
                        CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $lId . "/profileView",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 30,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_HTTPPROXYTUNNEL => 1,
                        CURLOPT_PROXY => "$proxyIp",
                        CURLOPT_PROXYPORT => "$proxyPort",
                        CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                        CURLOPT_CUSTOMREQUEST => "GET",
                        CURLOPT_HTTPHEADER => array(
                            "cookie: $cookie",
                            "csrf-token: $csrf",
                            "x-http-method-override: GET",
                            "Host: www.linkedin.com",
                            "User-Agent: $userAgent",
                            "Accept-Language: en-US,en;q=0.5",
                            "Accept-Encoding: gzip, deflate, br",
                            "content-type: application/x-www-form-urlencoded",
                            "x-li-lang: en_US",
                            "x-restli-protocol-version: 2.0.0",
                            "Origin: https://www.linkedin.com",
                            "TE: Trailers"
                        )
                    ));

                    $resProfile = curl_exec($curlProfile);
                    if (curl_errno($curlProfile)) {
                        $error_msg = curl_error($curlProfile);
                        addLogHistory($error_msg, $sequence['id'], $user['id'], 1);
                    } else {
                        $profile = json_decode($resProfile);
                        echo '<br/>LINE::' . __LINE__ . ':: within fetchFromDb<br/><pre>';
                        print_r($profile);
                        if (!empty($profile->profile->miniProfile)) {
                            $publicIdentifier = $profile->profile->miniProfile->publicIdentifier;
                            $profileId = "https://www.linkedin.com/in/" . $publicIdentifier;
                            sendCsvInvitations($user, $profileId, $seqId);
                        }
                    }
                    curl_close($curlProfile);
                } else {
                    echo '<br/>LINE::' . __LINE__ . ':: within fetchFromDb<br/>';
                    sendCSVInvitations($user, $value, $sequence['id']);
                }
            }
        } else {
            if (!empty($res) && strpos('[]', $res) != 0) {
                echo '<br/>LINE::' . __LINE__ . ':: within fetchFromDb<br/>';
                return 1;
            } else {
                echo '<br/>LINE::' . __LINE__ . ':: within fetchFromDb<br/>';
                if (!empty($task)) {
                    if (mysqli_query($con, "UPDATE ext_tasks SET status='Complete', subStatus='', progress='', step='' WHERE id=" . $task['id'])) {
                        echo '<br/>LINE::' . __LINE__ . ':: within fetchFromDb<br/>';
                        seqLogNewStatus($sequence['id'], 'Complete');
                        sendMessageToSettings("SequenceUpdated");
                    }
                }
                $lseq_comp = "Processing of the sequence is complete.";
                addLogHistory($lseq_comp, $sequence['id'], $user['id']);
                return 0;
            }
        }
    }
    curl_close($curl);
}

// Ankit + Trupal
function setUriParam($link, $param, $value) {
    if (!strpos($link, "?")) {
        $linkArr = array();
    } else {
        $splitedString = str_replace("%2520", "%20", substr($link, strpos($link, "?") + 1));
        $splitedString = str_replace("(", "%28", $splitedString);
        $splitedString = str_replace(")", "%29", $splitedString);
        parse_str($splitedString, $linkArr);
    }
    $exist = ((array_key_exists($param, $linkArr)) && trim($linkArr[$param]) == $value);
    if ($exist) {
        return $link;
    } else {
        if (!empty($linkArr)) {
            if (array_key_exists($param, $linkArr)) {
                $oldVal = $param . '=' . $linkArr[$param];
                $newVal = $param . '=' . $value;
                $link = str_replace($oldVal, $newVal, $link);
                return $link;
            } else {
                return $link . '&' . $param . '=' . $value;
            }
        } else {
            $link = str_replace((!empty($linkArr[$param])) ? '?' . $param . '=' . $linkArr[$param] : '', "", $link);
            return $link . '?' . $param . '=' . $value;
        }
    }
}

//NR chekBlacklistblendedsearch 25May2020 starts
function chekBlacklistblendedsearch($post_blacklistCompany,$post_msg,$sessionId,$searchData){
	//header("Access-Control-Allow-Origin:*");
	//header("Access-Control-Allow-Credentials:true");
	//header("Access-Control-Allow-Methods: OPTIONS, GET, POST");
	//header("Access-Control-Allow-Headers: Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
//echo '<br/>LINE:'.__LINE__.'::In chekBlacklistblendedsearch<br/>';
//echo '<br/>LINE:'.__LINE__.'::post_blacklistCompany:';print_r($post_blacklistCompany);
//echo '<br/>LINE:'.__LINE__.'::post_msg:';print_r($post_msg);
//echo '<br/>LINE:'.__LINE__.'::sessionId:';print_r($sessionId);
//echo '<br/>LINE:'.__LINE__.'::searchData:';echo '<pre>';print_r($searchData);echo '</pre>';
	include "config.php";
	ini_set('max_execution_time', '0');

	// Here we have to check Blacklisted users from db and change the search result and return it...
	//$data = $_POST["searchData"];
	//$data = str_replace("com.linkedin.voyager.search.SearchProfile","com_linkedin_voyager_search_SearchProfile",json_encode($_POST["searchData"]));
	$data = str_replace("com.linkedin.voyager.search.SearchProfile","com_linkedin_voyager_search_SearchProfile",json_encode($searchData));
	//echo $data;

	$session_id =$sessionId;//$_POST['sessionId'];

	$return_array= array();

	if($session_id != '' ){
		$session_id1 = base64_decode($session_id);
		$session_id1 =explode("/",$session_id1);
	}   
		/* //Use this to block people from sending any new requests
		if($session_id1[0] == 364 || $session_id1[0] == 390 || $session_id1[0] == 396 || $session_id1[0] == 818 || $session_id1[0] == 932 || $session_id1[0] == 933 || $session_id1[0] == 1305 || $session_id1[0] == 593 )
		die(); */

		$searchData = json_decode($data);

		$return_array = [];

		//$check_onAccept = $con->query("SELECT * FROM `user` WHERE id ='".$session_id1[0]."' AND `addBlaklist_OnAcceptance` = '1' ");
		//$checkForAcceptance = "";
		//$check_BlackList = $con->query("SELECT * FROM `user` WHERE id ='".$session_id1[0]."' AND `skip_Blacklist` = 0 ");
		
		//stars
		$check_onAccept = mysqli_query($con, "SELECT * FROM `user` WHERE id ='".$session_id1[0]."' AND `addBlaklist_OnAcceptance` = '1' ");
		$checkForAcceptance = "";
		$check_BlackList = mysqli_query($con, "SELECT * FROM `user` WHERE id ='".$session_id1[0]."' AND `skip_Blacklist` = 0 ");
		//ends
		
		if (mysqli_num_rows($check_onAccept) > 0 ){
				$checkForAcceptance .= " AND is_accepted = 1 ";
			}
			$msg = 0;
			if (isset($post_msg))
				$msg = $post_msg;

		foreach($searchData as $checkData){
			//print_r($checkData->targetPageInstance);
			if(isset($checkData->publicIdentifier))
				$publicIdentifier = $checkData->publicIdentifier;
			
				

			if(isset($checkData->trackingUrn))
				$objectUrn = $checkData->trackingUrn;
						
			preg_match_all('!\d+!', $objectUrn, $linkediobjectUrn);
			if(!isset($linkediobjectUrn[0][0])){
				continue;
			}
			//print_r($linkediobjectUrn[0]);

			//$sql_publicIdentifier = $con->query("SELECT linkedinpublicid FROM blacklist where linkedinpublicid ='".$publicIdentifier."' And teamid ='".$session_id1[1]."' ");
			
			//$sql = $con->query("SELECT linkedinpublicid FROM blacklist where  `deleted_at` IS NULL And    ( linkedinpublicid ='".$linkediobjectUrn[0][0]."' Or url_publicIdentifier  ='".$publicIdentifier."' ) And teamid ='".$session_id1[1]."' $checkForAcceptance ");
			//Arpan Changes in SQL query as we are no longer using deleted_at field.
			//$sql = $con->query("SELECT linkedinpublicid FROM blacklist where `flag`= 0 AND ( linkedinpublicid ='".$linkediobjectUrn[0][0]."' OR url_publicIdentifier  ='".$publicIdentifier."' ) AND teamid ='".$session_id1[1]."' $checkForAcceptance ");
			
			$sql = mysqli_query($con, "SELECT linkedinpublicid FROM blacklist where `flag`= 0 AND ( linkedinpublicid ='".$linkediobjectUrn[0][0]."' OR url_publicIdentifier  ='".$publicIdentifier."' ) AND teamid ='".$session_id1[1]."' $checkForAcceptance ");
			
			//print_r($sql);
			if (mysqli_num_rows($check_BlackList) > 0 ){
			if (mysqli_num_rows($sql) > 0 && $msg == 0){
				//print_r($linkediobjectUrn[0]);
				continue;
				
			}
	}
			array_push($return_array,$checkData);			
		 
		}

			//	print_r(str_replace("com_linkedin_voyager_search_SearchProfile","com.linkedin.voyager.search.SearchProfile",json_encode($return_array)));

			if(isset($post_blacklistCompany)){
		//echo "123"; die();
				//$sql = $con->query("SELECT `company_id` ,`company_name` FROM `blacklistcompany` WHERE `user_id` = '".$session_id1[0]."' or  `user_id` = '".$session_id1[1]."' ");
				$sql = mysqli_query($con, "SELECT `company_id` ,`company_name` FROM `blacklistcompany` WHERE `user_id` = '".$session_id1[0]."' or  `user_id` = '".$session_id1[1]."' ");
				$blacklistcompany = [];
				if (mysqli_num_rows($sql) > 0){
					while($row = mysqli_fetch_assoc($sql)) {	
						$blacklistcompany[] = ["company_id" => $row['company_id'],"company_name" => $row['company_name']]; 
					}

					//print_r(json_encode(['blacklist' => str_replace("com_linkedin_voyager_search_SearchProfile","com.linkedin.voyager.search.SearchProfile",json_encode($return_array, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE)) , 'blacklistcompany' => json_encode($blacklistcompany)]));
					
					return json_encode(['blacklist' => str_replace("com_linkedin_voyager_search_SearchProfile","com.linkedin.voyager.search.SearchProfile",json_encode($return_array, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE)) , 'blacklistcompany' => json_encode($blacklistcompany)]);
				//echo json_last_error ();
				}else{
					//print_r(json_encode(['blacklist' => str_replace("com_linkedin_voyager_search_SearchProfile","com.linkedin.voyager.search.SearchProfile",json_encode($return_array, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE)) , 'blacklistcompany' => json_encode($blacklistcompany)]));
					
					return json_encode(['blacklist' => str_replace("com_linkedin_voyager_search_SearchProfile","com.linkedin.voyager.search.SearchProfile",json_encode($return_array, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE)) , 'blacklistcompany' => json_encode($blacklistcompany)]);
				}
			}else{
				//print_r(str_replace("com_linkedin_voyager_search_SearchProfile","com.linkedin.voyager.search.SearchProfile",json_encode($return_array)));
				return str_replace("com_linkedin_voyager_search_SearchProfile","com.linkedin.voyager.search.SearchProfile",json_encode($return_array));
			}	
}
//NR chekBlacklistblendedsearch 25May2020 ends

//NR: 21May2020 processLinks_new_blended starts (Use: This function create tasks for various types ie. 1st Degree Url, 2nd Degree Url, MyNetwork Connection, CSV, Webhook, Sales Navigator)
function processLinks($user, $bSeqArr) {
    echo '<br/>In processLinks_new_blended:<pre>';
    print_r($bSeqArr);
    
    echo '</pre>';
    include('config.php');
    ini_set('max_execution_time', '0');
    $cookie = $user['cookie'];
    $csrf = $user['csrf'];
    $proxyIp = $user['proxyIp'];
    $proxyPort = $user['proxyPort'];
    $proxyUsername = $user['proxyUsername'];
    $proxyPassword = $user['proxyPassword'];
	$userAgent = $user['userAgent'];
    $userId = $user['id'];

    $currentTimestamp = round(microtime(true) * 1000);
    $aaExtLinkArr = array();

    if (is_array($bSeqArr)) {
        $seqId = $bSeqArr['id'];
		
        $seqQry = mysqli_query($con, "SELECT * from ext_links WHERE `seqId` = " . $seqId . " AND (status = 'Active' OR status = 'Not Started' OR status = 'Fetching')  order by id ASC LIMIT 1");
        if (mysqli_num_rows($seqQry) == 0) {
            echo '<br/>IN processLinks before noMoreProspect<br/>';
            noMoreProspect($user, $bSeqArr);
        } else {
            $aaExtLinkArr = $aExtLinkArr = mysqli_fetch_assoc($seqQry);
		    
			
            echo '<br>aExtLinkArr::::<pre>';
            print_r($aExtLinkArr);

            if (!empty($aExtLinkArr)) {
                $aExtLinkArr['link'] = trim($aExtLinkArr['link']);
            }

			
            if (!empty($aExtLinkArr) && $aaExtLinkArr['link'] != "https://www.dummyorgin.dummy" && $bSeqArr['webhookVal'] != '1') {
                echo '<br/>LINE::' . __LINE__ . ':::qry::' . "SELECT * from ext_tasks WHERE `seqId` = " . $seqId . " AND (`status`='Not Started' || `status`='Active') ORDER BY id ASC LIMIT 1";
                $taskQry = mysqli_query($con, "SELECT * from ext_tasks WHERE `seqId` = " . $seqId . " AND (`status`='Not Started' || `status`='Active') ORDER BY id ASC LIMIT 1");
                if (mysqli_num_rows($taskQry) == 0) {
                    $task = mysqli_fetch_assoc($taskQry);
                    echo '<br/>LINE::' . __LINE__ . ':::swwdf';
                } else {
					/*
                    $tskQry = mysqli_query($con, "SELECT id from ext_tasks WHERE `seqId` = " . $seqId . " LIMIT 1");
                    if (mysqli_num_rows($tskQry) > 0) {
                        $tskQry = mysqli_query($con, "SELECT * from ext_tasks WHERE `seqId` = " . $seqId . " AND (`status`='Not Started' || `status`='Active') ORDER BY id ASC LIMIT 1");
                        if (mysqli_num_rows($tskQry) == 0) {
                            $lseq_comp = "Processing of the sequence is completed."; //chrome.i18n.getMessage('lseq_comp');
                            echo '<br/>LINE:' . __LINE__ . ':::qry::' . "UPDATE ext_sequences SET status='Complete', subStatus='', progress='', step='' WHERE id = " . $seqId;
                            $updateTask = mysqli_query($con, "UPDATE ext_sequences SET status='Complete', subStatus='', progress='', step='' WHERE id = " . $seqId);
                            seqLogNewStatus($seqId, 'Complete', $user['id']);
                            //sendMessageToSettings("SequenceUpdated");

                            addLogHistory($lseq_comp, $seqId, $user['id']);
                        }
                    }
					*/
                }


                if (strpos($aExtLinkArr['link'], "linkedin.com/mynetwork/invite-connect/connections/") !== false) {
					
					//MyNetwork Case: One time entry inserted in ext_tasks table;
					

                    $taskQry = mysqli_query($con, "SELECT count(id) as total_cnt from ext_tasks WHERE `seqId` = " . $seqId);
                    $taskRow = mysqli_fetch_assoc($taskQry);

                    if ($taskRow['total_cnt'] == 0) {

                        $lsearch_page = "Search page ";
                        $lsearch_page = $lsearch_page . makeLink(setUriParam($aExtLinkArr['link'], "start", $aExtLinkArr['start']), "#"); //uncomment it once fun. created
                        addLogHistory($lsearch_page, $seqId, $user['id']);


                        $currentTimestamp = round(microtime(true) * 1000);
                        $curl = curl_init();
                        //new headears starts
						//CURLOPT_VERBOSE and CURLOPT_HEADER added for "$header_size" code
                        curl_setopt_array($curl, array(
                            CURLOPT_URL => "https://www.linkedin.com/voyager/api/search/cluster?count=10&q=guided&searchId=" . $currentTimestamp . "&origin=FACETED_SEARCH&guides=List(v-%3EPEOPLE,facetNetwork-%3EF)&start=0",
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => "",
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 30,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTPPROXYTUNNEL => 1,
							CURLOPT_VERBOSE => 1,
							CURLOPT_HEADER => 1,
                            CURLINFO_HEADER_OUT => true,
                            CURLOPT_PROXY => "$proxyIp",
                            CURLOPT_PROXYPORT => "$proxyPort",
                            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                            CURLOPT_CUSTOMREQUEST => "GET",
                            CURLOPT_HTTPHEADER => array(
                                "cookie: $cookie",
                                "csrf-token: $csrf",
                                "x-http-method-override: GET",
                                "Host: www.linkedin.com",
                                "User-Agent: $userAgent",
                                "Accept-Language: en-US,en;q=0.5",
                                "Accept-Encoding: gzip, deflate, br",
                                "content-type: application/x-www-form-urlencoded",
                                "x-li-lang: en_US",
                                "x-restli-protocol-version: 2.0.0",
                                "Origin: https://www.linkedin.com",
                                "TE: Trailers"
                            )
                        ));
						//'x-li-track: {"clientVersion":"1.6.7931","osName":"web","timezoneOffset":5.5,"deviceFormFactor":"DESKTOP","mpName":"voyager-web","displayDensity":1.25,"displayWidth":1920,"displayHeight":1080}',



                        $curl_res = curl_exec($curl);
                        $curl_err = curl_errno($curl);
                        echo '<br/>LINE:' . __LINE__ . '::::curl_res:' . $curl_res;
						
						//30-06-2020 starts
						$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
						$headers = substr($curl_res, 0, $header_size);
						$curl_res = substr($curl_res, $header_size);
						//30-06-2020 ends
						
                        if (curl_errno($curl)) {
							//30-06-2020 uncommented this block
                            $error_msg = curl_error($curl);
                            addLogHistory($error_msg, 0, $userId, 1);
                            curl_close($curl);
                            echo '<br/>LINE:' . __LINE__ . '::::error_msg:' . $error_msg;
							//$p2 = "Error fetching link::::curlurl for debug is:https://www.linkedin.com/voyager/api/search/cluster?count=10&q=guided&searchId=" . $currentTimestamp . "&origin=FACETED_SEARCH&guides=List(v-%3EPEOPLE,facetNetwork-%3EF)&start=0";
							//sequenceError($bSeqArr['id'], $p2, $user['id']);//added 01-07-2020
                        } else {
							
							$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
							if($http_code == 200){
								if (!empty($curl_res)) {
                            //curl_close($curl);
                            $xArr = json_decode($curl_res);
                            echo '<br>LINE:' . __LINE__ . ':::::xArr:::::<pre>';
                            print_r($xArr);
                            echo '</pre>';


                            if (isset($xArr->elements) && count($xArr->elements)) {

                                $chunkRange = 500;
                                $total = $xArr->elements[0]->total; //11May2020
                                $chunk = ceil($total / $chunkRange); //intval( $total / $chunkRange );
                                echo '<br/>LINE:' . __LINE__ . ':::::chunk=' . $chunk . '::::::: total=' . $total;
                                for ($i = 1; $i <= $chunk; $i++) {

                                    if ($i == 1) {
                                        $rangeStart = 0;
                                        $rangeEnd = $chunkRange * $i;
                                    } else {
                                        if ($i == $chunk) {
                                            $rangeEnd = $total;
                                        } else {
                                            $rangeEnd = $chunkRange * $i;
                                        }

                                        $rangeStart = ($chunkRange * ($i - 1)) + 1;
                                    }

                                    $currentTimestamp = round(microtime(true) * 1000);
                                    $curl = curl_init();


                                    echo '<br/>LINE:' . __LINE__ . ':::curl url:' . "https://www.linkedin.com/voyager/api/relationships/connections?count=" . $chunkRange . "&sortType=RECENTLY_ADDED&start=" . $rangeStart;
                                    //new headears starts
									//CURLOPT_VERBOSE and CURLOPT_HEADER added for "$header_size2" code
                                    curl_setopt_array($curl, array(
                                        CURLOPT_URL => "https://www.linkedin.com/voyager/api/relationships/connections?count=" . $chunkRange . "&sortType=RECENTLY_ADDED&start=" . $rangeStart,
                                        CURLOPT_RETURNTRANSFER => true,
                                        CURLOPT_ENCODING => "",
                                        CURLOPT_MAXREDIRS => 10,
                                        CURLOPT_TIMEOUT => 30,
                                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                        CURLOPT_FOLLOWLOCATION => true,
                                        CURLOPT_HTTPPROXYTUNNEL => 1,
										CURLOPT_VERBOSE => 1,
										CURLOPT_HEADER => 1,
                                        CURLINFO_HEADER_OUT => true,
                                        CURLOPT_PROXY => "$proxyIp",
                                        CURLOPT_PROXYPORT => "$proxyPort",
                                        CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                                        CURLOPT_CUSTOMREQUEST => "GET",
                                        CURLOPT_HTTPHEADER => array(
                                            "cookie: $cookie",
                                            "csrf-token: $csrf",
                                            "x-http-method-override: GET",
                                            "Host: www.linkedin.com",
                                            "User-Agent: $userAgent",
                                            "Accept-Language: en-US,en;q=0.5",
                                            "Accept-Encoding: gzip, deflate, br",
                                            "content-type: application/x-www-form-urlencoded",
                                            "x-li-lang: en_US",
                                            "x-restli-protocol-version: 2.0.0",
                                            "Origin: https://www.linkedin.com",
                                            "TE: Trailers"
                                        )
                                    ));
                                    //new headears ends
									//'x-li-track: {"clientVersion":"1.6.7931","osName":"web","timezoneOffset":5.5,"deviceFormFactor":"DESKTOP","mpName":"voyager-web","displayDensity":1.25,"displayWidth":1920,"displayHeight":1080}',

                                    $curl_response = curl_exec($curl);
                                    echo '<br/>LINE:' . __LINE__ . '::::curl_response:' . $curl_response;
									
									//30-06-2020 starts
									$header_size2 = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
									$headers2 = substr($curl_response, 0, $header_size2);
									$curl_response = substr($curl_response, $header_size2);
									//30-06-2020 ends

                                    $curl_err = curl_errno($curl);

                                    if (curl_errno($curl)) {
                                        $error_msg = curl_error($curl);
                                        addLogHistory($error_msg, 0, $userId, 1);
                                        curl_close($curl);
                                        echo '<br/>LINE:' . __LINE__ . '::::error_msg:' . $error_msg;
										//$p2 = "Error fetching link::::curlurl for debug is:https://www.linkedin.com/voyager/api/relationships/connections?count=" . $chunkRange . "&sortType=RECENTLY_ADDED&start=" . $rangeStart;
										//sequenceError($bSeqArr['id'], $p2, $user['id']);//added 01-07-2020
                                    } else {
                                        curl_close($curl);
										$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
										if($http_code == 200){
											if (!empty($res)) {	
										
                                        //$responseArr = json_decode($curl_response, true);
                                        $responseArr = json_decode($curl_response); //11May2020
                                        echo '<br>LINE:' . __LINE__ . ':::::responseArr:::::<pre>';
                                        print_r($responseArr);
                                        echo '</pre>';
                                        //foreach($responseArr->included as $k=>$res)//commented 11May2020
                                        foreach ($responseArr->elements as $k => $res) {
                                            if (isset($res->miniProfile->firstName)) {
                                                //echo '<br/><br/>'; print_r($res);

                                                preg_match_all('!\d+!', $res->miniProfile->objectUrn, $matches);
                                                $person_id = (isset($matches[0][0])) ? $matches[0][0] : 0;
                                                echo '<br/>LINE:' . __LINE__ . ':::person_id=' . $person_id;

                                                preg_match('/urn:li:fs_miniProfile\:\s*([^\;]+)/', $res->miniProfile->entityUrn, $matches_eu);
                                                $longId = $matches_eu[1];
                                                echo '<br/>LINE:' . __LINE__ . ':::longId=' . $longId;

                                                $person = array(
                                                    "firstName" => mb_htmlentities($res->miniProfile->firstName),
                                                    "lastName" => mb_htmlentities($res->miniProfile->lastName),
                                                    "fullName" => mb_htmlentities($res->miniProfile->firstName . ' ' . $res->miniProfile->lastName),
                                                    "id" => (int) $person_id,
                                                    "publicIdentifier" => $res->miniProfile->publicIdentifier,
                                                    "person_id" => (int) $person_id,
                                                    "longId" => $longId,
                                                    "trackingId" => $res->miniProfile->trackingId,
                                                    "occupation" => mb_htmlentities($res->miniProfile->occupation),
                                                    "entityUrn" => $res->miniProfile->entityUrn
                                                );
                                                $json_person = json_encode($person);
                                                //echo '<br/>json:'.json_encode($person);

                                                $extStepQry = mysqli_query($con, "SELECT * FROM `ext_steps` WHERE `seqId` = " . $bSeqArr['id'] . " ORDER BY id ASC LIMIT 1");
                                                if (mysqli_num_rows($extStepQry) > 0) {
                                                    $extStepRow = mysqli_fetch_assoc($extStepQry);

                                                    $extLinksQry = mysqli_query($con, "SELECT * FROM `ext_links` WHERE `seqId` = " . $bSeqArr['id'] . " ORDER BY id DESC LIMIT 1");
                                                    if (mysqli_num_rows($extLinksQry) > 0) {
                                                        $extLinksRow = mysqli_fetch_assoc($extLinksQry);
                                                        $json_person_db = mysqli_real_escape_string($con,$json_person);
														
														//startTime='" . round(microtime(true) * 1000) . "'
														$crnttmsmp = strtotime('+1 minutes', ceil(round(microtime(true) * 1000)/1000)) * 1000;
														
                                                        mysqli_query($con, "INSERT INTO `ext_tasks` SET userId=" . $user['id'] . ", seqId=" . $bSeqArr['id'] . ", linkId=" . $extLinksRow['id'] . ", stepId=" . $extStepRow['id'] . ", step=0, startTime='" . $crnttmsmp . "', personId=" . $person['person_id'] . ", status='Not Started', type='Message', firstName='" . addslashes($person['firstName']) . "', lastName='" . addslashes($person['lastName']) . "', delayDays=0, delayMinutes=1, person='" . $json_person_db . "',triggered='false'");

                                                        echo '<br/>LINE:' . __LINE__ . ':::insert_qry::' . "INSERT INTO `ext_tasks` SET userId=" . $user['id'] . ", seqId=" . $bSeqArr['id'] . ", linkId=" . $extLinksRow['id'] . ", stepId=" . $extStepRow['id'] . ", step=0, startTime='" . $crnttmsmp . "', personId=" . $person['person_id'] . ", status='Not Started', type='Message', firstName='" . addslashes($person['firstName']) . "', lastName='" . addslashes($person['lastName']) . "', delayDays=0, delayMinutes=1, person='" . $json_person_db . "',triggered='false'";

                                                        echo '<br/>LINE:' . __LINE__ . 'Tasks Added for 1st Degree Msg<br/>';
                                                    }
                                                }
                                            }
                                        }
										
												}
											}else{
												//30-06-2020 starts
												$request=json_encode(curl_getinfo($curl));
												$request=curl_getinfo($curl); 
												$request['cookie']=$cookie;
												$request['csrf']=$csrf;							
												$request['proxyip']=$proxyIp;
												$request['proxyPort']=$proxyPort;
												$request['proxyUsername']=$proxyUsername;
												$request['proxyPassword']=$proxyPassword;
												$request=json_encode($request);
												
												$response=json_encode(array('headers'=>$headers2,'body'=>$curl_response));
												errorHandling($userId, $http_code,$request,$response,$seqId, 0);
												//30-06-2020 ends
											}
										
                                    }



                                    //nr ends
                                }
                            }
                        
								}
								curl_close($curl);
							
								
							}else{
								/*30-06-2020 commented
								$request=json_encode(curl_getinfo($curl));
								errorHandling($user['id'],$http_code,$request ,$curl_res,$seqId, 0 ); 
								//curl_close($curl);
								
								$error_msg = curl_error($curl);
								addLogHistory($error_msg, 0, $userId, 1);
								curl_close($curl);
								echo '<br/>LINE:' . __LINE__ . '::::error_msg:' . $error_msg;
								*/
								
								//30-06-2020 starts
								$request=json_encode(curl_getinfo($curl));
								$request=curl_getinfo($curl); 
								$request['cookie']=$cookie;
								$request['csrf']=$csrf;							
								$request['proxyip']=$proxyIp;
								$request['proxyPort']=$proxyPort;
								$request['proxyUsername']=$proxyUsername;
								$request['proxyPassword']=$proxyPassword;
								$request=json_encode($request);
								
								$response=json_encode(array('headers'=>$headers,'body'=>$curl_res));
								errorHandling($userId, $http_code,$request,$response,$seqId, 0);
								curl_close($curl);
								//30-06-2020 ends
								
							}
						} 
                    } else {
                        if ($bSeqArr['webhookVal'] != '1') {
							/*26May2020 commented sequence status complete code
                            $lseq_comp = "Processing of the sequence is completed."; //chrome.i18n.getMessage('lseq_comp');
                            echo '<br/>LINE:' . __LINE__ . '::update_qry::' . "UPDATE ext_sequences SET status='Complete', subStatus='', progress='', step='' WHERE id = " . $seqId;

                            mysqli_query($con, "UPDATE ext_sequences SET status='Complete', subStatus='', progress='', step='' WHERE id = " . $seqId);
                            seqLogNewStatus($seqId, 'Complete', $user['id']);
                            //sendMessageToSettings("SequenceUpdated");

                            addLogHistory($lseq_comp, $seqId, $user['id']);
							*/
                        }
                    }
                } else if (!strpos($aExtLinkArr['link'], "linkedin.com/sales/search") && ($aExtLinkArr['status'] == 'Active' || $aExtLinkArr['status'] == 'Not Started')) {                    
                    
					//1st Degree Sequence and 2nd Degree Sequence 10 tasks inserted each time;
					
					
					if ($aExtLinkArr['status'] == 'Not Started') {
                        if (strpos($aExtLinkArr['link'], "www.dummyorgin.dummy") !== false) {
                            //when text found
                            echo "All Task Completed";
                        } else {
                            $lstart_pro_link = ">>>>Start processing link "; //chrome.i18n.getMessage('lstart_pro_link')
                            $lstart_pro_link = $lstart_pro_link . '' . makeLink($aExtLinkArr['link'], "#" . $aExtLinkArr['order']); //uncomment it once fun. created
                            addLogHistory($lstart_pro_link, $seqId, $user['id']);
                            $aExtLinkArr['pagesFetched'] = 0;
                        }

                        $aExtLinkArr['status'] = 'Fetching';
                        $aExtLinkArr['fetchStarted'] = round(microtime(true) * 1000);

                        mysqli_query($con, "UPDATE ext_links SET status='Fetching', fetchStarted='" . $aExtLinkArr['fetchStarted'] . "', pagesFetched=" . $aExtLinkArr['pagesFetched'] . " WHERE id = " . $aExtLinkArr['id']);

                        echo "<br/>LINE:" . __LINE__ . "::UPDATE ext_links SET status='Fetching', fetchStarted='" . $aExtLinkArr['fetchStarted'] . "', pagesFetched=" . $aExtLinkArr['pagesFetched'] . " WHERE id = " . $aExtLinkArr['id'];



                        if (strpos($aExtLinkArr['link'], "linkedin.com/search/results/people/") !== false || strpos($aExtLinkArr['link'], "www.dummyorgin.dummy") !== false) {
                            //when text found
                            //NR:20APR2020 above condition added and below code added from OLD POS
                        }
                    }

                    //OLD POS HERE
                    //05May2020 code position changed starts
                    if (strpos($aExtLinkArr['link'], "www.dummyorgin.dummy") !== false && $bSeqArr['webhookVal'] != '1') {
                        //when text found
                        $taskQry = mysqli_query($con, "SELECT * from ext_tasks WHERE `seqId` = " . $seqId . " AND (`status`='Not Started' || `status`='Active') ORDER BY id ASC LIMIT 1");
                        if (mysqli_num_rows($taskQry) > 0) {
                            $aTaskArr = mysqli_fetch_assoc($taskQry);
                            echo '<br/>LINE::' . __LINE__ . ':: before fetchFromDb<br/>';

                            if ($aTaskArr && $aTaskArr['type'] != 'Message' || fetchFromDb($user, $bSeqArr, $aTaskArr)) {
                                //fetchFromDb($user,$bSeqArr,$aTaskArr);
                            }
                        }
                    } else {
                        echo '<br/>LINE::' . __LINE__ . ':: <br/>';
                        $aExtLinkArr['start'] = ($aExtLinkArr['start']) ? $aExtLinkArr['start'] : 0;
                        $dArr = array();
                        $dArr['company'] = !0;
                        $dArr['firstName'] = !0;
                        $dArr['lastName'] = !0;
                        $dArr['school'] = !0;
                        $dArr['title'] = !0;

                        if (strpos($aExtLinkArr['link'], "results/people/v2/?") !== false) {
                            //when text found
                            //Sir: this case will not exist. As it was used before for Recruiter version;
                            echo '<br/>2455<br/>';
                        } else {
                            //echo '<br/>LINE::' . __LINE__ . ':: <br/>';
							
                            if ($aExtLinkArr['voyagerLink']) {
								
								/*25May2020 code commented starts
								//21May2020 starts (as per new extension changes)
								if (strpos($aExtLinkArr['voyagerLink'], "voyager/api/search/blended") !== false) {
									$DateTime = round(microtime(true) * 1000);
									$aExtLinkArr['voyagerLink'] = "https://www.linkedin.com/voyager/api/search/cluster?count=" . PROFILES_PER_PAGE . "&q=guided&searchId=" . $DateTime;
									
									$firstdegreesequenceblacklist = 1;
									$e = "List(v->PEOPLE";
									
									$URL_1 = explode('?', $aExtLinkArr['link']);
									//echo '<pre>';
									//print_r($URL_1);
									$URL_2 = explode('&', $URL_1[1]);
									//echo '<pre>';
									//print_r($URL_2);
									

									for ($i = 0; $i < count($URL_2); $i++) {
										echo '<br/><br/>' . $URL_2[$i];
										$b_URL_3 = explode('=', $URL_2[$i]);
										echo "<br>LINE:" . __LINE__ . "::::";
										echo '<pre>';
										print_r($b_URL_3);

										if (isset($b_URL_3[1])) {

											$startswith = startsWith($b_URL_3[0], "facet");
											if ($startswith == true || isset($dArr[$b_URL_3[0]])) {
												echo '<br/>in facet condition';

												$c = urldecode($b_URL_3[1]);
												//echo "<br>LINE:".__LINE__."::::".$c;
												$c = preg_replace('/["\[\]]/', '', $c);


												echo "<br>LINE:" . __LINE__ . "::::" . $c;
												$c = explode(",", $c);
												//echo "<br>LINE:".__LINE__."::::"; print_r($c);
												$c = implode("|", $c);
												echo "<br>LINE:" . __LINE__ . "::::" . $c;


												$e2 = "," . urlencode($b_URL_3[0] . "->" . $c);
												//echo "<br>LINE:".__LINE__."::::".$e2;
												$e2 = preg_replace('/\(/', "%28", $e2);
												//echo "<br>LINE:".__LINE__."::::".$e2;
												$e .= preg_replace('/\)/', "%29", $e2);
												echo "<br>LINE:" . __LINE__ . "::::" . $e;
											} elseif ("page" == $b_URL_3[0]) {
												$aExtLinkArr['start'] = ((intval($b_URL_3[1]) || 1) - 1) * PROFILES_PER_PAGE;
											} elseif ("origin" == $b_URL_3[0] || "keywords" == $b_URL_3[0]) {

												$vlink_1 = "&" . $b_URL_3[0] . "=";
												$vlink_2 = urlencode(urldecode($b_URL_3[1]));
												$vlink_2 = preg_replace('/\(/', "%28", $vlink_2);
												$vlink_2 = preg_replace('/\)/', "%29", $vlink_2);

												$aExtLinkArr['voyagerLink'] .= $vlink_1 . $vlink_2;
												//echo "<br>LINE:".__LINE__."::::".$aExtLinkArr['voyagerLink'];
											}
										}
									}
								
									$e .= ")";
									echo "<br>LINE:" . __LINE__ . "::::" . $aExtLinkArr['voyagerLink'];
									$aExtLinkArr['voyagerLink'] .= "&guides=" . $e;
									echo "<br>LINE:" . __LINE__ . "::::" . $aExtLinkArr['voyagerLink'];

									if (strpos($aExtLinkArr['voyagerLink'], "origin=") === false) {
										//when text not found
										$aExtLinkArr['voyagerLink'] .= "&origin=OTHER";
									}
								}
								//21May2020 ends								
								//25May2020 code commented ends*/
								
                                $f = floor($aExtLinkArr['start'] / PROFILES_PER_PAGE + 1);

                                $lsearch_page = 'Search page '; //chrome.i18n.getMessage('lsearch_page');
                                $lsearch_page = $lsearch_page . '' . makeLink(setUriParam($aExtLinkArr['link'], "page", $f), "#" + $f); //uncomment it once fun. created
                                addLogHistory($lsearch_page, $seqId, $user['id']);

                                $firstdegreesequenceblacklist = 1; //06May2020
                            } else {
                                $firstdegreesequenceblacklist = 1;
                                //13May2020 starts
                                $DateTime = round(microtime(true) * 1000);
                                //$aExtLinkArr['voyagerLink'] = "https://www.linkedin.com/voyager/api/search/cluster?count=" . PROFILES_PER_PAGE . "&q=guided&searchId=" . $DateTime;//25May2020 commented

                                $aExtLinkArr['start'] = 0;
                                $firstdegreesequenceblacklist = 1;
								
								/*25May2020 code commented starts
                                //$e = "List(v-\x3ePEOPLE";
                                $e = "List(v->PEOPLE";

                                $URL_1 = explode('?', $aExtLinkArr['link']);
                                //echo '<pre>';
                                //print_r($URL_1);
                                $URL_2 = explode('&', $URL_1[1]);
                                //echo '<pre>';
                                //print_r($URL_2);

                                for ($i = 0; $i < count($URL_2); $i++) {
                                    //echo '<br/><br/>' . $URL_2[$i];
                                    $b_URL_3 = explode('=', $URL_2[$i]);
                                    echo "<br>LINE:" . __LINE__ . "::::";
                                    echo '<pre>';
                                    print_r($b_URL_3);

                                    if (isset($b_URL_3[1])) {

                                        $startswith = startsWith($b_URL_3[0], "facet");
                                        if ($startswith == true || isset($dArr[$b_URL_3[0]])) {
                                            //echo '<br/>in facet condition';

                                            $c = urldecode($b_URL_3[1]);
                                            //echo "<br>LINE:".__LINE__."::::".$c;
                                            $c = preg_replace('/["\[\]]/', '', $c);


                                            //echo "<br>LINE:" . __LINE__ . "::::" . $c;
                                            $c = explode(",", $c);
                                            //echo "<br>LINE:".__LINE__."::::"; print_r($c);
                                            $c = implode("|", $c);
                                            //echo "<br>LINE:" . __LINE__ . "::::" . $c;


                                            $e2 = "," . urlencode($b_URL_3[0] . "->" . $c);
                                            //echo "<br>LINE:".__LINE__."::::".$e2;
                                            $e2 = preg_replace('/\(/', "%28", $e2);
                                            //echo "<br>LINE:".__LINE__."::::".$e2;
                                            $e .= preg_replace('/\)/', "%29", $e2);
                                            echo "<br>LINE:" . __LINE__ . "::::" . $e;
                                        } elseif ("page" == $b_URL_3[0]) {
                                            echo "<br>LINE:" . __LINE__ . "::::";
                                            print_r($b_URL_3);
                                            if (intval($b_URL_3[1])) {
                                                $abc = intval($b_URL_3[1]);
                                            } else {
                                                $abc = 1;
                                            }
                                            $aExtLinkArr['start'] = ($abc - 1) * PROFILES_PER_PAGE;

//                                            $aExtLinkArr['start'] = ((intval($b_URL_3[1]) || 1) - 1) * PROFILES_PER_PAGE;
                                            echo "<br>LINE:" . __LINE__ . "::::" . $aExtLinkArr['start'];
                                        } elseif ("origin" == $b_URL_3[0] || "keywords" == $b_URL_3[0]) {

                                            $vlink_1 = "&" . $b_URL_3[0] . "=";
                                            $vlink_2 = urlencode(urldecode($b_URL_3[1]));
                                            $vlink_2 = preg_replace('/\(/', "%28", $vlink_2);
                                            $vlink_2 = preg_replace('/\)/', "%29", $vlink_2);

                                            $aExtLinkArr['voyagerLink'] .= $vlink_1 . $vlink_2;
                                            echo "<br>LINE:" . __LINE__ . "::::" . $aExtLinkArr['voyagerLink'];
                                        }
                                    }
                                }


                                $e .= ")";
                                echo "<br>LINE:" . __LINE__ . "::::" . $aExtLinkArr['voyagerLink'];
                                $aExtLinkArr['voyagerLink'] .= "&guides=" . $e;
                                echo "<br>LINE:" . __LINE__ . "::::" . $aExtLinkArr['voyagerLink'];

                                if (strpos($aExtLinkArr['voyagerLink'], "origin=") === false) {
                                    //when text not found
                                    $aExtLinkArr['voyagerLink'] .= "&origin=OTHER";
                                }
								
								//25May2020 code commented*/
                            
								//07July2020 starts
								$aExtLinkArr['voyagerLink'] = "https://www.linkedin.com/voyager/api/search/blended?count\x3d" . PROFILES_PER_PAGE . "\x26q\x3dall";
								$e = "List(resultType->PEOPLE";
											$URL_1 = explode('?', $aExtLinkArr['link']);
											//echo '<pre>';
											//print_r($URL_1);
											$URL_2 = explode('&', $URL_1[1]);
											//echo '<pre>';
											//print_r($URL_2);

											for ($i = 0; $i < count($URL_2); $i++) {
												//echo '<br/><br/>' . $URL_2[$i];
												//$b_URL_3 = explode('\x3d', $URL_2[$i]);
												$b_URL_3 = explode('=', $URL_2[$i]);
												echo "<br>LINE:" . __LINE__ . "::::";
												echo '<pre>';
												print_r($b_URL_3);

												if (isset($b_URL_3[1])) {

													$startswith = startsWith($b_URL_3[0], "facet");
													//if ($startswith == true || isset($d[$b_URL_3[0]]))
													if ($startswith == true) {
														//echo '<br/>in facet condition';

														$c = urldecode($b_URL_3[1]);
														//echo "<br>LINE:".__LINE__."::::".$c;
														$c = preg_replace('/["\[\]]/', '', $c);


														//echo "<br>LINE:" . __LINE__ . "::::" . $c;
														$c = explode(",", $c);
														//echo "<br>LINE:".__LINE__."::::"; print_r($c);
														$c = implode("|", $c);
														//echo "<br>LINE:" . __LINE__ . "::::" . $c;

															
															echo "<br>LINE:".__LINE__."::::".$b_URL_3[0];
															$b_URL_3[0] = preg_replace('/facet/', '', $b_URL_3[0]);
															echo "<br>LINE:".__LINE__."::::".$b_URL_3[0];
															
															$bb = $b_URL_3[0];
															//echo "<br>LINE:".__LINE__."::::".$bb[0];
															$bb0 = strtolower($bb[0]);
															//echo "<br>LINE:".__LINE__."::::".$bb0;
															$bbsub = substr($b_URL_3[0], 1);
															//echo "<br>LINE:".__LINE__."::::".$bbsub;
															$b_URL_3[0] = $bb0.$bbsub;
															echo "<br>LINE:".__LINE__."::::".$b_URL_3[0];


														$e2 = "," . urlencode($b_URL_3[0] . "->" . $c);
														//$e2 = "," . urlencode($b_URL_3[0] . "-\x3e" . $c);
														//echo "<br>LINE:".__LINE__."::::".$e2;
														$e2 = preg_replace('/\(/', "%28", $e2);
														//echo "<br>LINE:".__LINE__."::::".$e2;
														$e .= preg_replace('/\)/', "%29", $e2);
														echo "<br>LINE:" . __LINE__ . "::::" . $e;
													} elseif ("page" == $b_URL_3[0]) {
														echo "<br>LINE:" . __LINE__ . "::::";
														print_r($b_URL_3);
														if (intval($b_URL_3[1])) {
															$abc = intval($b_URL_3[1]);
														} else {
															$abc = 1;
														}
														$aExtLinkArr['start'] = ($abc - 1) * PROFILES_PER_PAGE;

			//                                            $aExtLinkArr['start'] = ((intval($b_URL_3[1]) || 1) - 1) * PROFILES_PER_PAGE;
														echo "<br>LINE:" . __LINE__ . "::::" . $aExtLinkArr['start'];
													} elseif ("origin" == $b_URL_3[0] || "keywords" == $b_URL_3[0]) {

														//$vlink_1 = "\x26" . $b_URL_3[0] . "\x3d";
														$vlink_1 = "&" . $b_URL_3[0] . "=";
														//$vlink_2 = urlencode(urldecode($b_URL_3[1]));//25June2020 commented
														$vlink_2 = $b_URL_3[1];
														$vlink_2 = preg_replace('/\(/', "%28", $vlink_2);
														$vlink_2 = preg_replace('/\)/', "%29", $vlink_2);

														$aExtLinkArr['voyagerLink'] .= $vlink_1 . $vlink_2;
														echo "<br>LINE:" . __LINE__ . "::::" . $aExtLinkArr['voyagerLink'];
													} elseif("title" == $b_URL_3[0] || "firstName" == $b_URL_3[0] || "lastName" == $b_URL_3[0] || "company" == $b_URL_3[0] || "school" == $b_URL_3[0] || "contactInterest" == $b_URL_3[0]){
														$c1 = $b_URL_3[1];
														//$e .= "," . urlencode($b_URL_3[0] . "->" . $c1);
														$e .= "," . $b_URL_3[0] . "->" . $c1;
													}
												}
											}											
											
											$e = preg_replace('/facet/', "", $e);
											$e .= ")";

											echo "<br>LINE:" . __LINE__ . "::::" . $aExtLinkArr['voyagerLink'];
											$aExtLinkArr['voyagerLink'] .= "&filters=" . $e;
											//$aExtLinkArr['voyagerLink'] .= "\x26filters\x3d" . $e;
											echo "<br>LINE:" . __LINE__ . "::::" . $aExtLinkArr['voyagerLink'];
								
								//07July2020 ends
							}
                            //Arpan 31-03
                            //$tempforfirst= urldecode($aExtLinkArr['link']);
                            $tempforfirst = urldecode($aExtLinkArr['link']);
                            if (strpos($tempforfirst, 'facetNetwork=["F"]') !== false) {
                                //when text found
                                $firstdegreesequenceblacklist = 0;
                                //echo "<br/>1st degree :::::::::::<br/>";
                            }
                            //echo '<br/>LINE:' . __LINE__ . '::::voyagerLink:::' . $aExtLinkArr['voyagerLink'] . '<br/>';
                            
                            echo '<br/>LINE:' . __LINE__ . ':::::curlLink::::' . $aExtLinkArr['voyagerLink'] . "&start=" . $aExtLinkArr['start'] . '<br/>';

                            $currentTimestamp = round(microtime(true) * 1000);

							/*
                            $curl = curl_init();

                            //new headears starts
                            $abb = curl_setopt_array($curl, array(
                                CURLOPT_URL => $aExtLinkArr['voyagerLink'] . "&start=" . $aExtLinkArr['start'],
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => "",
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 0,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_FOLLOWLOCATION => true,
                                CURLOPT_HTTPPROXYTUNNEL => 1,
                                CURLINFO_HEADER_OUT => true,
                                CURLOPT_PROXY => "$proxyIp",
                                CURLOPT_PROXYPORT => "$proxyPort",
                                CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                                CURLOPT_CUSTOMREQUEST => "GET",
                                CURLOPT_HTTPHEADER => array(
                                    "cookie: $cookie",
                                    "csrf-token: $csrf",
                                    "x-http-method-override: GET",
                                    "Host: www.linkedin.com",
                                    "User-Agent: Mozilla/5.0 (Windows NT 6.1; rv:75.0) Gecko/20100101 Firefox/75.0",
                                    "Accept-Language: en-US,en;q=0.5",
                                    "Accept-Encoding: gzip, deflate, br",
                                    "content-type: application/x-www-form-urlencoded",
                                    "x-li-lang: en_US",
                                    'x-li-track: {"clientVersion":"1.6.3394","osName":"web","timezoneOffset":5.5,"deviceFormFactor":"DESKTOP","mpName":"voyager-web","displayDensity":1}',
                                    "x-restli-protocol-version: 2.0.0",
                                    "Origin: https://www.linkedin.com",
                                    "TE: Trailers"
                                )
                            ));
                            //new headears ends

                            $res = curl_exec($curl);
                            //echo '<br/>LINE:' . __LINE__ . '::::: curl res:<pre>';
                            //print_r($res);

                            $info = curl_getinfo($curl);
                            echo '<br/>LINE:' . __LINE__ . '::::: curl info:<pre>';
                            echo var_dump($info);

                            echo '</pre>';
                            $curl_err = curl_errno($curl);

                            $cRes = json_decode($res);
                            print_r($cRes);
                            if ((strpos($res, "40: Invalid HTTP Request") !== false ) || ( isset($cRes->status) && $cRes->status == 400)) {
                                //NR added on 14May2020
                                echo '<br/>LINE:' . __LINE__ . ':::API FAILED';
                                $error_msg = 'API FAILED - url: ' . $aExtLinkArr['voyagerLink'] . "&start=" . $aExtLinkArr['start'];
                                addLogHistory($error_msg, $bSeqArr['id'], $userId, 1);
                            } else {
								



                                if ($curl_err) {

                                    $error_msg = curl_error($curl);
                                    addLogHistory($error_msg, 0, $userId, 1);
                                    curl_close($curl);
                                    $cArr = json_decode($res, true);
                                    $lerr_fetch_link1 = "Error fetching link ";
                                    $lpage = ", page ";
                                    $lcode = ", code:";
                                    $ltry_to_cont = ". You can try to continue.";
                                    $lerr_fetch_link2 = "Error fetching link: ";
                                    $p2 = $lerr_fetch_link1 . '' . makeLink($aExtLinkArr['link'], "url") . '' . $lpage . '' . ($aExtLinkArr['start'] / PROFILES_PER_PAGE + 1) . '' . $lcode . '' . $cArr['status'] . '' . $ltry_to_cont;

                                    sequenceError($bSeqArr['id'], $p2, $user['id']);
                                    $lerr_fetch_link2 = "Error fetching link: ";
                                    logError($lerr_fetch_link2 . '' . $aExtLinkArr['link'], $cArr);

                                    mysqli_query($con, "UPDATE `ext_links` SET status='Active' WHERE id = " . $aExtLinkArr['id']);
                                } else {
                                    echo '<br/>LINE:' . __LINE__ . ':::';
                                    curl_close($curl);
                                    $cArr_First = $cArr = json_decode($res);
									*/
//                                    try {
                                        
										/*NR 21May2020 Commented as per new extension changes
                                        $aExtLinkArr['start'] += PROFILES_PER_PAGE; //Line as per extension
                                        if ($aExtLinkArr['pagesFetched']) {
                                            $aExtLinkArr['pagesFetched'] = $aExtLinkArr['pagesFetched'] + 1;
                                        } else {
                                            $aExtLinkArr['pagesFetched'] = 1;
                                        }
                                        $aExtLinkArr['status'] = 'Active';
										*/
										
										
                                        $d = 0;
										
										

//                                        if (isset($cArr->elements) && count($cArr->elements)) {
//                                            echo '<br/>cArr=<br/><pre>';
//                                            print_r($cArr);
//                                            echo '</pre>';
//                                            $d = $cArr->elements[0]->total;
											/*NR 21May2020 Commented as per new extension changes
                                            $e = $cArr->elements[0]->elements;
											*/
											/*07July2020 commented (position changed to above)
											//NR 21May2020 starts (as per new extension changes)
											//Code Started for New LinkedIn Update 26-04-2020
											//Check if total result found are Zero Use new logic
											$aExtLinkArr['voyagerLink'] = "https://www.linkedin.com/voyager/api/search/blended?count\x3d" . PROFILES_PER_PAGE . "\x26q\x3dall";
											//$aExtLinkArr['start'] = 0;
											$e = "List(resultType->PEOPLE";
											//$e = "List(resultType-\x3ePEOPLE";
											
											
//$aExtLinkArr['link'] = "https://www.linkedin.com/search/results/people/?facetGeoRegion=%5B%22in:7127%22%5D&facetNetwork=%5B%22S%22%5D&keywords=android%20developer&origin=FACETED_SEARCH";

//$d = 3141;
//$aExtLinkArr['start'] = 0;
											
											$URL_1 = explode('?', $aExtLinkArr['link']);
											//echo '<pre>';
											//print_r($URL_1);
											$URL_2 = explode('&', $URL_1[1]);
											//echo '<pre>';
											//print_r($URL_2);

											for ($i = 0; $i < count($URL_2); $i++) {
												//echo '<br/><br/>' . $URL_2[$i];
												//$b_URL_3 = explode('\x3d', $URL_2[$i]);
												$b_URL_3 = explode('=', $URL_2[$i]);
												echo "<br>LINE:" . __LINE__ . "::::";
												echo '<pre>';
												print_r($b_URL_3);

												if (isset($b_URL_3[1])) {

													$startswith = startsWith($b_URL_3[0], "facet");
													//if ($startswith == true || isset($d[$b_URL_3[0]]))
													if ($startswith == true) {
														//echo '<br/>in facet condition';

														$c = urldecode($b_URL_3[1]);
														//echo "<br>LINE:".__LINE__."::::".$c;
														$c = preg_replace('/["\[\]]/', '', $c);


														//echo "<br>LINE:" . __LINE__ . "::::" . $c;
														$c = explode(",", $c);
														//echo "<br>LINE:".__LINE__."::::"; print_r($c);
														$c = implode("|", $c);
														//echo "<br>LINE:" . __LINE__ . "::::" . $c;

															
															echo "<br>LINE:".__LINE__."::::".$b_URL_3[0];
															$b_URL_3[0] = preg_replace('/facet/', '', $b_URL_3[0]);
															echo "<br>LINE:".__LINE__."::::".$b_URL_3[0];
															
															$bb = $b_URL_3[0];
															//echo "<br>LINE:".__LINE__."::::".$bb[0];
															$bb0 = strtolower($bb[0]);
															//echo "<br>LINE:".__LINE__."::::".$bb0;
															$bbsub = substr($b_URL_3[0], 1);
															//echo "<br>LINE:".__LINE__."::::".$bbsub;
															$b_URL_3[0] = $bb0.$bbsub;
															echo "<br>LINE:".__LINE__."::::".$b_URL_3[0];


														$e2 = "," . urlencode($b_URL_3[0] . "->" . $c);
														//$e2 = "," . urlencode($b_URL_3[0] . "-\x3e" . $c);
														//echo "<br>LINE:".__LINE__."::::".$e2;
														$e2 = preg_replace('/\(/', "%28", $e2);
														//echo "<br>LINE:".__LINE__."::::".$e2;
														$e .= preg_replace('/\)/', "%29", $e2);
														echo "<br>LINE:" . __LINE__ . "::::" . $e;
													} elseif ("page" == $b_URL_3[0] && $isVoyagerLink==false) {
														echo "<br>LINE:" . __LINE__ . "::::";
														print_r($b_URL_3);
														if (intval($b_URL_3[1])) {
															$abc = intval($b_URL_3[1]);
														} else {
															$abc = 1;
														}
														$aExtLinkArr['start'] = ($abc - 1) * PROFILES_PER_PAGE;

			//                                            $aExtLinkArr['start'] = ((intval($b_URL_3[1]) || 1) - 1) * PROFILES_PER_PAGE;
														echo "<br>LINE:" . __LINE__ . "::::" . $aExtLinkArr['start'];
													} elseif ("origin" == $b_URL_3[0] || "keywords" == $b_URL_3[0]) {

														//$vlink_1 = "\x26" . $b_URL_3[0] . "\x3d";
														$vlink_1 = "&" . $b_URL_3[0] . "=";
														//$vlink_2 = urlencode(urldecode($b_URL_3[1]));//25June2020 commented
														$vlink_2 = $b_URL_3[1];
														$vlink_2 = preg_replace('/\(/', "%28", $vlink_2);
														$vlink_2 = preg_replace('/\)/', "%29", $vlink_2);

														$aExtLinkArr['voyagerLink'] .= $vlink_1 . $vlink_2;
														echo "<br>LINE:" . __LINE__ . "::::" . $aExtLinkArr['voyagerLink'];
													} elseif("title" == $b_URL_3[0] || "firstName" == $b_URL_3[0] || "lastName" == $b_URL_3[0] || "company" == $b_URL_3[0] || "school" == $b_URL_3[0] || "contactInterest" == $b_URL_3[0]){
														$c1 = $b_URL_3[1];
														//$e .= "," . urlencode($b_URL_3[0] . "->" . $c1);
														$e .= "," . $b_URL_3[0] . "->" . $c1;
													}
												}
											}											
											
											$e = preg_replace('/facet/', "", $e);
											$e .= ")";

											echo "<br>LINE:" . __LINE__ . "::::" . $aExtLinkArr['voyagerLink'];
											$aExtLinkArr['voyagerLink'] .= "&filters=" . $e;
											//$aExtLinkArr['voyagerLink'] .= "\x26filters\x3d" . $e;
											echo "<br>LINE:" . __LINE__ . "::::" . $aExtLinkArr['voyagerLink'];
											*/

											$curl = curl_init();

											echo "<br>LINE:" . __LINE__ .':::::'.$aExtLinkArr['voyagerLink'] . "&start=" . $aExtLinkArr['start'];
											//CURLOPT_VERBOSE and CURLOPT_HEADER added for "$header_size" code
											curl_setopt_array($curl, array(
												CURLOPT_URL => $aExtLinkArr['voyagerLink'] . "&start=" . $aExtLinkArr['start'],
												//CURLOPT_URL => "https://www.linkedin.com/voyager/api/search/blended?count=10&q=all&keywords=android+developer&origin=FACETED_SEARCH&filters=List(resultType->PEOPLE,geoRegion-%3Ein%3A7127,network-%3ES)&start=0",
												//CURLOPT_URL => "https://www.linkedin.com/voyager/api/search/blended?count=10&q=all&keywords=android+developer&origin=FACETED_SEARCH&filters=List(resultType->PEOPLE,geoRegion->in:7127,network->S)&start=0",
												CURLOPT_RETURNTRANSFER => true,
												//CURLOPT_ENCODING => "",
												CURLOPT_MAXREDIRS => 10,
												CURLOPT_TIMEOUT => 0,
												CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
												CURLOPT_FOLLOWLOCATION => true,
												CURLOPT_HTTPPROXYTUNNEL => 1,
												CURLOPT_VERBOSE => 1,
												CURLOPT_HEADER => 1,
												CURLINFO_HEADER_OUT => true,
												CURLOPT_PROXY => "$proxyIp",
												CURLOPT_PROXYPORT => "$proxyPort",
												CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
												CURLOPT_CUSTOMREQUEST => "GET",
												CURLOPT_HTTPHEADER => array(
													"accept: application/vnd.linkedin.normalized+json+2.1",
													"cookie: $cookie",
													"csrf-token: $csrf",
													//"x-http-method-override: GET",
													"Host: www.linkedin.com",
													"User-Agent: $userAgent",
													
													"accept-language: en-US,en;q=0.9",
													//"Accept-Encoding: gzip, deflate, br",
													//"content-type: application/x-www-form-urlencoded",
													"content-type: application/vnd.linkedin.normalized+json+2.1",
													"x-li-lang: en_US",
													//'x-li-track: {"clientVersion":"1.6.3394","osName":"web","timezoneOffset":5.5,"deviceFormFactor":"DESKTOP","mpName":"voyager-web","displayDensity":1}',
													"x-restli-protocol-version: 2.0.0",
													"Origin: https://www.linkedin.com",
													//"TE: Trailers"
												)
											));
											

											$res = curl_exec($curl);
											//echo '<br/>LINE:' . __LINE__ . '::::: curl res:<pre>';
											//print_r($res);

											//$info = curl_getinfo($curl);
											//echo '<br/>LINE:' . __LINE__ . '::::: curl info:<pre>'; print_r($info);
											//30-06-2020 starts
											$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
											$headers = substr($res, 0, $header_size);
											$res = substr($res, $header_size);
											//30-06-2020 ends

											//echo '</pre>';
											$curl_err = curl_errno($curl);

											$cRes = json_decode($res);
											//echo '<br/>LINE:' . __LINE__ . '::::: curl cRes:<pre>';
											//print_r($cRes);
											/*
											if ((strpos($res, "40: Invalid HTTP Request") !== false ) || ( isset($cRes->status) && $cRes->status == 400)) {
												//NR added on 14May2020
												echo '<br/>LINE:' . __LINE__ . ':::API FAILED';
												$error_msg = 'API FAILED - url: ' . $aExtLinkArr['voyagerLink'] . "&start=" . $aExtLinkArr['start'];
												addLogHistory($error_msg, $bSeqArr['id'], $userId, 1);
											} else {
												*/
												
												
												if (curl_errno($curl)) {
													//30-06-2020 uncommented this block
													$error_msg = curl_error($curl);
													addLogHistory($error_msg, 0, $userId, 1);
													curl_close($curl);
													
													$cArr = json_decode($res, true);
													$lerr_fetch_link1 = "Error fetching link ";
													$lpage = ", page ";
													$lcode = ", code:";
													$ltry_to_cont = ". You can try to continue.";
													$lerr_fetch_link2 = "Error fetching link: ";
													$p2 = $lerr_fetch_link1 . '' . makeLink($aExtLinkArr['link'], "url") . '' . $lpage . '' . ($aExtLinkArr['start'] / PROFILES_PER_PAGE + 1) . '' . $lcode . '' . $cArr['status'] . '' . $ltry_to_cont;

													sequenceError($bSeqArr['id'], $p2, $user['id']);
													$lerr_fetch_link2 = "Error fetching link: ";
													//logError($lerr_fetch_link2 . '' . $aExtLinkArr['link'], $cArr);
													

													
												} else {
													
													
													
													$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
													if($http_code == 200){
														if (!empty($res)) {
														
													
													
													echo '<br/>LINE:' . __LINE__ . ':::New Code...';
													//curl_close($curl);
													$cArr = json_decode($res);
													echo '<br/>LINE:' . __LINE__ . ':::curl res:'; print_r($cArr);
													
													try{
														
													
													
													mysqli_query($con, "UPDATE ext_links SET total=" . $cArr->data->metadata->totalResultCount . " WHERE id = " . $aExtLinkArr['id']);
													
													//a.start += PROFILES_PER_PAGE;
													$d = $cArr->data->metadata->totalResultCount;
													//if(isset($cArr->data->elements[1])){
														//$e = $cArr->data->elements[1]->elements;
													//}else{
														$e = $cArr->data->elements[0]->elements;
													//}
													
													$includeddata= $cArr->included;
													echo '<br/>LINE:' . __LINE__ . ':::e='; print_r($e);
													
													
													$merged = array();
													echo '<br/>LINE:' . __LINE__ . ':::e='; print_r(count($e));
													//echo count($e);
													
													$entityUrn_Arr = array_column($includeddata, 'entityUrn');
													echo '<br/>LINE:' . __LINE__ .':::';print_r($entityUrn_Arr);
													
													
													for($i2=0; $i2<count($e); $i2++) {
														
														echo '<br/>'.$e[$i2]->targetUrn;
														$eukey = array_search($e[$i2]->targetUrn,$entityUrn_Arr);
														if($eukey){
															
															
															$temp = (object) array_merge((array)$e[$i2], (array)$includeddata[$eukey]);
															array_push($merged, $temp);
														}
													}
													
													echo '<br/>LINE:' . __LINE__ .':::';print_r($merged);
													
													if ($aExtLinkArr['pagesFetched']) {
														$aExtLinkArr['pagesFetched'] = $aExtLinkArr['pagesFetched'] + 1;
													} else {
														$aExtLinkArr['pagesFetched'] = 1;
													}
													//25-06-2020 ends
													
													//$ltotl_people = "Total people found: ";
													//$ltotl_people .= ($d - $aExtLinkArr['start'] + PROFILES_PER_PAGE) ;
													$ltotl_people = "Total people found: ".$d;
													
													echo '<br/>LINE:' . __LINE__ .':::pagesFetched:';print_r($aExtLinkArr['pagesFetched']);
													if ($aExtLinkArr['pagesFetched'] < 2) {
														addLogHistory($ltotl_people, $seqId, $user['id']);
													}
													
													if (count($merged)>0) {
														$gArr = array();//$g = [];
														//my temp array for check blacklisted api users 04012017
														//call url[to remove blacklisted users] and send (a) this contains resultset of 10 records of SEARCH URL, 
														
														$z = $merged;
														if($firstdegreesequenceblacklist==0){
															try {
																//Messaging Sequence Dont check Blacklist
																
																foreach ($z as $k => $a_a) {
																	
																	preg_match('/(?<=urn:li:fs_miniProfile:)([^\n\r]*)/', $a_a->targetUrn, $matches_tu);
																	//echo '<br/>LINE:' . __LINE__ . '::mbu::';
																	//print_r($matches_tu);
																	$x = $matches_tu[0];
																	
																	preg_match('/\d+/', $a_a->trackingUrn, $matches_tru);
																	$per_id =  (isset($matches_tru[0]))?$matches_tru[0]:0;
																					
																	$person = (object) array(
																		'firstName'=>mb_htmlentities($a_a->firstName),
																		'lastName'=>mb_htmlentities($a_a->lastName),
																		'fullName'=>mb_htmlentities($a_a->firstName.' '.$a_a->lastName),
																		'id'=>$per_id,
																		'publicIdentifier'=>$a_a->publicIdentifier,
																		'person_id'=>$per_id,
																		'longId'=>$x,
																		'url'=>$a_a->navigationUrl,
																		'trackingId'=>$a_a->trackingId,
																		'occupation'=>mb_htmlentities($a_a->occupation),
																		'entityUrn'=>$a_a->entityUrn,
																	);
																	
																	
																	//Add Task if Person has connect Button
																	if($a_a->targetUrn && $a_a->memberDistance && $a_a->memberDistance->value != "SELF" && $a_a->publicIdentifier && $a_a->publicIdentifier != "UNKNOWN"){
																		//array_push($gArr, $person);
																		array_push($gArr, array('person' => $person));
																	}
																	
																}
																


																unset($p4Arr);
																$p4Arr['results'] = $gArr;
																createFirstTasks($user, $bSeqArr, $aExtLinkArr, $p4Arr);
																
																
																
															} catch (Exception $e) {
																echo '<br/>~~~~Err occured :' . $e->getMessage() . "<br/>";
															}
														}else{
															//Invitation Type Sequence so check Blacklist
															
															//"Blacklist Company Deleted"
															
																	$sessionId = base64_encode($user['id'] . '/' . $user['teamid']);
																	unset($postFields);
																	$postFields = array("blacklistCompany" => 1, "msg" => $bSeqArr['msgSeq'], "sessionId" => $sessionId, "searchData" => $z);
																	/*
																	$curl = curl_init();
																	curl_setopt_array($curl, array(
																		//CURLOPT_URL => API_ADDRESS . "/chekBlacklistblendedsearch.php",
																		CURLOPT_URL => "https://app.leadconnect.io/api/chekBlacklistblendedsearch.php",
																		CURLOPT_RETURNTRANSFER => true,
																		CURLOPT_TIMEOUT => 0,
																		CURLOPT_CUSTOMREQUEST => "POST",
																		CURLOPT_POSTFIELDS => http_build_query($postFields),
																		CURLOPT_HTTPHEADER => array(
																			"accept: application/json",
																		)
																	));

																	$resBlacklist = curl_exec($curl);
																	echo '<br/>chekBlaklistUsers:<br/><pre>';
																	print_r($resBlacklist);
																	echo '</pre>';
																	$curlErrBlacklist = curl_errno($curl);
																	*/
																	
																	//25May2020 starts
																	$resBlacklist = chekBlacklistblendedsearch($postFields['blacklistCompany'],$postFields['msg'],$postFields['sessionId'],$postFields['searchData']);
																	echo '<br/>LINE:' . __LINE__ . ':::resBlacklist:::::<pre>';print_r($resBlacklist);echo '</pre>';
																	//25May2020 ends

																	/*
																	if ($curlErrBlacklist) {
																		$error_msg = curl_error($curl);
																		addLogHistory($error_msg, 0, $userId, 1);
																		echo "<br/>... ERROR Occured.-chekBlaklistUsers.php : " . $error_msg . '<br/>';

																		curl_close($curl);
																	} else {
																		curl_close($curl);
																		*/

																		$z_new = json_decode($resBlacklist);
																		echo '<br/>LINE:' . __LINE__ . ':::z_new:::::<pre>';print_r($z_new);echo '</pre>';
																		
																		$z = json_decode($z_new->blacklist);
																		echo '<br/>LINE:' . __LINE__ . ':::z::::<pre>';print_r($z);echo '</pre>';
																		
																		$blacklistcompany = json_decode($z_new->blacklistcompany);
																		echo '<br/>LINE:' . __LINE__ . ':::blacklistcompany::::<pre>';print_r($blacklistcompany);echo '</pre>';
																		/*
																		$blacklistcompanyAdd = [];

																		if ($blacklistcompany) {
																			foreach ($blacklistcompany as $k => $a) {
																				$blacklistcompanyAdd[$k]['company_id'] = $a->company_id;
																				$blacklistcompanyAdd[$k]['company_name'] = $a->company_name;

																				//mysqli_query($con, "INSERT INTO `ext_blacklistcompany` SET companyName='" . $a->company_name . "', companyId='" . $a->company_id . "', userId=" . $user['id'] . "  ");
																			}
																		}*/
																		
																		try {

																			//$z = str_replace("com.linkedin.voyager.search.SearchProfile", "com_linkedin_voyager_search_SearchProfile", json_encode($z));
																			//$z = json_decode($z);
																			echo '<br/>LINE:' . __LINE__ . ':::$z:::: <pre>';print_r($z);echo '</pre>';
																			
																			foreach ($z as $k => $a_a) {
																				
																				
																				preg_match('/(?<=urn:li:fs_miniProfile:)([^\n\r]*)/', $a_a->targetUrn, $matches_tu);
																				$x = $matches_tu[0];
																	
																				preg_match('/\d+/', $a_a->trackingUrn, $matches_tru);
																				$per_id =  (isset($matches_tru[0]))?$matches_tru[0]:0;
																								
																				$person = (object) array(
																					'firstName'=>mb_htmlentities($a_a->firstName),
																					'lastName'=>mb_htmlentities($a_a->lastName),
																					'fullName'=>mb_htmlentities($a_a->firstName.' '.$a_a->lastName),
																					'id'=>$per_id,
																					'publicIdentifier'=>$a_a->publicIdentifier,
																					'person_id'=>$per_id,
																					'longId'=>$x,
																					'url'=>$a_a->navigationUrl,
																					'trackingId'=>$a_a->trackingId,
																					'occupation'=>mb_htmlentities($a_a->occupation),
																					'entityUrn'=>$a_a->entityUrn,
																				);								
																				
																				//Add Task if Person has connect Button
																				if($a_a->targetUrn && $a_a->memberDistance && $a_a->memberDistance->value != "SELF" && $a_a->publicIdentifier && $a_a->publicIdentifier != "UNKNOWN"){
																					//array_push($gArr, $person);
																					array_push($gArr, array('person' => $person));
																				}
																				
																			}
																			
																			unset($p4Arr);
																			$p4Arr['results'] = $gArr;
																			createFirstTasks($user, $bSeqArr, $aExtLinkArr, $p4Arr);
																			
																			
																		} catch (Exception $e) {
																			echo '<br/>~~~~Err occured :' . $e->getMessage() . "<br/>";
																		}
																				
																				
																				
																				
																				
																		
																	//}											
															
															
														}
														
													}
													
												

													//12June2020 code starts(this is new place; before this was out of try catch block)
													//21May2020 starts
													$aExtLinkArr['start'] += PROFILES_PER_PAGE;
													/*if ($aExtLinkArr['pagesFetched']) {
														$aExtLinkArr['pagesFetched'] = $aExtLinkArr['pagesFetched'] + 1;
													} else {
														$aExtLinkArr['pagesFetched'] = 1;
													}*/
													$aExtLinkArr['status'] = 'Active';
													echo "<br/><br/>LINE:" . __LINE__ . ":::......... came here..";
													//21May2020 ends

													echo '<br/><br/>LINE::' . __LINE__ . '::::d=' . $d . ':::::start=' . $aExtLinkArr['start'] . '::::::PROFILES_PER_PAGE=' . PROFILES_PER_PAGE . ':::::SEARCH_LIMIT=' . SEARCH_LIMIT;

													if ($d <= ($aExtLinkArr['start']) || (($aExtLinkArr['start']) >= SEARCH_LIMIT)) {
														$aExtLinkArr['status'] = 'Complete'; //js: seqStatus.COMPLETE
														$aExtLinkArr['start'] = 0;
														$aExtLinkArr['voyagerLink'] = "";
														echo "<br/><br/>LINE:" . __LINE__ . ":::status=Complete:::::start=0:::::voyagerLink::";
													}
													
													
													mysqli_query($con, "UPDATE `ext_links` SET status='" . $aExtLinkArr['status'] . "', start='" . $aExtLinkArr['start'] . "', voyagerLink='" . $aExtLinkArr['voyagerLink'] . "', pagesFetched=" . $aExtLinkArr['pagesFetched'] . ", fetchStarted='" . $aExtLinkArr['fetchStarted'] . "' WHERE id = " . $aExtLinkArr['id']);
													
													


													echo "<br/><br/>LINE:" . __LINE__ . ":::::UPDATE `ext_links` SET status='" . $aExtLinkArr['status'] . "', start='" . $aExtLinkArr['start'] . "', voyagerLink='" . $aExtLinkArr['voyagerLink'] . "', pagesFetched=" . $aExtLinkArr['pagesFetched'] . ", fetchStarted='" . $aExtLinkArr['fetchStarted'] . "' WHERE id = " . $aExtLinkArr['id'];													
													//12June2020 code ends
													} catch (Exception $h) {
														//catch block added on 12June2020

														$lerr_proc_link = "Error processing link ";
														$lpage = ", page ";
														$ltry_to_cont = ". You can try to continue.";
														$lerr_proc_link1 = "Error processing link: ";

														$p2 = $lerr_proc_link . '' . makeLink($aExtLinkArr['link'], "url") . '' . $lpage . '' . ($aExtLinkArr['start'] / PROFILES_PER_PAGE + 1) . '' . $ltry_to_cont;
														sequenceError($bSeqArr['id'], $p2, $user['id']);
														logError($lerr_proc_link1 . '' . $aExtLinkArr['link'], $h);
													}
												
														}
														curl_close($curl);
													}else{
														/*30-06-2020 commented
														$error_msg = curl_error($curl);
														addLogHistory($error_msg, 0, $userId, 1);
														//curl_close($curl);
														$cArr = json_decode($res, true);
														$lerr_fetch_link1 = "Error fetching link ";
														$lpage = ", page ";
														$lcode = ", code:";
														$ltry_to_cont = ". You can try to continue.";
														$lerr_fetch_link2 = "Error fetching link: ";
														$p2 = $lerr_fetch_link1 . '' . makeLink($aExtLinkArr['link'], "url") . '' . $lpage . '' . ($aExtLinkArr['start'] / PROFILES_PER_PAGE + 1) . '' . $lcode . '' . $cArr['status'] . '' . $ltry_to_cont;

														sequenceError($bSeqArr['id'], $p2, $user['id']);
														$lerr_fetch_link2 = "Error fetching link: ";
														logError($lerr_fetch_link2 . '' . $aExtLinkArr['link'], $cArr);														
														
														$request=json_encode(curl_getinfo($curl));
														errorHandling($user['id'],$http_code,$request ,$res,$bSeqArr['id'], 0 );
														curl_close($curl);
														*/
														//30-06-2020 starts
														$request=json_encode(curl_getinfo($curl));
														$request=curl_getinfo($curl); 
														$request['cookie']=$cookie;
														$request['csrf']=$csrf;							
														$request['proxyip']=$proxyIp;
														$request['proxyPort']=$proxyPort;
														$request['proxyUsername']=$proxyUsername;
														$request['proxyPassword']=$proxyPassword;
														$request=json_encode($request);
														
														$response=json_encode(array('headers'=>$headers,'body'=>$res));
														errorHandling($userId, $http_code,$request,$response,$seqId, 0);
														curl_close($curl);
														//30-06-2020 ends
														
													}
												
												}
												
											//}	
							
							
											//NR 21May2020 ends (as per new extension changes)
											
											/*
											//Execute Old Normal Code
											echo '<br/>LINE:' . __LINE__ .':::Old Code';
											$e = $cArr->elements[0]->elements;
											
                                            $ltotl_people = "Total people found: "; //chrome.i18n.getMessage('ltotl_people');
                                            $ltotl_people .= ($d - $aExtLinkArr['start'] + PROFILES_PER_PAGE) . "(<a target='_blank' href='https://intercom.help/lead-connect/en/articles/3727785-search-results-count-in-sequence-does-not-match-with-actual-results-on-linkedin-search-query-geography-filter-solution'>  Different Count from LinkedIn? </a>)";

                                            mysqli_query($con, "UPDATE ext_links SET total=" . $cArr->elements[0]->total . " WHERE id = " . $aExtLinkArr['id']); //20Apr2020

                                            if (2 > $aExtLinkArr['pagesFetched'] && addLogHistory($ltotl_people, $seqId, $user['id'])) {
                                                
                                            }

                                            echo '<br/>LINE:' . __LINE__ . ':::EEEEE::<br/><br/>';
                                            print_r($e);

                                            if (count($e)) {
                                                $gArr = array();
                                                //my temp array for check blacklisted api users 04012017
                                                //call url[to remove blacklisted users] and send (a) this contains resultset of 10 records of SEARCH URL, 

                                                $z = $e;
                                                if ($firstdegreesequenceblacklist == 0) {
                                                    echo '<br/>LINE:' . __LINE__ . ':::::firstdegreesequenceblacklist:' . $firstdegreesequenceblacklist;
                                                    try {
                                                        //NR: This case is tested; DONE;
                                                        $z = str_replace("com.linkedin.voyager.search.SearchProfile", "com_linkedin_voyager_search_SearchProfile", json_encode($z));
                                                        $z = json_decode($z);

                                                        foreach ($z as $k => $a) {

                                                            $snippet = (isset($a->hitInfo->com_linkedin_voyager_search_SearchProfile->snippets)) ? json_encode($a->hitInfo->com_linkedin_voyager_search_SearchProfile->snippets) : '';
                                                            $educations = (isset($a->hitInfo->com_linkedin_voyager_search_SearchProfile->educations)) ? json_encode($a->hitInfo->com_linkedin_voyager_search_SearchProfile->educations) : '';

                                                            unset($temp);
                                                            $temp['targetPageInstance'] = $a->targetPageInstance;
                                                            $temp['snippet'] = $snippet;
                                                            $temp['educations'] = $educations;

                                                            //05May2020 starts
                                                            if (isset($a->hitInfo) && $a->hitInfo->com_linkedin_voyager_search_SearchProfile) {
                                                                $a_a = $a->hitInfo->com_linkedin_voyager_search_SearchProfile;
                                                                echo '<br/>LINE:' . __LINE__ . ':::$a_a:::: <pre>';
                                                                print_r($a_a);


                                                                if ($a_a->distance && $a_a->distance->value != "SELF" && $a_a->miniProfile && $a_a->miniProfile->publicIdentifier && $a_a->miniProfile->publicIdentifier != "UNKNOWN") {

                                                                    echo '<br/>LINE:' . __LINE__ . ':::sdfsdfa:::::';
                                                                    $a_a->miniProfile->longId = $a_a->id;

                                                                    preg_match('/\d+/', $a_a->backendUrn, $matches_bu);
                                                                    //$a->miniProfile->id = intval($matches_bu[0]);
                                                                    echo '<br/>LINE:' . __LINE__ . '::mbu::';
                                                                    print_r($matches_bu);
                                                                    $a_a->miniProfile->id = $matches_bu[0];
                                                                    array_push($gArr, array('person' => $a_a->miniProfile, $temp));
                                                                }
                                                            }
                                                        }

                                                        echo '<br/>gArr' . __LINE__ . ':::<pre>';
                                                        print_r($gArr);
                                                        unset($p4Arr);
                                                        $p4Arr['results'] = $gArr;
                                                        createFirstTasks($user, $bSeqArr, $aExtLinkArr, $p4Arr);
                                                    } catch (Exception $e) {
                                                        echo '<br/>~~~~Err occured :' . $e->getMessage() . "<br/>";
                                                    }
                                                } else {
                                                    //NR: This case is tested; DONE;
                                                    //Invitation Type Sequence so check Blacklist
                                                    echo '<br/>LINE:' . __LINE__ . ':::::before chekBlaklistUsers :: firstdegreesequenceblacklist:' . $firstdegreesequenceblacklist;

                                                    mysqli_query($con, "DELETE FROM `ext_blacklistcompany` where userId =" . $user['id']);
                                                    echo "<br/>Blacklist Company Deleted<br/>";
                                                    $sessionId = base64_encode($user['id'] . '/' . $user['teamid']);
                                                    unset($postFields);
                                                    $postFields = array("blacklistCompany" => 1, "msg" => $bSeqArr['msgSeq'], "sessionId" => $sessionId, "searchData" => $e);
                                                    
                                                    $curl = curl_init();
                                                    curl_setopt_array($curl, array(
                                                        CURLOPT_URL => API_ADDRESS . "/chekBlaklistUsers.php",
                                                        CURLOPT_RETURNTRANSFER => true,
                                                        CURLOPT_TIMEOUT => 0,
                                                        CURLOPT_CUSTOMREQUEST => "POST",
                                                        CURLOPT_POSTFIELDS => http_build_query($postFields),
                                                        CURLOPT_HTTPHEADER => array(
                                                            "accept: application/json",
                                                        )
                                                    ));

                                                    $resBlacklist = curl_exec($curl);
                                                    echo '<br/>chekBlaklistUsers:<br/><pre>';
                                                    print_r($resBlacklist);
                                                    echo '</pre>';
                                                    $curlErrBlacklist = curl_errno($curl);


                                                    if ($curlErrBlacklist) {
                                                        $error_msg = curl_error($curl);
                                                        addLogHistory($error_msg, 0, $userId, 1);
                                                        echo "<br/>... ERROR Occured.-chekBlaklistUsers.php : " . $error_msg . '<br/>';

                                                        curl_close($curl);
                                                    } else {
                                                        curl_close($curl);

                                                        $z_new = json_decode($resBlacklist);
                                                        echo '<br/>LINE:' . __LINE__ . ':::z_new:::::<pre>';
                                                        print_r($z_new);
                                                        echo '</pre>';
                                                        $z = json_decode($z_new->blacklist);
                                                        echo '<br/>LINE:' . __LINE__ . ':::z::::<pre>';
                                                        print_r($z);
                                                        echo '</pre>';
                                                        $blacklistcompany = json_decode($z_new->blacklistcompany);
                                                        echo '<br/>LINE:' . __LINE__ . ':::blacklistcompany::::<pre>';
                                                        print_r($blacklistcompany);
                                                        echo '</pre>';
                                                        $blacklistcompanyAdd = [];

                                                        if ($blacklistcompany) {
                                                            foreach ($blacklistcompany as $k => $a) {
                                                                $blacklistcompanyAdd[$k]['company_id'] = $a->company_id;
                                                                $blacklistcompanyAdd[$k]['company_name'] = $a->company_name;

                                                                mysqli_query($con, "INSERT INTO `ext_blacklistcompany` SET companyName='" . $a->company_name . "', companyId='" . $a->company_id . "', userId=" . $user['id'] . "  ");
                                                            }
                                                        }

                                                        try {

                                                            $z = str_replace("com.linkedin.voyager.search.SearchProfile", "com_linkedin_voyager_search_SearchProfile", json_encode($z));
                                                            $z = json_decode($z);
                                                            echo '<br/>LINE:' . __LINE__ . ':::$z:::: <pre>';
                                                            print_r($z);
                                                            foreach ($z as $k => $a) {



                                                                $snippet = (isset($a->hitInfo->com_linkedin_voyager_search_SearchProfile->snippets)) ? json_encode($a->hitInfo->com_linkedin_voyager_search_SearchProfile->snippets) : '';
                                                                $educations = (isset($a->hitInfo->com_linkedin_voyager_search_SearchProfile->educations)) ? json_encode($a->hitInfo->com_linkedin_voyager_search_SearchProfile->educations) : '';

                                                                unset($temp);
                                                                $temp['targetPageInstance'] = $a->targetPageInstance;
                                                                $temp['snippet'] = $snippet;
                                                                $temp['educations'] = $educations;

                                                                //05May2020 starts
                                                                if (isset($a->hitInfo) && $a->hitInfo->com_linkedin_voyager_search_SearchProfile) {
                                                                    $a_a = $a->hitInfo->com_linkedin_voyager_search_SearchProfile;
                                                                    echo '<br/>LINE:' . __LINE__ . ':::$a_a:::: <pre>';
                                                                    print_r($a_a);


                                                                    if ($a_a->distance && $a_a->distance->value != "SELF" && $a_a->miniProfile && $a_a->miniProfile->publicIdentifier && $a_a->miniProfile->publicIdentifier != "UNKNOWN") {

                                                                        echo '<br/>LINE:' . __LINE__ . ':::sdfsdfa:::::';
                                                                        $a_a->miniProfile->longId = $a_a->id;
                                                                        preg_match('/\d+/', $a_a->backendUrn, $matches_bu);
                                                                        echo '<br/>LINE:' . __LINE__ . '::mbu::';
                                                                        print_r($matches_bu);
                                                                        $a_a->miniProfile->id = $matches_bu[0];

                                                                        array_push($gArr, array('person' => $a_a->miniProfile, $temp));
                                                                    }
                                                                }
                                                                //05May2020 ends
                                                            }
                                                            echo '<br/>gArr' . __LINE__ . ':::<pre>';
//                                                            print_r($gArr);
                                                            unset($p4Arr);
                                                            $p4Arr['results'] = $gArr;
                                                            createFirstTasks($user, $bSeqArr, $aExtLinkArr, $p4Arr); //uncomment it once fun. created
                                                        } catch (Exception $e) {
                                                            echo '<br/>~~~~Err occured :' . $e->getMessage() . "<br/>";
                                                        }
                                                    }
                                                }
                                            }
											
											Old Code Commented ends */
//                                        }
										
										/*12June2020 commented this and moved in try block;
										//21May2020 starts
										$aExtLinkArr['start'] += PROFILES_PER_PAGE;
                                        if ($aExtLinkArr['pagesFetched']) {
                                            $aExtLinkArr['pagesFetched'] = $aExtLinkArr['pagesFetched'] + 1;
                                        } else {
                                            $aExtLinkArr['pagesFetched'] = 1;
                                        }
                                        $aExtLinkArr['status'] = 'Active';
										echo "<br/><br/>LINE:" . __LINE__ . ":::......... came here..";
										//21May2020 ends

                                        echo '<br/><br/>LINE::' . __LINE__ . '::::d=' . $d . ':::::start=' . $aExtLinkArr['start'] . '::::::PROFILES_PER_PAGE=' . PROFILES_PER_PAGE . ':::::SEARCH_LIMIT=' . SEARCH_LIMIT;

                                        if ($d <= ($aExtLinkArr['start']) || (($aExtLinkArr['start']) >= SEARCH_LIMIT)) {
                                            $aExtLinkArr['status'] = 'Complete'; //js: seqStatus.COMPLETE
                                            $aExtLinkArr['start'] = 0;
                                            $aExtLinkArr['voyagerLink'] = "";
                                            echo "<br/><br/>LINE:" . __LINE__ . ":::status=Complete:::::start=0:::::voyagerLink::";
                                        }
                                        
                                        
                                        mysqli_query($con, "UPDATE `ext_links` SET status='" . $aExtLinkArr['status'] . "', start='" . $aExtLinkArr['start'] . "', voyagerLink='" . $aExtLinkArr['voyagerLink'] . "', pagesFetched=" . $aExtLinkArr['pagesFetched'] . ", fetchStarted='" . $aExtLinkArr['fetchStarted'] . "' WHERE id = " . $aExtLinkArr['id']);
										
										


                                        echo "<br/><br/>LINE:" . __LINE__ . ":::::UPDATE `ext_links` SET status='" . $aExtLinkArr['status'] . "', start='" . $aExtLinkArr['start'] . "', voyagerLink='" . $aExtLinkArr['voyagerLink'] . "', pagesFetched=" . $aExtLinkArr['pagesFetched'] . ", fetchStarted='" . $aExtLinkArr['fetchStarted'] . "' WHERE id = " . $aExtLinkArr['id'];
										*/
										
										
                                        //js code: db.links.update(a.id, a)
                                    /*} catch (Exception $h) {

                                        $lerr_proc_link = "Error processing link ";
                                        $lpage = ", page "; 
                                        $ltry_to_cont = ". You can try to continue.";
                                        $lerr_proc_link1 = "Error processing link: ";

                                        $p2 = $lerr_proc_link . '' . makeLink($aExtLinkArr['link'], "url") . '' . $lpage . '' . ($aExtLinkArr['start'] / PROFILES_PER_PAGE + 1) . '' . $ltry_to_cont;
                                        sequenceError($bSeqArr['id'], $p2, $user['id']);
                                        logError($lerr_proc_link1 . '' . $aExtLinkArr['link'], $h);
                                    }*/
                                //}
                            //}
                        }
                    }
                    //05May2020 code position changed ends
                } else if (strpos($aExtLinkArr['link'], "linkedin.com/sales/search") !== false) {

                    //Ankit + Trupal starts
                    (!empty($aExtLinkArr['start'])) ? $aExtLinkArr['start'] = $aExtLinkArr['start'] : $aExtLinkArr['start'] = 0;
                    if (strpos($aExtLinkArr['link'], "facet")) {
                        $aExtLinkArr['link'] = str_replace('\x26pivotType\x3dDELTA', '', $aExtLinkArr['link']);
                        if (!empty($aExtLinkArr['salesNavigatorLink'])) {
                            $aExtLinkArr['salesNavigatorLink'] = str_replace("\x26pivotType\x3dDELTA", "", $aExtLinkArr['salesNavigatorLink']);
                        } else {
                            $aExtLinkArr['salesNavigatorLink'] = str_replace("linkedin.com/sales/search?", "linkedin.com/sales/search/results?", $aExtLinkArr['link']);
                            $aExtLinkArr['salesNavigatorLink'] = setUriParam($aExtLinkArr['salesNavigatorLink'], "count", PROFILES_PER_PAGE_SALESNAV);

                            if (!strpos($aExtLinkArr['link'], "?")) {
                                $params = array();
                            } else {
                                $splitedString = str_replace("%2520", "%20", substr($aExtLinkArr['link'], strpos($aExtLinkArr['link'], "?") + 1));
                                $splitedString = str_replace("(", "%28", $splitedString);
                                $splitedString = str_replace(")", "%29", $splitedString);
                                parse_str($splitedString, $params);
                            }

                            if (!empty($params)) {
                                if ((array_key_exists('start', $params))) {
                                    $aExtLinkArr['start'] = $params['start'];
                                    $parsed = parse_url($aExtLinkArr['salesNavigatorLink']);
                                    $query = $parsed['query'];
                                    parse_str($query, $params);
                                    unset($params['start']);
                                    $strParams = http_build_query($params);
                                    $aExtLinkArr['salesNavigatorLink'] = explode('?', $aExtLinkArr['salesNavigatorLink'])[0] . '?' . $strParams;
                                } else {
                                    $aExtLinkArr['start'] = 0;
                                }
                            } else {
                                $aExtLinkArr['start'] = 0;
                            }

                            $page = floor($aExtLinkArr['start'] / PROFILES_PER_PAGE_SALESNAV + 1);
                            $lsearch_page = "Search page ";
                            addLogHistory($lsearch_page . makeLink(setUriParam($aExtLinkArr['link'], "start", $aExtLinkArr['start']), "#" . $page), $seqId, $user['id']);

                            $curlUrl = $aExtLinkArr['salesNavigatorLink'] . "\x26start\x3d" . $aExtLinkArr['start'];
                            $curl = curl_init();

                            //new headears starts
                            curl_setopt_array($curl, array(
                                CURLOPT_URL => $curlUrl,
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => "",
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 30,
								CURLOPT_VERBOSE => 1,
								CURLOPT_HEADER => 1,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_FOLLOWLOCATION => true,
                                CURLOPT_HTTPPROXYTUNNEL => 1,
                                CURLINFO_HEADER_OUT => true,
                                CURLOPT_PROXY => "$proxyIp",
                                CURLOPT_PROXYPORT => "$proxyPort",
                                CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                                CURLOPT_CUSTOMREQUEST => "GET",
                                CURLOPT_HTTPHEADER => array(
                                    "cookie: $cookie",
                                    "csrf-token: $csrf",
                                    "x-http-method-override: GET",
                                    "Host: www.linkedin.com",
                                    "User-Agent: $userAgent",
                                    "Accept-Language: en-US,en;q=0.5",
                                    "Accept-Encoding: gzip, deflate, br",
                                    "content-type: application/x-www-form-urlencoded",
                                    "x-li-lang: en_US",
                                    "x-restli-protocol-version: 2.0.0",
                                    "Origin: https://www.linkedin.com",
                                    "TE: Trailers"
                                ),
                            ));
                            //new headears ends

                            
							$res = curl_exec($curl);//print_r($res);
							$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
							$headers = substr($res, 0, $header_size);
							$res = substr($res, $header_size);  
                            if (curl_errno($curl)) {
                                $error_msg = curl_error($curl);
                                addLogHistory($error_msg, 0, $userId, 1);
                                curl_close($curl);
                            } else {
								$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
								if($http_code == 200){
									
								
								
                                //processContinue();
                                $aExtLinkArr['status'] = 'Active';
                                $page = 0;
                                $lwrong_search1 = "Got wrong search results. Try to open ";
                                $lwrong_search2 = " and then continue the sequence.";
                                $ltotl_people = "Total people found: ";
                                $lreach_end = "Reached end of search results at link ";
                                $lno_of_pro = "Number of profiles on search page: ";
                                $lsearch_page1 = "the search page";
                                $lwrong_serch_page = "Wrong search page:";

                                //pending
								
								}else{
									$request=json_encode(curl_getinfo($curl));
									$request=curl_getinfo($curl); 
									$request['cookie']=$cookie;
									$request['csrf']=$csrf;							
									$request['proxyip']=$proxyIp;
									$request['proxyPort']=$proxyPort;
									$request['proxyUsername']=$proxyUsername;
									$request['proxyPassword']=$proxyPassword;
									$request=json_encode($request);
									
									$response=json_encode(array('headers'=>$headers,'body'=>$res));
									errorHandling($userId, $http_code,$request,$response,$seqId, 0);
								}
                            }
                            curl_close($curl);
                        }
                    } else {
                        $splitedString = str_replace("%2520", "%20", substr($aExtLinkArr['link'], strpos($aExtLinkArr['link'], "?") + 1));
                        $splitedString = str_replace("(", "%28", $splitedString);
                        $splitedString = str_replace(")", "%29", $splitedString);

                        parse_str($splitedString, $queryString);

                        $logHistory = $queryString["logHistory"];
                        $page = $queryString["page"];
                        (isset($queryString["logId"]) && !empty($queryString["logId"])) ? $logId = $queryString["logId"] : $logId = 0;
                        $searchSessionId = $queryString["searchSessionId"];
                        $searchSessionId = str_replace(" ", "+", $queryString['searchSessionId']);
                        $resID = $queryString["rsLogId"];

                        unset($queryString["logHistory"]);
                        unset($queryString["page"]);
                        unset($queryString["logId"]);
                        unset($queryString["searchSessionId"]);
                        unset($queryString["rsLogId"]);
                        salesNavInvitaion($user, $aExtLinkArr, $queryString, $resID, $logId, $searchSessionId, $logHistory);
                    }
                    //Ankit + Trupal ends
                } else {
                    echo '<br/>LINE:' . __LINE__ . '::update_qry::' . "UPDATE `ext_links` SET status='Not Started' WHERE id = " . $aExtLinkArr['id'];
                    mysqli_query($con, "UPDATE `ext_links` SET status='Not Started' WHERE id = " . $aExtLinkArr['id']);
                    $lwrong_link = "Wrong link: "; //chrome.i18n.getMessage('lwrong_link');
                    addLogHistory($lwrong_link . '' . makeLink($aExtLinkArr['link'], $lwrong_link), $bSeqArr['id'], $user['id']);
                    //sequenceError($bSeqArr['id'], 0, $user['id']);
                }
                //here
                //05May2020: 3561 New postion changed here ends
            } else if ($bSeqArr['webhookVal'] == '1') {
                getWebhooksFromDB($user, $bSeqArr);
            } else if ($aaExtLinkArr['link'] == "https://www.dummyorgin.dummy" && $bSeqArr['webhookVal'] != '1') {
                csvProfile($user, $seqId);
            } else if (strpos($aExtLinkArr['link'], "linkedin.com/mynetwork/invite-connect/connections/") !== false) {
                //code
            } else if ($aExtLinkArr['status'] == 'Active' || $aExtLinkArr['status'] == 'Not Started') {
                
            } else if (strpos($aExtLinkArr['link'], "linkedin.com/sales/search") !== false) {
                
            } else {
                
            }
        
		}
    }
}
//21May2020 processLinks_new_blended ends

function logError(){
	//
}
?>