<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\LinkPager;

$this->title = 'Webhooks';
?>
<style>
#webhooktable .row_class_new{ cursor: pointer; }
</style>

<div class="webhook-index">
    <div class="grid simple contentmargin">   
        <div class="grid-title">
            <div class="row">
				<div class="col-md-10">
					<h3 id="customtitle"><span class="semi-bold" style=""><a href="<?php echo Yii::$app->request->baseUrl; ?>/webhook"> <span class="semi-bold" style="">Webhooks</a></span></h3>
				</div>
				<div class="col-md-2" style="text-align: right;margin-top: 7px;">
					<a class="btn btn-success add_new_webhook"  href="javascript:void(0);"><i class="fa fa-plus"></i>&nbsp;&nbsp;Add Webhook</a>
				</div>
            </div>
             
        </div>
        <div class="grid-body">
              <div class="table-responsive">      
                   <table class="table table-striped dataTable" id="webhooktable">
                <thead>
                  <tr>
                    <th width="1px">#</th>
                    <th>Sequence Name</th>
                    <th>Webhook Url</th>
                    <th>Created at</th>
                  </tr>
                </thead>
                <tbody>
                  <?php if(empty($Getwebhooks)){?>
                     <tr class="row_class"  style="cursor: pointer;">
                        <td colspan="4" class="text-center">No results found.</td>
                      </tr>
                  <?php } ?>
                  <?php 
				  $key=1;
                  foreach($Getwebhooks as $datas){
					  
					 // echo '<pre>'; print_r($datas['w_seq_id']); exit;
 ?>
                      <tr class="row_class row_class_new"  id="<?php echo $datas['w_seq_id']; ?>" style="cursor: pointer;">
                        <td class="text-center"><?php echo $key;?></td>
                        <td><?php echo $datas['w_seq_name']; ?></td>
                        <td><?php echo $datas['w_url']; ?></td>
                        <td><?php echo date('d/m/Y H:i:s',strtotime($datas['created_at'])); ?></td>
                      </tr>
                  <?php $key++; }  ?>
                </tbody>
              </table>
              </div>   
            <?php /*echo LinkPager::widget([
                'pagination' => $pages,
            ]); */ ?>
        
      </div>
    </div>
</div>
<!-- Webhook profile viewer popup -->
<div class="modal fade" id="myModal22" role="dialog">
   <div class="modal-dialog modal-lg">
      <div class="modal-content">
         <div class="modal-header text-left">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title">Webhook Viewer</h4>
         </div>
         <div class="modal-body">
            <div class="row">
               <div class="col-md-12">
                  <div class="loader">
                     <img src="<?php echo Yii::$app->urlManager->baseUrl?>/img/varun_loader.gif" id="loader1" style='display:none; margin-left: 45%;'>
                  </div>
                  <div class="grid simple ">
                     <table  id="allowedappdetail12334" style="width:100%;"  class="table table-bordered no-more-tables">
                        <thead>
                           <tr>
                              <th>Sr No</th>
                              <th>Webhook Profiles</th>
                              <th>Status</th>
                           </tr>
                        </thead>
                        <tbody id ="appSettingsContent"></tbody>
                     </table>
                     <div class="csv_pagination"></div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
<!-- End popup -->

<!-- Add New webhhook popup -->
<div class="modal fade" id="addWebhookPop" role="dialog">
   <div class="modal-dialog modal-lg">
      <div class="modal-content">
         <div class="modal-header text-left">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title">Add New Webhook</h4>
         </div>
         <div class="modal-body">
            <div class="row">
               <div class="col-md-12">
                
					<div class="form-group field-webhook-w_seq_id required">
						<label class="control-label" for="webhook-w_seq_id">Sequences</label>
						<select id="webhook-w_seq_id" class="form-control" name="Webhook[w_seq_id]" required="true">
						<option value="">Select</option>
						<?php if(!empty($Getwebhookseq)){ ?>
						<?php foreach($Getwebhookseq as $rows){ ?>
						<option value="<?php echo $rows['id']; ?>"><?php echo $rows['name']; ?></option>
						<?php } ?>
						<?php } ?>
						</select>
						<div class="help-block"></div>
					</div>
					<div class="form-group field-webhook-w_url required">
						<label class="control-label" for="webhook-w_url">Webhook URL</label>
						<input type="text" id="webhook-w_url" class="form-control" name="Webhook[w_url]" readonly="" label="Webhook URL" placeholder="Webhook URL" aria-required="true" aria-invalid="true">
						<div class="help-block"></div>
					</div>
					<div class="form-group">
						<button type="button" class="btn btn-success addNewWebhook">Save</button> 
					</div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
<!-- End webhhook popup -->
<script type="text/javascript">
$(document).ready(function(){
	
// Add ne popup

$(".add_new_webhook").click( function(){
	$('#addWebhookPop').modal('show');
});

$('#webhook-w_seq_id').on('change',function(){
			var sid = $(this).val();
			var uid = <?php echo Yii::$app->session->get('userid'); ?>;
			var csrfToken = $('meta[name="csrf-token"]').attr("content");

			$.ajax({
				type: "POST",
				url: "<?php echo Yii::$app->request->baseUrl; ?>/webh/checkseq",
				data: {'sid':sid,'uid':uid,_csrf : csrfToken},
				success: function(data){
				  if(data == '1'){
				  	  alert('Already generate URL for this sequence. Please select another Sequence');
				  	  $("#webhook-w_seq_id").val('');
				  	  $("#webhook-w_url").val('');
					  return false;
				  }else{
				  	var url = "<?php echo Yii::$app->request->baseUrl; ?>/webh/"+btoa(sid+'$*$'+uid);
					$("#webhook-w_url").val(url); 

					var w_seq_name = $("#webhook-w_seq_id option:selected").text();
					$("#w_seq_name").val(w_seq_name);
				  }
				}
			}); 
		});
		
	$(".addNewWebhook").click( function(){
		
		var sid = $('#webhook-w_seq_id').val();
		var wurl = $('#webhook-w_url').val();
		var sname = $('#webhook-w_seq_id option:selected').html();
		var csrfToken = $('meta[name="csrf-token"]').attr("content");
		
		if(sid == '')
		{
			$('#webhook-w_seq_id').css('border','1px solid red');
			return false;
		}
		else
		{
			$('#webhook-w_seq_id').css('border','1px solid green');
			
		}
		
		if(wurl == '')
		{
			$('#webhook-w_url').css('border','1px solid red');
			return false;
		}
		else
		{
			$('#webhook-w_url').css('border','1px solid green');
			
		}
		
		
		$.ajax({
				type: "POST",
				url: "<?php echo Yii::$app->request->baseUrl; ?>/webh/create",
				data: {'sid':sid,'wurl':wurl,'sname':sname,_csrf : csrfToken},
				success: function(data){
					window.location.reload();
				}
			}); 
	});
// 	
$('#webhooktable').DataTable({
"aaSorting": [],
"paging"  :false,
'columnDefs': [{
   "targets": 2,
   "className": "text-center"
}],
language: {
searchPlaceholder: "Search "
}

});
});

var table;
$('body').on('click', '#closeModal', function(){
$('#myModal22').modal('hide');
//location.reload();
});
$('body').on('click', '.row_class_new', function(){
var id=$(this).attr("id");
$('#allowedappdetail12334').DataTable().clear().draw();
$('#allowedappdetail12334').DataTable().destroy();

var dataTable = $('#allowedappdetail12334').DataTable({
       "processing": true,
       "serverSide": true,
       'columnDefs': [
       {"searchable": false,"orderable": false,"targets": 0,"className": "text-center"}
   ],
       "ajax": {
           url: "<?php echo Yii::$app->urlManager->createUrl(['my-template/csv_filee?id=']); ?>"+id,
           type: "POST",
           data: {id:id},
           error: function(){
              console.log('error');
           }
         }
   });  
$('#myModal22').modal('show');  
});
</script>