<?php
use yii\helpers\Html;
use yii\grid\GridView;
use yii\web\View;
use app\components\CommonFunction;

$this->title = 'Billing Address';
$user_id = Yii::$app->session->get('userid');
$posturl = Yii::$app->getUrlManager()->createUrl('billingaddress/ajx_update');
?>        

<section>
    <div class="container">
	
<?php if(Yii::$app->session->get('userid')!=Yii::$app->session->get('teamid')){ ?>
	<div class="alert alert-danger mb-2" role="alert">Only admin user can change billing information.</div>
<?php }else if($userDetail['2coCustomerReference']==0){ ?>
	<div class="alert alert-danger mb-2" role="alert">It looks like you are not linked with 2checkout.</div>
<?php } ?>

	
<?php if(!empty($userDetail) && Yii::$app->session->get('userid')==Yii::$app->session->get('teamid') && $userDetail['2coCustomerReference']>0 ){ ?>
		<h4 class="card-title" style="padding-top: 20px;">Billing Address</h4>
        <div class="row ">


<form name="billing_form" id="billing_form" role="form" method="post">
  <div class="form-group">
    <label for="custFullName">Your Full Name*:</label>
    <input type="text" class="form-control" name="custFullName" value="<?php echo (isset($Quickbook_userDetail['custFullName']))?$Quickbook_userDetail['custFullName']:''; ?>" placeholder="eg: John Doe" required />
  </div>
  <div class="form-group">
    <label for="custBillingAddress">Billing Address*:</label>
    <input type="text" class="form-control" name="custBillingAddress" value="<?php echo (isset($Quickbook_userDetail['custBillingAddress']))?$Quickbook_userDetail['custBillingAddress']:''; ?>" placeholder="eg: 123 Main Street" required />
  </div>
  <div class="form-group">
    <label for="bill_city">Billing City*:</label>
    <input type="text" class="form-control" name="bill_city" value="<?php echo (isset($Quickbook_userDetail['bill_city']))?$Quickbook_userDetail['bill_city']:''; ?>" placeholder="eg: Mountain View" required />
  </div>

  <div class="form-group">
    <label for="bill_country">Billing Country*:</label>
	<select name="bill_country" class="form-control " required>
		<option value="">--Select Billing Country--</option>
		<?php foreach($countries as $res){ 
		if(isset($Quickbook_userDetail['bill_country']) && $res['country_code']==$Quickbook_userDetail['bill_country']){
			$sel='selected="selected"';
		}else{
			$sel='';
		}
		?>
		<option value="<?php echo $res['country_code']; ?>" <?php echo $sel; ?>  ><?php echo $res['country_name']; ?></option>
		<?php } ?>
	</select>
  </div>
  
  <div class="form-group">
    <label for="bill_state">Billing State/Region:</label>
    <input type="text" class="form-control" name="bill_state" value="<?php echo (isset($Quickbook_userDetail['bill_state']))?$Quickbook_userDetail['bill_state']:''; ?>" placeholder="eg: CA"  />
  </div>
  <div class="form-group">
    <label for="bill_postal_code">Billing Postal Code:</label>
    <input type="text" class="form-control" name="bill_postal_code" value="<?php echo (isset($Quickbook_userDetail['bill_postal_code']))?$Quickbook_userDetail['bill_postal_code']:''; ?>" placeholder="eg: 94042" required />
  </div>
  
  
  <button type="submit" id="btn_2coProceed" class="btn btn-primary">Submit</button>
</form>            

        </div>
<?php } ?>

    </div>
</section>


<script>

$("#billing_form").submit(function (event) {
	event.preventDefault();
	$('#btn_2coProceed').prop("disabled", true);

	var form_ls = $('#billing_form')[0];
	var form_data = new FormData(form_ls);

	$.ajax({
		url: "<?php echo $posturl; ?>",
		method: "POST",
		data: form_data,
		processData: false,
		contentType: false,
		success: function (response) {
			var obj = JSON.parse(response);

			if (obj.success == '1') {
				swal({
					title: "Billing Address",
					text: obj.success_msg,
					type: "success"
				}).then(function () {
					//location.reload();
				});
				$('#btn_2coProceed').prop("disabled", false);
			} else if (obj.success == '0') {
				
				swal({
					title: "Billing Address",
					text: obj.error_msg,
					type: "error"
				}).then(function () {
					//location.reload();
				});
				$('#btn_2coProceed').prop("disabled", false);
			}
		},
		complete: function (xhr, textStatus) {
		}
	});
});
</script>