<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\db\Query;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Scheduled Tasks';
$this->registerJs('$(document).on("pjax:timeout", function(event) {
  // Prevent default timeout redirection behavior
  event.preventDefault()
});');
?>
<style>
    .term{
        display: inherit;
        position: relative;
        float: right;
        height: 20px;
        width: 20px;
        top: 5px;
        right: 5px;
        border-radius: 20px;
        font-weight: bold;
        text-align: center;
        cursor: pointer;
        margin-top: -32px;
    }
    .ScheduledTasks{
        margin-bottom: 50px;
    }
    .ScheduledTasks select.form-control:not([multiple=multiple]) {
        border-radius: 0!important;
    }
    .ScheduledTasks thead tr th{
        color: #475F7B;
        font-size: .8rem;
        letter-spacing: 1px;
    }
    .ScheduledTasks tbody tr td {
        font-size: 1rem;
        letter-spacing: 0;
    }
    .ScheduledTasks .dropdown-items{
        text-transform: uppercase;
        display: flex;
        align-items: center;
    }
    .swal2-icon.swal2-warning {
        font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
        color: #f8bb86;
        border-color: #facea8;
        font-size: 18px;
        text-align: center;
    }
    .title_heading{
        font-weight: 400;
        letter-spacing: .05rem;
        font-size: 1.2rem;
        margin-bottom: 1.2rem;
        text-transform: capitalize;
    }
.pagination .page-item.active .page-link, .pagination .page-item.active .page-link:hover {
    color: #FFFFFF !important;
}
</style>
<div class="site-index ScheduledTasks">
    <div class="body-content">
        <div class="row" style="margin-top: 20px;">
            <div class="col-lg-12 p-0">
                <div class="alert alert-success" id="success-alert" style="display:none">
                    Skipped successfully.
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12 p-0">
                <div class="row" style="margin-top: 20px;margin-bottom: 20px;">

                    <div class="col-md-2 p-0">
                        <h5 class="title_heading">Scheduled for</h5>
                    </div>
                    <div class="col-md-2 p-l-r-0">
                        <div>
                            <form action="<?php echo Yii::$app->request->baseUrl; ?>/scheduletask" autocomplete="off">
                                <div class="input-group">
                                    <input type="text" value="<?php
                                    if (isset($_GET['scheduletasksearchname'])) {
                                        echo $_GET['scheduletasksearchname'];
                                    }
                                    ?><?php
                                    if (isset($_GET['search'])) {
                                        echo $_GET['search'];
                                    }
                                    ?>" class="form-control searchname" placeholder="Search & Hit Enter" name="scheduletasksearchname">                                   

                                    <div class="input-group-btn crossbtn" style='position: absolute;right: 0;width: 35px;height: 100%;background-color: #5a8dee;display: none;align-items: center;justify-content: center;border-top-right-radius: 5px;border-bottom-right-radius: 5px;'>
                                        <button type="button" id="cleardata" style="padding: 0; display: flex;align-items: center; margin-top: -5px;" class="btn btn-default"><i class="fa fa-remove" style='line-height: 1;color: #fff;'></i></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="">                                          
                            <select class="sequenceList form-control" name="sequenceList" style="width: 100%" id="sequenceList">
                                <option value="all">All Sequences</option>
                                <?php foreach ($sequences as $sequence) { ?>
                                    <option value="<?php echo $sequence['id']; ?>" <?php
                                    if (!empty(Yii::$app->session->get('seqId'))) {
                                        if (Yii::$app->session->get('seqId') == $sequence['id']) {
                                            echo "selected";
                                        }
                                    }
                                    ?>><?php echo $sequence['name']; ?></option>
                                        <?php } ?>
                            </select>
                        </div>
                        <div class="mm-bottom visible-xs"></div>
                    </div> 

                    <div class="col-md-2">
                        <div class="">  
                            
                            <select class="seqFollowUpTime form-control" name="seqFollowUpTime" style="width: 100%" id="seqFollowUpTime">
                                <option value="1" <?php
                                if (!empty(Yii::$app->session->get('seqFollowUpTime'))) {
                                    if (Yii::$app->session->get('seqFollowUpTime') == '1') {
                                        echo "selected";
                                    }
                                }
                                ?>>24 Hours</option>                                                  
                                <option value="2" <?php
                                if (!empty(Yii::$app->session->get('seqFollowUpTime'))) {
                                    if (Yii::$app->session->get('seqFollowUpTime') == '2') {
                                        echo "selected";
                                    }
                                } else {
                                    echo 'Selected';
                                }
                                ?>>48 Hours</option>
                                <option value="7" <?php
                                if (!empty(Yii::$app->session->get('seqFollowUpTime'))) {
                                    if (Yii::$app->session->get('seqFollowUpTime') == '7') {
                                        echo "selected";
                                    }
                                }
                                ?>>7 Days</option>
                                <option value="24" <?php
                                if (!empty(Yii::$app->session->get('seqFollowUpTime'))) {
                                    if (Yii::$app->session->get('seqFollowUpTime') == '24') {
                                        echo "selected";
                                    }
                                }
                                ?>>15 Days</option>
                            </select> 
                        </div>
                        <div class="mm-bottom visible-xs"></div>
                    </div> 
					<div class="col-md-2">
						<?php// if(isset($_REQUEST['msg']) && $_REQUEST['msg'] == '1'){ ?>
						<div class="custom-control custom-switch custom-switch-success custom-switch-glow custom-control-inline mt-1">
							<span>Hide Paused Tasks&nbsp;&nbsp;</span>
							<input type="checkbox" class="custom-control-input" id="hidepausedtask" name="hidepausedtask" value="1">
							<label class="custom-control-label" for="hidepausedtask">
							</label>
						</div>
						<?php //} ?>
					</div>

                    <div class="col-md-2 filterBtnDiv" style="display:none">
                        <div class="">                                 											
                            <button id="search" type="button" class="btn btn-primary btn-sm" title="Search Term"><i class="fa fa-search"></i> Search</button>	
                        </div>
                    </div>

                </div>

                <?php
                $queryUsr = new Query();
                $queryUsr->select('TimeZone')->from('user')->where(['id' => Yii::$app->session->get('userid')]);
                $usrData = $queryUsr->one();

                \yii\widgets\Pjax::begin(['id' => 'dataListSection']);
                ?>
                <?=
                GridView::widget([
                    'dataProvider' => $dataProvider,
                    'id' => 'responses',
                    'tableOptions' => [
                        'id' => 'theDatatable',
                        'class' => 'table'
                    ],
                    'layout' => '{items}<br /><nav aria-label="Page navigation example">{pager}</nav>',
                    'options' => ['data-count' => $dataProvider->getTotalCount()],
                    'pager' => [
                        'options' => ['class' => 'pagination'], // set clas name used in ui list of pagination
                        'linkOptions' => ['class' => 'page-link'],
                        'disabledListItemSubTagOptions' => [
                            'class' => 'page-link',
                        ],
                        'pageCssClass' => 'page-item',
                        'prevPageLabel' => 'Previous', // Set the label for the “previous? page button
                        'nextPageLabel' => 'Next', // Set the label for the “next? page button
                        //'firstPageLabel'=>'First',   // Set the label for the “first? page button
                        //'lastPageLabel'=>'Last',    // Set the label for the “last? page button
                        'nextPageCssClass' => 'page-item', // Set CSS class for the “next? page button
                        'prevPageCssClass' => 'page-item', // Set CSS class for the “previous? page button
                        'disabledPageCssClass' => 'page-item',
                        //'firstPageCssClass'=>'first',    // Set CSS class for the “first? page button
                        //'lastPageCssClass'=>'last',    // Set CSS class for the “last? page button
                        'maxButtonCount' => 5, // Set maximum number of page buttons that can be displayed 
                    ],
                    'columns' => [
                        ['class' => 'yii\grid\SerialColumn'],
                        [
                            'label' => 'Full Name',
                            'attribute' => 'person',
                            'format' => 'html',
                            'value' => function($model) {
                                if (!empty(json_decode(preg_replace('/\"description\"\:\".*?\"\,/ms', '"description":"empty",', $model['person']))->firstName)) {
                                    return json_decode(preg_replace('/\"description\"\:\".*?\"\,/ms', '"description":"empty",', $model['person']))->firstName . ' ' . json_decode(preg_replace('/\"description\"\:\".*?\"\,/ms', '"description":"empty",', $model['person']))->lastName;
                                } else {
                                    return '-';
                                }
                            },
                        //'visible' => (Yii::$app->user->identity->userRole != 'Viewer')?true:false,
                        //'contentOptions' => ['class' => ''],
                        //'headerOptions' => ['class' => '']
                        ],
                        [
                            'label' => 'Seq Name',
                            'attribute' => 'name',
							'format' => 'html'
                        ],
                        [  
                            'label' => 'Scheduled On',
                            'attribute' => 'requestWithdrawDays',
                            'value' => function($model) use ($usrData) {
                                if (!empty($model['starttime'])) {
                                    //if(Yii::$app->session->get('userid') == 14876){
                                    $ist_date = \DateTime::createFromFormat('d-m-Y h:i:s A', date('d-m-Y h:i:s A', $model['starttime'] / 1000), new \DateTimeZone('UTC'));
                                    $gmt_date = clone $ist_date;
                                    $gmt_date->setTimeZone(new \DateTimeZone($usrData['TimeZone']));
                                    $date = $gmt_date->format('m-d-Y h:i:s A');
                                    return $date;
                                    /* }else{
                                      return date('d-m-Y h:i:s A', strtotime('+'.$model['requestWithdrawDays'].' days', $model['starttime'])/1000);
                                      } */
                                } else {
                                    return '-';
                                }
                            },
                        ],
                        [
                            'header' => '',
                            'class' => 'yii\grid\ActionColumn',
                            'template' => '{skip}',
                            'buttons' => [
                                'skip' => function ($url, $model) {
                                    if (!empty(json_decode(preg_replace('/\"description\"\:\".*?\"\,/ms', '"description":"empty",', $model['person']))->firstName)) {
                                        $fullname = json_decode(preg_replace('/\"description\"\:\".*?\"\,/ms', '"description":"empty",', $model['person']))->firstName . ' ' . json_decode(preg_replace('/\"description\"\:\".*?\"\,/ms', '"description":"empty",', $model['person']))->lastName;
                                    } else {
                                        $fullname = '-';
                                    }
                                    /* $blacklistCnt = Yii::$app->db->createCommand("select COUNT(id) AS cnt from  ext_blacklist where liId ='" . json_decode($model['person'])->person_id . "' AND userId = '" . Yii::$app->session->get('userid')."'")->queryScalar(); */
                                    $blacklistCnt = Yii::$app->db->createCommand("select COUNT(id) AS cnt from  blacklist where linkedinpublicid ='" . $model['personId'] . "' AND is_response=1 AND userId = '" . Yii::$app->session->get('userid') . "'")->queryScalar();
                                    /* if($blacklistCnt > 0 && json_decode($model['person'])->connected == true){
                                      return Html::a(
                                      'Follow-up Skipped',
                                      false,
                                      [
                                      'class'          => 'skip-follow-up',
                                      'data-id'		 =>	$model['id'],
                                      'style'			 =>	'cursor:pointer',
                                      'data-pjax'		 => 0,
                                      'data-skip'		 => $model['personId'],
                                      'title'          => Yii::t('app', 'Follow-up Skipped')
                                      ]
                                      );
                                      } */
                                    if ($model['step'] != 0 && $model['triggerOnInvitationAccepted'] != 0 /* && json_decode($model['person'])->connected == false */) {
                                        return Html::a(
                                                        'Skip withdraw', '#', [
                                                    'class' => 'skip-withdraw',
                                                    'data-id' => $model['id'],
                                                    'data-seqId' => $model['seqId'],
                                                    'style' => 'cursor:pointer',
                                                    'data-pjax' => 0,
                                                    'data-skip' => $model['personId'],
                                                    'data-fullname' => $fullname,
                                                    'title' => Yii::t('app', 'Skip Withdraw')
                                                        ]
                                        );
                                    }else if ($model['type'] == "Connect"){
										return Html::a(
                                                        'Skip Invitation', '#', [
                                                    'class' => 'skip-follow-up',
                                                    'data-id' => $model['id'],
                                                    'data-seqId' => $model['seqId'],
                                                    'style' => 'cursor:pointer',
                                                    'data-pjax' => 0,
                                                    'data-skip' => $model['personId'],
                                                    'data-fullname' => $fullname,
                                                    'title' => Yii::t('app', 'Skip Invitation')
                                                        ]
                                        );
									} else {
                                        return Html::a(
                                                        'Skip Follow-up', '#', [
                                                    'class' => 'skip-follow-up',
                                                    'data-id' => $model['id'],
                                                    'data-seqId' => $model['seqId'],
                                                    'style' => 'cursor:pointer',
                                                    'data-pjax' => 0,
                                                    'data-skip' => $model['personId'],
                                                    'data-fullname' => $fullname,
                                                    'title' => Yii::t('app', 'Skip Follow-up')
                                                        ]
                                        );
                                    }
                                },
                            ]
                        ],
                        [
                            'header' => '',
                            //'visible' => (Yii::$app->user->identity->userRole != 'Viewer')?true:false,
                            'class' => 'yii\grid\ActionColumn',
                            'template' => '{profile}',
                            'buttons' => [
                                'profile' => function ($url, $model) {
                                    return Html::a(
                                                    '<i class="bx bx-show mr-1"></i>View ', false, [
                                                'class' => 'dropdown-items',
                                                'data-id' => $model['id'],
                                                'style' => 'cursor:pointer',
                                                'data-pjax' => 0,
                                                'title' => Yii::t('app', 'View Profile')
                                                    ]
                                    );
                                },
                            ],
                            'urlCreator' => function ($action, $model, $key, $index) {
                                if ($action === 'profile') {
                                    $url = ''; //json_decode($model['person'])->url;
                                    return $url;
                                }
                            }
                        ]
                    ],
                ]);
                ?>
                <?php \yii\widgets\Pjax::end(); ?>
            </div>

        </div>

    </div>

    <div class="modal fade profile in" id="profile_model" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Profile Details</h4>
                </div>
                <div class="modal-body" style="background-color:#f5f5f5ba;">
                    <div class="profilewizard">

                    </div>
                    <label id="error"></label>

                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function () {
        var timeout = null;

        /* Schedule Delete Popup*/
        $(document).on("click", "a.deleteItem", function () {
            var tableRow = $(this).closest('tr');
            var id = $(this).data("id");
            var r = confirm("Are you sure?");

            if (r == true) {
                $.ajax({
                    'type': 'POST',
                    'data': {id: id},
                    'url': '<?= Yii::$app->request->baseUrl ?>/responses/deleteresponse',
                    success: function (res) {
                        if (res) {
                            tableRow.find('td').fadeOut('slow',
                                    function () {
                                        tableRow.remove();
                                        $("#success-alert").fadeTo(2000, 500).slideUp(500, function () {
                                            $("#success-alert").slideUp(500);
                                        });
                                    }
                            );
                        } else {
                            $("#error-alert").fadeTo(2000, 500).slideUp(500, function () {
                                $("#error-alert").slideUp(500);
                            });
                        }
                    }
                });
            }
        });

        $("#sequenceList").change(function () {
            $("#search").click();
        });
        $("#seqFollowUpTime").change(function () {
            $("#search").click();
        });
		
		
		
		$("#hidepausedtask").change(function () {
            $("#search").click();
        });
		
		var hidepausedval = 0;
        $("#search").click(function (event) {
			
			if ($("#hidepausedtask").is(":checked")) {
				hidepausedval = 1;
			}else{
				hidepausedval = 0;
			}
			
            $.ajax({'type': 'POST',
                'data': {seqId: $('#sequenceList').val(), seqFollowUpTime: $('#seqFollowUpTime').val(),hidepausedtask:hidepausedval},
                'url': '<?= Yii::$app->request->baseUrl ?>/scheduletask/setschedulefilter',
                success: function (res) {
                    $.pjax.reload({container: '#dataListSection', timeout: 0});
                }
            });
            return false;
        });

        $(document).on("click", ".skip-follow-up", function () {
            var tableRow = $(this).closest('tr');
            if (typeof (Storage) !== "undefined") {
                var n = localStorage.getItem('on_load_counter_skip_follow');
                if (n === null) {
                    n = 0;
                }
                n++;
                localStorage.setItem("on_load_counter_skip_follow", n);
                if (n > 3) {
                    $.ajax({'type': 'POST',
                        'data': {seqId: $(this).data('seqid'), taskId: $(this).data('id'), personId: $(this).data('skip'), fullname: $(this).data('fullname'), types: 'Follow-up'},
                        'url': '<?= Yii::$app->request->baseUrl ?>/scheduletask/skipfollowup',
                        success: function (res) {
                            if (res) {
                                tableRow.find('td').fadeOut('slow',
                                        function () {
                                            tableRow.remove();
                                            $("#success-alert").fadeTo(2000, 500).slideUp(500, function () {
                                                $("#success-alert").slideUp(500);
                                            });
                                        }
                                );
                            } else {
                                $("#error-alert").fadeTo(2000, 500).slideUp(500, function () {
                                    $("#error-alert").slideUp(500);
                                });
                            }
                        }
                    });
                } else {
                    swal({
                        title: 'Are you sure?',
                        text: "All the future followups for this prospect will be skipped",
                        type: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, Skip it !'
                    }).then((result) => {
                        if (result.value) {
                            $.ajax({'type': 'POST',
                                'data': {seqId: $(this).data('seqid'), taskId: $(this).data('id'), personId: $(this).data('skip'), fullname: $(this).data('fullname'), types: 'Follow-up'},
                                'url': '<?= Yii::$app->request->baseUrl ?>/scheduletask/skipfollowup',
                                success: function (res) {
                                    if (res) {
                                        tableRow.find('td').fadeOut('slow',
                                                function () {
                                                    tableRow.remove();
                                                    $("#success-alert").fadeTo(2000, 500).slideUp(500, function () {
                                                        $("#success-alert").slideUp(500);
                                                    });
                                                }
                                        );
                                    } else {
                                        $("#error-alert").fadeTo(2000, 500).slideUp(500, function () {
                                            $("#error-alert").slideUp(500);
                                        });
                                    }
                                }
                            });
                        }
                    });
                }
            }

        });

        $(document).on("click", ".skip-withdraw", function () {
            var tableRow = $(this).closest('tr');
            if (typeof (Storage) !== "undefined") {
                var n = localStorage.getItem('on_load_counter_skip_withdraw');
                if (n === null) {
                    n = 0;
                }
                n++;
                localStorage.setItem("on_load_counter_skip_withdraw", n);
                if (n > 3) {
                    $.ajax({'type': 'POST',
                        'data': {seqId: $(this).data('seqid'), taskId: $(this).data('id'), personId: $(this).data('skip'), fullname: $(this).data('fullname'), types: 'Withdrawal'},
                        'url': '<?= Yii::$app->request->baseUrl ?>/scheduletask/skipwithdraw',
                        success: function (res) {
                            if (res) {
                                tableRow.find('td').fadeOut('slow',
                                        function () {
                                            tableRow.remove();
                                            $("#success-alert").fadeTo(2000, 500).slideUp(500, function () {
                                                $("#success-alert").slideUp(500);
                                            });
                                        }
                                );
                            } else {
                                $("#error-alert").fadeTo(2000, 500).slideUp(500, function () {
                                    $("#error-alert").slideUp(500);
                                });
                            }
                        }
                    });
                } else {
                    swal({
                        title: 'Are you sure?',
                        text: "You will not be able to recover after skip-withdraw",
                        type: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, Skip it!'
                    }).then((result) => {
                        if (result.value) {
                            $.ajax({'type': 'POST',
                                'data': {seqId: $(this).data('seqid'), taskId: $(this).data('id'), personId: $(this).data('skip'), fullname: $(this).data('fullname'), types: 'Withdrawal'},
                                'url': '<?= Yii::$app->request->baseUrl ?>/scheduletask/skipwithdraw',
                                success: function (res) {
                                    if (res) {
                                        tableRow.find('td').fadeOut('slow',
                                                function () {
                                                    tableRow.remove();
                                                    $("#success-alert").fadeTo(2000, 500).slideUp(500, function () {
                                                        $("#success-alert").slideUp(500);
                                                    });
                                                }
                                        );
                                    } else {
                                        $("#error-alert").fadeTo(2000, 500).slideUp(500, function () {
                                            $("#error-alert").slideUp(500);
                                        });
                                    }
                                }
                            });
                        }
                    });
                }
            }
        });

        $(document).on("click", ".dropdown-items", function () {
            $('#profile_model').modal('show');
            $.ajax({'type': 'POST',
                'data': {taskId: $(this).data('id')},
                'url': '<?= Yii::$app->request->baseUrl ?>/scheduletask/getprofiledata',
                success: function (res) {
                    $('.profilewizard').html(res);
                    //$.pjax.reload({container:'#dataListSection', timeout:0}); 
                }
            });
        });

        $(document).on('pjax:start', function () {
            $(".ajax-spinner").css("display", "inherit");
        });
        $(document).on('pjax:complete', function () {
            $(".ajax-spinner").css("display", "none");
        });
    });
</script>
