<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\models\MyTemplateSearchModel */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Sales Person Settings';
?>
<div class="row">
    <div class="col-md-12">
        <h3>Buy Links Entry Form</h3>
		<p>As the buy link's orders are created outside from our system(ie. without using our pricing page) these orders are not inserting into our database. To enter such orders and further managed by system itself, it is required to enter such orders by filling below form. </p>
        <div class="grid simple contentmargin">                           
            <div class="grid-body no-border">
                <div class="panel panel-white">
                    <div class="col-md-12">                          
                        <div class="panel-body">
						
						
<!--starts-->
						<p style="color:red; font-size:12px !important;">All fields are mandatory.</p>
						
                        <form id="buyLinkEntry_form" method="POST" name="buyLinkEntry_form" action="<?php echo Yii::$app->getUrlManager()->createUrl('salesteam/buy_link_entry_form'); ?>" onsubmit="return false">

							  <div class="form-row">
								<div class="form-group col-md-6">
								  <label for="ble_orderRef">Enter Order Reference:</label>
								  <input type="text" name="ble_orderRef" id="ble_orderRef" class="form-control required" value="" >
								  <input type="hidden" name="_csrf" value="<?= Yii::$app->request->getCsrfToken() ?>" />
								</div>
								<div class="form-group col-md-6">
									<label>&nbsp;</label>
								  <input type="button" class="btn btn-primary form-control" onclick="jsGetOrderRef()" id="btn_getOrderRef" name="btn_getOrderRef" value="Validate Order">
								</div>
							  </div>
							  
							  

							 <!--html starts-->
							 <div class="ClsForm" style="display:none;">

								<div class="form-row">
									<div class="form-group col-md-6">
									  <label for="ble_userEmail">Enter Email Address Who Placed This Order: [This will treat as user_id]</label>
									  <input type="text" name="ble_userEmail" id="ble_userEmail" class="form-control required" value="" >
									</div>
								</div>
								 
								<div id="bl_create_form"></div>
								 
								  
								<div class="form-row">
									<div class="form-group col-md-6">
										<input type="submit" class="btn btn-primary form-control" onclick="jsInsertOrder()" id="btn_insertOrder" name="btn_insertOrder" value="Insert This Order">
									</div>
								</div>
								
								<div class="form-row">
								<b>Note: On clicking above button, the entered email addresses will be validated and these emails must exists into the portal #<?php echo Yii::$app->params['portal_id'].' '.Yii::$app->params['portal_url']; ?></b>
								</div>

							 </div>

							  
							  
							  
							  <!--html ends-->
                            
                            
                        </form>
<!--ends-->

						
						
                        </div>                            
                    </div>                              
                </div>
            </div>
        </div>
    </div>
</div>


<script>
function jsGetOrderRef() {
	var orderRef = $('#ble_orderRef').val();
	//alert(orderRef);
	var csrfToken = $('meta[name="csrf-token"]').attr("content");

	$.ajax({
		url: "<?php echo Yii::$app->getUrlManager()->createUrl('salesteam/validate_order_info'); ?>",
		method: "POST",
		data: {'orderRef': orderRef, '_csrf': csrfToken},
		success: function (response) {
			
			var obj = JSON.parse(response);
			//alert(obj.success);

			if (obj.success == '1') {
				
				$('#btn_getOrderRef').attr('disabled',true);
				$('#ble_orderRef').attr('readonly',true);
				
				
				var pro_codes = obj.return_product.product_codes;
				var pro_names = obj.return_product.product_names;
				var pro_qty = obj.return_product.product_qty;
				
				var html = '';
				$.each( pro_codes, function( key, value ) {
				  //alert( key + ": " + value );
				  //alert( key + ": " + pro_names[key] );
				  

		  html+= '<div class="form-row">';
			html+= '<div class="form-group col-md-12">';
			  html+= '<label for="">Enter '+ pro_qty[key] +' UserEmail(s) For Whom '+ value +' (ie. '+ pro_names[key] +') Is Purchased:</label>';
			  html+= '<input type="text" name="ble_seatPurchasedUserEmails['+ value +']" id="ble_seatPurchasedUserEmails_'+ value +'" class="form-control required" value="" placeholder="Enter comma separated user emails when multiple users. eg: one@xyz.com, two@xyz.com, three@xyz.com" >';
			html+= '</div>';
		  html+= '</div>';
				  
				  
				});
				
				$('#bl_create_form').html(html);
				$('.ClsForm').show();
				
				
				
				
			}else{
				swal({
					title: "Failed",
					text: obj.error_msg,
					type: "error"
				}).then(function () {
					//location.reload();
				});
				
			}
			

		},
		complete: function (xhr, textStatus) {
		}
	});

}
function jsInsertOrder(){

	var form_ls = $('#buyLinkEntry_form')[0];
	var form_data = new FormData(form_ls);
	
	
	$.ajax({
		url: "<?php echo Yii::$app->getUrlManager()->createUrl('salesteam/buy_link_entry_form'); ?>",
		method: "POST",
		data: form_data,
		processData: false,
		contentType: false,
		success: function (response) {
			var obj = JSON.parse(response);
			//alert(obj.success);

			if (obj.success == '1') {

				swal({
					title: "Success",
					text: obj.success_msg,
					type: "success"
				}).then(function () {
					location.reload();
				});
				
				
			}else{
				swal({
					title: "Failed",
					text: obj.error_msg,
					type: "error"
				}).then(function () {
					//location.reload();
				});
				
			}
			
			

		},
		complete: function (xhr, textStatus) {
		}
	});
}
</script>