<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Salesforce | Integration';
?>
<link rel="stylesheet" type="text/css" href="<?php echo Yii::$app->request->baseUrl; ?>/theme/css/select2.min.css<?= '?' . round(microtime(true) * 1000) ?>">
<section id="basic-horizontal-layouts">
    <div class="row">
        <div class="col-8 p-l-r-0">
            <h4>Salesforce settings</h4>
        </div>        
        <?php if ( $TokenData['access_token'] != "" && $TokenData['refresh_token'] != "" && $TokenData['instance_url'] != "" && $TokenData['sid'] != "") { ?>
            <div class="col-4 p-l-r-0 text-right">
                <button id="disconnectSalesforce"  class="btn btn-danger"><i class="fa fa-chain-broken" aria-hidden="true"></i> Disconnect</button>
            </div>
        <?php } ?>
        <div class="col-12 p-l-r-0">
            <div class="card">
                <?php if (!$loggedin) { ?>
                    <div>

                        <h4 class="card-title" style="padding-top: 20px;">Salesforce Settings</h4>
                    </div>
                    <?php $form = ActiveForm::begin(); ?>
                    <div class="row"> 
                        <input type="hidden" name="_csrf" value="FHwzQ6FoRJ8g5eXOZSRclsjyq0w8Hfpt1ZWSKzE-iZNlS2IW6Rkm1ka1pL5VVwzsiaieLg5Qkw6ExMZBbne93Q==">
                        <input type="hidden" name="user_id" value="<?php echo Yii::$app->session->get('userid'); ?>">
                        <div class="col-6 p-l-r-0">
                            <fieldset class="form-group">
                                <a href="javascript:;" class="btn btn-primary btn-lg" role="button" aria-disabled="false" onclick="openSalesforceLogin()">Connect With Salesforce<img src="https://login.salesforce.com/img/logo214.svg" class="img-fluid" alt="Responsive image"></a>
                            </fieldset>
                            <div class="row"> 
                                <div class="col-md-12">
                                    <div id="alert_message"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php ActiveForm::end(); ?>
                <?php } else { ?>
                    <div class="row"> 
                        <div class="col-6 p-l-r-0">
                        </div>
                    </div>
                    <div class="row"> 
                        <div class="col-12 p-l-r-0">
                            <div>
                                <div>
                                    <fieldset class="form-group">
                                        <label for="salesforce_auto">Create Contact Automatically On Acceptance</label>
                                        <select name="salesforce_auto" id="salesforce_auto" onchange="updatestatus(this.value);" class="form-control" style="width:400px;">
                                            <option value="0" <?php
                                            if (isset($TokenData['status']) && $TokenData['status']) {
                                                echo 'selected';
                                            }
                                            ?> >OFF</option>
                                            <option value="1" <?php
                                            if (isset($TokenData['status']) && $TokenData['status'] == 1) {
                                                echo 'selected';
                                            }
                                            ?>>ON</option>
                                        </select>
                                        <span style="font-size: small;">Note:We will create a new/Update contact on Salesforce with all the details from LinkedIn when someone accepts your request.</span>
                                    </fieldset>
                                    <a href="<?php echo Yii::$app->request->baseUrl; ?>/salesforce?action=edit" class="btn btn-primary mr-1 mb-1">Edit</a>

                                    <?php if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'edit') { ?>
                                        <form id="form_ls" method="post"> 

                                            <div class=" tab tab-2" style="padding: 20px 0;">

                                                <div class="panel panel-default" style="width:auto;">
                                                    <h5 class="card-title">Contact</h5>
                                                    <div class="panel-body">
                                                        <div>
                                                            <div class="row">
                                                                <div class="table-responsive">
                                                                    <table class="select-wrap locket ua_field_wrapperContact table mb-0" id="contact-fields">
                                                                        <thead>
                                                                            <tr>
                                                                                <th class="text-left">
                                                                                    Salesforce Field
                                                                                </th>
                                                                                <th class="">
                                                                                    Portal Field
                                                                                </th>
                                                                                <th></th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <?php
                                                                            if (!empty($companyRow)) {
                                                                                $i = 1;
                                                                                foreach ($contactRow as $contactkey => $contactvalue) {
                                                                                    ?>
                                                                                    <tr class="contactRowNumber_1">
                                                                                        <td>
                                                                                            <select name="selContactProperty[]" class="select2 form-control" style="width: 300px;" data-group="Contact" data-width="fit">                                                                                
                                                                                                <?php
                                                                                                foreach ($contactfieldsSalesforce as $contactfields) {
                                                                                                    if ($contactfields['name'] == $contactkey) {
                                                                                                        $selected_contactS = 'selected="selected"';
                                                                                                    } else {
                                                                                                        $selected_contactS = "";
                                                                                                    }
                                                                                                    ?>
                                                                                                    <option <?php echo $selected_contactS; ?> value="<?php echo $contactfields['name']; ?>" ><?php echo $contactfields['label']; ?></option>
                                                                                                <?php } ?>                                                                        
                                                                                            </select>
                                                                                        </td>
                                                                                        <td>
                                                                                            <select class="select2 form-control" name="selContactFormat[]">                                                                                
                                                                                                <?php
                                                                                                if (!empty($contactFieldsPortal)) {
                                                                                                    foreach ($contactFieldsPortal as $key => $value) {
                                                                                                        if ($key == $contactvalue) {
                                                                                                            $selected_contactP = 'selected="selected"';
                                                                                                        } else {
                                                                                                            $selected_contactP = "";
                                                                                                        }
                                                                                                        ?>
                                                                                                        <option <?php echo $selected_contactP; ?> value="<?php echo $key; ?>" ><?php echo $value; ?></option>
                                                                                                        <?php
                                                                                                    }
                                                                                                }
                                                                                                ?>
                                                                                            </select>
                                                                                        </td>
                                                                                        <td>
                                                                                            <?php if ($i > 3) { ?>
                                                                                                <span><i class="bx bxs-trash deleteRow"  title="Delete."></i></span>
                                                                                            <?php } else { ?>
                                                                                                <span><i class="bx bxs-lock-alt" title="This property can not be edited or deleted."></i></span>
                                                                                            <?php } ?>

                                                                                        </td>
                                                                                    </tr> 
                                                                                    <?php
                                                                                    $i++;
                                                                                }
                                                                            }
                                                                            ?>

                                                                        </tbody>
                                                                    </table>

                                                                </div>
                                                                <div class="col-12 p-l-r-0">
                                                                    <button class="ua_add_button_contact third ld_localize btn btn-primary mb-1 mt-1 float-right" type="button" id="add2" data-ld_localize="ladd_property">Add Property</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="panel panel-default" style="width:auto;">
                                                    <h5 class="card-title">Company</h5>
                                                    <div class="panel-body">
                                                        <div>
                                                            <div class="row">
                                                                <div class="table-responsive">
                                                                    <table class="select-wrap ua_field_wrapperCompany table mb-0" id="company-fields">
                                                                        <thead>
                                                                            <tr>
                                                                                <th class="">
                                                                                    Salesforce Filed
                                                                                </th>
                                                                                <th class="">
                                                                                    Portal Field
                                                                                </th>
                                                                                <th></th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <?php
                                                                            if (!empty($companyRow)) {
                                                                                $j = 1;
                                                                                foreach ($companyRow as $companykey => $companyvalue) {
                                                                                    ?>
                                                                                    <tr class="companyRowNumber_1">
                                                                                        <td>
                                                                                            <select name="selCompanyProperty[]" class="select2 form-control" style="width: 300px;" data-group="Company" data-width="fit">                                                                                    
                                                                                                <?php
                                                                                                foreach ($companyfieldsSalesforce as $companyfields) {
                                                                                                    if ($companyfields['name'] == $companykey) {
                                                                                                        $selected_companyS = 'selected="selected"';
                                                                                                    } else {
                                                                                                        $selected_companyS = '';
                                                                                                    }
                                                                                                    ?>
                                                                                                    <option <?php echo $selected_companyS; ?> value="<?php echo $companyfields['name']; ?>" ><?php echo $companyfields['label']; ?></option>
                                                                                                <?php } ?>                                                                              
                                                                                            </select>
                                                                                        </td>
                                                                                        <td>
                                                                                            <select class="select2 form-control ravi" name="selCompanyFormat[]">                                                                                       
                                                                                                <?php
                                                                                                if (!empty($companyFieldsPortal)) {
                                                                                                    foreach ($companyFieldsPortal as $key => $value) {
                                                                                                        if ($key == $companyvalue) {
                                                                                                            $selected_companyP = 'selected="selected"';
                                                                                                        } else {
                                                                                                            $selected_companyP = '';
                                                                                                        }
                                                                                                        ?>
                                                                                                        <option <?php echo $selected_companyP; ?> value="<?php echo $key; ?>" ><?php echo $value; ?></option>
                                                                                                        <?php
                                                                                                    }
                                                                                                }
                                                                                                ?>
                                                                                            </select>
                                                                                        </td>
                                                                                        <td>
                                                                                            <?php if ($j > 2) { ?>
                                                                                                <span><i class="bx bxs-trash deleteRow"  title="Delete."></i></span>
                                                                                            <?php } else { ?>
                                                                                                <span><i class="bx bxs-lock-alt" title="This property can not be edited or deleted."></i></span>
                                                                                            <?php } ?>
                                                                                        </td>
                                                                                    </tr> 
                                                                                    <?php
                                                                                    $j++;
                                                                                }
                                                                            }
                                                                            ?>

                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                                <div class="col-12 p-l-r-0">
                                                                    <button class="ua_add_button_company third ld_localize btn btn-primary mt-1 mb-1 float-right" type="button" id="add3" data-ld_localize="ladd_property">Add Property</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <button id="tempSvl" onclick="return jsSaveProspectorSettings()" class="btn btn-primary  mr-1 mb-1 mt-1 inline tmpl tmpl_save margin-left-16 save ld_localize" style="margin-top: -45px;" data-ld_localize="lsave"><i class="bx bxs-save"></i>Save</button>
                                        </form>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</section>
<script>
    //function disconnectHubspot(tval) {
    $(document).ready(function () {
        $("#disconnectSalesforce").click(function (e) {
            e.preventDefault();
            swal({
                title: 'Are you sure you want to disconnect?',
                //text: "long text message here",
                type: 'error',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, disconnect it!'
            }).then((result) => {
                if (result.value) {
                    $.ajax({
                        url: "<?php echo Yii::$app->request->baseUrl; ?>/salesforce/disconnectsalesforce",
                        type: "POST",
                        success: function (data) {
                            console.log(data);
                            if (data) {
                                window.location.href = "<?php echo Yii::$app->request->baseUrl; ?>/salesforce";
                            } else {
                                alert("Something went wrong.");
                                return false;
                            }
                        }
                    });
                }
            });

        });
    });

</script>
<script type="text/javascript" language="javascript">
    $(document).ready(function () {
        $(".select2").select2({
            dropdownAutoWidth: true,
            placeholder: "Type or insert",
            width: '100%'
        });
    });
    $(document).on("click", ".deleteRow", function (event) {
        $(this).closest("tr").remove();
    });
    $(document).on("click", ".ua_add_button_contact", function (event) {
        $(".ua_add_button_contact").attr("disabled", true);
        $.ajax({
            type: "POST",
            url: '<?php echo Yii::$app->request->baseUrl; ?>/salesforce/addcontactrow',
            success: function (response) {
                $('.contactRowNumber_1:last-child').after(response);
                $(".select2").select2({
                    dropdownAutoWidth: true,
                    width: '100%'
                });
                $(".ua_add_button_contact").attr("disabled", false);
            }
        });
    });
    $(document).on("click", ".ua_add_button_company", function (event) {
        $(".ua_add_button_company").attr("disabled", true);
        $.ajax({
            type: "POST",
            url: '<?php echo Yii::$app->request->baseUrl; ?>/salesforce/addcompanyrow',
            success: function (response) {
                $('.companyRowNumber_1:last-child').after(response);
                $(".select2").select2({
                    dropdownAutoWidth: true,
                    width: '100%'
                });
                $(".ua_add_button_company").attr("disabled", false);
            }
        });
    });

    function updatestatus(id) {
        $.ajax({
            type: "POST",
            url: '<?php echo Yii::$app->request->baseUrl; ?>/salesforce/updatestatus',
            data: {id: id},
            success: function (response) {
                swal("Status changes successfully.");
            }
        });
    }

    function jsSaveProspectorSettings() {
//        $("#form_ls").validate({
//            ignore: [],
//            rules: {
//                'selContactProperty': "required",
//                'selContactFormat': "required",
//                'selCompanyProperty': "required",
//                'selCompanyFormat': "required",
//            },
//            messages: {
//                'selContactProperty': "select field",
//                'selContactFormat': "select field",
//                'selCompanyProperty': "select field",
//                'selCompanyFormat': "select field",
//            },
//            errorPlacement: function (error, element) {
//                error.insertAfter(element);
//            },
//            submitHandler: function (form) {
//                alert("Zxczcxzcxzcz");
//            }
//        });

        var form_ls = $('#form_ls')[0];
        var form_data = new FormData(form_ls);

        $.ajax({
            url: '<?php echo Yii::$app->request->baseUrl; ?>/salesforce/addfield',
            type: 'post',
            data: form_data,
            processData: false,
            contentType: false,
            cache: false,
            dataType: 'json',
            success: function () {
                location.reload();
            }
        });
        return false;
    }
//    $(document).ready(function () {
//        $(".select2").select2({
//            dropdownAutoWidth: true,
//            placeholder: "Type or insert",
//            width: '100%'
//        });
//        $(document).on("change", "#OjectSelectBox", function (event) {
//            var objectName = $(this).val();
//            $.ajax({
//                type: "POST",
//                url: "<?php echo Yii::$app->request->baseUrl; ?>/salesforce/getobjectfield",
//                data: {'objectName': objectName},
//                success: function (response) {
//
//                }
//            });
//
//        });
//    });

    if (location.protocol != "https:") {
        document.write("OAuth will not work correctly from plain http. Please use an https URL.");
    }

    function openSalesforceLogin() {
       <?php $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "https") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]"; ?>
        
        
        var winref = window.open('https://app.linkedfusion.io/api/salesforce/oauth.php?user_id_salesforce=<?php echo Yii::$app->session->get('userid'); ?>&base_url=<?php echo $actual_link; ?>', 'newwindow', 'width=500, height=500');        
    }
</script>
