<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Integration | Pipedrive';
if (!empty($keyDetail)) {
    $keyDetail = json_decode($keyDetail['access_key']);
}
?>
<section id="basic-horizontal-layouts">
    <div class="row">
        <div class="col-12 p-l-r-0">
            <div class="card">
				<div>
					<?php if(Yii::$app->session->get('success_message') && Yii::$app->session->get('success_message')!=''){ ?>
					<div class="alert alert-success mb-2" role="alert"><?php echo Yii::$app->session->get('success_message'); ?></div>
					<?php 
						Yii::$app->session->remove('success_message');
					} ?>
					
					<?php if(Yii::$app->session->get('error_message') && Yii::$app->session->get('error_message')!=''){ ?>
					<div class="alert alert-danger mb-2" role="alert"><?php echo Yii::$app->session->get('error_message'); ?></div>
					<?php 
						Yii::$app->session->remove('error_message');
					} ?>
					
					
				
					<h4 class="card-title" style="padding-top: 20px;">Pipedrive Settings</h4>
					
				</div>
				<?php $form = ActiveForm::begin(); ?>
				<div class="row"> 
					<input type="hidden" name="_csrf" value="FHwzQ6FoRJ8g5eXOZSRclsjyq0w8Hfpt1ZWSKzE-iZNlS2IW6Rkm1ka1pL5VVwzsiaieLg5Qkw6ExMZBbne93Q==">
                    <input type="hidden" name="user_id" value="<?php echo Yii::$app->session->get('userid'); ?>">
					<div class="col-6 p-l-r-0">
						<fieldset class="form-group">
							<label for="pipedrive_api_key"><a target="_blank" href="https://app.pipedrive.com/auth/login">Pipedrive ApiKey</a></label>
							<input placeholder="Enter Api Key" id="pipedrive_api_key" name="pipedrive_api_key" type="text" spellcheck="false" pattern="[^' ']+" title="please dont use the white space" class=" form-control long" value="<?php
							if (isset($keyDetail->pipedrive_api_key)) {
								echo $keyDetail->pipedrive_api_key;
							} else {
								echo"";
							}
							?>" style="width:400px;">
						</fieldset>
						<div class="row"> 
							<div class="col-md-12">
								<div id="alert_message"></div>
							</div>
						</div>
					</div>
					<div class="col-6 p-l-r-0">
						<fieldset class="form-group">
							<label for="pipedrive">Create Contact Automatically On Acceptance</label>
							<select name="pipedrive" id="pipedrive" class="form-control" style="width:400px;">
								<option value="0" <?php
								if (isset($keyDetail->pipedrive) && $keyDetail->pipedrive == 0) {
									echo 'selected';
								}
								?> >OFF</option>
								<option value="1" <?php
								if (isset($keyDetail->pipedrive) && $keyDetail->pipedrive == 1) {
									echo 'selected';
								}
								?>>ON</option>
							</select>
							<span style="font-size: small;">Note:We will create a new/Update contact on Pipedrive with all the details from LinkedIn when someone accepts your request.</span>
						</fieldset>
					</div>
				</div>
				
				<div class="row">
					<div class="col-6 p-l-r-0">
						<?php if(!empty($owners)){ ?>
							<fieldset class="form-group">
								<label for="pipedriveOwnerId">Owner</label>
								<select name="pipedriveOwnerId" id="pipedriveOwnerId" class="form-control" style="width:400px;">
								<?php foreach($owners as $owner){ ?>
									<option value="<?=$owner['id']?>" <?php if (isset($keyDetail->pipedriveOwner) && !empty($keyDetail->pipedriveOwner) && $keyDetail->pipedriveOwner == $owner['id']) { echo 'selected'; } ?> ><?=$owner['name']?></option>
								<?php } ?>
								</select>
							</fieldset>
						<?php } ?>
					</div>
					<div class="col-6 p-l-r-0">
						<?php if(!empty($stages)){ ?>
							<fieldset class="form-group">
								<label for="pipedriveDefaultStage">Default Stage</label>
								<select name="pipedriveDefaultStage" id="pipedriveDefaultStage" class="form-control" style="width:400px;">
								<option value="" <?php if (isset($keyDetail->pipedriveDefaultStage) && empty($keyDetail->pipedriveDefaultStage)) { echo 'selected'; } ?>>No default stage</option>
								<?php foreach($stages as $stage){ ?>
									<option value="<?=$stage['id']?>" <?php if (isset($keyDetail->pipedriveDefaultStage) && !empty($keyDetail->pipedriveDefaultStage) && $keyDetail->pipedriveDefaultStage == $stage['id']) { echo 'selected'; } ?> ><?=$stage['name']?></option>
								<?php } ?>
								</select>
							</fieldset>
						<?php } ?>
					</div>
				</div>
				
				<div class="row"> 
					<div class="col-6 p-l-r-0">
						<fieldset class="form-group">
							<label for="pipedriveContactPrivacy">Visible To</label>
							<select name="pipedriveContactPrivacy" id="pipedriveContactPrivacy" class="form-control" style="width:400px;">
								<option value="1" <?php
								if (isset($keyDetail->pipedriveContactPrivacy) && $keyDetail->pipedriveContactPrivacy == 1) {
									echo 'selected';
								}
								?> >Owner & followers (private)</option>
								<option value="3" <?php
								if ((isset($keyDetail->pipedriveContactPrivacy) && !empty($keyDetail->pipedriveContactPrivacy) && $keyDetail->pipedriveContactPrivacy == 3) || (!isset($keyDetail->pipedriveContactPrivacy) || empty($keyDetail->pipedriveContactPrivacy))) {
									echo 'selected';
								}
								?>>Entire company (shared)</option>
							</select>
						</fieldset>
					</div>
					<?php 
							if (isset($keyDetail->pipedrive_api_key) && !empty($keyDetail->pipedrive_api_key)) { 
						?>
							<div class="col-6 p-l-r-0">
								<fieldset class="form-group">
									 <button id="disconnectPipedrive"  class="btn btn-danger"><i class="fa fa-chain-broken" aria-hidden="true"></i> Disconnect</button>
								</fieldset>
							</div>
						<?php  } ?> 
				</div>
				
				<div class="row"> 
					<div class="col-12 p-l-r-0">
							
							<?= Html::submitButton('<i class="bx bxs-save"></i> Save', ['class' => 'btn btn-primary']) ?>
					</div>
				</div>
				<?php ActiveForm::end(); ?>
				</div>
			</div>
		</div>
</section>

<script>

	//function disconnectHubspot(tval) {
$(document).ready(function () {
    $("#disconnectPipedrive").click(function (e) {
		e.preventDefault();
		swal({
          title: 'Are you sure you want to disconnect?',
          //text: "long text message here",
          type: 'error',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, disconnect it!'
        }).then((result) => {
          if (result.value) {
					$.ajax({
						url: "<?php echo Yii::$app->request->baseUrl; ?>/my-template/disconnectpipedrive",
						type: "POST",
						success: function (data) {
							console.log(data);
							if(data){
								window.location.href = "<?php echo Yii::$app->request->baseUrl; ?>/pipedrive";
							}else {
								alert("Something went wrong.");
								return false;
							}
						}
					}); 
                }
        });	

    });
});

</script>