<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Hyperise | Integration';
?>
<link rel="stylesheet" type="text/css" href="<?php echo Yii::$app->request->baseUrl; ?>/theme/css/select2.min.css<?= '?' . round(microtime(true) * 1000) ?>">

<section id="basic-horizontal-layouts">
    <div class="row">
        <div class="col-8 p-l-r-0">
            <h4>Hyperise settings</h4>
        </div>
        <?php if (isset($api_key) && !empty($api_key)) { ?>
            <div class="col-4 p-l-r-0 text-right">
                <button id="disconnectInsightly"  type="button" id="" name="" class="btn btn-danger"><i class="fa fa-chain-broken" aria-hidden="true"></i> Disconnect</button>
            </div>
        <?php } ?>
        <div class="col-12 p-l-r-0">
            <div class="card">
                <?php //if (!$loggedin) { ?>
                <div>

                    <h4 class="card-title" style="padding-top: 20px;">Api Key</h4>
                </div>
                <?php $form = ActiveForm::begin(); ?>
                <div class="row"> 
                    <div class="row"> 
                        <!--<input type="hidden" name="_csrf" value="FHwzQ6FoRJ8g5eXOZSRclsjyq0w8Hfpt1ZWSKzE-iZNlS2IW6Rkm1ka1pL5VVwzsiaieLg5Qkw6ExMZBbne93Q==">-->
                        <input type="hidden" name="<?=Yii::$app->request->csrfParam?>" value="<?=Yii::$app->request->getCsrfToken()?>" />
                        <input type="hidden" name="user_id" value="<?php echo Yii::$app->session->get('userid'); ?>">
                        <input type="hidden" name="record_id" id="record_id" value="<?php echo $id; ?>">
                        <div class="col-6 p-l-r-0">
                            <fieldset class="form-group">
                                <label for="api_key"><a target="_blank" href="https://support.hyperise.com/api">Hyperise Api Key</a></label>
                                <input placeholder="Enter Api Key" id="api_key" name="api_key" type="text" spellcheck="false" pattern="[^' ']+" title="please dont use the white space" class=" form-control long" value="<?php
                                if (isset($api_key) && !empty($api_key)) {
                                    echo $api_key;
                                }
                                ?>" style="width:400px;">
                            </fieldset>						
                            <div class="row"> 
                                <div class="col-md-12">
                                    <div id="alert_message"></div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="row"> 
                        <div class="col-12 p-l-r-0">
                            <button type="button" id="btn_save3" name="btn_save" class="btn btn-primary save"><i class="bx bxs-save"></i> Save</button>
                        </div>
                    </div>
                </div>

            </div>
            <?php ActiveForm::end(); ?>            
        </div>
    </div>
</div>
</section>
<script type="text/javascript" language="javascript">
    $(document).ready(function () {
        $("#disconnectInsightly").click(function (e) {
            e.preventDefault();
            swal({
                title: 'Are you sure you want to disconnect?',
                //text: "long text message here",
                type: 'error',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, disconnect it!'
            }).then((result) => {
                if (result.value) {
                    $.ajax({
                        url: "<?php echo Yii::$app->request->baseUrl; ?>/hyperise/disconnectinsightly",
                        type: "POST",
                        success: function (data) {
                            console.log(data);
                            if (data) {
                                window.location.href = "<?php echo Yii::$app->request->baseUrl; ?>/hyperise";
                            } else {
                                alert("Something went wrong.");
                                return false;
                            }
                        }
                    });
                }
            });
        });
    });

    $("#btn_save3").click(function () {
        $("#btn_save3").html('<i class="spinner-border spinner-border-sm"></i> Save');
        var api_key = $("#api_key").val();
        var record_id = $("#record_id").val();
        if (api_key != "") {
            $.ajax({
                type: "POST",
                url: '<?php echo Yii::$app->request->baseUrl; ?>/hyperise/saveapikey',
                data: {api_key: api_key, record_id: record_id},
                success: function (resp) {
                    var obj = JSON.parse(resp)
                    if (obj.status) {
                        console.log('here1');
                        swal(obj.message);
                        window.location.href = '<?php echo Yii::$app->request->baseUrl; ?>/hyperise';

                    } else
                    {
                        console.log('here2');
                        swal(obj.message);
                    }
                    $("#btn_save3").html('<i class="bx bxs-save"></i> Save');
                }
            });
        } else {
            swal("Pelase Enter API key");
            $("#btn_save3").html('<i class="bx bxs-save"></i> Save');
        }
    });
</script>