<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use yii\widgets\LinkPager;

/* @var $this yii\web\View */
/* @var $searchModel app\models\BlacklistSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */
//$this->params['breadcrumbs'][] = $this->title;

$this->title = 'FirstDegree';


?>
<div class="">
    <div class="blacklist-index contentmargin">
        <div class="row-fluid">
            <div class="span12" >
                <div class="grid simple contentmargin">
                        <div class="grid-title">
							 
                            <div class="row">
                                <div class="col-md-2 p-l-r-0">
                                    <div class="search-container">
                                        <form action="<?php echo Yii::$app->request->baseUrl; ?>/firstdegree" id="blacklistFilter" autocomplete="off">
											<div class="input-group blkflt">
                                                <input type="text" value="<?php if (isset($_GET['searchname'])) {echo $_GET['searchname'];} ?>" class="form-control" placeholder="Search & Hit Enter" style="width:200px;" name="searchname">
                                            </div>
                                        </form>
                                    </div>
                                </div>
								<div class="col-md-2 p-l-r-0 ml-1">
								 <button type="button" class="btn btn-info" onclick="jsDownloadProspectReport()"><i class="fa fa-download"></i> &nbsp;Export Leads</button>
								</div>
                            </div>
                        </div>

                        <div class="grid-body ">            
                            <div class="table-responsive mt-1"> 
                                <table class="table blacklistMainListBlk dataTable">                                            
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>NAME</th>
                                            <th>EMAIL</th>
                                            <th>LINKEDIN PROFILE</th>
                                            <th>LOCATION</th>
                                        </tr>
                                    </thead>
									<?php if(!empty($firstdegreedata)){ ?>
									<tbody>
											<?php $i=1; $offset = $pages->offset; foreach ($firstdegreedata as $row) {  
											$offset++; 
											
											// filters 
											if($row['locationName'] != ''){
											$locationname = str_replace('"', '', $row['locationName']);
											}else{
											$locationname = 'NA';	
											}
											
											?>
                                            <tr>
                                                <td ><?php  echo $offset; ?></td>
                                                <td title="<?php echo $row['fullName']; ?>" ><?php if(strlen($row['fullName']) < 20) { echo $row['fullName']; } else { echo substr($row['fullName'],0,20); } ?></td>
                                                <td ><?php if($row['emailID'] == ""){ echo 'NA';} else { echo $row['emailID']; } ?></td>
                                                <td ><?php if($row['url_publicIdentifier'] != '') { ?><a target ='_blank' href="https://www.linkedin.com/in/<?php echo $row['url_publicIdentifier']; ?>"><?php echo urldecode($row['url_publicIdentifier']); ?></a> <?php } else { echo 'NA'; } ?></td>
                                                <td ><?php echo $locationname; ?></td>
                                            </tr>
											<?php $i++;  } ?>
                                     
                                    </tbody>
									<?php } else { ?>
                                    <tbody>
                                            <tr>
                                                <td colspan="6" class="text-center">No results found.</td>
                                            </tr>
                                     
                                    </tbody>
									<?php } ?>

                                </table>


                        </div>
						<?php
							echo LinkPager::widget([
								'pagination' => $pages,
							]);
							?>
                 
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade custommodal in" id="myModal_export" role="dialog">
    <div class="modal-dialog">                        
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Select export range</h4>
            </div>
            <div class="modal-body" style="background-color:#f5f5f5ba;">   
				<form role="form" name="myForm" id="exportleads" action="<?php echo Yii::$app->request->baseUrl; ?>/firstdegree/exportdata">
				<div class="row">
                    <div class="col-md-6">
                       <input type="number" class="form-control" placeholder="From" onKeyPress="if(this.value.length==4 ) return false;" name="from_number" id="from_number" />
                    </div>
                    <div class="col-md-6">
                       <input type="number" class="form-control" onKeyPress="if(this.value.length==4) return false;" placeholder="Range" name="to_number" id="to_number" />
                    </div>
					<span class="ml-1 errspan danger"></span>
                </div>
                <div class="row" style="margin-top: 10px;">
                    <div class="col-md-12">
                        <button type="button" class="btn btn-info export_btn">
                            <span class="d-none d-lg-block ">Export</span>
                        </button>
                    </div>
                    
                </div>
				</form>
            </div>
        </div>
    </div>
</div>
<script>
 function jsDownloadProspectReport() {

        $('#myModal_export').modal();
    }

  $(document).on("click", ".export_btn", function () {
 
	var from_number = $("#from_number").val();
	var to_number = $("#to_number").val();
	
	if(from_number == '' ||  to_number == '')
	{
		$('.errspan').text('Please enter values.');
		return false;
	}else{
		$('.errspan').text('');
	}
	
	//alert(from_number);
	//alert(to_number);
	
	if(parseInt(from_number) >= parseInt(to_number))
	{
		$('.errspan').text('From value must be smaller than range value.');
		return false;
	}else{
		$('.errspan').text('');
	}
	
	var exp_from_number  = parseInt(from_number) + 100;
	
	if(parseInt(to_number) < (exp_from_number))
	{
		$('.errspan').text('Range must be greater than or equal to 100');
		return false;
	}else{
		$('.errspan').text('');
	}
	
	$('#exportleads').submit();
  
  });
</script>


