<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model app\models\Blacklistcompany */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Blacklist Companies', 'url' => ['index']];
$this->params['breadcrumbs'][] = $model->company_name;
?>
<div class="blacklistcompany-view">

    <h1><?= Html::encode($model->company_name) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'company_name',
           
             [
            'attribute'=>'company_url',
            'format'=>'raw',
            'value'=>Html::a($model->company_url, $model->company_url, ['target'=>'_blank']),
        ],

        ],
    ]) ?>

</div>
