<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\LinkPager;

/* @var $this yii\web\View */
/* @var $searchModel app\models\BlacklistcompanySearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Blacklist Companies';
//$this->params['breadcrumbs'][] = $this->title;
//print_r($blacklistcmp);exit;
?>
<style>
    .search-container .searchname {
        background-color: #eee ! important;
        border-radius: 0!important;
    }
    .crossbtn{
        position: absolute;
        right: 0;
        width: 35px;
        height: 100%;
        background-color: #00cfdd;
        display: flex;
        align-items: center;
        justify-content: center;
        border-top-right-radius: 5px;
        border-bottom-right-radius: 5px;
    }
    .crossbtn button i{
        color:#FFF;
        margin-top: 10px;
    }
    .blacklistCmpList tbody tr td {
        font-size: 1rem;
        letter-spacing: 0;
    }
    .blacklistCmpList tbody tr td .dropdown-item {
        text-transform: uppercase;
        display: flex;
        align-items: center;
    }
.icsv_cls input[type="file"] {
    display: none;
}
#error_table .error-msg{ color: red !important; }
#error_modal .modal-body{ overflow-y: scroll;height: 500px;overflow-x: hidden; }
.downloadFiles{
	margin: 5px 0 0 0;
	display: inline-block;
	color: grey;
	text-decoration: underline;
	font-size: 12px;
}
</style>
<?php
if (isset($_GET['sortby']) && $_GET['sortby'] != '') {
    $current_sortby = $_GET['sortby'];
} else {
    $current_sortby = 'id';
}

if (isset($_GET['sortorder']) && $_GET['sortorder'] != '') {
    $current_sortorder = $_GET['sortorder'];
} else {
    $current_sortorder = 'desc';
}
?>
<script>
    function jsMakeSortingFor(sorting_column = '') {

        var current_sortby = '<?php echo $current_sortby; ?>';
        var current_sortorder = '<?php echo $current_sortorder; ?>';

        var new_sorting_column = sorting_column;

        if (sorting_column == current_sortby) {
            if (current_sortorder == 'asc') {
                var new_sorting_order = 'desc';
            } else {
                var new_sorting_order = 'asc';
            }
        } else {
            var new_sorting_order = 'desc';
        }
        location.href = "<?php echo Yii::$app->request->baseUrl; ?>/blacklistcompany/index?sortby=" + new_sorting_column + "&sortorder=" + new_sorting_order;

    }
</script>
<div class="blacklistcompany-index">
    <?php if (empty($blacklistcmp) && empty($_GET)) { ?>
        <div class="col-md-12">
            <div class="card-content">
                <div class="card-body">
                        <!--  <img src="<?php echo Yii::$app->request->baseUrl; ?>/img/CompanyWideBlacklist.png" style="width: 50%;" alt="BlackList" class="center">-->
                    <div class="text-center p-md-4 p-sm-1 py-1 p-0">
                        <h1 class="faq-title">Company Wide BlackList</h1>
                        <p>Avoid connecting to prospects who is currently working at specified company. <br>If any company is listed here, tool will skip all those profiles who is currently working at the company</p>
                        <?= Html::a('<i class="bx bx-plus"></i> Add Company', ['create'], ['class' => 'btn btn-success mb-1', 'style' => '']) ?>
						<br/>
						<label for="import_csv" class="btn btn-info"><i class="bx bxs-cloud-upload"></i> Import CSV</label><br/>
						<a href="<?php echo Yii::$app->request->baseUrl; ?>/csv/BlacklistCompany.csv" class="downloadFiles"><i class="bx bx-download"></i> Download Sample File</a>
						
						<div class="icsv_cls">
						<input id="import_csv" name="import_csv" accept=".csv" type="file"/>
						</div>
						
						
                    </div>
					
					
					
					
                </div>
            </div>
        </div>


    <?php } else { ?>
        <div class="grid simple contentmargin">     
            <div class="grid-title">
                <div class="row">
                    <div class="col-md-3 p-l-r-0">
                        <div class="search-container">
                            <form action="<?php echo Yii::$app->request->baseUrl; ?>/blacklistcompany" autocomplete="off">
                                <div class="input-group">
                                    <input type="text" class="form-control searchname" value="<?php
                                    if (isset($_GET['searchname'])) {
                                        echo $_GET['searchname'];
                                    }
                                    ?>" placeholder="Search & Hit Enter" name="searchname">

                                    <div class="input-group-btn crossbtn">
                                        <button type="button" id="cleardata" class="btn btn-default"><i class="fa fa-remove mb-1"></i></button>
                                    </div>
                                </div>

                            </form>

                        </div>
                    </div>
					
					
					<div class="col-md-2 p-l-r-0">
						<label for="import_csv" class="btn btn-info" style="margin-left: 10px;">
						 <i class="bx bxs-cloud-upload"></i> Import CSV
						</label>
					</div>
					<div class="col-md-2 p-l-r-0 icsv_cls">
						
						<input id="import_csv" name="import_csv" accept=".csv" type="file"/>
						<a href="<?php echo Yii::$app->request->baseUrl; ?>/csv/BlacklistCompany.csv" class="downloadFiles"><i class="bx bx-download"></i> Download Sample File</a>
					</div>

                    <div class="col-md-5 p-l-r-0">
                        <?= Html::a('<i class="bx bx-plus"></i> Add company', ['create'], ['class' => 'btn btn-info float-right']) ?>
                    </div>


                </div>

            </div>
            <div class="grid-body ">
                <div class="table-responsive mt-1">  
                    <table class="table blacklistCmpList dataTable" id="blacklistCmpList">
                        <thead>
                            <tr>
                                <th onclick="jsMakeSortingFor('id')" class="<?php if($current_sortby=='id' && $current_sortorder=='desc'){ echo 'sorting_desc';}else if($current_sortby=='id' && $current_sortorder=='asc'){echo 'sorting_asc';}else{ echo 'sorting';} ?>">#</th>
                                <th onclick="jsMakeSortingFor('company_name')" class="<?php if($current_sortby=='company_name' && $current_sortorder=='desc'){ echo 'sorting_desc';}else if($current_sortby=='company_name' && $current_sortorder=='asc'){echo 'sorting_asc';}else{ echo 'sorting';} ?>">Company Name</th>
                                <th onclick="jsMakeSortingFor('company_url')" class="<?php if($current_sortby=='company_url' && $current_sortorder=='desc'){ echo 'sorting_desc';}else if($current_sortby=='company_url' && $current_sortorder=='asc'){echo 'sorting_asc';}else{ echo 'sorting';} ?>">Company Url</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody> 
                            <?php if (empty($blacklistcmp)) { ?>
                                <tr class="row_class"  style="cursor: pointer;">
                                    <td colspan="4" class="text-center">No results found.</td>
                                </tr>
                            <?php } ?>
                            <?php
                            $i = 0;
                            foreach ($blacklistcmp as $data) {
                                $start = 0;
                                $limit = 20;

                                $i = $i + 1;
                                if (isset($_GET['page'])) {
                                    $mainmdsid = $_GET['page'];
                                    $start = ($mainmdsid - 1) * $limit;
                                } else {
                                    $mainmdsid = 1;
                                }
                                $sn = $start + $i;
                                ?> 
                                <tr>
                                    <td><?php echo $sn; ?></td>
                                    <td><?php echo $data['company_name']; ?></td>
                                    <td><a target="_blank" href="<?php echo $data['company_url']; ?>"><?php echo $data['company_url']; ?></a></td>
                                    <td>
                                        <a  href="<?php echo Yii::$app->request->baseUrl; ?>/blacklistcompany/update?id=<?php echo $data['id']; ?>" class="dropdown-item">
                                            <i class="bx bx-edit-alt mr-1"></i>Edit</a>
                                    </td> 
                                </tr>
                                <?php
                            }
                            ?>
                        </tbody>

                    </table> 
                </div>  
                <?php
                echo LinkPager::widget([
                    'pagination' => $pages,
                ]);
                ?>
            </div>
        </div>
    <?php } ?>
</div>

<div class="modal fade" id="error_modal" role="dialog">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header text-left">
          <button type="button" class="close closeModal">&times;</button>
          <h4 class="modal-title">Error Messages</h4>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-12">
              <div class="simple">
                  <table id="error_table" class="table table-bordered no-more-tables" style="width:100%;">
                    <thead>
                      <tr>
                        <th>Linkedin Profile</th>
                        <th>Error Message</th>
                      </tr>
                    </thead>
                    <tbody id ="error_body"></tbody>
                  </table>
                </div>
            </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-danger closeModal">Close</button>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
    $('input[type="text"]').on('input propertychange', function () {
        var $this = $(this);
        var visible = Boolean($this.val());
        // alert(visible);
        $this.siblings('.crossbtn').toggleClass('hidden', !visible);
    }).trigger('propertychange');
    $('#cleardata').click(function (e) {
        e.preventDefault();
        //alert("clear");
        //$('.searchname').val('');
        // .trigger('propertychange').focus();
        window.location = "<?php echo Yii::$app->request->baseUrl; ?>/blacklistcompany";

    });
    $(document).ready(function () {
<?php if (isset($_GET['searchname'])) { ?>
            $('input[type="text"]').addClass("custominput");
<?php } ?>
    });

$(document).on('change', '#import_csv', function(){
  swal({
    title: "Are you sure?",
    text: "To import blacklist company",
    type: "warning",
    showCancelButton: true,
    confirmButtonClass: "btn-danger",
    confirmButtonText: "Yes"
  })
  .then(function(isConfirm){
    if(isConfirm.dismiss != 'cancel'){
      var fd = new FormData();
      var csrfToken = $('meta[name="csrf-token"]').attr("content");
      fd.append('file', $('#import_csv')[0].files[0]);
      fd.append('_csrf', csrfToken);

      $.ajax({
         url:"<?php echo Yii::$app->request->baseUrl; ?>/blacklistcompany/importcsv",
         method:"POST",
         data: fd,
         dataType:'json',
         contentType:false,
         cache:false,
         processData:false,
         success:function(jsonData)
         {
            if(jsonData.length > 0){
              $('#error_table').DataTable().clear().draw();
              $('#error_table').DataTable().destroy();

              $('#loader1').show();
              $('#error_body').html('');
              
              if ($.fn.dataTable.isDataTable('#error_table')){
                $('#error_table').DataTable().destroy();
              }
              table = $('#error_table').DataTable({
                data : jsonData,
                 "ordering": false,
                'columnDefs': [{ 
                    "targets": 1,
                    "className": "error-msg"
                }],
                columns : [
                 {  data: "link"},
                 {  data: "error"}
               ]        
              });
              $('#error_modal').modal('show');
            }else{
              swal({
                  title: "Blacklist Company Imported", 
                  text: "CSV file uploaded successfully", 
                  type: "success"
              }).then(function(){
                  location.reload();
              });
            }
        }
      });
    }else{
      location.reload();
    }
  });
});

$(document).on('click', '.closeModal', function(){
  $('#error_modal').modal('hide');
  location.reload();
});
</script>
