<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\widgets\Pjax;

/* @var $this yii\web\View */
/* @var $model app\models\Blacklist */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="blacklist-form">
    <?php Pjax::begin(['id' => 'new_country']) ?>
    <?php $form = ActiveForm::begin(['options' => ['data-pjax' => true]]); ?>

    <?= $form->field($model, 'url_publicIdentifier')->textInput(['maxlength' => true, 'placeholder' => 'Ex. https://www.linkedin.com/in/a5411058', 'id' => 'url_publicIdentifier']) ?>


    <?= $form->field($model, 'type')->dropDownList([1 => '1', 2 => '2',], ['prompt' => ''])->hiddenInput(['value' => 2])->label(false); ?>

    <?= $form->field($model, 'seq_name')->textarea(['rows' => '6', 'placeholder' => 'Description'])->label('Description'); ?>	

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success', 'id' => 'customsaveblacklist']) ?>
    </div>

    <?php ActiveForm::end(); ?>

    <?php Pjax::end() ?>

</div> 

<script>
    $(document).ready(function () {
		
		$("#customsaveblacklist").click( function(){
			 $('#customsaveblacklist').addClass("disabled");
		});
		
        $("#url_publicIdentifier").change(function () {
            var url = $(this).val();
            if (url.indexOf("linkedin") != -1) {

                if (url.indexOf("/sales/people") != -1) {
                    swal("Please enter valid public id from non-sales navigator profile", "", "error");
                    $("#url_publicIdentifier").val("");
                    $('#customsaveblacklist').addClass("disabled");
                } else if (url.indexOf("/company") != -1) {
                    swal("Enter valid Profile LinkedIn Public Id, use Company blacklist to blacklist the whole company", "", "error");
                    $("#url_publicIdentifier").val("");
                    $('#customsaveblacklist').addClass("disabled");
                } else {
                    $('#customsaveblacklist').removeClass("disabled");
                    swal("You have entered full profile url, we have replace it with valid LinkedIn Public Id", "", "info");
                    $("#url_publicIdentifier").val(url.split("/")[4]);
                }

            } else {
                swal("Invalid LinkedIn Public Id", "", "error");
                $("#url_publicIdentifier").val("");
                $('#customsaveblacklist').addClass("disabled");
            }
				
        });
    });
    $(document).ready(function (e) {
		
		e.preventDefault();//to prevent double click;

        $("#w0").validate({
            rules: {
                'Blacklist[url_publicIdentifier]': "required",
                'Blacklist[seq_name]': "required",
            },
            messages: {
                'Blacklist[url_publicIdentifier]': "Linkedin public ID cannot be blank.",
                'Blacklist[seq_name]': "Description cannot be blank.",
            },
            errorPlacement: function (error, element) {
                error.insertAfter(element);
            },
            submitHandler: function (form) {
                var csrfToken = $('meta[name="csrf-token"]').attr("content");


                $.ajax({
                    type: "POST",
                    url: "<?php echo Yii::$app->request->baseUrl; ?>/blacklist/checkpublicidentifier",
                    data: {'url_publicIdentifier': $('#url_publicIdentifier').val(), _csrf: csrfToken},
                    success: function (data) {
                        if (data == 0) {
                            form.submit();
                        } else {
							$('#customsaveblacklist').removeClass("disabled");
                            swal("This profile is already exist", "", "error");
                        }
                    }
                });
            }
        });
    });
</script>