<?php

/*
 * This file is part of the Dektrium project.
 *
 * (c) Dektrium project <http://github.com/dektrium>
 *
 * For the full copyright and license information, please view the LICENSE.md
 * file that was distributed with this source code.
 */

use dektrium\user\widgets\Connect;
use dektrium\user\models\LoginForm;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/**
 * @var yii\web\View $this
 * @var dektrium\user\models\LoginForm $model
 * @var dektrium\user\Module $module
 */
$portal_id = \Yii::$app->params['portal_id'];
$sitetitle = \Yii::$app->params['sitetitle'];
$loginpagtitl = 'Login | Sign In To '.$sitetitle;
if($portal_id == 5){
$this->title = Yii::t('user', 'Kennected Login | Sign In To Kennected'); 
} else{
$this->title = Yii::t('user', $loginpagtitl);  
}
//$this->params['breadcrumbs'][] = $this->title;
?>

<?= $this->render('/_alert', ['module' => Yii::$app->getModule('user')]) ?>
<style type="text/css">
#login-form{
	margin-bottom: 20px;
}
.app-content.content{
    margin-left: 0!important;
}
.loginConfim p a{
	font-size: 12px;
}
.loginConfim p{
	padding: 0;  
    margin: 0;
}
.loginMainBlk .card-body{
	padding-bottom: 0;
}
.field-login-form-rememberme label{ 
	text-transform: inherit;
	font-weight: 400;
}
.field-login-form-password label a{
	text-transform: inherit;
	font-weight: 400;
}
.breadcrumb{
	
    border-radius: 0!important;
	padding:0px !important;
}
.breadcrumb li{
	padding: 10px;
	color:#FFF!important;
}
.breadcrumb li a{
	color:#FFF!important;
}
.breadcrumb li.active {
    font-weight: 600;
}
.clsCustomCntr li{
	text-align:center;
	width:100%;
}
html body.blank-page .content-wrapper .flexbox-container{
	height: auto!important;
}
</style>
<!-- BEGIN: Content-->
<?php
$sitelogo = \Yii::$app->params['sitelogo'];
$sitetitle = \Yii::$app->params['sitetitle'];
?>

	<?php if(Yii::$app->params['portal_url'] == 'https://app.leadscout.io'){ ?>
	<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-WQK2PQ3"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
	<?php } ?>

<ul class="breadcrumb clsCustomCntr">
<li><?php if($sitelogo==''){ echo '<span class="logoGuest" style="font-size: 18px;font-weight: bold;">'.$sitetitle.'</span>'; }else{  ?><img src="<?php echo $sitelogo; ?>" width="auto" height="50"> <?php } ?> </li>
</ul>
<div class="app-content content loginMainBlk">
<meta name="google-signin-scope" content="profile email">
    <meta name="google-signin-client_id" content="1040531612480-8s2e9osto4qtuns2ub6qg6dm1d39krjd.apps.googleusercontent.com">
    <script src="https://apis.google.com/js/platform.js" async defer></script>
	<div class="content-overlay"></div>
	<div class="content-wrapper">
		<div class="content-header row">
		</div>
		<div class="content-body">
			<!-- login page start -->
			<section id="auth-login" class="row flexbox-container">
				<div class="col-xl-8 col-11">
					<div class="card bg-authentication mb-0">
						<?php if(isset($_REQUEST['msg']) && $_REQUEST['msg'] == 1){ ?>
						<div class="row mt-1" style="text-align: center;">
							<div class="col-md-12">
								<span class="primary" style="font-size: 12px;">Thank you, registration is now complete. Please login to start using.</span>
							</div>
						</div>
						<?php } ?>
						<?php if(isset($_REQUEST['msg']) && $_REQUEST['msg'] == 0){ ?>
						<div class="row mt-1" style="text-align: center;">
							<div class="col-md-12">
								<span style="font-size: 12px;color: red;">Something went wrong. Please contact support.</span>
							</div>
						</div>
						<?php } ?>
						
						<div class="row m-0">
							<!-- left section-login -->
							<div class="col-md-6 col-12 px-0">
								<div class="card disable-rounded-right mb-0 p-2 h-100 d-flex justify-content-center">
									<div class="card-header pb-1">
										<div class="card-title">
											<h4 class="text-center" style="margin: 0;">Welcome Back</h4>
											<?php if(isset($_REQUEST['msg']) && $_REQUEST['msg'] == 0){ ?>
											.//<span style="font-size: 12px;color: red;" >Something went wrong. Please contact support.</span>
											<?php } ?>
											<?php if(isset($_REQUEST['msg']) && $_REQUEST['msg'] == 1){ ?>
											<!--<span style="font-size: 12px;color: green;" >Verification successfully completed.</span>-->
											<?php } ?>
										</div>
										
										<?php if(Yii::$app->session->get('success_message') && Yii::$app->session->get('success_message')!=''){ ?>
										<div class="alert alert-success mb-2" role="alert"><?php echo Yii::$app->session->get('success_message'); ?></div>
										<?php 
											Yii::$app->session->remove('success_message');
										} ?>
										
									</div>
									<div class="card-content">
										<div class="card-body">
											
											<!--div class="divider">
												<div class="divider-text text-uppercase text-muted"><small>or login with
														email</small>
												</div>
											</div-->

											<div class="signinBlk">
												<?php $form = ActiveForm::begin([
													'id' => 'login-form',
													'enableAjaxValidation' => true,
													'enableClientValidation' => false,
													'validateOnBlur' => false,
													'validateOnType' => false,
													'validateOnChange' => false,
												]) ?>

												<?php if ($module->debug): ?>
													<?= $form->field($model, 'login', [
														'inputOptions' => [
															'autofocus' => 'autofocus',
															'class' => 'form-control',
															'tabindex' => '1']])->dropDownList(LoginForm::loginList());
													?>

												<?php else: ?>

												<?= $form->field($model, 'login',
													['inputOptions' => ['autofocus' => 'autofocus', 'class' => 'form-control', 'tabindex' => '1']]
												);
												?>

													<?php endif ?>

													<?php if ($module->debug): ?>
														<div class="alert alert-warning">
															<?= Yii::t('user', 'Password is not necessary because the module is in DEBUG mode.'); ?>
														</div>
													<?php else: ?>
														<?= $form->field(
															$model,
															'password',
															['inputOptions' => ['class' => 'form-control', 'tabindex' => '2']])
															->passwordInput()
															->label(
																Yii::t('user', 'Password')
																. ($module->enablePasswordRecovery ?
																	' (' . Html::a(
																		Yii::t('user', 'Forgot password?'),
																		['/user/recovery/request'],
																		['tabindex' => '5']
																	)
																	. ')' : '')
															) ?>
													<?php endif ?>


<?php
$flag_pd=0;
$portal_id = 0;
$loginPageImgUrl='';
$getPortalQry = Yii::$app->db->createCommand("SELECT * FROM `portals` WHERE `portal_url` LIKE '%" . $_SERVER['HTTP_HOST'] . "%'  LIMIT 1")->queryOne();
if(!empty($getPortalQry)){
	$portal_id = $getPortalQry['id'];
	$loginPageImgUrl=$getPortalQry['loginPageImgUrl'];
}else{
	$getPortalQry = Yii::$app->db->createCommand("SELECT * FROM `portals` WHERE `portal_url` LIKE '%app.linkedfusion.io%'  LIMIT 1")->queryOne();
	if(count($getPortalQry) > 0){
		$portal_id = $getPortalQry['id'];
		$loginPageImgUrl=$getPortalQry['loginPageImgUrl'];
	}
}
?>										
										
										<?= $form->field($model, 'portal_id')->hiddenInput(['value'=> $portal_id])->label(false);?>													
													
													<?= $form->field($model, 'rememberMe')->checkbox(['tabindex' => '3']) ?>
													<?php if($_SERVER['HTTP_HOST']=='app.linkedfusion.io'){ ?><div class="g-recaptcha" data-sitekey="0x4AAAAAAAOEsC9thlQTxqI8"></div>
													<input type="hidden" name="g-recaptcha-response" id="g-recaptcha-response" value=""> <br> <?php }else{ ?>
													<div class="g-recaptcha" data-sitekey=""></div>
													<input type="hidden" name="g-recaptcha-response" id="g-recaptcha-response" value="bypass"> <br>   
													<?php } ?> 
													<?= Html::submitButton(
														Yii::t('user', 'Login'),
														['class' => 'btn btn-primary glow w-100 position-relative', 'tabindex' => '4']
													) ?>

													<?php ActiveForm::end(); ?>
													
													<!--<div class="form-group">
														<div class="g-signin2" data-onsuccess="onSignIn"></div>
													</div> 
													<script type="text/javascript">
														function onSignIn(googleUser) {
														var profile = googleUser.getBasicProfile();
														console.log('ID: ' + profile.getId()); // Do not send to your backend! Use an ID token instead.
														console.log('Name: ' + profile.getName());
														console.log('Image URL: ' + profile.getImageUrl());
														console.log('Email: ' + profile.getEmail()); // This is null if the 'email' scope is not present.

														console.log('First Name: ' + profile.getGivenName());
															console.log('Last Name: ' + profile.getFamilyName());

														/*$("#email").val(profile.getEmail());
														$("#password_hash").val(profile.getId());
														$('#insert').trigger('click');*/
														var loginData = {username:profile.getEmail(), password:profile.getId(),first_name: profile.getGivenName(),last_name: profile.getFamilyName()};
														/* loginData['username'] = profile.getEmail();
														loginData['password'] = profile.getId();*/

														 var auth2 = gapi.auth2.getAuthInstance();
														auth2.signOut().then(function () {
														  console.log('User signed out.');
														});
														window.location = window.location.href+"?loginData="+btoa(JSON.stringify(loginData));
														}
													</script>
													-->
						
												</div>

											<hr>
											<div class="text-center">
												<div class="loginConfim">
													<?php if ($module->enableConfirmation): ?>
														<p class="text-center">
															<?= Html::a(Yii::t('user', 'Didn\'t receive confirmation message?'), ['/user/registration/resend']) ?>
														</p>
													<?php endif ?>
													<?php if ($module->enableRegistration): ?>
														<p class="text-center">
															<?= Html::a(Yii::t('user', 'Don\'t have an account Yet? Sign up Now!'), ['/user/registration/register']) ?>
														</p>
													<?php endif ?>
													<?= Connect::widget([
														'baseAuthUrl' => ['/user/security/auth'],
													]) ?>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							<!-- right section image -->
							<div class="col-md-6 d-md-block d-none text-center align-self-center p-3">
								<div class="card-content">
									<img class="img-fluid" src="<?php echo $loginPageImgUrl; ?>" alt="branding logo">
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
			<!-- login page ends -->

		</div>
	</div>
</div>
<!-- END: Content-->

<script>

$( document ).ready(function() {
	

$("#login-form-password").keypress( function(){
	
	if($('#login-form-password').val() != ''){
		$('.show_pwd').show();
	}
	
	
});

$( "#login-form-password" ).after('<i class="bx bx-show show_pwd" style="float: right; display: none; margin: -26px 5px 0px 0px;padding: 0;"></i><i class="bx bx-hide hide_pwd" style="float: right; display: none; margin: -26px 5px 0px 0px;padding: 0;"></i>' );


$('.show_pwd').click( function(){
    $("#login-form-password").attr('type','text');
	$(this).hide();
	$('.hide_pwd').show();
}); 

$('.hide_pwd').click( function(){
    $("#login-form-password").attr('type','password');
	$(this).hide();
	$('.show_pwd').show();
});

});
$(function() {
  $('body').addClass('horizontal-layout navbar-sticky 1-column footer-static bg-full-screen-image blank-page blank-page pace-done menu-hide vertical-layout vertical-overlay-menu fixed-navbar');
});
</script>
<script src="https://challenges.cloudflare.com/turnstile/v0/api.js?onload=onloadTurnstileCallback" async defer></script>
<script src="https://challenges.cloudflare.com/turnstile/v0/api.js"></script>
<script type="text/javascript">
	<?php if($_SERVER['HTTP_HOST']=='app.linkedfusion.io'){ ?>
		window.onloadTurnstileCallback = function () {
		turnstile.render('.g-recaptcha', {
			sitekey: '0x4AAAAAAAOEsC9thlQTxqI8',
			callback: function(token) { 
				$('#g-recaptcha-response').val(token); 
				console.log(`Challenge Success ${token}`);
			}, 
		});
	<?php } ?>
};

// if using synchronous loading, will be called once the DOM is ready
turnstile.ready(onloadTurnstileCallback);
</script>

