<?php

/*
 * This file is part of the Dektrium project.
 *
 * (c) Dektrium project <http://github.com/dektrium>
 *
 * For the full copyright and license information, please view the LICENSE.md
 * file that was distributed with this source code.
 */

use dektrium\user\widgets\Connect;
use dektrium\user\models\LoginForm;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/**
 * @var yii\web\View $this
 * @var dektrium\user\models\LoginForm $model
 * @var dektrium\user\Module $module
 */
$cloudfront="https://d1kzoyopflesfg.cloudfront.net";

$this->title = Yii::t('user', 'Sign in');
$this->params['breadcrumbs'][] = $this->title;
?>

<?= $this->render('/_alert', ['module' => Yii::$app->getModule('user')]) ?>
<meta name="google-signin-scope" content="profile email">
<meta name="google-signin-client_id" content="1040531612480-8s2e9osto4qtuns2ub6qg6dm1d39krjd.apps.googleusercontent.com">
<script src="https://apis.google.com/js/platform.js" async defer></script>


<style type="text/css">
    .breadcrumb{
        margin:0px ! important;
        display: none;
    }
  .bracketdiv {
    border: solid thin;
    border-color: #5BC6F8;
    margin-top: 6%;
    background-color: #f2f2f2;
    border-radius: 10px;
}
@media (min-width: 1281px) {
  .bracketdiv {
    border: solid thin;
    border-color: #5BC6F8;
    margin-top: 6%;
    background-color: #f2f2f2;
    border-radius: 10px;
    position: fixed;
    top: 45%;
    left: 50%;
    width: 55em;
    height: auto;
    margin-top: -16em;
    margin-left: -29em;
    border: 1px solid #ccc;
    background-color: #f3f3f3;
}
}
.contentborderright {
    border-color: #dddddd ! important;
 
}
input[type="text"] {
    font-family: "roboto";
    -webkit-appearance: none !important;
    color: #282323;
    outline: 0;
    height: 16px;
    padding: 6px 11px !important;
    line-height: 15px;
    font-size: 13px;
    font-weight: normal;
    vertical-align: top;
    background-color: #ffffff ! important;
    min-height: 37px;
    -webkit-box-shadow: none !important;
    -moz-box-shadow: none !important;
    box-shadow: none !important;
    -webkit-border-radius: 0px;
    -moz-border-radius: 0px;
    border-radius: 0px;
    -webkit-border-radius: 2px;
    -moz-border-radius: 2px;
    border-radius: 2px;
    border: 1px solid #e5e9ec;
    transition: background 0.2s linear 0s, box-shadow 0.2s linear 0s;
}
.tip,.control-label,.field-login-form-rememberme label{
    color: #505458;
}

.tooltip {
    position: absolute;
    z-index: 1070;
    display: block;
    font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
    font-size: 12px;
    font-style: normal;
    font-weight: 400;
    line-height: 1.42857143;
    text-align: left;
    text-align: start;
    text-decoration: none;
    text-shadow: none;
    text-transform: none;
    letter-spacing: normal;
    word-break: normal;
    word-spacing: normal;
    word-wrap: normal;
    white-space: normal;
    filter: alpha(opacity=0);
    opacity: 0;
    line-break: auto
}

.tooltip.in {
    filter: alpha(opacity=90);
    opacity: .9
}

.tooltip.top {
    padding: 5px 0;
    margin-top: -3px
}

.tooltip.right {
    padding: 0 5px;
    margin-left: 3px
}

.tooltip.bottom {
    padding: 5px 0;
    margin-top: 3px
}

.tooltip.left {
    padding: 0 5px;
    margin-left: -3px
}

.tooltip-inner {
    max-width: 200px;
    padding: 3px 8px;
    color: #fff;
    text-align: center;
    background-color: #000;
    border-radius: 4px
}

.tooltip-arrow {
    position: absolute;
    width: 0;
    height: 0;
    border-color: transparent;
    border-style: solid
}

.tooltip.top .tooltip-arrow {
    bottom: 0;
    left: 50%;
    margin-left: -5px;
    border-width: 5px 5px 0;
    border-top-color: #000
}

.tooltip.top-left .tooltip-arrow {
    right: 5px;
    bottom: 0;
    margin-bottom: -5px;
    border-width: 5px 5px 0;
    border-top-color: #000
}

.tooltip.top-right .tooltip-arrow {
    bottom: 0;
    left: 5px;
    margin-bottom: -5px;
    border-width: 5px 5px 0;
    border-top-color: #000
}

.tooltip.right .tooltip-arrow {
    top: 50%;
    left: 0;
    margin-top: -5px;
    border-width: 5px 5px 5px 0;
    border-right-color: #000
}

.tooltip.left .tooltip-arrow {
    top: 50%;
    right: 0;
    margin-top: -5px;
    border-width: 5px 0 5px 5px;
    border-left-color: #000
}

.tooltip.bottom .tooltip-arrow {
    top: 0;
    left: 50%;
    margin-left: -5px;
    border-width: 0 5px 5px;
    border-bottom-color: #000
}

.tooltip.bottom-left .tooltip-arrow {
    top: 0;
    right: 5px;
    margin-top: -5px;
    border-width: 0 5px 5px;
    border-bottom-color: #000
}

.tooltip.bottom-right .tooltip-arrow {
    top: 0;
    left: 5px;
    margin-top: -5px;
    border-width: 0 5px 5px;
    border-bottom-color: #000
}

.popover {
    position: absolute;
    top: 0;
    left: 0;
    z-index: 1060;
    display: none;
    max-width: 276px;
    padding: 1px;
    font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
    font-size: 14px;
    font-style: normal;
    font-weight: 400;
    line-height: 1.42857143;
    text-align: left;
    text-align: start;
    text-decoration: none;
    text-shadow: none;
    text-transform: none;
    letter-spacing: normal;
    word-break: normal;
    word-spacing: normal;
    word-wrap: normal;
    white-space: normal;
    background-color: #fff;
    -webkit-background-clip: padding-box;
    background-clip: padding-box;
    border: 1px solid #ccc;
    border: 1px solid rgba(0, 0, 0, .2);
    border-radius: 6px;
    -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, .2);
    box-shadow: 0 5px 10px rgba(0, 0, 0, .2);
    line-break: auto
}

.popover.top {
    margin-top: -10px
}

.popover.right {
    margin-left: 10px
}

.popover.bottom {
    margin-top: 10px
}

.popover.left {
    margin-left: -10px
}

.popover-title {
    padding: 8px 14px;
    margin: 0;
    font-size: 14px;
    background-color: #f7f7f7;
    border-bottom: 1px solid #ebebeb;
    border-radius: 5px 5px 0 0
}

.popover-content {
    padding: 9px 14px
}

.popover>.arrow,
.popover>.arrow:after {
    position: absolute;
    display: block;
    width: 0;
    height: 0;
    border-color: transparent;
    border-style: solid
}

.popover>.arrow {
    border-width: 11px
}

.popover>.arrow:after {
    content: "";
    border-width: 10px
}

.popover.top>.arrow {
    bottom: -11px;
    left: 50%;
    margin-left: -11px;
    border-top-color: #999;
    border-top-color: rgba(0, 0, 0, .25);
    border-bottom-width: 0
}

.popover.top>.arrow:after {
    bottom: 1px;
    margin-left: -10px;
    content: " ";
    border-top-color: #fff;
    border-bottom-width: 0
}

.popover.right>.arrow {
    top: 50%;
    left: -11px;
    margin-top: -11px;
    border-right-color: #999;
    border-right-color: rgba(0, 0, 0, .25);
    border-left-width: 0
}

.popover.right>.arrow:after {
    bottom: -10px;
    left: 1px;
    content: " ";
    border-right-color: #fff;
    border-left-width: 0
}

.popover.bottom>.arrow {
    top: -11px;
    left: 50%;
    margin-left: -11px;
    border-top-width: 0;
    border-bottom-color: #999;
    border-bottom-color: rgba(0, 0, 0, .25)
}

.popover.bottom>.arrow:after {
    top: 1px;
    margin-left: -10px;
    content: " ";
    border-top-width: 0;
    border-bottom-color: #fff
}

.popover.left>.arrow {
    top: 50%;
    right: -11px;
    margin-top: -11px;
    border-right-width: 0;
    border-left-color: #999;
    border-left-color: rgba(0, 0, 0, .25)
}

.popover.left>.arrow:after {
    right: 1px;
    bottom: -10px;
    content: " ";
    border-right-width: 0;
    border-left-color: #fff
}
.field-icon {
    float: right;
    margin-top: -26px;
    position: relative;
    z-index: 2;
    padding-right: 10px;
}
span{
    font-size: 14px;
}
.contentborderright h3{
    text-align: center;
    margin-top: 25px;
}
span, label, input, button, select, textarea, a,h3 {
    color: #5f6368;
}
.control-label,.tip, .control-label, .field-login-form-rememberme label{
    font-weight: 600;
}
@media (min-width: 481px) and (max-width: 1024px) {
      .contentborderright {
        display: none ! important;
    }
    .customlogo{
            margin-bottom: 0%;
    }
  
}

/* 
  ##Device = Most of the Smartphones Mobiles (Portrait)
  ##Screen = B/w 320px to 479px
*/

@media (min-width: 320px) and (max-width: 480px) {
  
 .contentborderright {
        display: none ! important;
    }
    .customlogo{
            margin-bottom: -3%;
    }
  
}
.contentborderright1{
margin-top: 30px;
}
.customlogo{
    text-align: center;
}
.customlink{
color: #00507e;
text-decoration: underline;
font-weight: 100;
}

</style>
<body class="error-body no-top lazy"  data-original="<?php echo $cloudfront;?>/work.jpg"  style="background-image: url('<?php echo $cloudfront;?>/work.jpg')"> 

<div class="row">
    <meta name="google-signin-scope" content="profile email">
    <meta name="google-signin-client_id" content="1040531612480-8s2e9osto4qtuns2ub6qg6dm1d39krjd.apps.googleusercontent.com">
    <script src="https://apis.google.com/js/platform.js" async defer></script>
    <div class="col-md-8 col-md-offset-2 col-sm-6 col-sm-offset-3 bracketdiv">
        <div class="panel panel-default contentmargin">
           <!--  <div class="panel-heading">
                <h3 class="panel-title"><?= Html::encode($this->title) ?></h3>
            </div> -->
            
            <div class="col-md-7 contentborderright1">
                    <h3 class="text-transform-upr font-size-17 customlogo">Sign in to&nbsp;<a href="<?php echo Yii::$app->request->baseUrl; ?>//user/security/login" class="custom-logo-link  no-t-logo" rel="home" itemprop="url"><img width="240" height="44" src="https://d1kzoyopflesfg.cloudfront.net/wp-content/uploads/2018/07/13115904/cropped-logo_header4.png" class="custom-logo" alt="LeadConnect" itemprop="logo"></a><span class="opacity-80"></span></h3>
                    <br>
                   
                     <div class="col-md-2 contentborderright"><br>
                         <img alt="integrate-with-hubspot-crm" src="https://d1kzoyopflesfg.cloudfront.net/autonew.png" class="center-block img-responsive">
                    </div>
                    <div class="col-md-10 contentborderright">
                                <br>
                              <span class="">Setup personalized automated messages for a connection request, create a follow-up message to be sent a few hours or days after connecting, set another set of automated follow-up messages if there is no response in a few days.</span>                        
                    </div>
                    <div class="col-md-2 contentborderright"><br>
                        <img alt="integrate-with-hubspot-crm" src="https://d1kzoyopflesfg.cloudfront.net/wp-content/uploads/2018/07/11114609/hubspot-sprocket-logo.png" class="center-block img-responsive">
                    </div>
                    <div class="col-md-10 contentborderright"><br>
                        
                              <span class="">Sync all the activity to Hubspot with a single Click. <a class="customlink" href="https://www.youtube.com/watch?v=8u55P3yBVXQ" target="_blank">Learn How ?</a></span>                        
                    </div>

                    <div class="divider"></div>
                   
                </div>
            <!-- -->
            <div class="panel-body col-md-5">
                <a class="contentborderright text-center" href="https://chrome.google.com/webstore/detail/lead-connect-automate-lin/jdcjfphdohecknoaelnngakpignnedfb" target="_blank">
                    <img style="margin: 0 auto;" src="https://d1kzoyopflesfg.cloudfront.net/wp-content/uploads/2018/11/15064102/ChromeWebStore_Badge_v2_496x150.png" width="270px" height="auto" alt="Chrome Web Store"></a>
                    <hr>
                <?php $form = ActiveForm::begin([
                    'id' => 'login-form',
                    'enableAjaxValidation' => true,
                    'enableClientValidation' => false,
                    'validateOnBlur' => false,
                    'validateOnType' => false,
                    'validateOnChange' => false,
                ]) ?>

                <?php if ($module->debug): ?>
                    <?= $form->field($model, 'login', [
                        'inputOptions' => [
                            'autofocus' => 'autofocus',
                            'class' => 'form-control',
                            'tabindex' => '1']])->dropDownList(LoginForm::loginList());
                    ?>

                <?php else: ?>

                    <?= $form->field($model, 'login',
                        ['inputOptions' => ['autofocus' => 'autofocus', 'class' => 'form-control','tabindex' => '1']]
                    );
                    ?>

                <?php endif ?>

                <?php if ($module->debug): ?>
                    <div class="alert alert-warning">
                        <?= Yii::t('user', 'Password is not necessary because the module is in DEBUG mode.'); ?>
                    </div>
                <?php else: ?>
                    <?= $form->field(
                        $model,
                        'password',[
                         'template' => '<div class=\"\"><label class="control-label" for="login-form-password">Password <a href="'. Yii::$app->request->baseUrl.'/user/forgot" tabindex="5" class="customlink">( Forgot password ? )</a></label>{input}<i  toggle="#password-field"  class="fa fa-eye-slash toggle-password field-icon "></i></div><div class=\"\">{error}</div>',
                   
                        'inputOptions' => ['class' => 'form-control','data-toggle'=>"tooltip","title"=>"<i class='fa fa-exclamation-triangle' aria-hidden='true'></i>&nbsp;&nbsp;<b>Caps lock is on</b>",'data-html'=>"true","data-placement"=>"left",'tabindex' => '2',"data-trigger"=>"manual"]])
                        ->passwordInput()
                       ?>
                <?php endif ?>
                <?= $form->field($model, 'rememberMe')->checkbox(['tabindex' => '3']) ?>

                <?= Html::submitButton(
                    Yii::t('user', 'Sign in'),
                    ['class' => 'btn btn-primary btn-lg', 'tabindex' => '4']
                ) ?>

                <?php ActiveForm::end(); ?>
 
               <div class="form-group" style="margin-left: 73px; margin-top: -37px;">
                    <div class="g-signin2" data-onsuccess="onSignIn"></div>
               </div>
               <script type="text/javascript">
                    function onSignIn(googleUser) {
                          var profile = googleUser.getBasicProfile();
                          console.log('ID: ' + profile.getId()); // Do not send to your backend! Use an ID token instead.
                          console.log('Name: ' + profile.getName());
                          console.log('Image URL: ' + profile.getImageUrl());
                          console.log('Email: ' + profile.getEmail()); // This is null if the 'email' scope is not present.

                            console.log('First Name: ' + profile.getGivenName());
                                console.log('Last Name: ' + profile.getFamilyName());

                          /*$("#email").val(profile.getEmail());
                          $("#password_hash").val(profile.getId());
                          $('#insert').trigger('click');*/
                          var loginData = {username:profile.getEmail(), password:profile.getId(),first_name: profile.getGivenName(),last_name: profile.getFamilyName()};
                           /* loginData['username'] = profile.getEmail();
                            loginData['password'] = profile.getId();*/

                             var auth2 = gapi.auth2.getAuthInstance();
                            auth2.signOut().then(function () {
                              console.log('User signed out.');
                            });
                          window.location = window.location.href+"?loginData="+btoa(JSON.stringify(loginData));
                        }
               </script>
            </div>
            
            <div class="panel-footer col-md-12">   
                <div>
                        <div style="margin-top:15px">   
                            <?php if ($module->enableConfirmation): ?>
                                <p class="text-center">
                                    <?= Html::a(Yii::t('user', 'Didn\'t receive confirmation message?'), ['/user/registration/resend']) ?>
                                </p>
                            <?php endif ?>
                            <?php if ($module->enableRegistration): ?>
                                <p class="text-center">
                                    <?= Html::a(Yii::t('user', 'Don\'t have an account? Sign up!'), ['/user/registration/register']) ?>
                                </p>
                            <?php endif ?>
                            <?= Connect::widget([
                                'baseAuthUrl' => ['/user/security/auth'],
                            ]) ?>
                        </div>
                 </div>
            </div>
        
        </div>
    </div>
</div>
</body>
 <script language="Javascript">
    $(document).ready(function(){
        $('[type=password]').keypress(function(e) {
          var $password = $(this),
              tooltipVisible = $('.tooltip').is(':visible'),
              s = String.fromCharCode(e.which);
          
          //Check if capslock is on. No easy way to test for this
          //Tests if letter is upper case and the shift key is NOT pressed.

          if ( s.toUpperCase() === s && s.toLowerCase() !== s && !e.shiftKey ) {
            if (!tooltipVisible)
                $password.tooltip('show');
          } else {
            if (tooltipVisible)
                $password.tooltip('hide');
          }
          
          //Hide the tooltip when moving away from the password field
          $password.blur(function(e) {
            $password.tooltip('hide');
          });
        });
            $('body').on('click', '.toggle-password', function() {
              $(this).toggleClass("fa fa-eye-slash fa fa-eye");
              var input = $("#login-form-password");
              if (input.attr("type") == "password") {
                input.attr("type", "text");
              } else {
                input.attr("type", "password");
              }
            });
    });

</script>
