<?php

/*
 * This file is part of the Dektrium project.
 *
 * (c) Dektrium project <http://github.com/dektrium>
 *
 * For the full copyright and license information, please view the LICENSE.md
 * file that was distributed with this source code.
 */

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/**
 * @var yii\web\View $this
 * @var dektrium\user\models\User $model
 * @var dektrium\user\Module $module
 */

$this->title = Yii::t('user', 'Sign up');
//$this->params['breadcrumbs'][] = $this->title;
?>
<style type="text/css">
.app-content.content{
    margin-left: 0!important;
}
.signUpPage h4{
	margin-bottom: 8px!important;
}
.signUpPage .signupblk{
	padding:0!important;
	margin:0!important;
}
.signUpPage .form-control{
	height: 35px!important;
}
.signUpPage a{
	font-size: 12px;
}
.breadcrumb{
	background-color: #5A8DEE !important;
    border-radius: 0!important;
	padding:0px !important;
}
.breadcrumb li{
	padding: 10px;
	color:#FFF!important;
}
.breadcrumb li a{
	color:#FFF!important;
}
.breadcrumb li.active {
    font-weight: 600;
}
.clsCustomCntr li{
	text-align:center;
	width:100%;
}
.help-block{
	    color: #FF5B5C !important;

}
html body.blank-page .content-wrapper .flexbox-container{
	height: auto!important;
}
</style>
<!-- BEGIN: Content-->
<?php
$sitelogo = \Yii::$app->params['sitelogo'];
$sitetitle = \Yii::$app->params['sitetitle'];
?>
<ul class="breadcrumb clsCustomCntr">
<li><?php if($sitelogo==''){ echo '<span class="logoGuest" style="font-size: 18px;font-weight: bold;">'.$sitetitle.'</span>'; }else{  ?><img src="<?php echo $sitelogo; ?>" width="auto" height="50"> <?php } ?> </li>
</ul>
<meta name="google-signin-scope" content="profile email">
<meta name="google-signin-client_id" content="1040531612480-8s2e9osto4qtuns2ub6qg6dm1d39krjd.apps.googleusercontent.com">
<script src="https://apis.google.com/js/platform.js" async defer></script>
<div class="app-content content signUpPage">
	<div class="content-overlay"></div>
	<div class="content-wrapper">
		<div class="content-header row">
		</div>
		<div class="content-body">
			<!-- register section starts -->
			<section class="row flexbox-container">
				<div class="col-xl-8 col-10">
					<div class="card bg-authentication mb-0">
						<div class="row m-0">
							<!-- register section left -->
							<div class="col-md-6 col-12 px-0">
								<div class="card disable-rounded-right mb-0 p-2 h-100 d-flex justify-content-center">
									<div class="card-header pb-1 signupblk">
										<div class="card-title">
											<h4 class="text-center mb-2"><?= Html::encode($this->title) ?></h4>
										</div>
									</div>
									<div class="text-center">
										<p> <small> Please enter your details to sign up and be part of our great community.</small>
										</p>
									</div>
									<div class="panel-body">
										<?php $form = ActiveForm::begin([
											'id' => 'registration-form',
											'enableAjaxValidation' => true,
											'enableClientValidation' => false,
										]); ?>
										<!-- new added --->				
										<?= $form->field($model, 'first_name') ?>
										<?= $form->field($model, 'last_name') ?>
										<?= $form->field($model, 'companyname') ?>
										<?= $form->field($model, 'contactphone') ?>
										<!-- ends -->
										<?= $form->field($model, 'email') ?>
										
										<?php //echo Html::hiddenInput('portal_id', 1); ?>
<?php
$flag_pd=0;
$portal_id = 0;

$getPortalQry = Yii::$app->db->createCommand("SELECT * FROM `portals` WHERE `portal_url` LIKE '%" . $_SERVER['HTTP_HOST'] . "%'  LIMIT 1")->queryOne();
if(count($getPortalQry) > 0){
	$portal_id = $getPortalQry['id'];
}else{
	$getPortalQry = Yii::$app->db->createCommand("SELECT * FROM `portals` WHERE `portal_url` LIKE '%app.linkedfusion.io%'  LIMIT 1")->queryOne();
	if(count($getPortalQry) > 0){
		$portal_id = $getPortalQry['id'];
	}
}
//$portal_id = 2;
?>										
										
										<?= $form->field($model, 'portal_id')->hiddenInput(['value'=> $portal_id])->label(false);?>

										

										<?php if ($module->enableGeneratingPassword == false): ?>
											<?= $form->field($model, 'password')->passwordInput() ?>
										<?php endif ?>
										
										<div class="form-group field-register-form-password required has-error">
										<label class="control-label" for="register-form-password">Confirm  Password</label>
										<input type="password" id="confirm_password" class="form-control" name="confirm_password" aria-required="true" aria-invalid="true">

										<div class="con-pwd-help-block " style="display:none;color:red;">The password confirmation does not match.</div>
										</div>
										
										<?= Html::submitButton(Yii::t('user', 'Sign up'), ['class' => 'btn btn-primary glow signup_btn position-relative w-100']) ?>

										<?php ActiveForm::end(); ?>
									</div>
									
									<p class="text-center">
										<?= Html::a(Yii::t('user', 'Already registered? Sign in!'), ['/user/security/login']) ?>
									</p>
<?php if($portal_id == '5'){ ?>
<p>By Creating an account you confirm that you have read and agree to our <a href="https://kennected.org/terms-of-service/" target="_blank">Terms</a></p>
<?php } else { ?>
<p>By Creating an account you confirm that you have read and agree to our <a href="https://www.linkedfusion.io/terms-of-use/" target="_blank">Terms</a></p>
<?php } ?>
									<script type="text/javascript">
									function onSignIn(googleUser) {
										var profile = googleUser.getBasicProfile();
										console.log('ID: ' + profile.getId()); // Do not send to your backend! Use an ID token instead.
										console.log('Name: ' + profile.getName());
											  console.log('First Name: ' + profile.getGivenName());
											console.log('Last Name: ' + profile.getFamilyName());
										console.log('Image URL: ' + profile.getImageUrl());
										console.log('Email: ' + profile.getEmail()); // This is null if the 'email' scope is not present.

										$("#register-form-email").val(profile.getEmail());
										$("#register-form-password").val(profile.getId());
										$("#register-form-first_name").val(profile.getGivenName());
										$("#register-form-last_name").val(profile.getFamilyName());
										$('#registration-form').trigger('submit');
									}
									</script>
								</div>
							</div>
							<!-- image section right -->
							<div class="col-md-6 d-md-block d-none text-center align-self-center p-3">
								<img class="img-fluid" src="http://d3j2mp6mc1f39j.cloudfront.net/img/register.png" alt="branding logo">
							</div>
						</div>
					</div>
				</div>
			</section>
			<!-- register section endss -->
		</div>
	</div>
</div>
<!-- END: Content-->


<script>
//$('.signup_btn').prop('disabled',true);
$( document ).ready(function() {
	
	$('#registration-form').on('submit', function() {
         
		 if($("#confirm_password").val() == $("#register-form-password").val()){
			$('.signup_btn').prop('disabled',false);
			$('.con-pwd-help-block').hide();
		}else{
			$('.signup_btn').prop('disabled',true);			
			$('.con-pwd-help-block').show();
			return false;
		}
		 
     });
    
	$('#confirm_password').on('blur change keyup', function(e) {
		
		if($(this).val() == $("#register-form-password").val()){
			$('.signup_btn').prop('disabled',false);
			$('.con-pwd-help-block').hide();
		}else{
			$('.signup_btn').prop('disabled',true);			
			$('.con-pwd-help-block').show();
			return false;
		}
	
	});
	
	
	
});
$(function() {
  $('body').addClass('horizontal-layout navbar-sticky 1-column footer-static bg-full-screen-image blank-page blank-page pace-done menu-hide vertical-layout vertical-overlay-menu fixed-navbar');
});
</script>
