<?php

/*
 * This file is part of the Dektrium project.
 *
 * (c) Dektrium project <http://github.com/dektrium>
 *
 * For the full copyright and license information, please view the LICENSE.md
 * file that was distributed with this source code.
 */

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/**
 * @var yii\web\View $this
 * @var dektrium\user\models\User $model
 * @var dektrium\user\Module $module
 */
$cloudfront="https://d1kzoyopflesfg.cloudfront.net";

$this->title = Yii::t('user', 'Sign up');
$this->params['breadcrumbs'][] = $this->title;
?>

<meta name="google-signin-scope" content="profile email">
<meta name="google-signin-client_id" content="1040531612480-8s2e9osto4qtuns2ub6qg6dm1d39krjd.apps.googleusercontent.com">
<script src="https://apis.google.com/js/platform.js" async defer></script>
<style type="text/css">
    .breadcrumb{
        margin:0px ! important;
        display: none;
    }
    .bracketdiv1 {
    border: solid thin;
    border-color: #5BC6F8;
    margin-top: 1%;
    background-color: white;
    border-radius: 10px;
}
input[type="text"] {
    font-family: "roboto";
    -webkit-appearance: none !important;
    color: #282323;
    outline: 0;
    height: 16px;
    padding: 6px 11px !important;
    line-height: 15px;
    font-size: 13px;
    font-weight: normal;
    vertical-align: top;
    background-color: #ffffff ! important;
    min-height: 37px;
    -webkit-box-shadow: none !important;
    -moz-box-shadow: none !important;
    box-shadow: none !important;
    -webkit-border-radius: 0px;
    -moz-border-radius: 0px;
    border-radius: 0px;
    -webkit-border-radius: 2px;
    -moz-border-radius: 2px;
    border-radius: 2px;
    border: 1px solid #e5e9ec;
    transition: background 0.2s linear 0s, box-shadow 0.2s linear 0s;
}

.tooltip {
    position: absolute;
    z-index: 1070;
    display: block;
    font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
    font-size: 12px;
    font-style: normal;
    font-weight: 400;
    line-height: 1.42857143;
    text-align: left;
    text-align: start;
    text-decoration: none;
    text-shadow: none;
    text-transform: none;
    letter-spacing: normal;
    word-break: normal;
    word-spacing: normal;
    word-wrap: normal;
    white-space: normal;
    filter: alpha(opacity=0);
    opacity: 0;
    line-break: auto
}

.tooltip.in {
    filter: alpha(opacity=90);
    opacity: .9
}

.tooltip.top {
    padding: 5px 0;
    margin-top: -3px
}

.tooltip.right {
    padding: 0 5px;
    margin-left: 3px
}

.tooltip.bottom {
    padding: 5px 0;
    margin-top: 3px
}

.tooltip.left {
    padding: 0 5px;
    margin-left: -3px
}

.tooltip-inner {
    max-width: 200px;
    padding: 3px 8px;
    color: #fff;
    text-align: center;
    background-color: #000;
    border-radius: 4px
}

.tooltip-arrow {
    position: absolute;
    width: 0;
    height: 0;
    border-color: transparent;
    border-style: solid
}

.tooltip.top .tooltip-arrow {
    bottom: 0;
    left: 50%;
    margin-left: -5px;
    border-width: 5px 5px 0;
    border-top-color: #000
}

.tooltip.top-left .tooltip-arrow {
    right: 5px;
    bottom: 0;
    margin-bottom: -5px;
    border-width: 5px 5px 0;
    border-top-color: #000
}

.tooltip.top-right .tooltip-arrow {
    bottom: 0;
    left: 5px;
    margin-bottom: -5px;
    border-width: 5px 5px 0;
    border-top-color: #000
}

.tooltip.right .tooltip-arrow {
    top: 50%;
    left: 0;
    margin-top: -5px;
    border-width: 5px 5px 5px 0;
    border-right-color: #000
}

.tooltip.left .tooltip-arrow {
    top: 50%;
    right: 0;
    margin-top: -5px;
    border-width: 5px 0 5px 5px;
    border-left-color: #000
}

.tooltip.bottom .tooltip-arrow {
    top: 0;
    left: 50%;
    margin-left: -5px;
    border-width: 0 5px 5px;
    border-bottom-color: #000
}

.tooltip.bottom-left .tooltip-arrow {
    top: 0;
    right: 5px;
    margin-top: -5px;
    border-width: 0 5px 5px;
    border-bottom-color: #000
}

.tooltip.bottom-right .tooltip-arrow {
    top: 0;
    left: 5px;
    margin-top: -5px;
    border-width: 0 5px 5px;
    border-bottom-color: #000
}

.popover {
    position: absolute;
    top: 0;
    left: 0;
    z-index: 1060;
    display: none;
    max-width: 276px;
    padding: 1px;
    font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
    font-size: 14px;
    font-style: normal;
    font-weight: 400;
    line-height: 1.42857143;
    text-align: left;
    text-align: start;
    text-decoration: none;
    text-shadow: none;
    text-transform: none;
    letter-spacing: normal;
    word-break: normal;
    word-spacing: normal;
    word-wrap: normal;
    white-space: normal;
    background-color: #fff;
    -webkit-background-clip: padding-box;
    background-clip: padding-box;
    border: 1px solid #ccc;
    border: 1px solid rgba(0, 0, 0, .2);
    border-radius: 6px;
    -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, .2);
    box-shadow: 0 5px 10px rgba(0, 0, 0, .2);
    line-break: auto
}

.popover.top {
    margin-top: -10px
}

.popover.right {
    margin-left: 10px
}

.popover.bottom {
    margin-top: 10px
}

.popover.left {
    margin-left: -10px
}

.popover-title {
    padding: 8px 14px;
    margin: 0;
    font-size: 14px;
    background-color: #f7f7f7;
    border-bottom: 1px solid #ebebeb;
    border-radius: 5px 5px 0 0
}

.popover-content {
    padding: 9px 14px
}

.popover>.arrow,
.popover>.arrow:after {
    position: absolute;
    display: block;
    width: 0;
    height: 0;
    border-color: transparent;
    border-style: solid
}

.popover>.arrow {
    border-width: 11px
}

.popover>.arrow:after {
    content: "";
    border-width: 10px
}

.popover.top>.arrow {
    bottom: -11px;
    left: 50%;
    margin-left: -11px;
    border-top-color: #999;
    border-top-color: rgba(0, 0, 0, .25);
    border-bottom-width: 0
}

.popover.top>.arrow:after {
    bottom: 1px;
    margin-left: -10px;
    content: " ";
    border-top-color: #fff;
    border-bottom-width: 0
}

.popover.right>.arrow {
    top: 50%;
    left: -11px;
    margin-top: -11px;
    border-right-color: #999;
    border-right-color: rgba(0, 0, 0, .25);
    border-left-width: 0
}

.popover.right>.arrow:after {
    bottom: -10px;
    left: 1px;
    content: " ";
    border-right-color: #fff;
    border-left-width: 0
}

.popover.bottom>.arrow {
    top: -11px;
    left: 50%;
    margin-left: -11px;
    border-top-width: 0;
    border-bottom-color: #999;
    border-bottom-color: rgba(0, 0, 0, .25)
}

.popover.bottom>.arrow:after {
    top: 1px;
    margin-left: -10px;
    content: " ";
    border-top-width: 0;
    border-bottom-color: #fff
}

.popover.left>.arrow {
    top: 50%;
    right: -11px;
    margin-top: -11px;
    border-right-width: 0;
    border-left-color: #999;
    border-left-color: rgba(0, 0, 0, .25)
}

.popover.left>.arrow:after {
    right: 1px;
    bottom: -10px;
    content: " ";
    border-right-width: 0;
    border-left-color: #fff
}
.field-icon {
    float: right;
    margin-top: -28px;
    position: relative;
    z-index: 2;
    padding-right: 10px;
}

.step__content, .col-md-4 label, .col-md-2 label,p a {
    color: #5f6368 ! important;
}
</style>
<body class="error-body no-top lazy"  data-original="<?php echo $cloudfront;?>/work.jpg"  style="background-image: url('<?php echo $cloudfront;?>/work.jpg')"> 

<div class="row">
    <div class="col-md-4 col-md-offset-4 col-sm-6 col-sm-offset-3 bracketdiv1">
        <div class="panel panel-default contentmargin">
          <!--   <div class="panel-heading">
                <h3 class="panel-title"><?= Html::encode($this->title) ?></h3>
            </div> -->
            <div class="panel-body lightbracketdiv">
                <?php $form = ActiveForm::begin([
                    'id' => 'registration-form',
                    'enableAjaxValidation' => true,
                    'enableClientValidation' => false,
                ]); ?>
				<!-- new added --->				
				<?= $form->field($model, 'first_name') ?>
				<?= $form->field($model, 'last_name') ?>
                <?= $form->field($model, 'companyname') ?>
                <?= $form->field($model, 'contactphone') ?>
				<!-- ends -->
                <?= $form->field($model, 'email') ?>

                <!-- <?= $form->field($model, 'username') ?>
 -->
                <?php if ($module->enableGeneratingPassword == false): ?>
                    <?= $form->field($model, 'password',[
                    'template' => '<div class=\"\"><label class="control-label" for="register-form-password">Password</label>{input}<i  toggle="#password-field"  class="fa fa-eye-slash toggle-password field-icon "></i></div><div class=\"\">{error}</div>',
                    'inputOptions' => ['class' => 'form-control','data-toggle'=>"tooltip","title"=>"<i class='fa fa-exclamation-triangle' aria-hidden='true'></i>&nbsp;&nbsp;<b>Caps lock is on</b>",'data-html'=>"true","data-trigger"=>"manual"]])->passwordInput() ?>
                    
                <?php endif ?>

                <?= Html::submitButton(Yii::t('user', 'Sign up'), ['class' => 'btn btn-primary form-control btn-lg']) ?>

                <?php ActiveForm::end(); ?>
            </div>
        </div>
        <p class="text-center">
            <?= Html::a(Yii::t('user', 'Already registered?? Sign in!'), ['/user/security/login']) ?>
	</p>


       <!--  <div class="form-group">
                <div class="g-signin2" data-onsuccess="onSignIn"></div>
           </div> -->
           <script type="text/javascript">
                function onSignIn(googleUser) {
                      var profile = googleUser.getBasicProfile();
                      console.log('ID: ' + profile.getId()); // Do not send to your backend! Use an ID token instead.
                      console.log('Name: ' + profile.getName());
                              console.log('First Name: ' + profile.getGivenName());
                            console.log('Last Name: ' + profile.getFamilyName());
                      console.log('Image URL: ' + profile.getImageUrl());
                      console.log('Email: ' + profile.getEmail()); // This is null if the 'email' scope is not present.
                      
                      $("#register-form-email").val(profile.getEmail());
                      $("#register-form-password").val(profile.getId());
                      $("#register-form-first_name").val(profile.getGivenName());
                      $("#register-form-last_name").val(profile.getFamilyName());
                      $('#registration-form').trigger('submit');
                      
                    }
           </script>
    </div>
</div>
</body>
<script language="Javascript">
    $(document).ready(function(){
         $('[type=password]').keypress(function(e) {
          var $password = $(this),
              tooltipVisible = $('.tooltip').is(':visible'),
              s = String.fromCharCode(e.which);
          
          //Check if capslock is on. No easy way to test for this
          //Tests if letter is upper case and the shift key is NOT pressed.
          if ( s.toUpperCase() === s && s.toLowerCase() !== s && !e.shiftKey ) {
            if (!tooltipVisible)
                $password.tooltip('show');
          } else {
            if (tooltipVisible)
                $password.tooltip('hide');
          }
          
          //Hide the tooltip when moving away from the password field
          $password.blur(function(e) {
            $password.tooltip('hide');
          });
        });
          $('body').on('click', '.toggle-password', function() {
              $(this).toggleClass("fa fa-eye-slash fa fa-eye ");
              var input = $("#register-form-password");
              if (input.attr("type") == "password") {
                input.attr("type", "text");
              } else {
                input.attr("type", "password");
              }
            });
    });

</script>
