<?php
/*
 * This file is part of the Dektrium project.
 *
 * (c) Dektrium project <http://github.com/dektrium>
 *
 * For the full copyright and license information, please view the LICENSE.md
 * file that was distributed with this source code.
 */

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/**
 * @var yii\web\View $this
 * @var yii\widgets\ActiveForm $form
 * @var dektrium\user\models\RecoveryForm $model
 */
$cloudfront = "https://d1kzoyopflesfg.cloudfront.net";

$this->title = Yii::t('user', 'Reset your password');
$this->params['breadcrumbs'][] = $this->title;
?>
<style type="text/css">
    .breadcrumb{
        margin:0px ! important;
        display: none;
    }
    .bracketdiv1{
        border: solid thin;
        border-color: #5BC6F8;
        margin-top: 11%;
        background-color: white;
        border-radius: 10px;
    }

    input[type="text"] {
        font-family: "roboto";
        -webkit-appearance: none !important;
        color: #282323;
        outline: 0;
        height: 16px;
        padding: 6px 11px !important;
        line-height: 15px;
        font-size: 13px;
        font-weight: normal;
        vertical-align: top;
        background-color: #ffffff ! important;
        min-height: 37px;
        -webkit-box-shadow: none !important;
        -moz-box-shadow: none !important;
        box-shadow: none !important;
        -webkit-border-radius: 0px;
        -moz-border-radius: 0px;
        border-radius: 0px;
        -webkit-border-radius: 2px;
        -moz-border-radius: 2px;
        border-radius: 2px;
        border: 1px solid #e5e9ec;
        transition: background 0.2s linear 0s, box-shadow 0.2s linear 0s;
    }
    .panel-footer{
        background-color: white;
    }
    .panel-default > .panel-heading {
        background-color: transparent;
    }
    .panel-default > .panel-heading,.step__content, .col-md-4 label, .col-md-2 label,.panel-footer a {
        color: #5f6368;
    }
    .panel-default {
        background-color: white;
    }
    .bracketdiv1 {
        border: solid thin;
        border-color: #5BC6F8;
        margin-top: 11%;
        background-color: white;
        border-radius: 10px;
    }
    .field-icon {
        float: right;
        margin-top: -26px;
        position: relative;
        z-index: 2;
        padding-right: 10px;
    }
</style>


<body class="vertical-layout vertical-menu-modern 1-column  navbar-sticky footer-static bg-full-screen-image  blank-page blank-page" data-open="click" data-menu="vertical-menu-modern" data-col="1-column">
    <!-- BEGIN: Content-->
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="content-wrapper">
            <div class="content-header row">
            </div>
            <div class="content-body"><!-- forgot password start -->
                <section class="row flexbox-container">
                    <div class="col-xl-7 col-md-9 col-10  px-0">
                        <div class="card bg-authentication mb-0">
                            <div class="row m-0">
                                <!-- left section-forgot password -->
                                <div class="col-md-6 col-12 px-0">
                                    <div class="card disable-rounded-right mb-0 p-2">
                                        <div class="card-header pb-1">
                                            <div class="card-title">
                                                <h4 class="text-center mb-2">Reset your password</h4>
                                            </div>
                                        </div>                                       
                                        <div class="card-content">
                                            <div class="card-body">                                                
                                                 
                                                <?php
                                                $form = ActiveForm::begin([
                                                            'id' => 'password-recovery-form',
                                                            'enableAjaxValidation' => true,
                                                            'enableClientValidation' => false,
                                                ]);
                                                ?>

                                                <?=
                                                        $form->field(
                                                                $model, 'password', [
                                                            'template' => '<div class=\"\"><label class="text-bold-600" for="recovery-form-password">Password</label>{input}<i  toggle="#password-field"  class="fa fa-eye-slash toggle-password field-icon "></i></div><div class=\"\">{error}</div>',
                                                            'inputOptions' => ['class' => 'form-control', 'data-toggle' => "tooltip", "title" => "<i class='fa fa-exclamation-triangle' aria-hidden='true'></i>&nbsp;&nbsp;<b>Caps lock is on</b>", 'data-html' => "true", "data-placement" => "left", 'tabindex' => '2', "data-trigger" => "manual", 'maxlength' => "25"]])
                                                        ->passwordInput()
                                                ?>
                                                <?= Html::submitButton(Yii::t('user', 'Finish'), ['class' => 'btn btn-primary btn-block']) ?><br>

                                                <?php ActiveForm::end(); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 d-md-block d-none text-center align-self-center">
                                    <img class="img-fluid" src="https://app.leadcrm.io/web/app-assets/images/pages/maintenance-2.png" alt="branding logo" width="300">
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
</body>
<!--<body class="error-body no-top lazy"> 

<div class="row">
    <div class="col-md-4 col-md-offset-4 col-sm-6 col-sm-offset-3 bracketdiv1">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><?= Html::encode($this->title) ?></h3>
            </div>
            <div class="panel-body">
<?php
$form = ActiveForm::begin([
            'id' => 'password-recovery-form',
            'enableAjaxValidation' => true,
            'enableClientValidation' => false,
        ]);
?>

<?=
        $form->field(
                $model, 'password', [
            'template' => '<div class=\"\"><label class="control-label" for="recovery-form-password">Password</label>{input}<i  toggle="#password-field"  class="fa fa-eye-slash toggle-password field-icon "></i></div><div class=\"\">{error}</div>',
            'inputOptions' => ['class' => 'form-control', 'data-toggle' => "tooltip", "title" => "<i class='fa fa-exclamation-triangle' aria-hidden='true'></i>&nbsp;&nbsp;<b>Caps lock is on</b>", 'data-html' => "true", "data-placement" => "left", 'tabindex' => '2', "data-trigger" => "manual", 'maxlength' => "25"]])
        ->passwordInput()
?>
<?= Html::submitButton(Yii::t('user', 'Finish'), ['class' => 'btn btn-primary btn-block']) ?><br>

<?php ActiveForm::end(); ?>
            </div>
        </div>
    </div>
</div>
</body>-->
<script language="Javascript">
    $(document).ready(function () {
        $('[type=password]').keypress(function (e) {
            var $password = $(this),
                    tooltipVisible = $('.tooltip').is(':visible'),
                    s = String.fromCharCode(e.which);

            //Check if capslock is on. No easy way to test for this
            //Tests if letter is upper case and the shift key is NOT pressed.
            if (s.toUpperCase() === s && s.toLowerCase() !== s && !e.shiftKey) {
                if (!tooltipVisible)
                    $password.tooltip('show');
            } else {
                if (tooltipVisible)
                    $password.tooltip('hide');
            }

            //Hide the tooltip when moving away from the password field
            $password.blur(function (e) {
                $password.tooltip('hide');
            });
        });
        $('body').on('click', '.toggle-password', function () {
            $(this).toggleClass("fa fa-eye-slash fa fa-eye");
            var input = $("#recovery-form-password");
            if (input.attr("type") == "password") {
                input.attr("type", "text");
            } else {
                input.attr("type", "password");
            }
        });
    });

</script>
