<?php

/*
 * This file is part of the Dektrium project.
 *
 * (c) Dektrium project <http://github.com/dektrium>
 *
 * For the full copyright and license information, please view the LICENSE.md
 * file that was distributed with this source code.
 */

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/**
 * @var yii\web\View $this
 * @var dektrium\user\models\ResendForm $model
 */

$this->title = Yii::t('user', 'Recover your password');
//$this->params['breadcrumbs'][] = $this->title;
?>
<style>
.loginConfim p a{
	font-size: 12px;
}
.loginConfim p{
	padding: 0;
    margin: 0;
}
.breadcrumb{
	background-color: #5A8DEE !important;
    border-radius: 0!important;
	padding:0px !important;
}
.breadcrumb li{
	padding: 10px;
	color:#FFF!important;
}
.breadcrumb li a{
	color:#FFF!important;
}
.breadcrumb li.active {
    font-weight: 600;
}
.clsCustomCntr li{
	text-align:center;
	width:100%;
}
html body.blank-page .content-wrapper .flexbox-container{
	height:auto!important;
}
</style>
<!-- BEGIN: Content-->
<?php
$sitelogo = \Yii::$app->params['sitelogo'];
$sitetitle = \Yii::$app->params['sitetitle'];
?>
<ul class="breadcrumb clsCustomCntr">
<li><?php if($sitelogo==''){ echo '<span class="logoGuest" style="font-size: 18px;font-weight: bold;">'.$sitetitle.'</span>'; }else{  ?><img src="<?php echo $sitelogo; ?>" width="auto" height="50"> <?php } ?> </li>
</ul>
<div class="app-content content">
	<div class="content-overlay"></div>
	<div class="content-wrapper">
		<div class="content-header row">
		</div>
		<div class="content-body">
			<!-- register section starts -->
			<section class="row flexbox-container">
				<div class="col-xl-8 col-10">
					<div class="card bg-authentication mb-0">
						<div class="row m-0">
							<!-- register section left -->
							<div class="col-md-6 col-12 px-0">
								<div class="card disable-rounded-right mb-0 p-2 h-100 d-flex justify-content-center">
									<div class="card-header pb-1">
										<div class="card-title">
											<h4 class="text-center mb-2"><?= Html::encode($this->title) ?></h4>
										</div>
									</div>
									<div class="panel-body">
										<?php $form = ActiveForm::begin([
											'id' => 'password-recovery-form',
											'enableAjaxValidation' => true,
											'enableClientValidation' => false,
										]); ?>

										<?= $form->field($model, 'email')->textInput(['autofocus' => true]) ?>

<?php
$flag_pd=0;
$portal_id = 0;

$getPortalQry = Yii::$app->db->createCommand("SELECT * FROM `portals` WHERE `portal_url` LIKE '%" . $_SERVER['HTTP_HOST'] . "%'  LIMIT 1")->queryOne();
if(!empty($getPortalQry)){
	$portal_id = $getPortalQry['id'];
}else{
	$getPortalQry = Yii::$app->db->createCommand("SELECT * FROM `portals` WHERE `portal_url` LIKE '%app.linkedfusion.io%'  LIMIT 1")->queryOne();
	if(count($getPortalQry) > 0){
		$portal_id = $getPortalQry['id'];
	}
}
//$portal_id = 2;
?>										
										
										<?= $form->field($model, 'portal_id')->hiddenInput(['value'=> $portal_id])->label(false);?>
										
										<?= Html::submitButton(Yii::t('user', 'Continue'), ['class' => 'btn btn-primary btn-block']) ?><br>

										<?php ActiveForm::end(); ?>
									</div>
									<div class="text-center">
									<div class="loginConfim">
									<p class="text-center"><a href="<?php echo Yii::$app->request->baseUrl; ?>">Back to login ?</a> </p>
									</div>
									</div>
								</div>
							</div>
							<!-- image section right -->
							<div class="col-md-6 d-md-block d-none text-center align-self-center p-3">
								<img class="img-fluid" src="https://app.leadcrm.io/web/app-assets/images/pages/maintenance-2.png" alt="branding logo">
							</div>
						</div>
					</div>
				</div>
			</section>
			<!-- register section endss -->
		</div>
	</div>
</div>
<!-- END: Content-->
<script>
$(function() {
  $('body').addClass('horizontal-layout navbar-sticky 1-column footer-static bg-full-screen-image blank-page blank-page pace-done menu-hide vertical-layout vertical-overlay-menu fixed-navbar');
});
</script>

