<?php

/*
 * This file is part of the Dektrium project.
 *
 * (c) Dektrium project <http://github.com/dektrium/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace dektrium\user\models;

use dektrium\user\traits\ModuleTrait;
use Yii;
use yii\base\Model;

/**
 * Registration form collects user input on registration process, validates it and creates new User model.
 *
 * @author Dmitry Erofeev <dmeroff@gmail.com>
 */
class RegistrationForm extends Model
{
    use ModuleTrait;
	
	// for first_name 
	public $first_name;
	// for last_name
	public $last_name;
    public $companyname;
    public $contactphone;
    /**
     * @var string User email address
     */
    public $email;

    /**
     * @var string Username
     */
    public $username;

    /**
     * @var string Password
     */
    public $password;
    public $portal_id;
    public $channel_id;

    /**
     * @inheritdoc
     */
    public function rules()
    {
        $user = $this->module->modelMap['User'];
        return [
            // username rules
            /*'usernameTrim'     => ['username', 'trim'],
            'usernameLength'   => ['username', 'string', 'min' => 3, 'max' => 255],
            'usernamePattern'  => ['username', 'match', 'pattern' => $user::$usernameRegexp],
            'usernameRequired' => ['username', 'required'],
            'usernameUnique'   => [
                'username',
                'unique',
                'targetClass' => $user,
                'message' => Yii::t('user', 'This username has already been taken')
            ],*/
			[['first_name', 'last_name','email','password','portal_id','channel_id'], 'required'],
            // email rules
            'emailTrim'     => ['email', 'trim'],
            'emailRequired' => ['email', 'required'],
            'emailPattern'  => ['email', 'email'],
            /*'emailUnique'   => [
                'email',
                'unique',
                'targetClass' => $user,
                'message' => Yii::t('user', 'REGISTRAION CONTROLLER This email address has already been taken')
            ],*/
			'emailUnique'   => [
                'email',
                'isValidCombinationForEmailAndPortalID',
                //'targetClass' => $user,
                //'message' => Yii::t('user', 'REGISTRAION CONTROLLER This email address has already been taken')
            ],
            // password rules
            'passwordRequired' => ['password', 'required', 'skipOnEmpty' => $this->module->enableGeneratingPassword],
            'passwordLength'   => ['password', 'string', 'min'=>6, 'max'=>25],
            // for first name & last name
            'first_name' =>['first_name','string', 'min'=>3, 'max'=>20],
            'last_name' =>['last_name','string', 'min'=>3, 'max'=>20],
            'companyname' =>['companyname','string','min'=>3],
            'contactphone' =>['contactphone','integer'],
            'portal_id' =>['portal_id','integer'],
            'channel_id' =>['channel_id','integer'],
        ];
    }
	
	public function isValidCombinationForEmailAndPortalID($attribute){
		$p_email = Yii::$app->request->post()['register-form']['email'];
		$p_portal_id = Yii::$app->request->post()['register-form']['portal_id'];
		$p_channel_id = Yii::$app->request->post()['register-form']['channel_id'];
		
		$dataUserarry = Yii::$app->db->createCommand("SELECT * from `user` where `email`='".$p_email."' and `portal_id`=".$p_portal_id." LIMIT 1")->queryOne();
		if (!empty($dataUserarry['id'])){
			$this->addError($attribute, Yii::t('user', 'This email address has already been taken...'));
		}
		
		/*if($p_channel_id > 0){
			
			$dataUserarryc = Yii::$app->db->createCommand("SELECT * from `user` where `email`='".$p_email."' and `channel_id`=".$p_channel_id." LIMIT 1")->queryOne();
			if (!empty($dataUserarryc['id'])){
			$this->addError($attribute, Yii::t('user', 'This email address has already been taken...'));
			}
			
		} */
	}

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
			// new added first_name, last_name
			'first name'=> Yii::t('user', 'first_name'),
			'last name'=> Yii::t('user', 'last_name'),
            'companyname'=> Yii::t('user', 'Company Name'),
            'contactphone'=> Yii::t('user', 'Contact Phone'),
            'email'    => Yii::t('user', 'Email'),
            //'username' => Yii::t('user', 'Username'),
            'password' => Yii::t('user', 'Password'),
            'portal_id' => Yii::t('user', 'portal_id'),
            'channel_id' => Yii::t('user', 'channel_id'),
        ];
    }

    /**
     * @inheritdoc
     */
    public function formName()
    {
        return 'register-form';
    }

    /**
     * Registers a new user account. If registration was successful it will set flash message.
     *
     * @return bool
     */
    public function register()
    {
        if (!$this->validate()) {
            return false;
        }

        /** @var User $user */
        $user = Yii::createObject(User::className());
		
        $user->setScenario('register');        
        $this->loadAttributes($user);
		
		//echo '<pre>'; print_r($this); exit;
		
		
		
		//echo '<pre>'; print_r($this); exit; 
        if (!$user->register()) {
            return false;
        }

        Yii::$app->session->setFlash(
            'info',
            Yii::t(
                'user',
                'Your account has been created and a message with further instructions has been sent to your email'
            )
        );

        return true;
    }

    /**
     * Loads attributes to the user model. You should override this method if you are going to add new fields to the
     * registration form. You can read more in special guide.
     *
     * By default this method set all attributes of this model to the attributes of User model, so you should properly
     * configure safe attributes of your User model.
     *
     * @param User $user
     */
    protected function loadAttributes(User $user)
    {   
        $user->setAttributes($this->attributes);
    }
}
