<?php

/*
 * This file is part of the Dektrium project.
 *
 * (c) Dektrium project <http://github.com/dektrium/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace dektrium\user\controllers;

use dektrium\user\Finder;
use dektrium\user\models\Account;
use dektrium\user\models\LoginForm;
use dektrium\user\models\User;
use dektrium\user\Module;
use dektrium\user\traits\AjaxValidationTrait;
use dektrium\user\traits\EventTrait;
use Yii;
use yii\authclient\AuthAction;
use yii\authclient\ClientInterface;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;
use yii\helpers\Url;
use yii\web\Controller;
use yii\web\Response;


/**
 * Controller that manages user authentication process.
 *
 * @property Module $module
 *
 * @author Dmitry Erofeev <dmeroff@gmail.com>
 */
class SecurityController extends Controller
{
    use AjaxValidationTrait;
    use EventTrait;

    /**
     * Event is triggered before logging user in.
     * Triggered with \dektrium\user\events\FormEvent.
     */
    const EVENT_BEFORE_LOGIN = 'beforeLogin';

    /**
     * Event is triggered after logging user in.
     * Triggered with \dektrium\user\events\FormEvent.
     */
    const EVENT_AFTER_LOGIN = 'afterLogin';

    /**
     * Event is triggered before logging user out.
     * Triggered with \dektrium\user\events\UserEvent.
     */
    const EVENT_BEFORE_LOGOUT = 'beforeLogout';

    /**
     * Event is triggered after logging user out.
     * Triggered with \dektrium\user\events\UserEvent.
     */
    const EVENT_AFTER_LOGOUT = 'afterLogout';

    /**
     * Event is triggered before authenticating user via social network.
     * Triggered with \dektrium\user\events\AuthEvent.
     */
    const EVENT_BEFORE_AUTHENTICATE = 'beforeAuthenticate';

    /**
     * Event is triggered after authenticating user via social network.
     * Triggered with \dektrium\user\events\AuthEvent.
     */
    const EVENT_AFTER_AUTHENTICATE = 'afterAuthenticate';

    /**
     * Event is triggered before connecting social network account to user.
     * Triggered with \dektrium\user\events\AuthEvent.
     */
    const EVENT_BEFORE_CONNECT = 'beforeConnect';

    /**
     * Event is triggered before connecting social network account to user.
     * Triggered with \dektrium\user\events\AuthEvent.
     */
    const EVENT_AFTER_CONNECT = 'afterConnect';


    /** @var Finder */
    protected $finder;

    /**
     * @param string $id
     * @param Module $module
     * @param Finder $finder
     * @param array  $config
     */
    public function __construct($id, $module, Finder $finder, $config = [])
    {
        $this->finder = $finder;
        parent::__construct($id, $module, $config);
    }

    /** @inheritdoc */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    ['allow' => true, 'actions' => ['login', 'auth'], 'roles' => ['?']],
                    ['allow' => true, 'actions' => ['login', 'auth', 'logout'], 'roles' => ['@']],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /** @inheritdoc */
    public function actions()
    {
        return [
            'auth' => [
                'class' => AuthAction::className(),
                // if user is not logged in, will try to log him in, otherwise
                // will try to connect social account to user.
                'successCallback' => \Yii::$app->user->isGuest
                    ? [$this, 'authenticate']
                    : [$this, 'connect'],
            ],
        ];
    }

    /**
     * Displays the login page.
     *
     * @return string|Response
     */
   public function actionLogin()
    {	
		if(\Yii::$app->session->get('useremail')){
            $url = Yii::$app->request->baseUrl;            
            //$url .="/my-template/prospect";
            //$url .="/dashboard";
            $url .="/sequences";
            return $this->redirect($url);
        }
		 	
        if (!\Yii::$app->user->isGuest) {      
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect('$url');
        }
		
		if(isset($_GET['loginData'])){
			$recaptcha_secret = "0x4AAAAAAAOEsBV8JvEK9lCZVRsxuzKQno8";  // Replace with your actual secret key   
			$recaptcha_response = $_POST['g-recaptcha-response'] ?? '';

			if (!$recaptcha_response) {
				//die("reCAPTCHA verification failed. Please try again."); 
				$url = \Yii::$app->request->baseUrl."/login"; 
				return $this->redirect('$url');
			}
			if(!empty($recaptcha_response) && $recaptcha_response!="bypass"){ 
				$ip = $_SERVER['REMOTE_ADDR']; 
				$url_path = 'https://challenges.cloudflare.com/turnstile/v0/siteverify';
				$data = array('secret' => $recaptcha_secret, 'response' => $recaptcha_response, 'remoteip' => $ip);

				$options = array(
					'http' => array(
					'header' => "Content-type: application/x-www-form-urlencoded", 
					'method' => 'POST',
					'content' => http_build_query($data))
				);

				$stream = stream_context_create($options);

				$result = file_get_contents($url_path, false, $stream);

				$response =  $result;   

				$recaptcha_data = json_decode($response,true);
				//print_r($recaptcha_data);exit; 
				if (!$recaptcha_data['success']) { 
					//return false; 
					$url = \Yii::$app->request->baseUrl."/login"; 
					return $this->redirect('$url');
				}
			}
			
             $login_data1 = base64_decode($_GET['loginData']);
             $login_data1 = json_decode($login_data1);
             $username =    $login_data1->username;
           $password =    $login_data1->password;
		   $portal_id =    $login_data1->portal_id;
           $google = 0;
           if(isset($login_data1->google))
           $google =  $login_data1->google;
             $login_data = ['login-form'=>['username' => $login_data1->username ,'password' =>$login_data1->password ,                'rememberMe' => 1 ]];
            
			$userAgent = $_SERVER['HTTP_USER_AGENT'];
			$sql = Yii::$app->db->createCommand("select * from user where email='".$username."' and portal_id=".$portal_id)->queryAll();
             
            if(sizeof($sql) > 0){
                \Yii::$app->session->set('useremail',$username);
                \Yii::$app->session->set('teamid',$sql[0]['teamid']);
                \Yii::$app->session->set('username',$sql[0]['username']);        
                \Yii::$app->session->set('userid',$sql[0]['id']);
                \Yii::$app->session->set('first_name',$sql[0]['first_name']);
                \Yii::$app->session->set('last_name',$sql[0]['last_name']);
                \Yii::$app->session->set('companyname',$sql[0]['companyname']);
                \Yii::$app->session->set('contactphone',$sql[0]['contactphone']);
                \Yii::$app->session->set('google',$google);
				\Yii::$app->session->set('last_login_at',$sql[0]['last_login_at']);
				\Yii::$app->session->set('portal_id',$sql[0]['portal_id']);
				\Yii::$app->session->set('channel_id',$sql[0]['channel_id']);
				
				$last_login_at = Yii::$app->db->createCommand("update `user` SET `last_login_at`=".time().", `userAgent`='".$userAgent."' where `id`=".$sql[0]['id'])->execute();  
                
                $url = \Yii::$app->request->baseUrl;            
               //$url .="/my-template/prospect";
               //$url .="/dashboard";
               $url .="/sequences";
               return $this->redirect($url);
            }else{

                $email = $login_data1->username;
                $password = $login_data1->password;
                $first_name = $login_data1->first_name;
                $last_name = $login_data1->last_name;
                $registration_ip = "::1";
                $created_at = time();
                $activation_code=mt_rand(100000000,999999999);

                $name = explode('@',$email)[0].$activation_code;

                    if (!empty($_SERVER['HTTP_CLIENT_IP']))   //check ip from share internet
                    {
                      $registration_ip=$_SERVER['HTTP_CLIENT_IP'];
                    }
                    elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))   //to check ip is pass from proxy
                    {
                      $registration_ip=$_SERVER['HTTP_X_FORWARDED_FOR'];
                    }
                    else
                    {
                      $registration_ip=$_SERVER['REMOTE_ADDR'];
                    }
					
				$killWordsSuffix = 'bsn,ceo,certified,copywriter,cpc,digital,dr,drs,expert,freelance,hubspot,internet,lion,lme,lmt,ma,marketing,mba,md,mim,msc,ninja,online,pharma,phd,ppc,seo,sip,videoseo';
/*echo "INSERT INTO `user` (`id`,`username`,`email`,`password_hash`,`auth_key`,`confirmed_at`,`unconfirmed_email`,`blocked_at`,`registration_ip`,`created_at`,`updated_at`,`flags`,`last_login_at`,`first_name`,`last_name`,`companyname`,`contactphone`) 
                        VALUES (null,'$name','$email','$password','$activation_code',0,NULL,0,'$registration_ip','$created_at','$created_at',0,'0','$first_name','$last_name','',''
                        )"; die();*/
                $password = password_hash($password,PASSWORD_DEFAULT);
                $sql = Yii::$app->db->createCommand("INSERT INTO `user` (`id`,`username`,`email`,`password_hash`,`auth_key`,`confirmed_at`,`unconfirmed_email`,`blocked_at`,`registration_ip`,`created_at`,`updated_at`,`flags`,`last_login_at`,`first_name`,`last_name`,`companyname`,`contactphone`,`portal_id`,`userAgent`,`killWordsSuffix`) 
                        VALUES (null,'$name','$email','$password','$activation_code',0,NULL,0,'$registration_ip','$created_at','$created_at',0,'0','$first_name','$last_name','','','$portal_id','".$userAgent."','".$killWordsSuffix."'
                        )")->execute();
                // \Yii::$app->session->setFlash('danger', \Yii::t('user', 'Not a Register User'));
             //   echo "select * from user where email='".$email ."'"; die();
                  $sql = Yii::$app->db->createCommand("select * from user where email='".$email ."' and portal_id=".$portal_id)->queryAll();
            
             $sql = Yii::$app->db->createCommand("update `user` SET `teamid`=".$sql[0]['id']." where `id`=".$sql[0]['id'])->execute();
            
               $sql = Yii::$app->db->createCommand("select * from user where email='".$email ."' and portal_id=".$portal_id)->queryAll();

                \Yii::$app->session->set('useremail',$username);
                //\Yii::$app->session->set('teamid',$sql[0]['teamid']);
                \Yii::$app->session->set('username',$sql[0]['username']);        
                \Yii::$app->session->set('userid',$sql[0]['id']);
                \Yii::$app->session->set('teamid',$sql[0]['id']);
                \Yii::$app->session->set('first_name',$sql[0]['first_name']);
                \Yii::$app->session->set('last_name',$sql[0]['last_name']);
                \Yii::$app->session->set('companyname',$sql[0]['companyname']);
                \Yii::$app->session->set('contactphone',$sql[0]['last_login_at']);
                \Yii::$app->session->set('google','1');
				\Yii::$app->session->set('last_login_at',$sql[0]['last_login_at']);
				\Yii::$app->session->set('portal_id',$sql[0]['portal_id']);
				\Yii::$app->session->set('channel_id',$sql[0]['channel_id']);
				
				  $last_login_at = Yii::$app->db->createCommand("update `user` SET `last_login_at`=".time()." where `id`=".$sql[0]['id'])->execute();

              // echo \Yii::$app->session->get('teamid'); die();
                
                $url = \Yii::$app->request->baseUrl;            
               //$url .="/my-template/prospect";
               //$url .="/dashboard";
               $url .="/sequences";
               return $this->redirect($url);
            }
        }
		
        /** @var LoginForm $model */                
        $model = \Yii::createObject(LoginForm::className());
        $event = $this->getFormEvent($model);
        $this->performAjaxValidation($model);

        $this->trigger(self::EVENT_BEFORE_LOGIN, $event);		
        if ($model->load(\Yii::$app->getRequest()->post()) && $model->login()) {
			
			$sql = Yii::$app->db->createCommand("select * from user where id='".Yii::$app->session->get('userid')."'")->queryAll();
            if(sizeof($sql) > 0){
				$proxyIp = $sql[0]['proxyIp'];
				$proxyPort = $sql[0]['proxyPort'];
				$proxyUsername = $sql[0]['proxyUsername'];
				$proxyPassword = $sql[0]['proxyPassword'];
				$cookie = $sql[0]['cookie'];
				$csrf = $sql[0]['csrf'];
				$userAgent = $sql[0]['userAgent']; 
				if(empty($cookie) && empty($csrf)){
					\Yii::$app->session->set('top_profile_pic',''); 
				}else{

					$curl = curl_init();
					curl_setopt_array($curl, array(
					CURLOPT_URL => "https://www.linkedin.com/voyager/api/me",
					CURLOPT_RETURNTRANSFER => true,
					CURLOPT_ENCODING => "",
					CURLOPT_MAXREDIRS => 10,
					CURLOPT_TIMEOUT => 0,
					CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
					CURLOPT_HTTPPROXYTUNNEL => 1,
					CURLOPT_PROXY => "$proxyIp",
					CURLOPT_PROXYPORT => "$proxyPort",
					CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
					CURLOPT_CUSTOMREQUEST => "GET",
					CURLOPT_HTTPHEADER => array(
					"cookie: $cookie",
					"csrf-token: $csrf",
					"x-http-method-override: GET",
					"Host: www.linkedin.com",
					"User-Agent: $userAgent",
					"Accept-Language: en-US,en;q=0.5",
					"Accept-Encoding: gzip, deflate, br",
					"content-type: application/x-www-form-urlencoded",
					"x-li-lang: en_US",
					"x-restli-protocol-version: 2.0.0",
					"Origin: https://www.linkedin.com",
					"TE: Trailers"
					),
					));	
					$curlResult = curl_exec($curl);
					//echo '<pre>';print_r($curlResult); die;
					if(!empty($curlResult)){
						$decodedRes = json_decode($curlResult);
						if(!empty($decodedRes->miniProfile->picture)){
						$picture = (array)$decodedRes->miniProfile->picture;
						$topProfilePic = $picture['com.linkedin.common.VectorImage']->rootUrl . $picture['com.linkedin.common.VectorImage']->artifacts[0]->fileIdentifyingUrlPathSegment;
						\Yii::$app->session->set('top_profile_pic',$topProfilePic);
						\Yii::$app->session->set('linkedin_firstname',$decodedRes->miniProfile->firstName);
						\Yii::$app->session->set('linkedin_lastname',$decodedRes->miniProfile->lastName);
						}else{
							\Yii::$app->session->set('top_profile_pic',''); 
						} 
					}else{
						\Yii::$app->session->set('top_profile_pic','');
					}
				
				}
				\Yii::$app->session->set('user_role',$sql[0]['user_role']);
				//Yii::$app->db->createCommand("UPDATE user SET userAgent= '".$_SERVER['HTTP_USER_AGENT']."' ")->execute();

			}
			
            $this->trigger(self::EVENT_AFTER_LOGIN, $event);							
            $url = \Yii::$app->request->baseUrl;            
            //$url .="/my-template/prospect";
           // $url .="/dashboard";
            $url .="/sequences";
            return $this->redirect($url);        
        }

        return $this->render('login', [
            'model'  => $model,
            'module' => $this->module,
        ]);
		
    }

    /**
     * Logs the user out and then redirects to the homepage.
     *
     * @return Response
     */
    public function actionLogout()
    {
		
		
        $event = $this->getUserEvent(\Yii::$app->user->identity);

        $this->trigger(self::EVENT_BEFORE_LOGOUT, $event);
      
        \Yii::$app->getUser()->logout();

        //$this->trigger(self::EVENT_AFTER_LOGOUT, $event);
        
    }

    /**
     * Tries to authenticate user via social network. If user has already used
     * this network's account, he will be logged in. Otherwise, it will try
     * to create new user account.
     *
     * @param ClientInterface $client
     */
    public function authenticate(ClientInterface $client)
    {
        $account = $this->finder->findAccount()->byClient($client)->one();

        if (!$this->module->enableRegistration && ($account === null || $account->user === null)) {
            \Yii::$app->session->setFlash('danger', \Yii::t('user', 'Registration on this website is disabled'));
            $this->action->successUrl = Url::to(['/user/security/login']);
            return;
        }

        if ($account === null) {
            /** @var Account $account */
            $accountObj = \Yii::createObject(Account::className());
            $account = $accountObj::create($client);
        }

        $event = $this->getAuthEvent($account, $client);

        $this->trigger(self::EVENT_BEFORE_AUTHENTICATE, $event);

        if ($account->user instanceof User) {
            if ($account->user->isBlocked) {
                \Yii::$app->session->setFlash('danger', \Yii::t('user', 'Your account has been blocked.'));
                $this->action->successUrl = Url::to(['/user/security/login']);
            } else {
                $account->user->updateAttributes(['last_login_at' => time()]);
                \Yii::$app->user->login($account->user, $this->module->rememberFor);
                $this->action->successUrl = \Yii::$app->getUser()->getReturnUrl();
            }
        } else {
            $this->action->successUrl = $account->getConnectUrl();
        }

        $this->trigger(self::EVENT_AFTER_AUTHENTICATE, $event);
    }

    /**
     * Tries to connect social account to user.
     *
     * @param ClientInterface $client
     */
    public function connect(ClientInterface $client)
    {
        /** @var Account $account */
        $account = \Yii::createObject(Account::className());
        $event   = $this->getAuthEvent($account, $client);

        $this->trigger(self::EVENT_BEFORE_CONNECT, $event);

        $account->connectWithUser($client);

        $this->trigger(self::EVENT_AFTER_CONNECT, $event);

        $this->action->successUrl = Url::to(['/user/settings/networks']);
    }
}
