<?php

/*
 * This file is part of the Dektrium project.
 *
 * (c) Dektrium project <http://github.com/dektrium/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace dektrium\user;

use dektrium\user\models\Token;
use dektrium\user\models\User;
use Yii;
use yii\base\Component;
use yii\db\Query;//29-06-2020 added

/**
 * Mailer.
 *
 * @author Dmitry Erofeev <dmeroff@gmail.com>
 */
class Mailer extends Component
{
    /** @var string */
    public $viewPath = '@dektrium/user/views/mail';

    /** @var string|array Default: `Yii::$app->params['adminEmail']` OR `no-reply@example.com` */
    public $sender;

    /** @var \yii\mail\BaseMailer Default: `Yii::$app->mailer` */
    public $mailerComponent;

    /** @var string */
    protected $welcomeSubject;

    /** @var string */
    protected $newPasswordSubject;

    /** @var string */
    protected $confirmationSubject;

    /** @var string */
    protected $reconfirmationSubject;

    /** @var string */
    protected $recoverySubject;

    /** @var \dektrium\user\Module */
    protected $module;

    /**
     * @return string
     */
    public function getWelcomeSubject()
    {   $sitetitle = \Yii::$app->params['sitetitle'];
        if ($this->welcomeSubject == null) {
            $this->setWelcomeSubject(Yii::t('user', $sitetitle.' | LinkedIn Lead Generation',  $sitetitle));
        }

        return $this->welcomeSubject;
    }

    /**
     * @param string $welcomeSubject
     */
    public function setWelcomeSubject($welcomeSubject)
    {
        $this->welcomeSubject = $welcomeSubject;
    }

    /**
     * @return string
     */
    public function getNewPasswordSubject()
    {
         $sitetitle = \Yii::$app->params['sitetitle'];
		if ($this->newPasswordSubject == null) {
            $this->setNewPasswordSubject(Yii::t('user', 'Your password on {0} has been changed', $sitetitle));
        }

        return $this->newPasswordSubject;
    }

    /**
     * @param string $newPasswordSubject
     */
    public function setNewPasswordSubject($newPasswordSubject)
    {
        $this->newPasswordSubject = $newPasswordSubject;
    }

    /**
     * @return string
     */
    public function getConfirmationSubject()
    {   $sitetitle = \Yii::$app->params['sitetitle'];
        if ($this->confirmationSubject == null) {
            $this->setConfirmationSubject(Yii::t('user', 'Confirm account on {0}', $sitetitle));
        }

        return $this->confirmationSubject;
    }

    /**
     * @param string $confirmationSubject
     */
    public function setConfirmationSubject($confirmationSubject)
    {
        $this->confirmationSubject = $confirmationSubject;
    }

    /**
     * @return string
     */
    public function getReconfirmationSubject()
    {
        $sitetitle = \Yii::$app->params['sitetitle'];
		if ($this->reconfirmationSubject == null) {
            $this->setReconfirmationSubject(Yii::t('user', 'Confirm email change on {0}', $sitetitle));
        }

        return $this->reconfirmationSubject;
    }

    /**
     * @param string $reconfirmationSubject
     */
    public function setReconfirmationSubject($reconfirmationSubject)
    {
        $this->reconfirmationSubject = $reconfirmationSubject;
    }

    /**
     * @return string
     */
    public function getRecoverySubject()
    {  $sitetitle = \Yii::$app->params['sitetitle'];
        if ($this->recoverySubject == null) {
            $this->setRecoverySubject(Yii::t('user', 'Complete password reset on {0}', $sitetitle));
        }

        return $this->recoverySubject;
    }

    /**
     * @param string $recoverySubject
     */
    public function setRecoverySubject($recoverySubject)
    {
        $this->recoverySubject = $recoverySubject;
    }

    /** @inheritdoc */
    public function init()
    {
        $this->module = Yii::$app->getModule('user');
        parent::init();
    }

    /**
     * Sends an email to a user after registration.
     *
     * @param User  $user
     * @param Token $token
     * @param bool  $showPassword
     *
     * @return bool
     */
    public function sendWelcomeMessage(User $user, Token $token = null, $showPassword = false)
    {
	
			//29-06-2020 starts
			$welcomeEmailEileByPortal = 'welcome';
			if($user->portal_id > 0){
				$sql = "select `portal_url` from `portals` where `id`=".$user->portal_id." LIMIT 1";
				$mydata = Yii::$app->db->createCommand($sql)->queryOne();
				if(!empty($mydata['portal_url'])){
					if($mydata['portal_url']=='https://nikit.intricare.net'){
						$welcomeEmailEileByPortal = 'welcome_staging_server';
					}elseif($mydata['portal_url']=='https://app.linkedfusion.io'){
						$welcomeEmailEileByPortal = 'welcome_app-linkedfusion-io_server';
					}elseif($mydata['portal_url']=='https://app.cloudkennect.com'){
						$welcomeEmailEileByPortal = 'welcome_app-cloudkennect-com_server';
					}elseif($mydata['portal_url']=='https://staging.cloudkennect.com'){
						$welcomeEmailEileByPortal = 'welcome_staging-cloudkennect-com_server';
					}else{
						$welcomeEmailEileByPortal = 'welcome';
					}
				}
			}
			//29-06-2020 ends
	
        return $this->sendMessage(
            $user->email,
            $this->getWelcomeSubject(),
            $welcomeEmailEileByPortal,
            ['user' => $user, 'token' => $token, 'module' => $this->module, 'showPassword' => $showPassword]
        );
    }

    /**
     * Sends a new generated password to a user.
     *
     * @param User  $user
     * @param Password $password
     *
     * @return bool
     */
    public function sendGeneratedPassword(User $user, $password)
    {
        return $this->sendMessage(
            $user->email,
            $this->getNewPasswordSubject(),
            'new_password',
            ['user' => $user, 'password' => $password, 'module' => $this->module]
        );
    }

    /**
     * Sends an email to a user with confirmation link.
     *
     * @param User  $user
     * @param Token $token
     *
     * @return bool
     */
    public function sendConfirmationMessage(User $user, Token $token)
    {
        return $this->sendMessage(
            $user->email,
            $this->getConfirmationSubject(),
            'confirmation',
            ['user' => $user, 'token' => $token]
        );
    }

    /**
     * Sends an email to a user with reconfirmation link.
     *
     * @param User  $user
     * @param Token $token
     *
     * @return bool
     */
    public function sendReconfirmationMessage(User $user, Token $token)
    {
        if ($token->type == Token::TYPE_CONFIRM_NEW_EMAIL) {
            $email = $user->unconfirmed_email;
        } else {
            $email = $user->email;
        }

        return $this->sendMessage(
            $email,
            $this->getReconfirmationSubject(),
            'reconfirmation',
            ['user' => $user, 'token' => $token]
        );
    }

    /**
     * Sends an email to a user with recovery link.
     *
     * @param User  $user
     * @param Token $token
     *
     * @return bool
     */
    public function sendRecoveryMessage(User $user, Token $token)
    {
        return $this->sendMessage(
            $user->email,
            $this->getRecoverySubject(),
            'recovery',
            ['user' => $user, 'token' => $token]
        );
    }

    /**
     * @param string $to
     * @param string $subject
     * @param string $view
     * @param array  $params
     *
     * @return bool
     */
    protected function sendMessage($to, $subject, $view, $params = [])
    {
        
		
		
		$mailer = $this->mailerComponent === null ? Yii::$app->mailer : Yii::$app->get($this->mailerComponent);
        $mailer->viewPath = $this->viewPath;
        $mailer->getView()->theme = Yii::$app->view->theme;

        if ($this->sender === null) {
            $this->sender = isset(Yii::$app->params['adminEmail']) ?
                Yii::$app->params['adminEmail']
                : 'no-reply@example.com';
        }

		if(Yii::$app->params['portal_id'] == '5' && $view == 'recovery'){
			
			return $mailer->compose(['html' => $view, 'text' => 'text/' . $view], $params)
            ->setTo($to)
//	    ->setCc('arpan@intricare.net','support@intricare.net')
            //->setBcc(['forgot@kennected.io']) 
           //->setFrom($this->sender)
		    ->setFrom([$this->sender=>Yii::$app->params['emailFromName']])
            ->setSubject($subject)
            ->send();
			
	} 
	elseif(Yii::$app->params['portal_id'] == '5' && $view == 'welcome_app-cloudkennect-com_server')
	{
		
		return $mailer->compose(['html' => $view, 'text' => 'text/' . $view], $params)
            ->setTo($to)
 	        //->setCc('dhaval.thakor@intricare.net')
            //->setBcc(['forgot@kennected.io','brandon@kennected.io','ryan@kennected.io','zack.lathan@kennected.io'])   
           //->setFrom($this->sender)
		    ->setFrom([$this->sender=>Yii::$app->params['emailFromName']])
            ->setSubject($subject)
            ->send();
		
	}
	elseif(Yii::$app->params['portal_id'] == '12')
	{
		
		return $mailer->compose(['html' => $view, 'text' => 'text/' . $view], $params)
            ->setTo($to)
 	        ->setCc('chad@bdr.ai')
            ->setBcc(['kristen@scalex.ai'])   
           //->setFrom($this->sender)
		    ->setFrom([$this->sender=>Yii::$app->params['emailFromName']])
            ->setSubject($subject)
            ->send();
		
	}
	elseif(Yii::$app->params['portal_id'] == '20')
	{
		
		return $mailer->compose(['html' => $view, 'text' => 'text/' . $view], $params)
            ->setTo($to)
 	        ->setCc('orders@leadscout.io')
            //->setBcc(['kristen@scalex.ai'])   
           //->setFrom($this->sender)
		    ->setFrom([$this->sender=>Yii::$app->params['emailFromName']])
            ->setSubject($subject)
            ->send();
		
	}
	else
		{


        return $mailer->compose(['html' => $view, 'text' => 'text/' . $view], $params)
            ->setTo($to)
//	    ->setCc('arpan@intricare.net','support@intricare.net')
            //->setBcc(['forgot@kennected.io']) 
           //->setFrom($this->sender)
		    ->setFrom([$this->sender=>Yii::$app->params['emailFromName']])
            ->setSubject($subject)
            ->send();
    
		}
	}
}
