<?php

namespace app\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\MyTemplateModel;

/**
 * MyTemplateSearchModel represents the model behind the search form of `app\models\MyTemplateModel`.
 */
class MyTemplateSearchModel extends MyTemplateModel
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['templateid'], 'integer'],
            [['templatename', 'teamid', 'template'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $teamid= Yii::$app->session->get('teamid');
        $query = MyTemplateModel::find()->where(['teamid'=>$teamid]);  

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'templateid' => $this->templateid,
        ]);

        $query->andFilterWhere(['like', 'templatename', $this->templatename])
            ->andFilterWhere(['like', 'teamid', $this->teamid])
            ->andFilterWhere(['like', 'template', $this->template]);

        return $dataProvider;
    }
}
