<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "Templates".
 *
 * @property int $templateid
 * @property string $templatename
 * @property string $teamid
 * @property string $template
 */
class MyTemplateModel extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'templates';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            //[['templateid', 'templatename', 'teamid', 'template'], 'required'],
            [['templatename', 'teamid', 'template'], 'required'],
            [['templateid'], 'integer'],
            [['templatename', 'teamid'], 'string', 'max' => 30],
            [['template'], 'string', 'max' => 3000],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'templateid' => 'Templateid',
            'templatename' => 'Title',
            'teamid' => 'Team Id',
            'template' => 'Content'
			
        ];
    }
}
