<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "blacklistcompany".
 *
 * @property int $id
 * @property string $company_name
 * @property string $company_url
 * @property string $user_id
 */
class Blacklistcompany extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'blacklistcompany';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        //echo Yii::$app->request->post('company_url'); die();
        return [ 
                [
                    ['company_name', 'company_url'], 'required'],
                    ['company_url', 'url'],
                    ['user_id','default','value'=>Yii::$app->session->get('userid')],
                    ['company_url','match', 'pattern' => '/\bwww.linkedin.com\/company\/*\b/', 'message' => 'Please provide valid Company page Url'],['company_id','string']
            ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
           // 'id' => 'ID',
            'company_name' => 'Company Name',
            'company_url' => 'LinkedIn Company Page URL',
        ];
    }
}
