<?php

namespace app\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Blacklist;

/**
 * BlacklistSearch represents the model behind the search form of `app\models\Blacklist`.
 */
class BlacklistSearch extends Blacklist
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'teamid', 'userid'], 'integer'],
            [['url_publicIdentifier', 'type'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Blacklist::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'teamid' => $this->teamid,
            'userid' => $this->userid,
        ]);
	
	if($this->is_accepted)
	$query->andFilterWhere(['=', 'is_accepted', $this->is_accepted]);

        $query->andFilterWhere(['like', 'url_publicIdentifier', $this->url_publicIdentifier])
            ->andFilterWhere(['like', 'type', $this->type])->andFilterWhere(['userid'=>\Yii::$app->session->get('userid')])->andWhere(['deleted_at'=>NULL]);

        return $dataProvider;
    }
}
