
<?php

use yii\helpers;
use yii\helpers\Html;

$t = time() - (7 * 24 * 60 * 60);
$char_len = 30;
?>
<!DOCTYPE html>
<html>
    <head>
        <title>Summary Report of Last 7 Days</title>
        <meta charset="utf-8">
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link href="https://fonts.googleapis.com/css?family=Open+Sans" rel="stylesheet">
        <link href="https://afeld.github.io/emoji-css/emoji.css" rel="stylesheet">

        <style>
            a {background-color: transparent;}
            a:active,a:hover {outline: 0;}
            * {-webkit-box-sizing: border-box;-moz-box-sizing: border-box;box-sizing: border-box;}
            *:before,*:after {-webkit-box-sizing: border-box;-moz-box-sizing: border-box;box-sizing: border-box;}
            html {font-size: 10px;-webkit-tap-highlight-color: rgba(0, 0, 0, 0);}
            body {font-family: 'Open Sans', sans-serif;font-size: 14px;line-height: 1.42857143;color: #333;margin: 0;}
            img {vertical-align: middle;border: 0;}
            .text-center {text-align: center;}
            .container {margin-right: auto;margin-left: auto;padding-top: 30px;padding-bottom: 30px;}
            table {border-spacing: 0;border-collapse: collapse;}
            td,th {padding: 0;}
            .table {width: 100%;max-width: 100%;margin-bottom: 20px;}
            .table > thead > tr > th,.table > tbody > tr > th,.table > tfoot > tr > th,.table > thead > tr > td,.table > tbody > tr > td,.table > tfoot > tr > td {padding: 8px;line-height: 1.42857143;vertical-align: top;border-top: 1px solid #ddd;}
            .table > thead > tr > th {vertical-align: bottom;border-bottom: 2px solid #ddd;}
            .table > caption + thead > tr:first-child > th,.table > colgroup + thead > tr:first-child > th,.table > thead:first-child > tr:first-child > th,.table > caption + thead > tr:first-child > td,.table > colgroup + thead > tr:first-child > td,.table > thead:first-child > tr:first-child > td {border-top: 0;}
            .table .table {background-color: #fff;}
            .table-hover > tbody > tr:hover {background-color: #f5f5f5;}
            table col[class*="col-"] {position: static;display: table-column;float: none;}
            table td[class*="col-"],table th[class*="col-"] {position: static;display: table-cell;float: none;}
            .table-responsive {padding-right: 20px;padding-left: 20px;}
            .table-bordered {border: 1px solid #aaa;}
            .table-bordered > thead > tr > th,.table-bordered > tbody > tr > th,.table-bordered > tfoot > tr > th,.table-bordered > thead > tr > td,.table-bordered > tbody > tr > td,.table-bordered > tfoot > tr > td {border: 1px solid #aaa;}
            .table-bordered > thead > tr > th,.table-bordered > thead > tr > td {border-bottom-width: 1px;}
            .h_label,.admin_email_tr{ display: none; }
            @media all and (max-width: 599px) {
                .table > tbody > tr > td{ padding: 6px;}
                .h_label{ display: inline-block;float: left;font-weight: bold;width: 130px;text-align: left; }
                .smarttable {
                    border: 0px;
                    margin-bottom: 0 !important;
                    box-shadow: none !important;
                    margin: 10px auto !important;
                }
                .user_table.smarttable td{ border: 1px solid #aaa; }
                .user_table.smarttable tr{ background-color: #d9edf7; }
                /*.smarttable tbody tr:nth-of-type(odd) { background-color: rgba(0,0,0,.05); }*/
                .smarttable thead {
                    display:none;
                    border: none;
                    height: 0px;
                    margin: 0px;
                    overflow: hidden;
                    padding: 0px;
                    max-width:0px;
                    max-height:0px;
                }
                .smarttable tr {
                    display: block;
                    width:100%;
                    margin:10px auto;
                }
                .row_cls{ background-color: #d9edf7; }
                .header_table.smarttable td{ text-align: center !important;border: 0 !important; }
                .footer_table.smarttable td{ text-align: center !important;border: 0 !important; }
                .smarttable .hotspot_td {
                    text-align: center !important;background-color: #eee; 
                }
                .smarttable td {
                    display: block;
                    font-size: 13px;
                    text-align: right !important;
                }
            }/*
            .header_table{ background-color: #00507e; }*/
            /*.footer_table{ background-color: #f6f6f6; }*/
            .footer_table{ margin-top: 30px; }
            .footer_table td{color: #aeaeae;font-size: 12px;padding-top: 14px;border-top: 0 !important; }
            .footer_table td a,.footer_table td a:focus,.footer_table td a:hover{color: #000;text-decoration: underline; }
            .header-logo{ width: 250px;margin-bottom: 20px; }
            .header_table td{ padding: 10px 0;color: #3a3b3c;font-size: 15px; }
            .header_table span{ font-size: 18px;font-weight: 800; }
            .user_table{ width: 90%;margin: 25px auto;box-shadow: 1px 1px 4px 1px #aaa; }
            .user_table th{ background-color: #d9edf7;border-bottom: 0 !important; }
            .user_table td{ text-align: center;padding-right: 15px;padding-left: 15px; }
            .seq_table{ width: 90%;margin: 25px auto;box-shadow: 1px 1px 4px 1px #aaa; }
            .seq_table th{ background-color: #d9edf7;border-bottom: 0 !important; }
            .seq_table td{ text-align: center;font-size: 13px; }
            .seq_table .act_sts{ background-color: #4caf50;color: #ffffff;font-size: 13px;padding: 4px 8px;border-radius: 7px; }
            .seq_table .pause_sts{ background-color: #f26522;color: #ffffff;font-size: 13px;padding: 4px 8px;border-radius: 7px; }
            .hotspot_cls{ font-weight: bold;font-size: 15px; }
            .seq_table .admin_email { font-size: 14px;text-align: center !important; }
            .title_cls{ font-weight: bold;color: #235983;}
            .mail_body{ background-color: #fff;width: 85%;margin: 0 auto; margin-top: 10px;border-radius: 10px; }
        </style>
    </head>
    <body style="background-color: #f4f4f4;">
        <div class="container">
            <div class="mail_body">
                <table class="table header_table smarttable" width="100%" cellspacing="0" cellpadding="0" style="min-width:100%;">
                    <tr>
                        <td align="center">
                            <?php
                            if ($GLOBALS['sitelogo'] == '') {
                                echo $GLOBALS['sitetitle'];
                            } else {
                                ?><img src="<?php echo $GLOBALS['sitelogo']; ?>" class="header-logo"><?php } ?><br/>
                            <?php if (isset($value)) { ?>
                                <p style="font-size: 25px;margin: 0 0 5px 0;font-weight: 800;">Weekly Summary Report</p><span><?php echo date('l', strtotime(date('d-m-Y', $t))) . ', ' . date('F jS', $t) . ' - ' . date('l') . ', ' . date('F jS'); ?></span>

                            <?php } else { ?>
                                <p style="font-size: 25px;margin: 0 0 5px 0;font-weight: 800;">Weekly Team Summary Report</p><span><?php echo date('l', strtotime(date('d-m-Y', $t))) . ', ' . date('F jS', $t) . ' - ' . date('l') . ', ' . date('F jS'); ?></span>
                            <?php } ?>
                        </td>
                    </tr>
                </table>

                <?php
                //echo "<pre>";print_r($value);die; 
                if (isset($value)) {
                    ?>
                    <div class="table-responsive">
                        <?php
                        $totl_acc_per = 0;
                        $totl_acc_per = (100 * $value['ACCEPTED']) / $value['SENT'];
                        $totl_acc_per = round($totl_acc_per);
                        ?>
                        <p style="font-size: 15px;">Hope you had a good Weekend 🙂! Here is your summary of what happened on your account last week. <br/> Your account reached out to total of <b><?= $value['SENT'] ?> Prospects</b> last week. Of that <b><?= $totl_acc_per ?>% Accepted</b> the Invite to connect. <?php  echo $GLOBALS['sitetitle']; ?> Performed <b><?php echo $value['PERFORMED']; ?></b> Actions  on LinkedIn on your behalf.</p>
                        <!-- <span class="title_cls">Detailed Summary</span> -->
                        <table class="table user_table table-bordered smarttable" width="100%" cellspacing="0" cellpadding="0" style="min-width:100%;margin-top: 5px;">
                            <thead>
                                <tr>
                                    <th class="text-center">Name</th>
                                    <th class="text-center">Email ID</th>
                                    <th class="text-center">Task Performed</th>
                                    <th class="text-center">Requests Sent</th>
                                    <th class="text-center">Accepted Requests</th>
                                    <th class="text-center">Responses Received</th>
                                    <th class="text-center">Requests Withdrawn</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <?php
                                    $a_name = $value['first_name'] . ' ' . $value['last_name'];

                                    if ($value['ACCEPTED'] != 0) {
                                        $acceptedPercent = "(" . round($value['ACCEPTED'] / $value['SENT'] * 100) . "%)";
                                    } else {
                                        $acceptedPercent = "";
                                    }
                                    if ($value['RESPONDED'] != 0) {
                                        $respondedPercent = "(" . round($value['RESPONDED'] / $value['SENT'] * 100) . "%)";
                                    } else {
                                        $respondedPercent = "";
                                    }
                                    ?>
                                    <td><span class="h_label">Name</span><?= (strlen($a_name) > $char_len) ? substr($a_name, 0, $char_len) . '...' : $a_name ?></td>
                                    <td><span class="h_label">Email ID</span><?= (strlen($value['email']) > $char_len) ? substr($value['email'], 0, $char_len) . '...' : $value['email'] ?></td>
                                    <td><span class="h_label">Task Performed</span><?= $value['PERFORMED'] ?></td>
                                    <td><span class="h_label">Requests Sent</span><?= $value['SENT'] ?></td>
                                    <td><span class="h_label">Accepted Requests</span><?= $value['ACCEPTED'] . $acceptedPercent ?></td>
                                    <td><span class="h_label">Responses Received</span><?= $value['RESPONDED'] . $respondedPercent ?></td>
                                    <td><span class="h_label">Requests Withdrawn</span><?= $value['WITHDRAWN'] ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <div class="table-responsive">
                        <table class="table seq_table table-bordered smarttable" width="100%" cellspacing="0" cellpadding="0" style="min-width:100%;">
                            <thead>
                                <tr>
                                    <th class="text-center">#</th>
                                    <th class="text-center">Sequence Name</th>
                                    <th class="text-center">Status</th>
                                    <th class="text-center">Request Sent</th>
                                    <th class="text-center">Accepted</th>
                                    <th class="text-center">Total Response</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 1;
                                foreach ($value as $key => $val) {
                                    if (is_int($key)) {
                                        ?>
                                        <tr>
                                            <?php
                                            echo "<td class='row_cls' scope='row' data-label='$i'><span class='h_label'>#</span>" . $i++ . "</td>";
                                            foreach ($val as $key1 => $val1) {
                                                $cls = '';

                                                if ($key1 == 'ACCEPTED' && $val1 > 0) {
                                                    $seq_accept = $val1;
                                                }

                                                if ($key1 == "STATUS") {

                                                    if ($val1 == 'Active') {
                                                        $val1 = '<span class="act_sts">Active</span>';
                                                    } elseif ($val1 == 'Paused') {
                                                        $val1 = '<span class="pause_sts">Paused</span>';
                                                    }
                                                }

                                                if ($key1 == "SEQUENCE_NAME") {
                                                    $val1 = (strlen($val1) > $char_len) ? substr($val1, 0, $char_len) . '...' : $val1;
                                                }

                                                if ($key1 == "TOTAL_RESPONSE" && $val1 > 0) {
                                                    /* $val1 = json_decode($val1,true);
                                                      if (json_last_error() == 0 && isset($val1['response_count'])) {
                                                      $val1 =$val1['response_count'];
                                                      }
                                                      else
                                                      $val1 = '0'; */                                                    
                                                    $res_per = 0;
                                                    $res_per = (100 * $val1) / $seq_accept;
                                                    $val1 = $val1 . " (" . round($res_per) . "%)";
                                                }

                                                if ($key1 == "USER_ID" || $key1 == "SEQ_ID")
                                                    continue;
                                                else {
                                                    if ($key1 == 'REQUEST_SENT') {
                                                        $req_sent = $val1;
                                                    }
                                                    if ($key1 == 'ACCEPTED' && $val1 > 0) {
                                                        $acc_per = 0;
                                                        $acc_per = (100 * $val1) / $req_sent;
                                                        $val1 = $val1 . " (" . round($acc_per) . "%)";
                                                    }
                                                    $label = ucwords(str_replace('_', " ", strtolower($key1)));

                                                    echo "<td data-label='$val1'><span class='h_label'>$label</span>$val1</td>";
                                                }
                                            }
                                            echo "</tr>";
                                        }
                                    }
                                    ?>

                            </tbody>
                        </table>
                    </div>
                    <?php
                } elseif (isset($team_admin)) {

                    $t_sent = 0;
                    $t_acc = 0;
                    $t_acc_per = 0;
                    foreach ($team_admin as $t_key => $t_val) {
                        if (is_int($t_key)) {
                            foreach ($t_val as $t_key1 => $t_value) {
                                if ($t_key1 == 'SENT' && $t_value > 0) {
                                    $t_sent += $t_value;
                                } elseif ($t_key1 == 'ACCEPTED' && $t_value > 0) {
                                    $t_acc += $t_value;
                                }
                            }
                        }
                    }

                    if ($t_acc > 0) {
                        $t_acc_per = round((100 * $t_acc) / $t_sent);
                    }
                    ?>
                    <div class="table-responsive">
                        <p style="font-size: 15px;">Hope you had a good Weekend 🙂! Here is your summary of what happened on your team last week. <br/> Your team reached out to total of <b><?= $t_sent ?> Prospects</b> last week. Of that <b><?= $t_acc_per ?>% Accepted</b> the Invite to connect.</p>
                        <table class="table seq_table table-bordered smarttable" width="100%" cellspacing="0" cellpadding="0" style="min-width:100%;">
                            <thead>
                                <tr>
                                    <td colspan="7" class="admin_email"><b>Admin Email:&nbsp;</b><?php echo $team_admin['email'] ?></td>
                                </tr>
                                <tr>
                                    <th class="text-center">#</th>
                                    <th class="text-center">First Name</th>
                                    <th class="text-center">Last Name</th>
                                    <th class="text-center">Sent</th>
                                    <th class="text-center">Accepted</th>
                                    <th class="text-center">Response</th>
                                    <th class="text-center">Email</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="admin_email_tr">
                                    <td colspan="7" class="admin_email"><b>Admin Email:&nbsp;</b><?php echo $team_admin['email'] ?></td>
                                </tr>
                                <?php
                                $i = 1;
                                foreach ($team_admin as $key => $val) {
                                    if (is_int($key)) {
                                        ?><tr>
                                        <?php
                                            echo "<td scope='row' data-label='$i' class='text-center row_cls'><span class='h_label'>#</span>" . $i++ . "</td>";
                                            unset($val['TEAM_ID']);
                                            foreach ($val as $key1 => $value) {
                                                if ($key1 == 'id') {
                                                    continue;
                                                } else {
                                                    if ($key1 == 'SENT') {
                                                        $req_sent = $value;
                                                    } elseif ($key1 == 'email' || $key1 == 'first_name' || $key1 == 'last_name') {
                                                        $value = (strlen($value) > $char_len) ? substr($value, 0, $char_len) . '...' : $value;
                                                    } elseif ($key1 == 'ACCEPTED' && $value > 0) {
                                                        $acc_per = 0;
                                                        $acc_per = (100 * $value) / $req_sent;
                                                        $value = $value . " (" . round($acc_per) . "%)";
                                                    } elseif ($key1 == 'RESPONSE' && $value > 0) {
                                                        $resp_per = 0;
                                                        $resp_per = (100 * $value) / $req_sent;
                                                        $value = $value . " (" . round($resp_per) . "%)";
                                                    }
                                                    $label = ucwords(str_replace('_', " ", strtolower($key1)));
                                                    echo "<td data-label='$key1' class='text-center;'><span class='h_label'>$label</span>" . $value . "</td>";
                                                }
                                            }
                                            echo "</tr>";
                                        }
                                    }
                                    ?>
                                    <!-- tr>
                                        <td colspan="6" class="text-center hotspot_td"><?php /* if($team_admin['intigration_status']==1){
                                  echo "<span class='hotspot_cls'>Hubspot Connected</span>";
                                  }
                                  else{
                                  echo "<span class='hotspot_cls'>Not Using Hubspot</span>";
                                  } */ ?>
                                        </td>
                                    </tr> -->
                            </tbody>
                        </table>
                    </div>
                <?php } ?>
                <table class="table footer_table smarttable" width="100%" cellspacing="0" cellpadding="0" style="min-width:100%;">
                    <tr>
                        <td align="center" valign="middle">
                            <!--p>Responses may not match with actual count on LinkedIn. LinkedIn update effected leadconnect's count mechanism. Leadconnect was updated on 20-07-2019 which have solved this issue.</p-->
                            <p class="text-center">You're receiving this email because you opted in at our website. If you do NOT wish to receive these updates you can turn off "Weekly Reports" in the profile section.</p> 
                            <p>© 2020 <?php echo $GLOBALS['sitetitle']; ?>. - All Rights Reserved</p>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </body>
</html>
