<?php

namespace app\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\db\Query;

class ZohocrmController extends Controller {

    public $enableCsrfValidation = false;
//    private $CLIENT_ID = "1000.9XT53M3RB1M7CO9IV9F6Q3ZHAQZZOX";
//    private $CLIENT_SECRET = "787751935d46d2342987e3102c3656be1fd616e901";

    private $CLIENT_ID = "1000.Z18RR3S288AKUH4HQB32XSTVBS8WVC";
    private $CLIENT_SECRET = "97917e323eab1e6271b20c559522471336cc9f090c";
    public $company_array = ["name" => "Name", "domain" => "Domain", "linkedin_company_page" => "Linkedin Company Page"];
    public $contact_array = ["job_title" => "Job Title", "first_name" => "First Name", "last_name" => "Last Name", "email" => "Email", "linkedin_uid" => "Linkedin Uid", "linkedin" => "Linkedin",
        "contact_source" => "Contact Source", "contact_assigned_by" => "Contact Assigned By", "sequence_name" => "Sequence Name", "account_id" => "Account Id",
        "org_id" => "Org Id", "phone" => "Phone"];

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions() {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    //Developed by Dharmesh Tandel
    /**
     * Displays homepage.
     *
     * @return string
     */
    public function beforeAction($action) {
        if (empty(Yii::$app->session->get('userid'))) {
            $loginUrl = Yii::$app->request->baseUrl . "/login";
            return $this->redirect($loginUrl);
        }
        return parent::beforeAction($action);
    }

    public function actionIndex() {

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }
        $userid = Yii::$app->session->get('userid');


        $TokenData = Yii::$app->db->createCommand("select  zc_instance_url, zc_access_token, zc_status  from  crm_token where user_id=" . $userid)->queryOne();


        if (!empty($TokenData['zc_access_token'])) {
            if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'edit') {

                $access_token = $TokenData['zc_access_token'];
                $instance_url = $TokenData['zc_instance_url'];

                $is_expire = $this->is_token_expired($instance_url, $access_token);
                
                if ($is_expire) {
                    $userid = Yii::$app->session->get('userid');
                    $TokenData = Yii::$app->db->createCommand("select  *  from  crm_token where user_id=" . $userid)->queryOne();
                    $result = $this->regenerate_token($this->CLIENT_ID, $this->CLIENT_SECRET, $TokenData['zc_refresh_token'], $userid, $TokenData['zc_instance_url']);

                    $access_token = $result;
                }


                /*
                  $is_valid_token = $this->is_valid_token($api_key, $api_url);
                  if(!$is_valid_token){


                  return $this->render('index', [
                  'contactRow' => '',
                  'companyRow' => '',
                  'contactfieldsCloseIo' => '',
                  'contactFieldsPortal' => '',
                  'companyfieldsCloseIo' => '',
                  'companyFieldsPortal' => '',
                  'loggedin' => true,
                  'TokenData' => $TokenData,
                  ]);

                  }
                 */


                $MapingData = Yii::$app->db->createCommand("select  mapping_fileds  from  crm_field_mapping where crm_name='zohocrm' and user_id=" . $userid)->queryOne();




                $UserFields = json_decode($MapingData['mapping_fileds'], true);




                $contactRow = $UserFields['contact'];


                $companyRow = $UserFields['company'];



                $sobj = "Contacts";
                $contactfieldsCloseIo = $this->get_custom_fields($sobj, $access_token, $instance_url);




                $sobj = "Accounts";
                $companyfieldsCloseIo = $this->get_custom_fields($sobj, $access_token, $instance_url);

                $loggedin = true;
            } else {
                $contactRow = "";
                $companyRow = "";
                $contactfieldsCloseIo = "";
                $companyfieldsCloseIo = "";
                $loggedin = true;
            }
        } else {
            $contactRow = "";
            $companyRow = "";
            $contactfieldsCloseIo = "";
            $companyfieldsCloseIo = "";
            $loggedin = false;
        }



        return $this->render('index', [
                    'contactRow' => $contactRow,
                    'companyRow' => $companyRow,
                    'contactfieldsCloseIo' => $contactfieldsCloseIo,
                    'contactFieldsPortal' => $this->contact_array,
                    'companyfieldsCloseIo' => $companyfieldsCloseIo,
                    'companyFieldsPortal' => $this->company_array,
                    'loggedin' => $loggedin,
                    'TokenData' => $TokenData,
        ]);
    }

    public function actionAddfield() {


        $userid = Yii::$app->session->get('userid');
        $formData = $_REQUEST;

        $finalArr = array();

        $closeIoFields_contact = $formData['selContactProperty'];
        $portalFields_contact = $formData['selContactFormat'];
        $contactArr = array_combine($closeIoFields_contact, $portalFields_contact);
        $finalArr['contact'] = [];
        foreach ($contactArr as $key => $value) {
            if (!empty($key) && !empty($value)) {
                $finalArr['contact'][$key] = $value;
            }
        }

        $closeIoFields_company = $formData['selCompanyProperty'];
        $portalFields_company = $formData['selCompanyFormat'];
        $companyArr = array_combine($closeIoFields_company, $portalFields_company);

        //$finalArr['company'] = $companyArr;

        $finalArr['company'] = [];
        foreach ($companyArr as $key => $value) {
            if (!empty($key) && !empty($value)) {
                $finalArr['company'][$key] = $value;
            }
        }

        $maping_fileds = json_encode($finalArr);

        $MappingDetail = Yii::$app->db->createCommand("select  *  from  crm_field_mapping where user_id=" . $userid)->queryOne();
        if (empty($MappingDetail)) {

            $result = Yii::$app->db->createCommand("INSERT INTO `crm_field_mapping`(`crm_name`,`user_id`,`mapping_fileds`) VALUES ('zohocrm','" . $userid . "','" . $maping_fileds . "')")->execute();
        } else {

            $result = Yii::$app->db->createCommand("UPDATE `crm_field_mapping` SET `mapping_fileds`='" . $maping_fileds . "' WHERE  `user_id`='" . $userid . "' and crm_name='zohocrm'")->execute();
            $result = 1;
        }

        $response = array("status" => false, "message" => "Error in updating mapping data.");
        if ($result) {
            $response = array("status" => true, "message" => "Mapping data updated successfully.");
        }

        return json_encode($response);
    }

    public function actionUpdatestatus() {


        $userid = Yii::$app->session->get('userid');
        $formData = $_REQUEST;
        $status = $formData['id'];
        $result = Yii::$app->db->createCommand("UPDATE `crm_token` SET `zc_status`='" . $status . "' WHERE  `user_id`='" . $userid . "'")->execute();

        $result = 1;

        $response = array("status" => false, "message" => "Error in updating status.");
        if ($result) {
            $response = array("status" => true, "message" => "Status updated successfully.");
        }
        return json_encode($response);
    }

	public function actionUpdatesftype() { 


        $userid = Yii::$app->session->get('userid');
        $formData = $_REQUEST;
        $status = $formData['id'];
        $result = Yii::$app->db->createCommand("UPDATE `crm_token` SET `sf_contact_type`='" . $status . "' WHERE  `user_id`='" . $userid . "'")->execute();

        $result = 1;

        $response = array("status" => false, "message" => "Error in updating status.");
        if ($result) {
            $response = array("status" => true, "message" => "Status updated successfully.");
        }
        return json_encode($response);
    }

    public function actionSaveapikey() {
        /*
          $response = array("status" => true, "message" => "Api key updated successfully.");

          $userid = Yii::$app->session->get('userid');
          $formData = $_REQUEST;
          $api_key = $formData['api_key'];

          $is_valid_token = $this->is_valid_token($api_key);
          if(isset($is_valid_token['error'])){

          $response = array("status" => false, "message" => "Invalid api key or api key is expired.");
          return json_encode($response);

          }


          $default_data = array("contact" => array("TITLE" => "job_title","FIRST_NAME" => "first_name","LAST_NAME" => "last_name", "EMAIL_ADDRESS" => "email", "PHONE" => "phone",  "SOCIAL_LINKEDIN" => "linkedin"), "company" => array("ORGANISATION_NAME" => "name", "WEBSITE" => "domain", "SOCIAL_LINKEDIN" => "linkedin_company_page"));


          $custom_contact_fields = array( "LINKEDIN_UID" => "Linkedin Uid", "CONTACT_SOURCE" => "Contact Source", "CONTACT_ASSIGNED_BY" => "Contact Assigned By", "SEQUENCE_NAME" => "Sequence Name", "ACCOUNT_ID" => "Account Id", "ORG_ID" => "Org Id");

          if ($this->is_user_exist_in_token_table($userid)) {


          $result = Yii::$app->db->createCommand("UPDATE `crm_token` SET `insightly_api_key`='" . $api_key . "' WHERE  `user_id`='" . $userid . "'")->execute();
          $response = array("status" => true, "message" => "Api key updated successfully.");


          $all_custom_fields =$this->get_all_custom_fields('Contacts', $api_key, $api_url);

          if (!$this->is_mapping_data_exist($userid)) {
          foreach ($custom_contact_fields as $cKey => $ctm_data) {
          $temp_id = array_search($ctm_data,$all_custom_fields);
          if(!$temp_id){
          //$cfId = $this->create_custom_field('Contact', $ctm_data, 'text', $api_key);
          }else
          {
          $cfId = $temp_id;
          }

          if (isset($cfId) && !empty($cfId)) {
          $default_data['contact'][$cfId] = $cKey;
          }
          }
          $default_data = json_encode($default_data);
          $sqlInsertFields = Yii::$app->db->createCommand("INSERT INTO `crm_field_mapping`(`crm_name`,`user_id`,`mapping_fileds`) VALUES ('zohocrm','" . $userid . "','" . $default_data . "')")->execute();
          }


          return json_encode($response);
          }else
          {



          $result = Yii::$app->db->createCommand("INSERT INTO `crm_token`(`user_id`,`insightly_api_key`,`insightly_status`) VALUES ('" . $userid . "','" . $api_key . "','1')")->execute();
          $all_custom_fields =$this->get_all_custom_fields('Contact', $api_key);

          if ($result) {
          foreach ($custom_contact_fields as $cKey => $ctm_data) {
          $temp_id = array_search($ctm_data,$all_custom_fields);
          if(!$temp_id){
          $cfId = $this->create_custom_field('contact', $ctm_data, 'text', $api_key);
          }else
          {
          $cfId = $temp_id;
          }

          if (isset($cfId) && !empty($cfId)) {
          $default_data['contact'][$cfId] = $cKey;
          }
          }


          $default_data = json_encode($default_data);



          $sqlInsertFields = Yii::$app->db->createCommand("INSERT INTO `crm_field_mapping`(`crm_name`,`user_id`,`mapping_fileds`) VALUES ('insightly','" . $userid . "','" . $default_data . "')")->execute();
          }




          //return $result;

          $response = array("status" => false, "message" => "Error in updating Api key.");
          if ($result) {
          $response = array("status" => true, "message" => "Api key updated successfully.");
          }
          return json_encode($response);
          }
         */
    }

    function get_custom_fields($sobj, $api_key, $api_url) {
        /*
          $company_array = array(array("name" => "Account_Name", "label" => "Name"), array("name" => "Website", "label" => "Domain"), array("name" => "Description", "label" => "Linkedin Url"));
          $contact_array = array(array("name" => "Title", "label" => "Title"),array("name" => "First_Name", "label" => "First Name"), array("name" => "Last_Name", "label" => "Last Name"), array("name" => "Email", "label" => "Email"), array("name" => "Phone", "label" => "Phone"), array("name" => "Description", "label" => "Linkedin")); */

        $company_array = array(array("name" => "Account_Name", "label" => "Account Name"), array("name" => "Website", "label" => "Website"), array("name" => "Description", "label" => "Description"));
        $contact_array = array(array("name" => "Title", "label" => "Title"), array("name" => "First_Name", "label" => "First Name"), array("name" => "Last_Name", "label" => "Last Name"), array("name" => "Email", "label" => "Email"), array("name" => "Phone", "label" => "Phone"), array("name" => "Description", "label" => "Linkedin"));
        $dataArray = [];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url . "/crm/v2/settings/fields?module=" . $sobj);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 0);
        $headers = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'X-Http-Method-Override: GET';
        $headers[] = 'Authorization: Zoho-oauthtoken ' . $api_key;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $datas = curl_exec($ch);
        curl_close($ch);

        $datas = json_decode($datas, true);
        //print_r($datas); exit;


        if (isset($datas['fields']) && !empty($datas['fields'])) {
            foreach ($datas['fields'] as $key => $data) {

                if (isset($data['field_label']) && $data['field_label'] != '' && $data['custom_field'] == true) {
                    switch ($sobj) {
                        case "Accounts":
                            $company_array[] = array("name" => $data['field_label'], "label" => $data['display_label'], "is_custom" => true);
                            break;
                        case "Contacts":
                            $contact_array[] = array("name" => $data['field_label'], "label" => $data['display_label'], "is_custom" => true);
                            break;
                    }
                }
            }
        }

        if ($sobj == 'Contacts') {
            return $contact_array;
        }

        if ($sobj == 'Accounts') {
            return $company_array;
        }
    }

    public function actionAddcontactrow() {
        $userid = Yii::$app->session->get('userid');

        $TokenData = Yii::$app->db->createCommand("select  *  from  crm_token where user_id=" . $userid)->queryOne();
        $mappingFieldData = Yii::$app->db->createCommand("select  mapping_fileds  from  crm_field_mapping where crm_name='zohocrm' and user_id=" . $userid)->queryOne();
        $mappingFileds = json_decode($mappingFieldData['mapping_fileds'], true);


        $api_key = $TokenData['zc_access_token'];
        $api_url = $TokenData['zc_instance_url'];


        $sobj = "Contacts";
        $ContactfieldsCloseIo = $this->get_custom_fields($sobj, $api_key, $api_url);




        $contactFieldsPortal = $this->contact_array;
        $html = '<tr class="contactRowNumber_1">
                    <td>
                        <select name="selContactProperty[]" class="select2 form-control contactFieldSelect" style="width: 300px;" data-group="Contact" data-width="fit"><option  value="" >Select Field</option>';
        foreach ($ContactfieldsCloseIo as $contactfields) {
            $disabeled = "";

            if (array_key_exists($contactfields['name'], $mappingFileds['contact'])) {
                $disabeled = "disabled";
            }
            $html .= '<option  value="' . $contactfields['name'] . '" ' . $disabeled . '>' . $contactfields['label'] . '</option>';
        }
        $html .= '</select></td>';
        $html .= '<td>
                    <select class="select2 form-control" name="selContactFormat[]"><option  value="" >Select Field</option>';
        foreach ($contactFieldsPortal as $key => $value) {
            $html .= '<option value="' . $key . '" >' . $value . '</option>';
        }
        $html .= '</select>
                    </td>
                    <td>
                    <span><i class="bx bxs-trash deleteRow" title="This property can not be edited or deleted."></i></span>
                    </td>
                    </tr>';
        echo $html;
        exit;
    }

    public function actionAddcompanyrow() {
        $userid = Yii::$app->session->get('userid');

        $TokenData = Yii::$app->db->createCommand("select  *  from  crm_token where user_id=" . $userid)->queryOne();
        //print_r($TokenData); exit;
        $mappingFieldData = Yii::$app->db->createCommand("select  mapping_fileds  from  crm_field_mapping where crm_name='zohocrm' and user_id=" . $userid)->queryOne();

        $mappingFileds = json_decode($mappingFieldData['mapping_fileds'], true);

        $api_key = $TokenData['zc_access_token'];
        $api_url = $TokenData['zc_instance_url'];
        $sobj = "Accounts";
        $CompanyfieldsCloseIo = $this->get_custom_fields($sobj, $api_key, $api_url);
        $companyFieldsPortal = $this->company_array;

        $html = '<tr class="companyRowNumber_1">
                    <td>
                        <select name="selCompanyProperty[]" class="select2 form-control" style="width: 300px;" data-group="Company" data-width="fit"><option  value="" >Select Field</option>';
        foreach ($CompanyfieldsCloseIo as $companyfields) {
            $disabeled = "";
            if (array_key_exists($companyfields['name'], $mappingFileds['company'])) {
                $disabeled = "disabled";
            }
            $html .= '<option  value="' . $companyfields['name'] . '" ' . $disabeled . '>' . $companyfields['label'] . '</option>';
        }
        $html .= '</select></td>';
        $html .= '<td>
                    <select class="select2 form-control" name="selCompanyFormat[]"><option  value="" >Select Field</option>';
        foreach ($companyFieldsPortal as $key => $value) {
            $html .= '<option value="' . $key . '" >' . $value . '</option>';
        }
        $html .= '</select>
                    </td>
                        <td>
                            <span><i class="bx bxs-trash deleteRow" title="This property can not be edited or deleted."></i></span>
                        </td>
                </tr>';
        echo $html;
        exit;
    }

    public function actionDisconnectzoho() {
        $userid = Yii::$app->session->get('userid');
        $result = Yii::$app->db->createCommand("UPDATE `crm_token` SET  `zc_access_token` = '', `zc_refresh_token`='',`zc_instance_url`='',`zc_token_type`='', `zc_status` = '0' WHERE  `user_id`='" . $userid . "'")->execute();
        if ($result) {
            //$delete = Yii::$app->db->createCommand("DELETE from crm_field_mapping WHERE  `user_id`='" . $userid . "'")->execute();
            return true;
        } else {
            return false;
        }
    }

    function is_mapping_data_exist($uid) {
        $result = Yii::$app->db->createCommand("select id from crm_field_mapping where crm_name='zohocrm' AND user_id=" . $uid)->queryOne();
        if ($result) {
            return true;
        } else {
            return false;
        }
        /*
          $sql1 = "select id from crm_field_mapping where crm_name='insightly' AND user_id=".$uid." limit 1";
          $result1 = $conn->query($sql1);

          return $result1->num_rows;
         */
        //return false;
    }

    function is_user_exist_in_token_table($uid) {

        $result = Yii::$app->db->createCommand("select id from crm_token where user_id=" . $uid)->queryOne();
        if (isset($result['id']) && !empty($result['id'])) {
            return true;
        } else {
            return false;
        }
    }

    function create_default_activity_and_fields($api_key) {

        $data = ["name" => "Linkedin Message", "description" => "Linkedin Message", "api_create_only" => false];

        $data = json_encode($data);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.close.com/api/v1/custom_activity/');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_USERPWD, $api_key);

        $headers = array();
        $headers[] = 'Content-Type: application/json';
        //$headers[] = 'X-Http-Method-Override: GET';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $json_response = curl_exec($ch);
        $response = json_decode($json_response, true);

        if (curl_errno($ch)) {
            //return curl_errno($ch);	   
        }
        curl_close($ch);

        if ($response['id']) {

            $data = ["name" => "Linkedin Message", "type" => "text", "accepts_multiple_values" => false, "custom_activity_type_id" => $response['id']];
            $data = json_encode($data);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://api.close.com/api/v1/custom_field/activity/');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_USERPWD, $api_key);

            $headers = array();
            $headers[] = 'Content-Type: application/json';
            //$headers[] = 'X-Http-Method-Override: GET';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $json_response = curl_exec($ch);
            $response1 = json_decode($json_response, true);

            if (curl_errno($ch)) {
                //return curl_errno($ch);	   
            }
            curl_close($ch);

            $data = ["name" => "User Id", "type" => "text", "accepts_multiple_values" => false, "custom_activity_type_id" => $response['id']];

            $data = json_encode($data);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://api.close.com/api/v1/custom_field/activity/');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_USERPWD, $api_key);

            $headers = array();
            $headers[] = 'Content-Type: application/json';
            //$headers[] = 'X-Http-Method-Override: GET';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $json_response = curl_exec($ch);
            $response2 = json_decode($json_response, true);

            if (curl_errno($ch)) {
                //return curl_errno($ch);	   
            }
            curl_close($ch);

            $data = ["name" => "Lead Id", "type" => "text", "accepts_multiple_values" => false, "custom_activity_type_id" => $response['id']];
            //$data = json_encode($data);

            $data = json_encode($data);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://api.close.com/api/v1/custom_field/activity/');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_USERPWD, $api_key);

            $headers = array();
            $headers[] = 'Content-Type: application/json';
            //$headers[] = 'X-Http-Method-Override: GET';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $json_response = curl_exec($ch);
            $response2 = json_decode($json_response, true);

            if (curl_errno($ch)) {
                //return curl_errno($ch);	   
            }
            curl_close($ch);
        }
    }

    function create_custom_field($obj, $custom_field_name, $custom_field_type, $api_key) {
        if (isset($custom_field_name) && !empty($custom_field_name) && isset($custom_field_type) && !empty($custom_field_type)) {
            $data = array("name" => $custom_field_name, "type" => $custom_field_type);
            $data = json_encode($data);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://api.close.com/api/v1/custom_field/' . $obj . '/');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_USERPWD, $api_key);

            $headers = array();
            $headers[] = 'Content-Type: application/json';
            //$headers[] = 'X-Http-Method-Override: GET';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $json_response = curl_exec($ch);
            $response = json_decode($json_response, true);

            if (isset($response['id']) && !empty($response['id'])) {
                return $response['id'];
            }
            return false;
            //if (curl_errno($ch)) {
            //return curl_errno($ch);	   
            //}
            curl_close($ch);
        }
        return false;
    }

    function get_all_custom_fields($sobj, $api_key, $api_url) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url . "/crm/v2/settings/fields?module=" . $sobj);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 0);
        $headers = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'X-Http-Method-Override: GET';
        $headers[] = 'Authorization: Zoho-oauthtoken ' . $api_key;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $datas = curl_exec($ch);
        curl_close($ch);

        $datas = json_decode($datas, true);

        if (isset($datas['fields']) && !empty($datas['fields'])) {
            foreach ($datas['fields'] as $key => $data) {
                if (isset($data['field_label']) && $data['field_label'] != '' && $data['custom_field'] == true) {
                    switch ($sobj) {
                        case "Organisations":
                            $company_array[] = array("name" => $data['field_label'], "label" => $data['display_label'], "is_custom" => true);
                            break;
                        case "Contacts":
                            $contact_array[] = array("name" => $data['field_label'], "label" => $data['display_label'], "is_custom" => true);
                            break;
                    }
                }
            }
        }

        $finalArray = [];

        if (isset($datas['fields']) && !empty($datas['fields'])) {
            foreach ($datas['fields'] as $key => $data) {
                $finalArray[$data['field_label']] = $data['display_label'];
            }
        }
        return $finalArray;
    }

    function is_valid_token($api_key, $api_url) {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url . "/crm/v2/Contacts");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 0);
        $headers = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'X-Http-Method-Override: GET';
        $headers[] = 'Authorization: Zoho-oauthtoken ' . $api_key;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $datas = curl_exec($ch);
        curl_close($ch);

        $datas = json_decode($datas, true);

        if (isset($datas['code']) && $datas['code'] == "INVALID_TOKEN" && isset($datas['status']) && $datas['status'] == "error") {
            return false;
        }

        return true;
    }

    //----

    function regenerate_token($client_id, $client_secret, $refresh_token, $user_id, $instance_url) {
        $instance = explode(".", $instance_url);
        $dd = end($instance);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://accounts.zoho.' . $dd . '/oauth/v2/token');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=refresh_token&client_id=" . $client_id . "&client_secret=" . $client_secret . "&refresh_token=" . $refresh_token . "&format=json");

        $headers = array();
        $headers[] = 'Content-Type: application/x-www-form-urlencoded';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        $response = json_decode($result, true);        

        if (curl_errno($ch)) {

            return curl_error($ch);
        }

        curl_close($ch);


        if (isset($response['access_token']) && !empty($response['access_token'])) {

            if (Yii::$app->db->createCommand("UPDATE `crm_token` SET `zc_access_token` = '" . $response['access_token'] . "', `zc_token_type` = '" . $response['token_type'] . "', `zc_instance_url` = '" . $response['api_domain'] . "' WHERE `crm_token`.`user_id` = " . $user_id)->execute()) {

                return $response['access_token'];
            } else {
                return false;
            }
        }
    }

    function is_token_expired($instance_url, $access_token) {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $instance_url . "/crm/v2/Contacts");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 0);
        $headers = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'X-Http-Method-Override: GET';
        $headers[] = 'Authorization: Zoho-oauthtoken ' . $access_token;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $datas = curl_exec($ch);
        curl_close($ch);

        $datas = json_decode($datas, true);

        if (isset($datas['code']) && $datas['code'] == "INVALID_TOKEN" && isset($datas['status']) && $datas['status'] == "error") {
            return true;
        }

        return true;
    }

}
