<?php

namespace app\controllers;

use Yii;
use app\models\MyTemplateModel;
use app\models\User;
use app\models\MyTemplateSearchModel;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Blacklist;
use yii\data\Pagination;
use app\models\BlacklistSearch;
use yii\db\Query;

require '../vendor/autoload.php';

use Aws\S3\S3Client;
use Aws\DynamoDb\DynamoDbClient;
use Aws\Sqs\SqsClient;

//NR 30Apr2020 starts
include ('../phpseclib/vendor/autoload.php');
$loader = new \Composer\Autoload\ClassLoader();

use phpseclib\Net\SSH2;
use phpseclib\Crypt\RSA;

//NR 30Apr2020 ends
/**
 * MyTemplateController implements the CRUD actions for MyTemplateModel model.
 */
class TestingController extends Controller {

    /**
     * @inheritdoc
     */
    public $enableCsrfValidation = false;

    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

	public function actionIndex(){
		if (YII_ENV_PROD) {
			echo 'YII_ENV_PROD::'.YII_ENV_PROD;
		}
		if (YII_ENV_DEV) {
			echo 'YII_ENV_DEV::'.YII_ENV_DEV;
		}
		
	}  

	//actionTestingemail ends

    //06-07-2020
    public function actionAjxrefreshprofile() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $UserDetail = Yii::$app->db->createCommand("select  *  from  user  where id =" . Yii::$app->session->get('userid'))->queryOne();
        $proxyIp = $UserDetail['proxyIp'];
        $proxyPort = $UserDetail['proxyPort'];
        $proxyUsername = $UserDetail['proxyUsername'];
        $proxyPassword = $UserDetail['proxyPassword'];
        $userAgent = $UserDetail['userAgent'];
        $cookie = $UserDetail['cookie'];
        $csrf = $UserDetail['csrf'];
//echo 'sdfdfdf::<pre>'; print_r($UserDetail);die;
        $profileData = array();


        //06June2020 starts
        $profileData['pic_100_100'] = '';
        $profileData['pic_400_400'] = '';
        $apiRes_me = '';

        $profileData['numConnections'] = 0;
        $profileData['pendingConnections'] = 0;
        $profileData['numTotalSentInvitations'] = 0;


        $apiRes_IdentityProfilesProfileView = '';
        $apiRes_IdentityProfilesProfileContactInfo = '';
        //06June2020 ends



        if ($proxyIp && $proxyPort && $proxyUsername && $proxyPassword) {

            if (!empty($cookie) && !empty($csrf)) {
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/me",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $curlResult = curl_exec($curl);
                if (!empty($curlResult)) {
                    $apiRes_me = $decodedRes = json_decode($curlResult);
                    //echo 'C:<pre>'; print_r($decodedRes);
                    $picture = (array) $decodedRes->miniProfile->picture;
                    $profileData['pic_100_100'] = $picture['com.linkedin.common.VectorImage']->rootUrl . $picture['com.linkedin.common.VectorImage']->artifacts[0]->fileIdentifyingUrlPathSegment;
                    $profileData['pic_400_400'] = $picture['com.linkedin.common.VectorImage']->rootUrl . $picture['com.linkedin.common.VectorImage']->artifacts[2]->fileIdentifyingUrlPathSegment;
                    \Yii::$app->session->set('top_profile_pic', $profileData['pic_100_100']);
                } else {
                    $profileData['pic_100_100'] = '';
                    $profileData['pic_400_400'] = '';
                    $apiRes_me = '';
                }
            }


            if (!empty($cookie) && !empty($csrf)) {
                $curlConnectionDetails = curl_init();
                curl_setopt_array($curlConnectionDetails, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/relationships/connectionsSummary/",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $connectionDetailsRes = curl_exec($curlConnectionDetails);
                if (!empty($connectionDetailsRes)) {
                    $decodedJsonRes = json_decode($connectionDetailsRes);
                    //echo 'AA:<pre>'; print_r($decodedJsonRes);
                    $profileData['numConnections'] = $decodedJsonRes->numConnections;
                } else {
                    $profileData['numConnections'] = 0;
                }
                $curlInvitationDetails = curl_init();
                curl_setopt_array($curlInvitationDetails, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/relationships/invitationsSummaryV2?types=List(SENT_INVITATION_COUNT,PENDING_INVITATION_COUNT,UNSEEN_INVITATION_COUNT,PENDING_INVITATION_BY_FACET_COUNT)",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        /* "cookie: $cookie",
                          "csrf-token: $csrf",
                          "x-http-method-override: GET",
                          "Host: www.linkedin.com",
                          "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36",
                          "accept: application/vnd.linkedin.normalized+json+2.1",
                          "Accept-Language: en-US,en;q=0.5",
                          "Accept-Encoding: gzip, deflate, br",
                          //"content-type: application/x-www-form-urlencoded",
                          "x-li-lang: en_US",
                          "x-restli-protocol-version: 2.0.0",
                          "Origin: https://www.linkedin.com",
                          "TE: Trailers" */

                        "accept: application/vnd.linkedin.normalized+json+2.1",
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        //"x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "accept-language: en-US,en;q=0.9",
                        //"Accept-Encoding: gzip, deflate, br",
                        //"content-type: application/x-www-form-urlencoded",
                        "content-type: application/vnd.linkedin.normalized+json+2.1",
                        "x-li-lang: en_US",
                        //'x-li-track: {"clientVersion":"1.6.3394","osName":"web","timezoneOffset":5.5,"deviceFormFactor":"DESKTOP","mpName":"voyager-web","displayDensity":1}',
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                    //"TE: Trailers"						
                    ),
                ));
                $invitationDetailsRes = curl_exec($curlInvitationDetails);
                if (!empty($invitationDetailsRes)) {
                    $decodedJsonResInvDtls = json_decode($invitationDetailsRes);
                    $profileData['numTotalSentInvitations'] = $decodedJsonResInvDtls->data->numTotalSentInvitations;
                    $profileData['pendingConnections'] = $decodedJsonResInvDtls->data->numPendingInvitations;
                    //echo 'BBSDSD:<pre>'; print_r($decodedJsonResInvDtls);
                    //$profileData['pendingConnections'] = $decodedJsonResInvDtls->elements[1]->count;
                } else {
                    //$profileData['pendingConnections'] = 0;
                }
            }

echo '<pre>';print_r($apiRes_me);
echo '<br/>LINE:'. __LINE__ ."::dfdf".$apiRes_me->miniProfile->publicIdentifier;
            //NR starts
            if ($apiRes_me != '') {
                //$publicIdentifier = $apiRes_me->miniProfile->publicIdentifier;
                $publicIdentifier = 'ACoAAAWOpRIBTI_zRhAy6oi0ALjUXsWaXF6miT8';
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $publicIdentifier . "/profileView",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $curlResult = curl_exec($curl);
                //echo '<br/>LINE:'.__LINE__.':::'; echo $curlResult;
                $apiRes_IdentityProfilesProfileView = json_decode($curlResult);
                //echo 'C:<pre>';  print_r($apiRes_IdentityProfilesProfileView);
                curl_close($curl);
$publicIdentifier = $apiRes_me->miniProfile->publicIdentifier;
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $publicIdentifier . "/profileContactInfo",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $curlResult = curl_exec($curl);
                echo '<br/>LINE:'. __LINE__ .':::'; echo $curlResult;
                $apiRes_IdentityProfilesProfileContactInfo = json_decode($curlResult);
				//echo 'D:<pre>';  print_r($apiRes_IdentityProfilesProfileContactInfo);
                curl_close($curl);
            }
            //NR ends
        }
die;
        $final_result = array();
        $final_result['profileData'] = $profileData;



        $api_IPPV_profile_locationName = 'N/A';
        $api_IPPV_profile_summary_html = '<p>N/A</p>';
        if ($apiRes_IdentityProfilesProfileView != '') {
            if (isset($apiRes_IdentityProfilesProfileView->profile->locationName)) {
                $api_IPPV_profile_locationName = $apiRes_IdentityProfilesProfileView->profile->locationName;
            }

            if (isset($apiRes_IdentityProfilesProfileView->profile->summary)) {
                //01-07-2020:htmlentities added due to it was causing issue when summary contains html;
                if (strlen($apiRes_IdentityProfilesProfileView->profile->summary) > 325) {
                    $api_IPPV_profile_summary_html = '<p id="shortAbout">' . substr(htmlentities($apiRes_IdentityProfilesProfileView->profile->summary), 0, 325) . '... <a href="javascript:void(0);" id="aShortAbout">Read more</a></p>';
                    $api_IPPV_profile_summary_html .= '<p id="fullAbout" style="display:none;">' . htmlentities($apiRes_IdentityProfilesProfileView->profile->summary) . ' <a href="javascript:void(0);" id="aFullAbout">Read less</a></p>';
                } else {
                    $api_IPPV_profile_summary_html = '<p>' . htmlentities($apiRes_IdentityProfilesProfileView->profile->summary) . '</p>';
                }
            }
        }
        //print_r($api_IPPV_profile_summary_html); 
        $apiIPPCI_phoneNumbers = 'N/A';
        $apiIPPCI_emailAddress = 'N/A';
        if ($apiRes_IdentityProfilesProfileContactInfo != '') {
            if (isset($apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number)) {
                $apiIPPCI_phoneNumbers = $apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number;
            }

            if (isset($apiRes_IdentityProfilesProfileContactInfo->emailAddress)) {
                $apiIPPCI_emailAddress = $apiRes_IdentityProfilesProfileContactInfo->emailAddress;
            }
        }

        $api_me_miniProfile_Occupation = 'N/A';
        if ($apiRes_me != '') {
            if (isset($apiRes_me->miniProfile->occupation)) {
                $api_me_miniProfile_Occupation = $apiRes_me->miniProfile->occupation;
            }
        }

        $html_basicDetail = '';
        $html_basicDetail .= '<ul class="list-unstyled basicDetailsBlk">';
        $html_basicDetail .= '<li><i class="cursor-pointer bx bx-map mb-1 mr-50"></i>' . $api_IPPV_profile_locationName . '</li>';
        $html_basicDetail .= '<li><i class="cursor-pointer bx bx-phone-call mb-1 mr-50"></i>' . $apiIPPCI_phoneNumbers . '</li>';
        $html_basicDetail .= '<li><i class="cursor-pointer bx bx-envelope mb-1 mr-50"></i>' . $apiIPPCI_emailAddress . '</li></ul><div class="profilOccBlk"><h6><small class="text-muted">Occupation</small></h6><p>' . $api_me_miniProfile_Occupation . '</p></div>';
        //<div class="profileAbtBlk"><h6><small class="text-muted">About</small></h6>
        /* $api_IPPV_profile_summary_html = addslashes($api_IPPV_profile_summary_html);
          $api_IPPV_profile_summary_html = htmlspecialchars($api_IPPV_profile_summary_html); */
        //$html_basicDetail .= $api_IPPV_profile_summary_html;
        //$html_basicDetail .= '</div>'; 
        //print_r(htmlentities($html_basicDetail, NULL, 'UTF-8'));
        $final_result['html_basicDetail'] = $html_basicDetail;
        $final_result['apiRes_me'] = $apiRes_me;
        //print_r(json_encode($final_result,JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)); 
        //updating data starts
        $ProfilePic400_400 = $profileData['pic_400_400'];
        $pdNumConnections = $profileData['numConnections'];
        $pdPendingConnections = $profileData['pendingConnections'];
        $pdNumTotalSentInvitations = $profileData['numTotalSentInvitations'];

        $api_IPPV_profile_locationName = 'N/A';
        $api_IPPV_profile_summary_html = 'N/A'; //'<p>N/A</p>';
        if ($apiRes_IdentityProfilesProfileView != '') {
            if (isset($apiRes_IdentityProfilesProfileView->profile->locationName)) {
                $api_IPPV_profile_locationName = $apiRes_IdentityProfilesProfileView->profile->locationName;
            }

            if (isset($apiRes_IdentityProfilesProfileView->profile->summary)) {
                //01-07-2020:htmlentities added due to it was causing issue when summary contains html;
                $api_IPPV_profile_summary_html = htmlentities($apiRes_IdentityProfilesProfileView->profile->summary);
            }
        }
        $IPPV_profileLocationName = $api_IPPV_profile_locationName;
        //$IPPV_profileSummary = $api_IPPV_profile_summary_html;
        $IPPV_profileSummary = str_replace("'", "`", $api_IPPV_profile_summary_html); //07-July-2020

        $apiIPPCI_phoneNumbers = 'N/A';
        if ($apiRes_IdentityProfilesProfileContactInfo != '') {
            if (isset($apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number)) {
                $apiIPPCI_phoneNumbers = $apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number;
            }
        }
        $IPPCI_phoneNumber = $apiIPPCI_phoneNumbers;

        $api_me_miniProfile_Occupation = 'N/A';
        $api_me_miniProfile_firstName = 'N/A';
        $api_me_miniProfile_lastName = 'N/A';
        if ($apiRes_me != '') {
            if (isset($apiRes_me->miniProfile->occupation)) {
                //$api_me_miniProfile_Occupation = $apiRes_me->miniProfile->occupation;
                $api_me_miniProfile_Occupation = addslashes($this->mb_htmlentities($apiRes_me->miniProfile->occupation));
            }
            if (isset($apiRes_me->miniProfile->firstName)) {
                //$api_me_miniProfile_firstName = $apiRes_me->miniProfile->firstName;
                $api_me_miniProfile_firstName = addslashes($this->mb_htmlentities($apiRes_me->miniProfile->firstName));
            }
            if (isset($apiRes_me->miniProfile->lastName)) {
                //$api_me_miniProfile_lastName = $apiRes_me->miniProfile->lastName;
                $api_me_miniProfile_lastName = addslashes($this->mb_htmlentities($apiRes_me->miniProfile->lastName));
            }
        }


        //, IPPV_profileSummary='".$IPPV_profileSummary."'
        //addslashes($api_me_miniProfile_firstName)
        //addslashes($api_me_miniProfile_lastName)
        //addslashes($api_me_miniProfile_Occupation)
        $update_user_data = "update user_profile set ProfilePic400_400='" . addslashes($ProfilePic400_400) . "', pdNumConnections='" . $pdNumConnections . "', pdPendingConnections='" . $pdPendingConnections . "', pdNumTotalSentInvitations='" . $pdNumTotalSentInvitations . "', IPPV_profileLocationName='" . addslashes($IPPV_profileLocationName) . "', IPPCI_phoneNumber='" . addslashes($IPPCI_phoneNumber) . "', firstName='" . $api_me_miniProfile_firstName . "', lastName='" . $api_me_miniProfile_lastName . "', occupation='" . $api_me_miniProfile_Occupation . "' where user_id='" . Yii::$app->session->get('userid') . "'";
		
		echo $update_user_data;

        //Yii::$app->db->createCommand($update_user_data)->execute();
        //updating data ends

        //return json_encode($final_result);
    }

    //25Nov2020 NR testing
    public function actionAjxprofilenrtesting() {
        include('../web/updateLinkedInCookie.php');
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $UserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid') . " AND id =" . Yii::$app->session->get('userid'))->queryOne();
        $proxyIp = $UserDetail['proxyIp'];
        $proxyPort = $UserDetail['proxyPort'];
        $proxyUsername = $UserDetail['proxyUsername'];
        $proxyPassword = $UserDetail['proxyPassword'];
        $userAgent = $UserDetail['userAgent'];
        $cookie = $UserDetail['cookie'];
        $csrf = $UserDetail['csrf'];

        $profileData = array();


        //06June2020 starts
        $profileData['pic_100_100'] = '';
        $profileData['pic_400_400'] = '';
        $apiRes_me = '';

        $profileData['numConnections'] = 0;
        $profileData['pendingConnections'] = 0;
        $profileData['numTotalSentInvitations'] = 0;


        $apiRes_IdentityProfilesProfileView = '';
        $apiRes_IdentityProfilesProfileContactInfo = '';
        //06June2020 ends



        if ($proxyIp && $proxyPort && $proxyUsername && $proxyPassword) {

            if (!empty($cookie) && !empty($csrf)) {
				

                $curl = curl_init();
                curl_setopt_array($curl, array(
                    //CURLOPT_URL => "https://www.linkedin.com/sales-api/salesApiPrimaryIdentity",
						//CURLOPT_URL => "https://www.linkedin.com/sales-api/salesApiAccess",
					CURLOPT_URL => "https://www.linkedin.com/sales-api/salesApiSsi",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    /*CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",*/
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        //"User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $curlResult = curl_exec($curl);
                $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                $headers = substr($curlResult, 0, $header_size);

                $curlResult = substr($curlResult, $header_size);
				$apiRes_me = $decodedRes = json_decode($curlResult);
                    echo 'E:<pre>'; print_r($decodedRes);
					echo '<br/>0:'.$decodedRes->memberScore->overall;
					echo '<br/>A:'.$valProfessionalBrand = $decodedRes->memberScore->subScores[0]->score;
					echo '<br/>B:'.$valFindRightPeople = $decodedRes->memberScore->subScores[1]->score;
					echo '<br/>C:'.$valInsightEngagement = $decodedRes->memberScore->subScores[2]->score;
					echo '<br/>D:'.$valStrongRelationship = $decodedRes->memberScore->subScores[3]->score;
					
					
die;				
				
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/me",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    /* CURLOPT_VERBOSE=>true, */
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $curlResult = curl_exec($curl);
                $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                $headers = substr($curlResult, 0, $header_size);

                $curlResult = substr($curlResult, $header_size);
                $newCookie = getCookiesLdnFromHeaders($headers);
                if (!empty($newCookie)) {
                    //updateUserLdnCookies($userId, $newCookie);
                }
                if (!empty($curlResult)) {
                    $apiRes_me = $decodedRes = json_decode($curlResult);
                    echo 'C:<pre>'; print_r($decodedRes);
                    $picture = (array) $decodedRes->miniProfile->picture;
                    $profileData['pic_100_100'] = $picture['com.linkedin.common.VectorImage']->rootUrl . $picture['com.linkedin.common.VectorImage']->artifacts[0]->fileIdentifyingUrlPathSegment;
                    $profileData['pic_400_400'] = $picture['com.linkedin.common.VectorImage']->rootUrl . $picture['com.linkedin.common.VectorImage']->artifacts[2]->fileIdentifyingUrlPathSegment;
                    \Yii::$app->session->set('top_profile_pic', $profileData['pic_100_100']);
                } else {
                    $profileData['pic_100_100'] = '';
                    $profileData['pic_400_400'] = '';
                    $apiRes_me = '';
                }
            }
//echo '<br/>123123';die;

            if (!empty($cookie) && !empty($csrf)) {
                $curlConnectionDetails = curl_init();
                curl_setopt_array($curlConnectionDetails, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/relationships/connectionsSummary/",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    /* CURLOPT_VERBOSE=>true, */
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $connectionDetailsRes = curl_exec($curlConnectionDetails);
                $header_size = curl_getinfo($curlConnectionDetails, CURLINFO_HEADER_SIZE);
                $headers = substr($connectionDetailsRes, 0, $header_size);

                $connectionDetailsRes = substr($connectionDetailsRes, $header_size);
                $newCookie = getCookiesLdnFromHeaders($headers);
                if (!empty($newCookie)) {
                    //updateUserLdnCookies($userId, $newCookie);
                }
                if (!empty($connectionDetailsRes)) {
                    $decodedJsonRes = json_decode($connectionDetailsRes);
                    echo '<br/>AA:<pre>'; print_r($decodedJsonRes);
                    $profileData['numConnections'] = $decodedJsonRes->numConnections;
                } else {
                    $profileData['numConnections'] = 0;
                }
				
				
                $curlInvitationDetails = curl_init();
                curl_setopt_array($curlInvitationDetails, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/relationships/invitationsSummaryV2?types=List(SENT_INVITATION_COUNT,PENDING_INVITATION_COUNT,UNSEEN_INVITATION_COUNT,PENDING_INVITATION_BY_FACET_COUNT)",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    /* CURLOPT_VERBOSE=>true, */
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        /* "cookie: $cookie",
                          "csrf-token: $csrf",
                          "x-http-method-override: GET",
                          "Host: www.linkedin.com",
                          "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36",
                          "accept: application/vnd.linkedin.normalized+json+2.1",
                          "Accept-Language: en-US,en;q=0.5",
                          "Accept-Encoding: gzip, deflate, br",
                          //"content-type: application/x-www-form-urlencoded",
                          "x-li-lang: en_US",
                          "x-restli-protocol-version: 2.0.0",
                          "Origin: https://www.linkedin.com",
                          "TE: Trailers" */

                        "accept: application/vnd.linkedin.normalized+json+2.1",
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        //"x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "accept-language: en-US,en;q=0.9",
                        //"Accept-Encoding: gzip, deflate, br",
                        //"content-type: application/x-www-form-urlencoded",
                        "content-type: application/vnd.linkedin.normalized+json+2.1",
                        "x-li-lang: en_US",
                        //'x-li-track: {"clientVersion":"1.6.3394","osName":"web","timezoneOffset":5.5,"deviceFormFactor":"DESKTOP","mpName":"voyager-web","displayDensity":1}',
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                    //"TE: Trailers"						
                    ),
                ));
                $invitationDetailsRes = curl_exec($curlInvitationDetails);
                $header_size = curl_getinfo($curlInvitationDetails, CURLINFO_HEADER_SIZE);
                $headers = substr($invitationDetailsRes, 0, $header_size);

                $invitationDetailsRes = substr($invitationDetailsRes, $header_size);
                $newCookie = getCookiesLdnFromHeaders($headers);
                if (!empty($newCookie)) {
                    //updateUserLdnCookies($userId, $newCookie);
                }
                if (!empty($invitationDetailsRes)) {
                    $decodedJsonResInvDtls = json_decode($invitationDetailsRes);
                    $profileData['numTotalSentInvitations'] = $decodedJsonResInvDtls->data->numTotalSentInvitations;
                    $profileData['pendingConnections'] = $decodedJsonResInvDtls->data->numPendingInvitations;
                    echo 'BBSDSD:<pre>'; print_r($decodedJsonResInvDtls);
                    //$profileData['pendingConnections'] = $decodedJsonResInvDtls->elements[1]->count;
                } else {
                    //$profileData['pendingConnections'] = 0;
                }
            }

echo '<br/>LINE::'. __LINE__ .':::';

            //NR starts
            if ($apiRes_me != '') {
                $publicIdentifier = $apiRes_me->miniProfile->publicIdentifier;
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $publicIdentifier . "/profileView",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    /* CURLOPT_VERBOSE=>true, */
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $curlResult = curl_exec($curl);
                $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                $headers = substr($curlResult, 0, $header_size);

                $curlResult = substr($curlResult, $header_size);
                $newCookie = getCookiesLdnFromHeaders($headers);
                if (!empty($newCookie)) {
                    //updateUserLdnCookies($userId, $newCookie);
                }
                //echo '<br/>LINE:'.__LINE__.':::'; echo $curlResult;
                $apiRes_IdentityProfilesProfileView = json_decode($curlResult);
				echo '<br/>LINE::'. __LINE__ .':::';
                echo 'C:<pre>';  print_r($apiRes_IdentityProfilesProfileView);
                curl_close($curl);

                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $publicIdentifier . "/profileContactInfo",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    /* CURLOPT_VERBOSE=>true, */
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $curlResult = curl_exec($curl);
                $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                $headers = substr($curlResult, 0, $header_size);

                $curlResult = substr($curlResult, $header_size);
                $newCookie = getCookiesLdnFromHeaders($headers);
                if (!empty($newCookie)) {
                    //updateUserLdnCookies($userId, $newCookie);
                }
                //echo '<br/>LINE:'.__LINE__.':::'; echo $curlResult;
                $apiRes_IdentityProfilesProfileContactInfo = json_decode($curlResult);
				echo '<br/>LINE::'. __LINE__ .':::';
				echo '<pre>'; print_r($apiRes_IdentityProfilesProfileContactInfo);
                curl_close($curl);
            }
            //NR ends
        }

        $final_result = array();
        $final_result['profileData'] = $profileData;
		echo '<br/>LINE::'. __LINE__ .':::';
die;


        $api_IPPV_profile_locationName = 'N/A';
        $api_IPPV_profile_summary_html = '<p>N/A</p>';
        if ($apiRes_IdentityProfilesProfileView != '') {
            if (isset($apiRes_IdentityProfilesProfileView->profile->locationName)) {
                $api_IPPV_profile_locationName = $apiRes_IdentityProfilesProfileView->profile->locationName;
            }

            if (isset($apiRes_IdentityProfilesProfileView->profile->summary)) {
                //01-07-2020:htmlentities added due to it was causing issue when summary contains html;
                if (strlen($apiRes_IdentityProfilesProfileView->profile->summary) > 325) {
                    $api_IPPV_profile_summary_html = '<p id="shortAbout">' . substr(htmlentities($apiRes_IdentityProfilesProfileView->profile->summary), 0, 325) . '... <a href="javascript:void(0);" id="aShortAbout">Read more</a></p>';
                    $api_IPPV_profile_summary_html .= '<p id="fullAbout" style="display:none;">' . htmlentities($apiRes_IdentityProfilesProfileView->profile->summary) . ' <a href="javascript:void(0);" id="aFullAbout">Read less</a></p>';
                } else {
                    $api_IPPV_profile_summary_html = '<p>' . htmlentities($apiRes_IdentityProfilesProfileView->profile->summary) . '</p>';
                }
            }
        }
        //print_r($api_IPPV_profile_summary_html); 
        $apiIPPCI_phoneNumbers = 'N/A';
        $apiIPPCI_emailAddress = 'N/A';
        if ($apiRes_IdentityProfilesProfileContactInfo != '') {
            if (isset($apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number)) {
                $apiIPPCI_phoneNumbers = $apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number;
            }

            if (isset($apiRes_IdentityProfilesProfileContactInfo->emailAddress)) {
                $apiIPPCI_emailAddress = $apiRes_IdentityProfilesProfileContactInfo->emailAddress;
            }
        }

        $api_me_miniProfile_Occupation = 'N/A';
        if ($apiRes_me != '') {
            if (isset($apiRes_me->miniProfile->occupation)) {
                $api_me_miniProfile_Occupation = $apiRes_me->miniProfile->occupation;
            }
        }

        $html_basicDetail = '';
        $html_basicDetail .= '<h5 class="card-title">Basic details</h5>';
        $html_basicDetail .= '<ul class="list-unstyled basicDetailsBlk">';
        $html_basicDetail .= '<li><i class="cursor-pointer bx bx-map mb-1 mr-50"></i>' . $api_IPPV_profile_locationName . '</li>';
        $html_basicDetail .= '<li><i class="cursor-pointer bx bx-phone-call mb-1 mr-50"></i>' . $apiIPPCI_phoneNumbers . '</li>';
        $html_basicDetail .= '<li><i class="cursor-pointer bx bx-envelope mb-1 mr-50"></i>' . $apiIPPCI_emailAddress . '</li></ul><div class="profilOccBlk"><h6><small class="text-muted">Occupation</small></h6><p>' . $api_me_miniProfile_Occupation . '</p></div><div class="profileAbtBlk"><h6><small class="text-muted">About</small></h6>';
        /* $api_IPPV_profile_summary_html = addslashes($api_IPPV_profile_summary_html);
          $api_IPPV_profile_summary_html = htmlspecialchars($api_IPPV_profile_summary_html); */
        $html_basicDetail .= $api_IPPV_profile_summary_html;
        $html_basicDetail .= '</div>';


        //print_r(htmlentities($html_basicDetail, NULL, 'UTF-8'));
        $final_result['html_basicDetail'] = $html_basicDetail;
        $final_result['apiRes_me'] = $apiRes_me;
        //print_r(json_encode($final_result,JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)); 
        return json_encode($final_result);
    }



    public function actionNrtestingdashboard() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
//echo 'fds';die;
        $SubuserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid'))->queryAll();

        //$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $time = new \DateTime('now');
        $today = $time->format('Y-m-d');
        $month = $time->format('Y-m-01');
        $userid = Yii::$app->session->get('userid');
        $result = [];
        //$result['allReq'] = count(Blacklist::find()->select('id')->where(['=', 'teamid', Yii::$app->session->get('teamid')])->all());
        $result['allReq'] = count(Blacklist::find()->select('id')->where(['=', 'teamid', Yii::$app->session->get('teamid')])->andWhere(['!=', 'seq_id', 0])->all());
        $result['allMonth'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $month], ['=', 'teamid', Yii::$app->session->get('teamid')]])->andWhere(['!=', 'seq_id', 0])->all());
        $result['allToday'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $today], ['=', 'teamid', Yii::$app->session->get('teamid')]])->andWhere(['!=', 'seq_id', 0])->all());



        $result['allMyToday'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $today], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
        $result['allMyMonth'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $month], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
        $result['allMy'] = count(Blacklist::find()->select('id')->where(['and', ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());



        $result['allMyAcceptedToday'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $today], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_accepted', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
        $result['allMyAcceptedMonth'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $month], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_accepted', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
        $result['allMyAccepted'] = count(Blacklist::find()->select('id')->where(['and', ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_accepted', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());

        $result['allMyRespondedToday'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $today], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_response', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
        $result['allMyRespondedMonth'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $month], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_response', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
        $result['allMyResponded'] = count(Blacklist::find()->select('id')->where(['and', ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_response', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());


		//ssi api starts

        $UserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid') . " AND id =" . Yii::$app->session->get('userid'))->queryOne();
        $proxyIp = $UserDetail['proxyIp'];
        $proxyPort = $UserDetail['proxyPort'];
        $proxyUsername = $UserDetail['proxyUsername'];
        $proxyPassword = $UserDetail['proxyPassword'];
        $userAgent = $UserDetail['userAgent'];
        $cookie = $UserDetail['cookie'];
        $csrf = $UserDetail['csrf'];
		
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    //CURLOPT_URL => "https://www.linkedin.com/sales-api/salesApiPrimaryIdentity",
						//CURLOPT_URL => "https://www.linkedin.com/sales-api/salesApiAccess",
					CURLOPT_URL => "https://www.linkedin.com/sales-api/salesApiSsi",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    /*CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",*/
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        //"User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $curlResult = curl_exec($curl);
                $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                $headers = substr($curlResult, 0, $header_size);

                $curlResult = substr($curlResult, $header_size);
				$decodedRes = json_decode($curlResult);
				
                    //echo 'E:<pre>'; print_r($decodedRes);
					$ssiData['memberScore_overall'] = $decodedRes->memberScore->overall;
					$ssiData['valProfessionalBrand'] = $decodedRes->memberScore->subScores[0]->score;
					$ssiData['valFindRightPeople'] = $decodedRes->memberScore->subScores[1]->score;
					$ssiData['valInsightEngagement'] = $decodedRes->memberScore->subScores[2]->score;
					$ssiData['valStrongRelationship']  = $decodedRes->memberScore->subScores[3]->score;
		//ssi api ends

        return $this->render('dashboard_nrtesting', [
                    'SubuserDetail' => $SubuserDetail,
                    'report' => $result,
                    'ssiData' => $ssiData
                        // 'dataProvider' => $dataProvider,
        ]);
    }

}
