<?php

namespace app\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\db\Query;
use app\models\Blacklist;
use yii\data\Pagination;

//include "../classes/class.phpmailer.php"; // include the class name
//include "../classes/class.smtp.php"; // include the class name

class SubUsersController extends Controller {

    public $enableCsrfValidation = false;

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions() {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    public function actionIndex() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }

        //14870::14885
        //echo Yii::$app->session->get('teamid').'::'.Yii::$app->session->get('userid');die;
        /*
          $SubuserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid')." and id!=" . Yii::$app->session->get('userid')."  ")->queryAll();
          //echo '<pre>'; print_r($SubuserDetail);echo '</pre>';
          return $this->render('index', [
          'SubuserDetail' => $SubuserDetail,
          ]);
         */

        if (isset($_GET['sortby']) && $_GET['sortby'] != '') {
            $sortby = $_GET['sortby'];
        } else {
            $sortby = 'id'; //default column
        }

        if (isset($_GET['sortorder']) && $_GET['sortorder'] != '') {
            if ($_GET['sortorder'] == 'asc') {
                $sortorder = SORT_ASC;
            } else {
                $sortorder = SORT_DESC;
            }
        } else {
            $sortorder = SORT_DESC; //default sort order
        }

        $whereClause = "";
		$showDeleted = " AND is_deleted = '0'";
		if (isset($_GET['deleted_filter']) && $_GET['deleted_filter'] != '') {
			
			$showDeleted = " AND is_deleted = '".$_GET['deleted_filter']."'";
		}
		
        if (isset($_GET['search']) && $_GET['search'] != '') {

            $fullname = explode(" ", trim($_GET['search']));
            $firstname = trim($_GET['search']);
            $lastname = trim($_GET['search']);
            if (isset($fullname[0]) && !empty($fullname[0])) {
                $firstname = $fullname[0];
            }
            if (isset($fullname[1]) && !empty($fullname[1])) {
                $lastname = $fullname[1];
            }

            $whereClause = " AND (email LIKE'%" . trim($_GET['search']) . "%' OR first_name LIKE'%" . $firstname . "%' OR last_name LIKE'%" . $lastname . "%')";
        }

        $query = new Query;

		if($_SESSION['portal_id'] == 23){
		
        $query->select(['*'])
                ->from('user')
                ->where(['teamid' => Yii::$app->session->get('userid'),'is_deleted' => '0'])
                ->andWhere("id !=" . Yii::$app->session->get('userid') . $whereClause)
//                ->orderBy([$sortby => $sortorder]);
                ->orderBy(['is_deleted' => SORT_ASC]);
				
				
		} else {
			
			$query->select(['*'])
                ->from('user')
                ->where(['teamid' => Yii::$app->session->get('userid')])
                ->andWhere("id !=" . Yii::$app->session->get('userid') . $whereClause .$showDeleted);
//                ->orderBy([$sortby => $sortorder]);
                //->orderBy(['is_deleted' => SORT_ASC]);
			
		}
		
		if(Yii::$app->session->get('userid') == '14905'){
		 //echo $query->createCommand()->getRawSql();exit;
		}


        $countQuery = clone $query;
        $pages = new Pagination(['totalCount' => $countQuery->count()]);
        $SubuserDetail = $query->offset($pages->offset)
                ->limit($pages->limit)
                ->all();


        //echo 'SDFD:<pre>'; print_r($models);die;
        return $this->render('index', [
                    'SubuserDetail' => $SubuserDetail,
                    'pages' => $pages,
        ]);
    }
	
	public function actionTeammetrics(){ 
		
		 if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }
		
		 return $this->render('team_metrics');
		
	}
	
	public function actionGetchartdata() {
        $s_date = implode('-', array_reverse(explode('/', $_POST['s_date'])));
        $e_date = implode('-', array_reverse(explode('/', $_POST['e_date'])));
        $userid = Yii::$app->session->get('userid');

        $res_arr = array();
        $rep_acc_data = Yii::$app->db->createCommand("SELECT COUNT(id) as accepted, CAST(accepted_at AS DATE) as accepted_at FROM blacklist WHERE (DATE(accepted_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . Yii::$app->session->get('teamid') . "' AND is_accepted = 1 AND seq_id != '0' GROUP BY CAST(accepted_at AS DATE)")->queryAll();
		//echo "SELECT COUNT(id) as accepted, CAST(accepted_at AS DATE) as accepted_at FROM blacklist WHERE (DATE(accepted_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . Yii::$app->session->get('teamid') . "' AND is_accepted = 1 AND userid = '" . $userid . "' AND seq_id != '0' GROUP BY CAST(accepted_at AS DATE)";
        $rep_res_data = Yii::$app->db->createCommand("SELECT COUNT(id) as responded, CAST(created_at AS DATE) as created_at FROM blacklist WHERE (DATE(created_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . Yii::$app->session->get('teamid') . "' AND is_response = 1 AND seq_id != '0' GROUP BY CAST(created_at AS DATE)")->queryAll();
        //echo "<pre>";print_r($rep_acc_data);die;

        $dates = $this->getallDates($s_date, $e_date);
        $k = 0;
        foreach ($dates as $date_v) {
            $arr = [];
            $rkey = '';
            $akey = '';

            $rkey = array_search($date_v, array_column($rep_res_data, 'created_at'));
            $akey = array_search($date_v, array_column($rep_acc_data, 'accepted_at'));

            if ($rkey !== false && $akey !== false) {
                $arr['b'] = $rep_res_data[$rkey]['responded'];
                $arr['a'] = $rep_acc_data[$akey]['accepted'];
                $arr['y'] = date('d/m', strtotime($date_v));
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($rkey !== false && $akey === false) {
                $arr['b'] = $rep_res_data[$rkey]['responded'];
                $arr['y'] = date('d/m', strtotime($date_v));
                $arr['a'] = 0;
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($akey !== false && $rkey === false) {
                $arr['a'] = $rep_acc_data[$akey]['accepted'];
                $arr['y'] = date('d/m', strtotime($date_v));
                $arr['b'] = 0;
                $res_arr[$k] = $arr;
                $k++;
            }/* else{
              $arr['a'] = 0;
              $arr['b'] = 0;
              $arr['y'] = $date_v;
              } */
        }

        echo json_encode($res_arr);
    }
	
	 public function actionGetdonutchartdata() {
        $s_date = implode('-', array_reverse(explode('/', $_POST['s_date'])));
        $e_date = implode('-', array_reverse(explode('/', $_POST['e_date'])));
        $userid = Yii::$app->session->get('userid');
		$totalwithdrown = 0;
		
		$getallsubuserid = Yii::$app->db->createCommand("SELECT id FROM user WHERE teamid = '" . $userid . "'")->queryAll();
		$subuserarr = array();
		foreach($getallsubuserid as $key=>$value){
			
			$subuserarr[] = $value['id'];
		}
		$subusersstr =  implode(', ', $subuserarr);
		//echo $subusersstr;
		 //exit; 
		
        // $rep_req_data = Yii::$app->db->createCommand("SELECT COUNT(id) as request FROM blacklist WHERE (DATE(created_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . Yii::$app->session->get('teamid') . "' AND userid = '" . $userid . "' AND seq_id != '0'")->queryAll();
		
		//echo "SELECT COUNT(id) as totwithdrawn FROM completed_tasks where (DATE(completedOn) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND triggerOnInvitationAccepted = '1' AND status = 'Complete' AND userId IN (".$subusersstr.")"; exit; 
		
		//echo "SELECT COUNT(id) as request FROM completed_tasks where (DATE(completedOn) BETWEEN '" . $s_date . "' AND '" . $e_date . "')  AND status = 'Complete' AND type = 'Connect' AND userId IN (".$subusersstr.")";

        $rep_req_data = Yii::$app->db->createCommand("SELECT COUNT(id) as request FROM completed_tasks where (DATE(completedOn) BETWEEN '" . $s_date . "' AND '" . $e_date . "')  AND status = 'Complete' AND type = 'Connect' AND userId IN (".$subusersstr.")")->queryAll();

        $rep_acc_data = Yii::$app->db->createCommand("SELECT COUNT(id) as accepted FROM blacklist WHERE (DATE(accepted_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . Yii::$app->session->get('teamid') . "' AND is_accepted = 1 AND seq_id != '0'")->queryAll();

        $rep_res_data = Yii::$app->db->createCommand("SELECT COUNT(id) as responded FROM blacklist WHERE (DATE(FROM_UNIXTIME(round(respond / 1000))) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . Yii::$app->session->get('teamid') . "' AND is_response = 1 AND seq_id != '0'")->queryAll(); 

        $sqltottask = "SELECT COUNT(id) as performedtasks FROM completed_tasks where (DATE(completedOn) BETWEEN '" . $s_date . "' AND '" . $e_date . "')  AND status = 'Complete' AND userId IN (".$subusersstr.")";
        $rowstottask = Yii::$app->db->createCommand($sqltottask)->queryAll();

        $sqltotwithdrown = "SELECT COUNT(id) as totwithdrawn FROM completed_tasks where (DATE(completedOn) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND triggerOnInvitationAccepted = '1' AND status = 'Complete' AND userId IN (".$subusersstr.")";
        $rowstotwithdrown = Yii::$app->db->createCommand($sqltotwithdrown)->queryAll();
		
		
		$sqltotwithdrown_auto = "SELECT COUNT(id) as totwithdrawn_auto FROM withdrawals where (DATE(created) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND status = 1 AND userId = " . Yii::$app->session->get('userid');
        $rowstotwithdrown_auto = Yii::$app->db->createCommand($sqltotwithdrown_auto)->queryAll();
		
		$totalwithdrown = $rowstotwithdrown[0]['totwithdrawn'] + $rowstotwithdrown_auto[0]['totwithdrawn_auto'];
		
		

        $res_arr = array();
		
	//	echo "SELECT COUNT(id) as accepted FROM blacklist WHERE (DATE(created_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . Yii::$app->session->get('teamid') . "' AND is_accepted = 1 AND userid = '" . $userid . "' AND seq_id != '0'";
//echo "SELECT COUNT(id) as responded FROM blacklist WHERE (DATE(respond) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . Yii::$app->session->get('teamid') . "' AND is_response = 1 AND userid = '" . $userid . "' AND seq_id != '0'";

        if ($rep_acc_data[0]['accepted'] > 0 || $rep_res_data[0]['responded'] > 0 || $rep_req_data[0]['request']) {
            $space = '&nbsp;';
            $res_arr[] = array('label' => 'Total Accepted', 'value' => $rep_acc_data[0]['accepted']);
            $res_arr[] = array('label' => 'Total Response', 'value' => $rep_res_data[0]['responded']);
            $res_arr[] = array('label' => 'Total Sent', 'value' => $rep_req_data[0]['request']);
            $res_arr[] = array('label' => 'Total Task Performed', 'value' => $rowstottask[0]['performedtasks']);
            $res_arr[] = array('label' => 'Total Task Withdrawn', 'value' => $totalwithdrown);
        }

        echo json_encode($res_arr);
    }

	public function actionGettopsequenceofweek()
	{
		if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }
		
		$html ='';
		$topseqweek = "SELECT COUNT(b.id) as total_accepted,b.userid,b.seq_id,s.name,u.first_name,u.last_name FROM `blacklist` as b,user as u,ext_sequences as s where u.id = b.userid and b.seq_id = s.id and b.teamid = '".Yii::$app->session->get('teamid')."' and b.is_accepted = '1' and b.accepted_at >= ( CURDATE() - INTERVAL 7 DAY ) GROUP BY b.seq_id ORDER BY total_accepted DESC LIMIT 5";
		$rowstopseqweek = Yii::$app->db->createCommand($topseqweek)->queryAll();
		
		if(!empty($rowstopseqweek))
		{
											$html .='<ul class="list-group list-group-flush">';
											$i = 1;
											$trophy = '';
											$textsize = '';
                                            foreach($rowstopseqweek as $key=>$value){
												
											if($i == 1){
												$trophy = '<i style="font-size:2rem;" class="bx bx-trophy text-warning font-size-base"></i>';
												$textsize = '1.2';
											}else if($i == 2){
												$trophy = '<i style="font-size:1.6rem;" class="bx bx-trophy text-light font-size-base"></i>';
												$textsize = '1.0';
											}else if($i == 3){
												$trophy = '<i style="color:#897a5f !important;" class="bx bx-trophy text-dark font-size-base"></i>';
												$textsize = '1.0';
											}else if($i ==4){
												$trophy = '<span style="font-weight: bold;" class="text-dark">'.$i.'</span>';
												$textsize = '0.9';
											}else{
												$trophy = '<span style="font-weight: bold;" class="text-dark">'.$i.'</span>';
												$textsize = '0.9';
											}
											
											if(strlen($value['name']) > 20){ 
												$seqname = substr($value['name'],0,20).'...';
											}
											else{
												$seqname = $value['name'];
											}
												//echo '<pre>'; print_r($value['name']);
											$html .='<li class="list-group-item list-group-item-action border-0 d-flex align-items-center justify-content-between">
                                                <div class="list-left d-flex">
                                                    <div class="list-icon mr-1" style="width: 50px;">
                                                       
																'.$trophy.'
                                                             
                                                    </div>
                                                    <div class="list-content" style="text-transform: capitalize; font-size:'.$textsize.'em;" title="'.$value['name'].'">
                                                        <span class="list-title">'.$seqname.' | '.$value['first_name'].' '.$value['last_name'].'</span>
                                                    </div>
                                                </div>
                                                <span class="text-warning"><button class="btn btn-sm btn-primary btn_view_details" data-seqid="'.$value['seq_id'].'">Details</button></span>
                                            </li>';
                                            $i++;}
                                           
                                       $html .= '</ul>';
		}
		else{
			
			$html .='<ul class="list-group list-group-flush" style="opacity: 0.2; pointer-events: none;"><li class="list-group-item list-group-item-action border-0 d-flex align-items-center justify-content-between">
                                                <div class="list-left d-flex">
                                                    <div class="list-icon mr-1" style="width: 50px;">
                                                       
																<i style="font-size:2rem;" class="bx bx-trophy text-warning font-size-base"></i>
                                                            
                                                    </div>
                                                    <div class="list-content" style="text-transform: capitalize; font-size:1.2em;" title="test - insightly">
                                                        <span class="list-title">Sales One  | John dev</span>
                                                    </div>
                                                </div>
                                                <span class="text-warning"><button class="btn btn-sm btn-primary">Details</button></span>
                                            </li><li class="list-group-item list-group-item-action border-0 d-flex align-items-center justify-content-between">
                                                <div class="list-left d-flex">
                                                    <div class="list-icon mr-1" style="width: 50px;">
                                                       
																<i style="font-size:1.6rem;" class="bx bx-trophy text-light font-size-base"></i>
                                                            
                                                    </div>
                                                    <div class="list-content" style="text-transform: capitalize; font-size:1.0em;" title="PHP DEVELOPER">
                                                        <span class="list-title">Sales Two | Nick Brown</span>
                                                    </div>
                                                </div>
                                                <span class="text-warning"><button class="btn btn-sm btn-primary">Details</button></span>
                                            </li><li class="list-group-item list-group-item-action border-0 d-flex align-items-center justify-content-between">
                                                <div class="list-left d-flex">
                                                    <div class="list-icon mr-1" style="width: 50px;">
                                                       
																<i style="color:#897a5f !important;" class="bx bx-trophy text-dark font-size-base"></i>
                                                            
                                                    </div>
                                                    <div class="list-content" style="text-transform: capitalize; font-size:1.0em;" title="Hubspot - location - test">
                                                        <span class="list-title">Sales Three | Tom Taylor</span>
                                                    </div>
                                                </div>
                                                <span class="text-warning"><button class="btn btn-sm btn-primary">Details</button></span>
                                            </li><li class="list-group-item list-group-item-action border-0 d-flex align-items-center justify-content-between">
                                                <div class="list-left d-flex">
                                                    <div class="list-icon mr-1" style="width: 50px;">
                                                       
																<span style="font-weight: bold;" class="text-dark">4</span>
                                                            
                                                    </div>
                                                    <div class="list-content" style="text-transform: capitalize; font-size:0.9em;" title="Boosted - 2nd Degree test">
                                                        <span class="list-title">Sales Four | Jim Dengo</span>
                                                    </div>
                                                </div>
                                                <span class="text-warning"><button class="btn btn-sm btn-primary">Details</button></span>
                                            </li><li class="list-group-item list-group-item-action border-0 d-flex align-items-center justify-content-between">
                                                <div class="list-left d-flex">
                                                    <div class="list-icon mr-1" style="width: 50px;">
                                                       
																<span style="font-weight: bold;" class="text-dark">5</span>
                                                            
                                                    </div>
                                                    <div class="list-content" style="text-transform: capitalize; font-size:0.9em;" title="test hubspot">
                                                        <span class="list-title">Sales Five | Smith Dave</span>
                                                    </div>
                                                </div>
                                                <span class="text-warning"><button class="btn btn-sm btn-primary">Details</button></span>
                                            </li></ul>';
			
		}
					
										
			return $html;
		
		
		
	}
	
	public function actionGetseqdetails(){
		
		
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		$seq_id = $_POST['seq_id'];
		
		// seq stats
		  $getallseqids = Yii::$app->db->createCommand("SELECT id,msgSeq FROM ext_sequences WHERE id ='".$seq_id."' AND (status = 'Active' OR status = 'Complete' OR status = 'Paused' OR status = 'Error' OR status = 'Stopped')  order by id ASC")->queryOne();
 		
		 
			$seqId = $getallseqids['id']; 
			$seqType = $getallseqids['msgSeq'];
			
			if($seqType == 0)
			{
			$getalltasks2nddegrees = Yii::$app->db->createCommand("SELECT id FROM completed_tasks WHERE seqId = '".$seqId."' AND status = 'Complete' AND step = 0 AND type = 'Connect' order by id ASC")->queryAll();  
			}
			else{
			$getalltasks2nddegrees = Yii::$app->db->createCommand("SELECT id FROM completed_tasks WHERE seqId = '".$seqId."' AND status = 'Complete' AND step = 0 AND type = 'Message' order by id ASC")->queryAll();	
			} 
			
			$sqlaccept = "SELECT  id from blacklist  where is_accepted = 1 AND seq_id=" .$seqId;
            $countaccept = Yii::$app->db->createCommand($sqlaccept)->queryAll();
		
		    $sqlresponse = "SELECT  id from blacklist  where is_response = 1 AND seq_id=" .$seqId;
            $countresponse = Yii::$app->db->createCommand($sqlresponse)->queryAll(); 
		
		//echo count($countaccept).'|'.count($countresponse);
			
			$percentacc = '';
			$percentres = '';
			
			//if($user_id == '16839'){
			
				if(count($getalltasks2nddegrees) > 0){
					$percentacc = count($countaccept) * 100 / count($getalltasks2nddegrees);	
					$percentacc = ceil($percentacc).'%';	
					
					if(count($countaccept) > 0){
					$percentres = count($countresponse) * 100 / count($countaccept);
					$percentres = ceil($percentres).'%';
					} else{
					$percentres = '0%';	
					}
				}
			
				//$seqConnectsend = $seqId.':'.count($getalltasks2nddegrees).':'.count($countaccept).$percentacc.':'.count($countresponse).$percentres;  
				
				$statsHtml = '<div class="row" style="border: 1px solid #ccc; padding: 20px;"> 
														  <div class="col">
														 <div class="statistics-data my-auto">
															<div class="statistics" style="text-align: center;">
                                                                <span class="font-medium-2 mr-50 text-bold-600 countConreq_48513" style="color: #00CFDD !important;">'.count($getalltasks2nddegrees).'</span>
                                                            </div>
															<div class="statistics-date" style="text-align: center;">
                                                                <small class="text-muted">Total Enrolled</small> 
                                                            </div>
                                                            
                                                        </div>
														</div>
														<div class="col order-1">
														 <div class="statistics-data my-auto"> 
															<div class="statistics" style="text-align: center;">
                                                                <span class="font-medium-2 mr-50 text-bold-600 countConaccept_48513" style="color:#39DA8A !important;">'.count($countaccept).' <span class="rowpercent">('.$percentacc.')</span></span>
                                                            </div>
															<div class="statistics-date" style="text-align: center;">
                                                                <small class="text-muted">Total Accepted</small>
                                                            </div>
                                                            
                                                        </div>
														</div> 
														<div class="col order-2">
														 <div class="statistics-data my-auto"> 
															<div class="statistics" style="text-align: center;">
                                                                <span class="font-medium-2 mr-50 text-bold-600 countConresponse_48513" style="color:#5A8DEE !important;">'.count($countresponse).' <span class="rowpercent">('.$percentres.')</span></span>
                                                            </div>
															<div class="statistics-date" style="text-align: center;">
                                                                <small class="text-muted">Total Responses</small>
                                                            </div>
                                                            
                                                        </div>
														</div>
														</div>';
			
			   
		
		
		
		// seq details
		$getCurseqData = Yii::$app->db->createCommand("SELECT name,msgSeq,target_audience_type,SelectedcsvId,requestWithdrawDays,working_hour_id,zapireStatus,zaptouse,bypassweekly,isPostLike FROM ext_sequences WHERE id ='".$seq_id."'")->queryOne();
		
		$working_hour_id = $getCurseqData['working_hour_id'];
		$requestWithdrawDays = $getCurseqData['requestWithdrawDays'];
		$getCurseqData['name'];
		if($getCurseqData['msgSeq'] == 0){
			$seqType = 'Invitation Sequence';
			$seqMsgTxt = 'Once connect is accepted wait';
		}else{
			$seqType = 'Messaging Sequence';
			$seqMsgTxt = 'If no response after';
		}
		$target_audience_type = 'None';
		if(isset($getCurseqData['target_audience_type'])){
			if($getCurseqData['target_audience_type'] == 1)
			{
					$target_audience_type = 'Linkedin URL';
			}else if($getCurseqData['target_audience_type'] == 2){
					$target_audience_type = 'CSV';
			}else{
					$target_audience_type = 'Webhook';
			}
		}
		
		$seqhtml = '';
		$seqhtml .= $statsHtml.'<div class="row">';
			$seqhtml .= '<div class="col-md-12 p-l-r-0">';
				$seqhtml .= '<div style="padding-top: 10px;">
				<label class="customlabel" for="first_name">Sequence Name : </label>
				'.$getCurseqData['name'].'
				<div class="help-block"></div>
				</div>';
				
				$seqhtml .= '<div style="padding-top: 10px;">
				<label class="customlabel" for="seq_type">Sequence  Type : </label>
				'.$seqType.'
				<div class="help-block"></div>
				</div>';
			$seqhtml .= '</div>';
			$seqhtml .= '<div style="padding-top: 10px;">';
			$seqhtml .= '<div><label class="customlabel" for="target_adu">Target Audience : </label> '.$target_audience_type.'</div>';
			
			$gethoursData = Yii::$app->db->createCommand("SELECT name,start_time,end_time,days FROM  ext_working_hours WHERE id ='".$working_hour_id."'")->queryOne();
			
			$daysA = explode(',',$gethoursData['days']);
			$daysAV = array();
			foreach($daysA as $res){
				if($res==1){
					$daysAV[]='Monday';
				}elseif($res==2){
					$daysAV[]='Tuesday';
				}elseif($res==3){
					$daysAV[]='Wednesday';
				}elseif($res==4){
					$daysAV[]='Thursday';
				}elseif($res==5){
					$daysAV[]='Friday';
				}elseif($res==6){
					$daysAV[]='Saturday';
				}elseif($res==7){
					$daysAV[]='Sunday';
				}
			}
			$daysAV = implode(", ",$daysAV);
			
			$seqhtml .= '<div style="padding-top: 10px;"><label class="customlabel" for="target_adu">Working Hours: </label> '.$gethoursData['name'].': '.$daysAV.' - '.$gethoursData['start_time'].' to '.$gethoursData['end_time'].'</div>'; 
			
			if($getCurseqData['bypassweekly'] == 1){ 
				$seqhtml .= '<div style="padding-top: 10px;"><label class="customlabel" for="target_adu">Boosted invites: </label> On</div>';
			}  
			
			if($getCurseqData['isPostLike'] == 1) 
			{
				$seqhtml .= '<div style="padding-top: 10px;"><label class="customlabel" for="target_adu">Auto Like Recent post before: </label> Yes</div>';
			}
			
			
			//if(Yii::$app->session->get('useremail') == 'dhaval.thakor@intricare.net'){
				if($getCurseqData['zapireStatus'] == 'true' ){ 
					$zapErr = json_decode($getCurseqData['zaptouse']);
					$zapEvent = '';
					$zapEventstr = '';
					foreach($zapErr as $key=>$value)
					{
						$zapEvent .= $value.',';
					}
					$zapEventstr = rtrim($zapEvent,',');
					$seqhtml .= '<div style="padding-top: 10px;"><label class="customlabel" for="target_adu">Zapier:</label>&nbsp;'.$zapEventstr.'</div>';
				}
			//}
			
			
			$getalllinks = Yii::$app->db->createCommand("SELECT link,postFlag FROM ext_links WHERE seqId ='".$seq_id."' order by id ASC")->queryAll();
			
			foreach($getalllinks as $rows)
			{
				$posturlaudtype = '';
				if($rows['postFlag'] == '1')
				{
					$posturlaudtype = ' - Send Invitation to Likes';
					
				}else if($rows['postFlag'] == '2'){
					
					$posturlaudtype = ' - Send Invitation to Comments';
					
				}else{
					
					$posturlaudtype = '';
				}
				
				if($getCurseqData['target_audience_type'] == 1){
					$seqhtml.= '<div class="targetAdu"><a href="'.$rows['link'].'" target="_blank">'.$rows['link'].'</a>'.$posturlaudtype.'</div>';
				}
				else if($getCurseqData['target_audience_type'] == 2)
				{
				
					$getCurCsvData = Yii::$app->db->createCommand("SELECT file_name FROM csvfiles WHERE id ='".$getCurseqData['SelectedcsvId']."'")->queryOne();
					$seqhtml .= $getCurCsvData['file_name'];	
				}
				else
				{
					$getwebhookData = Yii::$app->db->createCommand("SELECT w_url,w_type FROM webhooks WHERE w_seq_id ='".$seq_id."'")->queryOne();
					if($getwebhookData['w_type'] == 1){
						
					$getgsheetData = Yii::$app->db->createCommand("SELECT spreadsheetId,sheetName FROM spreadsheet_info WHERE seqid ='".$seq_id."'")->queryOne();
					
					$seqhtml .= '<div style="padding-top: 10px;"><label class="customlabel" for="target_adu">Google Sheet URL : </label><img src="https://d3j2mp6mc1f39j.cloudfront.net/sheetIcon.png" style="height:30px;"><a href="https://docs.google.com/spreadsheets/d/'.$getgsheetData['spreadsheetId'].'" target="_blank">'.$getgsheetData['sheetName'].'</a></div>';
					}
					//$seqhtml .= 'Using Webhook'; 	
				}
			}
			
			
			$sequenceType = $getCurseqData['msgSeq'];
			$seqhtml .= '</div>';
			$seqhtml .= '<div class="col-md-12 p-l-r-0" style="padding-top: 10px;">';
				$seqhtml .= '<label class="customlabel" for="first_name">Messages</label>';
				$getallsteps = Yii::$app->db->createCommand("SELECT * FROM ext_steps WHERE seqId ='".$seq_id."' order by `order` ASC")->queryAll();
				$count = 1;
				foreach($getallsteps as $rows){
					
					if($sequenceType == 0 && $count == 2){
						$seqMsgTxt = 'Once connect is accepted wait';
					}else if($sequenceType == 1 && $count == 2){
						$seqMsgTxt = 'If no response after';
					}else if($count == 1){
						$seqMsgTxt = '';
					}else{
						$seqMsgTxt = 'If no response after';
					}
					
					
				
					$seqhtml .='<div class="row"><div class="col-md-1 showingsteps"><div class="indicatorbox intPop"><div class="badge-circle badge-circle-info mr-1 mb-1">'.$count.'</div></div><div class="indicatorbox chtIcon intPop"></div></div><div class="col-md-10 seqstep step_row_'.$rows['id'].' step_ord_'.$rows['order'].' step_typ_'.$rows['type'].'">';
					if($rows['type'] != 'Connect'){
							if($rows['order'] != 0){
							$seqhtml .='<div class="step_delay col-md-12">'.$seqMsgTxt.' <span class="numBlk">'.$rows['delayDays'].'</span> days and <span class="numBlk">'.$rows['delayMinutes'].'</span> minutes</div>';
							}
						}
						
					$seqhtml .='<div class="step_header col-md-12">';
						$seqhtml .='<ul>';
						$seqhtml .='<li><span class="step_type_lab">'.$rows['type'].'</span></li>';
						$seqhtml .='</ul>';
					$seqhtml .='</div>';
					$seqhtml .='<div class="step_body col-md-11">';
						
						if($rows['subject'] != ''){
							$seqhtml .='<br><span><b>Subject: </b>'.$rows['subject'].'</span><br><hr>';
						}
						
						$seqhtml .='<span>'.nl2br($rows['message']).'</span>';
						
						
						if($rows['type'] == 'Zapier'){
							$seqhtml .='<br><span><b>Webhook: </b>'.$rows['webhooks'].'</span>';
						}
					$seqhtml .='</div></div>';
					
					
				 $seqhtml .='</div>';
				
				$count++;
				} 
			$seqhtml .= '</div>';
			if($getCurseqData['msgSeq'] == 0){
			$seqhtml .= '<div class="col-md-12 p-l-r-0" style="padding-top: 10px;">';
			$seqhtml .= '<p>Withdraw request if not Accepted In (days): <strong>'.$requestWithdrawDays.'</strong></p>';
			$seqhtml .= '</div>';
			}
			
		$seqhtml .= '</div>';
		
		
		echo $seqhtml; 
	}

    public function actionIndex_nrtesting() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }

        //14870::14885
        //echo Yii::$app->session->get('teamid').'::'.Yii::$app->session->get('userid');die;
        /*
          $SubuserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid')." and id!=" . Yii::$app->session->get('userid')."  ")->queryAll();
          //echo '<pre>'; print_r($SubuserDetail);echo '</pre>';
          return $this->render('index', [
          'SubuserDetail' => $SubuserDetail,
          ]);
         */

        if (isset($_GET['sortby']) && $_GET['sortby'] != '') {
            $sortby = $_GET['sortby'];
        } else {
            $sortby = 'id'; //default column
        }

        if (isset($_GET['sortorder']) && $_GET['sortorder'] != '') {
            if ($_GET['sortorder'] == 'asc') {
                $sortorder = SORT_ASC;
            } else {
                $sortorder = SORT_DESC;
            }
        } else {
            $sortorder = SORT_DESC; //default sort order
        }

        $whereClause = "";
        if (isset($_GET['search']) && $_GET['search'] != '') {

            $fullname = explode(" ", trim($_GET['search']));
            $firstname = trim($_GET['search']);
            $lastname = trim($_GET['search']);
            if (isset($fullname[0]) && !empty($fullname[0])) {
                $firstname = $fullname[0];
            }
            if (isset($fullname[1]) && !empty($fullname[1])) {
                $lastname = $fullname[1];
            }

            $whereClause = " AND (email LIKE'%" . trim($_GET['search']) . "%' OR first_name LIKE'%" . $firstname . "%' OR last_name LIKE'%" . $lastname . "%')";
        }

        $query = new Query;

        $query->select(['*'])
                ->from('user')
                ->where(['teamid' => Yii::$app->session->get('userid')])
                ->andWhere("id !=" . Yii::$app->session->get('userid') . $whereClause)
//                ->orderBy([$sortby => $sortorder]);
                ->orderBy(['is_deleted' => SORT_ASC]);



        $countQuery = clone $query;
        $pages = new Pagination(['totalCount' => $countQuery->count()]);
        $SubuserDetail = $query->offset($pages->offset)
                ->limit($pages->limit)
                ->all();


        //echo 'SDFD:<pre>'; print_r($models);die;
        return $this->render('index_nrtesting', [
                    'SubuserDetail' => $SubuserDetail,
                    'pages' => $pages,
        ]);
    }	
	
    public function actionIndextest() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        //14870::14885
        //echo Yii::$app->session->get('teamid').'::'.Yii::$app->session->get('userid');die;
        /*
          $SubuserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid')." and id!=" . Yii::$app->session->get('userid')."  ")->queryAll();
          //echo '<pre>'; print_r($SubuserDetail);echo '</pre>';
          return $this->render('index', [
          'SubuserDetail' => $SubuserDetail,
          ]);
         */

        if (isset($_GET['sortby']) && $_GET['sortby'] != '') {
            $sortby = $_GET['sortby'];
        } else {
            $sortby = 'id'; //default column
        }

        if (isset($_GET['sortorder']) && $_GET['sortorder'] != '') {
            if ($_GET['sortorder'] == 'asc') {
                $sortorder = SORT_ASC;
            } else {
                $sortorder = SORT_DESC;
            }
        } else {
            $sortorder = SORT_DESC; //default sort order
        }

        $query = new Query;
        /*
          $query->select(['*'])
          ->from('ext_tasks')
          //->where(['teamid' => Yii::$app->session->get('userid')])
          //->andWhere("id !=".Yii::$app->session->get('userid'))
          ->orderBy(['id' => SORT_DESC]);
         */

        $query->select(['*'])
                ->from('ext_tasks')
                //->where(['teamid' => Yii::$app->session->get('userid')])
                //->andWhere("id !=".Yii::$app->session->get('userid'))
                ->orderBy([$sortby => $sortorder]);




        $countQuery = clone $query;
        $pages = new Pagination(['totalCount' => $countQuery->count()]);
        $SubuserDetail = $query->offset($pages->offset)
                ->limit($pages->limit)
                ->all();
        //echo '<pre>'; print_r($pages); die;
        //echo 'SDFD:<pre>'; print_r($models);die;
        return $this->render('index_test', [
                    'SubuserDetail' => $SubuserDetail,
                    'pages' => $pages,
        ]);
    }


	public function actionKnsendinvitation() {
	
		if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $portal_id = Yii::$app->session->get('portal_id');



        if (isset($_POST['fname'])) {
            $fname = ucfirst($_POST['fname']);
            $fname = addslashes($fname);
            $fname = htmlspecialchars($fname);
        }
        if (isset($_POST['lname'])) {
            $lname = ucfirst($_POST['lname']);
            $lname = addslashes($lname);
            $lname = htmlspecialchars($lname);
        }
		
		 $user_account_type = 0;
        if (isset($_POST['user_account_type'])) {

            $user_account_type = 1;
        }

        $email = $_POST['email'];
        $teamid = $_POST['teamid'];
		
		$password = substr(str_shuffle("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"), -3);
        $password .= substr(str_shuffle("0123456789"), -2);
        $password .= substr(str_shuffle("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"), -2);
        $pass = password_hash($password, PASSWORD_DEFAULT);
        $time = time();

        $killWordsSuffix = 'bsn,ceo,certified,copywriter,cpc,digital,dr,drs,expert,freelance,hubspot,internet,lion,lme,lmt,ma,marketing,mba,md,mim,msc,ninja,online,pharma,phd,ppc,seo,sip,videoseo';
        $userAgent = $_SERVER['HTTP_USER_AGENT'];
		$sublevel = '0';
       
        $trial = 1;
        $trial_expired_at = strtotime('+7 days', time()) * 1000;

        $sqlUserdata = "SELECT  * from `user`  where `email`='" . $email . "' and `portal_id`=" . $portal_id;
        $dataUserarry = Yii::$app->db->createCommand($sqlUserdata)->queryOne();
        if (!empty($dataUserarry['id'])) {
            Yii::$app->session->set('error_message', "Email Id already exists.!");
            return $this->redirect(\Yii::$app->request->baseUrl . "/sub-users/index");
        } else {

            do {
                $generated_username = $this->random_username(explode('@', $email)[0]);
                $exist = $this->checkIfUserExist($generated_username);
            } while ($exist == 1);
            $name = $this->random_username($generated_username);

            $invitedata = Yii::$app->db->createCommand("INSERT INTO user (first_name,last_name,teamid,email,username,password_hash,confirmed_at,created_at,portal_id,killWordsSuffix,userAgent,user_role,sublevel,trial,trial_expired_at) VALUES ('" . $fname . "','" . $lname . "','" . $teamid . "','" . $email . "','" . $name . "','" . $pass . "','" . $time . "','" . $time . "','" . $portal_id . "','" . $killWordsSuffix . "','" . $userAgent . "','" . $user_account_type . "','" . $sublevel . "','" . $trial . "','" . $trial_expired_at . "')")->execute();









            //email starts
            if ($user_account_type != 1) {
                $html = $this->renderPartial('/../mail/invitationEmail', ['fname' => $fname, 'lname' => $lname, 'email' => $email, 'password' => $password]);
            } else {
                $html = $this->renderPartial('/../mail/invitationEmailCustomer', ['fname' => $fname, 'lname' => $lname, 'email' => $email, 'password' => $password]);
            }

			
			
			$subjecttext = '';
			if(Yii::$app->params['portal_url'] == 'https://dashboard.angelinvestorsnetwork.com')
			{ 
				$subjecttext = ' | LinkedIn Lead Generation';
			}

            $mail = Yii::$app->mailer->compose()
                    ->setTo($email)
//                    ->setBcc('ronit@leadconnect.io')
                    //->setFrom([Yii::$app->params['adminEmail'] => Yii::$app->params['emailFromName'].' | You have been Invited'])
                    ->setFrom(Yii::$app->params['adminEmail'])
                    //->setReplyTo()
                    ->setSubject(Yii::$app->params['emailFromName'] . " | You have been Invited".$subjecttext)
                    ->setHtmlBody($html, 'text/html');
            $mail->send();
            //email ends

           return 1;
           
        }
	
	}
	
    public function actionSendInvitation() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $portal_id = Yii::$app->session->get('portal_id');



        if (isset($_POST['fname'])) {
            $fname = ucfirst($_POST['fname']);
            $fname = addslashes($fname);
            $fname = htmlspecialchars($fname);
        }
        if (isset($_POST['lname'])) {
            $lname = ucfirst($_POST['lname']);
            $lname = addslashes($lname);
            $lname = htmlspecialchars($lname);
        }



        $user_account_type = 0;
        if (isset($_POST['user_account_type'])) {

            $user_account_type = 1;
        }









        $email = $_POST['email'];
        $teamid = $_POST['teamid'];





        $password = substr(str_shuffle("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"), -3);
        $password .= substr(str_shuffle("0123456789"), -2);
        $password .= substr(str_shuffle("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"), -2);
        $pass = password_hash($password, PASSWORD_DEFAULT);
        $time = time();

        $killWordsSuffix = 'bsn,ceo,certified,copywriter,cpc,digital,dr,drs,expert,freelance,hubspot,internet,lion,lme,lmt,ma,marketing,mba,md,mim,msc,ninja,online,pharma,phd,ppc,seo,sip,videoseo';
        $userAgent = $_SERVER['HTTP_USER_AGENT'];

        $sublevel = '0';
		
		// For outbound consulting
		$outboudadmis = array(27582,29622,29653,29654,29656,29658,29655,29657,29659);
		if(in_array($teamid,$outboudadmis)){
			 //$sublevel = '3';
		}
		// end outbound consulting
		
        $trial = 0;
        $trial_expired_at = strtotime('+7 days', time()) * 1000;

        $sqlUserdata = "SELECT  * from `user`  where `email`='" . $email . "' and `portal_id`=" . $portal_id;
        $dataUserarry = Yii::$app->db->createCommand($sqlUserdata)->queryOne();
        if (!empty($dataUserarry['id'])) {
            Yii::$app->session->set('error_message', "Email Id already exists.!");
            return $this->redirect(\Yii::$app->request->baseUrl . "/sub-users/index");
        } else {

            do {
                $generated_username = $this->random_username(explode('@', $email)[0]);
                $exist = $this->checkIfUserExist($generated_username);
            } while ($exist == 1);
            $name = $this->random_username($generated_username);

            $invitedata = Yii::$app->db->createCommand("INSERT INTO user (first_name,last_name,teamid,email,username,password_hash,confirmed_at,created_at,portal_id,killWordsSuffix,userAgent,user_role,sublevel,trial,trial_expired_at) VALUES ('" . $fname . "','" . $lname . "','" . $teamid . "','" . $email . "','" . $name . "','" . $pass . "','" . $time . "','" . $time . "','" . $portal_id . "','" . $killWordsSuffix . "','" . $userAgent . "','" . $user_account_type . "','" . $sublevel . "','" . $trial . "','" . $trial_expired_at . "')")->execute();



			// For new whitelabel - Update email templates

			 //if(Yii::$app->session->get('userid') == '16943'){
				 
				$emailtemQry = "SELECT  customer_email_template,subuser_email_template,emailsitelogo from `portals`  where `id`=" . $portal_id;
				$emailtemdata = Yii::$app->db->createCommand($emailtemQry)->queryOne();
				
				if(!empty($emailtemdata))
				{
					if(isset($emailtemdata['emailsitelogo']) && $emailtemdata['emailsitelogo'] != ''){
						$emailtemplateLogo = $emailtemdata['emailsitelogo'];
					}else{
						$emailtemplateLogo = Yii::$app->params['sitelogo'];
					}
					
					 if ($user_account_type != 1) {
						 
						if(isset($emailtemdata['subuser_email_template']) && $emailtemdata['subuser_email_template'] != ''){
							$subuser_email_template = base64_decode($emailtemdata['subuser_email_template']);
							
							$strrlc = ["[FIRSTNAME]", "[SITETITLE]", "[LASTNAME]", "[LOGINEMAIL]","[PASSWORD]"];
							$strtorpc   = [$fname,Yii::$app->params['sitetitle'], $lname,$email,$password];

							$subuser_email_template = str_replace($strrlc, $strtorpc, $subuser_email_template);
							
							$html = $this->renderPartial('/../mail/invitationEmailPortal', ['EmailLogo' => $emailtemplateLogo,'emailTemplate' => $subuser_email_template]);
							
						}else{
							
							 $html = $this->renderPartial('/../mail/invitationEmail', ['fname' => $fname, 'lname' => $lname, 'email' => $email, 'password' => $password]);
						}
						
						
					 }else{
						 
						 if(isset($emailtemdata['customer_email_template']) && $emailtemdata['customer_email_template'] != ''){
							$customer_email_template = base64_decode($emailtemdata['customer_email_template']);
							
							$strrlc = ["[FIRSTNAME]", "[SITETITLE]", "[LASTNAME]", "[LOGINEMAIL]","[PASSWORD]"];
							$strtorpc   = [$fname,Yii::$app->params['sitetitle'], $lname,$email,$password];

							$customer_email_template = str_replace($strrlc, $strtorpc, $customer_email_template);
							
							$html = $this->renderPartial('/../mail/invitationEmailCustomerPortal', ['EmailLogo' => $emailtemplateLogo,'emailTemplate' => $customer_email_template]);
						}else{
							
							 $html = $this->renderPartial('/../mail/invitationEmailCustomer', ['fname' => $fname, 'lname' => $lname, 'email' => $email, 'password' => $password]);
						}
						 
					 }
					
					
				}
				 
			// }

			// End - Update email templates

            //email starts
           /* if ($user_account_type != 1) {
                $html = $this->renderPartial('/../mail/invitationEmail', ['fname' => $fname, 'lname' => $lname, 'email' => $email, 'password' => $password]);
            } else {
                $html = $this->renderPartial('/../mail/invitationEmailCustomer', ['fname' => $fname, 'lname' => $lname, 'email' => $email, 'password' => $password]);
            } */

			
			
			$subjecttext = '';
			if(Yii::$app->params['portal_url'] == 'https://dashboard.angelinvestorsnetwork.com')
			{ 
				$subjecttext = ' | LinkedIn Lead Generation';
			}

            $mail = Yii::$app->mailer->compose()
                    ->setTo($email)
//                    ->setBcc('ronit@leadconnect.io')
                    //->setFrom([Yii::$app->params['adminEmail'] => Yii::$app->params['emailFromName'].' | You have been Invited'])
                    ->setFrom(Yii::$app->params['adminEmail'])
                    //->setReplyTo()
                    ->setSubject(Yii::$app->params['emailFromName'] . " | You have been Invited".$subjecttext)
                    ->setHtmlBody($html, 'text/html');
            $mail->send();
            //email ends
			
			// For outbound consulting
			if(in_array($teamid,$outboudadmis)){
			
			$ochtml = '<p><b>Admin Email:</b> '.Yii::$app->session->get('useremail').'</p>';
			$ochtml .= '<p><b> Subuser Email:</b> '.$email.'</p>';
			$ochtml .= '<p><b> Date:</b> '.date('Y-m-d').'</p>';
			
			 $mail = Yii::$app->mailer->compose()
                    ->setTo('darshit@intricare.net')
                    ->setFrom('no-reply@linkedfusion.io')
                    ->setSubject("Outbound consulting added new team member")
                    ->setHtmlBody($ochtml, 'text/html');
				$mail->send();
			}
			// End for outbound consulting

            Yii::$app->session->set('success_message', "New User is Added To your Team Successfully.");
            return $this->redirect(\Yii::$app->request->baseUrl . "/sub-users/index");
        }
    }

    public function random_username($string) {
        $nrRand = rand(0, 100);
        $string = preg_replace('/\s+/', '', $string);
        $username = trim($string) . trim($nrRand);
        return $username;
    }

    public function checkIfUserExist($string) {
        $select_sql = Yii::$app->db->createCommand("select username from user where username like '" . $string . "'")->queryAll();
        if (!empty($select_sql)) {
            return 1;
        } else {
            return 0;
        }
    }

    public function actionGetreport() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        try {
            $time = new \DateTime('now');
            $today = $time->format('Y-m-d');
            $month = $time->format('Y-m-01');
            $result = [];

            $userid = $_POST['id'];


            $result['allReq'] = count(Blacklist::find()->select('id')->where(['=', 'teamid', Yii::$app->session->get('teamid')])->andWhere(['!=', 'seq_id', 0])->all());

            //$result['allReq'] = count(Blacklist::find()->select('id')->where(['and',['=', 'teamid', Yii::$app->session->get('teamid')],['!=','seq_id',0]])->all());
            $result['allMonth'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $month], ['=', 'teamid', Yii::$app->session->get('teamid')]])->andWhere(['!=', 'seq_id', 0])->all());
            $result['allToday'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $today], ['=', 'teamid', Yii::$app->session->get('teamid')]])->andWhere(['!=', 'seq_id', 0])->all());



            $result['allMyToday'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $today], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
            $result['allMyMonth'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $month], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
            $result['allMy'] = count(Blacklist::find()->select('id')->where(['and', ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->andWhere(['!=', 'seq_id', 0])->all());



            $result['allMyAcceptedToday'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $today], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_accepted', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
            $result['allMyAcceptedMonth'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $month], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_accepted', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
            $result['allMyAccepted'] = count(Blacklist::find()->select('id')->where(['and', ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_accepted', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
        } catch (Exception $e) {
            echo 'Caught exception: ', $e->getMessage(), "\n";
            exit;
        }

        echo json_encode($result);
        exit;
    }

    public function actionChangeuserrole() {
        $userid = $_POST['id'];
        $userRole = $_POST['userRole'];
        $sql = Yii::$app->db->createCommand("update user set user_role = '$userRole' where id =" . $userid)->execute();
    }
	
	public function actionSubusermakeadmin() {
		
		if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		
		$newadmin = $_POST['subuserId'];
		$oldadmin = Yii::$app->session->get('userid');
		
		//echo "update user set teamid = '".$newadmin."' where teamid ='".$oldadmin."'"; exit;
		
		$sqluser = Yii::$app->db->createCommand("update user set teamid = '".$newadmin."' where teamid ='".$oldadmin."'")->execute();
		
		$sqlblk = Yii::$app->db->createCommand("update blacklist set teamid = '".$newadmin."' where teamid ='".$oldadmin."'")->execute();
		
		$getNewadminemailqur = "SELECT  email from `user` where `id`=" .$newadmin;
	    $getemailval = Yii::$app->db->createCommand($getNewadminemailqur)->queryOne();
				
		
		$notes = 'Admin changed form '.Yii::$app->session->get('useremail').' to '.$getemailval['email'];
		
		$sqlblk = Yii::$app->db->createCommand("INSERT INTO `admin_logs` (`from_user_id`, `to_user_id`, `note`) VALUES ('".$oldadmin."', '".$newadmin."', '".$notes."')")->execute();
		
		
	//	$url = \Yii::$app->request->baseUrl . "/site/signout";
       // return $this->redirect($url);
		
		//Yii::$app->runAction('/web/site/signout');
	
	 
	}
	
	public function actionAddnewaccount() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $portal_id = Yii::$app->session->get('portal_id');



        if (isset($_POST['fname'])) {
            $fname = ucfirst($_POST['fname']);
            $fname = addslashes($fname);
            $fname = htmlspecialchars($fname);
        }
        if (isset($_POST['lname'])) {
            $lname = ucfirst($_POST['lname']);
            $lname = addslashes($lname);
            $lname = htmlspecialchars($lname);
        }
        $email = $_POST['email'];
        $teamid = $_POST['teamid'];

        $password = substr(str_shuffle("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"), -3);
        $password .= substr(str_shuffle("0123456789"), -2);
        $password .= substr(str_shuffle("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"), -2);
        $pass = password_hash($password, PASSWORD_DEFAULT);
        $time = time();

        $killWordsSuffix = 'bsn,ceo,certified,copywriter,cpc,digital,dr,drs,expert,freelance,hubspot,internet,lion,lme,lmt,ma,marketing,mba,md,mim,msc,ninja,online,pharma,phd,ppc,seo,sip,videoseo';
        $userAgent = $_SERVER['HTTP_USER_AGENT'];
        
		$user = Yii::$app->db->createCommand("select *  from user where id =" . Yii::$app->session->get('userid'))->queryOne();
		$sublevel = $user['sublevel'];
		$trial_expired_at = $user['trial_expired_at'];
		
        $sqlUserdata = "SELECT  * from `user`  where `email`='" . $email . "' and `portal_id`=" . $portal_id;
        $dataUserarry = Yii::$app->db->createCommand($sqlUserdata)->queryOne();
        if (!empty($dataUserarry['id'])) {
            Yii::$app->session->set('error_message', "Email Id already exists.!");
            return $this->redirect(\Yii::$app->request->baseUrl . "/sub-users/manageaccounts");
        } else {

            do {
                $generated_username = $this->random_username(explode('@', $email)[0]);
                $exist = $this->checkIfUserExist($generated_username);
            } while ($exist == 1);
            $name = $this->random_username($generated_username);
			
            $invitedata = Yii::$app->db->createCommand("INSERT INTO user (first_name,last_name,teamid,email,username,password_hash,confirmed_at,created_at,portal_id,killWordsSuffix,userAgent,user_role,sublevel,trial,trial_expired_at,lastResponseChecked,acceptedResponseCheckedAt,nextResponseChecked,isLastResponseChecked) VALUES ('" . $fname . "','" . $lname . "','" . $teamid . "','" . $email . "','" . $name . "','" . $pass . "','" . $time . "','" . $time . "','" . $portal_id . "','" . $killWordsSuffix . "','" . $userAgent . "',3,'" . $sublevel . "','0','" . $trial_expired_at . "','" . round(time()*1000) . "','" . round(time()*1000) . "','" . round(time()*1000) . "',1)")->execute();  
			$accountId = Yii::$app->db->getLastInsertID();
			Yii::$app->db->createCommand("INSERT INTO accountpriority (userId,accountId,activity) VALUES ('" . $teamid . "','" . $accountId . "',0)")->execute(); 
            Yii::$app->session->set('success_message', "New Account Added Successfully.");   
            return $this->redirect(\Yii::$app->request->baseUrl . "/sub-users/manageaccounts");
        }
    }  
	public function actionGetadminlogs()
	{
		 if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		
		//echo 'Here'; exit;
		
		$user_timezone = '';
        $getTimezone = Yii::$app->db->createCommand("SELECT TimeZone FROM user where id =  " . Yii::$app->session->get('userid'))->queryOne();
        $user_timezone = $getTimezone['TimeZone'];
		
		$html = '<table style="width:100%; border-collapse: separate;border-spacing: 0 0.7em;" class="sequencefeedcontentData">';
		
		
		$sqllog = "SELECT note,created_at from admin_logs where from_user_id = ".Yii::$app->session->get('userid')." OR to_user_id=".Yii::$app->session->get('userid')." ORDER BY `id` DESC";
        $logsrow = Yii::$app->db->createCommand($sqllog)->queryAll();
		
		foreach($logsrow as $lrow){
			
		 $respond = strtotime($lrow['created_at']);
         $ist_date = \DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d H:i:s', $respond), new \DateTimeZone('UTC'));
         $gmt_date = clone $ist_date;
         $gmt_date->setTimeZone(new \DateTimeZone($user_timezone));
         $server_start_time = $gmt_date->format('d M Y h:i A');
		
		$html .= '<tr><td style="font-size:14px;"><b>'.$server_start_time.'</b>: '.$lrow['note'].' </td></tr>';
		}
		
		$html .= '</table>';
		
		echo $html;
		
	}

    public function actionDeleteuser() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $userid = $_POST['id'];
        $sublevel = $_POST['sublevel'];
        try {

            $UserProxyDetail = Yii::$app->db->createCommand("select proxyUsername from  user  where teamid = '".Yii::$app->session->get('userid')."' AND id =" . $userid)->queryOne();

            $sql = Yii::$app->db->createCommand("update user set is_deleted = '1',proxyIp='',proxyPort='',proxyUsername='',proxyPassword='',popupstatus=0,app_container='',app_container_ip=null,app_container_port='' where teamid = '".Yii::$app->session->get('userid')."' AND id =" . $userid)->execute();

            $updated_at = date("d M Y h:i:s A");
            $notemsg = 'User Deleted by ' . Yii::$app->session->get('useremail') . ',  ' . date("F d, Y h:i:s A", time());
            $sqlins = "Insert into `user_notes` SET `note` ='" . $notemsg . "', updated_at = '" . $updated_at . "', `user_id`='" . $userid . "', last_updated_by = '" . \Yii::$app->session->get('userid') . "'";
            Yii::$app->db->createCommand($sqlins)->execute();

            if (!empty($UserProxyDetail)) {
                if (!empty($UserProxyDetail['proxyUsername'])) {
                    $UserProxyDetail = explode("-", $UserProxyDetail['proxyUsername']);
                    $zoneName = $UserProxyDetail[4];
                    $iP = $UserProxyDetail[6];
                    if (!empty($iP) && !empty($zoneName)) {
                        $ch_deleteIp = curl_init();
                        curl_setopt($ch_deleteIp, CURLOPT_URL, 'https://luminati.io/api/zone/ips');
                        curl_setopt($ch_deleteIp, CURLOPT_RETURNTRANSFER, 1);
                        curl_setopt($ch_deleteIp, CURLOPT_CUSTOMREQUEST, 'DELETE');
                        curl_setopt($ch_deleteIp, CURLOPT_POSTFIELDS, "{\"customer\":\"halfpixel\",\"zone\":\"$zoneName\",\"ips\":[\"$iP\"]}");
//                        curl_setopt($ch_deleteIp, CURLOPT_USERPWD, 'arpan@halfpixel.co.in' . ':' . 'Asdf@123');
                        $headers = array();
                        $headers[] = 'Content-Type: application/json';
                        $headers[] = 'Authorization: Bearer c2b5593e-9399-4607-b4f1-8b3f35aa9ae7';
                        curl_setopt($ch_deleteIp, CURLOPT_HTTPHEADER, $headers);
                        $result_deleteIp = curl_exec($ch_deleteIp);
                        if (curl_errno($ch_deleteIp)) {
                            echo 'Error:' . curl_error($ch_deleteIp);
                        }
                        curl_close($ch_deleteIp);
                    }
                }
            }


            // Send email if user not using free account
            if ($sublevel > 0) {

                $UserDetail = Yii::$app->db->createCommand("select email,first_name,last_name,trial_expired_at  from  user  where teamid = '".Yii::$app->session->get('userid')."' AND id =" . $userid)->queryOne();

                $plan = "";
                if ($sublevel == 0) {
                    //$plan="Free Forever"; 
                    $plan = "";
                } else if ($sublevel == 1) {
                    $plan = "Professional Monthly";
                } else if ($sublevel == 2) {
                    $plan = "Professional Quarterly";
                } else if ($sublevel == 3) {
                    $plan = "Grow Monthly";
                } else if ($sublevel == 4) {
                    $plan = "Grow Quarterly";
                } else if ($sublevel == 5) {
                    $plan = "Ultimate Monthly";
                } else if ($sublevel == 6) {
                    $plan = "Ultimate Quarterly";
                } else if ($sublevel == 7) {
                    $plan = "Ultimate Plus";
                }
                $emailaadress = $UserDetail['email'];
                $trial_expired_at = $UserDetail['trial_expired_at'];
                $fullname = $UserDetail['first_name'] . ' ' . $UserDetail['last_name'];
                include("../include/senddeteledemail.php");
            }
        } catch (Exception $e) {
            echo 'Caught exception: ', $e->getMessage(), "\n";
        }
        //return $this->redirect('dashboard'); 
    }
	
	public function actionAssignlicenceuser(){
		
		if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		
		//echo '<pre>'; print_r($_POST); exit;
        $updateuserid = $_POST['uptid'];
        $teamid = $_POST['teamId'];
		
		$UserDetail = Yii::$app->db->createCommand("select id,sublevel,stripe_cust_id from  user  where id =" . $teamid)->queryOne();
		
		//echo "select id,sublevel,stripe_cust_id from  user  where id =" . $teamid;
		
		if(isset($UserDetail['stripe_cust_id']) && $UserDetail['stripe_cust_id'] != ''){
			
			$invDetail = Yii::$app->db->createCommand("select SubcriptionQty from invoice_details  where CustomerID ='" . $UserDetail['stripe_cust_id']."'")->queryOne();
			
			//echo "select SubcriptionQty from invoice_details  where CustomerID ='" . $UserDetail['stripe_cust_id']."'"; 
			
			if(isset($invDetail['SubcriptionQty']) && $invDetail['SubcriptionQty'] > 1){
				 
				//echo "update user set sublevel = ".$UserDetail['sublevel']." where id =" . $updateuserid; exit; 
				
				$sqlupt = Yii::$app->db->createCommand("update user set sublevel = '".$UserDetail['sublevel']."' where id =" . $updateuserid)->execute();
				
				$subqtyupt = $invDetail['SubcriptionQty'] - 1;
				
				$sqlupt2 = Yii::$app->db->createCommand("update invoice_details set SubcriptionQty = ".$subqtyupt." where CustomerID = '" . $UserDetail['stripe_cust_id']."'")->execute();
				
				
				$updated_at = date("d M Y h:i:s A");
				$notemsg = 'Assign licence to user by admin,  ' . date("F d, Y h:i:s A", time());
				$sqlins = "Insert into `user_notes` SET `note` ='" . $notemsg . "', updated_at = '" . $updated_at . "', `user_id`='" . $updateuserid . "', last_updated_by = '" .  $teamid . "'";
				Yii::$app->db->createCommand($sqlins)->execute();
				
			}
			else{
				echo 0;
			}
		}else{
			echo 0;
		}
	}

    public function actionSubuserslogin() {
        include '../web/updateLinkedInCookie.php';
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $email = $_POST['username'];
        $password = $_POST['password'];
        $UserID = $_POST['UserID'];
        $sql = Yii::$app->db->createCommand("select * from user where email='" . $email . "' and id='$UserID' and password_hash='" . $password . "'")->queryOne();
        if (!empty($sql)) {

            $adminEmail = Yii::$app->session->get('useremail');

            Yii::$app->session->remove('useremail');
            Yii::$app->session->remove('teamid');
            Yii::$app->session->remove('userid');
            Yii::$app->session->remove('username');
            Yii::$app->session->remove('__returnUrl');
            Yii::$app->session->remove('__id');
            Yii::$app->session->remove('loggedinwith_subusers');
//            Yii::$app->session->remove('user_role');


            $useremail = $sql['email'];
            $username = $sql['username'];
            $userid = $sql['id'];
            $teamid = $sql['teamid'];
            $first_name = $sql['first_name'];
            $last_name = $sql['last_name'];
            $companyname = $sql['companyname'];
            $last_login_at = $sql['last_login_at'];
            $portal_id = $sql['portal_id'];


            Yii::$app->session->set('useremail', $useremail);
            Yii::$app->session->set('username', $username);
            Yii::$app->session->set('userid', $userid);
            Yii::$app->session->set('teamid', $teamid);
            Yii::$app->session->set('first_name', $first_name);
            Yii::$app->session->set('last_name', $last_name);
            Yii::$app->session->set('companyname', $companyname);
//            Yii::$app->session->set('google', '1');
            Yii::$app->session->set('last_login_at', $last_login_at);
            Yii::$app->session->set('portal_id', $portal_id);
            Yii::$app->session->set('adminEmail', $adminEmail);
//            Yii::$app->session->set('user_role',$sql['user_role']);
            Yii::$app->session->set('loggedinwith_subusers', "true");

            $last_login_at = Yii::$app->db->createCommand("update `user` SET `last_login_at`=" . time() . " where `id`=" . $UserID)->execute();

            $proxyIp = $sql['proxyIp'];
            $proxyPort = $sql['proxyPort'];
            $proxyUsername = $sql['proxyUsername'];
            $proxyPassword = $sql['proxyPassword'];
            $cookie = $sql['cookie'];
            $csrf = $sql['csrf'];
            if (!empty($proxyIp) && !empty($proxyPort) && !empty($proxyUsername) && !empty($proxyPassword) && !empty($cookie) && !empty($csrf)) {
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/me",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    //CURLOPT_VERBOSE => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: Mozilla/5.0 (Windows NT 6.1; rv:75.0) Gecko/20100101 Firefox/75.0",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $curlResult = curl_exec($curl);
                $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                $headers = substr($curlResult, 0, $header_size);
                $curlResult = substr($curlResult, $header_size);
                $newCookie = getCookiesLdnFromHeaders($headers);
                if (!empty($newCookie)) {
                    updateUserLdnCookies($UserID, $newCookie);
                }
                //echo '<pre>';print_r($curlResult); die;
                if (!empty($curlResult)) {
                    $decodedRes = json_decode($curlResult);
                    if (!empty($decodedRes->miniProfile->picture)) {
                        $picture = (array) $decodedRes->miniProfile->picture;
                        $topProfilePic = $picture['com.linkedin.common.VectorImage']->rootUrl . $picture['com.linkedin.common.VectorImage']->artifacts[0]->fileIdentifyingUrlPathSegment;
                        Yii::$app->session->set('top_profile_pic', $topProfilePic);
                        Yii::$app->session->set('linkedin_firstname', $decodedRes->miniProfile->firstName);
                        Yii::$app->session->set('linkedin_lastname', $decodedRes->miniProfile->lastName);
                    } else {
                        Yii::$app->session->set('top_profile_pic', '');
                    }
                } else {
                    Yii::$app->session->set('top_profile_pic', '');
                }
            } else {
                Yii::$app->session->set('top_profile_pic', '');
            }
            return "1";
        } else {
            return "0";
        }
    }

    public function actionSequencematrix() { // Get matrix data count on sequece list page
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $user_id = $_POST['user_id'];
        //Yii::$app->session->get('userid')

        $tottask = 0;
        $totrequestsent = 0;
        $totaccepted = 0;
        $totreponses = 0;
        $totwithdrown = 0;
        // Total task
        $sqltottask = "SELECT id FROM completed_tasks where completedOn >= ( CURDATE() - INTERVAL 14 DAY ) AND status = 'Complete' AND userId = " . $user_id;
        $rowstottask = Yii::$app->db->createCommand($sqltottask)->queryAll();
        $tottask1 = count($rowstottask);

        $sqltottask2 = "SELECT id FROM completed_tasks where completedOn >= ( CURDATE() - INTERVAL 7 DAY ) AND status = 'Complete' AND userId = " . $user_id;
        $rowstottask2 = Yii::$app->db->createCommand($sqltottask2)->queryAll();
        $tottask2 = count($rowstottask2);

        $percentChange = $tottask1 - $tottask2;
        $percentChange = $tottask2 - $percentChange;

        if ($percentChange >= 0) {
            $ptype = 1;
        } else {
            $ptype = 0;
        }


        /* if ( $tottask1 > 0 ) {
          $percentChange = round($tottask2 / ($tottask1 / 100),2);
          } else {
          $percentChange = 0;
          } */

        $tottask = $tottask2 . ':' . $percentChange . ':' . $ptype;

        // End Total task
        // Request sent
        $sqltotreqs = "SELECT id FROM completed_tasks where completedOn >= ( CURDATE() - INTERVAL 14 DAY ) AND status = 'Complete' AND type = 'Connect' AND userId = " . $user_id;
        $rowstotreqs = Yii::$app->db->createCommand($sqltotreqs)->queryAll();
        $totrequestsent1 = count($rowstotreqs);

        $sqltotreqs2 = "SELECT id FROM completed_tasks where completedOn >= ( CURDATE() - INTERVAL 7 DAY ) AND status = 'Complete' AND type = 'Connect' AND userId = " . $user_id;
        $rowstotreqs2 = Yii::$app->db->createCommand($sqltotreqs2)->queryAll();
        $totrequestsent2 = count($rowstotreqs2);

        $percentChange2 = $totrequestsent1 - $totrequestsent2;
        $percentChange2 = $totrequestsent2 - $percentChange2;
        if ($percentChange2 >= 0) {
            $ptype2 = 1;
        } else {
            $ptype2 = 0;
        }

        /*
          if ( $totrequestsent1 > 0 ) {
          $percentChange2 = round($totrequestsent2 / ($totrequestsent1 / 100),2);
          } else {
          $percentChange2 = 0;
          } */

        $totrequestsent = $totrequestsent2 . ":" . $percentChange2 . ":" . $ptype2;
        // End
        // Accepted 

        $sqltotaccepted = "SELECT id FROM blacklist where accepted_at >= ( CURDATE() - INTERVAL 14 DAY ) AND is_accepted = '1' AND userId = " . $user_id;
        $rowstotaccepted = Yii::$app->db->createCommand($sqltotaccepted)->queryAll();
        $totaccepted1 = count($rowstotaccepted);

        $sqltotaccepted2 = "SELECT id FROM blacklist where accepted_at >= ( CURDATE() - INTERVAL 7 DAY ) AND is_accepted = '1' AND userId = " . $user_id;
        $rowstotaccepted2 = Yii::$app->db->createCommand($sqltotaccepted2)->queryAll();
        $totaccepted2 = count($rowstotaccepted2);

        $percentChange3 = $totaccepted1 - $totaccepted2;
        $percentChange3 = $totaccepted2 - $percentChange3;
        if ($percentChange3 >= 0) {
            $ptype3 = 1;
        } else {
            $ptype3 = 0;
        }

        /* if ( $totaccepted1 > 0 ) {
          $percentChange3 = round($totaccepted2 / ($totaccepted1 / 100),2);
          } else {
          $percentChange3 = 0;
          } */

        $totaccepted = $totaccepted2 . ":" . $percentChange3 . ":" . $ptype3;
        // End
        // Responses

        $sqltotreponses = "SELECT id FROM blacklist where respond >= (UNIX_TIMESTAMP(CURRENT_DATE - INTERVAL 14 DAY)*1000) AND is_response = '1' AND userId  = " . $user_id;

        $rowstotreponses = Yii::$app->db->createCommand($sqltotreponses)->queryAll();
        $totreponses1 = count($rowstotreponses);

        $sqltotreponses2 = "SELECT id FROM blacklist where respond >= (UNIX_TIMESTAMP(CURRENT_DATE - INTERVAL 7 DAY)*1000) AND is_response = '1' AND userId = " . $user_id;
        $rowstotreponses2 = Yii::$app->db->createCommand($sqltotreponses2)->queryAll();
        $totreponses2 = count($rowstotreponses2);

        $percentChange4 = $totreponses1 - $totreponses2;
        $percentChange4 = $totreponses2 - $percentChange4;
        if ($percentChange4 >= 0) {
            $ptype4 = 1;
        } else {
            $ptype4 = 0;
        }


        /* if ( $totreponses1 > 0 ) {
          $percentChange4 = round($totreponses2 / ($totreponses1 / 100),2);
          } else {
          $percentChange4 = 0;
          } */

        $totreponses = $totreponses2 . ":" . $percentChange4 . ":" . $ptype4;


        // End
        // Withdrown

        $sqltotwithdrown = "SELECT id FROM completed_tasks where completedOn >= ( CURDATE() - INTERVAL 14 DAY ) AND triggerOnInvitationAccepted = '1' AND userId = " . $user_id;
        $rowstotwithdrown = Yii::$app->db->createCommand($sqltotwithdrown)->queryAll();
        $totwithdrown1 = count($rowstotwithdrown);

        $sqltotwithdrown2 = "SELECT id FROM completed_tasks where completedOn >= ( CURDATE() - INTERVAL 7 DAY ) AND triggerOnInvitationAccepted = '1' AND userId = " . $user_id;
        $rowstotwithdrown2 = Yii::$app->db->createCommand($sqltotwithdrown2)->queryAll();
        $totwithdrown2 = count($rowstotwithdrown2);

        $percentChange5 = $totwithdrown1 - $totwithdrown2;
        $percentChange5 = $totwithdrown2 - $percentChange5;

        if ($percentChange5 >= 0) {
            $ptype5 = 1;
        } else {
            $ptype5 = 0;
        }

        /* if ( $totwithdrown1 > 0 ) {
          $percentChange5 = round($totwithdrown2 / ($totwithdrown1 / 100),2);
          } else {
          $percentChange5 = 0;
          } */

        $totwithdrown = $totwithdrown2 . ":" . $percentChange5 . ":" . $ptype5;

        // End

        echo $tottask . ',' . $totrequestsent . ',' . $totaccepted . ',' . $totreponses . ',' . $totwithdrown;
    }

    public function actionExportchartdata() {
        $s_date = implode('-', array_reverse(explode('/', $_POST['cstart_date'])));
        $e_date = implode('-', array_reverse(explode('/', $_POST['cend_date'])));

        $userid = $_POST['export_uid']; //Yii::$app->session->get('userid');
        $team_id = Yii::$app->session->get('teamid');

        $res_arr = array();
        $rep_req_data = Yii::$app->db->createCommand("SELECT COUNT(id) as request, CAST(created_at AS DATE) as created_at FROM blacklist WHERE (DATE(created_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . $team_id . "' AND seq_id != '0' GROUP BY CAST(created_at AS DATE)")->queryAll();

        $rep_acc_data = Yii::$app->db->createCommand("SELECT COUNT(id) as accepted, CAST(created_at AS DATE) as created_at FROM blacklist WHERE (DATE(created_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . $team_id . "' AND is_accepted = 1 AND  seq_id != '0' GROUP BY CAST(created_at AS DATE)")->queryAll();

        $rep_res_data = Yii::$app->db->createCommand("SELECT COUNT(id) as responded, CAST(created_at AS DATE) as created_at FROM blacklist WHERE (DATE(created_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . $team_id . "' AND is_response = 1 AND  seq_id != '0' GROUP BY CAST(created_at AS DATE)")->queryAll();
        //echo "<pre>";print_r($rep_acc_data);die;

        $dates = $this->getallDates($s_date, $e_date);
        $k = 0;
        foreach ($dates as $date_v) {

            $arr = [];
            $rkey = '';
            $akey = '';
            $reqkey = '';

            $reqkey = array_search($date_v, array_column($rep_req_data, 'created_at'));
            $rkey = array_search($date_v, array_column($rep_res_data, 'created_at'));
            $akey = array_search($date_v, array_column($rep_acc_data, 'created_at'));

            if ($rkey !== false && $reqkey !== false && $akey !== false) {
                $arr['res'] = $rep_res_data[$rkey]['responded'];
                $arr['acc'] = $rep_acc_data[$akey]['accepted'];
                $arr['req'] = $rep_req_data[$reqkey]['request'];
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($rkey !== false && $reqkey !== false && $akey === false) {
                $arr['res'] = $rep_res_data[$rkey]['responded'];
                $arr['acc'] = 0;
                $arr['req'] = $rep_req_data[$reqkey]['request'];
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($rkey !== false && $reqkey === false && $akey !== false) {
                $arr['res'] = $rep_res_data[$rkey]['responded'];
                $arr['acc'] = $rep_acc_data[$akey]['accepted'];
                $arr['req'] = 0;
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($rkey === false && $reqkey !== false && $akey !== false) {
                $arr['res'] = 0;
                $arr['acc'] = $rep_acc_data[$akey]['accepted'];
                $arr['req'] = $rep_req_data[$reqkey]['request'];
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($reqkey !== false && $akey === false && $rkey === false) {
                $arr['req'] = $rep_req_data[$reqkey]['request'];
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $arr['res'] = 0;
                $arr['acc'] = 0;
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($rkey !== false && $akey === false && $reqkey === false) {
                $arr['res'] = $rep_res_data[$rkey]['responded'];
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $arr['req'] = 0;
                $arr['acc'] = 0;
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($akey !== false && $rkey === false && $reqkey === false) {
                $arr['acc'] = $rep_acc_data[$akey]['accepted'];
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $arr['res'] = 0;
                $arr['req'] = 0;
                $res_arr[$k] = $arr;
                $k++;
            }
        }



        $data = ",,,," . Yii::$app->params['sitetitle'] . " Export data (" . $_POST['cstart_date'] . " - " . $_POST['cend_date'] . ") \r\n\r\nDate,Sent,Accepted,Response\r\n";

        foreach ($res_arr as $res) {

            $data .= $res['date'] .
                    ',' . $res['req'] .
                    ',' . $res['acc'] .
                    ',' . $res['res'] .
                    "\r\n";
        }

        header("Content-type: text/csv");
        header("Content-Disposition: attachment; filename=" . Yii::$app->params['sitetitle'] . ".csv");
        header("Content-Transfer-Encoding: ASCII\r\n");
        header("Pragma: no-cache");
        header("Expires: 0");

        echo $data . "\n";
        die;
    }

	public function actionExportchartdatateam() {
        $s_date = implode('-', array_reverse(explode('/', $_POST['cstart_date'])));
        $e_date = implode('-', array_reverse(explode('/', $_POST['cend_date'])));

        $userid = $_POST['export_uid']; //Yii::$app->session->get('userid');
        $team_id = Yii::$app->session->get('teamid');

        $res_arr = array();
        $rep_req_data = Yii::$app->db->createCommand("SELECT COUNT(id) as request, CAST(created_at AS DATE) as created_at FROM blacklist WHERE (DATE(created_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND userid = '" . $userid . "' AND seq_id != '0' GROUP BY CAST(created_at AS DATE)")->queryAll();

        $rep_acc_data = Yii::$app->db->createCommand("SELECT COUNT(id) as accepted, CAST(created_at AS DATE) as created_at FROM blacklist WHERE (DATE(created_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND userid = '" . $userid . "' AND is_accepted = 1 AND  seq_id != '0' GROUP BY CAST(created_at AS DATE)")->queryAll();

        $rep_res_data = Yii::$app->db->createCommand("SELECT COUNT(id) as responded, CAST(created_at AS DATE) as created_at FROM blacklist WHERE (DATE(created_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND userid = '" . $userid . "' AND is_response = 1 AND  seq_id != '0' GROUP BY CAST(created_at AS DATE)")->queryAll();
        //echo "<pre>";print_r($rep_acc_data);die;

        $dates = $this->getallDates($s_date, $e_date);
        $k = 0;
        foreach ($dates as $date_v) {

            $arr = [];
            $rkey = '';
            $akey = '';
            $reqkey = '';

            $reqkey = array_search($date_v, array_column($rep_req_data, 'created_at'));
            $rkey = array_search($date_v, array_column($rep_res_data, 'created_at'));
            $akey = array_search($date_v, array_column($rep_acc_data, 'created_at'));

            if ($rkey !== false && $reqkey !== false && $akey !== false) {
                $arr['res'] = $rep_res_data[$rkey]['responded'];
                $arr['acc'] = $rep_acc_data[$akey]['accepted'];
                $arr['req'] = $rep_req_data[$reqkey]['request'];
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($rkey !== false && $reqkey !== false && $akey === false) {
                $arr['res'] = $rep_res_data[$rkey]['responded'];
                $arr['acc'] = 0;
                $arr['req'] = $rep_req_data[$reqkey]['request'];
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($rkey !== false && $reqkey === false && $akey !== false) {
                $arr['res'] = $rep_res_data[$rkey]['responded'];
                $arr['acc'] = $rep_acc_data[$akey]['accepted'];
                $arr['req'] = 0;
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($rkey === false && $reqkey !== false && $akey !== false) {
                $arr['res'] = 0;
                $arr['acc'] = $rep_acc_data[$akey]['accepted'];
                $arr['req'] = $rep_req_data[$reqkey]['request'];
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($reqkey !== false && $akey === false && $rkey === false) {
                $arr['req'] = $rep_req_data[$reqkey]['request'];
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $arr['res'] = 0;
                $arr['acc'] = 0;
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($rkey !== false && $akey === false && $reqkey === false) {
                $arr['res'] = $rep_res_data[$rkey]['responded'];
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $arr['req'] = 0;
                $arr['acc'] = 0;
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($akey !== false && $rkey === false && $reqkey === false) {
                $arr['acc'] = $rep_acc_data[$akey]['accepted'];
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $arr['res'] = 0;
                $arr['req'] = 0;
                $res_arr[$k] = $arr;
                $k++;
            }
        }



        $data = ",,,," . Yii::$app->params['sitetitle'] . " Export data (" . $_POST['cstart_date'] . " - " . $_POST['cend_date'] . ") \r\n\r\nDate,Sent,Accepted,Response\r\n";

        foreach ($res_arr as $res) {

            $data .= $res['date'] .
                    ',' . $res['req'] .
                    ',' . $res['acc'] .
                    ',' . $res['res'] .
                    "\r\n";
        }

        header("Content-type: text/csv");
        header("Content-Disposition: attachment; filename=" . Yii::$app->params['sitetitle'] . ".csv");
        header("Content-Transfer-Encoding: ASCII\r\n");
        header("Pragma: no-cache");
        header("Expires: 0");

        echo $data . "\n";
        die;
    }

    public function getallDates($s_date, $e_date) {
        $dates = array();

        $d1 = strtotime($s_date);
        $d2 = strtotime($e_date);

        for ($currentDate = $d1; $currentDate <= $d2; $currentDate += (86400)) {
            $date = date('Y-m-d', $currentDate);
            $dates[] = $date;
        }
        return $dates;
    }
	
	public function actionRefreshprofile() { 
        include('../web/updateLinkedInCookie.php');
        /* if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        } */ 
		$userId = $_POST['userId'];
        $UserDetail = Yii::$app->db->createCommand("select  *  from  user  where id =" . $userId)->queryOne();
        //echo '<pre>'; print_r($UserDetail); die;
        $proxyIp = $UserDetail['proxyIp'];
        $proxyPort = $UserDetail['proxyPort'];
        $proxyUsername = $UserDetail['proxyUsername'];
        $proxyPassword = $UserDetail['proxyPassword'];
        $userAgent = $UserDetail['userAgent'];
        $cookie = $UserDetail['cookie'];
        $csrf = $UserDetail['csrf'];
        $userId = $UserDetail['id'];

        $profileData = array();


        //06June2020 starts
        $profileData['pic_100_100'] = '';
        $profileData['pic_400_400'] = '';
        $apiRes_me = '';



        $profileData['numConnections'] = 0;
        $profileData['pendingConnections'] = 0;
        $profileData['numTotalSentInvitations'] = 0;


        $apiRes_IdentityProfilesProfileView = '';
        $apiRes_IdentityProfilesProfileContactInfo = '';
        //06June2020 ends
        $api_ssiScore = ''; //04-12-2020



        if ($proxyIp && $proxyPort && $proxyUsername && $proxyPassword && !empty($cookie) && !empty($csrf)) {

            //if (!empty($cookie) && !empty($csrf)) {
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://www.linkedin.com/voyager/api/me",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_HEADER => true,
                /* CURLOPT_VERBOSE=>true, */
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_NONE,
                CURLOPT_HTTPPROXYTUNNEL => 1,
                CURLOPT_PROXY => "$proxyIp",
                CURLOPT_PROXYPORT => "$proxyPort",
                CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => array(
                    "cookie: $cookie",
                    "csrf-token: $csrf",
                    "x-http-method-override: GET",
                    "Host: www.linkedin.com",
                    "User-Agent: $userAgent",
                    "Accept-Language: en-US,en;q=0.5",
                    "Accept-Encoding: gzip, deflate, br",
                    "content-type: application/x-www-form-urlencoded",
                    "x-li-lang: en_US",
                    "x-restli-protocol-version: 2.0.0",
                    "Origin: https://www.linkedin.com",
                    "TE: Trailers"
                ),
            ));
            $curlResult = curl_exec($curl);
            $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
            $headers = substr($curlResult, 0, $header_size);

            $curlResult = substr($curlResult, $header_size);
            $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            $newCookie = getCookiesLdnFromHeaders($headers);
            if (!empty($newCookie)) {
                updateUserLdnCookies($userId, $newCookie);
            }
            //echo 'DFDFDF:<pre>'; print_r($curlResult);echo '</pre>';
            /* if (!empty($curlResult)) {
              echo '<br/>::::A';
              }else{
              echo '<br/>::::B';
              } */
//die;
			
	
            if ($http_code == 200) {
                $apiRes_me = $decodedRes = json_decode($curlResult);				
				$loggedin_data= $apiRes_me->miniProfile;
				$objectUrn=$loggedin_data->objectUrn;
				$entityUrn=$loggedin_data->entityUrn;
				$publicIdentifier=$loggedin_data->publicIdentifier;
				$trackingId=$loggedin_data->trackingId;
				
				$service_version ="";
				$linkedin_notification = "https://www.linkedin.com/notifications/";
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, $linkedin_notification);
				curl_setopt($ch, CURLOPT_REFERER, "https://www.linkedin.com/mynetwork/");
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_ACCEPT_ENCODING, ''); 
				curl_setopt($ch, CURLOPT_HTTPPROXYTUNNEL, 1);
				curl_setopt($ch, CURLOPT_PROXY, "$proxyIp");
				curl_setopt($ch, CURLOPT_PROXYPORT, "$proxyPort");
				curl_setopt($ch, CURLOPT_PROXYUSERPWD, "$proxyUsername:$proxyPassword");
				curl_setopt($ch, CURLOPT_HEADER, 1);
				curl_setopt($ch, CURLOPT_HTTPHEADER , array(
					"Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8",
					"Accept-Encoding: gzip, deflate, br",
					"Accept-Language: en-US,en;q=0.5",
					"Host: www.linkedin.com",
					"User-Agent: $userAgent",
					"Cookie: $cookie",
					"csrf-token: $csrf",
					"Upgrade-Insecure-Requests:	1" 
				));
				$notification_content = curl_exec($ch);
				$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
				$headers = substr($notification_content, 0, $header_size);
				$notification_content = substr($notification_content, $header_size);
				$service_version =$this->fetchValue($notification_content, '<meta name="serviceVersion" content="', '"');
				$update_usssr= "update user set serviceVersion='" . $service_version . "' where id='" . $userId . "'";
                Yii::$app->db->createCommand($update_usssr)->execute();
				
				$update_bbbb = "update user_profile set objectUrn='" . $objectUrn . "', entityUrn='" . $entityUrn . "', publicIdentifier='" . $publicIdentifier . "', trackingId='" . $trackingId . "' where user_id='" . $userId . "'";
                Yii::$app->db->createCommand($update_bbbb)->execute();
				
                if (isset($decodedRes->miniProfile->picture)) {
                    $picture = (array) $decodedRes->miniProfile->picture;
                    if (isset($picture['com.linkedin.common.VectorImage']->rootUrl) && isset($picture['com.linkedin.common.VectorImage']->artifacts[0]->fileIdentifyingUrlPathSegment)) {
                        $profileData['pic_100_100'] = $picture['com.linkedin.common.VectorImage']->rootUrl . $picture['com.linkedin.common.VectorImage']->artifacts[0]->fileIdentifyingUrlPathSegment;
                        \Yii::$app->session->set('top_profile_pic', $profileData['pic_100_100']);
                    }
                    if (isset($picture['com.linkedin.common.VectorImage']->rootUrl) && isset($picture['com.linkedin.common.VectorImage']->artifacts[2]->fileIdentifyingUrlPathSegment)) {
                        $profileData['pic_400_400'] = $picture['com.linkedin.common.VectorImage']->rootUrl . $picture['com.linkedin.common.VectorImage']->artifacts[2]->fileIdentifyingUrlPathSegment;
                    }
                }




                if (!empty($cookie) && !empty($csrf)) {
                    $curlConnectionDetails = curl_init();
                    curl_setopt_array($curlConnectionDetails, array(
                        CURLOPT_URL => "https://www.linkedin.com/voyager/api/relationships/connectionsSummary/",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_HEADER => true,
                        /* CURLOPT_VERBOSE=>true, */
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_NONE,
                        CURLOPT_HTTPPROXYTUNNEL => 1,
                        CURLOPT_PROXY => "$proxyIp",
                        CURLOPT_PROXYPORT => "$proxyPort",
                        CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                        CURLOPT_CUSTOMREQUEST => "GET",
                        CURLOPT_HTTPHEADER => array(
                            "cookie: $cookie",
                            "csrf-token: $csrf",
                            "x-http-method-override: GET",
                            "Host: www.linkedin.com",
                            "User-Agent: $userAgent",
                            "Accept-Language: en-US,en;q=0.5",
                            "Accept-Encoding: gzip, deflate, br",
                            "content-type: application/x-www-form-urlencoded",
                            "x-li-lang: en_US",
                            "x-restli-protocol-version: 2.0.0",
                            "Origin: https://www.linkedin.com",
                            "TE: Trailers"
                        ),
                    ));
                    $connectionDetailsRes = curl_exec($curlConnectionDetails);
                    $header_size = curl_getinfo($curlConnectionDetails, CURLINFO_HEADER_SIZE);
                    $headers = substr($connectionDetailsRes, 0, $header_size);

                    $connectionDetailsRes = substr($connectionDetailsRes, $header_size);
                    $http_code = curl_getinfo($curlConnectionDetails, CURLINFO_HTTP_CODE);
                    $newCookie = getCookiesLdnFromHeaders($headers);
                    if (!empty($newCookie)) {
                        updateUserLdnCookies($userId, $newCookie);
                    }
                    if ($http_code == 200) {
                        $decodedJsonRes = json_decode($connectionDetailsRes);
                        //echo 'AA:<pre>'; print_r($decodedJsonRes);
                        if (isset($decodedJsonRes->numConnections)) {
                            $profileData['numConnections'] = $decodedJsonRes->numConnections;
                        }
                    } else {
                        //$profileData['numConnections'] = 0;//already define above
                    }
                    $curlInvitationDetails = curl_init();
                    curl_setopt_array($curlInvitationDetails, array(
                        CURLOPT_URL => "https://www.linkedin.com/voyager/api/relationships/invitationsSummaryV2?types=List(SENT_INVITATION_COUNT,PENDING_INVITATION_COUNT,UNSEEN_INVITATION_COUNT,PENDING_INVITATION_BY_FACET_COUNT)",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_HEADER => true,
                        /* CURLOPT_VERBOSE=>true, */
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_NONE,
                        CURLOPT_HTTPPROXYTUNNEL => 1,
                        CURLOPT_PROXY => "$proxyIp",
                        CURLOPT_PROXYPORT => "$proxyPort",
                        CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                        CURLOPT_CUSTOMREQUEST => "GET",
                        CURLOPT_HTTPHEADER => array(
                            /* "cookie: $cookie",
                              "csrf-token: $csrf",
                              "x-http-method-override: GET",
                              "Host: www.linkedin.com",
                              "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36",
                              "accept: application/vnd.linkedin.normalized+json+2.1",
                              "Accept-Language: en-US,en;q=0.5",
                              "Accept-Encoding: gzip, deflate, br",
                              //"content-type: application/x-www-form-urlencoded",
                              "x-li-lang: en_US",
                              "x-restli-protocol-version: 2.0.0",
                              "Origin: https://www.linkedin.com",
                              "TE: Trailers" */

                            "accept: application/vnd.linkedin.normalized+json+2.1",
                            "cookie: $cookie",
                            "csrf-token: $csrf",
                            //"x-http-method-override: GET",
                            "Host: www.linkedin.com",
                            "User-Agent: $userAgent",
                            "accept-language: en-US,en;q=0.9",
                            //"Accept-Encoding: gzip, deflate, br",
                            //"content-type: application/x-www-form-urlencoded",
                            "content-type: application/vnd.linkedin.normalized+json+2.1",
                            "x-li-lang: en_US",
                            //'x-li-track: {"clientVersion":"1.6.3394","osName":"web","timezoneOffset":5.5,"deviceFormFactor":"DESKTOP","mpName":"voyager-web","displayDensity":1}',
                            "x-restli-protocol-version: 2.0.0",
                            "Origin: https://www.linkedin.com",
                        //"TE: Trailers"						
                        ),
                    ));
                    $invitationDetailsRes = curl_exec($curlInvitationDetails);
                    $header_size = curl_getinfo($curlInvitationDetails, CURLINFO_HEADER_SIZE);
                    $headers = substr($invitationDetailsRes, 0, $header_size);

                    $invitationDetailsRes = substr($invitationDetailsRes, $header_size);
                    $http_code = curl_getinfo($curlInvitationDetails, CURLINFO_HTTP_CODE);
                    $newCookie = getCookiesLdnFromHeaders($headers);
                    if (!empty($newCookie)) {
                        updateUserLdnCookies($userId, $newCookie);
                    }
                    if ($http_code == 200) {
                        $decodedJsonResInvDtls = json_decode($invitationDetailsRes);
                        if (isset($decodedJsonResInvDtls->data->numTotalSentInvitations)) {
                            $profileData['numTotalSentInvitations'] = $decodedJsonResInvDtls->data->numTotalSentInvitations;
                        }
                        if (isset($decodedJsonResInvDtls->data->numPendingInvitations)) {
                            $profileData['pendingConnections'] = $decodedJsonResInvDtls->data->numPendingInvitations;
                        }
                        //echo 'BBSDSD:<pre>'; print_r($decodedJsonResInvDtls);
                        //$profileData['pendingConnections'] = $decodedJsonResInvDtls->elements[1]->count;
                    } else {
                        //$profileData['pendingConnections'] = 0;
                    }
                }






                //NR starts
                if ($apiRes_me != '') {
                    //$publicIdentifier = $apiRes_me->miniProfile->publicIdentifier;
                    if (isset($apiRes_me->miniProfile->entityUrn)) {


                        //17-08-2020 starts
                        $exp_entityUrn = explode(':', $apiRes_me->miniProfile->entityUrn); //urn:li:fs_miniProfile:ACoAACk3C7UBq40T-fMQ4G2Y9pjfh0zsc4pAt48
                        if (isset($exp_entityUrn[3])) {


                            $publicIdentifier = $exp_entityUrn[3]; //ACoAACk3C7UBq40T-fMQ4G2Y9pjfh0zsc4pAt48
                            //17-08-2020 ends

                            $curl = curl_init();
                            curl_setopt_array($curl, array(
                                CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $publicIdentifier . "/profileView",
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => "",
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 0,
                                CURLOPT_HEADER => true,
                                /* CURLOPT_VERBOSE=>true, */
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_NONE,
                                CURLOPT_HTTPPROXYTUNNEL => 1,
                                CURLOPT_PROXY => "$proxyIp",
                                CURLOPT_PROXYPORT => "$proxyPort",
                                CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                                CURLOPT_CUSTOMREQUEST => "GET",
                                CURLOPT_HTTPHEADER => array(
                                    "cookie: $cookie",
                                    "csrf-token: $csrf",
                                    "x-http-method-override: GET",
                                    "Host: www.linkedin.com",
                                    "User-Agent: $userAgent",
                                    "Accept-Language: en-US,en;q=0.5",
                                    "Accept-Encoding: gzip, deflate, br",
                                    "content-type: application/x-www-form-urlencoded",
                                    "x-li-lang: en_US",
                                    "x-restli-protocol-version: 2.0.0",
                                    "Origin: https://www.linkedin.com",
                                    "TE: Trailers"
                                ),
                            ));
                            $curlResult = curl_exec($curl);
                            $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                            $headers = substr($curlResult, 0, $header_size);

                            $curlResult = substr($curlResult, $header_size);
                            $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
                            $newCookie = getCookiesLdnFromHeaders($headers);
                            if (!empty($newCookie)) {
                                updateUserLdnCookies($userId, $newCookie);
                            }
                            if ($http_code == 200) {
                                //echo '<br/>LINE:'.__LINE__.':::'; echo $curlResult;
                                $apiRes_IdentityProfilesProfileView = json_decode($curlResult);
                                //echo 'C:<pre>';  print_r($apiRes_IdentityProfilesProfileView->profile->summary);die;
                            }
                            curl_close($curl);

                            $curl = curl_init();
                            curl_setopt_array($curl, array(
                                CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $publicIdentifier . "/profileContactInfo",
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => "",
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 0,
                                CURLOPT_HEADER => true,
                                /* CURLOPT_VERBOSE=>true, */
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_NONE,
                                CURLOPT_HTTPPROXYTUNNEL => 1,
                                CURLOPT_PROXY => "$proxyIp",
                                CURLOPT_PROXYPORT => "$proxyPort",
                                CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                                CURLOPT_CUSTOMREQUEST => "GET",
                                CURLOPT_HTTPHEADER => array(
                                    "cookie: $cookie",
                                    "csrf-token: $csrf",
                                    "x-http-method-override: GET",
                                    "Host: www.linkedin.com",
                                    "User-Agent: $userAgent",
                                    "Accept-Language: en-US,en;q=0.5",
                                    "Accept-Encoding: gzip, deflate, br",
                                    "content-type: application/x-www-form-urlencoded",
                                    "x-li-lang: en_US",
                                    "x-restli-protocol-version: 2.0.0",
                                    "Origin: https://www.linkedin.com",
                                    "TE: Trailers"
                                ),
                            ));
                            $curlResult = curl_exec($curl);
                            $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                            $headers = substr($curlResult, 0, $header_size);

                            $curlResult = substr($curlResult, $header_size);
                            $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
                            $newCookie = getCookiesLdnFromHeaders($headers);
                            if (!empty($newCookie)) {
                                updateUserLdnCookies($userId, $newCookie);
                            }
                            if ($http_code == 200) {
                                //echo '<br/>LINE:'.__LINE__.':::'; echo $curlResult;
                                $apiRes_IdentityProfilesProfileContactInfo = json_decode($curlResult);
                            }
                            curl_close($curl);
                        }
                    }


                    //04-12-2020 starts
                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                        CURLOPT_URL => "https://www.linkedin.com/sales-api/salesApiSsi",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_HEADER => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_NONE,
                        CURLOPT_HTTPPROXYTUNNEL => 1,
                        CURLOPT_PROXY => "$proxyIp",
                        CURLOPT_PROXYPORT => "$proxyPort",
                        CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                        CURLOPT_CUSTOMREQUEST => "GET",
                        CURLOPT_HTTPHEADER => array(
                            "cookie: $cookie",
                            "csrf-token: $csrf",
                            "x-http-method-override: GET",
                            "Host: www.linkedin.com",
                            "User-Agent: $userAgent",
                            "Accept-Language: en-US,en;q=0.5",
                            "Accept-Encoding: gzip, deflate, br",
                            "content-type: application/x-www-form-urlencoded",
                            "x-li-lang: en_US",
                            "x-restli-protocol-version: 2.0.0",
                            "Origin: https://www.linkedin.com",
                            "TE: Trailers"
                        ),
                    ));
                    $curlResult = curl_exec($curl);
                    $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                    $headers = substr($curlResult, 0, $header_size);

                    $curlResult = substr($curlResult, $header_size);
                    $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

                    if ($http_code == 200) {
                        $decodedRes = json_decode($curlResult);
                        //echo 'E:<pre>'; print_r($decodedRes);
                        if (isset($decodedRes->memberScore->overall) && isset($decodedRes->memberScore->subScores[0]->score) && isset($decodedRes->memberScore->subScores[1]->score) && isset($decodedRes->memberScore->subScores[2]->score) && isset($decodedRes->memberScore->subScores[3]->score)) {
                            $ssiData = array();
                            $api_ssiScore = $ssiData['memberScore_overall'] = $decodedRes->memberScore->overall; //44.64;//
                            $ssiData['valProfessionalBrand'] = $decodedRes->memberScore->subScores[0]->score; //5.75;//
                            $ssiData['valFindRightPeople'] = $decodedRes->memberScore->subScores[1]->score; //17.28;//
                            $ssiData['valInsightEngagement'] = $decodedRes->memberScore->subScores[2]->score; //8.03;//
                            $ssiData['valStrongRelationship'] = $decodedRes->memberScore->subScores[3]->score; //13.58;//


                            $ssiStr = json_encode($ssiData);
                            $ssiLastUpdated = date('Y-m-d H:i:s');


                            Yii::$app->db->createCommand("UPDATE `user_profile` SET `ssiData` = '" . addslashes($ssiStr) . "', `ssiLastUpdated` = '" . $ssiLastUpdated . "', lastUpdatedBy = 'MytemplateController-Ajxrefreshprofile' WHERE `user_id` =" . $userId)->execute();
							
							
							$reffresquery = "UPDATE `user_profile` SET `ssiData` = '" . addslashes($ssiStr) . "', `ssiLastUpdated` = '" . $ssiLastUpdated . "' WHERE `user_id` =" . $userId;
							
							 Yii::$app->db->createCommand("INSERT INTO `user_login_logs` SET `userid` = '" .$userId . "', `csrf` = 'NA', cookie = 'NA', vnc_ip = 'NA', port_id = 'NA', fileName = 'SubUsersController-actionrefreshprofile', flag = 'Refresh Query: ".addslashes($reffresquery)."'")->execute();
                        }
                    }
                    //04-12-2020 ends
                }
                //NR ends




                $final_result = array();
                $final_result['success'] = 1; //09-09-2020
                $final_result['profileData'] = $profileData;




                $api_IPPV_profile_locationName = 'N/A';
                $api_IPPV_profile_summary_html = '<p>N/A</p>';
                if ($apiRes_IdentityProfilesProfileView != '') {
                    if (isset($apiRes_IdentityProfilesProfileView->profile->locationName)) {
                        $col_IPPV_profileLocationName = $api_IPPV_profile_locationName = $apiRes_IdentityProfilesProfileView->profile->locationName;
                    }

                    if (isset($apiRes_IdentityProfilesProfileView->profile->summary)) {
                        //01-07-2020:htmlentities added due to it was causing issue when summary contains html;
                        if (strlen($apiRes_IdentityProfilesProfileView->profile->summary) > 325) {
                            $api_IPPV_profile_summary_html = '<p id="shortAbout">' . substr(htmlentities($apiRes_IdentityProfilesProfileView->profile->summary), 0, 325) . '... <a href="javascript:void(0);" id="aShortAbout">Read more</a></p>';
                            $api_IPPV_profile_summary_html .= '<p id="fullAbout" style="display:none;">' . htmlentities($apiRes_IdentityProfilesProfileView->profile->summary) . ' <a href="javascript:void(0);" id="aFullAbout">Read less</a></p>';
                        } else {
                            $api_IPPV_profile_summary_html = '<p>' . htmlentities($apiRes_IdentityProfilesProfileView->profile->summary) . '</p>';
                        }
                    }
                }
                //print_r($api_IPPV_profile_summary_html); 
                $apiIPPCI_phoneNumbers = 'N/A';
                $apiIPPCI_emailAddress = 'N/A';
                if ($apiRes_IdentityProfilesProfileContactInfo != '') {
                    if (isset($apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number)) {
                        $col_IPPCI_phoneNumber = $apiIPPCI_phoneNumbers = $apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number;
                    }

                    if (isset($apiRes_IdentityProfilesProfileContactInfo->emailAddress)) {
                        $apiIPPCI_emailAddress = $apiRes_IdentityProfilesProfileContactInfo->emailAddress;
                    }
                }

                $api_me_miniProfile_Occupation = 'N/A';
                if ($apiRes_me != '') {
                    if (isset($apiRes_me->miniProfile->occupation)) {
                        $api_me_miniProfile_Occupation = $apiRes_me->miniProfile->occupation;
                        $col_occupation = $this->mb_htmlentities($apiRes_me->miniProfile->occupation); //16-07-2021 added
                    }
                }

                $html_basicDetail = '';
                $html_basicDetail .= '<ul class="list-unstyled basicDetailsBlk">';
                $html_basicDetail .= '<li><i class="cursor-pointer bx bx-map mb-1 mr-50"></i>' . $api_IPPV_profile_locationName . '</li>';
                $html_basicDetail .= '<li><i class="cursor-pointer bx bx-phone-call mb-1 mr-50"></i>' . $apiIPPCI_phoneNumbers . '</li>';
                $html_basicDetail .= '<li><i class="cursor-pointer bx bx-envelope mb-1 mr-50"></i>' . $apiIPPCI_emailAddress . '</li></ul><div class="profilOccBlk"><h6><small class="text-muted">Occupation</small></h6><p>' . $api_me_miniProfile_Occupation . '</p></div>';
                //<div class="profileAbtBlk"><h6><small class="text-muted">About</small></h6>
                /* $api_IPPV_profile_summary_html = addslashes($api_IPPV_profile_summary_html);
                  $api_IPPV_profile_summary_html = htmlspecialchars($api_IPPV_profile_summary_html); */
                //$html_basicDetail .= $api_IPPV_profile_summary_html;
                //$html_basicDetail .= '</div>'; 
                //print_r(htmlentities($html_basicDetail, NULL, 'UTF-8'));
                $final_result['html_basicDetail'] = $html_basicDetail;
                $final_result['apiRes_me'] = $apiRes_me;
                $final_result['api_ssiScore'] = $api_ssiScore; //04-12-2020
                //print_r(json_encode($final_result,JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)); 
                //updating data starts
                $ProfilePic400_400 = $profileData['pic_400_400'];
                $pdNumConnections = $profileData['numConnections'];
                $pdPendingConnections = $profileData['pendingConnections'];
                $pdNumTotalSentInvitations = $profileData['numTotalSentInvitations'];

                //$api_IPPV_profile_locationName = 'N/A';//commented on 16-07-2021 already define above
                $api_IPPV_profile_summary_html = 'N/A'; //'<p>N/A</p>';
                if ($apiRes_IdentityProfilesProfileView != '') {
                    /* commented on 16-07-2021 already define above
                      if (isset($apiRes_IdentityProfilesProfileView->profile->locationName)) {
                      $api_IPPV_profile_locationName = $apiRes_IdentityProfilesProfileView->profile->locationName;
                      }
                     */

                    if (isset($apiRes_IdentityProfilesProfileView->profile->summary)) {
                        //01-07-2020:htmlentities added due to it was causing issue when summary contains html;
                        $api_IPPV_profile_summary_html = htmlentities($apiRes_IdentityProfilesProfileView->profile->summary);
                    }
                }
                $IPPV_profileLocationName = $api_IPPV_profile_locationName;
                //$IPPV_profileSummary = $api_IPPV_profile_summary_html;
                $IPPV_profileSummary = str_replace("'", "`", $api_IPPV_profile_summary_html); //07-July-2020

                /* 16-07-2021 commented; already define above
                  $apiIPPCI_phoneNumbers = 'N/A';
                  if ($apiRes_IdentityProfilesProfileContactInfo != '') {
                  if (isset($apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number)) {
                  $apiIPPCI_phoneNumbers = $apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number;
                  }
                  }
                 */
                $IPPCI_phoneNumber = $apiIPPCI_phoneNumbers;

                $api_me_miniProfile_Occupation = 'N/A';
                $api_me_miniProfile_firstName = 'N/A';
                $api_me_miniProfile_lastName = 'N/A';
                if ($apiRes_me != '') {
                    if (isset($apiRes_me->miniProfile->occupation)) {
                        //$api_me_miniProfile_Occupation = $apiRes_me->miniProfile->occupation;
                        $api_me_miniProfile_Occupation = addslashes($this->mb_htmlentities($apiRes_me->miniProfile->occupation));
                    }
                    if (isset($apiRes_me->miniProfile->firstName)) {
                        //$api_me_miniProfile_firstName = $apiRes_me->miniProfile->firstName;
                        $api_me_miniProfile_firstName = addslashes($this->mb_htmlentities($apiRes_me->miniProfile->firstName));
                        $col_firstName = $this->mb_htmlentities($apiRes_me->miniProfile->firstName); //16-07-2021 added
                    }
                    if (isset($apiRes_me->miniProfile->lastName)) {
                        //$api_me_miniProfile_lastName = $apiRes_me->miniProfile->lastName;
                        $api_me_miniProfile_lastName = addslashes($this->mb_htmlentities($apiRes_me->miniProfile->lastName));
                        $col_lastName = $this->mb_htmlentities($apiRes_me->miniProfile->lastName); //16-07-2021 added
                    }
                }


                //, IPPV_profileSummary='".$IPPV_profileSummary."'
                //addslashes($api_me_miniProfile_firstName)
                //addslashes($api_me_miniProfile_lastName)
                //addslashes($api_me_miniProfile_Occupation)
                $update_user_data = "update user_profile set ProfilePic400_400='" . addslashes($ProfilePic400_400) . "', pdNumConnections='" . $pdNumConnections . "', pdPendingConnections='" . $pdPendingConnections . "', pdNumTotalSentInvitations='" . $pdNumTotalSentInvitations . "', IPPV_profileLocationName='" . addslashes($IPPV_profileLocationName) . "', IPPCI_phoneNumber='" . addslashes($IPPCI_phoneNumber) . "', firstName='" . $api_me_miniProfile_firstName . "', lastName='" . $api_me_miniProfile_lastName . "', occupation='" . $api_me_miniProfile_Occupation . "' where user_id='" . $userId . "'";

                //echo $update_user_data;
                //Yii::$app->db->createCommand($update_user_data)->execute();//16-07-2021 commented
                //16-07-2021 starts
                $userProfileArr = array();
                $runSql = false;
                if (!empty($profileData['pic_400_400'])) {
                    $userProfileArr['ProfilePic400_400'] = $profileData['pic_400_400'];
                    $runSql = true;
                }
                if ($profileData['numConnections'] > 0) {
                    $userProfileArr['pdNumConnections'] = $profileData['numConnections'];
                    $runSql = true;
                }
                if ($profileData['numTotalSentInvitations'] > 0) {
                    $userProfileArr['pdNumTotalSentInvitations'] = $profileData['numTotalSentInvitations'];
                    $runSql = true;
                }
                if ($profileData['pendingConnections'] > 0) {
                    $userProfileArr['pdPendingConnections'] = $profileData['pendingConnections'];
                    $runSql = true;
                }

                if (isset($col_IPPV_profileLocationName)) {
                    $userProfileArr['IPPV_profileLocationName'] = $col_IPPV_profileLocationName;
                    $runSql = true;
                }

                if (isset($col_IPPCI_phoneNumber)) {
                    $userProfileArr['IPPCI_phoneNumber'] = $col_IPPCI_phoneNumber;
                    $runSql = true;
                }

                if (isset($col_occupation)) {
                    $userProfileArr['occupation'] = $col_occupation;
                    $runSql = true;
                }
                if (isset($col_firstName)) {
                    $userProfileArr['firstName'] = $col_firstName;
                    $runSql = true;
                }
                if (isset($col_lastName)) {
                    $userProfileArr['lastName'] = $col_lastName;
                    $runSql = true;
                }
				
				$lastUpdatedBy = 'MytemplateController-Ajxrefreshprofile2';
				$userProfileArr['lastUpdatedBy'] = $lastUpdatedBy;

					

                if ($runSql) {
                    //echo 'in qry::';
                    $query = Yii::$app->db->createCommand()->update('user_profile', $userProfileArr, 'user_id = ' . $userId)->execute();
					
					$querytext = $query = Yii::$app->db->createCommand()->update('user_profile', $userProfileArr, 'user_id = ' . $userId)->getRawSql();
					
					Yii::$app->db->createCommand("INSERT INTO `user_login_logs` SET `userid` = '" .$userId . "', `csrf` = 'NA', cookie = 'NA', vnc_ip = 'NA', port_id = 'NA', fileName = 'MytemplateController-Ajxrefreshprofile2', flag = 'Refresh Query: ".addslashes($querytext)."'")->execute();
                    //echo '<pre>'; print_r($query);
                }


                //16-07-2021 ends
                //updating data ends

                return json_encode($final_result);
            } else {
                //$profileData['pic_100_100'] = '';
                //$profileData['pic_400_400'] = '';
                //$apiRes_me = '';
                //09-09-2020 added
                $final_result = array();
                $final_result['success'] = 0; //09-09-2020
                $final_result['error_message'] = 'voyager-api-me result not found.'; //01-04-2021
                return json_encode($final_result);
            }
            //}
        } else {
            //09-09-2020 added
            $final_result = array();
            $final_result['success'] = 0; //09-09-2020
            $final_result['error_message'] = 'proxy detail, cookie and csrf details not found.'; //01-04-2021
            return json_encode($final_result);
        }
    }

}
