<?php
namespace app\controllers;
use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use app\models\LoginForm;
use app\models\ContactForm;

class SiteController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'only' => ['logout'],
                'rules' => [
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    /**
     * Displays homepage.
     *
     * @return string
     */
    public function actionIndex()
    {        
        if(Yii::$app->session->get('useremail')){
			$url = Yii::$app->request->baseUrl;            
            $url .="/dashboard";

            return $this->redirect($url);
         }else{           
            return $this->redirect('login');
		 }
    }

    /**
     * Login action.
     *
     * @return Response|string
     */
    public function actionLogin()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new LoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            return $this->goBack();
        }
        return $this->render('login', [
            'model' => $model,
        ]);
    }

    /*** Signout action.  */

    // Signout user .. 
    public function actionSignout()
    {
		
		Yii::$app->db->createCommand("UPDATE `user` SET `IsnotificationRead` = '0' WHERE IsnotificationRead = '1' AND `id` = '" . Yii::$app->session->get('userid') . "'")->execute();
       // echo 'in logout'; exit;
		
        Yii::$app->session->remove('useremail');
        Yii::$app->session->remove('teamid');
        Yii::$app->session->remove('userid');
        Yii::$app->session->remove('username');
        Yii::$app->session->remove('__returnUrl'); 
        Yii::$app->session->remove('__id'); 
        Yii::$app->session->remove('loggedinwith_subusers');
        Yii::$app->session->remove('loggedinwith_superadmin');
		$url = Yii::$app->request->baseUrl;
        $url = $url."/user/security/login";
        return $this->redirect($url);        
    }


    /**
     * Displays contact page.
     *
     * @return Response|string
     */
    public function actionContact()
    {
        $model = new ContactForm();
        if ($model->load(Yii::$app->request->post()) && $model->contact(Yii::$app->params['adminEmail'])) {
            Yii::$app->session->setFlash('contactFormSubmitted');

            return $this->refresh();
        }
        return $this->render('contact', [
            'model' => $model,
        ]);
    }


    /**
     * Displays about page.
     *
     * @return string
     */
    public function actionAbout()
    {
        return $this->render('about');
    }
}
