<?php

namespace app\controllers; 
require '../aws_php_sdk/vendor/autoload.php'; 
use Yii;
use yii\db\Query;    
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Aws\S3\S3Client;
use Aws\Exception\AwsException;


/**
 *  SequencesController the CRUD actions for SequencesModel model.
 */
class SequencesController extends Controller {

    /**
     * @inheritdoc
     */
    public $enableCsrfValidation = false;

    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**   
     * Lists all SequencesModel models.
     * @return mixed
     */
    public function actionIndex() {
		
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if(Yii::$app->session->get('user_role') == 1){
            $this->redirect('dashboard');
        }
		
		// chekc if sequence id connect with userId
		if(isset($_REQUEST['seqid']) && $_REQUEST['seqid'] != '' )
		{
			$chkseq1 = Yii::$app->db->createCommand("SELECT id from `ext_sequences` where id = '".$_REQUEST['seqid']."' AND  user_id = '".Yii::$app->session->get('userid')."'")->queryOne();
			
			if(empty($chkseq1))
			{
				 $url = \Yii::$app->request->baseUrl;
				return $this->redirect($url);
			}
		}
		
		// List sequance
		$sequencelist_query = new Query;
		$sequencelist = $sequencelist_query->select(['name','status','msgSeq','enrollPerDay','id']) 
                        ->from('ext_sequences')
                        ->where(['user_id' => Yii::$app->session->get('userid')])
						->all();
		// End 
		
		// Get loggedin user details
		$userdetails_query = new Query;
		$userdetils = $userdetails_query->select(['sublevel','TimeZone','portal_id','is_booster','skipEmail','user_api_key'])
                        ->from('user')
                        ->where(['id' => Yii::$app->session->get('userid')])
						->one();
		
		// End
		$query_sequ = new Query;
		 $allcsvsaved = $query_sequ->select(['*'])
                ->from('csvfiles')
                ->where(['user_id' => Yii::$app->session->get('userid')])
                ->all();
		
		 $query_tempalte = new Query;
		 $allteamplates = $query_tempalte->select(['*'])
                ->from('templates')
                ->where(['teamid' => Yii::$app->session->get('userid')])
                ->orWhere("teamid = '0'")
                ->orWhere("sharewith LIKE '%" . Yii::$app->session->get('userid') . "%'")
                ->all();
		
		$getsequencedata = '';
		$getstepsdata = '';
		$getlinksdata = '';
		if(isset($_REQUEST['seqid']) && $_REQUEST['seqid'] != '' )
		{
			$query_sequance = new Query;
			$getsequencedata = $query_sequance->select(['*'])
                ->from('ext_sequences')
                ->where(['id' => $_REQUEST['seqid']])
                ->one();
			
			$query_steps = new Query;
			$getstepsdata = $query_steps->select(['*'])
                ->from('ext_steps')
                ->where(['seqId' => $_REQUEST['seqid']])
                ->all();
				
			$query_links = new Query;
			$getlinksdata = $query_steps->select(['*'])
                ->from('ext_links')
                ->where(['seqId' => $_REQUEST['seqid']])
                ->all();
		}
		
		// check if kennected user
		$haystack = Yii::$app->session->get('useremail');
		$needle   = "@kennected.io";
                
                $getHyperiseIntegration = Yii::$app->db->createCommand("SELECT api_key from `hyperise_integration` where userId=".Yii::$app->session->get('userid'))->queryOne();
		
		
		//if(strpos( $haystack, $needle ) !== false || Yii::$app->params['portal_id']  == '2')
		
		  $users_arr = array(16943,14907,14909,14905,14932,14942,14935);
		
		  if(in_array(Yii::$app->session->get('userid'), $users_arr))
		  {
			
			return $this->render('index_email',array('Allsavedcsv'=>$allcsvsaved,'Alltempaltes'=>$allteamplates,'Getsequencedata'=>$getsequencedata,'Getstepsdata'=>$getstepsdata,'Sequencelist'=>$sequencelist,'Userdetils'=>$userdetils,'Getlinksdata'=>$getlinksdata,'getHyperiseIntegration'=>$getHyperiseIntegration)); 
			
		  }else{
			
			if(Yii::$app->params['portal_id']  == '2'){
				return $this->render('index_email',array('Allsavedcsv'=>$allcsvsaved,'Alltempaltes'=>$allteamplates,'Getsequencedata'=>$getsequencedata,'Getstepsdata'=>$getstepsdata,'Sequencelist'=>$sequencelist,'Userdetils'=>$userdetils,'Getlinksdata'=>$getlinksdata,'getHyperiseIntegration'=>$getHyperiseIntegration));
			}else{
				return $this->render('index_email',array('Allsavedcsv'=>$allcsvsaved,'Alltempaltes'=>$allteamplates,'Getsequencedata'=>$getsequencedata,'Getstepsdata'=>$getstepsdata,'Sequencelist'=>$sequencelist,'Userdetils'=>$userdetils,'Getlinksdata'=>$getlinksdata,'getHyperiseIntegration'=>$getHyperiseIntegration));
			}
			
		  }
    }
	
public function actionSequencespagination() // 2nd degree sequence list
	{
		  if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		 
		 $perpageoffset = $_POST['perpageoffset'];
		  
		 $currentPage = $_POST['pagenum'];
		 
		 $perpage = 5;
		 
		 $totsqlseqlist = "SELECT  name,status,msgSeq,enrollPerDay,id from ext_sequences  where status != 'Deleted' AND msgSeq = 0 AND user_id = ".Yii::$app->session->get('userid');
		 $countsequencelist = Yii::$app->db->createCommand($totsqlseqlist)->queryAll();
		 
		 if(isset($_POST['totalRowsCount']))
		 {
			 $totalPage = $_POST['totalRowsCount'] / $perpage;
		 }else{
			  $totalPage = count($countsequencelist) / $perpage;
		 }
		
		 $totalPagecount = ceil($totalPage);
		 
		
//		$sqlseqlist = "SELECT  name,status,msgSeq,enrollPerDay,id from ext_sequences  where status != 'Deleted' AND msgSeq = 0 AND user_id = ".Yii::$app->session->get('userid')." order by id DESC limit $perpageoffset,$perpage ";
                $sqlseqlist = "SELECT  s.SelectedcsvId,s.webhookVal,s.name,s.status,s.msgSeq,s.enrollPerDay,s.id,s.working_hour_id,w.server_start_time,w.server_end_time from ext_sequences as s left join ext_working_hours as w on s.working_hour_id=w.id  where s.status != 'Deleted' AND s.msgSeq = 0 AND s.user_id = " . Yii::$app->session->get('userid') . " order by s.id DESC limit $perpageoffset,$perpage ";
        $sequencelist = Yii::$app->db->createCommand($sqlseqlist)->queryAll();
		
		?>
		<table class="table table-striped table mb-0 sequencesMainList" id="sequencesMainList">
										<thead>
											<tr>                          
												<th class="text-center" style="padding: 0 10px;">#</th>
												<?php //if(Yii::$app->session->get('userid') == '16839'){ ?>
												<th style="width: 20px;padding: 0;margin: 0;"></th>
												<?php //} ?>
												<th>Name</th>
												<th style="text-align:center;" >Statistics</th>
												<th class="text-center" data-hide="phone,tablet" width="20%">Per Day Limit</th>
												<th data-hide="phone,tablet">Action</th>
												<th data-hide="phone,tablet">Options</th>
											</tr>
										</thead>
										<tbody>
												<?php 
												
												$getuserboardingstatus = Yii::$app->db->createCommand("SELECT entry_fee FROM user where id = '".Yii::$app->session->get('userid')."'")->queryOne();
												
												$boardingstatus = 0;
												if(isset($getuserboardingstatus['entry_fee']) && $getuserboardingstatus['entry_fee'] != ''){
													$boardingstatus = $getuserboardingstatus['entry_fee'];
												}
												
												$i=1; 
												$sn = ($currentPage * $perpage - ($perpage)) + 1;
												foreach($sequencelist as $rows){ 
												 
												$statusbadge = 'info';
													if($rows['status'] == 'Active')
													{
														$statusbadge = 'primary'; 
														 
													}else if($rows['status'] == 'Not Started'){
														$statusbadge = 'secondary'; 
													}else if($rows['status'] == 'Paused'){
														$statusbadge = 'info';
													}else if($rows['status'] == 'Error'){
														$statusbadge = 'danger';
													}else if($rows['status'] == 'Stopped'){
														$statusbadge = 'warning'; 
													}else if($rows['status'] == 'Complete'){
														$statusbadge = 'success';
													}else{
														$statusbadge = 'info';
													} 
													
												$seqName = '';
												if(isset($rows['name']))
												{
														if(strlen($rows['name']) > 30){
															$seqName = substr($rows['name'],0,25).'...';
														}
														else{
															$seqName = $rows['name'];
														} 
												}
                                                                                                
                                                                                                $timerActive = "";
                                                                                                $startTime = "";
                                                                                                $server_start_time = "";
                                                                                                $server_end_time = "";
                                                                                                $currentTime = "";
                                                                                                if($rows['status'] == "Active"){
                                                                                                    $timerActive = 'timerActive';                                                                     
                                                                                                    $server_start_time = strtotime(date("M d Y")." ". $rows['server_start_time'])*1000;
                                                                                                    $server_end_time = strtotime(date("M d Y")." ". $rows['server_end_time'])*1000;
                                                                                                    $t = time();
//                                                                                                    $currentTime = strtotime(date("M d Y")." ".date("h:i:s", $t))*1000;
                                                                                                    $currentTime = round(microtime(true) * 1000);
                                                                                                 }
																								 
												$seqtypelab = '<a title="URL Sequence" data-seq-id="'.$rows['id'].'" class="view_seq" href="javascript:void();"><i class="bx bx-link-alt"></i></a>';										
												if($rows['SelectedcsvId'] > 0){
													
													
													
													$seqtypelab = '<a title="CSV Sequence" data-seq-id="'.$rows['id'].'" class="view_seq" href="javascript:void();"><i class="bx bxs-file"></i></a>';
												}
												else if($rows['webhookVal'] > 0)
												{
													
													$seqtypelab = '<a title="Webhook Sequence" data-seq-id="'.$rows['id'].'" class="view_seq" href="javascript:void();"><i class="bx bx-world"></i></a>';
												}
												else{
													
													$seqtypelab = '<a title="URL Sequence" data-seq-id="'.$rows['id'].'" class="view_seq" href="javascript:void();"><i class="bx bx-link-alt"></i></a>';
												}
												
												 if(Yii::$app->session->get('userid') == '16839'){
													 
													 //echo $rows['SelectedcsvId'].'=='.$rows['webhookVal'];
												 }
													
												?>
												<tr class="row_class seq_row <?php echo $timerActive; ?>" data-server-time="<?php echo $currentTime; ?>" data-start-time="<?php echo $server_start_time; ?>" data-end-time="<?php echo $server_end_time; ?>" data-seq-id="<?php echo $rows['id']; ?>">
													<td class="text-center"><?php echo $sn; ?></td> 
													<?php //(Yii::$app->session->get('userid') == '16839'){ ?>
													<td class="text-center"><?php echo $seqtypelab; ?></td>
													<?php //} ?>
													<td><?php if($rows['msgSeq']==0){ echo '<a href="#" title="2nd Degree Connection"></a>'; }else{ echo '<a href="#" title="1st Degree Messages"><i class="bx bxs-conversation"></i></a>';} ?> <?php echo  '<a href="javascript:void(0);" title="'.$rows['name'].'" style="color:#727E8C; padding: 5px;" data-seq-id="'.$rows['id'].'" class="view_seq_logs">'.$seqName .'</a>'; ?><br><div style="padding: 5px;margin-left: 8px;font-size: 10px; border-radius: 2px;" class="badge badge-pill badge-light-<?php echo $statusbadge; ?> mr-1 mb-1 ch_stat_<?php echo  $rows['id']; ?> target_aud<?php echo $rows['id']; ?>" id="ch_stat_<?php echo  $rows['id']; ?>"><?php echo $rows['status']; ?></div></td>
													
													<?php 
													$sqlenrolled = "SELECT id FROM ext_tasks WHERE seqId = '".$rows['id']."' AND status = 'Complete' AND step = 0";
													$countenrolled = Yii::$app->db->createCommand($sqlenrolled)->queryAll();
													$Totalcountenrolled = count($countenrolled);
													?>
													<td>
													<!--<span title="Total Enrolled" style="cursor:pointer;" class="badge badge-pill badge-round badge-light-info countConreq_<?php echo  $rows['id']; ?>"><?php echo $Totalcountenrolled; ?></span>-->
													<!--<div class="donut-chart-wrapper">
														<div id="donut-chart<?php echo  $rows['id']; ?>" class="d-flex justify-content-center"></div>
														<div class="statistics-data my-auto">
														  <div class="statistics">
															<span class="font-medium-2 mr-50 text-bold-600 countConreq_<?php echo  $rows['id']; ?>"><?php echo $Totalcountenrolled; ?></span>
														  </div>
														</div>
														</div>-->
														
														<!--<div class="d-flex market-statistics-1">
                                                        <div id="donut-chart<?php echo  $rows['id']; ?>" class="d-flex justify-content-center"></div>
                                                        <div class="statistics-data my-auto">
															<div class="statistics">
                                                                <span class="font-medium-2 mr-50 text-bold-600 countConreq_<?php echo  $rows['id']; ?>"><?php echo $Totalcountenrolled; ?></span>
                                                            </div>
															<div class="statistics-date">
                                                                <small class="text-muted">Total Enrolled</small>
                                                            </div>
                                                            
                                                        </div>
                                                    </div> -->
													<?php 
														$sqlaccept = "SELECT  id from blacklist  where is_accepted = 1 AND seq_id=" .$rows['id'];
														$countaccept = Yii::$app->db->createCommand($sqlaccept)->queryAll();
		
														$sqlresponse = "SELECT  id from blacklist  where (is_response = 1 OR is_response = 2)  AND seq_id=" .$rows['id'];
														$countresponse = Yii::$app->db->createCommand($sqlresponse)->queryAll(); 
														
														$Totalcountaccept = count($countaccept);
														$Totalcountresponse = count($countresponse);
														?>
													<div class="row">
														  <div class="col">
														 <div class="statistics-data my-auto">
															<div class="statistics" style="text-align: center;">
                                                                <span class="font-medium-2 mr-50 text-bold-600 countConreq_<?php echo  $rows['id']; ?>" style="color: #00CFDD !important;">0</span>
                                                            </div>
															<div class="statistics-date" style="text-align: center;">
                                                                <small class="text-muted">Total Enrolled</small> 
                                                            </div>
                                                            
                                                        </div>
														</div>
														<div class="col order-1">
														 <div class="statistics-data my-auto"> 
															<div class="statistics" style="text-align: center;">
                                                                <span class="font-medium-2 mr-50 text-bold-600 countConaccept_<?php echo  $rows['id']; ?>" style="color:#39DA8A !important;" >0</span>
                                                            </div>
															<div class="statistics-date" style="text-align: center;">
                                                                <small class="text-muted">Total Accepted</small>
                                                            </div>
                                                            
                                                        </div>
														</div> 
														<div class="col order-2">
														 <div class="statistics-data my-auto"> 
															<div class="statistics" style="text-align: center;">
                                                                <span class="font-medium-2 mr-50 text-bold-600 countConresponse_<?php echo  $rows['id']; ?>" style="color:#5A8DEE !important;">0</span>
                                                            </div>
															<div class="statistics-date" style="text-align: center;">
                                                                <small class="text-muted">Total Responses</small>
                                                            </div>
                                                            
                                                        </div>
														</div>
														</div>
														
														
												
													</td>
													<td>
													<?php if($rows['status'] != 'Deleted') { ?>
													<?php if($rows['msgSeq'] == 0){ ?>
													<input type="number" class="num ppdel form-control text-center" id="ppdel_<?php echo  $rows['id']; ?>" min="1"  
													 
													value="<?php 
														if($rows['msgSeq'] == 0){
															if($rows['enrollPerDay'] == '')
															{
																
																	echo 0;
															} 
															else 
															{ 
																echo $rows['enrollPerDay']; 
															} 
														}
													?>">
													<?php } else { ?>
													<input type="number" class="numM mprl form-control text-center"  id="mprl_<?php echo  $rows['id']; ?>"  min="1" 
													value="<?php 
													if($rows['msgSeq'] == 1)
													{
														if($rows['enrollPerDay'] == '')
														{
															
																echo 0; 
														} 
														else
														{
															echo $rows['enrollPerDay']; 
														}
													}
											
													?>">
													<?php } ?>
													<?php } ?>
                                                                                                        <?php if($rows['enrollPerDay'] < 1 && $rows['status'] == 'Active'){ ?>
                                                                                                        <div class="on_zero_enroll on_zero_enroll_<?php echo $rows['id']; ?>" style="text-align: right;width: 20px;float: right;margin-right: 50px;margin-top: -30px;">
                                                                                                            <i class="bx bxs-error" title="Increase limit to enroll new prospects" style="color: #fdac41;"></i>
                                                                                                        </div>
                                                                                                        <?php } ?>
													</td>
												 <td class="status_row_<?php echo  $rows['id']; ?>">
													<div id="LoaderSteps_<?php echo htmlspecialchars($rows['id'],ENT_QUOTES); ?>" style="display: none">                                      
														<img src="<?php echo Yii::$app->urlManager->baseUrl?>/img/varun_loader.gif" style=" width: 15px;"> 
													</div>
												<?php 
												$bflag = 0;
												if($boardingstatus == 2 && Yii::$app->params['portal_id'] == 5){ 
													$bflag = 1;
												}
												?>
													<?php if($bflag == 0){ ?>
													<div class="seq_lable">
													<?php 
													if($rows['status'] == 'Not Started' ||  $rows['status'] == 'Stopped')
													{
														echo '<a href="javascript:void(0);"  data-seq-type="'.$rows['msgSeq'].'" class="changeSeqStatus badge badge-success btnStart" data-seq-id="Active-'.$rows['id'].'" >Start</a>';
													}else if($rows['status'] == 'Paused'){
													
														echo '<a href="javascript:void(0);"  data-seq-type="'.$rows['msgSeq'].'" class="changeSeqStatus badge badge-primary btnStart" data-seq-id="Active-'.$rows['id'].'" >Continue</a>';
													
													}
													else if($rows['status'] == 'Active'){
														echo '<a href="javascript:void(0);" data-seq-type="'.$rows['msgSeq'].'"  class="changeSeqStatus badge badge-warning btnActive" data-seq-id="Stopped-'.$rows['id'].'" >Stop</a>&nbsp;<a href="javascript:void(0);" data-seq-type="'.$rows['msgSeq'].'"  class="changeSeqStatus badge badge-info btnActive" data-seq-id="Paused-'.$rows['id'].'" >Pause</a>';
													}
													else if($rows['status'] == 'Complete'){
														echo '<label  class="badge badge-primary btnCompleted" >Completed</label>';
													}else{
														echo '<label  class="badge badge-danger btnDeleted" >Error</label>&nbsp;<a href="javascript:void(0);"  data-seq-type="'.$rows['msgSeq'].'" class="changeSeqStatus badge badge-success btnStart" data-seq-id="Active-'.$rows['id'].'" >Continue</a>';
													}
													?> 
													</div>
													<?php } else { 
														echo '<a href="javascript:void(0);"  class="badge badge-light btn_contact_support" >Start</a>';
													} ?>
													</td>
													<td class="text-center py-1">
                                                    <div class="dropdown">
                                                        <span class="bx bx-dots-vertical-rounded font-medium-3 dropdown-toggle nav-hide-arrow cursor-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" role="menu"></span>
                                                        <div class="dropdown-menu dropdown-menu-right">
                                                           

															<?php if($rows['status'] == 'Deleted') {?>
															<a href="javascript:void(0);" class="clone_seq dropdown-item" data-seq-type="<?php echo  $rows['msgSeq']; ?>"  data-seq-id="<?php echo  $rows['id']; ?>" title="Clone Sequence" ><i class="bx bxs-copy mr-1"></i>clone</a>
															<a href="javascript:void(0);" class="view_seq dropdown-item" data-seq-id="<?php echo  $rows['id']; ?>" title="View Sequence" ><i class="bx bx-show mr-1"></i>clone</a>
															<?php } else { ?>
															<a href="javascript:void(0);" class="clone_seq dropdown-item" data-seq-type="<?php echo  $rows['msgSeq']; ?>"  data-seq-id="<?php echo  $rows['id']; ?>" title="Clone Sequence" ><i class="bx bxs-copy mr-1"></i>clone</a>

															<a class="dropdown-item" href="?seqid=<?php echo $rows['id']; ?>"  title="Edit Sequence" ><i class="bx bx-edit-alt mr-1"></i>edit</a>

															<a href="javascript:void(0);" class="delete_seq dropdown-item" data-seq-id="<?php echo  $rows['id']; ?>" title="Delete Sequence" ><i class="bx bx-trash mr-1"></i>delete</a> 

															<span class="seq_view_url_<?php echo $rows['id']; ?>" <?php //if($rows['status'] != 'Not Started'){ echo 'style="display:contents"'; } else { echo 'style="display:none"';}?>></span>

															<a href="javascript:void(0);" class="view_seq dropdown-item" data-seq-id="<?php echo  $rows['id']; ?>" title="View Sequence" ><i class="bx bx-show mr-1"></i>View</a><?php //if($rows['status'] == 'Active' || $rows['status'] == 'Paused') { ?>

															<a href="javascript:void(0);" class="view_seq_logs dropdown-item" data-seq-id="<?php echo  $rows['id']; ?>" title="View Logs"><i class="bx bx-history mr-1"></i>Activity Log</a><?php //} ?>
															<?php } ?>
                                                        </div>
                                                    </div>
                                                </td>	
												</tr>
												<?php $i++;$sn++; } ?>  
										</tbody>
									</table>
									<!-- Pagination  -->
									<input type="hidden" name="totalRowsCount" value="<?php echo count($countsequencelist);?>" id="totalRowsCount" />
									<div class="dataTables_info" id="DataTables_Table_4_info" role="status" aria-live="polite">Showing <?php echo $perpageoffset; ?> to <?php if($currentPage < $totalPagecount){echo $perpage * $currentPage; } else{ echo count($countsequencelist); } ?> of <?php echo count($countsequencelist);?> entries</div>
									<div class="pagination paginationcon">
									<?php if($totalPagecount > 1){ ?>
									<ul class="pagination">
										<!-- Previous -->
										<li class="Prevpagedata" >
										<a class="page-link" href="javascript:void(0);" >Previous</a>
										</li>
										<!-- Previous End -->
										<?php 
										$perpagdata = 0;
										for($p=1; $p <= $totalPagecount; $p++){ 
										if($p > 1){
											$perpagdata = $perpage * $p - $perpage;
										}
										?>
										<li onClick="changePage(<?php echo $perpagdata; ?>,<?php echo $p; ?>);"  class="showthispage_<?php echo $perpagdata; ?> <?php if($p==$currentPage){?>active<?php } ?>">
										<a href="javascript:void(0);" class="page-link"><?php echo $p; ?></a>
										</li>
										<?php } ?>
										<!-- Next -->
										<li class="Nextpagedata" >
										<a class="page-link" href="javascript:void(0);" >Next</a>
										</li>
										<!-- Next End -->
										
									</ul>
									<?php } ?>
									</div>
									<!--End Pagination  -->
									
		<?php 
	}
	
	public function actionSequencespaginationmsg() //1st degree sequence list
	{
		  if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		 
		 $perpageoffset = $_POST['perpageoffset'];
		 
		 $currentPage = $_POST['pagenum'];
		 
		 $perpage = 5;
		 
		 $totsqlseqlist = "SELECT  name,status,msgSeq,enrollPerDay,id from ext_sequences  where status != 'Deleted' AND msgSeq = 1 AND user_id = ".Yii::$app->session->get('userid');
		 $countsequencelist = Yii::$app->db->createCommand($totsqlseqlist)->queryAll();
		 
		 if(isset($_POST['totalRowsCountmsg']))
		 {
			 $totalPage = $_POST['totalRowsCountmsg'] / $perpage;
		 }else{
			  $totalPage = count($countsequencelist) / $perpage;
		 }
		
		 $totalPagecount = ceil($totalPage);
		 
		
//		$sqlseqlist = "SELECT  name,status,msgSeq,enrollPerDay,id from ext_sequences  where status != 'Deleted' AND msgSeq = 1 AND user_id = ".Yii::$app->session->get('userid')." order by id DESC limit $perpageoffset,$perpage ";
                $sqlseqlist = "SELECT  s.SelectedcsvId,s.webhookVal,s.name,s.status,s.msgSeq,s.enrollPerDay,s.id,s.working_hour_id,w.server_start_time,w.server_end_time from ext_sequences  as s left join ext_working_hours as w on s.working_hour_id=w.id where s.status != 'Deleted' AND s.msgSeq = 1 AND s.user_id = " . Yii::$app->session->get('userid') . " order by s.id DESC limit $perpageoffset,$perpage ";
        $sequencelist = Yii::$app->db->createCommand($sqlseqlist)->queryAll();
		
		?>
		<table class="table table-striped table mb-0 sequencesMainList" id="sequencesMainList">
										<thead>
											<tr>                          
												<th class="text-center" style="padding: 0 10px;">#</th>
												<?php //if(Yii::$app->session->get('userid') == '16839'){ ?>
												<th style="width: 20px;padding: 0;margin: 0;"></th>
												<?php // } ?>
												<th>Name</th>
												<th style="text-align:center;" >Statistics</th> 
												<th class="text-center" data-hide="phone,tablet" width="20%">Per Day Limit</th>
												<th data-hide="phone,tablet">Action</th>
												<th data-hide="phone,tablet">Options</th>
											</tr>
										</thead>
										<tbody>
												<?php $i=1; 
												$sn = ($currentPage * $perpage - ($perpage)) + 1;
												foreach($sequencelist as $rows){
													$statusbadge = 'info';
													if($rows['status'] == 'Active')
													{
														$statusbadge = 'primary'; 
														 
													}else if($rows['status'] == 'Not Started'){
														$statusbadge = 'secondary'; 
													}else if($rows['status'] == 'Paused'){
														$statusbadge = 'info';
													}else if($rows['status'] == 'Error'){
														$statusbadge = 'danger';
													}else if($rows['status'] == 'Stopped'){
														$statusbadge = 'warning'; 
													}else if($rows['status'] == 'Complete'){
														$statusbadge = 'success';
													}else{
														$statusbadge = 'info';
													} 
													
												$seqNamemsg = '';
												if(isset($rows['name']))
												{
														if(strlen($rows['name']) > 30){
															$seqNamemsg = substr($rows['name'],0,25).'...';
														}
														else{
															$seqNamemsg = $rows['name'];
														} 
												}
												$timerActive = "";
                                                                                                $startTime = "";
                                                                                                $server_start_time = "";
                                                                                                $server_end_time = "";
                                                                                                $currentTime = "";
                                                                                                if($rows['status'] == "Active"){
                                                                                                    $timerActive = 'timerActive';                                                                     
                                                                                                    $server_start_time = strtotime(date("M d Y")." ". $rows['server_start_time'])*1000;
                                                                                                    $server_end_time = strtotime(date("M d Y")." ". $rows['server_end_time'])*1000;
                                                                                                    $t = time();
//                                                                                                    $currentTime = strtotime(date("M d Y")." ".date("h:i:s", $t))*1000;
                                                                                                    $currentTime = round(microtime(true) * 1000);
                                                                                                }
												$seqtypelab = '<a title="URL Sequence" class="view_seq" data-seq-id="'.$rows['id'].'" href="javascript:void();"><i class="bx bx-link-alt"></i></a>';
													
												$isgroupicon = '';
												//if(Yii::$app->session->get('userid') == 16839){
												$getseqfrsturl = Yii::$app->db->createCommand("SELECT link FROM ext_links where seqId = '".$rows['id']."' limit 1")->queryOne();
													
													if(isset($getseqfrsturl['link']) && $getseqfrsturl['link'] != ''){
														
														if (strpos($getseqfrsturl['link'], '/groups/') !== false) {
															$isgroupicon = '<a title="Group Sequence" class="view_seq" data-seq-id="'.$rows['id'].'" href="javascript:void();"><i class="bx bxs-group"></i></a>';
														}
													
													} 
												//}
												
												
												if($rows['SelectedcsvId'] > 0 && $rows['SelectedcsvId'] != ''){
													
													$seqtypelab = '<a title="CSV Sequence" class="view_seq" data-seq-id="'.$rows['id'].'" href="javascript:void();"><i class="bx bxs-file"></i></a>';
												}
												else if($rows['webhookVal'] > 1 && $rows['webhookVal'] != '')
												{
													$seqtypelab = '<a title="Webhook Sequence" class="view_seq"  data-seq-id="'.$rows['id'].'" href="javascript:void();"><i class="bx bx-world"></i></a>';
												}
												else{
													
													$seqtypelab = '<a title="URL Sequence" class="view_seq" data-seq-id="'.$rows['id'].'" href="javascript:void();"><i class="bx bx-link-alt"></i></a>';
												}
												?>
												<tr class="row_class seq_row <?php echo $timerActive; ?>" data-server-time="<?php echo $currentTime; ?>" data-start-time="<?php echo $server_start_time; ?>" data-end-time="<?php echo $server_end_time; ?>" data-seq-id="<?php echo $rows['id']; ?>">
													<td class="text-center"><?php echo $sn; ?></td> 
													<?php //if(Yii::$app->session->get('userid') == '16839'){ ?>
													<td class="text-center"><?php if($isgroupicon == ''){ echo $seqtypelab; } else { echo $isgroupicon; } ?></td> 
													<?php  //} ?>
													<td><?php if($rows['msgSeq']==0){ echo '<a href="#" title="2nd Degree Connection">'; }else{ echo '<a href="#" title="1st Degree Messages"></a>';} ?> <?php echo  '<a href="javascript:void(0);" title="'.$rows['name'].'" style="color:#727E8C; padding: 5px;" data-seq-id="'.$rows['id'].'" class="view_seq_logs">'.$seqNamemsg.'</a>'; ?><br><div style="padding: 5px;margin-left: 8px;font-size: 10px; border-radius: 2px;" class="badge badge-pill badge-light-<?php  echo $statusbadge; ?> mr-1 mb-1 ch_stat_<?php echo  $rows['id']; ?> target_aud<?php echo $rows['id']; ?>" id="ch_stat_<?php echo  $rows['id']; ?>"><?php echo $rows['status']; ?></div></td> 
													<?php 
													$sqlenrolled = "SELECT id FROM ext_tasks WHERE seqId = '".$rows['id']."' AND status = 'Complete' AND step = 0";
														$countenrolled = Yii::$app->db->createCommand($sqlenrolled)->queryAll();
													$Totalcountenrolled = count($countenrolled);
													?>
													<td>
													<!--<span title="Total Enrolled" style="cursor:pointer;" class="badge badge-pill badge-round badge-light-info countConreq_<?php echo  $rows['id']; ?>"><?php echo $Totalcountenrolled; ?></span>-->
													<!--<div class="donut-chart-wrapper">
														<div id="donut-chart<?php echo  $rows['id']; ?>" class="d-flex justify-content-center"></div>
														<div class="statistics-data my-auto">
														  <div class="statistics">
															<span class="font-medium-2 mr-50 text-bold-600 countConreq_<?php echo  $rows['id']; ?>"><?php echo $Totalcountenrolled; ?></span>
														  </div>
														</div>
														</div>-->
														<div class="row">
														  <div class="col">
                                                        <div class="statistics-data my-auto">
															<div class="statistics" style="text-align: center;">
                                                                <span class="font-medium-2 mr-50 text-bold-600 countConreq_<?php echo  $rows['id']; ?>">0</span><!--<span class="text-success">(+16.2%)</span>-->
                                                            </div>
															<div class="statistics-date" style="text-align: center;">
                                                                <!--<i class="bx bx-radio-circle font-small-1 text-success mr-25"></i>-->
                                                                <small class="text-muted">Total Enrolled</small>
                                                            </div>
                                                            
                                                        </div>
                                                        </div>
                                                        </div>
                                                
														
														<?php 
														$sqlaccept = "SELECT  id from blacklist  where is_accepted = 1 AND seq_id=" .$rows['id'];
														$countaccept = Yii::$app->db->createCommand($sqlaccept)->queryAll();
		
														$sqlresponse = "SELECT  id from blacklist  where (is_response = 1 OR is_response = 2) AND seq_id=" .$rows['id'];
														$countresponse = Yii::$app->db->createCommand($sqlresponse)->queryAll();
														
														$Totalcountaccept = count($countaccept);
														$Totalcountresponse = count($countresponse);
														?>
														<script>
														$( document ).ready(function() { 
														var donutchartId = 'donut-chart'+<?php echo  $rows['id']; ?>;	
				var totaccepted = <?php echo $Totalcountaccept; ?>;
				var totresponse = <?php echo $Totalcountresponse; ?>;
				var totrequestsent = <?php echo $Totalcountenrolled; ?>;
		
														var donutChartOption = {
																chart: {
																  width: 80,
																	height: 110,
																  type: 'donut'
																},
																dataLabels: {
																  enabled: false
																},
																series: [totaccepted, totresponse],
																labels: ["Accept", "Response"],
																stroke: {
																  width: 2,
																  lineCap: 'round',
																},
																
																colors: ['#5A8DEE', '#00CFDD'],	
																
																plotOptions: {
																  pie: {
																	offsetY: 15,
																	donut: {
																	  size: '70%',
																	}
																  }
																},
																legend: {
																  show: false
																}
															  }
		
															  var donutChart = new ApexCharts(
																document.querySelector("#"+donutchartId),
																donutChartOption
															  );

															  donutChart.render();
															  });
														</script>
												
													</td>
													<td>
													<?php if($rows['status'] != 'Deleted') { ?>
													<?php if($rows['msgSeq'] == 0){ ?>
													<input type="number" class="num ppdel form-control text-center" id="ppdel_<?php echo  $rows['id']; ?>" min="1"  
													 
													value="<?php 
														if($rows['msgSeq'] == 0){
															if($rows['enrollPerDay'] == '')
															{
																
																	echo 0;
															} 
															else 
															{ 
																echo $rows['enrollPerDay']; 
															} 
														}
													?>">
													<?php } else { ?>
													<input type="number" class="numM mprl form-control text-center"  id="mprl_<?php echo  $rows['id']; ?>"  min="1" 
													value="<?php 
													if($rows['msgSeq'] == 1)
													{
														if($rows['enrollPerDay'] == '')
														{
															
																echo 0; 
														} 
														else
														{
															echo $rows['enrollPerDay']; 
														}
													}
											
													?>">
													<?php } ?>
                                                                                                        <?php if($rows['enrollPerDay'] < 1 && $rows['status'] == 'Active'){ ?>                                                                                                        
                                                                                                        <div class="on_zero_enroll on_zero_enroll_<?php echo $rows['id']; ?>" style="text-align: right;width: 20px;float: right;margin-right: 50px;margin-top: -30px;">
                                                                                                        <i class="bx bxs-error" title="Increase limit to enroll new prospects" style="color: #fdac41;"></i>
                                                                                                        </div>
                                                                                                        <?php } ?>
													<?php } ?>
													</td>
												 <td class="status_row_<?php echo  $rows['id']; ?>">
													<div id="LoaderSteps_<?php echo htmlspecialchars($rows['id'],ENT_QUOTES); ?>" style="display: none">                                      
														<img src="<?php echo Yii::$app->urlManager->baseUrl?>/img/varun_loader.gif" style=" width: 15px;"> 
													</div>
													<div class="seq_lable">
													<?php 
													if($rows['status'] == 'Not Started' ||  $rows['status'] == 'Stopped')
													{
														echo '<a href="javascript:void(0);"  data-seq-type="'.$rows['msgSeq'].'" class="changeSeqStatus badge badge-success btnStart" data-seq-id="Active-'.$rows['id'].'" >Start</a>';
													}else if($rows['status'] == 'Paused'){
													
														echo '<a href="javascript:void(0);"  data-seq-type="'.$rows['msgSeq'].'" class="changeSeqStatus badge badge-primary btnStart" data-seq-id="Active-'.$rows['id'].'" >Continue</a>'; 
													
													}
													else if($rows['status'] == 'Active'){
														echo '<a href="javascript:void(0);" data-seq-type="'.$rows['msgSeq'].'"  class="changeSeqStatus badge badge-warning btnActive" data-seq-id="Stopped-'.$rows['id'].'" >Stop</a>&nbsp;<a href="javascript:void(0);" data-seq-type="'.$rows['msgSeq'].'"  class="changeSeqStatus badge badge-info btnActive" data-seq-id="Paused-'.$rows['id'].'" >Pause</a>';
													}
													else if($rows['status'] == 'Complete'){
														echo '<label  class="badge badge-primary btnCompleted" >Completed</label>';
													}else{
														echo '<label  class="badge badge-danger btnDeleted" >Error</label>&nbsp;<a href="javascript:void(0);"  data-seq-type="'.$rows['msgSeq'].'" class="changeSeqStatus badge badge-success btnStart" data-seq-id="Active-'.$rows['id'].'" >Continue</a>';
													} 
													?>
													</div>  
													</td>
													<td class="text-center py-1">
                                                    <div class="dropdown">
                                                        <span class="bx bx-dots-vertical-rounded font-medium-3 dropdown-toggle nav-hide-arrow cursor-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" role="menu"></span>
                                                        <div class="dropdown-menu dropdown-menu-right">
                                                           

															<?php if($rows['status'] == 'Deleted') {?>
															<a href="javascript:void(0);" class="clone_seq dropdown-item" data-seq-type="<?php echo  $rows['msgSeq']; ?>"  data-seq-id="<?php echo  $rows['id']; ?>" title="Clone Sequence" ><i class="bx bxs-copy mr-1"></i>clone</a>
															<a href="javascript:void(0);" class="view_seq dropdown-item" data-seq-id="<?php echo  $rows['id']; ?>" title="View Sequence" ><i class="bx bx-show mr-1"></i>clone</a>
															<?php } else { ?>
															<a href="javascript:void(0);" class="clone_seq dropdown-item" data-seq-type="<?php echo  $rows['msgSeq']; ?>"  data-seq-id="<?php echo  $rows['id']; ?>" title="Clone Sequence" ><i class="bx bxs-copy mr-1"></i>clone</a>

															<a class="dropdown-item" href="?seqid=<?php echo $rows['id']; ?>"  title="Edit Sequence" ><i class="bx bx-edit-alt mr-1"></i>edit</a>

															<a href="javascript:void(0);" class="delete_seq dropdown-item" data-seq-id="<?php echo  $rows['id']; ?>" title="Delete Sequence" ><i class="bx bx-trash mr-1"></i>delete</a> 

															<span class="seq_view_url_<?php echo $rows['id']; ?>" <?php //if($rows['status'] != 'Not Started'){ echo 'style="display:contents"'; } else { echo 'style="display:none"';}?>></span>

															<a href="javascript:void(0);" class="view_seq dropdown-item" data-seq-id="<?php echo  $rows['id']; ?>" title="View Sequence" ><i class="bx bx-show mr-1"></i>View</a><?php //if($rows['status'] == 'Active' || $rows['status'] == 'Paused') { ?>

															<a href="javascript:void(0);" class="view_seq_logs dropdown-item" data-seq-id="<?php echo  $rows['id']; ?>" title="View Logs"><i class="bx bx-history mr-1"></i>Activity Log</a><?php //} ?>
															<?php } ?>
                                                        </div>
                                                    </div>
                                                </td>	
												</tr>
												<?php $i++;$sn++; } ?>  
										</tbody>
									</table>
									<!-- Pagination  -->
									<input type="hidden" name="totalRowsCountmsg" value="<?php echo count($countsequencelist);?>" id="totalRowsCountmsg" />
									<div class="dataTables_info" id="DataTables_Table_4_info" role="status" aria-live="polite">Showing <?php echo $perpageoffset; ?> to <?php if($currentPage < $totalPagecount){echo $perpage * $currentPage; } else{ echo count($countsequencelist); } ?> of <?php echo count($countsequencelist);?> entries</div>
									<div class="pagination paginationmsg">
									<?php if($totalPagecount > 1){ ?>
									<ul class="pagination">
										<!-- Previous -->
										<li class="Prevpagedatamsg" >
										<a class="page-link" href="javascript:void(0);" >Previous</a>
										</li>
										<!-- Previous End -->
										<?php 
										$perpagdata = 0;
										for($p=1; $p <= $totalPagecount; $p++){ 
										if($p > 1){
											$perpagdata = $perpage * $p - $perpage;
										}
										?>
										<li onClick="changePagemsg(<?php echo $perpagdata; ?>,<?php echo $p; ?>);"  class="showthispage_<?php echo $perpagdata; ?> <?php if($p==$currentPage){?>active<?php } ?>">
										<a href="javascript:void(0);" class="page-link"><?php echo $p; ?></a>
										</li>
										<?php } ?>
										<!-- Next -->
										<li class="Nextpagedatamsg" >
										<a class="page-link" href="javascript:void(0);" >Next</a>
										</li>
										<!-- Next End -->
										
									</ul>
									<?php } ?>
									</div>
									<!--End Pagination  -->
									
		<?php 
	}
	
	public function actionSelecttemplate() // Select steps templates
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }  
			//echo '<prE>'; print_r($_POST); exit;
			$templateid = $_POST['templateid'];
			$checkdataCsv = Yii::$app->db->createCommand("SELECT template FROM templates WHERE templateid ='".$templateid."'")->queryOne();
			echo $checkdataCsv['template'];
		
	}
	
	public function actionAddnewsequence() // Add new sequence
	{
		 if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		//echo '<prE>'; print_r($_POST); exit; 
		$selected_type = 0;
		$isDirectMsg = 0;
		if($_POST['selected_type'] == 'Messaging Sequence'){
		$selected_type = 1;
		}
		
		if($_POST['selected_type'] == 'Free InMails'){
		$selected_type = 1;
		$isDirectMsg = 1;
		}
		
	    $savesql = Yii::$app->db->createCommand("INSERT INTO ext_sequences (user_id,name,status,msgSeq,zapireStatus,isDirectMsg) VALUES ('".Yii::$app->session->get('userid')."','New Sequence','Not Started','".$selected_type."','false','".$isDirectMsg."')")->execute(); 
		$seq_id = Yii::$app->db->getLastInsertID(); 
	   
		
		/*$savesql = Yii::$app->db->createCommand("INSERT INTO sequences (id,user_id,local_db_id,seq_url,local_seq_json,local_seq_step,seq_type) VALUES ('".$seq_id."','".Yii::$app->session->get('userid')."','".$seq_id."','','','','')")->execute();*/
		
		
		
		 return $seq_id; 
		
		
		
	 
		
	}
	
	
	public function actionClonenewsequence()//clone sequence
	{
		 if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		//echo '<prE>'; print_r($_POST); exit; 
		$selected_type = 0;
		$get_clone_seq_id = $_POST['get_clone_seq_id'];
		$get_clone_seq_type = $_POST['get_clone_seq_type'];
		
		$getCurseqData = Yii::$app->db->createCommand("SELECT name,zapireStatus,requestWithdrawDays,isDirectMsg FROM ext_sequences WHERE id ='".$get_clone_seq_id."'")->queryOne();
		
		// insert into new sequence table
	    $savesql = Yii::$app->db->createCommand("INSERT INTO ext_sequences (user_id,name,status,msgSeq,zapireStatus,requestWithdrawDays,isDirectMsg) VALUES ('".Yii::$app->session->get('userid')."','".addslashes($getCurseqData['name'])." copy','Not Started','".$get_clone_seq_type."','false','".$getCurseqData['requestWithdrawDays']."','".$getCurseqData['isDirectMsg']."')")->execute();
		$seq_id = Yii::$app->db->getLastInsertID(); 
	   
	
		
		// Get and Insert data in links table
		//$getalllinks = Yii::$app->db->createCommand("SELECT link,status from `ext_links` where seqId = '".$get_clone_seq_id."' order by `order` ASC")->queryAll();
		//$i=1;
		//foreach($getalllinks as $key=>$value){
			
			//$savelinkssql = Yii::$app->db->createCommand("INSERT INTO ext_links (seqId,link,status,`order`) VALUES ('".$seq_id."','".$value['link']."','Not Started','".$i."')")->execute();
			//$i++; 
		//} 
		
		// Get and Insert steps for clone
		$getallsteps = Yii::$app->db->createCommand("SELECT message,type,delayDays,delayMinutes from `ext_steps` where seqId = '".$get_clone_seq_id."' order by `order` ASC")->queryAll();
		$j=0;
		$messagecp ='';
		foreach($getallsteps as $key=>$value){
			
			$messagecp = addslashes($value['message']);
			
			$savelinkssql = Yii::$app->db->createCommand("INSERT INTO ext_steps (seqId,`order`,message,type,delayDays,delayMinutes) VALUES ('".$seq_id."','".$j."','".$messagecp."','".$value['type']."','".$value['delayDays']."','".$value['delayMinutes']."')")->execute();
			$j++; 
		} 
		 return $seq_id; 
		
		
		
	 
		
	}
	
	
	public function actionCreatesequences_OldMethodBkp() // update sequence
	{  die;
		 if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
	
		
		//if(Yii::$app->session->get('userid') == '16943'){
			//echo '<pre>'; print_r($_POST); exit;
		//}
		// Seq Data 
		$zapier_action = 0;
		if(isset($_POST['zapier_action']) && $_POST['zapier_action'] == 1){
			
			$zapier_action = $_POST['zapier_action'];
			
		}
		
		$currentSeqID = $_POST['currentSeqID'];
		$zapEventArry = '';
		$SelectedcsvId = '';
		$working_hour_id = 0;
		if(isset($_POST['radioGlow'])){
		$working_hour_id = $_POST['radioGlow'];
		}
		$seq_name = addslashes($_POST['seq_name']);
		$seq_name = htmlspecialchars($seq_name);
		if(Yii::$app->session->get('userid') == '14878' || Yii::$app->session->get('userid') == '14909') {
		$seq_name = htmlspecialchars_decode($seq_name);
		//echo $seq_name; exit;
		 }
		 
		$seq_type = $_POST['seq_type'];
		$status = 'Not Started';
		if(isset($_POST['withdraw_days'])){
		$withdraw_days = $_POST['withdraw_days'];
		} else{
		$withdraw_days = 0;
		}
		$t=time();
		$createdAt =  $t;
		if(isset($_POST['currentTimeZone'])){
		// Get timezone
			$timezone_offset_minutes = $_POST['currentTimeZone'];
			$timezone_name = timezone_name_from_abbr("", $timezone_offset_minutes*60, false);
		// End get timezone
		}
		
		// Zapier status
		if(isset($_POST['zapirestatus']) && $_POST['zapirestatus'] == 1){
		$zapirestatus = 'true';
		}
		else{
		$zapirestatus = 'false';	
		}
		
		// Zaier Array to json
		if(isset($_POST['zapirestatus']) && $_POST['zapirestatus'] == 1)
		{  
			$firstdegrrearra = array("Invitationsent","Accept","Withdraw");
			if($seq_type == 0){
			$zapEventArry = explode(",",$_POST['zapier_events_array']);
			}
			else{ // if 1st degree seq
			$zapEventArry = explode(",",$_POST['zapier_events_array']);	
			$zapEventArry = array_diff($zapEventArry,$firstdegrrearra);
			}
			
			$zapEventArry = json_encode($zapEventArry);
		}
		else
		{
			$zapEventArry = "";
		}
		// End 
		
		
		// End Zapier data
		
		// Is Webhook 
		$webhook_val = 0;
		
		$return_array= array();
		$userid = Yii::$app->session->get('userid');
		
		$check_onAccept = Yii::$app->db->createCommand("SELECT * FROM `user` WHERE id ='".$userid."' AND `addBlaklist_OnAcceptance` = '1' ")->execute();
		$checkForAcceptance = "";
		$check_BlackList = Yii::$app->db->createCommand("SELECT * FROM `user` WHERE id ='".$userid."' AND `skip_Blacklist` = 0 ")->execute();
		
		if (count($check_onAccept) > 0 ){
			$checkForAcceptance .= " AND is_accepted = 1 ";
		}	
		
		// Check source of profile data 
		//1:linkedin url
		//2:CSV 
		//3:webhooks
		//echo '<pre>'; print_r($_POST); exit;
		
		$SelectedcsvId = 0;
		$seq_url_type = 0; 
		$seq_type_for_old_tbl = 0;
		if(isset($_POST['csvurl']) && $_POST['csvurl'] == 'webhook')
		{
			$seq_url_type = 3;
			$seq_type_for_old_tbl = 'Webhook';
		}
		else if(isset($_POST['csvurl']) && $_POST['csvurl'] == 'https://www.dummyorgin.dummy')
		{
			$seq_url_type = 2;
		}
		else
		{
			$seq_url_type = 1;
		}
		// End Check source of profile data
		
		// Get current sequence status
		
		if(isset($_POST['currentSeqID'])){
		$getcurseqstatus = Yii::$app->db->createCommand("SELECT status from `ext_sequences` where id = '".$_POST['currentSeqID']."'")->queryOne();
		$cur_seq_sts = $getcurseqstatus['status'];
		}
		
		// IF Webhook
		if($seq_url_type == 3){
			
				
				$webhook_val = 1;
				
				$Chklinks = Yii::$app->db->createCommand("SELECT seqId from `ext_links` where seqId = '".$_POST['currentSeqID']."'")->queryOne();
				if($Chklinks['seqId'] == ''){
				$sqllinks = Yii::$app->db->createCommand("INSERT INTO `ext_links`(`seqId`,`userId`,`link`,`status`,`order`) VALUES ('".$_POST['currentSeqID']."','".$userid."','https://www.dummyorgin.dummy','Not Started','1')")->execute(); 
				
				}
				
				// Update sequences name to webhook table
				
				
			
		}
		// If linkedin URL
		if($seq_url_type == 1)
		{   
			
			
			
		}
		
		
		 
		// If csv 
		if($seq_url_type == 2)
		{
			// Check if CSV Uploaded Or Selected
			if(isset($_POST['seqcsvfileID']) && $_POST['seqcsvfileID'] > 0)
			{
				// CSV Selected from dropdown
				$Chklinks = Yii::$app->db->createCommand("SELECT seqId from `ext_links` where seqId = '".$_POST['currentSeqID']."'")->queryOne();
				if($Chklinks['seqId'] == ''){
				$SelectedcsvId = $_POST['seqcsvfileID'];
				$sqllinks = Yii::$app->db->createCommand("INSERT INTO `ext_links`(`seqId`,`userId`,`link`,`status`,`order`) VALUES ('".$_POST['currentSeqID']."','".$userid."','https://www.dummyorgin.dummy','Not Started','1')")->execute(); 
				}
			}
			else
			{
				// New CSV Uploaded
				if ($_FILES['csvfile1']['size'] == 0 && $_FILES['csvfile1']['error'] == 0)
				{
					//"Error in File";
					echo "Error in File";
				}
				else
				{
					
					
					echo "No Error in File";
					 // insert CSV Data to database
					 
						$fileName = $_FILES["csvfile1"]["tmp_name"];
						
						if ($_FILES["csvfile1"]["size"] > 0) {
							
							$file = fopen($fileName, "r");
							$key=1;
							$IdSegment = [];
							$values = [];
							$is_sales_url = 0;
							while (($checkData = fgetcsv($file, 10000, ",")) !== FALSE) {
								
								
								
								
								 
								// Check if sale url or not
								$haystack = $checkData[0];
								$needle   = "sales/people";
								if( strpos( $haystack, $needle ) !== false) {
									$is_sales_url = 1;
								}else{
									$is_sales_url = 0;
								}
								
								
								
								
								
								// Validate csv
								
								if(trim($checkData[0]) == '')
								continue;
		
								if (strpos($checkData[0], '.linkedin.com') == false) {
								continue;
								} 
								
								
								
							   
								$segments = explode('/', $checkData[0]);
								$numSegments = count($segments); 
								
								
							  
								
								$pubid = '';
								if($segments[3] == "in")
								{
									$pubid=$segments[4];
									
									if($numSegments > 5){
										$checkData = implode('/',array_slice($segments, 0, 5));
									}
									else
									{
										$checkData = $checkData[0];
									}
									//echo '<pre>'; print_r($checkData); exit;
								}
								else if($segments[3] == "pub")
									{
										
										
										$pubid=$segments[4]."-";
										if(strlen($segments[7])>=3)
										{
											$pubid= $pubid.$segments[7];
										}
										else if(strlen($segments[7])==2)
										{
											$pubid=$pubid."0".$segments[7];
										}
										else if(strlen($segments[7])==1)
										{
											$pubid=$pubid."00".$segments[7];
										}
										
										if(strlen($segments[6])>=3)
										{
											$pubid= $pubid.$segments[6];
										}
										else if(strlen($segments[6])==2)
										{
											$pubid=$pubid."0".$segments[6];
										}
										else if(strlen($segments[6])==1)
										{
											$pubid=$pubid."00".$segments[6];
										}
										
										if(strlen($segments[5])>=2)
										{
											$pubid=$pubid.$segments[5];
										}
										else if(strlen($segments[5])==1)
										{
											$pubid=$pubid."0".$segments[7];
										}
									}
								 
								
								
								//$sqlchkblklist = Yii::$app->db->createCommand("SELECT url_publicIdentifier FROM blacklist where url_publicIdentifier  ='".$pubid."'  And teamid ='".$userid."' $checkForAcceptance")->execute();
								
								//if($sqlchkblklist > 0)
								//{
								// $checkData = ''; 
								//} 
							  
							 
							  
							   
							  
								if($is_sales_url == 1 || $segments[3] == 'pub'){ 
									
									if (strpos($checkData[0], '.linkedin.com') == false) {
										continue;
									}
								}
								else{
										/*if(Yii::$app->session->get('userid') == '14878'){
										
											echo  '<pre> dhaval ==='; print_r($checkData[0]); exit;
										
										} */
									
										if (strpos($checkData, '.linkedin.com') == false) {
											continue;
										}
									
								}
							
								
								 if(Yii::$app->session->get('userid') == '14878') {
								
								 //echo '<pre>'; print_r($checkData); exit;
								
								}
								
							
								if($is_sales_url == 1 || $segments[3] == 'pub'){ 
								
								//str_replace("world","Peter","Hello world!");
								
								$values[] = "('csvfile_id', '".str_replace("'","\'",$checkData[0])."')";
								
								}else{
								
								$values[] = "('csvfile_id', '".str_replace("'","\'",$checkData)."')";	
								
								}						
								
							    $key++;  
								
								
							}
							
							$addtotask = json_encode($return_array);
							
							$csvName = $_FILES['csvfile1']['name'];
							$csvName = addslashes($csvName);
							$csvName = htmlspecialchars($csvName);
							
							$sql = Yii::$app->db->createCommand("INSERT INTO `csvfiles`(`user_id`,`db_seq_id`,`file_name`) VALUES ('".$userid."','".$_POST['currentSeqID']."','".$csvName."')")->execute();
							$proInfo_id = Yii::$app->db->getLastInsertID(); // Last inserted csv file
							
							$SelectedcsvId = $proInfo_id;
							
							
							if($proInfo_id && !empty($values)){
								
								
								$sql1 = Yii::$app->db->createCommand("INSERT INTO `csvprofiles` (`csvfile_id`, `csvprofile`) VALUES ".str_replace('csvfile_id',$proInfo_id,implode(',', $values)))->execute();
							}
							
							$sqllinks = Yii::$app->db->createCommand("INSERT INTO `ext_links`(`seqId`,`userId`,`link`,`status`,`order`) VALUES ('".$_POST['currentSeqID']."','".$userid."','https://www.dummyorgin.dummy','Not Started','1')")->execute(); 
							
							
						}
						
					 // End insert CSV Data to database
				}
			} 
		}
		
		
		
		
		if(isset($_POST['seqcsvfileID']) && $_POST['seqcsvfileID'] > 0){
			$SelectedcsvId = $_POST['seqcsvfileID'];
		}
		
		if(Yii::$app->session->get('userid') == '14878') {
			//echo $SelectedcsvId; exit;
		}
		
		// Update sequences
		$savesql = Yii::$app->db->createCommand("UPDATE ext_sequences set 
		name = '".$seq_name."',
		msgSeq = '".$seq_type."',
		working_hour_id = '".$working_hour_id."',
		requestWithdrawDays = '".$withdraw_days."',
		createdAt = '".$createdAt."',
		webhookVal = '".$webhook_val."',
		target_audience_type = '".$seq_url_type."', 
		timezone = '".$timezone_name."',
		zaptouse = '".$zapEventArry."',
		zapireStatus = '".$zapirestatus."',
		zapier_action = '".$zapier_action."',
		SelectedcsvId = '".$SelectedcsvId."' where id=".$_POST['currentSeqID']."")->execute();
		
		// add webhhok url to webhook table
		$webhookUrl = '';
		if(isset($_POST['webhookUrlcp']) && $_POST['webhookUrlcp'] != '')
		{
				$webhookUrl = $_POST['webhookUrlcp'];
					
				$sqlweburl = Yii::$app->db->createCommand("INSERT INTO `webhooks`(`w_seq_id`,`w_seq_name`,`w_url`,`w_user_id`) VALUES ('".$_POST['currentSeqID']."','".$seq_name."','".$webhookUrl."','".$userid."')")->execute(); 
		}
		
	}
	

	public function actionCreatesequences() // update sequence
	{  
		 if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		
		$zapier_action = 0;
		if(isset($_POST['zapier_action']) && $_POST['zapier_action'] == 1){
			
			$zapier_action = $_POST['zapier_action'];
			
		}
		
		$bypassweeklyvalue = $_POST['bypassweeklyvalue'];
		
		$getseqconstep = Yii::$app->db->createCommand("SELECT message from `ext_steps` where seqId = '".$_POST['currentSeqID']."' AND type = 'Connect' AND message = '' ")->queryOne(); 
		
		if(isset($getseqconstep['message']) && $getseqconstep['message'] == '' && $bypassweeklyvalue == 0){
			
			$bypassweeklyvalue = 1;
			
		} 
		
		$postlike_days = $_POST['postlike_days'];
		$enablepostlike = $_POST['enablepostlike'];
		//if(Yii::$app->session->get('userid') == '16839') {
			// echo '<pre>'; print_r($_POST); exit;
		//}
	    //echo '<pre>'; print_r($_POST); exit;
		// Seq Data 
		$currentSeqID = $_POST['currentSeqID'];
		$zapEventArry = '';
		$SelectedcsvId = '';
		$working_hour_id = 0;
		if(isset($_POST['radioGlow'])){
		$working_hour_id = $_POST['radioGlow'];
		}
		$seq_name = addslashes($_POST['seq_name']);
		$seq_name = htmlspecialchars($seq_name);
		if(Yii::$app->session->get('userid') == '14878' || Yii::$app->session->get('userid') == '14909') {
		$seq_name = htmlspecialchars_decode($seq_name);
		//echo $seq_name; exit;
		 }
		 
		$seq_type = $_POST['seq_type'];
		$isDirectMsg = $_POST['isDirectMsg'];
		$status = 'Not Started';
		if(isset($_POST['withdraw_days'])){
		$withdraw_days = $_POST['withdraw_days'];
		} else{
		$withdraw_days = 0;
		}
		$t=time();
		$createdAt =  $t;
		if(isset($_POST['currentTimeZone'])){
		// Get timezone
			$timezone_offset_minutes = $_POST['currentTimeZone'];
			$timezone_name = timezone_name_from_abbr("", $timezone_offset_minutes*60, false);
		// End get timezone
		}
		
		// Zapier status
		if(isset($_POST['zapirestatus']) && $_POST['zapirestatus'] == 1){
		$zapirestatus = 'true';
		}
		else{
		$zapirestatus = 'false';	
		}
		
		// Zaier Array to json
		if(isset($_POST['zapirestatus']) && $_POST['zapirestatus'] == 1)
		{  
			$firstdegrrearra = array("Invitationsent","Accept","Withdraw");
			if($seq_type == 0){
			$zapEventArry = explode(",",$_POST['zapier_events_array']);
			}
			else{ // if 1st degree seq
			$zapEventArry = explode(",",$_POST['zapier_events_array']);	
			$zapEventArry = array_diff($zapEventArry,$firstdegrrearra);
			}
			
			$zapEventArry = json_encode($zapEventArry);
		}
		else
		{
			$zapEventArry = "";
		}
		// End 
		
		
		// End Zapier data
		
		// Is Webhook 
		$webhook_val = 0;
		
		$return_array= array();
		$userid = Yii::$app->session->get('userid');
		
		$check_onAccept = Yii::$app->db->createCommand("SELECT * FROM `user` WHERE id ='".$userid."' AND `addBlaklist_OnAcceptance` = '1' ")->execute();
		$checkForAcceptance = "";
		$check_BlackList = Yii::$app->db->createCommand("SELECT * FROM `user` WHERE id ='".$userid."' AND `skip_Blacklist` = 0 ")->execute();
		
		if (count($check_onAccept) > 0 ){
			$checkForAcceptance .= " AND is_accepted = 1 ";
		}	
		
		// Check source of profile data 
		//1:linkedin url
		//2:CSV 
		//3:webhooks
		//echo '<pre>'; print_r($_POST); exit;
		
		$SelectedcsvId = 0;
		$seq_url_type = 0; 
		$seq_type_for_old_tbl = 0;
		if(isset($_POST['csvurl']) && $_POST['csvurl'] == 'webhook')
		{
			$seq_url_type = 3;
			$seq_type_for_old_tbl = 'Webhook';
		}
		else if(isset($_POST['csvurl']) && $_POST['csvurl'] == 'https://www.dummyorgin.dummy')
		{
			$seq_url_type = 2;
		}
		else
		{
			$seq_url_type = 1;
		}
		// End Check source of profile data
		
		// Get current sequence status
		
		if(isset($_POST['currentSeqID'])){
		$getcurseqstatus = Yii::$app->db->createCommand("SELECT status from `ext_sequences` where id = '".$_POST['currentSeqID']."'")->queryOne();
		$cur_seq_sts = $getcurseqstatus['status'];
		}
		
		// IF Webhook
		if($seq_url_type == 3){
			
				
				$webhook_val = 1;
				
				$Chklinks = Yii::$app->db->createCommand("SELECT seqId from `ext_links` where seqId = '".$_POST['currentSeqID']."'")->queryOne();
				if($Chklinks['seqId'] == ''){
				$sqllinks = Yii::$app->db->createCommand("INSERT INTO `ext_links`(`seqId`,`userId`,`link`,`status`,`order`) VALUES ('".$_POST['currentSeqID']."','".$userid."','https://www.dummyorgin.dummy','Not Started','1')")->execute(); 
				
				}
				
				// Update sequences name to webhook table
				
				
			
		}
		// If linkedin URL
		if($seq_url_type == 1)
		{   
			
			
			
		}
		
		
		 
		// If csv 
		$lastcsvfile_ins_id = $_POST['seqcsvfileID'];
		if($seq_url_type == 2)
		{
			// Check if CSV Uploaded Or Selected
			if(isset($_POST['seqcsvfileID']) && $_POST['seqcsvfileID'] > 0)
			{
				// CSV Selected from dropdown
				$Chklinks = Yii::$app->db->createCommand("SELECT seqId from `ext_links` where seqId = '".$_POST['currentSeqID']."'")->queryOne();
				if($Chklinks['seqId'] == ''){
					
				$SelectedcsvId = $_POST['seqcsvfileID'];
				$sqllinks = Yii::$app->db->createCommand("INSERT INTO `ext_links`(`seqId`,`userId`,`link`,`status`,`order`) VALUES ('".$_POST['currentSeqID']."','".$userid."','https://www.dummyorgin.dummy','Not Started','1')")->execute(); 
				
				//if($userid == '16943'){
					$copycsv = Yii::$app->db->createCommand("insert into csvfiles (user_id,db_seq_id,file_name,local_db_id,customHeadings) select ".$userid.",".$_POST['currentSeqID'].",file_name,0,customHeadings from csvfiles where id=".$_POST['seqcsvfileID'])->execute();
					$lastcsvfile_ins_id = Yii::$app->db->getLastInsertID(); // Last inserted csvfile id
					
					$copycsvprofiles = Yii::$app->db->createCommand("insert into csvprofiles (csvfile_id,csvprofile,isDeleted,customFieldDetails) select ".$lastcsvfile_ins_id.",csvprofile,0,customFieldDetails from csvprofiles where csvfile_id=".$_POST['seqcsvfileID'])->execute();
				//}
				
				}
							
				
			}
			else
			{
				// New CSV Uploaded
				if ($_FILES['csvfile1']['size'] == 0 && $_FILES['csvfile1']['error'] == 0)
				{
					//"Error in File";
					echo "Error in File";
				}
				else
				{
					
					
					echo "No Error in File";
					 // insert CSV Data to database
					 
						$fileName = $_FILES["csvfile1"]["tmp_name"];
						
						if ($_FILES["csvfile1"]["size"] > 0) {
							
							$file = fopen($fileName, "r");
							$key=1;
							$IdSegment = [];
							$values = [];
							$is_sales_url = 0;
							while (($checkData = fgetcsv($file, 10000, ",")) !== FALSE) {
                                                            
                                                            if ($key == 1 && strpos($checkData[0], 'linkedin.') === false) {
                                $firstHeading = $checkData;
                                unset($firstHeading[0]);
                                $customHeadings = json_encode(array_values($firstHeading), JSON_UNESCAPED_UNICODE);
                            }
                            if (strpos($checkData[0], 'linkedin.') !== false) {
                                $customeFieldDetails = $checkData;
                                unset($customeFieldDetails[0]);

                                $customeFieldDetails = array_values($customeFieldDetails);
                                $firstHeading = array_values($firstHeading);

                                $customeFieldArr = array();

                                for ($x = 0; $x <= count($firstHeading); $x++) {
                                    if (isset($customeFieldDetails[$x])) {
                                        $customeFieldArr[$firstHeading[$x]] = $customeFieldDetails[$x];
                                    }
                                }

                                $finalCustomField = json_encode($customeFieldArr, JSON_UNESCAPED_UNICODE);
//                                echo $finalCustomField;exit;
                            }
								
								
								
								
								 
								// Check if sale url or not
								$haystack = $checkData[0];
								$needle   = "sales/people";
								if( strpos( $haystack, $needle ) !== false) {
									$is_sales_url = 1;
								}else{
									$is_sales_url = 0;
								}
								
								
								
								
								
								// Validate csv
								
								if(trim($checkData[0]) == '')
								continue;
								//echo '<br/><br/>cd:'.$checkData[0];
		
									//if (strpos($checkData[0], '.linkedin.com') == false)
								if (strpos($checkData[0], 'linkedin.') === false) {
									//skipped this record if linkedin.com not found
									continue;
								} 

								
								
							   
								$segments = explode('/', $checkData[0]);
								//echo 'segments:<pre>'; print_r($segments);echo '</pre>';
								$numSegments = count($segments); 
								

							  
								
								$pubid = '';
								/*17-11-2020:Old orig commented
								if($segments[3] == "in")
								{
									$pubid=$segments[4];
									
									if($numSegments > 5){
										$checkData = implode('/',array_slice($segments, 0, 5));
									}
									else
									{
										$checkData = $checkData[0];
									}
									//echo '<pre>'; print_r($checkData); exit;
								}
								else if($segments[3] == "pub")
									{
										
										
										$pubid=$segments[4]."-";
										if(strlen($segments[7])>=3)
										{
											$pubid= $pubid.$segments[7];
										}
										else if(strlen($segments[7])==2)
										{
											$pubid=$pubid."0".$segments[7];
										}
										else if(strlen($segments[7])==1)
										{
											$pubid=$pubid."00".$segments[7];
										}
										
										if(strlen($segments[6])>=3)
										{
											$pubid= $pubid.$segments[6];
										}
										else if(strlen($segments[6])==2)
										{
											$pubid=$pubid."0".$segments[6];
										}
										else if(strlen($segments[6])==1)
										{
											$pubid=$pubid."00".$segments[6];
										}
										
										if(strlen($segments[5])>=2)
										{
											$pubid=$pubid.$segments[5];
										}
										else if(strlen($segments[5])==1)
										{
											$pubid=$pubid."0".$segments[7];
										}
									}
								 */
								
								
								//$sqlchkblklist = Yii::$app->db->createCommand("SELECT url_publicIdentifier FROM blacklist where url_publicIdentifier  ='".$pubid."'  And teamid ='".$userid."' $checkForAcceptance")->execute();
								
								//if($sqlchkblklist > 0)
								//{
								// $checkData = ''; 
								//} 
							  
							 
							  
							   
							  /*17-11-2020:Old orig commented 
								if($is_sales_url == 1 || $segments[3] == 'pub'){ 
									
									if (strpos($checkData[0], '.linkedin.com') == false) {
										//skipped this record if linkedin.com not found
										continue;
									}
								}
								else{
										//if(Yii::$app->session->get('userid') == '14878'){
										
											//echo  '<pre> dhaval ==='; print_r($checkData[0]); exit;
										
										//}
									
										if (strpos($checkData, '.linkedin.com') == false) {
											//skipped this record if linkedin.com not found
											continue;
										}
									
								}
								*/
								//17-11-2020: new code starts
								
								if($is_sales_url==1){
									
								}else if($is_sales_url==0 && isset($segments[3]) && $segments[3] == "in" && isset($segments[4]) && $segments[4]!=''){
									//DONE
									//eg: http://www.linkedin.com/in/josephd1
									//echo '<br/>A:checkData0='.$checkData[0];
									//echo '<br/>A:numSegments='.$numSegments;
									
									$pubid=$segments[4];
									$checkData[0] = 'https://www.linkedin.com/in/'.$pubid;
									//echo '<br/>::A2::'.$checkData[0];

								}else if($is_sales_url==0 && isset($segments[1]) && $segments[1] == "in" && isset($segments[2]) && $segments[2]!=''){
									//DONE
									//eg: linkedin.com/in/arthur-borowski-2b115b7
									//eg: www.linkedin.com/in/arthur-borowski-2b115b7
									//echo '<br/>B:checkData0='.$checkData[0];
									//echo '<br/>B:numSegments='.$numSegments;
									
									$pubid=$segments[2];
									$checkData[0] = 'https://www.linkedin.com/in/'.$pubid;

									
								}else if($is_sales_url==0 && isset($segments[3]) && $segments[3] == "pub" && isset($segments[4]) && $segments[4]!='' && isset($segments[5]) && $segments[5]!='' && isset($segments[6]) && $segments[6]!='' && isset($segments[7]) && $segments[7]!=''){
									//eg: https://www.linkedin.com/pub/april-bright/10/962/81
									
									//echo '<br/>C:checkData0='.$checkData[0];
									//echo '<br/>C:numSegments='.$numSegments;
									
									$pubid=$segments[4];
									
									$seg7Length = strlen($segments[7]);
									if($seg7Length==1){
										$seg7Str = '00'.$segments[7];
									}else if($seg7Length==2){
										$seg7Str = '0'.$segments[7];
									}else{
										$seg7Str = $segments[7];
									}

									$seg6Length = strlen($segments[6]);
									if($seg6Length==1){
										$seg6Str = '00'.$segments[6];
									}else if($seg6Length==2){
										$seg6Str = '0'.$segments[6];
									}else{
										$seg6Str = $segments[6];
									}
									
									if($segments[5]=='0'){
										$seg5Str = '';
									}else{
										$seg5Str = $segments[5];
									}

									
									$checkData[0] = 'https://www.linkedin.com/in/'.$pubid.'-'.$seg7Str.$seg6Str.$seg5Str;
									
									//https://www.linkedin.com/in/april-bright-08196210/

									/*Array
									(
										[0] => https:
										[1] => 
										[2] => www.linkedin.com
										[3] => pub
										[4] => april-bright
										[5] => 10
										[6] => 962
										[7] => 81
									)*/

								}
								
								//str_replace("world","Peter","Hello world!");
								$values[] = "('csvfile_id', '" . str_replace("'", "\'", $checkData[0]) . "','" . addslashes($finalCustomField) . "')";
																								
								//17-11-2020: new code ends
							
								
								 if(Yii::$app->session->get('userid') == '14878') {
								
								 //echo '<pre>'; print_r($checkData); exit;
								
								}
								
								/*17-11-2020:Old orig commented 
								if($is_sales_url == 1 || $segments[3] == 'pub'){ 
								
								//str_replace("world","Peter","Hello world!");
								
								$values[] = "('csvfile_id', '".str_replace("'","\'",$checkData[0])."')";
								
								}else{
								
								$values[] = "('csvfile_id', '".str_replace("'","\'",$checkData)."')";	
								
								}
								*/
								
								
								
							    $key++;  
								
								
							}
							
							$addtotask = json_encode($return_array);
							
							$csvName = $_FILES['csvfile1']['name'];
							$csvName = addslashes($csvName);
							$csvName = htmlspecialchars($csvName);
							
							$sql = Yii::$app->db->createCommand("INSERT INTO `csvfiles`(`user_id`,`db_seq_id`,`file_name`,`customHeadings`) VALUES ('" . $userid . "','" . $_POST['currentSeqID'] . "','" . $csvName . "','" . $customHeadings . "')")->execute();
							$proInfo_id = Yii::$app->db->getLastInsertID(); // Last inserted csv file
							
							$SelectedcsvId = $proInfo_id;
							
							
							if($proInfo_id && !empty($values)){
								$connection = new \yii\db\Connection([
                                'charset' => 'utf8mb4',
                                'dsn' => 'mysql:host=restorelinkedfusion610.cuuwos9fpos4.us-east-2.rds.amazonaws.com;dbname=linkedfusion',
                                'username' => 'linkedfusion',
                                'password' => 'Admin2020',
                            ]);
                            $connection->open();
                            
                            $sql1 = $connection->createCommand("INSERT INTO `csvprofiles` (`csvfile_id`, `csvprofile`,`customFieldDetails`) VALUES " . str_replace('csvfile_id', $proInfo_id, implode(',', $values)))->execute();
							}

							
							$sqllinks = Yii::$app->db->createCommand("INSERT INTO `ext_links`(`seqId`,`userId`,`link`,`status`,`order`) VALUES ('".$_POST['currentSeqID']."','".$userid."','https://www.dummyorgin.dummy','Not Started','1')")->execute(); 
							
							
						}
						
					 // End insert CSV Data to database
				}
			} 
		}
		

		
		
		if(isset($_POST['seqcsvfileID']) && $_POST['seqcsvfileID'] > 0){
			
			//if($userid == '16943'){
				$SelectedcsvId = $lastcsvfile_ins_id;
			//}else{
				//$SelectedcsvId = $_POST['seqcsvfileID'];
			//}
		}
		
		if(Yii::$app->session->get('userid') == '14878') {
			//echo $SelectedcsvId; exit;
		}
		
		
		
		// Update sequences
		$savesql = Yii::$app->db->createCommand("UPDATE ext_sequences set 
		name = '".$seq_name."',
		msgSeq = '".$seq_type."',
		isDirectMsg = '".$isDirectMsg."',
		working_hour_id = '".$working_hour_id."',
		requestWithdrawDays = '".$withdraw_days."',
		createdAt = '".$createdAt."',
		webhookVal = '".$webhook_val."',
		target_audience_type = '".$seq_url_type."', 
		timezone = '".$timezone_name."',
		zaptouse = '".$zapEventArry."',
		zapireStatus = '".$zapirestatus."',
		isPostLike = '".$enablepostlike."',
		bypassweekly = '".$bypassweeklyvalue."',
		postLikeDays = '".$postlike_days."',
		zapier_action = '".$zapier_action."',
		SelectedcsvId = '".$SelectedcsvId."' where id=".$_POST['currentSeqID']."")->execute();
		
		// add webhhok url to webhook table
		$webhookUrl = '';
		$webcutfieldStr = '';
		if(isset($_POST['webhookUrlcp']) && $_POST['webhookUrlcp'] != '')
		{
				$webhookUrl = $_POST['webhookUrlcp'];
					
				$sqlweburl = Yii::$app->db->createCommand("INSERT INTO `webhooks`(`w_seq_id`,`w_seq_name`,`w_url`,`w_user_id`) VALUES ('".$_POST['currentSeqID']."','".$seq_name."','".$webhookUrl."','".$userid."')")->execute(); 
				
				$webcutfieldStr = $_POST['webcutfieldStr'];
				
				if($webcutfieldStr != ''){
					
					$webcutfieldStrarr = explode(',',$webcutfieldStr);
					
					$webcutfieldStrjson = json_encode($webcutfieldStrarr);
					
					$sqlweburl = Yii::$app->db->createCommand("Update webhooks set customHeadings = '".$webcutfieldStrjson."' where w_seq_id = '".$_POST['currentSeqID']."' AND w_user_id = '".$userid."'")->execute(); 
					
				}
		}
		
	}
	
	public function actionAddnewlinktoseq() // add new link to sequense
	{
		 if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		$post_type_flag = '0';
		if(isset($_POST['post_type_flag']))
		{
			$post_type_flag = $_POST['post_type_flag'];
		}
		
		$seq_id = $_POST['seq_id'];
		$s_url = $_POST['s_url'];
		$userid = Yii::$app->session->get('userid');
		
		
		
		$countlinks = Yii::$app->db->createCommand("SELECT COUNT(id) as total_links from `ext_links` where seqId = '".$seq_id."'")->queryOne();
		
		$linksorder = $countlinks['total_links'] + 1;
		
		
		$s_url = str_replace("'","\'",$s_url);
		$sqllinks = Yii::$app->db->createCommand("INSERT INTO `ext_links`(`seqId`,`userId`,`link`,`status`,`order`,`postFlag`) VALUES ('".$seq_id."','".$userid."','".$s_url."','Not Started','".$linksorder."','".$post_type_flag."')")->execute();
		
		
		echo Yii::$app->db->getLastInsertId();   
		
	}
	
	public function actionRemovelinkfromseq() // remove link from sequense
	{
		 if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		$del_link_id = $_POST['del_link_id'];
		$userid = Yii::$app->session->get('userid');
		
		Yii::$app->db->createCommand("DELETE from `ext_links` where id = '".$del_link_id."'")->execute();
		
	}
	
        public function actionDeleteimagefroms3() {
            if(!Yii::$app->session->get('useremail')){
                $url = \Yii::$app->request->baseUrl."/login"; 
                return $this->redirect($url);
            }
            $imageid = $_POST['imageid'];
//            $getattachment = Yii::$app->db->createCommand("SELECT s3url from `attachment` where attachmentId = '".$imageid."'")->queryOne();
//            $existFileName = basename($getattachment['s3url']);
            
//            $credentials = new \Aws\Credentials\Credentials('AKIA2BIJALKAVZ7OR3IK', 'LHnhwkBth6yHymhRTk8aNdBtj2+Ra4Rslj1UPDhH');
//            $bucket="seqenceattachment";
//            $s3Client = new S3Client([					
//                'region' => 'us-east-1',  
//                'version' => 'latest',
//                'credentials' => $credentials
//            ]);
//            try{
//                $deleteExistFileName = $s3Client->deleteObject([
//                        'Bucket' => $bucket,
//                        'Key'    => $existFileName 
//                ]);
            
                $getCurStepData = Yii::$app->db->createCommand("SELECT stepId FROM `attachment` WHERE `attachmentId` = $imageid")->queryOne(); 
                $stepId =  $getCurStepData['stepId'];
                $savesql = Yii::$app->db->createCommand("UPDATE attachment set deleted_at = '".date('Y-m-d h:i:s')."' where attachmentId = '".$imageid."'")->execute();                
                $getStepDataCount = Yii::$app->db->createCommand("SELECT COUNT(attachmentId) as total  FROM `attachment` WHERE `stepId` = $stepId AND `deleted_at` IS NULL")->queryOne(); 
                
//            }catch(AwsException $e){
//
//            }
            
            return json_encode(["imageid" => $imageid,"totalImage" => $getStepDataCount['total']]);
        }
        public function actionGethyperiseimage() {
//            echo "XCvxcvxcvcxvx";exit;
            $userid = Yii::$app->session->get('userid');            
            $getHyperiseIntegration = Yii::$app->db->createCommand("SELECT id,api_key from `hyperise_integration` where userId=$userid")->queryOne();
            $html = "";
            if(!empty($getHyperiseIntegration)){
                $api_key = $getHyperiseIntegration['api_key'];
                    if(!empty($api_key)){
                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                        CURLOPT_URL => "https://app.hyperise.io/api/v1/regular/image-templates?api_token=$api_key",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'GET',
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);
                    $result = json_decode($response, true);
                    if (json_last_error() === JSON_ERROR_NONE) {
                        $i = 0;
                        if(!empty($result)){
                            foreach ($result as $data) {
                                $url = $data['base_url']. $data['image_url'];
                                $html .= '<div class="image_box" title="'.$data['name'].'">
                                            <input type="checkbox" id="hyprise_img'.$i.'" name="hyprise_check" value="'.$url.'"  />
                                            <label for="hyprise_img'.$i.'"><img src="'.$url.'" class="gallery_img" /></label>
                                            <div class="hyprise_edit">
                                            <p>'.$data['name'].'</p>
                                                <button  data-toggle="modal" data-target="#hyprise_edit" class="openFieldPopup" data-url="'.$url.'" type="button" disabled>
                                                 Add Field
                                                </button>
                                            </div>
                                        </div>';
                                $i++;

                            }
                        } else {
                            $html .= "<p>No Images to load.</p>";
                        }
                    } else {
                        $html .= "<p>Error while getting images please check your api-key.</p>";
                    }
                } else {
                        $html .= "<p>Please connect Hyperise api-key from integration.</p>";                    
                }
            } else {
                $html .= "<p>Please connect Hyperise api-key from integration.</p>";                
            }
            return $html;

        }
        public function actionGetimagesforgallery() {
            $userid = Yii::$app->session->get('userid');            
            $getattachment = Yii::$app->db->createCommand("SELECT s3url,attachmentId from `attachment` where attachmentType=1 and userId = '".$userid."'")->queryAll();            
            if(!empty($getattachment)){
                return json_encode($getattachment);
            } else {
                return 0;    
            }
        }
        public function actionAddimagefromhyperise(){
            $stepid = $_POST['stepid'];            
            $urls = json_decode($_POST['urls'],true);
            $userid = Yii::$app->session->get('userid');            
            $newUrls = array_keys($urls);                        
            
            $getCurStepData = Yii::$app->db->createCommand("SELECT s3url FROM `attachment` WHERE attachmentType=2 and`stepId` = $stepid AND userId=$userid and `deleted_at` IS NULL")->queryAll(); 
            $dbUrlArr = array();
            
            foreach ($getCurStepData as $data) {
                array_push($dbUrlArr, $data['s3url']);
            }            
            $deleteResult = array_values(array_diff($dbUrlArr,$newUrls));
            
            if(!empty($urls)){
                foreach ($urls as $key => $value) {                
                    $fields = json_encode($value);
                    $getCurStepData = Yii::$app->db->createCommand("SELECT * FROM `attachment` WHERE `stepId` = $stepid AND userId=$userid AND s3url='".$key."' and `deleted_at` IS NULL")->queryOne(); 

                    if(empty($getCurStepData)){
                        $savesql = Yii::$app->db->createCommand("INSERT INTO attachment (stepId,userId,`attachmentType`,s3url,hyperise_field) VALUES ('".$stepid."','".Yii::$app->session->get('userid')."','2','".$key."','".$fields."')")->execute();                        
                    } else {                    
                        $savesql = Yii::$app->db->createCommand("UPDATE attachment set hyperise_field = '".$fields."' where stepId=$stepid AND `userId`=$userid AND s3url='".$key."'")->execute();
                    }
                }
                
                if(!empty($deleteResult)){
                    foreach ($deleteResult as $dUrl){                
                        $savesql = Yii::$app->db->createCommand("UPDATE attachment set deleted_at = '".date('Y-m-d h:i:s')."' where `stepId` = $stepid and userId=$userid and s3url='".$dUrl."'")->execute();                
                    }  
                }
                
            }
        } 
        public function actionAddimagefromgallery(){
            $stepid = $_POST['stepid'];
            $urls = explode(",", $_POST['urls']);
            for ($index = 0; $index < count($urls); $index++) {
                $imageS3Url  = $urls[$index];                
                $savesql = Yii::$app->db->createCommand("INSERT INTO attachment (stepId,userId,`attachmentType`,s3url) VALUES ('".$stepid."','".Yii::$app->session->get('userid')."','1','".$imageS3Url."')")->execute();
            }
        } 
	public function actionAddattachment() 
	{
            if (isset($_POST) && $_SERVER['REQUEST_METHOD'] == "POST") {
                
                $stepid = $_POST['stepid'];
                $credentials = new \Aws\Credentials\Credentials('AKIA2BIJALKAVZ7OR3IK', 'LHnhwkBth6yHymhRTk8aNdBtj2+Ra4Rslj1UPDhH');
                $bucket="seqenceattachment";
                for ($index = 0; $index < count($_FILES); $index++) {
                    $ext = pathinfo($_FILES[$index]['name'], PATHINFO_EXTENSION);
                    $file_name = time().'_'.Yii::$app->session->get('userid').".".$ext;                    
                    
                    $body = fopen($_FILES[$index]['tmp_name'], 'rb');
                    $s3Client = new S3Client([					
                            'region' => 'us-east-1',  
                            'version' => 'latest',
                            'credentials' => $credentials
                    ]);
                    try {
                    $result = $s3Client->putObject([
                            'Bucket' => $bucket,
                            'Key' => $file_name,
                            'Body'=>$body,
//                            'SourceFile'   => $file_name,
                            'ACL'          => 'public-read',
                            'ServerSideEncryption' => 'AES256',
                    ]);
//                    print_r($result);
                        $imageS3Url =  $result['ObjectURL'];                        
                        $savesql = Yii::$app->db->createCommand("INSERT INTO attachment (stepId,userId,`attachmentType`,s3url) VALUES ('".$stepid."','".Yii::$app->session->get('userid')."','1','".$imageS3Url."')")->execute();
                        sleep(1);
                    } catch (S3Exception $e) {
                        echo $e->getMessage() . PHP_EOL;
                    }

                }
            }
        }
	public function actionAddnewseqstep() // Add new step
	{
		 if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		
		$msg_subject = '';
		$sendEmptyinvite = 0;
		if(isset($_POST['sendEmptyinvite'])){
		$sendEmptyinvite = $_POST['sendEmptyinvite'];
		}
		$seqId = $_POST['seqId'];
		$order = $_POST['order'];
		
		if($_POST['type'] == 'Email'){
			
			$msg_subject = $_POST['email_msg_subject'];
		}
		else{
			
			$msg_subject = $_POST['msg_subject'];
			
		}
		
		$msg_subject = addslashes($msg_subject);
		
		
		
		if(isset($_POST['message'])){
		$message = $_POST['message'];
		$message = addslashes($message);
       // $message = htmlspecialchars($message);
		}
		
		
		$type = $_POST['type'];
		$webhooks = $_POST['webhooks'];
		$delayDays = $_POST['delayDays'];
		$delayMinutes = $_POST['delayMinutes'];
		$isAttachment = $_POST['isAttachment'];
		
		$getseqtype = Yii::$app->db->createCommand("SELECT msgSeq from `ext_sequences` where id = '".$seqId."'")->queryOne();
		$chkseqtype = $getseqtype['msgSeq'];
		
		if(isset($_POST['seq_step_updateid']) && $_POST['seq_step_updateid'] > 0){
		$seq_step_updateid = $_POST['seq_step_updateid'];
		
		$savesql = Yii::$app->db->createCommand("UPDATE ext_steps set 
		seqId = '".$seqId."',
		`order` = '".$order."',
		message = '".$message."',
		subject = '".$msg_subject."',
		type = '".$type."',
		webhooks = '".$webhooks."',
		isAttachment = '".$isAttachment."',
		emptyInvite = '".$sendEmptyinvite."' where id = '".$seq_step_updateid."'")->execute();
		$step_id = $seq_step_updateid; 
		} 
		else
		{
		$savesql = Yii::$app->db->createCommand("INSERT INTO ext_steps (seqId,`order`,message,type,webhooks,delayDays,delayMinutes,subject,emptyInvite,isAttachment) VALUES ('".$seqId."','".$order."','".$message."','".$type."','".$webhooks."','3','".$delayMinutes."','".$msg_subject."','".$sendEmptyinvite."','".$isAttachment."')")->execute();
	    $step_id = Yii::$app->db->getLastInsertID(); 
		}
		
		$getCurStepData = Yii::$app->db->createCommand("SELECT id,message,type,webhooks,delayDays,delayMinutes,`order`,subject,emptyInvite FROM ext_steps WHERE id ='".$step_id."'")->queryOne(); 
	    
		$stepHtml = '';
		 if($getCurStepData['order'] == 0 && $chkseqtype == 0){
		$stpIcon = '<i class="bx bx-link"></i>';
		}else{
		$stpIcon = '<i class="bx bxs-message"></i>';	
		}
		$countRound = $getCurStepData['order']+1;
		$stepHtml .='<div class="row"><div class="col-md-1 showingsteps"><div class="indicatorbox"><div class="badge-circle badge-circle-info mr-1 mb-1">'.$countRound.'</div></div><div class="indicatorbox">'.$stpIcon.'</div></div>';	
		
		 $stepHtml .='<div class="col-md-9 seqstep step_row_'.$getCurStepData['id'].' step_ord_'.$getCurStepData['order'].' step_typ_'.$getCurStepData['type'].'">';
		 
		   
			if($getCurStepData['order'] != 0){
				
			   $delaylbl = '';
			   if($chkseqtype==0 && $getCurStepData['order'] == 1){
				$delaylbl = "Once connect is accepted wait";
				}
				else
				{
				$delaylbl =  "If no response after";
				}
				
			$stepHtml .=$getCurStepData['order'].'ADD<div class="step_delay col-md-12">'.$delaylbl.' <input type="number" class="num days" min="0" value="3"> days and <input type="number" class="num minutes" min="0" value="0"> minutes</div>';
		    $stepHtml .='</div><div class="col-md-2"></div></div>';
			}
			$stepHtml .='<div class="step_header col-md-12">';
				$stepHtml .='<ul>';
				$stepHtml .='<li><span class="hidethiscntt">Step: '.$getCurStepData['order'].' - <span class="step_type_lab">'.$getCurStepData['type'].'</span></span></li>';
				$stepHtml .='<li class="step_action"><a href="javascript:void(0);" data-lable-id="'.$countRound.'" data-order-id="'.$getCurStepData['order'].'" data-setp-id="'.$getCurStepData['id'].'" class="editsteps"><i class="bx bxs-pencil"></i></a> <a href="javascript:void(0);" data-order-id="'.$getCurStepData['order'].'" data-setp-id="'.$getCurStepData['id'].'" class="delsteps"><i class="bx bx-trash-alt"></i></a></li>';
				$stepHtml .='</ul>';
			$stepHtml .='</div>';
			$stepHtml .='<div class="step_body col-md-12">';
				if($msg_subject != ''){
					$stepHtml .='<span><b>Subject: </b>'.$getCurStepData['subject'].'</span><br>';
				}
				$stepHtml .='<span>'.$getCurStepData['message'].'</span>';
				if($getCurStepData['type'] == 'Zapier'){
					$stepHtml .='<br><span><b>Webhook: </b>'.$getCurStepData['webhooks'].'</span>';
				}
			$stepHtml .='</div>';
			
		 
		 return $stepHtml;
		
		
	}
	
	public function actionDeleteseqstep() // Delete sequence step
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		$stepid = $_POST['stepid'];
		$curorderid = $_POST['curorderid'];
		$seqid = $_POST['seqid'];
		$seq_type = $_POST['seq_type'];
		
		//if(Yii::$app->session->get('userid') == 21196){
			$curorderid = Yii::$app->db->createCommand("SELECT `order` FROM ext_steps WHERE id ='".$stepid."'")->queryOne();
			$curorderid = $curorderid['order'];
			
			if($curorderid['order'] == 0 && $seq_type == 0){
				$savesql = Yii::$app->db->createCommand("UPDATE ext_steps set type = 'Connect' where seqId = '".$seqid."' AND `order` = '1'")->execute();
			}
			
		//}
		/*else
		{
		
			if($_POST['curorderid'] == 0 && $seq_type == 0){
				$savesql = Yii::$app->db->createCommand("UPDATE ext_steps set type = 'Connect' where seqId = '".$seqid."' AND `order` = '1'")->execute();
			}
		
		} */
		
		$savesql = Yii::$app->db->createCommand("DELETE From ext_steps where id = '".$stepid."'")->execute();
		
	}
	
	public function actionTotalsteps(){
		
		$seqId = $_POST['seqid'];
		$totalstepsq = Yii::$app->db->createCommand("SELECT COUNT(id) as totalSteps FROM ext_steps WHERE seqId ='".$seqId."'")->queryOne();
		$totalstepsr = 0;
		if(!empty($totalstepsq) && isset($totalstepsq['totalSteps'])){
		$totalstepsr = $totalstepsq['totalSteps'];
		}
		
		return $totalstepsr;
		
	}
	
	public function actionUpdatenewconnectstep() // Update new connect step
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		 
		$seq_id = $_POST['seq_id'];
 		$savesql = Yii::$app->db->createCommand("UPDATE ext_steps set type = 'Connect' where seqId = '".$seq_id."' AND `order` = '1'")->execute();
		
	}
	
	public function actionEditseqstep() // Edit sequence step
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
        $userid = Yii::$app->session->get('userid');
		
		$stepid = $_POST['stepid'];
		$getCurStepData = Yii::$app->db->createCommand("SELECT id,message,type,webhooks,delayDays,delayMinutes,`order`,subject,emptyInvite,isAttachment FROM ext_steps WHERE id ='".$stepid."'")->queryOne();
		
//                if($userid == 15042 || $userid == 16943 || $userid == 14907 || $userid == 14909 || $userid == 15100 || $userid == 14935 || $userid == 14942 || $userid ==  14932){                    
                    if($getCurStepData['isAttachment']){
                        $getAttachmentData = Yii::$app->db->createCommand("SELECT attachmentId,s3url,attachmentType,hyperise_field FROM attachment WHERE deleted_at IS NULL AND stepId ='".$stepid."'")->queryAll();                        
                        $getCurStepData['attachment'] = $getAttachmentData;
                    }
//                }
		$getCurStepData = json_encode($getCurStepData);
		
		return $getCurStepData;
		
		
	}
	
	public function actionGetcurrentseqlaststep() // Get last step of current sequence
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		$seqid = $_POST['seqid'];
		$getCurStepData = Yii::$app->db->createCommand("SELECT `order` FROM ext_steps WHERE seqId ='".$seqid."' ORDER BY `order` DESC")->queryOne();
		
		return $getCurStepData['order'];
	}
	public function actionUpdatestepdays() // update step days
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		$stepid = $_POST['stepid'];
		$dayval = $_POST['dayval'];
		
		
		$savesql = Yii::$app->db->createCommand("UPDATE ext_steps set 
		delayDays = '".$dayval."' where id = '".$stepid."'")->execute();
	}
	
	public function actionUpdatestepminutes() // Update steps delay time
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		$stepid = $_POST['stepid'];
		$minval = $_POST['minval'];
		
		$savesql = Yii::$app->db->createCommand("UPDATE ext_steps set 
		delayMinutes = '".$minval."' where id = '".$stepid."'")->execute();
	}
	
	public function actionGetseqlistofsteps() // Get list of steps by sequence
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		//echo '<pre>'; print_r($_POST); exit;
		$seqid = $_POST['seqid'];
		
		///echo "SELECT msgSeq from `ext_sequences` where id = '".$seqId."'"; exit; 
		
		$getseqtype = Yii::$app->db->createCommand("SELECT msgSeq,status from `ext_sequences` where id = '".$seqid."'")->queryOne();
		$chkseqtype = $getseqtype['msgSeq'];
		$seqStatus = $getseqtype['status'];
		
		$getallsteps = Yii::$app->db->createCommand("SELECT * FROM ext_steps WHERE seqId ='".$seqid."' order by `order` ASC")->queryAll();
		
		
		
		
		
		$count = 0;
		$stepHtml= '';
		foreach($getallsteps as $rows){
			//echo $rows['order'];
			$savesql = Yii::$app->db->createCommand("UPDATE ext_steps set `order` = '".$count."' where id = '".$rows['id']."'")->execute();
			
			
			if($rows['order'] == 0 && $chkseqtype == 0){
			$stpIcon = '<i class="bx bx-link"></i>';
			}else{
			$stpIcon = '<i class="bx bxs-message"></i>';	
		    }
			$countRound = $count+1;
			$stepHtml .='<div class="row"><div class="col-md-1 showingsteps"><div class="indicatorbox"><div class="badge-circle badge-circle-info mr-1 mb-1">'.$countRound.'</div></div><div class="indicatorbox">'.$stpIcon.'</div></div>';	
		
			$stepHtml .='<div class="col-md-9 seqstep step_row_'.$rows['id'].' step_ord_'.$rows['order'].' step_typ_'.$rows['type'].'">';
													if($rows['order'] != 0){
														
														 $delaylbl = '';
													    if($getseqtype['msgSeq'] == 0 && $countRound == 2){ 
														$delaylbl = "Once connect is accepted wait"; 
														}
														else
														{
														$delaylbl =  "If no response after";
														}
														
														if($countRound > 1){
														$stepHtml .= '<div class="step_delay col-md-12">'.$delaylbl.' <input type="number" onChange="updateDelayDays(this.value,'.$rows['id'].')" class="num days" min="0" value="'.$rows['delayDays'].'"> days and <input type="number" class="num minutes" onChange="updateDelayMinutes(this.value,'.$rows['id'].')" min="0" value="'.$rows['delayMinutes'].'"> minutes</div>';
														}
														
														}
														$stepHtml .='<div class="step_header col-md-12">';
															$stepHtml .='<ul>';
															$stepHtml .='<li><span class="hidethiscntt">Step: <span class="stepOrNum">'.$count.'</span> - </span><span class="step_type_lab">'.$rows['type'].'</span></li>';
															if($seqStatus == 'Not Started'){
															$stepHtml .='<li class="step_action"><a href="javascript:void(0);" data-lable-id="'.$countRound.'" data-order-id="'.$rows['order'].'" data-setp-id="'.$rows['id'].'" class="editsteps"><i class="bx bxs-pencil"></i></a> <a href="javascript:void(0);" data-order-id="'.$rows['order'].'" data-setp-id="'.$rows['id'].'" class="delsteps"><i class="bx bx-trash-alt"></i></a></li>';
															}else{ 
																$stepHtml .='<li class="step_action"><a href="javascript:void(0);" data-lable-id="'.$countRound.'"  data-order-id="'.$rows['order'].'" data-setp-id="'.$rows['id'].'" class="editsteps"><i class="bx bxs-pencil"></i></a></li>';
															}
															$stepHtml .='</ul>';
														$stepHtml .='</div>';
														$stepHtml .='<div class="step_body col-md-12">';
															if($rows['subject'] != ''){
																$stepHtml .='<span><b>Subject: </b>'.$rows['subject'].'</span><br><hr>';
															}
															$stepHtml .='<span>'.nl2br($rows['message']).'</span>';
															if($rows['type'] == 'Zapier'){
																$stepHtml .='<br><span><b>Webhook: </b>'.$rows['webhooks'].'</span>';
															}
														$stepHtml .='</div>';
													
														
													 $stepHtml .='</div><div class="col-md-2"></div></div>';
		
		$count++;
		}
		return $stepHtml;
	}
	

	
	public function actionChangeseqenrollperday() 	// Change enroll per day
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		$pepdl = $_POST['pepdl'];
		$seq_id = $_POST['seq_id'];
		$savesql = Yii::$app->db->createCommand("UPDATE ext_sequences set 
		enrollPerDay = '".$pepdl."' where id = '".$seq_id."'")->execute();
	}
	
	
	public function actionChangeseqmessageperday() // Change Message per day
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		$mprl = $_POST['mprl'];
		$seq_id = $_POST['seq_id'];
		$savesql = Yii::$app->db->createCommand("UPDATE ext_sequences set 
		enrollPerDay = '".$mprl."' where id = '".$seq_id."'")->execute();
	}
	
	
	
	public function actionDeletesequence() // Delete sequencelist
	{
			if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		$seq_id = $_POST['seq_id'];
		$user_id = Yii::$app->session->get('userid');
		$savesql = Yii::$app->db->createCommand("UPDATE ext_sequences set status = 'Deleted' where id = '".$seq_id."'")->execute();
		
		//if($user_id == '14878')
		//{
		if(Yii::$app->db->createCommand("UPDATE `ext_tasks` SET `status` = 'Skipped' WHERE userId = '".$user_id."' AND seqId = '".$seq_id."' AND status = 'Not Started'")->execute()){ 
					 
					Yii::$app->db->createCommand("INSERT INTO completed_tasks SELECT ext_tasks.*, NOW() FROM ext_tasks WHERE userId = '".$user_id."' AND seqId = '".$seq_id."' AND status = 'Skipped'")->execute();
					
					Yii::$app->db->createCommand("DELETE FROM ext_tasks WHERE userId = '".$user_id."' AND seqId = '".$seq_id."' AND status = 'Skipped'")->execute();
					//return true;
				}
				
				$textmsg = 'Sequence has been deleted.';
				// Add to log table
				Yii::$app->db->createCommand("INSERT INTO ext_log (text,seqId,userId,errorLog) VALUES ('".$textmsg."','".$seq_id."','".$user_id."','0')")->execute(); 
		//}
		/*$savesql = Yii::$app->db->createCommand("DELETE From sequences where local_db_id = '".$seq_id."'")->execute();*/
	}
	
	public function actionChangeseqliststatus() // Change sequence status
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		$user_id = Yii::$app->session->get('userid');
		$seqStatus = $_POST['seqStatus'];
		$seq_id = $_POST['seq_id'];  
		
		//if($user_id == '21196'){
			
			$getseqtype = Yii::$app->db->createCommand("SELECT msgSeq from `ext_sequences` where id = '".$seq_id."'")->queryOne();
			$chkseqtype = $getseqtype['msgSeq'];
			if($chkseqtype == 0){
				
				$stepdata = Yii::$app->db->createCommand("SELECT type FROM ext_steps WHERE type = 'Connect' AND seqId ='".$seq_id."'")->queryOne();
				
				if(empty($stepdata))
				{
					$getfirststep = Yii::$app->db->createCommand("SELECT id FROM ext_steps WHERE seqId = '".$seq_id."' order by id ASC LIMIT 1")->queryOne();
					if(!empty($getfirststep))
					{
						//echo "UPDATE ext_steps SET type = 'Connect' WHERE id = '".$getfirststep['id']."' AND seqId = '".$seq_id."'"; exit;
						Yii::$app->db->createCommand("UPDATE ext_steps SET type = 'Connect' WHERE id = '".$getfirststep['id']."' AND seqId = '".$seq_id."'")->execute();
					}
					//echo 'connect step not found'; exit;
				}
				
			}
		//}
		
		$savesql = Yii::$app->db->createCommand("UPDATE ext_sequences set status = '".$seqStatus."' where id = '".$seq_id."'")->execute();
		
		if($seqStatus == 'Stopped') // if sequence stopped delete task
		{
			
				if(Yii::$app->db->createCommand("UPDATE `ext_tasks` SET `status` = 'Skipped' WHERE userId = '".$user_id."' AND seqId = '".$seq_id."' AND status = 'Not Started'")->execute()){ 
					 
					Yii::$app->db->createCommand("INSERT INTO completed_tasks SELECT ext_tasks.*, NOW() FROM ext_tasks WHERE userId = '".$user_id."' AND seqId = '".$seq_id."' AND status = 'Skipped'")->execute();
					
					Yii::$app->db->createCommand("DELETE FROM ext_tasks WHERE userId = '".$user_id."' AND seqId = '".$seq_id."' AND status = 'Skipped'")->execute();
					//return true;
					
				}
				
				//if(Yii::$app->session->get('userid') == '14878'){
					
					Yii::$app->db->createCommand("UPDATE `ext_links` SET `status` = 'Not Started', pagesFetched = '0', fetchStarted = '', `start` = '0', voyagerLink = '', `total` = '0' WHERE userId = '".$user_id."' AND seqId = '".$seq_id."'")->execute();
				//}
				 
				$textmsg = 'Sequence has been stopped.'; 
				// Add to log table
				Yii::$app->db->createCommand("INSERT INTO ext_log (text,seqId,userId,errorLog) VALUES ('".$textmsg."','".$seq_id."','".$user_id."','0')")->execute();  
			
		}
		
		if($seqStatus == 'Paused') // if sequence paused , change status to Paused
		{
			
				//Yii::$app->db->createCommand("UPDATE `ext_tasks` SET `status` = 'Paused' WHERE userId = '".$user_id."' AND seqId = '".$seq_id."' AND status = 'Not Started'")->execute();
			
		}
		
		if($seqStatus == 'Active') // if sequence active , change status Paused to not started.
		{
			
				//Yii::$app->db->createCommand("UPDATE `ext_tasks` SET `status` = 'Not Started' WHERE userId = '".$user_id."' AND seqId = '".$seq_id."' AND status = 'Paused'")->execute();
			
		}
		
		
		
	}
	public function actionGetsequencefeeds() // view sequence feeds
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		$seq_id = $_POST['seq_id'];
		$getCurseqData = Yii::$app->db->createCommand("SELECT name,msgSeq,target_audience_type,SelectedcsvId,requestWithdrawDays,working_hour_id,zapireStatus,zaptouse,bypassweekly,isPostLike FROM ext_sequences WHERE id ='".$seq_id."'")->queryOne();
		
	  
		
		$working_hour_id = $getCurseqData['working_hour_id'];
		$requestWithdrawDays = $getCurseqData['requestWithdrawDays'];
		$getCurseqData['name'];
		if($getCurseqData['msgSeq'] == 0){
			$seqType = 'Invitation Sequence';
			$seqMsgTxt = 'Once connect is accepted wait';
		}else{
			$seqType = 'Messaging Sequence';
			$seqMsgTxt = 'If no response after';
		}
		$target_audience_type = 'None';
		if(isset($getCurseqData['target_audience_type'])){
			if($getCurseqData['target_audience_type'] == 1)
			{
					$target_audience_type = 'Linkedin URL';
			}else if($getCurseqData['target_audience_type'] == 2){
					$target_audience_type = 'CSV';
			}else{
					$target_audience_type = 'Webhook';
			}
		}
		
		$seqhtml = '';
		$seqhtml .= '<div class="row">';
			$seqhtml .= '<div class="col-md-12 p-l-r-0">';
				$seqhtml .= '<div style="padding-top: 10px;">
				<label class="customlabel" for="first_name">Sequence Name : </label>
				'.$getCurseqData['name'].'
				<div class="help-block"></div>
				</div>';
				
				$seqhtml .= '<div style="padding-top: 10px;">
				<label class="customlabel" for="seq_type">Sequence  Type : </label>
				'.$seqType.'
				<div class="help-block"></div>
				</div>';
			$seqhtml .= '</div>';
			$seqhtml .= '<div style="padding-top: 10px;">';
			$seqhtml .= '<div><label class="customlabel" for="target_adu">Target Audience : </label> '.$target_audience_type.'</div>';
			
			$gethoursData = Yii::$app->db->createCommand("SELECT name,start_time,end_time,days FROM  ext_working_hours WHERE id ='".$working_hour_id."'")->queryOne();
			
			$daysA = explode(',',$gethoursData['days']);
			$daysAV = array();
			foreach($daysA as $res){
				if($res==1){
					$daysAV[]='Monday';
				}elseif($res==2){
					$daysAV[]='Tuesday';
				}elseif($res==3){
					$daysAV[]='Wednesday';
				}elseif($res==4){
					$daysAV[]='Thursday';
				}elseif($res==5){
					$daysAV[]='Friday';
				}elseif($res==6){
					$daysAV[]='Saturday';
				}elseif($res==7){
					$daysAV[]='Sunday';
				}
			}
			$daysAV = implode(", ",$daysAV);
			
			$seqhtml .= '<div style="padding-top: 10px;"><label class="customlabel" for="target_adu">Working Hours: </label> '.$gethoursData['name'].': '.$daysAV.' - '.$gethoursData['start_time'].' to '.$gethoursData['end_time'].'</div>'; 
		
			if($getCurseqData['bypassweekly'] == 1){ 
				$seqhtml .= '<div style="padding-top: 10px;"><label class="customlabel" for="target_adu">Boosted invites: </label> On</div>';
			}  
			
			if($getCurseqData['isPostLike'] == 1)
			{
				$seqhtml .= '<div style="padding-top: 10px;"><label class="customlabel" for="target_adu">Auto Like Recent post before: </label> Yes</div>';
			}
			
			//if(Yii::$app->session->get('useremail') == 'dhaval.thakor@intricare.net'){
				if($getCurseqData['zapireStatus'] == 'true' ){ 
					$zapErr = json_decode($getCurseqData['zaptouse']);
					$zapEvent = '';
					$zapEventstr = '';
					foreach($zapErr as $key=>$value)
					{
						$zapEvent .= $value.',';
					}
					$zapEventstr = rtrim($zapEvent,',');
					$seqhtml .= '<div style="padding-top: 10px;"><label class="customlabel" for="target_adu">Zapier:</label>&nbsp;'.$zapEventstr.'</div>';
				}
			//}
			
			
			$getalllinks = Yii::$app->db->createCommand("SELECT link,postFlag FROM ext_links WHERE seqId ='".$seq_id."' order by id ASC")->queryAll();
			
			foreach($getalllinks as $rows)
			{
				$posturlaudtype = '';
				if($rows['postFlag'] == '1')
				{
					$posturlaudtype = ' - Send Invitation to Likes';
					
				}else if($rows['postFlag'] == '2'){
					
					$posturlaudtype = ' - Send Invitation to Comments';
					
				}else{
					
					$posturlaudtype = '';
				}
				
				if($getCurseqData['target_audience_type'] == 1){
					$seqhtml.= '<div class="targetAdu"><a href="'.$rows['link'].'" target="_blank">'.$rows['link'].'</a>'.$posturlaudtype.'</div>';
				}
				else if($getCurseqData['target_audience_type'] == 2)
				{
				
					$getCurCsvData = Yii::$app->db->createCommand("SELECT file_name FROM csvfiles WHERE id ='".$getCurseqData['SelectedcsvId']."'")->queryOne();
					$seqhtml .= $getCurCsvData['file_name'];	
				}
				else
				{
					$getwebhookData = Yii::$app->db->createCommand("SELECT w_url,w_type FROM webhooks WHERE w_seq_id ='".$seq_id."'")->queryOne();
					if($getwebhookData['w_type'] == 1){
						
					$getgsheetData = Yii::$app->db->createCommand("SELECT spreadsheetId,sheetName FROM spreadsheet_info WHERE seqid ='".$seq_id."'")->queryOne();
					
					$seqhtml .= '<div style="padding-top: 10px;"><label class="customlabel" for="target_adu">Google Sheet URL : </label><img src="https://d3j2mp6mc1f39j.cloudfront.net/sheetIcon.png" style="height:30px;"><a href="https://docs.google.com/spreadsheets/d/'.$getgsheetData['spreadsheetId'].'" target="_blank">'.$getgsheetData['sheetName'].'</a></div>';
					}
					//$seqhtml .= 'Using Webhook'; 	
				}
			}
			
			
			$sequenceType = $getCurseqData['msgSeq'];
			$seqhtml .= '</div>';
			$seqhtml .= '<div class="col-md-12 p-l-r-0" style="padding-top: 10px;">';
				$seqhtml .= '<label class="customlabel" for="first_name">Messages</label>';
				$getallsteps = Yii::$app->db->createCommand("SELECT * FROM ext_steps WHERE seqId ='".$seq_id."' order by `order` ASC")->queryAll();
				$count = 1;
				foreach($getallsteps as $rows){
					
					if($sequenceType == 0 && $count == 2){
						$seqMsgTxt = 'Once connect is accepted wait';
					}else if($sequenceType == 1 && $count == 2){
						$seqMsgTxt = 'If no response after';
					}else if($count == 1){
						$seqMsgTxt = '';
					}else{
						$seqMsgTxt = 'If no response after';
					}
					
					
				
					$seqhtml .='<div class="row"><div class="col-md-1 showingsteps"><div class="indicatorbox intPop"><div class="badge-circle badge-circle-info mr-1 mb-1">'.$count.'</div></div><div class="indicatorbox chtIcon intPop"></div></div><div class="col-md-10 seqstep step_row_'.$rows['id'].' step_ord_'.$rows['order'].' step_typ_'.$rows['type'].'">';
					if($rows['type'] != 'Connect'){
							if($rows['order'] != 0){
							$seqhtml .='<div class="step_delay col-md-12">'.$seqMsgTxt.' <span class="numBlk">'.$rows['delayDays'].'</span> days and <span class="numBlk">'.$rows['delayMinutes'].'</span> minutes</div>';
							}
						}
						
					$seqhtml .='<div class="step_header col-md-12">';
						$seqhtml .='<ul>';
                                                $attachHtml = "";
                                                if($rows['isAttachment']){
                                                    $attachHtml = '<span class="step_type_lab" style="font-size: 10px;"> | <i class="bx bx-paperclip" style="position: absolute;margin-top: 10px;"></i> <span style="margin-left: 20px;">Attachment</span></span>';
                                                }
						$seqhtml .='<li><span class="step_type_lab">'.$rows['type'].'</span>'.$attachHtml.'</li>';
						$seqhtml .='</ul>';
					$seqhtml .='</div>';
					$seqhtml .='<div class="step_body col-md-11">';
						
						if($rows['subject'] != ''){
							$seqhtml .='<br><span><b>Subject: </b>'.$rows['subject'].'</span><br><hr>';
						}
						
						$seqhtml .='<span>'.nl2br($rows['message']).'</span>';
						
						
						if($rows['type'] == 'Zapier'){
							$seqhtml .='<br><span><b>Webhook: </b>'.$rows['webhooks'].'</span>';
						}
					$seqhtml .='</div></div>';
					
					
				 $seqhtml .='</div>';
				
				$count++;
				} 
			$seqhtml .= '</div>';
			if($getCurseqData['msgSeq'] == 0){
			$seqhtml .= '<div class="col-md-12 p-l-r-0" style="padding-top: 10px;">';
			$seqhtml .= '<p>Withdraw request if not Accepted In (days): <strong>'.$requestWithdrawDays.'</strong></p>';
			$seqhtml .= '</div>';
			}
			
		$seqhtml .= '</div>';
		
		
		echo $seqhtml; 
		
	}
	
	
	public function actionGettotalinvitationsentbysequence() // get total Invitation sent by sequence id
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		$seqConnectsend = '';
		$user_id = Yii::$app->session->get('userid');
		
		$getallseqids = Yii::$app->db->createCommand("SELECT id,msgSeq FROM ext_sequences WHERE user_id ='".$user_id."' AND (status = 'Active' OR status = 'Complete' OR status = 'Paused' OR status = 'Error')  order by id ASC")->queryAll();
		
		foreach($getallseqids as $key=>$value)
		{ 
			$seqId = $value['id']; 
			$seqType = $value['msgSeq'];
			if($seqType == 0)
			{
			$getalltasks2nddegrees = Yii::$app->db->createCommand("SELECT id FROM completed_tasks WHERE userId ='".$user_id."' AND seqId = '".$seqId."' AND status = 'Complete' AND step = 0 AND type = 'Connect' order by id ASC")->queryAll();  
			}
			else{
			$getalltasks2nddegrees = Yii::$app->db->createCommand("SELECT id FROM completed_tasks WHERE userId ='".$user_id."' AND seqId = '".$seqId."' AND status = 'Complete' AND step = 0 AND type = 'Message' order by id ASC")->queryAll();	
			} 
			
			$sqlaccept = "SELECT  id from blacklist  where is_accepted = 1 AND seq_id=" .$seqId;
            $countaccept = Yii::$app->db->createCommand($sqlaccept)->queryAll();
		
		    $sqlresponse = "SELECT  id from blacklist  where is_response = 1 AND seq_id=" .$seqId;
            $countresponse = Yii::$app->db->createCommand($sqlresponse)->queryAll(); 
		
		//echo count($countaccept).'|'.count($countresponse);
			
			$seqConnectsend .= $seqId.':'.count($getalltasks2nddegrees).':'.count($countaccept).':'.count($countresponse).',';  
			
			
		}
		return rtrim($seqConnectsend,',');
		exit;
		
	}
	
	public function actionGettotalinvitationandmessagesentperday() // get total message sent by per day 
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		  
		$user_id = Yii::$app->session->get('userid');
		// connect count per day
		$getallconcount = Yii::$app->db->createCommand("Select seqId,timestamp from completed_tasks where userId = '".$user_id."' AND status = 'Complete' AND  type = 'Connect' AND step = '0' AND completedOn >= now() - INTERVAL 1 DAY")->queryAll();
		$getcntcon = count($getallconcount);  
		
		
		// Msg count per day
		$getallconcount2 = Yii::$app->db->createCommand("Select seqId,timestamp from completed_tasks where userId = '".$user_id."' AND status = 'Complete' AND type = 'Message' AND step = '0' AND completedOn >= now() - INTERVAL 1 DAY")->queryAll();
		$getcntmsg = count($getallconcount2); 
		
		return $getcntcon.':'.$getcntmsg; 
		
	}
	
	public function actionMessageinvitationsequencedata(){
		
		
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		$seqArray = '';
		
		// Second degree
		$seqConnectsend = '';
		$user_id = Yii::$app->session->get('userid');
		
		$getallseqids = Yii::$app->db->createCommand("SELECT id,msgSeq FROM ext_sequences WHERE user_id ='".$user_id."' AND (status = 'Active' OR status = 'Complete' OR status = 'Paused' OR status = 'Error' OR status = 'Stopped')  order by id ASC")->queryAll();
		
		foreach($getallseqids as $key=>$value)
		{ 
			$seqId = $value['id']; 
			$seqType = $value['msgSeq'];
			if($seqType == 0)
			{
			$getalltasks2nddegrees = Yii::$app->db->createCommand("SELECT id FROM completed_tasks WHERE userId ='".$user_id."' AND seqId = '".$seqId."' AND status = 'Complete' AND step = 0 AND type = 'Connect' order by id ASC")->queryAll();  
			}
			else{
			$getalltasks2nddegrees = Yii::$app->db->createCommand("SELECT id FROM completed_tasks WHERE userId ='".$user_id."' AND seqId = '".$seqId."' AND status = 'Complete' AND step = 0 AND type = 'Message' order by id ASC")->queryAll();	
			} 
			
			$sqlaccept = "SELECT  id from blacklist  where is_accepted = 1 AND seq_id=" .$seqId;
            $countaccept = Yii::$app->db->createCommand($sqlaccept)->queryAll();
		
		    $sqlresponse = "SELECT  id from blacklist  where is_response = 1 AND seq_id=" .$seqId;
            $countresponse = Yii::$app->db->createCommand($sqlresponse)->queryAll(); 
		
		//echo count($countaccept).'|'.count($countresponse);
			
			$percentacc = ':';
			$percentres = ':';
			
			//if($user_id == '16839'){
			
				if(count($getalltasks2nddegrees) > 0){
					$percentacc = count($countaccept) * 100 / count($getalltasks2nddegrees);	
					$percentacc = ':'.ceil($percentacc).'%';	
					
					if(count($countaccept) > 0){
					$percentres = count($countresponse) * 100 / count($countaccept);
					$percentres = ':'.ceil($percentres).'%';
					} else{
					$percentres = ':0%';	
					}
				}
			
				$seqConnectsend .= $seqId.':'.count($getalltasks2nddegrees).':'.count($countaccept).$percentacc.':'.count($countresponse).$percentres.',';  
				
			//}else{
				
			//$seqConnectsend .= $seqId.':'.count($getalltasks2nddegrees).':'.count($countaccept).':'.count($countresponse).',';  
			
			//}
			
			
		}
		$seqArray .= rtrim($seqConnectsend,',').'|';
		
		
		// st Degree
		
		// connect count per day
		$getallconcount = Yii::$app->db->createCommand("Select seqId,timestamp from completed_tasks where userId = '".$user_id."' AND status = 'Complete' AND  type = 'Connect' AND step = '0' AND completedOn >= now() - INTERVAL 1 DAY")->queryAll();
		$getcntcon = count($getallconcount);  
		
		
		// Msg count per day
		$getallconcount2 = Yii::$app->db->createCommand("Select seqId,timestamp from completed_tasks where userId = '".$user_id."' AND status = 'Complete' AND type = 'Message' AND step = '0' AND completedOn >= now() - INTERVAL 1 DAY")->queryAll();
		$getcntmsg = count($getallconcount2); 
		
		$seqArray .= $getcntcon.':'.$getcntmsg; 
		
		echo $seqArray;

		exit;
		
	}
	
//	public function actionViewcurrentactivitylog() // Get current activity logs
//	{
//		
//		if(!Yii::$app->session->get('useremail')){
//            $url = \Yii::$app->request->baseUrl."/login"; 
//            return $this->redirect($url);
//        }
//		
//		$user_id = Yii::$app->session->get('userid');
//		$seqId = $_POST['seqid'];
//		$getlogtable = Yii::$app->db->createCommand("Select`text`,`timestamp` from ext_log where errorLog = 0 AND userId = '".$user_id."' AND seqId = '".$seqId."' order by id DESC")->queryAll();
//		
//		$user_timezone = '';
//		$getTimezone = Yii::$app->db->createCommand("SELECT TimeZone FROM user where id =  ".Yii::$app->session->get('userid'))->queryOne();
//		$user_timezone = $getTimezone['TimeZone'];
//		
//		
//
//
//		$loghtml = '<table style="width:100%; border-collapse: separate;border-spacing: 0 0.7em;">'; 
//		foreach($getlogtable as $key=>$value){
//			
//		/*$date = $value['timestamp'];
//		$timestamp1 = strtotime($date);
//		$dbtime = date('Y-m-d H:i:s',$timestamp1);
//		$ist_date = \DateTime::createFromFormat('H:i:s', $dbtime,new \DateTimeZone($user_timezone));
//		$gmt_date = clone $ist_date; 
//		$gmt_date->setTimeZone(new \DateTimeZone('UTC'));
//		$server_start_time = $gmt_date->format('H:i:s'); */
//		
//		$respond = strtotime($value['timestamp']);
//		$ist_date = \DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d H:i:s', $respond), new \DateTimeZone('UTC'));
//		$gmt_date = clone $ist_date;
//        $gmt_date->setTimeZone(new \DateTimeZone($user_timezone));
//        $server_start_time = $gmt_date->format('d M Y h:i A');
//		$loghtml .='<tr><td>'.$server_start_time.'  :   '.$value['text'].'</td></tr>';
//		}
//		$loghtml .= '</table>';
//		
//		
//		return $loghtml;
//	}
	
        
         public function actionViewcurrentactivitylog() { // Get current activity logs
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        
        $LimitStart = Yii::$app->request->post('LimitStart');
        $LimitEnd = Yii::$app->request->post('LimitEnd');
        if(!isset($LimitStart) && !isset($LimitStart)){
            $LimitStart = 0;
            $LimitEnd = 50;
        } else {
            $LimitStart = Yii::$app->request->post('LimitStart');
            $LimitEnd = Yii::$app->request->post('LimitEnd');
        }

        $user_id = Yii::$app->session->get('userid');
        $seqId = $_POST['seqid'];        
//        $getlogtable = Yii::$app->db->createCommand("Select`text`,`timestamp` from ext_log where errorLog = 0 AND userId = '" . $user_id . "' AND seqId = '" . $seqId . "' order by id DESC")->queryAll();
        $getlogtable = Yii::$app->db->createCommand("Select`text`,`timestamp` from ext_log where errorLog = 0 AND userId = '" . $user_id . "' AND seqId = '" . $seqId . "' order by id DESC LIMIT $LimitStart, $LimitEnd")->queryAll();
//        $getlogCnt = Yii::$app->db->createCommand("Select`text`,`timestamp` from ext_log where errorLog = 0 AND userId = '" . $user_id . "' AND seqId = '" . $seqId . "' order by id DESC")->queryAll();
        $getlogCnt = Yii::$app->db->createCommand("Select count(id) as total from ext_log where errorLog = 0 AND userId = '" . $user_id . "' AND seqId = '" . $seqId . "' order by id DESC")->queryOne();
        $totalRec = $getlogCnt['total'];
        $user_timezone = '';
        $getTimezone = Yii::$app->db->createCommand("SELECT TimeZone FROM user where id =  " . Yii::$app->session->get('userid'))->queryOne();
        $user_timezone = $getTimezone['TimeZone'];
		
		
		$getseqDetails = Yii::$app->db->createCommand("SELECT lnk.seqId,lnk.status as linkstatus,lnk.link,lnk.pagesFetched,lnk.total,seq.name,seq.webhookVal,seq.status as seqstatus,seq.msgSeq,seq.isDirectMsg FROM ext_links as lnk, ext_sequences as seq where seq.user_id=lnk.userId and seq.id=lnk.seqId and seq.id=" .$seqId. " and  seq.user_id =  " . Yii::$app->session->get('userid'))->queryOne();
		
		$seqData=array();
		$seqData['seqId']=$getseqDetails['seqId'];
		$seqData['linkstatus']=$getseqDetails['linkstatus'];
		$seqData['link']=$getseqDetails['link'];
		$seqData['pagesFetched']=$getseqDetails['pagesFetched'];
		$seqData['total']=$getseqDetails['total'];
		$seqData['name']=$getseqDetails['name'];
		$seqData['seqstatus']=$getseqDetails['seqstatus'];
		$seqData['msgSeq']=$getseqDetails['msgSeq'];
		$seqData['isDirectMsg']=$getseqDetails['isDirectMsg'];
		
		$pagecount=0;
		$isUrlseq = 1;
		/* if(isset($getseqDetails['link']) && !empty($getseqDetails['link'])){
			
			if($getseqDetails['link'] != 'https://www.dummyorgin.dummy' || strpos($getseqDetails['link'],'www.linkedin.com/post/')==false){
				if(strpos($getseqDetails['link'],'www.linkedin.com/sales/') ){
					
				}else{
					
				}
			}else{
			
				$isUrlseq = 0;
			
			}
		} */
		$urlseqhtml ='';
		$pagination="";
		if(strpos($getseqDetails['link'], "www.linkedin.com/posts") !== false) {
				//$pagination="post";
			$urlseqhtml = '<br><span style="font-size: 13px;"><strong>Total People Found: </strong> '.$getseqDetails['total'].'</span> | ';
		}else if (strpos($getseqDetails['link'], "linkedin.com/sales/search") !== false) {
			//$pagination="sales link";
			$pagecount=ceil($getseqDetails['total']/25);
			if($getseqDetails['total'] <= 25){
				$pagecount=1;
			}
			$pagination='<span style="font-size: 13px;"> Current page '.$getseqDetails['pagesFetched'].' of '.$pagecount.'</span>';
			$urlseqhtml = '<br><span style="font-size: 13px;"><strong>Total People Found: </strong> '.$getseqDetails['total'].'</span> | ';
		} else if ($getseqDetails['webhookVal'] == '1') {
			$pagination="webhook";
		} else if ($getseqDetails['link'] == "https://www.dummyorgin.dummy" && $getseqDetails['webhookVal'] != '1') {
			//$pagination="csv";
			
			$totalcsvprofile = Yii::$app->db->createCommand("select COUNT(cp.id) as total_profile from csvfiles c LEFT JOIN ext_sequences s ON s.id = c.db_seq_id LEFT JOIN csvprofiles cp ON cp.csvfile_id = c.id where s.id=".$seqId." and  c.user_id =" . Yii::$app->session->get('userid') . " group by c.id")->queryOne();
       
            $remainingcsvprofile = Yii::$app->db->createCommand("select COUNT(cp.id) as total_rem from csvfiles c LEFT JOIN ext_sequences s ON s.id = c.db_seq_id LEFT JOIN csvprofiles cp ON cp.csvfile_id = c.id where  s.id=".$seqId." and cp.isDeleted=0 and c.user_id =" . Yii::$app->session->get('userid') . " group by c.id")->queryOne();
			
			$pagination='<span style="font-size: 13px;"> <br>Total remaining '.$remainingcsvprofile['total_rem'].' out of '.$totalcsvprofile['total_profile'].'</span>';
			
		}else{
			$pagecount=ceil($getseqDetails['total']/10);
			if($getseqDetails['total'] <= 10){
				$pagecount=1;
			}
			$pagination='<span style="font-size: 13px;"> Current page '.$getseqDetails['pagesFetched'].' of '.$pagecount.'</span>';
			$urlseqhtml = '<br><span style="font-size: 13px;"><strong>Total People Found: </strong> '.$getseqDetails['total'].'</span> | ';
		}			
		
		$seqType="Connect";
		if(!empty($getseqDetails['isDirectMsg'])){
			$seqType="Free In-mail";
		}elseif(!empty($getseqDetails['msgSeq']) && $getseqDetails['msgSeq']==1 ){
			$seqType="Message";
		}
		/* $pagination='';
		if(!empty($pagecount)){
			$pagination='<span style="font-size: 13px;"> Current page '.$getseqDetails['pagesFetched'].' of '.$pagecount.'</span>';
		} else if ($getseqDetails['webhookVal'] == '1') {
			$pagination='<span style="font-size: 13px;"> Current page '.$getseqDetails['pagesFetched'].' of '.$pagecount.'</span>';
		} else if ($getseqDetails['link'] == "https://www.dummyorgin.dummy" && $getseqDetails['webhookVal'] != '1') {
			$totalcsvprofile = Yii::$app->db->createCommand("select COUNT(cp.id) as total_rem from csvfiles c LEFT JOIN ext_sequences s ON s.id = c.db_seq_id LEFT JOIN csvprofiles cp ON cp.csvfile_id = c.id where c.user_id =" . Yii::$app->session->get('userid') . " group by c.id")->queryOne();
       
            $remainingcsvprofile = Yii::$app->db->createCommand("select COUNT(cp.id) as total_rem from csvfiles c LEFT JOIN ext_sequences s ON s.id = c.db_seq_id LEFT JOIN csvprofiles cp ON cp.csvfile_id = c.id where cp.isDeleted=0 and c.user_id =" . Yii::$app->session->get('userid') . " group by c.id")->queryOne();
			
			$pagination='<span style="font-size: 13px;"> Total remaining  '.$remainingcsvprofile.' of '.$totalcsvprofile.'</span>';
		} */
		
		/* $urlseqhtml = '';
		if($isUrlseq == 1) { // csv,webhook seq chk
			
			$urlseqhtml = '<br><span style="font-size: 13px;"><strong>Total People Found: </strong> '.$getseqDetails['total'].'</span> | '.$pagination;
		} */
		
		$seqName = $getseqDetails['name'];
		if(strlen($getseqDetails['name']) > 30)
		{
			$seqName = substr($getseqDetails['name'],0,30).'...';
		}
		
		$sequencesData='<span style="font-size: 13px;"><strong>Sequence Name: </strong><span title="'.$getseqDetails['name'].'">'.$seqName.'</span>&nbsp;<span style="font-size: 10px !important;color: #ffffff;background: #333333;padding: 2px;border-radius: 2px;">'.$getseqDetails['seqstatus'].'</span></span><br><span style="font-size: 13px;"><strong>Sequence Type: </strong>'.$seqType.'</span>'.$urlseqhtml.$pagination;
		
		
    

		
        $loghtml = '';
        foreach ($getlogtable as $key => $value) {

            /* $date = $value['timestamp'];
              $timestamp1 = strtotime($date);
              $dbtime = date('Y-m-d H:i:s',$timestamp1);
              $ist_date = \DateTime::createFromFormat('H:i:s', $dbtime,new \DateTimeZone($user_timezone));
              $gmt_date = clone $ist_date;
              $gmt_date->setTimeZone(new \DateTimeZone('UTC'));
              $server_start_time = $gmt_date->format('H:i:s'); */

            $respond = strtotime($value['timestamp']);
            $ist_date = \DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d H:i:s', $respond), new \DateTimeZone('UTC'));
            $gmt_date = clone $ist_date;
            $gmt_date->setTimeZone(new \DateTimeZone($user_timezone));
            $server_start_time = $gmt_date->format('d M Y h:i A');
            $loghtml .= '<tr><td>' . $server_start_time . ': ' . $value['text'] . '</td></tr>';
        }
		
		$pattern = '/(<span[^>]*\btitle=")(.*?)(">)/is';
		$callback = function ($matches) {
			// Extract the full match and the title text
			$start = $matches[1];
			$title = $matches[2];
			$end = $matches[3];
			$newTitle = str_replace('"', "'", $title);
			return $start . $newTitle . $end;
		};
		$loghtml = preg_replace_callback($pattern, $callback, $loghtml);
		
        $response = array('loghtml' => $loghtml, 'totalRec' => $totalRec,'sequenceData' =>$sequencesData);
        echo json_encode($response);
//        return $loghtml;
    }
	public function actionSeqgetworkinghours() // Get working hours
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		$sqldata = "SELECT  * from ext_working_hours  where user_id=" . Yii::$app->session->get('userid') . " order by id DESC ";
        $dataarry = Yii::$app->db->createCommand($sqldata)->queryAll();
		$seq_id = '';
		$seqwhid = '';
		if(isset($_POST['seq_id']) && $_POST['seq_id'] != ''){
		$seq_id = $_POST['seq_id'];
		$getseqwh = Yii::$app->db->createCommand("SELECT working_hour_id FROM ext_sequences WHERE id ='".$seq_id."'")->queryOne();
		$seqwhid = $getseqwh['working_hour_id'];
		}
		
		$whhtml = '';
		
		if(count($dataarry) > 0){
		foreach($dataarry as $key=>$whrw ){
		if($seqwhid == $whrw['id']){ $chked = 'checked'; }else{ $chked = ''; } 
		
			//nr starts
			$daysA = explode(',',$whrw['days']);
			$daysAV = array();
			foreach($daysA as $res){
				if($res==1){
					$daysAV[]='Monday';
				}elseif($res==2){
					$daysAV[]='Tuesday';
				}elseif($res==3){
					$daysAV[]='Wednesday';
				}elseif($res==4){
					$daysAV[]='Thursday';
				}elseif($res==5){
					$daysAV[]='Friday';
				}elseif($res==6){
					$daysAV[]='Saturday';
				}elseif($res==7){
					$daysAV[]='Sunday';
				}
			}
			$daysAV = implode(", ",$daysAV);
			//nr ends		
									
		$whhtml .='<li class="d-inline-block mr-2 mb-1" style="width:100%">
                                                <fieldset>
                                                    <div class="radio radio-primary radio-glow">
                                                        <input type="radio" id="radioGlow'.$whrw['id'].'" name="radioGlow" class="radioGlowCls" value="'.$whrw['id'].'" '.$chked.' >
                                                        <label for="radioGlow'.$whrw['id'].'">'.$whrw['name'].'&nbsp;&nbsp;<b>'.$daysAV.' - '.$whrw['start_time'].' to '.$whrw['end_time'].'</b></label>
                                                    </div>
                                                </fieldset>
												</li>';
		
		
		}
		}else{
			$whhtml = '<li class="d-inline-block mr-2 mb-1" style="width:100%"><p class="warning">Please add working hours to start.</p></li>';
		}
		return $whhtml;
	}
	
	public function actionGetratedatabyseqid() // Get count total accepted and response
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		$seq_id = $_POST['seq_id'];
		
		$sqlaccept = "SELECT  id from blacklist  where is_accepted = 1 AND seq_id=" .$seq_id;
        $countaccept = Yii::$app->db->createCommand($sqlaccept)->queryAll();
		
		$sqlresponse = "SELECT  id from blacklist  where is_response = 1 AND seq_id=" .$seq_id;
        $countresponse = Yii::$app->db->createCommand($sqlaccept)->queryAll();
		
		echo count($countaccept).'|'.count($countresponse);
		
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	public function actionSequencematrix() // Get matrix data count on sequece list page
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		 
		$tottask = 0;
		$totrequestsent = 0;
		$totaccepted = 0;
		$totreponses = 0; 
		$totwithdrown = 0;
		// Total task
		$sqltottask = "SELECT COUNT(id) as tottasksone FROM completed_tasks where completedOn >= ( CURDATE() - INTERVAL 14 DAY ) AND status = 'Complete' AND userId = ".Yii::$app->session->get('userid');
        $rowstottask = Yii::$app->db->createCommand($sqltottask)->queryAll();
		//$tottask1 = count($rowstottask);
		$tottask1 = $rowstottask[0]['tottasksone'];
		
		$sqltottask2 = "SELECT COUNT(id) as tottaskstwo FROM completed_tasks where completedOn >= ( CURDATE() - INTERVAL 7 DAY ) AND status = 'Complete' AND userId = ".Yii::$app->session->get('userid');
        $rowstottask2 = Yii::$app->db->createCommand($sqltottask2)->queryAll();
		//$tottask2 = count($rowstottask2);
		$tottask2 = $rowstottask2[0]['tottaskstwo'];
		
		$percentChange = $tottask1 - $tottask2;
		$percentChange = $tottask2 - $percentChange;									  
				
		if($percentChange >= 0){
			$ptype = 1 ;
		}
		else{
			$ptype = 0;
		}
		
		
		/*if ( $tottask1 > 0 ) {
		   $percentChange = round($tottask2 / ($tottask1 / 100),2);
		  } else {
			$percentChange = 0;
			}  */
		
		$tottask = $tottask2.':'.$percentChange.':'.$ptype;
		
		// End Total task
		
		// Request sent
		$sqltotreqs = "SELECT id FROM completed_tasks where completedOn >= ( CURDATE() - INTERVAL 14 DAY ) AND status = 'Complete' AND type = 'Connect' AND userId = ".Yii::$app->session->get('userid');
        $rowstotreqs = Yii::$app->db->createCommand($sqltotreqs)->queryAll();
		$totrequestsent1 = count($rowstotreqs);
		
		$sqltotreqs2 = "SELECT id FROM completed_tasks where completedOn >= ( CURDATE() - INTERVAL 7 DAY ) AND status = 'Complete' AND type = 'Connect' AND userId = ".Yii::$app->session->get('userid');
        $rowstotreqs2 = Yii::$app->db->createCommand($sqltotreqs2)->queryAll();
		$totrequestsent2 = count($rowstotreqs2);
		
		$percentChange2 = $totrequestsent1 - $totrequestsent2;
		$percentChange2 = $totrequestsent2 - $percentChange2;
		if($percentChange2 >= 0){
			$ptype2 = 1 ;
		}
		else{
			$ptype2 = 0;
		}
		
		/*
		if ( $totrequestsent1 > 0 ) {
		   $percentChange2 = round($totrequestsent2 / ($totrequestsent1 / 100),2);
		  } else {
			$percentChange2 = 0;
			} */
		
		$totrequestsent = $totrequestsent2.":".$percentChange2.":".$ptype2;
		// End
		
		
		// Accepted 
		
		$sqltotaccepted = "SELECT id FROM blacklist where accepted_at >= ( CURDATE() - INTERVAL 14 DAY ) AND is_accepted = '1' AND userId = ".Yii::$app->session->get('userid');
        $rowstotaccepted = Yii::$app->db->createCommand($sqltotaccepted)->queryAll();
		$totaccepted1 = count($rowstotaccepted);
		
		$sqltotaccepted2 = "SELECT id FROM blacklist where accepted_at >= ( CURDATE() - INTERVAL 7 DAY ) AND is_accepted = '1' AND userId = ".Yii::$app->session->get('userid');
        $rowstotaccepted2 = Yii::$app->db->createCommand($sqltotaccepted2)->queryAll();
		$totaccepted2 = count($rowstotaccepted2);
		
		//echo $sqltotaccepted2;
		
		$percentChange3 = $totaccepted1 - $totaccepted2;
		$percentChange3 = $totaccepted2 - $percentChange3;
		if($percentChange3 >= 0){
			$ptype3 = 1 ;
		}
		else{
			$ptype3 = 0;
		}
		 
		/* if ( $totaccepted1 > 0 ) {
		   $percentChange3 = round($totaccepted2 / ($totaccepted1 / 100),2);
		  } else {
			$percentChange3 = 0;
			} */
		
		$totaccepted = $totaccepted2.":".$percentChange3.":".$ptype3;
		// End
		
		
		// Responses
		
		$sqltotreponses = "SELECT id FROM blacklist where respond >= (UNIX_TIMESTAMP(CURRENT_DATE - INTERVAL 14 DAY)*1000) AND is_response = '1' AND userId = ".Yii::$app->session->get('userid');
		
        $rowstotreponses = Yii::$app->db->createCommand($sqltotreponses)->queryAll();  
		$totreponses1 = count($rowstotreponses); 
		
		$sqltotreponses2 = "SELECT id FROM blacklist where respond >= (UNIX_TIMESTAMP(CURRENT_DATE - INTERVAL 7 DAY)*1000) AND is_response = '1' AND userId = ".Yii::$app->session->get('userid');
        $rowstotreponses2 = Yii::$app->db->createCommand($sqltotreponses2)->queryAll();
		$totreponses2 = count($rowstotreponses2);
		
		$percentChange4 = $totreponses1 - $totreponses2; 
		$percentChange4 = $totreponses2 - $percentChange4;
		if($percentChange4 >= 0){
			$ptype4 = 1 ;
		}
		else  
		{ 
			$ptype4 = 0;
		}
		
		//echo "SELECT id FROM blacklist where respond >= CAST(UNIX_TIMESTAMP(CURRENT_DATE - INTERVAL 7 DAY) AS CHAR(10)) AND is_response = '1' AND userId = ".Yii::$app->session->get('userid');
		
		/* if ( $totreponses1 > 0 ) {
		   $percentChange4 = round($totreponses2 / ($totreponses1 / 100),2);
		  } else {
			$percentChange4 = 0;
			} */
		
		$totreponses = $totreponses2.":".$percentChange4.":".$ptype4;
		
		
		// End
		
		// Withdrown
		
		$sqltotwithdrown = "SELECT id FROM completed_tasks where completedOn >= ( CURDATE() - INTERVAL 14 DAY ) AND triggerOnInvitationAccepted = '1' AND status = 'Complete' AND userId = ".Yii::$app->session->get('userid');
        $rowstotwithdrown = Yii::$app->db->createCommand($sqltotwithdrown)->queryAll();
		$totwithdrown1 = count($rowstotwithdrown);
		
		$sqltotwithdrown2 = "SELECT id FROM completed_tasks where completedOn >= ( CURDATE() - INTERVAL 7 DAY ) AND triggerOnInvitationAccepted = '1' AND status = 'Complete' AND userId = ".Yii::$app->session->get('userid');
		
        $rowstotwithdrown2 = Yii::$app->db->createCommand($sqltotwithdrown2)->queryAll();
		$totwithdrown2 = count($rowstotwithdrown2);
		
		$percentChange5 = $totwithdrown1 - $totwithdrown2;
		$percentChange5 = $totwithdrown2 - $percentChange5;
		 
		if($percentChange5 >= 0){
			$ptype5 = 1 ;
		} 
		else
		{
			$ptype5 = 0;
		}
		
		/* if ( $totwithdrown1 > 0 ) {
		   $percentChange5 = round($totwithdrown2 / ($totwithdrown1 / 100),2);
		  } else {
			$percentChange5 = 0;
			} */
		
		$totwithdrown = $totwithdrown2.":".$percentChange5.":".$ptype5;
		
		// End
		
		echo $tottask.','.$totrequestsent.','.$totaccepted.','.$totreponses.','.$totwithdrown;
		
		
	}
	
	public function actionGetdailylimitchkonchange()
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		$available_ppdel = $_POST['available_ppdel'];
		$text_total_ppdel = $_POST['total_ppdel'];
		$seq_id = $_POST['seq_id'];
		//echo "SELECT SUM(enrollPerDay) as totalppdl from ext_sequences where id != ".$seq_id."  AND status != 'Deleted' AND msgSeq = '0' AND user_id = ".Yii::$app->session->get('userid'); exit;
		$sqlenrollprd = "SELECT SUM(enrollPerDay) as totalppdl from ext_sequences where id != ".$seq_id."  AND status != 'Deleted' AND msgSeq = '0' AND user_id = ".Yii::$app->session->get('userid');
        $countenrollprd = Yii::$app->db->createCommand($sqlenrollprd)->queryOne();
		
		$currentdbtot = $countenrollprd['totalppdl'];
		
		if($currentdbtot > $available_ppdel)
		{
			echo 0;
			
		}else{
			
			$pendingtotlimit = $available_ppdel - $currentdbtot;
			
			if($text_total_ppdel <= $pendingtotlimit)
			{
				echo $text_total_ppdel;
			}
			else
			{
				echo $pendingtotlimit;
			}
		}
		
		
	}
	
	public function actionGetdailylimitchkonchangemsg()
	{
		if(!Yii::$app->session->get('useremail')){
            $url = \Yii::$app->request->baseUrl."/login"; 
            return $this->redirect($url);
        }
		
		$available_mprl = $_POST['available_mprl'];
		$text_total_mprl = $_POST['total_mprl'];
		$seq_id = $_POST['seq_id'];
		
		$sqlenrollprd = "SELECT SUM(enrollPerDay) as totalmprl from ext_sequences where id != ".$seq_id."  AND status != 'Deleted' AND msgSeq = '1' AND user_id = ".Yii::$app->session->get('userid');
        $countenrollprd = Yii::$app->db->createCommand($sqlenrollprd)->queryOne();
		
		$currentdbtot = $countenrollprd['totalmprl'];
		
		if($currentdbtot > $available_mprl)
		{
			echo 0;
			
		}else{
			
			$pendingtotlimit = $available_mprl - $currentdbtot;
			
			if($text_total_mprl <= $pendingtotlimit)
			{
				echo $text_total_mprl;
			}
			else
			{
				echo $pendingtotlimit;
			}
		}
		
		
	}
        
        
         public function actionGetoutoftargetsequense() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $user_id = Yii::$app->session->get('userid');

//        $sqlnomoreprospect = "SELECT * from ext_nomoreprospect where userId = " . $user_id;
        $sqlnomoreprospect = "SELECT N.seqId,S.status from ext_nomoreprospect as N LEFT JOIN ext_sequences AS S ON N.seqId=S.ID where N.userId = " . $user_id . " AND S.status= 'Active'";
        $nomoreprospect = Yii::$app->db->createCommand($sqlnomoreprospect)->queryAll();
        echo json_encode($nomoreprospect);
    }

    public function actionCheckseqlink() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $seqId = Yii::$app->request->post('seqId');
        $user_id = Yii::$app->session->get('userid');
		
		$qry_seqtype = "select target_audience_type from ext_sequences where id = ".$seqId;
		$dataseqtype =  Yii::$app->db->createCommand($qry_seqtype)->queryOne();
		$seqtypeval = $dataseqtype['target_audience_type'];
		
		if($user_id == '16839'){
			if($seqtypeval == 2){ // for csv sequance
				
				$totCount= "SELECT t1.db_seq_id FROM csvfiles t1 JOIN csvprofiles t2 ON t1.id = t2.csvfile_id where t1.db_seq_id=" . $seqId . " AND t2.isDeleted=0 ORDER BY t1.id";
				$totcountprofiles = Yii::$app->db->createCommand($totCount)->queryAll();
				if(count($totcountprofiles) > 0){
					
					Yii::$app->db->createCommand()->delete('ext_nomoreprospect', ['seqId' => $seqId, 'userId' => $user_id])->execute();
					
					Yii::$app->db->createCommand("UPDATE `csvfiles` SET `local_db_id` = '1' WHERE user_id = '".$user_id."' AND db_seq_id = '".$seqId."'")->execute();
					
					return $seqId;
				
				}
				
			}
			else
			{ // for url sequence
			
				$sqlext_links = "SELECT id from ext_links WHERE `seqId` = " . $seqId . " AND (status = 'Active' OR status = 'Not Started')  order by id ASC";
				$ext_links = Yii::$app->db->createCommand($sqlext_links)->queryAll();
				if (count($ext_links) > 0) {
					Yii::$app->db->createCommand()->delete('ext_nomoreprospect', ['seqId' => $seqId, 'userId' => $user_id])->execute();
					return $seqId;
				}
			
			} 
		} 
		else 
		{
			$sqlext_links = "SELECT id from ext_links WHERE `seqId` = " . $seqId . " AND (status = 'Active' OR status = 'Not Started')  order by id ASC";
				$ext_links = Yii::$app->db->createCommand($sqlext_links)->queryAll();
				if (count($ext_links) > 0) {
					Yii::$app->db->createCommand()->delete('ext_nomoreprospect', ['seqId' => $seqId, 'userId' => $user_id])->execute();
					return $seqId;
				}
			
		}
		
    }
    public function actionGetcustomheadings() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $userid = Yii::$app->session->get('userid');
        $customHeadingsQry = Yii::$app->db->createCommand("SELECT customHeadings from `csvfiles` where user_id=$userid and id = '" . $_POST['csvid'] . "'")->queryOne();
        if (!empty($customHeadingsQry)) {
            return $customHeadingsQry['customHeadings'];
        } else {
            return false;
        }
    }
	
	   public function actionGetcustomheadingswebhook() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $userid = Yii::$app->session->get('userid');
		$seqid = $_POST['seqid'];
        $customHeadingsQry = Yii::$app->db->createCommand("SELECT customHeadings from `webhooks` where w_user_id=$userid and w_seq_id = '" . $seqid . "'")->queryOne();
        if (!empty($customHeadingsQry)) {
            return $customHeadingsQry['customHeadings'];
        } else {
            return false;
        }
    }
	
	public function actionAddnewtemplate(){
		
		if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		
		//echo '<pre>'; print_r($_POST); exit;
		
		$userid = Yii::$app->session->get('userid');
        $template_title = addslashes($_POST['template_title']);
        $template_msg = addslashes($_POST['template_msg']);
		//echo "INSERT INTO templates (teamid,templatename,template) VALUES ('".Yii::$app->session->get('userid')."','".//$template_title."','".$template_msg."')"; exit;
		$savesql = Yii::$app->db->createCommand("INSERT INTO templates (teamid,templatename,template) VALUES ('".Yii::$app->session->get('userid')."','".$template_title."','".$template_msg."')")->execute(); 
		$template_id = Yii::$app->db->getLastInsertID(); 
		return $template_id;
	}
	
	
	public function actionGetcountofstepforseq()
	{
		if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		
		$seqid = 0;
		
		if(isset($_POST['seqid'])){
			
			$seqid = $_POST['seqid'];
			
		}
		
		$getstepcount = Yii::$app->db->createCommand("SELECT COUNT(id) as totalSteps FROM ext_steps WHERE seqId ='".$seqid."' order by `order` ASC")->queryOne();
		
		return $getstepcount['totalSteps'];
	}
	
	

}
