<?php
namespace app\controllers;
use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\helpers\Url;
use yii\web\NotFoundHttpException;

use app\controllers\UtilController;
use app\models\Activity;
use yii\web\Session;
use yii\db\Query;
use app\components\CommonFunction;
class SecurepaymentController extends Controller
{
    public $enableCsrfValidation = false;
	
	 public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'only' => ['logout'],
                'rules' => [
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

	
	//NR: This Method is in Use; Do Not Remove; It contains code for multi products in cart;
	public function actionIndex(){
		
		if(!Yii::$app->session->get('useremail')){
           $url = \Yii::$app->request->baseUrl."/login";
           return $this->redirect($url);
        }
		if(Yii::$app->params['portal_url']=='https://app.cloudkennect.com'){
			$url = \Yii::$app->request->baseUrl."/dashboard";
			return $this->redirect($url);
		}		
		//echo '<pre>'; print_r($_POST);die;
		
		extract($_POST);


		$time = new \DateTime('now');
		//$today = $time->format('Y-m-d');
		$timestamp = $time->getTimestamp();
		$merchant_order_id = 'Lf_'.$timestamp.'_'.substr(Yii::$app->security->generateRandomString(),0,15);
		
		
		//|| !isset($product_id) || !isset($quantity)
		if($merchant_order_id==''|| !isset($_POST['selPlan']) || !isset($_POST['selFreeUser']) || count($_POST['selPlan'])!=count($_POST['selFreeUser']) ){
			 return $this->redirect(['my-template/pricing']);
		}
		
		$userinfo = array('merchant_order_id'=>$merchant_order_id,'email'=>Yii::$app->session->get('useremail'),'username'=>Yii::$app->session->get('username'),'user_id'=>Yii::$app->session->get('userid'));
		

		$selPlanArr = $_POST['selPlan'];
		$selUniquePlanArr=array();
		$selPlanUsrArr=array();
		foreach($selPlanArr as $k=>$spa){
			//echo '<br/>'.$k.'::'.$spa.'<br/>';
			if($k==0){
				$selUniquePlanArr[]=$spa;
			}else{
				if(!in_array($spa, $selUniquePlanArr)){
					$selUniquePlanArr[]=$spa;
				}
			}
			$selPlanUsrArr[$spa][]=$_POST['selFreeUser'][$k];
		}
		//echo '<br/>DFDFD:';print_r($selUniquePlanArr);
		//echo '<br/>ADSD:';print_r($selPlanUsrArr);

		$this->initPayment($_POST,$userinfo,array('selPlanUsrArr'=>$selPlanUsrArr));
		$userinfo = json_encode($userinfo);

		//$a = array('NRTestProduct1'=>'100,101,102','NRTestProduct2'=>'103,104,105','NRTestProduct3'=>'106,107,108');
		//$lfaf_seat_purchased_userids = json_encode($selPlanUsrArr);
		//$af_twocheckout_product_id = json_encode($selUniquePlanArr);

		$lfaf_seat_purchased_userids = addslashes(json_encode($selPlanUsrArr));//31-07-2020
		$af_twocheckout_product_id = addslashes(json_encode($selUniquePlanArr));//31-07-2020

		/*11-06-2021:old product commented*/
		$LFPM_qty=0;$LFPM_users='';
		$LFGM_qty=0;$LFGM_users='';
		$LFUM_qty=0;$LFUM_users='';
		$LFPQ_qty=0;$LFPQ_users='';
		$LFGQ_qty=0;$LFGQ_users='';
		$LFUQ_qty=0;$LFUQ_users='';
		$LFUP_qty=0;$LFUP_users='';
		
		$LFPSAR_qty=0;$LFPSAR_users='';
		$LFGSAR_qty=0;$LFGSAR_users='';
		$LFUSAR_qty=0;$LFUSAR_users='';
		$LFPA_qty=0;$LFPA_users='';
		$LFGA_qty=0;$LFGA_users='';
		$LFUA_qty=0;$LFUA_users='';
		/**/
		
		//new product starts
		$LFGM_v2_qty=0;$LFGM_v2_users='';
		$LFUM_v2_qty=0;$LFUM_v2_users='';
		$LFGSAR_v2_qty=0;$LFGSAR_v2_users='';
		$LFUSAR_v2_qty=0;$LFUSAR_v2_users='';
		$LFGA_v2_qty=0;$LFGA_v2_users='';
		$LFUA_v2_qty=0;$LFUA_v2_users='';
		//new product ends

		//$command =Yii::$app->db->createCommand("INSERT INTO user_payment_history (`userid`,`product_id`,`merchant_id`,`user_info`,`status`) VALUES ('".Yii::$app->session->get('userid')."','".$product_id."','".$merchant_order_id."','".$userinfo."','Initialize')");
		//$command =Yii::$app->db->createCommand("INSERT INTO user_payment_history (`userid`,`product_id`,`merchant_id`,`user_info`,`status`,`user_ids`) VALUES ('".Yii::$app->session->get('userid')."','".$product_id."','".$merchant_order_id."','".$userinfo."','Initialize','".$_POST['selUserIds']."')");
		
		$free_userids = implode(',',$_POST['selFreeUser']);
		Yii::$app->db->createCommand("INSERT INTO user_payment_history (`userid`,`merchant_id`,`user_info`,`status`,`user_ids`) VALUES ('".Yii::$app->session->get('userid')."','".$merchant_order_id."','".$userinfo."','Initialize','".$free_userids."')")->execute();
		$lastuphid = Yii::$app->db->getLastInsertID();
		
		foreach($selPlanUsrArr as $product_code=>$uidarr){
			Yii::$app->db->createCommand("INSERT INTO user_order_products SET uph_id=".$lastuphid.", product_id='".$product_code."', user_ids='".implode(',',$uidarr)."' ")->execute();
			/*11-06-2021 commented*/
			if($product_code=='LFPM'){
				$LFPM_qty = count($uidarr);
				$LFPM_users = implode(',',$uidarr);
			}elseif($product_code=='LFGM'){
				$LFGM_qty = count($uidarr);
				$LFGM_users = implode(',',$uidarr);
			}elseif($product_code=='LFUM'){
				$LFUM_qty = count($uidarr);
				$LFUM_users = implode(',',$uidarr);
			}elseif($product_code=='LFPQ'){
				$LFPQ_qty = count($uidarr);
				$LFPQ_users = implode(',',$uidarr);
			}elseif($product_code=='LFGQ'){
				$LFGQ_qty = count($uidarr);
				$LFGQ_users = implode(',',$uidarr);
			}elseif($product_code=='LFUQ'){
				$LFUQ_qty = count($uidarr);
				$LFUQ_users = implode(',',$uidarr);
			}elseif($product_code=='LFUP'){
				$LFUP_qty = count($uidarr);
				$LFUP_users = implode(',',$uidarr);
			}elseif($product_code=='LFPSAR'){
				$LFPSAR_qty = count($uidarr);
				$LFPSAR_users = implode(',',$uidarr);
			}elseif($product_code=='LFGSAR'){
				$LFGSAR_qty = count($uidarr);
				$LFGSAR_users = implode(',',$uidarr);
			}elseif($product_code=='LFUSAR'){
				$LFUSAR_qty = count($uidarr);
				$LFUSAR_users = implode(',',$uidarr);
			}elseif($product_code=='LFPA'){
				$LFPA_qty = count($uidarr);
				$LFPA_users = implode(',',$uidarr);
			}elseif($product_code=='LFGA'){
				$LFGA_qty = count($uidarr);
				$LFGA_users = implode(',',$uidarr);
			}elseif($product_code=='LFUA'){
				$LFUA_qty = count($uidarr);
				$LFUA_users = implode(',',$uidarr);
			}
			/**/

			//new product starts
			elseif($product_code=='LFGM_v2'){
				$LFGM_v2_qty = count($uidarr);
				$LFGM_v2_users = implode(',',$uidarr);
			}elseif($product_code=='LFUM_v2'){
				$LFUM_v2_qty = count($uidarr);
				$LFUM_v2_users = implode(',',$uidarr);
			}elseif($product_code=='LFGSAR_v2'){
				$LFGSAR_v2_qty = count($uidarr);
				$LFGSAR_v2_users = implode(',',$uidarr);
			}elseif($product_code=='LFUSAR_v2'){
				$LFUSAR_v2_qty = count($uidarr);
				$LFUSAR_v2_users = implode(',',$uidarr);
			}elseif($product_code=='LFGA_v2'){
				$LFGA_v2_qty = count($uidarr);
				$LFGA_v2_users = implode(',',$uidarr);
			}elseif($product_code=='LFUA_v2'){
				$LFUA_v2_qty = count($uidarr);
				$LFUA_v2_users = implode(',',$uidarr);
			}
			//new product ends
		}


		
		//$recurrence_plan_array = array('0'=>'2 Week','LFPM'=>'1 Month','LFPQ'=>'3 Month','LFGM'=>'1 Month','LFGQ'=>'3 Month','LFUM'=>'1 Month','LFUQ'=>'3 Month');
       //$recurrence_plan = $recurrence_plan_array[$product_id];
       //$product_name_array = array('LFPM'=>'Professional Monthly','LFPQ'=>'Professional Quarterly','LFGM'=>'Grow Monthly','LFGQ'=>'Grow Quarterly','LFUM'=>'Ultimate Monthly','LFUQ'=>'Ultimate Quarterly');
		//$product_name = $product_name_array[$product_id];
		
		//$twocheckout_product_id = array('LFPM'=>'36147949','LFPQ'=>'36147960','LFGM'=>'36149087','LFGQ'=>'36149119','LFUM'=>'36147991','LFUQ'=>'36148018');//ids in 2checkout panel
        
		
		$command = Yii::$app->db->createCommand("SELECT 2coCustomerReference FROM user WHERE id =".Yii::$app->session->get('userid')." AND 2coCustomerReference>0")->queryOne();
		if(!empty($command)){
			$CustomerReference = $command['2coCustomerReference'];
		}else{
			if (YII_ENV_PROD) {
				//production
				$merchantCode = "203537015";
				$key = 'd?q4rkG]&KAh#vwnmSJ%';				
			}else{
				//staging
				$merchantCode = "251108887711";
				$key = '!G2S8WRBKJ6#&c~luOz=';				
			}

			$gmdate = gmdate('Y-m-d H:i:s');
			$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
			$hashAlgorithm = 'sha256';
			$hash = hash_hmac($hashAlgorithm , $string, $key);
			
			//Working example of how to create a customer
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, "https://api.2checkout.com/rest/6.0/customers/");
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_HEADER, FALSE);
			curl_setopt($ch, CURLOPT_POST, TRUE);

			$headers = array();
			$headers[] = 'Accept: application/json';
			$headers[] = 'Content-Type: application/json';
			$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				  $first_name = Yii::$app->session->get('first_name');
				  $last_name = Yii::$app->session->get('last_name');
				  $useremail = Yii::$app->session->get('useremail');
				  $userid = Yii::$app->session->get('userid');
				  //\"ExternalCustomerReference\": \"$userid\",
				  //\"ExternalCustomerReference\": \"\",
				  
			curl_setopt($ch, CURLOPT_POSTFIELDS, "{
				  \"ExternalCustomerReference\": null,
				  \"FirstName\": \"$first_name\",
				  \"LastName\": \"$last_name\",
				  \"Address1\": \"N/A\",
				  \"City\": \"N/A\",
				  \"Zip\": \"123456\",
				  \"CountryCode\": \"gb\",
				  \"Email\": \"$useremail\",
				  \"Trial\": false,
				  \"Enabled\": true
			}");
			$CustomerReference = $curl_result = curl_exec($ch);
			if($CustomerReference>0){
				Yii::$app->db->createCommand('UPDATE user SET 2coCustomerReference = "'.$CustomerReference.'"  WHERE id='.Yii::$app->session->get('userid'))->execute();
			}
			//print_r($curl_result);
			//$curlResult = json_decode($curl_result);
			//echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
			if (curl_errno($ch)) {
				//echo 'Error:' . curl_error($ch);
			}
			curl_close($ch);
		}
		
		
		if($CustomerReference>0){
			
			$TwoCO_RedirectUrl = Yii::$app->params['siteburl'].'securepayment/response';		
			
			//echo json_encode(array('success'=>1,'merchant_order_id'=>$merchant_order_id,'twocheckout_product_id'=>$twocheckout_product_id,'selUserIds'=>$selUserIds,'TwoCOCustomerReference'=>$CustomerReference));
			//'twocheckout_product_id'=>$twocheckout_product_id : this should be now at product level instead of order level; => af_twocheckout_product_id done
			//,'selUserIds'=>$selUserIds : this should be now at product level instead of order level; => lfaf_seat_purchased_userids done
			echo json_encode(array('success'=>1,'merchant_order_id'=>$merchant_order_id,'TwoCOCustomerReference'=>$CustomerReference,'lfaf_seat_purchased_userids'=>$lfaf_seat_purchased_userids,'af_twocheckout_product_id'=>$af_twocheckout_product_id,
			/*11-06-2021 commented*/
			'LFPM_qty'=>$LFPM_qty,
			'LFPM_users'=>$LFPM_users,
			'LFGM_qty'=>$LFGM_qty,
			'LFGM_users'=>$LFGM_users,
			'LFUM_qty'=>$LFUM_qty,
			'LFUM_users'=>$LFUM_users,
			'LFPQ_qty'=>$LFPQ_qty,
			'LFPQ_users'=>$LFPQ_users,
			'LFGQ_qty'=>$LFGQ_qty,
			'LFGQ_users'=>$LFGQ_users,
			'LFUQ_qty'=>$LFUQ_qty,
			'LFUQ_users'=>$LFUQ_users,
			'LFPSAR_qty'=>$LFPSAR_qty,
			'LFPSAR_users'=>$LFPSAR_users,
			'LFGSAR_qty'=>$LFGSAR_qty,
			'LFGSAR_users'=>$LFGSAR_users,
			'LFUSAR_qty'=>$LFUSAR_qty,
			'LFUSAR_users'=>$LFUSAR_users,
			'LFPA_qty'=>$LFPA_qty,
			'LFPA_users'=>$LFPA_users,
			'LFGA_qty'=>$LFGA_qty,
			'LFGA_users'=>$LFGA_users,
			'LFUA_qty'=>$LFUA_qty,
			'LFUA_users'=>$LFUA_users,
			/**/
			'LFGM_v2_qty'=>$LFGM_v2_qty,
			'LFGM_v2_users'=>$LFGM_v2_users,
			'LFUM_v2_qty'=>$LFUM_v2_qty,
			'LFUM_v2_users'=>$LFUM_v2_users,
			'LFGSAR_v2_qty'=>$LFGSAR_v2_qty,
			'LFGSAR_v2_users'=>$LFGSAR_v2_users,
			'LFUSAR_v2_qty'=>$LFUSAR_v2_qty,
			'LFUSAR_v2_users'=>$LFUSAR_v2_users,
			'LFGA_v2_qty'=>$LFGA_v2_qty,
			'LFGA_v2_users'=>$LFGA_v2_users,
			'LFUA_v2_qty'=>$LFUA_v2_qty,
			'LFUA_v2_users'=>$LFUA_v2_users,
			'TwoCO_RedirectUrl'=>$TwoCO_RedirectUrl
			));
		}
		
	}	
	

	//NR: Used for Blackfriday. This Method is in Use; Do Not Remove; It contains code for multi products in cart;
	public function actionIndexblackfriday(){
		
		if(!Yii::$app->session->get('useremail')){
           $url = \Yii::$app->request->baseUrl."/login";
           return $this->redirect($url);
        }
		if(Yii::$app->params['portal_url']=='https://app.cloudkennect.com'){
			$url = \Yii::$app->request->baseUrl."/dashboard";
			return $this->redirect($url);
		}		
		//echo '<pre>'; print_r($_POST);die;
		
		extract($_POST);


		$time = new \DateTime('now');
		//$today = $time->format('Y-m-d');
		$timestamp = $time->getTimestamp();
		$merchant_order_id = 'Lf_'.$timestamp.'_'.substr(Yii::$app->security->generateRandomString(),0,15);
		
		
		//|| !isset($product_id) || !isset($quantity)
		if($merchant_order_id==''|| !isset($_POST['selPlan']) || !isset($_POST['selFreeUser']) || count($_POST['selPlan'])!=count($_POST['selFreeUser']) ){
			 return $this->redirect(['my-template/blackfriday']);
		}
		
		$userinfo = array('merchant_order_id'=>$merchant_order_id,'email'=>Yii::$app->session->get('useremail'),'username'=>Yii::$app->session->get('username'),'user_id'=>Yii::$app->session->get('userid'));
		

		$selPlanArr = $_POST['selPlan'];
		$selUniquePlanArr=array();
		$selPlanUsrArr=array();
		foreach($selPlanArr as $k=>$spa){
			//echo '<br/>'.$k.'::'.$spa.'<br/>';
			if($k==0){
				$selUniquePlanArr[]=$spa;
			}else{
				if(!in_array($spa, $selUniquePlanArr)){
					$selUniquePlanArr[]=$spa;
				}
			}
			$selPlanUsrArr[$spa][]=$_POST['selFreeUser'][$k];
		}
		//echo '<br/>DFDFD:';print_r($selUniquePlanArr);
		//echo '<br/>ADSD:';print_r($selPlanUsrArr);

		$this->initPayment($_POST,$userinfo,array('selPlanUsrArr'=>$selPlanUsrArr));
		$userinfo = json_encode($userinfo);

		//$a = array('NRTestProduct1'=>'100,101,102','NRTestProduct2'=>'103,104,105','NRTestProduct3'=>'106,107,108');
		//$lfaf_seat_purchased_userids = json_encode($selPlanUsrArr);
		//$af_twocheckout_product_id = json_encode($selUniquePlanArr);

		$lfaf_seat_purchased_userids = addslashes(json_encode($selPlanUsrArr));//31-07-2020
		$af_twocheckout_product_id = addslashes(json_encode($selUniquePlanArr));//31-07-2020

		$LFPSA_qty=0;$LFPSA_users='';
		$LFGSA_qty=0;$LFGSA_users='';
		$LFUSA_qty=0;$LFUSA_users='';
		$LFPABF_qty=0;$LFPABF_users='';
		$LFGABF_qty=0;$LFGABF_users='';
		$LFUABF_qty=0;$LFUABF_users='';
		$LFUP_qty=0;$LFUP_users='';

		//$command =Yii::$app->db->createCommand("INSERT INTO user_payment_history (`userid`,`product_id`,`merchant_id`,`user_info`,`status`) VALUES ('".Yii::$app->session->get('userid')."','".$product_id."','".$merchant_order_id."','".$userinfo."','Initialize')");
		//$command =Yii::$app->db->createCommand("INSERT INTO user_payment_history (`userid`,`product_id`,`merchant_id`,`user_info`,`status`,`user_ids`) VALUES ('".Yii::$app->session->get('userid')."','".$product_id."','".$merchant_order_id."','".$userinfo."','Initialize','".$_POST['selUserIds']."')");
		
		$free_userids = implode(',',$_POST['selFreeUser']);
		Yii::$app->db->createCommand("INSERT INTO user_payment_history (`userid`,`merchant_id`,`user_info`,`status`,`user_ids`) VALUES ('".Yii::$app->session->get('userid')."','".$merchant_order_id."','".$userinfo."','Initialize','".$free_userids."')")->execute();
		$lastuphid = Yii::$app->db->getLastInsertID();
		
		foreach($selPlanUsrArr as $product_code=>$uidarr){
			Yii::$app->db->createCommand("INSERT INTO user_order_products SET uph_id=".$lastuphid.", product_id='".$product_code."', user_ids='".implode(',',$uidarr)."' ")->execute();

			if($product_code=='LFPSA'){
				$LFPSA_qty = count($uidarr);
				$LFPSA_users = implode(',',$uidarr);
			}elseif($product_code=='LFGSA'){
				$LFGSA_qty = count($uidarr);
				$LFGSA_users = implode(',',$uidarr);
			}elseif($product_code=='LFUSA'){
				$LFUSA_qty = count($uidarr);
				$LFUSA_users = implode(',',$uidarr);
			}elseif($product_code=='LFPABF'){
				$LFPABF_qty = count($uidarr);
				$LFPABF_users = implode(',',$uidarr);
			}elseif($product_code=='LFGABF'){
				$LFGABF_qty = count($uidarr);
				$LFGABF_users = implode(',',$uidarr);
			}elseif($product_code=='LFUABF'){
				$LFUABF_qty = count($uidarr);
				$LFUABF_users = implode(',',$uidarr);
			}elseif($product_code=='LFUP'){
				$LFUP_qty = count($uidarr);
				$LFUP_users = implode(',',$uidarr);
			}
		}


		
		//$recurrence_plan_array = array('0'=>'2 Week','LFPM'=>'1 Month','LFPQ'=>'3 Month','LFGM'=>'1 Month','LFGQ'=>'3 Month','LFUM'=>'1 Month','LFUQ'=>'3 Month');
       //$recurrence_plan = $recurrence_plan_array[$product_id];
       //$product_name_array = array('LFPM'=>'Professional Monthly','LFPQ'=>'Professional Quarterly','LFGM'=>'Grow Monthly','LFGQ'=>'Grow Quarterly','LFUM'=>'Ultimate Monthly','LFUQ'=>'Ultimate Quarterly');
		//$product_name = $product_name_array[$product_id];
		
		//$twocheckout_product_id = array('LFPM'=>'36147949','LFPQ'=>'36147960','LFGM'=>'36149087','LFGQ'=>'36149119','LFUM'=>'36147991','LFUQ'=>'36148018');//ids in 2checkout panel
        
		
		$command = Yii::$app->db->createCommand("SELECT 2coCustomerReference FROM user WHERE id =".Yii::$app->session->get('userid')." AND 2coCustomerReference>0")->queryOne();
		if(!empty($command)){
			$CustomerReference = $command['2coCustomerReference'];
		}else{
			if (YII_ENV_PROD) {
				//production
				$merchantCode = "203537015";
				$key = 'd?q4rkG]&KAh#vwnmSJ%';				
			}else{
				//staging
				$merchantCode = "251108887711";
				$key = '!G2S8WRBKJ6#&c~luOz=';				
			}

			$gmdate = gmdate('Y-m-d H:i:s');
			$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
			$hashAlgorithm = 'sha256';
			$hash = hash_hmac($hashAlgorithm , $string, $key);
			
			//Working example of how to create a customer
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, "https://api.2checkout.com/rest/6.0/customers/");
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_HEADER, FALSE);
			curl_setopt($ch, CURLOPT_POST, TRUE);

			$headers = array();
			$headers[] = 'Accept: application/json';
			$headers[] = 'Content-Type: application/json';
			$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				  $first_name = Yii::$app->session->get('first_name');
				  $last_name = Yii::$app->session->get('last_name');
				  $useremail = Yii::$app->session->get('useremail');
				  $userid = Yii::$app->session->get('userid');
				  //\"ExternalCustomerReference\": \"$userid\",
				  //\"ExternalCustomerReference\": \"\",
				  
			curl_setopt($ch, CURLOPT_POSTFIELDS, "{
				  \"ExternalCustomerReference\": null,
				  \"FirstName\": \"$first_name\",
				  \"LastName\": \"$last_name\",
				  \"Address1\": \"N/A\",
				  \"City\": \"N/A\",
				  \"Zip\": \"123456\",
				  \"CountryCode\": \"gb\",
				  \"Email\": \"$useremail\",
				  \"Trial\": false,
				  \"Enabled\": true
			}");
			$CustomerReference = $curl_result = curl_exec($ch);
			if($CustomerReference>0){
				Yii::$app->db->createCommand('UPDATE user SET 2coCustomerReference = "'.$CustomerReference.'"  WHERE id='.Yii::$app->session->get('userid'))->execute();
			}
			//print_r($curl_result);
			//$curlResult = json_decode($curl_result);
			//echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
			if (curl_errno($ch)) {
				//echo 'Error:' . curl_error($ch);
			}
			curl_close($ch);
		}
		
		
		if($CustomerReference>0){
			
			$TwoCO_RedirectUrl = Yii::$app->params['siteburl'].'securepayment/responseblackfriday';		
			
			//echo json_encode(array('success'=>1,'merchant_order_id'=>$merchant_order_id,'twocheckout_product_id'=>$twocheckout_product_id,'selUserIds'=>$selUserIds,'TwoCOCustomerReference'=>$CustomerReference));
			//'twocheckout_product_id'=>$twocheckout_product_id : this should be now at product level instead of order level; => af_twocheckout_product_id done
			//,'selUserIds'=>$selUserIds : this should be now at product level instead of order level; => lfaf_seat_purchased_userids done
			echo json_encode(array('success'=>1,'merchant_order_id'=>$merchant_order_id,'TwoCOCustomerReference'=>$CustomerReference,'lfaf_seat_purchased_userids'=>$lfaf_seat_purchased_userids,'af_twocheckout_product_id'=>$af_twocheckout_product_id,
			'LFPSA_qty'=>$LFPSA_qty,
			'LFPSA_users'=>$LFPSA_users,
			'LFGSA_qty'=>$LFGSA_qty,
			'LFGSA_users'=>$LFGSA_users,
			'LFUSA_qty'=>$LFUSA_qty,
			'LFUSA_users'=>$LFUSA_users,
			'LFPABF_qty'=>$LFPABF_qty,
			'LFPABF_users'=>$LFPABF_users,
			'LFGABF_qty'=>$LFGABF_qty,
			'LFGABF_users'=>$LFGABF_users,
			'LFUABF_qty'=>$LFUABF_qty,
			'LFUABF_users'=>$LFUABF_users,
			'TwoCO_RedirectUrl'=>$TwoCO_RedirectUrl
			));
		}
		
	}

	//Working method for addOnPack product
	public function actionIndex_addonpack(){
		//echo 'dfdf';die;
		if(!Yii::$app->session->get('useremail')){
           $url = \Yii::$app->request->baseUrl."/login";
           return $this->redirect($url);
        }
		if(Yii::$app->params['portal_url']=='https://app.cloudkennect.com'){
			$url = \Yii::$app->request->baseUrl."/dashboard";
			return $this->redirect($url);
		}		
		//echo '<pre>'; print_r($_POST);die;
		
		extract($_POST);


		$time = new \DateTime('now');
		//$today = $time->format('Y-m-d');
		$timestamp = $time->getTimestamp();
		$merchant_order_id = 'Lf_'.$timestamp.'_'.substr(Yii::$app->security->generateRandomString(),0,15);
		
		
		//|| !isset($product_id) || !isset($quantity)
		if($merchant_order_id==''|| !isset($_POST['selAddOnPlan']) || !isset($_POST['selAddOnUser']) || count($_POST['selAddOnPlan'])!=count($_POST['selAddOnUser']) ){
			 return $this->redirect(['my-template/pricing']);
		}
		
		$userinfo = array('merchant_order_id'=>$merchant_order_id,'email'=>Yii::$app->session->get('useremail'),'username'=>Yii::$app->session->get('username'),'user_id'=>Yii::$app->session->get('userid'));
		

		$selPlanArr = $_POST['selAddOnPlan'];
		$selUniquePlanArr=array();
		$selPlanUsrArr=array();
		foreach($selPlanArr as $k=>$spa){
			//echo '<br/>'.$k.'::'.$spa.'<br/>';
			if($k==0){
				$selUniquePlanArr[]=$spa;
			}else{
				if(!in_array($spa, $selUniquePlanArr)){
					$selUniquePlanArr[]=$spa;
				}
			}
			$selPlanUsrArr[$spa][]=$_POST['selAddOnUser'][$k];
		}
		//echo '<br/>DFDFD:';print_r($selUniquePlanArr);
		//echo '<br/>ADSD:';print_r($selPlanUsrArr);

		$this->initPayment($_POST,$userinfo,array('selPlanUsrArr'=>$selPlanUsrArr));
		$userinfo = json_encode($userinfo);

		//$a = array('NRTestProduct1'=>'100,101,102','NRTestProduct2'=>'103,104,105','NRTestProduct3'=>'106,107,108');
		//$lfaf_seat_purchased_userids = json_encode($selPlanUsrArr);
		//$af_twocheckout_product_id = json_encode($selUniquePlanArr);

		$lfaf_seat_purchased_userids = addslashes(json_encode($selPlanUsrArr));//31-07-2020
		$af_twocheckout_product_id = addslashes(json_encode($selUniquePlanArr));//31-07-2020


		
		//addOnProduct starts
		$LFAddOnPack_qty=0;$LFAddOnPack_users='';
		//addOnProduct ends

		//$command =Yii::$app->db->createCommand("INSERT INTO user_payment_history (`userid`,`product_id`,`merchant_id`,`user_info`,`status`) VALUES ('".Yii::$app->session->get('userid')."','".$product_id."','".$merchant_order_id."','".$userinfo."','Initialize')");
		//$command =Yii::$app->db->createCommand("INSERT INTO user_payment_history (`userid`,`product_id`,`merchant_id`,`user_info`,`status`,`user_ids`) VALUES ('".Yii::$app->session->get('userid')."','".$product_id."','".$merchant_order_id."','".$userinfo."','Initialize','".$_POST['selUserIds']."')");
		
		$free_userids = implode(',',$_POST['selAddOnUser']);
		Yii::$app->db->createCommand("INSERT INTO user_payment_history (`userid`,`merchant_id`,`user_info`,`status`,`isAddOnPackOrder`,`user_ids`) VALUES ('".Yii::$app->session->get('userid')."','".$merchant_order_id."','".$userinfo."','Initialize',1,'".$free_userids."')")->execute();
		$lastuphid = Yii::$app->db->getLastInsertID();
		
		foreach($selPlanUsrArr as $product_code=>$uidarr){
			Yii::$app->db->createCommand("INSERT INTO user_order_products SET uph_id=".$lastuphid.", product_id='".$product_code."', isAddOnPackProduct=1, user_ids='".implode(',',$uidarr)."' ")->execute();
			
			
			

			
			
			//addOnProduct starts
			if($product_code=='LFAddOnPack'){
				$LFAddOnPack_qty = count($uidarr);
				$LFAddOnPack_users = implode(',',$uidarr);
			}
			//addOnProduct ends
		}


		
		//$recurrence_plan_array = array('0'=>'2 Week','LFPM'=>'1 Month','LFPQ'=>'3 Month','LFGM'=>'1 Month','LFGQ'=>'3 Month','LFUM'=>'1 Month','LFUQ'=>'3 Month');
       //$recurrence_plan = $recurrence_plan_array[$product_id];
       //$product_name_array = array('LFPM'=>'Professional Monthly','LFPQ'=>'Professional Quarterly','LFGM'=>'Grow Monthly','LFGQ'=>'Grow Quarterly','LFUM'=>'Ultimate Monthly','LFUQ'=>'Ultimate Quarterly');
		//$product_name = $product_name_array[$product_id];
		
		//$twocheckout_product_id = array('LFPM'=>'36147949','LFPQ'=>'36147960','LFGM'=>'36149087','LFGQ'=>'36149119','LFUM'=>'36147991','LFUQ'=>'36148018');//ids in 2checkout panel
        
		
		$command = Yii::$app->db->createCommand("SELECT 2coCustomerReference FROM user WHERE id =".Yii::$app->session->get('userid')." AND 2coCustomerReference>0")->queryOne();
		if(!empty($command)){
			$CustomerReference = $command['2coCustomerReference'];
		}else{
			if (YII_ENV_PROD) {
				//production
				$merchantCode = "203537015";
				$key = 'd?q4rkG]&KAh#vwnmSJ%';				
			}else{
				//staging
				$merchantCode = "251108887711";
				$key = '!G2S8WRBKJ6#&c~luOz=';				
			}

			$gmdate = gmdate('Y-m-d H:i:s');
			$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
			$hashAlgorithm = 'sha256';
			$hash = hash_hmac($hashAlgorithm , $string, $key);
			
			//Working example of how to create a customer
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, "https://api.2checkout.com/rest/6.0/customers/");
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_HEADER, FALSE);
			curl_setopt($ch, CURLOPT_POST, TRUE);

			$headers = array();
			$headers[] = 'Accept: application/json';
			$headers[] = 'Content-Type: application/json';
			$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				  $first_name = Yii::$app->session->get('first_name');
				  $last_name = Yii::$app->session->get('last_name');
				  $useremail = Yii::$app->session->get('useremail');
				  $userid = Yii::$app->session->get('userid');
				  //\"ExternalCustomerReference\": \"$userid\",
				  //\"ExternalCustomerReference\": \"\",
				  
			curl_setopt($ch, CURLOPT_POSTFIELDS, "{
				  \"ExternalCustomerReference\": null,
				  \"FirstName\": \"$first_name\",
				  \"LastName\": \"$last_name\",
				  \"Address1\": \"N/A\",
				  \"City\": \"N/A\",
				  \"Zip\": \"123456\",
				  \"CountryCode\": \"gb\",
				  \"Email\": \"$useremail\",
				  \"Trial\": false,
				  \"Enabled\": true
			}");
			$CustomerReference = $curl_result = curl_exec($ch);
			if($CustomerReference>0){
				Yii::$app->db->createCommand('UPDATE user SET 2coCustomerReference = "'.$CustomerReference.'"  WHERE id='.Yii::$app->session->get('userid'))->execute();
			}
			//print_r($curl_result);
			//$curlResult = json_decode($curl_result);
			//echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
			if (curl_errno($ch)) {
				//echo 'Error:' . curl_error($ch);
			}
			curl_close($ch);
		}
		
		
		if($CustomerReference>0){
			
			$TwoCO_RedirectUrl = Yii::$app->params['siteburl'].'securepayment/response';		
			
			//echo json_encode(array('success'=>1,'merchant_order_id'=>$merchant_order_id,'twocheckout_product_id'=>$twocheckout_product_id,'selUserIds'=>$selUserIds,'TwoCOCustomerReference'=>$CustomerReference));
			//'twocheckout_product_id'=>$twocheckout_product_id : this should be now at product level instead of order level; => af_twocheckout_product_id done
			//,'selUserIds'=>$selUserIds : this should be now at product level instead of order level; => lfaf_seat_purchased_userids done
			echo json_encode(array('success'=>1,'merchant_order_id'=>$merchant_order_id,'TwoCOCustomerReference'=>$CustomerReference,'lfaf_seat_purchased_userids'=>$lfaf_seat_purchased_userids,'af_twocheckout_product_id'=>$af_twocheckout_product_id,
			'LFAddOnPack_qty'=>$LFAddOnPack_qty,
			'LFAddOnPack_users'=>$LFAddOnPack_users,
			'TwoCO_RedirectUrl'=>$TwoCO_RedirectUrl
			));
		}
		
	}
	
	public function initPayment($postData,$userinfo,$selPlanUsrArr){

		
		
		$combined_array =  array_merge ($postData,$userinfo,$selPlanUsrArr);
		//echo '<br/>:::<pre>'; print_r($combined_array);die;
		extract($_POST);
		extract($userinfo);

			if (YII_ENV_PROD) {
				//production
				$email_address='arpan@intricare.net';
				$email_subject=$userinfo['username']. ' has initialized payment at '.date('Y-m-d H:i:s');
			}else{
				//staging
				$email_address='nikit@intricaretech.com';
				$email_subject='STAGING TEST - '.$userinfo['username']. ' has initialized payment at '.date('Y-m-d H:i:s');
			}
		
		$html = $this->renderPartial('/../mail/paymentinit', ['value' => $combined_array,'fullname'=>Yii::$app->session->get('username')]);		
		$mail = Yii::$app->mailer->compose()		
		->setTo($email_address)
		//->setBcc('binita@intricare.net')
		//->setBcc(['nikit@intricaretech.com'])
		->setFrom([Yii::$app->params['adminEmail']=>Yii::$app->params['emailFromName'].' payment initialized'])
		//->setReplyTo()
		->setSubject($email_subject)
		->setHtmlBody($html,'text/html');
		$mail->send(); 
		
		
		$pcodesArr=array();
		$selPlanUsrArr = $selPlanUsrArr['selPlanUsrArr'];
		foreach($selPlanUsrArr as $product_code=>$uidarr){
			$pcodesArr[]=$product_code;
		}
		$pcodes = implode(',',$pcodesArr);
		
		/*just commented for staging. It will be there in PRODUCTION;
		$created_at=time();  
			try{    
				$curl = curl_init();

				//$postfield='{"event_name" : "Payment_initialized","created_at": "'.$created_at.'","email" : "'.$combined_array['email'].'","metadata": {"Selected_Plan": "'.$combined_array['plan'].' '.$combined_array['duration'].'" } }';
				$postfield='{"event_name" : "Payment_initialized","created_at": "'.$created_at.'","email" : "'.$combined_array['email'].'","metadata": {"Selected_Plan": "'.$pcodes.'" } }';
				curl_setopt_array($curl, array(
				CURLOPT_URL => "https://api.intercom.io/events",
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 30,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => "POST",
				CURLOPT_SSL_VERIFYPEER=>FALSE,
				CURLOPT_POSTFIELDS =>$postfield,
				CURLOPT_HTTPHEADER => array(
				"authorization: Bearer dG9rOmVhOGViNWE0X2UwN2NfNDE2NF85YzU4XzRhOTFmYjI3YTFlMDoxOjA=",
				"cache-control: no-cache",
				"content-type: application/json"
				),
				));

				$response = curl_exec($curl);
				$err = curl_error($curl);

				curl_close($curl);

				if ($err) {
				echo "cURL Error #:" . $err;
				} else {
				echo $response;
				}
			}catch(Exception $e){
				echo 'Caught exception: ',  $e->getMessage(), "\n";
			}
		*/
	}
	 
	 public function successedPayment($payment_info){
		$email = $payment_info['ses_email'];
		$html = $this->renderPartial('/../mail/paymentsuccessed', ['value' => $payment_info,'fullname'=>$payment_info['ses_full_name']]);
		
		if (YII_ENV_PROD) {
			//production
			$email_subject = 'Thank you for upgrading your '.Yii::$app->params['emailFromName'].' subscription !';
			$bccEmail = ['arpan@intricare.net'];
		}else{
			//staging
			$email_subject = 'STAGING TEST - Thank you for upgrading your '.Yii::$app->params['emailFromName'].' subscription !';
			$bccEmail = ['nikit@intricaretech.com'];
		}
		
		/*if($payment_info['previous_plan'] == 'Free Forever'){
			$mail = Yii::$app->mailer->compose()
			->setTo($email)
			->setBcc('nikit@intricaretech.com')
			//->setFrom(['payments@intricare.net'=>Yii::$app->params['emailFromName'].' Payments'])
			//->setFrom(['arpan@intricare.net'=>Yii::$app->params['emailFromName'].' Payments'])
			->setFrom(['dhaval.thakor@linkedfusion.io'=>Yii::$app->params['emailFromName'].' Payments'])
			//->setReplyTo()
				->setSubject('STAGING TEST - Thank for subscribing to '.Yii::$app->params['emailFromName'].'!')
			->setHtmlBody($html,'text/html');
			$mail->send();
		}else{*/
		if (YII_ENV_PROD) {
			$mail = Yii::$app->mailer->compose()
			->setTo($email)
			->setBcc($bccEmail)
			//->setFrom(['payments@intricare.net'=>Yii::$app->params['emailFromName'].' Payments'])
			//->setFrom(['arpan@intricare.net'=>Yii::$app->params['emailFromName'].' Payments'])
			//->setFrom(['dhaval.thakor@linkedfusion.io'=>Yii::$app->params['emailFromName'].' Payments'])
			->setFrom([Yii::$app->params['adminEmail']=>Yii::$app->params['emailFromName'].' Payments'])
			//->setReplyTo()
			->setSubject($email_subject)
			->setHtmlBody($html,'text/html');
			$mail->send();
		}else{
			$mail = Yii::$app->mailer->compose()
			->setTo($email)
			->setFrom([Yii::$app->params['adminEmail']=>Yii::$app->params['emailFromName'].' Payments'])
			->setSubject($email_subject)
			->setHtmlBody($html,'text/html');
			$mail->send();
		}
		//}
		
		
		
		/*just commented for staging. It will be there in PRODUCTION;
		$pcodesArr=array();
		$selPlanUsrArr = $payment_info['selPlanUsrArr'];
		foreach($selPlanUsrArr as $product_code=>$userinfo){
			$pcodesArr[]=$product_code;
		}
		$pcodes = implode(',',$pcodesArr);
		
		$created_at=time();
			try{    
				$curl = curl_init();
				//$postfield='{"event_name" : "Plan_upgraded","created_at": "'.$created_at.'","email" : "'.$email.'","metadata": {"Selected_Plan": "'.$payment_info['current_plan'].'" } }';
				$postfield='{"event_name" : "Plan_upgraded","created_at": "'.$created_at.'","email" : "'.$email.'","metadata": {"Selected_Plan": "'.$pcodes.'" } }';
				curl_setopt_array($curl, array(
				CURLOPT_URL => "https://api.intercom.io/events",
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 30,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => "POST",
				CURLOPT_SSL_VERIFYPEER=>FALSE,
				CURLOPT_POSTFIELDS =>$postfield,
				CURLOPT_HTTPHEADER => array(
				"authorization: Bearer dG9rOmVhOGViNWE0X2UwN2NfNDE2NF85YzU4XzRhOTFmYjI3YTFlMDoxOjA=",
				"cache-control: no-cache",
				"content-type: application/json"
				),
				));
				$response = curl_exec($curl);
				$err = curl_error($curl);
				curl_close($curl);
				if ($err) {
				echo "cURL Error #:" . $err;
				} else {
				echo $response;
				}
			}catch(Exception $e){
				echo 'Caught exception: ',  $e->getMessage(), "\n";
			}
		*/
	}
	
	

	 public function recurringSuccessedPayment($payment_info){
		$email = $payment_info['ses_email'];//customer email
		
		$html = $this->renderPartial('/../mail/recurringpaymentsuccessed', ['value' => $payment_info,'fullname'=>$payment_info['ses_full_name'],'responseGetJson'=>$payment_info['responseGetJson']]);

			if (YII_ENV_PROD) {
				//production
				$to_email = ['nikit@intricaretech.com'];
				$email_subject = Yii::$app->params['emailFromName'].' - Recurring Installment Successed For Order Ref #'.$payment_info['order_number'];
			}else{
				//staging
				$to_email = 'nikit@intricaretech.com';
				$email_subject = 'STAGING TEST - '.Yii::$app->params['emailFromName'].' - Recurring Installment Successed For Order Ref #'.$payment_info['order_number'];
			}

			$mail = Yii::$app->mailer->compose()
			//->setTo($email)
			->setTo($to_email)
			//->setBcc(['binita@intricare.net','bhavin@intricare.net'])
			//->setFrom(['payments@intricare.net'=>Yii::$app->params['emailFromName'].' Payments'])
			//->setFrom(['arpan@intricare.net'=>Yii::$app->params['emailFromName'].' Payments'])
			->setFrom([Yii::$app->params['adminEmail']=>Yii::$app->params['emailFromName'].' Payments'])
			//->setReplyTo()
			//->setSubject('STAGING TEST - '.Yii::$app->params['emailFromName'].' - Recurring Successed Payment For Order Ref #'.$payment_info['order_number'])
			->setSubject($email_subject)
			->setHtmlBody($html,'text/html');
			$mail->send();
	}
	
	//28-06-2021
	 public function recurringSuccessedPaymentAddOnPackProduct($payment_info){
		$email = $payment_info['ses_email'];//customer email
		
		$html = $this->renderPartial('/../mail/recurringpaymentsuccessedAddOnPackProduct', ['value' => $payment_info,'fullname'=>$payment_info['ses_full_name'],'responseGetJson'=>$payment_info['responseGetJson']]);

			if (YII_ENV_PROD) {
				//production
				$to_email = ['nikit@intricaretech.com'];
				$email_subject = Yii::$app->params['emailFromName'].' - Recurring Installment Successed For Order Ref #'.$payment_info['order_number'];
			}else{
				//staging
				$to_email = 'nikit@intricaretech.com';
				$email_subject = 'STAGING TEST - '.Yii::$app->params['emailFromName'].' - Recurring Installment Successed For Order Ref #'.$payment_info['order_number'];
			}

			$mail = Yii::$app->mailer->compose()
			->setTo($to_email)
			->setFrom([Yii::$app->params['adminEmail']=>Yii::$app->params['emailFromName'].' Payments'])
			->setSubject($email_subject)
			->setHtmlBody($html,'text/html');
			$mail->send();
	}

	 
	 public function renewedSuccessedPayment($payment_info){
		$email = $payment_info['ses_email'];//customer email

			if (YII_ENV_PROD) {
				//production
				$to_email = ['arpan@intricare.net','nikit@intricaretech.com'];
				$email_subject = Yii::$app->params['emailFromName'].' - Manual Subscription Renewal (#'.$payment_info['GETSubscriptionRef'].') Successed For Order Ref #'.$payment_info['order_number'];
			}else{
				//staging
				$to_email = 'nikit@intricaretech.com';
				$email_subject = 'STAGING TEST - '.Yii::$app->params['emailFromName'].' - Manual Subscription Renewal (#'.$payment_info['GETSubscriptionRef'].') Successed For Order Ref #'.$payment_info['order_number'];
			}
		
		$html = $this->renderPartial('/../mail/renewedpaymentsuccessed', ['value' => $payment_info,'fullname'=>$payment_info['ses_full_name'],'responseGetJson'=>$payment_info['responseGetJson']]);

			$mail = Yii::$app->mailer->compose()
			->setTo($to_email)
			//->setBcc(['binita@intricare.net','bhavin@intricare.net'])
			//->setFrom(['payments@intricare.net'=>Yii::$app->params['emailFromName'].' Payments'])
			//->setFrom(['arpan@intricare.net'=>Yii::$app->params['emailFromName'].' Payments'])
			->setFrom([Yii::$app->params['adminEmail']=>Yii::$app->params['emailFromName'].' Payments'])
			//->setReplyTo()
			->setSubject($email_subject)
			->setHtmlBody($html,'text/html');
			$mail->send();
	}
	
	//28-06-2021
	 public function renewedSuccessedPaymentAddOnPackExclusiveOrder($payment_info){
		$email = $payment_info['ses_email'];//customer email

			if (YII_ENV_PROD) {
				//production
				$to_email = ['arpan@intricare.net','nikit@intricaretech.com'];
				$email_subject = Yii::$app->params['emailFromName'].' - Manual Subscription Renewal (#'.$payment_info['GETSubscriptionRef'].') Successed For Order Ref #'.$payment_info['order_number'];
			}else{
				//staging
				$to_email = 'nikit@intricaretech.com';
				$email_subject = 'STAGING TEST - '.Yii::$app->params['emailFromName'].' - Manual Subscription Renewal (#'.$payment_info['GETSubscriptionRef'].') Successed For Order Ref #'.$payment_info['order_number'];
			}
		
		$html = $this->renderPartial('/../mail/renewedpaymentsuccessedAddOnPackExclusiveOrder', ['value' => $payment_info,'fullname'=>$payment_info['ses_full_name'],'responseGetJson'=>$payment_info['responseGetJson']]);

			$mail = Yii::$app->mailer->compose()
			->setTo($to_email)
			->setFrom([Yii::$app->params['adminEmail']=>Yii::$app->params['emailFromName'].' Payments'])
			->setSubject($email_subject)
			->setHtmlBody($html,'text/html');
			$mail->send();
	}

	 public function recurringFailedPayment($payment_info){
		$email = $payment_info['ses_email'];
		
		$html = $this->renderPartial('/../mail/recurringpaymentfailed', ['value' => $payment_info,'fullname'=>$payment_info['ses_full_name'],'responseGetJson'=>$payment_info['responseGetJson']]);

			if (YII_ENV_PROD) {
				//production
				$to_email = ['nikit@intricaretech.com'];
				$email_subject = Yii::$app->params['emailFromName'].' - Recurring Installment Failed For Order Ref #'.$payment_info['order_number'];
			}else{
				//staging
				$to_email = 'nikit@intricaretech.com';
				$email_subject = 'STAGING TEST - '.Yii::$app->params['emailFromName'].' - Recurring Installment Failed For Order Ref #'.$payment_info['order_number'];
			}

			$mail = Yii::$app->mailer->compose()
			->setTo($to_email)
			//->setBcc(['binita@intricare.net'])
			//->setFrom(['payments@intricare.net'=>Yii::$app->params['emailFromName'].' Payments'])
			//->setFrom(['arpan@intricare.net'=>Yii::$app->params['emailFromName'].' Payments'])
			->setFrom([Yii::$app->params['adminEmail']=>Yii::$app->params['emailFromName'].' Payments'])
			//->setReplyTo()
			->setSubject($email_subject)
			->setHtmlBody($html,'text/html');
			$mail->send();
	}

	//28-06-2021
	 public function recurringFailedPaymentAddOnPackProduct($payment_info){
		$email = $payment_info['ses_email'];
		
		$html = $this->renderPartial('/../mail/recurringpaymentfailedAddOnPackProduct', ['value' => $payment_info,'fullname'=>$payment_info['ses_full_name'],'responseGetJson'=>$payment_info['responseGetJson']]);

			if (YII_ENV_PROD) {
				//production
				$to_email = ['nikit@intricaretech.com'];
				$email_subject = Yii::$app->params['emailFromName'].' - Recurring Installment Failed For Order Ref #'.$payment_info['order_number'];
			}else{
				//staging
				$to_email = 'nikit@intricaretech.com';
				$email_subject = 'STAGING TEST - '.Yii::$app->params['emailFromName'].' - Recurring Installment Failed For Order Ref #'.$payment_info['order_number'];
			}

			$mail = Yii::$app->mailer->compose()
			->setTo($to_email)
			->setFrom([Yii::$app->params['adminEmail']=>Yii::$app->params['emailFromName'].' Payments'])
			->setSubject($email_subject)
			->setHtmlBody($html,'text/html');
			$mail->send();
	}
	

	//14July2020 created
    public function actionBillingInformation() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

		if(Yii::$app->params['portal_url']=='https://app.cloudkennect.com'){
			$url = \Yii::$app->request->baseUrl."/dashboard";
			return $this->redirect($url);
		}
		
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }
		/*
		if(Yii::$app->session->get('userid') != Yii::$app->session->get('teamid')){
			return $this->redirect(['my-template/pricing']);
		}
		*/
		


        $userDetail = Yii::$app->db->createCommand("select  t1.*, t2.name as plan_name from user t1 LEFT JOIN lead_plans t2 ON t1.sublevel = t2.sublevel where t1.id =" . Yii::$app->session->get('userid'))->queryOne();
		
        $SubuserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid'))->queryAll();

		//$lastUserPaymentHistory = Yii::$app->db->createCommand("select  *  from  user_payment_history  where userid =" . Yii::$app->session->get('userid')." and status='success' order by id DESC")->queryOne();
		//$getMyLatestSubscription = Yii::$app->db->createCommand("select * from user_order_products where 2coSubscriptionStatus IS NOT NULL AND FIND_IN_SET (".Yii::$app->session->get('userid').",user_ids) ORDER BY id DESC")->queryOne();
		$getMyLatestSubscription = Yii::$app->mycomponent->get_latest_subscription(Yii::$app->session->get('userid'));

        return $this->render('billing_information', [
					'message' => '',
                    'userDetail' => $userDetail,
                    'SubuserDetail' => $SubuserDetail,
                    'getMyLatestSubscription' => $getMyLatestSubscription,
        ]);
    }

    public function actionBillingInformation_nrtesting() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

		if(Yii::$app->params['portal_url']=='https://app.cloudkennect.com'){
			$url = \Yii::$app->request->baseUrl."/dashboard";
			return $this->redirect($url);
		}
		
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }
		/*
		if(Yii::$app->session->get('userid') != Yii::$app->session->get('teamid')){
			return $this->redirect(['my-template/pricing']);
		}
		*/
		


        $userDetail = Yii::$app->db->createCommand("select  t1.*, t2.name as plan_name from user t1 LEFT JOIN lead_plans t2 ON t1.sublevel = t2.sublevel where t1.id =" . Yii::$app->session->get('userid'))->queryOne();
		
        $SubuserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid'))->queryAll();

		//$lastUserPaymentHistory = Yii::$app->db->createCommand("select  *  from  user_payment_history  where userid =" . Yii::$app->session->get('userid')." and status='success' order by id DESC")->queryOne();
		//$getMyLatestSubscription = Yii::$app->db->createCommand("select * from user_order_products where 2coSubscriptionStatus IS NOT NULL AND FIND_IN_SET (".Yii::$app->session->get('userid').",user_ids) ORDER BY id DESC")->queryOne();
		$getMyLatestSubscription = Yii::$app->mycomponent->get_latest_subscription(Yii::$app->session->get('userid'));

        return $this->render('billing_information_nrtesting', [
					'message' => '',
                    'userDetail' => $userDetail,
                    'SubuserDetail' => $SubuserDetail,
                    'getMyLatestSubscription' => $getMyLatestSubscription,
        ]);
    }	
	
	//05-May-2021: test page as per new plans.
    public function actionBillingInformation_new() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

		if(Yii::$app->params['portal_url']=='https://app.cloudkennect.com'){
			$url = \Yii::$app->request->baseUrl."/dashboard";
			return $this->redirect($url);
		}
		
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }
		/*
		if(Yii::$app->session->get('userid') != Yii::$app->session->get('teamid')){
			return $this->redirect(['my-template/pricing']);
		}
		*/
		


        $userDetail = Yii::$app->db->createCommand("select  t1.*, t2.name as plan_name from user t1 LEFT JOIN lead_plans t2 ON t1.sublevel = t2.sublevel where t1.id =" . Yii::$app->session->get('userid'))->queryOne();
		
        $SubuserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid'))->queryAll();

		//$lastUserPaymentHistory = Yii::$app->db->createCommand("select  *  from  user_payment_history  where userid =" . Yii::$app->session->get('userid')." and status='success' order by id DESC")->queryOne();
		//$getMyLatestSubscription = Yii::$app->db->createCommand("select * from user_order_products where 2coSubscriptionStatus IS NOT NULL AND FIND_IN_SET (".Yii::$app->session->get('userid').",user_ids) ORDER BY id DESC")->queryOne();
		$getMyLatestSubscription = Yii::$app->mycomponent->get_latest_subscription(Yii::$app->session->get('userid'));

        return $this->render('billing_information_new', [
					'message' => '',
                    'userDetail' => $userDetail,
                    'SubuserDetail' => $SubuserDetail,
                    'getMyLatestSubscription' => $getMyLatestSubscription,
        ]);
    }	
	
	//14July2020 created
    public function actionBillingHistory() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		if(Yii::$app->params['portal_url']=='https://app.cloudkennect.com'){
			$url = \Yii::$app->request->baseUrl."/dashboard";
			return $this->redirect($url);
		}
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }
		if(Yii::$app->session->get('userid') != Yii::$app->session->get('teamid')){
			return $this->redirect(['my-template/pricing']);
		}

        $userDetail = Yii::$app->db->createCommand("select  *  from  user  where id =" . Yii::$app->session->get('userid'))->queryOne();
		
        //$userPaymentHistory = Yii::$app->db->createCommand("select  *  from  user_payment_history  where userid =" . Yii::$app->session->get('userid')." and status='success' and ordertype IN(0,1,2,4) order by id DESC")->queryAll();
		
		$userPaymentHistory = Yii::$app->db->createCommand("select  *  from  user_payment_history  where userid IN (SELECT id FROM user WHERE teamid=".Yii::$app->session->get('userid').") and status='success' and ordertype IN(0,1,2,4) order by id DESC")->queryAll();
		
		//21-02-2022 starts
		$QuickbookInvoiceLink_curlResult = false;
		$curl_OrderNumberArr = false;
		if(!empty($userPaymentHistory)){
			$orderNumberArr = array_column($userPaymentHistory, 'order_number');
			$orderNumbersString = implode(',',$orderNumberArr);
			
			if(!empty($userDetail) && $userDetail['2coCustomerReference']>0){
				$postFields = array("twoCoOrderReferences" => $orderNumbersString);

				if (YII_ENV_PROD) {
					//production
					$curl_url = "https://app.leadconnect.io/QBOConceptsTutorial-PHP/api_GetUserOrders.php";
				}else{
					//staging
					$curl_url = "https://nikit.intricare.net/leadconnect-backend/basic/QBOConceptsTutorial-PHP/api_GetUserOrders.php";
				}

				$curl = curl_init();
				curl_setopt_array($curl, array(
					CURLOPT_URL => $curl_url,
					CURLOPT_RETURNTRANSFER => true,
					CURLOPT_ENCODING => "",
					CURLOPT_MAXREDIRS => 10,
					CURLOPT_TIMEOUT => 0,
					CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
					CURLOPT_CUSTOMREQUEST => "POST",
					CURLOPT_POSTFIELDS => $postFields,
					CURLOPT_HTTPHEADER => array(
						"Accept: application/json"
					)
				));
				//"Content-Type: application/json",
				
				$curlres = curl_exec($curl);
				$curlHttpStatus = curl_getinfo($curl, CURLINFO_HTTP_CODE);
				curl_close($curl);
				
				if($curlHttpStatus==200){
					$curl_res = json_decode($curlres);
					if($curl_res->success==1){
						$QuickbookInvoiceLink_curlResult = $curl_res->success_data;
						//echo '<br/>dFDFD:<pre>';print_r($QuickbookInvoiceLink_curlResult);echo '</pre>';
						
						$curl_OrderNumberArr = array_column($QuickbookInvoiceLink_curlResult, 'order_ref');
						//echo '<br/>curl_OrderNumberArr:<pre>';print_r($curl_OrderNumberArr);echo '</pre>';
					}					
				}
			}
		}
		//21-02-2022 ends

        return $this->render('billing_history', [
					'message' => '',
                    'userDetail' => $userDetail,
                    'userPaymentHistory' => $userPaymentHistory,
                    'QuickbookInvoiceLink_curlResult' => $QuickbookInvoiceLink_curlResult,
                    'curl_OrderNumberArr' => $curl_OrderNumberArr,
        ]);
    }

	
	//NR: This Method is in use. DO NOT REMOVE; It upgrades plan for new multiproduct structure;
	public function actionUpgradeplan(){

	
		if(!Yii::$app->session->get('useremail')){
           $url = \Yii::$app->request->baseUrl."/login";
           return $this->redirect($url);
        }
		if(Yii::$app->params['portal_url']=='https://app.cloudkennect.com'){
			$url = \Yii::$app->request->baseUrl."/dashboard";
			return $this->redirect($url);
		}
		//echo '<pre>'; print_r($_POST);die;

		extract($_POST);
		
		$time = new \DateTime('now');
		//$today = $time->format('Y-m-d');
		$timestamp = $time->getTimestamp();
		
		$merchant_order_id = 'Lf_'.$timestamp.'_'.substr(Yii::$app->security->generateRandomString(),0,15);
		
		//echo '<pre>';print_r($_REQUEST);die;
		
		if(!isset($product_id) || ($product_id!='LFPM' && $product_id!='LFGM' && $product_id!='LFUM' && $product_id!='LFPQ' && $product_id!='LFGQ' && $product_id!='LFUQ' && $product_id!='LFPSAR' && $product_id!='LFGSAR' && $product_id!='LFUSAR' && $product_id!='LFPA' && $product_id!='LFGA' && $product_id!='LFUA' )){
			return $this->redirect(['my-template/pricing']);
		}
		
		/*
		if(!isset($product_id) || ($product_id!='LFGM_v2' && $product_id!='LFUM_v2' && $product_id!='LFGSAR_v2' && $product_id!='LFUSAR_v2' && $product_id!='LFGA_v2' && $product_id!='LFUA_v2' )){
			return $this->redirect(['my-template/pricing']);
		}
		*/
		
		//$uph_row = Yii::$app->db->createCommand("SELECT * FROM user_payment_history WHERE id=".$uph_id." and userid =".Yii::$app->session->get('userid'))->queryOne();
		$uph_row = Yii::$app->db->createCommand("SELECT t1.*,t2.2coCustomerReference FROM user_order_products t1 JOIN user_payment_history t2 ON t1.uph_id=t2.id WHERE t1.id=".$uop_id." and t2.userid =".Yii::$app->session->get('userid'))->queryOne();
		//echo '<pre>';print_r($uph_row);die;
		if(empty($uph_row)){
			return $this->redirect(['my-template/pricing']);
		}else{
			$uids = explode(',',$uph_row['user_ids']);
			$quantity = count($uids);
			
			if($merchant_order_id=='' || !isset($uop_id) || !isset($quantity) || !isset($product_id) ){
				 return $this->redirect(['my-template/pricing']);
			}else{

				$selPlanUsrArr=array();
				$selPlanUsrArr[$product_id]=$uids;
				//echo '<br/><pre>'; print_r($selPlanUsrArr);die;
				$userinfo = array('merchant_order_id'=>$merchant_order_id,'email'=>Yii::$app->session->get('useremail'),'username'=>Yii::$app->session->get('username'),'user_id'=>Yii::$app->session->get('userid'));
				
				$this->initPayment($_POST,$userinfo,array('selPlanUsrArr'=>$selPlanUsrArr));
				$userinfo = json_encode($userinfo);

				$command =Yii::$app->db->createCommand("INSERT INTO user_payment_history (`userid`,`merchant_id`,`user_info`,`status`,`user_ids`,`2coCustomerReference`,`ordertype`) VALUES ('".Yii::$app->session->get('userid')."','".$merchant_order_id."','".$userinfo."','Initialize','".$uph_row['user_ids']."','".$uph_row['2coCustomerReference']."','1')");
				$command->execute();
				$lastuphid = Yii::$app->db->getLastInsertID();
				
				//2coCustomerReference is inserted from here because its not available in orderdetail api & also not available in webhook ins;
				Yii::$app->db->createCommand("INSERT INTO user_order_products SET uph_id=".$lastuphid.", product_id='".$product_id."', user_ids='".$uph_row['user_ids']."' ")->execute();
				
				//Yii::$app->db->createCommand("UPDATE user_payment_history SET upgradeStatus=1, upgraded_uphid=".$lastuphid." where id=".$uop_id)->execute();
				Yii::$app->db->createCommand("UPDATE user_order_products SET upgradeStatus=1, upgraded_uphid=".$lastuphid." where id=".$uop_id)->execute();
				/*
				//$recurrence_plan_array = array('0'=>'2 Week','LFPM'=>'1 Month','LFPQ'=>'3 Month','LFGM'=>'1 Month','LFGQ'=>'3 Month','LFUM'=>'1 Month','LFUQ'=>'3 Month');
				//$recurrence_plan = $recurrence_plan_array[$product_id];
				$product_name_array = array('LFPM'=>'Professional Monthly','LFPQ'=>'Professional Quarterly','LFGM'=>'Grow Monthly','LFGQ'=>'Grow Quarterly','LFUM'=>'Ultimate Monthly','LFUQ'=>'Ultimate Quarterly','LFUP'=>'Ultimate Plus',
				'LFPSAR'=>'Professional Semi-Annually',
				'LFPA'=>'Professional Annually',
				'LFGSAR'=>'Grow Semi-Annually',
				'LFGA'=>'Grow Annually',
				'LFUSAR'=>'Ultimate Semi-Annually',
				'LFUA'=>'Ultimate Annually'
				);
				$product_name = $product_name_array[$product_id];
				*/
				if (YII_ENV_PROD) {
					//production
					$twocheckout_product_id = array('LFPM'=>'31350945','LFPQ'=>'31351063','LFGM'=>'31350988','LFGQ'=>'31351042','LFUM'=>'31350996','LFUQ'=>'31351018',
					'LFPSAR'=>'33325070',
					'LFPA'=>'33325107',
					'LFGSAR'=>'33325123',
					'LFGA'=>'33325138',
					'LFUSAR'=>'33325166',
					'LFUA'=>'33325182',
					'LFGM_v2'=>'xxxxxxx',
					'LFUM_v2'=>'xxxxxxx',
					'LFGSAR_v2'=>'xxxxxxx',
					'LFUSAR_v2'=>'xxxxxxx',
					'LFGA_v2'=>'xxxxxxx',
					'LFUA_v2'=>'xxxxxxx'
					);
					$merchantCode = "203537015";
					$key = 'd?q4rkG]&KAh#vwnmSJ%';
				}else{
					//staging
					$twocheckout_product_id = array('LFPM'=>'36147949','LFPQ'=>'36147960','LFGM'=>'36149087','LFGQ'=>'36149119','LFUM'=>'36147991','LFUQ'=>'36148018',
					'LFPSAR'=>'36147691',
					'LFPA'=>'36147674',
					'LFGSAR'=>'36147637',
					'LFGA'=>'36147479',
					'LFUSAR'=>'36147811',
					'LFUA'=>'36147799',
					'LFGM_v2'=>'36149191',
					'LFUM_v2'=>'36149373',
					'LFGSAR_v2'=>'36149635',
					'LFUSAR_v2'=>'36149813',
					'LFGA_v2'=>'36149895',
					'LFUA_v2'=>'36150064'
					);//new product ids in 2checkout panel
					$merchantCode = "251108887711";
					$key = '!G2S8WRBKJ6#&c~luOz=';
				}				
				
				$twocheckout_product_id = $twocheckout_product_id[$product_id];
				
				//Upgrade a subscription starts
				$SubscriptionReference = $uph_row['SubscriptionReference'];
				
				$gmdate = gmdate('Y-m-d H:i:s');
				$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
				$hashAlgorithm = 'sha256';
				$hash = hash_hmac($hashAlgorithm , $string, $key);
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, "https://api.2checkout.com/rest/6.0/subscriptions/".$SubscriptionReference."/upgrade/");
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_HEADER, FALSE);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");

				$headers = array();
				$headers[] = 'Accept: application/json';
				$headers[] = 'Content-Type: application/json';
				$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				curl_setopt($ch, CURLOPT_POSTFIELDS, "{
				  \"ProductCode\": \"$product_id\",
				  \"Quantity\": \"$quantity\",
				  \"ExternalRef\": \"$merchant_order_id\"
				}");

				$curl_result = curl_exec($ch);//return 1 if success;
				//echo '::DD:<pre>';print_r($curl_result);echo '</pre>';
				//$info = curl_getinfo($ch);
				$curlResult = json_decode($curl_result);
				
				if (curl_errno($ch)) {
					//$curl_error_msg = curl_error($ch);
				}
				curl_close($ch);
				
				if(isset($curlResult->error_code)){
					Yii::$app->db->createCommand("UPDATE user_order_products SET upgradeStatus=0, upgraded_uphid=0 where id=".$uop_id)->execute();
					Yii::$app->db->createCommand("UPDATE user_order_products SET error_response='".$curl_result."' where uph_id=".$lastuphid)->execute();
					echo json_encode(array('success'=>0,'message'=>'Upgrade Failed.'));
				}else if($curl_result){
					echo json_encode(array('success'=>1,'merchant_order_id'=>$merchant_order_id,'twocheckout_product_id'=>$twocheckout_product_id,'selUserIds'=>$uph_row['user_ids']));
				}else{
					echo json_encode(array('success'=>0,'message'=>'Upgrade Failed...'));
				}					
				
				//Upgrade a subscription ends

				
			}

		}


		
		
	}
	

	//NR: This Method is in use. DO NOT REMOVE; 
	public function actionCancelsubscription(){

		
		if(!Yii::$app->session->get('useremail')){
           $url = \Yii::$app->request->baseUrl."/login";
           return $this->redirect($url);
        }
		if(Yii::$app->params['portal_url']=='https://app.cloudkennect.com'){
			$url = \Yii::$app->request->baseUrl."/dashboard";
			return $this->redirect($url);
		}
		//echo '<pre>'; print_r($_POST);die;
		
		extract($_POST);

		if(!isset($uop_id) || !isset($subscriptionRef)){
			return $this->redirect(['my-template/pricing']);
		}
		
		$uph_row = Yii::$app->db->createCommand("SELECT t1.*,t2.2coCustomerReference FROM user_order_products t1 JOIN user_payment_history t2 ON t1.uph_id=t2.id WHERE t1.id=".$uop_id." and t1.SubscriptionReference='".$subscriptionRef."' and t2.userid =".Yii::$app->session->get('userid'))->queryOne();
		//echo '<pre>';print_r($uph_row);die;
		if(empty($uph_row)){
			echo json_encode(array('success'=>0,'message'=>'Invalid Subscription Reference'));
		}else{
			

				//Disable a subscription starts
				if (YII_ENV_PROD) {
					//production
					$merchantCode = "203537015";
					$key = 'd?q4rkG]&KAh#vwnmSJ%';
				}else{
					//staging
					$merchantCode = "251108887711";
					$key = '!G2S8WRBKJ6#&c~luOz=';
				}
				$SubscriptionReference = $uph_row['SubscriptionReference'];
				
				//$SubscriptionReference = '7B9CB649A3';
				//$SubscriptionReference = 'C741CFF993';
				//$SubscriptionReference = '707727F3B1';Billing cycle expiration: Sep 14, 2020
				
				
				
				$gmdate = gmdate('Y-m-d H:i:s');
				$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
				$hashAlgorithm = 'sha256';
				$hash = hash_hmac($hashAlgorithm , $string, $key);
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, "https://api.2checkout.com/rest/6.0/subscriptions/".$SubscriptionReference."/");
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_HEADER, FALSE);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");

				$headers = array();
				$headers[] = 'Accept: application/json';
				$headers[] = 'Content-Type: application/json';
				$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

				$curl_result = curl_exec($ch);//return 1 if success;
				//$info = curl_getinfo($ch);
				$curlResult = json_decode($curl_result);
				
				if (curl_errno($ch)) {
					//$curl_error_msg = curl_error($ch);
				}
				curl_close($ch);
				
				if(isset($curlResult->error_code)){
					Yii::$app->db->createCommand("UPDATE user_order_products SET cancelSubscrErrorResponse='".$curl_result."' where id=".$uop_id)->execute();
					
					if(isset($curlResult->message)){
						$errmsg = $curlResult->message;
					}else{
						$errmsg = 'Your request for cancelling subscription is failed.';
					}
					echo json_encode(array('success'=>0,'message'=>$errmsg));
				}else if($curl_result){
					Yii::$app->db->createCommand("UPDATE user_order_products SET cancelSubscrStatus=1 where id=".$uop_id)->execute();
					echo json_encode(array('success'=>1,'message'=>'success'));
				}else{
					echo json_encode(array('success'=>0,'message'=>'Your request for cancelling subscription is failed...'));
				}				
		}
	}

	//NR: testing: (its calling frequently) this is created to check whether it is called when customer cancel the subscription;
	public function actionWebhookInsWhenInvoiceStatusChanged(){
		
		//email starts
		//if(isset($_POST['md5_hash'])){
			$html = json_encode($_POST,JSON_PRETTY_PRINT);
		//}else{
			//$html = 'this email called from https://nikit.intricare.net/cloud_theme/basic/web/securepayment/webhook-ins-when-new-order-created';
		//}

			if (YII_ENV_PROD) {
				//production
				$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - Webhook INS Called When Invoice Status Changed";
			}else{
				//staging
				$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - Webhook INS Called When Invoice Status Changed";
			}
		
		$mail = Yii::$app->mailer->compose()
				->setTo('nikit@intricaretech.com')
				//->setBcc('ronit@leadconnect.io')
				//->setFrom([Yii::$app->params['adminEmail'] => Yii::$app->params['emailFromName'].' | You have been Invited'])
				->setFrom(Yii::$app->params['adminEmail'])
				//->setReplyTo()
				->setSubject($email_subject)
				->setHtmlBody($html, 'text/html');
		$mail->send();
		//email ends
		

	}
	
	//NR: testing: (its calling frequently) this is created to check whether it is called when customer cancel the subscription;
	public function actionWebhookIpnCanceledOrders(){
		if(isset($_POST['HASH'])){
			
		
			//email starts
			//if(isset($_POST['md5_hash'])){
				$html = json_encode($_POST,JSON_PRETTY_PRINT);
			//}else{
				//$html = 'this email called from https://nikit.intricare.net/cloud_theme/basic/web/securepayment/webhook-ins-when-new-order-created';
			//}

				if (YII_ENV_PROD) {
					//production
					$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - Webhook Ipn Canceled Orders";
				}else{
					//staging
					$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - Webhook Ipn Canceled Orders";
				}
			
			$mail = Yii::$app->mailer->compose()
					->setTo('nikit@intricaretech.com')
					//->setBcc('ronit@leadconnect.io')
					//->setFrom([Yii::$app->params['adminEmail'] => Yii::$app->params['emailFromName'].' | You have been Invited'])
					->setFrom(Yii::$app->params['adminEmail'])
					//->setReplyTo()
					->setSubject($email_subject)
					->setHtmlBody($html, 'text/html');
			$mail->send();
			//email ends
		}
	}




	//NR: Unused. DO NOT REMOVE; When single subscription is renewed successfully this method was fine. but, for whole order that contain multiple subscriptions, this method was unable to handle it.
	public function actionWebhookInsWhenRecurringInstallmentSuccess_OldOrigForSingleSubscription(){
		die;
		//When Recurring Installment is Successed then 2checkout create new order (It will not create New subscription). The previous subscription (on which the recurring successed) will remain as an ACTIVE.
		
		//Order reference #129682361 (Renewal Order) Order no: 174
		//Order reference #129751387 (Test) Order no: 170 :- this origianl order contains total 2 subscription. Among which subscription #518F85CB32 is renewed that cause 2 below calls due to it was containg 2 qty. ie. LFPM x 2
 		/*
		{ "sale_id": "250448661039", "sale_date_placed": "2020-08-06 08:05:39", "recurring": "1", "payment_type": "credit card", "list_currency": "USD", "order_ref": "129682361", "order_no": "174", "vendor_id": "251108887711", "vendor_order_id": "1596636838_hHPphDsC8901Hz2", "invoice_id": "250449393203", "item_count": "1", "customer_first_name": "NRSTAGING", "customer_last_name": "Test", "customer_name": "John Doe", "customer_email": "nikit@intricaretech.com", "customer_phone": "", "customer_ip": "127.0.0.1", "cust_currency": "USD", "bill_city": "N\/A", "bill_country": "GBR", "bill_postal_code": "123456", "bill_state": "", "bill_street_address": "N\/A", "bill_street_address2": "", "ship_status": "", "ship_tracking_number": "", "ship_name": "Test NRSTAGING", "ship_street_address": "N\/A", "ship_street_address2": "", "ship_city": "N\/A", "ship_state": "", "ship_postal_code": "123456", "ship_country": "GBR", "message_id": "301", "message_type": "RECURRING_INSTALLMENT_SUCCESS", "message_description": "Recurring installment successfully billed", "timestamp": "2020-08-06 08:05:44 EEST", "item_name_1": "Professional Monthly", "item_id_1": "", "item_list_amount_1": "65.95", "item_usd_amount_1": "65.95", "item_cust_amount_1": "65.95", "item_type_1": "bill", "item_duration_1": "Forever", "item_recurrence_1": "7 Day", "item_rec_list_amount_1": "65.95", "item_rec_status_1": "live", "item_rec_date_next_1": "2020-08-19", "item_rec_install_billed_1": "1", "md5_hash": "7CE627F2605159E7C348C37F529EF189", "key_count": "51" }
		
		{ "sale_id": "250448661039", "sale_date_placed": "2020-08-06 08:05:39", "recurring": "1", "payment_type": "credit card", "list_currency": "USD", "order_ref": "129682361", "order_no": "174", "vendor_id": "251108887711", "vendor_order_id": "1596636838_hHPphDsC8901Hz2", "invoice_id": "250449393203", "item_count": "1", "customer_first_name": "NRSTAGING", "customer_last_name": "Test", "customer_name": "John Doe", "customer_email": "nikit@intricaretech.com", "customer_phone": "", "customer_ip": "127.0.0.1", "cust_currency": "USD", "bill_city": "N\/A", "bill_country": "GBR", "bill_postal_code": "123456", "bill_state": "", "bill_street_address": "N\/A", "bill_street_address2": "", "ship_status": "", "ship_tracking_number": "", "ship_name": "Test NRSTAGING", "ship_street_address": "N\/A", "ship_street_address2": "", "ship_city": "N\/A", "ship_state": "", "ship_postal_code": "123456", "ship_country": "GBR", "message_id": "302", "message_type": "RECURRING_INSTALLMENT_SUCCESS", "message_description": "Recurring installment successfully billed", "timestamp": "2020-08-06 08:05:44 EEST", "item_name_1": "Professional Monthly", "item_id_1": "", "item_list_amount_1": "65.95", "item_usd_amount_1": "65.95", "item_cust_amount_1": "65.95", "item_type_1": "bill", "item_duration_1": "Forever", "item_recurrence_1": "7 Day", "item_rec_list_amount_1": "65.95", "item_rec_status_1": "live", "item_rec_date_next_1": "2020-08-19", "item_rec_install_billed_1": "1", "md5_hash": "7CE627F2605159E7C348C37F529EF189", "key_count": "51" }
		*/
		
		
		echo '<pre>'; print_r($_POST);echo '</pre>';
		
		$order_number = $_POST['order_ref'];//this is newly inserted order's reference number;
		
		$uphOrderExist_row = Yii::$app->db->createCommand("select id from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
		if(!empty($uphOrderExist_row)){
			//if order is already exists nothing happen;
			//NR: when subscription licence is renewed and if it has more than 1 Qty (of product), this ipn method will call that nuber of times.
		}else{

			//$_POST['vendor_order_id'] eg:1595940629_Oix6SlusxWWmMY3
			if(isset($_POST['vendor_order_id']) && $_POST['vendor_order_id']!='' && isset($_POST['message_type']) && $_POST['message_type']=='RECURRING_INSTALLMENT_SUCCESS'){
			

				if (YII_ENV_PROD) {
					//production
					$merchantCode = "203537015";
					$key = 'd?q4rkG]&KAh#vwnmSJ%';
				}else{
					//staging
					$merchantCode = "251108887711";// your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
					$key = '!G2S8WRBKJ6#&c~luOz=';// your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
				}

				$gmdate = gmdate('Y-m-d H:i:s');
				$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
				$hashAlgorithm = 'sha256';
				$hash = hash_hmac($hashAlgorithm , $string, $key);
				
				$OrderReferenceNumber = $_POST['order_ref'];
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

				$headers = array();
				$headers[] = 'Accept: application/json';
				$headers[] = 'Content-Type: application/json';
				$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				$curl_result = curl_exec($ch);
				
				$curlResult = json_decode($curl_result);
				echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
				if (curl_errno($ch)) {
					//echo 'Error:' . curl_error($ch);
				}
				curl_close($ch);
				
				$responseGetJson = json_encode($_POST);
				$responseOrderJson = $curl_result;
				
				
				
				$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id; it is blank here;
				
				$twoCo_CustomerReference = 0;
				if(isset($curlResult->CustomerDetails->CustomerReference)){
					//CustomerDetails not exits here
					$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference; 
				}


				$uph_row = Yii::$app->db->createCommand("select t1.id, t1.userid,t1.2coCustomerReference, t2.email, t2.username, t2.first_name, t2.last_name from user_payment_history t1 JOIN user t2 ON t1.userid=t2.id where t1.merchant_id='".$_POST['vendor_order_id']."' ORDER BY t1.id DESC")->queryOne();
				if(!empty($uph_row)){
					echo '<br/>uph_row:<br/><pre>'; print_r($uph_row);echo '</pre>';
					$uph_pkid = $uph_row['id'];
					
					$user_infoArr = array();
					$user_infoArr['merchant_order_id'] = $merchant_order_id;//it is blank here;
					$user_infoArr['email'] = $uph_row['email'];
					$user_infoArr['username'] = $uph_row['username'];
					$user_infoArr['user_id'] = $uph_row['userid'];
					
					if($twoCo_CustomerReference==0){
						$twoCo_CustomerReference = $uph_row['2coCustomerReference'];
					}
					
					$sql_moi='merchant_id='.$merchant_order_id;
					if($merchant_order_id==''){
						$sql_moi='merchant_id=NULL';
					}

					$uphOrderExist_row = Yii::$app->db->createCommand("select id from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
					if(!empty($uphOrderExist_row)){
						
					}else{
						
						//new order insert entry //user_ids=''
						Yii::$app->db->createCommand('INSERT INTO user_payment_history SET userid='.$uph_row['userid'].', order_number = "'.$order_number.'", '.$sql_moi.', user_info = "'.addslashes(json_encode($user_infoArr)).'" , status="Success", complete_date = "'.date("Y-m-d H:i:s").'", 2coCustomerReference = "'.$twoCo_CustomerReference.'",ordertype=2')->execute();
						$lastuphid = Yii::$app->db->getLastInsertID();
						
						Yii::$app->db->createCommand("UPDATE `user_payment_history` SET `response_get` = '".addslashes($responseGetJson)."', `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$lastuphid)->execute(); 
						
						
						$selPlanUsrArr=array();
						$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7');
						
						$fullplanname_array = array('Free'=>'Free','Professional Monthly'=>'LFPM','Professional Quarterly'=>'LFPQ','Grow Monthly'=>'LFGM','Grow Quarterly'=>'LFGQ','Ultimate Monthly'=>'LFUM','Ultimate Quarterly'=>'LFUQ','Ultimate Plus'=>'LFUP');
				
						$Items = $curlResult->Items;
						
						foreach($Items as $item_key=>$item_res){
			
							//$_POST['item_name_1'] : getting only 1 item_name here. there is no item_name_2 or further found as of now;
							if($item_res->Code==$fullplanname_array[$_POST['item_name_1']]){
								
							
								$product_id = $item_res->Code;//this is product code eg: LCPM
								$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
								$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
								$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
								$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
								
								$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
								
								
								$upo_row = Yii::$app->db->createCommand("select id,user_ids from user_order_products where uph_id =".$uph_pkid." AND product_id='".$product_id."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
								
								if(!empty($upo_row)){
									$upo_user_ids = $upo_row['user_ids'];
									
									//SubscriptionStartDate = "'.$SubscriptionStartDate.'",2coSubscriptionStatus="ACTIVE"
									Yii::$app->db->createCommand('UPDATE user_order_products SET ExpirationDate = "'.$ExpirationDate.'" WHERE id='.$upo_row['id'])->execute();
									
									Yii::$app->db->createCommand("UPDATE `user_payment_history` SET user_ids = '".$upo_user_ids."' where id =".$lastuphid)->execute();
									
									
									$lfaf_seat_purchased_useridsArr = array();
									$lfaf_seat_purchased_useridsArr[$product_id] = explode(',',$upo_user_ids);
			

									//$uidsStrPerProduct = $upo_user_ids;
									$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
									
									
									//starts
									$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus');
									$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
									foreach($userIdArr as $uid){
										
										$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
										$previous_plan = $usrcommand['sublevel'];
										$isTrial = $usrcommand['trial'];
										
										$previous_plan = $previous_plan_array[$previous_plan];
										
										$current_plan = $previous_plan_array[$current_user_setting_plan];
										
										$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
										$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
										$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
										$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
										$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
									}
									//trial_expired_at = "'.$ExpirationDateTimestamp.'"
									Yii::$app->db->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
									//ends
									
									$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$uph_row['email'],'ses_full_name'=>$uph_row['first_name'].' '.$uph_row['last_name'],'responseGetJson'=> $responseGetJson);
									$this->recurringSuccessedPayment($payment_info);
									echo '<br/>ends';
									
								}			

							}
						}
					}
					
				}
				
				
				
			}

		}
		
		
		//email starts
		//if(isset($_POST['md5_hash'])){
			$html = json_encode($_POST,JSON_PRETTY_PRINT);
		//}else{
			//$html = 'this email called from https://nikit.intricare.net/cloud_theme/basic/web/securepayment/webhook-ins-when-new-order-created';
		//}

			if (YII_ENV_PROD) {
				//production
				$to_email = ['nikit@intricaretech.com'];//'arpan@intricare.net',
				$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - Webhook INS Called When Recurring Installment Success";
			}else{
				//staging
				$to_email = 'nikit@intricaretech.com';
				$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - Webhook INS Called When Recurring Installment Success";
			}
		
		$mail = Yii::$app->mailer->compose()
				->setTo($to_email)
				//->setBcc('ronit@leadconnect.io')
				//->setFrom([Yii::$app->params['adminEmail'] => Yii::$app->params['emailFromName'].' | You have been Invited'])
				->setFrom(Yii::$app->params['adminEmail'])
				//->setReplyTo()
				->setSubject($email_subject)
				->setHtmlBody($html, 'text/html');
		$mail->send();
		//email ends		
		
	}



	//NR: In use. DO NOT REMOVE; Use: When (single subscription is renewed) OR (whole order renewed which contains mutliple subscriptions) successfully then it should be handled here.
	public function actionWebhookInsWhenRecurringInstallmentSuccess(){
		
		//When Recurring Installment is Successed then 2checkout create new order (It will not create New subscription). The previous subscription (on which the recurring successed) will remain as an ACTIVE.
		
		//Order reference #129682361 (Renewal Order) Order no: 174
		//Order reference #129751387 (Test) Order no: 170 :- this origianl order contains total 2 subscription. Among which subscription #518F85CB32 is renewed that cause 2 below calls due to it was containg 2 qty. ie. LFPM x 2
 		/*
		{ "sale_id": "250448661039", "sale_date_placed": "2020-08-06 08:05:39", "recurring": "1", "payment_type": "credit card", "list_currency": "USD", "order_ref": "129682361", "order_no": "174", "vendor_id": "251108887711", "vendor_order_id": "1596636838_hHPphDsC8901Hz2", "invoice_id": "250449393203", "item_count": "1", "customer_first_name": "NRSTAGING", "customer_last_name": "Test", "customer_name": "John Doe", "customer_email": "nikit@intricaretech.com", "customer_phone": "", "customer_ip": "127.0.0.1", "cust_currency": "USD", "bill_city": "N\/A", "bill_country": "GBR", "bill_postal_code": "123456", "bill_state": "", "bill_street_address": "N\/A", "bill_street_address2": "", "ship_status": "", "ship_tracking_number": "", "ship_name": "Test NRSTAGING", "ship_street_address": "N\/A", "ship_street_address2": "", "ship_city": "N\/A", "ship_state": "", "ship_postal_code": "123456", "ship_country": "GBR", "message_id": "301", "message_type": "RECURRING_INSTALLMENT_SUCCESS", "message_description": "Recurring installment successfully billed", "timestamp": "2020-08-06 08:05:44 EEST", "item_name_1": "Professional Monthly", "item_id_1": "", "item_list_amount_1": "65.95", "item_usd_amount_1": "65.95", "item_cust_amount_1": "65.95", "item_type_1": "bill", "item_duration_1": "Forever", "item_recurrence_1": "7 Day", "item_rec_list_amount_1": "65.95", "item_rec_status_1": "live", "item_rec_date_next_1": "2020-08-19", "item_rec_install_billed_1": "1", "md5_hash": "7CE627F2605159E7C348C37F529EF189", "key_count": "51" }
		
		{ "sale_id": "250448661039", "sale_date_placed": "2020-08-06 08:05:39", "recurring": "1", "payment_type": "credit card", "list_currency": "USD", "order_ref": "129682361", "order_no": "174", "vendor_id": "251108887711", "vendor_order_id": "1596636838_hHPphDsC8901Hz2", "invoice_id": "250449393203", "item_count": "1", "customer_first_name": "NRSTAGING", "customer_last_name": "Test", "customer_name": "John Doe", "customer_email": "nikit@intricaretech.com", "customer_phone": "", "customer_ip": "127.0.0.1", "cust_currency": "USD", "bill_city": "N\/A", "bill_country": "GBR", "bill_postal_code": "123456", "bill_state": "", "bill_street_address": "N\/A", "bill_street_address2": "", "ship_status": "", "ship_tracking_number": "", "ship_name": "Test NRSTAGING", "ship_street_address": "N\/A", "ship_street_address2": "", "ship_city": "N\/A", "ship_state": "", "ship_postal_code": "123456", "ship_country": "GBR", "message_id": "302", "message_type": "RECURRING_INSTALLMENT_SUCCESS", "message_description": "Recurring installment successfully billed", "timestamp": "2020-08-06 08:05:44 EEST", "item_name_1": "Professional Monthly", "item_id_1": "", "item_list_amount_1": "65.95", "item_usd_amount_1": "65.95", "item_cust_amount_1": "65.95", "item_type_1": "bill", "item_duration_1": "Forever", "item_recurrence_1": "7 Day", "item_rec_list_amount_1": "65.95", "item_rec_status_1": "live", "item_rec_date_next_1": "2020-08-19", "item_rec_install_billed_1": "1", "md5_hash": "7CE627F2605159E7C348C37F529EF189", "key_count": "51" }
		*/
		

		//test email code starts
		$html = json_encode($_POST,JSON_PRETTY_PRINT);
		if (YII_ENV_PROD) {
			//production
			$to_email = 'nikit@intricaretech.com';
			$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - Webhook INS Called When Recurring Installment Success";
		}else{
			//staging
			$to_email = 'nikit@intricaretech.com';
			$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - Webhook INS Called When Recurring Installment Success";
		}
	
		$mail = Yii::$app->mailer->compose()
				->setTo($to_email)
				->setFrom(Yii::$app->params['adminEmail'])
				->setSubject($email_subject)
				->setHtmlBody($html, 'text/html');
		$mail->send();
		//test email code ends

		echo '<pre>'; print_r($_POST);echo '</pre>';
		
		$order_number = $_POST['order_ref'];//this is newly inserted order's reference number;
		
		//$uphOrderExist_row = Yii::$app->db->createCommand("select id from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
		//if(!empty($uphOrderExist_row)){
			//if order is already exists nothing happen;
			//NR: when subscription licence is renewed and if it has more than 1 Qty (of product), this ins method will call that number of times.
		//}else{

			//$_POST['vendor_order_id'] eg:1595940629_Oix6SlusxWWmMY3
			if(isset($_POST['vendor_order_id']) && $_POST['vendor_order_id']!='' && isset($_POST['message_type']) && $_POST['message_type']=='RECURRING_INSTALLMENT_SUCCESS'){
			

				if (YII_ENV_PROD) {
					//production
					$merchantCode = "203537015";
					$key = 'd?q4rkG]&KAh#vwnmSJ%';
				}else{
					//staging
					$merchantCode = "251108887711";// your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
					$key = '!G2S8WRBKJ6#&c~luOz=';// your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
				}

				$gmdate = gmdate('Y-m-d H:i:s');
				$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
				$hashAlgorithm = 'sha256';
				$hash = hash_hmac($hashAlgorithm , $string, $key);
				
				$OrderReferenceNumber = $_POST['order_ref'];
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

				$headers = array();
				$headers[] = 'Accept: application/json';
				$headers[] = 'Content-Type: application/json';
				$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				$curl_result = curl_exec($ch);
				
				$curlResult = json_decode($curl_result);
				echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
				if (curl_errno($ch)) {
					//echo 'Error:' . curl_error($ch);
				}
				curl_close($ch);
				
				$responseGetJson = json_encode($_POST);
				$responseOrderJson = $curl_result;
				
				
				
				$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id; it is blank here;
				
				$twoCo_CustomerReference = 0;
				if(isset($curlResult->CustomerDetails->CustomerReference)){
					//CustomerDetails not exits here
					$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference; 
				}


				$uph_row = Yii::$app->db->createCommand("select t1.id, t1.userid,t1.2coCustomerReference, t2.email, t2.username, t2.first_name, t2.last_name from user_payment_history t1 JOIN user t2 ON t1.userid=t2.id where t1.merchant_id='".$_POST['vendor_order_id']."' ORDER BY t1.id DESC")->queryOne();
				if(!empty($uph_row)){
					echo '<br/>uph_row:<br/><pre>'; print_r($uph_row);echo '</pre>';
					$uph_pkid = $uph_row['id'];
					
					$user_infoArr = array();
					$user_infoArr['merchant_order_id'] = $merchant_order_id;//it is blank here;
					$user_infoArr['email'] = $uph_row['email'];
					$user_infoArr['username'] = $uph_row['username'];
					$user_infoArr['user_id'] = $uph_row['userid'];
					
					if($twoCo_CustomerReference==0){
						$twoCo_CustomerReference = $uph_row['2coCustomerReference'];
					}
					
					// $sql_moi='merchant_id='.$merchant_order_id; //commented on 20-11-2023 due to error in insert qry when it has value.
					$sql_moi='merchant_id="'.$merchant_order_id.'"';
					if($merchant_order_id==''){
						$sql_moi='merchant_id=NULL';
					}
					
					// sleep for 5 seconds
					sleep(5);
					
					$uphOrderExist_row = Yii::$app->db->createCommand("select id,user_ids from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
					if(!empty($uphOrderExist_row)){
						$lastuphid = $uphOrderExist_row['id'];
					}else{
						
						$uphOrderExist_row = Yii::$app->db->createCommand("select id,user_ids from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
						if(!empty($uphOrderExist_row)){
							$lastuphid = $uphOrderExist_row['id'];
						}else{
							//new order insert entry //user_ids=''
							Yii::$app->db->createCommand('INSERT INTO user_payment_history SET userid='.$uph_row['userid'].', order_number = "'.$order_number.'", '.$sql_moi.', user_info = "'.addslashes(json_encode($user_infoArr)).'" , status="Success", complete_date = "'.date("Y-m-d H:i:s").'", 2coCustomerReference = "'.$twoCo_CustomerReference.'",ordertype=2')->execute();
							$lastuphid = Yii::$app->db->getLastInsertID();
							
							Yii::$app->db->createCommand("UPDATE `user_payment_history` SET `response_get` = '".addslashes($responseGetJson)."', `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$lastuphid)->execute(); 							
						}
					}

						
						
						$selPlanUsrArr=array();
						$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7',
						'LFPSAR'=>'8',
						'LFPA'=>'9',
						'LFGSAR'=>'10',
						'LFGA'=>'11',
						'LFUSAR'=>'12',
						'LFUA'=>'13',
						'LFGM_v2'=>'18',
						'LFUM_v2'=>'19',
						'LFGSAR_v2'=>'20',
						'LFUSAR_v2'=>'21',
						'LFGA_v2'=>'22',
						'LFUA_v2'=>'23'
						);
						/*
						$fullplanname_array = array('Free'=>'Free','Professional Monthly'=>'LFPM','Professional Quarterly'=>'LFPQ','Grow Monthly'=>'LFGM','Grow Quarterly'=>'LFGQ','Ultimate Monthly'=>'LFUM','Ultimate Quarterly'=>'LFUQ','Ultimate Plus'=>'LFUP',
						'Professional Semi-Annually'=>'LFPSAR',
						'Professional Annually'=>'LFPA',
						'Grow Semi-Annually'=>'LFGSAR',
						'Grow Annually'=>'LFGA',
						'Ultimate Semi-Annually'=>'LFUSAR',
						'Ultimate Annually'=>'LFUA'
						);
						*/
				
						$Items = $curlResult->Items;
						
						foreach($Items as $item_key=>$item_res){
			
							//$_POST['item_name_1'] : getting only 1 item_name here. there is no item_name_2 or further found as of now;
								//if($item_res->Code==$fullplanname_array[$_POST['item_name_1']])
								//04-11-2020: above condition commented, modified as below condition;
							if($item_res->Code==$_POST['item_id_1']){
								
							
								$product_id = $item_res->Code;//this is product code eg: LCPM
								$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
								$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
								$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
								$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
								
								if($product_id=='LFAddOnPack'){
									//for AddOnPackProduct
								}else{
								$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
								}
								
								$upo_row = Yii::$app->db->createCommand("select id,user_ids from user_order_products where uph_id =".$uph_pkid." AND product_id='".$product_id."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
								
								if(!empty($upo_row)){
									$upo_user_ids = $upo_row['user_ids'];
									
									//SubscriptionStartDate = "'.$SubscriptionStartDate.'"
									Yii::$app->db->createCommand('UPDATE user_order_products SET ExpirationDate = "'.$ExpirationDate.'", 2coSubscriptionStatus="ACTIVE" WHERE id='.$upo_row['id'])->execute();
									
									if(isset($uphOrderExist_row['id'])){
										$previousSubscriptionUserIDs = explode(',',$uphOrderExist_row['user_ids']);
										
										$currentSubscriptionUserIDs = $upo_user_ids;
										$currentSubscriptionUserIDs = explode(',',$currentSubscriptionUserIDs);
										
										$allUserIDs = array_unique(array_merge($previousSubscriptionUserIDs, $currentSubscriptionUserIDs));
										$allUserIDs = implode(',',$allUserIDs);
										
									}else{
										$allUserIDs = $upo_user_ids;
									}

									//17-02-2021 code starts
									//echo '<br/>'.$allUserIDs[0];
									//echo '<br/>'.substr($allUserIDs, 1);
									if($allUserIDs[0]==','){
										$html='first char comma found:<br/>Old value:'.$allUserIDs;
										//$allUserIDs = substr($allUserIDs, 1);
										//$html.='<br/>New value:'.$allUserIDs;

											if (YII_ENV_PROD) {
												//production
												$to_email = ['nikit@intricaretech.com'];
												$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - Webhook INS Recurring Installment Success first char comma found";
											}else{
												//staging
												$to_email = 'nikit@intricaretech.com';
												$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - Webhook INS Recurring Installment Success first char comma found";
											}
											
											$mail = Yii::$app->mailer->compose()
													->setTo($to_email)
													->setFrom(Yii::$app->params['adminEmail'])
													->setSubject($email_subject)
													->setHtmlBody($html, 'text/html');
											$mail->send();

									}
									//echo '<br/>DD2:'.$allUserIDs;

									//17-02-2021 code ends									
									
									
									Yii::$app->db->createCommand("UPDATE `user_payment_history` SET user_ids = '".$allUserIDs."' where id =".$lastuphid)->execute();
									
									
									$lfaf_seat_purchased_useridsArr = array();
									$lfaf_seat_purchased_useridsArr[$product_id] = explode(',',$upo_user_ids);
			

									//$uidsStrPerProduct = $upo_user_ids;
									$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
									
									
									//starts
									$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus',
									'8'=>'Professional Semi-Annually',
									'9'=>'Professional Annually',
									'10'=>'Grow Semi-Annually',
									'11'=>'Grow Annually',
									'12'=>'Ultimate Semi-Annually',
									'13'=>'Ultimate Annually',
									'14'=>'New Grow Monthly',
									'15'=>'New Grow Annual',
									'16'=>'New Ultimate Monthly',
									'17'=>'New Ultimate Annual',
									'18'=>'Grow Monthly',
									'19'=>'Ultimate Monthly',
									'20'=>'Grow Semi-Annually',
									'21'=>'Ultimate Semi-Annually',
									'22'=>'Grow Annually',
									'23'=>'Ultimate Annually'
									);
									$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
									foreach($userIdArr as $uid){
										
										$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
										$previous_plan = $usrcommand['sublevel'];
										$isTrial = $usrcommand['trial'];
										
										$previous_plan = $previous_plan_array[$previous_plan];
										
										if($product_id=='LFAddOnPack'){
											//for AddOnPackProduct
											$current_plan = $product_id;
										}else{
										$current_plan = $previous_plan_array[$current_user_setting_plan];
										}
										
										$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
										$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
										$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
										$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
										$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
									}
									
									if($product_id=='LFAddOnPack'){
										//for AddOnPackProduct
										Yii::$app->db->createCommand('UPDATE user SET is_booster="1", isBoosterOnTrial = 0, cancelBoosterSub = 0, boosterSubscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
										
									}else if($product_id=='LFUM_v2' || $product_id=='LFUSAR_v2' || $product_id=='LFUA_v2' || $product_id=="LFUM" || $product_id=="LFUQ" || $product_id=="LFUSAR" || $product_id=="LFUA"){
										//for above plans, booster pack is free.
										
										Yii::$app->db->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'", is_booster="1", isBoosterOnTrial = 0, cancelBoosterSub = 0, boosterSubscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
									}else{
										//trial_expired_at = "'.$ExpirationDateTimestamp.'"
										Yii::$app->db->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
									}
									//ends
									
									$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$uph_row['email'],'ses_full_name'=>$uph_row['first_name'].' '.$uph_row['last_name'],'responseGetJson'=> $responseGetJson);
									if($product_id=='LFAddOnPack'){
										//for AddOnPackProduct
										$this->recurringSuccessedPaymentAddOnPackProduct($payment_info);
									}else{
									$this->recurringSuccessedPayment($payment_info);
									}
									echo '<br/>ends';


									$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
									if(empty($uos_row)){
										Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
									}
									
								}
							}
						}
					
					
				}
				
				
				
			}

		//}
		
		

		
	}
	
	




	//NR: Unused. DO NOT REMOVE;  Usage: When single subscription is renewed successfully this method was fine. but, for whole order that contain multiple subscriptions, this method was unable to handle it.
	public function actionWebhookInsWhenRecurringInstallmentFailed_OldOrigForSingleSubscription(){
		die;



		//In 2checkout test mode, to call this method, the previous order should have card name "Mike Doe" or "Jenny Doe".
		//for more info: https://knowledgecenter.2checkout.com/Documentation/09Test_ordering_system/01Test_payment_methods
		
		//Order reference #129982142 (Renewal Order) Order no: N/A Order status: UNFINISHED
		//Order no: 182 Order reference #130030854 Card Name: Mike Doe :- this origianl order contains total 2 subscription. Among which subscription #56F0CEEF71 is renewed that cause 2 below calls due to it was containg 2 qty. ie. LFPM x 2
 		/*
		{ "sale_id": "250450767314", "sale_date_placed": "2020-08-07 09:11:50", "recurring": "1", "payment_type": "credit card", "list_currency": "USD", "order_ref": "129982142", "order_no": "0", "vendor_id": "251108887711", "vendor_order_id": "1596779952_hEbTzkPmTErRlIK", "invoice_id": "250450776068", "item_count": "1", "customer_first_name": "NRSTAGING", "customer_last_name": "Test", "customer_name": "Mike Doe", "customer_email": "nikit@intricaretech.com", "customer_phone": "", "customer_ip": "127.0.0.1", "cust_currency": "USD", "bill_city": "N\/A", "bill_country": "GBR", "bill_postal_code": "123456", "bill_state": "", "bill_street_address": "N\/A", "bill_street_address2": "", "ship_status": "", "ship_tracking_number": "", "ship_name": "Test NRSTAGING", "ship_street_address": "N\/A", "ship_street_address2": "", "ship_city": "N\/A", "ship_state": "", "ship_postal_code": "123456", "ship_country": "GBR", "message_id": "336", "message_type": "RECURRING_INSTALLMENT_FAILED", "message_description": "Recurring installment failed to bill", "timestamp": "2020-08-07 09:11:53 EEST", "item_name_1": "Professional Monthly", "item_id_1": "", "item_list_amount_1": "65.95", "item_usd_amount_1": "65.95", "item_cust_amount_1": "65.95", "item_type_1": "bill", "item_duration_1": "Forever", "item_recurrence_1": "7 Day", "item_rec_list_amount_1": "65.95", "item_rec_status_1": "live", "item_rec_date_next_1": "2020-08-14", "item_rec_install_billed_1": "1", "md5_hash": "E2734E31FF6DD1120555284C99AB2325", "key_count": "51" }
		
		{ "sale_id": "250450767314", "sale_date_placed": "2020-08-07 09:11:50", "recurring": "1", "payment_type": "credit card", "list_currency": "USD", "order_ref": "129982142", "order_no": "0", "vendor_id": "251108887711", "vendor_order_id": "1596779952_hEbTzkPmTErRlIK", "invoice_id": "250450776068", "item_count": "1", "customer_first_name": "NRSTAGING", "customer_last_name": "Test", "customer_name": "Mike Doe", "customer_email": "nikit@intricaretech.com", "customer_phone": "", "customer_ip": "127.0.0.1", "cust_currency": "USD", "bill_city": "N\/A", "bill_country": "GBR", "bill_postal_code": "123456", "bill_state": "", "bill_street_address": "N\/A", "bill_street_address2": "", "ship_status": "", "ship_tracking_number": "", "ship_name": "Test NRSTAGING", "ship_street_address": "N\/A", "ship_street_address2": "", "ship_city": "N\/A", "ship_state": "", "ship_postal_code": "123456", "ship_country": "GBR", "message_id": "335", "message_type": "RECURRING_INSTALLMENT_FAILED", "message_description": "Recurring installment failed to bill", "timestamp": "2020-08-07 09:11:53 EEST", "item_name_1": "Professional Monthly", "item_id_1": "", "item_list_amount_1": "65.95", "item_usd_amount_1": "65.95", "item_cust_amount_1": "65.95", "item_type_1": "bill", "item_duration_1": "Forever", "item_recurrence_1": "7 Day", "item_rec_list_amount_1": "65.95", "item_rec_status_1": "live", "item_rec_date_next_1": "2020-08-14", "item_rec_install_billed_1": "1", "md5_hash": "E2734E31FF6DD1120555284C99AB2325", "key_count": "51" }
		*/
		
		
		echo '<pre>'; print_r($_POST);echo '</pre>';
		
		$order_number = $_POST['order_ref'];//this is newly inserted order's reference number;
		
		$uphOrderExist_row = Yii::$app->db->createCommand("select id from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
		if(!empty($uphOrderExist_row)){
			//if order is already exists nothing happen;
			//NR: when subscription licence is renewed and if it has more than 1 Qty (of product), this ipn method will call that number of times. so, prevented here;
		}else{

			//$_POST['vendor_order_id'] eg:1596779952_hEbTzkPmTErRlIK
			if(isset($_POST['vendor_order_id']) && $_POST['vendor_order_id']!='' && isset($_POST['message_type']) && $_POST['message_type']=='RECURRING_INSTALLMENT_FAILED'){
			

				if (YII_ENV_PROD) {
					//production
					$merchantCode = "203537015";
					$key = 'd?q4rkG]&KAh#vwnmSJ%';
				}else{
					//staging
					$merchantCode = "251108887711";// your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
					$key = '!G2S8WRBKJ6#&c~luOz=';// your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
				}

				$gmdate = gmdate('Y-m-d H:i:s');
				$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
				$hashAlgorithm = 'sha256';
				$hash = hash_hmac($hashAlgorithm , $string, $key);
				
				$OrderReferenceNumber = $_POST['order_ref'];
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

				$headers = array();
				$headers[] = 'Accept: application/json';
				$headers[] = 'Content-Type: application/json';
				$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				$curl_result = curl_exec($ch);
				
				$curlResult = json_decode($curl_result);
				echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
				if (curl_errno($ch)) {
					//echo 'Error:' . curl_error($ch);
				}
				curl_close($ch);
				
				$responseGetJson = json_encode($_POST);
				$responseOrderJson = $curl_result;
				
				//die;
				
				$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id; it is blank here;
				
				$twoCo_CustomerReference = 0;
				if(isset($curlResult->CustomerDetails->CustomerReference)){
					//CustomerDetails not exits here
					$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference; 
				}


				$uph_row = Yii::$app->db->createCommand("select t1.id,t1.order_number, t1.userid,t1.2coCustomerReference, t2.email, t2.username, t2.first_name, t2.last_name from user_payment_history t1 JOIN user t2 ON t1.userid=t2.id where t1.merchant_id='".$_POST['vendor_order_id']."' ORDER BY t1.id DESC")->queryOne();
				if(!empty($uph_row)){
					
					echo '<br/>uph_row:<br/><pre>'; print_r($uph_row);echo '</pre>';
					
					$uph_pkid = $uph_row['id'];
					
					$user_infoArr = array();
					$user_infoArr['merchant_order_id'] = $merchant_order_id;//it is blank here;
					$user_infoArr['email'] = $uph_row['email'];
					$user_infoArr['username'] = $uph_row['username'];
					$user_infoArr['user_id'] = $uph_row['userid'];
					
					if($twoCo_CustomerReference==0){
						$twoCo_CustomerReference = $uph_row['2coCustomerReference'];
					}
					
					$sql_moi='merchant_id='.$merchant_order_id;
					if($merchant_order_id==''){
						$sql_moi='merchant_id=NULL';
					}

					$uphOrderExist_row = Yii::$app->db->createCommand("select id from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
					if(!empty($uphOrderExist_row)){
						
					}else{
						
						//new order insert entry //user_ids=''
						Yii::$app->db->createCommand('INSERT INTO user_payment_history SET userid='.$uph_row['userid'].', order_number = "'.$order_number.'", '.$sql_moi.', user_info = "'.addslashes(json_encode($user_infoArr)).'" , status="Failed", complete_date = "'.date("Y-m-d H:i:s").'", 2coCustomerReference = "'.$twoCo_CustomerReference.'",ordertype=3')->execute();
						$lastuphid = Yii::$app->db->getLastInsertID();

						Yii::$app->db->createCommand("UPDATE `user_payment_history` SET `response_get` = '".addslashes($responseGetJson)."', `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$lastuphid)->execute();


						
						/*
						//with below "previous order" code also, unable to detect subscription licence whose "Recurring Installment Failed"
						//getting SubscriptionReference from previous order starts
							//echo '<br/>order_number::'.$uph_row['order_number'];die;
							$PreviousOrderReferenceNumber = $uph_row['order_number'];
							$ch = curl_init();
							curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$PreviousOrderReferenceNumber.'/');
							curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
							curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

							$headers = array();
							$headers[] = 'Accept: application/json';
							$headers[] = 'Content-Type: application/json';
							$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
							curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
							$po_curl_result = curl_exec($ch);
							
							$po_curlResult = json_decode($po_curl_result);
							echo '<br/>res:<pre>'; print_r($po_curlResult);echo '</pre>';
							if (curl_errno($ch)) {
								//echo 'Error:' . curl_error($ch);
							}
							curl_close($ch);
							$po_Items = $po_curlResult->Items;
							foreach($po_Items as $item_key=>$item_res){
								
							}
						//getting SubscriptionReference from previous order ends
						*/



						
						$selPlanUsrArr=array();
						$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7');
						
						$fullplanname_array = array('Free'=>'Free','Professional Monthly'=>'LFPM','Professional Quarterly'=>'LFPQ','Grow Monthly'=>'LFGM','Grow Quarterly'=>'LFGQ','Ultimate Monthly'=>'LFUM','Ultimate Quarterly'=>'LFUQ','Ultimate Plus'=>'LFUP');

						$Items = $curlResult->Items;
						
						foreach($Items as $item_key=>$item_res){
			
							//$_POST['item_name_1'] : getting only 1 item_name here. there is no item_name_2 or further found as of now;
							if($item_res->Code==$fullplanname_array[$_POST['item_name_1']]){
								
							
								$product_id = $item_res->Code;//this is product code eg: LCPM
								
								//this ProductDetails's Subscriptions data will not exits
								//$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
								//$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
								//$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
								//$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;

								
								
								
								$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
								
								//$upo_row = Yii::$app->db->createCommand("select id,user_ids from user_order_products where uph_id =".$uph_pkid." AND product_id='".$product_id."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
								$upo_row = Yii::$app->db->createCommand("select id,user_ids from user_order_products where uph_id =".$uph_pkid." AND product_id='".$product_id."'   ORDER BY id DESC")->queryOne();
								
								if(!empty($upo_row)){
									$upo_user_ids = $upo_row['user_ids'];
									
									//SubscriptionStartDate = "'.$SubscriptionStartDate.'",2coSubscriptionStatus="ACTIVE"
									//Yii::$app->db->createCommand('UPDATE user_order_products SET ExpirationDate = "'.$ExpirationDate.'" WHERE id='.$upo_row['id'])->execute();
									
									Yii::$app->db->createCommand("UPDATE `user_payment_history` SET user_ids = '".$upo_user_ids."' where id =".$lastuphid)->execute();
									
									$lfaf_seat_purchased_useridsArr = array();
									$lfaf_seat_purchased_useridsArr[$product_id] = explode(',',$upo_user_ids);
			

									//$uidsStrPerProduct = $upo_user_ids;
									$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
									
									
									//starts
									$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus');
									$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
									foreach($userIdArr as $uid){
										
										$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
										$previous_plan = $usrcommand['sublevel'];
										$isTrial = $usrcommand['trial'];
										
										$previous_plan = $previous_plan_array[$previous_plan];
										
										$current_plan = $previous_plan_array[$current_user_setting_plan];
										
										$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
										$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
										$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
										$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
										$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
									}
									
									echo '<br/> qry: UPDATE user SET sublevel = "0" , trial = 1 WHERE id IN ('.$upo_user_ids.')';
									Yii::$app->db->createCommand('UPDATE user SET sublevel = "0" , trial = 1 WHERE id IN ('.$upo_user_ids.')')->execute();
									//ends
									
									$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$uph_row['email'],'ses_full_name'=>$uph_row['first_name'].' '.$uph_row['last_name'],'responseGetJson'=> $responseGetJson);
									$this->recurringFailedPayment($payment_info);
									echo '<br/>ends';
									
								}			

							}
						}
					}
					
				}
				
				
				
			}

		}



	}
	
	//NR: In use. DO NOT REMOVE; Use: When (single subscription is renewed [but failed] OR (whole order renewed [but failed] which contains mutliple subscriptions) then it should be handled here.
	public function actionWebhookInsWhenRecurringInstallmentFailed(){


		//In 2checkout test mode, to call this method, the previous order should have card name "Mike Doe" or "Jenny Doe".
		//for more info: https://knowledgecenter.2checkout.com/Documentation/09Test_ordering_system/01Test_payment_methods
		
		//Order reference #129982142 (Renewal Order) Order no: N/A Order status: UNFINISHED
		//Order no: 182 Order reference #130030854 Card Name: Mike Doe :- this origianl order contains total 2 subscription. Among which subscription #56F0CEEF71 is renewed that cause 2 below calls due to it was containg 2 qty. ie. LFPM x 2
 		/*
		{ "sale_id": "250450767314", "sale_date_placed": "2020-08-07 09:11:50", "recurring": "1", "payment_type": "credit card", "list_currency": "USD", "order_ref": "129982142", "order_no": "0", "vendor_id": "251108887711", "vendor_order_id": "1596779952_hEbTzkPmTErRlIK", "invoice_id": "250450776068", "item_count": "1", "customer_first_name": "NRSTAGING", "customer_last_name": "Test", "customer_name": "Mike Doe", "customer_email": "nikit@intricaretech.com", "customer_phone": "", "customer_ip": "127.0.0.1", "cust_currency": "USD", "bill_city": "N\/A", "bill_country": "GBR", "bill_postal_code": "123456", "bill_state": "", "bill_street_address": "N\/A", "bill_street_address2": "", "ship_status": "", "ship_tracking_number": "", "ship_name": "Test NRSTAGING", "ship_street_address": "N\/A", "ship_street_address2": "", "ship_city": "N\/A", "ship_state": "", "ship_postal_code": "123456", "ship_country": "GBR", "message_id": "336", "message_type": "RECURRING_INSTALLMENT_FAILED", "message_description": "Recurring installment failed to bill", "timestamp": "2020-08-07 09:11:53 EEST", "item_name_1": "Professional Monthly", "item_id_1": "", "item_list_amount_1": "65.95", "item_usd_amount_1": "65.95", "item_cust_amount_1": "65.95", "item_type_1": "bill", "item_duration_1": "Forever", "item_recurrence_1": "7 Day", "item_rec_list_amount_1": "65.95", "item_rec_status_1": "live", "item_rec_date_next_1": "2020-08-14", "item_rec_install_billed_1": "1", "md5_hash": "E2734E31FF6DD1120555284C99AB2325", "key_count": "51" }
		
		{ "sale_id": "250450767314", "sale_date_placed": "2020-08-07 09:11:50", "recurring": "1", "payment_type": "credit card", "list_currency": "USD", "order_ref": "129982142", "order_no": "0", "vendor_id": "251108887711", "vendor_order_id": "1596779952_hEbTzkPmTErRlIK", "invoice_id": "250450776068", "item_count": "1", "customer_first_name": "NRSTAGING", "customer_last_name": "Test", "customer_name": "Mike Doe", "customer_email": "nikit@intricaretech.com", "customer_phone": "", "customer_ip": "127.0.0.1", "cust_currency": "USD", "bill_city": "N\/A", "bill_country": "GBR", "bill_postal_code": "123456", "bill_state": "", "bill_street_address": "N\/A", "bill_street_address2": "", "ship_status": "", "ship_tracking_number": "", "ship_name": "Test NRSTAGING", "ship_street_address": "N\/A", "ship_street_address2": "", "ship_city": "N\/A", "ship_state": "", "ship_postal_code": "123456", "ship_country": "GBR", "message_id": "335", "message_type": "RECURRING_INSTALLMENT_FAILED", "message_description": "Recurring installment failed to bill", "timestamp": "2020-08-07 09:11:53 EEST", "item_name_1": "Professional Monthly", "item_id_1": "", "item_list_amount_1": "65.95", "item_usd_amount_1": "65.95", "item_cust_amount_1": "65.95", "item_type_1": "bill", "item_duration_1": "Forever", "item_recurrence_1": "7 Day", "item_rec_list_amount_1": "65.95", "item_rec_status_1": "live", "item_rec_date_next_1": "2020-08-14", "item_rec_install_billed_1": "1", "md5_hash": "E2734E31FF6DD1120555284C99AB2325", "key_count": "51" }
		*/
		
		
		echo '<pre>'; print_r($_POST);echo '</pre>';
		
		$order_number = $_POST['order_ref'];//this is newly inserted order's reference number;
		/*
		if (YII_ENV_PROD) {
			//production
			//$twocheckout_product_id = array('LFPM'=>'31350945','LFPQ'=>'31351063','LFGM'=>'31350988','LFGQ'=>'31351042','LFUM'=>'31350996','LFUQ'=>'31351018','LFPSAR'=>'33325070','LFPA'=>'33325107','LFGSAR'=>'33325123','LFGA'=>'33325138','LFUSAR'=>'33325166','LFUA'=>'33325182');//ids in 2checkout panel
			$twocheckout_product_idArr = array(31350945,31351063,31350988,31351042,31350996,31351018,33325070,33325107,33325123,33325138,33325166,33325182);//product ids in 2checkout panel
		}else{
			//staging
			//$twocheckout_product_id = array('LFPM'=>'36147949','LFPQ'=>'36147960','LFGM'=>'36149087','LFGQ'=>'36149119','LFUM'=>'36147991','LFUQ'=>'36148018','LFPSAR'=>'36147691','LFPA'=>'36147674','LFGSAR'=>'36147637','LFGA'=>'36147479','LFUSAR'=>'36147811','LFUA'=>'36147799');//ids in 2checkout panel
			$twocheckout_product_idArr = array(36147949,36147960,36149087,36149119,36147991,36148018,36147691,36147674,36147637,36147479,36147811,36147799);
		}
		*/
		//if(isset($_POST['item_id_1']) && in_array($_POST['item_id_1'],$twocheckout_product_idArr)){
			
		//}
		
		//$uphOrderExist_row = Yii::$app->db->createCommand("select id from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
		//if(!empty($uphOrderExist_row)){
			//if order is already exists nothing happen;
			//NR: when subscription licence is renewed and if it has more than 1 Qty (of product), this ipn method will call that number of times. so, prevented here;
		//}else{

			//$_POST['vendor_order_id'] eg:1596779952_hEbTzkPmTErRlIK
			if(isset($_POST['vendor_order_id']) && $_POST['vendor_order_id']!='' && isset($_POST['message_type']) && $_POST['message_type']=='RECURRING_INSTALLMENT_FAILED'){
			

				if (YII_ENV_PROD) {
					//production
					$merchantCode = "203537015";
					$key = 'd?q4rkG]&KAh#vwnmSJ%';
				}else{
					//staging
					$merchantCode = "251108887711";// your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
					$key = '!G2S8WRBKJ6#&c~luOz=';// your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
				}

				$gmdate = gmdate('Y-m-d H:i:s');
				$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
				$hashAlgorithm = 'sha256';
				$hash = hash_hmac($hashAlgorithm , $string, $key);
				
				$OrderReferenceNumber = $_POST['order_ref'];
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

				$headers = array();
				$headers[] = 'Accept: application/json';
				$headers[] = 'Content-Type: application/json';
				$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				$curl_result = curl_exec($ch);
				
				$curlResult = json_decode($curl_result);
				echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
				if (curl_errno($ch)) {
					//echo 'Error:' . curl_error($ch);
				}
				curl_close($ch);
				
				$responseGetJson = json_encode($_POST);
				$responseOrderJson = $curl_result;
				
				//die;
				
				$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id; it is blank here;
				
				$twoCo_CustomerReference = 0;
				if(isset($curlResult->CustomerDetails->CustomerReference)){
					//CustomerDetails not exits here
					$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference; 
				}


				$uph_row = Yii::$app->db->createCommand("select t1.id,t1.order_number, t1.userid,t1.2coCustomerReference, t2.email, t2.username, t2.first_name, t2.last_name from user_payment_history t1 JOIN user t2 ON t1.userid=t2.id where t1.merchant_id='".$_POST['vendor_order_id']."' ORDER BY t1.id DESC")->queryOne();
				if(!empty($uph_row)){
					
					$sendOneTimeEmailToUser = false;
					
					echo '<br/>uph_row:<br/><pre>'; print_r($uph_row);echo '</pre>';
					
					$uph_pkid = $uph_row['id'];
					
					$user_infoArr = array();
					$user_infoArr['merchant_order_id'] = $merchant_order_id;//it is blank here;
					$user_infoArr['email'] = $uph_row['email'];
					$user_infoArr['username'] = $uph_row['username'];
					$user_infoArr['user_id'] = $uph_row['userid'];
					
					if($twoCo_CustomerReference==0){
						$twoCo_CustomerReference = $uph_row['2coCustomerReference'];
					}
					
					// $sql_moi='merchant_id='.$merchant_order_id; //commented on 20-11-2023 due to error in insert qry when it has value.
					$sql_moi='merchant_id="'.$merchant_order_id.'"';
					if($merchant_order_id==''){
						$sql_moi='merchant_id=NULL';
					}

					$uphOrderExist_row = Yii::$app->db->createCommand("select id,user_ids from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
					if(!empty($uphOrderExist_row)){
						$lastuphid = $uphOrderExist_row['id'];
					}else{

						$uphOrderExist_row = Yii::$app->db->createCommand("select id,user_ids from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
						if(!empty($uphOrderExist_row)){
							$lastuphid = $uphOrderExist_row['id'];
						}else{
							
							$sendOneTimeEmailToUser = true;

							//new order insert entry //user_ids=''
							Yii::$app->db->createCommand('INSERT INTO user_payment_history SET userid='.$uph_row['userid'].', order_number = "'.$order_number.'", '.$sql_moi.', user_info = "'.addslashes(json_encode($user_infoArr)).'" , status="Failed", complete_date = "'.date("Y-m-d H:i:s").'", 2coCustomerReference = "'.$twoCo_CustomerReference.'",ordertype=3')->execute();
							$lastuphid = Yii::$app->db->getLastInsertID();

							Yii::$app->db->createCommand("UPDATE `user_payment_history` SET `response_get` = '".addslashes($responseGetJson)."', `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$lastuphid)->execute();
						
						}
					
					}



						
						/*
						//with below "previous order" code also, unable to detect subscription licence whose "Recurring Installment Failed"
						//getting SubscriptionReference from previous order starts
							//echo '<br/>order_number::'.$uph_row['order_number'];die;
							$PreviousOrderReferenceNumber = $uph_row['order_number'];
							$ch = curl_init();
							curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$PreviousOrderReferenceNumber.'/');
							curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
							curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

							$headers = array();
							$headers[] = 'Accept: application/json';
							$headers[] = 'Content-Type: application/json';
							$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
							curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
							$po_curl_result = curl_exec($ch);
							
							$po_curlResult = json_decode($po_curl_result);
							echo '<br/>res:<pre>'; print_r($po_curlResult);echo '</pre>';
							if (curl_errno($ch)) {
								//echo 'Error:' . curl_error($ch);
							}
							curl_close($ch);
							$po_Items = $po_curlResult->Items;
							foreach($po_Items as $item_key=>$item_res){
								
							}
						//getting SubscriptionReference from previous order ends
						*/



						
						$selPlanUsrArr=array();
						$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7',
						'LFPSAR'=>'8',
						'LFPA'=>'9',
						'LFGSAR'=>'10',
						'LFGA'=>'11',
						'LFUSAR'=>'12',
						'LFUA'=>'13',
						'LFGM_v2'=>'18',
						'LFUM_v2'=>'19',
						'LFGSAR_v2'=>'20',
						'LFUSAR_v2'=>'21',
						'LFGA_v2'=>'22',
						'LFUA_v2'=>'23'
						);
						/*
						$fullplanname_array = array('Free'=>'Free','Professional Monthly'=>'LFPM','Professional Quarterly'=>'LFPQ','Grow Monthly'=>'LFGM','Grow Quarterly'=>'LFGQ','Ultimate Monthly'=>'LFUM','Ultimate Quarterly'=>'LFUQ','Ultimate Plus'=>'LFUP',
						'Professional Semi-Annually'=>'LFPSAR',
						'Professional Annually'=>'LFPA',
						'Grow Semi-Annually'=>'LFGSAR',
						'Grow Annually'=>'LFGA',
						'Ultimate Semi-Annually'=>'LFUSAR',
						'Ultimate Annually'=>'LFUA'
						);
						*/

						$Items = $curlResult->Items;
						
						foreach($Items as $item_key=>$item_res){
			
							//$_POST['item_name_1'] : getting only 1 item_name here. there is no item_name_2 or further found as of now;
							//if($item_res->Code==$fullplanname_array[$_POST['item_name_1']])
							//04-11-2020: above condition commented, below condition added;
							if($item_res->Code==$_POST['item_id_1']){
								
							
								$product_id = $item_res->Code;//this is product code eg: LCPM
								
								//this ProductDetails's Subscriptions data will not exits
								//$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
								//$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
								//$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
								//$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;

								
								
								if($product_id=='LFAddOnPack'){
									//for AddOnPackProduct
								}else{
								$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
								}
								//$upo_row = Yii::$app->db->createCommand("select id,user_ids from user_order_products where uph_id =".$uph_pkid." AND product_id='".$product_id."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
								$upo_row = Yii::$app->db->createCommand("select id,user_ids,SubscriptionReference,isRecurringInstallmentFailedEmailSent from user_order_products where uph_id =".$uph_pkid." AND product_id='".$product_id."'   ORDER BY id DESC")->queryOne();
								
								if(!empty($upo_row)){
									$upo_user_ids = $upo_row['user_ids'];
									$upo_SubscriptionReference = $upo_row['SubscriptionReference'];
									
									//06-May-2021 starts
									if($upo_row['isRecurringInstallmentFailedEmailSent']==1){
										$isRecInstaFailedEmailSent = true;
									}else{
										$isRecInstaFailedEmailSent = false;
										//06-May-2021: making 2coSubscriptionStatus = "EXPIRED" here because after 2 days "LCN Subscription Expired" will be called. To prevent that call we are doing "EXPIRED" here.
										Yii::$app->db->createCommand('UPDATE user_order_products SET isRecurringInstallmentFailedEmailSent = 1, 2coSubscriptionStatus = "EXPIRED" WHERE id='.$upo_row['id'])->execute();
									}
									//06-May-2021 ends
									
									//SubscriptionStartDate = "'.$SubscriptionStartDate.'",2coSubscriptionStatus="ACTIVE"
									//Yii::$app->db->createCommand('UPDATE user_order_products SET ExpirationDate = "'.$ExpirationDate.'" WHERE id='.$upo_row['id'])->execute();
									
									//Yii::$app->db->createCommand("UPDATE `user_payment_history` SET user_ids = '".$upo_user_ids."' where id =".$lastuphid)->execute();
									
									if(isset($uphOrderExist_row['id'])){
										$previousSubscriptionUserIDs = explode(',',$uphOrderExist_row['user_ids']);
										
										$currentSubscriptionUserIDs = $upo_user_ids;
										$currentSubscriptionUserIDs = explode(',',$currentSubscriptionUserIDs);
										
										$allUserIDs = array_unique(array_merge($previousSubscriptionUserIDs, $currentSubscriptionUserIDs));
										$allUserIDs = implode(',',$allUserIDs);
										
									}else{
										$allUserIDs = $upo_user_ids;
									}
									echo '<br/>'."UPDATE `user_payment_history` SET user_ids = '".$allUserIDs."' where id =".$lastuphid;
									Yii::$app->db->createCommand("UPDATE `user_payment_history` SET user_ids = '".$allUserIDs."' where id =".$lastuphid)->execute();
									
									$lfaf_seat_purchased_useridsArr = array();
									$lfaf_seat_purchased_useridsArr[$product_id] = explode(',',$upo_user_ids);
			

									//$uidsStrPerProduct = $upo_user_ids;
									$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
									
									
									//starts
									$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus',
									'8'=>'Professional Semi-Annually',
									'9'=>'Professional Annually',
									'10'=>'Grow Semi-Annually',
									'11'=>'Grow Annually',
									'12'=>'Ultimate Semi-Annually',
									'13'=>'Ultimate Annually',
									'14'=>'New Grow Monthly',
									'15'=>'New Grow Annual',
									'16'=>'New Ultimate Monthly',
									'17'=>'New Ultimate Annual',
									'18'=>'Grow Monthly',
									'19'=>'Ultimate Monthly',
									'20'=>'Grow Semi-Annually',
									'21'=>'Ultimate Semi-Annually',
									'22'=>'Grow Annually',
									'23'=>'Ultimate Annually'
									);
									$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
									foreach($userIdArr as $uid){
										
										$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
										$previous_plan = $usrcommand['sublevel'];
										$isTrial = $usrcommand['trial'];
										
										$previous_plan = $previous_plan_array[$previous_plan];
										if($product_id=='LFAddOnPack'){
											//for AddOnPackProduct
											$current_plan = $product_id;
										}else{
										$current_plan = $previous_plan_array[$current_user_setting_plan];
										}
										$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
										$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
										$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
										$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
										$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
									}
									
									
									
									if($isRecInstaFailedEmailSent==false){
										//above condition added on 06-May-2021

										if($product_id=='LFAddOnPack'){
											//for AddOnPackProduct
											Yii::$app->db->createCommand('UPDATE user SET is_booster="0" WHERE id IN ('.$upo_user_ids.')')->execute();
										}else if($product_id=='LFUM_v2' || $product_id=='LFUSAR_v2' || $product_id=='LFUA_v2' || $product_id=="LFUM" || $product_id=="LFUQ" || $product_id=="LFUSAR" || $product_id=="LFUA"){
											
											Yii::$app->db->createCommand('UPDATE user SET sublevel = "0", is_booster="0" WHERE id IN ('.$upo_user_ids.')')->execute();
										}else{
										
											echo '<br/> qry: UPDATE user SET sublevel = "0" WHERE id IN ('.$upo_user_ids.')';
											//, trial = 1
											Yii::$app->db->createCommand('UPDATE user SET sublevel = "0" WHERE id IN ('.$upo_user_ids.')')->execute();
										}
										//ends
										
										$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$uph_row['email'],'ses_full_name'=>$uph_row['first_name'].' '.$uph_row['last_name'],'responseGetJson'=> $responseGetJson);
										if($product_id=='LFAddOnPack'){
											//for AddOnPackProduct
											$this->recurringFailedPaymentAddOnPackProduct($payment_info);
											
										}else{
										$this->recurringFailedPayment($payment_info);
										}
									}
									echo '<br/>ends';


									$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$upo_SubscriptionReference."' ORDER BY id DESC")->queryOne();
									if(empty($uos_row)){
										Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$upo_SubscriptionReference.'"')->execute();
									}

									//05-May-2021 starts
									if($sendOneTimeEmailToUser==true){
										//Sir:When payment fails and we downgrade account. Need to send email to users also
										
										$getOneSubscribedUserPortal_row = Yii::$app->db->createCommand("select t1.email, t1.portal_id, t2.emailFromName, t2.adminEmail as siteAdminEmail from user t1 JOIN portals t2 ON t1.portal_id = t2.id where t1.id IN (".$upo_user_ids.") ORDER BY t1.id DESC")->queryOne();
										
										$getSubscribedUsers_result = Yii::$app->db->createCommand("select id,email from user where id IN (".$upo_user_ids.") ORDER BY id DESC")->queryAll();
										if(!empty($getSubscribedUsers_result)){
											$subscribeUserEmailArr = array();
											
											foreach($getSubscribedUsers_result as $res){
												$subscribeUserEmailArr[] = $res['email'];
											}

											//email starts
											if($product_id=='LFAddOnPack'){
												//for AddOnPackProduct
												$html = 'Hello,<br/><br/>We are writing this email to let you know that your recent booster pack renewal did not go through. And hence your booster pack has been downgraded.<br/><br/>To continue using our booster pack services please purchase new booster pack subscription.<br/><br/>Thanks,<br/>Team '.$getOneSubscribedUserPortal_row['emailFromName'];
												$emailSubjectTxt = 'Booster Pack';
											}else{
											$html = 'Hello,<br/><br/>We are writing this email to let you know that your recent renewal did not go through. And hence your account has been downgraded.<br/><br/>To continue using our services please purchase new subscription.<br/><br/>Thanks,<br/>Team '.$getOneSubscribedUserPortal_row['emailFromName'];
											$emailSubjectTxt = 'account';
											}
											
											if (YII_ENV_PROD) {
												$email_subject = 'Important <> '.$getOneSubscribedUserPortal_row['emailFromName'].' '.$emailSubjectTxt.' downgraded due to failed payment attempt';
												$to_email = $subscribeUserEmailArr;
												$bcc_email = ['arpan@intricare.net','binita@intricare.net','nikit@intricaretech.com'];
											}else{
												$email_subject = 'STAGING TEST - '.$getOneSubscribedUserPortal_row['emailFromName'].' '.$emailSubjectTxt.' downgraded due to failed payment attempt';
												$to_email = 'nikit@intricaretech.com';
												$bcc_email = 'nikit@intricaretech.com';
											}
											
											if($getOneSubscribedUserPortal_row['portal_id']==2){
												$siteAdminEmail = 'Accounts@linkedfusion.io';
											}else{
												$siteAdminEmail = $getOneSubscribedUserPortal_row['siteAdminEmail'];
											}
											
											$mail = Yii::$app->mailer->compose()
													->setTo($to_email)
													->setBcc($bcc_email)
													->setFrom([$siteAdminEmail=>$getOneSubscribedUserPortal_row['emailFromName'].' Accounts'])
													->setSubject($email_subject)
													->setHtmlBody($html, 'text/html');
											if (YII_ENV_PROD) {
												$mail->send();
											}else{
												$mail->send();
											}
											
											//email ends
											
										}
									}
									//05-May-2021 ends

									
								}

							}
						}
					
					
				}
				
				
				
			}

		//}


		//email starts
		//if(isset($_POST['md5_hash'])){
			$html = json_encode($_POST,JSON_PRETTY_PRINT);
		//}else{
			//$html = 'this email called from https://nikit.intricare.net/cloud_theme/basic/web/securepayment/webhook-ins-when-new-order-created';
		//}

			if (YII_ENV_PROD) {
				//production
				$to_email = ['nikit@intricaretech.com'];//'arpan@intricare.net',
				$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - Webhook INS Called When Recurring Installment Failed";
			}else{
				//staging
				$to_email = 'nikit@intricaretech.com';
				$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - Webhook INS Called When Recurring Installment Failed";
			}
		
		$mail = Yii::$app->mailer->compose()
				->setTo($to_email)
				//->setBcc('ronit@leadconnect.io')
				//->setFrom([Yii::$app->params['adminEmail'] => Yii::$app->params['emailFromName'].' | You have been Invited'])
				->setFrom(Yii::$app->params['adminEmail'])
				//->setReplyTo()
				->setSubject($email_subject)
				->setHtmlBody($html, 'text/html');
		$mail->send();
		//email ends		
		

	}


	//NR: This method is in Use; Do Not Remove; This is my working code for multiproducts in cart;
	public function actionResponse_OldBkpBefore14Oct2020(){
		//This method used 2 times. (1) From our pricing page, when inline 2checkout order is placed at that time, in 2checkout response, it redirected to this method. (2) From customer's 2checkout panel, When customer manually renew a subscription at that time he will be redirected to this method;
		
		//echo '<pre>';print_r($_GET);echo '</pre>';
		
		//echo '<br/><br/>post:<br/>';print_r($_POST);
		//echo '<br/><br/>req:<br/>';print_r($_REQUEST);

		//test email starts
				$html = json_encode($_GET,JSON_PRETTY_PRINT);
				$datetimenow = date('Y-m-d H:i:s');
			if (YII_ENV_PROD) {
				$email_subject = "Linkedfusion Production Server - Response Method Called at ".$datetimenow;
			}else{
				$email_subject = "Linkedfusion Staging Server - Response Method Called at ".$datetimenow;
			}
				$mail = Yii::$app->mailer->compose()
						->setTo('nikit@intricaretech.com')
						->setFrom(Yii::$app->params['adminEmail'])
						->setSubject($email_subject)
						->setHtmlBody($html, 'text/html');
				$mail->send();
		//test email ends

		
		if (YII_ENV_PROD) {
			//production
			$merchantCode = "203537015";
			$key = 'd?q4rkG]&KAh#vwnmSJ%';
		}else{
			//staging
			$merchantCode = "251108887711";// your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
			$key = '!G2S8WRBKJ6#&c~luOz=';// your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
		}

		$gmdate = gmdate('Y-m-d H:i:s');
		$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
		$hashAlgorithm = 'sha256';
		$hash = hash_hmac($hashAlgorithm , $string, $key);
		
		$OrderReferenceNumber = $_GET['refno'];
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

		$headers = array();
		$headers[] = 'Accept: application/json';
		$headers[] = 'Content-Type: application/json';
		$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		$curl_result = curl_exec($ch);
		
		$curlResult = json_decode($curl_result);
		//echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
		if (curl_errno($ch)) {
			//echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);
		//echo '<br/>';
		
		//test email starts
				$html = $curl_result;
				//$datetimenow = date('Y-m-d H:i:s');
			if (YII_ENV_PROD) {
				$email_subject = "Linkedfusion Production Server - Response Method Called at ".$datetimenow;
			}else{
				$email_subject = "Linkedfusion Staging Server - Response Method Called at ".$datetimenow;
			}
				$mail = Yii::$app->mailer->compose()
						->setTo('nikit@intricaretech.com')
						->setFrom(Yii::$app->params['adminEmail'])
						->setSubject($email_subject)
						->setHtmlBody($html, 'text/html');
				$mail->send();
		//test email ends		
		
		$responseGetJson = json_encode($_REQUEST);
		$responseOrderJson = $curl_result;
		//$responseOrderJson = json_decode($curl_result,true);
		//$responseOrderJson = json_encode($responseOrderJson);


		if(isset($_GET['merchant']) && $_GET['merchant']==$merchantCode && isset($_GET['subscription']) && $_GET['subscription']!='' && isset($_GET['signature']) && $_GET['signature']!='' ){
			//From customer's 2checkout panel, When customer manually renew a subscription at that time he will be redirected to this method and this block of code is used to process it further; It may possible that customer is not already logged-in;
			//sample url when it redirects to our website:https://nikit.intricare.net/cloud_theme/basic/web/securepayment/response-working?merchant=251108887711&subscription=56F0CEEF71&refno=129660480&total=131.9&total-currency=USD&signature=1f84b71c22935f8a1e9faed392aa7d1751413891eda27092f5cdccbdec7ee4f7

			/*Olg Orig Code- This code will not wait order to become authorized.
			$response_data = $_GET;
			
			$order_number= $_GET['refno'];//this is order's reference number;
				
			$signature= $_GET['signature'];
			$GETSubscriptionRef = $_GET['subscription'];
			
			//$merchant_order_id= $response_data->merchant_order_id;
			$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;
			
			
			$lfaf_seat_purchased_userids='';
			$addifi = $curlResult->AdditionalFields;
			foreach($addifi as $res){
				if($res->Code=="lfaf_seat_purchased_userids"){
					$lfaf_seat_purchased_userids = $res->Value; //it is blank here
				}
			}


			$twoCo_CustomerReference = 0;
			if(isset($curlResult->CustomerDetails->CustomerReference)){
				//CustomerDetails not exits here
				$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference;
			}
			

			
			$uph_row = Yii::$app->db->createCommand("select t1.id, t1.userid,t1.2coCustomerReference, t2.email, t2.username, t2.first_name, t2.last_name from user_payment_history t1 JOIN user t2 ON t1.userid=t2.id JOIN user_order_products t3 ON t1.id=t3.uph_id where t3.SubscriptionReference='".$GETSubscriptionRef."' ORDER BY t1.id DESC")->queryOne();
			if(!empty($uph_row)){
				//echo '<br/>uph_row:<br/><pre>'; print_r($uph_row);echo '</pre>';
				$uph_pkid = $uph_row['id'];
				
				$user_infoArr = array();
				$user_infoArr['merchant_order_id'] = $merchant_order_id;//it is blank here;
				$user_infoArr['email'] = $uph_row['email'];
				$user_infoArr['username'] = $uph_row['username'];
				$user_infoArr['user_id'] = $uph_row['userid'];
				
				if($twoCo_CustomerReference==0){
					$twoCo_CustomerReference = $uph_row['2coCustomerReference'];
				}
			

				$uphOrderExist_row = Yii::$app->db->createCommand("select id,user_ids from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
				if(!empty($uphOrderExist_row)){
					$lastuphid = $uphOrderExist_row['id'];
				}else{

					$sql_moi='merchant_id='.$merchant_order_id;
					if($merchant_order_id==''){
						$sql_moi='merchant_id=NULL';
					}

					//new order insert entry //user_ids=''
					Yii::$app->db->createCommand('INSERT INTO user_payment_history SET userid='.$uph_row['userid'].', order_number = "'.$order_number.'", '.$sql_moi.', user_info = "'.addslashes(json_encode($user_infoArr)).'" , status="Success", complete_date = "'.date("Y-m-d H:i:s").'", 2coCustomerReference = "'.$twoCo_CustomerReference.'",ordertype=4')->execute();
					$lastuphid = Yii::$app->db->getLastInsertID();
					
					Yii::$app->db->createCommand("UPDATE `user_payment_history` SET `response_get` = '".addslashes($responseGetJson)."', `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$lastuphid)->execute(); 							
				}
				

				$selPlanUsrArr=array();
				$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7');
				
				$fullplanname_array = array('Free'=>'Free','Professional Monthly'=>'LFPM','Professional Quarterly'=>'LFPQ','Grow Monthly'=>'LFGM','Grow Quarterly'=>'LFGQ','Ultimate Monthly'=>'LFUM','Ultimate Quarterly'=>'LFUQ','Ultimate Plus'=>'LFUP');
		
				$Items = $curlResult->Items;				

				foreach($Items as $item_key=>$item_res){
	
					
						$product_id = $item_res->Code;//this is product code eg: LCPM
						$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
						$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
						$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
						$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
						
						$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
						
						if($GETSubscriptionRef==$SubscriptionReference){
							
						
							$upo_row = Yii::$app->db->createCommand("select id,user_ids from user_order_products where uph_id =".$uph_pkid." AND product_id='".$product_id."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
							
							if(!empty($upo_row)){
								$upo_user_ids = $upo_row['user_ids'];
								
								//SubscriptionStartDate = "'.$SubscriptionStartDate.'"
								Yii::$app->db->createCommand('UPDATE user_order_products SET ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE" WHERE id='.$upo_row['id'])->execute();
								
								Yii::$app->db->createCommand("UPDATE `user_payment_history` SET user_ids = '".$upo_user_ids."' where id =".$lastuphid)->execute();
								
								
								$lfaf_seat_purchased_useridsArr = array();
								$lfaf_seat_purchased_useridsArr[$product_id] = explode(',',$upo_user_ids);
		

								//$uidsStrPerProduct = $upo_user_ids;
								$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
								
								
								//starts
								$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus');
								$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
								foreach($userIdArr as $uid){
									
									$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
									$previous_plan = $usrcommand['sublevel'];
									$isTrial = $usrcommand['trial'];
									
									$previous_plan = $previous_plan_array[$previous_plan];
									
									$current_plan = $previous_plan_array[$current_user_setting_plan];
									
									$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
									$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
									$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
									$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
									$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
								}
								//trial_expired_at = "'.$ExpirationDateTimestamp.'"
								Yii::$app->db->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
								//ends
								
								$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$uph_row['email'],'ses_full_name'=>$uph_row['first_name'].' '.$uph_row['last_name'],'responseGetJson'=> $responseGetJson,'GETSubscriptionRef'=>$GETSubscriptionRef);
								$this->renewedSuccessedPayment($payment_info);
								
								
								$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
								if(empty($uos_row)){
									Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
								}
								
								
								Yii::$app->session->set('success_message',"Successfully renewed Subscription #".$GETSubscriptionRef);
								
								
								if(!Yii::$app->session->get('useremail')){
								   $url = \Yii::$app->request->baseUrl."/login";
								   return $this->redirect($url);
								}else{
									return $this->redirect(['my-template/pricing']);
								}
								
							}

						}
				}
				
			}*/

			//30-09-2020 starts
			$response_data = $_GET;
			
			$order_number= $_GET['refno'];//this is order's reference number;
				
			$signature= $_GET['signature'];
			$GETSubscriptionRef = $_GET['subscription'];
			
			//$merchant_order_id= $response_data->merchant_order_id;
			$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;
			
			
			$lfaf_seat_purchased_userids='';
			$addifi = $curlResult->AdditionalFields;
			foreach($addifi as $res){
				if($res->Code=="lfaf_seat_purchased_userids"){
					$lfaf_seat_purchased_userids = $res->Value; //it is blank here
				}
			}


			$twoCo_CustomerReference = 0;
			if(isset($curlResult->CustomerDetails->CustomerReference)){
				//CustomerDetails not exits here
				$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference;
			}
			
			if($curlResult->Status=='COMPLETE' && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK' && 1==2){
				//This code block is not in use. As 2checkout will take some few minutes to authorise the payment. And at this stage above order Status, ApproveStatus and VendorApproveStatus will not be as mentioned in the above condition. So, always it will go in else condition.

				$uph_row = Yii::$app->db->createCommand("select t1.id, t1.userid,t1.2coCustomerReference, t2.email, t2.username, t2.first_name, t2.last_name from user_payment_history t1 JOIN user t2 ON t1.userid=t2.id JOIN user_order_products t3 ON t1.id=t3.uph_id where t3.SubscriptionReference='".$GETSubscriptionRef."' ORDER BY t1.id DESC")->queryOne();
				if(!empty($uph_row)){
					//echo '<br/>uph_row:<br/><pre>'; print_r($uph_row);echo '</pre>';
					$uph_pkid = $uph_row['id'];
					
					$user_infoArr = array();
					$user_infoArr['merchant_order_id'] = $merchant_order_id;//it is blank here;
					$user_infoArr['email'] = $uph_row['email'];
					$user_infoArr['username'] = $uph_row['username'];
					$user_infoArr['user_id'] = $uph_row['userid'];
					
					if($twoCo_CustomerReference==0){
						$twoCo_CustomerReference = $uph_row['2coCustomerReference'];
					}
				

					$uphOrderExist_row = Yii::$app->db->createCommand("select id,user_ids from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
					if(!empty($uphOrderExist_row)){
						$lastuphid = $uphOrderExist_row['id'];
					}else{

						$sql_moi='merchant_id='.$merchant_order_id;
						if($merchant_order_id==''){
							$sql_moi='merchant_id=NULL';
						}

						//new order insert entry //user_ids=''
						Yii::$app->db->createCommand('INSERT INTO user_payment_history SET userid='.$uph_row['userid'].', order_number = "'.$order_number.'", '.$sql_moi.', user_info = "'.addslashes(json_encode($user_infoArr)).'" , status="Success", complete_date = "'.date("Y-m-d H:i:s").'", 2coCustomerReference = "'.$twoCo_CustomerReference.'",ordertype=4')->execute();
						$lastuphid = Yii::$app->db->getLastInsertID();
						
						Yii::$app->db->createCommand("UPDATE `user_payment_history` SET `response_get` = '".addslashes($responseGetJson)."', `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$lastuphid)->execute(); 							
					}
					

					$selPlanUsrArr=array();
					$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7');
					
					$fullplanname_array = array('Free'=>'Free','Professional Monthly'=>'LFPM','Professional Quarterly'=>'LFPQ','Grow Monthly'=>'LFGM','Grow Quarterly'=>'LFGQ','Ultimate Monthly'=>'LFUM','Ultimate Quarterly'=>'LFUQ','Ultimate Plus'=>'LFUP');
			
					$Items = $curlResult->Items;				

					foreach($Items as $item_key=>$item_res){
		
						
							$product_id = $item_res->Code;//this is product code eg: LCPM
							$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
							$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
							$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
							$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
							
							$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
							
							if($GETSubscriptionRef==$SubscriptionReference){
								
							
								$upo_row = Yii::$app->db->createCommand("select id,user_ids from user_order_products where uph_id =".$uph_pkid." AND product_id='".$product_id."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
								
								if(!empty($upo_row)){
									$upo_user_ids = $upo_row['user_ids'];
									
									//SubscriptionStartDate = "'.$SubscriptionStartDate.'"
									Yii::$app->db->createCommand('UPDATE user_order_products SET ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE" WHERE id='.$upo_row['id'])->execute();
									
									Yii::$app->db->createCommand("UPDATE `user_payment_history` SET user_ids = '".$upo_user_ids."' where id =".$lastuphid)->execute();
									
									
									$lfaf_seat_purchased_useridsArr = array();
									$lfaf_seat_purchased_useridsArr[$product_id] = explode(',',$upo_user_ids);
			

									//$uidsStrPerProduct = $upo_user_ids;
									$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
									
									
									//starts
									$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus');
									$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
									foreach($userIdArr as $uid){
										
										$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
										$previous_plan = $usrcommand['sublevel'];
										$isTrial = $usrcommand['trial'];
										
										$previous_plan = $previous_plan_array[$previous_plan];
										
										$current_plan = $previous_plan_array[$current_user_setting_plan];
										
										$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
										$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
										$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
										$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
										$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
									}
									//trial_expired_at = "'.$ExpirationDateTimestamp.'"
									Yii::$app->db->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
									//ends
									
									$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$uph_row['email'],'ses_full_name'=>$uph_row['first_name'].' '.$uph_row['last_name'],'responseGetJson'=> $responseGetJson,'GETSubscriptionRef'=>$GETSubscriptionRef);
									$this->renewedSuccessedPayment($payment_info);
									
									
									$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
									if(empty($uos_row)){
										Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
									}
									
									
									Yii::$app->session->set('success_message',"Successfully renewed Subscription #".$GETSubscriptionRef);
									
									
									if(!Yii::$app->session->get('useremail')){
									   $url = \Yii::$app->request->baseUrl."/login";
									   return $this->redirect($url);
									}else{
										return $this->redirect(['my-template/pricing']);
									}
									
								}

							}
					}
					
				}

			}else{
				
				$uph_row = Yii::$app->db->createCommand("select t1.id, t1.userid,t1.2coCustomerReference, t2.email, t2.username, t2.first_name, t2.last_name from user_payment_history t1 JOIN user t2 ON t1.userid=t2.id JOIN user_order_products t3 ON t1.id=t3.uph_id where t3.SubscriptionReference='".$GETSubscriptionRef."' ORDER BY t1.id DESC")->queryOne();
				if(!empty($uph_row)){
					//echo '<br/>uph_row:<br/><pre>'; print_r($uph_row);echo '</pre>';
					$uph_pkid = $uph_row['id'];
					
					$user_infoArr = array();
					$user_infoArr['merchant_order_id'] = $merchant_order_id;//it is blank here;
					$user_infoArr['email'] = $uph_row['email'];
					$user_infoArr['username'] = $uph_row['username'];
					$user_infoArr['user_id'] = $uph_row['userid'];
					
					if($twoCo_CustomerReference==0){
						$twoCo_CustomerReference = $uph_row['2coCustomerReference'];
					}
				

					$uphOrderExist_row = Yii::$app->db->createCommand("select id,user_ids from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
					if(!empty($uphOrderExist_row)){
						$lastuphid = $uphOrderExist_row['id'];
					}else{

						$sql_moi='merchant_id='.$merchant_order_id;
						if($merchant_order_id==''){
							$sql_moi='merchant_id=NULL';
						}

						//new order insert entry //user_ids=''
						Yii::$app->db->createCommand('INSERT INTO user_payment_history SET userid='.$uph_row['userid'].', order_number = "'.$order_number.'", '.$sql_moi.', user_info = "'.addslashes(json_encode($user_infoArr)).'" , status="Initialize", complete_date = "'.date("Y-m-d H:i:s").'", 2coCustomerReference = "'.$twoCo_CustomerReference.'",ordertype=4')->execute();
						$lastuphid = Yii::$app->db->getLastInsertID();
						
						Yii::$app->db->createCommand("UPDATE `user_payment_history` SET `response_get` = '".addslashes($responseGetJson)."', `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$lastuphid)->execute(); 							
					}
					
					

					Yii::$app->session->set('success_message',"Payment Authorised Successfully, please wait upto 15 minutes. Your subscription #".$GETSubscriptionRef." will be extended soon.");
					//echo '<br/>ASD';die;
					
					if(!Yii::$app->session->get('useremail')){
					   $url = \Yii::$app->request->baseUrl."/login";
					   return $this->redirect($url);
					}else{
						return $this->redirect(['my-template/pricing']);
					}

					
					
				}
			}
			//30-09-2020 ends
			
		}elseif(isset($_GET['signature']) && $_GET['signature']!=''){
			//From our pricing page, when inline 2checkout order is placed at that time, in 2checkout response, it redirected to this method and this block of code is used to process it further;
		

			$response_data = $_GET;
			
			$order_number= $_GET['refno'];//this is order's reference number;
				
			$signature= $_GET['signature'];
			
			//$merchant_order_id= $response_data->merchant_order_id;
			$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;
			
			
			$lfaf_seat_purchased_userids='';
			$addifi = $curlResult->AdditionalFields;
			foreach($addifi as $res){
				if($res->Code=="lfaf_seat_purchased_userids"){
					$lfaf_seat_purchased_userids = $res->Value;
				}
			}

			//$lfaf_seat_purchased_userids = '{"LFPM":["14935","14988"],"LFUM":["14987"]}';
			
			$lfaf_seat_purchased_userids = stripslashes($lfaf_seat_purchased_userids);//added 31-07-2020: removes slash
			$lfaf_seat_purchased_useridsArr = json_decode($lfaf_seat_purchased_userids,true);

			
			$twoCo_CustomerReference = 0;
			if(isset($curlResult->CustomerDetails->CustomerReference)){
				$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference;
			}
			
			$connection = Yii::$app->db;
			$user_id = Yii::$app->session->get('userid');
			
			
			$uph_row = $connection->createCommand("select id from user_payment_history where merchant_id='".$merchant_order_id."' and userid =" . Yii::$app->session->get('userid'))->queryOne();
			$uph_pkid = $uph_row['id'];

			$connection->createCommand("UPDATE `user_payment_history` SET `response_get` = '".$responseGetJson."', `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$uph_pkid)->execute();
			
			if($curlResult->Status=='COMPLETE' && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK' && 1==2){
				//This code block is not in use. As 2checkout will take some few minutes to authorise the payment. And at this stage above order Status, ApproveStatus and VendorApproveStatus will not be as mentioned in the above condition. So, always it will go in else condition.
				


				//new starts
				$command = $connection->createCommand('UPDATE user_payment_history SET order_number = "'.$order_number.'", complete_date = "'.date("Y-m-d H:i:s").'", status="Success", response_signature = "'.$signature.'", 2coCustomerReference = "'.$twoCo_CustomerReference.'" WHERE id='.$uph_pkid);
				$command->execute();
				
				$selPlanUsrArr=array();
				
				//$current_user_setting_plan_array = array('0'=>'Free Forever','36147949'=>'1','36147960'=>'2','36149087'=>'3','36149119'=>'4','36147991'=>'5','36148018'=>'6');
				$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7');
				
				$Items = $curlResult->Items;
				/*
				echo '<br/>Items::<pre>'; print_r($Items);
				echo '<br/><br/>';
				foreach($Items as $item_key=>$item_res){
					echo $item_res->Code;
					echo '<br/>';print_r($item_res);
				}
				die;*/
				
				foreach($Items as $item_key=>$item_res){
					$product_id = $item_res->Code;//this is product code eg: LCPM
					$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
					$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
					$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
					$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
					

					$command = $connection->createCommand('UPDATE user_order_products SET SubscriptionStartDate = "'.$SubscriptionStartDate.'", ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE", SubscriptionReference="'.$SubscriptionReference.'" WHERE uph_id='.$uph_pkid.' AND product_id="'.$product_id.'" ');
					$command->execute();
					
					$uidsStrPerProduct = implode(',',$lfaf_seat_purchased_useridsArr[$product_id]);
					$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
					
					$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
					
					//starts
					$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus');
					$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
					foreach($userIdArr as $uid){
						
						$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
						$previous_plan = $usrcommand['sublevel'];
						$isTrial = $usrcommand['trial'];
						
						$previous_plan = $previous_plan_array[$previous_plan];
						
						$current_plan = $previous_plan_array[$current_user_setting_plan];
						
						$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
						$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
						$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
						$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
						$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
					}
					//trial_expired_at = "'.$ExpirationDateTimestamp.'"
					$command = $connection->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$uidsStrPerProduct.')');
					$command->execute();
					//ends
					
					$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
					if(empty($uos_row)){
						Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
					}
					
					
				}
				//echo '<br/>SDFDF:<pre>'; print_r($selPlanUsrArr);
				
				//new ends
				
				$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>Yii::$app->session->get('useremail'),'ses_full_name'=>Yii::$app->session->get('first_name'));
				$this->successedPayment($payment_info);
				
				//Yii::$app->session->setFlash('success', "Successfully enabled plan ".$current_plan);
				//Yii::$app->session->setFlash('success', "Successfully enabled subscription");
		//die;;
				Yii::$app->session->set('success_message',"Successfully enabled subscription.");
				return $this->redirect(['my-template/pricing']);

			}else{
				//As we need to wait due to 2checkout, until the order is authorized. Once the order is authorized, 2checkout will call "webhookipn" method. From that "webhookipn" method, the further process will be done.

				$command = $connection->createCommand('UPDATE user_payment_history SET order_number = "'.$order_number.'", complete_date = "'.date("Y-m-d H:i:s").'", response_signature = "'.$signature.'", 2coCustomerReference = "'.$twoCo_CustomerReference.'" WHERE id='.$uph_pkid);
				$command->execute();

				Yii::$app->session->set('success_message',"Payment Authorised Successfully, please wait upto 5 minutes. Your account will be upgraded and you will be notified by email soon.");
				//echo '<br>ASD';die;
				return $this->redirect(['my-template/pricing']);

			}

		}
	    
	}


	//NR: This method is in Use; Do Not Remove; This is my working code for multiproducts in cart;
	public function actionResponse(){
		//This method used 2 times. (1) From our pricing page, when inline 2checkout order is placed at that time, in 2checkout response, it redirected to this method. (2) From customer's 2checkout panel, When customer manually renew a subscription at that time he will be redirected to this method;
		//24-06-2021:This method is also used by add-on pack ie.booster pack order, which is also recurring product.
		
		//echo '<pre>';print_r($_GET);echo '</pre>';
		
		//echo '<br/><br/>post:<br/>';print_r($_POST);
		//echo '<br/><br/>req:<br/>';print_r($_REQUEST);

		//test email starts
				$html = json_encode($_GET,JSON_PRETTY_PRINT);
				$datetimenow = date('Y-m-d H:i:s');
			if (YII_ENV_PROD) {
				$email_subject = "Linkedfusion Production Server - Response Method Called at ".$datetimenow;
			}else{
				$email_subject = "Linkedfusion Staging Server - Response Method Called at ".$datetimenow;
			}
				$mail = Yii::$app->mailer->compose()
						->setTo('nikit@intricaretech.com')
						->setFrom(Yii::$app->params['adminEmail'])
						->setSubject($email_subject)
						->setHtmlBody($html, 'text/html');
				$mail->send();
		//test email ends

		
		if (YII_ENV_PROD) {
			//production
			$merchantCode = "203537015";
			$key = 'd?q4rkG]&KAh#vwnmSJ%';
		}else{
			//staging
			$merchantCode = "251108887711";// your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
			$key = '!G2S8WRBKJ6#&c~luOz=';// your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
		}

		$gmdate = gmdate('Y-m-d H:i:s');
		$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
		$hashAlgorithm = 'sha256';
		$hash = hash_hmac($hashAlgorithm , $string, $key);
		
		$OrderReferenceNumber = $_GET['refno'];
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

		$headers = array();
		$headers[] = 'Accept: application/json';
		$headers[] = 'Content-Type: application/json';
		$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		$curl_result = curl_exec($ch);
		
		$curlResult = json_decode($curl_result);
		//echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
		if (curl_errno($ch)) {
			//echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);
		//echo '<br/>';
		
		//test email starts
				$html = $curl_result;
				//$datetimenow = date('Y-m-d H:i:s');
			if (YII_ENV_PROD) {
				$email_subject = "Linkedfusion Production Server - Response Method Called at ".$datetimenow;
			}else{
				$email_subject = "Linkedfusion Staging Server - Response Method Called at ".$datetimenow;
			}
				$mail = Yii::$app->mailer->compose()
						->setTo('nikit@intricaretech.com')
						->setFrom(Yii::$app->params['adminEmail'])
						->setSubject($email_subject)
						->setHtmlBody($html, 'text/html');
				$mail->send();
		//test email ends		
		
		$responseGetJson = json_encode($_REQUEST);
		$responseOrderJson = $curl_result;
		//$responseOrderJson = json_decode($curl_result,true);
		//$responseOrderJson = json_encode($responseOrderJson);


		if(isset($_GET['merchant']) && $_GET['merchant']==$merchantCode && isset($_GET['subscription']) && $_GET['subscription']!='' && isset($_GET['signature']) && $_GET['signature']!='' ){
			//From customer's 2checkout panel, When customer manually renew a subscription at that time he will be redirected to this method and this block of code is used to process it further; It may possible that customer is not already logged-in;
			//sample url when it redirects to our website:https://nikit.intricare.net/cloud_theme/basic/web/securepayment/response-working?merchant=251108887711&subscription=56F0CEEF71&refno=129660480&total=131.9&total-currency=USD&signature=1f84b71c22935f8a1e9faed392aa7d1751413891eda27092f5cdccbdec7ee4f7

			/*Olg Orig Code- This code will not wait order to become authorized.
			$response_data = $_GET;
			
			$order_number= $_GET['refno'];//this is order's reference number;
				
			$signature= $_GET['signature'];
			$GETSubscriptionRef = $_GET['subscription'];
			
			//$merchant_order_id= $response_data->merchant_order_id;
			$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;
			
			
			$lfaf_seat_purchased_userids='';
			$addifi = $curlResult->AdditionalFields;
			foreach($addifi as $res){
				if($res->Code=="lfaf_seat_purchased_userids"){
					$lfaf_seat_purchased_userids = $res->Value; //it is blank here
				}
			}


			$twoCo_CustomerReference = 0;
			if(isset($curlResult->CustomerDetails->CustomerReference)){
				//CustomerDetails not exits here
				$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference;
			}
			

			
			$uph_row = Yii::$app->db->createCommand("select t1.id, t1.userid,t1.2coCustomerReference, t2.email, t2.username, t2.first_name, t2.last_name from user_payment_history t1 JOIN user t2 ON t1.userid=t2.id JOIN user_order_products t3 ON t1.id=t3.uph_id where t3.SubscriptionReference='".$GETSubscriptionRef."' ORDER BY t1.id DESC")->queryOne();
			if(!empty($uph_row)){
				//echo '<br/>uph_row:<br/><pre>'; print_r($uph_row);echo '</pre>';
				$uph_pkid = $uph_row['id'];
				
				$user_infoArr = array();
				$user_infoArr['merchant_order_id'] = $merchant_order_id;//it is blank here;
				$user_infoArr['email'] = $uph_row['email'];
				$user_infoArr['username'] = $uph_row['username'];
				$user_infoArr['user_id'] = $uph_row['userid'];
				
				if($twoCo_CustomerReference==0){
					$twoCo_CustomerReference = $uph_row['2coCustomerReference'];
				}
			

				$uphOrderExist_row = Yii::$app->db->createCommand("select id,user_ids from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
				if(!empty($uphOrderExist_row)){
					$lastuphid = $uphOrderExist_row['id'];
				}else{

					$sql_moi='merchant_id='.$merchant_order_id;
					if($merchant_order_id==''){
						$sql_moi='merchant_id=NULL';
					}

					//new order insert entry //user_ids=''
					Yii::$app->db->createCommand('INSERT INTO user_payment_history SET userid='.$uph_row['userid'].', order_number = "'.$order_number.'", '.$sql_moi.', user_info = "'.addslashes(json_encode($user_infoArr)).'" , status="Success", complete_date = "'.date("Y-m-d H:i:s").'", 2coCustomerReference = "'.$twoCo_CustomerReference.'",ordertype=4')->execute();
					$lastuphid = Yii::$app->db->getLastInsertID();
					
					Yii::$app->db->createCommand("UPDATE `user_payment_history` SET `response_get` = '".addslashes($responseGetJson)."', `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$lastuphid)->execute(); 							
				}
				

				$selPlanUsrArr=array();
				$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7');
				
				$fullplanname_array = array('Free'=>'Free','Professional Monthly'=>'LFPM','Professional Quarterly'=>'LFPQ','Grow Monthly'=>'LFGM','Grow Quarterly'=>'LFGQ','Ultimate Monthly'=>'LFUM','Ultimate Quarterly'=>'LFUQ','Ultimate Plus'=>'LFUP');
		
				$Items = $curlResult->Items;				

				foreach($Items as $item_key=>$item_res){
	
					
						$product_id = $item_res->Code;//this is product code eg: LCPM
						$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
						$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
						$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
						$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
						
						$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
						
						if($GETSubscriptionRef==$SubscriptionReference){
							
						
							$upo_row = Yii::$app->db->createCommand("select id,user_ids from user_order_products where uph_id =".$uph_pkid." AND product_id='".$product_id."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
							
							if(!empty($upo_row)){
								$upo_user_ids = $upo_row['user_ids'];
								
								//SubscriptionStartDate = "'.$SubscriptionStartDate.'"
								Yii::$app->db->createCommand('UPDATE user_order_products SET ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE" WHERE id='.$upo_row['id'])->execute();
								
								Yii::$app->db->createCommand("UPDATE `user_payment_history` SET user_ids = '".$upo_user_ids."' where id =".$lastuphid)->execute();
								
								
								$lfaf_seat_purchased_useridsArr = array();
								$lfaf_seat_purchased_useridsArr[$product_id] = explode(',',$upo_user_ids);
		

								//$uidsStrPerProduct = $upo_user_ids;
								$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
								
								
								//starts
								$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus');
								$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
								foreach($userIdArr as $uid){
									
									$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
									$previous_plan = $usrcommand['sublevel'];
									$isTrial = $usrcommand['trial'];
									
									$previous_plan = $previous_plan_array[$previous_plan];
									
									$current_plan = $previous_plan_array[$current_user_setting_plan];
									
									$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
									$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
									$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
									$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
									$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
								}
								//trial_expired_at = "'.$ExpirationDateTimestamp.'"
								Yii::$app->db->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
								//ends
								
								$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$uph_row['email'],'ses_full_name'=>$uph_row['first_name'].' '.$uph_row['last_name'],'responseGetJson'=> $responseGetJson,'GETSubscriptionRef'=>$GETSubscriptionRef);
								$this->renewedSuccessedPayment($payment_info);
								
								
								$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
								if(empty($uos_row)){
									Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
								}
								
								
								Yii::$app->session->set('success_message',"Successfully renewed Subscription #".$GETSubscriptionRef);
								
								
								if(!Yii::$app->session->get('useremail')){
								   $url = \Yii::$app->request->baseUrl."/login";
								   return $this->redirect($url);
								}else{
									return $this->redirect(['my-template/pricing']);
								}
								
							}

						}
				}
				
			}*/

			//30-09-2020 starts
			$response_data = $_GET;
			
			$order_number= $_GET['refno'];//this is order's reference number;
				
			$signature= $_GET['signature'];
			$GETSubscriptionRef = $_GET['subscription'];
			
			//$merchant_order_id= $response_data->merchant_order_id;
			$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;
			
			
			$lfaf_seat_purchased_userids='';
			$addifi = $curlResult->AdditionalFields;
			foreach($addifi as $res){
				if($res->Code=="lfaf_seat_purchased_userids"){
					$lfaf_seat_purchased_userids = $res->Value; //it is blank here
				}
			}


			$twoCo_CustomerReference = 0;
			if(isset($curlResult->CustomerDetails->CustomerReference)){
				//CustomerDetails not exits here
				$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference;
			}
			
			if($curlResult->Status=='COMPLETE' && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK' && 1==2){
				//This code block is not in use. As 2checkout will take some few minutes to authorise the payment. And at this stage above order Status, ApproveStatus and VendorApproveStatus will not be as mentioned in the above condition. So, always it will go in else condition.

				$uph_row = Yii::$app->db->createCommand("select t1.id, t1.userid,t1.2coCustomerReference, t2.email, t2.username, t2.first_name, t2.last_name from user_payment_history t1 JOIN user t2 ON t1.userid=t2.id JOIN user_order_products t3 ON t1.id=t3.uph_id where t3.SubscriptionReference='".$GETSubscriptionRef."' ORDER BY t1.id DESC")->queryOne();
				if(!empty($uph_row)){
					//echo '<br/>uph_row:<br/><pre>'; print_r($uph_row);echo '</pre>';
					$uph_pkid = $uph_row['id'];
					
					$user_infoArr = array();
					$user_infoArr['merchant_order_id'] = $merchant_order_id;//it is blank here;
					$user_infoArr['email'] = $uph_row['email'];
					$user_infoArr['username'] = $uph_row['username'];
					$user_infoArr['user_id'] = $uph_row['userid'];
					
					if($twoCo_CustomerReference==0){
						$twoCo_CustomerReference = $uph_row['2coCustomerReference'];
					}
				

					$uphOrderExist_row = Yii::$app->db->createCommand("select id,user_ids from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
					if(!empty($uphOrderExist_row)){
						$lastuphid = $uphOrderExist_row['id'];
					}else{

						// $sql_moi='merchant_id='.$merchant_order_id; //commented on 20-11-2023 due to error in insert qry when it has value.
						$sql_moi='merchant_id="'.$merchant_order_id.'"';
						if($merchant_order_id==''){
							$sql_moi='merchant_id=NULL';
						}

						//new order insert entry //user_ids=''
						Yii::$app->db->createCommand('INSERT INTO user_payment_history SET userid='.$uph_row['userid'].', order_number = "'.$order_number.'", '.$sql_moi.', user_info = "'.addslashes(json_encode($user_infoArr)).'" , status="Success", complete_date = "'.date("Y-m-d H:i:s").'", 2coCustomerReference = "'.$twoCo_CustomerReference.'",ordertype=4')->execute();
						$lastuphid = Yii::$app->db->getLastInsertID();
						
						Yii::$app->db->createCommand("UPDATE `user_payment_history` SET `response_get` = '".addslashes($responseGetJson)."', `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$lastuphid)->execute(); 							
					}
					

					$selPlanUsrArr=array();
					$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7');
					
					$fullplanname_array = array('Free'=>'Free','Professional Monthly'=>'LFPM','Professional Quarterly'=>'LFPQ','Grow Monthly'=>'LFGM','Grow Quarterly'=>'LFGQ','Ultimate Monthly'=>'LFUM','Ultimate Quarterly'=>'LFUQ','Ultimate Plus'=>'LFUP');
			
					$Items = $curlResult->Items;				

					foreach($Items as $item_key=>$item_res){
		
						
							$product_id = $item_res->Code;//this is product code eg: LCPM
							$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
							$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
							$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
							$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
							
							$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
							
							if($GETSubscriptionRef==$SubscriptionReference){
								
							
								$upo_row = Yii::$app->db->createCommand("select id,user_ids from user_order_products where uph_id =".$uph_pkid." AND product_id='".$product_id."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
								
								if(!empty($upo_row)){
									$upo_user_ids = $upo_row['user_ids'];
									
									//SubscriptionStartDate = "'.$SubscriptionStartDate.'"
									Yii::$app->db->createCommand('UPDATE user_order_products SET ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE" WHERE id='.$upo_row['id'])->execute();
									
									Yii::$app->db->createCommand("UPDATE `user_payment_history` SET user_ids = '".$upo_user_ids."' where id =".$lastuphid)->execute();
									
									
									$lfaf_seat_purchased_useridsArr = array();
									$lfaf_seat_purchased_useridsArr[$product_id] = explode(',',$upo_user_ids);
			

									//$uidsStrPerProduct = $upo_user_ids;
									$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
									
									
									//starts
									$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus');
									$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
									foreach($userIdArr as $uid){
										
										$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
										$previous_plan = $usrcommand['sublevel'];
										$isTrial = $usrcommand['trial'];
										
										$previous_plan = $previous_plan_array[$previous_plan];
										
										$current_plan = $previous_plan_array[$current_user_setting_plan];
										
										$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
										$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
										$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
										$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
										$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
									}
									//trial_expired_at = "'.$ExpirationDateTimestamp.'"
									Yii::$app->db->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
									//ends
									
									$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$uph_row['email'],'ses_full_name'=>$uph_row['first_name'].' '.$uph_row['last_name'],'responseGetJson'=> $responseGetJson,'GETSubscriptionRef'=>$GETSubscriptionRef);
									$this->renewedSuccessedPayment($payment_info);
									
									
									$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
									if(empty($uos_row)){
										Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
									}
									
									
									Yii::$app->session->set('success_message',"Successfully renewed Subscription #".$GETSubscriptionRef);
									
									
									if(!Yii::$app->session->get('useremail')){
									   $url = \Yii::$app->request->baseUrl."/login";
									   return $this->redirect($url);
									}else{
										return $this->redirect(['my-template/pricing']);
									}
									
								}

							}
					}
					
				}

			}else{
				
				$uph_row = Yii::$app->db->createCommand("select t1.id, t1.userid,t1.2coCustomerReference, t2.email, t2.username, t2.first_name, t2.last_name from user_payment_history t1 JOIN user t2 ON t1.userid=t2.id JOIN user_order_products t3 ON t1.id=t3.uph_id where t3.SubscriptionReference='".$GETSubscriptionRef."' ORDER BY t1.id DESC")->queryOne();
				if(!empty($uph_row)){
					//echo '<br/>uph_row:<br/><pre>'; print_r($uph_row);echo '</pre>';
					$uph_pkid = $uph_row['id'];
					
					$user_infoArr = array();
					$user_infoArr['merchant_order_id'] = $merchant_order_id;//it is blank here;
					$user_infoArr['email'] = $uph_row['email'];
					$user_infoArr['username'] = $uph_row['username'];
					$user_infoArr['user_id'] = $uph_row['userid'];
					
					if($twoCo_CustomerReference==0){
						$twoCo_CustomerReference = $uph_row['2coCustomerReference'];
					}
				

					$uphOrderExist_row = Yii::$app->db->createCommand("select id,user_ids from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
					if(!empty($uphOrderExist_row)){
						$lastuphid = $uphOrderExist_row['id'];
					}else{

						// $sql_moi='merchant_id='.$merchant_order_id; //commented on 20-11-2023 due to error in insert qry when it has value.
						$sql_moi='merchant_id="'.$merchant_order_id.'"';
						if($merchant_order_id==''){
							$sql_moi='merchant_id=NULL';
						}

						//new order insert entry //user_ids=''
						Yii::$app->db->createCommand('INSERT INTO user_payment_history SET userid='.$uph_row['userid'].', order_number = "'.$order_number.'", '.$sql_moi.', user_info = "'.addslashes(json_encode($user_infoArr)).'" , status="Initialize", complete_date = "'.date("Y-m-d H:i:s").'", 2coCustomerReference = "'.$twoCo_CustomerReference.'",ordertype=4')->execute();
						$lastuphid = Yii::$app->db->getLastInsertID();
						
						Yii::$app->db->createCommand("UPDATE `user_payment_history` SET `response_get` = '".addslashes($responseGetJson)."', `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$lastuphid)->execute(); 							
					}
					
					

					Yii::$app->session->set('success_message',"Payment Authorised Successfully, please wait upto 15 minutes. Your subscription #".$GETSubscriptionRef." will be extended soon.");
					//echo '<br/>ASD';die;
					
					if(!Yii::$app->session->get('useremail')){
					   $url = \Yii::$app->request->baseUrl."/login";
					   return $this->redirect($url);
					}else{
						return $this->redirect(['my-template/pricing']);
					}

					
					
				}
			}
			//30-09-2020 ends
			
		}elseif(isset($_GET['signature']) && $_GET['signature']!=''){
			//From our pricing page, when inline 2checkout order is placed at that time, in 2checkout response, it redirected to this method and this block of code is used to process it further;
		

			$response_data = $_GET;
			
			$order_number= $_GET['refno'];//this is order's reference number;
				
			$signature= $_GET['signature'];
			
			//$merchant_order_id= $response_data->merchant_order_id;
			$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;
			
			
			$lfaf_seat_purchased_userids='';
			$addifi = $curlResult->AdditionalFields;
			foreach($addifi as $res){
				if($res->Code=="lfaf_seat_purchased_userids"){
					$lfaf_seat_purchased_userids = $res->Value;
				}
			}

			//$lfaf_seat_purchased_userids = '{"LFPM":["14935","14988"],"LFUM":["14987"]}';
			
			$lfaf_seat_purchased_userids = stripslashes($lfaf_seat_purchased_userids);//added 31-07-2020: removes slash
			$lfaf_seat_purchased_useridsArr = json_decode($lfaf_seat_purchased_userids,true);

			
			$twoCo_CustomerReference = 0;
			if(isset($curlResult->CustomerDetails->CustomerReference)){
				$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference;
			}
			
			$connection = Yii::$app->db;
			$user_id = Yii::$app->session->get('userid');
			
			
			$uph_row = $connection->createCommand("select id,isAddOnPackOrder from user_payment_history where merchant_id='".$merchant_order_id."' and userid =" . Yii::$app->session->get('userid'))->queryOne();
			$uph_pkid = $uph_row['id'];
			
			$command = $connection->createCommand('UPDATE user_payment_history SET order_number = "'.$order_number.'", complete_date = "'.date("Y-m-d H:i:s").'", response_signature = "'.$signature.'", 2coCustomerReference = "'.$twoCo_CustomerReference.'" WHERE id='.$uph_pkid);
			$command->execute();

			$connection->createCommand("UPDATE `user_payment_history` SET `response_get` = '".$responseGetJson."', `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$uph_pkid)->execute();
			
			if($curlResult->Status=='COMPLETE' && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK' && 1==2){
				//This code block is not in use. As 2checkout will take some few minutes to authorise the payment. And at this stage above order Status, ApproveStatus and VendorApproveStatus will not be as mentioned in the above condition. So, always it will go in else condition.
				


				//new starts
				$command = $connection->createCommand('UPDATE user_payment_history SET order_number = "'.$order_number.'", complete_date = "'.date("Y-m-d H:i:s").'", status="Success", response_signature = "'.$signature.'", 2coCustomerReference = "'.$twoCo_CustomerReference.'" WHERE id='.$uph_pkid);
				$command->execute();
				
				$selPlanUsrArr=array();
				
				//$current_user_setting_plan_array = array('0'=>'Free Forever','36147949'=>'1','36147960'=>'2','36149087'=>'3','36149119'=>'4','36147991'=>'5','36148018'=>'6');
				$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7');
				
				$Items = $curlResult->Items;
				/*
				echo '<br/>Items::<pre>'; print_r($Items);
				echo '<br/><br/>';
				foreach($Items as $item_key=>$item_res){
					echo $item_res->Code;
					echo '<br/>';print_r($item_res);
				}
				die;*/
				
				foreach($Items as $item_key=>$item_res){
					$product_id = $item_res->Code;//this is product code eg: LCPM
					$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
					$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
					$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
					$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
					

					$command = $connection->createCommand('UPDATE user_order_products SET SubscriptionStartDate = "'.$SubscriptionStartDate.'", ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE", SubscriptionReference="'.$SubscriptionReference.'" WHERE uph_id='.$uph_pkid.' AND product_id="'.$product_id.'" ');
					$command->execute();
					
					$uidsStrPerProduct = implode(',',$lfaf_seat_purchased_useridsArr[$product_id]);
					$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
					
					$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
					
					//starts
					$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus');
					$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
					foreach($userIdArr as $uid){
						
						$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
						$previous_plan = $usrcommand['sublevel'];
						$isTrial = $usrcommand['trial'];
						
						$previous_plan = $previous_plan_array[$previous_plan];
						
						$current_plan = $previous_plan_array[$current_user_setting_plan];
						
						$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
						$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
						$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
						$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
						$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
					}
					//trial_expired_at = "'.$ExpirationDateTimestamp.'"
					$command = $connection->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$uidsStrPerProduct.')');
					$command->execute();
					//ends
					
					$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
					if(empty($uos_row)){
						Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
					}
					
					
				}
				//echo '<br/>SDFDF:<pre>'; print_r($selPlanUsrArr);
				
				//new ends
				
				$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>Yii::$app->session->get('useremail'),'ses_full_name'=>Yii::$app->session->get('first_name'));
				$this->successedPayment($payment_info);
				
				//Yii::$app->session->setFlash('success', "Successfully enabled plan ".$current_plan);
				//Yii::$app->session->setFlash('success', "Successfully enabled subscription");
				//die;;
				Yii::$app->session->set('success_message',"Successfully enabled subscription.");
				return $this->redirect(['my-template/pricing']);

			}else{
				//As we need to wait due to 2checkout, until the order is authorized. Once the order is authorized, 2checkout will call "webhookipn" method. From that "webhookipn" method, the further process will be done.

						if (YII_ENV_PROD) {
							Yii::$app->session->set('session_tracking_order_uph_pkid',$uph_pkid);
							Yii::$app->session->set('session_tracking_order_refno',$_GET['refno']);
							if($_GET['total-currency']=='USD'){
								Yii::$app->session->set('session_tracking_order_total',$_GET['total']);
							}else{
								$usd_total_amt = $curlResult->FxRate * $curlResult->NetDiscountedPrice;
								Yii::$app->session->set('session_tracking_order_total',$usd_total_amt);
							}
						}

				if($uph_row['isAddOnPackOrder']==1){
				Yii::$app->session->set('success_message',"Payment Authorised Successfully, please wait upto 5 minutes. You will be notified by email soon.");
				}else{
				Yii::$app->session->set('success_message',"Payment Authorised Successfully, please wait upto 5 minutes. Your account will be upgraded and you will be notified by email soon.");	
				}
				
				return $this->redirect(['my-template/pricing']);

			}

		}
	    
	}

	//NR: Blackfriday Method. This method is in Use; Do Not Remove; This is my working code for multiproducts in cart;
	public function actionResponseblackfriday(){
		//This method used 2 times. (1) From our pricing page, when inline 2checkout order is placed at that time, in 2checkout response, it redirected to this method. (2) From customer's 2checkout panel, When customer manually renew a subscription at that time he will be redirected to this method;
		
		//echo '<pre>';print_r($_GET);echo '</pre>';
		
		//echo '<br/><br/>post:<br/>';print_r($_POST);
		//echo '<br/><br/>req:<br/>';print_r($_REQUEST);

		//test email starts
				$html = json_encode($_GET,JSON_PRETTY_PRINT);
				$datetimenow = date('Y-m-d H:i:s');
			if (YII_ENV_PROD) {
				$email_subject = "Linkedfusion Production Server - Blackfriday Response Method Called at ".$datetimenow;
			}else{
				$email_subject = "Linkedfusion Staging Server - Blackfriday Response Method Called at ".$datetimenow;
			}
				$mail = Yii::$app->mailer->compose()
						->setTo('nikit@intricaretech.com')
						->setFrom(Yii::$app->params['adminEmail'])
						->setSubject($email_subject)
						->setHtmlBody($html, 'text/html');
				$mail->send();
		//test email ends

		
		if (YII_ENV_PROD) {
			//production
			$merchantCode = "203537015";
			$key = 'd?q4rkG]&KAh#vwnmSJ%';
		}else{
			//staging
			$merchantCode = "251108887711";// your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
			$key = '!G2S8WRBKJ6#&c~luOz=';// your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
		}

		$gmdate = gmdate('Y-m-d H:i:s');
		$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
		$hashAlgorithm = 'sha256';
		$hash = hash_hmac($hashAlgorithm , $string, $key);
		
		$OrderReferenceNumber = $_GET['refno'];
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

		$headers = array();
		$headers[] = 'Accept: application/json';
		$headers[] = 'Content-Type: application/json';
		$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		$curl_result = curl_exec($ch);
		
		$curlResult = json_decode($curl_result);
		//echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
		if (curl_errno($ch)) {
			//echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);
		//echo '<br/>';
		
		//test email starts
				$html = $curl_result;
				//$datetimenow = date('Y-m-d H:i:s');
			if (YII_ENV_PROD) {
				$email_subject = "Linkedfusion Production Server - Blackfriday Response Method Called at ".$datetimenow;
			}else{
				$email_subject = "Linkedfusion Staging Server - Blackfriday Response Method Called at ".$datetimenow;
			}
				$mail = Yii::$app->mailer->compose()
						->setTo('nikit@intricaretech.com')
						->setFrom(Yii::$app->params['adminEmail'])
						->setSubject($email_subject)
						->setHtmlBody($html, 'text/html');
				$mail->send();
		//test email ends		
		
		$responseGetJson = json_encode($_REQUEST);
		$responseOrderJson = $curl_result;
		//$responseOrderJson = json_decode($curl_result,true);
		//$responseOrderJson = json_encode($responseOrderJson);


		if(isset($_GET['merchant']) && $_GET['merchant']==$merchantCode && isset($_GET['subscription']) && $_GET['subscription']!='' && isset($_GET['signature']) && $_GET['signature']!='' ){
			//This will not exist for blackfriday products;
			//From customer's 2checkout panel, When customer manually renew a subscription at that time he will be redirected to this method and this block of code is used to process it further; It may possible that customer is not already logged-in;
			

			
		}elseif(isset($_GET['signature']) && $_GET['signature']!=''){
			//From our pricing page, when inline 2checkout order is placed at that time, in 2checkout response, it redirected to this method and this block of code is used to process it further;
		

			$response_data = $_GET;
			
			$order_number= $_GET['refno'];//this is order's reference number;
				
			$signature= $_GET['signature'];
			
			//$merchant_order_id= $response_data->merchant_order_id;
			$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;
			
			
			$lfaf_seat_purchased_userids='';
			$addifi = $curlResult->AdditionalFields;
			foreach($addifi as $res){
				if($res->Code=="lfaf_seat_purchased_userids"){
					$lfaf_seat_purchased_userids = $res->Value;
				}
			}

			//$lfaf_seat_purchased_userids = '{"LFPM":["14935","14988"],"LFUM":["14987"]}';
			
			$lfaf_seat_purchased_userids = stripslashes($lfaf_seat_purchased_userids);//added 31-07-2020: removes slash
			$lfaf_seat_purchased_useridsArr = json_decode($lfaf_seat_purchased_userids,true);

			
			$twoCo_CustomerReference = 0;
			if(isset($curlResult->CustomerDetails->CustomerReference)){
				$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference;
			}
			
			$connection = Yii::$app->db;
			$user_id = Yii::$app->session->get('userid');
			
			
			$uph_row = $connection->createCommand("select id from user_payment_history where merchant_id='".$merchant_order_id."' and userid =" . Yii::$app->session->get('userid'))->queryOne();
			$uph_pkid = $uph_row['id'];
			
			$command = $connection->createCommand('UPDATE user_payment_history SET order_number = "'.$order_number.'", complete_date = "'.date("Y-m-d H:i:s").'", response_signature = "'.$signature.'", 2coCustomerReference = "'.$twoCo_CustomerReference.'" WHERE id='.$uph_pkid);
			$command->execute();

			$connection->createCommand("UPDATE `user_payment_history` SET `response_get` = '".$responseGetJson."', `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$uph_pkid)->execute();
			
			if($curlResult->Status=='COMPLETE' && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK' && 1==2){
				//This code block is not in use. As 2checkout will take some few minutes to authorise the payment. And at this stage above order Status, ApproveStatus and VendorApproveStatus will not be as mentioned in the above condition. So, always it will go in else condition.
				


			}else{
				//As we need to wait due to 2checkout, until the order is authorized. Once the order is authorized, 2checkout will call "webhookipn" method. From that "webhookipn" method, the further process will be done.

				
						if (YII_ENV_PROD) {
							Yii::$app->session->set('session_tracking_order_uph_pkid',$uph_pkid);
							Yii::$app->session->set('session_tracking_order_refno',$_GET['refno']);
							if($_GET['total-currency']=='USD'){
								Yii::$app->session->set('session_tracking_order_total',$_GET['total']);
							}else{
								$usd_total_amt = $curlResult->FxRate * $curlResult->NetDiscountedPrice;
								Yii::$app->session->set('session_tracking_order_total',$usd_total_amt);
							}
						}

				Yii::$app->session->set('success_message',"Payment Authorised Successfully, please wait upto 5 minutes. Your account will be upgraded and you will be notified by email soon.");
				//echo '<br>ASD';die;
				return $this->redirect(['my-template/blackfriday']);

			}

		}
	    
	}






	//02-10-2020 method
	function arrayexpandipntwooct($array){
		$retval = "";
					foreach($array as $i => $value){
									if(is_array($value)){
													$retval .= $this->arrayexpandipntwooct($value);
									}
									else{
													$size        = strlen($value);
													$retval    .= $size.$value;
									}
					}    
		return $retval;
	}

	//02-10-2020 method
	function hmacipntwooct($key, $data){
	   $b = 64; // byte length for md5
	   if (strlen($key) > $b) {
		   $key = pack("H*",md5($key));
	   }
	   $key  = str_pad($key, $b, chr(0x00));
	   $ipad = str_pad('', $b, chr(0x36));
	   $opad = str_pad('', $b, chr(0x5c));
	   $k_ipad = $key ^ $ipad ;
	   $k_opad = $key ^ $opad;
	   return md5($k_opad  . pack("H*",md5($k_ipad . $data)));
	}
	
	//02-10-2020 method
	function createtablefromarrayipntwooct($array2table) {
		$output = '<table border="1" cellpadding="5" cellspacing="0" style="width: 100%; table-layout: fixed;">
			<thead><tr><th>Field attribute</th><th>Length</th><th>Value</th></tr></thead>
			<tbody>
		';    
		
		foreach($array2table as $key=>$value) {
			$output .= '<tr>';
			
			if(!is_array($value)) {
				$output .= '<td>'.$key.'</td>';
				$output .= '<td>'.strlen($value).'</td>';
				$output .= '<td>'.$value.'</td>';                          
			} else {
				$output .= '<td>'.$key.'[0]'.'</td>';
				foreach($value as $finalvalue) {
					$output .= '<td>'.strlen($finalvalue).'</td>';
					$output .= '<td>'.$finalvalue.'</td>';
				}
			}
			
			$output .= '</tr>';
		}
		
		$output .= '</tbody>';
		$output .= '</table>';
		
		return $output;
	}
	
	//NR: DO NOT DELETE - This is Live Backup method before blackfriday products added; _LiveBkpMethodBeforeBlackfridayProductsAdded
	public function actionWebhookIpn_LiveBkpMethodBeforeBlackfridayProductsAdded(){
		die;
		ini_set('display_errors', 1);
		ini_set('display_startup_errors', 1);
		error_reporting(E_ALL);
		
		if(isset($_POST['HASH'])){
			
			//data coming from 2checkout will be in post method.

			$isLfProductInIPN = false;
			if(isset($_POST['IPN_PCODE'][0])){
				$allLfProductCodesArr = array(
					"LFPM",
					"LFPQ",
					"LFGM",
					"LFGQ",
					"LFUM",
					"LFUQ"
					);
					
				if(in_array($_POST['IPN_PCODE'][0],$allLfProductCodesArr)){
					$isLfProductInIPN = true;
				}

			}else{
				//let it process.
				$isLfProductInIPN = true;
			}
			
			if($isLfProductInIPN){
				
				//email starts
					if (YII_ENV_PROD) {
						$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - Webhook Ipn";
					}else{
						$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - Webhook Ipn";
					}
				$html = json_encode($_POST,JSON_PRETTY_PRINT);
				$html.= '<br/>Timestamp:'.strtotime('now');
				$mail = Yii::$app->mailer->compose()
						->setTo('nikit@intricaretech.com')
						->setFrom(Yii::$app->params['adminEmail'])
						->setSubject($email_subject)
						->setHtmlBody($html, 'text/html');
				$mail->send();
				//email ends
			

				if (YII_ENV_PROD) {
					//production
					$merchantCode = "203537015";
					$key = 'd?q4rkG]&KAh#vwnmSJ%';
				}else{
					//staging
					$merchantCode = "251108887711";// your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
					$key = '!G2S8WRBKJ6#&c~luOz=';// your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
				}

				$gmdate = gmdate('Y-m-d H:i:s');
				$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
				$hashAlgorithm = 'sha256';
				$hash = hash_hmac($hashAlgorithm , $string, $key);
				
				//$OrderReferenceNumber = $_GET['refno'];
				$OrderReferenceNumber = $_POST['REFNO'];
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

				$headers = array();
				$headers[] = 'Accept: application/json';
				$headers[] = 'Content-Type: application/json';
				$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				$curl_result = curl_exec($ch);
				
				$curlResult = json_decode($curl_result);
		//echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
				if (curl_errno($ch)) {
					//echo 'Error:' . curl_error($ch);
				}
				curl_close($ch);
				//echo '<br/>';


				//test email starts
						$html = $curl_result;
						$datetimenow = date('Y-m-d H:i:s');
					if (YII_ENV_PROD) {
						$email_subject = "Linkedfusion Production Server - Webhook Ipn Order Ref #".$OrderReferenceNumber." Response";//at $datetimenow
					}else{
						$email_subject = "Linkedfusion Staging Server - Webhook Ipn Order Ref #".$OrderReferenceNumber." Response";
					}
						$mail = Yii::$app->mailer->compose()
								->setTo('nikit@intricaretech.com')
								->setFrom(Yii::$app->params['adminEmail'])
								->setSubject($email_subject)
								->setHtmlBody($html, 'text/html');
						$mail->send();
				//test email ends

				$responseGetJson = json_encode($_REQUEST);
				$responseOrderJson = $curl_result;
				//$responseOrderJson = json_decode($curl_result,true);
				//$responseOrderJson = json_encode($responseOrderJson);
				
				$flagSubscriptionDataNotFoundEmailSend = false;
				
				if(($curlResult->Status=='COMPLETE' || $curlResult->Status=='AUTHRECEIVED') && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK'){

					//$merchant_order_id= $response_data->merchant_order_id;
					$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;
					
					$twoCo_CustomerReference = 0;
					if(isset($curlResult->CustomerDetails->CustomerReference)){
						$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference;
					}
					
					
					$connection = Yii::$app->db;
					
					//14-10-2020 : In below query, removed this condition:  order_number='".$OrderReferenceNumber."'
					$uph_row = $connection->createCommand("select id,userid,response_get from user_payment_history where merchant_id='".$merchant_order_id."' AND status='Initialize' AND ordertype='0' ORDER BY id DESC")->queryOne();
					//print_r($uph_row);
					if(!empty($uph_row)){
						//Usage of this code: For ordertype=0, Once the order is authorized, 2checkout will call this "webhookipn" method. The further process will be done from this code of block.
						
						if(isset($curlResult->Items[0]->ProductDetails->Name) && isset($curlResult->Items[0]->Code) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionStartDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->ExpirationDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionReference) ){
							//above condition added on 09-10-2020
							//to put here 09-10-2020

							$uph_pkid = $uph_row['id'];
							
							//14-10-2020 : order_number and 2coCustomerReference added here in below query as we should not depend on response method;
							$command = $connection->createCommand('UPDATE user_payment_history SET complete_date = "'.date("Y-m-d H:i:s").'", status="Success", order_number = "'.$OrderReferenceNumber.'", 2coCustomerReference = "'.$twoCo_CustomerReference.'" WHERE id='.$uph_pkid);
							$command->execute();
							
							if($uph_row['response_get']==NULL){
								
								$responseGetVar = array('refno'=>$_POST['REFNO'],'total'=>$_POST['IPN_TOTALGENERAL'],'total-currency'=>$_POST['CURRENCY']);
								$responseGetVar = json_encode($responseGetVar);
								
								$connection->createCommand("UPDATE `user_payment_history` SET `response_get` = '".$responseGetVar."' where `id` =".$uph_pkid)->execute();
							}
							
							
							
							$response_data = $_POST;//$_GET;
							
							$order_number= $_POST['REFNO'];//$_GET['refno'];//this is order's reference number;
								
							//$signature= $_GET['signature'];
							
							$lfaf_seat_purchased_userids='';
							$addifi = $curlResult->AdditionalFields;
							foreach($addifi as $res){
								if($res->Code=="lfaf_seat_purchased_userids"){
									$lfaf_seat_purchased_userids = $res->Value;
								}
							}

							//$lfaf_seat_purchased_userids = '{"LFPM":["14935","14988"],"LFUM":["14987"]}';
							
							$lfaf_seat_purchased_userids = stripslashes($lfaf_seat_purchased_userids);//added 31-07-2020: removes slash
							$lfaf_seat_purchased_useridsArr = json_decode($lfaf_seat_purchased_userids,true);

							
							
							
							//$user_id = Yii::$app->session->get('userid');
							$user_id = $uph_row['userid'];//order placed by this userid;


							//new starts

							
							$selPlanUsrArr=array();
							
							//$current_user_setting_plan_array = array('0'=>'Free Forever','36147949'=>'1','36147960'=>'2','36149087'=>'3','36149119'=>'4','36147991'=>'5','36148018'=>'6');
							$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7');
							
							$Items = $curlResult->Items;
							/*
							echo '<br/>Items::<pre>'; print_r($Items);
							echo '<br/><br/>';
							foreach($Items as $item_key=>$item_res){
								echo $item_res->Code;
								echo '<br/>';print_r($item_res);
							}
							die;*/


							foreach($Items as $item_key=>$item_res){
								$product_id = $item_res->Code;//this is product code eg: LCPM
								$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
								$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
								$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
								$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
								

								$command = $connection->createCommand('UPDATE user_order_products SET SubscriptionStartDate = "'.$SubscriptionStartDate.'", ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE", SubscriptionReference="'.$SubscriptionReference.'" WHERE uph_id='.$uph_pkid.' AND product_id="'.$product_id.'" ');
								$command->execute();
								
								$uidsStrPerProduct = implode(',',$lfaf_seat_purchased_useridsArr[$product_id]);
								$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
								
								$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
								
								//starts
								$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus');
								$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
								foreach($userIdArr as $uid){
									
									$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
									$previous_plan = $usrcommand['sublevel'];
									$isTrial = $usrcommand['trial'];
									
									$previous_plan = $previous_plan_array[$previous_plan];
									
									$current_plan = $previous_plan_array[$current_user_setting_plan];
									
									$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
									$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
									$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
									$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
									$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
								}
								//trial_expired_at = "'.$ExpirationDateTimestamp.'"
								$command = $connection->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$uidsStrPerProduct.')');
								$command->execute();
								//ends
								
								$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
								if(empty($uos_row)){
									Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
								}
								
								
							}
							//echo '<br/>SDFDF:<pre>'; print_r($selPlanUsrArr);
							
							//new ends

							$usrInfoOrdPlaced = $connection->createCommand("select email,first_name from user where id='".$user_id."' ")->queryOne();
							$emailId = $usrInfoOrdPlaced['email'];
							$emailId = $usrInfoOrdPlaced['first_name'];

							$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$usrInfoOrdPlaced['email'],'ses_full_name'=>$usrInfoOrdPlaced['first_name']);
							$this->successedPayment($payment_info);
							
							$connection->createCommand("UPDATE `user_payment_history` SET `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$uph_pkid)->execute();
							
							echo '<br>The End';
							
							//Yii::$app->session->set('success_message',"Successfully enabled subscription.");
							//return $this->redirect(['my-template/pricing']);

							
						}else{
							$flagSubscriptionDataNotFoundEmailSend = true;
							//if subscription data not found just send email;
						}
						
						
					}
					


					
				}
				
				//30-09-2020 starts
				if(($curlResult->Status=='COMPLETE' || $curlResult->Status=='AUTHRECEIVED') && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK'){
					//Usage:When manual renewal order is authorized, this code of block will process futher.
					
					$order_number= $OrderReferenceNumber;//this is order's reference number;
					$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;it is blank here.
					
					$uph_row = Yii::$app->db->createCommand("select t1.id, t1.response_get from user_payment_history t1 where t1.order_number='".$OrderReferenceNumber."' and t1.status='Initialize' and t1.ordertype='4' ORDER BY t1.id DESC")->queryOne();
					
					if(!empty($uph_row)){
						
						if(isset($curlResult->Items[0]->ProductDetails->Name) && isset($curlResult->Items[0]->Code) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionStartDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->ExpirationDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionReference) ){
							//above condition added on 09-10-2020
							//to put here 09-10-2020

							$newOrder_uphpkid = $lastuphid = $uph_row['id'];
							$response_get = json_decode($uph_row['response_get']);
							//echo '<pre>';print_r($response_get);
							$GETSubscriptionRef = $response_get->subscription;
							
							$responseGetJson = $uph_row['response_get'];
							
							$uph_row = Yii::$app->db->createCommand("select t1.id, t1.userid,t1.2coCustomerReference, t2.email, t2.username, t2.first_name, t2.last_name from user_payment_history t1 JOIN user t2 ON t1.userid=t2.id JOIN user_order_products t3 ON t1.id=t3.uph_id where t3.SubscriptionReference='".$GETSubscriptionRef."' ORDER BY t1.id DESC")->queryOne();
							if(!empty($uph_row)){
								$uph_pkid = $uph_row['id'];
								
								Yii::$app->db->createCommand('UPDATE user_payment_history SET complete_date = "'.date("Y-m-d H:i:s").'", status="Success" WHERE id='.$newOrder_uphpkid)->execute();
								

								$selPlanUsrArr=array();
								$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7');
								
								$fullplanname_array = array('Free'=>'Free','Professional Monthly'=>'LFPM','Professional Quarterly'=>'LFPQ','Grow Monthly'=>'LFGM','Grow Quarterly'=>'LFGQ','Ultimate Monthly'=>'LFUM','Ultimate Quarterly'=>'LFUQ','Ultimate Plus'=>'LFUP');
						
								$Items = $curlResult->Items;				

								foreach($Items as $item_key=>$item_res){
					
									
										$product_id = $item_res->Code;//this is product code eg: LCPM
										$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
										$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
										$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
										$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
										
										$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
										
										if($GETSubscriptionRef==$SubscriptionReference){
											
										
											$upo_row = Yii::$app->db->createCommand("select id,user_ids from user_order_products where uph_id =".$uph_pkid." AND product_id='".$product_id."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
											
											if(!empty($upo_row)){
												$upo_user_ids = $upo_row['user_ids'];
												
												//SubscriptionStartDate = "'.$SubscriptionStartDate.'"
												Yii::$app->db->createCommand('UPDATE user_order_products SET ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE" WHERE id='.$upo_row['id'])->execute();
												
												Yii::$app->db->createCommand("UPDATE `user_payment_history` SET user_ids = '".$upo_user_ids."' where id =".$lastuphid)->execute();
												
												
												$lfaf_seat_purchased_useridsArr = array();
												$lfaf_seat_purchased_useridsArr[$product_id] = explode(',',$upo_user_ids);
						

												//$uidsStrPerProduct = $upo_user_ids;
												$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
												
												
												//starts
												$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus');
												$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
												foreach($userIdArr as $uid){
													
													$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
													$previous_plan = $usrcommand['sublevel'];
													$isTrial = $usrcommand['trial'];
													
													$previous_plan = $previous_plan_array[$previous_plan];
													
													$current_plan = $previous_plan_array[$current_user_setting_plan];
													
													$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
													$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
													$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
													$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
													$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
												}
												//trial_expired_at = "'.$ExpirationDateTimestamp.'"
												Yii::$app->db->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
												//ends
												
												$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$uph_row['email'],'ses_full_name'=>$uph_row['first_name'].' '.$uph_row['last_name'],'responseGetJson'=> $responseGetJson,'GETSubscriptionRef'=>$GETSubscriptionRef);
												$this->renewedSuccessedPayment($payment_info);
												
												
												$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
												if(empty($uos_row)){
													Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
												}
												
												echo '<br/>The end';
												
											}

										}
								}							
								
							}


						}else{
							$flagSubscriptionDataNotFoundEmailSend = true;
							//if subscription data not found just send email;
						}
						
						
					}
					
				}
				//30-09-2020 ends


				//09-10-2020 starts
				if($flagSubscriptionDataNotFoundEmailSend==true){
					//if subscription data not found just send email;
					//email starts
			
						$html = 'Hello Admin,<br/><br/>For Order Ref #'.$OrderReferenceNumber.' IPN is called but it does not yet contain Subscription Data. Once the data available, need to manually run actionWebhookIpn method by passing valid post variables.<br/><br/>Below post data received:<br>';
						$html.= json_encode($_POST,JSON_PRETTY_PRINT);
						
					if (YII_ENV_PROD) {
						$email_subject = "Linkedfusion Production Server - Webhook Ipn Order Ref #".$OrderReferenceNumber." Called But Not Having Subscription Data";
						$to_email = ['arpan@intricare.net','nikit@intricaretech.com'];
					}else{
						$email_subject = "Linkedfusion Staging Server - Webhook Ipn Order Ref #".$OrderReferenceNumber." Called But Not Having Subscription Data";
						$to_email = 'nikit@intricaretech.com';
					}
						$mail = Yii::$app->mailer->compose()
								->setTo($to_email)
								->setFrom(Yii::$app->params['adminEmail'])
								->setSubject($email_subject)
								->setHtmlBody($html, 'text/html');
						$mail->send();
					//email ends
				}
				//09-10-2020 ends


			}
		}
		
		//ipn hash code starts here
		if(isset($_POST['HASH'])){
			if (YII_ENV_PROD) {
				$secret_key = 'd?q4rkG]&KAh#vwnmSJ%'; //2checkout secret_key
			}else{
				$secret_key = '!G2S8WRBKJ6#&c~luOz=';
			}
			date_default_timezone_set('UTC');
			//PARAMETERS
			$IPN_parameters = array(); 
			$IPN_parameters['SALEDATE'] = $_POST['SALEDATE'];
			$IPN_parameters['REFNO'] = $_POST['REFNO'];
			$IPN_parameters['REFNOEXT'] = $_POST['REFNOEXT'];
			$IPN_parameters['ORDERNO'] = $_POST['ORDERNO']; 
			$IPN_parameters['ORDERSTATUS'] = $_POST['ORDERSTATUS'];
			$IPN_parameters['PAYMETHOD'] = $_POST['PAYMETHOD'];
			$IPN_parameters['FIRSTNAME'] = $_POST['FIRSTNAME'];
			$IPN_parameters['LASTNAME'] = $_POST['LASTNAME'];
			$IPN_parameters['COMPANY'] = $_POST['COMPANY'];
			$IPN_parameters['REGISTRATIONNUMBER'] = $_POST['REGISTRATIONNUMBER'];
			$IPN_parameters['FISCALCODE'] = $_POST['FISCALCODE'];
			$IPN_parameters['CBANKNAME'] = $_POST['CBANKNAME'];
			$IPN_parameters['CBANKACCOUNT'] = $_POST['CBANKACCOUNT'];
			$IPN_parameters['ADDRESS1'] = $_POST['ADDRESS1'];
			$IPN_parameters['ADDRESS2'] = $_POST['ADDRESS2'];
			$IPN_parameters['CITY'] = $_POST['CITY'];
			$IPN_parameters['STATE'] = $_POST['STATE'];
			$IPN_parameters['ZIPCODE'] = $_POST['ZIPCODE'];
			$IPN_parameters['COUNTRY'] = $_POST['COUNTRY'];
			$IPN_parameters['PHONE'] = $_POST['PHONE'];
			$IPN_parameters['FAX'] = $_POST['FAX'];
			$IPN_parameters['CUSTOMEREMAIL'] = $_POST['CUSTOMEREMAIL'];
			$IPN_parameters['FIRSTNAME_D'] = $_POST['FIRSTNAME_D'];
			$IPN_parameters['LASTNAME_D'] = $_POST['LASTNAME_D'];
			$IPN_parameters['COMPANY_D'] = $_POST['COMPANY_D'];
			$IPN_parameters['ADDRESS1_D'] = $_POST['ADDRESS1_D'];
			$IPN_parameters['ADDRESS2_D'] = $_POST['ADDRESS2_D'];
			$IPN_parameters['CITY_D'] = $_POST['CITY_D'];
			$IPN_parameters['STATE_D'] = $_POST['STATE_D'];
			$IPN_parameters['ZIPCODE_D'] = $_POST['ZIPCODE_D'];
			$IPN_parameters['COUNTRY_D'] = $_POST['COUNTRY_D'];
			$IPN_parameters['PHONE_D'] = $_POST['PHONE_D'];
			$IPN_parameters['IPADDRESS'] = $_POST['IPADDRESS'];
			$IPN_parameters['CURRENCY'] = $_POST['CURRENCY'];
			$IPN_parameters['IPN_PID'][0] = $_POST['IPN_PID'][0];
			$IPN_parameters['IPN_PNAME'][0] = $_POST['IPN_PNAME'][0];
			$IPN_parameters['IPN_PCODE'][0] = $_POST['IPN_PCODE'][0];
			$IPN_parameters['IPN_INFO'][0] = $_POST['IPN_INFO'][0];
			$IPN_parameters['IPN_QTY'][0] = $_POST['IPN_QTY'][0];
			$IPN_parameters['IPN_PRICE'][0] = $_POST['IPN_PRICE'][0];
			$IPN_parameters['IPN_VAT'][0] = $_POST['IPN_VAT'][0];
			$IPN_parameters['IPN_VER'][0] = $_POST['IPN_VER'][0];
			$IPN_parameters['IPN_DISCOUNT'][0] = $_POST['IPN_DISCOUNT'][0];
			$IPN_parameters['IPN_PROMONAME'][0] = $_POST['IPN_PROMONAME'][0];
			$IPN_parameters['IPN_DELIVEREDCODES'][0] = $_POST['IPN_DELIVEREDCODES'][0];
			$IPN_parameters['IPN_TOTAL'][0] = $_POST['IPN_TOTAL'][0];
			$IPN_parameters['IPN_TOTALGENERAL'] = $_POST['IPN_TOTALGENERAL'];
			$IPN_parameters['IPN_SHIPPING'] = $_POST['IPN_SHIPPING'];
			$IPN_parameters['IPN_COMMISSION'] = $_POST['IPN_COMMISSION'];
			$IPN_parameters['IPN_DATE'] = $_POST['IPN_DATE'];
			$IPN_parameters['TEST_ORDER'] = $_POST['TEST_ORDER'];
			$tabble = $this->createtablefromarrayipntwooct($IPN_parameters);
			$email_html=$tabble;
			//*********Base string for HMAC_MD5 calculation:*********
			//echo "<br/><br/>This is the base string for HMAC_MD5 calculation:<br/>";
			$email_html.=  "<br/><br/>This is the base string for HMAC_MD5 calculation:<br/>";
			$result = '';
			foreach ($IPN_parameters as $key => $val){
				$result .= $this->arrayexpandipntwooct((array)$val);
			}
			//var_dump($result);
			//$email_html.=print_r($result,true);
			$email_html.=$result;
			//*********Calculated HMAC_MD5 signature:*********
			//echo "<br/><br/>This is the HMAC_MD5 signature:<br/>";
			$email_html.="<br/><br/>This is the HMAC_MD5 signature:<br/>";
			$hash =  $this->hmacipntwooct($secret_key, $result);
			$IPN_parameters['HASH']=$hash;
			//var_dump($hash);
			//$email_html.=print_r($hash,true);
			$email_html.=$hash;
			//*********Response:*********
			$IPN_parameters_response = array();
			$IPN_parameters_response['IPN_PID'][0] = $_POST['IPN_PID'][0];
			$IPN_parameters_response['IPN_PNAME'][0] = $_POST['IPN_PNAME'][0];
			$IPN_parameters_response['IPN_DATE'] = $_POST['IPN_DATE'];
			//$IPN_parameters_response['DATE'] = $_POST['IPN_DATE'];
			//$IPN_parameters_response['DATE'] = date('YmdHis');//NR
			$IPN_parameters_response['DATE'] = gmdate('YmdHis');//NR
			//*********Response base string for HMAC_MD5 calculation:*********
			//echo "<br/><br/>This is the response base string for HMAC_MD5 calculation:<br/>";
			$email_html.="<br/><br/>This is the response base string for HMAC_MD5 calculation:<br/>";
			$result_response = '';
			foreach ($IPN_parameters_response as $key => $val){
				$result_response .= $this->arrayexpandipntwooct((array)$val);
			}
			//var_dump($result_response);
			//$email_html.=print_r($result_response,true);
			$email_html.=$result_response;
			//*********Calculated response HMAC_MD5 signature:*********
			//echo "<br/><br/>This is the response HMAC_MD5 signature:<br/>";
			$email_html.="<br/><br/>This is the response HMAC_MD5 signature:<br/>";
			$hash =  $this->hmacipntwooct($secret_key, $result_response);
			$link_params['HASH']=$hash;
			//var_dump($hash);
			//$email_html.=print_r($hash,true);
			$email_html.=$hash;
			//Expected response
			//echo 'Expected response: '.'&lt;EPAYMENT&gt;'.$IPN_parameters_response['DATE'].'|'.$hash.'&lt;/EPAYMENT&gt;';
			echo '<EPAYMENT>'.$IPN_parameters_response['DATE'].'|'.$hash.'</EPAYMENT>';
			$email_html.='<br/><br/>Expected response: '.'&lt;EPAYMENT&gt;'.$IPN_parameters_response['DATE'].'|'.$hash.'&lt;/EPAYMENT&gt;';

			
			//email starts
				if (YII_ENV_PROD) {
					$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - WebhookIpn demo hash signature email";
				}else{
					$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - WebhookIpn demo hash signature email";
				}
			$html = $email_html;
			$mail = Yii::$app->mailer->compose()
					->setTo('nikit@intricaretech.com')
					->setFrom(Yii::$app->params['adminEmail'])
					->setSubject($email_subject)
					->setHtmlBody($html, 'text/html');
			$mail->send();
			//email ends
		}
		//ipn hash code ends here
		
	}
	

	//NR: DO NOT DELETE - This is current method after blackfriday products added and before AddOnPackProduct;
	public function actionWebhookIpn_BkpMethodBeforeAddingAddOnPackProduct(){
		ini_set('display_errors', 1);
		ini_set('display_startup_errors', 1);
		error_reporting(E_ALL);
		
		if(isset($_POST['HASH'])){
			
			//data coming from 2checkout will be in post method.

			$isLfProductInIPN = false;
			$isLfBlackFridayProductInIPN = false;
			if(isset($_POST['IPN_PCODE'][0])){
				$allLfProductCodesArr = array(
					"LFPM",
					"LFPQ",
					"LFGM",
					"LFGQ",
					"LFUM",
					"LFUQ",
					"LFPSAR",
					"LFPA",
					"LFGSAR",
					"LFGA",
					"LFUSAR",
					"LFUA",
					"LFGM_v2",
					"LFUM_v2",
					"LFGSAR_v2",
					"LFUSAR_v2",
					"LFGA_v2",
					"LFUA_v2",
					);

				$allLfBlackFridayProductCodesArr = array(
					"LFPSA",
					"LFPABF",
					"LFGSA",
					"LFGABF",
					"LFUSA",
					"LFUABF"
					);
					
				if(in_array($_POST['IPN_PCODE'][0],$allLfProductCodesArr)){
					$isLfProductInIPN = true;
				}

				if(in_array($_POST['IPN_PCODE'][0],$allLfBlackFridayProductCodesArr)){
					$isLfBlackFridayProductInIPN = true;
				}

			}else{
				//let it process.
				$isLfProductInIPN = true;
			}
			
			if($isLfProductInIPN){
				
				//email starts
					if (YII_ENV_PROD) {
						$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - Webhook Ipn";
					}else{
						$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - Webhook Ipn";
					}
				$html = json_encode($_POST,JSON_PRETTY_PRINT);
				$html.= '<br/>Timestamp:'.strtotime('now');
				$mail = Yii::$app->mailer->compose()
						->setTo('nikit@intricaretech.com')
						->setFrom(Yii::$app->params['adminEmail'])
						->setSubject($email_subject)
						->setHtmlBody($html, 'text/html');
				if (YII_ENV_PROD) {
				$mail->send();
				}else{
				$mail->send();	
				}
				//email ends
			

				if (YII_ENV_PROD) {
					//production
					$merchantCode = "203537015";
					$key = 'd?q4rkG]&KAh#vwnmSJ%';
				}else{
					//staging
					$merchantCode = "251108887711";// your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
					$key = '!G2S8WRBKJ6#&c~luOz=';// your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
				}

				$gmdate = gmdate('Y-m-d H:i:s');
				$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
				$hashAlgorithm = 'sha256';
				$hash = hash_hmac($hashAlgorithm , $string, $key);
				
				//$OrderReferenceNumber = $_GET['refno'];
				$OrderReferenceNumber = $_POST['REFNO'];
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

				$headers = array();
				$headers[] = 'Accept: application/json';
				$headers[] = 'Content-Type: application/json';
				$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				$curl_result = curl_exec($ch);
				
				$curlResult = json_decode($curl_result);
		//echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
				if (curl_errno($ch)) {
					//echo 'Error:' . curl_error($ch);
				}
				curl_close($ch);
				//echo '<br/>';


				//test email starts
						$html = $curl_result;
						$datetimenow = date('Y-m-d H:i:s');
					if (YII_ENV_PROD) {
						$email_subject = "Linkedfusion Production Server - Webhook Ipn Order Ref #".$OrderReferenceNumber." Response";//at $datetimenow
					}else{
						$email_subject = "Linkedfusion Staging Server - Webhook Ipn Order Ref #".$OrderReferenceNumber." Response";
					}
						$mail = Yii::$app->mailer->compose()
								->setTo('nikit@intricaretech.com')
								->setFrom(Yii::$app->params['adminEmail'])
								->setSubject($email_subject)
								->setHtmlBody($html, 'text/html');
						if (YII_ENV_PROD) {
						$mail->send();
						}else{
						//$mail->send();	
						}
				//test email ends

				$responseGetJson = json_encode($_REQUEST);
				$responseOrderJson = $curl_result;
				//$responseOrderJson = json_decode($curl_result,true);
				//$responseOrderJson = json_encode($responseOrderJson);
				
				$flagSubscriptionDataNotFoundEmailSend = false;
				
				if(($curlResult->Status=='COMPLETE' || $curlResult->Status=='AUTHRECEIVED') && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK'){

					//$merchant_order_id= $response_data->merchant_order_id;
					$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;
					
					$twoCo_CustomerReference = 0;
					if(isset($curlResult->CustomerDetails->CustomerReference)){
						$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference;
					}
					
					
					$connection = Yii::$app->db;
					
					//14-10-2020 : In below query, removed this condition:  order_number='".$OrderReferenceNumber."'
					$uph_row = $connection->createCommand("select id,userid,response_get from user_payment_history where merchant_id='".$merchant_order_id."' AND status='Initialize' AND ordertype='0' ORDER BY id DESC")->queryOne();
					//print_r($uph_row);
					if(!empty($uph_row)){
						//Usage of this code: For ordertype=0, Once the order is authorized, 2checkout will call this "webhookipn" method. The further process will be done from this code of block.
						
						if(isset($curlResult->Items[0]->ProductDetails->Name) && isset($curlResult->Items[0]->Code) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionStartDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->ExpirationDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionReference) ){
							//above condition added on 09-10-2020
							//to put here 09-10-2020

							$uph_pkid = $uph_row['id'];
							
							//14-10-2020 : order_number and 2coCustomerReference added here in below query as we should not depend on response method;
							$command = $connection->createCommand('UPDATE user_payment_history SET complete_date = "'.date("Y-m-d H:i:s").'", status="Success", order_number = "'.$OrderReferenceNumber.'", 2coCustomerReference = "'.$twoCo_CustomerReference.'" WHERE id='.$uph_pkid);
							$command->execute();
							
							if($uph_row['response_get']==NULL){
								
								$responseGetVar = array('refno'=>$_POST['REFNO'],'total'=>$_POST['IPN_TOTALGENERAL'],'total-currency'=>$_POST['CURRENCY']);
								$responseGetVar = json_encode($responseGetVar);
								
								$connection->createCommand("UPDATE `user_payment_history` SET `response_get` = '".$responseGetVar."' where `id` =".$uph_pkid)->execute();
							}
							
							
							
							$response_data = $_POST;//$_GET;
							
							$order_number= $_POST['REFNO'];//$_GET['refno'];//this is order's reference number;
								
							//$signature= $_GET['signature'];
							
							/*Old Orig code commented on 06-01-2021
							$lfaf_seat_purchased_userids='';
							$addifi = $curlResult->AdditionalFields;
							foreach($addifi as $res){
								if($res->Code=="lfaf_seat_purchased_userids"){
									$lfaf_seat_purchased_userids = $res->Value;
								}
							}

							//$lfaf_seat_purchased_userids = '{"LFPM":["14935","14988"],"LFUM":["14987"]}';
							
							$lfaf_seat_purchased_userids = stripslashes($lfaf_seat_purchased_userids);//added 31-07-2020: removes slash
							$lfaf_seat_purchased_useridsArr = json_decode($lfaf_seat_purchased_userids,true);
							*/

							//06-01-2021 starts (now take seat purchased userids from database instead of getting depended on API)
							$lfafSeatPurchased_useridsArr = array();
							$upo_result = $connection->createCommand("select product_id,user_ids from user_order_products where uph_id='".$uph_pkid."' ORDER BY id ASC")->queryAll();
							if(!empty($upo_result)){
								foreach($upo_result as $uporow){
									$lfafSeatPurchased_useridsArr[$uporow['product_id']] = explode(',',$uporow['user_ids']);
								}
							}
							//echo '<br/>:::New:<pre>';print_r($lfafSeatPurchased_useridsArr);echo '</pre>';
							//06-01-2021 ends
							$lfaf_seat_purchased_useridsArr = $lfafSeatPurchased_useridsArr;
							
							
							
							//$user_id = Yii::$app->session->get('userid');
							$user_id = $uph_row['userid'];//order placed by this userid;


							//new starts

							
							$selPlanUsrArr=array();
							
							
							$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7',
							'LFPSAR'=>'8',
							'LFPA'=>'9',
							'LFGSAR'=>'10',
							'LFGA'=>'11',
							'LFUSAR'=>'12',
							'LFUA'=>'13',
							'LFGM_v2'=>'18',
							'LFUM_v2'=>'19',
							'LFGSAR_v2'=>'20',
							'LFUSAR_v2'=>'21',
							'LFGA_v2'=>'22',
							'LFUA_v2'=>'23'
							);
							
							$Items = $curlResult->Items;
							/*
							echo '<br/>Items::<pre>'; print_r($Items);
							echo '<br/><br/>';
							foreach($Items as $item_key=>$item_res){
								echo $item_res->Code;
								echo '<br/>';print_r($item_res);
							}
							die;*/


							foreach($Items as $item_key=>$item_res){
								$product_id = $item_res->Code;//this is product code eg: LCPM
								$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
								$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
								$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
								$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
								

								$command = $connection->createCommand('UPDATE user_order_products SET SubscriptionStartDate = "'.$SubscriptionStartDate.'", ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE", SubscriptionReference="'.$SubscriptionReference.'" WHERE uph_id='.$uph_pkid.' AND product_id="'.$product_id.'" ');
								$command->execute();
								
								$uidsStrPerProduct = implode(',',$lfaf_seat_purchased_useridsArr[$product_id]);
								$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
								
								$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
								
								//starts
								$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus',
								'8'=>'Professional Semi-Annually',
								'9'=>'Professional Annually',
								'10'=>'Grow Semi-Annually',
								'11'=>'Grow Annually',
								'12'=>'Ultimate Semi-Annually',
								'13'=>'Ultimate Annually',
								'14'=>'New Grow Monthly',
								'15'=>'New Grow Annual',
								'16'=>'New Ultimate Monthly',
								'17'=>'New Ultimate Annual',
								'18'=>'Grow Monthly',
								'19'=>'Ultimate Monthly',
								'20'=>'Grow Semi-Annually',
								'21'=>'Ultimate Semi-Annually',
								'22'=>'Grow Annually',
								'23'=>'Ultimate Annually'
								);
								$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
								foreach($userIdArr as $uid){
									
									$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
									$previous_plan = $usrcommand['sublevel'];
									$isTrial = $usrcommand['trial'];
									
									$previous_plan = $previous_plan_array[$previous_plan];
									
									$current_plan = $previous_plan_array[$current_user_setting_plan];
									
									$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
									$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
									$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
									$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
									$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
								}
								//trial_expired_at = "'.$ExpirationDateTimestamp.'"
								$command = $connection->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$uidsStrPerProduct.')');
								$command->execute();
								//ends
								
								$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
								if(empty($uos_row)){
									Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
								}
								
								
							}
							//echo '<br/>SDFDF:<pre>'; print_r($selPlanUsrArr);
							
							//new ends

							$usrInfoOrdPlaced = $connection->createCommand("select email,first_name from user where id='".$user_id."' ")->queryOne();
							$emailId = $usrInfoOrdPlaced['email'];
							$emailId = $usrInfoOrdPlaced['first_name'];

							$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$usrInfoOrdPlaced['email'],'ses_full_name'=>$usrInfoOrdPlaced['first_name']);
							$this->successedPayment($payment_info);
							
							$connection->createCommand("UPDATE `user_payment_history` SET `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$uph_pkid)->execute();
							
							echo '<br>The End';
							
							//Yii::$app->session->set('success_message',"Successfully enabled subscription.");
							//return $this->redirect(['my-template/pricing']);

							
						}else{
							$flagSubscriptionDataNotFoundEmailSend = true;
							//if subscription data not found just send email;
						}
						
						
					}
					


					
				}
				
				//30-09-2020 starts
				if(($curlResult->Status=='COMPLETE' || $curlResult->Status=='AUTHRECEIVED') && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK'){
					//Usage:When manual renewal order is authorized, this code of block will process futher.
					
					$order_number= $OrderReferenceNumber;//this is order's reference number;
					$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;it is blank here.
					
					$uph_row = Yii::$app->db->createCommand("select t1.id, t1.response_get from user_payment_history t1 where t1.order_number='".$OrderReferenceNumber."' and t1.status='Initialize' and t1.ordertype='4' ORDER BY t1.id DESC")->queryOne();
					
					if(!empty($uph_row)){
						
						if(isset($curlResult->Items[0]->ProductDetails->Name) && isset($curlResult->Items[0]->Code) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionStartDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->ExpirationDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionReference) ){
							//above condition added on 09-10-2020
							//to put here 09-10-2020

							$newOrder_uphpkid = $lastuphid = $uph_row['id'];
							$response_get = json_decode($uph_row['response_get']);
							//echo '<pre>';print_r($response_get);
							$GETSubscriptionRef = $response_get->subscription;
							
							$responseGetJson = $uph_row['response_get'];
							
							$uph_row = Yii::$app->db->createCommand("select t1.id, t1.userid,t1.2coCustomerReference, t2.email, t2.username, t2.first_name, t2.last_name from user_payment_history t1 JOIN user t2 ON t1.userid=t2.id JOIN user_order_products t3 ON t1.id=t3.uph_id where t3.SubscriptionReference='".$GETSubscriptionRef."' ORDER BY t1.id DESC")->queryOne();
							if(!empty($uph_row)){
								$uph_pkid = $uph_row['id'];
								
								Yii::$app->db->createCommand('UPDATE user_payment_history SET complete_date = "'.date("Y-m-d H:i:s").'", status="Success" WHERE id='.$newOrder_uphpkid)->execute();
								

								$selPlanUsrArr=array();
								$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7',
								'LFPSAR'=>'8',
								'LFPA'=>'9',
								'LFGSAR'=>'10',
								'LFGA'=>'11',
								'LFUSAR'=>'12',
								'LFUA'=>'13',
								'LFGM_v2'=>'18',
								'LFUM_v2'=>'19',
								'LFGSAR_v2'=>'20',
								'LFUSAR_v2'=>'21',
								'LFGA_v2'=>'22',
								'LFUA_v2'=>'23'
								);
								/*
								$fullplanname_array = array('Free'=>'Free','Professional Monthly'=>'LFPM','Professional Quarterly'=>'LFPQ','Grow Monthly'=>'LFGM','Grow Quarterly'=>'LFGQ','Ultimate Monthly'=>'LFUM','Ultimate Quarterly'=>'LFUQ','Ultimate Plus'=>'LFUP',
								'Professional Semi-Annually'=>'LFPSAR',
								'Professional Annually'=>'LFPA',
								'Grow Semi-Annually'=>'LFGSAR',
								'Grow Annually'=>'LFGA',
								'Ultimate Semi-Annually'=>'LFUSAR',
								'Ultimate Annually'=>'LFUA',
								'Grow Monthly'=>'LFGM_v2',
								'Ultimate Monthly'=>'LFUM_v2',
								'Grow Semi-Annually'=>'LFGSAR_v2',
								'Ultimate Semi-Annually'=>'LFUSAR_v2',
								'Grow Annually'=>'LFGA_v2',
								'Ultimate Annually'=>'LFUA_v2'
								);
								*/
						
								$Items = $curlResult->Items;				

								foreach($Items as $item_key=>$item_res){
					
									
										$product_id = $item_res->Code;//this is product code eg: LCPM
										$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
										$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
										$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
										$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
										
										$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
										
										if($GETSubscriptionRef==$SubscriptionReference){
											
										
											$upo_row = Yii::$app->db->createCommand("select id,user_ids from user_order_products where uph_id =".$uph_pkid." AND product_id='".$product_id."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
											
											if(!empty($upo_row)){
												$upo_user_ids = $upo_row['user_ids'];
												
												//SubscriptionStartDate = "'.$SubscriptionStartDate.'"
												Yii::$app->db->createCommand('UPDATE user_order_products SET ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE" WHERE id='.$upo_row['id'])->execute();
												
												Yii::$app->db->createCommand("UPDATE `user_payment_history` SET user_ids = '".$upo_user_ids."' where id =".$lastuphid)->execute();
												
												
												$lfaf_seat_purchased_useridsArr = array();
												$lfaf_seat_purchased_useridsArr[$product_id] = explode(',',$upo_user_ids);
						

												//$uidsStrPerProduct = $upo_user_ids;
												$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
												
												
												//starts
												$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus',
												'8'=>'Professional Semi-Annually',
												'9'=>'Professional Annually',
												'10'=>'Grow Semi-Annually',
												'11'=>'Grow Annually',
												'12'=>'Ultimate Semi-Annually',
												'13'=>'Ultimate Annually',
												'14'=>'New Grow Monthly',
												'15'=>'New Grow Annual',
												'16'=>'New Ultimate Monthly',
												'17'=>'New Ultimate Annual',
												'18'=>'Grow Monthly',
												'19'=>'Ultimate Monthly',
												'20'=>'Grow Semi-Annually',
												'21'=>'Ultimate Semi-Annually',
												'22'=>'Grow Annually',
												'23'=>'Ultimate Annually'
												);
												$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
												foreach($userIdArr as $uid){
													
													$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
													$previous_plan = $usrcommand['sublevel'];
													$isTrial = $usrcommand['trial'];
													
													$previous_plan = $previous_plan_array[$previous_plan];
													
													$current_plan = $previous_plan_array[$current_user_setting_plan];
													
													$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
													$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
													$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
													$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
													$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
												}
												//trial_expired_at = "'.$ExpirationDateTimestamp.'"
												Yii::$app->db->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
												//ends
												
												$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$uph_row['email'],'ses_full_name'=>$uph_row['first_name'].' '.$uph_row['last_name'],'responseGetJson'=> $responseGetJson,'GETSubscriptionRef'=>$GETSubscriptionRef);
												$this->renewedSuccessedPayment($payment_info);
												
												
												$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
												if(empty($uos_row)){
													Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
												}
												
												echo '<br/>The end';
												
											}

										}
								}							
								
							}


						}else{
							$flagSubscriptionDataNotFoundEmailSend = true;
							//if subscription data not found just send email;
						}
						
						
					}
					
				}
				//30-09-2020 ends


				//09-10-2020 starts
				if($flagSubscriptionDataNotFoundEmailSend==true){
					//if subscription data not found just send email;
					//email starts
			
						$html = 'Hello Admin,<br/><br/>For Order Ref #'.$OrderReferenceNumber.' IPN is called but it does not yet contain Subscription Data. So, for this user sublevel and other data are not updated.<br/>For smooth experience, manually call actionWebhookIpn method by passing valid post variables.<br/><br/>Below post data received:<br>';
						$html.= json_encode($_POST,JSON_PRETTY_PRINT);
						
					if (YII_ENV_PROD) {
						$email_subject = "Linkedfusion Production Server - Webhook Ipn Order Ref #".$OrderReferenceNumber." Called But Not Having Subscription Data";
						$to_email = ['arpan@intricare.net','nikit@intricaretech.com'];
					}else{
						$email_subject = "Linkedfusion Staging Server - Webhook Ipn Order Ref #".$OrderReferenceNumber." Called But Not Having Subscription Data";
						$to_email = 'nikit@intricaretech.com';
					}
						$mail = Yii::$app->mailer->compose()
								->setTo($to_email)
								->setFrom(Yii::$app->params['adminEmail'])
								->setSubject($email_subject)
								->setHtmlBody($html, 'text/html');
						$mail->send();
					//email ends
				}
				//09-10-2020 ends


			}
			

			if($isLfBlackFridayProductInIPN){
				//This code block is only for LF Blackfriday products;
				//Blackfriday products recurring nathi. only 1 time. Blackfriday products ma upgrade subscription, cancel subscription nai aave; also, auto/manual renewal pan nai aave;
				
				//email starts
					if (YII_ENV_PROD) {
						$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - Webhook Ipn Blackfriday";
					}else{
						$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - Webhook Ipn Blackfriday";
					}
				$html = json_encode($_POST,JSON_PRETTY_PRINT);
				$html.= '<br/>Timestamp:'.strtotime('now');
				$mail = Yii::$app->mailer->compose()
						->setTo('nikit@intricaretech.com')
						->setFrom(Yii::$app->params['adminEmail'])
						->setSubject($email_subject)
						->setHtmlBody($html, 'text/html');
				if (YII_ENV_PROD) {
				$mail->send();
				}else{
					
				}
				//email ends
				
				//order response email send starts
				if (YII_ENV_PROD) {
					//production
					$merchantCode = "203537015";
					$key = 'd?q4rkG]&KAh#vwnmSJ%';
				}else{
					//staging
					$merchantCode = "251108887711";// your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
					$key = '!G2S8WRBKJ6#&c~luOz=';// your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
				}

				$gmdate = gmdate('Y-m-d H:i:s');
				$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
				$hashAlgorithm = 'sha256';
				$hash = hash_hmac($hashAlgorithm , $string, $key);
				
				//$OrderReferenceNumber = $_GET['refno'];
				$OrderReferenceNumber = $_POST['REFNO'];
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

				$headers = array();
				$headers[] = 'Accept: application/json';
				$headers[] = 'Content-Type: application/json';
				$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				$curl_result = curl_exec($ch);
				
				$curlResult = json_decode($curl_result);
				//echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
				if (curl_errno($ch)) {
					//echo 'Error:' . curl_error($ch);
				}
				curl_close($ch);
				//echo '<br/>';


				//test email starts
						$html = $curl_result;
						$datetimenow = date('Y-m-d H:i:s');
					if (YII_ENV_PROD) {
						$email_subject = "Linkedfusion Production Server - Blackfriday Webhook Ipn Order Ref #".$OrderReferenceNumber." Response";//at $datetimenow
					}else{
						$email_subject = "Linkedfusion Staging Server - Blackfriday Webhook Ipn Order Ref #".$OrderReferenceNumber." Response";
					}
						$mail = Yii::$app->mailer->compose()
								->setTo('nikit@intricaretech.com')
								->setFrom(Yii::$app->params['adminEmail'])
								->setSubject($email_subject)
								->setHtmlBody($html, 'text/html');
						if (YII_ENV_PROD) {
						$mail->send();
						}else{
							
						}
				//test email ends
				//order response email send ends

				$responseGetJson = json_encode($_REQUEST);
				$responseOrderJson = $curl_result;
				//$responseOrderJson = json_decode($curl_result,true);
				//$responseOrderJson = json_encode($responseOrderJson);
				
				
				
				if(($curlResult->Status=='COMPLETE' || $curlResult->Status=='AUTHRECEIVED') && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK'){

					//$merchant_order_id= $response_data->merchant_order_id;
					$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;
					
					$twoCo_CustomerReference = 0;
					if(isset($curlResult->CustomerDetails->CustomerReference)){
						$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference;
					}
					
					
					$connection = Yii::$app->db;
					
					
					$uph_row = $connection->createCommand("select id,userid,response_get from user_payment_history where merchant_id='".$merchant_order_id."' AND status='Initialize' AND ordertype='0' ORDER BY id DESC")->queryOne();
					//print_r($uph_row);
					if(!empty($uph_row)){
						//Usage of this code: For ordertype=0, Once the order is authorized, 2checkout will call this "webhookipn" method. The further process will be done from this code of block.
						
						if(isset($curlResult->Items[0]->ProductDetails->Name) && isset($curlResult->Items[0]->Code) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionStartDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionReference) ){
							
							

							$uph_pkid = $uph_row['id'];
							
							//14-10-2020 : order_number and 2coCustomerReference added here in below query as we should not depend on response method;
							$command = $connection->createCommand('UPDATE user_payment_history SET complete_date = "'.date("Y-m-d H:i:s").'", status="Success", order_number = "'.$OrderReferenceNumber.'", 2coCustomerReference = "'.$twoCo_CustomerReference.'" WHERE id='.$uph_pkid);
							$command->execute();
							
							if($uph_row['response_get']==NULL){
								
								$responseGetVar = array('refno'=>$_POST['REFNO'],'total'=>$_POST['IPN_TOTALGENERAL'],'total-currency'=>$_POST['CURRENCY']);
								$responseGetVar = json_encode($responseGetVar);
								
								$connection->createCommand("UPDATE `user_payment_history` SET `response_get` = '".$responseGetVar."' where `id` =".$uph_pkid)->execute();
							}
							
							
							
							$response_data = $_POST;//$_GET;
							
							$order_number= $_POST['REFNO'];//$_GET['refno'];//this is order's reference number;
								
							//$signature= $_GET['signature'];
							
							/*Old Orig code commented on 06-01-2021
							$lfaf_seat_purchased_userids='';
							$addifi = $curlResult->AdditionalFields;
							foreach($addifi as $res){
								if($res->Code=="lfaf_seat_purchased_userids"){
									$lfaf_seat_purchased_userids = $res->Value;
								}
							}

							//$lfaf_seat_purchased_userids = '{"LFPSA":["14935","14988"],"LFGSA":["14987"]}';
							
							$lfaf_seat_purchased_userids = stripslashes($lfaf_seat_purchased_userids);//added 31-07-2020: removes slash
							$lfaf_seat_purchased_useridsArr = json_decode($lfaf_seat_purchased_userids,true);
							*/

							//06-01-2021 starts (now take seat purchased userids from database instead of getting depended on API)
							$lfafSeatPurchased_useridsArr = array();
							$upo_result = $connection->createCommand("select product_id,user_ids from user_order_products where uph_id='".$uph_pkid."' ORDER BY id ASC")->queryAll();
							if(!empty($upo_result)){
								foreach($upo_result as $uporow){
									$lfafSeatPurchased_useridsArr[$uporow['product_id']] = explode(',',$uporow['user_ids']);
								}
							}
							//echo '<br/>:::New:<pre>';print_r($lfafSeatPurchased_useridsArr);echo '</pre>';
							//06-01-2021 ends
							$lfaf_seat_purchased_useridsArr = $lfafSeatPurchased_useridsArr;
							
							
							
							//$user_id = Yii::$app->session->get('userid');
							$user_id = $uph_row['userid'];//order placed by this userid;


							//new starts

							
							$selPlanUsrArr=array();
							
							
							$current_user_setting_plan_array = array('0'=>'Free','LFPSA'=>'1','LFPABF'=>'2','LFGSA'=>'3','LFGABF'=>'4','LFUSA'=>'5','LFUABF'=>'6','LFUP'=>'7',
							'LFPSAR'=>'8',
							'LFPA'=>'9',
							'LFGSAR'=>'10',
							'LFGA'=>'11',
							'LFUSAR'=>'12',
							'LFUA'=>'13',
							'LFGM_v2'=>'18',
							'LFUM_v2'=>'19',
							'LFGSAR_v2'=>'20',
							'LFUSAR_v2'=>'21',
							'LFGA_v2'=>'22',
							'LFUA_v2'=>'23'
							);
							
							$Items = $curlResult->Items;
							/*
							echo '<br/>Items::<pre>'; print_r($Items);
							echo '<br/><br/>';
							foreach($Items as $item_key=>$item_res){
								echo $item_res->Code;
								echo '<br/>';print_r($item_res);
							}
							die;*/


							foreach($Items as $item_key=>$item_res){
								$product_id = $item_res->Code;//this is product code eg: LFPSA
								$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
								//$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;//this value will be blank for blackfriday products;

								if($product_id=='LFPSA' || $product_id=='LFGSA' || $product_id=='LFUSA'){
									//for blackfriday Semi Annual plans
									$ExpirationDate = date('Y-m-d H:i:s', strtotime($SubscriptionStartDate. ' + 6 months'));
								}else{
									//for blackfriday Annual plans
									$ExpirationDate = date('Y-m-d H:i:s', strtotime($SubscriptionStartDate. ' + 1 year'));
								}
								
								//$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
								$ExpirationDateTimestamp = strtotime($ExpirationDate) * 1000;
								$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
								

								$command = $connection->createCommand('UPDATE user_order_products SET SubscriptionStartDate = "'.$SubscriptionStartDate.'", ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE", SubscriptionReference="'.$SubscriptionReference.'" WHERE uph_id='.$uph_pkid.' AND product_id="'.$product_id.'" ');
								$command->execute();
								
								$uidsStrPerProduct = implode(',',$lfaf_seat_purchased_useridsArr[$product_id]);
								$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
								
								$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
								
								//starts
								$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus',
								'8'=>'Professional Semi-Annually',
								'9'=>'Professional Annually',
								'10'=>'Grow Semi-Annually',
								'11'=>'Grow Annually',
								'12'=>'Ultimate Semi-Annually',
								'13'=>'Ultimate Annually',
								'14'=>'New Grow Monthly',
								'15'=>'New Grow Annual',
								'16'=>'New Ultimate Monthly',
								'17'=>'New Ultimate Annual',
								'18'=>'Grow Monthly',
								'19'=>'Ultimate Monthly',
								'20'=>'Grow Semi-Annually',
								'21'=>'Ultimate Semi-Annually',
								'22'=>'Grow Annually',
								'23'=>'Ultimate Annually'
								);
								
								$lfblackfriday_plan_array = array('0'=>'Free','1'=>'Professional Semi Annual Black Friday','2'=>'Professional Annual Black Friday','3'=>'Grow Semi Annual Black Friday','4'=>'Grow Annual Black Friday','5'=>'Ultimate Semi Annual Black Friday','6'=>'Ultimate Annual Black Friday','7'=>'Ultimate Plus');
								
								$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
								foreach($userIdArr as $uid){
									
									$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
									$previous_plan = $usrcommand['sublevel'];
									$isTrial = $usrcommand['trial'];
									
									$previous_plan = $previous_plan_array[$previous_plan];
									
									//$current_plan = $previous_plan_array[$current_user_setting_plan];
									$current_plan = $lfblackfriday_plan_array[$current_user_setting_plan];
									
									$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
									$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
									$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
									$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
									$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
								}
								//trial_expired_at = "'.$ExpirationDateTimestamp.'"
								$command = $connection->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, trial_expired_at = "'.$ExpirationDateTimestamp.'", cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$uidsStrPerProduct.')');
								$command->execute();
								//ends
								
								$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
								if(empty($uos_row)){
									Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
								}
								
								
							}
							//echo '<br/>SDFDF:<pre>'; print_r($selPlanUsrArr);
							
							//new ends

							$usrInfoOrdPlaced = $connection->createCommand("select email,first_name from user where id='".$user_id."' ")->queryOne();
							$emailId = $usrInfoOrdPlaced['email'];
							$emailId = $usrInfoOrdPlaced['first_name'];

							$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$usrInfoOrdPlaced['email'],'ses_full_name'=>$usrInfoOrdPlaced['first_name']);
							$this->successedPayment($payment_info);
							
							$connection->createCommand("UPDATE `user_payment_history` SET `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$uph_pkid)->execute();
							
							echo '<br>The End';
							
							//Yii::$app->session->set('success_message',"Successfully enabled subscription.");
							//return $this->redirect(['my-template/pricing']);

							
						}else{
							
							//if subscription data not found just send email;
							//email starts
					
								$html = 'Hello Admin,<br/><br/>For Order Ref #'.$OrderReferenceNumber.' IPN is called but it does not yet contain Subscription Data. So, for this user sublevel and other data are not updated.<br/>For smooth experience, manually call actionWebhookIpn method by passing valid post variables.<br/><br/>Below post data received:<br>';
								$html.= json_encode($_POST,JSON_PRETTY_PRINT);
								
							if (YII_ENV_PROD) {
								$email_subject = "Linkedfusion Production Server - Blackfriday Webhook Ipn Order Ref #".$OrderReferenceNumber." Called But Not Having Subscription Data";
								$to_email = ['arpan@intricare.net','nikit@intricaretech.com'];
							}else{
								$email_subject = "Linkedfusion Staging Server - Blackfriday Webhook Ipn Order Ref #".$OrderReferenceNumber." Called But Not Having Subscription Data";
								$to_email = 'nikit@intricaretech.com';
							}
								$mail = Yii::$app->mailer->compose()
										->setTo($to_email)
										->setFrom(Yii::$app->params['adminEmail'])
										->setSubject($email_subject)
										->setHtmlBody($html, 'text/html');
								$mail->send();
							//email ends
							
						}
						
						
					}
					


					
				}

				
			}
			
		}
		
		//ipn hash code starts here
		if(isset($_POST['HASH'])){
			if (YII_ENV_PROD) {
				$secret_key = 'd?q4rkG]&KAh#vwnmSJ%'; //2checkout secret_key
			}else{
				$secret_key = '!G2S8WRBKJ6#&c~luOz=';
			}
			date_default_timezone_set('UTC');
			//PARAMETERS
			$IPN_parameters = array(); 
			$IPN_parameters['SALEDATE'] = $_POST['SALEDATE'];
			$IPN_parameters['REFNO'] = $_POST['REFNO'];
			$IPN_parameters['REFNOEXT'] = $_POST['REFNOEXT'];
			$IPN_parameters['ORDERNO'] = $_POST['ORDERNO']; 
			$IPN_parameters['ORDERSTATUS'] = $_POST['ORDERSTATUS'];
			$IPN_parameters['PAYMETHOD'] = $_POST['PAYMETHOD'];
			$IPN_parameters['FIRSTNAME'] = $_POST['FIRSTNAME'];
			$IPN_parameters['LASTNAME'] = $_POST['LASTNAME'];
			$IPN_parameters['COMPANY'] = $_POST['COMPANY'];
			$IPN_parameters['REGISTRATIONNUMBER'] = $_POST['REGISTRATIONNUMBER'];
			$IPN_parameters['FISCALCODE'] = $_POST['FISCALCODE'];
			$IPN_parameters['CBANKNAME'] = $_POST['CBANKNAME'];
			$IPN_parameters['CBANKACCOUNT'] = $_POST['CBANKACCOUNT'];
			$IPN_parameters['ADDRESS1'] = $_POST['ADDRESS1'];
			$IPN_parameters['ADDRESS2'] = $_POST['ADDRESS2'];
			$IPN_parameters['CITY'] = $_POST['CITY'];
			$IPN_parameters['STATE'] = $_POST['STATE'];
			$IPN_parameters['ZIPCODE'] = $_POST['ZIPCODE'];
			$IPN_parameters['COUNTRY'] = $_POST['COUNTRY'];
			$IPN_parameters['PHONE'] = $_POST['PHONE'];
			$IPN_parameters['FAX'] = $_POST['FAX'];
			$IPN_parameters['CUSTOMEREMAIL'] = $_POST['CUSTOMEREMAIL'];
			$IPN_parameters['FIRSTNAME_D'] = $_POST['FIRSTNAME_D'];
			$IPN_parameters['LASTNAME_D'] = $_POST['LASTNAME_D'];
			$IPN_parameters['COMPANY_D'] = $_POST['COMPANY_D'];
			$IPN_parameters['ADDRESS1_D'] = $_POST['ADDRESS1_D'];
			$IPN_parameters['ADDRESS2_D'] = $_POST['ADDRESS2_D'];
			$IPN_parameters['CITY_D'] = $_POST['CITY_D'];
			$IPN_parameters['STATE_D'] = $_POST['STATE_D'];
			$IPN_parameters['ZIPCODE_D'] = $_POST['ZIPCODE_D'];
			$IPN_parameters['COUNTRY_D'] = $_POST['COUNTRY_D'];
			$IPN_parameters['PHONE_D'] = $_POST['PHONE_D'];
			$IPN_parameters['IPADDRESS'] = $_POST['IPADDRESS'];
			$IPN_parameters['CURRENCY'] = $_POST['CURRENCY'];
			$IPN_parameters['IPN_PID'][0] = $_POST['IPN_PID'][0];
			$IPN_parameters['IPN_PNAME'][0] = $_POST['IPN_PNAME'][0];
			$IPN_parameters['IPN_PCODE'][0] = $_POST['IPN_PCODE'][0];
			$IPN_parameters['IPN_INFO'][0] = $_POST['IPN_INFO'][0];
			$IPN_parameters['IPN_QTY'][0] = $_POST['IPN_QTY'][0];
			$IPN_parameters['IPN_PRICE'][0] = $_POST['IPN_PRICE'][0];
			$IPN_parameters['IPN_VAT'][0] = $_POST['IPN_VAT'][0];
			$IPN_parameters['IPN_VER'][0] = $_POST['IPN_VER'][0];
			$IPN_parameters['IPN_DISCOUNT'][0] = $_POST['IPN_DISCOUNT'][0];
			$IPN_parameters['IPN_PROMONAME'][0] = $_POST['IPN_PROMONAME'][0];
			$IPN_parameters['IPN_DELIVEREDCODES'][0] = $_POST['IPN_DELIVEREDCODES'][0];
			$IPN_parameters['IPN_TOTAL'][0] = $_POST['IPN_TOTAL'][0];
			$IPN_parameters['IPN_TOTALGENERAL'] = $_POST['IPN_TOTALGENERAL'];
			$IPN_parameters['IPN_SHIPPING'] = $_POST['IPN_SHIPPING'];
			$IPN_parameters['IPN_COMMISSION'] = $_POST['IPN_COMMISSION'];
			$IPN_parameters['IPN_DATE'] = $_POST['IPN_DATE'];
			$IPN_parameters['TEST_ORDER'] = $_POST['TEST_ORDER'];
			$tabble = $this->createtablefromarrayipntwooct($IPN_parameters);
			$email_html=$tabble;
			//*********Base string for HMAC_MD5 calculation:*********
			//echo "<br/><br/>This is the base string for HMAC_MD5 calculation:<br/>";
			$email_html.=  "<br/><br/>This is the base string for HMAC_MD5 calculation:<br/>";
			$result = '';
			foreach ($IPN_parameters as $key => $val){
				$result .= $this->arrayexpandipntwooct((array)$val);
			}
			//var_dump($result);
			//$email_html.=print_r($result,true);
			$email_html.=$result;
			//*********Calculated HMAC_MD5 signature:*********
			//echo "<br/><br/>This is the HMAC_MD5 signature:<br/>";
			$email_html.="<br/><br/>This is the HMAC_MD5 signature:<br/>";
			$hash =  $this->hmacipntwooct($secret_key, $result);
			$IPN_parameters['HASH']=$hash;
			//var_dump($hash);
			//$email_html.=print_r($hash,true);
			$email_html.=$hash;
			//*********Response:*********
			$IPN_parameters_response = array();
			$IPN_parameters_response['IPN_PID'][0] = $_POST['IPN_PID'][0];
			$IPN_parameters_response['IPN_PNAME'][0] = $_POST['IPN_PNAME'][0];
			$IPN_parameters_response['IPN_DATE'] = $_POST['IPN_DATE'];
			//$IPN_parameters_response['DATE'] = $_POST['IPN_DATE'];
			//$IPN_parameters_response['DATE'] = date('YmdHis');//NR
			$IPN_parameters_response['DATE'] = gmdate('YmdHis');//NR
			//*********Response base string for HMAC_MD5 calculation:*********
			//echo "<br/><br/>This is the response base string for HMAC_MD5 calculation:<br/>";
			$email_html.="<br/><br/>This is the response base string for HMAC_MD5 calculation:<br/>";
			$result_response = '';
			foreach ($IPN_parameters_response as $key => $val){
				$result_response .= $this->arrayexpandipntwooct((array)$val);
			}
			//var_dump($result_response);
			//$email_html.=print_r($result_response,true);
			$email_html.=$result_response;
			//*********Calculated response HMAC_MD5 signature:*********
			//echo "<br/><br/>This is the response HMAC_MD5 signature:<br/>";
			$email_html.="<br/><br/>This is the response HMAC_MD5 signature:<br/>";
			$hash =  $this->hmacipntwooct($secret_key, $result_response);
			$link_params['HASH']=$hash;
			//var_dump($hash);
			//$email_html.=print_r($hash,true);
			$email_html.=$hash;
			//Expected response
			//echo 'Expected response: '.'&lt;EPAYMENT&gt;'.$IPN_parameters_response['DATE'].'|'.$hash.'&lt;/EPAYMENT&gt;';
			echo '<EPAYMENT>'.$IPN_parameters_response['DATE'].'|'.$hash.'</EPAYMENT>';
			$email_html.='<br/><br/>Expected response: '.'&lt;EPAYMENT&gt;'.$IPN_parameters_response['DATE'].'|'.$hash.'&lt;/EPAYMENT&gt;';

			
			//email starts
				if (YII_ENV_PROD) {
					$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - WebhookIpn demo hash signature email";
				}else{
					$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - WebhookIpn demo hash signature email";
				}
			$html = $email_html;
			$mail = Yii::$app->mailer->compose()
					->setTo('nikit@intricaretech.com')
					->setFrom(Yii::$app->params['adminEmail'])
					->setSubject($email_subject)
					->setHtmlBody($html, 'text/html');
			//$mail->send();
			//email ends
		}
		//ipn hash code ends here
		
	}

	//NR:24-06-2021: DO NOT DELETE - This is current method. adding Add-on pack product into normal recurring plan section.;
	public function actionWebhookIpn(){
		ini_set('display_errors', 1);
		ini_set('display_startup_errors', 1);
		error_reporting(E_ALL);
		


		//ipn hash code starts here
		if(isset($_POST['HASH'])){
			if (YII_ENV_PROD) {
				$secret_key = 'd?q4rkG]&KAh#vwnmSJ%'; //2checkout secret_key
			}else{
				$secret_key = '!G2S8WRBKJ6#&c~luOz=';
			}
			date_default_timezone_set('UTC');
			//PARAMETERS
			$IPN_parameters = array(); 
			$IPN_parameters['SALEDATE'] = $_POST['SALEDATE'];
			$IPN_parameters['REFNO'] = $_POST['REFNO'];
			$IPN_parameters['REFNOEXT'] = $_POST['REFNOEXT'];
			$IPN_parameters['ORDERNO'] = $_POST['ORDERNO']; 
			$IPN_parameters['ORDERSTATUS'] = $_POST['ORDERSTATUS'];
			$IPN_parameters['PAYMETHOD'] = $_POST['PAYMETHOD'];
			$IPN_parameters['FIRSTNAME'] = $_POST['FIRSTNAME'];
			$IPN_parameters['LASTNAME'] = $_POST['LASTNAME'];
			$IPN_parameters['COMPANY'] = $_POST['COMPANY'];
			$IPN_parameters['REGISTRATIONNUMBER'] = $_POST['REGISTRATIONNUMBER'];
			$IPN_parameters['FISCALCODE'] = $_POST['FISCALCODE'];
			$IPN_parameters['CBANKNAME'] = $_POST['CBANKNAME'];
			$IPN_parameters['CBANKACCOUNT'] = $_POST['CBANKACCOUNT'];
			$IPN_parameters['ADDRESS1'] = $_POST['ADDRESS1'];
			$IPN_parameters['ADDRESS2'] = $_POST['ADDRESS2'];
			$IPN_parameters['CITY'] = $_POST['CITY'];
			$IPN_parameters['STATE'] = $_POST['STATE'];
			$IPN_parameters['ZIPCODE'] = $_POST['ZIPCODE'];
			$IPN_parameters['COUNTRY'] = $_POST['COUNTRY'];
			$IPN_parameters['PHONE'] = $_POST['PHONE'];
			$IPN_parameters['FAX'] = $_POST['FAX'];
			$IPN_parameters['CUSTOMEREMAIL'] = $_POST['CUSTOMEREMAIL'];
			$IPN_parameters['FIRSTNAME_D'] = $_POST['FIRSTNAME_D'];
			$IPN_parameters['LASTNAME_D'] = $_POST['LASTNAME_D'];
			$IPN_parameters['COMPANY_D'] = $_POST['COMPANY_D'];
			$IPN_parameters['ADDRESS1_D'] = $_POST['ADDRESS1_D'];
			$IPN_parameters['ADDRESS2_D'] = $_POST['ADDRESS2_D'];
			$IPN_parameters['CITY_D'] = $_POST['CITY_D'];
			$IPN_parameters['STATE_D'] = $_POST['STATE_D'];
			$IPN_parameters['ZIPCODE_D'] = $_POST['ZIPCODE_D'];
			$IPN_parameters['COUNTRY_D'] = $_POST['COUNTRY_D'];
			$IPN_parameters['PHONE_D'] = $_POST['PHONE_D'];
			$IPN_parameters['IPADDRESS'] = $_POST['IPADDRESS'];
			$IPN_parameters['CURRENCY'] = $_POST['CURRENCY'];
			$IPN_parameters['IPN_PID'][0] = $_POST['IPN_PID'][0];
			$IPN_parameters['IPN_PNAME'][0] = $_POST['IPN_PNAME'][0];
			$IPN_parameters['IPN_PCODE'][0] = $_POST['IPN_PCODE'][0];
			$IPN_parameters['IPN_INFO'][0] = $_POST['IPN_INFO'][0];
			$IPN_parameters['IPN_QTY'][0] = $_POST['IPN_QTY'][0];
			$IPN_parameters['IPN_PRICE'][0] = $_POST['IPN_PRICE'][0];
			$IPN_parameters['IPN_VAT'][0] = $_POST['IPN_VAT'][0];
			$IPN_parameters['IPN_VER'][0] = $_POST['IPN_VER'][0];
			$IPN_parameters['IPN_DISCOUNT'][0] = $_POST['IPN_DISCOUNT'][0];
			$IPN_parameters['IPN_PROMONAME'][0] = $_POST['IPN_PROMONAME'][0];
			$IPN_parameters['IPN_DELIVEREDCODES'][0] = $_POST['IPN_DELIVEREDCODES'][0];
			$IPN_parameters['IPN_TOTAL'][0] = $_POST['IPN_TOTAL'][0];
			$IPN_parameters['IPN_TOTALGENERAL'] = $_POST['IPN_TOTALGENERAL'];
			$IPN_parameters['IPN_SHIPPING'] = $_POST['IPN_SHIPPING'];
			$IPN_parameters['IPN_COMMISSION'] = $_POST['IPN_COMMISSION'];
			$IPN_parameters['IPN_DATE'] = $_POST['IPN_DATE'];
			$IPN_parameters['TEST_ORDER'] = $_POST['TEST_ORDER'];
			$tabble = $this->createtablefromarrayipntwooct($IPN_parameters);
			$email_html=$tabble;
			//*********Base string for HMAC_MD5 calculation:*********
			//echo "<br/><br/>This is the base string for HMAC_MD5 calculation:<br/>";
			$email_html.=  "<br/><br/>This is the base string for HMAC_MD5 calculation:<br/>";
			$result = '';
			foreach ($IPN_parameters as $key => $val){
				$result .= $this->arrayexpandipntwooct((array)$val);
			}
			//var_dump($result);
			//$email_html.=print_r($result,true);
			$email_html.=$result;
			//*********Calculated HMAC_MD5 signature:*********
			//echo "<br/><br/>This is the HMAC_MD5 signature:<br/>";
			$email_html.="<br/><br/>This is the HMAC_MD5 signature:<br/>";
			$hash =  $this->hmacipntwooct($secret_key, $result);
			$IPN_parameters['HASH']=$hash;
			//var_dump($hash);
			//$email_html.=print_r($hash,true);
			$email_html.=$hash;
			//*********Response:*********
			$IPN_parameters_response = array();
			$IPN_parameters_response['IPN_PID'][0] = $_POST['IPN_PID'][0];
			$IPN_parameters_response['IPN_PNAME'][0] = $_POST['IPN_PNAME'][0];
			$IPN_parameters_response['IPN_DATE'] = $_POST['IPN_DATE'];
			//$IPN_parameters_response['DATE'] = $_POST['IPN_DATE'];
			//$IPN_parameters_response['DATE'] = date('YmdHis');//NR
			$IPN_parameters_response['DATE'] = gmdate('YmdHis');//NR
			//*********Response base string for HMAC_MD5 calculation:*********
			//echo "<br/><br/>This is the response base string for HMAC_MD5 calculation:<br/>";
			$email_html.="<br/><br/>This is the response base string for HMAC_MD5 calculation:<br/>";
			$result_response = '';
			foreach ($IPN_parameters_response as $key => $val){
				$result_response .= $this->arrayexpandipntwooct((array)$val);
			}
			//var_dump($result_response);
			//$email_html.=print_r($result_response,true);
			$email_html.=$result_response;
			//*********Calculated response HMAC_MD5 signature:*********
			//echo "<br/><br/>This is the response HMAC_MD5 signature:<br/>";
			$email_html.="<br/><br/>This is the response HMAC_MD5 signature:<br/>";
			$hash =  $this->hmacipntwooct($secret_key, $result_response);
			$link_params['HASH']=$hash;
			//var_dump($hash);
			//$email_html.=print_r($hash,true);
			$email_html.=$hash;
			//Expected response
			//echo 'Expected response: '.'&lt;EPAYMENT&gt;'.$IPN_parameters_response['DATE'].'|'.$hash.'&lt;/EPAYMENT&gt;';
			echo '<EPAYMENT>'.$IPN_parameters_response['DATE'].'|'.$hash.'</EPAYMENT>';
			$email_html.='<br/><br/>Expected response: '.'&lt;EPAYMENT&gt;'.$IPN_parameters_response['DATE'].'|'.$hash.'&lt;/EPAYMENT&gt;';

			
			//email starts
				if (YII_ENV_PROD) {
					$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - WebhookIpn demo hash signature email";
				}else{
					$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - WebhookIpn demo hash signature email";
				}
			$html = $email_html;
			$mail = Yii::$app->mailer->compose()
					->setTo('nikit@intricaretech.com')
					->setFrom(Yii::$app->params['adminEmail'])
					->setSubject($email_subject)
					->setHtmlBody($html, 'text/html');
			//$mail->send();
			//email ends
		}
		//ipn hash code ends here
		
	}
	
	//NR: This method after AddOnPackProduct products added into blackfriday section which is useless, as now addOn pack product is recurring product;
	public function actionWebhookIpn_BkpMethodAddOnPackIntoBlackFridaySection(){
		ini_set('display_errors', 1);
		ini_set('display_startup_errors', 1);
		error_reporting(E_ALL);
		
		if(isset($_POST['HASH'])){
			
			//data coming from 2checkout will be in post method.

			$isLfProductInIPN = false;
			$isLfBlackFridayProductInIPN = false;
			$isLfAddOnPackExclusiveOrder = false;
			if(isset($_POST['IPN_PCODE'][0])){
				$allLfProductCodesArr = array(
					"LFPM",
					"LFPQ",
					"LFGM",
					"LFGQ",
					"LFUM",
					"LFUQ",
					"LFPSAR",
					"LFPA",
					"LFGSAR",
					"LFGA",
					"LFUSAR",
					"LFUA",
					"LFGM_v2",
					"LFUM_v2",
					"LFGSAR_v2",
					"LFUSAR_v2",
					"LFGA_v2",
					"LFUA_v2",
					);

				$allLfBlackFridayProductCodesArr = array(
					"LFPSA",
					"LFPABF",
					"LFGSA",
					"LFGABF",
					"LFUSA",
					"LFUABF"
					);
					
				$allLfAddOnPackProductCodesArr = array(
					"LFAddOnPack"
					);					
				if(in_array($_POST['IPN_PCODE'][0],$allLfProductCodesArr)){
					$isLfProductInIPN = true;
				}

				if(in_array($_POST['IPN_PCODE'][0],$allLfBlackFridayProductCodesArr)){
					$isLfBlackFridayProductInIPN = true;
				}
				//18-06-2021 starts
				foreach($_POST['IPN_PCODE'] as $key=>$val){
					if(in_array($val,$allLfAddOnPackProductCodesArr)){
						$isLfAddOnPackExclusiveOrder = true;
					}
				}
				
				if($isLfAddOnPackExclusiveOrder==true){
					$cnt_PEO=0;
					foreach($_POST['IPN_PCODE'] as $key=>$val){
						if(in_array($val,$allLfProductCodesArr)){
							$cnt_PEO++;
						}
					}
					if($cnt_PEO>0){
						$isLfAddOnPackExclusiveOrder = false;
					}
				}
				//18-06-2021 ends
				

			}else{
				//let it process.
				$isLfProductInIPN = true;
			}
			
			if($isLfProductInIPN){
				
				//email starts
					if (YII_ENV_PROD) {
						$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - Webhook Ipn";
					}else{
						$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - Webhook Ipn";
					}
				$html = json_encode($_POST,JSON_PRETTY_PRINT);
				$html.= '<br/>Timestamp:'.strtotime('now');
				$mail = Yii::$app->mailer->compose()
						->setTo('nikit@intricaretech.com')
						->setFrom(Yii::$app->params['adminEmail'])
						->setSubject($email_subject)
						->setHtmlBody($html, 'text/html');
				if (YII_ENV_PROD) {
				$mail->send();
				}else{
				$mail->send();	
				}
				//email ends
			

				if (YII_ENV_PROD) {
					//production
					$merchantCode = "203537015";
					$key = 'd?q4rkG]&KAh#vwnmSJ%';
				}else{
					//staging
					$merchantCode = "251108887711";// your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
					$key = '!G2S8WRBKJ6#&c~luOz=';// your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
				}

				$gmdate = gmdate('Y-m-d H:i:s');
				$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
				$hashAlgorithm = 'sha256';
				$hash = hash_hmac($hashAlgorithm , $string, $key);
				
				//$OrderReferenceNumber = $_GET['refno'];
				$OrderReferenceNumber = $_POST['REFNO'];
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

				$headers = array();
				$headers[] = 'Accept: application/json';
				$headers[] = 'Content-Type: application/json';
				$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				$curl_result = curl_exec($ch);
				
				$curlResult = json_decode($curl_result);
		//echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
				if (curl_errno($ch)) {
					//echo 'Error:' . curl_error($ch);
				}
				curl_close($ch);
				//echo '<br/>';


				//test email starts
						$html = $curl_result;
						$datetimenow = date('Y-m-d H:i:s');
					if (YII_ENV_PROD) {
						$email_subject = "Linkedfusion Production Server - Webhook Ipn Order Ref #".$OrderReferenceNumber." Response";//at $datetimenow
					}else{
						$email_subject = "Linkedfusion Staging Server - Webhook Ipn Order Ref #".$OrderReferenceNumber." Response";
					}
						$mail = Yii::$app->mailer->compose()
								->setTo('nikit@intricaretech.com')
								->setFrom(Yii::$app->params['adminEmail'])
								->setSubject($email_subject)
								->setHtmlBody($html, 'text/html');
						if (YII_ENV_PROD) {
						$mail->send();
						}else{
						//$mail->send();	
						}
				//test email ends

				$responseGetJson = json_encode($_REQUEST);
				$responseOrderJson = $curl_result;
				//$responseOrderJson = json_decode($curl_result,true);
				//$responseOrderJson = json_encode($responseOrderJson);
				
				$flagSubscriptionDataNotFoundEmailSend = false;
				
				if(($curlResult->Status=='COMPLETE' || $curlResult->Status=='AUTHRECEIVED') && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK'){

					//$merchant_order_id= $response_data->merchant_order_id;
					$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;
					
					$twoCo_CustomerReference = 0;
					if(isset($curlResult->CustomerDetails->CustomerReference)){
						$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference;
					}
					
					
					$connection = Yii::$app->db;
					
					//14-10-2020 : In below query, removed this condition:  order_number='".$OrderReferenceNumber."'
					$uph_row = $connection->createCommand("select id,userid,response_get from user_payment_history where merchant_id='".$merchant_order_id."' AND status='Initialize' AND ordertype='0' ORDER BY id DESC")->queryOne();
					//print_r($uph_row);
					if(!empty($uph_row)){
						//Usage of this code: For ordertype=0, Once the order is authorized, 2checkout will call this "webhookipn" method. The further process will be done from this code of block.
						
						if(isset($curlResult->Items[0]->ProductDetails->Name) && isset($curlResult->Items[0]->Code) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionStartDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->ExpirationDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionReference) ){
							//above condition added on 09-10-2020
							//to put here 09-10-2020

							$uph_pkid = $uph_row['id'];
							
							//14-10-2020 : order_number and 2coCustomerReference added here in below query as we should not depend on response method;
							$command = $connection->createCommand('UPDATE user_payment_history SET complete_date = "'.date("Y-m-d H:i:s").'", status="Success", order_number = "'.$OrderReferenceNumber.'", 2coCustomerReference = "'.$twoCo_CustomerReference.'" WHERE id='.$uph_pkid);
							$command->execute();
							
							if($uph_row['response_get']==NULL){
								
								$responseGetVar = array('refno'=>$_POST['REFNO'],'total'=>$_POST['IPN_TOTALGENERAL'],'total-currency'=>$_POST['CURRENCY']);
								$responseGetVar = json_encode($responseGetVar);
								
								$connection->createCommand("UPDATE `user_payment_history` SET `response_get` = '".$responseGetVar."' where `id` =".$uph_pkid)->execute();
							}
							
							
							
							$response_data = $_POST;//$_GET;
							
							$order_number= $_POST['REFNO'];//$_GET['refno'];//this is order's reference number;
								
							//$signature= $_GET['signature'];
							
							/*Old Orig code commented on 06-01-2021
							$lfaf_seat_purchased_userids='';
							$addifi = $curlResult->AdditionalFields;
							foreach($addifi as $res){
								if($res->Code=="lfaf_seat_purchased_userids"){
									$lfaf_seat_purchased_userids = $res->Value;
								}
							}

							//$lfaf_seat_purchased_userids = '{"LFPM":["14935","14988"],"LFUM":["14987"]}';
							
							$lfaf_seat_purchased_userids = stripslashes($lfaf_seat_purchased_userids);//added 31-07-2020: removes slash
							$lfaf_seat_purchased_useridsArr = json_decode($lfaf_seat_purchased_userids,true);
							*/

							//06-01-2021 starts (now take seat purchased userids from database instead of getting depended on API)
							$lfafSeatPurchased_useridsArr = array();
							$upo_result = $connection->createCommand("select product_id,user_ids from user_order_products where uph_id='".$uph_pkid."' ORDER BY id ASC")->queryAll();
							if(!empty($upo_result)){
								foreach($upo_result as $uporow){
									$lfafSeatPurchased_useridsArr[$uporow['product_id']] = explode(',',$uporow['user_ids']);
								}
							}
							//echo '<br/>:::New:<pre>';print_r($lfafSeatPurchased_useridsArr);echo '</pre>';
							//06-01-2021 ends
							$lfaf_seat_purchased_useridsArr = $lfafSeatPurchased_useridsArr;
							
							
							
							//$user_id = Yii::$app->session->get('userid');
							$user_id = $uph_row['userid'];//order placed by this userid;


							//new starts

							
							$selPlanUsrArr=array();
							
							
							$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7',
							'LFPSAR'=>'8',
							'LFPA'=>'9',
							'LFGSAR'=>'10',
							'LFGA'=>'11',
							'LFUSAR'=>'12',
							'LFUA'=>'13',
							'LFGM_v2'=>'18',
							'LFUM_v2'=>'19',
							'LFGSAR_v2'=>'20',
							'LFUSAR_v2'=>'21',
							'LFGA_v2'=>'22',
							'LFUA_v2'=>'23'
							);
							
							$Items = $curlResult->Items;
							/*
							echo '<br/>Items::<pre>'; print_r($Items);
							echo '<br/><br/>';
							foreach($Items as $item_key=>$item_res){
								echo $item_res->Code;
								echo '<br/>';print_r($item_res);
							}
							die;*/


							foreach($Items as $item_key=>$item_res){
								$product_id = $item_res->Code;//this is product code eg: LCPM
								$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
								$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
								$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
								$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
								

								$command = $connection->createCommand('UPDATE user_order_products SET SubscriptionStartDate = "'.$SubscriptionStartDate.'", ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE", SubscriptionReference="'.$SubscriptionReference.'" WHERE uph_id='.$uph_pkid.' AND product_id="'.$product_id.'" ');
								$command->execute();
								
								$uidsStrPerProduct = implode(',',$lfaf_seat_purchased_useridsArr[$product_id]);
								$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
								
								$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
								
								//starts
								$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus',
								'8'=>'Professional Semi-Annually',
								'9'=>'Professional Annually',
								'10'=>'Grow Semi-Annually',
								'11'=>'Grow Annually',
								'12'=>'Ultimate Semi-Annually',
								'13'=>'Ultimate Annually',
								'14'=>'New Grow Monthly',
								'15'=>'New Grow Annual',
								'16'=>'New Ultimate Monthly',
								'17'=>'New Ultimate Annual',
								'18'=>'Grow Monthly',
								'19'=>'Ultimate Monthly',
								'20'=>'Grow Semi-Annually',
								'21'=>'Ultimate Semi-Annually',
								'22'=>'Grow Annually',
								'23'=>'Ultimate Annually'
								);
								$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
								foreach($userIdArr as $uid){
									
									$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
									$previous_plan = $usrcommand['sublevel'];
									$isTrial = $usrcommand['trial'];
									
									$previous_plan = $previous_plan_array[$previous_plan];
									
									$current_plan = $previous_plan_array[$current_user_setting_plan];
									
									$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
									$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
									$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
									$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
									$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
								}
								//23-06-2021 starts
								$sql_booster = ' is_booster = is_booster ';
								if($product_id=='LFUM_v2' || $product_id=='LFUSAR_v2' || $product_id=='LFUA_v2'){
									$sql_booster = ' is_booster="1" ';
								}
								//23-06-2021 ends
								//trial_expired_at = "'.$ExpirationDateTimestamp.'"
								$command = $connection->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'", '.$sql_booster.' WHERE id IN ('.$uidsStrPerProduct.')');
								$command->execute();
								//ends
								
								$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
								if(empty($uos_row)){
									Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
								}
								
								
							}
							//echo '<br/>SDFDF:<pre>'; print_r($selPlanUsrArr);
							
							//new ends

							$usrInfoOrdPlaced = $connection->createCommand("select email,first_name from user where id='".$user_id."' ")->queryOne();
							$emailId = $usrInfoOrdPlaced['email'];
							$emailId = $usrInfoOrdPlaced['first_name'];

							$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$usrInfoOrdPlaced['email'],'ses_full_name'=>$usrInfoOrdPlaced['first_name']);
							$this->successedPayment($payment_info);
							
							$connection->createCommand("UPDATE `user_payment_history` SET `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$uph_pkid)->execute();
							
							echo '<br>The End';
							
							//Yii::$app->session->set('success_message',"Successfully enabled subscription.");
							//return $this->redirect(['my-template/pricing']);

							
						}else{
							$flagSubscriptionDataNotFoundEmailSend = true;
							//if subscription data not found just send email;
						}
						
						
					}
					


					
				}
				
				//30-09-2020 starts
				if(($curlResult->Status=='COMPLETE' || $curlResult->Status=='AUTHRECEIVED') && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK'){
					//Usage:When manual renewal order is authorized, this code of block will process futher.
					
					$order_number= $OrderReferenceNumber;//this is order's reference number;
					$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;it is blank here.
					
					$uph_row = Yii::$app->db->createCommand("select t1.id, t1.response_get from user_payment_history t1 where t1.order_number='".$OrderReferenceNumber."' and t1.status='Initialize' and t1.ordertype='4' ORDER BY t1.id DESC")->queryOne();
					
					if(!empty($uph_row)){
						
						if(isset($curlResult->Items[0]->ProductDetails->Name) && isset($curlResult->Items[0]->Code) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionStartDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->ExpirationDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionReference) ){
							//above condition added on 09-10-2020
							//to put here 09-10-2020

							$newOrder_uphpkid = $lastuphid = $uph_row['id'];
							$response_get = json_decode($uph_row['response_get']);
							//echo '<pre>';print_r($response_get);
							$GETSubscriptionRef = $response_get->subscription;
							
							$responseGetJson = $uph_row['response_get'];
							
							$uph_row = Yii::$app->db->createCommand("select t1.id, t1.userid,t1.2coCustomerReference, t2.email, t2.username, t2.first_name, t2.last_name from user_payment_history t1 JOIN user t2 ON t1.userid=t2.id JOIN user_order_products t3 ON t1.id=t3.uph_id where t3.SubscriptionReference='".$GETSubscriptionRef."' ORDER BY t1.id DESC")->queryOne();
							if(!empty($uph_row)){
								$uph_pkid = $uph_row['id'];
								
								Yii::$app->db->createCommand('UPDATE user_payment_history SET complete_date = "'.date("Y-m-d H:i:s").'", status="Success" WHERE id='.$newOrder_uphpkid)->execute();
								

								$selPlanUsrArr=array();
								$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7',
								'LFPSAR'=>'8',
								'LFPA'=>'9',
								'LFGSAR'=>'10',
								'LFGA'=>'11',
								'LFUSAR'=>'12',
								'LFUA'=>'13',
								'LFGM_v2'=>'18',
								'LFUM_v2'=>'19',
								'LFGSAR_v2'=>'20',
								'LFUSAR_v2'=>'21',
								'LFGA_v2'=>'22',
								'LFUA_v2'=>'23'
								);
								/*
								$fullplanname_array = array('Free'=>'Free','Professional Monthly'=>'LFPM','Professional Quarterly'=>'LFPQ','Grow Monthly'=>'LFGM','Grow Quarterly'=>'LFGQ','Ultimate Monthly'=>'LFUM','Ultimate Quarterly'=>'LFUQ','Ultimate Plus'=>'LFUP',
								'Professional Semi-Annually'=>'LFPSAR',
								'Professional Annually'=>'LFPA',
								'Grow Semi-Annually'=>'LFGSAR',
								'Grow Annually'=>'LFGA',
								'Ultimate Semi-Annually'=>'LFUSAR',
								'Ultimate Annually'=>'LFUA',
								'Grow Monthly'=>'LFGM_v2',
								'Ultimate Monthly'=>'LFUM_v2',
								'Grow Semi-Annually'=>'LFGSAR_v2',
								'Ultimate Semi-Annually'=>'LFUSAR_v2',
								'Grow Annually'=>'LFGA_v2',
								'Ultimate Annually'=>'LFUA_v2'
								);
								*/
						
								$Items = $curlResult->Items;				

								foreach($Items as $item_key=>$item_res){
					
									
										$product_id = $item_res->Code;//this is product code eg: LCPM
										$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
										$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
										$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
										$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
										
										$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
										
										if($GETSubscriptionRef==$SubscriptionReference){
											
										
											$upo_row = Yii::$app->db->createCommand("select id,user_ids from user_order_products where uph_id =".$uph_pkid." AND product_id='".$product_id."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
											
											if(!empty($upo_row)){
												$upo_user_ids = $upo_row['user_ids'];
												
												//SubscriptionStartDate = "'.$SubscriptionStartDate.'"
												Yii::$app->db->createCommand('UPDATE user_order_products SET ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE" WHERE id='.$upo_row['id'])->execute();
												
												Yii::$app->db->createCommand("UPDATE `user_payment_history` SET user_ids = '".$upo_user_ids."' where id =".$lastuphid)->execute();
												
												
												$lfaf_seat_purchased_useridsArr = array();
												$lfaf_seat_purchased_useridsArr[$product_id] = explode(',',$upo_user_ids);
						

												//$uidsStrPerProduct = $upo_user_ids;
												$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
												
												
												//starts
												$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus',
												'8'=>'Professional Semi-Annually',
												'9'=>'Professional Annually',
												'10'=>'Grow Semi-Annually',
												'11'=>'Grow Annually',
												'12'=>'Ultimate Semi-Annually',
												'13'=>'Ultimate Annually',
												'14'=>'New Grow Monthly',
												'15'=>'New Grow Annual',
												'16'=>'New Ultimate Monthly',
												'17'=>'New Ultimate Annual',
												'18'=>'Grow Monthly',
												'19'=>'Ultimate Monthly',
												'20'=>'Grow Semi-Annually',
												'21'=>'Ultimate Semi-Annually',
												'22'=>'Grow Annually',
												'23'=>'Ultimate Annually'
												);
												$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
												foreach($userIdArr as $uid){
													
													$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
													$previous_plan = $usrcommand['sublevel'];
													$isTrial = $usrcommand['trial'];
													
													$previous_plan = $previous_plan_array[$previous_plan];
													
													$current_plan = $previous_plan_array[$current_user_setting_plan];
													
													$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
													$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
													$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
													$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
													$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
												}
												//trial_expired_at = "'.$ExpirationDateTimestamp.'"
												Yii::$app->db->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
												//ends
												
												$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$uph_row['email'],'ses_full_name'=>$uph_row['first_name'].' '.$uph_row['last_name'],'responseGetJson'=> $responseGetJson,'GETSubscriptionRef'=>$GETSubscriptionRef);
												$this->renewedSuccessedPayment($payment_info);
												
												
												$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
												if(empty($uos_row)){
													Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
												}
												
												echo '<br/>The end';
												
											}

										}
								}							
								
							}


						}else{
							$flagSubscriptionDataNotFoundEmailSend = true;
							//if subscription data not found just send email;
						}
						
						
					}
					
				}
				//30-09-2020 ends


				//09-10-2020 starts
				if($flagSubscriptionDataNotFoundEmailSend==true){
					//if subscription data not found just send email;
					//email starts
			
						$html = 'Hello Admin,<br/><br/>For Order Ref #'.$OrderReferenceNumber.' IPN is called but it does not yet contain Subscription Data. So, for this user sublevel and other data are not updated.<br/>For smooth experience, manually call actionWebhookIpn method by passing valid post variables.<br/><br/>Below post data received:<br>';
						$html.= json_encode($_POST,JSON_PRETTY_PRINT);
						
					if (YII_ENV_PROD) {
						$email_subject = "Linkedfusion Production Server - Webhook Ipn Order Ref #".$OrderReferenceNumber." Called But Not Having Subscription Data";
						$to_email = ['arpan@intricare.net','nikit@intricaretech.com'];
					}else{
						$email_subject = "Linkedfusion Staging Server - Webhook Ipn Order Ref #".$OrderReferenceNumber." Called But Not Having Subscription Data";
						$to_email = 'nikit@intricaretech.com';
					}
						$mail = Yii::$app->mailer->compose()
								->setTo($to_email)
								->setFrom(Yii::$app->params['adminEmail'])
								->setSubject($email_subject)
								->setHtmlBody($html, 'text/html');
						$mail->send();
					//email ends
				}
				//09-10-2020 ends


			}
			

			if($isLfBlackFridayProductInIPN==true || $isLfAddOnPackExclusiveOrder==true){
				//This code block is only for LF Blackfriday products and AddOnPackProduct;
				//Blackfriday products recurring nathi. only 1 time. Blackfriday products ma upgrade subscription, cancel subscription nai aave; also, auto/manual renewal pan nai aave;
				//AddOnPackProduct pan recurring nathi. only 1 time. AddOnPackProduct ma upgrade subscription, cancel subscription nai aave; also, auto/manual renewal pan nai aave;
				
				//email starts
				if($isLfBlackFridayProductInIPN){
					$emailSubjectTxt = "Blackfriday";
				}else{
					$emailSubjectTxt = "AddOnPackProduct";
				}
				
					if (YII_ENV_PROD) {
						$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - Webhook Ipn ".$emailSubjectTxt;
					}else{
						$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - Webhook Ipn ".$emailSubjectTxt;
					}
				$html = json_encode($_POST,JSON_PRETTY_PRINT);
				$html.= '<br/>Timestamp:'.strtotime('now');
				$mail = Yii::$app->mailer->compose()
						->setTo('nikit@intricaretech.com')
						->setFrom(Yii::$app->params['adminEmail'])
						->setSubject($email_subject)
						->setHtmlBody($html, 'text/html');
				if (YII_ENV_PROD) {
				$mail->send();
				}else{
				//$mail->send();
				}
				//email ends
				
				//order response email send starts
				if (YII_ENV_PROD) {
					//production
					$merchantCode = "203537015";
					$key = 'd?q4rkG]&KAh#vwnmSJ%';
				}else{
					//staging
					$merchantCode = "251108887711";// your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
					$key = '!G2S8WRBKJ6#&c~luOz=';// your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
				}

				$gmdate = gmdate('Y-m-d H:i:s');
				$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
				$hashAlgorithm = 'sha256';
				$hash = hash_hmac($hashAlgorithm , $string, $key);
				
				//$OrderReferenceNumber = $_GET['refno'];
				$OrderReferenceNumber = $_POST['REFNO'];
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

				$headers = array();
				$headers[] = 'Accept: application/json';
				$headers[] = 'Content-Type: application/json';
				$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				$curl_result = curl_exec($ch);
				
				$curlResult = json_decode($curl_result);
				//echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
				if (curl_errno($ch)) {
					//echo 'Error:' . curl_error($ch);
				}
				curl_close($ch);
				//echo '<br/>';


				//test email starts
						$html = $curl_result;
						$datetimenow = date('Y-m-d H:i:s');
					if (YII_ENV_PROD) {
						$email_subject = "Linkedfusion Production Server - ".$emailSubjectTxt." Webhook Ipn Order Ref #".$OrderReferenceNumber." Response";//at $datetimenow
					}else{
						$email_subject = "Linkedfusion Staging Server - ".$emailSubjectTxt." Webhook Ipn Order Ref #".$OrderReferenceNumber." Response";
					}
						$mail = Yii::$app->mailer->compose()
								->setTo('nikit@intricaretech.com')
								->setFrom(Yii::$app->params['adminEmail'])
								->setSubject($email_subject)
								->setHtmlBody($html, 'text/html');
						if (YII_ENV_PROD) {
						$mail->send();
						}else{
							
						}
				//test email ends
				//order response email send ends

				$responseGetJson = json_encode($_REQUEST);
				$responseOrderJson = $curl_result;
				//$responseOrderJson = json_decode($curl_result,true);
				//$responseOrderJson = json_encode($responseOrderJson);
				
				
				
				if(($curlResult->Status=='COMPLETE' || $curlResult->Status=='AUTHRECEIVED') && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK'){

					//$merchant_order_id= $response_data->merchant_order_id;
					$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;
					
					$twoCo_CustomerReference = 0;
					if(isset($curlResult->CustomerDetails->CustomerReference)){
						$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference;
					}
					
					
					$connection = Yii::$app->db;
					
					
					$uph_row = $connection->createCommand("select id,userid,response_get,isAddOnPackOrder from user_payment_history where merchant_id='".$merchant_order_id."' AND status='Initialize' AND ordertype='0' ORDER BY id DESC")->queryOne();
					//print_r($uph_row);
					if(!empty($uph_row)){
						//Usage of this code: For ordertype=0, Once the order is authorized, 2checkout will call this "webhookipn" method. The further process will be done from this code of block.
						
						if(isset($curlResult->Items[0]->ProductDetails->Name) && isset($curlResult->Items[0]->Code) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionStartDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionReference) ){
							
							

							$uph_pkid = $uph_row['id'];
							
							//14-10-2020 : order_number and 2coCustomerReference added here in below query as we should not depend on response method;
							$command = $connection->createCommand('UPDATE user_payment_history SET complete_date = "'.date("Y-m-d H:i:s").'", status="Success", order_number = "'.$OrderReferenceNumber.'", 2coCustomerReference = "'.$twoCo_CustomerReference.'" WHERE id='.$uph_pkid);
							$command->execute();
							
							if($uph_row['response_get']==NULL){
								
								$responseGetVar = array('refno'=>$_POST['REFNO'],'total'=>$_POST['IPN_TOTALGENERAL'],'total-currency'=>$_POST['CURRENCY']);
								$responseGetVar = json_encode($responseGetVar);
								
								$connection->createCommand("UPDATE `user_payment_history` SET `response_get` = '".$responseGetVar."' where `id` =".$uph_pkid)->execute();
							}
							
							
							
							$response_data = $_POST;//$_GET;
							
							$order_number= $_POST['REFNO'];//$_GET['refno'];//this is order's reference number;
								
							//$signature= $_GET['signature'];
							
							/*Old Orig code commented on 06-01-2021
							$lfaf_seat_purchased_userids='';
							$addifi = $curlResult->AdditionalFields;
							foreach($addifi as $res){
								if($res->Code=="lfaf_seat_purchased_userids"){
									$lfaf_seat_purchased_userids = $res->Value;
								}
							}

							//$lfaf_seat_purchased_userids = '{"LFPSA":["14935","14988"],"LFGSA":["14987"]}';
							
							$lfaf_seat_purchased_userids = stripslashes($lfaf_seat_purchased_userids);//added 31-07-2020: removes slash
							$lfaf_seat_purchased_useridsArr = json_decode($lfaf_seat_purchased_userids,true);
							*/

							//06-01-2021 starts (now take seat purchased userids from database instead of getting depended on API)
							$lfafSeatPurchased_useridsArr = array();
							$upo_result = $connection->createCommand("select product_id,user_ids from user_order_products where uph_id='".$uph_pkid."' ORDER BY id ASC")->queryAll();
							if(!empty($upo_result)){
								foreach($upo_result as $uporow){
									$lfafSeatPurchased_useridsArr[$uporow['product_id']] = explode(',',$uporow['user_ids']);
								}
							}
							//echo '<br/>:::New:<pre>';print_r($lfafSeatPurchased_useridsArr);echo '</pre>';
							//06-01-2021 ends
							$lfaf_seat_purchased_useridsArr = $lfafSeatPurchased_useridsArr;
							
							
							
							//$user_id = Yii::$app->session->get('userid');
							$user_id = $uph_row['userid'];//order placed by this userid;


							//new starts

							
							$selPlanUsrArr=array();
							
							
							$current_user_setting_plan_array = array('0'=>'Free','LFPSA'=>'1','LFPABF'=>'2','LFGSA'=>'3','LFGABF'=>'4','LFUSA'=>'5','LFUABF'=>'6','LFUP'=>'7',
							'LFPSAR'=>'8',
							'LFPA'=>'9',
							'LFGSAR'=>'10',
							'LFGA'=>'11',
							'LFUSAR'=>'12',
							'LFUA'=>'13',
							'LFGM_v2'=>'18',
							'LFUM_v2'=>'19',
							'LFGSAR_v2'=>'20',
							'LFUSAR_v2'=>'21',
							'LFGA_v2'=>'22',
							'LFUA_v2'=>'23'
							);
							
							$Items = $curlResult->Items;
							/*
							echo '<br/>Items::<pre>'; print_r($Items);
							echo '<br/><br/>';
							foreach($Items as $item_key=>$item_res){
								echo $item_res->Code;
								echo '<br/>';print_r($item_res);
							}
							die;*/


							foreach($Items as $item_key=>$item_res){
								$product_id = $item_res->Code;//this is product code eg: LFPSA
								$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
								//$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;//this value will be blank for blackfriday products;
							if($isLfBlackFridayProductInIPN){
								if($product_id=='LFPSA' || $product_id=='LFGSA' || $product_id=='LFUSA'){
									//for blackfriday Semi Annual plans
									$ExpirationDate = date('Y-m-d H:i:s', strtotime($SubscriptionStartDate. ' + 6 months'));
								}else{
									//for blackfriday Annual plans
									$ExpirationDate = date('Y-m-d H:i:s', strtotime($SubscriptionStartDate. ' + 1 year'));
								}
								
								//$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
								$ExpirationDateTimestamp = strtotime($ExpirationDate) * 1000;
								$sql_ExpirationDate = 'ExpirationDate = "'.$ExpirationDate.'"';
							}else{
								//for AddOnPackProduct there is no ExpirationDate.
								$sql_ExpirationDate = 'ExpirationDate = NULL';
							}
								$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
								

								$command = $connection->createCommand('UPDATE user_order_products SET SubscriptionStartDate = "'.$SubscriptionStartDate.'", '.$sql_ExpirationDate.',2coSubscriptionStatus="ACTIVE", SubscriptionReference="'.$SubscriptionReference.'" WHERE uph_id='.$uph_pkid.' AND product_id="'.$product_id.'" ');
								$command->execute();
								
								$uidsStrPerProduct = implode(',',$lfaf_seat_purchased_useridsArr[$product_id]);
							if($isLfBlackFridayProductInIPN){	
								$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
							}
								
								$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
								
								//starts
								$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus',
								'8'=>'Professional Semi-Annually',
								'9'=>'Professional Annually',
								'10'=>'Grow Semi-Annually',
								'11'=>'Grow Annually',
								'12'=>'Ultimate Semi-Annually',
								'13'=>'Ultimate Annually',
								'14'=>'New Grow Monthly',
								'15'=>'New Grow Annual',
								'16'=>'New Ultimate Monthly',
								'17'=>'New Ultimate Annual',
								'18'=>'Grow Monthly',
								'19'=>'Ultimate Monthly',
								'20'=>'Grow Semi-Annually',
								'21'=>'Ultimate Semi-Annually',
								'22'=>'Grow Annually',
								'23'=>'Ultimate Annually'
								);
								
								$lfblackfriday_plan_array = array('0'=>'Free','1'=>'Professional Semi Annual Black Friday','2'=>'Professional Annual Black Friday','3'=>'Grow Semi Annual Black Friday','4'=>'Grow Annual Black Friday','5'=>'Ultimate Semi Annual Black Friday','6'=>'Ultimate Annual Black Friday','7'=>'Ultimate Plus');
								
								$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
								foreach($userIdArr as $uid){
									
									$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
									$previous_plan = $usrcommand['sublevel'];
									$isTrial = $usrcommand['trial'];
									
									$previous_plan = $previous_plan_array[$previous_plan];
								if($isLfBlackFridayProductInIPN){
									//$current_plan = $previous_plan_array[$current_user_setting_plan];
									$current_plan = $lfblackfriday_plan_array[$current_user_setting_plan];
								}else{
									//for AddOnPackProduct
									$current_plan = $item_res->ProductDetails->Name;//this is product name;
								}
									
									$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
									$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
									$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
									$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
									$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
								}
							if($isLfBlackFridayProductInIPN){

												//23-06-2021 starts
												$sql_booster = ' is_booster = is_booster ';
												if($product_id=='LFUSA' || $product_id=='LFUABF'){
													$sql_booster = ' is_booster="1" ';
												}
												//23-06-2021 ends							
								
								//trial_expired_at = "'.$ExpirationDateTimestamp.'"
								$command = $connection->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, trial_expired_at = "'.$ExpirationDateTimestamp.'", cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'", '.$sql_booster.' WHERE id IN ('.$uidsStrPerProduct.')');
								$command->execute();
							}else{
								//for AddOnPackProduct
								$command = $connection->createCommand('UPDATE user SET is_booster = "1" WHERE id IN ('.$uidsStrPerProduct.')');
								$command->execute();
							}
								//ends
								
								$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
								if(empty($uos_row)){
									Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
								}
								
								
							}
							//echo '<br/>SDFDF:<pre>'; print_r($selPlanUsrArr);
							
							//new ends

							$usrInfoOrdPlaced = $connection->createCommand("select email,first_name from user where id='".$user_id."' ")->queryOne();
							$emailId = $usrInfoOrdPlaced['email'];
							$emailId = $usrInfoOrdPlaced['first_name'];

							$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$usrInfoOrdPlaced['email'],'ses_full_name'=>$usrInfoOrdPlaced['first_name']);
							if($uph_row['isAddOnPackOrder']==1){
								//for AddOnPackProduct
								$this->successedPaymentAddOnPackExclusiveOrder($payment_info);
							}else{
								$this->successedPayment($payment_info);
							}
							
							
							$connection->createCommand("UPDATE `user_payment_history` SET `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$uph_pkid)->execute();
							
							echo '<br>The End';
							
							//Yii::$app->session->set('success_message',"Successfully enabled subscription.");
							//return $this->redirect(['my-template/pricing']);

							
						}else{
							
							//if subscription data not found just send email;
							//email starts
							if($isLfBlackFridayProductInIPN){
								$html = 'Hello Admin,<br/><br/>For Order Ref #'.$OrderReferenceNumber.' IPN is called but it does not yet contain Subscription Data. So, for this user sublevel and other data are not updated.<br/>For smooth experience, manually call actionWebhookIpn method by passing valid post variables.<br/><br/>Below post data received:<br>';
								$emailSubjectTxt = "Blackfriday";
							}else{
								//for AddOnPackProduct ie. Booster Pack
								$html = 'Hello Admin,<br/><br/>For Order Ref #'.$OrderReferenceNumber.' IPN is called but it does not yet contain Subscription Data. So, for this user Booster Pack data are not updated.<br/>For smooth experience, manually call actionWebhookIpn method by passing valid post variables.<br/><br/>Below post data received:<br>';
								$emailSubjectTxt = "AddOnPackProduct";
							}
								$html.= json_encode($_POST,JSON_PRETTY_PRINT);
							
							if (YII_ENV_PROD) {
								$email_subject = "Linkedfusion Production Server - ".$emailSubjectTxt." Webhook Ipn Order Ref #".$OrderReferenceNumber." Called But Not Having Subscription Data";
								$to_email = ['arpan@intricare.net','nikit@intricaretech.com'];
							}else{
								$email_subject = "Linkedfusion Staging Server - ".$emailSubjectTxt." Webhook Ipn Order Ref #".$OrderReferenceNumber." Called But Not Having Subscription Data";
								$to_email = 'nikit@intricaretech.com';
							}
								$mail = Yii::$app->mailer->compose()
										->setTo($to_email)
										->setFrom(Yii::$app->params['adminEmail'])
										->setSubject($email_subject)
										->setHtmlBody($html, 'text/html');
								$mail->send();
							//email ends
							
						}
						
						
					}
					


					
				}

				
			}
			
		}
		
		//ipn hash code starts here
		if(isset($_POST['HASH'])){
			if (YII_ENV_PROD) {
				$secret_key = 'd?q4rkG]&KAh#vwnmSJ%'; //2checkout secret_key
			}else{
				$secret_key = '!G2S8WRBKJ6#&c~luOz=';
			}
			date_default_timezone_set('UTC');
			//PARAMETERS
			$IPN_parameters = array(); 
			$IPN_parameters['SALEDATE'] = $_POST['SALEDATE'];
			$IPN_parameters['REFNO'] = $_POST['REFNO'];
			$IPN_parameters['REFNOEXT'] = $_POST['REFNOEXT'];
			$IPN_parameters['ORDERNO'] = $_POST['ORDERNO']; 
			$IPN_parameters['ORDERSTATUS'] = $_POST['ORDERSTATUS'];
			$IPN_parameters['PAYMETHOD'] = $_POST['PAYMETHOD'];
			$IPN_parameters['FIRSTNAME'] = $_POST['FIRSTNAME'];
			$IPN_parameters['LASTNAME'] = $_POST['LASTNAME'];
			$IPN_parameters['COMPANY'] = $_POST['COMPANY'];
			$IPN_parameters['REGISTRATIONNUMBER'] = $_POST['REGISTRATIONNUMBER'];
			$IPN_parameters['FISCALCODE'] = $_POST['FISCALCODE'];
			$IPN_parameters['CBANKNAME'] = $_POST['CBANKNAME'];
			$IPN_parameters['CBANKACCOUNT'] = $_POST['CBANKACCOUNT'];
			$IPN_parameters['ADDRESS1'] = $_POST['ADDRESS1'];
			$IPN_parameters['ADDRESS2'] = $_POST['ADDRESS2'];
			$IPN_parameters['CITY'] = $_POST['CITY'];
			$IPN_parameters['STATE'] = $_POST['STATE'];
			$IPN_parameters['ZIPCODE'] = $_POST['ZIPCODE'];
			$IPN_parameters['COUNTRY'] = $_POST['COUNTRY'];
			$IPN_parameters['PHONE'] = $_POST['PHONE'];
			$IPN_parameters['FAX'] = $_POST['FAX'];
			$IPN_parameters['CUSTOMEREMAIL'] = $_POST['CUSTOMEREMAIL'];
			$IPN_parameters['FIRSTNAME_D'] = $_POST['FIRSTNAME_D'];
			$IPN_parameters['LASTNAME_D'] = $_POST['LASTNAME_D'];
			$IPN_parameters['COMPANY_D'] = $_POST['COMPANY_D'];
			$IPN_parameters['ADDRESS1_D'] = $_POST['ADDRESS1_D'];
			$IPN_parameters['ADDRESS2_D'] = $_POST['ADDRESS2_D'];
			$IPN_parameters['CITY_D'] = $_POST['CITY_D'];
			$IPN_parameters['STATE_D'] = $_POST['STATE_D'];
			$IPN_parameters['ZIPCODE_D'] = $_POST['ZIPCODE_D'];
			$IPN_parameters['COUNTRY_D'] = $_POST['COUNTRY_D'];
			$IPN_parameters['PHONE_D'] = $_POST['PHONE_D'];
			$IPN_parameters['IPADDRESS'] = $_POST['IPADDRESS'];
			$IPN_parameters['CURRENCY'] = $_POST['CURRENCY'];
			$IPN_parameters['IPN_PID'][0] = $_POST['IPN_PID'][0];
			$IPN_parameters['IPN_PNAME'][0] = $_POST['IPN_PNAME'][0];
			$IPN_parameters['IPN_PCODE'][0] = $_POST['IPN_PCODE'][0];
			$IPN_parameters['IPN_INFO'][0] = $_POST['IPN_INFO'][0];
			$IPN_parameters['IPN_QTY'][0] = $_POST['IPN_QTY'][0];
			$IPN_parameters['IPN_PRICE'][0] = $_POST['IPN_PRICE'][0];
			$IPN_parameters['IPN_VAT'][0] = $_POST['IPN_VAT'][0];
			$IPN_parameters['IPN_VER'][0] = $_POST['IPN_VER'][0];
			$IPN_parameters['IPN_DISCOUNT'][0] = $_POST['IPN_DISCOUNT'][0];
			$IPN_parameters['IPN_PROMONAME'][0] = $_POST['IPN_PROMONAME'][0];
			$IPN_parameters['IPN_DELIVEREDCODES'][0] = $_POST['IPN_DELIVEREDCODES'][0];
			$IPN_parameters['IPN_TOTAL'][0] = $_POST['IPN_TOTAL'][0];
			$IPN_parameters['IPN_TOTALGENERAL'] = $_POST['IPN_TOTALGENERAL'];
			$IPN_parameters['IPN_SHIPPING'] = $_POST['IPN_SHIPPING'];
			$IPN_parameters['IPN_COMMISSION'] = $_POST['IPN_COMMISSION'];
			$IPN_parameters['IPN_DATE'] = $_POST['IPN_DATE'];
			$IPN_parameters['TEST_ORDER'] = $_POST['TEST_ORDER'];
			$tabble = $this->createtablefromarrayipntwooct($IPN_parameters);
			$email_html=$tabble;
			//*********Base string for HMAC_MD5 calculation:*********
			//echo "<br/><br/>This is the base string for HMAC_MD5 calculation:<br/>";
			$email_html.=  "<br/><br/>This is the base string for HMAC_MD5 calculation:<br/>";
			$result = '';
			foreach ($IPN_parameters as $key => $val){
				$result .= $this->arrayexpandipntwooct((array)$val);
			}
			//var_dump($result);
			//$email_html.=print_r($result,true);
			$email_html.=$result;
			//*********Calculated HMAC_MD5 signature:*********
			//echo "<br/><br/>This is the HMAC_MD5 signature:<br/>";
			$email_html.="<br/><br/>This is the HMAC_MD5 signature:<br/>";
			$hash =  $this->hmacipntwooct($secret_key, $result);
			$IPN_parameters['HASH']=$hash;
			//var_dump($hash);
			//$email_html.=print_r($hash,true);
			$email_html.=$hash;
			//*********Response:*********
			$IPN_parameters_response = array();
			$IPN_parameters_response['IPN_PID'][0] = $_POST['IPN_PID'][0];
			$IPN_parameters_response['IPN_PNAME'][0] = $_POST['IPN_PNAME'][0];
			$IPN_parameters_response['IPN_DATE'] = $_POST['IPN_DATE'];
			//$IPN_parameters_response['DATE'] = $_POST['IPN_DATE'];
			//$IPN_parameters_response['DATE'] = date('YmdHis');//NR
			$IPN_parameters_response['DATE'] = gmdate('YmdHis');//NR
			//*********Response base string for HMAC_MD5 calculation:*********
			//echo "<br/><br/>This is the response base string for HMAC_MD5 calculation:<br/>";
			$email_html.="<br/><br/>This is the response base string for HMAC_MD5 calculation:<br/>";
			$result_response = '';
			foreach ($IPN_parameters_response as $key => $val){
				$result_response .= $this->arrayexpandipntwooct((array)$val);
			}
			//var_dump($result_response);
			//$email_html.=print_r($result_response,true);
			$email_html.=$result_response;
			//*********Calculated response HMAC_MD5 signature:*********
			//echo "<br/><br/>This is the response HMAC_MD5 signature:<br/>";
			$email_html.="<br/><br/>This is the response HMAC_MD5 signature:<br/>";
			$hash =  $this->hmacipntwooct($secret_key, $result_response);
			$link_params['HASH']=$hash;
			//var_dump($hash);
			//$email_html.=print_r($hash,true);
			$email_html.=$hash;
			//Expected response
			//echo 'Expected response: '.'&lt;EPAYMENT&gt;'.$IPN_parameters_response['DATE'].'|'.$hash.'&lt;/EPAYMENT&gt;';
			echo '<EPAYMENT>'.$IPN_parameters_response['DATE'].'|'.$hash.'</EPAYMENT>';
			$email_html.='<br/><br/>Expected response: '.'&lt;EPAYMENT&gt;'.$IPN_parameters_response['DATE'].'|'.$hash.'&lt;/EPAYMENT&gt;';

			
			//email starts
				if (YII_ENV_PROD) {
					$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - WebhookIpn demo hash signature email";
				}else{
					$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - WebhookIpn demo hash signature email";
				}
			$html = $email_html;
			$mail = Yii::$app->mailer->compose()
					->setTo('nikit@intricaretech.com')
					->setFrom(Yii::$app->params['adminEmail'])
					->setSubject($email_subject)
					->setHtmlBody($html, 'text/html');
			//$mail->send();
			//email ends
		}
		//ipn hash code ends here
		
	}

	
    //20-03-2024 [DONE. Working perfect with my test 2checkout account]
    public function actionWebhookIpn_nrtest_hash(){
        // echo 'show';
        //20-03-2024: This entire code is working fine. IPN Signature Success email arrived. + panel webhook ipn log status shows success.

        /* Instant Payment Notification */

        /* Return HTTP 200 response for initial IPN endpoint setup */
        if ($_SERVER['REQUEST_METHOD'] === 'GET'){
            http_response_code(200);
            return;
        }

        /*
        * possible values: sha256, sha3-256
        * sha3-256 only for php version > 7.1
        */
        $usedHashAlgorithm = 'sha256';

        /* pass to compute HASH. Retrieve your secret key by accessing https://secure.2checkout.com/cpanel/webhooks_api.php */
        $secretKey = "=H1CO#Ge^V&[(+DAM*aw";

        $signature_sha2   = isset($_POST["SIGNATURE_SHA2_256"]) ? $_POST["SIGNATURE_SHA2_256"] : '';    /* sha256 HASH received */
        $signature_sha3   = isset($_POST["SIGNATURE_SHA3_256"]) ? $_POST["SIGNATURE_SHA3_256"] : '';    /* sha3-256 HASH received */
        
        $stringForHash = $this->serializeArray($_POST);
        $computedHash = hash_hmac($usedHashAlgorithm, $stringForHash, $secretKey);
        
        $validHash = false;
        switch ($usedHashAlgorithm) {
            case "sha256":
                if ($computedHash == $signature_sha2) {
                    $validHash = true;
                }
                break;
            case "sha3-256":
                if ($computedHash == $signature_sha3) {
                    $validHash = true;
                }
                break;
        }
        
        
        if ($validHash === false) {
            /* hash verification failed */
            
            http_response_code(400);
            // mail("your_address@example.com","BAD IPN Signature", print_r($_POST, TRUE),"");
            
            //test email starts
            $message = "this is test email. BAD IPN Signature. computedHash:".$computedHash.'::::signature_sha2:'.$signature_sha2.'::::SERVER REQUEST_METHOD:'.$_SERVER['REQUEST_METHOD'];
            
            $html = $message;
            $datetimenow = date('Y-m-d H:i:s');
            // if (YII_ENV_PROD) {
            // 	$email_subject = "Leadconnect Production Server - Webhook IPN Order Ref #".$OrderReferenceNumber." Response";//at $datetimenow
            // }else{
                // $email_subject = "Leadconnect Staging Server - Webhook IPN TESTING NEW HASH Signature Final at ".date('Y-m-d H:i:s');
                $email_subject = "test LinkedFusion email : web/securepayment/webhook-ipn_nrtest_hash BAD IPN Signature";
            // }
            $mail = Yii::$app->mailer->compose()
                    ->setTo('nikit@intricaretech.com')
					->setFrom(Yii::$app->params['adminEmail'])
                    ->setSubject($email_subject)
                    ->setHtmlBody($html, 'text/html');
            $mail->send();
            //test email ends

            return;
        }
        
        // hash is valid. We proceed with success response
        $responseDate = date('YmdHis');
        
        $arrayForResponseHash = [
            $_POST["IPN_PID"][0],
            $_POST["IPN_PNAME"][0],
            $_POST["IPN_DATE"],
            $responseDate
        ];
        $stringForResponseHash = $this->serializeArray($arrayForResponseHash);
        
        $responseString = '';
        switch ($usedHashAlgorithm) {
            case "sha256":
                $responseHash = hash_hmac('sha256', $stringForResponseHash, $secretKey);
                $responseString = '<sig algo="sha256" date="' . $responseDate . '">' . $responseHash . '</sig>';
                break;
            case "sha3-256":
                $responseHash = hash_hmac('sha3-256', $stringForResponseHash, $secretKey);
                $responseString = '<sig algo="sha3-256" date="' . $responseDate . '">' . $responseHash . '</sig>';
                break;
        }
        
        //test email starts
        $message = "this is test email. IPN Signature success. responseString:".$responseString.'::::SERVER REQUEST_METHOD:'.$_SERVER['REQUEST_METHOD'];
		$html = $message;
		$datetimenow = date('Y-m-d H:i:s');
		// if (YII_ENV_PROD) {
		// 	$email_subject = "Leadconnect Production Server - Webhook IPN Order Ref #".$OrderReferenceNumber." Response";//at $datetimenow
		// }else{
			// $email_subject = "Leadconnect Staging Server - Webhook IPN TESTING NEW HASH Signature Final at ".date('Y-m-d H:i:s');
			$email_subject = "test LinkedFusion email : web/securepayment/webhook-ipn_nrtest_hash Success IPN Signature";
		// }
		$mail = Yii::$app->mailer->compose()
				->setTo('nikit@intricaretech.com')
				->setFrom(Yii::$app->params['adminEmail'])
				->setSubject($email_subject)
				->setHtmlBody($html, 'text/html');
		$mail->send();
		//test email ends
        
        http_response_code(200);
        echo $responseString;

    }

    //21-03-2024 [DONE]
    public function actionWebhookIpn_new_hash(){
		ini_set('display_errors', 1);
		ini_set('display_startup_errors', 1);
		error_reporting(E_ALL);
        /* Instant Payment Notification */

        /* Return HTTP 200 response for initial IPN endpoint setup */
        if ($_SERVER['REQUEST_METHOD'] === 'GET'){
            http_response_code(200);
            return;
        }

        /*
        * possible values: sha256, sha3-256
        * sha3-256 only for php version > 7.1
        */
        $usedHashAlgorithm = 'sha256';

        /* pass to compute HASH. Retrieve your secret key by accessing https://secure.2checkout.com/cpanel/webhooks_api.php */
		$secretKey = "d?q4rkG]&KAh#vwnmSJ%"; //2checkout secret_key

        $signature_sha2   = isset($_POST["SIGNATURE_SHA2_256"]) ? $_POST["SIGNATURE_SHA2_256"] : '';    /* sha256 HASH received */
        $signature_sha3   = isset($_POST["SIGNATURE_SHA3_256"]) ? $_POST["SIGNATURE_SHA3_256"] : '';    /* sha3-256 HASH received */
        
        $stringForHash = $this->serializeArray($_POST);
        $computedHash = hash_hmac($usedHashAlgorithm, $stringForHash, $secretKey);
        
        $validHash = false;
        switch ($usedHashAlgorithm) {
            case "sha256":
                if ($computedHash == $signature_sha2) {
                    $validHash = true;
                }
                break;
            case "sha3-256":
                if ($computedHash == $signature_sha3) {
                    $validHash = true;
                }
                break;
        }
        
        
        if ($validHash === false) {
            /* hash verification failed */
            
            http_response_code(400);
            // mail("your_address@example.com","BAD IPN Signature", print_r($_POST, TRUE),"");
            
            //test email starts
            $message = "this is test email. BAD IPN Signature. computedHash:".$computedHash.'::::signature_sha2:'.$signature_sha2.'::::SERVER REQUEST_METHOD:'.$_SERVER['REQUEST_METHOD'];
            
            $html = $message;
            $datetimenow = date('Y-m-d H:i:s');
            if (YII_ENV_PROD) {
            	$email_subject = "LinkedFusion Production Server NEW HASH TESTING : web/securepayment/webhook-ipn_new_hash BAD IPN Signature";
            }else{
                $email_subject = "LinkedFusion Stagging Server NEW HASH TESTING : web/securepayment/webhook-ipn_new_hash BAD IPN Signature";
            }
            $mail = Yii::$app->mailer->compose()
                    ->setTo('nikit@intricaretech.com')
					->setFrom(Yii::$app->params['adminEmail'])
                    ->setSubject($email_subject)
                    ->setHtmlBody($html, 'text/html');
            $mail->send();
            //test email ends

            return;
        }
        
        // hash is valid. We proceed with success response
        $responseDate = date('YmdHis');
        
        $arrayForResponseHash = [
            $_POST["IPN_PID"][0],
            $_POST["IPN_PNAME"][0],
            $_POST["IPN_DATE"],
            $responseDate
        ];
        $stringForResponseHash = $this->serializeArray($arrayForResponseHash);
        
        $responseString = '';
        switch ($usedHashAlgorithm) {
            case "sha256":
                $responseHash = hash_hmac('sha256', $stringForResponseHash, $secretKey);
                $responseString = '<sig algo="sha256" date="' . $responseDate . '">' . $responseHash . '</sig>';
                break;
            case "sha3-256":
                $responseHash = hash_hmac('sha3-256', $stringForResponseHash, $secretKey);
                $responseString = '<sig algo="sha3-256" date="' . $responseDate . '">' . $responseHash . '</sig>';
                break;
        }
        
        //test email starts
        $message = "this is test email. IPN Signature success. responseString:".$responseString.'::::SERVER REQUEST_METHOD:'.$_SERVER['REQUEST_METHOD'];
		$html = $message;
		$datetimenow = date('Y-m-d H:i:s');
		if (YII_ENV_PROD) {
			$email_subject = "LinkedFusion Production Server NEW HASH TESTING : web/securepayment/webhook-ipn_new_hash Success IPN Signature";
		}else{
			$email_subject = "LinkedFusion Stagging Server NEW HASH TESTING : web/securepayment/webhook-ipn_new_hash Success IPN Signature";
		}
		$mail = Yii::$app->mailer->compose()
				->setTo('nikit@intricaretech.com')
				->setFrom(Yii::$app->params['adminEmail'])
				->setSubject($email_subject)
				->setHtmlBody($html, 'text/html');
		$mail->send();
		//test email ends

		//your processing code starts
		if(isset($_POST['SIGNATURE_SHA2_256'])){
			
			//data coming from 2checkout will be in post method.

			$isLfProductInIPN = false;
			$isLfBlackFridayProductInIPN = false;
			$isLfAddOnPackExclusiveOrder = false;
			$isLfAddOnPackProductInIPN = false;
			if(isset($_POST['IPN_PCODE'][0])){
				$allLfProductCodesArr = array(
					"LFPM",
					"LFPQ",
					"LFGM",
					"LFGQ",
					"LFUM",
					"LFUQ",
					"LFPSAR",
					"LFPA",
					"LFGSAR",
					"LFGA",
					"LFUSAR",
					"LFUA",
					"LFGM_v2",
					"LFUM_v2",
					"LFGSAR_v2",
					"LFUSAR_v2",
					"LFGA_v2",
					"LFUA_v2",
					"LFAddOnPack",
					);

				$allLfBlackFridayProductCodesArr = array(
					"LFPSA",
					"LFPABF",
					"LFGSA",
					"LFGABF",
					"LFUSA",
					"LFUABF"
					);

				$allLfAddOnPackProductCodesArr = array(
					"LFAddOnPack"
					);
					
				if(in_array($_POST['IPN_PCODE'][0],$allLfProductCodesArr)){
					$isLfProductInIPN = true;
				}

				if(in_array($_POST['IPN_PCODE'][0],$allLfBlackFridayProductCodesArr)){
					$isLfBlackFridayProductInIPN = true;
				}

				//24-06-2021 starts
				foreach($_POST['IPN_PCODE'] as $key=>$val){
					if(in_array($val,$allLfAddOnPackProductCodesArr)){
						$isLfAddOnPackProductInIPN = true;
						$isLfAddOnPackExclusiveOrder = true;
					}
				}
				
				if($isLfAddOnPackExclusiveOrder==true){
					$cnt_PEO=0;
					foreach($_POST['IPN_PCODE'] as $key=>$val){
						if(in_array($val,$allLfProductCodesArr) && $val!='LFAddOnPack'){
							$cnt_PEO++;
						}
					}
					if($cnt_PEO>0){
						$isLfAddOnPackExclusiveOrder = false;
					}
				}
				//24-06-2021 ends
				
			}else{
				//let it process.
				$isLfProductInIPN = true;
			}
			
			if($isLfProductInIPN){
				
				//email starts
					if (YII_ENV_PROD) {
						$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - Webhook Ipn";
					}else{
						$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - Webhook Ipn";
					}
				$html = json_encode($_POST,JSON_PRETTY_PRINT);
				$html.= '<br/>Timestamp:'.strtotime('now');
				$mail = Yii::$app->mailer->compose()
						->setTo('nikit@intricaretech.com')
						->setFrom(Yii::$app->params['adminEmail'])
						->setSubject($email_subject)
						->setHtmlBody($html, 'text/html');
				if (YII_ENV_PROD) {
				$mail->send();
				}else{
				$mail->send();
				}
				//email ends
			

				if (YII_ENV_PROD) {
					//production
					$merchantCode = "203537015";
					$key = 'd?q4rkG]&KAh#vwnmSJ%';
				}else{
					//staging
					$merchantCode = "251108887711";// your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
					$key = '!G2S8WRBKJ6#&c~luOz=';// your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
				}

				$gmdate = gmdate('Y-m-d H:i:s');
				$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
				$hashAlgorithm = 'sha256';
				$hash = hash_hmac($hashAlgorithm , $string, $key);
				
				//$OrderReferenceNumber = $_GET['refno'];
				$OrderReferenceNumber = $_POST['REFNO'];
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

				$headers = array();
				$headers[] = 'Accept: application/json';
				$headers[] = 'Content-Type: application/json';
				$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				$curl_result = curl_exec($ch);
				
				$curlResult = json_decode($curl_result);
				//echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
				if (curl_errno($ch)) {
					//echo 'Error:' . curl_error($ch);
				}
				curl_close($ch);
				//echo '<br/>';


				//test email starts
						$html = $curl_result;
						$datetimenow = date('Y-m-d H:i:s');
					if (YII_ENV_PROD) {
						$email_subject = "Linkedfusion Production Server - Webhook Ipn Order Ref #".$OrderReferenceNumber." Response";//at $datetimenow
					}else{
						$email_subject = "Linkedfusion Staging Server - Webhook Ipn Order Ref #".$OrderReferenceNumber." Response";
					}
						$mail = Yii::$app->mailer->compose()
								->setTo('nikit@intricaretech.com')
								->setFrom(Yii::$app->params['adminEmail'])
								->setSubject($email_subject)
								->setHtmlBody($html, 'text/html');
						if (YII_ENV_PROD) {
						$mail->send();
						}else{
						$mail->send();
						}
				//test email ends

				$responseGetJson = json_encode($_REQUEST);
				$responseOrderJson = $curl_result;
				//$responseOrderJson = json_decode($curl_result,true);
				//$responseOrderJson = json_encode($responseOrderJson);
				
				$flagSubscriptionDataNotFoundEmailSend = false;
				
				if(($curlResult->Status=='COMPLETE' || $curlResult->Status=='AUTHRECEIVED') && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK'){

					//$merchant_order_id= $response_data->merchant_order_id;
					$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;
					
					$twoCo_CustomerReference = 0;
					if(isset($curlResult->CustomerDetails->CustomerReference)){
						$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference;
					}
					
					
					$connection = Yii::$app->db;
					
					//14-10-2020 : In below query, removed this condition:  order_number='".$OrderReferenceNumber."'
					$uph_row = $connection->createCommand("select id,userid,response_get,isAddOnPackOrder from user_payment_history where merchant_id='".$merchant_order_id."' AND status='Initialize' AND ordertype='0' ORDER BY id DESC")->queryOne();
					//print_r($uph_row);
					if(!empty($uph_row)){
						//Usage of this code: For ordertype=0, Once the order is authorized, 2checkout will call this "webhookipn" method. The further process will be done from this code of block.
						//this block of code is used by normal recurring plan. Also, used by AddOnPack product;
						
						if(isset($curlResult->Items[0]->ProductDetails->Name) && isset($curlResult->Items[0]->Code) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionStartDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->ExpirationDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionReference) ){
							//above condition added on 09-10-2020
							//to put here 09-10-2020

							$uph_pkid = $uph_row['id'];
							
							//14-10-2020 : order_number and 2coCustomerReference added here in below query as we should not depend on response method;
							$command = $connection->createCommand('UPDATE user_payment_history SET complete_date = "'.date("Y-m-d H:i:s").'", status="Success", order_number = "'.$OrderReferenceNumber.'", 2coCustomerReference = "'.$twoCo_CustomerReference.'" WHERE id='.$uph_pkid);
							$command->execute();
							
							if($uph_row['response_get']==NULL){
								
								$responseGetVar = array('refno'=>$_POST['REFNO'],'total'=>$_POST['IPN_TOTALGENERAL'],'total-currency'=>$_POST['CURRENCY']);
								$responseGetVar = json_encode($responseGetVar);
								
								$connection->createCommand("UPDATE `user_payment_history` SET `response_get` = '".$responseGetVar."' where `id` =".$uph_pkid)->execute();
							}
							
							
							
							$response_data = $_POST;//$_GET;
							
							$order_number= $_POST['REFNO'];//$_GET['refno'];//this is order's reference number;
								
							//$signature= $_GET['signature'];
							
							/*Old Orig code commented on 06-01-2021
							$lfaf_seat_purchased_userids='';
							$addifi = $curlResult->AdditionalFields;
							foreach($addifi as $res){
								if($res->Code=="lfaf_seat_purchased_userids"){
									$lfaf_seat_purchased_userids = $res->Value;
								}
							}

							//$lfaf_seat_purchased_userids = '{"LFPM":["14935","14988"],"LFUM":["14987"]}';
							
							$lfaf_seat_purchased_userids = stripslashes($lfaf_seat_purchased_userids);//added 31-07-2020: removes slash
							$lfaf_seat_purchased_useridsArr = json_decode($lfaf_seat_purchased_userids,true);
							*/

							//06-01-2021 starts (now take seat purchased userids from database instead of getting depended on API)
							$lfafSeatPurchased_useridsArr = array();
							$upo_result = $connection->createCommand("select product_id,user_ids from user_order_products where uph_id='".$uph_pkid."' ORDER BY id ASC")->queryAll();
							if(!empty($upo_result)){
								foreach($upo_result as $uporow){
									$lfafSeatPurchased_useridsArr[$uporow['product_id']] = explode(',',$uporow['user_ids']);
								}
							}
							//echo '<br/>:::New:<pre>';print_r($lfafSeatPurchased_useridsArr);echo '</pre>';
							//06-01-2021 ends
							$lfaf_seat_purchased_useridsArr = $lfafSeatPurchased_useridsArr;
							
							
							
							//$user_id = Yii::$app->session->get('userid');
							$user_id = $uph_row['userid'];//order placed by this userid;


							//new starts

							
							$selPlanUsrArr=array();
							
							
							$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7',
							'LFPSAR'=>'8',
							'LFPA'=>'9',
							'LFGSAR'=>'10',
							'LFGA'=>'11',
							'LFUSAR'=>'12',
							'LFUA'=>'13',
							'LFGM_v2'=>'18',
							'LFUM_v2'=>'19',
							'LFGSAR_v2'=>'20',
							'LFUSAR_v2'=>'21',
							'LFGA_v2'=>'22',
							'LFUA_v2'=>'23'
							);
							
							$Items = $curlResult->Items;
							/*
							echo '<br/>Items::<pre>'; print_r($Items);
							echo '<br/><br/>';
							foreach($Items as $item_key=>$item_res){
								echo $item_res->Code;
								echo '<br/>';print_r($item_res);
							}
							die;*/


							foreach($Items as $item_key=>$item_res){
								$product_id = $item_res->Code;//this is product code eg: LCPM
								$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
								$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
								$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
								$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
								

								$command = $connection->createCommand('UPDATE user_order_products SET SubscriptionStartDate = "'.$SubscriptionStartDate.'", ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE", SubscriptionReference="'.$SubscriptionReference.'" WHERE uph_id='.$uph_pkid.' AND product_id="'.$product_id.'" ');
								$command->execute();
								
								$uidsStrPerProduct = implode(',',$lfaf_seat_purchased_useridsArr[$product_id]);
								if($product_id=='LFAddOnPack'){
									//for AddOnPackProduct
								}else{
									$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
								}
								
								$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
								
								//starts
								$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus',
								'8'=>'Professional Semi-Annually',
								'9'=>'Professional Annually',
								'10'=>'Grow Semi-Annually',
								'11'=>'Grow Annually',
								'12'=>'Ultimate Semi-Annually',
								'13'=>'Ultimate Annually',
								'14'=>'New Grow Monthly',
								'15'=>'New Grow Annual',
								'16'=>'New Ultimate Monthly',
								'17'=>'New Ultimate Annual',
								'18'=>'Grow Monthly',
								'19'=>'Ultimate Monthly',
								'20'=>'Grow Semi-Annually',
								'21'=>'Ultimate Semi-Annually',
								'22'=>'Grow Annually',
								'23'=>'Ultimate Annually'
								);
								$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
								foreach($userIdArr as $uid){
									
									$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
									$previous_plan = $usrcommand['sublevel'];
									$isTrial = $usrcommand['trial'];
									
									$previous_plan = $previous_plan_array[$previous_plan];
									if($product_id=='LFAddOnPack'){
										//for AddOnPackProduct
										if($isLfAddOnPackExclusiveOrder){
											$current_plan = $item_res->ProductDetails->Name;//this is product name;
										}else{
											$current_plan = $product_id;
										}
									}else{
										$current_plan = $previous_plan_array[$current_user_setting_plan];
									}
									
									$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
									$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
									$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
									$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
									$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
								}
								
								if($product_id=='LFAddOnPack'){
									//for AddOnPackProduct
									$command = $connection->createCommand('UPDATE user SET is_booster = "1", isBoosterOnTrial = 0, cancelBoosterSub = 0, boosterSubscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$uidsStrPerProduct.')');
									$command->execute();
								}else if($product_id=='LFUM_v2' || $product_id=='LFUSAR_v2' || $product_id=='LFUA_v2' || $product_id=="LFUM" || $product_id=="LFUQ" || $product_id=="LFUSAR" || $product_id=="LFUA"){
									//for above plans, booster pack is free.
									$command = $connection->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'", is_booster="1", isBoosterOnTrial = 0, cancelBoosterSub = 0, boosterSubscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$uidsStrPerProduct.')');
									$command->execute();
								}else{
									//trial_expired_at = "'.$ExpirationDateTimestamp.'"
									$command = $connection->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$uidsStrPerProduct.')');
									$command->execute();									
								}
									
								
								//ends
								
								$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
								if(empty($uos_row)){
									Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
								}
								
								
							}
							//echo '<br/>SDFDF:<pre>'; print_r($selPlanUsrArr);
							
							//new ends

							$usrInfoOrdPlaced = $connection->createCommand("select email,first_name from user where id='".$user_id."' ")->queryOne();
							$emailId = $usrInfoOrdPlaced['email'];
							$emailId = $usrInfoOrdPlaced['first_name'];

							$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$usrInfoOrdPlaced['email'],'ses_full_name'=>$usrInfoOrdPlaced['first_name']);
							if($isLfAddOnPackExclusiveOrder){
								$this->successedPaymentAddOnPackExclusiveOrder($payment_info);	
							}else{
							$this->successedPayment($payment_info);
							}
							
							$connection->createCommand("UPDATE `user_payment_history` SET `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$uph_pkid)->execute();
							
							echo '<br>The End';
							
							//Yii::$app->session->set('success_message',"Successfully enabled subscription.");
							//return $this->redirect(['my-template/pricing']);

							
						}else{
							$flagSubscriptionDataNotFoundEmailSend = true;
							//if subscription data not found just send email;
						}
						
						
					}
					


					
				}
				
				//30-09-2020 starts
				if(($curlResult->Status=='COMPLETE' || $curlResult->Status=='AUTHRECEIVED') && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK'){
					//Usage:When manual renewal order is authorized, this code of block will process futher.
					
					$order_number= $OrderReferenceNumber;//this is order's reference number;
					$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;it is blank here.
					
					$uph_row = Yii::$app->db->createCommand("select t1.id, t1.response_get from user_payment_history t1 where t1.order_number='".$OrderReferenceNumber."' and t1.status='Initialize' and t1.ordertype='4' ORDER BY t1.id DESC")->queryOne();
					
					if(!empty($uph_row)){
						
						if(isset($curlResult->Items[0]->ProductDetails->Name) && isset($curlResult->Items[0]->Code) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionStartDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->ExpirationDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionReference) ){
							//above condition added on 09-10-2020
							//to put here 09-10-2020

							$newOrder_uphpkid = $lastuphid = $uph_row['id'];
							$response_get = json_decode($uph_row['response_get']);
							//echo '<pre>';print_r($response_get);
							$GETSubscriptionRef = $response_get->subscription;
							
							$responseGetJson = $uph_row['response_get'];
							
							$uph_row = Yii::$app->db->createCommand("select t1.id, t1.userid,t1.2coCustomerReference, t2.email, t2.username, t2.first_name, t2.last_name from user_payment_history t1 JOIN user t2 ON t1.userid=t2.id JOIN user_order_products t3 ON t1.id=t3.uph_id where t3.SubscriptionReference='".$GETSubscriptionRef."' ORDER BY t1.id DESC")->queryOne();
							if(!empty($uph_row)){
								$uph_pkid = $uph_row['id'];
								
								Yii::$app->db->createCommand('UPDATE user_payment_history SET complete_date = "'.date("Y-m-d H:i:s").'", status="Success" WHERE id='.$newOrder_uphpkid)->execute();
								

								$selPlanUsrArr=array();
								$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7',
								'LFPSAR'=>'8',
								'LFPA'=>'9',
								'LFGSAR'=>'10',
								'LFGA'=>'11',
								'LFUSAR'=>'12',
								'LFUA'=>'13',
								'LFGM_v2'=>'18',
								'LFUM_v2'=>'19',
								'LFGSAR_v2'=>'20',
								'LFUSAR_v2'=>'21',
								'LFGA_v2'=>'22',
								'LFUA_v2'=>'23'
								);
								/*
								$fullplanname_array = array('Free'=>'Free','Professional Monthly'=>'LFPM','Professional Quarterly'=>'LFPQ','Grow Monthly'=>'LFGM','Grow Quarterly'=>'LFGQ','Ultimate Monthly'=>'LFUM','Ultimate Quarterly'=>'LFUQ','Ultimate Plus'=>'LFUP',
								'Professional Semi-Annually'=>'LFPSAR',
								'Professional Annually'=>'LFPA',
								'Grow Semi-Annually'=>'LFGSAR',
								'Grow Annually'=>'LFGA',
								'Ultimate Semi-Annually'=>'LFUSAR',
								'Ultimate Annually'=>'LFUA',
								'Grow Monthly'=>'LFGM_v2',
								'Ultimate Monthly'=>'LFUM_v2',
								'Grow Semi-Annually'=>'LFGSAR_v2',
								'Ultimate Semi-Annually'=>'LFUSAR_v2',
								'Grow Annually'=>'LFGA_v2',
								'Ultimate Annually'=>'LFUA_v2'
								);
								*/
						
								$Items = $curlResult->Items;				

								foreach($Items as $item_key=>$item_res){
					
									
										$product_id = $item_res->Code;//this is product code eg: LCPM
										$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
										$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
										$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
										$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
										if($product_id=='LFAddOnPack'){
											//for AddOnPackProduct
										}else{
										$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
										}
										if($GETSubscriptionRef==$SubscriptionReference){
											
										
											$upo_row = Yii::$app->db->createCommand("select id,user_ids from user_order_products where uph_id =".$uph_pkid." AND product_id='".$product_id."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
											
											if(!empty($upo_row)){
												$upo_user_ids = $upo_row['user_ids'];
												
												//SubscriptionStartDate = "'.$SubscriptionStartDate.'"
												Yii::$app->db->createCommand('UPDATE user_order_products SET ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE" WHERE id='.$upo_row['id'])->execute();
												
												Yii::$app->db->createCommand("UPDATE `user_payment_history` SET user_ids = '".$upo_user_ids."' where id =".$lastuphid)->execute();
												
												
												$lfaf_seat_purchased_useridsArr = array();
												$lfaf_seat_purchased_useridsArr[$product_id] = explode(',',$upo_user_ids);
						

												//$uidsStrPerProduct = $upo_user_ids;
												$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
												
												
												//starts
												$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus',
												'8'=>'Professional Semi-Annually',
												'9'=>'Professional Annually',
												'10'=>'Grow Semi-Annually',
												'11'=>'Grow Annually',
												'12'=>'Ultimate Semi-Annually',
												'13'=>'Ultimate Annually',
												'14'=>'New Grow Monthly',
												'15'=>'New Grow Annual',
												'16'=>'New Ultimate Monthly',
												'17'=>'New Ultimate Annual',
												'18'=>'Grow Monthly',
												'19'=>'Ultimate Monthly',
												'20'=>'Grow Semi-Annually',
												'21'=>'Ultimate Semi-Annually',
												'22'=>'Grow Annually',
												'23'=>'Ultimate Annually'
												);
												$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
												foreach($userIdArr as $uid){
													
													$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
													$previous_plan = $usrcommand['sublevel'];
													$isTrial = $usrcommand['trial'];
													
													$previous_plan = $previous_plan_array[$previous_plan];
													if($product_id=='LFAddOnPack'){
														//for AddOnPackProduct
														if($isLfAddOnPackExclusiveOrder){
															$current_plan = $item_res->ProductDetails->Name;//this is product name;
														}else{
															$current_plan = $product_id;
														}
													}else{
													$current_plan = $previous_plan_array[$current_user_setting_plan];
													}
													$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
													$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
													$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
													$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
													$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
												}
												
												if($product_id=='LFAddOnPack'){
													//for AddOnPackProduct
													Yii::$app->db->createCommand('UPDATE user SET is_booster = "1", isBoosterOnTrial = 0, cancelBoosterSub = 0, boosterSubscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
													
												}else if($product_id=='LFUM_v2' || $product_id=='LFUSAR_v2' || $product_id=='LFUA_v2' || $product_id=="LFUM" || $product_id=="LFUQ" || $product_id=="LFUSAR" || $product_id=="LFUA"){
													//for above plans, booster pack is free.
													Yii::$app->db->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'", is_booster = "1", isBoosterOnTrial = 0, cancelBoosterSub = 0, boosterSubscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
												
												}else{
													//trial_expired_at = "'.$ExpirationDateTimestamp.'"
													Yii::$app->db->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
												}
												//ends
												
												$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$uph_row['email'],'ses_full_name'=>$uph_row['first_name'].' '.$uph_row['last_name'],'responseGetJson'=> $responseGetJson,'GETSubscriptionRef'=>$GETSubscriptionRef);
												if($isLfAddOnPackExclusiveOrder){
													$this->renewedSuccessedPaymentAddOnPackExclusiveOrder($payment_info);	
												}else{
												$this->renewedSuccessedPayment($payment_info);
												}
												
												$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
												if(empty($uos_row)){
													Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
												}
												
												echo '<br/>The end';
												
											}

										}
								}							
								
							}


						}else{
							$flagSubscriptionDataNotFoundEmailSend = true;
							//if subscription data not found just send email;
						}
						
						
					}
					
				}
				//30-09-2020 ends


				//09-10-2020 starts
				if($flagSubscriptionDataNotFoundEmailSend==true){
					//if subscription data not found just send email;
					//email starts
					if($isLfAddOnPackExclusiveOrder){
						$html = 'Hello Admin,<br/><br/>For Order Ref #'.$OrderReferenceNumber.' IPN is called but it does not yet contain Subscription Data. So, for this user, data are not updated.<br/>For smooth experience, manually call actionWebhookIpn method by passing valid post variables.<br/><br/>Below post data received:<br>';
					}else{
						$html = 'Hello Admin,<br/><br/>For Order Ref #'.$OrderReferenceNumber.' IPN is called but it does not yet contain Subscription Data. So, for this user, sublevel and other data are not updated.<br/>For smooth experience, manually call actionWebhookIpn method by passing valid post variables.<br/><br/>Below post data received:<br>';
					}
						$html.= json_encode($_POST,JSON_PRETTY_PRINT);
						
					if (YII_ENV_PROD) {
						$email_subject = "Linkedfusion Production Server - Webhook Ipn Order Ref #".$OrderReferenceNumber." Called But Not Having Subscription Data";
						$to_email = ['arpan@intricare.net','nikit@intricaretech.com'];
					}else{
						$email_subject = "Linkedfusion Staging Server - Webhook Ipn Order Ref #".$OrderReferenceNumber." Called But Not Having Subscription Data";
						$to_email = 'nikit@intricaretech.com';
					}
						$mail = Yii::$app->mailer->compose()
								->setTo($to_email)
								->setFrom(Yii::$app->params['adminEmail'])
								->setSubject($email_subject)
								->setHtmlBody($html, 'text/html');
						$mail->send();
					//email ends
				}
				//09-10-2020 ends


			}
			

			if($isLfBlackFridayProductInIPN){
				//This code block is only for LF Blackfriday products;
				//Blackfriday products recurring nathi. only 1 time. Blackfriday products ma upgrade subscription, cancel subscription nai aave; also, auto/manual renewal pan nai aave;
				
				//email starts
					if (YII_ENV_PROD) {
						$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - Webhook Ipn Blackfriday";
					}else{
						$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - Webhook Ipn Blackfriday";
					}
				$html = json_encode($_POST,JSON_PRETTY_PRINT);
				$html.= '<br/>Timestamp:'.strtotime('now');
				$mail = Yii::$app->mailer->compose()
						->setTo('nikit@intricaretech.com')
						->setFrom(Yii::$app->params['adminEmail'])
						->setSubject($email_subject)
						->setHtmlBody($html, 'text/html');
				if (YII_ENV_PROD) {
				$mail->send();
				}else{
					
				}
				//email ends
				
				//order response email send starts
				if (YII_ENV_PROD) {
					//production
					$merchantCode = "203537015";
					$key = 'd?q4rkG]&KAh#vwnmSJ%';
				}else{
					//staging
					$merchantCode = "251108887711";// your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
					$key = '!G2S8WRBKJ6#&c~luOz=';// your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
				}

				$gmdate = gmdate('Y-m-d H:i:s');
				$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
				$hashAlgorithm = 'sha256';
				$hash = hash_hmac($hashAlgorithm , $string, $key);
				
				//$OrderReferenceNumber = $_GET['refno'];
				$OrderReferenceNumber = $_POST['REFNO'];
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

				$headers = array();
				$headers[] = 'Accept: application/json';
				$headers[] = 'Content-Type: application/json';
				$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				$curl_result = curl_exec($ch);
				
				$curlResult = json_decode($curl_result);
				//echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
				if (curl_errno($ch)) {
					//echo 'Error:' . curl_error($ch);
				}
				curl_close($ch);
				//echo '<br/>';


				//test email starts
						$html = $curl_result;
						$datetimenow = date('Y-m-d H:i:s');
					if (YII_ENV_PROD) {
						$email_subject = "Linkedfusion Production Server - Blackfriday Webhook Ipn Order Ref #".$OrderReferenceNumber." Response";//at $datetimenow
					}else{
						$email_subject = "Linkedfusion Staging Server - Blackfriday Webhook Ipn Order Ref #".$OrderReferenceNumber." Response";
					}
						$mail = Yii::$app->mailer->compose()
								->setTo('nikit@intricaretech.com')
								->setFrom(Yii::$app->params['adminEmail'])
								->setSubject($email_subject)
								->setHtmlBody($html, 'text/html');
						if (YII_ENV_PROD) {
						$mail->send();
						}else{
							
						}
				//test email ends
				//order response email send ends

				$responseGetJson = json_encode($_REQUEST);
				$responseOrderJson = $curl_result;
				//$responseOrderJson = json_decode($curl_result,true);
				//$responseOrderJson = json_encode($responseOrderJson);
				
				
				
				if(($curlResult->Status=='COMPLETE' || $curlResult->Status=='AUTHRECEIVED') && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK'){

					//$merchant_order_id= $response_data->merchant_order_id;
					$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;
					
					$twoCo_CustomerReference = 0;
					if(isset($curlResult->CustomerDetails->CustomerReference)){
						$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference;
					}
					
					
					$connection = Yii::$app->db;
					
					
					$uph_row = $connection->createCommand("select id,userid,response_get from user_payment_history where merchant_id='".$merchant_order_id."' AND status='Initialize' AND ordertype='0' ORDER BY id DESC")->queryOne();
					//print_r($uph_row);
					if(!empty($uph_row)){
						//Usage of this code: For ordertype=0, Once the order is authorized, 2checkout will call this "webhookipn" method. The further process will be done from this code of block.
						
						if(isset($curlResult->Items[0]->ProductDetails->Name) && isset($curlResult->Items[0]->Code) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionStartDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionReference) ){
							
							

							$uph_pkid = $uph_row['id'];
							
							//14-10-2020 : order_number and 2coCustomerReference added here in below query as we should not depend on response method;
							$command = $connection->createCommand('UPDATE user_payment_history SET complete_date = "'.date("Y-m-d H:i:s").'", status="Success", order_number = "'.$OrderReferenceNumber.'", 2coCustomerReference = "'.$twoCo_CustomerReference.'" WHERE id='.$uph_pkid);
							$command->execute();
							
							if($uph_row['response_get']==NULL){
								
								$responseGetVar = array('refno'=>$_POST['REFNO'],'total'=>$_POST['IPN_TOTALGENERAL'],'total-currency'=>$_POST['CURRENCY']);
								$responseGetVar = json_encode($responseGetVar);
								
								$connection->createCommand("UPDATE `user_payment_history` SET `response_get` = '".$responseGetVar."' where `id` =".$uph_pkid)->execute();
							}
							
							
							
							$response_data = $_POST;//$_GET;
							
							$order_number= $_POST['REFNO'];//$_GET['refno'];//this is order's reference number;
								
							//$signature= $_GET['signature'];
							
							/*Old Orig code commented on 06-01-2021
							$lfaf_seat_purchased_userids='';
							$addifi = $curlResult->AdditionalFields;
							foreach($addifi as $res){
								if($res->Code=="lfaf_seat_purchased_userids"){
									$lfaf_seat_purchased_userids = $res->Value;
								}
							}

							//$lfaf_seat_purchased_userids = '{"LFPSA":["14935","14988"],"LFGSA":["14987"]}';
							
							$lfaf_seat_purchased_userids = stripslashes($lfaf_seat_purchased_userids);//added 31-07-2020: removes slash
							$lfaf_seat_purchased_useridsArr = json_decode($lfaf_seat_purchased_userids,true);
							*/

							//06-01-2021 starts (now take seat purchased userids from database instead of getting depended on API)
							$lfafSeatPurchased_useridsArr = array();
							$upo_result = $connection->createCommand("select product_id,user_ids from user_order_products where uph_id='".$uph_pkid."' ORDER BY id ASC")->queryAll();
							if(!empty($upo_result)){
								foreach($upo_result as $uporow){
									$lfafSeatPurchased_useridsArr[$uporow['product_id']] = explode(',',$uporow['user_ids']);
								}
							}
							//echo '<br/>:::New:<pre>';print_r($lfafSeatPurchased_useridsArr);echo '</pre>';
							//06-01-2021 ends
							$lfaf_seat_purchased_useridsArr = $lfafSeatPurchased_useridsArr;
							
							
							
							//$user_id = Yii::$app->session->get('userid');
							$user_id = $uph_row['userid'];//order placed by this userid;


							//new starts

							
							$selPlanUsrArr=array();
							
							
							$current_user_setting_plan_array = array('0'=>'Free','LFPSA'=>'1','LFPABF'=>'2','LFGSA'=>'3','LFGABF'=>'4','LFUSA'=>'5','LFUABF'=>'6','LFUP'=>'7',
							'LFPSAR'=>'8',
							'LFPA'=>'9',
							'LFGSAR'=>'10',
							'LFGA'=>'11',
							'LFUSAR'=>'12',
							'LFUA'=>'13',
							'LFGM_v2'=>'18',
							'LFUM_v2'=>'19',
							'LFGSAR_v2'=>'20',
							'LFUSAR_v2'=>'21',
							'LFGA_v2'=>'22',
							'LFUA_v2'=>'23'
							);
							
							$Items = $curlResult->Items;
							/*
							echo '<br/>Items::<pre>'; print_r($Items);
							echo '<br/><br/>';
							foreach($Items as $item_key=>$item_res){
								echo $item_res->Code;
								echo '<br/>';print_r($item_res);
							}
							die;*/


							foreach($Items as $item_key=>$item_res){
								$product_id = $item_res->Code;//this is product code eg: LFPSA
								$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
								//$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;//this value will be blank for blackfriday products;

								if($product_id=='LFPSA' || $product_id=='LFGSA' || $product_id=='LFUSA'){
									//for blackfriday Semi Annual plans
									$ExpirationDate = date('Y-m-d H:i:s', strtotime($SubscriptionStartDate. ' + 6 months'));
								}else{
									//for blackfriday Annual plans
									$ExpirationDate = date('Y-m-d H:i:s', strtotime($SubscriptionStartDate. ' + 1 year'));
								}
								
								//$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
								$ExpirationDateTimestamp = strtotime($ExpirationDate) * 1000;
								$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
								

								$command = $connection->createCommand('UPDATE user_order_products SET SubscriptionStartDate = "'.$SubscriptionStartDate.'", ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE", SubscriptionReference="'.$SubscriptionReference.'" WHERE uph_id='.$uph_pkid.' AND product_id="'.$product_id.'" ');
								$command->execute();
								
								$uidsStrPerProduct = implode(',',$lfaf_seat_purchased_useridsArr[$product_id]);
								$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
								
								$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
								
								//starts
								$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus',
								'8'=>'Professional Semi-Annually',
								'9'=>'Professional Annually',
								'10'=>'Grow Semi-Annually',
								'11'=>'Grow Annually',
								'12'=>'Ultimate Semi-Annually',
								'13'=>'Ultimate Annually',
								'14'=>'New Grow Monthly',
								'15'=>'New Grow Annual',
								'16'=>'New Ultimate Monthly',
								'17'=>'New Ultimate Annual',
								'18'=>'Grow Monthly',
								'19'=>'Ultimate Monthly',
								'20'=>'Grow Semi-Annually',
								'21'=>'Ultimate Semi-Annually',
								'22'=>'Grow Annually',
								'23'=>'Ultimate Annually'
								);
								
								$lfblackfriday_plan_array = array('0'=>'Free','1'=>'Professional Semi Annual Black Friday','2'=>'Professional Annual Black Friday','3'=>'Grow Semi Annual Black Friday','4'=>'Grow Annual Black Friday','5'=>'Ultimate Semi Annual Black Friday','6'=>'Ultimate Annual Black Friday','7'=>'Ultimate Plus');
								
								$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
								foreach($userIdArr as $uid){
									
									$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
									$previous_plan = $usrcommand['sublevel'];
									$isTrial = $usrcommand['trial'];
									
									$previous_plan = $previous_plan_array[$previous_plan];
									
									//$current_plan = $previous_plan_array[$current_user_setting_plan];
									$current_plan = $lfblackfriday_plan_array[$current_user_setting_plan];
									
									$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
									$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
									$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
									$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
									$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
								}
								//trial_expired_at = "'.$ExpirationDateTimestamp.'"
								//18-Nov-2021: Into below query trial was 0. Changed to 1.
								$command = $connection->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 1, trial_expired_at = "'.$ExpirationDateTimestamp.'", cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$uidsStrPerProduct.')');
								$command->execute();
								//ends
								
								$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
								if(empty($uos_row)){
									Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
								}
								
								
							}
							//echo '<br/>SDFDF:<pre>'; print_r($selPlanUsrArr);
							
							//new ends

							$usrInfoOrdPlaced = $connection->createCommand("select email,first_name from user where id='".$user_id."' ")->queryOne();
							$emailId = $usrInfoOrdPlaced['email'];
							$emailId = $usrInfoOrdPlaced['first_name'];

							$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$usrInfoOrdPlaced['email'],'ses_full_name'=>$usrInfoOrdPlaced['first_name']);
							$this->successedPayment($payment_info);
							
							$connection->createCommand("UPDATE `user_payment_history` SET `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$uph_pkid)->execute();
							
							echo '<br>The End';
							
							//Yii::$app->session->set('success_message',"Successfully enabled subscription.");
							//return $this->redirect(['my-template/pricing']);

							
						}else{
							
							//if subscription data not found just send email;
							//email starts
					
								$html = 'Hello Admin,<br/><br/>For Order Ref #'.$OrderReferenceNumber.' IPN is called but it does not yet contain Subscription Data. So, for this user sublevel and other data are not updated.<br/>For smooth experience, manually call actionWebhookIpn method by passing valid post variables.<br/><br/>Below post data received:<br>';
								$html.= json_encode($_POST,JSON_PRETTY_PRINT);
								
							if (YII_ENV_PROD) {
								$email_subject = "Linkedfusion Production Server - Blackfriday Webhook Ipn Order Ref #".$OrderReferenceNumber." Called But Not Having Subscription Data";
								$to_email = ['arpan@intricare.net','nikit@intricaretech.com'];
							}else{
								$email_subject = "Linkedfusion Staging Server - Blackfriday Webhook Ipn Order Ref #".$OrderReferenceNumber." Called But Not Having Subscription Data";
								$to_email = 'nikit@intricaretech.com';
							}
								$mail = Yii::$app->mailer->compose()
										->setTo($to_email)
										->setFrom(Yii::$app->params['adminEmail'])
										->setSubject($email_subject)
										->setHtmlBody($html, 'text/html');
								$mail->send();
							//email ends
							
						}
						
						
					}
					


					
				}

				
			}
			
		}
		//your processing code ends
        
        http_response_code(200);
        echo $responseString;

    }

	//20-03-2024
    function serializeArray($array) {
        $ret_value = "";
    
        foreach ($array as $key => $val) {
            /* skip signature hashes from computed hash */
            if (in_array($key , ['HASH', 'SIGNATURE_SHA2_256', 'SIGNATURE_SHA3_256'], true)) {
                continue;
            }
    
            if (is_array($val)) {
                $ret_value .= $this->serializeArray($val);
            } else {
                $ret_value .= strlen($val) . $val;
            }
        }
    
        return $ret_value;
    }

	//NR: testing: this is created to check whether it is called when customer cancel the subscription; Found that its not calling when customer cancel the subscription;
	public function actionWebhookInsWhenRecurringStopped(){
		
		
		//Order reference #129660480  Order no: 192
		//order can contains multiple subscription. The subscription (on which the recurring stopped) #56F0CEEF71 has 2 Qty that cause 2 below calls. ie. LFPM x 2
 		/*
		{ "sale_id": "250450767314", "sale_date_placed": "2020-08-09 14:43:14", "recurring": "1", "payment_type": "credit card", "list_currency": "USD", "order_ref": "129660480", "order_no": "192", "vendor_id": "251108887711", "vendor_order_id": "1596779952_hEbTzkPmTErRlIK", "invoice_id": "250453282772", "item_count": "1", "customer_first_name": "Mike", "customer_last_name": "Doe", "customer_name": "Mike Doe", "customer_email": "nikit@intricaretech.com", "customer_phone": "", "customer_ip": "203.187.228.19", "customer_ip_country": "India", "cust_currency": "USD", "bill_city": "vadodara", "bill_country": "IND", "bill_postal_code": "123456", "bill_state": "Gujarat", "bill_street_address": "-", "bill_street_address2": "", "ship_status": "", "ship_tracking_number": "", "ship_name": "Doe Mike", "ship_street_address": "-", "ship_street_address2": "", "ship_city": "vadodara", "ship_state": "Gujarat", "ship_postal_code": "123456", "ship_country": "IND", "message_id": "435", "message_type": "RECURRING_STOPPED", "message_description": "Recurring order stopped", "timestamp": "2020-08-11 10:59:52 EEST", "item_name_1": "Professional Monthly", "item_id_1": "", "item_list_amount_1": "65.95", "item_usd_amount_1": "65.95", "item_cust_amount_1": "65.95", "item_type_1": "bill", "item_duration_1": "Forever", "item_recurrence_1": "7 Day", "item_rec_list_amount_1": "", "item_rec_status_1": "cancelled", "item_rec_date_next_1": "", "item_rec_install_billed_1": "", "md5_hash": "5F83E063F0713655EAA6C02C65B3B4A6", "key_count": "51" }
		
		{ "sale_id": "250450767314", "sale_date_placed": "2020-08-09 14:43:14", "recurring": "1", "payment_type": "credit card", "list_currency": "USD", "order_ref": "129660480", "order_no": "192", "vendor_id": "251108887711", "vendor_order_id": "1596779952_hEbTzkPmTErRlIK", "invoice_id": "250453282772", "item_count": "1", "customer_first_name": "Mike", "customer_last_name": "Doe", "customer_name": "Mike Doe", "customer_email": "nikit@intricaretech.com", "customer_phone": "", "customer_ip": "203.187.228.19", "customer_ip_country": "India", "cust_currency": "USD", "bill_city": "vadodara", "bill_country": "IND", "bill_postal_code": "123456", "bill_state": "Gujarat", "bill_street_address": "-", "bill_street_address2": "", "ship_status": "", "ship_tracking_number": "", "ship_name": "Doe Mike", "ship_street_address": "-", "ship_street_address2": "", "ship_city": "vadodara", "ship_state": "Gujarat", "ship_postal_code": "123456", "ship_country": "IND", "message_id": "436", "message_type": "RECURRING_STOPPED", "message_description": "Recurring order stopped", "timestamp": "2020-08-11 10:59:52 EEST", "item_name_1": "Professional Monthly", "item_id_1": "", "item_list_amount_1": "65.95", "item_usd_amount_1": "65.95", "item_cust_amount_1": "65.95", "item_type_1": "bill", "item_duration_1": "Forever", "item_recurrence_1": "7 Day", "item_rec_list_amount_1": "", "item_rec_status_1": "cancelled", "item_rec_date_next_1": "", "item_rec_install_billed_1": "", "md5_hash": "5F83E063F0713655EAA6C02C65B3B4A6", "key_count": "51" }



		
		*/
		
		
		echo '<pre>'; print_r($_POST);echo '</pre>';
		
		$order_number = $_POST['order_ref'];//this is latest order's reference number while subscription is stopped from either by customer's 2checkout panel or vendor's 2checkout panel;
		
		//$uphOrderExist_row = Yii::$app->db->createCommand("select id from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
		//if(!empty($uphOrderExist_row)){
			//if order is already exists nothing happen;
			//NR: when subscription licence is renewed and if it has more than 1 Qty (of product), this ins method will call that number of times.
		//}else{

			//$_POST['vendor_order_id'] eg:1596779952_hEbTzkPmTErRlIK
			if(isset($_POST['vendor_order_id']) && $_POST['vendor_order_id']!='' && isset($_POST['message_type']) && $_POST['message_type']=='RECURRING_STOPPED'){
			

				if (YII_ENV_PROD) {
					//production
					$merchantCode = "203537015";
					$key = 'd?q4rkG]&KAh#vwnmSJ%';
				}else{
					//staging
					$merchantCode = "251108887711";// your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
					$key = '!G2S8WRBKJ6#&c~luOz=';// your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
				}

				$gmdate = gmdate('Y-m-d H:i:s');
				$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
				$hashAlgorithm = 'sha256';
				$hash = hash_hmac($hashAlgorithm , $string, $key);
				
				$OrderReferenceNumber = $_POST['order_ref'];
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

				$headers = array();
				$headers[] = 'Accept: application/json';
				$headers[] = 'Content-Type: application/json';
				$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				$curl_result = curl_exec($ch);
				
				$curlResult = json_decode($curl_result);
				echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
				if (curl_errno($ch)) {
					//echo 'Error:' . curl_error($ch);
				}
				curl_close($ch);
				
				$responseGetJson = json_encode($_POST);
				$responseOrderJson = $curl_result;
				
				//die;				
				$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id; it is blank here for Renewal Order;
				
				$twoCo_CustomerReference = 0;
				if(isset($curlResult->CustomerDetails->CustomerReference)){
					//CustomerDetails not exits here for Renewal Order;
					$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference;
				}


				$uph_row = Yii::$app->db->createCommand("select t1.id, t1.userid,t1.2coCustomerReference, t2.email, t2.username, t2.first_name, t2.last_name from user_payment_history t1 JOIN user t2 ON t1.userid=t2.id where t1.merchant_id='".$_POST['vendor_order_id']."' ORDER BY t1.id DESC")->queryOne();
				if(!empty($uph_row)){
					echo '<br/>uph_row:<br/><pre>'; print_r($uph_row);echo '</pre>';

					$uph_pkid = $uph_row['id'];
					
					$user_infoArr = array();
					$user_infoArr['merchant_order_id'] = $merchant_order_id;//it is blank here for Renewal Order;
					$user_infoArr['email'] = $uph_row['email'];
					$user_infoArr['username'] = $uph_row['username'];
					$user_infoArr['user_id'] = $uph_row['userid'];
					
					if($twoCo_CustomerReference==0){
						$twoCo_CustomerReference = $uph_row['2coCustomerReference'];
					}
					
					// $sql_moi='merchant_id='.$merchant_order_id; //commented on 20-11-2023 due to error in insert qry when it has value.
					$sql_moi='merchant_id="'.$merchant_order_id.'"';
					if($merchant_order_id==''){
						$sql_moi='merchant_id=NULL';
					}

					$uphOrderExist_row = Yii::$app->db->createCommand("select id,user_ids from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
					if(!empty($uphOrderExist_row)){
						$lastuphid = $uphOrderExist_row['id'];
					}
					/*else{
						
						$uphOrderExist_row = Yii::$app->db->createCommand("select id,user_ids from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
						if(!empty($uphOrderExist_row)){
							$lastuphid = $uphOrderExist_row['id'];
						}else{
							//new order insert entry //user_ids=''
							Yii::$app->db->createCommand('INSERT INTO user_payment_history SET userid='.$uph_row['userid'].', order_number = "'.$order_number.'", '.$sql_moi.', user_info = "'.addslashes(json_encode($user_infoArr)).'" , status="Success", complete_date = "'.date("Y-m-d H:i:s").'", 2coCustomerReference = "'.$twoCo_CustomerReference.'",ordertype=2')->execute();
							$lastuphid = Yii::$app->db->getLastInsertID();
							
							Yii::$app->db->createCommand("UPDATE `user_payment_history` SET `response_get` = '".addslashes($responseGetJson)."', `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$lastuphid)->execute(); 							
						}
					}*/
						
						
						$selPlanUsrArr=array();
						$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7',
						'LFPSAR'=>'8',
						'LFPA'=>'9',
						'LFGSAR'=>'10',
						'LFGA'=>'11',
						'LFUSAR'=>'12',
						'LFUA'=>'13',
						'LFGM_v2'=>'18',
						'LFUM_v2'=>'19',
						'LFGSAR_v2'=>'20',
						'LFUSAR_v2'=>'21',
						'LFGA_v2'=>'22',
						'LFUA_v2'=>'23'
						);
						/*
						$fullplanname_array = array('Free'=>'Free','Professional Monthly'=>'LFPM','Professional Quarterly'=>'LFPQ','Grow Monthly'=>'LFGM','Grow Quarterly'=>'LFGQ','Ultimate Monthly'=>'LFUM','Ultimate Quarterly'=>'LFUQ','Ultimate Plus'=>'LFUP',
						'Professional Semi-Annually'=>'LFPSAR',
						'Professional Annually'=>'LFPA',
						'Grow Semi-Annually'=>'LFGSAR',
						'Grow Annually'=>'LFGA',
						'Ultimate Semi-Annually'=>'LFUSAR',
						'Ultimate Annually'=>'LFUA'
						);
						*/
				
						$Items = $curlResult->Items;
						
						foreach($Items as $item_key=>$item_res){
			
							//$_POST['item_name_1'] : getting only 1 item_name here. there is no item_name_2 or further found as of now;
							//if($item_res->Code==$fullplanname_array[$_POST['item_name_1']])
							//04-11-2020: above condition commented, below condition added;
							if($item_res->Code==$_POST['item_id_1']){
								
							
								$product_id = $item_res->Code;//this is product code eg: LCPM
								$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
								$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
								$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
								$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
								if($product_id=='LFAddOnPack'){
									//for AddOnPackProduct
								}else{
								$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
								}
								
								
								$upo_row = Yii::$app->db->createCommand("select id,user_ids,ExpirationDate from user_order_products where uph_id =".$uph_pkid." AND product_id='".$product_id."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
								
								if(!empty($upo_row)){
									$upo_user_ids = $upo_row['user_ids'];
									$upo_ExpirationDate = $upo_row['ExpirationDate'];
									
									if($upo_ExpirationDate!=$ExpirationDate){
										//SubscriptionStartDate = "'.$SubscriptionStartDate.'", 2coSubscriptionStatus="ACTIVE"
										Yii::$app->db->createCommand('UPDATE user_order_products SET ExpirationDate = "'.$ExpirationDate.'" WHERE id='.$upo_row['id'])->execute();
										echo '<br/>UPDATE user_order_products SET ExpirationDate = "'.$ExpirationDate.'" WHERE id='.$upo_row['id'];
									}
									
									/*
									if(isset($uphOrderExist_row['id'])){
										$previousSubscriptionUserIDs = explode(',',$uphOrderExist_row['user_ids']);
										
										$currentSubscriptionUserIDs = $upo_user_ids;
										$currentSubscriptionUserIDs = explode(',',$currentSubscriptionUserIDs);
										
										$allUserIDs = array_unique(array_merge($previousSubscriptionUserIDs, $currentSubscriptionUserIDs));
										$allUserIDs = implode(',',$allUserIDs);
										
									}else{
										$allUserIDs = $upo_user_ids;
									}
									
									
									
									Yii::$app->db->createCommand("UPDATE `user_payment_history` SET user_ids = '".$allUserIDs."' where id =".$lastuphid)->execute();
									*/
									
									
									$lfaf_seat_purchased_useridsArr = array();
									$lfaf_seat_purchased_useridsArr[$product_id] = explode(',',$upo_user_ids);
			

									//$uidsStrPerProduct = $upo_user_ids;
									$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
									
									
									//starts
									$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus',
									'8'=>'Professional Semi-Annually',
									'9'=>'Professional Annually',
									'10'=>'Grow Semi-Annually',
									'11'=>'Grow Annually',
									'12'=>'Ultimate Semi-Annually',
									'13'=>'Ultimate Annually',
									'14'=>'New Grow Monthly',
									'15'=>'New Grow Annual',
									'16'=>'New Ultimate Monthly',
									'17'=>'New Ultimate Annual',
									'18'=>'Grow Monthly',
									'19'=>'Ultimate Monthly',
									'20'=>'Grow Semi-Annually',
									'21'=>'Ultimate Semi-Annually',
									'22'=>'Grow Annually',
									'23'=>'Ultimate Annually'
									);
									$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
									foreach($userIdArr as $uid){
										
										$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
										$previous_plan = $usrcommand['sublevel'];
										$isTrial = $usrcommand['trial'];
										
										$previous_plan = $previous_plan_array[$previous_plan];
										if($product_id=='LFAddOnPack'){
											//for AddOnPackProduct
											$current_plan = $product_id;
										}else{
										$current_plan = $previous_plan_array[$current_user_setting_plan];
										}
										$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
										$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
										$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
										$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
										$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
									}
									
									if($product_id=='LFAddOnPack'){
										//for AddOnPackProduct
										Yii::$app->db->createCommand('UPDATE user SET boosterSubscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
											
									}else if($product_id=='LFUM_v2' || $product_id=='LFUSAR_v2' || $product_id=='LFUA_v2' || $product_id=="LFUM" || $product_id=="LFUQ" || $product_id=="LFUSAR" || $product_id=="LFUA"){
										Yii::$app->db->createCommand('UPDATE user SET subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'", boosterSubscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
									}else{
										//trial_expired_at = "'.$ExpirationDateTimestamp.'",sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0,
										echo '<br/>'.'UPDATE user SET subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')';
										Yii::$app->db->createCommand('UPDATE user SET subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
									}
									//ends
									
									if($upo_ExpirationDate!=$ExpirationDate || 1==1){
										$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$uph_row['email'],'ses_full_name'=>$uph_row['first_name'].' '.$uph_row['last_name'],'responseGetJson'=> $responseGetJson,'SubscriptionReference'=> $SubscriptionReference);
										if($product_id=='LFAddOnPack'){
											//for AddOnPackProduct
											$this->recurringPaymentStoppedAddOnPackProduct($payment_info);
										}else{
										$this->recurringPaymentStopped($payment_info);
										}
										echo '<br/>ends';
									}

									
								}
							}
						}
					
					
				}
				
				
				
			}

		//}
		
		
		//email starts
		//if(isset($_POST['md5_hash'])){
			$html = json_encode($_POST,JSON_PRETTY_PRINT);
		//}else{
			//$html = 'this email called from https://nikit.intricare.net/cloud_theme/basic/web/securepayment/webhook-ins-when-new-order-created';
		//}

			if (YII_ENV_PROD) {
				//production
				$to_email = ['nikit@intricaretech.com'];//'arpan@intricare.net',
				$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - Webhook INS Called When Recurring Stopped";
			}else{
				//staging
				$to_email = 'nikit@intricaretech.com';
				$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - Webhook INS Called When Recurring Stopped";
			}
		
		$mail = Yii::$app->mailer->compose()
				->setTo($to_email)
				//->setBcc('ronit@leadconnect.io')
				//->setFrom([Yii::$app->params['adminEmail'] => Yii::$app->params['emailFromName'].' | You have been Invited'])
				->setFrom(Yii::$app->params['adminEmail'])
				//->setReplyTo()
				->setSubject($email_subject)
				->setHtmlBody($html, 'text/html');
		$mail->send();
		//email ends
		
	}


	 public function recurringPaymentStopped($payment_info){
		$email = $payment_info['ses_email'];//customer email
		
		$html = $this->renderPartial('/../mail/recurringpaymentstopped', ['value' => $payment_info,'fullname'=>$payment_info['ses_full_name'],'responseGetJson'=>$payment_info['responseGetJson']]);

			if (YII_ENV_PROD) {
				//production
				$to_email = ['nikit@intricaretech.com'];
				$email_subject = Yii::$app->params['emailFromName'].' - Recurring Stopped For Subscription Ref # '.$payment_info['SubscriptionReference'].' | Order Ref #'.$payment_info['order_number'];
			}else{
				//staging
				$to_email = 'nikit@intricaretech.com';
				$email_subject = 'STAGING TEST - '.Yii::$app->params['emailFromName'].' - Recurring Stopped For Subscription Ref # '.$payment_info['SubscriptionReference'].' | Order Ref #'.$payment_info['order_number'];
			}

			$mail = Yii::$app->mailer->compose()
			//->setTo($email)
			->setTo($to_email)
			//->setBcc(['binita@intricare.net'])
			//->setFrom(['payments@intricare.net'=>Yii::$app->params['emailFromName'].' Payments'])
			//->setFrom(['arpan@intricare.net'=>Yii::$app->params['emailFromName'].' Payments'])
			->setFrom([Yii::$app->params['adminEmail']=>Yii::$app->params['emailFromName'].' Payments'])
			//->setReplyTo()
			//->setSubject('STAGING TEST - '.Yii::$app->params['emailFromName'].' - Recurring Successed Payment For Order Ref #'.$payment_info['order_number'])
			->setSubject($email_subject)
			->setHtmlBody($html,'text/html');
			$mail->send();
	}
	
	//28-06-2021
	 public function recurringPaymentStoppedAddOnPackProduct($payment_info){
		$email = $payment_info['ses_email'];//customer email
		
		$html = $this->renderPartial('/../mail/recurringpaymentstoppedAddOnPackProduct', ['value' => $payment_info,'fullname'=>$payment_info['ses_full_name'],'responseGetJson'=>$payment_info['responseGetJson']]);

			if (YII_ENV_PROD) {
				//production
				$to_email = ['nikit@intricaretech.com'];
				$email_subject = Yii::$app->params['emailFromName'].' - Recurring Stopped For Subscription Ref # '.$payment_info['SubscriptionReference'].' | Order Ref #'.$payment_info['order_number'];
			}else{
				//staging
				$to_email = 'nikit@intricaretech.com';
				$email_subject = 'STAGING TEST - '.Yii::$app->params['emailFromName'].' - Recurring Stopped For Subscription Ref # '.$payment_info['SubscriptionReference'].' | Order Ref #'.$payment_info['order_number'];
			}

			$mail = Yii::$app->mailer->compose()
			->setTo($to_email)
			->setFrom([Yii::$app->params['adminEmail']=>Yii::$app->params['emailFromName'].' Payments'])
			->setSubject($email_subject)
			->setHtmlBody($html,'text/html');
			$mail->send();
	}	
	
	

	//NR: In use. DO NOT REMOVE;
	public function actionWebhookInsWhenNewOrderCreated(){

		ini_set('display_errors', 1);
		ini_set('display_startup_errors', 1);
		error_reporting(E_ALL);

		$isLfProductInINS = false;
		$isLfBlackFridayProductInINS = false;
		$isLfAddOnPackExclusiveOrder = false;
		if(isset($_POST['md5_hash']) && isset($_POST['item_id_1'])){
			$allLfProductCodesArr = array(
				"LFPM",
				"LFPQ",
				"LFGM",
				"LFGQ",
				"LFUM",
				"LFUQ",
				"LFPSAR",
				"LFPA",
				"LFGSAR",
				"LFGA",
				"LFUSAR",
				"LFUA",

				"LFPSA",
				"LFPABF",
				"LFGSA",
				"LFGABF",
				"LFUSA",
				"LFUABF",
				"LFGM_v2",
				"LFUM_v2",
				"LFGSAR_v2",
				"LFUSAR_v2",
				"LFGA_v2",
				"LFUA_v2",
				"LFAddOnPack"
				);

			$allLfBlackFridayProductCodesArr = array(
				"LFPSA",
				"LFPABF",
				"LFGSA",
				"LFGABF",
				"LFUSA",
				"LFUABF"
				);

			$allLfAddOnPackProductCodesArr = array(
				"LFAddOnPack"
				);				

			if(in_array($_POST['item_id_1'],$allLfProductCodesArr)){
				$isLfProductInINS = true;
			}
			
			if(in_array($_POST['item_id_1'],$allLfBlackFridayProductCodesArr)){
				$isLfBlackFridayProductInINS = true;
			}
			
			if(in_array($_POST['item_id_1'],$allLfAddOnPackProductCodesArr)){
				$isLfAddOnPackExclusiveOrder = true;
			}

		}

		if($isLfProductInINS){
			//isset($_POST['vendor_order_id']) && $_POST['vendor_order_id']!=''
			
			//email starts
				$html = json_encode($_POST,JSON_PRETTY_PRINT);
				$html.= '<br/>Timestamp:'.strtotime('now');

				if (YII_ENV_PROD) {
					//production
					$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - Webhook INS Called When New Order Created";
				}else{
					//staging
					$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - Webhook INS Called When New Order Created";
				}
			
			$mail = Yii::$app->mailer->compose()
					->setTo('nikit@intricaretech.com')
					->setFrom(Yii::$app->params['adminEmail'])
					->setSubject($email_subject)
					->setHtmlBody($html, 'text/html');
			$mail->send();
			//email ends
		}
		
		if($isLfProductInINS){

			if (YII_ENV_PROD) {
				//production
				$merchantCode = "203537015";
				$key = 'd?q4rkG]&KAh#vwnmSJ%';				
			}else{
				//staging
				$merchantCode = "251108887711";
				$key = '!G2S8WRBKJ6#&c~luOz=';				
			}

			$gmdate = gmdate('Y-m-d H:i:s');
			$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
			$hashAlgorithm = 'sha256';
			$hash = hash_hmac($hashAlgorithm , $string, $key);		
			
			$webhook_response = json_encode($_POST);
				
			//$OrderReferenceNumber = '128307398';
			$OrderReferenceNumber = $_POST['order_ref'];
			$vendor_order_id = $_POST['vendor_order_id'];
		
			//04-12-2020 condition removed from below line:$_POST['invoice_status']=='approved' &&
			if(isset($_POST['invoice_status']) && isset($_POST['message_type']) && $_POST['message_type']=='ORDER_CREATED'){
				
				if(isset($_POST['vendor_order_id']) && $_POST['vendor_order_id']!='' && $isLfBlackFridayProductInINS==false && $isLfAddOnPackExclusiveOrder==false){
					
				
					//echo "SELECT t1.* FROM user_payment_history t1 JOIN user_order_products t2 ON t1.id=t2.upgraded_uphid WHERE t1.merchant_id='".$_POST['vendor_order_id']."' AND t2.upgradeStatus=1 AND t2.2coSubscriptionStatus='ACTIVE' ";
					//AND t2.upgradeStatus=1 AND t2.2coSubscriptionStatus='ACTIVE'
					
					//NR: When you upgrade any subscription, 2checkout creates new order with new subscription. To handle that new order this case is used;
					//This case will not exists for blackfriday products;
					$neworder_row = Yii::$app->db->createCommand("SELECT t1.* FROM user_payment_history t1 JOIN user_order_products t2 ON t1.id=t2.upgraded_uphid WHERE t1.merchant_id='".$_POST['vendor_order_id']."'  ")->queryOne();
					if(!empty($neworder_row)){
						
						$newuop_row = Yii::$app->db->createCommand("SELECT * FROM user_order_products WHERE uph_id=".$neworder_row['id']."  ")->queryOne();
						
						$ch = curl_init();
						curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
						curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

						$headers = array();
						$headers[] = 'Accept: application/json';
						$headers[] = 'Content-Type: application/json';
						$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
						curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
						$response_order = $curl_result = curl_exec($ch);
						//echo '<br/>res1:<pre>'; print_r($curl_result);echo '</pre>';
						$curlResult = json_decode($curl_result);
						//echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
						if (curl_errno($ch)) {
							echo 'Error:' . curl_error($ch);
						}
						curl_close($ch);

							//test email starts
									$html = $curl_result;
									$datetimenow = date('Y-m-d H:i:s');
								if (YII_ENV_PROD) {
									$email_subject = "Linkedfusion Production Server - WebhookInsWhenNewOrderCreated Order API Response Called at ".$datetimenow;
								}else{
									$email_subject = "Linkedfusion Staging Server - WebhookInsWhenNewOrderCreated Order API Response Called at ".$datetimenow;
								}
									$mail = Yii::$app->mailer->compose()
											->setTo('nikit@intricaretech.com')
											->setFrom(Yii::$app->params['adminEmail'])
											->setSubject($email_subject)
											->setHtmlBody($html, 'text/html');
								if (YII_ENV_PROD) {
									$mail->send();
								}else{
									
								}
							//test email ends
						
						$SubscriptionReference = $curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionReference;
						$SubscriptionStartDate = $curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
						$ExpirationDate = $curlResult->Items[0]->ProductDetails->Subscriptions[0]->ExpirationDate;
						$ExpirationDateTimestamp = strtotime($curlResult->Items[0]->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;

						//Retrieve a subscription
						$ch = curl_init();
						curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/subscriptions/'.$SubscriptionReference.'/');
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
						curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

						$headers = array();
						$headers[] = 'Accept: application/json';
						$headers[] = 'Content-Type: application/json';
						$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
						curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
						$curl_result = curl_exec($ch);
						
						$curlResult = json_decode($curl_result);
						//echo '<br/>res sub:<pre>'; print_r($curlResult);echo '</pre>';
						if (curl_errno($ch)) {
							echo 'Error:' . curl_error($ch);
						}
						curl_close($ch);	

							//test email starts
									$html = $curl_result;
									//$datetimenow = date('Y-m-d H:i:s');
								if (YII_ENV_PROD) {
									$email_subject = "Linkedfusion Production Server - WebhookInsWhenNewOrderCreated Subscription API Response Called at ".$datetimenow;
								}else{
									$email_subject = "Linkedfusion Staging Server - WebhookInsWhenNewOrderCreated Subscription API Response Called at ".$datetimenow;
								}
									$mail = Yii::$app->mailer->compose()
											->setTo('nikit@intricaretech.com')
											->setFrom(Yii::$app->params['adminEmail'])
											->setSubject($email_subject)
											->setHtmlBody($html, 'text/html');
								if (YII_ENV_PROD) {
									$mail->send();
								}else{
									
								}
							//test email ends
						
						$CustomerReference = $curlResult->CustomerReference;
						$TwoCoSubscriptionStatus = $curlResult->Status;//eg: ACTIVE


						Yii::$app->db->createCommand("UPDATE user_payment_history SET order_number='".$OrderReferenceNumber."',status='Success', 2coCustomerReference ='".$CustomerReference."', response_get='".$webhook_response."', response_order='".$response_order."' where id=".$neworder_row['id'])->execute();
										
						Yii::$app->db->createCommand("UPDATE user_order_products SET SubscriptionStartDate='".$SubscriptionStartDate."', ExpirationDate='".$ExpirationDate."', 2coSubscriptionStatus='".$TwoCoSubscriptionStatus."', SubscriptionReference='".$SubscriptionReference."'  where uph_id=".$neworder_row['id'])->execute();
										
						//updating old order
						Yii::$app->db->createCommand("UPDATE user_order_products SET 2coSubscriptionStatus='DISABLED', upgradeStatus=2  where upgraded_uphid=".$neworder_row['id'])->execute();
						
						//25-06-2021 starts
						$olduop_row = Yii::$app->db->createCommand("SELECT product_id, user_ids FROM user_order_products WHERE upgraded_uphid=".$neworder_row['id']."  ")->queryOne();
						if($olduop_row['product_id']=='LFUM_v2' || $olduop_row['product_id']=='LFUSAR_v2' || $olduop_row['product_id']=='LFUA_v2' || $olduop_row['product_id']=="LFUM" || $olduop_row['product_id']=="LFUQ" || $olduop_row['product_id']=="LFUSAR" || $olduop_row['product_id']=="LFUA"){
							//for above plans, booster pack is free so now downgrading booster pack.
							//NR 25-06-2021: when upgrading subscription, 2checkout first cancel old subscription and then this method is called. so, undo changes in below query.
							Yii::$app->db->createCommand('UPDATE user SET cancelSub=0, trial=0, cancelBoosterSub=0, isBoosterOnTrial=0, is_booster="0" WHERE id IN ('.$olduop_row['user_ids'].')')->execute();
						}
						//25-06-2021 ends
						

						$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$OrderReferenceNumber."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
						if(empty($uos_row)){
							Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$OrderReferenceNumber.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
						}
						

						$product_code = $newuop_row['product_id'];
						$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7',
						'LFPSAR'=>'8',
						'LFPA'=>'9',
						'LFGSAR'=>'10',
						'LFGA'=>'11',
						'LFUSAR'=>'12',
						'LFUA'=>'13',
						'LFGM_v2'=>'18',
						'LFUM_v2'=>'19',
						'LFGSAR_v2'=>'20',
						'LFUSAR_v2'=>'21',
						'LFGA_v2'=>'22',
						'LFUA_v2'=>'23'
						);
						$current_user_setting_plan = $current_user_setting_plan_array[$product_code];
						$user_ids = $newuop_row['user_ids'];

						//new email working starts
						$selPlanUsrArr=array();
						$lfaf_seat_purchased_userids=array();
						$product_id = $product_code;//eg:LFPM
						$expuidArr = explode(',',$newuop_row['user_ids']);
						
						$lfaf_seat_purchased_userids[$product_id] = $expuidArr;
						
						//$lfaf_seat_purchased_userids = '{"LFPM":["14935","14988"],"LFUM":["14987"]}';
						$lfaf_seat_purchased_userids = json_encode($lfaf_seat_purchased_userids);
						$lfaf_seat_purchased_useridsArr = json_decode($lfaf_seat_purchased_userids,true);
						$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
						$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus',
						'8'=>'Professional Semi-Annually',
						'9'=>'Professional Annually',
						'10'=>'Grow Semi-Annually',
						'11'=>'Grow Annually',
						'12'=>'Ultimate Semi-Annually',
						'13'=>'Ultimate Annually',
						'14'=>'New Grow Monthly',
						'15'=>'New Grow Annual',
						'16'=>'New Ultimate Monthly',
						'17'=>'New Ultimate Annual',
						'18'=>'Grow Monthly',
						'19'=>'Ultimate Monthly',
						'20'=>'Grow Semi-Annually',
						'21'=>'Ultimate Semi-Annually',
						'22'=>'Grow Annually',
						'23'=>'Ultimate Annually'
						);
						$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];

						foreach($userIdArr as $uid){
							$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
							$previous_plan = $usrcommand['sublevel'];
							$isTrial = $usrcommand['trial'];
							
							$previous_plan = $previous_plan_array[$previous_plan];
							$current_plan = $previous_plan_array[$current_user_setting_plan];
							
							$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
							$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
							$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
							$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
							$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
						}
						
						
						$usrcommand = Yii::$app->db->createCommand("SELECT email,first_name FROM user WHERE  id =".$neworder_row['userid'])->queryOne();

						$payment_info=array('order_number'=>$OrderReferenceNumber,'merchant_order_id'=>$_POST['vendor_order_id'],'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$usrcommand['email'],'ses_full_name'=>$usrcommand['first_name']);
						$this->successedPayment($payment_info);
						//new email working ends

						
						if($product_id=='LFUM_v2' || $product_id=='LFUSAR_v2' || $product_id=='LFUA_v2' || $product_id=="LFUM" || $product_id=="LFUQ" || $product_id=="LFUSAR" || $product_id=="LFUA"){
							//for above plans, booster pack is free.
							
							Yii::$app->db->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'", is_booster="1", isBoosterOnTrial = 0, cancelBoosterSub = 0, boosterSubscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$user_ids.')')->execute();
						}else{
							//trial_expired_at = "'.$ExpirationDateTimestamp.'"
							Yii::$app->db->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$user_ids.')')->execute();
						}
						
						
					}
				
				}
			
			}

			if(isset($_POST['vendor_order_id']) && $_POST['vendor_order_id']==''){
				//when customer has upgraded his subscription from his 2checkout panel, as we do not have "vendor_order_id" number for that new upgraded order, below code just send an alert email to interal team;

				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

				$headers = array();
				$headers[] = 'Accept: application/json';
				$headers[] = 'Content-Type: application/json';
				$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				$curl_result = $responseOrderJson = curl_exec($ch);
				
				$curlResult = json_decode($curl_result);
		//echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
				if (curl_errno($ch)) {
					//echo 'Error:' . curl_error($ch);
				}
				curl_close($ch);
				

					//email starts
					if($isLfBlackFridayProductInINS==false){
						$html = "Hello Admin,<br/><br/>This order #".$_POST['order_ref']." may be created using manual link or created from customer's 2checkout panel as it does not contain value for vendor_order_id. Hense, This order is not inserted in our database.<br/><br/>";
						$html.= "If this order is created using buy link, then you need to make entry into our buy link form.<br/><br/>";
					}else{
						//for blackfriday products
						$html = "Hello Admin,<br/><br/>This blackfriday order #".$_POST['order_ref']." is created using manual link. As it does not contain value for vendor_order_id, this order is not inserted in our database.<br/><br/>";
						$html.= "So, You need to make entry into our buy link form.<br/><br/>";
					}
					/*
					$html.= "You need to manually handle this order by following steps:(To get better understand, check these methods in securepayment controller file: upgradeplan, WebhookInsWhenNewOrderCreated)<br/><br/>";
					$html.= "1) Identify its customer & go to customer detail page in vendor's 2checkout panel.<br/>";
					$html.= "2) To findout on which subscription this order is upgraded, Identify recent disabled subscription.<br/>";
					$html.= "3) On Subscription detail page, check \"Subscription history\". If you find there this newly order #".$_POST['order_ref']." it means that this newly order was upgraded on this subscription on which your current page is opened.<br/>";
					$html.= "4) On the same Subscription detail page, under \"Subscription history\" details, find the previous Order Ref Number- from that previous Order Ref Number you will able to find user_ids,etc details. The previous order detail will be used in next step. <br/>";
					$html.= "5) After verifying & confirming, need to manually insert entry in user_payment_history, user_order_products and user_order_subscriptions tables.<br/>";
					$html.= "6) Update some details for Previous Order Ref Record in user_payment_history and user_order_products.<br/>";
					$html.= "7) Note: Number of Qty denotes number of users. If Qty is different between new and previous subscriptions, need to ask customer for which users this newly subscription is bought.<br/>";
					*/
					$html.= "<br/><br/>The below is the webhook response:<br/><br/>";
					
					$html.= json_encode($_POST,JSON_PRETTY_PRINT);
					$html.= "<br/><br/>The below is the order response:<br/><br/>";
					$html.= $responseOrderJson;
					
					if (YII_ENV_PROD) {
						//production
						$to_email = ['arpan@intricare.net','nikit@intricaretech.com'];
						//$bcc_email = ['binita@intricare.net','bhavin@intricare.net'];
						//$email_subject = Yii::$app->params['emailFromName']." - New Order Created From Customer 2Co Alert | Order #".$_POST['order_ref'];
						$email_subject = Yii::$app->params['emailFromName']." - New Order Created Alert | Order #".$_POST['order_ref'];
					}else{
						//staging
						$to_email = 'nikit@intricaretech.com';
						//$bcc_email = 'nikit@intricaretech.com';
						//$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - New Order Created From Customer 2Co Alert | Order #".$_POST['order_ref'];
						$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - New Order Created Alert | Order #".$_POST['order_ref'];
					}
					
					$mail = Yii::$app->mailer->compose()
							->setTo($to_email)
							//->setBcc($bcc_email)
							//->setFrom([Yii::$app->params['adminEmail'] => Yii::$app->params['emailFromName'].' | You have been Invited'])
							->setFrom(Yii::$app->params['adminEmail'])
							//->setReplyTo()
							->setSubject($email_subject)
							->setHtmlBody($html, 'text/html');
					$mail->send();
					//email ends

					
				
				
			}
	
		}
	}
	


	//NR: In Use; This webhook method is called by 2checkout frequently;
	public function actionWebhookLcn(){
		/*
		if (YII_ENV_PROD) {
			//production
			//$twocheckout_product_id = array('LFPM'=>'31350945','LFPQ'=>'31351063','LFGM'=>'31350988','LFGQ'=>'31351042','LFUM'=>'31350996','LFUQ'=>'31351018');//ids in 2checkout panel
			$twocheckout_product_idArr = array(31350945,31351063,31350988,31351042,31350996,31351018);//product ids in 2checkout panel
		}else{
			//staging
			//$twocheckout_product_id = array('LFPM'=>'36147949','LFPQ'=>'36147960','LFGM'=>'36149087','LFGQ'=>'36149119','LFUM'=>'36147991','LFUQ'=>'36148018');//ids in 2checkout panel
			$twocheckout_product_idArr = array(36147949,36147960,36149087,36149119,36147991,36148018);
		}*/		


		$isLfProductInLCN = false;
		$isLfBlackFridayProductInLCN = false;
		if(isset($_POST['LICENSE_PRODUCT_CODE'])){
			$allLfProductCodesArr = array(
				"LFPM",
				"LFPQ",
				"LFGM",
				"LFGQ",
				"LFUM",
				"LFUQ",
				"LFPSAR",
				"LFPA",
				"LFGSAR",
				"LFGA",
				"LFUSAR",
				"LFUA",
				
				"LFPSA",
				"LFPABF",
				"LFGSA",
				"LFGABF",
				"LFUSA",
				"LFUABF",
				"LFGM_v2",
				"LFUM_v2",
				"LFGSAR_v2",
				"LFUSAR_v2",
				"LFGA_v2",
				"LFUA_v2",
				"LFAddOnPack",
				);

			$allLfBlackFridayProductCodesArr = array(
				"LFPSA",
				"LFPABF",
				"LFGSA",
				"LFGABF",
				"LFUSA",
				"LFUABF"
				);
				
			if(in_array($_POST['LICENSE_PRODUCT_CODE'],$allLfProductCodesArr)){
				$isLfProductInLCN = true;
			}
			
			if(in_array($_POST['LICENSE_PRODUCT_CODE'],$allLfBlackFridayProductCodesArr)){
				$isLfBlackFridayProductInLCN = true;
			}

		}else{
			//let it process.
			$isLfProductInLCN = true;
		}
		
		if($isLfProductInLCN){
			

			//email starts
				$html = json_encode($_POST,JSON_PRETTY_PRINT);

				if (YII_ENV_PROD) {
					//production
					$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - Webhook Lcn";
				}else{
					//staging
					$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - Webhook Lcn";
				}
			
			$mail = Yii::$app->mailer->compose()
					->setTo('nikit@intricaretech.com')
					->setFrom(Yii::$app->params['adminEmail'])
					->setSubject($email_subject)
					->setHtmlBody($html, 'text/html');
			if (YII_ENV_PROD) {
			$mail->send();
			}else{
			$mail->send();
			}
			//email ends


		
			//&& in_array($_POST['LICENSE_PRODUCT'],$twocheckout_product_idArr)
			if(isset($_POST['STATUS']) && $_POST['STATUS']=='CANCELED' && isset($_POST['LICENSE_PRODUCT'])){
				$ORDER_REFERENCE = $_POST['LAST_ORDER_REFERENCE'];
				$LICENSE_CODE = $_POST['LICENSE_CODE'];//ie.Subscription Reference Number;
				if($isLfBlackFridayProductInLCN==false){
				$EXPIRATION_DATE_TIME = $_POST['EXPIRATION_DATE_TIME'];
				$ExpirationDateTimestamp = strtotime($EXPIRATION_DATE_TIME) * 1000;
				}else{
					//for blackfriday products no need to change EXPIRATION_DATE_TIME; as the post value is not valid (eg:10000-01-01 03:29:59).
					//also, when blackfriday order is successfully inserted system correctly inserted its expiration date. so, its not required to update the same value again.
				}
				
				//t1.order_number='".$ORDER_REFERENCE."' AND : removed this from below qry on 11-08-2020;
				$uph_row = Yii::$app->db->createCommand("SELECT t1.userid, t2.id as uop_pkid, t2.user_ids, t2.product_id, t2.ExpirationDate FROM user_payment_history t1 JOIN user_order_products t2 ON t1.id=t2.uph_id WHERE  t2.SubscriptionReference='".$LICENSE_CODE."' AND t2.2coSubscriptionStatus='ACTIVE'")->queryOne();
				if(!empty($uph_row)){
					
					//NR:From 2checkout panel, when subscription is cancelled this code block is used to process further;
					if($isLfBlackFridayProductInLCN==false){
						Yii::$app->db->createCommand('UPDATE user_order_products SET 2coSubscriptionStatus="CANCELED", ExpirationDate="'.$EXPIRATION_DATE_TIME.'"  WHERE id='.$uph_row['uop_pkid'])->execute();
						if($uph_row['product_id']=='LFAddOnPack'){
							//for AddOnPackProduct
							Yii::$app->db->createCommand('UPDATE user SET cancelBoosterSub=1, boosterSubscriptionExpiredAt="'.$ExpirationDateTimestamp.'", isBoosterOnTrial=1, booster_expired_at="'.$ExpirationDateTimestamp.'" WHERE id IN ('.$uph_row['user_ids'].')')->execute();
						}else if($uph_row['product_id']=='LFUM_v2' || $uph_row['product_id']=='LFUSAR_v2' || $uph_row['product_id']=='LFUA_v2' || $product_id=="LFUM" || $product_id=="LFUQ" || $product_id=="LFUSAR" || $product_id=="LFUA"){
				
							Yii::$app->db->createCommand('UPDATE user SET cancelSub=1, subscriptionExpiredAt="'.$ExpirationDateTimestamp.'", trial=1, trial_expired_at="'.$ExpirationDateTimestamp.'", cancelBoosterSub=1, boosterSubscriptionExpiredAt="'.$ExpirationDateTimestamp.'", isBoosterOnTrial=1, booster_expired_at="'.$ExpirationDateTimestamp.'" WHERE id IN ('.$uph_row['user_ids'].')')->execute();
						}else{
							Yii::$app->db->createCommand('UPDATE user SET cancelSub=1, subscriptionExpiredAt="'.$ExpirationDateTimestamp.'", trial=1, trial_expired_at="'.$ExpirationDateTimestamp.'" WHERE id IN ('.$uph_row['user_ids'].')')->execute();
						}
						
					}else{
						//for blackfriday product
						//24-06-2021 starts
						$EXPIRATION_DATE_TIME = $uph_row['ExpirationDate'];
						$ExpirationDateTimestamp = strtotime($EXPIRATION_DATE_TIME) * 1000;
						//24-06-2021 ends
						
						//for blackfriday products
						Yii::$app->db->createCommand('UPDATE user_order_products SET 2coSubscriptionStatus="CANCELED" WHERE id='.$uph_row['uop_pkid'])->execute();
						if($uph_row['product_id']=='LFUSA' || $uph_row['product_id']=='LFUABF'){
							Yii::$app->db->createCommand('UPDATE user SET cancelSub=1, trial=1, cancelBoosterSub=1, isBoosterOnTrial=1, booster_expired_at="'.$ExpirationDateTimestamp.'" WHERE id IN ('.$uph_row['user_ids'].')')->execute();
						}else{
							Yii::$app->db->createCommand('UPDATE user SET cancelSub=1, trial=1 WHERE id IN ('.$uph_row['user_ids'].')')->execute();
						}
					}
					
					

					if(isset($_POST['CHANGED_BY']) && $_POST['CHANGED_BY']!=''){
						$CHANGED_BY = $_POST['CHANGED_BY'];//eg: CUSTOMER or VENDOR
					}else{
						$CHANGED_BY = 'System';
					}
					
					if(isset($_POST['DATE_UPDATED']) && $_POST['DATE_UPDATED']!=''){
						$DATE_UPDATED = $_POST['DATE_UPDATED'];//eg: 2020-09-24 20:03:07
					}else{
						$DATE_UPDATED = date('Y-m-d H:i:s');
					}
					
					$notetxt = "SubscriptionReference #".$LICENSE_CODE." is CANCELED by ".$CHANGED_BY." on ".$DATE_UPDATED;
					$created_on = date('d M Y h:i:s A');
					Yii::$app->db->createCommand("INSERT INTO user_notes SET user_id=".$uph_row['userid'].", note='".$notetxt."', last_updated_by='".$uph_row['userid']."', updated_at='".$created_on."' ")->execute();
					$lastunpkid = Yii::$app->db->getLastInsertID();

					//email starts
					//if(isset($_POST['md5_hash'])){
						$html = 'LCN Subscription Canceled is called.<br/>Order #'.$ORDER_REFERENCE.'<br/>LICENSE CODE:'.$LICENSE_CODE.'<br/><br/>';
						if($isLfBlackFridayProductInLCN==false){
							$html.= 'UPDATE user_order_products SET 2coSubscriptionStatus="CANCELED", ExpirationDate="'.$EXPIRATION_DATE_TIME.'"  WHERE id='.$uph_row['uop_pkid'].'<br/><br/>';
							if($uph_row['product_id']=='LFAddOnPack'){
								//for AddOnPackProduct
								$html.= 'UPDATE user SET cancelBoosterSub=1, boosterSubscriptionExpiredAt="'.$ExpirationDateTimestamp.'", isBoosterOnTrial=1, booster_expired_at="'.$ExpirationDateTimestamp.'" WHERE id IN ('.$uph_row['user_ids'].')<br/><br/>';
							}else if($uph_row['product_id']=='LFUM_v2' || $uph_row['product_id']=='LFUSAR_v2' || $uph_row['product_id']=='LFUA_v2' || $product_id=="LFUM" || $product_id=="LFUQ" || $product_id=="LFUSAR" || $product_id=="LFUA"){
					
								$html.= 'UPDATE user SET cancelSub=1, subscriptionExpiredAt="'.$ExpirationDateTimestamp.'", trial=1, trial_expired_at="'.$ExpirationDateTimestamp.'", cancelBoosterSub=1, boosterSubscriptionExpiredAt="'.$ExpirationDateTimestamp.'", isBoosterOnTrial=1, booster_expired_at="'.$ExpirationDateTimestamp.'" WHERE id IN ('.$uph_row['user_ids'].')<br/><br/>';
							}else{
								$html.= 'UPDATE user SET cancelSub=1, subscriptionExpiredAt="'.$ExpirationDateTimestamp.'", trial=1, trial_expired_at="'.$ExpirationDateTimestamp.'" WHERE id IN ('.$uph_row['user_ids'].')<br/><br/>';	
							}
						}else{
							//for blackfriday products
							$html.= 'UPDATE user_order_products SET 2coSubscriptionStatus="CANCELED" WHERE id='.$uph_row['uop_pkid'].'<br/><br/>';

							if($uph_row['product_id']=='LFUSA' || $uph_row['product_id']=='LFUABF'){
								$html.= 'UPDATE user SET cancelSub=1, trial=1, cancelBoosterSub=1, isBoosterOnTrial=1, booster_expired_at="'.$ExpirationDateTimestamp.'" WHERE id IN ('.$uph_row['user_ids'].')<br/><br/>';
							}else{
								$html.= 'UPDATE user SET cancelSub=1, trial=1 WHERE id IN ('.$uph_row['user_ids'].')<br/><br/>';
							}
							
						}
						
						$html.= 'user_notes added. id:'.$lastunpkid.'<br/><br/>';
						$html.= json_encode($_POST,JSON_PRETTY_PRINT);
					//}else{
						//$html = 'lcn testing email';
					//}
					

					if (YII_ENV_PROD) {
						//production
						$to_email = ['nikit@intricaretech.com'];
						//$bcc_email = ['binita@intricare.net'];
						$email_subject = Yii::$app->params['emailFromName']." - LCN Subscription Canceled For Order #".$ORDER_REFERENCE." | LICENSE:".$LICENSE_CODE;
					}else{
						//staging
						$to_email = 'nikit@intricaretech.com';
						//$bcc_email = 'nikit@intricaretech.com';
						$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - LCN Subscription Canceled For Order #".$ORDER_REFERENCE." | LICENSE:".$LICENSE_CODE;
					}
					$mail = Yii::$app->mailer->compose()
							->setTo($to_email)
							//->setBcc($bcc_email)
							->setFrom(Yii::$app->params['adminEmail'])
							->setSubject($email_subject)
							->setHtmlBody($html, 'text/html');
					$mail->send();
					//email ends	
				}
			}
			
			if(isset($_POST['LICENSE_CODE']) && $_POST['LICENSE_CODE']!='' && isset($_POST['EXPIRATION_DATE']) && $_POST['EXPIRATION_DATE']!=''  && isset($_POST['HASH']) && $_POST['HASH']!='' && $isLfBlackFridayProductInLCN==false){
				//Usage: when customer has disabled the auto renewal and if he failes to do payment upto that expiration date, 2checkout will do such Subscription status to "EXPIRED". Now, to change the new status to "EXPIRED" in our database and downgrade its user this code block is used;
				//Note: this case will not exists for blackfriday products due to blackfriday products are not recurring products ie.Only 1 time payment.
				
				$LICENSE_CODE = $_POST['LICENSE_CODE'];//ie.Subscription Reference Number;

				if (YII_ENV_PROD) {
					//production
					$merchantCode = "203537015";
					$key = 'd?q4rkG]&KAh#vwnmSJ%';				
				}else{
					//staging
					$merchantCode = "251108887711";
					$key = '!G2S8WRBKJ6#&c~luOz=';				
				}

					$gmdate = gmdate('Y-m-d H:i:s');
					$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
					$hashAlgorithm = 'sha256';
					$hash = hash_hmac($hashAlgorithm , $string, $key);
				
				//Retrieve a subscription
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/subscriptions/'.$LICENSE_CODE.'/');
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

				$headers = array();
				$headers[] = 'Accept: application/json';
				$headers[] = 'Content-Type: application/json';
				$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				$curl_result = curl_exec($ch);
				
				$curlResult = json_decode($curl_result);
				//echo '<br/>subscription res:<pre>'; print_r($curlResult);echo '</pre>';
				if (curl_errno($ch)) {
					echo 'Error:' . curl_error($ch);
				}
				curl_close($ch);
				
				if($curlResult->Status=='EXPIRED'){
					
					$uph_row = Yii::$app->db->createCommand("SELECT t2.id as uop_pkid, t2.user_ids, t2.product_id FROM user_payment_history t1 JOIN user_order_products t2 ON t1.id=t2.uph_id WHERE  t2.SubscriptionReference='".$LICENSE_CODE."' AND t2.2coSubscriptionStatus='ACTIVE'")->queryOne();
					
					if(!empty($uph_row)){
						$upo_user_ids = $uph_row['user_ids'];
						//17-08-2020 starts 
						Yii::$app->db->createCommand('UPDATE user_order_products SET 2coSubscriptionStatus="EXPIRED"  WHERE id='.$uph_row['uop_pkid'])->execute();
						if($uph_row['product_id']=='LFAddOnPack'){
							//for AddOnPackProduct
							Yii::$app->db->createCommand('UPDATE user SET is_booster="0" WHERE id IN ('.$uph_row['user_ids'].')')->execute();
						}else if($uph_row['product_id']=='LFUM_v2' || $uph_row['product_id']=='LFUSAR_v2' || $uph_row['product_id']=='LFUA_v2' || $product_id=="LFUM" || $product_id=="LFUQ" || $product_id=="LFUSAR" || $product_id=="LFUA"){
							Yii::$app->db->createCommand('UPDATE user SET sublevel="0", is_booster="0" WHERE id IN ('.$uph_row['user_ids'].')')->execute();
						}else{
							Yii::$app->db->createCommand('UPDATE user SET sublevel="0" WHERE id IN ('.$uph_row['user_ids'].')')->execute();
						}

						//email starts
						//if(isset($_POST['md5_hash'])){
							$html = 'LCN Subscription Expired is called.<br/>LICENSE CODE:'.$LICENSE_CODE.'<br/><br/>';
							$html.= 'UPDATE user_order_products SET 2coSubscriptionStatus="EXPIRED"  WHERE id='.$uph_row['uop_pkid'].'<br/><br/>';
							if($uph_row['product_id']=='LFAddOnPack'){
								//for AddOnPackProduct
								$html.= 'UPDATE user SET is_booster="0" WHERE id IN ('.$uph_row['user_ids'].')'.'<br/><br/>';
							}else if($uph_row['product_id']=='LFUM_v2' || $uph_row['product_id']=='LFUSAR_v2' || $uph_row['product_id']=='LFUA_v2' || $product_id=="LFUM" || $product_id=="LFUQ" || $product_id=="LFUSAR" || $product_id=="LFUA"){
								$html.= 'UPDATE user SET sublevel="0", is_booster="0" WHERE id IN ('.$uph_row['user_ids'].')'.'<br/><br/>';
							}else{
								$html.= 'UPDATE user SET sublevel="0" WHERE id IN ('.$uph_row['user_ids'].')'.'<br/><br/>';
							}
							$html.= json_encode($_POST,JSON_PRETTY_PRINT);
						//}else{
							//$html = 'lcn testing email';
						//}
						

						if (YII_ENV_PROD) {
							//production
							$to_email = ['nikit@intricaretech.com'];
							$email_subject = Yii::$app->params['emailFromName']." - LCN Subscription Expired For LICENSE:".$LICENSE_CODE;
						}else{
							//staging
							$to_email = 'nikit@intricaretech.com';
							$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - LCN Subscription Expired For LICENSE:".$LICENSE_CODE;
						}
						
						$mail = Yii::$app->mailer->compose()
								->setTo($to_email)
								//->setBcc(['binita@intricare.net'])
								->setFrom(Yii::$app->params['adminEmail'])
								->setSubject($email_subject)
								->setHtmlBody($html, 'text/html');
						$mail->send();
						//email ends
						//17-08-2020 ends 
						
									//05-May-2021 starts
										//Sir:When payment fails and we downgrade account. Need to send email to users also
										
										$getOneSubscribedUserPortal_row = Yii::$app->db->createCommand("select t1.email, t1.portal_id, t2.emailFromName, t2.adminEmail as siteAdminEmail from user t1 JOIN portals t2 ON t1.portal_id = t2.id where t1.id IN (".$upo_user_ids.") ORDER BY t1.id DESC")->queryOne();
										
										$getSubscribedUsers_result = Yii::$app->db->createCommand("select id,email from user where id IN (".$upo_user_ids.") ORDER BY id DESC")->queryAll();
										if(!empty($getSubscribedUsers_result)){
											$subscribeUserEmailArr = array();
											
											foreach($getSubscribedUsers_result as $res){
												$subscribeUserEmailArr[] = $res['email'];
											}

											//email starts
											if($uph_row['product_id']=='LFAddOnPack'){
												//for AddOnPackProduct
												$html = 'Hello,<br/><br/>We are writing this email to let you know that your recent booster pack did not go through. And hence booster pack has been downgraded.<br/><br/>To continue using our booster pack services please purchase new booster pack subscription.<br/><br/>Thanks,<br/>Team '.$getOneSubscribedUserPortal_row['emailFromName'];
											}else{
												$html = 'Hello,<br/><br/>We are writing this email to let you know that your recent renewal did not go through. And hence your account has been downgraded.<br/><br/>To continue using our services please purchase new subscription.<br/><br/>Thanks,<br/>Team '.$getOneSubscribedUserPortal_row['emailFromName'];
											}
												if($uph_row['product_id']=='LFAddOnPack'){
													//for AddOnPackProduct
													$emailSubjectTxt = 'booster pack';
												}else{
													$emailSubjectTxt = 'account';
												}											
											if (YII_ENV_PROD) {
												$email_subject = 'Important <> '.$getOneSubscribedUserPortal_row['emailFromName'].' '.$emailSubjectTxt.' downgraded due to failed payment attempt';
												$to_email = $subscribeUserEmailArr;
												$bcc_email = ['arpan@intricare.net','binita@intricare.net','nikit@intricaretech.com'];
											}else{
												$email_subject = 'STAGING TEST - '.$getOneSubscribedUserPortal_row['emailFromName'].' '.$emailSubjectTxt.' downgraded due to failed payment attempt';
												$to_email = 'nikit@intricaretech.com';
												$bcc_email = 'nikit@intricaretech.com';
											}

											if($getOneSubscribedUserPortal_row['portal_id']==2){
												$siteAdminEmail = 'Accounts@linkedfusion.io';
											}else{
												$siteAdminEmail = $getOneSubscribedUserPortal_row['siteAdminEmail'];
											}											
											
											$mail = Yii::$app->mailer->compose()
													->setTo($to_email)
													->setBcc($bcc_email)
													->setFrom([$siteAdminEmail=>$getOneSubscribedUserPortal_row['emailFromName'].' Accounts'])
													->setSubject($email_subject)
													->setHtmlBody($html, 'text/html');
											if (YII_ENV_PROD) {
												$mail->send();
											}else{
												$mail->send();
											}
											
											//email ends
											
										}
										
										
									
									//05-May-2021 ends	

						
					}
					
					
				}
				

			}
		}
		
		//LCN sending response code starts
		if (YII_ENV_PROD) {
			$pass = 'd?q4rkG]&KAh#vwnmSJ%';//your secret key to compute HASH
		}else{
			$pass = '!G2S8WRBKJ6#&c~luOz=';				
		}

		// do something only if it's POSTed with the right fields
		if(
			isset($_POST)
			&& is_array($_POST)
			&& isset($_POST["HASH"]) && is_string($_POST["HASH"]) && strlen($_POST["HASH"]) > 0
			&& isset($_POST["LICENSE_CODE"]) && is_string($_POST["LICENSE_CODE"]) && strlen($_POST["LICENSE_CODE"]) > 0
			&& isset($_POST["EXPIRATION_DATE"]) && is_string($_POST["EXPIRATION_DATE"]) && strlen($_POST["EXPIRATION_DATE"]) > 0
			&& $_POST["HASH"] == $this->hmacLcn($pass, $this->SerializeArrayLcn($_POST))
		) {
			$returnedDate = date("YmdGis");
			$returnedHash = $this->hmacLcn($pass, $this->SerializeArrayLcn(array(
				$pass,
				$_POST["LICENSE_CODE"],
				$_POST["EXPIRATION_DATE"],
				$returnedDate
			)));

			/* must echo this to give feedback to us */
			echo "<EPAYMENT>".$returnedDate."|".$returnedHash."</EPAYMENT>";

			/* put your custom "SUCCESS" code below */
			//email starts
				if (YII_ENV_PROD) {
					$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - WebhookLcn demo success email Verified LCN Signature";
				}else{
					$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - WebhookLcn demo success email Verified LCN Signature";
				}
			$html = $returnedDate."|".$returnedHash;
			$mail = Yii::$app->mailer->compose()
					->setTo('nikit@intricaretech.com')
					->setFrom(Yii::$app->params['adminEmail'])
					->setSubject($email_subject)
					->setHtmlBody($html, 'text/html');
			//$mail->send();
			//email ends
			
		} else {
			/* put your custom "ERROR" code below, for example: */
			//mail("your_address@example.com", "BAD LCN", print_r($_POST, TRUE),"");
			if(isset($_POST)){
				//email starts
					if (YII_ENV_PROD) {
						$email_subject = "Production Server ".Yii::$app->params['emailFromName']." - WebhookLcn demo warning email BAD LCN Signature";
					}else{
						$email_subject = "Staging Server ".Yii::$app->params['emailFromName']." - WebhookLcn demo warning email BAD LCN Signature";
					}
				$html = print_r($_POST, TRUE);
				$mail = Yii::$app->mailer->compose()
						->setTo('nikit@intricaretech.com')
						->setFrom(Yii::$app->params['adminEmail'])
						->setSubject($email_subject)
						->setHtmlBody($html, 'text/html');
				$mail->send();
				//email ends
			}
		}
		//LCN sending response code ends
	}

    //20-03-2024 [DONE. Working perfect with my test 2checkout account]
    public function actionWebhookLcn_nrtest_hash(){

        /* License Change Notification */

        /*
        * possible values: sha256, sha3-256
        * sha3-256 only for php version > 7.1
        */
        $usedHashAlgorithm = 'sha256';

        /* pass to compute HASH. Retrieve your secret key by accessing https://secure.2checkout.com/cpanel/webhooks_api.php */
        $secretKey = "=H1CO#Ge^V&[(+DAM*aw";


        $signature_sha2   = isset($_POST["SIGNATURE_SHA2_256"]) ? $_POST["SIGNATURE_SHA2_256"] : '';    /* sha256 HASH received */
        $signature_sha3   = isset($_POST["SIGNATURE_SHA3_256"]) ? $_POST["SIGNATURE_SHA3_256"] : '';    /* sha3-256 HASH received */
        
        $stringForHash = $this->serializeArray($_POST);
        $computedHash = hash_hmac($usedHashAlgorithm, $stringForHash, $secretKey);
        
        $validHash = false;
        switch ($usedHashAlgorithm) {
            case "sha256":
                if ($computedHash == $signature_sha2) {
                    $validHash = true;
                }
                break;
            case "sha3-256":
                if ($computedHash == $signature_sha3) {
                    $validHash = true;
                }
                break;
        }
        
        if ($validHash === false) {
            /* hash verification failed */
            http_response_code(400);
            // mail("your_address@example.com", "BAD LCN Signature", print_r($_POST, TRUE),"");

            //test email starts
            $message = "this is test email. BAD LCN Signature. computedHash:".$computedHash.'::::signature_sha2:'.$signature_sha2.'::::SERVER REQUEST_METHOD:'.$_SERVER['REQUEST_METHOD'];
                        
            $html = $message;
            $datetimenow = date('Y-m-d H:i:s');
            // if (YII_ENV_PROD) {
            // 	$email_subject = "Leadconnect Production Server - Webhook IPN Order Ref #".$OrderReferenceNumber." Response";//at $datetimenow
            // }else{
                // $email_subject = "Leadconnect Staging Server - Webhook IPN TESTING NEW HASH Signature Final at ".date('Y-m-d H:i:s');
                $email_subject = "test LinkedFusion email : web/securepayment/webhook-lcn_nrtest_hash BAD LCN Signature";
            // }
            $mail = Yii::$app->mailer->compose()
                    ->setTo('nikit@intricaretech.com')
					->setFrom(Yii::$app->params['adminEmail'])
                    ->setSubject($email_subject)
                    ->setHtmlBody($html, 'text/html');
            $mail->send();
            //test email ends

            return;
        }
        
        
        // hash is valid. We proceed with success response
        $responseDate = date("YmdGis");
        $arrayForResponseHash = [
            $_POST["LICENSE_CODE"],
            $_POST["EXPIRATION_DATE"],
            $responseDate
        ];
        $stringForResponseHash = $this->serializeArray($arrayForResponseHash);
        
        $responseString = '';
        switch ($usedHashAlgorithm) {
            case "sha256":
                $responseHash = hash_hmac('sha256', $stringForResponseHash, $secretKey);
                $responseString = '<sig algo="sha256" date="' . $responseDate . '">' . $responseHash . '</sig>';
                break;
            case "sha3-256":
                $responseHash = hash_hmac('sha3-256', $stringForResponseHash, $secretKey);
                $responseString = '<sig algo="sha3-256" date="' . $responseDate . '">' . $responseHash . '</sig>';
                break;
        }
        
        //test email starts
        $message = "this is test email. LCN Signature success. responseString:".$responseString.":::::computedHash:".$computedHash.'::::signature_sha2:'.$signature_sha2.'::::SERVER REQUEST_METHOD:'.$_SERVER['REQUEST_METHOD'];
                        
        $html = $message;
        $datetimenow = date('Y-m-d H:i:s');
        // if (YII_ENV_PROD) {
        // 	$email_subject = "Leadconnect Production Server - Webhook IPN Order Ref #".$OrderReferenceNumber." Response";//at $datetimenow
        // }else{
            // $email_subject = "Leadconnect Staging Server - Webhook IPN TESTING NEW HASH Signature Final at ".date('Y-m-d H:i:s');
            $email_subject = "test LinkedFusion email : web/securepayment/webhook-lcn_nrtest_hash Success LCN Signature";
        // }
        $mail = Yii::$app->mailer->compose()
                ->setTo('nikit@intricaretech.com')
				->setFrom(Yii::$app->params['adminEmail'])
                ->setSubject($email_subject)
                ->setHtmlBody($html, 'text/html');
        $mail->send();
        //test email ends
        
        http_response_code(200);
        echo $responseString;

    }

    //21-03-2024 [IN PROGRESS. Working perfect with my test 2checkout account]
    public function actionWebhookLcn_new_hash(){

        /* License Change Notification */

        /*
        * possible values: sha256, sha3-256
        * sha3-256 only for php version > 7.1
        */
        $usedHashAlgorithm = 'sha256';

        /* pass to compute HASH. Retrieve your secret key by accessing https://secure.2checkout.com/cpanel/webhooks_api.php */
		$secretKey = "d?q4rkG]&KAh#vwnmSJ%";


        $signature_sha2   = isset($_POST["SIGNATURE_SHA2_256"]) ? $_POST["SIGNATURE_SHA2_256"] : '';    /* sha256 HASH received */
        $signature_sha3   = isset($_POST["SIGNATURE_SHA3_256"]) ? $_POST["SIGNATURE_SHA3_256"] : '';    /* sha3-256 HASH received */
        
        $stringForHash = $this->serializeArray($_POST);
        $computedHash = hash_hmac($usedHashAlgorithm, $stringForHash, $secretKey);
        
        $validHash = false;
        switch ($usedHashAlgorithm) {
            case "sha256":
                if ($computedHash == $signature_sha2) {
                    $validHash = true;
                }
                break;
            case "sha3-256":
                if ($computedHash == $signature_sha3) {
                    $validHash = true;
                }
                break;
        }
        
        if ($validHash === false) {
            /* hash verification failed */
            http_response_code(400);
            // mail("your_address@example.com", "BAD LCN Signature", print_r($_POST, TRUE),"");

            //test email starts
            $message = "this is test email. BAD LCN Signature. computedHash:".$computedHash.'::::signature_sha2:'.$signature_sha2.'::::SERVER REQUEST_METHOD:'.$_SERVER['REQUEST_METHOD'];
                        
            $html = $message;
            $datetimenow = date('Y-m-d H:i:s');
            if (YII_ENV_PROD) {
            	$email_subject = "LinkedFusion Production Server NEW HASH TESTING : web/securepayment/webhook-lcn_new_hash BAD LCN Signature";
            }else{
                $email_subject = "LinkedFusion Staging Server NEW HASH TESTING : web/securepayment/webhook-lcn_new_hash BAD LCN Signature";
            }
            $mail = Yii::$app->mailer->compose()
                    ->setTo('nikit@intricaretech.com')
					->setFrom(Yii::$app->params['adminEmail'])
                    ->setSubject($email_subject)
                    ->setHtmlBody($html, 'text/html');
            $mail->send();
            //test email ends

            return;
        }
        
        
        // hash is valid. We proceed with success response
        $responseDate = date("YmdGis");
        $arrayForResponseHash = [
            $_POST["LICENSE_CODE"],
            $_POST["EXPIRATION_DATE"],
            $responseDate
        ];
        $stringForResponseHash = $this->serializeArray($arrayForResponseHash);
        
        $responseString = '';
        switch ($usedHashAlgorithm) {
            case "sha256":
                $responseHash = hash_hmac('sha256', $stringForResponseHash, $secretKey);
                $responseString = '<sig algo="sha256" date="' . $responseDate . '">' . $responseHash . '</sig>';
                break;
            case "sha3-256":
                $responseHash = hash_hmac('sha3-256', $stringForResponseHash, $secretKey);
                $responseString = '<sig algo="sha3-256" date="' . $responseDate . '">' . $responseHash . '</sig>';
                break;
        }
        
        //test email starts
        $message = "this is test email. LCN Signature success. responseString:".$responseString.":::::computedHash:".$computedHash.'::::signature_sha2:'.$signature_sha2.'::::SERVER REQUEST_METHOD:'.$_SERVER['REQUEST_METHOD'];
                        
        $html = $message;
        $datetimenow = date('Y-m-d H:i:s');
        if (YII_ENV_PROD) {
        	$email_subject = "LinkedFusion Production Server NEW HASH TESTING : web/securepayment/webhook-lcn_new_hash Success LCN Signature";
        }else{
            $email_subject = "LinkedFusion Staging Server NEW HASH TESTING : web/securepayment/webhook-lcn_new_hash Success LCN Signature";
        }
        $mail = Yii::$app->mailer->compose()
                ->setTo('nikit@intricaretech.com')
				->setFrom(Yii::$app->params['adminEmail'])
                ->setSubject($email_subject)
                ->setHtmlBody($html, 'text/html');
        $mail->send();
        //test email ends
        
        http_response_code(200);
        echo $responseString;

    }

	/* function used to hash */
	function hmacLcn($key, $data)
	{
		$b = 64; // byte length for md5
		if (strlen($key) > $b) {
			$key = pack("H*",md5($key));
		}
		$key  = str_pad($key, $b, chr(0x00));
		$ipad = str_pad('', $b, chr(0x36));
		$opad = str_pad('', $b, chr(0x5c));
		$k_ipad = $key ^ $ipad ;
		$k_opad = $key ^ $opad;
		return md5($k_opad  . pack("H*",md5($k_ipad . $data)));
	}

	function SerializeArrayLcn($myarray)
	{
		$retvalue = "";

		if (isset($myarray) && is_array($myarray) && count($myarray) > 0) {
			foreach ($myarray as $key => $val) {
				if ($key == 'HASH') {
					continue;
				}

				if (is_array($val)) {
					$retvalue .= $this->SerializeArrayLcn($val);
				} else {
					$retvalue .= strlen($val) . $val;
				}
			}
		}

		return $retvalue;
	}


	public function actionIndex_afftesting(){
		
		if(!Yii::$app->session->get('useremail')){
           $url = \Yii::$app->request->baseUrl."/login";
           return $this->redirect($url);
        }
		if(Yii::$app->params['portal_url']=='https://app.cloudkennect.com'){
			$url = \Yii::$app->request->baseUrl."/dashboard";
			return $this->redirect($url);
		}		
		//echo '<pre>'; print_r($_POST);die;
		
		extract($_POST);


		$time = new \DateTime('now');
		//$today = $time->format('Y-m-d');
		$timestamp = $time->getTimestamp();
		$merchant_order_id = 'Lf_'.$timestamp.'_'.substr(Yii::$app->security->generateRandomString(),0,15);
		
		
		//|| !isset($product_id) || !isset($quantity)
		if($merchant_order_id==''|| !isset($_POST['selPlan']) || !isset($_POST['selFreeUser']) || count($_POST['selPlan'])!=count($_POST['selFreeUser']) ){
			 return $this->redirect(['my-template/pricing']);
		}
		
		$userinfo = array('merchant_order_id'=>$merchant_order_id,'email'=>Yii::$app->session->get('useremail'),'username'=>Yii::$app->session->get('username'),'user_id'=>Yii::$app->session->get('userid'));
		

		$selPlanArr = $_POST['selPlan'];
		$selUniquePlanArr=array();
		$selPlanUsrArr=array();
		foreach($selPlanArr as $k=>$spa){
			//echo '<br/>'.$k.'::'.$spa.'<br/>';
			if($k==0){
				$selUniquePlanArr[]=$spa;
			}else{
				if(!in_array($spa, $selUniquePlanArr)){
					$selUniquePlanArr[]=$spa;
				}
			}
			$selPlanUsrArr[$spa][]=$_POST['selFreeUser'][$k];
		}
		//echo '<br/>DFDFD:';print_r($selUniquePlanArr);
		//echo '<br/>ADSD:';print_r($selPlanUsrArr);

		$this->initPayment($_POST,$userinfo,array('selPlanUsrArr'=>$selPlanUsrArr));
		$userinfo = json_encode($userinfo);

		//$a = array('NRTestProduct1'=>'100,101,102','NRTestProduct2'=>'103,104,105','NRTestProduct3'=>'106,107,108');
		//$lfaf_seat_purchased_userids = json_encode($selPlanUsrArr);
		//$af_twocheckout_product_id = json_encode($selUniquePlanArr);

		$lfaf_seat_purchased_userids = addslashes(json_encode($selPlanUsrArr));//31-07-2020
		$af_twocheckout_product_id = addslashes(json_encode($selUniquePlanArr));//31-07-2020

		$LFPM_qty=0;$LFPM_users='';
		$LFGM_qty=0;$LFGM_users='';
		$LFUM_qty=0;$LFUM_users='';
		$LFPQ_qty=0;$LFPQ_users='';
		$LFGQ_qty=0;$LFGQ_users='';
		$LFUQ_qty=0;$LFUQ_users='';
		$LFUP_qty=0;$LFUP_users='';
		
		$LFPSAR_qty=0;$LFPSAR_users='';
		$LFGSAR_qty=0;$LFGSAR_users='';
		$LFUSAR_qty=0;$LFUSAR_users='';
		$LFPA_qty=0;$LFPA_users='';
		$LFGA_qty=0;$LFGA_users='';
		$LFUA_qty=0;$LFUA_users='';

		//$command =Yii::$app->db->createCommand("INSERT INTO user_payment_history (`userid`,`product_id`,`merchant_id`,`user_info`,`status`) VALUES ('".Yii::$app->session->get('userid')."','".$product_id."','".$merchant_order_id."','".$userinfo."','Initialize')");
		//$command =Yii::$app->db->createCommand("INSERT INTO user_payment_history (`userid`,`product_id`,`merchant_id`,`user_info`,`status`,`user_ids`) VALUES ('".Yii::$app->session->get('userid')."','".$product_id."','".$merchant_order_id."','".$userinfo."','Initialize','".$_POST['selUserIds']."')");
		
		$free_userids = implode(',',$_POST['selFreeUser']);
		Yii::$app->db->createCommand("INSERT INTO user_payment_history (`userid`,`merchant_id`,`user_info`,`status`,`user_ids`) VALUES ('".Yii::$app->session->get('userid')."','".$merchant_order_id."','".$userinfo."','Initialize','".$free_userids."')")->execute();
		$lastuphid = Yii::$app->db->getLastInsertID();
		
		foreach($selPlanUsrArr as $product_code=>$uidarr){
			Yii::$app->db->createCommand("INSERT INTO user_order_products SET uph_id=".$lastuphid.", product_id='".$product_code."', user_ids='".implode(',',$uidarr)."' ")->execute();

			if($product_code=='LFPM'){
				$LFPM_qty = count($uidarr);
				$LFPM_users = implode(',',$uidarr);
			}elseif($product_code=='LFGM'){
				$LFGM_qty = count($uidarr);
				$LFGM_users = implode(',',$uidarr);
			}elseif($product_code=='LFUM'){
				$LFUM_qty = count($uidarr);
				$LFUM_users = implode(',',$uidarr);
			}elseif($product_code=='LFPQ'){
				$LFPQ_qty = count($uidarr);
				$LFPQ_users = implode(',',$uidarr);
			}elseif($product_code=='LFGQ'){
				$LFGQ_qty = count($uidarr);
				$LFGQ_users = implode(',',$uidarr);
			}elseif($product_code=='LFUQ'){
				$LFUQ_qty = count($uidarr);
				$LFUQ_users = implode(',',$uidarr);
			}elseif($product_code=='LFUP'){
				$LFUP_qty = count($uidarr);
				$LFUP_users = implode(',',$uidarr);
			}elseif($product_code=='LFPSAR'){
				$LFPSAR_qty = count($uidarr);
				$LFPSAR_users = implode(',',$uidarr);
			}elseif($product_code=='LFGSAR'){
				$LFGSAR_qty = count($uidarr);
				$LFGSAR_users = implode(',',$uidarr);
			}elseif($product_code=='LFUSAR'){
				$LFUSAR_qty = count($uidarr);
				$LFUSAR_users = implode(',',$uidarr);
			}elseif($product_code=='LFPA'){
				$LFPA_qty = count($uidarr);
				$LFPA_users = implode(',',$uidarr);
			}elseif($product_code=='LFGA'){
				$LFGA_qty = count($uidarr);
				$LFGA_users = implode(',',$uidarr);
			}elseif($product_code=='LFUA'){
				$LFUA_qty = count($uidarr);
				$LFUA_users = implode(',',$uidarr);
			}
		}


		
		//$recurrence_plan_array = array('0'=>'2 Week','LFPM'=>'1 Month','LFPQ'=>'3 Month','LFGM'=>'1 Month','LFGQ'=>'3 Month','LFUM'=>'1 Month','LFUQ'=>'3 Month');
       //$recurrence_plan = $recurrence_plan_array[$product_id];
       //$product_name_array = array('LFPM'=>'Professional Monthly','LFPQ'=>'Professional Quarterly','LFGM'=>'Grow Monthly','LFGQ'=>'Grow Quarterly','LFUM'=>'Ultimate Monthly','LFUQ'=>'Ultimate Quarterly');
		//$product_name = $product_name_array[$product_id];
		
		//$twocheckout_product_id = array('LFPM'=>'36147949','LFPQ'=>'36147960','LFGM'=>'36149087','LFGQ'=>'36149119','LFUM'=>'36147991','LFUQ'=>'36148018');//ids in 2checkout panel
        
		
		$command = Yii::$app->db->createCommand("SELECT 2coCustomerReference FROM user WHERE id =".Yii::$app->session->get('userid')." AND 2coCustomerReference>0")->queryOne();
		if(!empty($command)){
			$CustomerReference = $command['2coCustomerReference'];
		}else{
			/*if (YII_ENV_PROD) {
				//production
				$merchantCode = "203537015";
				$key = 'd?q4rkG]&KAh#vwnmSJ%';				
			}else{*/
				//staging
				$merchantCode = "251108887711";
				$key = '!G2S8WRBKJ6#&c~luOz=';				
			//}

			$gmdate = gmdate('Y-m-d H:i:s');
			$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
			$hashAlgorithm = 'sha256';
			$hash = hash_hmac($hashAlgorithm , $string, $key);
			
			//Working example of how to create a customer
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, "https://api.2checkout.com/rest/6.0/customers/");
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_HEADER, FALSE);
			curl_setopt($ch, CURLOPT_POST, TRUE);

			$headers = array();
			$headers[] = 'Accept: application/json';
			$headers[] = 'Content-Type: application/json';
			$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				  $first_name = Yii::$app->session->get('first_name');
				  $last_name = Yii::$app->session->get('last_name');
				  $useremail = Yii::$app->session->get('useremail');
				  $userid = Yii::$app->session->get('userid');
				  //\"ExternalCustomerReference\": \"$userid\",
				  //\"ExternalCustomerReference\": \"\",
				  
			curl_setopt($ch, CURLOPT_POSTFIELDS, "{
				  \"ExternalCustomerReference\": null,
				  \"FirstName\": \"$first_name\",
				  \"LastName\": \"$last_name\",
				  \"Address1\": \"N/A\",
				  \"City\": \"N/A\",
				  \"Zip\": \"123456\",
				  \"CountryCode\": \"gb\",
				  \"Email\": \"$useremail\",
				  \"Trial\": false,
				  \"Enabled\": true
			}");
			$CustomerReference = $curl_result = curl_exec($ch);
			if($CustomerReference>0){
				Yii::$app->db->createCommand('UPDATE user SET 2coCustomerReference = "'.$CustomerReference.'"  WHERE id='.Yii::$app->session->get('userid'))->execute();
			}
			//print_r($curl_result);
			//$curlResult = json_decode($curl_result);
			//echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
			if (curl_errno($ch)) {
				//echo 'Error:' . curl_error($ch);
			}
			curl_close($ch);
		}
		
		
		if($CustomerReference>0){
			
			//$TwoCO_RedirectUrl = Yii::$app->params['siteburl'].'securepayment/response';		
			$TwoCO_RedirectUrl = Yii::$app->params['siteburl'].'securepayment/response_afftesting';		
			
			//echo json_encode(array('success'=>1,'merchant_order_id'=>$merchant_order_id,'twocheckout_product_id'=>$twocheckout_product_id,'selUserIds'=>$selUserIds,'TwoCOCustomerReference'=>$CustomerReference));
			//'twocheckout_product_id'=>$twocheckout_product_id : this should be now at product level instead of order level; => af_twocheckout_product_id done
			//,'selUserIds'=>$selUserIds : this should be now at product level instead of order level; => lfaf_seat_purchased_userids done
			echo json_encode(array('success'=>1,'merchant_order_id'=>$merchant_order_id,'TwoCOCustomerReference'=>$CustomerReference,'lfaf_seat_purchased_userids'=>$lfaf_seat_purchased_userids,'af_twocheckout_product_id'=>$af_twocheckout_product_id,
			'LFPM_qty'=>$LFPM_qty,
			'LFPM_users'=>$LFPM_users,
			'LFGM_qty'=>$LFGM_qty,
			'LFGM_users'=>$LFGM_users,
			'LFUM_qty'=>$LFUM_qty,
			'LFUM_users'=>$LFUM_users,
			'LFPQ_qty'=>$LFPQ_qty,
			'LFPQ_users'=>$LFPQ_users,
			'LFGQ_qty'=>$LFGQ_qty,
			'LFGQ_users'=>$LFGQ_users,
			'LFUQ_qty'=>$LFUQ_qty,
			'LFUQ_users'=>$LFUQ_users,
			'LFPSAR_qty'=>$LFPSAR_qty,
			'LFPSAR_users'=>$LFPSAR_users,
			'LFGSAR_qty'=>$LFGSAR_qty,
			'LFGSAR_users'=>$LFGSAR_users,
			'LFUSAR_qty'=>$LFUSAR_qty,
			'LFUSAR_users'=>$LFUSAR_users,
			'LFPA_qty'=>$LFPA_qty,
			'LFPA_users'=>$LFPA_users,
			'LFGA_qty'=>$LFGA_qty,
			'LFGA_users'=>$LFGA_users,
			'LFUA_qty'=>$LFUA_qty,
			'LFUA_users'=>$LFUA_users,
			'TwoCO_RedirectUrl'=>$TwoCO_RedirectUrl
			));
		}
		
	}

	public function actionResponse_afftesting(){
		//This method used 2 times. (1) From our pricing page, when inline 2checkout order is placed at that time, in 2checkout response, it redirected to this method. (2) From customer's 2checkout panel, When customer manually renew a subscription at that time he will be redirected to this method;
		
		//echo '<pre>';print_r($_GET);echo '</pre>';
		
		//echo '<br/><br/>post:<br/>';print_r($_POST);
		//echo '<br/><br/>req:<br/>';print_r($_REQUEST);

		//test email starts
				$html = json_encode($_GET,JSON_PRETTY_PRINT);
				$datetimenow = date('Y-m-d H:i:s');
			if (YII_ENV_PROD) {
				$email_subject = "Linkedfusion Production Server - Response Method Called at ".$datetimenow;
			}else{
				$email_subject = "Linkedfusion Staging Server - Response Method Called at ".$datetimenow;
			}
				$mail = Yii::$app->mailer->compose()
						->setTo('nikit@intricaretech.com')
						->setFrom(Yii::$app->params['adminEmail'])
						->setSubject($email_subject)
						->setHtmlBody($html, 'text/html');
				$mail->send();
		//test email ends

		
		/*if (YII_ENV_PROD) {
			//production
			$merchantCode = "203537015";
			$key = 'd?q4rkG]&KAh#vwnmSJ%';
		}else{*/
			//staging
			$merchantCode = "251108887711";// your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
			$key = '!G2S8WRBKJ6#&c~luOz=';// your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
		//}

		$gmdate = gmdate('Y-m-d H:i:s');
		$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
		$hashAlgorithm = 'sha256';
		$hash = hash_hmac($hashAlgorithm , $string, $key);
		
		$OrderReferenceNumber = $_GET['refno'];
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

		$headers = array();
		$headers[] = 'Accept: application/json';
		$headers[] = 'Content-Type: application/json';
		$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		$curl_result = curl_exec($ch);
		
		$curlResult = json_decode($curl_result);
		//echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
		if (curl_errno($ch)) {
			//echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);
		//echo '<br/>';
		
		//test email starts
				$html = $curl_result;
				//$datetimenow = date('Y-m-d H:i:s');
			if (YII_ENV_PROD) {
				$email_subject = "Linkedfusion Production Server - Response Method Called at ".$datetimenow;
			}else{
				$email_subject = "Linkedfusion Staging Server - Response Method Called at ".$datetimenow;
			}
				$mail = Yii::$app->mailer->compose()
						->setTo('nikit@intricaretech.com')
						->setFrom(Yii::$app->params['adminEmail'])
						->setSubject($email_subject)
						->setHtmlBody($html, 'text/html');
				$mail->send();
		//test email ends		
		
		$responseGetJson = json_encode($_REQUEST);
		$responseOrderJson = $curl_result;
		//$responseOrderJson = json_decode($curl_result,true);
		//$responseOrderJson = json_encode($responseOrderJson);


		if(isset($_GET['merchant']) && $_GET['merchant']==$merchantCode && isset($_GET['subscription']) && $_GET['subscription']!='' && isset($_GET['signature']) && $_GET['signature']!='' ){
			//From customer's 2checkout panel, When customer manually renew a subscription at that time he will be redirected to this method and this block of code is used to process it further; It may possible that customer is not already logged-in;
			//sample url when it redirects to our website:https://nikit.intricare.net/cloud_theme/basic/web/securepayment/response-working?merchant=251108887711&subscription=56F0CEEF71&refno=129660480&total=131.9&total-currency=USD&signature=1f84b71c22935f8a1e9faed392aa7d1751413891eda27092f5cdccbdec7ee4f7

			/*Olg Orig Code- This code will not wait order to become authorized.
			$response_data = $_GET;
			
			$order_number= $_GET['refno'];//this is order's reference number;
				
			$signature= $_GET['signature'];
			$GETSubscriptionRef = $_GET['subscription'];
			
			//$merchant_order_id= $response_data->merchant_order_id;
			$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;
			
			
			$lfaf_seat_purchased_userids='';
			$addifi = $curlResult->AdditionalFields;
			foreach($addifi as $res){
				if($res->Code=="lfaf_seat_purchased_userids"){
					$lfaf_seat_purchased_userids = $res->Value; //it is blank here
				}
			}


			$twoCo_CustomerReference = 0;
			if(isset($curlResult->CustomerDetails->CustomerReference)){
				//CustomerDetails not exits here
				$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference;
			}
			

			
			$uph_row = Yii::$app->db->createCommand("select t1.id, t1.userid,t1.2coCustomerReference, t2.email, t2.username, t2.first_name, t2.last_name from user_payment_history t1 JOIN user t2 ON t1.userid=t2.id JOIN user_order_products t3 ON t1.id=t3.uph_id where t3.SubscriptionReference='".$GETSubscriptionRef."' ORDER BY t1.id DESC")->queryOne();
			if(!empty($uph_row)){
				//echo '<br/>uph_row:<br/><pre>'; print_r($uph_row);echo '</pre>';
				$uph_pkid = $uph_row['id'];
				
				$user_infoArr = array();
				$user_infoArr['merchant_order_id'] = $merchant_order_id;//it is blank here;
				$user_infoArr['email'] = $uph_row['email'];
				$user_infoArr['username'] = $uph_row['username'];
				$user_infoArr['user_id'] = $uph_row['userid'];
				
				if($twoCo_CustomerReference==0){
					$twoCo_CustomerReference = $uph_row['2coCustomerReference'];
				}
			

				$uphOrderExist_row = Yii::$app->db->createCommand("select id,user_ids from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
				if(!empty($uphOrderExist_row)){
					$lastuphid = $uphOrderExist_row['id'];
				}else{

					$sql_moi='merchant_id='.$merchant_order_id;
					if($merchant_order_id==''){
						$sql_moi='merchant_id=NULL';
					}

					//new order insert entry //user_ids=''
					Yii::$app->db->createCommand('INSERT INTO user_payment_history SET userid='.$uph_row['userid'].', order_number = "'.$order_number.'", '.$sql_moi.', user_info = "'.addslashes(json_encode($user_infoArr)).'" , status="Success", complete_date = "'.date("Y-m-d H:i:s").'", 2coCustomerReference = "'.$twoCo_CustomerReference.'",ordertype=4')->execute();
					$lastuphid = Yii::$app->db->getLastInsertID();
					
					Yii::$app->db->createCommand("UPDATE `user_payment_history` SET `response_get` = '".addslashes($responseGetJson)."', `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$lastuphid)->execute(); 							
				}
				

				$selPlanUsrArr=array();
				$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7');
				
				$fullplanname_array = array('Free'=>'Free','Professional Monthly'=>'LFPM','Professional Quarterly'=>'LFPQ','Grow Monthly'=>'LFGM','Grow Quarterly'=>'LFGQ','Ultimate Monthly'=>'LFUM','Ultimate Quarterly'=>'LFUQ','Ultimate Plus'=>'LFUP');
		
				$Items = $curlResult->Items;				

				foreach($Items as $item_key=>$item_res){
	
					
						$product_id = $item_res->Code;//this is product code eg: LCPM
						$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
						$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
						$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
						$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
						
						$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
						
						if($GETSubscriptionRef==$SubscriptionReference){
							
						
							$upo_row = Yii::$app->db->createCommand("select id,user_ids from user_order_products where uph_id =".$uph_pkid." AND product_id='".$product_id."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
							
							if(!empty($upo_row)){
								$upo_user_ids = $upo_row['user_ids'];
								
								//SubscriptionStartDate = "'.$SubscriptionStartDate.'"
								Yii::$app->db->createCommand('UPDATE user_order_products SET ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE" WHERE id='.$upo_row['id'])->execute();
								
								Yii::$app->db->createCommand("UPDATE `user_payment_history` SET user_ids = '".$upo_user_ids."' where id =".$lastuphid)->execute();
								
								
								$lfaf_seat_purchased_useridsArr = array();
								$lfaf_seat_purchased_useridsArr[$product_id] = explode(',',$upo_user_ids);
		

								//$uidsStrPerProduct = $upo_user_ids;
								$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
								
								
								//starts
								$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus');
								$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
								foreach($userIdArr as $uid){
									
									$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
									$previous_plan = $usrcommand['sublevel'];
									$isTrial = $usrcommand['trial'];
									
									$previous_plan = $previous_plan_array[$previous_plan];
									
									$current_plan = $previous_plan_array[$current_user_setting_plan];
									
									$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
									$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
									$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
									$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
									$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
								}
								//trial_expired_at = "'.$ExpirationDateTimestamp.'"
								Yii::$app->db->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
								//ends
								
								$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$uph_row['email'],'ses_full_name'=>$uph_row['first_name'].' '.$uph_row['last_name'],'responseGetJson'=> $responseGetJson,'GETSubscriptionRef'=>$GETSubscriptionRef);
								$this->renewedSuccessedPayment($payment_info);
								
								
								$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
								if(empty($uos_row)){
									Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
								}
								
								
								Yii::$app->session->set('success_message',"Successfully renewed Subscription #".$GETSubscriptionRef);
								
								
								if(!Yii::$app->session->get('useremail')){
								   $url = \Yii::$app->request->baseUrl."/login";
								   return $this->redirect($url);
								}else{
									return $this->redirect(['my-template/pricing']);
								}
								
							}

						}
				}
				
			}*/

			//30-09-2020 starts
			$response_data = $_GET;
			
			$order_number= $_GET['refno'];//this is order's reference number;
				
			$signature= $_GET['signature'];
			$GETSubscriptionRef = $_GET['subscription'];
			
			//$merchant_order_id= $response_data->merchant_order_id;
			$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;
			
			
			$lfaf_seat_purchased_userids='';
			$addifi = $curlResult->AdditionalFields;
			foreach($addifi as $res){
				if($res->Code=="lfaf_seat_purchased_userids"){
					$lfaf_seat_purchased_userids = $res->Value; //it is blank here
				}
			}


			$twoCo_CustomerReference = 0;
			if(isset($curlResult->CustomerDetails->CustomerReference)){
				//CustomerDetails not exits here
				$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference;
			}
			
			if($curlResult->Status=='COMPLETE' && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK' && 1==2){
				//This code block is not in use. As 2checkout will take some few minutes to authorise the payment. And at this stage above order Status, ApproveStatus and VendorApproveStatus will not be as mentioned in the above condition. So, always it will go in else condition.

				$uph_row = Yii::$app->db->createCommand("select t1.id, t1.userid,t1.2coCustomerReference, t2.email, t2.username, t2.first_name, t2.last_name from user_payment_history t1 JOIN user t2 ON t1.userid=t2.id JOIN user_order_products t3 ON t1.id=t3.uph_id where t3.SubscriptionReference='".$GETSubscriptionRef."' ORDER BY t1.id DESC")->queryOne();
				if(!empty($uph_row)){
					//echo '<br/>uph_row:<br/><pre>'; print_r($uph_row);echo '</pre>';
					$uph_pkid = $uph_row['id'];
					
					$user_infoArr = array();
					$user_infoArr['merchant_order_id'] = $merchant_order_id;//it is blank here;
					$user_infoArr['email'] = $uph_row['email'];
					$user_infoArr['username'] = $uph_row['username'];
					$user_infoArr['user_id'] = $uph_row['userid'];
					
					if($twoCo_CustomerReference==0){
						$twoCo_CustomerReference = $uph_row['2coCustomerReference'];
					}
				

					$uphOrderExist_row = Yii::$app->db->createCommand("select id,user_ids from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
					if(!empty($uphOrderExist_row)){
						$lastuphid = $uphOrderExist_row['id'];
					}else{

						$sql_moi='merchant_id='.$merchant_order_id;
						if($merchant_order_id==''){
							$sql_moi='merchant_id=NULL';
						}

						//new order insert entry //user_ids=''
						Yii::$app->db->createCommand('INSERT INTO user_payment_history SET userid='.$uph_row['userid'].', order_number = "'.$order_number.'", '.$sql_moi.', user_info = "'.addslashes(json_encode($user_infoArr)).'" , status="Success", complete_date = "'.date("Y-m-d H:i:s").'", 2coCustomerReference = "'.$twoCo_CustomerReference.'",ordertype=4')->execute();
						$lastuphid = Yii::$app->db->getLastInsertID();
						
						Yii::$app->db->createCommand("UPDATE `user_payment_history` SET `response_get` = '".addslashes($responseGetJson)."', `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$lastuphid)->execute(); 							
					}
					

					$selPlanUsrArr=array();
					$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7');
					
					$fullplanname_array = array('Free'=>'Free','Professional Monthly'=>'LFPM','Professional Quarterly'=>'LFPQ','Grow Monthly'=>'LFGM','Grow Quarterly'=>'LFGQ','Ultimate Monthly'=>'LFUM','Ultimate Quarterly'=>'LFUQ','Ultimate Plus'=>'LFUP');
			
					$Items = $curlResult->Items;				

					foreach($Items as $item_key=>$item_res){
		
						
							$product_id = $item_res->Code;//this is product code eg: LCPM
							$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
							$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
							$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
							$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
							
							$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
							
							if($GETSubscriptionRef==$SubscriptionReference){
								
							
								$upo_row = Yii::$app->db->createCommand("select id,user_ids from user_order_products where uph_id =".$uph_pkid." AND product_id='".$product_id."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
								
								if(!empty($upo_row)){
									$upo_user_ids = $upo_row['user_ids'];
									
									//SubscriptionStartDate = "'.$SubscriptionStartDate.'"
									Yii::$app->db->createCommand('UPDATE user_order_products SET ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE" WHERE id='.$upo_row['id'])->execute();
									
									Yii::$app->db->createCommand("UPDATE `user_payment_history` SET user_ids = '".$upo_user_ids."' where id =".$lastuphid)->execute();
									
									
									$lfaf_seat_purchased_useridsArr = array();
									$lfaf_seat_purchased_useridsArr[$product_id] = explode(',',$upo_user_ids);
			

									//$uidsStrPerProduct = $upo_user_ids;
									$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
									
									
									//starts
									$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus');
									$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
									foreach($userIdArr as $uid){
										
										$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
										$previous_plan = $usrcommand['sublevel'];
										$isTrial = $usrcommand['trial'];
										
										$previous_plan = $previous_plan_array[$previous_plan];
										
										$current_plan = $previous_plan_array[$current_user_setting_plan];
										
										$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
										$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
										$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
										$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
										$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
									}
									//trial_expired_at = "'.$ExpirationDateTimestamp.'"
									Yii::$app->db->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$upo_user_ids.')')->execute();
									//ends
									
									$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>$uph_row['email'],'ses_full_name'=>$uph_row['first_name'].' '.$uph_row['last_name'],'responseGetJson'=> $responseGetJson,'GETSubscriptionRef'=>$GETSubscriptionRef);
									$this->renewedSuccessedPayment($payment_info);
									
									
									$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
									if(empty($uos_row)){
										Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
									}
									
									
									Yii::$app->session->set('success_message',"Successfully renewed Subscription #".$GETSubscriptionRef);
									
									
									if(!Yii::$app->session->get('useremail')){
									   $url = \Yii::$app->request->baseUrl."/login";
									   return $this->redirect($url);
									}else{
										return $this->redirect(['my-template/affiliates_pricing']);
									}
									
								}

							}
					}
					
				}

			}else{
				
				$uph_row = Yii::$app->db->createCommand("select t1.id, t1.userid,t1.2coCustomerReference, t2.email, t2.username, t2.first_name, t2.last_name from user_payment_history t1 JOIN user t2 ON t1.userid=t2.id JOIN user_order_products t3 ON t1.id=t3.uph_id where t3.SubscriptionReference='".$GETSubscriptionRef."' ORDER BY t1.id DESC")->queryOne();
				if(!empty($uph_row)){
					//echo '<br/>uph_row:<br/><pre>'; print_r($uph_row);echo '</pre>';
					$uph_pkid = $uph_row['id'];
					
					$user_infoArr = array();
					$user_infoArr['merchant_order_id'] = $merchant_order_id;//it is blank here;
					$user_infoArr['email'] = $uph_row['email'];
					$user_infoArr['username'] = $uph_row['username'];
					$user_infoArr['user_id'] = $uph_row['userid'];
					
					if($twoCo_CustomerReference==0){
						$twoCo_CustomerReference = $uph_row['2coCustomerReference'];
					}
				

					$uphOrderExist_row = Yii::$app->db->createCommand("select id,user_ids from user_payment_history where order_number='".$order_number."' ORDER BY id DESC")->queryOne();
					if(!empty($uphOrderExist_row)){
						$lastuphid = $uphOrderExist_row['id'];
					}else{

						$sql_moi='merchant_id='.$merchant_order_id;
						if($merchant_order_id==''){
							$sql_moi='merchant_id=NULL';
						}

						//new order insert entry //user_ids=''
						Yii::$app->db->createCommand('INSERT INTO user_payment_history SET userid='.$uph_row['userid'].', order_number = "'.$order_number.'", '.$sql_moi.', user_info = "'.addslashes(json_encode($user_infoArr)).'" , status="Initialize", complete_date = "'.date("Y-m-d H:i:s").'", 2coCustomerReference = "'.$twoCo_CustomerReference.'",ordertype=4')->execute();
						$lastuphid = Yii::$app->db->getLastInsertID();
						
						Yii::$app->db->createCommand("UPDATE `user_payment_history` SET `response_get` = '".addslashes($responseGetJson)."', `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$lastuphid)->execute(); 							
					}
					
					

					Yii::$app->session->set('success_message',"Payment Authorised Successfully, please wait upto 15 minutes. Your subscription #".$GETSubscriptionRef." will be extended soon.");
					//echo '<br/>ASD';die;
					
					if(!Yii::$app->session->get('useremail')){
					   $url = \Yii::$app->request->baseUrl."/login";
					   return $this->redirect($url);
					}else{
						return $this->redirect(['my-template/affiliates_pricing']);
					}

					
					
				}
			}
			//30-09-2020 ends
			
		}elseif(isset($_GET['signature']) && $_GET['signature']!=''){
			//From our pricing page, when inline 2checkout order is placed at that time, in 2checkout response, it redirected to this method and this block of code is used to process it further;
		

			$response_data = $_GET;
			
			$order_number= $_GET['refno'];//this is order's reference number;
				
			$signature= $_GET['signature'];
			
			//$merchant_order_id= $response_data->merchant_order_id;
			$merchant_order_id= $curlResult->ExternalReference;//this is merchant_order_id;
			
			
			$lfaf_seat_purchased_userids='';
			$addifi = $curlResult->AdditionalFields;
			foreach($addifi as $res){
				if($res->Code=="lfaf_seat_purchased_userids"){
					$lfaf_seat_purchased_userids = $res->Value;
				}
			}

			//$lfaf_seat_purchased_userids = '{"LFPM":["14935","14988"],"LFUM":["14987"]}';
			
			$lfaf_seat_purchased_userids = stripslashes($lfaf_seat_purchased_userids);//added 31-07-2020: removes slash
			$lfaf_seat_purchased_useridsArr = json_decode($lfaf_seat_purchased_userids,true);

			
			$twoCo_CustomerReference = 0;
			if(isset($curlResult->CustomerDetails->CustomerReference)){
				$twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference;
			}
			
			$connection = Yii::$app->db;
			$user_id = Yii::$app->session->get('userid');
			
			
			$uph_row = $connection->createCommand("select id from user_payment_history where merchant_id='".$merchant_order_id."' and userid =" . Yii::$app->session->get('userid'))->queryOne();
			$uph_pkid = $uph_row['id'];
			
			$command = $connection->createCommand('UPDATE user_payment_history SET order_number = "'.$order_number.'", complete_date = "'.date("Y-m-d H:i:s").'", response_signature = "'.$signature.'", 2coCustomerReference = "'.$twoCo_CustomerReference.'" WHERE id='.$uph_pkid);
			$command->execute();

			$connection->createCommand("UPDATE `user_payment_history` SET `response_get` = '".$responseGetJson."', `response_order` = '".addslashes($responseOrderJson)."' where `id` =".$uph_pkid)->execute();
			
			if($curlResult->Status=='COMPLETE' && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK' && 1==2){
				//This code block is not in use. As 2checkout will take some few minutes to authorise the payment. And at this stage above order Status, ApproveStatus and VendorApproveStatus will not be as mentioned in the above condition. So, always it will go in else condition.
				


				//new starts
				$command = $connection->createCommand('UPDATE user_payment_history SET order_number = "'.$order_number.'", complete_date = "'.date("Y-m-d H:i:s").'", status="Success", response_signature = "'.$signature.'", 2coCustomerReference = "'.$twoCo_CustomerReference.'" WHERE id='.$uph_pkid);
				$command->execute();
				
				$selPlanUsrArr=array();
				
				//$current_user_setting_plan_array = array('0'=>'Free Forever','36147949'=>'1','36147960'=>'2','36149087'=>'3','36149119'=>'4','36147991'=>'5','36148018'=>'6');
				$current_user_setting_plan_array = array('0'=>'Free','LFPM'=>'1','LFPQ'=>'2','LFGM'=>'3','LFGQ'=>'4','LFUM'=>'5','LFUQ'=>'6','LFUP'=>'7');
				
				$Items = $curlResult->Items;
				/*
				echo '<br/>Items::<pre>'; print_r($Items);
				echo '<br/><br/>';
				foreach($Items as $item_key=>$item_res){
					echo $item_res->Code;
					echo '<br/>';print_r($item_res);
				}
				die;*/
				
				foreach($Items as $item_key=>$item_res){
					$product_id = $item_res->Code;//this is product code eg: LCPM
					$SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;
					$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
					$ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
					$SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;
					

					$command = $connection->createCommand('UPDATE user_order_products SET SubscriptionStartDate = "'.$SubscriptionStartDate.'", ExpirationDate = "'.$ExpirationDate.'",2coSubscriptionStatus="ACTIVE", SubscriptionReference="'.$SubscriptionReference.'" WHERE uph_id='.$uph_pkid.' AND product_id="'.$product_id.'" ');
					$command->execute();
					
					$uidsStrPerProduct = implode(',',$lfaf_seat_purchased_useridsArr[$product_id]);
					$current_user_setting_plan = $current_user_setting_plan_array[$product_id];//eg:5
					
					$selPlanUsrArr[$product_id]['userIdArr']=$lfaf_seat_purchased_useridsArr[$product_id];
					
					//starts
					$previous_plan_array = array('0'=>'Free','1'=>'Professional Monthly','2'=>'Professional Quarterly','3'=>'Grow Monthly','4'=>'Grow Quarterly','5'=>'Ultimate Monthly','6'=>'Ultimate Quarterly','7'=>'Ultimate Plus');
					$userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
					foreach($userIdArr as $uid){
						
						$usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =".$uid)->queryOne();
						$previous_plan = $usrcommand['sublevel'];
						$isTrial = $usrcommand['trial'];
						
						$previous_plan = $previous_plan_array[$previous_plan];
						
						$current_plan = $previous_plan_array[$current_user_setting_plan];
						
						$selPlanUsrArr[$product_id]['user_name'][]=$usrcommand['first_name'].' '.$usrcommand['last_name'];
						$selPlanUsrArr[$product_id]['user_email'][]=$usrcommand['email'];
						$selPlanUsrArr[$product_id]['previous_plan'][]=$previous_plan;
						$selPlanUsrArr[$product_id]['previous_planisTrial'][]=$isTrial;
						$selPlanUsrArr[$product_id]['current_plan'][]=$current_plan;
					}
					//trial_expired_at = "'.$ExpirationDateTimestamp.'"
					$command = $connection->createCommand('UPDATE user SET sublevel = "'.$current_user_setting_plan.'" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "'.$ExpirationDateTimestamp.'" WHERE id IN ('.$uidsStrPerProduct.')');
					$command->execute();
					//ends
					
					$uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='".$order_number."' AND SubscriptionReference='".$SubscriptionReference."' ORDER BY id DESC")->queryOne();
					if(empty($uos_row)){
						Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "'.$order_number.'", SubscriptionReference="'.$SubscriptionReference.'"')->execute();
					}
					
					
				}
				//echo '<br/>SDFDF:<pre>'; print_r($selPlanUsrArr);
				
				//new ends
				
				$payment_info=array('order_number'=>$order_number,'merchant_order_id'=>$merchant_order_id,'selPlanUsrArr'=>$selPlanUsrArr,'ses_email'=>Yii::$app->session->get('useremail'),'ses_full_name'=>Yii::$app->session->get('first_name'));
				$this->successedPayment($payment_info);
				
				//Yii::$app->session->setFlash('success', "Successfully enabled plan ".$current_plan);
				//Yii::$app->session->setFlash('success', "Successfully enabled subscription");
				//die;;
				Yii::$app->session->set('success_message',"Successfully enabled subscription.");
				return $this->redirect(['my-template/affiliates_pricing']);

			}else{
				//As we need to wait due to 2checkout, until the order is authorized. Once the order is authorized, 2checkout will call "webhookipn" method. From that "webhookipn" method, the further process will be done.

						//if (YII_ENV_PROD) {
							Yii::$app->session->set('session_tracking_order_uph_pkid',$uph_pkid);
							Yii::$app->session->set('session_tracking_order_refno',$_GET['refno']);
							if($_GET['total-currency']=='USD'){
								Yii::$app->session->set('session_tracking_order_total',$_GET['total']);
							}else{
								$usd_total_amt = $curlResult->FxRate * $curlResult->NetDiscountedPrice;
								Yii::$app->session->set('session_tracking_order_total',$usd_total_amt);
							}
						//}


				Yii::$app->session->set('success_message',"Payment Authorised Successfully, please wait upto 5 minutes. Your account will be upgraded and you will be notified by email soon.");
				return $this->redirect(['my-template/affiliates_pricing']);

			}

		}
	    
	}

	public function actionNrtesting_checkfreeuser() {
		$today = date('Y-m-d');
		
		$uop_res = Yii::$app->db->createCommand("SELECT * FROM `user_order_products` WHERE `2coSubscriptionStatus` != 'ACTIVE' AND DATE(ExpirationDate) <= '".$today."' ORDER BY `id` ASC")->queryAll();
		if(!empty($uop_res)){
			foreach($uop_res as $key=>$res){
				
				echo '<br/>('.($key+1).') Id='.$res['id'].'::::uph_id='.$res['uph_id'].'::::product_id='.$res['product_id'].'::::SubscriptionStartDate='.$res['SubscriptionStartDate'].'::::ExpirationDate='.$res['ExpirationDate'].'::::user_ids='.$res['user_ids'].'::::2coSubscriptionStatus='.$res['2coSubscriptionStatus'].'::::upgradeStatus='.$res['upgradeStatus'].'::::upgraded_uphid='.$res['upgraded_uphid'].'::::SubscriptionReference='.$res['SubscriptionReference'].'::::error_response='.$res['error_response'].'::::cancelSubscrErrorResponse='.$res['cancelSubscrErrorResponse'].'::::cancelSubscrStatus='.$res['cancelSubscrStatus'].'::::releaseLicUniqueCode='.$res['releaseLicUniqueCode'].'::::releaseLicUserId='.$res['releaseLicUserId'].'::::isRecurringInstallmentFailedEmailSent='.$res['isRecurringInstallmentFailedEmailSent'].'::::created_at='.$res['created_at'].'::::updated_at='.$res['updated_at'].'<br/><br/>';
				

				if(strpos($res['user_ids'], ",") !== false){
					echo '<br/>CASE_A::Multiple user_ids:::'.$res['user_ids'];
					
					$expl = explode(',',$res['user_ids']);
					foreach($expl as $uid){
						//echo '<br/>'.$uid.'<br/>';

						$user_id = $uid;
						$userDetail = Yii::$app->db->createCommand("select * from user where id =" . $user_id." AND sublevel!='0' ")->queryOne();
						if(!empty($userDetail)){
							//echo '<br/>Suspect User. Sublevel:'.$userDetail['sublevel'];
							echo "<br/>uop_qry1select::SELECT * FROM `user_order_products` WHERE FIND_IN_SET('".$user_id."',user_ids) AND DATE(SubscriptionStartDate) <= '".$today."' AND DATE(ExpirationDate) >= '".$today."' ORDER BY `id` DESC";
							$uop_qry1 = Yii::$app->db->createCommand("SELECT * FROM `user_order_products` WHERE FIND_IN_SET('".$user_id."',user_ids) AND DATE(SubscriptionStartDate) <= '".$today."' AND DATE(ExpirationDate) >= '".$today."' ORDER BY `id` DESC")->queryAll();
							if(!empty($uop_qry1)){
								echo '<br/>uop_qry1result:<br/><pre>'; print_r($uop_qry1); echo '</pre>';
							}else{
								echo '<br/>CASE_A::Check_manually<br/>';
								$qry2 = Yii::$app->db->createCommand("SELECT * FROM `user` WHERE id='".$user_id."' ORDER BY `id` DESC")->queryOne();
								echo '<br/>UserTableData::::id='.$qry2['id'].'::::email='.$qry2['email'].'::::portal_id='.$qry2['portal_id'].'::::last_login_at='.$qry2['last_login_at'].'::'.date('Y-m-d H:i:s',$qry2['last_login_at']).'::::sublevel='.$qry2['sublevel'].'::::trial='.$qry2['trial'].'::::trial_expired_at='.$qry2['trial_expired_at'].'::'.date('Y-m-d H:i:s',($qry2['trial_expired_at']/1000)).'::::is_deleted='.$qry2['is_deleted'].'::::2coCustomerReference='.$qry2['2coCustomerReference'].'::::subscriptionExpiredAt='.date('Y-m-d H:i:s',($qry2['subscriptionExpiredAt']/1000)).'<br/>';
								

							$qry4 = Yii::$app->db->createCommand("SELECT * FROM `user_notes` WHERE user_id='".$user_id."' ORDER BY `id` ASC")->queryAll();
							if(!empty($qry4)){
								echo "<table border='1' colspan='5' rowspan='5' >";
									echo "<tr>";
										echo "<td>id</td>";
										echo "<td>note</td>";
										echo "<td>last_updated_by</td>";
										echo "<td>updated_at</td>";
									echo "</tr>";
								foreach($qry4 as $qry4row){
									echo "<tr>";
										echo "<td>".$qry4row['id']."</td>";
										echo "<td>".$qry4row['note']."</td>";
										echo "<td>".$qry4row['last_updated_by']."</td>";
										echo "<td>".$qry4row['updated_at']."</td>";
									echo "</tr>";
								}
								echo "</table>";
							}
								
								if($qry2['trial']==1 && $qry2['trial_expired_at']>0 ){
									$qry3 = Yii::$app->db->createCommand("SELECT * FROM `ext_sequences` WHERE user_id='".$user_id."' AND lastRunTime >= '".($qry2['trial_expired_at']*1000)."'   ORDER BY `id` DESC")->queryAll();
									if(!empty($qry3)){
										echo '<br/>LINE:'. __LINE__ .':::CASE_A::MustCheckSuspectUser<br/>';
									}
									
								}
								
								
							}
						}						
						
						
					}
					
				}else{
					$user_id = $res['user_ids'];
					$userDetail = Yii::$app->db->createCommand("select * from user where id =" . $user_id." AND sublevel!='0' ")->queryOne();
					if(!empty($userDetail)){
						//echo '<br/>Suspect User. Sublevel:'.$userDetail['sublevel'];
						echo "<br/>uop_qry1select::SELECT * FROM `user_order_products` WHERE FIND_IN_SET('".$user_id."',user_ids) AND DATE(SubscriptionStartDate) <= '".$today."' AND DATE(ExpirationDate) >= '".$today."' ORDER BY `id` DESC";
						$uop_qry1 = Yii::$app->db->createCommand("SELECT * FROM `user_order_products` WHERE FIND_IN_SET('".$user_id."',user_ids) AND DATE(SubscriptionStartDate) <= '".$today."' AND DATE(ExpirationDate) >= '".$today."' ORDER BY `id` DESC")->queryAll();
						if(!empty($uop_qry1)){
							echo '<br/>uop_qry1result:<br/><pre>'; print_r($uop_qry1); echo '</pre>';
						}else{
							echo '<br/>CASE_B::Check_manually<br/>';
							$qry2 = Yii::$app->db->createCommand("SELECT * FROM `user` WHERE id='".$user_id."' ORDER BY `id` DESC")->queryOne();
							echo '<br/>UserTableData::::id='.$qry2['id'].'::::email='.$qry2['email'].'::::portal_id='.$qry2['portal_id'].'::::last_login_at='.$qry2['last_login_at'].'::'.date('Y-m-d H:i:s',$qry2['last_login_at']).'::::sublevel='.$qry2['sublevel'].'::::trial='.$qry2['trial'].'::::trial_expired_at='.$qry2['trial_expired_at'].'::'.date('Y-m-d H:i:s',($qry2['trial_expired_at']/1000)).'::::is_deleted='.$qry2['is_deleted'].'::::2coCustomerReference='.$qry2['2coCustomerReference'].'::::subscriptionExpiredAt='.date('Y-m-d H:i:s',($qry2['subscriptionExpiredAt']/1000)).'<br/>';
							
							
							$qry4 = Yii::$app->db->createCommand("SELECT * FROM `user_notes` WHERE user_id='".$user_id."' ORDER BY `id` ASC")->queryAll();
							if(!empty($qry4)){
								echo "<table border='1' colspan='5' rowspan='5' >";
									echo "<tr>";
										echo "<td>id</td>";
										echo "<td>note</td>";
										echo "<td>last_updated_by</td>";
										echo "<td>updated_at</td>";
									echo "</tr>";
								foreach($qry4 as $qry4row){
									echo "<tr>";
										echo "<td>".$qry4row['id']."</td>";
										echo "<td>".$qry4row['note']."</td>";
										echo "<td>".$qry4row['last_updated_by']."</td>";
										echo "<td>".$qry4row['updated_at']."</td>";
									echo "</tr>";
								}
								echo "</table>";
							}
							
							
							if($qry2['trial']==1 && $qry2['trial_expired_at']>0 ){
								//createdAt >= '".$qry2['trial_expired_at']."'
								$qry3 = Yii::$app->db->createCommand("SELECT * FROM `ext_sequences` WHERE user_id='".$user_id."' AND lastRunTime >= '".($qry2['trial_expired_at']*1000)."'   ORDER BY `id` DESC")->queryAll();
								if(!empty($qry3)){
									echo '<br/>LINE:'. __LINE__ .':::CASE_B::MustCheckSuspectUser<br/>';
								}
								
							}
							
							
						}
					}
				
				}
				
			}
		}
		
		echo '<br/>The End:::';die;
		
		
		
		
		
		
		
		
		
	}

	public function actionNrtesting3(){
		//this is for testing purpose only.
		
				if (isset($_GET['isProductionEnv']) && $_GET['isProductionEnv']==1) {
					//production
					$merchantCode = "203537015";
					$key = 'd?q4rkG]&KAh#vwnmSJ%';
				}else{
					//staging
					$merchantCode = "251108887711";// your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
					$key = '!G2S8WRBKJ6#&c~luOz=';// your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
				}
					
				$gmdate = gmdate('Y-m-d H:i:s');
				$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
				$hashAlgorithm = 'sha256';
				$hash = hash_hmac($hashAlgorithm , $string, $key);
				
				//$OrderReferenceNumber = 147200920;//SANDBOX
				//$OrderReferenceNumber = 147516811;//SANDBOX
				if(isset($_GET['order_ref']) && isset($_GET['isProductionEnv'])){
					
				
					$OrderReferenceNumber = $_GET['order_ref'];//LIVE
					
					
					$ch = curl_init();
					curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/'.$OrderReferenceNumber.'/');
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
					curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

					$headers = array();
					$headers[] = 'Accept: application/json';
					$headers[] = 'Content-Type: application/json';
					$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
					curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
					$curl_result = curl_exec($ch);
					
					$curlResult = json_decode($curl_result);
			echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
					if (curl_errno($ch)) {
						//echo 'Error:' . curl_error($ch);
					}
					curl_close($ch);
					//echo '<br/>';
				}

		//die;

				if(isset($_GET['subscription_ref']) && isset($_GET['isProductionEnv'])){
					
				
				$LICENSE_CODE = $_GET['subscription_ref'];

					$gmdate = gmdate('Y-m-d H:i:s');
					$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
					$hashAlgorithm = 'sha256';
					$hash = hash_hmac($hashAlgorithm , $string, $key);
				
					//Retrieve a subscription
					$ch = curl_init();
					curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/subscriptions/'.$LICENSE_CODE.'/');
					//curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/subscriptions/'.$LICENSE_CODE.'/history/');
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
					curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

					$headers = array();
					$headers[] = 'Accept: application/json';
					$headers[] = 'Content-Type: application/json';
					$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
					curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
					$curl_result = curl_exec($ch);
					
					$curlResult = json_decode($curl_result);
					echo '<br/>subscription res 2:<pre>'; print_r($curlResult);echo '</pre>';
					if (curl_errno($ch)) {
						echo 'Error:' . curl_error($ch);
					}
					curl_close($ch);
				
		//die;				
				

					$gmdate = gmdate('Y-m-d H:i:s');
					$string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
					$hashAlgorithm = 'sha256';
					$hash = hash_hmac($hashAlgorithm , $string, $key);
				
					//Retrieve a subscription
					$ch = curl_init();
					//curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/subscriptions/'.$LICENSE_CODE.'/');
					curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/subscriptions/'.$LICENSE_CODE.'/history/');
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
					curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

					$headers = array();
					$headers[] = 'Accept: application/json';
					$headers[] = 'Content-Type: application/json';
					$headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
					curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
					$curl_result = curl_exec($ch);
					
					$curlResult = json_decode($curl_result);
					echo '<br/>subscription res 1:<pre>'; print_r($curlResult);echo '</pre>';
					if (curl_errno($ch)) {
						echo 'Error:' . curl_error($ch);
					}
					curl_close($ch);
				}	
					
		die;
	}

	//18-06-2021
	 public function successedPaymentAddOnPackExclusiveOrder($payment_info){
		$email = $payment_info['ses_email'];
		$html = $this->renderPartial('/../mail/paymentsuccessedAddOnPackExclusiveOrder', ['value' => $payment_info,'fullname'=>$payment_info['ses_full_name']]);
		
		if (YII_ENV_PROD) {
			//production
			$email_subject = 'Thank you for purchasing Booster Pack!';
			$bccEmail = ['arpan@intricare.net'];

			$mail = Yii::$app->mailer->compose()
			->setTo($email)
			->setBcc($bccEmail)
			->setFrom([Yii::$app->params['adminEmail']=>Yii::$app->params['emailFromName'].' Payments'])
			->setSubject($email_subject)
			->setHtmlBody($html,'text/html');
			$mail->send();			
		}else{
			//staging
			$email_subject = 'STAGING TEST - Thank you for purchasing Booster Pack!';
			$bccEmail = ['nikit@intricaretech.com'];

			$mail = Yii::$app->mailer->compose()
			->setTo($email)
			//->setBcc($bccEmail)
			->setFrom([Yii::$app->params['adminEmail']=>Yii::$app->params['emailFromName'].' Payments'])
			->setSubject($email_subject)
			->setHtmlBody($html,'text/html');
			$mail->send();			
		}


	}
	
}
