<?php

namespace app\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\db\Query;

class ScheduletaskController extends Controller {

    public $enableCsrfValidation = false;

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions() {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    public function beforeAction($action) {
        if (empty(Yii::$app->session->get('userid'))) {
            $loginUrl = Yii::$app->request->baseUrl . "/login";
            return $this->redirect($loginUrl);
        }
        return parent::beforeAction($action);
    }

    //Developed by Ankit Sevak
    /**
     * Displays homepage.
     *
     * @return string
     */
    public function actionIndex() {   //print_r(date('m/d/Y, h:i:s A', strtotime('+7 days', '1584594931375')));
        //print_r(date('m/d/Y, h:i:s A', round(1584594931375 / 1000 + 7 * 24 * 60 * 60 * 1000 )));
        //exit;
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }

        $querySeq = new Query();
        $querySeq->select('id, name')
                ->from('ext_sequences')
                ->where(['=', 'user_id', Yii::$app->session->get('userid')]);

        $seqCommand = $querySeq->createCommand();
        $sequences = $seqCommand->queryAll();

        $query = new Query();
        $query->select('ext_tasks.id,ext_tasks.personId, ext_tasks.starttime, ext_sequences.id as seqId, ext_tasks.person, ext_sequences.name, ext_sequences.requestWithdrawDays, ext_tasks.step,ext_tasks.type, ext_tasks.triggered,ext_tasks.triggerOnInvitationAccepted,ext_tasks.result')
                ->from('ext_tasks')
                ->leftJoin('ext_sequences', 'ext_tasks.seqId = ext_sequences.id AND ext_sequences.user_id='.Yii::$app->session->get('userid'))
                ->where(['=', 'ext_tasks.status', 'Not Started'])
                ->andWhere(['=', 'ext_tasks.userId', Yii::$app->session->get('userid')])
                ->andWhere(['!=', 'ext_sequences.status', "Deleted"])
				->groupBy(['ext_tasks.personId']);
		
        if (isset($_GET['scheduletasksearchname']) && $_GET['scheduletasksearchname'] != "") {
            $name = $_GET['scheduletasksearchname'];
            $query->andWhere("ext_tasks.person LIKE'%" . str_replace("'","\'", $name) . "%'");
            $query->orWhere("ext_sequences.name LIKE'%" . str_replace("'","\'", $name) . "%'");
        }

        $seqFollowUpTime = Yii::$app->session->get('seqFollowUpTime');
        if (!empty($seqFollowUpTime)) {
            $query->andWhere(['<', 'ext_tasks.starttime', round(microtime(true) * 1000 + $seqFollowUpTime * 24 * 60 * 60 * 1000)]);
            //$query->andWhere(['>', 'ext_tasks.starttime', round(microtime(true) * 1000)]);
        } else {
            $query->andWhere(['<', 'ext_tasks.starttime', round(microtime(true) * 1000 + 2 * 24 * 60 * 60 * 1000)]);
            //$query->andWhere(['>', 'ext_tasks.starttime', round(microtime(true) * 1000)]);
        }
		
		
		$hidepausedtask = Yii::$app->session->get('hidepausedtask');
        if (!empty($hidepausedtask) && $hidepausedtask == 1) {
            $query->andWhere(['!=', 'ext_sequences.status', "Paused"]);
            //$query->andWhere(['>', 'ext_tasks.starttime', round(microtime(true) * 1000)]);
        } else {
            $query->andWhere(['=', 'ext_sequences.status', "Paused"]);
            //$query->andWhere(['>', 'ext_tasks.starttime', round(microtime(true) * 1000)]);
        }

        $seqId = Yii::$app->session->get('seqId');
        if (!empty($seqId) && $seqId != 'all') {
            $query->andWhere(['=', 'ext_tasks.seqId', $seqId]);
        }
        //echo $query->createCommand()->getRawSql();die;  
        //print_r($query->prepare(Yii::$app->db->queryBuilder)->createCommand()->rawSql);exit;
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 20,
            ],
        ]);

        return $this->render('index', [
                    'dataProvider' => $dataProvider,
                    'sequences' => $sequences
        ]);
    }

    public function actionDeleteresponse() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $id = Yii::$app->request->post('id');
        if (Yii::$app->db->createCommand("UPDATE `ext_blacklist` SET `deleted` = '1' WHERE `id` = '" . $id . "'")->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function actionSetschedulefilter() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $seqId = Yii::$app->request->post('seqId');
        $seqFollowUpTime = Yii::$app->request->post('seqFollowUpTime');
        $hidepausedtask = Yii::$app->request->post('hidepausedtask');

        if (!empty($seqId)) {
            Yii::$app->session->set('seqId', $seqId);
        } else {
            Yii::$app->session->remove('seqId');
        }

        if (!empty($seqFollowUpTime)) {
            Yii::$app->session->set('seqFollowUpTime', $seqFollowUpTime);
        } else {
            Yii::$app->session->remove('seqFollowUpTime');
        }
		
		 if(!empty($hidepausedtask)) {
            Yii::$app->session->set('hidepausedtask', $hidepausedtask);
        } else {
            Yii::$app->session->remove('hidepausedtask');
        }
    }

    public function actionSkipfollowup() {

        $taskId = Yii::$app->request->post('taskId');
        $personId = Yii::$app->request->post('personId');
        $userId = Yii::$app->session->get('userid');
        $timestamp = round(microtime(true) * 1000);
        $seqId = Yii::$app->request->post('seqId');
        $fullname = Yii::$app->request->post('fullname');
        $types = Yii::$app->request->post('types');
        $a = 'Skipped for <a href="#">';
        $aa = '</a>';
        $text = $types . " " . $a . $fullname . $aa;
        /* echo "INSERT INTO `ext_log` (`userId`,`seqId`,`text`) values('".$userId."','".$seqId."','".$text."')";
          die; */
        if (Yii::$app->db->createCommand("UPDATE `ext_tasks` SET `status` = 'Paused' WHERE `status` = 'Not Started' AND `personId` = '" . $personId . "' AND `userId` = '" . $userId . "'")->execute()) {
            /* Yii::$app->db->createCommand("INSERT INTO completed_tasks SELECT ext_tasks.*, NOW() FROM ext_tasks WHERE id = '" . $taskId . "'")->execute(); 
              Yii::$app->db->createCommand("DELETE FROM ext_tasks WHERE id = '" . $taskId . "'")->execute(); */

            //Yii::$app->db->createCommand("UPDATE  blacklist SET  is_response='2',respond='" . $timestamp . "' WHERE seq_id = '" . $seqId . "' AND linkedinpublicid='" . $personId . "' AND userid='" . $userId . "'")->execute();
			Yii::$app->db->createCommand("UPDATE  blacklist SET  is_response='2' WHERE seq_id = '" . $seqId . "' AND linkedinpublicid='" . $personId . "' AND userid='" . $userId . "'")->execute();

            Yii::$app->db->createCommand("INSERT INTO `ext_log` (`userId`,`seqId`,`text`) values('" . $userId . "','" . $seqId . "','" . $text . "')")->execute();

            return true;
        } else {
            return false;
        }
    }

    public function actionSkipwithdraw() {

        $taskId = Yii::$app->request->post('taskId');
        $personId = Yii::$app->request->post('personId');
        $userId = Yii::$app->session->get('userid');
        $timestamp = round(microtime(true) * 1000);
        $seqId = Yii::$app->request->post('seqId');
        $fullname = Yii::$app->request->post('fullname');
        $types = Yii::$app->request->post('types');
        $a = 'Skipped for <a href="#">';
        $aa = '</a>';
        $text = $types . " " . $a . $fullname . $aa;
        /* echo "INSERT INTO `ext_log` (`userId`,`seqId`,`text`) values('".$userId."','".$seqId."','".$text."')";
          die; */
        if (Yii::$app->db->createCommand("UPDATE `ext_tasks` SET `status` = 'Paused' WHERE `status` = 'Not Started' AND `personId` = '" . $personId . "' AND `userId` = '" . $userId . "'")->execute()) {
            /* Yii::$app->db->createCommand("INSERT INTO completed_tasks SELECT ext_tasks.*, NOW() FROM ext_tasks WHERE id = '" . $taskId . "'")->execute(); 
              Yii::$app->db->createCommand("DELETE FROM ext_tasks WHERE id = '" . $taskId . "'")->execute(); */

            /* Yii::$app->db->createCommand("UPDATE  blacklist SET  is_response='2',respond='".$timestamp."' WHERE seq_id = '".$seqId ."' AND linkedinpublicid='" .$personId. "' AND userid='" .$userId. "'")->execute();  */

            Yii::$app->db->createCommand("INSERT INTO `ext_log` (`userId`,`seqId`,`text`) values('" . $userId . "','" . $seqId . "','" . $text . "')")->execute();

            return true;
        } else {
            return false;
        }
    }

    public function actionGetprofiledata() {
        $id = Yii::$app->request->post('taskId');
        $person = Yii::$app->db->createCommand("SELECT person FROM `ext_tasks` WHERE `id` = '" . $id . "'")->queryScalar();
        $profile_data = json_decode($person);
        if (!empty(json_decode(preg_replace('/\"description\"\:\".*?\"\,/ms', '"description":"empty",', $person)))) {
            $profile_data = json_decode(preg_replace('/\"description\"\:\".*?\"\,/ms', '"description":"empty",', $person));
        } else {
            $profile_data = '';
        }
        if (!empty($profile_data->firstName)) {
            $fullname = $profile_data->firstName . ' ' . $profile_data->lastName;
        } else {
            $fullname = 'N/A';
        }
        if (!empty($profile_data->occupation)) {
            $occupation = $profile_data->occupation;
        } else {
            $occupation = 'N/A';
        }
        if (!empty($profile_data->publicIdentifier)) {
            $profileLink = 'https://www.linkedin.com/in/' . $profile_data->publicIdentifier;
            $publicIdentifier = "<a  target='_blank' href=" . $profileLink . ">Linkedin Profile Link</a>";
        } else {
            $profileLink = 'N/A';
            $publicIdentifier = "N/A";
        }

        $result = "<span><b>Fullname</b> : " . $fullname . "</br></span></br><span><b>Occupation</b> : " . $occupation . "</span></br></br><span><b>Linkedin Profile</b> :" . $publicIdentifier . "</span>";
        echo $result;
    }

    //Developed by Ankit Sevak
}
