<?php

namespace app\controllers;

use Yii;
use yii\web\User;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\Pagination;
use yii\db\Query;

/**
 * BlacklistController implements the CRUD actions for Blacklist model.
 */
class SalesteamController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Blacklist models.
     * @return mixed
     */
    //use for fetch record user from first name , last name And email
    function actionIndex($id = 0) {

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (\Yii::$app->session->get('salesperson') == 0)
            throw new \yii\web\NotFoundHttpException();


        $portal_id = Yii::$app->session->get('portal_id');



        $UserDetails = [];
        if (\Yii::$app->request->post() && empty(\Yii::$app->request->post('teamid'))) {
            if (isset($_REQUEST['msg'])) {
                $SearchType = Yii::$app->request->post('SearchType');
                $customQuery = '';
                if ($SearchType == 'fname') {
                    $customQuery = "WHERE first_name = '" . trim(\Yii::$app->request->post('search_user')) . "'";
                } else if ($SearchType == 'lname') {
                    $customQuery = "WHERE last_name = '" . trim(\Yii::$app->request->post('search_user')) . "'";
                } else if ($SearchType == 'merchantid') {
                    $customQuery = "WHERE merchant_id = '" . trim(\Yii::$app->request->post('search_user')) . "'";
                } else {
                    $customQuery = "WHERE email LIKE '" . trim(\Yii::$app->request->post('search_user')) . "'";
                }
            }

            // dev005 - new search on 08 Jan 2020
            $SearchType = Yii::$app->request->post('SearchType');
            $customQuery = '';

            if ($SearchType == 'fname') {
                $customQuery = "WHERE first_name LIKE '%" . trim(\Yii::$app->request->post('search_user')) . "%'";
            } else if ($SearchType == 'lname') {
                $customQuery = "WHERE last_name LIKE '%" . trim(\Yii::$app->request->post('search_user')) . "%'";
            } else if ($SearchType == 'merchantid') {
                $customQuery = "WHERE merchant_id LIKE '%" . trim(\Yii::$app->request->post('search_user')) . "%'";
            } else {
                $customQuery = "WHERE email LIKE '%" . trim(\Yii::$app->request->post('search_user')) . "%'";
            }


            $srcbysublevel = Yii::$app->request->post('srcbysublevel');
            $customQuery2 = '';
            if ($srcbysublevel != '' && $customQuery != '') {
                $customQuery2 = " AND user.sublevel LIKE '%" . \Yii::$app->request->post('srcbysublevel') . "%'";
            }


//            if (Yii::$app->session->get('userid') == "14905") {
//                $UserDetails = Yii::$app->db->createCommand("SELECT `user`.* , `user_payment_history`.`status` , `user_payment_history`.`id` as user_payment_history_id FROM `user` LEFT JOIN user_payment_history ON `user_payment_history`.`userid` = `user`.`id` " . $customQuery . " GROUP BY `user`.`id` ")->queryAll();
//            } else {
            $UserDetails = Yii::$app->db->createCommand("SELECT `user`.* , `user_payment_history`.`status` , `user_payment_history`.`id` as user_payment_history_id FROM `user` LEFT JOIN user_payment_history ON `user_payment_history`.`userid` = `user`.`id` " . $customQuery . " " . $customQuery2 . " and user.portal_id='" . $portal_id . "' GROUP BY `user`.`id` ")->queryAll();
//            }
        } else {
            if (!empty(\Yii::$app->request->post('teamid'))) {
//                if (Yii::$app->session->get('userid') == "14905") {
//                    $UserDetails = Yii::$app->db->createCommand("SELECT * FROM `user` WHERE `teamid` = '" . \Yii::$app->request->post('teamid') . "'")->queryAll();
//                } else {
                $UserDetails = Yii::$app->db->createCommand("SELECT * FROM `user` WHERE `teamid` = '" . \Yii::$app->request->post('teamid') . "' and portal_id='" . $portal_id . "'")->queryAll();
//                }
            }
        }
        $lead_plans = Yii::$app->db->createCommand("SELECT sublevel,name FROM `lead_plans` order by sublevel")->queryAll();


        return $this->render('index', [
                    'users' => $UserDetails,
                    'lead_plans' => $lead_plans,
        ]);
    }

    function actionIndex_nrtesting($id = 0) {

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (\Yii::$app->session->get('salesperson') == 0)
            throw new \yii\web\NotFoundHttpException();


        $portal_id = Yii::$app->session->get('portal_id');



        $UserDetails = [];
        if (\Yii::$app->request->post() && empty(\Yii::$app->request->post('teamid'))) {
            if (isset($_REQUEST['msg'])) {
                $SearchType = Yii::$app->request->post('SearchType');
                $customQuery = '';
                if ($SearchType == 'fname') {
                    $customQuery = "WHERE first_name = '" . trim(\Yii::$app->request->post('search_user')) . "'";
                } else if ($SearchType == 'lname') {
                    $customQuery = "WHERE last_name = '" . trim(\Yii::$app->request->post('search_user')) . "'";
                } else if ($SearchType == 'merchantid') {
                    $customQuery = "WHERE merchant_id = '" . trim(\Yii::$app->request->post('search_user')) . "'";
                } else {
                    $customQuery = "WHERE email LIKE '" . trim(\Yii::$app->request->post('search_user')) . "'";
                }
            }

            // dev005 - new search on 08 Jan 2020
            $SearchType = Yii::$app->request->post('SearchType');
            $customQuery = '';

            if ($SearchType == 'fname') {
                $customQuery = "WHERE first_name LIKE '%" . trim(\Yii::$app->request->post('search_user')) . "%'";
            } else if ($SearchType == 'lname') {
                $customQuery = "WHERE last_name LIKE '%" . trim(\Yii::$app->request->post('search_user')) . "%'";
            } else if ($SearchType == 'merchantid') {
                $customQuery = "WHERE merchant_id LIKE '%" . trim(\Yii::$app->request->post('search_user')) . "%'";
            } else {
                $customQuery = "WHERE email LIKE '%" . trim(\Yii::$app->request->post('search_user')) . "%'";
            }


            $srcbysublevel = Yii::$app->request->post('srcbysublevel');
            $customQuery2 = '';
            if ($srcbysublevel != '' && $customQuery != '') {
                $customQuery2 = " AND user.sublevel LIKE '%" . \Yii::$app->request->post('srcbysublevel') . "%'";
            }


//            if (Yii::$app->session->get('userid') == "14905") {
//                $UserDetails = Yii::$app->db->createCommand("SELECT `user`.* , `user_payment_history`.`status` , `user_payment_history`.`id` as user_payment_history_id FROM `user` LEFT JOIN user_payment_history ON `user_payment_history`.`userid` = `user`.`id` " . $customQuery . " GROUP BY `user`.`id` ")->queryAll();
//            } else {
            $UserDetails = Yii::$app->db->createCommand("SELECT `user`.* , `user_payment_history`.`status` , `user_payment_history`.`id` as user_payment_history_id FROM `user` LEFT JOIN user_payment_history ON `user_payment_history`.`userid` = `user`.`id` " . $customQuery . " " . $customQuery2 . " and user.portal_id='" . $portal_id . "' GROUP BY `user`.`id` ")->queryAll();
//            }
        } else {
            if (!empty(\Yii::$app->request->post('teamid'))) {
//                if (Yii::$app->session->get('userid') == "14905") {
//                    $UserDetails = Yii::$app->db->createCommand("SELECT * FROM `user` WHERE `teamid` = '" . \Yii::$app->request->post('teamid') . "'")->queryAll();
//                } else {
                $UserDetails = Yii::$app->db->createCommand("SELECT * FROM `user` WHERE `teamid` = '" . \Yii::$app->request->post('teamid') . "' and portal_id='" . $portal_id . "'")->queryAll();
//                }
            }
        }
        $lead_plans = Yii::$app->db->createCommand("SELECT sublevel,name FROM `lead_plans` order by sublevel")->queryAll();


        return $this->render('index_nrtesting', [
                    'users' => $UserDetails,
                    'lead_plans' => $lead_plans,
        ]);
    }

    // use for extending Trial 
    public function actionExtendtrial() {
        $id = Yii::$app->request->post('id');
        $user_id = Yii::$app->session->get('userid');

        if ($user_id == 14907 || $user_id == 14909) {
            $timestamp = intval(strtotime(Yii::$app->request->post('date')));
            $extend_expired_at_militime = round($timestamp * 1000);
            //$tempExtend_expire_at_militime1 = strtotime(date('d-m-Y', strtotime(' + 7 days'))) * 1000;
//            $sql1 = "UPDATE `user` SET  `trial_expired_at`='" . $tempExtend_expire_at_militime1 . "' ,`trial`= '1' ,  `note`= IFNULL (CONCAT( note , '* Trial Extended  by " . Yii::$app->session->get('useremail') . " , Extended to (" . date("F d, Y h:i:s A", $tempExtend_expire_at_militime1) . " )  " . date("F d, Y h:i:s A", time()) . " \n' ), '* Trial Extended  by " . Yii::$app->session->get('useremail') . " ,   Extended to  (" . date("F d, Y h:i:s A", $tempExtend_expire_at_militime1) . " )  " . date("F d, Y h:i:s A", time()) . " \n' )  where `id`='" . $id . "' ";
            $sql1 = "UPDATE `user` SET  `trial_expired_at`='" . $extend_expired_at_militime . "' ,`trial`= '1' where `id`='" . $id . "' ";
            Yii::$app->db->createCommand($sql1)->execute();

            $updated_at = date("d M Y h:i:s A");
            $notemsg = 'Trial Extended by ' . Yii::$app->session->get('useremail') . ' , Extended to (' . date("F d, Y h:i:s A", $timestamp) . ') ' . date("F d, Y h:i:s A", time());
            $sqlins = "Insert into `sales_notes` SET `note` ='" . $notemsg . "', created_on = '" . $updated_at . "', `userid`='" . $id . "', addedby = '" . \Yii::$app->session->get('userid') . "'";
            Yii::$app->db->createCommand($sqlins)->execute();

            $sqlins = "Insert into `user_notes` SET `note` ='" . $notemsg . "', updated_at = '" . $updated_at . "', `user_id`='" . $id . "', last_updated_by = '" . \Yii::$app->session->get('userid') . "'";
            Yii::$app->db->createCommand($sqlins)->execute();
        } else if ($user_id == 14938) {

            $tempExtend_expire_at_militime1 = strtotime(date('d-m-Y', strtotime(' + 7 days'))) * 1000;
//            $sql1 = "UPDATE `user` SET  `trial_expired_at`='" . $tempExtend_expire_at_militime1 . "' ,`trial`= '1' ,  `note`= IFNULL (CONCAT( note , '* Trial Extended  by " . Yii::$app->session->get('useremail') . " , Extended to (" . date("F d, Y h:i:s A", $tempExtend_expire_at_militime1) . " )  " . date("F d, Y h:i:s A", time()) . " \n' ), '* Trial Extended  by " . Yii::$app->session->get('useremail') . " ,   Extended to  (" . date("F d, Y h:i:s A", $tempExtend_expire_at_militime1) . " )  " . date("F d, Y h:i:s A", time()) . " \n' )  where `id`='" . $id . "' ";
            $sql1 = "UPDATE `user` SET  `trial_expired_at`='" . $tempExtend_expire_at_militime1 . "' ,`trial`= '1' where `id`='" . $id . "' ";
            Yii::$app->db->createCommand($sql1)->execute();

            $updated_at = date("d M Y h:i:s A");
            $notemsg = 'Trial Extended by ' . Yii::$app->session->get('useremail') . ' , Extended to (' . date("F d, Y h:i:s A", $tempExtend_expire_at_militime1 / 1000) . ') ' . date("F d, Y h:i:s A", time());
            $sqlins = "Insert into `user_notes` SET `note` ='" . $notemsg . "', updated_at = '" . $updated_at . "', `user_id`='" . $id . "', last_updated_by = '" . \Yii::$app->session->get('userid') . "'";
            Yii::$app->db->createCommand($sqlins)->execute();
        } else {
            $id = Yii::$app->request->post('id');
            $timestamp = intval(strtotime(Yii::$app->request->post('date')));
            $extend_expired_at_militime = round($timestamp * 1000);
//            $sql = "UPDATE `user` SET  `trial_expired_at`='" . $extend_expired_at_militime . "' ,`trial`= '1' ,  `note`= IFNULL (CONCAT( note , '* Trial Extended  by " . Yii::$app->session->get('useremail') . " , Extended to (" . date("F d, Y h:i:s A", $timestamp) . " )  " . date("F d, Y h:i:s A", time()) . " \n' ), '* Trial Extended  by " . Yii::$app->session->get('useremail') . " ,   Extended to  (" . date("F d, Y h:i:s A", $timestamp) . " )  " . date("F d, Y h:i:s A", time()) . " \n' )  where `id`='" . $id . "' ";
            $sql = "UPDATE `user` SET  `trial_expired_at`='" . $extend_expired_at_militime . "' ,`trial`= '1' where `id`='" . $id . "' ";
            Yii::$app->db->createCommand($sql)->execute();

            $updated_at = date("d M Y h:i:s A");
            $notemsg = 'Trial Extended by ' . Yii::$app->session->get('useremail') . ' , Extended to (' . date("F d, Y h:i:s A", $timestamp) . ') ' . date("F d, Y h:i:s A", time());
            $sqlins = "Insert into `user_notes` SET `note` ='" . $notemsg . "', updated_at = '" . $updated_at . "', `user_id`='" . $id . "', last_updated_by = '" . \Yii::$app->session->get('userid') . "'";
            Yii::$app->db->createCommand($sqlins)->execute();
        }
    }

    public function getportalname($id) {
        $query_sequ = new Query;
        $model_sequ = $query_sequ->select(['sitetitle'])
                ->from('portals')
                ->where(['id' => $id])
                ->one();
        return $model_sequ['sitetitle'];
    }

    public function actionGetuserplan() {
        $id = Yii::$app->request->post('id');
        $query_sequ = new Query;
        $model_sequ = $query_sequ->select(['sublevel'])
                ->from('user')
                ->where(['id' => $id])
                ->one();
        return $model_sequ['sublevel'];
    }

    //Change Plan
    public function actionChangeplan() {
        $timestamp = intval(strtotime(Yii::$app->request->post('date')));

        $id = Yii::$app->request->post('id');
        $sublevel = Yii::$app->request->post('sublevel');
        $pre_plan_id = Yii::$app->request->post('pre_plan_id');
        $nowFormat = date('Y-m-d H:i:s');
        $notemsg = 'Plan Changed By: ' . Yii::$app->session->get('useremail') . ':';
        $notemsg .= 'Plan Changed On: ' . $nowFormat . ':';
        $notemsg .= 'Plan Changed to Sublevel (' . $sublevel . ') From (' . $pre_plan_id . ')';
        $trial_expired_at = strtotime("+7 day", time());
        $trial_expired_at_militime = round($trial_expired_at * 1000);

        // active booster plan on ultimate account
        $ultimateplan = array(1, 2, 3, 4, 5, 6, 7, 12, 13, 16, 17);

        $updbootqury = '';
        if (in_array($sublevel, $ultimateplan)) {
            $updbootqury = "is_booster='1',";
        } else {
            $updbootqury = "is_booster='0',";
        }

//        $sql = "UPDATE `user` SET  `sublevel`='" . $sublevel . "', `trial_expired_at` = '" . $trial_expired_at_militime . "', `note`='" . $notemsg . "'   where `id`='" . $id . "' ";

        $sql = "UPDATE `user` SET " . $updbootqury . " `sublevel`='" . $sublevel . "', `trial_expired_at` = '" . $trial_expired_at_militime . "' where `id`='" . $id . "' ";

        Yii::$app->db->createCommand($sql)->execute();


        $updated_at = date("d M Y h:i:s A");
        $sqlins = "Insert into `user_notes` SET `note` ='" . $notemsg . "', updated_at = '" . $updated_at . "', `user_id`='" . $id . "', last_updated_by = '" . \Yii::$app->session->get('userid') . "'";
        Yii::$app->db->createCommand($sqlins)->execute();

        if ($sublevel == 0) {
            $sql = "UPDATE `user` SET  `popupstatus`='0' where `id`='" . $id . "' ";
            Yii::$app->db->createCommand($sql)->execute();

            $proxyData = Yii::$app->db->createCommand("SELECT proxyUsername,id FROM user where id='$id'")->queryOne();
            if (!empty($proxyData['proxyUsername'])) {
                $UserProxyDetail = explode("-", $proxyData['proxyUsername']);
                $zoneName = $UserProxyDetail[4];
                $iP = $UserProxyDetail[6];
                if (!empty($iP) && !empty($zoneName)) {
                    $ch_deleteIp = curl_init();
                    curl_setopt($ch_deleteIp, CURLOPT_URL, 'https://luminati.io/api/zone/ips');
                    curl_setopt($ch_deleteIp, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch_deleteIp, CURLOPT_CUSTOMREQUEST, 'DELETE');
                    curl_setopt($ch_deleteIp, CURLOPT_POSTFIELDS, "{\"customer\":\"hl_4b7d4696\",\"zone\":\"$zoneName\",\"ips\":[\"$iP\"]}");
//                    curl_setopt($ch_deleteIp, CURLOPT_USERPWD, 'arpan@halfpixel.co.in' . ':' . 'Asdf@123');
                    $headers = array();
                    $headers[] = 'Content-Type: application/json';
                    //$headers[] = 'Authorization: Bearer c2b5593e-9399-4607-b4f1-8b3f35aa9ae7';
					$headers[] = 'Authorization: Bearer e18c02a4-2520-4e94-b19a-fc70efd2f36c';
                    curl_setopt($ch_deleteIp, CURLOPT_HTTPHEADER, $headers);
                    $result_deleteIp = curl_exec($ch_deleteIp);
                    if (curl_errno($ch_deleteIp)) {
                        echo 'Error:' . curl_error($ch_deleteIp);
                    } else {
                        Yii::$app->db->createCommand("UPDATE user SET proxyIp='',`proxyPort` = NULL,`proxyUsername`=NULL,proxyPassword=NULL,popupstatus='0',app_container='',app_container_ip=NULL,app_container_port='' WHERE id=" . $proxyData['id'])->execute();
                        Yii::$app->db->createCommand("UPDATE Luminati_IP_Info SET Ip_ReleaseOn='" . date("Y-m-d H:i:s") . "' WHERE Ip_address='" . $iP . "' and userId=" . $proxyData['id'])->execute();
                    }
                    curl_close($ch_deleteIp);
                }
            }
        }
    }

    // activate booster plan

    public function actionActivateboosterplan() {

        $nowFormat = date('Y-m-d H:i:s');
        $notemsg = 'Booster plan activated By: ' . Yii::$app->session->get('useremail') . ':';
        $notemsg .= 'Booster plan activated On: ' . $nowFormat . ':';
        $datauserid = $_POST['datauserid'];


        $updated_at = date("d M Y h:i:s A");
        $sqlins = "Insert into `user_notes` SET `note` ='" . $notemsg . "', updated_at = '" . $updated_at . "', `user_id`='" . $datauserid . "', last_updated_by = '" . \Yii::$app->session->get('userid') . "'";
        Yii::$app->db->createCommand($sqlins)->execute();

        //echo "UPDATE user SET is_booster='1' WHERE id='" . $datauserid;

        Yii::$app->db->createCommand("UPDATE user SET is_booster='1' WHERE id='" . $datauserid . "'")->execute();
    }

    // End activate booster plan
    // deactivate booster plan

    public function actionDeactivateboosterplan() {

        $nowFormat = date('Y-m-d H:i:s');
        $notemsg = 'Booster plan deactivated By: ' . Yii::$app->session->get('useremail') . ':';
        $notemsg .= 'Booster plan deactivated On: ' . $nowFormat . ':';
        $datauserid = $_POST['datauserid'];


        $updated_at = date("d M Y h:i:s A");
        $sqlins = "Insert into `user_notes` SET `note` ='" . $notemsg . "', updated_at = '" . $updated_at . "', `user_id`='" . $datauserid . "', last_updated_by = '" . \Yii::$app->session->get('userid') . "'";
        Yii::$app->db->createCommand($sqlins)->execute();

        //echo "UPDATE user SET is_booster='1' WHERE id='" . $datauserid;

        Yii::$app->db->createCommand("UPDATE user SET is_booster='0' WHERE id='" . $datauserid . "'")->execute();
    }

    // End deactivate booster plan
    // active user
    public function actionActiveuseracc() {

        $nowFormat = date('Y-m-d H:i:s');
        $notemsg = 'User activated By: ' . Yii::$app->session->get('useremail') . ':';
        $notemsg .= 'Activated On: ' . $nowFormat . ':';
        $datauserid = $_POST['userid'];


        $updated_at = date("d M Y h:i:s A");
        $sqlins = "Insert into `user_notes` SET `note` ='" . $notemsg . "', updated_at = '" . $updated_at . "', `user_id`='" . $datauserid . "', last_updated_by = '" . \Yii::$app->session->get('userid') . "'";
        Yii::$app->db->createCommand($sqlins)->execute();

        //echo "UPDATE user SET is_booster='1' WHERE id='" . $datauserid;

        Yii::$app->db->createCommand("UPDATE user SET is_deleted='0' WHERE id='" . $datauserid . "'")->execute();
    }

    // end active user
    // stripe payment link order

    public function actionStripecheckpaymentinvoice() {

        $stripeinvid = $_POST['stripeinvid'];

        $invoicedata = Yii::$app->db->createCommand("SELECT SubcriptionQty,InvoiceID FROM invoice_details where InvoiceID='$stripeinvid'")->queryOne();

        if (!empty($invoicedata) && isset($invoicedata['InvoiceID'])) {
            if (isset($invoicedata['SubcriptionQty']) && $invoicedata['SubcriptionQty'] > 0) {

                echo $invoicedata['SubcriptionQty'];
            } else {
                echo 0;
            }
        }
    }

    public function actionAddlicencetouser() {

        $emailslist = $_POST['emailslist'];
        $stripeinvid = $_POST['stripeinvid'];
        $availicencecount = $_POST['licencecount'];

        $emailslist = rtrim($emailslist, ',');
        $emailslist = ltrim($emailslist, ',');

        $emailsarray = explode(",", $emailslist);

        //echo '<prE>'; print_r($_POST);
        //echo '<prE>'; print_r($emailsarray);

        $invDetail = Yii::$app->db->createCommand("select SubcriptionQty from invoice_details  where InvoiceID ='" . $stripeinvid . "'")->queryOne();

        //echo $availicencecount."===".$invDetail['SubcriptionQty']; exit;

        if ($availicencecount <= $invDetail['SubcriptionQty']) {

            $invoicedata = Yii::$app->db->createCommand("SELECT CustomerID,SubcriptionID FROM invoice_details where InvoiceID='$stripeinvid'")->queryOne();

            $CustomerID = $invoicedata['CustomerID'];
            $SubcriptionID = $invoicedata['SubcriptionID'];

            $errorEmail = array();
            $successEmail = array();
            $Responsemsg = '';
            foreach ($emailsarray as $erow) {

                //echo '<pre>'; print_r($erow); exit;
                // echo "SELECT email,id,portal_id FROM user where portal_id = '5' AND email='$erow'"; 
                $userdata = Yii::$app->db->createCommand("SELECT email,id,portal_id FROM user where portal_id = '5' AND email='$erow'")->queryOne();

                if (!empty($userdata)) {
                    if (isset($userdata['email'])) {
                        $updateusersql = "UPDATE `user` SET `stripe_cust_id`='" . $CustomerID . "', `stripe_sub_id`= '" . $SubcriptionID . "' where portal_id = '5' AND `id`='" . $userdata['id'] . "' ";
                        Yii::$app->db->createCommand($updateusersql)->execute();

                        // update SubcriptionQty in invoice_details table 
                        $subqtyupt = $invDetail['SubcriptionQty'] - 1;
                        $sqlupt2 = Yii::$app->db->createCommand("update invoice_details set SubcriptionQty = " . $subqtyupt . " where InvoiceID = '" . $stripeinvid . "'")->execute();

                        // end 		
                        // insert entry to stripe payment history table

                        $sqlInsert = Yii::$app->db->createCommand("INSERT INTO user_payment_history_stripe set 
						userid = '" . Yii::$app->session->get('userid') . "',
						stripe_cust_id = '" . $CustomerID . "',
						stripe_sub_id = '" . $SubcriptionID . "',
						email_address = '" . $userdata['email'] . "',
						sublevel = '0',
						subscription_plan_id = '0',
						billingname = 'NA',
						billingaddress = 'NA',
						billingphone = 'NA',
						status = 'Payment Link Order'")->execute();


                        // end
                        // add usr notes in user_notes table 
                        $nowFormat = date('Y-m-d H:i:s');
                        $notemsg = 'Stripe payment link order added By: ' . Yii::$app->session->get('useremail') . ':';
                        $notemsg .= 'Added On: ' . $nowFormat . ':';
                        $datauserid = $userdata['id'];

                        $updated_at = date("d M Y h:i:s A");
                        $sqlins = "Insert into `user_notes` SET `note` ='" . $notemsg . "', updated_at = '" . $updated_at . "', `user_id`='" . $datauserid . "', last_updated_by = '" . \Yii::$app->session->get('userid') . "'";
                        Yii::$app->db->createCommand($sqlins)->execute();
                        // end


                        $successEmail[] = $erow;
                    }
                } else {

                    $errorEmail[] = $erow;
                }
            }


            if (!empty($successEmail)) {
                $Responsemsg .= "<p style='color:green;'>Licence successfully updated to: " . implode(",", $successEmail) . ".</p>";
            } else {
                $Responsemsg .= '';
            }

            if (!empty($errorEmail)) {
                $Responsemsg .= "<p style='color:red;'>These email(s) are not found: " . implode(",", $errorEmail) . ".</p>";
            } else {
                $Responsemsg .= '';
            }

            $Responsemsg .= '<p style="color:333333;">Reload page to enter new InvoiceID. <a style="color:#blue;" href="salesteam">Click Here</a></p>';
        } else {

            $Responsemsg .= "<p style='color:red;'>You don't have any licence left.</p>";
            $Responsemsg .= '<p style="color:#333333;">Reload page to enter new InvoiceID. <a style="color:blue;" href="salesteam">Click Here</a></p>';
        }

        echo $Responsemsg;

        exit;
    }

    // end payment link
    // use for Starting Trial 
    public function actionStarttrial() {

        if ((is_numeric(Yii::$app->request->post('sublevel')) || is_numeric(Yii::$app->request->post('id'))) && is_numeric(Yii::$app->request->post('trial_expired_at'))) {

            $sublevel = Yii::$app->request->post('sublevel');
            $trial_expired_at = Yii::$app->request->post('trial_expired_at');
            $id = Yii::$app->request->post('id');

//            $sql = "UPDATE `user` SET `sublevel`='" . $sublevel . "', `trial`= '1' , `trial_expired_at`='" . $trial_expired_at . "' ,  `note`= IFNULL (CONCAT( note , '* Trial started  by " . Yii::$app->session->get('useremail') . " ,  sublevel (" . $sublevel . " )  " . date("F d, Y h:i:s A", time()) . " \n' ), '* Trial started  by " . Yii::$app->session->get('useremail') . " ,  sublevel (" . $sublevel . " )  " . date("F d, Y h:i:s A", time()) . " \n' )  where `id`='" . $id . "' ";
            $sql = "UPDATE `user` SET `sublevel`='" . $sublevel . "', `trial`= '1' , `trial_expired_at`='" . $trial_expired_at . "' where `id`='" . $id . "' ";
            Yii::$app->db->createCommand($sql)->execute();

            $updated_at = date("d M Y h:i:s A");
            $notemsg = "Trial started  by " . Yii::$app->session->get('useremail') . " ,  sublevel (" . $sublevel . ")  " . date("F d, Y h:i:s A", time());
            $sqlins = "Insert into `user_notes` SET `note` ='" . $notemsg . "', updated_at = '" . $updated_at . "', `user_id`='" . $id . "', last_updated_by = '" . \Yii::$app->session->get('userid') . "'";
            Yii::$app->db->createCommand($sqlins)->execute();

            echo "1";
        }
    }

    // use for fetching user Payment History
    public function actionPaymenthistory($id) {

        if (\Yii::$app->session->get('salesperson') == 0)
            throw new \yii\web\NotFoundHttpException();

        $id = $this->decode($id);
//        echo "SELECT user_payment_history.* , user.email , user.first_name , user.last_name FROM `user_payment_history` LEFT join user ON user.id = user_payment_history.userid where `userid` = $id AND status = 'Success' ";exit;
        $user_payment_history = Yii::$app->db->createCommand("SELECT user_payment_history.* , user.email , user.first_name , user.last_name , user_order_products.product_id FROM `user_payment_history` LEFT join user ON user.id = user_payment_history.userid LEFT JOIN user_order_products ON user_payment_history.id=user_order_products.uph_id where `userid` = $id AND status = 'Success' ")->queryAll();

        $user_payment_history = Yii::$app->db->createCommand("SELECT user_payment_history.* , user.email , user.first_name , user.last_name, user.sublevel FROM `user_payment_history` LEFT join user ON user.id = user_payment_history.userid where `userid` = $id AND status = 'Success' ORDER BY user_payment_history.id DESC")->queryAll();
        return $this->render('paymenthistory', [
                    'user_payment_history' => $user_payment_history,
        ]);
    }

    public function actionPaymenthistory_nrtesting($id) {

        if (\Yii::$app->session->get('salesperson') == 0)
            throw new \yii\web\NotFoundHttpException();

        $id = $this->decode($id);
//        echo "SELECT user_payment_history.* , user.email , user.first_name , user.last_name FROM `user_payment_history` LEFT join user ON user.id = user_payment_history.userid where `userid` = $id AND status = 'Success' ";exit;
        $user_payment_history = Yii::$app->db->createCommand("SELECT user_payment_history.* , user.email , user.first_name , user.last_name , user_order_products.product_id FROM `user_payment_history` LEFT join user ON user.id = user_payment_history.userid LEFT JOIN user_order_products ON user_payment_history.id=user_order_products.uph_id where `userid` = $id AND status = 'Success' ")->queryAll();

        $user_payment_history = Yii::$app->db->createCommand("SELECT user_payment_history.* , user.email , user.first_name , user.last_name, user.sublevel FROM `user_payment_history` LEFT join user ON user.id = user_payment_history.userid where `userid` = $id AND status = 'Success' ORDER BY user_payment_history.id DESC")->queryAll();
        return $this->render('paymenthistory_nrtesting', [
                    'user_payment_history' => $user_payment_history,
        ]);
    }

    //20-01-2021
    public function actionAjx_get_orderinfo() {
        $final_result = array();
        $final_result['success'] = 1;

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            //return $this->redirect($url);
            $final_result['redirect_url'] = $url;
            $final_result['success'] = 0;
        }

        if (!isset($_POST['orderRef']) || empty($_POST['orderRef'])) {
            $final_result['error_msg'] = 'Invalid value is passed.';
            $final_result['success'] = 0;
        }

        if ($final_result['success'] == 1) {
            $OrderReferenceNumber = trim($_POST['orderRef']);
            $connection = Yii::$app->db;
            $uop_res = $connection->createCommand("SELECT t1.id as t1_pkid,t1.order_number, t1.SubscriptionReference, t2.* FROM user_order_subscriptions t1 JOIN user_order_products t2 ON t1.SubscriptionReference = t2.SubscriptionReference where t1.order_number='" . $OrderReferenceNumber . "' ORDER BY t1.id DESC")->queryAll();
            if (!empty($uop_res)) {

                $plan_array = array('LFPM' => 'Professional Monthly', 'LFPQ' => 'Professional Quarterly', 'LFGM' => 'Grow Monthly', 'LFGQ' => 'Grow Quarterly', 'LFUM' => 'Ultimate Monthly', 'LFUQ' => 'Ultimate Quarterly',
                    'LFPSAR' => 'Professional Semi-Annually', 'LFPA' => 'Professional Annually', 'LFGSAR' => 'Grow Semi-Annually', 'LFGA' => 'Grow Annually', 'LFUSAR' => 'Ultimate Semi-Annually', 'LFUA' => 'Ultimate Annually',
                    'LFPSA' => 'Professional Semi Annual Black Friday Deal', 'LFPABF' => 'Professional Annual Black Friday Plan', 'LFGSA' => 'Grow Semi-Annual Black Friday Plan', 'LFGABF' => 'Grow Annual Black Friday Plan', 'LFUSA' => 'Ultimate Semi-Annual Black Friday Plan', 'LFUABF' => 'Ultimate Annual Black Friday Plan',
                    'LFGM_v2' => 'Grow Monthly', 'LFUM_v2' => 'Ultimate Monthly', 'LFGSAR_v2' => 'Grow Semi-Annually', 'LFUSAR_v2' => 'Ultimate Semi-Annually', 'LFGA_v2' => 'Grow Annually', 'LFUA_v2' => 'Ultimate Annually', 'LFAddOnPack' => 'Booster Pack');

                $html = '<table class="table no-more-tables">';
                $html .= '<thead><tr><th>Subscription</th><th>User(s)</th></tr></thead>';

                foreach ($uop_res as $res) {
                    $UserDetail_new = Yii::$app->db->createCommand("select  email  from  user  where id IN (" . $res['user_ids'] . ") ")->queryAll();
                    $usremail = array();
                    foreach ($UserDetail_new as $urow) {
                        $usremail[] = $urow['email'];
                    }
                    $usremail_str = implode(', ', $usremail);

                    $html .= '<tr>';
                    $html .= '<td>';
                    $html .= $plan_array[$res['product_id']];
                    $html .= '</td>';
                    $html .= '<td>';
                    $html .= $usremail_str;
                    $html .= '</td>';
                    $html .= '</tr>';
                }
                $html .= '</table>';

                $final_result['success'] = 1;
                $final_result['return_html'] = $html;
            } else {
                $final_result['error_msg'] = 'Record not found.';
                $final_result['success'] = 0;
            }
            //print_r($uop_res);
        }


        echo json_encode($final_result);
    }

    //Remove expiry date
    public function actionRemoveexpirydate() {

        $seluserid = Yii::$app->request->post('seluserid');
        $notemsg = 'Expiry date removed By: ' . Yii::$app->session->get('useremail') . ':';


        $sql = "UPDATE `user` SET `trial_expired_at` = null , `trial` = 0 where `id`='" . $seluserid . "' ";
        //echo $sql;
        //die;
        Yii::$app->db->createCommand($sql)->execute();

        $updated_at = date("d M Y h:i:s A");
        $sqlins = "Insert into `user_notes` SET `note` ='" . $notemsg . "', updated_at = '" . $updated_at . "', `user_id`='" . $seluserid . "', last_updated_by = '" . \Yii::$app->session->get('userid') . "'";
        Yii::$app->db->createCommand($sqlins)->execute();
    }

    public function actionGetusernotes() {
        $seluserid = Yii::$app->request->post('seluserid');

        $Usernotes = Yii::$app->db->createCommand("SELECT note,updated_at,user_id FROM `user_notes` WHERE `user_id` = '" . $seluserid . "'")->queryAll();

        //echo '<pre>'; print_r($Usernotes); exit; 

        $oldUsernotes = Yii::$app->db->createCommand("SELECT note FROM `user` WHERE `id` = '" . $seluserid . "'")->queryAll();

        $cretedon = Yii::$app->db->createCommand("SELECT created_at FROM `user` WHERE `id` = '" .$seluserid ."'")->queryOne();
		

        $lastuseddate = Yii::$app->db->createCommand("SELECT updated_at FROM `blacklist` WHERE `userid` = '" . $seluserid . "' ORDER BY `updated_at` DESC limit 1")->queryAll();

        if (!empty($lastuseddate)) {
            echo '<div style="width:100%; text-align:right; padding-right: 5px;"><b class="primary">User created on </b> '.date('Y-m-d', $cretedon['created_at']).' | <b class="primary"> Last used on </b>' . $lastuseddate[0]['updated_at'] . '</div>';
        }
        echo '<ul>';
        if (!empty($oldUsernotes)) {
            foreach ($oldUsernotes as $key1 => $value1) {
                if ($value1['note'] != '') {
                    echo '<li style="margin-bottom: 5px;"><b style="color: red;">Old Note: </b> ' . $value1['note'] . '</li>';
                }
            }
        }

        $i = 1;
        if (!empty($Usernotes)) {

            foreach ($Usernotes as $key => $value) {

                echo '<li style="margin-bottom: 5px;"><b style="color: red;">' . $i . '.</b> ' . $value['note'] . ' - <small style="color: #337ab7;" > ' . $value['updated_at'] . '</small></li>';
                $i++;
            }
        } else {
            echo '<li>No new notes.</li>';
        }
        echo '</ul>';
    }

    public function actionUpdateusernotes() {
        $noteuserid = Yii::$app->request->post('noteuserid');
        $UsernoteText = Yii::$app->request->post('UsernoteText');
        $notemsg = $UsernoteText;
        $updated_at = date("d M Y h:i:s A");

        $notemsg = str_replace("'", "", $notemsg);

        $sqlins = "Insert into `user_notes` SET `note` ='" . $notemsg . "', updated_at = '" . $updated_at . "', `user_id`='" . $noteuserid . "', last_updated_by = '" . \Yii::$app->session->get('userid') . "'";

        Yii::$app->db->createCommand($sqlins)->execute();

        if (Yii::$app->session->get('portal_id') == "2") {
            $useremail = Yii::$app->session->get('useremail');
//        $toemail = 'ravi@intricare.net';
            $toemail = 'dhaval.thakor@intricare.net';

            $html = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd"> <html lang="en"> <head> <meta http-equiv="content-type" content="text/html; charset=utf-8"> <title>' . Yii::$app->params['emailFromName'] . ' - New Note Added</title> </head> <body>
		<table width="100%">
			<tr><td><b>Note:</b> ' . $notemsg . '</td></tr>
			<tr><td><b>Added By:</b> ' . $useremail . '</td></tr>
		</table>
		</body> </html>';

            $mail = Yii::$app->mailer->compose()
                    ->setTo($toemail)
                    ->setBcc('binita@intricare.net')
                    //->setFrom(['dhaval.thakor@intricare.net'=>'Dhaval Thakor'])
                    ->setFrom([Yii::$app->params['adminEmail'] => 'Arpan Shah'])
                    //->setReplyTo()
                    ->setSubject(Yii::$app->params['emailFromName'] . ' - New Note Added')
                    ->setHtmlBody($html, 'text/html');
            $mail->send();
        }
    }

    public function actionShowadmin() {
        $id = $_POST['userId'];
        $sublevelQry = Yii::$app->db->createCommand("SELECT email FROM user where id='$id'")->queryOne();
        return $sublevelQry['email'];
    }

    public function actionGetmsgslist() {
        $userid = $_REQUEST['userId'];
        $Keywordname = '';
        if (isset($_REQUEST['Keywordname']) && $_REQUEST['Keywordname'] != '') {
            $Keywordname = $_REQUEST['Keywordname'];
        }
        if ($Keywordname != '') {
            $srchQur = " AND `message` LIKE '%" . $Keywordname . "%'";
        } else {
            $srchQur = '';
        }
        $getdata = Yii::$app->db->createCommand("SELECT id FROM ext_sequences where user_id='" . $userid . "'")->queryAll();
        $k = 1;
        $msgHtml = '';
        if (!empty($getdata)) {
            $msgHtml .= '<table style="width:100%;height: 400px;overflow: auto;display: block;font-size: 14px;">';
            foreach ($getdata as $row) {
                $getext_stepsdata = Yii::$app->db->createCommand("SELECT message FROM ext_steps where seqId='" . $row['id'] . "' $srchQur")->queryAll();
                $i = 1;
                if (!empty($getext_stepsdata)) {
                    $msgHtml .= '<tr><td style="vertical-align: top;text-align: center;padding-bottom: 10px;"><b>Sequence: ' . $k . '</b></br></td></tr><tr><td>';
                    $msgHtml .= '<ul style="width:100%;">';
                    foreach ($getext_stepsdata as $data) {
                        $msgHtml .= '<li><p>' . $i . ') ' . $data['message'] . '</p></li>';
                        $i++;
                    }
                    $msgHtml .= '</ul>';
                    $msgHtml .= '</td></tr>';
                    $msgHtml .= '<tr><td><hr></td></tr>';
                }
                $k++;
            }
            $msgHtml .= '</table>';
        } else {
            $msgHtml .= 'No message found!';
        }
        return $msgHtml;
    }

    public function actionExport() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $portalId = $_GET['portal'];
        $portalQry = Yii::$app->db->createCommand("SELECT sitetitle FROM portals where id='$portalId'")->queryOne();


        if ($_GET['export_option'] == "Active") {
            $exportData = Yii::$app->db->createCommand("SELECT id,username,email,sublevel,trial_expired_at,portal_id FROM user where portal_id='" . $portalId . "' AND sublevel !='0' AND (from_unixtime((trial_expired_at / 1000), '%Y-%m-%d') >= from_unixtime(UNIX_TIMESTAMP(),'%Y-%m-%d') OR trial_expired_at IS NULL)")->queryAll();
        } else {
            $exportData = Yii::$app->db->createCommand("SELECT id,username,email,sublevel,trial_expired_at,portal_id FROM user where portal_id='" . $portalId . "' AND trial_expired_at != '' AND sublevel!='0' AND from_unixtime((trial_expired_at / 1000), '%Y-%m-%d') < from_unixtime(UNIX_TIMESTAMP(),'%Y-%m-%d') AND from_unixtime((trial_expired_at / 1000), '%Y-%m-%d') >= from_unixtime(UNIX_TIMESTAMP(DATE_SUB(NOW(), INTERVAL 1 month))) AND from_unixtime((trial_expired_at / 1000), '%Y-%m-%d') <= from_unixtime(UNIX_TIMESTAMP(),'%Y-%m-%d')")->queryAll();
        }

        if ($_GET['export_option'] == "Active") {
            $csv_data = "Monthly Active User ,,,,\r\n\r\nPortal:," . $portalQry['sitetitle'] . "\r\nDate:," . date('Y-m-d') . "\r\n\r\n,\r\nUser Name,Email,Current Plan,Notes,Expired At\n";
        } else {
            $csv_data = "Monthly Expired User ,,,,\r\n\r\nPortal:," . $portalQry['sitetitle'] . "\r\nDate:," . date('Y-m-d') . "\r\n\r\n,\r\nUser Name,Email,Current Plan,Notes,Expired On\n";
        }

        foreach ($exportData as $data_export) {
            $username = $data_export['username'];
            $email = $data_export['email'];
            $sublevel = $data_export['sublevel'];
            if (!empty($data_export['trial_expired_at'])) {
                $trial_expired_at = date(("F j Y g:i a"), $data_export['trial_expired_at'] / 1000);
            } else {
                $trial_expired_at = "N/A";
            }
            $sublevelQry = Yii::$app->db->createCommand("SELECT name FROM lead_plans where sublevel='$sublevel'")->queryOne();
            $i = 1;
            $note = "";
            $user_notesQry = Yii::$app->db->createCommand("SELECT note,updated_at FROM user_notes where user_id='" . $data_export['id'] . "'")->queryAll();
            if (count($user_notesQry) > 0) {
                foreach ($user_notesQry as $user_notes) {
                    $note .= "--" . $i . ". " . str_replace(",", "", $user_notes['note']) . " " . $user_notes['updated_at'];
                    $i++;
                }
            } else {
                $note = "N/A";
            }
            $csv_data .= $username . ',' . $email . ',' . $sublevelQry['name'] . "," . $note . "," . $trial_expired_at . "\r\n";
        }

        $fileName = $portalQry['sitetitle'] . $_GET['export_option'] . "Users";

        header("Content-type: text/csv");
        header("Content-Disposition: attachment; filename=" . $fileName . ".csv");
        header("Pragma: no-cache");
        header("Expires: 0");
        echo $csv_data . "\n";
        die;
    }

    public function actionSuperadminlogin() {
        include '../web/updateLinkedInCookie.php';
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $UserID = $_POST['UserID'];
        $sql = Yii::$app->db->createCommand("select * from user where id='$UserID'")->queryOne();
        if (!empty($sql)) {

            $adminEmail = Yii::$app->session->get('useremail');
            $adminID = Yii::$app->session->get('userid');

            Yii::$app->session->remove('useremail');
            Yii::$app->session->remove('teamid');
            Yii::$app->session->remove('userid');
            Yii::$app->session->remove('username');
            Yii::$app->session->remove('__returnUrl');
            Yii::$app->session->remove('__id');
            Yii::$app->session->remove('salesperson');
//            Yii::$app->session->remove('loggedinwith_subusers');
            Yii::$app->session->remove('loggedinwith_superadmin');
//            Yii::$app->session->remove('user_role');


            $useremail = $sql['email'];
            $username = $sql['username'];
            $userid = $sql['id'];
            $teamid = $sql['teamid'];
            $first_name = $sql['first_name'];
            $last_name = $sql['last_name'];
            $companyname = $sql['companyname'];
            $last_login_at = $sql['last_login_at'];
            $portal_id = $sql['portal_id'];
            $salesperson = $sql['salesperson'];


            Yii::$app->session->set('useremail', $useremail);
            Yii::$app->session->set('username', $username);
            Yii::$app->session->set('userid', $userid);
            Yii::$app->session->set('teamid', $teamid);
            Yii::$app->session->set('first_name', $first_name);
            Yii::$app->session->set('last_name', $last_name);
            Yii::$app->session->set('companyname', $companyname);
//            Yii::$app->session->set('google', '1');
            Yii::$app->session->set('last_login_at', $last_login_at);
            Yii::$app->session->set('portal_id', $portal_id);
            Yii::$app->session->set('adminEmail', $adminEmail);
            Yii::$app->session->set('adminID', $adminID);
            Yii::$app->session->set('salesperson', $salesperson);
//            Yii::$app->session->set('user_role',$sql['user_role']);
//            Yii::$app->session->set('loggedinwith_subusers', "true");
            Yii::$app->session->set('loggedinwith_superadmin', "true");

            $last_login_at = Yii::$app->db->createCommand("update `user` SET `last_login_at`=" . time() . " where `id`=" . $UserID)->execute();

            $proxyIp = $sql['proxyIp'];
            $proxyPort = $sql['proxyPort'];
            $proxyUsername = $sql['proxyUsername'];
            $proxyPassword = $sql['proxyPassword'];
            $cookie = $sql['cookie'];
            $csrf = $sql['csrf'];
            if (!empty($proxyIp) && !empty($proxyPort) && !empty($proxyUsername) && !empty($proxyPassword) && !empty($cookie) && !empty($csrf)) {
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/me",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    //CURLOPT_VERBOSE => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: Mozilla/5.0 (Windows NT 6.1; rv:75.0) Gecko/20100101 Firefox/75.0",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $curlResult = curl_exec($curl);
                $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                $headers = substr($curlResult, 0, $header_size);
                $curlResult = substr($curlResult, $header_size);
                $newCookie = getCookiesLdnFromHeaders($headers);
                if (!empty($newCookie)) {
                    updateUserLdnCookies($UserID, $newCookie);
                }
                //echo '<pre>';print_r($curlResult); die;
                if (!empty($curlResult)) {
                    $decodedRes = json_decode($curlResult);
                    if (!empty($decodedRes->miniProfile->picture)) {
                        $picture = (array) $decodedRes->miniProfile->picture;
                        $topProfilePic = $picture['com.linkedin.common.VectorImage']->rootUrl . $picture['com.linkedin.common.VectorImage']->artifacts[0]->fileIdentifyingUrlPathSegment;
                        Yii::$app->session->set('top_profile_pic', $topProfilePic);
                        Yii::$app->session->set('linkedin_firstname', $decodedRes->miniProfile->firstName);
                        Yii::$app->session->set('linkedin_lastname', $decodedRes->miniProfile->lastName);
                    } else {
                        Yii::$app->session->set('top_profile_pic', '');
                    }
                } else {
                    Yii::$app->session->set('top_profile_pic', '');
                }
            } else {
                Yii::$app->session->set('top_profile_pic', '');
            }
            return "1";
        } else {
            return "0";
        }
    }

    function encode($string, $key = "LEADCONNECTCLOUD2020") {
        $key = sha1($key);
        $strLen = strlen($string);
        $keyLen = strlen($key);
        $j = 0;
        $hash = "";
        for ($i = 0; $i < $strLen; $i++) {
            $ordStr = ord(substr($string, $i, 1));
            if ($j == $keyLen) {
                $j = 0;
            }
            $ordKey = ord(substr($key, $j, 1));
            $j++;
            $hash .= strrev(base_convert(dechex($ordStr + $ordKey), 16, 36));
        }
        return $hash;
    }

    function decode($string, $key = "LEADCONNECTCLOUD2020") {
        $key = sha1($key);
        $strLen = strlen($string);
        $keyLen = strlen($key);
        $j = 0;
        $hash = "";
        for ($i = 0; $i < $strLen; $i += 2) {
            $ordStr = hexdec(base_convert(strrev(substr($string, $i, 2)), 36, 16));
            if ($j == $keyLen) {
                $j = 0;
            }
            $ordKey = ord(substr($key, $j, 1));
            $j++;
            $hash .= chr($ordStr - $ordKey);
        }
        return $hash;
    }

    // Delete user 

    public function actionReleaseipinfotest() {
		exit;
		$proxyDatas = Yii::$app->db->createCommand("SELECT proxyUsername,id FROM user where popupstatus=0 and proxyUsername !=''")->queryAll(); 
		foreach($proxyDatas as $proxyData){ 
			if (!empty($proxyData['proxyUsername'])) {

				$notemsg = "Users Ip released by " . Yii::$app->session->get('useremail');

				$sqlins2 = "Insert into `user_notes` SET `note` ='" . $notemsg . "',`user_id`='" . $userid . "', last_updated_by = '" . \Yii::$app->session->get('userid') . "', updated_at = '" . $updated_at . "'";
				Yii::$app->db->createCommand($sqlins2)->execute();

				$UserProxyDetail = explode("-", $proxyData['proxyUsername']);
				$zoneName = $UserProxyDetail[4];
				$iP = $UserProxyDetail[6];
				if (!empty($iP) && !empty($zoneName)) {
					$ch_deleteIp = curl_init();
					curl_setopt($ch_deleteIp, CURLOPT_URL, 'https://luminati.io/api/zone/ips');
					curl_setopt($ch_deleteIp, CURLOPT_RETURNTRANSFER, 1);
					curl_setopt($ch_deleteIp, CURLOPT_CUSTOMREQUEST, 'DELETE');
					curl_setopt($ch_deleteIp, CURLOPT_POSTFIELDS, "{\"customer\":\"hl_4b7d4696\",\"zone\":\"$zoneName\",\"ips\":[\"$iP\"]}");
					$headers = array();
					$headers[] = 'Content-Type: application/json';
					//$headers[] = 'Authorization: Bearer c2b5593e-9399-4607-b4f1-8b3f35aa9ae7';
					$headers[] = 'Authorization: Bearer e18c02a4-2520-4e94-b19a-fc70efd2f36c';
					curl_setopt($ch_deleteIp, CURLOPT_HTTPHEADER, $headers);
					$result_deleteIp = curl_exec($ch_deleteIp);
					if (curl_errno($ch_deleteIp)) {
						echo 'Error:' . curl_error($ch_deleteIp);
					} else {
						Yii::$app->db->createCommand("UPDATE user SET proxyIp='',`proxyPort` = NULL,`proxyUsername`=NULL,proxyPassword=NULL,popupstatus='0',app_container='',app_container_ip=NULL,app_container_port='' WHERE id=" . $proxyData['id'])->execute();
						Yii::$app->db->createCommand("UPDATE Luminati_IP_Info SET Ip_ReleaseOn='" . date("Y-m-d H:i:s") . "' WHERE Ip_address='" . $iP . "' and userId=" . $proxyData['id'])->execute();
					}
					curl_close($ch_deleteIp);
				} 
			}
		}
	}
    public function actionReleaseipinfo() {
        $userid = $_REQUEST['userId'];
        $updated_at = date("d M Y h:i:s A");
        $proxyData = Yii::$app->db->createCommand("SELECT proxyUsername,id FROM user where id='$userid'")->queryOne();
        if (!empty($proxyData['proxyUsername'])) {

            $notemsg = "Users Ip released by " . Yii::$app->session->get('useremail');

            $sqlins2 = "Insert into `user_notes` SET `note` ='" . $notemsg . "',`user_id`='" . $userid . "', last_updated_by = '" . \Yii::$app->session->get('userid') . "', updated_at = '" . $updated_at . "'";
            Yii::$app->db->createCommand($sqlins2)->execute();

            $UserProxyDetail = explode("-", $proxyData['proxyUsername']);
            $zoneName = $UserProxyDetail[4];
            $iP = $UserProxyDetail[6];
            if (!empty($iP) && !empty($zoneName)) {
                $ch_deleteIp = curl_init();
                curl_setopt($ch_deleteIp, CURLOPT_URL, 'https://luminati.io/api/zone/ips');
                curl_setopt($ch_deleteIp, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch_deleteIp, CURLOPT_CUSTOMREQUEST, 'DELETE');
                curl_setopt($ch_deleteIp, CURLOPT_POSTFIELDS, "{\"customer\":\"hl_4b7d4696\",\"zone\":\"$zoneName\",\"ips\":[\"$iP\"]}");
                $headers = array();
                $headers[] = 'Content-Type: application/json';
                //$headers[] = 'Authorization: Bearer c2b5593e-9399-4607-b4f1-8b3f35aa9ae7';
				$headers[] = 'Authorization: Bearer e18c02a4-2520-4e94-b19a-fc70efd2f36c';
                curl_setopt($ch_deleteIp, CURLOPT_HTTPHEADER, $headers);
                $result_deleteIp = curl_exec($ch_deleteIp);
                if (curl_errno($ch_deleteIp)) {
                    echo 'Error:' . curl_error($ch_deleteIp);
                } else {
                    Yii::$app->db->createCommand("UPDATE user SET proxyIp='',`proxyPort` = NULL,`proxyUsername`=NULL,proxyPassword=NULL,popupstatus='0',app_container='',app_container_ip=NULL,app_container_port='' WHERE id=" . $proxyData['id'])->execute();
                    Yii::$app->db->createCommand("UPDATE Luminati_IP_Info SET Ip_ReleaseOn='" . date("Y-m-d H:i:s") . "' WHERE Ip_address='" . $iP . "' and userId=" . $proxyData['id'])->execute();
                }
                curl_close($ch_deleteIp);
            }
        }
    }

    public function actionVerifyuserip() {
        $userid = $_REQUEST['userId'];
        $updated_at = date("d M Y h:i:s A");
        $proxyData = Yii::$app->db->createCommand("SELECT proxyUsername,id,proxyPassword,proxyPort FROM user where id='$userid'")->queryOne();
        if (!empty($proxyData['proxyUsername'])) {


            //$proxyip = $proxyData['proxyUsername'].':'.$proxyData['proxyPassword'];

            $proxyUsername = $proxyData['proxyUsername'];
            $proxyPassword = $proxyData['proxyPassword'];

            //$proxyUsername = 'proxy-user lum-customer-c_5b864891-zone-us-ip-188.119.126.34';
            //$proxyPassword = '4mxrcxekdkl1';
            $proxyPort = $proxyData['proxyPort'];
            $user_agent = $proxyData['userAgent'];
            $session = mt_rand();
            $proxyIp = 'zproxy.lum-superproxy.io';
            $curl = curl_init();


            curl_setopt_array($curl, array(
                CURLOPT_URL => 'http://lumtest.com/myip.json',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_PROXY => "$proxyIp",
                CURLOPT_PROXYPORT => "$proxyPort",
                CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
            ));
            $response = curl_exec($curl);
            $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            curl_close($curl);
            echo $httpcode;
        }
    }

    public function actionGetdeleteuser() {
        $userid = $_REQUEST['userId'];
        $updated_at = date("d M Y h:i:s A");
        $sqlins = "UPDATE `user` SET `is_deleted` = '1' where `id`='" . $userid . "'";
        Yii::$app->db->createCommand($sqlins)->execute();
        $notemsg = "User deleted by " . Yii::$app->session->get('useremail');

        $sqlins2 = "Insert into `user_notes` SET `note` ='" . $notemsg . "',`user_id`='" . $userid . "', last_updated_by = '" . \Yii::$app->session->get('userid') . "', updated_at = '" . $updated_at . "'";
        Yii::$app->db->createCommand($sqlins2)->execute();

        $proxyData = Yii::$app->db->createCommand("SELECT proxyUsername,id FROM user where id='$userid'")->queryOne();
        if (!empty($proxyData['proxyUsername'])) {
            $UserProxyDetail = explode("-", $proxyData['proxyUsername']);
            $zoneName = $UserProxyDetail[4];
            $iP = $UserProxyDetail[6];
            if (!empty($iP) && !empty($zoneName)) {
                $ch_deleteIp = curl_init();
                curl_setopt($ch_deleteIp, CURLOPT_URL, 'https://luminati.io/api/zone/ips');
                curl_setopt($ch_deleteIp, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch_deleteIp, CURLOPT_CUSTOMREQUEST, 'DELETE');
                curl_setopt($ch_deleteIp, CURLOPT_POSTFIELDS, "{\"customer\":\"hl_4b7d4696\",\"zone\":\"$zoneName\",\"ips\":[\"$iP\"]}");
//                curl_setopt($ch_deleteIp, CURLOPT_USERPWD, 'arpan@halfpixel.co.in' . ':' . 'Asdf@123');
                $headers = array();
                $headers[] = 'Content-Type: application/json';
                //$headers[] = 'Authorization: Bearer c2b5593e-9399-4607-b4f1-8b3f35aa9ae7';
				$headers[] = 'Authorization: Bearer e18c02a4-2520-4e94-b19a-fc70efd2f36c';
                curl_setopt($ch_deleteIp, CURLOPT_HTTPHEADER, $headers);
                $result_deleteIp = curl_exec($ch_deleteIp);
                if (curl_errno($ch_deleteIp)) {
                    echo 'Error:' . curl_error($ch_deleteIp);
                } else {
                    Yii::$app->db->createCommand("UPDATE user SET proxyIp='',`proxyPort` = NULL,`proxyUsername`=NULL,proxyPassword=NULL,popupstatus='0',app_container='',app_container_ip=NULL,app_container_port='' WHERE id=" . $proxyData['id'])->execute();
                    Yii::$app->db->createCommand("UPDATE Luminati_IP_Info SET Ip_ReleaseOn='" . date("Y-m-d H:i:s") . "' WHERE Ip_address='" . $iP . "' and userId=" . $proxyData['id'])->execute();
                }
                curl_close($ch_deleteIp);
            }
        }
    }

    public function actionConfirmedaccountmanually() {
        $userid = $_REQUEST['userId'];
        $currenttime = time();
        $updated_at = date("d M Y h:i:s A");
        $sqlins = "UPDATE `user` SET `confirmed_at` = '" . $currenttime . "' where `id`='" . $userid . "'";
        Yii::$app->db->createCommand($sqlins)->execute();
        $notemsg = "User confirmed by " . Yii::$app->session->get('useremail');

        $sqlins2 = "Insert into `user_notes` SET `note` ='" . $notemsg . "',`user_id`='" . $userid . "', last_updated_by = '" . \Yii::$app->session->get('userid') . "', updated_at = '" . $updated_at . "'";
        Yii::$app->db->createCommand($sqlins2)->execute();
    }

    public function actionGetupdateuser() {
        $userid = $_REQUEST['userId'];
        $updated_at = date("d M Y h:i:s A");
        $sqlins = "UPDATE `user` SET `is_deleted` = '0' where `id`='" . $userid . "'";
        Yii::$app->db->createCommand($sqlins)->execute();
        $notemsg = "User Active by " . Yii::$app->session->get('useremail');

        $sqlins2 = "Insert into `user_notes` SET `note` ='" . $notemsg . "',`user_id`='" . $userid . "', last_updated_by = '" . \Yii::$app->session->get('userid') . "', updated_at = '" . $updated_at . "'";
        Yii::$app->db->createCommand($sqlins2)->execute();
    }

    public function actionGetuserlinkedinprofile() {
        $id = $_POST['userId'];
        $user_cnt_type = $_POST['user_cnt_type'];
        $linkedin_email = "";
        $firstName = "";
        $lastName = "";
        $ProfilePic400_400 = "";
		//gpornt
		$premiumSubscriber=0;
		$user = Yii::$app->db->createCommand("SELECT usrprfl.linkedin_email, usrprfl.linkedin_password, usrprfl.firstName, usrprfl.lastName, usr.csrf, usr.cookie, usr.first_name,  usr.serviceVersion, usr.email, usr.portal_id, usr.geoUpdate, usr.proxyIp,usr.proxyPort, usr.proxyUsername, usr.proxyPassword, usr.userAgent from user_profile usrprfl, user usr where usrprfl.user_id = usr.id AND usr.popupstatus=1 AND usr.id=" . $id)->queryOne();
		if(!empty($user)){
			$proxyIp = $user['proxyIp'];
			$proxyPort = $user['proxyPort'];
			$proxyUsername = $user['proxyUsername'];
			$proxyPassword = $user['proxyPassword'];
			$userAgent = $user['userAgent']; 
			$csrf = $user['csrf'];
			$cookie = $user['cookie']; 	   
					
			$profileContactInfo = curl_init();
			curl_setopt_array($profileContactInfo, array(
				CURLOPT_URL => "https://www.linkedin.com/voyager/api/me",
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 30,
				CURLOPT_HEADER => 1,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_HTTPPROXYTUNNEL => 1,
				CURLOPT_PROXY => "$proxyIp",
				CURLOPT_PROXYPORT => "$proxyPort",
				CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
				CURLOPT_CUSTOMREQUEST => "GET",
				CURLOPT_HTTPHEADER => array(
					"authority: www.linkedin.com",
					"User-Agent: $userAgent",
					"Accept: application/vnd.linkedin.normalized+json+2.1",
					"Accept-Language: en-US,en;q=0.9",
					"Accept-Encoding: gzip, deflate, br",
					"cookie: $cookie",
					"csrf-token: $csrf",
					"x-li-lang: en_US",
					"x-restli-protocol-version: 2.0.0"
				)
			)); 

			$resCurlProfile = curl_exec($profileContactInfo);
			$header_size = curl_getinfo($profileContactInfo, CURLINFO_HEADER_SIZE);
			$headers = substr($resCurlProfile, 0, $header_size);
			$resCurlProfile = substr($resCurlProfile, $header_size); 
			$http_code = curl_getinfo($profileContactInfo, CURLINFO_HTTP_CODE);
			if($http_code == 200){
				$eventResponse=json_decode($resCurlProfile);
				$premiumSubscriber=(!empty($eventResponse->data->premiumSubscriber))??0;
			}
		}
        if (isset($_POST['userId']) && $_POST['userId'] != '') {
            $sublevelQry = Yii::$app->db->createCommand("SELECT firstName,lastName,linkedin_email,ProfilePic400_400 FROM user_profile where user_id='$id'")->queryOne();
			
			$proxyData = Yii::$app->db->createCommand("SELECT proxyUsername,id,proxyPassword,proxyPort FROM user where id='$id'")->queryOne();
			
			///echo '<pre>'; print_r($proxyData); exit;

            $linkedin_email = $sublevelQry['linkedin_email'];
            $firstName = $sublevelQry['firstName'];
            $lastName = $sublevelQry['lastName'];
            $ProfilePic400_400 = $sublevelQry['ProfilePic400_400'];

            if ($user_cnt_type == 'Disconnected') {
                $usercnttypeclr = 'red';
            } else {
                $usercnttypeclr = 'green';
            }

			$prmim='';
			if ($premiumSubscriber == 1) {
                $prmim = ' border: 5px solid orange;';
            }

            echo '<div class="col-md-12">
						<div class="ProfilePicBlk text-center">
							<div class="imgMinBlk">
								<h5 class="clsLinkedIn_fullName" style="color:' . $usercnttypeclr . ';">' . $user_cnt_type . '</h5>';
            if ($ProfilePic400_400 != '') {
                echo '<img class="clsProfilePic400_400" style="width:150px;'.$prmim.'" src="' . $ProfilePic400_400 . '">';
            }
            echo '</div>';

            echo '<div class="profileDetailblk">';
            if ($firstName != '') {
                echo '<h5 class="clsLinkedIn_fullName" style="margin-top: 10px;">' . $firstName . ' ' . $lastName . '</h5>';
            }
            if ($linkedin_email != '') {
                echo '<h5 class="clsLinkedIn_fullName">' . $linkedin_email . '</h5>';
            }
			if(isset($proxyData['proxyUsername'])){
				
				//echo '<h6><strong>IP:</strong>'.$proxyData['proxyUsername'].'</h6>';
			}
            echo '</div>';

            echo '</div></div>';
        }
    }

    public function actionChangeonboardingstatus() {

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $onboarduserid = 0;
        $onboardstatus = 0;
        if (isset($_POST['onboarduserid']) && $_POST['onboarduserid'] != '') {
            $onboarduserid = $_POST['onboarduserid'];
        }

        if (isset($_POST['onboardstatus']) && $_POST['onboardstatus'] != '') {
            $onboardstatus = $_POST['onboardstatus'];
        }

        if ($onboarduserid != 0 && $onboardstatus != 0) {

            $sqlins = "UPDATE `user` SET `entry_fee` = '" . $onboardstatus . "' where `id`='" . $onboarduserid . "'";
            Yii::$app->db->createCommand($sqlins)->execute();
        }

        //echo '<prE>'; print_r($_POST); exit;
    }
	
	public function actionMakeadminusercall(){
		
		 if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		
		$userid = $_POST['userid'];
		
		$sqlins = "UPDATE `user` SET `teamid` = '" . $userid . "' where `id`='" . $userid . "'";
        Yii::$app->db->createCommand($sqlins)->execute();
		
		$sqlinsblk = "UPDATE `blacklist` set teamid = '".$userid."' WHERE `userid` = '".$userid."'";
        Yii::$app->db->createCommand($sqlinsblk)->execute();
		echo 1;
		//echo '<pre>'; print_r($_POST); exit;		
	}

    public function actionGetlistofqueuedsubuser() {

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $admin_user_id = $_POST['admin_user_id'];

        $subuserdata = Yii::$app->db->createCommand("SELECT userby,admin_id,subuser_id,status,created_at FROM schedule_subusers where admin_id = '" . $admin_user_id . "'")->queryAll();

        $html = '<table class="table table-striped table">';

        if (!empty($subuserdata)) {



            $html .= '<tr>';
            $html .= '<th style="padding: 1rem 1rem; text-align: center;">Admin</th>';
            $html .= '<th style="padding: 1rem 1rem; text-align: center;">Subuser</th>';
            $html .= '<th style="padding: 1rem 1rem; text-align: center;">Status</th>';
            $html .= '<th style="padding: 1rem 1rem; text-align: center;">Created On</th>';
            $html .= '</tr>';
            $status = '';
            foreach ($subuserdata as $row) {

                $getadminemailid = Yii::$app->db->createCommand("SELECT email FROM user where id = '" . $row['admin_id'] . "'")->queryOne();
                $getsubuseremailid = Yii::$app->db->createCommand("SELECT email FROM user where id = '" . $row['subuser_id'] . "'")->queryOne();


                if ($row['status'] == 0) {

                    $status = 'Pending';
                } else {
                    $status = 'Completed';
                }

                $html .= '<tr>';
                $html .= '<td style="padding: 10px;font-size: 14px;text-align: center;">' . $getadminemailid['email'] . '</td>';
                $html .= '<td style="padding: 10px;font-size: 14px;text-align: center;">' . $getsubuseremailid['email'] . '</td>';
                $html .= '<td style="padding: 10px;font-size: 14px;text-align: center;">' . $status . '</td>';
                $html .= '<td style="padding: 10px;font-size: 14px;text-align: center;">' . date("Y-m-d", strtotime($row['created_at'])) . '</td>';
                $html .= '</tr>';
            }
        } else {
            $html .= '<tr>';
            $html .= '<td colspan="4">No records found!</td>';
            $html .= '</tr>';
        }

        $html .= '<table>';

        echo $html;
    }

    public function actionChksubuseremail() {

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $subuserid = 0;
        $admin_user_id = $_POST['admin_user_id'];
        $portalId = $_POST['portal_id'];
        $emailID = $_POST['useremail'];
        $emailID = str_replace(' ', '', $emailID);
        $emaildata = Yii::$app->db->createCommand("SELECT email,id,teamid FROM user where portal_id = '" . $portalId . "' AND email = '" . $emailID . "'")->queryOne();
        if (isset($emaildata['email']) && $emaildata['email'] != '') {

            if ($emaildata['id'] == $emaildata['teamid']) {

                //$subuserid = 1; // chk for subuser if admin

                $subusercnt = Yii::$app->db->createCommand("SELECT COUNT(id) as totalSubusr FROM user where teamid = '" . $emaildata['id'] . "'")->queryOne();


                if (isset($subusercnt['totalSubusr']) && $subusercnt['totalSubusr'] > 1) {

                    $subuserid = 1; // admin has subuser		
                } else {

                    $subuserid = $emaildata['id'];

                    $subuserqry = "Insert into `schedule_subusers` SET `userby` ='" . \Yii::$app->session->get('userid') . "',`admin_id`='" . $admin_user_id . "', subuser_id = '" . $subuserid . "'";
                    Yii::$app->db->createCommand($subuserqry)->execute();
                }
            } else {


                if ($emaildata['teamid'] == $admin_user_id) {

                    $subuserid = 1;
                } else {
                    $subuserid = $emaildata['id']; // add subuser

                    $subuserqry = "Insert into `schedule_subusers` SET `userby` ='" . \Yii::$app->session->get('userid') . "',`admin_id`='" . $admin_user_id . "', subuser_id = '" . $subuserid . "'";
                    Yii::$app->db->createCommand($subuserqry)->execute();
                }

                //echo $subuserqry;
            }
        }

        echo $subuserid = str_replace(' ', '', $subuserid);
    }

    public function actionBuy_link_entry_form_BkpMethodBeforeAddOnPackProduct() {
        die;
        if (\Yii::$app->request->post() && \Yii::$app->request->post('ble_orderRef')) {
            //echo '<pre>';print_r($_POST);die;

            $OrderReferenceNumber = trim(Yii::$app->request->post('ble_orderRef'));
            $orderPlacedByEmail = trim(Yii::$app->request->post('ble_userEmail'));

            $final_result = array();
            $final_result['success'] = 1;

            if (!Yii::$app->session->get('useremail')) {
                $url = \Yii::$app->request->baseUrl . "/login";
                //return $this->redirect($url);
                $final_result['redirect_url'] = $url;
                $final_result['success'] = 0;
            }

            if (empty($OrderReferenceNumber) || empty($orderPlacedByEmail)) {
                $final_result['error_msg'] = 'All fields are required.';
                $final_result['success'] = 0;
            }

            if ($final_result['success']) {

                //echo '<pre>'; print_r($_POST);echo '</pre>';

                if (YII_ENV_PROD) {
                    //production
                    $merchantCode = "203537015";
                    $key = 'd?q4rkG]&KAh#vwnmSJ%';
                } else {
                    //staging
                    $merchantCode = "251108887711"; // your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
                    $key = '!G2S8WRBKJ6#&c~luOz='; // your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
                }

                $gmdate = gmdate('Y-m-d H:i:s');
                $string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
                $hashAlgorithm = 'sha256';
                $hash = hash_hmac($hashAlgorithm , $string, $key);

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/' . $OrderReferenceNumber . '/');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

                $headers = array();
                $headers[] = 'Accept: application/json';
                $headers[] = 'Content-Type: application/json';
                $headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
                
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                $curl_result = curl_exec($ch);

                $curlResult = json_decode($curl_result);
                //echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
                if (curl_errno($ch)) {
                    //echo 'Error:' . curl_error($ch);
                }
                curl_close($ch);
                //echo '<br/>';

                if (isset($curlResult->error_code)) {
                    $final_result['error_msg'] = $curlResult->message;
                    $final_result['success'] = 0;
                } else if ($curlResult) {

                    $connection = Yii::$app->db;

                    $isDuplicateMerchantID = false;
                    if (!empty($curlResult->ExternalReference)) {
                        $chk_extRef = $connection->createCommand("select id from user_payment_history where order_number!='" . $OrderReferenceNumber . "' and merchant_id='" . $curlResult->ExternalReference . "'  ORDER BY id DESC")->queryOne();
                        if (!empty($chk_extRef)) {
                            $isDuplicateMerchantID = true;
                        }
                    }

                    $uph_row = $connection->createCommand("select id from user_payment_history where order_number='" . $OrderReferenceNumber . "' ORDER BY id DESC")->queryOne();
                    //print_r($uph_row);
                    //
					if (!empty($uph_row)) {
                        $final_result['error_msg'] = 'This order is already available into our database. Can not re-insert again.';
                        $final_result['success'] = 0;
                    } else if (empty($curlResult->ExternalReference)) {
                        $time = new \DateTime('now');
                        $timestamp = $time->getTimestamp();
                        $final_result['error_msg'] = 'External Order Reference is not found. First you need to insert it from your 2checkout panel for this order. It must be in this format: Lf_<CurrentTimestampInSeconds>_<AnyAlphaNumericStringUpto15Characters> eg: Lf_' . $timestamp . '_' . substr(Yii::$app->security->generateRandomString(), 0, 15);
                        $final_result['success'] = 0;
                    } else if (!isset($curlResult->Items[0]->ProductDetails->Name) || !isset($curlResult->Items[0]->Code)) {
                        $final_result['error_msg'] = 'Product not found in this order.';
                        $final_result['success'] = 0;
                    } else if (!isset(Yii::$app->params['portal_id'])) {
                        $final_result['error_msg'] = 'portal_id not found.';
                        $final_result['success'] = 0;
                    } else if ($isDuplicateMerchantID == true) {
                        $time = new \DateTime('now');
                        $timestamp = $time->getTimestamp();
                        $final_result['error_msg'] = 'External Order Reference entered in 2checkout panel is already exist into our database. Please, change it from your 2checkout panel. It must be in this format: Lf_<CurrentTimestampInSeconds>_<AnyAlphaNumericStringUpto15Characters> eg: Lf_' . $timestamp . '_' . substr(Yii::$app->security->generateRandomString(), 0, 15);
                        $final_result['success'] = 0;
                    } else {

                        $plan_array = array('LFPM' => 'Professional Monthly', 'LFPQ' => 'Professional Quarterly', 'LFGM' => 'Grow Monthly', 'LFGQ' => 'Grow Quarterly', 'LFUM' => 'Ultimate Monthly', 'LFUQ' => 'Ultimate Quarterly', 'LFUP' => 'Ultimate Plus',
                            'LFPSAR' => 'Professional Semi-Annually',
                            'LFPA' => 'Professional Annually',
                            'LFGSAR' => 'Grow Semi-Annually',
                            'LFGA' => 'Grow Annually',
                            'LFUSAR' => 'Ultimate Semi-Annually',
                            'LFUA' => 'Ultimate Annually',
                            'LFPSA' => 'Professional Semi Annual Black Friday Plan',
                            'LFGSA' => 'Grow Semi-Annual Black Friday Plan',
                            'LFUSA' => 'Ultimate Semi-Annual Black Friday Plan',
                            'LFPABF' => 'Professional Annual Black Friday Plan',
                            'LFGABF' => 'Grow Annual Black Friday Plan',
                            'LFUABF' => 'Ultimate Annual Black Friday Plan',
                            'LFGM_v2' => 'Grow Monthly',
                            'LFUM_v2' => 'Ultimate Monthly',
                            'LFGSAR_v2' => 'Grow Semi-Annually',
                            'LFUSAR_v2' => 'Ultimate Semi-Annually',
                            'LFGA_v2' => 'Grow Annually',
                            'LFUA_v2' => 'Ultimate Annually',
                        );

                        $isLfBlackFridayProductInIPN = false;
                        $isUnknownProductFound = false;
                        $Items = $curlResult->Items;
                        $isEmailQtyMisMatchProductQty = false;
                        $lfafSeatPurchasedPerProduct_useridsArr = array();
                        $cuRepeatCnt = 0;
                        $free_userEmailsArr = array();
                        $free_useridsArr = array();
                        foreach ($Items as $item_key => $item_res) {
                            $product_id = $item_res->Code; //this is product code eg: LFPM
                            if (isset($plan_array[$product_id])) {
                                
                            } else {
                                $isUnknownProductFound = true;
                            }

                            $productEmailsStr = str_replace(' ', '', $_POST['ble_seatPurchasedUserEmails'][$product_id]);

                            $productEmailsArr = explode(',', $productEmailsStr);
                            //echo '<br/>DFGDFG:<pre>';print_r($productEmailsArr);echo '</pre>';
                            $productEmailsStr = "'" . implode("', '", $productEmailsArr) . "'";

                            //echo ':::FFF:'.Yii::$app->params['portal_id'].'::'.Yii::$app->params['portal_url'];


                            $cuCnt = 0;
                            $chk_user = $connection->createCommand("select * from user where portal_id=" . Yii::$app->params['portal_id'] . " and email IN (" . $productEmailsStr . ")")->queryAll();
                            if (!empty($chk_user)) {
                                foreach ($chk_user as $cu) {

                                    $cuCnt++;

                                    if (in_array($cu['email'], $free_userEmailsArr)) {
                                        $cuRepeatCnt++;
                                    } else {
                                        $free_userEmailsArr[] = $cu['email'];
                                        $free_useridsArr[] = $cu['id'];

                                        $lfafSeatPurchasedPerProduct_useridsArr[$product_id][] = $cu['id'];
                                    }
                                }
                            }

                            if ($cuCnt != $item_res->Quantity) {
                                $isEmailQtyMisMatchProductQty = true;
                            }

                            if ($product_id == 'LFPSA' || $product_id == 'LFGSA' || $product_id == 'LFUSA' || $product_id == 'LFPABF' || $product_id == 'LFGABF' || $product_id == 'LFUABF') {
                                $isLfBlackFridayProductInIPN = true;
                            }

                            if (count($productEmailsArr) != $item_res->Quantity) {
                                $isEmailQtyMisMatchProductQty = true;
                            }
                        }

                        //echo 'DFDFD:<pre>';print_r($lfafSeatPurchasedPerProduct_useridsArr);echo '</pre>';die;

                        $orderPlacedUserInfo = $connection->createCommand("select * from user where portal_id=" . Yii::$app->params['portal_id'] . " and email='" . $orderPlacedByEmail . "' ")->queryOne();


                        if ($isUnknownProductFound) {
                            $final_result['error_msg'] = 'This order contains Product Code which is not setup here.';
                            $final_result['success'] = 0;
                        } else if ($isEmailQtyMisMatchProductQty) {
                            $final_result['error_msg'] = 'The email(s) you entered does not match with product quantity OR not found in current logged in portal.';
                            $final_result['success'] = 0;
                        } else if (empty($orderPlacedUserInfo)) {
                            $final_result['error_msg'] = 'The email address (who placed this order) does not exist in current logged in portal.';
                            $final_result['success'] = 0;
                        } else if (!empty($orderPlacedUserInfo) && $orderPlacedUserInfo['id'] != $orderPlacedUserInfo['teamid']) {
                            $final_result['error_msg'] = 'The email address (who placed this order) is a subuser.';
                            $final_result['success'] = 0;
                        } else if ($cuRepeatCnt > 0) {
                            $final_result['error_msg'] = 'The email(s) must not repeat.';
                            $final_result['success'] = 0;
                        } else {


                            //$responseGetJson = json_encode($_REQUEST);
                            $responseOrderJson = $curl_result;

                            //$flagSubscriptionDataNotFoundEmailSend = false;

                            $merchant_order_id = $curlResult->ExternalReference; //this is merchant_order_id;

                            $twoCo_CustomerReference = 0;
                            if (isset($curlResult->CustomerDetails->CustomerReference)) {
                                $twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference; //it is blank here for buy link order;
                            }


                            $responseGetVar = array('refno' => $OrderReferenceNumber, 'total' => $curlResult->GrossPrice, 'total-currency' => $curlResult->Currency);
                            $responseGetVar = json_encode($responseGetVar);

                            $order_number = $OrderReferenceNumber; //this is order's reference number;

                            $lfaf_seat_purchased_useridsArr = $lfafSeatPurchasedPerProduct_useridsArr;

                            $user_id = $orderPlacedUserInfo['id']; //order placed by this userid;

                            $selPlanUsrArr = array();

                            $current_user_setting_plan_array = array('0' => 'Free', 'LFPM' => '1', 'LFPQ' => '2', 'LFGM' => '3', 'LFGQ' => '4', 'LFUM' => '5', 'LFUQ' => '6', 'LFUP' => '7',
                                'LFPSAR' => '8',
                                'LFPA' => '9',
                                'LFGSAR' => '10',
                                'LFGA' => '11',
                                'LFUSAR' => '12',
                                'LFUA' => '13',
                                'LFPSA' => '1', 'LFPABF' => '2', 'LFGSA' => '3', 'LFGABF' => '4', 'LFUSA' => '5', 'LFUABF' => '6',
                                'LFGM_v2' => '18', 'LFUM_v2' => '19', 'LFGSAR_v2' => '20', 'LFUSAR_v2' => '21', 'LFGA_v2' => '22', 'LFUA_v2' => '23',
                            );


                            //echo '<pre>'; print_r($free_useridsArr);die;
                            //inserting order code starts
                            $free_userids = implode(',', $free_useridsArr);
                            $userinfo = array('merchant_order_id' => $merchant_order_id, 'email' => $orderPlacedUserInfo['email'], 'username' => $orderPlacedUserInfo['username'], 'user_id' => (int) $orderPlacedUserInfo['id']);
                            $userinfo = json_encode($userinfo);

                            Yii::$app->db->createCommand("INSERT INTO user_payment_history (`userid`,`merchant_id`,`user_info`,`status`,`user_ids`,`isBuyLinkEntry`) VALUES ('" . $user_id . "','" . $merchant_order_id . "','" . $userinfo . "','Initialize','" . $free_userids . "',1)")->execute();
                            $lastuphid = Yii::$app->db->getLastInsertID();

                            foreach ($lfaf_seat_purchased_useridsArr as $product_code => $uidarr) {
                                Yii::$app->db->createCommand("INSERT INTO user_order_products SET uph_id=" . $lastuphid . ", product_id='" . $product_code . "', user_ids='" . implode(',', $uidarr) . "' ")->execute();
                            }

                            //inserting order code ends


                            if (($curlResult->Status == 'COMPLETE' || $curlResult->Status == 'AUTHRECEIVED') && $curlResult->ApproveStatus == 'OK' && $curlResult->VendorApproveStatus == 'OK') {

                                if (isset($curlResult->Items[0]->ProductDetails->Name) && isset($curlResult->Items[0]->Code) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionStartDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionReference)) {

                                    //&& isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->ExpirationDate)//this value will be blank for blackfriday products because it is not recurring products;

                                    $uph_row = $connection->createCommand("select id,userid,response_get from user_payment_history where merchant_id='" . $merchant_order_id . "' AND status='Initialize' AND ordertype='0' ORDER BY id DESC")->queryOne();
                                    if (!empty($uph_row)) {
                                        $uph_pkid = $uph_row['id'];

                                        //Retrieve a subscription code starts (Only to get 2coCustomerReference)
                                        if ($twoCo_CustomerReference == 0) {

                                            $firstSubscriptionReference = $curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionReference;
                                            $ch = curl_init();
                                            curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/subscriptions/' . $firstSubscriptionReference . '/');
                                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                                            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

                                            $headers = array();
                                            $headers[] = 'Accept: application/json';
                                            $headers[] = 'Content-Type: application/json';
                                            $headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
                                            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                                            $firstSubsCurl_result = curl_exec($ch);

                                            $firstSubsCurlResult = json_decode($firstSubsCurl_result);
                                            //echo '<br/>res sub:<pre>'; print_r($firstSubsCurlResult);echo '</pre>';
                                            if (curl_errno($ch)) {
                                                //echo 'Error:' . curl_error($ch);
                                            }
                                            curl_close($ch);
                                            $twoCo_CustomerReference = $firstSubsCurlResult->CustomerReference;
                                        }
                                        //Retrieve a subscription code ends
                                        //14-10-2020 : order_number and 2coCustomerReference added here in below query as we should not depend on response method;
                                        $command = $connection->createCommand('UPDATE user_payment_history SET complete_date = "' . date("Y-m-d H:i:s") . '", status="Success", order_number = "' . $OrderReferenceNumber . '", 2coCustomerReference = "' . $twoCo_CustomerReference . '" WHERE id=' . $uph_pkid);
                                        $command->execute();

                                        if ($uph_row['response_get'] == NULL) {
                                            $connection->createCommand("UPDATE `user_payment_history` SET `response_get` = '" . $responseGetVar . "' where `id` =" . $uph_pkid)->execute();
                                        }


                                        $previous_plan_array = array('0' => 'Free', '1' => 'Professional Monthly', '2' => 'Professional Quarterly', '3' => 'Grow Monthly', '4' => 'Grow Quarterly', '5' => 'Ultimate Monthly', '6' => 'Ultimate Quarterly', '7' => 'Ultimate Plus',
                                            '8' => 'Professional Semi-Annually',
                                            '9' => 'Professional Annually',
                                            '10' => 'Grow Semi-Annually',
                                            '11' => 'Grow Annually',
                                            '12' => 'Ultimate Semi-Annually',
                                            '13' => 'Ultimate Annually',
                                            '14' => 'New Grow Monthly',
                                            '15' => 'New Grow Annual',
                                            '16' => 'New Ultimate Monthly',
                                            '17' => 'New Ultimate Annual',
                                            '18' => 'Grow Monthly',
                                            '19' => 'Ultimate Monthly',
                                            '20' => 'Grow Semi-Annually',
                                            '21' => 'Ultimate Semi-Annually',
                                            '22' => 'Grow Annually',
                                            '23' => 'Ultimate Annually',
                                        );

                                        $lfblackfriday_plan_array = array('0' => 'Free', '1' => 'Professional Semi Annual Black Friday', '2' => 'Professional Annual Black Friday', '3' => 'Grow Semi Annual Black Friday', '4' => 'Grow Annual Black Friday', '5' => 'Ultimate Semi Annual Black Friday', '6' => 'Ultimate Annual Black Friday', '7' => 'Ultimate Plus');

                                        $Items = $curlResult->Items;

                                        foreach ($Items as $item_key => $item_res) {
                                            $product_id = $item_res->Code; //this is product code eg: LCPM
                                            $SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;


                                            if ($product_id == 'LFPSA' || $product_id == 'LFGSA' || $product_id == 'LFUSA' || $product_id == 'LFPABF' || $product_id == 'LFGABF' || $product_id == 'LFUABF') {
                                                //for blackfriday plans
                                                //$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;//this value will be blank for blackfriday products;

                                                if ($product_id == 'LFPSA' || $product_id == 'LFGSA' || $product_id == 'LFUSA') {
                                                    //for blackfriday Semi Annual plans
                                                    $ExpirationDate = date('Y-m-d H:i:s', strtotime($SubscriptionStartDate . ' + 6 months'));
                                                } else if ($product_id == 'LFPABF' || $product_id == 'LFGABF' || $product_id == 'LFUABF') {
                                                    //for blackfriday Annual plans
                                                    $ExpirationDate = date('Y-m-d H:i:s', strtotime($SubscriptionStartDate . ' + 1 year'));
                                                }

                                                $ExpirationDateTimestamp = strtotime($ExpirationDate) * 1000;
                                            } else {
                                                $ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
                                                $ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
                                            }


                                            $SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;

                                            $command = $connection->createCommand('UPDATE user_order_products SET SubscriptionStartDate = "' . $SubscriptionStartDate . '", ExpirationDate = "' . $ExpirationDate . '",2coSubscriptionStatus="ACTIVE", SubscriptionReference="' . $SubscriptionReference . '" WHERE uph_id=' . $uph_pkid . ' AND product_id="' . $product_id . '" ');
                                            $command->execute();

                                            $uidsStrPerProduct = implode(',', $lfaf_seat_purchased_useridsArr[$product_id]);
                                            $current_user_setting_plan = $current_user_setting_plan_array[$product_id]; //eg:5

                                            $selPlanUsrArr[$product_id]['userIdArr'] = $lfaf_seat_purchased_useridsArr[$product_id];

                                            //starts


                                            $userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
                                            foreach ($userIdArr as $uid) {

                                                $usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =" . $uid)->queryOne();
                                                $previous_plan = $usrcommand['sublevel'];
                                                $isTrial = $usrcommand['trial'];

                                                $previous_plan = $previous_plan_array[$previous_plan];

                                                if ($isLfBlackFridayProductInIPN == false) {
                                                    $current_plan = $previous_plan_array[$current_user_setting_plan];
                                                } else {
                                                    $current_plan = $lfblackfriday_plan_array[$current_user_setting_plan];
                                                }

                                                $selPlanUsrArr[$product_id]['user_name'][] = $usrcommand['first_name'] . ' ' . $usrcommand['last_name'];
                                                $selPlanUsrArr[$product_id]['user_email'][] = $usrcommand['email'];
                                                $selPlanUsrArr[$product_id]['previous_plan'][] = $previous_plan;
                                                $selPlanUsrArr[$product_id]['previous_planisTrial'][] = $isTrial;
                                                $selPlanUsrArr[$product_id]['current_plan'][] = $current_plan;
                                            }

                                            if ($isLfBlackFridayProductInIPN) {
                                                //for blackfriday products
                                                $command = $connection->createCommand('UPDATE user SET sublevel = "' . $current_user_setting_plan . '" , trial = 0, trial_expired_at = "' . $ExpirationDateTimestamp . '", cancelSub = 0, subscriptionExpiredAt = "' . $ExpirationDateTimestamp . '" WHERE id IN (' . $uidsStrPerProduct . ')');
                                            } else {
                                                //trial_expired_at = "'.$ExpirationDateTimestamp.'"
                                                $command = $connection->createCommand('UPDATE user SET sublevel = "' . $current_user_setting_plan . '" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "' . $ExpirationDateTimestamp . '" WHERE id IN (' . $uidsStrPerProduct . ')');
                                            }
                                            $command->execute();
                                            //ends

                                            $uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='" . $order_number . "' AND SubscriptionReference='" . $SubscriptionReference . "' ORDER BY id DESC")->queryOne();
                                            if (empty($uos_row)) {
                                                Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "' . $order_number . '", SubscriptionReference="' . $SubscriptionReference . '"')->execute();
                                            }
                                        }
                                        //echo '<br/>SDFDF:<pre>'; print_r($selPlanUsrArr);
                                        //new ends
                                        //$usrInfoOrdPlaced = $connection->createCommand("select email,first_name from user where id='".$user_id."' ")->queryOne();
                                        $usrInfoOrdPlaced = $orderPlacedUserInfo;

                                        $emailId = $usrInfoOrdPlaced['email'];
                                        $emailId = $usrInfoOrdPlaced['first_name'];

                                        $payment_info = array('order_number' => $order_number, 'merchant_order_id' => $merchant_order_id, 'selPlanUsrArr' => $selPlanUsrArr, 'ses_email' => $usrInfoOrdPlaced['email'], 'ses_full_name' => $usrInfoOrdPlaced['first_name']);
                                        $this->successedPayment($payment_info);

                                        $connection->createCommand("UPDATE `user_payment_history` SET `response_order` = '" . addslashes($responseOrderJson) . "' where `id` =" . $uph_pkid)->execute();

                                        //echo '<br>The End';

                                        if ($orderPlacedUserInfo['2coCustomerReference'] == 0) {
                                            Yii::$app->db->createCommand('UPDATE user SET 2coCustomerReference = "' . $twoCo_CustomerReference . '"  WHERE id=' . $user_id)->execute();
                                        }


                                        $final_result['success'] = 1;
                                        $final_result['success_msg'] = 'Order inserted successfully.';
                                    }
                                } else {

                                    //subscription data not available.
                                    //order inserted but with status 'Initialize'
                                    $final_result['success_msg'] = 'Due to subscription data is not yet available, this order is inserted but with following status: Order Status:' . $curlResult->Status . ', ApproveStatus:' . $curlResult->ApproveStatus . ', VendorApproveStatus:' . $curlResult->VendorApproveStatus . ' ; In our database order status is Initialize. If the webhook ipn is already called then we need to manually run for this order.';
                                    $final_result['success'] = 1;
                                }
                            } else {
                                //order inserted but with status 'Initialize'
                                $final_result['success_msg'] = 'This order is inserted but with following status: Order Status:' . $curlResult->Status . ', ApproveStatus:' . $curlResult->ApproveStatus . ', VendorApproveStatus:' . $curlResult->VendorApproveStatus . ' ; In our database order status is Initialize. If the webhook ipn is already called then we need to manually run for this order.';
                                $final_result['success'] = 1;
                            }
                        }
                    }
                } else {
                    $final_result['error_msg'] = 'failed.';
                    $final_result['success'] = 0;
                }
            }

            echo json_encode($final_result);
        } else {

            if (!Yii::$app->session->get('useremail')) {
                $url = \Yii::$app->request->baseUrl . "/login";
                return $this->redirect($url);
            }

            if (\Yii::$app->session->get('salesperson') == 0) {
                throw new \yii\web\NotFoundHttpException();
            }

            /*
              if(Yii::$app->session->get('userid') != Yii::$app->session->get('teamid')){
              }
             */

            return $this->render('buy_link_entry_form', [
                        'message' => '',
                            //'userDetail' => $userDetail
            ]);
        }
    }

    public function actionBuy_link_entry_form() {

        if (\Yii::$app->request->post() && \Yii::$app->request->post('ble_orderRef')) {
            //echo '<pre>';print_r($_POST);die;

            $OrderReferenceNumber = trim(Yii::$app->request->post('ble_orderRef'));
            $orderPlacedByEmail = trim(Yii::$app->request->post('ble_userEmail'));

            $final_result = array();
            $final_result['success'] = 1;

            if (!Yii::$app->session->get('useremail')) {
                $url = \Yii::$app->request->baseUrl . "/login";
                //return $this->redirect($url);
                $final_result['redirect_url'] = $url;
                $final_result['success'] = 0;
            }

            if (empty($OrderReferenceNumber) || empty($orderPlacedByEmail)) {
                $final_result['error_msg'] = 'All fields are required.';
                $final_result['success'] = 0;
            }

            if ($final_result['success']) {

                //echo '<pre>'; print_r($_POST);echo '</pre>';

                if (YII_ENV_PROD) {
                    //production
                    $merchantCode = "203537015";
                    $key = 'd?q4rkG]&KAh#vwnmSJ%';
                } else {
                    //staging
                    $merchantCode = "251108887711"; // your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
                    $key = '!G2S8WRBKJ6#&c~luOz='; // your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
                }

                $gmdate = gmdate('Y-m-d H:i:s');
                $string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
                $hashAlgorithm = 'sha256';
                $hash = hash_hmac($hashAlgorithm , $string, $key);

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/' . $OrderReferenceNumber . '/');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

                $headers = array();
                $headers[] = 'Accept: application/json';
                $headers[] = 'Content-Type: application/json';
                $headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                $curl_result = curl_exec($ch);

                $curlResult = json_decode($curl_result);
                //echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
                if (curl_errno($ch)) {
                    //echo 'Error:' . curl_error($ch);
                }
                curl_close($ch);
                //echo '<br/>';

                if (isset($curlResult->error_code)) {
                    $final_result['error_msg'] = $curlResult->message;
                    $final_result['success'] = 0;
                } else if ($curlResult) {

                    $connection = Yii::$app->db;

                    $isDuplicateMerchantID = false;
                    if (!empty($curlResult->ExternalReference)) {
                        $chk_extRef = $connection->createCommand("select id from user_payment_history where order_number!='" . $OrderReferenceNumber . "' and merchant_id='" . $curlResult->ExternalReference . "'  ORDER BY id DESC")->queryOne();
                        if (!empty($chk_extRef)) {
                            $isDuplicateMerchantID = true;
                        }
                    }

                    $uph_row = $connection->createCommand("select id from user_payment_history where order_number='" . $OrderReferenceNumber . "' ORDER BY id DESC")->queryOne();
                    //print_r($uph_row);
                    //
					if (!empty($uph_row)) {
                        $final_result['error_msg'] = 'This order is already available into our database. Can not re-insert again.';
                        $final_result['success'] = 0;
                    } else if (empty($curlResult->ExternalReference)) {
                        $time = new \DateTime('now');
                        $timestamp = $time->getTimestamp();
                        $final_result['error_msg'] = 'External Order Reference is not found. First you need to insert it from your 2checkout panel for this order. It must be in this format: Lf_<CurrentTimestampInSeconds>_<AnyAlphaNumericStringUpto15Characters> eg: Lf_' . $timestamp . '_' . substr(Yii::$app->security->generateRandomString(), 0, 15);
                        $final_result['success'] = 0;
                    } else if (!isset($curlResult->Items[0]->ProductDetails->Name) || !isset($curlResult->Items[0]->Code)) {
                        $final_result['error_msg'] = 'Product not found in this order.';
                        $final_result['success'] = 0;
                    } else if (!isset(Yii::$app->params['portal_id'])) {
                        $final_result['error_msg'] = 'portal_id not found.';
                        $final_result['success'] = 0;
                    } else if ($isDuplicateMerchantID == true) {
                        $time = new \DateTime('now');
                        $timestamp = $time->getTimestamp();
                        $final_result['error_msg'] = 'External Order Reference entered in 2checkout panel is already exist into our database. Please, change it from your 2checkout panel. It must be in this format: Lf_<CurrentTimestampInSeconds>_<AnyAlphaNumericStringUpto15Characters> eg: Lf_' . $timestamp . '_' . substr(Yii::$app->security->generateRandomString(), 0, 15);
                        $final_result['success'] = 0;
                    } else {

                        $plan_array = array('LFPM' => 'Professional Monthly', 'LFPQ' => 'Professional Quarterly', 'LFGM' => 'Grow Monthly', 'LFGQ' => 'Grow Quarterly', 'LFUM' => 'Ultimate Monthly', 'LFUQ' => 'Ultimate Quarterly', 'LFUP' => 'Ultimate Plus',
                            'LFPSAR' => 'Professional Semi-Annually',
                            'LFPA' => 'Professional Annually',
                            'LFGSAR' => 'Grow Semi-Annually',
                            'LFGA' => 'Grow Annually',
                            'LFUSAR' => 'Ultimate Semi-Annually',
                            'LFUA' => 'Ultimate Annually',
                            'LFPSA' => 'Professional Semi Annual Black Friday Plan',
                            'LFGSA' => 'Grow Semi-Annual Black Friday Plan',
                            'LFUSA' => 'Ultimate Semi-Annual Black Friday Plan',
                            'LFPABF' => 'Professional Annual Black Friday Plan',
                            'LFGABF' => 'Grow Annual Black Friday Plan',
                            'LFUABF' => 'Ultimate Annual Black Friday Plan',
                            'LFGM_v2' => 'Grow Monthly',
                            'LFUM_v2' => 'Ultimate Monthly',
                            'LFGSAR_v2' => 'Grow Semi-Annually',
                            'LFUSAR_v2' => 'Ultimate Semi-Annually',
                            'LFGA_v2' => 'Grow Annually',
                            'LFUA_v2' => 'Ultimate Annually',
                        );

                        $isLfBlackFridayProductInIPN = false;
                        $isUnknownProductFound = false;
                        $Items = $curlResult->Items;
                        $isEmailQtyMisMatchProductQty = false;
                        $lfafSeatPurchasedPerProduct_useridsArr = array();
                        $cuRepeatCnt = 0;
                        $free_userEmailsArr = array();
                        $free_useridsArr = array();
                        //21-06-2021 starts
                        $isLfAddOnPackExclusiveOrder = false;
                        $addOnPackProduct_array = array('LFAddOnPack' => 'Booster Pack');
                        if (isset($addOnPackProduct_array[$curlResult->Items[0]->Code])) {
                            //addOnPackProduct added on 21-06-2021
                            //note:only exclusive add on pack order is supported. ie. the order must contains only add-on pack product in it.
                            foreach ($Items as $item_key => $item_res) {
                                $product_id = $item_res->Code; //this is product code eg: LFAddOnPack
                                if (isset($addOnPackProduct_array[$product_id])) {
                                    
                                } else {
                                    $isUnknownProductFound = true;
                                }
                            }
                        } else {
                            foreach ($Items as $item_key => $item_res) {
                                $product_id = $item_res->Code; //this is product code eg: LFPM
                                if (isset($plan_array[$product_id])) {
                                    
                                } else {
                                    $isUnknownProductFound = true;
                                }
                            }
                        }
                        //21-06-2021 ends
                        if ($isUnknownProductFound == false) {
                            //above condition added on 21-06-2021
                            foreach ($Items as $item_key => $item_res) {
                                $product_id = $item_res->Code; //this is product code eg: LFPM
                                /* commented on 21-06-2021
                                  if(isset($plan_array[$product_id])){
                                  }else{
                                  $isUnknownProductFound = true;
                                  }
                                 */

                                $productEmailsStr = str_replace(' ', '', $_POST['ble_seatPurchasedUserEmails'][$product_id]);

                                $productEmailsArr = explode(',', $productEmailsStr);
                                //echo '<br/>DFGDFG:<pre>';print_r($productEmailsArr);echo '</pre>';
                                $productEmailsStr = "'" . implode("', '", $productEmailsArr) . "'";

                                //echo ':::FFF:'.Yii::$app->params['portal_id'].'::'.Yii::$app->params['portal_url'];


                                $cuCnt = 0;
                                $chk_user = $connection->createCommand("select * from user where portal_id=" . Yii::$app->params['portal_id'] . " and email IN (" . $productEmailsStr . ")")->queryAll();
                                if (!empty($chk_user)) {
                                    foreach ($chk_user as $cu) {

                                        $cuCnt++;

                                        if (in_array($cu['email'], $free_userEmailsArr)) {
                                            $cuRepeatCnt++;
                                        } else {
                                            $free_userEmailsArr[] = $cu['email'];
                                            $free_useridsArr[] = $cu['id'];

                                            $lfafSeatPurchasedPerProduct_useridsArr[$product_id][] = $cu['id'];
                                        }
                                    }
                                }

                                if ($cuCnt != $item_res->Quantity) {
                                    $isEmailQtyMisMatchProductQty = true;
                                }

                                if ($product_id == 'LFPSA' || $product_id == 'LFGSA' || $product_id == 'LFUSA' || $product_id == 'LFPABF' || $product_id == 'LFGABF' || $product_id == 'LFUABF') {
                                    $isLfBlackFridayProductInIPN = true;
                                }
                                //21-06-2021 starts
                                if ($product_id == 'LFAddOnPack') {
                                    $isLfAddOnPackExclusiveOrder = true;
                                }
                                //21-06-2021 ends

                                if (count($productEmailsArr) != $item_res->Quantity) {
                                    $isEmailQtyMisMatchProductQty = true;
                                }
                            }
                        }
                        //echo 'DFDFD:<pre>';print_r($lfafSeatPurchasedPerProduct_useridsArr);echo '</pre>';die;

                        $orderPlacedUserInfo = $connection->createCommand("select * from user where portal_id=" . Yii::$app->params['portal_id'] . " and email='" . $orderPlacedByEmail . "' ")->queryOne();


                        if ($isUnknownProductFound) {
                            $final_result['error_msg'] = 'This order contains Product Code which is not setup here.';
                            $final_result['success'] = 0;
                        } else if ($isEmailQtyMisMatchProductQty) {
                            $final_result['error_msg'] = 'The email(s) you entered does not match with product quantity OR not found in current logged in portal.';
                            $final_result['success'] = 0;
                        } else if (empty($orderPlacedUserInfo)) {
                            $final_result['error_msg'] = 'The email address (who placed this order) does not exist in current logged in portal.';
                            $final_result['success'] = 0;
                        } else if (!empty($orderPlacedUserInfo) && $orderPlacedUserInfo['id'] != $orderPlacedUserInfo['teamid']) {
                            $final_result['error_msg'] = 'The email address (who placed this order) is a subuser.';
                            $final_result['success'] = 0;
                        } else if ($cuRepeatCnt > 0) {
                            $final_result['error_msg'] = 'The email(s) must not repeat.';
                            $final_result['success'] = 0;
                        } else {


                            //$responseGetJson = json_encode($_REQUEST);
                            $responseOrderJson = $curl_result;

                            //$flagSubscriptionDataNotFoundEmailSend = false;

                            $merchant_order_id = $curlResult->ExternalReference; //this is merchant_order_id;

                            $twoCo_CustomerReference = 0;
                            if (isset($curlResult->CustomerDetails->CustomerReference)) {
                                $twoCo_CustomerReference = $curlResult->CustomerDetails->CustomerReference; //it is blank here for buy link order;
                            }


                            $responseGetVar = array('refno' => $OrderReferenceNumber, 'total' => $curlResult->GrossPrice, 'total-currency' => $curlResult->Currency);
                            $responseGetVar = json_encode($responseGetVar);

                            $order_number = $OrderReferenceNumber; //this is order's reference number;

                            $lfaf_seat_purchased_useridsArr = $lfafSeatPurchasedPerProduct_useridsArr;

                            $user_id = $orderPlacedUserInfo['id']; //order placed by this userid;

                            $selPlanUsrArr = array();

                            $current_user_setting_plan_array = array('0' => 'Free', 'LFPM' => '1', 'LFPQ' => '2', 'LFGM' => '3', 'LFGQ' => '4', 'LFUM' => '5', 'LFUQ' => '6', 'LFUP' => '7',
                                'LFPSAR' => '8',
                                'LFPA' => '9',
                                'LFGSAR' => '10',
                                'LFGA' => '11',
                                'LFUSAR' => '12',
                                'LFUA' => '13',
                                'LFPSA' => '1', 'LFPABF' => '2', 'LFGSA' => '3', 'LFGABF' => '4', 'LFUSA' => '5', 'LFUABF' => '6',
                                'LFGM_v2' => '18', 'LFUM_v2' => '19', 'LFGSAR_v2' => '20', 'LFUSAR_v2' => '21', 'LFGA_v2' => '22', 'LFUA_v2' => '23',
                            );


                            //echo '<pre>'; print_r($free_useridsArr);die;
                            //inserting order code starts
                            $free_userids = implode(',', $free_useridsArr);
                            $userinfo = array('merchant_order_id' => $merchant_order_id, 'email' => $orderPlacedUserInfo['email'], 'username' => $orderPlacedUserInfo['username'], 'user_id' => (int) $orderPlacedUserInfo['id']);
                            $userinfo = json_encode($userinfo);
                            //21-06-2021 starts
                            $isAddOnPackOrderVal = 0;
                            $isAddOnPackProductVal = 0;
                            if ($isLfAddOnPackExclusiveOrder == true) {
                                $isAddOnPackOrderVal = 1;
                                $isAddOnPackProductVal = 1;
                            }
                            //21-06-2021 ends

                            Yii::$app->db->createCommand("INSERT INTO user_payment_history (`userid`,`merchant_id`,`user_info`,`status`,`user_ids`,`isBuyLinkEntry`,`isAddOnPackOrder`) VALUES ('" . $user_id . "','" . $merchant_order_id . "','" . $userinfo . "','Initialize','" . $free_userids . "',1," . $isAddOnPackOrderVal . ")")->execute();
                            $lastuphid = Yii::$app->db->getLastInsertID();

                            foreach ($lfaf_seat_purchased_useridsArr as $product_code => $uidarr) {
                                Yii::$app->db->createCommand("INSERT INTO user_order_products SET isAddOnPackProduct=" . $isAddOnPackProductVal . ", uph_id=" . $lastuphid . ", product_id='" . $product_code . "', user_ids='" . implode(',', $uidarr) . "' ")->execute();
                            }

                            //inserting order code ends


                            if (($curlResult->Status == 'COMPLETE' || $curlResult->Status == 'AUTHRECEIVED') && $curlResult->ApproveStatus == 'OK' && $curlResult->VendorApproveStatus == 'OK') {

                                if (isset($curlResult->Items[0]->ProductDetails->Name) && isset($curlResult->Items[0]->Code) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionStartDate) && isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionReference)) {

                                    //&& isset($curlResult->Items[0]->ProductDetails->Subscriptions[0]->ExpirationDate)//this value will be blank for blackfriday products because it is not recurring products;

                                    $uph_row = $connection->createCommand("select id,userid,response_get from user_payment_history where merchant_id='" . $merchant_order_id . "' AND status='Initialize' AND ordertype='0' ORDER BY id DESC")->queryOne();
                                    if (!empty($uph_row)) {
                                        $uph_pkid = $uph_row['id'];

                                        //Retrieve a subscription code starts (Only to get 2coCustomerReference)
                                        if ($twoCo_CustomerReference == 0) {

                                            $firstSubscriptionReference = $curlResult->Items[0]->ProductDetails->Subscriptions[0]->SubscriptionReference;
                                            $ch = curl_init();
                                            curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/subscriptions/' . $firstSubscriptionReference . '/');
                                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                                            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

                                            $headers = array();
                                            $headers[] = 'Accept: application/json';
                                            $headers[] = 'Content-Type: application/json';
                                            $headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
                                            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                                            $firstSubsCurl_result = curl_exec($ch);

                                            $firstSubsCurlResult = json_decode($firstSubsCurl_result);
                                            //echo '<br/>res sub:<pre>'; print_r($firstSubsCurlResult);echo '</pre>';
                                            if (curl_errno($ch)) {
                                                //echo 'Error:' . curl_error($ch);
                                            }
                                            curl_close($ch);
                                            $twoCo_CustomerReference = $firstSubsCurlResult->CustomerReference;
                                        }
                                        //Retrieve a subscription code ends
                                        //14-10-2020 : order_number and 2coCustomerReference added here in below query as we should not depend on response method;
                                        $command = $connection->createCommand('UPDATE user_payment_history SET complete_date = "' . date("Y-m-d H:i:s") . '", status="Success", order_number = "' . $OrderReferenceNumber . '", 2coCustomerReference = "' . $twoCo_CustomerReference . '" WHERE id=' . $uph_pkid);
                                        $command->execute();

                                        if ($uph_row['response_get'] == NULL) {
                                            $connection->createCommand("UPDATE `user_payment_history` SET `response_get` = '" . $responseGetVar . "' where `id` =" . $uph_pkid)->execute();
                                        }


                                        $previous_plan_array = array('0' => 'Free', '1' => 'Professional Monthly', '2' => 'Professional Quarterly', '3' => 'Grow Monthly', '4' => 'Grow Quarterly', '5' => 'Ultimate Monthly', '6' => 'Ultimate Quarterly', '7' => 'Ultimate Plus',
                                            '8' => 'Professional Semi-Annually',
                                            '9' => 'Professional Annually',
                                            '10' => 'Grow Semi-Annually',
                                            '11' => 'Grow Annually',
                                            '12' => 'Ultimate Semi-Annually',
                                            '13' => 'Ultimate Annually',
                                            '14' => 'New Grow Monthly',
                                            '15' => 'New Grow Annual',
                                            '16' => 'New Ultimate Monthly',
                                            '17' => 'New Ultimate Annual',
                                            '18' => 'Grow Monthly',
                                            '19' => 'Ultimate Monthly',
                                            '20' => 'Grow Semi-Annually',
                                            '21' => 'Ultimate Semi-Annually',
                                            '22' => 'Grow Annually',
                                            '23' => 'Ultimate Annually',
                                        );

                                        $lfblackfriday_plan_array = array('0' => 'Free', '1' => 'Professional Semi Annual Black Friday', '2' => 'Professional Annual Black Friday', '3' => 'Grow Semi Annual Black Friday', '4' => 'Grow Annual Black Friday', '5' => 'Ultimate Semi Annual Black Friday', '6' => 'Ultimate Annual Black Friday', '7' => 'Ultimate Plus');

                                        $Items = $curlResult->Items;

                                        foreach ($Items as $item_key => $item_res) {
                                            $product_id = $item_res->Code; //this is product code eg: LCPM
                                            $SubscriptionStartDate = $item_res->ProductDetails->Subscriptions[0]->SubscriptionStartDate;


                                            if ($product_id == 'LFPSA' || $product_id == 'LFGSA' || $product_id == 'LFUSA' || $product_id == 'LFPABF' || $product_id == 'LFGABF' || $product_id == 'LFUABF') {
                                                //for blackfriday plans
                                                //$ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;//this value will be blank for blackfriday products;

                                                if ($product_id == 'LFPSA' || $product_id == 'LFGSA' || $product_id == 'LFUSA') {
                                                    //for blackfriday Semi Annual plans
                                                    $ExpirationDate = date('Y-m-d H:i:s', strtotime($SubscriptionStartDate . ' + 6 months'));
                                                } else if ($product_id == 'LFPABF' || $product_id == 'LFGABF' || $product_id == 'LFUABF') {
                                                    //for blackfriday Annual plans
                                                    $ExpirationDate = date('Y-m-d H:i:s', strtotime($SubscriptionStartDate . ' + 1 year'));
                                                }

                                                $ExpirationDateTimestamp = strtotime($ExpirationDate) * 1000;
                                                $sql_ExpirationDate = 'ExpirationDate = "' . $ExpirationDate . '"';
                                            } else if ($isLfAddOnPackExclusiveOrder == true) {
                                                //for AddOnPackProduct there is no ExpirationDate.
                                                $sql_ExpirationDate = 'ExpirationDate = NULL';
                                            } else {
                                                $ExpirationDate = $item_res->ProductDetails->Subscriptions[0]->ExpirationDate;
                                                $ExpirationDateTimestamp = strtotime($item_res->ProductDetails->Subscriptions[0]->ExpirationDate) * 1000;
                                                $sql_ExpirationDate = 'ExpirationDate = "' . $ExpirationDate . '"';
                                            }


                                            $SubscriptionReference = $item_res->ProductDetails->Subscriptions[0]->SubscriptionReference;

                                            $command = $connection->createCommand('UPDATE user_order_products SET SubscriptionStartDate = "' . $SubscriptionStartDate . '", ' . $sql_ExpirationDate . ',2coSubscriptionStatus="ACTIVE", SubscriptionReference="' . $SubscriptionReference . '" WHERE uph_id=' . $uph_pkid . ' AND product_id="' . $product_id . '" ');
                                            $command->execute();

                                            $uidsStrPerProduct = implode(',', $lfaf_seat_purchased_useridsArr[$product_id]);
                                            if ($isLfAddOnPackExclusiveOrder == false) {
                                                $current_user_setting_plan = $current_user_setting_plan_array[$product_id]; //eg:5
                                            }


                                            $selPlanUsrArr[$product_id]['userIdArr'] = $lfaf_seat_purchased_useridsArr[$product_id];

                                            //starts


                                            $userIdArr = $lfaf_seat_purchased_useridsArr[$product_id];
                                            foreach ($userIdArr as $uid) {

                                                $usrcommand = Yii::$app->db->createCommand("SELECT sublevel,trial,first_name,last_name,email FROM user WHERE  id =" . $uid)->queryOne();
                                                $previous_plan = $usrcommand['sublevel'];
                                                $isTrial = $usrcommand['trial'];

                                                $previous_plan = $previous_plan_array[$previous_plan];
                                                if ($isLfAddOnPackExclusiveOrder == false) {
                                                    if ($isLfBlackFridayProductInIPN == false) {
                                                        $current_plan = $previous_plan_array[$current_user_setting_plan];
                                                    } else {
                                                        $current_plan = $lfblackfriday_plan_array[$current_user_setting_plan];
                                                    }
                                                } else {
                                                    //for AddOnPackProduct
                                                    $current_plan = $item_res->ProductDetails->Name; //this is product name;
                                                }
                                                $selPlanUsrArr[$product_id]['user_name'][] = $usrcommand['first_name'] . ' ' . $usrcommand['last_name'];
                                                $selPlanUsrArr[$product_id]['user_email'][] = $usrcommand['email'];
                                                $selPlanUsrArr[$product_id]['previous_plan'][] = $previous_plan;
                                                $selPlanUsrArr[$product_id]['previous_planisTrial'][] = $isTrial;
                                                $selPlanUsrArr[$product_id]['current_plan'][] = $current_plan;
                                            }
                                            if ($isLfAddOnPackExclusiveOrder == false) {
                                                //23-06-2021 starts
                                                $sql_booster = ' is_booster = is_booster ';
                                                if ($product_id == 'LFUM_v2' || $product_id == 'LFUSAR_v2' || $product_id == 'LFUA_v2') {
                                                    $sql_booster = ' is_booster="1" ';
                                                }
                                                //23-06-2021 ends
                                                if ($isLfBlackFridayProductInIPN) {
                                                    //for blackfriday products
                                                    $command = $connection->createCommand('UPDATE user SET sublevel = "' . $current_user_setting_plan . '" , trial = 0, trial_expired_at = "' . $ExpirationDateTimestamp . '", cancelSub = 0, subscriptionExpiredAt = "' . $ExpirationDateTimestamp . '", ' . $sql_booster . ' WHERE id IN (' . $uidsStrPerProduct . ')');
                                                } else {
                                                    //trial_expired_at = "'.$ExpirationDateTimestamp.'"
                                                    $command = $connection->createCommand('UPDATE user SET sublevel = "' . $current_user_setting_plan . '" , trial = 0, cancelSub = 0, subscriptionExpiredAt = "' . $ExpirationDateTimestamp . '", ' . $sql_booster . ' WHERE id IN (' . $uidsStrPerProduct . ')');
                                                }
                                                $command->execute();
                                            } else {
                                                $command = $connection->createCommand('UPDATE user SET is_booster = "1" WHERE id IN (' . $uidsStrPerProduct . ')');
                                                $command->execute();
                                            }
                                            //ends

                                            $uos_row = Yii::$app->db->createCommand("SELECT id FROM user_order_subscriptions WHERE order_number='" . $order_number . "' AND SubscriptionReference='" . $SubscriptionReference . "' ORDER BY id DESC")->queryOne();
                                            if (empty($uos_row)) {
                                                Yii::$app->db->createCommand('INSERT INTO user_order_subscriptions SET order_number = "' . $order_number . '", SubscriptionReference="' . $SubscriptionReference . '"')->execute();
                                            }
                                        }
                                        //echo '<br/>SDFDF:<pre>'; print_r($selPlanUsrArr);
                                        //new ends
                                        //$usrInfoOrdPlaced = $connection->createCommand("select email,first_name from user where id='".$user_id."' ")->queryOne();
                                        $usrInfoOrdPlaced = $orderPlacedUserInfo;

                                        $emailId = $usrInfoOrdPlaced['email'];
                                        $emailId = $usrInfoOrdPlaced['first_name'];

                                        $payment_info = array('order_number' => $order_number, 'merchant_order_id' => $merchant_order_id, 'selPlanUsrArr' => $selPlanUsrArr, 'ses_email' => $usrInfoOrdPlaced['email'], 'ses_full_name' => $usrInfoOrdPlaced['first_name']);
                                        if ($isLfAddOnPackExclusiveOrder == true) {
                                            //for AddOnPackProduct
                                            $this->successedPaymentAddOnPackExclusiveOrder($payment_info);
                                        } else {
                                            $this->successedPayment($payment_info);
                                        }

                                        $connection->createCommand("UPDATE `user_payment_history` SET `response_order` = '" . addslashes($responseOrderJson) . "' where `id` =" . $uph_pkid)->execute();

                                        //echo '<br>The End';

                                        if ($orderPlacedUserInfo['2coCustomerReference'] == 0) {
                                            Yii::$app->db->createCommand('UPDATE user SET 2coCustomerReference = "' . $twoCo_CustomerReference . '"  WHERE id=' . $user_id)->execute();
                                        }


                                        $final_result['success'] = 1;
                                        $final_result['success_msg'] = 'Order inserted successfully.';
                                    }
                                } else {

                                    //subscription data not available.
                                    //order inserted but with status 'Initialize'
                                    $final_result['success_msg'] = 'Due to subscription data is not yet available, this order is inserted but with following status: Order Status:' . $curlResult->Status . ', ApproveStatus:' . $curlResult->ApproveStatus . ', VendorApproveStatus:' . $curlResult->VendorApproveStatus . ' ; In our database order status is Initialize. If the webhook ipn is already called then we need to manually run for this order.';
                                    $final_result['success'] = 1;
                                }
                            } else {
                                //order inserted but with status 'Initialize'
                                $final_result['success_msg'] = 'This order is inserted but with following status: Order Status:' . $curlResult->Status . ', ApproveStatus:' . $curlResult->ApproveStatus . ', VendorApproveStatus:' . $curlResult->VendorApproveStatus . ' ; In our database order status is Initialize. If the webhook ipn is already called then we need to manually run for this order.';
                                $final_result['success'] = 1;
                            }
                        }
                    }
                } else {
                    $final_result['error_msg'] = 'failed.';
                    $final_result['success'] = 0;
                }
            }

            echo json_encode($final_result);
        } else {

            if (!Yii::$app->session->get('useremail')) {
                $url = \Yii::$app->request->baseUrl . "/login";
                return $this->redirect($url);
            }

            if (\Yii::$app->session->get('salesperson') == 0) {
                throw new \yii\web\NotFoundHttpException();
            }

            /*
              if(Yii::$app->session->get('userid') != Yii::$app->session->get('teamid')){
              }
             */

            return $this->render('buy_link_entry_form', [
                        'message' => '',
                            //'userDetail' => $userDetail
            ]);
        }
    }

    public function actionValidate_order_info_BkpMethodBeforeAddOnPackProduct() {
        die;
        //Usage: To insert buy link order into database, first validate that order and return the product codes available.

        $final_result = array();
        $final_result['success'] = 1;

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            //return $this->redirect($url);
            $final_result['redirect_url'] = $url;
            $final_result['success'] = 0;
        }

        //echo '<pre>'; print_r($_POST);die;

        if (!isset($_POST['orderRef']) || empty($_POST['orderRef'])) {
            $final_result['error_msg'] = 'Enter Order Reference Number.';
            $final_result['success'] = 0;
        }

        if ($final_result['success'] == 1) {

            if (YII_ENV_PROD) {
                //production
                $merchantCode = "203537015";
                $key = 'd?q4rkG]&KAh#vwnmSJ%';
            } else {
                //staging
                $merchantCode = "251108887711"; // your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
                $key = '!G2S8WRBKJ6#&c~luOz='; // your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
            }

            $gmdate = gmdate('Y-m-d H:i:s');
            $string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
            $hashAlgorithm = 'sha256';
            $hash = hash_hmac($hashAlgorithm , $string, $key);

            //$OrderReferenceNumber = trim($_POST['orderRef']);
            $OrderReferenceNumber = trim(\Yii::$app->request->post('orderRef'));
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/' . $OrderReferenceNumber . '/');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

            $headers = array();
            $headers[] = 'Accept: application/json';
            $headers[] = 'Content-Type: application/json';
            $headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            $curl_result = curl_exec($ch);

            $curlResult = json_decode($curl_result);
            //echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
            if (curl_errno($ch)) {
                //echo 'Error:' . curl_error($ch);
            }
            curl_close($ch);
            //echo '<br/>';

            if (isset($curlResult->error_code)) {
                $final_result['error_msg'] = $curlResult->message;
                $final_result['success'] = 0;
            } else if ($curlResult) {

                //if(($curlResult->Status=='COMPLETE' || $curlResult->Status=='AUTHRECEIVED') && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK'){

                $connection = Yii::$app->db;

                $isDuplicateMerchantID = false;
                if (!empty($curlResult->ExternalReference)) {
                    $chk_extRef = $connection->createCommand("select id from user_payment_history where order_number!='" . $OrderReferenceNumber . "' and merchant_id='" . $curlResult->ExternalReference . "'  ORDER BY id DESC")->queryOne();
                    if (!empty($chk_extRef)) {
                        $isDuplicateMerchantID = true;
                    }
                }

                $uph_row = $connection->createCommand("select id from user_payment_history where order_number='" . $OrderReferenceNumber . "' ORDER BY id DESC")->queryOne();
                //print_r($uph_row);
                if (!empty($uph_row)) {
                    $final_result['error_msg'] = 'This order is already available into our database. Can not re-insert again.';
                    $final_result['success'] = 0;
                } else if ($isDuplicateMerchantID == true) {
                    $time = new \DateTime('now');
                    $timestamp = $time->getTimestamp();
                    $final_result['error_msg'] = 'External Order Reference entered in 2checkout panel is already exist into our database. Please, change it from your 2checkout panel. It must be in this format: Lf_<CurrentTimestampInSeconds>_<AnyAlphaNumericStringUpto15Characters> eg: Lf_' . $timestamp . '_' . substr(Yii::$app->security->generateRandomString(), 0, 15);
                    $final_result['success'] = 0;
                } else if (empty($curlResult->ExternalReference)) {
                    $time = new \DateTime('now');
                    $timestamp = $time->getTimestamp();
                    $final_result['error_msg'] = 'External Order Reference is not found. First you need to insert it from your 2checkout panel for this order. It must be in this format: Lf_<CurrentTimestampInSeconds>_<AnyAlphaNumericStringUpto15Characters> eg: Lf_' . $timestamp . '_' . substr(Yii::$app->security->generateRandomString(), 0, 15);
                    $final_result['success'] = 0;
                } else {

                    if (isset($curlResult->Items[0]->ProductDetails->Name) && isset($curlResult->Items[0]->Code)) {

                        $plan_array = array('LFPM' => 'Professional Monthly', 'LFPQ' => 'Professional Quarterly', 'LFGM' => 'Grow Monthly', 'LFGQ' => 'Grow Quarterly', 'LFUM' => 'Ultimate Monthly', 'LFUQ' => 'Ultimate Quarterly', 'LFUP' => 'Ultimate Plus',
                            'LFPSAR' => 'Professional Semi-Annually',
                            'LFPA' => 'Professional Annually',
                            'LFGSAR' => 'Grow Semi-Annually',
                            'LFGA' => 'Grow Annually',
                            'LFUSAR' => 'Ultimate Semi-Annually',
                            'LFUA' => 'Ultimate Annually',
                            'LFPSA' => 'Professional Semi Annual Black Friday Plan',
                            'LFGSA' => 'Grow Semi-Annual Black Friday Plan',
                            'LFUSA' => 'Ultimate Semi-Annual Black Friday Plan',
                            'LFPABF' => 'Professional Annual Black Friday Plan',
                            'LFGABF' => 'Grow Annual Black Friday Plan',
                            'LFUABF' => 'Ultimate Annual Black Friday Plan',
                            'LFGM_v2' => 'Grow Monthly',
                            'LFUM_v2' => 'Ultimate Monthly',
                            'LFGSAR_v2' => 'Grow Semi-Annually',
                            'LFUSAR_v2' => 'Ultimate Semi-Annually',
                            'LFGA_v2' => 'Grow Annually',
                            'LFUA_v2' => 'Ultimate Annually',
                        );

                        $return_product = array();
                        $isUnknownProductFound = false;
                        $Items = $curlResult->Items;
                        foreach ($Items as $item_key => $item_res) {
                            $product_id = $item_res->Code; //this is product code eg: LFPM
                            if (isset($plan_array[$product_id])) {
                                $return_product['product_codes'][] = $product_id;
                                $return_product['product_names'][] = $plan_array[$product_id];
                                $return_product['product_qty'][] = $item_res->Quantity;
                            } else {
                                $isUnknownProductFound = true;
                            }
                        }

                        if ($isUnknownProductFound) {
                            $final_result['error_msg'] = 'This order contains Product Code which is not setup here.';
                            $final_result['success'] = 0;
                        } else {
                            $final_result['success'] = 1;
                            $final_result['return_product'] = $return_product;
                        }
                    } else {
                        $final_result['error_msg'] = 'Product not found in this order.';
                        $final_result['success'] = 0;
                    }
                }
                //}
            } else {
                $final_result['error_msg'] = 'failed.';
                $final_result['success'] = 0;
            }
        }

        echo json_encode($final_result);
    }

    public function actionValidate_order_info() {
        //Usage: To insert buy link order into database, first validate that order and return the product codes available.

        $final_result = array();
        $final_result['success'] = 1;

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            //return $this->redirect($url);
            $final_result['redirect_url'] = $url;
            $final_result['success'] = 0;
        }

        //echo '<pre>'; print_r($_POST);die;

        if (!isset($_POST['orderRef']) || empty($_POST['orderRef'])) {
            $final_result['error_msg'] = 'Enter Order Reference Number.';
            $final_result['success'] = 0;
        }

        if ($final_result['success'] == 1) {

            if (YII_ENV_PROD) {
                //production
                $merchantCode = "203537015";
                $key = 'd?q4rkG]&KAh#vwnmSJ%';
            } else {
                //staging
                $merchantCode = "251108887711"; // your account's merchant code available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
                $key = '!G2S8WRBKJ6#&c~luOz='; // your account's secret key available in the 'System settings' area of the cPanel: https://secure.avangate.com/cpanel/account_settings.php
            }

            $gmdate = gmdate('Y-m-d H:i:s');
            $string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
            $hashAlgorithm = 'sha256';
            $hash = hash_hmac($hashAlgorithm , $string, $key);

            //$OrderReferenceNumber = trim($_POST['orderRef']);
            $OrderReferenceNumber = trim(\Yii::$app->request->post('orderRef'));
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/orders/' . $OrderReferenceNumber . '/');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

            $headers = array();
            $headers[] = 'Accept: application/json';
            $headers[] = 'Content-Type: application/json';
            $headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            $curl_result = curl_exec($ch);

            $curlResult = json_decode($curl_result);
            //echo '<br/>res:<pre>'; print_r($curlResult);echo '</pre>';
            if (curl_errno($ch)) {
                //echo 'Error:' . curl_error($ch);
            }
            curl_close($ch);
            //echo '<br/>';

            if (isset($curlResult->error_code)) {
                $final_result['error_msg'] = $curlResult->message;
                $final_result['success'] = 0;
            } else if ($curlResult) {

                //if(($curlResult->Status=='COMPLETE' || $curlResult->Status=='AUTHRECEIVED') && $curlResult->ApproveStatus=='OK' && $curlResult->VendorApproveStatus=='OK'){

                $connection = Yii::$app->db;

                $isDuplicateMerchantID = false;
                if (!empty($curlResult->ExternalReference)) {
                    $chk_extRef = $connection->createCommand("select id from user_payment_history where order_number!='" . $OrderReferenceNumber . "' and merchant_id='" . $curlResult->ExternalReference . "'  ORDER BY id DESC")->queryOne();
                    if (!empty($chk_extRef)) {
                        $isDuplicateMerchantID = true;
                    }
                }

                $uph_row = $connection->createCommand("select id from user_payment_history where order_number='" . $OrderReferenceNumber . "' ORDER BY id DESC")->queryOne();
                //print_r($uph_row);
                if (!empty($uph_row)) {
                    $final_result['error_msg'] = 'This order is already available into our database. Can not re-insert again.';
                    $final_result['success'] = 0;
                } else if ($isDuplicateMerchantID == true) {
                    $time = new \DateTime('now');
                    $timestamp = $time->getTimestamp();
                    $final_result['error_msg'] = 'External Order Reference entered in 2checkout panel is already exist into our database. Please, change it from your 2checkout panel. It must be in this format: Lf_<CurrentTimestampInSeconds>_<AnyAlphaNumericStringUpto15Characters> eg: Lf_' . $timestamp . '_' . substr(Yii::$app->security->generateRandomString(), 0, 15);
                    $final_result['success'] = 0;
                } else if (empty($curlResult->ExternalReference)) {
                    $time = new \DateTime('now');
                    $timestamp = $time->getTimestamp();
                    $final_result['error_msg'] = 'External Order Reference is not found. First you need to insert it from your 2checkout panel for this order. It must be in this format: Lf_<CurrentTimestampInSeconds>_<AnyAlphaNumericStringUpto15Characters> eg: Lf_' . $timestamp . '_' . substr(Yii::$app->security->generateRandomString(), 0, 15);
                    $final_result['success'] = 0;
                } else {

                    if (isset($curlResult->Items[0]->ProductDetails->Name) && isset($curlResult->Items[0]->Code)) {

                        $plan_array = array('LFPM' => 'Professional Monthly', 'LFPQ' => 'Professional Quarterly', 'LFGM' => 'Grow Monthly', 'LFGQ' => 'Grow Quarterly', 'LFUM' => 'Ultimate Monthly', 'LFUQ' => 'Ultimate Quarterly', 'LFUP' => 'Ultimate Plus',
                            'LFPSAR' => 'Professional Semi-Annually',
                            'LFPA' => 'Professional Annually',
                            'LFGSAR' => 'Grow Semi-Annually',
                            'LFGA' => 'Grow Annually',
                            'LFUSAR' => 'Ultimate Semi-Annually',
                            'LFUA' => 'Ultimate Annually',
                            'LFPSA' => 'Professional Semi Annual Black Friday Plan',
                            'LFGSA' => 'Grow Semi-Annual Black Friday Plan',
                            'LFUSA' => 'Ultimate Semi-Annual Black Friday Plan',
                            'LFPABF' => 'Professional Annual Black Friday Plan',
                            'LFGABF' => 'Grow Annual Black Friday Plan',
                            'LFUABF' => 'Ultimate Annual Black Friday Plan',
                            'LFGM_v2' => 'Grow Monthly',
                            'LFUM_v2' => 'Ultimate Monthly',
                            'LFGSAR_v2' => 'Grow Semi-Annually',
                            'LFUSAR_v2' => 'Ultimate Semi-Annually',
                            'LFGA_v2' => 'Grow Annually',
                            'LFUA_v2' => 'Ultimate Annually',
                        );

                        $return_product = array();
                        $isUnknownProductFound = false;
                        $Items = $curlResult->Items;
                        $addOnPackProduct_array = array('LFAddOnPack' => 'Booster Pack'); //21-06-2021 added

                        if (isset($addOnPackProduct_array[$curlResult->Items[0]->Code])) {
                            //addOnPackProduct added on 21-06-2021
                            //note:only exclusive add on pack order is supported. ie. the order must contains only add-on pack product in it.
                            foreach ($Items as $item_key => $item_res) {
                                $product_id = $item_res->Code; //this is product code eg: LFPM
                                if (isset($addOnPackProduct_array[$product_id])) {
                                    $return_product['product_codes'][] = $product_id;
                                    $return_product['product_names'][] = $addOnPackProduct_array[$product_id];
                                    $return_product['product_qty'][] = $item_res->Quantity;
                                } else {
                                    $isUnknownProductFound = true;
                                }
                            }
                        } else {
                            foreach ($Items as $item_key => $item_res) {
                                $product_id = $item_res->Code; //this is product code eg: LFPM
                                if (isset($plan_array[$product_id])) {
                                    $return_product['product_codes'][] = $product_id;
                                    $return_product['product_names'][] = $plan_array[$product_id];
                                    $return_product['product_qty'][] = $item_res->Quantity;
                                } else {
                                    $isUnknownProductFound = true;
                                }
                            }
                        }
                        if ($isUnknownProductFound) {
                            $final_result['error_msg'] = 'This order contains Product Code which is not setup here.';
                            $final_result['success'] = 0;
                        } else {
                            $final_result['success'] = 1;
                            $final_result['return_product'] = $return_product;
                        }
                    } else {
                        $final_result['error_msg'] = 'Product not found in this order.';
                        $final_result['success'] = 0;
                    }
                }
                //}
            } else {
                $final_result['error_msg'] = 'failed.';
                $final_result['success'] = 0;
            }
        }

        echo json_encode($final_result);
    }

    public function successedPayment($payment_info) {
        $email = $payment_info['ses_email'];
        $html = $this->renderPartial('/../mail/paymentsuccessed', ['value' => $payment_info, 'fullname' => $payment_info['ses_full_name']]);

        if (YII_ENV_PROD) {
            //production
            $email_subject = 'Thank you for upgrading your ' . Yii::$app->params['emailFromName'] . ' subscription !';
            $bccEmail = ['arpan@intricare.net'];
        } else {
            //staging
            $email_subject = 'STAGING TEST - Thank you for upgrading your ' . Yii::$app->params['emailFromName'] . ' subscription !';
            $bccEmail = ['nikit@intricaretech.com'];
        }

        /* if($payment_info['previous_plan'] == 'Free Forever'){
          $mail = Yii::$app->mailer->compose()
          ->setTo($email)
          ->setBcc('nikit@intricaretech.com')
          //->setFrom(['payments@intricare.net'=>Yii::$app->params['emailFromName'].' Payments'])
          //->setFrom(['arpan@intricare.net'=>Yii::$app->params['emailFromName'].' Payments'])
          ->setFrom(['dhaval.thakor@linkedfusion.io'=>Yii::$app->params['emailFromName'].' Payments'])
          //->setReplyTo()
          ->setSubject('STAGING TEST - Thank for subscribing to '.Yii::$app->params['emailFromName'].'!')
          ->setHtmlBody($html,'text/html');
          $mail->send();
          }else{ */
        $mail = Yii::$app->mailer->compose()
                ->setTo($email)
                ->setBcc($bccEmail)
                //->setFrom(['payments@intricare.net'=>Yii::$app->params['emailFromName'].' Payments'])
                //->setFrom(['arpan@intricare.net'=>Yii::$app->params['emailFromName'].' Payments'])
                //->setFrom(['dhaval.thakor@linkedfusion.io'=>Yii::$app->params['emailFromName'].' Payments'])
                ->setFrom([Yii::$app->params['adminEmail'] => Yii::$app->params['emailFromName'] . ' Payments'])
                //->setReplyTo()
                ->setSubject($email_subject)
                ->setHtmlBody($html, 'text/html');
        $mail->send();
        //}
    }

    //18-06-2021
    public function successedPaymentAddOnPackExclusiveOrder($payment_info) {
        $email = $payment_info['ses_email'];
        $html = $this->renderPartial('/../mail/paymentsuccessedAddOnPackExclusiveOrder', ['value' => $payment_info, 'fullname' => $payment_info['ses_full_name']]);

        if (YII_ENV_PROD) {
            //production
            $email_subject = 'Thank you for purchasing Booster Pack!';
            $bccEmail = ['arpan@intricare.net'];
        } else {
            //staging
            $email_subject = 'STAGING TEST - Thank you for purchasing Booster Pack!';
            $bccEmail = ['nikit@intricaretech.com'];
        }

        $mail = Yii::$app->mailer->compose()
                ->setTo($email)
                ->setBcc($bccEmail)
                ->setFrom([Yii::$app->params['adminEmail'] => Yii::$app->params['emailFromName'] . ' Payments'])
                ->setSubject($email_subject)
                ->setHtmlBody($html, 'text/html');
        $mail->send();
    }

    //22-02-2021
    public function actionRelease_subscription() {
        //Usage: Initiate Release subscription request for 2checkout subscription which is handled by system;
        //echo Yii::$app->session->get('useremail').'::'.Yii::$app->session->get('userid'); die;
        //echo '<pre>'; print_r($_POST);die;

        $final_result = array();
        $final_result['success'] = 1;

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            //return $this->redirect($url);
            $final_result['redirect_url'] = $url;
            $final_result['error_msg'] = 'Need to re-login as the login session is expired.';
            $final_result['success'] = 0;
        }

        if (!isset($_POST['releasedUserId']) || empty($_POST['releasedUserId'])) {
            $final_result['error_msg'] = 'User not found.';
            $final_result['success'] = 0;
        }
        $releasedUserId = $_POST['releasedUserId'];

        $releasedUserRow = Yii::$app->db->createCommand("select * from user where id='" . $releasedUserId . "' ORDER BY id DESC")->queryOne();
        if (empty($releasedUserRow)) {
            $final_result['error_msg'] = 'User not found.';
            $final_result['success'] = 0;
        }

        $getLastestUserSubscription = Yii::$app->mycomponent->get_latest_subscription($releasedUserId);
        //echo '<pre>';print_r($getLastestUserSubscription);die;
        if (!empty($getLastestUserSubscription)) {
            $LICENSE_CODE = $getLastestUserSubscription['SubscriptionReference'];


            $product_id = $getLastestUserSubscription['product_id']; //eg:LFPM
            $current_user_setting_plan_array = array('LFPM' => '1', 'LFPQ' => '2', 'LFGM' => '3', 'LFGQ' => '4', 'LFUM' => '5', 'LFUQ' => '6',
                'LFPSAR' => '8',
                'LFPA' => '9',
                'LFGSAR' => '10',
                'LFGA' => '11',
                'LFUSAR' => '12',
                'LFUA' => '13',
                'LFPSA' => '1', 'LFPABF' => '2', 'LFGSA' => '3', 'LFGABF' => '4', 'LFUSA' => '5', 'LFUABF' => '6',
                'LFGM_v2' => '18', 'LFUM_v2' => '19', 'LFGSAR_v2' => '20', 'LFUSAR_v2' => '21', 'LFGA_v2' => '22', 'LFUA_v2' => '23'
            );

            if (!array_key_exists($product_id, $current_user_setting_plan_array)) {
                $final_result['error_msg'] = 'The Product is not supported.';
                $final_result['success'] = 0;
            }

            $allLfBlackFridayProductCodesArr = array(
                "LFPSA",
                "LFPABF",
                "LFGSA",
                "LFGABF",
                "LFUSA",
                "LFUABF"
            );

            $isLfBlackFridayProductInIPN = false;
            if (in_array($product_id, $allLfBlackFridayProductCodesArr)) {
                $isLfBlackFridayProductInIPN = true;
            }

            if (YII_ENV_PROD) {
                //production
                $merchantCode = "203537015";
                $key = 'd?q4rkG]&KAh#vwnmSJ%';
            } else {
                //staging
                $merchantCode = "251108887711";
                $key = '!G2S8WRBKJ6#&c~luOz=';
            }

            $gmdate = gmdate('Y-m-d H:i:s');
            $string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
            $hashAlgorithm = 'sha256';
            $hash = hash_hmac($hashAlgorithm , $string, $key);

            //Retrieve a subscription
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/subscriptions/' . $LICENSE_CODE . '/');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

            $headers = array();
            $headers[] = 'Accept: application/json';
            $headers[] = 'Content-Type: application/json';
            $headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            $curl_result = curl_exec($ch);

            $curlResultSub = json_decode($curl_result);
//echo '<br/>subscription res:<pre>'; print_r($curlResultSub);echo '</pre>';
            if (curl_errno($ch)) {
                //echo 'Error:' . curl_error($ch);
                $final_result['error_msg'] = 'An error occurred while fetching subscription data from an API. Error:' . curl_error($ch);
                $final_result['success'] = 0;
            }
            curl_close($ch);

            if ($final_result['success'] == 1) {
                if ($curlResultSub->Status == 'ACTIVE') {

                    //echo '<br/>:::'.$curlResultSub->ExpirationDate;
                    if ($isLfBlackFridayProductInIPN == true) {
                        //as the api provides wrong ExpirationDate eg: 9999-12-31 for blackfriday plans (which is one time product), get it from database;
                        $subExpirationDateTimestamp = strtotime($getLastestUserSubscription['ExpirationDate']);
                    } else {
                        $subExpirationDateTimestamp = strtotime($curlResultSub->ExpirationDate);
                    }

                    //echo '<br/>A:'.$subExpirationDateTimestamp;
                    //echo '<br/>A:'.date('Y-m-d H:i:s',$subExpirationDateTimestamp);
                    $currentTimestamp = time();
                    //echo '<br/>B:'.$currentTimestamp;
                    //echo '<br/>B:'.date('Y-m-d H:i:s',$currentTimestamp);
                    //echo '<br/>B:'.date('Y-m-d H:i:s',strtotime('+330 minutes', $currentTimestamp));
                    //echo '<br/>C:'.date('Y-m-d H:i:s',strtotime('+330 minutes', $subExpirationDateTimestamp));
                    //https://stackoverflow.com/questions/13216185/php-converting-gmt-to-ist

                    if ($subExpirationDateTimestamp > $currentTimestamp) {

                        $OrderReferenceNumber = $curlResultSub->LatestSubscriptionOrder->RefNo;

                        $latest_uph_orderRow = Yii::$app->db->createCommand("select id,userid,response_get from user_payment_history where order_number='" . $OrderReferenceNumber . "' ORDER BY id DESC")->queryOne();
                        if (!empty($latest_uph_orderRow)) {

                            $time = new \DateTime('now');
                            $timestamp = $time->getTimestamp();
                            $unique_code = $timestamp . '_' . substr(Yii::$app->security->generateRandomString(), 0, 15);

                            //echo Yii::$app->session->get('useremail').'::'.Yii::$app->session->get('userid'); die;
                            $user_note_txt = 'Release Licence (# ' . $LICENSE_CODE . ') request initiated by ' . Yii::$app->session->get('useremail') . ' | Generated Unique Code: ' . $unique_code . ' | For user #' . $releasedUserRow['id'] . ' ie. ' . $releasedUserRow['email'] . ' sublevel is changed to (0) from (' . $releasedUserRow['sublevel'] . ') | DateTime : ' . date('Y-m-d H:i:s');


                            Yii::$app->db->createCommand("INSERT INTO user_notes SET user_id=" . $releasedUserId . ", note='" . $user_note_txt . "', last_updated_by='" . Yii::$app->session->get('userid') . "', updated_at='" . date('d M Y h:i:s A') . "' ")->execute();

                            Yii::$app->db->createCommand("UPDATE user SET sublevel='0', trial=1, subscriptionExpiredAt=NULL WHERE id = '" . $releasedUserId . "' ")->execute();
                            Yii::$app->db->createCommand("UPDATE user_order_products SET releaseLicUniqueCode='" . $unique_code . "', releaseLicUserId='" . $releasedUserId . "' WHERE id = '" . $getLastestUserSubscription['id'] . "' ")->execute();

                            $final_result['success'] = 1;
                            $final_result['success_msg'] = 'Release licence request successfully initiated for Subscription Reference #' . $LICENSE_CODE . '.';
                            $final_result['unique_code'] = $unique_code;
                        } else {
                            $final_result['error_msg'] = 'For subscription ' . $LICENSE_CODE . ', the latest order reference ' . $OrderReferenceNumber . ' is not found in our database. Release & Attach Subscription feature will work ONLY for system handled orders/subscriptions.';
                            $final_result['success'] = 0;
                        }
                    } else {
                        if ($isLfBlackFridayProductInIPN == true) {
                            $subsc_ed = $getLastestUserSubscription['ExpirationDate'];
                        } else {
                            $subsc_ed = $curlResultSub->ExpirationDate;
                        }
                        $final_result['error_msg'] = 'The subscription ' . $LICENSE_CODE . ' is expired. Expired Date:' . $subsc_ed;
                        $final_result['success'] = 0;
                    }
                } else {
                    $final_result['error_msg'] = 'The current status of subscription ' . $LICENSE_CODE . ' is not ACTIVE.';
                    $final_result['success'] = 0;
                }
            }
        } else {
            $final_result['error_msg'] = 'Subscription data not found for this user. Release & Attach Subscription feature will work ONLY for system handled orders/subscriptions.';
            $final_result['success'] = 0;
        }
        echo json_encode($final_result);
    }

    //22-02-2021
    public function actionAttach_subscription() {
        //Usage: Attach "Released subscription" request for 2checkout subscription which is handled by system;
        //echo Yii::$app->session->get('useremail').'::'.Yii::$app->session->get('userid'); die;
        //echo '<pre>'; print_r($_POST);die;

        $final_result = array();
        $final_result['success'] = 1;


        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            //return $this->redirect($url);
            $final_result['redirect_url'] = $url;
            $final_result['error_msg'] = 'Need to re-login as the login session is expired.';
            $final_result['success'] = 0;
        }

        if (!isset($_POST['attachedUserId']) || empty($_POST['attachedUserId'])) {
            $final_result['error_msg'] = 'User not found.';
            $final_result['success'] = 0;
        }
        $attachedUserId = $_POST['attachedUserId'];

        $attachedUserRow = Yii::$app->db->createCommand("select * from user where id='" . $attachedUserId . "' ORDER BY id DESC")->queryOne();
        if (empty($attachedUserRow)) {
            $final_result['error_msg'] = 'User not found.';
            $final_result['success'] = 0;
        }

        $releasedLicUniqueCode = $_POST['releasedLicUniqueCode'];

        $getLastestUserSubscription = Yii::$app->db->createCommand("select * from user_order_products where releaseLicUniqueCode = '" . $releasedLicUniqueCode . "' ORDER BY id DESC")->queryOne();
        if (!empty($getLastestUserSubscription)) {
            $LICENSE_CODE = $getLastestUserSubscription['SubscriptionReference'];
            $releasedUserId = $getLastestUserSubscription['releaseLicUserId'];

            $releasedUserRow = Yii::$app->db->createCommand("select email from user where id='" . $releasedUserId . "' ORDER BY id DESC")->queryOne();
            if (empty($releasedUserRow)) {
                $final_result['error_msg'] = 'User not found.';
                $final_result['success'] = 0;
            }

            if (YII_ENV_PROD) {
                //production
                $merchantCode = "203537015";
                $key = 'd?q4rkG]&KAh#vwnmSJ%';
            } else {
                //staging
                $merchantCode = "251108887711";
                $key = '!G2S8WRBKJ6#&c~luOz=';
            }

            $gmdate = gmdate('Y-m-d H:i:s');
            $string = strlen($merchantCode) . $merchantCode . strlen($gmdate) . $gmdate;
            $hashAlgorithm = 'sha256';
            $hash = hash_hmac($hashAlgorithm , $string, $key);

            //Retrieve a subscription
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://api.avangate.com/rest/6.0/subscriptions/' . $LICENSE_CODE . '/');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

            $headers = array();
            $headers[] = 'Accept: application/json';
            $headers[] = 'Content-Type: application/json';
            $headers[] = 'X-Avangate-Authentication: code="'.$merchantCode.'" date="'.$gmdate.'" hash="'.$hash.'" algo="'.$hashAlgorithm.'"';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            $curl_result = curl_exec($ch);

            $curlResultSub = json_decode($curl_result);
            //echo '<br/>subscription res:<pre>'; print_r($curlResultSub);echo '</pre>';
            if (curl_errno($ch)) {
                //echo 'Error:' . curl_error($ch);
                $final_result['error_msg'] = 'An error occurred while fetching subscription data from an API. Error:' . curl_error($ch);
                $final_result['success'] = 0;
            }
            curl_close($ch);


            $product_id = $curlResultSub->Product->ProductCode; //eg:LFPM
            $current_user_setting_plan_array = array('LFPM' => '1', 'LFPQ' => '2', 'LFGM' => '3', 'LFGQ' => '4', 'LFUM' => '5', 'LFUQ' => '6',
                'LFPSAR' => '8',
                'LFPA' => '9',
                'LFGSAR' => '10',
                'LFGA' => '11',
                'LFUSAR' => '12',
                'LFUA' => '13',
                'LFPSA' => '1', 'LFPABF' => '2', 'LFGSA' => '3', 'LFGABF' => '4', 'LFUSA' => '5', 'LFUABF' => '6',
                'LFGM_v2' => '18', 'LFUM_v2' => '19', 'LFGSAR_v2' => '20', 'LFUSAR_v2' => '21', 'LFGA_v2' => '22', 'LFUA_v2' => '23'
            );

            if (array_key_exists($product_id, $current_user_setting_plan_array)) {
                $current_user_setting_plan = $current_user_setting_plan_array[$product_id]; //eg:5
            } else {
                $final_result['error_msg'] = 'The product is not supported.';
                $final_result['success'] = 0;
            }

            $allLfBlackFridayProductCodesArr = array(
                "LFPSA",
                "LFPABF",
                "LFGSA",
                "LFGABF",
                "LFUSA",
                "LFUABF"
            );

            $isLfBlackFridayProductInIPN = false;
            if (in_array($product_id, $allLfBlackFridayProductCodesArr)) {
                $isLfBlackFridayProductInIPN = true;
            }

            if ($final_result['success'] == 1) {
                if ($curlResultSub->Status == 'ACTIVE') {

                    //echo '<br/>:::'.$curlResultSub->ExpirationDate;

                    if ($isLfBlackFridayProductInIPN == true) {
                        //as the api provides wrong ExpirationDate eg: 9999-12-31 for blackfriday plans (which is one time product), get it from database;
                        $subExpirationDateTimestamp = strtotime($getLastestUserSubscription['ExpirationDate']) * 1000;
                    } else {
                        $subExpirationDateTimestamp = strtotime($curlResultSub->ExpirationDate) * 1000;
                    }
                    //echo '<br/>A:'.$subExpirationDateTimestamp;
                    //echo '<br/>A:'.date('Y-m-d H:i:s',$subExpirationDateTimestamp);
                    $currentTimestamp = time() * 1000;
                    //echo '<br/>B:'.$currentTimestamp;
                    //echo '<br/>B:'.date('Y-m-d H:i:s',$currentTimestamp);
                    //echo '<br/>B:'.date('Y-m-d H:i:s',strtotime('+330 minutes', $currentTimestamp));
                    //echo '<br/>C:'.date('Y-m-d H:i:s',strtotime('+330 minutes', $subExpirationDateTimestamp));
                    //https://stackoverflow.com/questions/13216185/php-converting-gmt-to-ist
                    if ($isLfBlackFridayProductInIPN == true) {
                        $ExpirationDate = $getLastestUserSubscription['ExpirationDate'];
                    } else {
                        $ExpirationDate = date('Y-m-d H:i:s', strtotime('+330 minutes', strtotime($curlResultSub->ExpirationDate)));
                    }


                    if ($subExpirationDateTimestamp > $currentTimestamp) {

                        $OrderReferenceNumber = $curlResultSub->LatestSubscriptionOrder->RefNo;

                        $latest_uph_orderRow = Yii::$app->db->createCommand("select id,userid,response_get from user_payment_history where order_number='" . $OrderReferenceNumber . "' ORDER BY id DESC")->queryOne();
                        if (!empty($latest_uph_orderRow)) {



                            //echo Yii::$app->session->get('useremail').'::'.Yii::$app->session->get('userid'); die;
                            $user_note_txt = 'Attach Licence (# ' . $LICENSE_CODE . ') request performed by ' . Yii::$app->session->get('useremail') . ' | Entered Unique Code: ' . $releasedLicUniqueCode . ' | Released User was #' . $releasedUserId . ' ie. ' . $releasedUserRow['email'] . ' | For user #' . $attachedUserRow['id'] . ' ie. ' . $attachedUserRow['email'] . ' sublevel is changed to (' . $current_user_setting_plan . ') from (' . $attachedUserRow['sublevel'] . ') | DateTime : ' . date('Y-m-d H:i:s');


                            $uop_allUserIDs = explode(',', $getLastestUserSubscription['user_ids']);
                            //echo '<br/>before:';print_r($uop_allUserIDs);
                            foreach ($uop_allUserIDs as $key => $uid) {
                                if ($uid == $releasedUserId) {
                                    $uop_allUserIDs[$key] = $attachedUserId; //replace with attachedUserId
                                }
                            }
                            $uop_allUserIDs = array_unique($uop_allUserIDs);
                            $uop_allUserIDs = implode(',', $uop_allUserIDs);


                            Yii::$app->db->createCommand("INSERT INTO user_notes SET user_id=" . $attachedUserId . ", note='" . $user_note_txt . "', last_updated_by='" . Yii::$app->session->get('userid') . "', updated_at='" . date('d M Y h:i:s A') . "' ")->execute();

                            Yii::$app->db->createCommand("UPDATE user SET sublevel='" . $current_user_setting_plan . "', trial=0, trial_expired_at='" . $subExpirationDateTimestamp . "', subscriptionExpiredAt='" . $subExpirationDateTimestamp . "' WHERE id = '" . $attachedUserRow['id'] . "' ")->execute();
                            Yii::$app->db->createCommand("UPDATE user_order_products SET releaseLicUniqueCode=NULL, releaseLicUserId=NULL, user_ids='" . $uop_allUserIDs . "',ExpirationDate = '" . $ExpirationDate . "'  WHERE id = '" . $getLastestUserSubscription['id'] . "' ")->execute();


                            $final_result['success'] = 1;
                            $final_result['success_msg'] = 'Attach licence request successfully performed for Subscription Reference #' . $LICENSE_CODE;
                        } else {
                            $final_result['error_msg'] = 'For subscription ' . $LICENSE_CODE . ', the latest order reference ' . $OrderReferenceNumber . ' is not found in our database. Release & Attach Subscription feature will work ONLY for system handled orders/subscriptions.';
                            $final_result['success'] = 0;
                        }
                    } else {
                        if ($isLfBlackFridayProductInIPN == true) {
                            $subsc_ed = $getLastestUserSubscription['ExpirationDate'];
                        } else {
                            $subsc_ed = $curlResultSub->ExpirationDate;
                        }
                        $final_result['error_msg'] = 'The subscription ' . $LICENSE_CODE . ' is expired. Expired Date:' . $subsc_ed;
                        $final_result['success'] = 0;
                    }
                } else {
                    $final_result['error_msg'] = 'The current status of subscription ' . $LICENSE_CODE . ' is not ACTIVE.';
                    $final_result['success'] = 0;
                }
            }
        } else {
            $final_result['error_msg'] = 'The entered unique code does not found.';
            $final_result['success'] = 0;
        }
        echo json_encode($final_result);
    }

    function actionAddtocovideo() {

        $Userid = Yii::$app->request->post('covideoUserid');
        $firstName = Yii::$app->request->post('firstnameCovideo');
        $lastName = Yii::$app->request->post('lastnameCovideo');
        $emailCovideo = Yii::$app->request->post('emailCovideo');
        $passwordCovideo = Yii::$app->request->post('passwordCovideo');
        $companyCovideo = Yii::$app->request->post('companyCovideo');
        $phoneCovideo = Yii::$app->request->post('phoneCovideo');

        $data = array("firstName" => $firstName, "lastName" => $lastName, "email" => $emailCovideo, "password" => $passwordCovideo, "company" => $companyCovideo, "phone" => $phoneCovideo);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.covideo.com/whitelabel/user');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
//        curl_setopt($ch, CURLOPT_POSTFIELDS, '{
//                "firstName": "John",
//                "lastName": "Doe",
//                "email": "john.doe@somecompany.com",
//                "password": "mysecurepassword",
//                "company":"My Company Name",
//                "phone":"555-555-5555"
//              }');

        $headers = array();
        $headers[] = 'Authorization: Jt4aQ9HZxmHRLyMkPddAlEV313CKgP8B';
        $headers[] = 'Content-Type: application/json';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);
        $res = json_decode($result, true);
        if (isset($res['name']) && $res['name'] == "Error") {
            return $res['message'];
        } else {
            Yii::$app->db->createCommand("UPDATE user SET coVideoId='" . $res['userId'] . "' WHERE id = '" . $Userid . "' ")->execute();
            return "User added";
        }
    }

    //04-04-2022
    function actionCreate_quickbook_estimate() {
        // echo 'Quickbook_estimate hh';die;

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (\Yii::$app->session->get('salesperson') == 0)
            throw new \yii\web\NotFoundHttpException();


        $portal_id = Yii::$app->session->get('portal_id');



        // $UserDetails = [];
        // $lead_plans = Yii::$app->db->createCommand("SELECT sublevel,name FROM `lead_plans` order by sublevel")->queryAll();

        if (isset($_POST['quickbook_customerDisplayName'])) {
            // echo '<pre>'; print_r($_POST);die;
            // echo '<pre>'; print_r(Yii::$app->request->post());die;

            $isValidationPassed = true;
            if (empty($_POST['quickbook_customerDisplayName'])) {
                $final_result['success'] = 0;
                $final_result['error_msg'] = 'Customer Display Name is required.';
                $isValidationPassed = false;
            } else {

                $explodeDisplayName = explode('-', $_POST['quickbook_customerDisplayName']);
                if (count($explodeDisplayName) == 3) {
                    $customerEmail = $explodeDisplayName[1]; // eg: example@intricare.net
                    $customerCurrencyCode = $explodeDisplayName[2]; //'USD';
                    $customer_FullName = $explodeDisplayName[0]; //eg: John Doe
                } else {
                    $final_result['success'] = 0;
                    $final_result['error_msg'] = 'Customer Display Name must be in this format: <Customer Name>-<Customer Email>-<CurrencyCode> eg: John Doe-example@email.com-USD';
                    $isValidationPassed = false;
                }
            }

            foreach ($_POST['item_rate'] as $key => $val) {
                if (empty($val)) {
                    $final_result['success'] = 0;
                    $final_result['error_msg'] = 'Item Rate is required.';
                    $isValidationPassed = false;
                }
            }

            foreach ($_POST['item_qty'] as $key => $val) {
                if (empty($val)) {
                    $final_result['success'] = 0;
                    $final_result['error_msg'] = 'Item Qty is required.';
                    $isValidationPassed = false;
                } else if (is_int($val)) {
                    $final_result['success'] = 0;
                    $final_result['error_msg'] = 'Item Qty must be integer.';
                    $isValidationPassed = false;
                }
            }

            foreach ($_POST['item_description'] as $key => $val) {
                if (empty($val)) {
                    $final_result['success'] = 0;
                    $final_result['error_msg'] = 'Item Description is required.';
                    $isValidationPassed = false;
                }
            }

            //12-01-2023 starts (discount can not be in multi-line)
            if(!empty($_POST['discountAmt']) ){
                if(!is_numeric($_POST['discountAmt'])){
                    $final_result['success'] = 0;
                    $final_result['error_msg'] = 'Discount amount is invalid.';
                    $isValidationPassed = false;
                }
            }
            
            // echo '<br>ends here';die;
            //12-01-2023 ends

            if ($_POST['isQuickbookCustomerAlreadyExist'] == 1) {
                
            } else {

                // if(!isset($_POST['cust_company_name']) || empty($_POST['cust_company_name'])){
                // 	$final_result['success'] = 0;
                // 	$final_result['error_msg'] = 'Company Name is required.';
                // 	$isValidationPassed = false;
                // }

                if (!isset($_POST['est_billing_address']) || empty($_POST['est_billing_address'])) {
                    $final_result['success'] = 0;
                    $final_result['error_msg'] = 'Billing Address is required.';
                    $isValidationPassed = false;
                }
            }

            if (!isset($_POST['expiration_date']) || empty($_POST['expiration_date'])) {
                $final_result['success'] = 0;
                $final_result['error_msg'] = 'Expiration Date is required.';
                $isValidationPassed = false;
            }
            if (!isset($_POST['estimate_date']) || empty($_POST['estimate_date'])) {
                $final_result['success'] = 0;
                $final_result['error_msg'] = 'Estimate Date is required.';
                $isValidationPassed = false;
            }

            if (!$isValidationPassed) {
                echo json_encode($final_result);
                exit;
            }


            if (YII_ENV_PROD) {
                //production
                $curl_url = "https://app.leadconnect.io/QBOConceptsTutorial-PHP/api_CreateQbEstimate.php";
            } else {
                //staging
                // $curl_url = "https://nikit.intricare.net/leadconnect-backend/basic/QBOConceptsTutorial-PHP/api_ValidateAndGetQBCustomer.php";
                $curl_url = 'http://3.14.236.191/leadconnect-backend/basic/QBOConceptsTutorial-PHP/api_CreateQbEstimate.php';
            }

            $postFields = $_POST;
            // echo '<br/>dump fii:::<pre>'; var_dump($postFields);
            // echo '<br/>post fii:::<pre>'; print_r($postFields);die;
            //url-ify the data for the POST
            $post_string = http_build_query($postFields);

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => $curl_url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $post_string
            ));

            $curlres = curl_exec($curl);
            $getCurlHttpStatus = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            curl_close($curl);

            // echo 'getCurlHttpStatus:';print_r($getCurlHttpStatus);
            // echo 'curlres:'.$curlres;
            // $curl_res = json_decode($curlres);
            // echo '<pre>';print_r($curl_res);echo '</pre>';
            // die;

            if ($getCurlHttpStatus == 200) {

                // $curl_res = json_decode($curlres,true);
                $curl_res = json_decode($curlres);

                if ($curl_res->success == 1) {
                    $final_result['success'] = 1;
                    $final_result['success_msg'] = $curl_res->success_msg;
                } else {
                    $final_result['success'] = 0;
                    $final_result['error_msg'] = $curl_res->error_msg;
                }
                $final_result['curl_res'] = $curl_res;
            } else {
                $final_result['success'] = 0;
                $final_result['error_msg'] = 'Curl return status is not 200';
            }
            $final_result['curl_HttpStatus'] = $getCurlHttpStatus;
            echo json_encode($final_result);
            exit;
        }


        return $this->render('create_quickbook_estimate', [
                        // 'users' => $UserDetails,
                        // 'lead_plans' => $lead_plans,
        ]);
    }

    //04-04-2022
    public function actionValidate_quickbook_customer_displayname() {
        //Usage: This function will just check that the inputed quickbook's customer display name is exist or not. If it is exist then it will return customer Ref.

        $final_result = array();
        $final_result['success'] = 1;

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            //return $this->redirect($url);
            $final_result['redirect_url'] = $url;
            $final_result['success'] = 0;
        }


        if (!isset($_POST['quickbook_customerDisplayName']) || empty($_POST['quickbook_customerDisplayName'])) {
            $final_result['error_msg'] = 'Enter Quickbook Customer DisplayName.';
            $final_result['success'] = 0;
        }


        if ($final_result['success'] == 1) {

            // echo 'EREREERER:<pre>'; print_r($_POST);
            $explodeDisplayName = explode('-', $_POST['quickbook_customerDisplayName']);
            // echo '<pre>';print_r($explodeDisplayName);echo '</pre>';
            // echo count($explodeDisplayName);
            if (count($explodeDisplayName) == 3) {
                
            } else {
                $final_result['success'] = 0;
                $final_result['error_msg'] = 'Inputed customerDisplayName format is invalid. Make sure it must be like this: John Doe-example@email.com-USD';
            }
        }


        if ($final_result['success'] == 1) {

            if (YII_ENV_PROD) {
                //production
                $curl_url = "https://app.leadconnect.io/QBOConceptsTutorial-PHP/api_ValidateAndGetQBCustomer.php";
            } else {
                //staging
                // $curl_url = "https://nikit.intricare.net/leadconnect-backend/basic/QBOConceptsTutorial-PHP/api_ValidateAndGetQBCustomer.php";
                $curl_url = 'http://3.14.236.191/leadconnect-backend/basic/QBOConceptsTutorial-PHP/api_ValidateAndGetQBCustomer.php';
            }

            // $postFields = array("platform_type" => '1',"user_id" => Yii::$app->session->get('userid'),"twoCoCustomerReference" => $userDetail['2coCustomerReference'],"custFullName" => $_POST['custFullName'], "custBillingAddress" => $_POST['custBillingAddress'], "bill_city" => $_POST['bill_city'], "bill_country" => $_POST['bill_country'], "bill_state" => $_POST['bill_state'], "bill_postal_code" => $_POST['bill_postal_code']);
            $postFields = array("quickbook_customerDisplayName" => $_POST['quickbook_customerDisplayName']);
            //echo '<br/>post fii:::<pre>'; print_r($postFields);die;

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => $curl_url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $postFields,
            ));

            $curlres = curl_exec($curl);
            $getCurlHttpStatus = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            curl_close($curl);

            // echo 'getCurlHttpStatus:';print_r($getCurlHttpStatus);
            // echo 'curlres:'.$curlres;
            if ($getCurlHttpStatus == 200) {

                // $curl_res = json_decode($curlres,true);
                $curl_res = json_decode($curlres);

                if ($curl_res->success == 1) {
                    $final_result['success'] = 1;
                    $final_result['success_msg'] = $curl_res->success_msg;
                } else {
                    $final_result['success'] = 0;
                    $final_result['error_msg'] = $curl_res->error_msg;
                }
                $final_result['curl_res'] = $curl_res;
            } else {
                $final_result['success'] = 0;
                $final_result['error_msg'] = 'Curl return status is not 200';
            }
        }
        echo json_encode($final_result);
    }

}
