<?php

namespace app\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\db\Query;

class SalesforceController extends Controller {

    public $enableCsrfValidation = false;
    private $CLIENT_ID = "3MVG97quAmFZJfVy_BfLiz_O8UOrq1L7TLzWuigm0EhyvGrpDjFk67Oj0FfuXZwPlozjxgjg_7GdKdNeZVuzq";
    private $CLIENT_SECRET = "6352E94FB09DF6C02835EF8F1F9F24F25808CA74229F2413B698B6D306607079";
//    protected $contact_fields = ['FirstName', 'LastName', 'Email', 'AccountId', 'Org_Id__c', 'Email', 'Phone', 'Owner_Id__c', 'Website__c', "	Linkedin_Uid__c", "Linkedin__c", "Job_Title__c", "Contact_Source__c", "Contact_Assigned_By__c", "Sequence_Name__c"];
//    protected $company_fields = ['Name', 'Domain__c', "Linkedin_Company_Page__c"];
    public $company_array = ["name" => "Name", "domain" => "Domain", "linkedin_company_page" => "Linkedin Company Page","industryName" => "Industry Name"];
    public $contact_array = ["first_name" => "First Name", "last_name" => "Last Name", "email" => "Email", "linkedin_uid" => "linkedin_uid", "linkedin" => "Linkedin Profile URL",
        "job_title" => "Job Title", "contact_source" => "Contact Source", "contact_assigned_by" => "Contact Assigned By", "sequence_name" => "Sequence Name", "account_id" => "Account Id",
        "org_id" => "Org Id", "phone" => "Phone", "occupation" => "Occupation","industryName" => "Industry Name","isResponse" => "Is Response"];

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions() {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    //Developed by Ankit Sevak
    /**
     * Displays homepage.
     *
     * @return string
     */
    public function beforeAction($action) {
        if (empty(Yii::$app->session->get('userid'))) {
            $loginUrl = Yii::$app->request->baseUrl . "/login";
            return $this->redirect($loginUrl);
        }
        return parent::beforeAction($action);
    }

    public function actionIndex() {

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }
        $userid = Yii::$app->session->get('userid');


        $TokenData = Yii::$app->db->createCommand("select  *  from  crm_token where user_id=" . $userid)->queryOne();

//        if (!empty($TokenData)) {
//        if ($TokenData['sf_user_id'] !="" && $TokenData['sf_user_name'] != "" && $TokenData['sf_user_email']!= "" && $TokenData['access_token'] != "" && $TokenData['refresh_token'] != "" && $TokenData['signature'] != "" && $TokenData['scope'] != "" && $TokenData['id_token'] != "" && $TokenData['instance_url'] != "" && $TokenData['sid'] != "") {
        if ( $TokenData['access_token'] != "" && $TokenData['refresh_token'] != "" && $TokenData['instance_url'] != "" && $TokenData['sid'] != "") {

            if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'edit') {

                $instance_url = $TokenData['instance_url'];
                $access_token = $TokenData['access_token'];

                $MapingData = Yii::$app->db->createCommand("select  mapping_fileds  from  crm_field_mapping where crm_name='salesforce' and user_id=" . $userid)->queryOne();
                $UserFields = json_decode($MapingData['mapping_fileds'], true);

                $contactRow = $UserFields['contact'];
                $companyRow = $UserFields['company'];



                $sobj = "Contact";
                $ContactfieldsSalesforce = $this->get_custom_fields($sobj, $instance_url, $access_token);

                $sobj = "Account";
                $CompanyfieldsSalesforce = $this->get_custom_fields($sobj, $instance_url, $access_token);
                $loggedin = true;
            } else {
                $contactRow = "";
                $companyRow = "";
                $ContactfieldsSalesforce = "";
                $CompanyfieldsSalesforce = "";
                $loggedin = true;
            }
        } else {
            $contactRow = "";
            $companyRow = "";
            $ContactfieldsSalesforce = "";
            $CompanyfieldsSalesforce = "";
            $loggedin = false;
        }


        return $this->render('index', [
                    'contactRow' => $contactRow,
                    'companyRow' => $companyRow,
                    'contactfieldsSalesforce' => $ContactfieldsSalesforce,
                    'contactFieldsPortal' => $this->contact_array,
                    'companyfieldsSalesforce' => $CompanyfieldsSalesforce,
                    'companyFieldsPortal' => $this->company_array,
                    'loggedin' => $loggedin,
                    'TokenData' => $TokenData,
        ]);
    }

    public function actionAddfield() {
        $userid = Yii::$app->session->get('userid');
        $formData = $_REQUEST;
        $finalArr = array();

        $salesForceFields_contact = $formData['selContactProperty'];
        $portalFields_contact = $formData['selContactFormat'];
        $contactArr = array_combine($salesForceFields_contact, $portalFields_contact);
        //$finalArr['contact'] = $contactArr;
        $finalArr['contact'] = [];
        foreach ($contactArr as $key => $value) {
            if (!empty($key) && !empty($value)) {
                $finalArr['contact'][$key] = $value;
            }
        }


        $salesForceFields_company = $formData['selCompanyProperty'];
        $portalFields_company = $formData['selCompanyFormat'];
        $companyArr = array_combine($salesForceFields_company, $portalFields_company);
        //$finalArr['company'] = $companyArr;

        $finalArr['company'] = [];
        foreach ($companyArr as $key => $value) {
            if (!empty($key) && !empty($value)) {
                $finalArr['company'][$key] = $value;
            }
        }
        $maping_fileds = json_encode($finalArr);

        $MappingDetail = Yii::$app->db->createCommand("select  *  from  crm_field_mapping where crm_name='salesforce' and user_id=" . $userid)->queryOne();
        if (empty($MappingDetail)) {
            $sqlInsertFields = Yii::$app->db->createCommand("INSERT INTO `crm_field_mapping`(`crm_name`,`user_id`,`mapping_fileds`) VALUES ('salesforce','" . $userid . "','" . $maping_fileds . "')")->execute();
        } else {
            Yii::$app->db->createCommand("UPDATE `crm_field_mapping` SET `mapping_fileds`='" . $maping_fileds . "' WHERE  `user_id`='" . $userid . "' and crm_name='salesforce'")->execute();
        }
        return true;
    }

    public function actionUpdatestatus() {
        $userid = Yii::$app->session->get('userid');
        $formData = $_REQUEST;
        $status = $formData['id'];
        Yii::$app->db->createCommand("UPDATE `crm_token` SET `status`='" . $status . "' WHERE  `user_id`='" . $userid . "'")->execute();
    }

    function get_custom_fields($sobj, $instance_url, $access_token) {

        $is_expire = $this->is_token_expired($instance_url, $access_token);
        if ($is_expire) {
            $userid = Yii::$app->session->get('userid');
            $TokenData = Yii::$app->db->createCommand("select  *  from  crm_token where user_id=" . $userid)->queryOne();
            $result = $this->regenerate_token($this->CLIENT_ID, $this->CLIENT_SECRET, $TokenData['refresh_token'], $userid);
            $access_token = $result;
        }
//        switch ($sobj) {
//            case "Contact":
//                $field_list = $this->contact_fields;
//                break;
//            case "Account":
//                $field_list = $this->company_fields;
//                break;
//        }

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "$instance_url/services/data/v54.0/sobjects/$sobj/describe");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        $headers = array();
        $headers[] = 'X-Prettyprint: 1';
        $headers[] = 'Authorization: Bearer ' . $access_token;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $datas = curl_exec($ch);

        $datas = json_decode($datas, true);
        if (curl_errno($ch)) {
            print_r(curl_errno($ch));
            return false;
        }
        $fields = [];
        foreach ($datas['fields'] as $key => $data) {
            $fields[$key]['label'] = $data['label'];
            $fields[$key]['name'] = $data['name'];
        }
//        $removeField = array(array('label' => 'Contact ID', 'name' => 'Id'), array('label' => 'Deleted', 'name' => 'IsDeleted'), array('label' => 'Master Record ID', 'name' => 'MasterRecordId'));
//        $removeField = array('Id', 'IsDeleted', 'MasterRecordId');



        return $fields;
        curl_close($ch);
    }

    public function actionAddcontactrow() {
        $userid = Yii::$app->session->get('userid');

        $TokenData = Yii::$app->db->createCommand("select  *  from  crm_token where user_id=" . $userid)->queryOne();

        $instance_url = $TokenData['instance_url'];
        $access_token = $TokenData['access_token'];
        $sobj = "Contact";
        $ContactfieldsSalesforce = $this->get_custom_fields($sobj, $instance_url, $access_token);
        $contactFieldsPortal = $this->contact_array;
        $html = '<tr class="contactRowNumber_1">
                    <td>
                        <select name="selContactProperty[]" class="select2 form-control" style="width: 300px;" data-group="Contact" data-width="fit"><option  value="" >Select Field</option>';
        foreach ($ContactfieldsSalesforce as $contactfields) {
            $html .= '<option  value="' . $contactfields['name'] . '" >' . $contactfields['label'] . '</option>';
        }
        $html .= '</select></td>';
        $html .= '<td>
                    <select class="select2 form-control" name="selContactFormat[]"><option  value="" >Select Field</option>';
        foreach ($contactFieldsPortal as $key => $value) {
            $html .= '<option value="' . $key . '" >' . $value . '</option>';
        }
        $html .= '</select>
                    </td>
                    <td>
                    <span><i class="bx bxs-trash deleteRow" title="This property can not be edited or deleted."></i></span>
                    </td>
                    </tr>';
        echo $html;
        exit;
    }

    public function actionDisconnectsalesforce() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $userid = Yii::$app->session->get('userid');
        Yii::$app->db->createCommand("UPDATE `crm_token` SET `sf_user_id`=NUll,`sf_user_name`=NULL,`sf_user_email`=NULL,`access_token`=NULL,`refresh_token`=NULL,`signature`=NULL,`scope`=NULL,`id_token`=NULL,`instance_url`=NULL,`sid`=NULL WHERE  `user_id`='" . $userid . "'")->execute();
        return true;
    }

    public function actionAddcompanyrow() {
        $userid = Yii::$app->session->get('userid');

        $TokenData = Yii::$app->db->createCommand("select  *  from  crm_token where user_id=" . $userid)->queryOne();

        $instance_url = $TokenData['instance_url'];
        $access_token = $TokenData['access_token'];
        $sobj = "Account";
        $CompanyfieldsSalesforce = $this->get_custom_fields($sobj, $instance_url, $access_token);
        $companyFieldsPortal = $this->company_array;

        $html = '<tr class="companyRowNumber_1">
                    <td>
                        <select name="selCompanyProperty[]" class="select2 form-control" style="width: 300px;" data-group="Company" data-width="fit"><option  value="" >Select Field</option>';
        foreach ($CompanyfieldsSalesforce as $companyfields) {
            $html .= '<option  value="' . $companyfields['name'] . '" >' . $companyfields['label'] . '</option>';
        }
        $html .= '</select></td>';
        $html .= '<td>
                    <select class="select2 form-control" name="selCompanyFormat[]"><option  value="" >Select Field</option>';
        foreach ($companyFieldsPortal as $key => $value) {
            $html .= '<option value="' . $key . '" >' . $value . '</option>';
        }
        $html .= '</select>
                    </td>
                        <td>
                            <span><i class="bx bxs-trash deleteRow" title="This property can not be edited or deleted."></i></span>
                        </td>
                </tr>';
        echo $html;
        exit;
    }

    public function updateCrmStatus() {
        $formData = $_REQUEST;
        $user_id = formdata['user_name'];
        $status = formdata['status'];
        Yii::$app->db->createCommand("UPDATE `crm_token` SET `status`='" . $maping_fileds . "' WHERE  `user_id`='" . $userid . "'")->execute();
    }

    function is_token_expired($instance_url, $access_token) {

        $url = "https://" . $instance_url . "/services/data/v54.0/sobjects/Contact/listviews/";
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token"));
        $json_response = curl_exec($curl);
        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        $response = json_decode($json_response, true);
        if ($status != 200) {
            return true;
        }
        return false;
    }

    function regenerate_token($client_id, $client_secret, $refresh_token, $user_id) {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://login.salesforce.com/services/oauth2/token');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=refresh_token&client_id=" . $client_id . "&client_secret=" . $client_secret . "&refresh_token=" . $refresh_token . "&format=json");

        $headers = array();
        $headers[] = 'Content-Type: application/x-www-form-urlencoded';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        $response = json_decode($result, true);
        if (curl_errno($ch)) {
            return curl_error($ch);
        }
        curl_close($ch);
        if (isset($response['access_token']) && !empty($response['access_token'])) {
            if (Yii::$app->db->createCommand("UPDATE `crm_token` SET `access_token` = '" . $response['access_token'] . "', `signature` = '" . $response['signature'] . "', `scope` = '" . $response['scope'] . "', `instance_url` = '" . $response['instance_url'] . "', `sid` = '" . $response['id'] . "', `issued_at` = '" . $response['issued_at'] . "' WHERE `crm_token`.`user_id` = " . $user_id)->execute()) {
                return $response['access_token'];
            } else {
                return false;
            }
            $conn->close();
        }
    }

}
