<?php

namespace app\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\db\Query;

class ResponsesController extends Controller {

    const CHAT_LIST_PERSON = 20;

    public $enableCsrfValidation = false;

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions() {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    //Developed by Ankit Sevak
    /**
     * Displays homepage.
     *
     * @return string
     */
    public function beforeAction($action) {
        if (empty(Yii::$app->session->get('userid'))) {
            $loginUrl = Yii::$app->request->baseUrl . "/login";
            return $this->redirect($loginUrl);
        }
        return parent::beforeAction($action);
    }

    public function actionUnicodeString($str, $encoding = null) {
        if (is_null($encoding))
            $encoding = ini_get('mbstring.internal_encoding');
        return preg_replace_callback('/u([0-9a-fA-F]{4})/u', function($match) use ($encoding) {
            return mb_convert_encoding(pack('H*', $match[1]), $encoding, 'UTF-16BE');
        }, $str);
    }

    public function actionIndex() {

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        // notification checked
        Yii::$app->db->createCommand("UPDATE `user` SET `IsnotificationRead` = '1' WHERE IsnotificationRead = '0' AND `id` = '" . Yii::$app->session->get('userid') . "'")->execute();

        $querySeq = new Query();
        $querySeq->select('id, name')
                ->where(['user_id' => Yii::$app->session->get('userid')])
                ->from('ext_sequences');
        $seqCommand = $querySeq->createCommand();
        $sequences = $seqCommand->queryAll();

        $queryTags = new Query();
        $queryTags->select('id, tagName')
                ->where(['userId' => Yii::$app->session->get('userid')])
                ->from('tags');
        $tags = $queryTags->all();

        $queryTamplates = new Query();
        $queryTamplates->select('templateid, templatename, template')
                ->where(['teamid' => Yii::$app->session->get('userid')])
                ->orWhere("sharewith LIKE '%" . Yii::$app->session->get('userid') . "%'")
                ->from('templates');
        $tamplates = $queryTamplates->all();

        $query = new Query();

        $query->select(['conversations.id', 'conversations.personId', 'conversations.threadId', 'conversations.thread', 'conversations.userId', 'conversations.isDeleted', 'conversations.isArchive', 'conversations.isRead', 'conversations.isResultDone', 'conversations.sentimentResult', 'blacklist.firstName', 'blacklist.lastName', 'blacklist.url_publicIdentifier', 'blacklist.seq_name', 'blacklist.seq_id', 'blacklist.id as blid', '1stdegreedata.fullName', '1stdegreedata.url_publicIdentifier as publicIdentifier', 'REPLACE(RIGHT(conversations.thread,15),"}]","") as time'])
                ->from('conversations')
                ->where(['conversations.userId' => Yii::$app->session->get('userid'), 'conversations.isArchive' => '0'])
                ->leftJoin('blacklist', 'blacklist.linkedinpublicid = conversations.personId AND blacklist.userid=' . Yii::$app->session->get('userid'))
                ->leftJoin('1stdegreedata', '1stdegreedata.linkedinpublicid = conversations.personId AND 1stdegreedata.userId=' . Yii::$app->session->get('userid'))
                ->groupBy(['conversations.personId'])
                ->offset(0)
                ->limit(self::CHAT_LIST_PERSON)
//                ->orderBy(['id' => SORT_DESC]);
                ->orderBy(['time' => SORT_DESC]);

        /* $countQuery = new Query();
          $countQuery->select('conversations.id,conversations.personId,conversations.threadId,conversations.thread,conversations.userId,conversations.isDeleted,conversations.isArchive,conversations.isRead,conversations.isResultDone,conversations.sentimentResult, blacklist.firstName, blacklist.lastName, blacklist.url_publicIdentifier, blacklist.seq_name,blacklist.seq_id, 1stdegreedata.fullName, 1stdegreedata.url_publicIdentifier as publicIdentifier')
          ->from('conversations')
          ->where(['conversations.userId' => Yii::$app->session->get('userid'), 'conversations.isArchive' => '0'])
          ->leftJoin('blacklist', 'blacklist.linkedinpublicid = conversations.personId AND blacklist.userid=' . Yii::$app->session->get('userid'))
          ->leftJoin('1stdegreedata', '1stdegreedata.linkedinpublicid = conversations.personId AND 1stdegreedata.userId=' . Yii::$app->session->get('userid'))
          ->groupBy(['conversations.personId']); */
        ///$countQuery = clone $query;
		
		
		$countQuery = new Query();

        $countQuery->select(['conversations.id', 'conversations.personId', 'conversations.threadId', 'conversations.thread', 'conversations.userId', 'conversations.isDeleted', 'conversations.isArchive', 'conversations.isRead', 'conversations.isResultDone', 'conversations.sentimentResult', 'blacklist.firstName', 'blacklist.lastName', 'blacklist.url_publicIdentifier', 'blacklist.seq_name', 'blacklist.seq_id', '1stdegreedata.fullName', '1stdegreedata.url_publicIdentifier as publicIdentifier', 'REPLACE(RIGHT(conversations.thread,15),"}]","") as time'])
                ->from('conversations')
                ->where(['conversations.userId' => Yii::$app->session->get('userid'), 'conversations.isArchive' => '0'])
                ->leftJoin('blacklist', 'blacklist.linkedinpublicid = conversations.personId AND blacklist.userid=' . Yii::$app->session->get('userid'))
                ->leftJoin('1stdegreedata', '1stdegreedata.linkedinpublicid = conversations.personId AND 1stdegreedata.userId=' . Yii::$app->session->get('userid'))
                ->groupBy(['conversations.personId'])
                ->orderBy(['time' => SORT_DESC]);

        $teamUsers = Yii::$app->db->createCommand("Select id,concat(first_name,' ',last_name) as name from `user` WHERE `teamid` = '" . Yii::$app->session->get('userid') . "'")->queryAll();

		  $haystack = Yii::$app->session->get('useremail');
          $needle = "@kennected.io";

		/* if(Yii::$app->session->get('userid')==15896){  
			echo $query->createCommand()->getRawSql();exit; 
		} */

		if(Yii::$app->session->get('userid') == '16943' || Yii::$app->session->get('userid') == '14909' || Yii::$app->session->get('userid') == '22420' || strpos($haystack, $needle) !== false){
			return $this->render('index_test', [
						'responses' => $query->all(),
						'sequences' => $sequences,
						'tags' => $tags,
						'teamUsers' => $teamUsers,
						'tamplates' => $tamplates,
						'chatListStart' => 0,
						'chatListLimit' => self::CHAT_LIST_PERSON,
						//'totalRec' => count($countQuery->all()),
						'totalRec' => $countQuery->count(),
			]);
		
		}else{
				//echo $query->createCommand()->getRawSql();
			return $this->render('index_test', [
						'responses' => $query->all(),
						'sequences' => $sequences,
						'tags' => $tags,
						'teamUsers' => $teamUsers,
						'tamplates' => $tamplates,
						'chatListStart' => 0,
						'chatListLimit' => self::CHAT_LIST_PERSON,
						//'totalRec' => count($countQuery->all()),
						'totalRec' => $countQuery->count(),
			]);
		}
    }

    public function actionDeleteresponse() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $currentTimestamp = round(microtime(true) * 1000);
        $threadId = Yii::$app->request->post('threadId');
        $personId = Yii::$app->request->post('personId');
        $userId = Yii::$app->session->get('userid');

        if (Yii::$app->db->createCommand("UPDATE `conversations` SET `isDeleted` = '1' WHERE `threadId` = '" . $threadId . "' AND `personId` = '" . $personId . "' AND `userId` = '" . $userId . "'")->execute()) {
            $task = Yii::$app->db->createCommand("Select * from `ext_tasks` WHERE `status` = 'Paused' AND `personId` = '" . $personId . "' AND `userId` = '" . $userId . "'")->queryOne();
            Yii::$app->db->createCommand("INSERT INTO notes (personId, threadId, note, userId, created) VALUES ('" . $personId . "', '" . $threadId . "', 'Scheduled tasks resumed.', '" . $userId . "', '" . $currentTimestamp . "')")->execute();
            if ($task['startTime'] > $currentTimestamp) {
                if (Yii::$app->db->createCommand("UPDATE `ext_tasks` SET `status` = 'Not Started' WHERE `status` = 'Paused' AND `personId` = '" . $personId . "' AND `userId` = '" . $userId . "'")->execute()) {
                    return true;
                } else {
                    return false;
                }
            } else {
                if (Yii::$app->db->createCommand("UPDATE `ext_tasks` SET `status` = 'Not Started' WHERE `status` = 'Paused' AND `personId` = '" . $personId . "' AND `userId` = '" . $userId . "'")->execute()) {
                    /*  Yii::$app->db->createCommand("INSERT INTO completed_tasks SELECT ext_tasks.*, NOW() FROM ext_tasks WHERE id = '" . $task['id'] . "'")->execute();
                      Yii::$app->db->createCommand("DELETE FROM ext_tasks WHERE id = '" . $task['id'] . "'")->execute(); */
                    return true;
                } else {
                    return false;
                }
            }
        } else {
            return false;
        }
    }

    public function actionSetresponsefilter() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $responseTerm = Yii::$app->request->post('term');
        $responseType = Yii::$app->request->post('responseType');

        if (!empty($responseTerm)) {
            Yii::$app->session->set('responseTerm', $responseTerm);
        } else {
            Yii::$app->session->remove('responseTerm');
        }

        if (!empty($responseType)) {
            Yii::$app->session->set('responseType', $responseType);
        } else {
            Yii::$app->session->remove('responseType');
        }
    }

    public function actionGetchatlist() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $sequenceId = Yii::$app->request->post('sequenceId');
        $responseFilter = Yii::$app->request->post('responseFilter');
        $tagId = Yii::$app->request->post('tags');
        $start = Yii::$app->request->post('start');
        $limit = Yii::$app->request->post('limit');
        $s_date = implode('-', array_reverse(explode('/', Yii::$app->request->post('startdate'))));
        $e_date = implode('-', array_reverse(explode('/', Yii::$app->request->post('enddate'))));
        $seqChanged = Yii::$app->request->post('seqChanged');
        $isRefresh = Yii::$app->request->post('isRefresh');
        $searchChat = addslashes(Yii::$app->request->post('searchChat'));
        $searchChat_new = $this->mb_htmlentities($this->convert_emoji($searchChat));
        $archiveFilter = Yii::$app->request->post('archiveFilter');
        $unreadFilter = Yii::$app->request->post('customMsgUnread');
        $resFilter = Yii::$app->request->post('resFilter');
        //if ($seqChanged || $searchChat || $archiveFilter) {
        if ($seqChanged || $searchChat) {
            $start = 0;
        }

        $checkDegree = "0";
        $query = new Query();
        if ($sequenceId == 'all') {
            $query->select(['conversations.id', 'conversations.personId', 'conversations.threadId', 'conversations.thread', 'conversations.userId', 'conversations.isDeleted', 'conversations.isArchive', 'conversations.isRead', 'conversations.isResultDone', 'conversations.sentimentResult', 'blacklist.firstName', 'blacklist.lastName', 'blacklist.url_publicIdentifier', 'blacklist.seq_name', 'blacklist.seq_id', '1stdegreedata.fullName', '1stdegreedata.url_publicIdentifier as publicIdentifier', 'REPLACE(RIGHT(conversations.thread,15),"}]","") as time'])
                    ->from('conversations')
                    ->where(['conversations.userId' => Yii::$app->session->get('userid'), 'conversations.isArchive' => $archiveFilter])
                    ->leftJoin('blacklist', 'blacklist.linkedinpublicid = conversations.personId AND blacklist.userid=' . Yii::$app->session->get('userid'))
                    ->leftJoin('1stdegreedata', '1stdegreedata.linkedinpublicid = conversations.personId AND 1stdegreedata.userId=' . Yii::$app->session->get('userid'))
                    ->groupBy(['conversations.personId'])
                    ->offset($start)
                    ->limit($limit)
//                    ->orderBy(['id' => SORT_DESC]);
                    ->orderBy(['time' => SORT_DESC]);
            if ($resFilter != 'ALL') {
                $query->andWhere(['conversations.sentimentResult' => $resFilter]);
            }
            if ($unreadFilter == 1) {
                $query->andWhere(['conversations.isRead' => 0]);
            }
            if (!empty($tagId)) {
                $query->andWhere('find_in_set(:blacklistTagId, blacklist.`tags`) OR find_in_set(:firstDegreeTagId, 1stdegreedata.tags)', [':blacklistTagId' => $tagId, ':firstDegreeTagId' => $tagId]);
            }
            if (!empty($responseFilter)) {
                if ($responseFilter == 'accepted')
                    $query->andWhere(['blacklist.`is_accepted`' => 1]);
                elseif ($responseFilter == 'unresponded')
                    $query->andWhere('blacklist.`is_response`=0 and 1stdegreedata.response is null');
                else
                    $query->andWhere('blacklist.`is_response`=1 OR 1stdegreedata.response is NOT null');
            }
            if (!empty($s_date) && !empty($e_date)) {
                if ($responseFilter == 'accepted')
                    $query->andWhere("DATE(blacklist.accepted_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
                elseif ($responseFilter == 'responded')
                //$query->andWhere("DATE(from_unixtime(ROUND(respond/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
                    $query->andWhere("DATE(from_unixtime(ROUND(respond/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "' Or DATE(from_unixtime(ROUND(CAST(JSON_EXTRACT(`1stdegreedata`.`response`,CONCAT('$[',JSON_LENGTH(`1stdegreedata`.`response`)-1,']','.respondedAt')) AS UNSIGNED)/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
                elseif ($responseFilter == 'unresponded')
                //$query->andWhere("DATE(from_unixtime(ROUND(respond/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
                    $query->andWhere("blacklist.`is_response`=0 AND 1stdegreedata.response is null");
				else
                //$query->andWhere("DATE(blacklist.accepted_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "' OR DATE(from_unixtime(ROUND(respond/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
                    $query->andWhere("DATE(blacklist.accepted_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "' OR DATE(from_unixtime(ROUND(respond/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "' OR DATE(from_unixtime(ROUND(CAST(JSON_EXTRACT(`1stdegreedata`.`response`,CONCAT('$[',JSON_LENGTH(`1stdegreedata`.`response`)-1,']','.respondedAt')) AS UNSIGNED)/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
            }
            if (!empty($searchChat)) {
                $query->andWhere(" blacklist.firstName LIKE '%" . $searchChat_new . "%' OR blacklist.lastName LIKE '%" . $searchChat_new . "%' OR 1stdegreedata.fullName LIKE '%" . $searchChat . "%'");
            }
			
            if ($seqChanged || $isRefresh) {
                $totalRecQuery = new Query();
                $totalRecQuery->select('conversations.id,conversations.personId,conversations.threadId,conversations.thread,conversations.userId,conversations.isDeleted,conversations.isArchive,conversations.isRead,conversations.isResultDone,conversations.sentimentResult, blacklist.firstName, blacklist.lastName, blacklist.url_publicIdentifier, blacklist.seq_name, 1stdegreedata.fullName, 1stdegreedata.url_publicIdentifier as publicIdentifier')
                        ->from('conversations')
                        ->where(['conversations.userId' => Yii::$app->session->get('userid'), 'conversations.isArchive' => $archiveFilter])
                        ->leftJoin('blacklist', 'blacklist.linkedinpublicid = conversations.personId AND blacklist.userid=' . Yii::$app->session->get('userid'))
                        ->leftJoin('1stdegreedata', '1stdegreedata.linkedinpublicid = conversations.personId AND 1stdegreedata.userId=' . Yii::$app->session->get('userid'))
                        ->groupBy(['conversations.personId']);
                if ($resFilter != 'ALL') {
                    $totalRecQuery->andWhere(['conversations.sentimentResult' => $resFilter]);
                }
                if ($unreadFilter == 1) {
                    $totalRecQuery->andWhere(['conversations.isRead' => 0]);
                }
                if (!empty($tagId)) {
                    $totalRecQuery->andWhere('find_in_set(:blacklistTagId, blacklist.`tags`) OR find_in_set(:firstDegreeTagId, 1stdegreedata.tags)', [':blacklistTagId' => $tagId, ':firstDegreeTagId' => $tagId]);
                }
                if (!empty($responseFilter)) {
                    if ($responseFilter == 'accepted')
                        $totalRecQuery->andWhere(['blacklist.`is_accepted`' => 1]);
                    elseif ($responseFilter == 'unresponded')
						$totalRecQuery->andWhere('blacklist.`is_response`=0 AND 1stdegreedata.response is null');
					else
                    //$totalRecQuery->andWhere(['blacklist.`is_response`' => 1]);
                        $totalRecQuery->andWhere('blacklist.`is_response`=1 OR 1stdegreedata.response is NOT null');
                }
                if (!empty($s_date) && !empty($e_date)) {
                    if ($responseFilter == 'accepted')
                        $totalRecQuery->andWhere("DATE(blacklist.accepted_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
                    elseif ($responseFilter == 'responded')
                    //$totalRecQuery->andWhere("DATE(from_unixtime(ROUND(respond/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
                        $totalRecQuery->andWhere("DATE(from_unixtime(ROUND(respond/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "' OR DATE(from_unixtime(ROUND(CAST(JSON_EXTRACT(`1stdegreedata`.`response`,CONCAT('$[',JSON_LENGTH(`1stdegreedata`.`response`)-1,']','.respondedAt')) AS UNSIGNED)/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
                    elseif ($responseFilter == 'unresponded')
                    //$totalRecQuery->andWhere("DATE(from_unixtime(ROUND(respond/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
						$totalRecQuery->andWhere("blacklist.`is_response`=0 AND 1stdegreedata.response is null");
                        //$totalRecQuery->andWhere("DATE(from_unixtime(ROUND(respond/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "' OR DATE(from_unixtime(ROUND(CAST(JSON_EXTRACT(`1stdegreedata`.`response`,CONCAT('$[',JSON_LENGTH(`1stdegreedata`.`response`)-1,']','.respondedAt')) AS UNSIGNED)/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
                    else
                    //$totalRecQuery->andWhere("DATE(blacklist.accepted_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "' OR DATE(from_unixtime(ROUND(respond/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
                        $totalRecQuery->andWhere("DATE(blacklist.accepted_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "' OR DATE(from_unixtime(ROUND(respond/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "' OR DATE(from_unixtime(ROUND(CAST(JSON_EXTRACT(`1stdegreedata`.`response`,CONCAT('$[',JSON_LENGTH(`1stdegreedata`.`response`)-1,']','.respondedAt')) AS UNSIGNED)/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
                }
				$totalRec = 0;
				/* if(Yii::$app->session->get('userid')==33829){
					echo $query->createCommand()->getRawSql();exit; 
				}  */
				foreach($totalRecQuery->all() as $records){
					if ((!empty($records['firstName']) && !empty($records['lastName'])) || !empty($records['fullName'])) {
						$totalRec = $totalRec +1;
					}
				}
                //$totalRec = count($totalRecQuery->all());
            }else {
                $totalRec = '';
            }
        } else {
            $checkDegree = Yii::$app->db->createCommand("SELECT msgSeq FROM ext_sequences WHERE id = " . $sequenceId)->queryScalar();
            if ($checkDegree) {
                $query->select(['conversations.id', 'conversations.personId', 'conversations.threadId', 'conversations.thread', 'conversations.userId', 'conversations.isDeleted', 'conversations.isArchive', 'conversations.isRead', 'conversations.isResultDone', 'conversations.sentimentResult', 'fullName', 'url_publicIdentifier', 'REPLACE(RIGHT(conversations.thread,15),"}]","") as time'])
                        ->from('conversations')
                        ->where(['conversations.userId' => Yii::$app->session->get('userid'), 'conversations.isArchive' => $archiveFilter])
                        ->innerJoin('1stdegreedata', '1stdegreedata.linkedinpublicid = conversations.personId AND  find_in_set(' . $sequenceId . ',1stdegreedata.sequenceIds)')
                        ->groupBy(['conversations.personId'])
                        ->offset($start)
                        ->limit($limit)
//                    ->orderBy(['conversations.id' => SORT_DESC]);
                        ->orderBy(['time' => SORT_DESC]);
                $table = "1stdegree";
            } else {
                $query->select(['conversations.id', 'conversations.personId', 'conversations.threadId', 'conversations.thread', 'conversations.userId', 'conversations.isDeleted', 'conversations.isArchive', 'conversations.isRead', 'conversations.isResultDone', 'conversations.sentimentResult', 'firstName', 'lastName', 'url_publicIdentifier', 'seq_name', 'seq_id', 'REPLACE(RIGHT(conversations.thread,15),"}]","") as time'])
                        ->from('conversations')
                        ->where(['conversations.userId' => Yii::$app->session->get('userid'), 'conversations.isArchive' => $archiveFilter])
                        ->innerJoin('blacklist', 'blacklist.linkedinpublicid = conversations.personId AND blacklist.seq_id = ' . $sequenceId)
                        ->groupBy(['conversations.personId'])
                        ->offset($start)
                        ->limit($limit)
//                    ->orderBy(['conversations.id' => SORT_DESC]);
                        ->orderBy(['time' => SORT_DESC]);
                $table = "2nddegree";
            }
            if ($resFilter != 'ALL') {
                $query->andWhere(['conversations.sentimentResult' => $resFilter]);
            }
            if ($unreadFilter == 1) {
                $query->andWhere(['conversations.isRead' => 0]);
            }
            if (!empty($tagId)) {
                if ($table == '1stdegree')
                    $query->andWhere('find_in_set(:blacklistTagId, 1stdegreedata.`tags`)', [':blacklistTagId' => $tagId]);
                else
                    $query->andWhere('find_in_set(:blacklistTagId, blacklist.`tags`)', [':blacklistTagId' => $tagId]);
            }
            if (!empty($responseFilter)) {
                if ($table != '1stdegree')
                    if ($responseFilter == 'accepted')
                        $query->andWhere(['blacklist.`is_accepted`' => 1]);
                    elseif ($responseFilter == 'unresponded')
						$query->andWhere(['blacklist.`is_response`' => 0]);
					else
                        $query->andWhere(['blacklist.`is_response`' => 1]);
                else
					if ($responseFilter == 'unresponded')
						$query->andWhere('response is null');
					else
						$query->andWhere('JSON_CONTAINS(JSON_EXTRACT(response, "$**.sequenceId"), "' . $sequenceId . '", "$")');
            }
            if (!empty($s_date) && !empty($e_date)) {
                if ($table != '1stdegree') {
                    if ($responseFilter == 'accepted')
                        $query->andWhere("DATE(blacklist.accepted_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
                    elseif ($responseFilter == 'responded')
                        $query->andWhere("DATE(from_unixtime(ROUND(respond/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
					elseif ($responseFilter == 'unresponded')
                        $query->andWhere("is_response=0");
                    else
                        $query->andWhere("DATE(blacklist.accepted_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "' OR DATE(from_unixtime(ROUND(respond/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
                }else {
                    //$query->andWhere(['1stdegreedata.`id`' => '-1']);
                    $query->andWhere("DATE(from_unixtime(ROUND(CAST(JSON_EXTRACT(`1stdegreedata`.`response`,CONCAT('$[',JSON_LENGTH(`1stdegreedata`.`response`)-1,']','.respondedAt')) AS UNSIGNED)/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
                }
            }
            if (!empty($searchChat)) {
                if ($table == '1stdegree')
                    $query->andWhere(" 1stdegreedata.fullName LIKE '%" . $searchChat . "%'");
                else
                    $query->andWhere(" blacklist.firstName LIKE '%" . $searchChat_new . "%' OR blacklist.lastName LIKE '%" . $searchChat_new . "%'");
            }
            if ($seqChanged || $isRefresh) {
                $totalRecQuery = new Query();
                if ($table == '1stdegree')
                    $totalRecQuery->select(['conversations.id', 'conversations.personId', 'conversations.threadId', 'conversations.thread', 'conversations.userId', 'conversations.isDeleted', 'conversations.isArchive', 'conversations.isRead', 'conversations.isResultDone', 'conversations.sentimentResult', 'fullName', 'url_publicIdentifier', 'REPLACE(RIGHT(conversations.thread,15),"}]","") as time'])
                            ->from('conversations')
                            ->where(['conversations.userId' => Yii::$app->session->get('userid'), 'conversations.isArchive' => $archiveFilter])
                            ->innerJoin('1stdegreedata', '1stdegreedata.linkedinpublicid = conversations.personId AND  find_in_set(' . $sequenceId . ',1stdegreedata.sequenceIds)')
                            ->groupBy(['conversations.personId']);
                else
                    $totalRecQuery->select('conversations.id,conversations.personId,conversations.threadId,conversations.thread,conversations.userId,conversations.isDeleted,conversations.isArchive,conversations.isRead,conversations.isResultDone,conversations.sentimentResult, firstName, lastName, url_publicIdentifier, seq_name, seq_id')
                            ->from('conversations')
                            ->where(['conversations.userId' => Yii::$app->session->get('userid'), 'conversations.isArchive' => $archiveFilter])
                            ->innerJoin('blacklist', 'blacklist.linkedinpublicid = conversations.personId AND blacklist.seq_id = ' . $sequenceId)
                            ->groupBy(['conversations.personId']);
                if ($resFilter != 'ALL') {
                    $totalRecQuery->andWhere(['conversations.sentimentResult' => $resFilter]);
                }
                if ($unreadFilter == 1) {
                    $totalRecQuery->andWhere(['conversations.isRead' => 0]);
                }
                if (!empty($tagId)) {
                    if ($table == '1stdegree')
                        $totalRecQuery->andWhere('find_in_set(:blacklistTagId, 1stdegreedata.`tags`)', [':blacklistTagId' => $tagId]);
                    else
                        $totalRecQuery->andWhere('find_in_set(:blacklistTagId, blacklist.`tags`)', [':blacklistTagId' => $tagId]);
                }
                if (!empty($responseFilter)) {
                    if ($table != '1stdegree')
                        if ($responseFilter == 'accepted')
                            $totalRecQuery->andWhere(['blacklist.`is_accepted`' => 1]);
                        elseif ($responseFilter == 'unresponded')
							$totalRecQuery->andWhere(['blacklist.`is_response`' => 0]);
						else
                            $totalRecQuery->andWhere(['blacklist.`is_response`' => 1]);
                    else
                        $totalRecQuery->andWhere('JSON_CONTAINS(JSON_EXTRACT(response, "$**.sequenceId"), "' . $sequenceId . '", "$")');
                }
                if (!empty($s_date) && !empty($e_date)) {
                    if ($table != '1stdegree')
                        if ($responseFilter == 'accepted')
                            $totalRecQuery->andWhere("DATE(blacklist.accepted_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
                        elseif ($responseFilter == 'responded')
                            $totalRecQuery->andWhere("DATE(from_unixtime(ROUND(respond/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
						elseif ($responseFilter == 'unresponded')
                            $totalRecQuery->andWhere("is_response=0");
                        else
                            $totalRecQuery->andWhere("DATE(blacklist.accepted_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "' OR DATE(from_unixtime(ROUND(respond/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
                    else
                        $totalRecQuery->andWhere("DATE(from_unixtime(ROUND(CAST(JSON_EXTRACT(`1stdegreedata`.`response`,CONCAT('$[',JSON_LENGTH(`1stdegreedata`.`response`)-1,']','.respondedAt')) AS UNSIGNED)/1000), '%Y-%m-%d')) BETWEEN '" . $s_date . "' AND '" . $e_date . "'");
                }
				
                $totalRec = count($totalRecQuery->all());
            }else {
                $totalRec = '';
            }
        }
		if(Yii::$app->session->get('userid')==16943 || Yii::$app->session->get('userid')==14907 || Yii::$app->session->get('userid')==23806 || Yii::$app->session->get('userid')==23256 || Yii::$app->session->get('userid')==14905 || Yii::$app->session->get('userid') == 24867 || Yii::$app->session->get('userid') == 24867){ 
			//echo "Q:::";
			//echo $query->createCommand()->getRawSql();exit;     
			//print_r($query->all());exit;
		} 
        $chatlist = $query->all();
		
        $chat = "";
        $haystack = Yii::$app->session->get('useremail');
        $needle = "@kennected.io";
        foreach ($chatlist as $response) {
            if ((!empty($response['firstName']) && !empty($response['lastName'])) || !empty($response['fullName'])) {
                if (!empty($response['firstName'])) {
                    $fullname = $response['firstName'] . ' ' . $response['lastName'];
                    $initials = strtoupper(substr($response['firstName'], 0, 1) . substr($response['lastName'], 0, 1));
                    $publicIdentifier = $response['url_publicIdentifier'];
                    $seqName = $response['seq_name'];
                } else {
                    $fullname = $response['fullName'];
                    if (!empty($response['fullName'])) {
                        $initials = strtoupper(substr(preg_split('/\s+/', $response['fullName'])[0], 0, 1) . substr(preg_split('/\s+/', $response['fullName'])[1], 0, 1));
                    } else {
                        $initials = '';
                    }
                    $publicIdentifier = $response['url_publicIdentifier'];
                    $response['seq_id'] = (isset($sequenceId) && $sequenceId != 'all') ? $sequenceId : '';
                    $seqName = 'N/A';
                }

                $seqName = mb_convert_encoding($seqName, 'UTF-8', 'UTF-8');
                $initials = mb_convert_encoding($initials, 'UTF-8', 'UTF-8');
                $fullname = mb_convert_encoding($fullname, 'UTF-8', 'UTF-8');

                $threadArr = json_decode($response['thread'], true);
                $message = "";
                if (!empty($threadArr)) {
                    $lastMsg = end($threadArr);
                    if (isset($lastMsg['msg']) && isset($lastMsg['type'])) {
                        if ($lastMsg['type'] == "S") {
                            $name = "You";
                        } else {
                            $name = substr($fullname, 0, strpos($fullname, " "));
                        }

                        $message_text = $name . ": " . strval(strip_tags(html_entity_decode($lastMsg['msg']), '<br /><br/>'));
                        if (strlen($message_text) > 50) {
                            $message = substr($message_text, 0, 50) . '...';
                        } else {
                            $message = $message_text;
                        }
                    } else {
                        $message = "";
                    }
                }
                $suppressionId = "";
                $suppressionData = Yii::$app->db->createCommand("SELECT id FROM `suppressionlist` WHERE `personId` ='" . $response['personId'] . "' and `userId` ='" . Yii::$app->session->get('userid') . "' and `teamId` ='" . Yii::$app->session->get('teamid') . "'")->queryScalar();
                if (!empty($suppressionData)) {
                    $suppressionId = $suppressionData;
                }

                if ($response['isRead'] == 0) {
                    $msg = "<span class='text-muted lnkdinbold' style='font-size: 12px;font-weight: bold;color:#6c757f;'>" . htmlspecialchars_decode($message) . "</span>";
                    $fullname = $fullname . '<span style="height: 8px;background: #0a66c2;width: 8px;position: absolute;border-radius: 10px;right: 35px;margin-top: 10px;"></span>';
                } else {
                    $msg = "<span class='text-muted lnkdinbold' style='font-size: 12px;'>" . htmlspecialchars_decode($message) . "</span>";
                }
                $chkbx = '';
                //if (Yii::$app->session->get('userid') == '16943' || Yii::$app->session->get('userid') == '16258' || strpos($haystack, $needle) !== false) {
                    $chkbx = "<span class='selbox chkspninb' data-id='" . $response['threadId'] . "' ><input type='checkbox' class='selbklid' value='" . $response['id'] . "' /></span>";
              // }


                $chat .= $chkbx . "<li data-id='" . $response['threadId'] . "' data-results='" . $response['sentimentResult'] . "' data-person='" . $response['personId'] . "' data-seqname='" . $seqName . "' data-seqid='" . $response['seq_id'] . "' data-publicidentifier='" . $publicIdentifier . "' data-isdeleted='" . $response['isDeleted'] . "' data-conversationid='" . $response['id'] . "' data-threadid='" . $response['threadId'] . "' data-suppressionId='" . $suppressionId . "'  data-isread='" . $response['isRead'] . "' class='response-person li_" . $response['id'] . "'>
				<div class='d-flex align-items-center'>
					<div class='avatar m-0 mr-50'>
						<p data-letters='" . $initials . "' style='margin: 0;'></p>
					</div>
					<div class='chat-sidebar-name'>
						<h6 class='mb-0'>" . $fullname . "<span id='tetstt'></h6>
                                                    " . $msg . "
					</div>
				</div>
			</li>";
            }
        }
		//echo $chat;exit;
        $response = array('chat' => $chat, 'totalRec' => $totalRec, 'isMsgSeq' => $checkDegree);
		//print_r(json_encode($response));exit;
        echo json_encode($response);
    }

    public function actionGetlastupdatedconversationtime() {
        //$userIds = Yii::$app->db->createCommand("SELECT id FROM `user` WHERE `isLastResponseChecked` = '0' AND proxyIp != '' AND lastResponseChecked < UNIX_TIMESTAMP((NOW() - INTERVAL 10 HOUR))*1000 AND popupstatus = '1' ORDER BY `user`.`lastResponseChecked` ASC")->queryColumn();
        $userIds = Yii::$app->db->createCommand("SELECT id FROM `user` WHERE `isLastResponseChecked` = '0' AND proxyIp != '' AND popupstatus = '1' ORDER BY `user`.`lastResponseChecked` ASC")->queryColumn();
        foreach ($userIds as $userId) {
            $sequenceId = "all";
            $start = 0;
            $limit = 1;
            $seqChanged = 1;
            $isRefresh = 1;
            $searchChat_new = "";
            $archiveFilter = 0;
            if ($seqChanged || $archiveFilter) {
                $start = 0;
            }

            $query = new Query();
            if ($sequenceId == 'all') {
                $query->select(['conversations.*', 'blacklist.firstName', 'blacklist.lastName', 'blacklist.url_publicIdentifier', 'blacklist.seq_name', 'blacklist.seq_id', '1stdegreedata.fullName', '1stdegreedata.url_publicIdentifier as publicIdentifier', 'REPLACE(RIGHT(conversations.thread,15),"}]","") as time'])
                        ->from('conversations')
                        ->where(['conversations.userId' => $userId, 'conversations.isArchive' => $archiveFilter])
                        ->leftJoin('blacklist', 'blacklist.linkedinpublicid = conversations.personId AND blacklist.userid=' . $userId)
                        ->leftJoin('1stdegreedata', '1stdegreedata.linkedinpublicid = conversations.personId AND 1stdegreedata.userId=' . $userId)
                        ->groupBy(['conversations.personId'])
                        ->offset($start)
                        ->limit($limit)
                        ->orderBy(['time' => SORT_DESC]);
            }

            $chatlist = $query->all();
            $chat = "";
            foreach ($chatlist as $response) {
                if ((!empty($response['firstName']) && !empty($response['lastName'])) || !empty($response['fullName'])) {
                    if (!empty($response['firstName'])) {
                        $fullname = $response['firstName'] . ' ' . $response['lastName'];
                        $initials = strtoupper(substr($response['firstName'], 0, 1) . substr($response['lastName'], 0, 1));
                        $publicIdentifier = $response['url_publicIdentifier'];
                        $seqName = $response['seq_name'];
                    } else {
                        $fullname = $response['fullName'];
                        if (!empty($response['fullName'])) {
                            $initials = strtoupper(substr(preg_split('/\s+/', $response['fullName'])[0], 0, 1) . substr(preg_split('/\s+/', $response['fullName'])[1], 0, 1));
                        } else {
                            $initials = '';
                        }
                        $publicIdentifier = $response['url_publicIdentifier'];
                        $response['seq_id'] = (isset($sequenceId) && $sequenceId != 'all') ? $sequenceId : '';
                        $seqName = 'N/A';
                    }

                    $seqName = mb_convert_encoding($seqName, 'UTF-8', 'UTF-8');
                    $initials = mb_convert_encoding($initials, 'UTF-8', 'UTF-8');
                    $fullname = mb_convert_encoding($fullname, 'UTF-8', 'UTF-8');

                    $threadArr = json_decode($response['thread'], true);
                    $message = "";
                    if (!empty($threadArr)) {
                        $lastMsg = end($threadArr);
                        if (isset($lastMsg['msg']) && isset($lastMsg['type'])) {
                            if ($lastMsg['type'] == "S") {
                                $name = "You";
                            } else {
                                $name = substr($fullname, 0, strpos($fullname, " "));
                            }

                            $message_text = $name . ": " . strval(strip_tags(html_entity_decode($lastMsg['msg']), '<br /><br/>'));
                            if (strlen($message_text) > 50) {
                                $message = $lastMsg['createdAt'];
                            } else {
                                $message = $lastMsg['createdAt'];
                            }
                        } else {
                            $message = "";
                        }
                    }
                }
            }
            if (isset($message) && !empty($message)) {
                echo $userId . " - UPDATE `user` SET `isLastResponseChecked` = '1', `lastResponseChecked` = '" . $message . "'  WHERE id ='" . $userId . "'<br>";
                Yii::$app->db->createCommand("UPDATE `user` SET `isLastResponseChecked` = '1', `lastResponseChecked` = '" . $message . "'  WHERE id ='" . $userId . "'")->execute();
            }
        }
    }

    public function actionUpdateconversationtoarchive() {
        $userId = 15270;
        $sequenceId = "all";
        $start = 0;
        $limit = 1;
        $seqChanged = 1;
        $isRefresh = 1;
        $searchChat_new = "";
        $archiveFilter = 0;
        if ($seqChanged || $archiveFilter) {
            $start = 0;
        }

        $query = new Query();
        if ($sequenceId == 'all') {
            $query->select(['conversations.*', 'blacklist.firstName', 'blacklist.lastName', 'blacklist.url_publicIdentifier', 'blacklist.seq_name', 'blacklist.seq_id', '1stdegreedata.fullName', '1stdegreedata.url_publicIdentifier as publicIdentifier', 'REPLACE(RIGHT(conversations.thread,15),"}]","") as time'])
                    ->from('conversations')
                    ->where(['conversations.userId' => $userId, 'conversations.isArchive' => $archiveFilter])
                    ->leftJoin('blacklist', 'blacklist.linkedinpublicid = conversations.personId AND blacklist.userid=' . $userId)
                    ->leftJoin('1stdegreedata', '1stdegreedata.linkedinpublicid = conversations.personId AND 1stdegreedata.userId=' . $userId)
                    ->groupBy(['conversations.personId'])
                    /* ->offset($start)
                      ->limit($limit) */
                    ->orderBy(['time' => SORT_DESC]);
        }

        $chatlist = $query->all();
        $chat = "";
        $conversationIds = "";
        $pad = "";
        foreach ($chatlist as $response) {
            if (isset($response['thread']) && !empty($response['thread'])) {
                $threadArr = json_decode($response['thread'], true);
                if (!empty($threadArr)) {
                    $lastMsg = end($threadArr);
                    if (isset($lastMsg['createdAt'])) {
                        $createdAt = $lastMsg['createdAt'];
                        if ($createdAt < 1616043600000) {
                            $conversationIds .= $pad . $response['id'];
                            $pad = ",";
                        }
                    }
                }
            }
        }
        print_r($conversationIds);
        exit;
    }

    public function actionProspect() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $threadId = Yii::$app->request->post('threadId');
        $personId = Yii::$app->request->post('personId');
        $hubspotKey = Yii::$app->request->post('hubspotKey');
        $hubspotOwnerId = Yii::$app->request->post('hubspotOwnerId');
        $userId = Yii::$app->session->get('userid');
        $loggedInUserFirstName = Yii::$app->session->get('first_name');
        $loggedInUserLastName = Yii::$app->session->get('last_name');
        $returnResponse = array();

        if (!empty($hubspotKey)) {
            $query = new Query();
            $query->select('blacklist.firstName, blacklist.lastName, blacklist.url_publicIdentifier, blacklist.seq_name, profileinfo.*, companyinfo.*')
                    ->from('blacklist')
                    ->where(['blacklist.userid' => $userId, 'blacklist.linkedinpublicid' => $personId])
                    ->leftJoin('profileinfo', 'profileinfo.id = blacklist.profileInfo_id')
                    ->leftJoin('companyinfo', 'companyinfo.id = blacklist.companyInfo_id');
            $blkLstDta = $query->one();

            $profileInfo = json_decode(trim($blkLstDta['contactInfo'], '"'));
            $profileBasicInfo = json_decode($blkLstDta['basicInfo']);
            $companyInfo = json_decode(str_replace('"]', '', str_replace('["', '', $blkLstDta['company_detail'])));

            if (!empty($profileInfo->emailAddress)) {
                $personEmail = $profileInfo->emailAddress;
            } else {
                $personEmail = '';
            }
            if (!empty($personEmail)) {
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://api.hubapi.com/contacts/v1/contact/email/" . $personEmail . "/profile?hapikey=" . $hubspotKey,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cache-control: no-cache",
                        "content-type: application/json"
                    ),
                ));
                $response = curl_exec($curl);
                $err = curl_error($curl);
                curl_close($curl);
                if ($err) {
                    
                } else {
                    $res = json_decode($response);
                    (isset($res->vid) && $res->vid > 0) ? $vid = $res->vid : $vid = '';
                }
            } else {
                $fullname = $blkLstDta['firstName'] . ' ' . $blkLstDta['lastName'];
                $curl = curl_init();
                curl_setopt($curl, CURLOPT_URL, "https://api.hubapi.com/contacts/v1/search/query?q=" . urlencode($fullname) . "&hapikey=" . $hubspotKey);
                curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                $response = curl_exec($curl);
                $response = json_decode($response);
                if (1 <= $response->total && count($response->contacts) > 0) {
                    for ($f = count($response->contacts) - 1; 0 <= $f; $f--) {
                        (!empty($response->contacts[$f]->vid)) ? $vid = $response->contacts[$f]->vid : $vid = '';
                        break;
                    }
                }
            }

            (!empty($profileInfo->phoneNumbers[0]->number)) ? $phoneNumber = $profileInfo->phoneNumbers[0]->number : $phoneNumber = '';
            if (!empty($phoneNumber)) {
                $phoneNumber = ",{\"property\": \"phone\",\"value\": \"" . $phoneNumber . "\"}";
            }
            if ($blkLstDta['company_li_id'] != 0)
                $domain = parse_url($blkLstDta['company_page_url'], PHP_URL_HOST);
            if (isset($domain)) {
                $domain = preg_replace('#^https?://#', '', $domain);
                $domain = preg_replace('{/$}', '', $domain);
            }
            if (isset($companyInfo->companyName)) {
                $companyName = $companyInfo->companyName;
            } else {
                $companyName = '';
            }

            $linkedin = "https://www.linkedin.com/in/" . $blkLstDta['url_publicIdentifier'];

            $portalId = Yii::$app->db->createCommand("select portal_id from user where id=" . $userId)->queryScalar();
            $flag_pd = 0;
            $sitetitle = Yii::$app->db->createCommand("SELECT sitetitle FROM `portals` WHERE `id` = " . $portalId)->queryScalar();
            if (!empty($sitetitle)) {
                $flag_pd = 1;
            }
            if ($flag_pd == 0) {
                $sitetitle = Yii::$app->db->createCommand("SELECT sitetitle FROM `portals` WHERE `portal_url` LIKE '%app.linkedfusion.io%'")->queryScalar();
                if (!empty($sitetitle)) {
                    $flag_pd = 1;
                }
            }

            if ($flag_pd == 1) {
                $GLOBALS['sitetitle'] = $sitetitle;
            } else {
                $GLOBALS['sitetitle'] = 'LinkedFusion';
            }

            $sitetitle = preg_replace('/\s+/', '', strtolower($GLOBALS['sitetitle']));
            $sitetitle_seq = $GLOBALS['sitetitle'] . '_sequence';
            $sitetitle_seq = preg_replace('/\s+/', '', strtolower($sitetitle_seq));

            $seq_name = $blkLstDta['seq_name'];
            $seq_name = str_replace('"', '', $seq_name);

            if (!empty($profileBasicInfo->occupation)) {
                $occupation = $profileBasicInfo->occupation;
            } else {
                $occupation = '';
            }

            if (isset($personEmail) && $personEmail != '') {
                $str = "{\"properties\": [{\"property\": \"firstname\",\"value\": \"" . $blkLstDta['firstName'] . "\"},{\"property\": \"lastname\",\"value\": \"" . $blkLstDta['lastName'] . "\"}" . $phoneNumber . ",{\"property\": \"website\",\"value\": \"" . $domain . "\"},{\"property\": \"company\",\"value\": \"" . $companyName . "\"},{\"property\": \"linkedin_uid\",\"value\": \"" . $personId . "\"},{\"property\": \"linkedin\",\"value\": \"" . $linkedin . "\"},{\"property\": \"email\",\"value\": \"" . $personEmail . "\"},{\"property\": \"hubspot_owner_id\",\"value\": \"" . $hubspotOwnerId . "\"},{\"property\": \"jobtitle\",\"value\": \"" . $occupation . "\"},{\"property\": \"contact_Source\",\"value\": \"LinkedIn\"},{\"property\": \"contact_Assigned_By\",\"value\": \"" . $sitetitle . "\"},{\"property\": \"" . $sitetitle_seq . "\",\"value\": \"" . $seq_name . "\"}]}";
            } else {
                $str = "{\"properties\": [{\"property\": \"firstname\",\"value\": \"" . $blkLstDta['firstName'] . "\"},{\"property\": \"lastname\",\"value\": \"" . $blkLstDta['lastName'] . "\"}" . $phoneNumber . ",{\"property\": \"website\",\"value\": \"" . $domain . "\"},{\"property\": \"company\",\"value\": \"" . $companyName . "\"},{\"property\": \"linkedin_uid\",\"value\": \"" . $personId . "\"},{\"property\": \"linkedin\",\"value\": \"" . $linkedin . "\"},{\"property\": \"jobtitle\",\"value\": \"" . $occupation . "\"},{\"property\": \"hubspot_owner_id\",\"value\": \"" . $hubspotOwnerId . "\"},{\"property\": \"contact_Source\",\"value\": \"LinkedIn\"},{\"property\": \"contact_Assigned_By\",\"value\": \"" . $sitetitle . "\"},{\"property\": \"" . $sitetitle_seq . "\",\"value\": \"" . $seq_name . "\"}]}";
            }

            if (!empty($vid)) {
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://api.hubapi.com/contacts/v1/contact/vid/" . $vid . "/profile?hapikey=" . $hubspotKey,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_POSTFIELDS => $str,
                    CURLOPT_HTTPHEADER => array(
                        "cache-control: no-cache",
                        "content-type: application/json"
                    ),
                ));
                $updateresponse = curl_exec($curl);
                $err = curl_error($curl);
                $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
                curl_close($curl);
                if ($err || (isset(json_decode($updateresponse)->status) && json_decode($updateresponse)->status == 'error')) {
                    $returnResponse['error'] = '1';
                    $returnResponse['errorMessage'] = 'Something went wrong while updating prospect.';
                } else {
                    $returnResponse['error'] = '0';
                    $returnResponse['errorMessage'] = 'Prospect has been updated successfully.';
                }

                /* $thread = Yii::$app->db->createCommand("SELECT thread FROM `conversations` WHERE userId = '".$userId."' AND personId = '".$personId."' AND threadId = '".$threadId."'")->queryScalar();
                  $conversationDetails = json_decode(mb_convert_encoding($thread, 'UTF-8', 'UTF-8'), true);
                  if(!empty($conversationDetails)){
                  foreach($conversationDetails as $conversationDetail){
                  $msg = '';
                  $msg = (!empty($conversationDetail['msg']))?$conversationDetail['msg']:'';
                  $type = (!empty($conversationDetail['type']))?$conversationDetail['type']:'';
                  if($type == 'I'){
                  $msg = $blkLstDta['firstName'] . ' ' . $blkLstDta['lastName'] . ' said:\n ' . $msg;
                  }elseif($type == 'S'){
                  $msg = $loggedInUserFirstName . ' ' . $loggedInUserLastName . ' said:\n ' . $msg;
                  }
                  $engagement = array('active' => 1,
                  'type' => 'NOTE',
                  'timeStamp' => (!empty($conversationDetail['createdAt']))?$conversationDetail['createdAt']:round(microtime(true) * 1000),
                  'uid' => (!empty($conversationDetail['id']))?$conversationDetail['id'].':'.$vid:'');
                  $associations = array('contactIds' => array($vid));
                  $metadata = array('body' => str_replace('/\n/g','\x3cbr\x3e', $msg));
                  $hubspotConversationStructure = array('engagement'=>$engagement,'associations'=>$associations,'metadata'=>$metadata);

                  $ch = curl_init();
                  curl_setopt($ch, CURLOPT_URL, "https://api.hubapi.com/engagements/v1/engagements?hapikey=".$hubspotKey);
                  curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
                  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                  curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                  curl_setopt($ch, CURLOPT_POST, 1);
                  curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($hubspotConversationStructure));
                  $res = curl_exec($ch);
                  curl_close($ch);
                  }
                  } */
            } else {
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://api.hubapi.com/contacts/v1/contact/?hapikey=" . $hubspotKey,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_POSTFIELDS => $str,
                    CURLOPT_HTTPHEADER => array(
                        "cache-control: no-cache",
                        "content-type: application/json"
                    ),
                ));
                $contactresponse = curl_exec($curl);
                $err = curl_error($curl);
                curl_close($curl);
                if ($err || (isset(json_decode($contactresponse)->status) && json_decode($contactresponse)->status == 'error')) {
                    $returnResponse['error'] = '1';
                    $returnResponse['errorMessage'] = 'Something went wrong while creating prospect.';
                } else {
                    $returnResponse['error'] = '0';
                    $returnResponse['errorMessage'] = 'Prospect has been created successfully.';
                }
            }
        } else {
            $returnResponse['error'] = '1';
            $returnResponse['errorMessage'] = 'Hubspot key not found.';
        }
        echo json_encode($returnResponse);
    }

    public function actionGetchatcontent() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $threadId = Yii::$app->request->post('threadId');
        $personId = Yii::$app->request->post('personId');
        $query = new Query();
        $query->select('thread,id,isRead')
                ->from('conversations')
                ->where(['threadId' => $threadId, 'conversations.userId' => Yii::$app->session->get('userid')])
        ;
        $threadData = $query->one();
        $thread = json_decode(mb_convert_encoding($threadData['thread'], 'UTF-8', 'UTF-8'));
 
        $content = '';

        $responsReceived = 0;
        $queryBlckLst = new Query();
        $queryBlckLst->select('blacklist.profileInfo_id,blacklist.companyInfo_id,blacklist.seq_id as seqIds,blacklist.id as blId,blacklist.firstName, blacklist.lastName,blacklist.url_publicIdentifier, blacklist.is_response, blacklist.tags, blacklist.seq_name, profileinfo.*, companyinfo.company_detail')->from('blacklist')->where(['blacklist.linkedinpublicid' => $personId, 'blacklist.userid' => Yii::$app->session->get('userid')])
                ->leftJoin('profileinfo', 'profileinfo.id = blacklist.profileInfo_id')
                ->leftJoin('companyinfo', 'companyinfo.id = blacklist.companyInfo_id');
        //echo $queryBlckLst->createCommand()->getRawSql();
        $threadPerson = $queryBlckLst->one();
		$PipeDrivedata = $threadPerson;
		
		
		$noemail='';
				//if(Yii::$app->session->get('userid') == '16943' || Yii::$app->session->get('userid') == '14909'){
					if(isset($threadPerson['blId']) && $threadPerson['blId'] != ''){
						//$noemail = '<a href="javascript:void(0);" data-blk-id="'.$threadPerson['blId'].'" class="find_prospect_email_btn badge badge-warning" title="Find Email.">Find Email</a>';
						$noemail = 'N/A';
					}else{
						$noemail = 'N/A';
					}
				//}
				//else{
					//$noemail = 'N/A';
				//}
		if(isset($threadPerson['blId']) && $threadPerson['blId'] != ''){		
			$lfcomemail = '<a href="javascript:void(0);" data-blk-id="'.$threadPerson['blId'].'" class="find_prospect_email_btn badge badge-warning" title="Find Email.">Find Email</a>';
		}else{
			$lfcomemail = 'N/A';
		}
		$lfemail = 'N/A';
		
        if (empty($threadPerson)) {
            $queryFirstDegree = new Query();
            $queryFirstDegree->select('sequenceIds as seqIds,fullName, phoneNumbers, emailID, locationName, occupation , url_publicIdentifier, companyDetail, tags')
                    ->from('1stdegreedata')
                    ->where(['1stdegreedata.linkedinpublicid' => $personId, '1stdegreedata.userId' => Yii::$app->session->get('userid')]);
            $threadPerson = $queryFirstDegree->one();

            (!empty($threadPerson['emailID'])) ? $email = '<a href="mailto:' . $threadPerson['emailID'] . '">' . $threadPerson['emailID'] . '</a>' : $email = $noemail;
            (!empty($threadPerson['locationName'])) ? $location = $threadPerson['locationName'] : $location = 'N/A';
            (!empty($threadPerson['occupation'])) ? $occupation = $threadPerson['occupation'] : $occupation = 'N/A';
            $industryName = 'N/A';
            $name = $threadPerson['fullName'];
            $publicIdentifier = $threadPerson['url_publicIdentifier'];
            if (!empty($threadPerson['fullName'])) {
                $initials = strtoupper(substr(preg_split('/\s+/', $threadPerson['fullName'])[0], 0, 1) . substr(preg_split('/\s+/', $threadPerson['fullName'])[1], 0, 1));
            } else {
                $initials = '';
            }
            
			//echo $threadPerson['phoneNumbers']; exit;
			
			if(!empty($threadPerson['phoneNumbers'])) 
			{ 
				$phoneNumber = $threadPerson['phoneNumbers'];
				
																			
			} 
			else 
			{ 
				$phoneNumber = 'N/A';  
				
				
			}
			
				
			
			//echo $phoneNumber; exit;
			
            (!empty(json_decode(str_replace('""', '"', $threadPerson['companyDetail']))->companyName)) ? $companyName = json_decode(str_replace('""', '"', $threadPerson['companyDetail']))->companyName : $companyName = 'N/A';
            $sequenceName = 'N/A';
			
			(!empty(json_decode(str_replace('""', '"', $threadPerson['companyDetail']))->companyPageUrl)) ? $companyPageUrl = json_decode(str_replace('""', '"', $threadPerson['companyDetail']))->companyPageUrl : $companyPageUrl = 'N/A';
            $companyPageUrl = 'N/A';
        } else {
            $responsReceived = $threadPerson['is_response'];
            if ($responsReceived) {
                $scheduledTasks = Yii::$app->db->createCommand("Select COUNT(*) from `ext_tasks` WHERE `status` = 'Paused' AND `personId` = '" . $personId . "' AND `userId` = '" . Yii::$app->session->get('userid') . "'")->queryScalar();
                if ($scheduledTasks == 0) {
                    $responsReceived = 0;
                }
            }
            (!empty(json_decode(trim($threadPerson['contactInfo'], '"'))->emailAddress)) ? $email = '<a href="mailto:' . json_decode(trim($threadPerson['contactInfo'], '"'))->emailAddress . '">' . json_decode(trim($threadPerson['contactInfo'], '"'))->emailAddress . '</a>' : $email = $noemail;
			(!empty(json_decode(trim($threadPerson['contactInfo'], '"'))->LFcompanyEmail)) ? $lfemail = '<a href="mailto:' . json_decode(trim($threadPerson['contactInfo'], '"'))->LFcompanyEmail . '">' . json_decode(trim($threadPerson['contactInfo'], '"'))->LFcompanyEmail . '</a>' : $lfemail = $lfcomemail;
            (!empty(json_decode($threadPerson['basicInfo'])->locationName)) ? $location = json_decode($threadPerson['basicInfo'])->locationName : $location = 'N/A';
            (!empty(json_decode($threadPerson['basicInfo'])->occupation)) ? $occupation = json_decode($threadPerson['basicInfo'])->occupation : $occupation = 'N/A';
            (!empty(json_decode($threadPerson['basicInfo'])->industryName)) ? $industryName = json_decode($threadPerson['basicInfo'])->industryName : $industryName = 'N/A';
            $initials = strtoupper(substr($threadPerson['firstName'], 0, 1) . substr($threadPerson['lastName'], 0, 1));
            $name = $threadPerson['firstName'] . ' ' . $threadPerson['lastName'];
            $publicIdentifier = $threadPerson['url_publicIdentifier'];
            //(!empty(json_decode(trim($threadPerson['contactInfo'], '"'))->phoneNumbers[0]->number)) ? $phoneNumber = json_decode(trim($threadPerson['contactInfo'], '"'))->phoneNumbers[0]->number : $phoneNumber = 'N/A';

            if (isset(json_decode(trim($threadPerson['contactInfo'], '"'))->phoneNumbers)) {
                if (isset(json_decode(trim($threadPerson['contactInfo'], '"'))->phoneNumbers->number)) {
                    $phoneNumbers = $contactInfo->phoneNumbers->number;
                } else if (isset(json_decode(trim($threadPerson['contactInfo'], '"'))->phoneNumbers[0]->number)) {
                    $phoneNumbers = json_decode(trim($threadPerson['contactInfo'], '"'))->phoneNumbers[0]->number;
                } else {
                    $phoneNumbers = 'N/A';
                }
            } else {
                $phoneNumbers = "N/A";
            }
			
			$lifirstname = 'N/A';
			if( (!empty(json_decode($threadPerson['basicInfo'])->firstName))){
				
				$lifirstname = json_decode($threadPerson['basicInfo'])->firstName;
			}
			
			$lilastname = 'N/A';
			if( (!empty(json_decode($threadPerson['basicInfo'])->lastName))){
				
				$lilastname = json_decode($threadPerson['basicInfo'])->lastName;
			}
			
			
			//echo $phoneNumbers; exit;

            (!empty(json_decode(str_replace('"]', '', str_replace('["', '', $threadPerson['company_detail'])))->companyName)) ? $companyName = json_decode(str_replace('"]', '', str_replace('["', '', $threadPerson['company_detail'])))->companyName : $companyName = 'NA';
			
			
			(!empty(json_decode(str_replace('"]', '', str_replace('["', '', $threadPerson['company_detail'])))->companyPageUrl)) ? $companyPageUrl = json_decode(str_replace('"]', '', str_replace('["', '', $threadPerson['company_detail'])))->companyPageUrl : $companyPageUrl = 'NA';
			
            $sequenceName = $threadPerson['seq_name'];
			
        }
		
		

        $queryUsr = new Query();
        $queryUsr->select('TimeZone')->from('user')->where(['id' => Yii::$app->session->get('userid')]);
        $usrData = $queryUsr->one();

        $tagsHTML = '';
		if (empty($threadPerson['tags'])) {
		 
			$queryFirstDegreetags = new Query();
            $queryFirstDegreetags->select('tags')
                    ->from('1stdegreedata')
                    ->where(['1stdegreedata.linkedinpublicid' => $personId, '1stdegreedata.userId' => Yii::$app->session->get('userid')]);
            $threadPersontags = $queryFirstDegreetags->one();
		 
		 }
		 
		// if(Yii::$app->session->get('userid') == 24134){
		 // echo $threadPerson['tags']; exit;
		 //}
		
        if (!empty($threadPerson['tags'])) {
            $tags = explode(',', $threadPerson['tags']);
            foreach ($tags as $tag) {
                $queryTag = new Query();
                $queryTag->select('tagName')
                        ->from('tags')
                        ->where(['id' => $tag]);
                $tagName = $queryTag->scalar();
//                $tagsHTML .= '<span class="badge badge-light-primary badge-pill" style="margin-right: 10px;margin-bottom: 10px;">' . $tagName . '</span>';
                $tagsHTML .= '<span id="tagID' . $tag . '" class="badge badge-light-primary badge-pill" style="margin-right: 10px;margin-bottom: 10px;line-height: 1.5;padding-right: 20px;">' . $tagName . ' <a href="javascript:;" style="position: absolute;" onclick="removeAssignTag(' . $tag . ')"><i class="bx bx-x"></i></a></span>';
            }
        } else {
            $tagsHTML = 'No tags';
        }
		
	

        if (!empty($thread)) {
            foreach ($thread as $msg) {
                if (!empty($msg->type) && $msg->type != 2 && !empty($msg->msg) && !empty($msg->createdAt)) {
                    $ist_date = \DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d H:i:s', $msg->createdAt / 1000), new \DateTimeZone('UTC'));
                    $gmt_date = clone $ist_date;
                    $gmt_date->setTimeZone(new \DateTimeZone($usrData['TimeZone']));
                    $created = $gmt_date->format('d M Y h:i A');
                    if ($msg->type == 'S') {
                        $content .= '<div class="chat">
							<div class="chat-avatar">
								<a class="avatar m-0" data-letters="' . strtoupper(substr(Yii::$app->session->get('linkedin_firstname'), 0, 1) . substr(Yii::$app->session->get('linkedin_lastname'), 0, 1)) . '"></a>
							</div>
							<div class="chat-body">
								<div class="chat-message">
									<p>' . htmlspecialchars_decode($msg->msg) . '</p>
									<span class="chat-time">' . $created . '</span>
								</div>
							</div>
						</div>';
                    } else {
                        $content .= '<div class="chat chat-left">
							<div class="chat-avatar">
								<a class="avatar m-0" data-letters="' . strtoupper($initials) . '"></a>
							</div>
							<div class="chat-body">
								<div class="chat-message">
									<p>' . htmlspecialchars_decode($msg->msg) . '</p>
									<span class="chat-time">' . $created . '</span>
								</div>
							</div>
						</div>';
                    }
                    $resFlag = 1;
                } else {
                    $resFlag = 0;
                }
            }
        }

        $occupationFl = $occupation;
        $companyNameFl = $companyName;
        $industryNameFl = $industryName;
        $sequenceNameFl = $sequenceName;
		
		if($threadPerson['url_publicIdentifier'] == 'navnit-uchadadiya-7864a324'){
			//echo $companyName; exit;
		}
		$curCompanyname ='NA';
		$curcompanyPageUrl ='NA';
		if(isset($threadPerson['company_detail'])){
				$company_detail_1 = json_decode($threadPerson['company_detail']);
				if(isset($company_detail_1->companyName)){
								$curCompanyname = $company_detail_1->companyName;
				}
				
				if(isset($company_detail_1->companyPageUrl)){
								$curcompanyPageUrl = $company_detail_1->companyPageUrl;
				}
		}
		
		if($companyName == 'NA'){ $companyName = $curCompanyname; }
		if($companyPageUrl == 'NA'){ $companyPageUrl = $curcompanyPageUrl; }

        $occupation = strlen($occupation) > 25 ? substr($occupation, 0, 25) . "..." : $occupation;
        $companyName = strlen($companyName) > 25 ? substr($companyName, 0, 25) . "..." : $companyName;
        $industryName = strlen($industryName) > 25 ? substr($industryName, 0, 25) . "..." : $industryName;
        $sequenceName = strlen($sequenceName) > 25 ? substr($sequenceName, 0, 25) . "..." : $sequenceName;

        $accessKey = Yii::$app->db->createCommand("select access_key from intigration where user_id=" . Yii::$app->session->get('userid'))->queryScalar();
        $keys = json_decode($accessKey);

		

        $info = "";

        if (!empty($keys->Webhooks)) {

            $webhookurl = $keys->Webhooks;
            $haystack = Yii::$app->session->get('useremail');
            $needle = "@kennected.io";
            $needlesales = "@salesgig.com";
            //$needletest = "@sugocapital.com"; 

            if (Yii::$app->params['portal_id'] == '2' || strpos($haystack, $needle) !== false || strpos($haystack, $needlesales) !== false) {
               // if (strpos($webhookurl, 'hooks.zapier.com') !== false) {
                if ($webhookurl != '') {
                    $info .= '<div class="infoBlkNMzap" style="float: left; position: absolute; margin: -10px 0px 0px -3px;"><span class="nmLbl">&nbsp</span> <span class="nmData font-weight-bold"><img style="width:16px;margin-right: 3px;" title="View" src="/web/img/zapier-icon.png"><a href="javascript:;" class="pushTozapier badge badge-warning" title="Push prospect details to zapier.">Zapier</a><input type="hidden" name="zapierData" id="zapierData" value=""><input type="hidden" name="ResponceThreadzap" id="ResponceThreadzap" value=""></span></div>';
                }
				
				
            }
        }

		$hubspotaccesstoken = Yii::$app->db->createCommand("select access_token,portal_id from  hubspot_token where userId='" . Yii::$app->session->get('userid') . "'")->queryOne();

		$zohoaccesstoken = Yii::$app->db->createCommand("select zc_status from crm_token where user_id='" . Yii::$app->session->get('userid') . "'")->queryOne();	
		
		if(Yii::$app->session->get('userid') == 21196){
			
			//echo '<pre>'; print_r($zohoaccesstoken['zc_status']);
		}
		
        if (!empty($keys->hubportal_id) && !empty($keys->hubspot_key)) {
            $info .= '<div class="infoBlkNM" style="display:none"><span class="nmLbl">&nbsp</span> <span class="nmData font-weight-bold"><a href="javascript:;" class="pushToHubSpot" title="Sync to CRM">Sync to CRM</a><input type="hidden" name="hubspotData" id="hubspotData" value=""><input type="hidden" name="ResponceThread" id="ResponceThread" value=""></span></div>';
        } elseif(!empty($hubspotaccesstoken)){
			
			 $info .= '<div class="infoBlkNM" style="display:none"><span class="nmLbl">&nbsp</span> <span class="nmData font-weight-bold"><a href="javascript:;" class="pushToHubSpot" title="Sync to CRM">Sync to CRM</a><input type="hidden" name="hubspotData" id="hubspotData" value=""><input type="hidden" name="ResponceThread" id="ResponceThread" value=""></span></div>';
		} elseif (!empty($keys->pipedrive_api_key)) {
            $info .= '<div class="infoBlkNM" style="display:none"><span class="nmLbl">&nbsp</span> <span class="nmData font-weight-bold"><a href="javascript:;" class="pushTopipeDrive" title="Sync to CRM">Sync to CRM</a><input type="hidden" name="hubspotData" id="hubspotData" value=""><input type="hidden" name="ResponceThread" id="ResponceThread" value=""></span></div>';
        } elseif(isset($zohoaccesstoken['zc_status']) && $zohoaccesstoken['zc_status'] == '1'){ 
			if(Yii::$app->session->get('userid') == 21196){ 
			//echo 'HERE';
				$info .= '<div class="infoBlkNM" style="display:none"><span class="nmLbl">&nbsp</span> <span class="nmData font-weight-bold"><a href="javascript:;" class="pushToZoho" title="Sync to CRM">Sync to CRM</a><input type="hidden" name="zohoData" id="zohoData" value=""><input type="hidden" name="ResponceThread" id="ResponceThread" value=""></span></div>';
			}
		}else {
//            $info .= '<div class="infoBlkNM" style="display:none"><span class="nmLbl">&nbsp</span> <span class="nmData font-weight-bold">Please Connect CRM</span></div>';
        }
		$phno = '';
		if(!empty($phoneNumber)){
			$phno = $phoneNumber; 
		}else if(!empty($phoneNumbers)){
			$phno = $phoneNumbers; 
		}else{
			$phno = 'N/A';
		}
		
        if (Yii::$app->session->get('user_role') != 1) {
            $info .= '<div class="infoBlkNM"><span class="nmLbl">Sequence Name</span> <span class="nmData font-weight-bold sequenceNm" title="' . $sequenceNameFl . '">' . $sequenceName . '</span></div>';
        }
		$name=substr($name, 0, 20) . "..";
        $info .= '<div class="infoBlkNM"><span class="nmLbl">Name</span> <span class="nmData font-weight-bold"><a href="https://www.linkedin.com/in/' . $publicIdentifier . '" target="_blank" ><i class="fa fa-linkedin-square" aria-hidden="true"></i> ' . $name . '</a></span></div>';
        $info .= '<div class="infoBlkNM"><span class="nmLbl">Email </span> <span class="nmData font-weight-bold">' . $email . '</span></div>';
		$info .= '<div class="infoBlkNM"><span class="nmLbl">Company Email </span> <span class="nmData font-weight-bold">' . $lfemail . '</span></div>';
		
        $info .= '<div class="infoBlkNM"><span class="nmLbl">Phone </span> <span class="nmData font-weight-bold">' . $phno . '</span></div>';
        $info .= '<div class="infoBlkNM"><span class="nmLbl">Location </span> <span class="nmData font-weight-bold location_val">' . $this->unicodeString($location) . '</span></div>';
        $info .= '<div class="infoBlkNM"><span class="nmLbl">Occupation </span> <span class="nmData font-weight-bold" title="' . $occupationFl . '">' . $this->unicodeString($occupation) . '</span></div>';
        $info .= '<div class="infoBlkNM"><span class="nmLbl">Current Company </span> <span class="nmData font-weight-bold" title="' . $companyNameFl . '">' . $this->unicodeString($companyName) . '</span></div>';
        $info .= '<div class="infoBlkNM"><span class="nmLbl">Industry Name </span> <span class="nmData font-weight-bold" title="' . $industryNameFl . '">' . $this->unicodeString($industryName) . '</span></div>';
        $info .= '<div class="infoBlkNM" style="display:none;"><span id="ffname_prospect">'.$lifirstname.'</span><span id="lname_prospect">'.$lilastname.'</span><span class="li_companydomain">'.$companyPageUrl.'</span></div>';
        
		
	

        $notesQry = new Query();
        $notes = $notesQry->select('note, created')->from('notes')->where(['personId' => $personId, 'threadId' => $threadId, 'userId' => Yii::$app->session->get('userid')])->all();
        $notesHTML = '';
        if (!empty($notes)) {
            foreach ($notes as $note) {
                $ist_date = \DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d H:i:s', $note['created'] / 1000), new \DateTimeZone('UTC'));
                $gmt_date = clone $ist_date;
                $gmt_date->setTimeZone(new \DateTimeZone($usrData['TimeZone']));
                $created = $gmt_date->format('d M Y h:i A');
                $notesHTML .= '<span>' . $created . ': </span><span>' . $note['note'] . '</span><br>';
            }
        } else {
            $notesHTML = 'No notes';
        }


        //START: Add code for push in hubspot - 04-dec-2020
        $userId = Yii::$app->session->get('userid');
        $portalId = Yii::$app->db->createCommand("select portal_id from user where id=" . $userId)->queryScalar();
        $flag_pd = 0;
        $sitetitle = Yii::$app->db->createCommand("SELECT sitetitle FROM `portals` WHERE `id` = " . $portalId)->queryScalar();
        if (!empty($sitetitle)) {
            $flag_pd = 1;
        }
        if ($flag_pd == 0) {
            $sitetitle = Yii::$app->db->createCommand("SELECT sitetitle FROM `portals` WHERE `portal_url` LIKE '%app.linkedfusion.io%'")->queryScalar();
            if (!empty($sitetitle)) {
                $flag_pd = 1;
            }
        }

		

        $hubspotData = "";
        $hubspotArr = array();
        $hubspotArr['hubportal_id'] = (!empty($keys->hubportal_id)) ? $keys->hubportal_id : "";
        $hubspotArr['hubspot_key'] = (!empty($keys->hubspot_key)) ? $keys->hubspot_key : "";
        $hubspotArr['actUserID'] = (!empty($keys->actUserID)) ? $keys->actUserID : "";
        $hubspotArr['pipedrive_api_key'] = (!empty($keys->pipedrive_api_key)) ? $keys->pipedrive_api_key : "";
		$hubspotArr['zoho_api_key'] = (!empty($zohoaccesstoken['zc_status'])) ? $zohoaccesstoken['zc_status'] : "";



        if (!isset($threadPerson['firstName']) && !isset($threadPerson['lastName']) && isset($threadPerson['fullName'])) {
            $nameExplode = explode(' ', $threadPerson['fullName'], 2);
            $threadPerson['firstName'] = $nameExplode[0];
            $threadPerson['lastName'] = $nameExplode[1];
        }
        $hubspotArr['profileInfo_id'] = "-1";
        if (isset($threadPerson['profileInfo_id']) && !empty($threadPerson['profileInfo_id'])) {
            $hubspotArr['profileInfo_id'] = $threadPerson['profileInfo_id'];
        }
        $hubspotArr['companyInfo_id'] = "-1";
        if (isset($threadPerson['companyInfo_id']) && !empty($threadPerson['companyInfo_id'])) {
            $hubspotArr['companyInfo_id'] = $threadPerson['companyInfo_id'];
        }

        if ($userId == '16839') {

            if (isset($threadPerson['basicInfo'])) {
                $profilelocation = (!empty(json_decode(trim($threadPerson['basicInfo'], '"'))->locationName)) ? json_decode(trim($threadPerson['basicInfo'], '"'))->locationName : '';

                if ($profilelocation != '') {
                    $hubspotArr['locationName'] = $profilelocation;
                } else {
                    $hubspotArr['locationName'] = 'NA';
                }
            }
        }
		
		
			
		//echo $threadPerson['firstName']; exit;
		
        $hubspotArr['seqIds'] = $threadPerson['seqIds'];
        $hubspotArr['firstName'] = $threadPerson['firstName'];
        $hubspotArr['lastName'] = $threadPerson['lastName'];
        $hubspotArr['fullname'] = $threadPerson['firstName'] . " " . $threadPerson['lastName'];
        if (isset($threadPerson['contactInfo'])) {
            $hubspotArr['email'] = (!empty(json_decode(trim($threadPerson['contactInfo'], '"'))->emailAddress)) ? json_decode(trim($threadPerson['contactInfo'], '"'))->emailAddress : '';
        } else {
            $hubspotArr['email'] = (!empty($threadPerson['emailID'])) ? $threadPerson['emailID'] : "";
        }
		
		if (isset($threadPerson['contactInfo'])) {
            $hubspotArr['LFcompanyEmail'] = (!empty(json_decode(trim($threadPerson['contactInfo'], '"'))->LFcompanyEmail)) ? json_decode(trim($threadPerson['contactInfo'], '"'))->LFcompanyEmail : '';
        } else {
            $hubspotArr['LFcompanyEmail'] = "NA";
        }

        if (isset($threadPerson['contactInfo'])) {

            if (isset(json_decode(trim($threadPerson['contactInfo'], '"'))->phoneNumbers)) {
                if (isset(json_decode(trim($threadPerson['contactInfo'], '"'))->phoneNumbers->number)) {
                    $phoneNumbers = $contactInfo->phoneNumbers->number;
                } else if (isset(json_decode(trim($threadPerson['contactInfo'], '"'))->phoneNumbers[0]->number)) {
                    $phoneNumbers = json_decode(trim($threadPerson['contactInfo'], '"'))->phoneNumbers[0]->number;
                } else {
                    $phoneNumbers = 'NA';
                }
            } else {
                $phoneNumbers = "NA";
            }

            //$hubspotArr['phone'] = (!empty(json_decode(trim($threadPerson['contactInfo'], '"'))->phoneNumbers[0]->number)) ? $phoneNumber = json_decode(trim($threadPerson['contactInfo'], '"'))->phoneNumbers[0]->number : $phoneNumber = '';

            $hubspotArr['phone'] = $phoneNumbers;
        } else {
            $hubspotArr['phone'] = "";
        }
        $hubspotArr['linkedin_uid'] = $personId;
        $hubspotArr['linkedin'] = $threadPerson['url_publicIdentifier'];
        $hubspotArr['seq_name'] = $sequenceName;
        if ($flag_pd == 1) {
            $GLOBALS['sitetitle'] = $sitetitle;
        } else {
            $GLOBALS['sitetitle'] = 'LinkedFusion';
        }

		

        $sitetitle = preg_replace('/\s+/', '', strtolower($GLOBALS['sitetitle']));
        $sitetitle_seq = $GLOBALS['sitetitle'] . '_sequence';
        $sitetitle_seq = preg_replace('/\s+/', '', strtolower($sitetitle_seq));
        $hubspotArr['contact_assigned_by'] = $sitetitle;
        $hubspotArr['sitetitle_seq'] = $sitetitle_seq;
        $hubspotArr[$sitetitle_seq] = $sequenceName;
        $hubspotArr['contact_source'] = "linkedin";
        if ($occupationFl == "N/A") {
            $occupationFl = "";
        } else {
            $occupationFl = $occupationFl;
        }
        $hubspotArr['occupation'] = $occupationFl;
			
		
			
        if (isset($threadPerson['company_detail'])) {
            $company_detail = json_decode(str_replace('"]', '', str_replace('["', '', $threadPerson['company_detail'])), true);
            $hubspotArr['name'] = (!empty($company_detail['companyName'])) ? $company_detail['companyName'] : "";
            $hubspotArr['linkedin_company_page'] = (!empty($company_detail['url'])) ? $company_detail['url'] : "";
            $hubspotArr['website'] = (!empty($company_detail['companyPageUrl'])) ? $company_detail['companyPageUrl'] : "";
            $hubspotArr['domain'] = (!empty($company_detail['companyPageUrl'])) ? $company_detail['companyPageUrl'] : "";
            $hubspotArr['industry'] = (!empty($company_detail['industries'])) ? $company_detail['industries'] : "";
        }
        if (isset($threadPerson['companyDetail'])) {
            $hubspotArr['name'] = (!empty(json_decode(str_replace('""', '"', $threadPerson['companyDetail']))->companyName)) ? $companyName = json_decode(str_replace('""', '"', $threadPerson['companyDetail']))->companyName : $companyName = '';
            $hubspotArr['linkedin_company_page'] = "";
            $hubspotArr['website'] = "";
            $hubspotArr['domain'] = "";
            $hubspotArr['industry'] = "";
        }
		
		
		
		//if($threadPerson['url_publicIdentifier'] == 'navnit-uchadadiya-7864a324'){
			
		if(isset($threadPerson['company_detail'])){
			
				$company_detail_2 = json_decode($threadPerson['company_detail']);
		
					if(empty($hubspotArr['name'])){
						
						if(isset($company_detail_2->companyName)){
						$hubspotArr['name'] = $company_detail_2->companyName;
						}
					}
					
					if(empty($hubspotArr['linkedin_company_page'])){
						
						if(isset($company_detail_2->url)){
						$hubspotArr['linkedin_company_page'] = $company_detail_2->url;
						}
					}
					
					if(empty($hubspotArr['website'])){
						
						if(isset($company_detail_2->companyPageUrl)){
						$hubspotArr['website'] = $company_detail_2->companyPageUrl;
						}
					}
					
					if(empty($hubspotArr['domain'])){
						
						if(isset($company_detail_2->companyPageUrl)){
						$hubspotArr['domain'] = $company_detail_2->companyPageUrl;
						}
					}
					
					if(empty($hubspotArr['industry'])){
						
						if(isset($company_detail_2->industries)){
						$hubspotArr['industry'] = str_replace('"]', '', str_replace('["', '', $company_detail_2->industries));
						}
						
					}
					
					if(!isset($hubspotArr['locationName'])){
						if(isset($company_detail_2->locationName)){
						$hubspotArr['locationName'] = $company_detail_2->locationName;
						}
					}
					
		}
		
			//echo '<prE>'; print_r($threadPerson); exit;
		
		//}
		
        //End: Add code for push in hubspot - 04-dec-2020

        $checkContact = array();
        $checkContact['firstName'] = $threadPerson['firstName'];
        $checkContact['lastName'] = $threadPerson['lastName'];
        $checkContact['email'] = $hubspotArr['email'];
       /// $checkContact['phone'] = (!empty($phoneNumbers)) ? $phoneNumbers : "NA";
        $checkContact['hubportal_id'] = (!empty($keys->hubportal_id)) ? $keys->hubportal_id : "";
        $checkContact['hubspot_key'] = (!empty($keys->hubspot_key)) ? $keys->hubspot_key : "";
        $checkContact['actUserID'] = (!empty($keys->actUserID)) ? $keys->actUserID : "";
        $checkContact['pipedrive_api_key'] = (!empty($keys->pipedrive_api_key)) ? $keys->pipedrive_api_key : "";
        $checkContact['zoho_api_key'] = (!empty($zohoaccesstoken['zc_status'])) ? $zohoaccesstoken['zc_status'] : "";
		
		
		
		//echo '<pre>'; print_r($PipeDrivedata); exit;
		// pipeDrive 
		if(isset($keys->pipedrive_api_key) && $keys->pipedrive_api_key != ''){
			
				 //$hubspotArr['seqIds'] = $threadPerson['seqIds'];
				
				if($hubspotArr['firstName'] == '' || $hubspotArr['firstName'] == 'N/A')
				{
					$hubspotArr['firstName'] = $PipeDrivedata['firstName'];
				}
				if($hubspotArr['lastName'] == '' || $hubspotArr['lastName'] == 'N/A')
				{
					$hubspotArr['lastName'] = $PipeDrivedata['lastName'];
				}
				
				if($hubspotArr['fullname'] == '' || $hubspotArr['fullname'] == 'N/A')
				{
					$hubspotArr['fullname'] = $PipeDrivedata['firstName'].' '.$PipeDrivedata['lastName'];
				}
				
				if($hubspotArr['email'] == '' || $hubspotArr['email'] == 'N/A')
				{
					
					 if (isset($PipeDrivedata['contactInfo'])) {
							$hubspotArr['email'] = (!empty(json_decode(trim($PipeDrivedata['contactInfo'], '"'))->emailAddress)) ? json_decode(trim($PipeDrivedata['contactInfo'], '"'))->emailAddress : '';
						} else {
							$hubspotArr['email'] = (!empty($PipeDrivedata['emailID'])) ? $PipeDrivedata['emailID'] : "";
						}
					
				}
		}
		// end pipeDrive
		//echo '<pre>'; print_r($hubspotArr); exit;
		
		
		

        $content = mb_convert_encoding($content, 'UTF-8', 'UTF-8');
        $info = mb_convert_encoding($info, 'UTF-8', 'UTF-8');
        $response = array('content' => $content, 'info' => $info, 'tags' => $tagsHTML, 'notes' => $notesHTML, 'isResponded' => $responsReceived, 'hubspotData' => json_encode($hubspotArr), 'checkContact' => $checkContact, 'resFlag' => $resFlag, 'readStatus' => $threadData['isRead'], 'threadId' => $threadId, 'personId' => $personId);
        echo json_encode($response); 
    }

    public function actionConversationread(){
		$userId = Yii::$app->session->get('userid');
		$threadId = Yii::$app->request->post('threadId');
        $personId = Yii::$app->request->post('personId');
		$query = new Query();
        $query->select('thread,id,isRead')
                ->from('conversations')
                ->where(['threadId' => $threadId, 'conversations.userId' => Yii::$app->session->get('userid')])
        ;
        $threadData = $query->one();
        $queryUsr = new Query();
        $queryUsr->select('proxyIp, proxyPort, proxyUsername, proxyPassword, cookie, csrf ,userAgent,popupstatus')->from('user')->where(['id' => $userId]);
        $usrData = $queryUsr->one();
        $csrf = $usrData['csrf'];
        $cookie = $usrData['cookie'];
        $proxyIp = $usrData['proxyIp'];
        $proxyPort = $usrData['proxyPort'];
        $proxyUsername = $usrData['proxyUsername'];
        $proxyPassword = $usrData['proxyPassword'];
        $userAgent = $usrData['userAgent'];
        $readStatus = 'true';
        $payload = "{\"patch\":{\"\$set\":{\"read\":" . $readStatus . "}}}";
        $curlMessage = curl_init();
        curl_setopt_array($curlMessage, array(
            CURLOPT_URL => "https://www.linkedin.com/voyager/api/messaging/conversations/" . $threadId,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HEADER => true,
            /* CURLOPT_VERBOSE=>true, */
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPPROXYTUNNEL => 1,
            CURLOPT_PROXY => "$proxyIp",
            CURLOPT_PROXYPORT => "$proxyPort",
            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => array(
                "cookie: $cookie",
                "csrf-token: $csrf",
                "authority:www.linkedin.com",
                "scheme:https",
                "Accept: application/vnd.linkedin.normalized+json+2.1",
                "Accept-Language: en-US,en;q=0.5",
                "Accept-Encoding: gzip, deflate, br",
                "Content-Length: " . strlen($payload),
                "Content-Type: application/json; charset=UTF-8",
                "x-li-lang: en_US",
                "user-agent: $userAgent",
                "origin: https://www.linkedin.com",
                "referer: https://www.linkedin.com/messaging/thread/" . $threadId,
                "x-restli-protocol-version: 2.0.0",
                "x-li-lang: en_US"
            ) 
        ));
        $resMessage = curl_exec($curlMessage);
		//echo $resMessage; exit;
        $header_size = curl_getinfo($curlMessage, CURLINFO_HEADER_SIZE);
        $headers = substr($resMessage, 0, $header_size);
        $resMessage = substr($resMessage, $header_size);
        $http_code = curl_getinfo($curlMessage, CURLINFO_HTTP_CODE); 
		 
		if ($http_code == 200 ||$http_code == 204 ||$http_code == 500 ||  $usrData['popupstatus']==0) { 
            $sqlUpdate_task = Yii::$app->db->createCommand("UPDATE conversations SET isRead = '1' WHERE id ='" . $threadData['id'] . "'")->execute();
        }else {
			$pubIdentifierQuery = new Query();
			$pubIdentifier=$pubIdentifierQuery->select('url_publicIdentifier')->from('blacklist')->where(['userid' => $userId,'linkedinpublicid' => $personId])->scalar();
			if(empty($pubIdentifier)){
				$pubIdentifier=$pubIdentifierQuery->select('url_publicIdentifier')->from('1stdegreedata')->where(['userId' => $userId,'linkedinpublicid' => $personId])->scalar();
			}
			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/dash/profiles?q=memberIdentity&memberIdentity=".$pubIdentifier."&decorationId=com.linkedin.voyager.dash.deco.identity.profile.TopCardSecondaryData-35", 
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 30,
				CURLOPT_HEADER => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_HTTPPROXYTUNNEL => 1,
				CURLOPT_PROXY => "$proxyIp",
				CURLOPT_PROXYPORT => "$proxyPort",
				CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
				CURLOPT_CUSTOMREQUEST => "GET",
				CURLOPT_HTTPHEADER => array(
					"cookie: $cookie",
					"csrf-token: $csrf",
					"authority: www.linkedin.com",
					"User-Agent: $userAgent",
					"accept: application/vnd.linkedin.normalized+json+2.1",
					"Accept-Language: en-US,en;q=0.5",
					"Accept-Encoding: gzip, deflate, br",
					"x-li-lang: en_US",
					"x-restli-protocol-version: 2.0.0"
				)
			));
			$res = curl_exec($curl);
            if (curl_errno($curl)) {
                $error_msg = curl_error($curl);
                return false;
            } else {
                if (!empty($res)) { 
					$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
					$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
					$headers = substr($res, 0, $header_size);
					$res = substr($res, $header_size);
                    $convRes = json_decode($res);
					if($http_code == 403){
						$sqlUpdate_task = Yii::$app->db->createCommand("UPDATE conversations SET isRead = '1' WHERE id ='" . $threadData['id'] . "'")->execute();   
					}
					if($http_code == 200){
						$cArr = json_decode($res);			
						$d = $cArr->data->paging->total;
						$data = (array)$cArr->data;
						$e = (isset($data['*elements']))?$data['*elements']:array();
						
						$includeddata= $cArr->included;
						$merged = array();
						$entityUrn_Arr = array_column($includeddata, 'entityUrn');
						for($i2=0; $i2<count($e); $i2++) {
							$eukey = array_search($e[$i2],$entityUrn_Arr);
							if($eukey !==""){
								$temp = (object) array_merge((array)$e[$i2], (array)$includeddata[$eukey]);
								array_push($merged, $temp);
							}
						}
						$merge2=array();
						if(!empty($merged)){ 
							$e = $merged;
							for($i2=0; $i2<count($e); $i2++) {
								$mn=(array)$e[$i2];
								$primaryActionResolutionResult=(isset($mn['profileStatefulProfileActions']) && !empty($mn['profileStatefulProfileActions']))?(array)$mn['profileStatefulProfileActions']->primaryActionResolutionResult:'';
								$composeOption=(!empty($primaryActionResolutionResult))?$primaryActionResolutionResult['*composeOption']:"";
								if(!empty($composeOption)){
									$eukey = array_search($composeOption,$entityUrn_Arr);
									if($eukey !==""){
										$temp = (object) array_merge((array)$e[$i2], (array)$includeddata[$eukey]);
										array_push($merge2, $temp);
									}
								}
							}
						}
						$threadId="";
						if(!empty($merge2)){
							$threadId=(isset($merge2[0]->composeNavigationContext->existingConversationUrn))?end(explode(':',$merge2[0]->composeNavigationContext->existingConversationUrn)):""; 
                            $payload = "{\"patch\":{\"\$set\":{\"read\":" . $readStatus . "}}}";
                            $curlMessage = curl_init();
                            curl_setopt_array($curlMessage, array(
                                CURLOPT_URL => "https://www.linkedin.com/voyager/api/messaging/conversations/" . $threadId,
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => "",
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 30,
                                CURLOPT_HEADER => true,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_HTTPPROXYTUNNEL => 1,
                                CURLOPT_PROXY => "$proxyIp",
                                CURLOPT_PROXYPORT => "$proxyPort",
                                CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                                CURLOPT_CUSTOMREQUEST => "POST",
                                CURLOPT_POSTFIELDS => $payload,
                                CURLOPT_HTTPHEADER => array(
                                    "cookie: $cookie",
                                    "csrf-token: $csrf",
                                    "authority:www.linkedin.com",
                                    "scheme:https",
                                    "Accept: application/vnd.linkedin.normalized+json+2.1",
                                    "Accept-Language: en-US,en;q=0.5",
                                    "Accept-Encoding: gzip, deflate, br",
                                    "Content-Length: " . strlen($payload),
                                    "Content-Type: application/json; charset=UTF-8",
                                    "x-li-lang: en_US",
                                    "user-agent: $userAgent",
                                    "origin: https://www.linkedin.com",
                                    "referer: https://www.linkedin.com/messaging/thread/" . $threadId,
                                    "x-restli-protocol-version: 2.0.0",
                                    "x-li-lang: en_US"
                                )
                            ));
                            $resMessage = curl_exec($curlMessage);
                            $header_size = curl_getinfo($curlMessage, CURLINFO_HEADER_SIZE);
                            $headers = substr($resMessage, 0, $header_size);
                            $resMessage = substr($resMessage, $header_size);
                            $http_code = curl_getinfo($curlMessage, CURLINFO_HTTP_CODE);
							
                            if ($http_code == 200) {
                               $sqlUpdate_task = Yii::$app->db->createCommand("UPDATE conversations SET isRead = '1',threadId='" . str_replace('=', '%3d', $threadId) . "' WHERE id ='" . $threadData['id'] . "'")->execute();  
                            } else {
                                return false;
                            }
						}else {
							return false;
						}
					}else {
						return false;
					}
                } else {
                    return false;
                }
            }
        }
	}
	public function replacecontent($msgText = "", $personInfo = "") {
        $personData = json_decode($personInfo, true);

        if (isset($personData['firstName']) && $personData['firstName'] != "") {
            //$firstName = preg_replace($newR, "", $personData['firstName']);
            //$firstName = preg_replace($emojis, "", $personData['firstName']);
            $firstName = $personData['firstName'];
            if (preg_match("/\{\s*first\s*name\s*\|\s*(.*?)\}/", $msgText)) {
                $msgText = preg_replace('/\{\s*first\s*name\s*\|\s*(.*?)\}/', $firstName, $msgText);
            }
        } else {
            preg_match('/\{\s*first\s*name\s*\|\s*(.*?)\}/', $msgText, $matches);
            if (!empty($matches)) {
                $firstNameText = explode("|", $matches[0])[1];
                $firstNameText = str_replace('fallback:"', "", $firstNameText);
                $firstNameText = trim(str_replace('"}', "", $firstNameText));
                if (preg_match("/\{\s*first\s*name\s*\|\s*(.*?)\}/", $msgText)) {
                    $msgText = preg_replace('/\{\s*first\s*name\s*\|\s*(.*?)\}/', $firstNameText, $msgText);
                }
            }
        }
        if (isset($personData['lastName']) && $personData['lastName'] != "") {
            //$lastName = preg_replace($newR, "", $personData['lastName']);
            //$lastName = preg_replace($emojis, "", $personData['lastName']);
            $lastName = $personData['lastName'];
            if (preg_match("/\{\s*last\s*name\s*\|\s*(.*?)\}/", $msgText)) {
                $msgText = preg_replace('/\{\s*last\s*name\s*\|\s*(.*?)\}/', $lastName, $msgText);
            }
        } else {
            preg_match('/\{\s*last\s*name\s*\|\s*(.*?)\}/', $msgText, $matches);
            if (!empty($matches)) {
                $lastNameText = explode("|", $matches[0])[1];
                $lastNameText = str_replace('fallback:"', "", $lastNameText);
                $lastNameText = trim(str_replace('"}', "", $lastNameText));

                if (preg_match("/\{\s*last\s*name\s*\|\s*(.*?)\}/", $msgText)) {
                    $msgText = preg_replace('/\{\s*last\s*name\s*\|\s*(.*?)\}/', $lastNameText, $msgText);
                }
            }
        }
        if (isset($personData['fullName']) && $personData['fullName'] != "") {
            //$fullName = preg_replace($newR, "", $personData['fullName']);
            //$fullName = preg_replace($emojis, "", $personData['fullName']);
            $fullName = $personData['fullName'];
            if (preg_match("/\{\s*full\s*name\s*\|\s*(.*?)\}/", $msgText)) {
                $msgText = preg_replace('/\{\s*full\s*name\s*\|\s*(.*?)\}/', $fullName, $msgText);
            }
        } else {
            preg_match('/\{\s*full\s*name\s*\|\s*(.*?)\}/', $msgText, $matches);
            if (!empty($matches)) {
                $fullNameText = explode("|", $matches[0])[1];
                $fullNameText = str_replace('fallback:"', "", $fullNameText);
                $fullNameText = trim(str_replace('"}', "", $fullNameText));

                if (preg_match("/\{\s*full\s*name\s*\|\s*(.*?)\}/", $msgText)) {
                    $msgText = preg_replace('/\{\s*full\s*name\s*\|\s*(.*?)\}/', $fullNameText, $msgText);
                }
            }
        }
        if (isset($personData['industries']) && !empty($personData['industries'])) {

            for ($i = 0; $i < count($personData['industries']); $i++) {
                if ($i == 0 && !empty($personData['industries'][$i])) {
                    $personData['industries'][$i];
                    if (preg_match("/\{\s*indu\s*stries\s*\|\s*(.*?)\}/", $msgText)) {
                        $msgText = preg_replace('/\{\s*indu\s*stries\s*\|\s*(.*?)\}/', $personData['industries'][$i], $msgText);
                    }
                }
            }
        } else {
            preg_match('/\{\s*indu\s*stries\s*\|\s*(.*?)\}/', $msgText, $matches);
            if (!empty($matches)) {
                $industriesText = explode("|", $matches[0])[1];
                $industriesText = str_replace('fallback:"', "", $industriesText);
                $industriesText = trim(str_replace('"}', "", $industriesText));
                if (preg_match("/\{\s*indu\s*stries\s*\|\s*(.*?)\}/", $msgText)) {
                    $msgText = preg_replace('/\{\s*indu\s*stries\s*\|\s*(.*?)\}/', $industriesText, $msgText);
                }
            }
        }
        if (isset($personData['locationName']) && $personData['locationName'] != "") {
            if (preg_match("/\{\s*loca\s*tion\s*\|\s*(.*?)\}/", $msgText)) {
                $msgText = preg_replace('/\{\s*loca\s*tion\s*\|\s*(.*?)\}/', $personData['locationName'], $msgText);
            }
        } else {
            preg_match('/\{\s*loca\s*tion\s*\|\s*(.*?)\}/', $msgText, $matches);
            if (!empty($matches)) {
                $locationNameText = explode("|", $matches[0])[1];
                $locationNameText = str_replace('fallback:"', "", $locationNameText);
                $locationNameText = trim(str_replace('"}', "", $locationNameText));
                if (preg_match("/\{\s*loca\s*tion\s*\|\s*(.*?)\}/", $msgText)) {
                    $msgText = preg_replace('/\{\s*loca\s*tion\s*\|\s*(.*?)\}/', $locationNameText, $msgText);
                }
            }
        }
        if (isset($personData['experiences']) && !empty($personData['experiences'])) {
            for ($i = 0; $i < count($personData['experiences']); $i++) {
                if (!empty($personData['experiences'][$i]) && $i == 0) {
                    $personData['experiences'][$i]['company'];
                    if (preg_match("/{\s*company\s*(\d+)\s*\|\s*(.*?)}/", $msgText)) {
                        $msgText = preg_replace('/{\s*company\s*(\d+)\s*\|\s*(.*?)}/', $personData['experiences'][$i]['company'], $msgText);
                    }
                }
            }
        } else {
            preg_match('/{\s*company\s*(\d+)\s*\|\s*(.*?)}/', $msgText, $matches);
            if (!empty($matches)) {
                $companyText = explode("|", $matches[0])[1];
                $companyText = str_replace('fallback:"', "", $companyText);
                $companyText = trim(str_replace('"}', "", $companyText));
                if (preg_match("/{\s*company\s*(\d+)\s*\|\s*(.*?)}/", $msgText)) {
                    $msgText = preg_replace('/{\s*company\s*(\d+)\s*\|\s*(.*?)}/', $companyText, $msgText);
                }
            }
        }
        /* if (isset($personData['educations']) && !empty($personData['educations'])) {
          for ($i = 0; $i < count($personData['educations']); $i++) {
          if (!empty($personData['educations'][$i]) && $i == 0) {
          if (preg_match("/{\s*edu(?:cation)?\s*(\d+)\s*\|\s*(.*?)}/", $msgText)) {
          $msgText = preg_replace('/{\s*edu(?:cation)?\s*(\d+)\s*\|\s*(.*?)}/', $personData['educations'][$i]['degree_institution'], $msgText);
          }
          }
          }
          } else {
          preg_match('/{\s*edu(?:cation)?\s*(\d+)\s*\|\s*(.*?)}/', $msgText, $matches);
          if (!empty($matches)) {
          $educationsText = explode("|", $matches[0])[1];
          $educationsText = str_replace('fallback:"', "", $educationsText);
          $educationsText = trim(str_replace('"}', "", $educationsText));
          if (preg_match("/{\s*edu(?:cation)?\s*(\d+)\s*\|\s*(.*?)}/", $msgText)) {
          $msgText = preg_replace('/{\s*edu(?:cation)?\s*(\d+)\s*\|\s*(.*?)}/', $educationsText, $msgText);
          }
          }
          } */
        return $msgText;
    }

    public function actionChangetemplatecontent() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $threadId = Yii::$app->request->post('threadId');
        $personId = Yii::$app->request->post('personId');
        $userId = Yii::$app->session->get('userid');
        $id = Yii::$app->request->post('id');

        $queryTamplates = new Query();
        $queryTamplates->select('template')
                ->where(['templateid' => $id])
                ->from('templates');
        $tamplates = $queryTamplates->one();
        $msg = $tamplates['template'];

        $queryBlckLst = new Query();
        $queryBlckLst->select('person')->from('completed_tasks')->where(['personId' => $personId, 'userId' => $userId]);
        $threadPerson = $queryBlckLst->one();

        $queryBlackList = new Query();
        $queryBlackList->select('profileinfo.*, companyinfo.company_detail')->from('blacklist')->where(['blacklist.linkedinpublicid' => $personId, 'blacklist.userid' => $userId])
                ->innerJoin('profileinfo', 'profileinfo.id = blacklist.profileInfo_id')
                ->innerJoin('companyinfo', 'companyinfo.id = blacklist.companyInfo_id');
        $threadPrsn = $queryBlackList->one();

        if (empty($threadPrsn)) {
            $queryFirstDegree = new Query();
            $queryFirstDegree->select('locationName, occupation , companyDetail')
                    ->from('1stdegreedata')
                    ->where(['1stdegreedata.linkedinpublicid' => $personId, '1stdegreedata.userId' => Yii::$app->session->get('userid')]);
            $threadPrsn = $queryFirstDegree->one();

            (!empty($threadPrsn['locationName'])) ? $location = $threadPrsn['locationName'] : $location = '';
            (!empty($threadPrsn['occupation'])) ? $occupation = $threadPrsn['occupation'] : $occupation = '';
            (!empty(json_decode(str_replace('""', '"', $threadPrsn['companyDetail']))->companyName)) ? $companyName = json_decode(str_replace('""', '"', $threadPrsn['companyDetail']))->companyName : $companyName = '';
            $industryName = '';
        } else {
            (!empty(json_decode($threadPrsn['basicInfo'])->locationName)) ? $location = json_decode($threadPrsn['basicInfo'])->locationName : $location = '';
            (!empty(json_decode($threadPrsn['basicInfo'])->occupation)) ? $occupation = json_decode($threadPrsn['basicInfo'])->occupation : $occupation = '';
            (!empty(json_decode($threadPrsn['basicInfo'])->industryName)) ? $industryName = json_decode($threadPrsn['basicInfo'])->industryName : $industryName = '';
            (!empty(json_decode(str_replace('"]', '', str_replace('["', '', $threadPrsn['company_detail'])))->companyName)) ? $companyName = json_decode(str_replace('"]', '', str_replace('["', '', $threadPrsn['company_detail'])))->companyName : $companyName = '';
        }

        (!empty($companyName)) ? $cmpnArr = array(array('company' => $companyName)) : $cmpnArr = array();
        (!empty($industryName)) ? $indstrArr = array($industryName) : $indstrArr = array();
        if (!empty($threadPerson)) {
            $prsn = json_decode(mb_convert_encoding(preg_replace('/\"description\"\:\".*?\"\,/s', '"description":"empty",', $threadPerson['person']), 'UTF-8', 'UTF-8'), true);
        } else {
            $prsn = array();
        }
        $prsn['locationName'] = $location;
        $prsn['experiences'] = $cmpnArr;
        $prsn['industries'] = $indstrArr;
        $msg = $this->replacecontent($msg, json_encode($prsn));

        $response = array('message' => $this->mb_html_entity_decode($msg));
        echo json_encode($response);
    }

    public function actionSendmessage() {
        include('../web/config.php');
        include('../web/updateLinkedInCookie.php');

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $threadId = Yii::$app->request->post('threadId');
        $personId = Yii::$app->request->post('personId');
        $userId = Yii::$app->session->get('userid');
        $msg = Yii::$app->request->post('message');

        $queryBlckLst = new Query();
        $queryBlckLst->select('person')->from('completed_tasks')->where(['personId' => $personId, 'userId' => $userId]);
        $threadPerson = $queryBlckLst->one();
        $person = json_decode(mb_convert_encoding(preg_replace('/\"description\"\:\".*?\"\,/s', '"description":"empty",', $threadPerson['person']), 'UTF-8', 'UTF-8'));
		$longId= $person->longId;
		if(empty($longId)){
			$re = '/longId":"(.*?)"/m';
			preg_match_all($re, $threadPerson['person'], $matches, PREG_SET_ORDER, 0); 
			if(isset($matches[0][1]) && !empty($matches[0][1])){
				$longId=$matches[0][1];
			}  
		} 
        /* if(Yii::$app->session->get('userid') != 14883){
          $queryBlackList = new Query();
          $queryBlackList->select('profileinfo.*, companyinfo.company_detail')->from('blacklist')->where(['blacklist.linkedinpublicid' => $personId, 'blacklist.userid' => Yii::$app->session->get('userid')])
          ->innerJoin('profileinfo','profileinfo.id = blacklist.profileInfo_id')
          ->innerJoin('companyinfo','companyinfo.id = blacklist.companyInfo_id');
          $threadPrsn = $queryBlackList->one();

          if(empty($threadPrsn)){
          $queryFirstDegree = new Query();
          $queryFirstDegree->select('locationName, occupation , companyDetail')
          ->from('1stdegreedata')
          ->where(['1stdegreedata.linkedinpublicid' => $personId, '1stdegreedata.userId' => Yii::$app->session->get('userid')]);
          $threadPrsn = $queryFirstDegree->one();

          (!empty($threadPrsn['locationName']))?$location = $threadPrsn['locationName']:$location='';
          (!empty($threadPrsn['occupation']))?$occupation = $threadPrsn['occupation']:$occupation='';
          (!empty(json_decode(str_replace('""','"',$threadPrsn['companyDetail']))->companyName))?$companyName = json_decode(str_replace('""','"',$threadPrsn['companyDetail']))->companyName:$companyName='';
          $industryName='';
          }else{
          (!empty(json_decode($threadPrsn['basicInfo'])->locationName))?$location = json_decode($threadPrsn['basicInfo'])->locationName:$location='';
          (!empty(json_decode($threadPrsn['basicInfo'])->occupation))?$occupation = json_decode($threadPrsn['basicInfo'])->occupation:$occupation='';
          (!empty(json_decode($threadPrsn['basicInfo'])->industryName))?$industryName = json_decode($threadPrsn['basicInfo'])->industryName:$industryName='';
          (!empty(json_decode(str_replace('"]', '', str_replace('["','',$threadPrsn['company_detail'])))->companyName))?$companyName = json_decode(str_replace('"]', '', str_replace('["','',$threadPrsn['company_detail'])))->companyName:$companyName='';
          }

          (!empty($companyName))?$cmpnArr = array(array('company' => $companyName)):$cmpnArr = array();
          (!empty($industryName))?$indstrArr = array(array('industries' => $industryName)):$indstrArr = array();
          $prsn = json_decode(mb_convert_encoding(preg_replace('/\"description\"\:\".*?\"\,/s', '"description":"empty",',$threadPerson['person']), 'UTF-8', 'UTF-8'), true);
          $prsn['locationName'] = $location;
          $prsn['experiences'] = $cmpnArr;
          $prsn['industries'] = $indstrArr;
          $msg = $this->replacecontent($msg, json_encode($prsn));
          } */
        $queryUsr = new Query();
        $queryUsr->select('proxyIp, proxyPort, proxyUsername, proxyPassword, cookie, csrf ,userAgent')->from('user')->where(['id' => $userId]);
        $usrData = $queryUsr->one();
        $csrf = $usrData['csrf'];
        $cookie = $usrData['cookie'];
        $proxyIp = $usrData['proxyIp'];
        $proxyPort = $usrData['proxyPort'];
        $proxyUsername = $usrData['proxyUsername'];
        $proxyPassword = $usrData['proxyPassword'];
        $userAgent = $usrData['userAgent'];
        $curlMessage = curl_init();
        curl_setopt_array($curlMessage, array(
            CURLOPT_URL => "https://www.linkedin.com/voyager/api/messaging/conversations?action=create",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HEADER => true,
            /* CURLOPT_VERBOSE=>true, */
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPPROXYTUNNEL => 1,
            CURLOPT_PROXY => "$proxyIp",
            CURLOPT_PROXYPORT => "$proxyPort",
            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => "{\"conversationCreate\":{\"eventCreate\":{\"value\":{\"com.linkedin.voyager.messaging.create.MessageCreate\":{\"body\":" . json_encode($msg) . ",\"attachments\":[]}}},\"recipients\":[\"" . $longId . "\"],\"subtype\":\"MEMBER_TO_MEMBER\"},\"keyVersion\":\"LEGACY_INBOX\"}",
            CURLOPT_HTTPHEADER => array(
                "cookie: $cookie",
                "csrf-token: $csrf",
                "Accept-Language: en-US,en;q=0.5",
                "Accept-Encoding: gzip, deflate, br",
                "x-li-lang: en_US",
                "User-Agent: $userAgent",
                "Accept-Language: en-US,en;q=0.5",
                "Accept-Encoding: gzip, deflate, br",
                "content-type: application/x-www-form-urlencoded",
                "x-li-lang: en_US",
                "x-restli-protocol-version: 2.0.0",
                "Origin: https://www.linkedin.com",
                "TE: Trailers"
            )
        ));
        $resMessage = curl_exec($curlMessage);
        $header_size = curl_getinfo($curlMessage, CURLINFO_HEADER_SIZE);
        $headers = substr($resMessage, 0, $header_size);
        $resMessage = substr($resMessage, $header_size);
        $newCookie = getCookiesLdnFromHeaders($headers);
        if (!empty($newCookie)) {
            updateUserLdnCookies($userId, $newCookie);
        }
        $http_code = curl_getinfo($curlMessage, CURLINFO_HTTP_CODE);

        if ($http_code == 201) {
            $thread = array(array("msg" => nl2br($this->mb_htmlentities($this->convert_emoji($msg))), "type" => "S", "createdAt" => json_decode($resMessage)->value->createdAt));
            $msgCnt = count($thread);
            $threadDetails = mysqli_real_escape_string($con, json_encode($thread));
            $getConversationQry = mysqli_query($con, "SELECT thread from conversations where threadId='" . $threadId . "' and userId = '" . $userId . "'");
            if (mysqli_num_rows($getConversationQry) > 0) {
                if ($msgCnt == 20) {
                    $conversationInsert = mysqli_query($con, "UPDATE conversations SET thread = '" . $threadDetails . "' WHERE threadId = '" . $threadId . "' AND userId = '" . $userId . "'");
                } else {
                    $conversationRes = mysqli_fetch_assoc($getConversationQry);
                    //$dbConvrstn = json_decode(mb_convert_encoding($conversationRes['thread'], 'UTF-8', 'UTF-8'));
                    $dbConvrstn = json_decode(mb_convert_encoding($conversationRes['thread'], 'HTML-ENTITIES', 'HTML-ENTITIES'));
                    $i = 0;
                    foreach ($dbConvrstn as $tmp) {
                        $dbConvrstn[$i]->msg = htmlspecialchars($tmp->msg);
                        $i++;
                    }
                    $dbConvrstnCnt = count($dbConvrstn);

                    $allEle = 20 - $msgCnt;
                    $rmEle = $dbConvrstnCnt - $allEle;
                    if ($rmEle > 0) {
                        $tmpArr = array_slice($dbConvrstn, $rmEle);
                    } else {
                        $tmpArr = array_slice($dbConvrstn, 0);
                    }
                    foreach ($thread as $arr) {
                        array_push($tmpArr, $arr);
                    }
                    $threadDetails = mysqli_real_escape_string($con, json_encode($tmpArr));
                    $conversationInsert = mysqli_query($con, "UPDATE conversations SET thread = '" . $threadDetails . "' WHERE threadId = '" . $threadId . "' AND userId = '" . $userId . "'");
                }
            } else {
                $conversationInsert = mysqli_query($con, "INSERT INTO conversations (threadId,thread,userId) values('" . $threadId . "','" . $threadDetails . "','" . $userId . "')");
            }
            echo 'Message sent';
        } else {
            return false;
        }

//        if (curl_errno($curlMessage)) {
//            $error_msg = curl_error($curlMessage);
//            echo 'Error: ' . $error_msg;
//        } else {
//            $thread = array(array("msg" => nl2br($this->mb_htmlentities($this->convert_emoji($msg))), "type" => "S", "createdAt" => json_decode($resMessage)->value->createdAt));
//            $msgCnt = count($thread);
//            $threadDetails = mysqli_real_escape_string($con, json_encode($thread));
//            $getConversationQry = mysqli_query($con, "SELECT thread from conversations where threadId='" . $threadId . "' and userId = '" . $userId . "'");
//            if (mysqli_num_rows($getConversationQry) > 0) {
//                if ($msgCnt == 20) {
//                    $conversationInsert = mysqli_query($con, "UPDATE conversations SET thread = '" . $threadDetails . "' WHERE threadId = '" . $threadId . "' AND userId = '" . $userId . "'");
//                } else {
//                    $conversationRes = mysqli_fetch_assoc($getConversationQry);
//                    //$dbConvrstn = json_decode(mb_convert_encoding($conversationRes['thread'], 'UTF-8', 'UTF-8'));
//                    $dbConvrstn = json_decode(mb_convert_encoding($conversationRes['thread'], 'HTML-ENTITIES', 'HTML-ENTITIES'));
//                    $i = 0;
//                    foreach ($dbConvrstn as $tmp) {
//                        $dbConvrstn[$i]->msg = htmlspecialchars($tmp->msg);
//                        $i++;
//                    }
//                    $dbConvrstnCnt = count($dbConvrstn);
//
//                    $allEle = 20 - $msgCnt;
//                    $rmEle = $dbConvrstnCnt - $allEle;
//                    if ($rmEle > 0) {
//                        $tmpArr = array_slice($dbConvrstn, $rmEle);
//                    } else {
//                        $tmpArr = array_slice($dbConvrstn, 0);
//                    }
//                    foreach ($thread as $arr) {
//                        array_push($tmpArr, $arr);
//                    }
//                    $threadDetails = mysqli_real_escape_string($con, json_encode($tmpArr));
//                    $conversationInsert = mysqli_query($con, "UPDATE conversations SET thread = '" . $threadDetails . "' WHERE threadId = '" . $threadId . "' AND userId = '" . $userId . "'");
//                }
//            } else {
//                $conversationInsert = mysqli_query($con, "INSERT INTO conversations (threadId,thread,userId) values('" . $threadId . "','" . $threadDetails . "','" . $userId . "')");
//            }
//            echo 'Message sent';
//        }
    }

    public function mb_ord($char, $encoding = 'UTF-8') {
        if ($encoding === 'UCS-4BE') {
            list(, $ord) = (strlen($char) === 4) ? @unpack('N', $char) : @unpack('n', $char);
            return $ord;
        } else {
            return $this->mb_ord(mb_convert_encoding($char, 'UCS-4BE', $encoding), 'UCS-4BE');
        }
    }

    public function mb_htmlentities($string, $hex = true, $encoding = 'UTF-8') {
        return preg_replace_callback('/[\x{80}-\x{10FFFF}]/u', function ($match) use ($hex) {
            return sprintf($hex ? '&#x%X;' : '&#%d;', $this->mb_ord($match[0]));
        }, $string);
    }

    public function mb_html_entity_decode($string, $flags = null, $encoding = 'UTF-8') {
        return html_entity_decode($string, ($flags === NULL) ? ENT_COMPAT | ENT_HTML401 : $flags, $encoding);
    }

    public function convert_emoji($str) {
        return preg_replace_callback("/[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0077}\x{E006C}\x{E0073}\x{E007F})|[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0073}\x{E0063}\x{E0074}\x{E007F})|[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0065}\x{E006E}\x{E0067}\x{E007F})|[\x{1F3F4}](?:\x{200D}\x{2620}\x{FE0F})|[\x{1F3F3}](?:\x{FE0F}\x{200D}\x{1F308})|[\x{0023}\x{002A}\x{0030}\x{0031}\x{0032}\x{0033}\x{0034}\x{0035}\x{0036}\x{0037}\x{0038}\x{0039}](?:\x{FE0F}\x{20E3})|[\x{1F441}](?:\x{FE0F}\x{200D}\x{1F5E8}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F466})|[\x{1F469}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F469})|[\x{1F469}\x{1F468}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F468})|[\x{1F469}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F48B}\x{200D}\x{1F469})|[\x{1F469}\x{1F468}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F48B}\x{200D}\x{1F468})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B0})|[\x{1F575}\x{1F3CC}\x{26F9}\x{1F3CB}](?:\x{FE0F}\x{200D}\x{2640}\x{FE0F})|[\x{1F575}\x{1F3CC}\x{26F9}\x{1F3CB}](?:\x{FE0F}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FF}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FE}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FD}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FC}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FB}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F9B8}\x{1F9B9}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F9DE}\x{1F9DF}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F46F}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93C}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FF}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FE}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FD}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FC}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FB}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F9B8}\x{1F9B9}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F9DE}\x{1F9DF}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F46F}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93C}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{200D}\x{2642}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2695}\x{FE0F})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FF})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FE})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FD})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FC})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FB})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F8}\x{1F1F9}\x{1F1FA}](?:\x{1F1FF})|[\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F0}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1FA}](?:\x{1F1FE})|[\x{1F1E6}\x{1F1E8}\x{1F1F2}\x{1F1F8}](?:\x{1F1FD})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F7}\x{1F1F9}\x{1F1FF}](?:\x{1F1FC})|[\x{1F1E7}\x{1F1E8}\x{1F1F1}\x{1F1F2}\x{1F1F8}\x{1F1F9}](?:\x{1F1FB})|[\x{1F1E6}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1ED}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F7}\x{1F1FB}](?:\x{1F1FA})|[\x{1F1E6}\x{1F1E7}\x{1F1EA}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FE}](?:\x{1F1F9})|[\x{1F1E6}\x{1F1E7}\x{1F1EA}\x{1F1EC}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F7}\x{1F1F8}\x{1F1FA}\x{1F1FC}](?:\x{1F1F8})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EB}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F0}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1F7})|[\x{1F1E6}\x{1F1E7}\x{1F1EC}\x{1F1EE}\x{1F1F2}](?:\x{1F1F6})|[\x{1F1E8}\x{1F1EC}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F3}](?:\x{1F1F5})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1EE}\x{1F1EF}\x{1F1F2}\x{1F1F3}\x{1F1F7}\x{1F1F8}\x{1F1F9}](?:\x{1F1F4})|[\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}](?:\x{1F1F3})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F4}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FF}](?:\x{1F1F2})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1EE}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1F1})|[\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1ED}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FD}](?:\x{1F1F0})|[\x{1F1E7}\x{1F1E9}\x{1F1EB}\x{1F1F8}\x{1F1F9}](?:\x{1F1EF})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EB}\x{1F1EC}\x{1F1F0}\x{1F1F1}\x{1F1F3}\x{1F1F8}\x{1F1FB}](?:\x{1F1EE})|[\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1ED})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EA}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}](?:\x{1F1EC})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F9}\x{1F1FC}](?:\x{1F1EB})|[\x{1F1E6}\x{1F1E7}\x{1F1E9}\x{1F1EA}\x{1F1EC}\x{1F1EE}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F7}\x{1F1F8}\x{1F1FB}\x{1F1FE}](?:\x{1F1EA})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1EE}\x{1F1F2}\x{1F1F8}\x{1F1F9}](?:\x{1F1E9})|[\x{1F1E6}\x{1F1E8}\x{1F1EA}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F8}\x{1F1F9}\x{1F1FB}](?:\x{1F1E8})|[\x{1F1E7}\x{1F1EC}\x{1F1F1}\x{1F1F8}](?:\x{1F1E7})|[\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F6}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}\x{1F1FF}](?:\x{1F1E6})|[\x{00A9}\x{00AE}\x{203C}\x{2049}\x{2122}\x{2139}\x{2194}-\x{2199}\x{21A9}-\x{21AA}\x{231A}-\x{231B}\x{2328}\x{23CF}\x{23E9}-\x{23F3}\x{23F8}-\x{23FA}\x{24C2}\x{25AA}-\x{25AB}\x{25B6}\x{25C0}\x{25FB}-\x{25FE}\x{2600}-\x{2604}\x{260E}\x{2611}\x{2614}-\x{2615}\x{2618}\x{261D}\x{2620}\x{2622}-\x{2623}\x{2626}\x{262A}\x{262E}-\x{262F}\x{2638}-\x{263A}\x{2640}\x{2642}\x{2648}-\x{2653}\x{2660}\x{2663}\x{2665}-\x{2666}\x{2668}\x{267B}\x{267E}-\x{267F}\x{2692}-\x{2697}\x{2699}\x{269B}-\x{269C}\x{26A0}-\x{26A1}\x{26AA}-\x{26AB}\x{26B0}-\x{26B1}\x{26BD}-\x{26BE}\x{26C4}-\x{26C5}\x{26C8}\x{26CE}-\x{26CF}\x{26D1}\x{26D3}-\x{26D4}\x{26E9}-\x{26EA}\x{26F0}-\x{26F5}\x{26F7}-\x{26FA}\x{26FD}\x{2702}\x{2705}\x{2708}-\x{270D}\x{270F}\x{2712}\x{2714}\x{2716}\x{271D}\x{2721}\x{2728}\x{2733}-\x{2734}\x{2744}\x{2747}\x{274C}\x{274E}\x{2753}-\x{2755}\x{2757}\x{2763}-\x{2764}\x{2795}-\x{2797}\x{27A1}\x{27B0}\x{27BF}\x{2934}-\x{2935}\x{2B05}-\x{2B07}\x{2B1B}-\x{2B1C}\x{2B50}\x{2B55}\x{3030}\x{303D}\x{3297}\x{3299}\x{1F004}\x{1F0CF}\x{1F170}-\x{1F171}\x{1F17E}-\x{1F17F}\x{1F18E}\x{1F191}-\x{1F19A}\x{1F201}-\x{1F202}\x{1F21A}\x{1F22F}\x{1F232}-\x{1F23A}\x{1F250}-\x{1F251}\x{1F300}-\x{1F321}\x{1F324}-\x{1F393}\x{1F396}-\x{1F397}\x{1F399}-\x{1F39B}\x{1F39E}-\x{1F3F0}\x{1F3F3}-\x{1F3F5}\x{1F3F7}-\x{1F3FA}\x{1F400}-\x{1F4FD}\x{1F4FF}-\x{1F53D}\x{1F549}-\x{1F54E}\x{1F550}-\x{1F567}\x{1F56F}-\x{1F570}\x{1F573}-\x{1F57A}\x{1F587}\x{1F58A}-\x{1F58D}\x{1F590}\x{1F595}-\x{1F596}\x{1F5A4}-\x{1F5A5}\x{1F5A8}\x{1F5B1}-\x{1F5B2}\x{1F5BC}\x{1F5C2}-\x{1F5C4}\x{1F5D1}-\x{1F5D3}\x{1F5DC}-\x{1F5DE}\x{1F5E1}\x{1F5E3}\x{1F5E8}\x{1F5EF}\x{1F5F3}\x{1F5FA}-\x{1F64F}\x{1F680}-\x{1F6C5}\x{1F6CB}-\x{1F6D2}\x{1F6E0}-\x{1F6E5}\x{1F6E9}\x{1F6EB}-\x{1F6EC}\x{1F6F0}\x{1F6F3}-\x{1F6F9}\x{1F910}-\x{1F93A}\x{1F93C}-\x{1F93E}\x{1F940}-\x{1F945}\x{1F947}-\x{1F970}\x{1F973}-\x{1F976}\x{1F97A}\x{1F97C}-\x{1F9A2}\x{1F9B0}-\x{1F9B9}\x{1F9C0}-\x{1F9C2}\x{1F9D0}-\x{1F9FF}]/u", function ($matches) {
            return '&#' . hexdec(bin2hex(mb_convert_encoding("$matches[0]", 'UTF-32', 'UTF-8'))) . ';';
        }, $str);
    }

    public function actionSetnote() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        include('../web/config.php');
        $currentTimestamp = round(microtime(true) * 1000);
        $threadId = Yii::$app->request->post('threadId');
        $personId = Yii::$app->request->post('personId');
        $note = addslashes(Yii::$app->request->post('note'));
        $userId = Yii::$app->session->get('userid');

        if (mysqli_query($con, "INSERT INTO notes (personId, threadId, note, userId, created) values('" . $personId . "','" . $threadId . "','" . $note . "','" . $userId . "','" . $currentTimestamp . "')")) {
            return true;
        } else {
            return false;
        }
    }

    public function actionSettag() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        include('../web/config.php');
        $personId = Yii::$app->request->post('personId');
        $tag = addslashes(Yii::$app->request->post('tag'));
        $userId = Yii::$app->session->get('userid');

        // Check if tag already by user

        $chktagavaibility = Yii::$app->db->createCommand("SELECT id FROM tags WHERE userId ='" . $userId . "' AND tagName = '" . $tag . "'")->queryAll();
        $totchkcount = count($chktagavaibility);
        // End check
        if ($totchkcount < 1) {
            if (mysqli_query($con, "INSERT INTO tags (tagName, userId) values('" . $tag . "','" . $userId . "')")) {
                $tagId = mysqli_insert_id($con);
                $queryBlckLst = new Query();
                $res = $queryBlckLst->select('id, tags')->from('blacklist')->where(['linkedinpublicid' => $personId, 'userid' => $userId])->one();
                if (!empty($res)) {
                    if (!empty($res['tags'])) {
                        $tags = $res['tags'] . ',' . $tagId;
                    } else {
                        $tags = $tagId;
                    }
                    mysqli_query($con, "UPDATE blacklist SET tags = '" . $tags . "' WHERE id =" . $res['id']);
                } else {
                    $queryFirstDegree = new Query();
                    $res = $queryFirstDegree->select('id, tags')->from('1stdegreedata')->where(['linkedinpublicid' => $personId, 'userid' => $userId])->one();
                    if (!empty($res)) {
                        if (!empty($res['tags'])) {
                            $tags = $res['tags'] . ',' . $tagId;
                        } else {
                            $tags = $tagId;
                        }
                        mysqli_query($con, "UPDATE 1stdegreedata SET tags = '" . $tags . "' WHERE id =" . $res['id']);
                    }
                }
                return $tagId;
            } else {
                return false;
            }
        } else {
            echo '1';
        }
    }

    public function actionAssigntag() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        include('../web/config.php');
        $personId = Yii::$app->request->post('personId');
        $tagId = Yii::$app->request->post('tag');
        $userId = Yii::$app->session->get('userid');

        $queryBlckLst = new Query();
        $res = $queryBlckLst->select('id, tags')->from('blacklist')->where(['linkedinpublicid' => $personId, 'userid' => $userId])->one();
        if (!empty($res)) {
            if (!empty($res['tags'])) {
                $tagsArr = explode(',', $res['tags']);
                if (!in_array($tagId, $tagsArr)) {
                    $tags = $res['tags'] . ',' . $tagId;
                } else {
                    return false;
                }
            } else {
                $tags = $tagId;
            }

            if (mysqli_query($con, "UPDATE blacklist SET tags = '" . $tags . "' WHERE id =" . $res['id'])) {
                return $tagId;
            } else {
                return false;
            }
        } else {
            $queryFirstDegree = new Query();
            $res = $queryFirstDegree->select('id, tags')->from('1stdegreedata')->where(['linkedinpublicid' => $personId, 'userid' => $userId])->one();
            if (!empty($res)) {
                if (!empty($res['tags'])) {
                    if (in_array($tagId, explode(',', $res['tags']))) {
                        return false;
                    }
                    $tags = $res['tags'] . ',' . $tagId;
                } else {
                    $tags = $tagId;
                }
                if (mysqli_query($con, "UPDATE 1stdegreedata SET tags = '" . $tags . "' WHERE id =" . $res['id'])) {
                    return $tagId;
                } else {
                    return false;
                }
            }
        }
    }

   public function actionArchiveprofile() {
        include('../web/config.php');
        include('../web/updateLinkedInCookie.php');

        $personId = Yii::$app->request->post('personId');
        $threadId = Yii::$app->request->post('threadId');
        $userId = Yii::$app->session->get('userid');
		
		$queryUsr = new Query();
        $queryUsr->select('proxyIp, proxyPort, proxyUsername, proxyPassword, cookie, csrf ,userAgent')->from('user')->where(['id' => $userId]);
        $usrData = $queryUsr->one();
        $csrf = $usrData['csrf'];
        $cookie = $usrData['cookie'];
        $proxyIp = $usrData['proxyIp'];
        $proxyPort = $usrData['proxyPort'];
        $proxyUsername = $usrData['proxyUsername'];
        $proxyPassword = $usrData['proxyPassword'];
        $userAgent = $usrData['userAgent'];

        $payload = "{\"patch\":{\"\$set\":{\"archived\":true}}}";
        $curlMessage = curl_init();
        curl_setopt_array($curlMessage, array(
            CURLOPT_URL => "https://www.linkedin.com/voyager/api/messaging/conversations/" . $threadId,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HEADER => true,
            /* CURLOPT_VERBOSE=>true, */
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPPROXYTUNNEL => 1,
            CURLOPT_PROXY => "$proxyIp",
            CURLOPT_PROXYPORT => "$proxyPort",
            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => array(
                "cookie: $cookie",
                "csrf-token: $csrf",
                "authority:www.linkedin.com",
                "scheme:https",
                "Accept: application/vnd.linkedin.normalized+json+2.1",
                "Accept-Language: en-US,en;q=0.5",
                "Accept-Encoding: gzip, deflate, br",
                "Content-Length: " . strlen($payload),
                "Content-Type: application/json; charset=UTF-8",
                "x-li-lang: en_US",
                "user-agent: $userAgent",
                "origin: https://www.linkedin.com",
                "referer: https://www.linkedin.com/messaging/thread/" . $threadId,
                "x-restli-protocol-version: 2.0.0",
                "x-li-lang: en_US"
            )
        ));
        $resMessage = curl_exec($curlMessage);
        $header_size = curl_getinfo($curlMessage, CURLINFO_HEADER_SIZE);
        $headers = substr($resMessage, 0, $header_size);
        $resMessage = substr($resMessage, $header_size);
        $newCookie = getCookiesLdnFromHeaders($headers);
        if (!empty($newCookie)) {
            updateUserLdnCookies($userId, $newCookie);
        }
        $err = curl_error($curlMessage);
        $http_code = curl_getinfo($curlMessage, CURLINFO_HTTP_CODE);
        if ($http_code == 204) {
            if (mysqli_query($con, "UPDATE conversations SET isArchive = '1' WHERE personId ='" . $personId . "' AND userId='" . $userId . "'")) {
                return $personId;
            }
        } else {
			$pubIdentifierQuery = new Query();
			$pubIdentifier=$pubIdentifierQuery->select('url_publicIdentifier')->from('blacklist')->where(['userid' => $userId,'linkedinpublicid' => $personId])->scalar();
			if(empty($pubIdentifier)){
				$pubIdentifier=$pubIdentifierQuery->select('url_publicIdentifier')->from('1stdegreedata')->where(['userId' => $userId,'linkedinpublicid' => $personId])->scalar();
			}
			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/dash/profiles?q=memberIdentity&memberIdentity=".$pubIdentifier."&decorationId=com.linkedin.voyager.dash.deco.identity.profile.TopCardSecondaryData-35", 
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 30,
				CURLOPT_HEADER => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_HTTPPROXYTUNNEL => 1,
				CURLOPT_PROXY => "$proxyIp",
				CURLOPT_PROXYPORT => "$proxyPort",
				CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
				CURLOPT_CUSTOMREQUEST => "GET",
				CURLOPT_HTTPHEADER => array(
					"cookie: $cookie",
					"csrf-token: $csrf",
					"authority: www.linkedin.com",
					"User-Agent: $userAgent",
					"accept: application/vnd.linkedin.normalized+json+2.1",
					"Accept-Language: en-US,en;q=0.5",
					"Accept-Encoding: gzip, deflate, br",
					"x-li-lang: en_US",
					"x-restli-protocol-version: 2.0.0"
				)
			));
			$res = curl_exec($curl);
            if (curl_errno($curl)) {
                $error_msg = curl_error($curl);
                return false;
            } else {
                if (!empty($res)) {
					$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
					$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
					$headers = substr($res, 0, $header_size);
					$res = substr($res, $header_size);
                    $convRes = json_decode($res);
					if($http_code == 200){
						$cArr = json_decode($res);			
						$d = $cArr->data->paging->total;
						$data = (array)$cArr->data;
						$e = (isset($data['*elements']))?$data['*elements']:array();
						
						$includeddata= $cArr->included;
						$merged = array();
						$entityUrn_Arr = array_column($includeddata, 'entityUrn');
						for($i2=0; $i2<count($e); $i2++) {
							$eukey = array_search($e[$i2],$entityUrn_Arr);
							if($eukey !==""){
								$temp = (object) array_merge((array)$e[$i2], (array)$includeddata[$eukey]);
								array_push($merged, $temp);
							}
						}
						$merge2=array();
						if(!empty($merged)){ 
							$e = $merged;
							for($i2=0; $i2<count($e); $i2++) {
								$mn=(array)$e[$i2];
								$primaryActionResolutionResult=(isset($mn['profileStatefulProfileActions']) && !empty($mn['profileStatefulProfileActions']))?(array)$mn['profileStatefulProfileActions']->primaryActionResolutionResult:'';
								$composeOption=(!empty($primaryActionResolutionResult))?$primaryActionResolutionResult['*composeOption']:"";
								if(!empty($composeOption)){
									$eukey = array_search($composeOption,$entityUrn_Arr);
									if($eukey !==""){
										$temp = (object) array_merge((array)$e[$i2], (array)$includeddata[$eukey]);
										array_push($merge2, $temp);
									}
								}
							}
						}
						$threadId="";
						if(!empty($merge2)){
							$threadId=(isset($merge2[0]->composeNavigationContext->existingConversationUrn))?end(explode(':',$merge2[0]->composeNavigationContext->existingConversationUrn)):""; 
                            $payload = "{\"patch\":{\"\$set\":{\"archived\":true}}}";
                            $curlMessage = curl_init();
                            curl_setopt_array($curlMessage, array(
                                CURLOPT_URL => "https://www.linkedin.com/voyager/api/messaging/conversations/" . $threadId,
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => "",
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 30,
                                CURLOPT_HEADER => true,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_HTTPPROXYTUNNEL => 1,
                                CURLOPT_PROXY => "$proxyIp",
                                CURLOPT_PROXYPORT => "$proxyPort",
                                CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                                CURLOPT_CUSTOMREQUEST => "POST",
                                CURLOPT_POSTFIELDS => $payload,
                                CURLOPT_HTTPHEADER => array(
                                    "cookie: $cookie",
                                    "csrf-token: $csrf",
                                    "authority:www.linkedin.com",
                                    "scheme:https",
                                    "Accept: application/vnd.linkedin.normalized+json+2.1",
                                    "Accept-Language: en-US,en;q=0.5",
                                    "Accept-Encoding: gzip, deflate, br",
                                    "Content-Length: " . strlen($payload),
                                    "Content-Type: application/json; charset=UTF-8",
                                    "x-li-lang: en_US",
                                    "user-agent: $userAgent",
                                    "origin: https://www.linkedin.com",
                                    "referer: https://www.linkedin.com/messaging/thread/" . $threadId,
                                    "x-restli-protocol-version: 2.0.0",
                                    "x-li-lang: en_US"
                                )
                            ));
                            $resMessage = curl_exec($curlMessage);
                            $header_size = curl_getinfo($curlMessage, CURLINFO_HEADER_SIZE);
                            $headers = substr($resMessage, 0, $header_size);
                            $resMessage = substr($resMessage, $header_size);
                            $http_code = curl_getinfo($curlMessage, CURLINFO_HTTP_CODE);
                            if ($http_code == 204) {
                                if (mysqli_query($con, "UPDATE conversations SET threadId='" . str_replace('=', '%3d', $threadId) . "',isArchive = '1' WHERE personId ='" . $personId . "' AND userId='" . $userId . "'")) {
                                    return $personId;
                                }
                            } else {
                                return false;
                            }
						}else {
							return false;
						}
					}else {
						return false;
					}
                } else {
                    return false;
                }
            }
        }
    }

    public function actionMovetoinbox() {
        include('../web/config.php');
        include('../web/updateLinkedInCookie.php');

        $personId = Yii::$app->request->post('personId');
        $threadId = Yii::$app->request->post('threadId');
        $userId = Yii::$app->session->get('userid');

        $queryUsr = new Query();
        $queryUsr->select('proxyIp, proxyPort, proxyUsername, proxyPassword, cookie, csrf ,userAgent')->from('user')->where(['id' => $userId]);
        $usrData = $queryUsr->one();
        $csrf = $usrData['csrf'];
        $cookie = $usrData['cookie'];
        $proxyIp = $usrData['proxyIp'];
        $proxyPort = $usrData['proxyPort'];
        $proxyUsername = $usrData['proxyUsername'];
        $proxyPassword = $usrData['proxyPassword'];
        $userAgent = $usrData['userAgent'];

        $payload = "{\"patch\":{\"\$set\":{\"archived\":false}}}";
        $curlMessage = curl_init();
        curl_setopt_array($curlMessage, array(
            CURLOPT_URL => "https://www.linkedin.com/voyager/api/messaging/conversations/" . $threadId,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HEADER => true,
            /* CURLOPT_VERBOSE=>true, */
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPPROXYTUNNEL => 1,
            CURLOPT_PROXY => "$proxyIp",
            CURLOPT_PROXYPORT => "$proxyPort",
            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => array(
                "cookie: $cookie",
                "csrf-token: $csrf",
                "authority:www.linkedin.com",
                "scheme:https",
                "Accept: application/vnd.linkedin.normalized+json+2.1",
                "Accept-Language: en-US,en;q=0.5",
                "Accept-Encoding: gzip, deflate, br",
                "Content-Length: " . strlen($payload),
                "Content-Type: application/json; charset=UTF-8",
                "x-li-lang: en_US",
                "user-agent: $userAgent",
                "origin: https://www.linkedin.com",
                "referer: https://www.linkedin.com/messaging/thread/" . $threadId,
                "x-restli-protocol-version: 2.0.0",
                "x-li-lang: en_US"
            )
        ));
        $resMessage = curl_exec($curlMessage);
        $header_size = curl_getinfo($curlMessage, CURLINFO_HEADER_SIZE);
        $headers = substr($resMessage, 0, $header_size);
        $resMessage = substr($resMessage, $header_size);
        $newCookie = getCookiesLdnFromHeaders($headers);
        if (!empty($newCookie)) {
            updateUserLdnCookies($userId, $newCookie);
        }
        $err = curl_error($curlMessage);
        $http_code = curl_getinfo($curlMessage, CURLINFO_HTTP_CODE);
        if ($http_code == 204) {
            if (mysqli_query($con, "UPDATE conversations SET isArchive = '0' WHERE personId ='" . $personId . "' AND userId='" . $userId . "'")) {
                return $personId;
            }
        } else {
			$pubIdentifierQuery = new Query();
			$pubIdentifier=$pubIdentifierQuery->select('url_publicIdentifier')->from('blacklist')->where(['userid' => $userId,'linkedinpublicid' => $personId])->scalar();
			if(empty($pubIdentifier)){
				$pubIdentifier=$pubIdentifierQuery->select('url_publicIdentifier')->from('1stdegreedata')->where(['userId' => $userId,'linkedinpublicid' => $personId])->scalar();
			}
            $curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/dash/profiles?q=memberIdentity&memberIdentity=".$pubIdentifier."&decorationId=com.linkedin.voyager.dash.deco.identity.profile.TopCardSecondaryData-35", 
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 30,
				CURLOPT_HEADER => true,
				/* CURLOPT_VERBOSE=>true, */
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_HTTPPROXYTUNNEL => 1,
				CURLOPT_PROXY => "$proxyIp",
				CURLOPT_PROXYPORT => "$proxyPort",
				CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
				CURLOPT_CUSTOMREQUEST => "GET",
				CURLOPT_HTTPHEADER => array(
					"cookie: $cookie",
					"csrf-token: $csrf",
					"authority: www.linkedin.com",
					"User-Agent: $userAgent",
					"accept: application/vnd.linkedin.normalized+json+2.1",
					"Accept-Language: en-US,en;q=0.5",
					"Accept-Encoding: gzip, deflate, br",
					"x-li-lang: en_US",
					"x-restli-protocol-version: 2.0.0"
				)
			));
            $res = curl_exec($curl);
            if (curl_errno($curl)) {
                $error_msg = curl_error($curl);
                return false;
            } else {
                if (!empty($res)) {
					$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
					$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
					$headers = substr($res, 0, $header_size);
					$res = substr($res, $header_size);
                    $convRes = json_decode($res);
					
                    if($http_code == 200){
						$cArr = json_decode($res);			
						$d = $cArr->data->paging->total;
						$data = (array)$cArr->data;
						$e = (isset($data['*elements']))?$data['*elements']:array();
						
						$includeddata= $cArr->included;
						$merged = array();
						$entityUrn_Arr = array_column($includeddata, 'entityUrn');
						for($i2=0; $i2<count($e); $i2++) {
							$eukey = array_search($e[$i2],$entityUrn_Arr);
							if($eukey !==""){
								$temp = (object) array_merge((array)$e[$i2], (array)$includeddata[$eukey]);
								array_push($merged, $temp);
							}
						}
						$merge2=array();
						if(!empty($merged)){ 
							$e = $merged;
							for($i2=0; $i2<count($e); $i2++) {
								$mn=(array)$e[$i2];
								$primaryActionResolutionResult=(isset($mn['profileStatefulProfileActions']) && !empty($mn['profileStatefulProfileActions']))?(array)$mn['profileStatefulProfileActions']->primaryActionResolutionResult:'';
								$composeOption=(!empty($primaryActionResolutionResult))?$primaryActionResolutionResult['*composeOption']:"";
								if(!empty($composeOption)){
									$eukey = array_search($composeOption,$entityUrn_Arr);
									if($eukey !==""){
										$temp = (object) array_merge((array)$e[$i2], (array)$includeddata[$eukey]);
										array_push($merge2, $temp);
									}
								}
							}
						}
						$threadId="";
						
						if(!empty($merge2)){
							$threadId=(isset($merge2[0]->composeNavigationContext->existingConversationUrn))?end(explode(':',$merge2[0]->composeNavigationContext->existingConversationUrn)):"";
							
                            $payload = "{\"patch\":{\"\$set\":{\"archived\":false}}}";
                            $curlMessage = curl_init();
                            curl_setopt_array($curlMessage, array(
                                CURLOPT_URL => "https://www.linkedin.com/voyager/api/messaging/conversations/" . $threadId,
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => "",
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 30,
                                CURLOPT_HEADER => true,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_HTTPPROXYTUNNEL => 1,
                                CURLOPT_PROXY => "$proxyIp",
                                CURLOPT_PROXYPORT => "$proxyPort",
                                CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                                CURLOPT_CUSTOMREQUEST => "POST",
                                CURLOPT_POSTFIELDS => $payload,
                                CURLOPT_HTTPHEADER => array(
                                    "cookie: $cookie",
                                    "csrf-token: $csrf",
                                    "authority:www.linkedin.com",
                                    "scheme:https",
                                    "Accept: application/vnd.linkedin.normalized+json+2.1",
                                    "Accept-Language: en-US,en;q=0.5",
                                    "Accept-Encoding: gzip, deflate, br",
                                    "Content-Length: " . strlen($payload),
                                    "Content-Type: application/json; charset=UTF-8",
                                    "x-li-lang: en_US",
                                    "user-agent: $userAgent",
                                    "origin: https://www.linkedin.com",
                                    "referer: https://www.linkedin.com/messaging/thread/" . $threadId,
                                    "x-restli-protocol-version: 2.0.0",
                                    "x-li-lang: en_US"
                                )
                            ));
                            $resMessage = curl_exec($curlMessage);
                            $header_size = curl_getinfo($curlMessage, CURLINFO_HEADER_SIZE);
                            $headers = substr($resMessage, 0, $header_size);
                            $resMessage = substr($resMessage, $header_size);
                            $http_code = curl_getinfo($curlMessage, CURLINFO_HTTP_CODE);
                            if ($http_code == 204) {
                                if (mysqli_query($con, "UPDATE conversations SET threadId='" . str_replace('=', '%3d', $threadId) . "',isArchive = '0' WHERE personId ='" . $personId . "' AND userId='" . $userId . "'")) {
                                    return $personId;
                                }
                            } else {
                                return false;
                            }
						}else {
							return false;
						}
					}else {
                        return false;
                    }
                } else {
                    return false;
                }
            }
        }
    }

    public function actionRemoveassigntag() {
        include('../web/config.php');
        $tagId = Yii::$app->request->post('tagId');
        $personId = Yii::$app->request->post('personId');
        $userId = Yii::$app->session->get('userid');
		
		
		
        $queryBlckLst = new Query();
        $res = $queryBlckLst->select('id, tags')->from('blacklist')->where(['linkedinpublicid' => $personId, 'userid' => $userId])->one();
        if (!empty($res)) {
            $tags = explode(",", $res['tags']);
            $pos = array_search($tagId, $tags);
            unset($tags[$pos]);
            $tags = implode(",", $tags);
            if (mysqli_query($con, "UPDATE blacklist SET tags = '" . $tags . "' WHERE id =" . $res['id'])) {
                //return $tagId;
                echo $tagId;
            }
        }
		
		//echo '=='.$personId.'=='.$userId; exit;
		
        $query1stdegreedata = new Query();
        $res1stdegreedata = $query1stdegreedata->select('id, tags')->from('1stdegreedata')->where(['linkedinpublicid' => $personId, 'userId' => $userId])->one();
		
        if (!empty($res1stdegreedata)) {
            $tags = explode(",", $res1stdegreedata['tags']);
            $pos = array_search($tagId, $tags);
            unset($tags[$pos]);
            $tags = implode(",", $tags);
            if (mysqli_query($con, "UPDATE 1stdegreedata SET tags = '" . $tags . "' WHERE id =" . $res1stdegreedata['id'])) {
               // return $tagId;
               echo $tagId;
            }
        }
    }

    public function actionAddnewtask() {
        $personId = Yii::$app->request->post('personId');
        $textMsg = Yii::$app->request->post('textMsg');
        $startTime = Yii::$app->request->post('startTime');
        $userId = Yii::$app->session->get('userid');

//        $start_date = Yii::$app->request->post('start_date');
        //Add Replace comma to null becouse not converting future year - ravi bhuva 07-Oct-2020
        $start_date = str_replace(",", "", Yii::$app->request->post('start_date'));
        $start_time = Yii::$app->request->post('start_time') . ":00";

        $date = date_create($start_date);
        $start_date = date_format($date, "Y-m-d");
        $date = $start_date . " " . $start_time;
        $getTimezone = Yii::$app->db->createCommand("SELECT TimeZone FROM user where id =  " . Yii::$app->session->get('userid'))->queryOne();
        $user_timezone = $getTimezone['TimeZone'];
        $ist_date = \DateTime::createFromFormat('Y-m-d H:i:s', $date, new \DateTimeZone($user_timezone));
        $gmt_date = clone $ist_date;
        $gmt_date->setTimeZone(new \DateTimeZone('UTC'));
        $server_start_time = $gmt_date->format('Y-m-d H:i:s');
        $server_start_time = strtotime($server_start_time) * 1000;

        $SubuserDetail = Yii::$app->db->createCommand("select  person  from  completed_tasks  where userId='$userId' AND personId='$personId'")->queryOne();
        $sqlAddext_steps = Yii::$app->db->createCommand("INSERT INTO `sendLaterMessage`(`userId`,`message`) VALUES ('" . $userId . "','" . addslashes($textMsg) . "')")->execute();
        $lastidinserted_steps = Yii::$app->db->getLastInsertID();
        $sqlAddext_steps = Yii::$app->db->createCommand("INSERT INTO `ext_tasks`(`userId`,`startTime`,`personId`,`stepId`,`status`,`type`,`delayType`,`person`) VALUES ('$userId','$server_start_time','$personId','$lastidinserted_steps','Not Started','Message','sendLater','" . addslashes($SubuserDetail['person']) . "')")->execute();
        $lastidinserted_tasks = Yii::$app->db->getLastInsertID();
        if (!empty($lastidinserted_tasks)) {
            return $lastidinserted_tasks;
        } else {
            return false;
        }
    }

    public function actionGettask() {
        $personId = Yii::$app->request->post('personId');
        $userId = Yii::$app->session->get('userid');

        $linkedin_ProfilePic = Yii::$app->db->createCommand("select ProfilePic400_400 from user_profile where user_id='" . Yii::$app->session->get('userid') . "'")->queryScalar();
        if (!empty($linkedin_ProfilePic)) {
            $linkedin_ProfilePic = $linkedin_ProfilePic;
        } else {
            $linkedin_ProfilePic = Yii::$app->request->baseUrl . '/img/no-user.png';
        }

        $SubuserDetail = Yii::$app->db->createCommand("select  id,startTime,stepId  from  ext_tasks  where userId='$userId' AND personId='$personId' AND delayType='sendLater' AND status='Not Started' AND startTime >= '" . round(microtime(true) * 1000) . "'")->queryAll();
        $html = "";
        if (!empty($SubuserDetail)) {
            foreach ($SubuserDetail as $data) {

                $getTimezone = Yii::$app->db->createCommand("SELECT TimeZone FROM user where id =  " . Yii::$app->session->get('userid'))->queryOne();
                $user_timezone = $getTimezone['TimeZone'];

                $ist_date = \DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d H:i:s', $data['startTime'] / 1000), new \DateTimeZone('UTC'));
                $gmt_date = clone $ist_date;
                $gmt_date->setTimeZone(new \DateTimeZone($user_timezone));
                $server_start_time = $gmt_date->format('d M Y h:i A');
//                $html .= '<div class="chat" id="taskid_' . $data['id'] . '"><div class="chat-avatar"><a class="avatar m-0" data-letters="' . strtoupper(substr(Yii::$app->session->get('linkedin_firstname'), 0, 1) . substr(Yii::$app->session->get('linkedin_lastname'), 0, 1)) . '"></a></div><div class="chat-body"><div class="chat-message"><p>Message Scheduled</p><span class="chat-time"><i class="bx bx-time" style="font-size: 12px;line-height: 0;display: contents;">&nbsp;</i>' . $server_start_time . '</span><button type="button" class="btn ml-2 btn-info btn-sm" onclick="getTaskMessage(' . $data['id'] . ')">Details</button><button type="button" class="btn ml-1 btn-warning btn-sm" onclick="getSkipMessage(' . $data['id'] . ')">Skip</button></div></div></div></div>';
                $html .= '<div class="chat" id="taskid_' . $data['id'] . '"><div class="chat-avatar"><a class="avatar m-0"><img src="' . $linkedin_ProfilePic . '" alt="avatar" height="36" width="36"></a></div><div class="chat-body"><div class="chat-message" style="background-color: #8eaeea;"><p>Message Scheduled</p><span class="chat-time"><i class="bx bx-time" style="font-size: 12px;line-height: 0;display: contents;">&nbsp;</i>' . $server_start_time . '</span><button type="button" class="btn mr-1 btn-info btn-sm" onclick="getTaskMessage(' . $data['id'] . ')">Details</button><button type="button" class="btn  btn-warning btn-sm" onclick="getSkipMessage(' . $data['id'] . ')">Skip</button></div></div></div></div>';
            }
            return $html;
        } else {
            return false;
        }
    }

    public function actionGettaskmsg() {
        $taskid = Yii::$app->request->post('taskid');
        $userId = Yii::$app->session->get('userid');

        $getTimezone = Yii::$app->db->createCommand("SELECT TimeZone FROM user where id =  " . Yii::$app->session->get('userid'))->queryOne();
        $user_timezone = $getTimezone['TimeZone'];



        $SubuserDetail = Yii::$app->db->createCommand("SELECT s.message,t.startTime FROM `sendLaterMessage` as s LEFT JOIN `ext_tasks` as t on t.stepId=s.id where t.id=$taskid")->queryOne();

        $ist_date = \DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d H:i:s', $SubuserDetail['startTime'] / 1000), new \DateTimeZone('UTC'));
        $gmt_date = clone $ist_date;
        $gmt_date->setTimeZone(new \DateTimeZone($user_timezone));
        $server_start_time = $gmt_date->format('d M Y h:i A');

        $dataArray = array();
        if (!empty($SubuserDetail)) {
            $dataArray['startTime'] = $server_start_time;
            $dataArray['message'] = $SubuserDetail['message'];
            return json_encode($dataArray);
        } else {
            return false;
        }
    }

    public function actionSkiptask() {
        $taskid = Yii::$app->request->post('taskid');
        $userId = Yii::$app->session->get('userid');
        $sqlUpdate_task = Yii::$app->db->createCommand("UPDATE ext_tasks SET status = 'Paused' WHERE id ='" . $taskid . "' AND delayType='sendLater'")->execute();
        if ($sqlUpdate_task == 1) {
            return $taskid;
        } else {
            return false;
        }
    }

    public function actionGetactivitylogdata() {
        $session = Yii::$app->session;
        $session->get('userid');
        $linkedinpublicid = Yii::$app->request->post('linkedinpublicid');
        $seqid = Yii::$app->request->post('seqid');
        $seq_name = Yii::$app->request->post('seq_name');
        $queryUsr = new Query();
        $queryUsr->select('TimeZone')->from('user')->where(['id' => Yii::$app->session->get('userid')]);
        $usrData = $queryUsr->one();


        $completedquery = new Query;
        $pendingquery = new Query;
        $blacklistquery = new Query;
        $completed_task = $completedquery->select(['`completed_tasks`.`type`', '`completed_tasks`.`seqId`', '`completed_tasks`.`delayType`', '`completed_tasks`.`result`', '`completed_tasks`.`completedOn`', '`completed_tasks`.`status`', '`completed_tasks`.`step`', '`completed_tasks`.`triggerOnInvitationAccepted`'])
                        ->from('completed_tasks')
                        ->where(['completed_tasks.userId' => $session->get('userid')])
						->andWhere(['<>','completed_tasks.status', 'Error'])
                        ->andWhere(['completed_tasks.personId' => $linkedinpublicid])
//                        ->andWhere(['completed_tasks.seqId' => $seqid])
                        ->orderBy(['completed_tasks.id' => SORT_DESC])->all();
        $pending_task = $pendingquery->select(['`ext_tasks`.`type`', '`ext_tasks`.`seqId`', '`ext_tasks`.`id`', '`ext_tasks`.`delayType`', '`ext_tasks`.`result`', '`ext_tasks`.`startTime`', '`ext_tasks`.`status`', '`ext_tasks`.`step`', '`ext_tasks`.`triggerOnInvitationAccepted`'])
                        ->from('ext_tasks')
                        ->where(['ext_tasks.userId' => $session->get('userid')])
                        ->andWhere(['ext_tasks.personId' => $linkedinpublicid])
//                        ->andWhere(['ext_tasks.seqId' => $seqid])
                        ->orderBy(['ext_tasks.id' => SORT_DESC])->all();
        $is_response = $blacklistquery->select(['`blacklist`.`is_response`', '`blacklist`.`respond`'])
                ->from('blacklist')
                ->where(['blacklist.userid' => $session->get('userid')])
                ->andWhere(['blacklist.linkedinpublicid' => $linkedinpublicid])
//                ->andWhere(['blacklist.seq_id' => $seqid])
                ->one();

        $tempArray = array();
        foreach ($pending_task as $pactivitydata) {
            $seq_name = Yii::$app->db->createCommand("select name from ext_sequences where id=" . $pactivitydata['seqId'])->queryScalar();
            $startTime = $pactivitydata['startTime'];
            $msg = $pactivitydata['result'];
            if (preg_match('/title="(.*?)"/s', $msg, $display) === 1) {
                $msg = $display[1];
                $fullmsg = $msg;
                $msg = strlen($msg) > 40 ? substr($msg, 0, 40) . "..." : $msg;
            } else {
                $fullmsg = '';
            }
            $ist_date = \DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d H:i:s', $startTime / 1000), new \DateTimeZone('UTC'));
            $gmt_date = clone $ist_date;
            $gmt_date->setTimeZone(new \DateTimeZone($usrData['TimeZone']));
            $startTime = $gmt_date->format('d M Y h:i A');
            $type = $pactivitydata['type'];
            $step = $pactivitydata['step'];
            $triggerOnInvitationAccepted = $pactivitydata['triggerOnInvitationAccepted'];

            if ($pactivitydata['delayType'] == "sendLater") {
                $sendLater = '<i class="bx bx-time" style="font-size: 13px;">&nbsp</i>';
            } else {
                $sendLater = "";
            }

            if ($pactivitydata['status'] == 'Skipped' && $type == 'Connect' && $step == 0) {
                $detailss = 'Invitation skipped ';
                $type = "Connection Message";
            } elseif ($pactivitydata['status'] == 'Skipped' && $type == 'Connect' && $step != 0) {
                $detailss = 'Follow-up skipped ';
                $type = "Follow-up Message";
            } elseif ($pactivitydata['status'] == 'Not Started' && $type == 'Connect' && $step == 0) {
                $detailss = 'Invite Scheduled ';
                $type = "Connection Message";
            } elseif ($pactivitydata['status'] == 'Not Started' && $type == 'Connect' && $step != 0) {
                $detailss = 'Follow-up Scheduled ';
                $type = "Follow-up Message";
            } elseif ($pactivitydata['status'] == 'Skipped' && $type == 'Message' && $step == 0) {
                $detailss = 'Message skipped ';
                $type = "First Message";
            } elseif ($pactivitydata['status'] == 'Skipped' && $type == 'Message' && $step != 0) {
                $detailss = 'Follow-up skipped ';
                $type = "Follow-up Message";
            } elseif ($pactivitydata['status'] == 'Not Started' && $type == 'Message' && $step == 0) {
                $detailss = 'Message Scheduled ';
                $type = "First Message";
            } elseif ($pactivitydata['status'] == 'Not Started' && $type == 'Message' && $step != 0 && $triggerOnInvitationAccepted == 1) {
                $detailss = 'Invite Withdrawal Task';
                $type = "";
            } elseif ($pactivitydata['status'] == 'Not Started' && $type == 'Message' && $step != 0) {
                $detailss = 'Message Scheduled ';
                $type = "Follow-up Message";
            } elseif ($pactivitydata['status'] == 'Paused' && $type == 'Message' && $step != 0 && $triggerOnInvitationAccepted == 1) {
                $detailss = 'Follow-up Paused ';
                $type = "Follow-up Message";
            } elseif ($pactivitydata['status'] == 'Paused' && $type == 'Message' && $step != 0) {
                $detailss = 'Follow-up Paused ';
                $type = "Follow-up Message";
            } elseif ($pactivitydata['status'] == 'Paused' && $pactivitydata['delayType'] == 'sendLater' && $type == 'Message' && $step == 0) {
                $detailss = 'Message Scheduled Paused ';
                $type = "Scheduled Message";
            } elseif ($type == 'Zapier') {
                $detailss = 'Zapier Trigger Scheduled';
                $type = 'Zapier Message';
            }
            if (!empty($msg)) {
                $div = "<div class='timeline-content'>  
                  <p class='timeline-text' title='" . $fullmsg . "'>" . $msg . "</p>
                </div>";
            } else {
                $div = "<div class='timeline-content' style='padding:0.5rem 0rem !important; '> 
                </div>";
            }

            if ($pactivitydata['status'] == 'Not Started') {
                $skipButton = "<a href='javascript:;' title='Skip Followup' class='skip-follow-up' data-id='" . $pactivitydata['id'] . "' style='display: block;margin-top: 5px !important;text-align: right;'><u>Skip Followup</u></a>";
            } else {
                $skipButton = "";
            }

            if ($pactivitydata['delayType'] == "sendLater") {
                $tmpArr = array();
                $tmpArr['time'] = $pactivitydata['startTime'];
                $tmpArr['result'] = "<li class='timeline-items timeline-icon-warning active'>
                <div class='timeline-time'>" . $sendLater . $startTime . $skipButton . "</div>
                <h6 class='timeline-title'>" . $detailss . "</h6>                
              </li>";
                array_push($tempArray, $tmpArr);
            } else {
                $tmpArr = array();
                $tmpArr['time'] = $pactivitydata['startTime'];
                $tmpArr['result'] = "<li class='timeline-items timeline-icon-warning active'>
                <div class='timeline-time'>" . $sendLater . $startTime . $skipButton . "</div>
                <h6 class='timeline-title'>" . $detailss . "</h6>
                <p class='timeline-text'>" . $type . "<br>(" . $seq_name . ")</p>" . $div . "
              </li> ";
                array_push($tempArray, $tmpArr);
            }
        }

        if (!empty($is_response['respond'])) {
            $respond = $is_response['respond'];
            $ist_date = \DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d H:i:s', $respond / 1000), new \DateTimeZone('UTC'));
            $gmt_date = clone $ist_date;
            $gmt_date->setTimeZone(new \DateTimeZone($usrData['TimeZone']));
            $respond = $gmt_date->format('d M Y h:i A');
            $tmpArr = array();
            $tmpArr['time'] = $is_response['respond'];
            $tmpArr['result'] = "<li class='timeline-items timeline-icon-warning active'>
			<div class='timeline-time'>" . $respond . "</div>
			<h6 class='timeline-title'>Responded At</h6>
			<p class='timeline-text'>(" . $seq_name . ")</p>
			</li> ";
            array_push($tempArray, $tmpArr);
        }
        foreach ($completed_task as $activitydata) {
            $seq_name = Yii::$app->db->createCommand("select name from ext_sequences where id=" . $activitydata['seqId'])->queryScalar();
            $completedOn = strtotime($activitydata['completedOn']);
            $msg = $activitydata['result'];
            if (preg_match('/title="(.*?)"/s', $msg, $display) === 1) {
                $msg = $display[1];
                $fullmsg = $msg;
                $msg = strlen($msg) > 40 ? substr($msg, 0, 40) . "..." : $msg;
            } else {
                $fullmsg = '';
            }
            $ist_date = \DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d H:i:s', $completedOn), new \DateTimeZone('UTC'));
            $gmt_date = clone $ist_date;
            $gmt_date->setTimeZone(new \DateTimeZone($usrData['TimeZone']));
            $completedOn = $gmt_date->format('d M Y h:i A');
            $type = $activitydata['type'];
            $step = $activitydata['step'];
            if ($activitydata['status'] == 'Skipped' && $type == 'Connect' && $step == 0) {
                $details = 'Invite skipped ';
                $type = "Connection Message";
                $active = "<li class='timeline-items timeline-icon-success active'>";
            } elseif ($activitydata['status'] == 'Skipped' && $type == 'Connect' && $step != 0) {
                $details = 'Follow-up skipped ';
                $type = "Follow-up Message";
                $active = "<li class='timeline-items timeline-icon-primary active'>";
            } elseif ($activitydata['status'] == 'Skipped' && $type == 'Message' && $step == 0) {
                $details = 'Message skipped ';
                $type = "First Message";
                $active = "<li class='timeline-items timeline-icon-success active'>";
            } elseif ($activitydata['status'] == 'Skipped' && $type == 'Message' && $step != 0) {
                $details = 'Follow-up skipped ';
                $type = "Follow-up Message";
                $active = "<li class='timeline-items timeline-icon-danger active'>";
            } elseif ($activitydata['status'] == 'Complete' && $type == 'Connect' && $step == 0) {
                $details = 'Invite sent ';
                $type = "Connection Message";
                $active = "<li class='timeline-items timeline-icon-success active'>";
            } elseif ($activitydata['status'] == 'Complete' && $type == 'Connect' && $step != 0) {
                $details = 'Follow-up sent ';
                $type = "Follow-up Message";
                $active = "<li class='timeline-items timeline-icon-primary active'>";
            } elseif ($activitydata['status'] == 'Complete' && $type == 'Message' && $step == 0) {
                $details = 'Message sent ';
                if ($activitydata['delayType'] == 'sendLater') {
                    $type = "Scheduled Message";
                } else {
                    $type = "First Message";
                }
                $active = "<li class='timeline-items timeline-icon-danger active'>";
            } elseif ($activitydata['status'] == 'Complete' && $type == 'Message' && $step != 0) {
                $details = 'Follow-up sent ';
                $type = "Follow-up Message";
                $active = "<li class='timeline-items timeline-icon-primary active'>";
            } elseif ($activitydata['status'] == 'Paused' && $type == 'Connect' && $step == 0) {
                $details = 'Invite Skipped ';
                $type = "Connection Message";
                $active = "<li class='timeline-items timeline-icon-success active'>";
            } elseif ($activitydata['status'] == 'Paused' && $type == 'Connect' && $step != 0) {
                $details = 'Follow-up Skipped ';
                $type = "Follow-up Message";
                $active = "<li class='timeline-items timeline-icon-primary active'>";
            } elseif ($activitydata['status'] == 'Paused' && $type == 'Message' && $step == 0) {
                if ($activitydata['delayType'] == "sendLater") {
                    $details = 'Message Skipped ';
                    $type = "Scheduled Message";
                } else {
                    $details = 'Message Skipped ';
                    $type = "First Message";
                }
                $active = "<li class='timeline-items timeline-icon-danger active'>";
            } elseif ($activitydata['status'] == 'Paused' && $type == 'Message' && $step != 0) {
                $details = 'Follow-up Skipped ';
                $type = "Follow-up Message";
                $active = "<li class='timeline-items timeline-icon-primary active'>";
            } elseif ($type == 'Zapier') {
                $details = 'Message sent';
                $type = 'Zapier Message';
                $active = "<li class='timeline-items timeline-icon-success active'>";
            }

            if (!empty($msg)) {
                $div = "<div class='timeline-content'>  
                  <p class='timeline-text' title='" . $fullmsg . "'>" . $msg . "</p>
                </div>";
            } else {
                $div = "<div class='timeline-content' style='padding:0.5rem 0rem !important; '> 
                </div>";
            }

            if ($activitydata['delayType'] == "sendLater") {

                $tmpArr = array();
                $tmpArr['time'] = strtotime($activitydata['completedOn']) * 1000;
                $tmpArr['result'] = $active . "
                <div class='timeline-time'>" . $completedOn . "</div>
                <h6 class='timeline-title'>" . $details . "</h6>
                <p class='timeline-text'>" . $type . "<br></p>" . $div . "                
              </li>  ";
                array_push($tempArray, $tmpArr);
            } else {

                $tmpArr = array();
                $tmpArr['time'] = strtotime($activitydata['completedOn']) * 1000;
                $tmpArr['result'] = $active . "
                <div class='timeline-time'>" . $completedOn . "</div>
                <h6 class='timeline-title'>" . $details . "</h6>
                <p class='timeline-text'>" . $type . "<br>(" . $seq_name . ")</p>" . $div . "                
              </li>  ";
                array_push($tempArray, $tmpArr);
            }
        }

        $time = array_column($tempArray, 'time');
        array_multisort($time, SORT_DESC, $tempArray);
        if (!empty($tempArray)) {
            $results = "<div class='card-body'>
            <ul class='widget-timeline mb-0'>";
            foreach ($tempArray as $tempAy) {
                $results .= $tempAy['result'];
            }
            $results .= "</ul></div>";
        }



        echo $results;
    }

    function actionSkipfollowup() {
        $taskId = Yii::$app->request->post('taskId');
        $userId = Yii::$app->session->get('userid');

        $task = Yii::$app->db->createCommand("SELECT personId,seqId,person,triggerOnInvitationAccepted,delayType FROM `ext_tasks` WHERE `id` = '" . $taskId . "' AND userId='$userId'")->queryOne();

//        if ($task['triggerOnInvitationAccepted'] == 1) {
//            //Skip withdraw
//            $personId = $task['personId'];
//            $timestamp = round(microtime(true) * 1000);
//            $seqId = $task['seqId'];
//            $types = "Withdrawal";
//
//            if (!empty(json_decode(preg_replace('/\"description\"\:\".*?\"\,/ms', '"description":"empty",', $task['person']))->fullName)) {
//                $fullname = json_decode(preg_replace('/\"description\"\:\".*?\"\,/ms', '"description":"empty",', $task['person']))->fullName;
//            } else {
//                $fullname = '';
//            }
//
//            $a = 'Skipped for <a href="#">';
//            $aa = '</a>';
//            $text = $types . " " . $a . $fullname . $aa;
//
//            if (Yii::$app->db->createCommand("UPDATE `ext_tasks` SET `status` = 'Paused' WHERE `status` = 'Not Started' AND `personId` = '" . $personId . "' AND `userId` = '" . $userId . "'")->execute()) {
//                Yii::$app->db->createCommand("INSERT INTO `ext_log` (`userId`,`seqId`,`text`) values('" . $userId . "','" . $seqId . "','" . $text . "')")->execute();
//                return true;
//            } else {
//                return false;
//            }
//        } else {
        //Skip Followup
        $personId = $task['personId'];
        $timestamp = round(microtime(true) * 1000);
        $seqId = $task['seqId'];
        $types = "Follow-up";

        if (!empty(json_decode(preg_replace('/\"description\"\:\".*?\"\,/ms', '"description":"empty",', $task['person']))->fullName)) {
            $fullname = json_decode(preg_replace('/\"description\"\:\".*?\"\,/ms', '"description":"empty",', $task['person']))->fullName;
        } else {
            $fullname = '';
        }

        $a = 'Skipped for <a href="#">';
        $aa = '</a> Manually';
        $text = $types . " " . $a . $fullname . $aa;

        if (Yii::$app->db->createCommand("UPDATE `ext_tasks` SET `status` = 'Paused' WHERE `status` = 'Not Started' AND `personId` = '" . $personId . "' AND `userId` = '" . $userId . "'")->execute()) {
            Yii::$app->db->createCommand("INSERT INTO completed_tasks SELECT ext_tasks.*, NOW() FROM ext_tasks WHERE id = '" . $taskId . "'")->execute();
            Yii::$app->db->createCommand("DELETE FROM ext_tasks WHERE id = '" . $taskId . "'")->execute();
            if ($task['delayType'] != "sendLater") {
                //Yii::$app->db->createCommand("UPDATE  blacklist SET  is_response='2',respond='" . $timestamp . "' WHERE seq_id = '" . $seqId . "' AND linkedinpublicid='" . $personId . "' AND userid='" . $userId . "'")->execute();
                Yii::$app->db->createCommand("UPDATE  blacklist SET  is_response='2' WHERE seq_id = '" . $seqId . "' AND linkedinpublicid='" . $personId . "' AND userid='" . $userId . "'")->execute();
            }
            Yii::$app->db->createCommand("INSERT INTO `ext_log` (`userId`,`seqId`,`text`) values('" . $userId . "','" . $seqId . "','" . $text . "')")->execute();

            return true;
        } else {
            return false;
        }
//        }
    }

    function actionCheckcontacthubspotv3() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $fullname = trim(str_replace(".", "", Yii::$app->request->post('fullname')));
        $firstName = $this->unicodeString(Yii::$app->request->post('firstName'));
        $lastName = $this->unicodeString(Yii::$app->request->post('lastName'));
        $email = Yii::$app->request->post('email');
        if ($email == "N/A" || $email == "NA") {
            $email = "";
        }
        $Apikey = Yii::$app->request->post('Apikey');
        $portalId = Yii::$app->request->post('portalId');
        $owID = Yii::$app->request->post('owID');
        if ($Apikey != "" && $portalId != "") {
            $data = array();
            if (!empty($email)) {
                $data['filterGroups'] = [array("filters" => array(["propertyName" => "email", "operator" => "EQ", "value" => $email]))];
            } else {
                $data['filterGroups'] = [array("filters" => array(["propertyName" => "firstname", "operator" => "EQ", "value" => $firstName], ["propertyName" => "lastname", "operator" => "EQ", "value" => $lastName]))];
            }
            $checkData = $this->unicodeString($CheckVar);

            $proxyIp = "brd.superproxy.io";
$proxyPort = "22225";
$proxyUsername = "brd-customer-hl_5b864891-zone-hubspotapi";
$proxyPassword = "qjuurxof7nyi";

            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://api.hubapi.com/crm/v3/objects/contacts/search?hapikey=' . $Apikey,
                CURLOPT_RETURNTRANSFER => 1,
                CURLOPT_POST => 1,
                CURLOPT_POSTFIELDS => json_encode($data),
                CURLOPT_PROXY => "$proxyIp",
                CURLOPT_PROXYPORT => "$proxyPort",
                CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                CURLOPT_HTTPHEADER => array(
                    "content-type: application/json"
                ),
            ));
            $response = curl_exec($curl);
            $err = curl_error($curl);
            $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            curl_close($curl);
            $hubspotContact = array();
            if ($err || (isset(json_decode($response)->status) && json_decode($response)->status == 'error')) {
                return false;
            } else {
                if (json_decode($response)->total > 0) {
                    $vid = json_decode($response)->results[0]->id;
                    $hubspotContact['vid'] = $vid;
                } else {
                    $hubspotContact['vid'] = "";
                }
                $response = array('vid' => $hubspotContact);
                return json_encode($response);
            }
        }
    }

    function actionCheckcontacthubspot() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $fullname = Yii::$app->request->post('fullname');
        $firstName = Yii::$app->request->post('firstName');
        $lastName = Yii::$app->request->post('lastName');
        $email = Yii::$app->request->post('email');
        $Apikey = Yii::$app->request->post('Apikey');
        $portalId = Yii::$app->request->post('portalId');
        if ($Apikey != "" && $portalId != "") {
            $CheckVar = !empty($email) ? $email : (!empty($fullname) ? $fullname : '');
            $checkData = $this->unicodeString($CheckVar);

            $proxyIp = "brd.superproxy.io";
$proxyPort = "22225";
$proxyUsername = "brd-customer-hl_5b864891-zone-hubspotapi";
$proxyPassword = "qjuurxof7nyi";

            $Url = "https://api.hubapi.com/contacts/v1/search/query?hapikey=" . $Apikey . "&q=" . $checkData;
            $RequestType = "GET";
            $PostFields = '';
            $Header = array();
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $Url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLINFO_HEADER_OUT => true,
                CURLOPT_ENCODING => "",
                CURLOPT_HTTPPROXYTUNNEL => 1,
                CURLOPT_PROXY => "$proxyIp",
                CURLOPT_PROXYPORT => "$proxyPort",
                CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                CURLOPT_CUSTOMREQUEST => $RequestType,
                CURLOPT_POSTFIELDS => $PostFields,
                CURLOPT_HTTPHEADER => $Header
            ));
            $response = curl_exec($curl);
            $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            $err = curl_error($curl);
            $hubspotContact = array();
            if ($httpcode == 200) {
                if (json_decode($response)->offset > 0) {
                    $vid = json_decode($response)->contacts[0]->vid;
                    $hubspotContact['vid'] = $vid;
                } else {
                    $hubspotContact['vid'] = "";
                }
                $response = array('vid' => $hubspotContact);
                return json_encode($response);
            } else {
                return false;
            }
        }
    }

    function unicodeString($str, $encoding = null) {
        if (is_null($encoding))
            $encoding = ini_get('mbstring.internal_encoding');
        return preg_replace_callback('/u([0-9a-fA-F]{4})/u', function($match) use ($encoding) {
            return mb_convert_encoding(pack('H*', $match[1]), $encoding, 'UTF-16BE');
        }, $str);
    }

    public function actionUpdatereadunreadflag() {
        $conversationId = Yii::$app->request->post('id');
        $personId = Yii::$app->request->post('personId');
        $threadId = Yii::$app->request->post('threadId');
        $userId = Yii::$app->session->get('userid');
        $isRead = Yii::$app->request->post('isRead');


        $queryUsr = new Query();
        $queryUsr->select('proxyIp, proxyPort, proxyUsername, proxyPassword, cookie, csrf ,userAgent')->from('user')->where(['id' => $userId]);
        $usrData = $queryUsr->one();
        $csrf = $usrData['csrf'];
        $cookie = $usrData['cookie'];
        $proxyIp = $usrData['proxyIp'];
        $proxyPort = $usrData['proxyPort'];
        $proxyUsername = $usrData['proxyUsername'];
        $proxyPassword = $usrData['proxyPassword'];
        $userAgent = $usrData['userAgent'];
        $readStatus = (isset($isRead) && !empty($isRead)) ? 'false' : 'true';
        $payload = "{\"patch\":{\"\$set\":{\"read\":" . $readStatus . "}}}";
        $curlMessage = curl_init();
        curl_setopt_array($curlMessage, array(
            CURLOPT_URL => "https://www.linkedin.com/voyager/api/messaging/conversations/" . $threadId,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HEADER => true,
            /* CURLOPT_VERBOSE=>true, */
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPPROXYTUNNEL => 1,
            CURLOPT_PROXY => "$proxyIp",
            CURLOPT_PROXYPORT => "$proxyPort",
            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPHEADER => array(
                "cookie: $cookie",
                "csrf-token: $csrf",
                "authority:www.linkedin.com",
                "scheme:https",
                "Accept: application/vnd.linkedin.normalized+json+2.1",
                "Accept-Language: en-US,en;q=0.5",
                "Accept-Encoding: gzip, deflate, br",
                "Content-Length: " . strlen($payload),
                "Content-Type: application/json; charset=UTF-8",
                "x-li-lang: en_US",
                "user-agent: $userAgent",
                "origin: https://www.linkedin.com",
                "referer: https://www.linkedin.com/messaging/thread/" . $threadId,
                "x-restli-protocol-version: 2.0.0",
                "x-li-lang: en_US"
            )
        ));
        $resMessage = curl_exec($curlMessage);
        $header_size = curl_getinfo($curlMessage, CURLINFO_HEADER_SIZE);
        $headers = substr($resMessage, 0, $header_size);
        $resMessage = substr($resMessage, $header_size);
        $http_code = curl_getinfo($curlMessage, CURLINFO_HTTP_CODE);
        if ($http_code == 200) {
            $isRead = (isset($isRead) && !empty($isRead)) ? 0 : 1;
            $userId = Yii::$app->session->get('userid');
            $sqlUpdate_task = Yii::$app->db->createCommand("UPDATE conversations SET isRead = '" . $isRead . "' WHERE id ='" . $conversationId . "'")->execute();
        } else {
            return false;
        }
    }

    public function actionAddsuppressionlist() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        include('../web/config.php');
        $publicidentifier = Yii::$app->request->post('publicidentifier');
        $personId = Yii::$app->request->post('personId');
        $userId = Yii::$app->session->get('userid');
        $teamId = Yii::$app->session->get('teamid');
        $suppressionId = "";
        /* $suppressionData = Yii::$app->db->createCommand("SELECT id FROM `suppressionlist` WHERE `publicidentifier` ='".$publicidentifier."' and `personId` ='".$personId."' and `userId` ='".$userId."' and `teamId` ='".$teamId."'")->queryScalar();
          if (!empty($suppressionData)) {
          $suppressionId = $suppressionData;
          return "false";
          }else{ */
        $insert = mysqli_query($con, "INSERT INTO suppressionlist (personId, publicidentifier, userId, teamId,flag) values('" . $personId . "','" . $publicidentifier . "','" . $userId . "','" . $teamId . "',1)");
        if ($insert) {
            return mysqli_insert_id($con);
        } else {
            return false;
        }
        //}
    }

    public function actionDeletesuppressionlist() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        include('../web/config.php');
        if (!empty(Yii::$app->request->post('suppressionid'))) {
            $suppressionid = Yii::$app->request->post('suppressionid');
            $delete = Yii::$app->db->createCommand("DELETE FROM suppressionlist WHERE id = '" . $suppressionid . "'")->execute();
            if ($delete) {
                return true;
            } else {
                return false;
            }
        }
    }

    //Developed by Ankit Sevak
    // multi mark unread function
    public function actionMultimarkunread() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        if (isset($_POST['delblkidslist']) && $_POST['delblkidslist'] != '') {

            $delblkidslist = explode(',', $_POST['delblkidslist']);

            $unreadthreadArr = array();
            $payload = "";
            $pad = "";
            $entitiesPayload = '{"entities":{';
            $entitiesPayloadEnd = '}}';
            $threadIds = "";
            $threadPad = "";
            if (count($delblkidslist) > 0) {

                foreach ($delblkidslist as $ur) {
                    //$sqltask = Yii::$app->db->createCommand("UPDATE conversations SET isRead = '0' WHERE id ='" . $ur . "'")->execute();

                    $threadidrow = Yii::$app->db->createCommand("SELECT threadId,personId FROM `conversations` WHERE `id` = '" . $ur . "'")->queryOne();
                    $threadIds .= $threadPad . $threadidrow['threadId'];
                    $threadPad = ",";
                    $threadId = str_replace('%3D%3D', '==', $threadidrow['threadId']);
                    $payload .= $pad . '"' . $threadId . '"' . ":{\"patch\":{\"\$set\":{\"read\":false}}}";
                    $pad = ",";
                }

                $readUnreadyPayload = $entitiesPayload . $payload . $entitiesPayloadEnd;

                //echo $readUnreadyPayload; exit;

                $referer = explode(',', $threadIds);
                $referer = str_replace('%3D%3D', '==', $referer[0]);

                //echo "https://www.linkedin.com/voyager/api/messaging/conversations?ids=List(".$threadIds.")";exit; 
                //exit; 
                $queryUsr = new Query();
                $queryUsr->select('proxyIp, proxyPort, proxyUsername, proxyPassword, cookie, csrf ,userAgent')->from('user')->where(['id' => Yii::$app->session->get('userid')]);
                $usrData = $queryUsr->one();
                $csrf = $usrData['csrf'];
                $cookie = $usrData['cookie'];
                $proxyIp = $usrData['proxyIp'];
                $proxyPort = $usrData['proxyPort'];
                $proxyUsername = $usrData['proxyUsername'];
                $proxyPassword = $usrData['proxyPassword'];
                $userAgent = $usrData['userAgent'];

                //echo "https://www.linkedin.com/voyager/api/messaging/conversations?ids=List(".$threadIds.")";
                //echo "<br>".$readUnreadyPayload;exit;
                //echo '<pre>'; print_r($usrData); exit;
                //$readStatus=(isset($isRead) && !empty($isRead))? 'false' :'true';	
                //$payload = "{\"patch\":{\"\$set\":{\"read\":".$readStatus."}}}";
                $curlMessage = curl_init();
                curl_setopt_array($curlMessage, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/messaging/conversations?ids=List(" . $threadIds . ")",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_HEADER => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_POSTFIELDS => $readUnreadyPayload,
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "authority:www.linkedin.com",
                        "scheme:https",
                        "Accept: application/vnd.linkedin.normalized+json+2.1",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "Content-Length: " . strlen($readUnreadyPayload),
                        "Content-Type: application/json; charset=UTF-8",
                        "x-li-lang: en_US",
                        "user-agent: $userAgent",
                        "origin: https://www.linkedin.com",
                        //"referer: https://www.linkedin.com/messaging/thread/" . $referer,
                        "x-restli-protocol-version: 2.0.0",
                        "x-li-lang: en_US"
                    )
                ));
                $resMessage = curl_exec($curlMessage);
                print_r($resMessage);
                //exit; 
                $header_size = curl_getinfo($curlMessage, CURLINFO_HEADER_SIZE);
                $headers = substr($resMessage, 0, $header_size);
                $resMessage = substr($resMessage, $header_size);
                $http_code = curl_getinfo($curlMessage, CURLINFO_HTTP_CODE);
                if ($http_code == 200) {
                    foreach ($delblkidslist as $ur) {
                        //echo "UPDATE conversations SET isRead = '0' WHERE id ='" . $ur . "'";
                        $sqlUpdate_task = Yii::$app->db->createCommand("UPDATE conversations SET isRead = '0' WHERE id ='" . $ur . "'")->execute();
                    }
                    echo 'Success';
                } else {
                    echo 'Something Went Wrong!';
                    return false;
                }
            }
        }
    }

    // mark as read multi

    public function actionMultimarkread() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        if (isset($_POST['delblkidslist']) && $_POST['delblkidslist'] != '') {

            $delblkidslist = explode(',', $_POST['delblkidslist']);

            $unreadthreadArr = array();
            $payload = "";
            $pad = "";
            $entitiesPayload = '{"entities":{';
            $entitiesPayloadEnd = '}}';
            $threadIds = "";
            $threadPad = "";
			
			$queryUsr = new Query();
			$queryUsr->select('proxyIp, proxyPort, proxyUsername, proxyPassword, cookie, csrf ,userAgent')->from('user')->where(['id' => Yii::$app->session->get('userid')]);
			$usrData = $queryUsr->one();
			$csrf = $usrData['csrf'];
			$cookie = $usrData['cookie'];
			$proxyIp = $usrData['proxyIp'];
			$proxyPort = $usrData['proxyPort'];
			$proxyUsername = $usrData['proxyUsername'];
			$proxyPassword = $usrData['proxyPassword'];
			$userAgent = $usrData['userAgent'];
			
            if (count($delblkidslist) > 0) {
				$userId = Yii::$app->session->get('userid');
                foreach ($delblkidslist as $ur) {
                    //$sqltask = Yii::$app->db->createCommand("UPDATE conversations SET isRead = '0' WHERE id ='" . $ur . "'")->execute();
                    $threadidrow = Yii::$app->db->createCommand("SELECT threadId,personId FROM `conversations` WHERE `id` = '" . $ur . "'")->queryOne();
//echo $threadidrow['threadId'];exit;
					if(is_numeric($threadidrow['threadId'])){
						$pubIdentifierQuery = new Query();
						$pubIdentifier=$pubIdentifierQuery->select('url_publicIdentifier')->from('blacklist')->where(['userid' => $userId,'linkedinpublicid' => $threadidrow['personId']])->scalar();
						if(empty($pubIdentifier)){
							$pubIdentifier=$pubIdentifierQuery->select('url_publicIdentifier')->from('1stdegreedata')->where(['userId' => $userId,'linkedinpublicid' => $threadidrow['personId']])->scalar();
						}
						$curl = curl_init();
						curl_setopt_array($curl, array(
							CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/dash/profiles?q=memberIdentity&memberIdentity=".$pubIdentifier."&decorationId=com.linkedin.voyager.dash.deco.identity.profile.TopCardSecondaryData-35", 
							CURLOPT_RETURNTRANSFER => true,
							CURLOPT_ENCODING => "",
							CURLOPT_MAXREDIRS => 10,
							CURLOPT_TIMEOUT => 30,
							CURLOPT_HEADER => true,
							CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
							CURLOPT_HTTPPROXYTUNNEL => 1,
							CURLOPT_PROXY => "$proxyIp",
							CURLOPT_PROXYPORT => "$proxyPort",
							CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
							CURLOPT_CUSTOMREQUEST => "GET",
							CURLOPT_HTTPHEADER => array(
								"cookie: $cookie",
								"csrf-token: $csrf",
								"authority: www.linkedin.com",
								"User-Agent: $userAgent",
								"accept: application/vnd.linkedin.normalized+json+2.1",
								"Accept-Language: en-US,en;q=0.5",
								"Accept-Encoding: gzip, deflate, br",
								"x-li-lang: en_US",
								"x-restli-protocol-version: 2.0.0"
							)
						));
						$res = curl_exec($curl);
						if (curl_errno($curl)) {
							$error_msg = curl_error($curl);
							return false;
						} else {
							if (!empty($res)) {
								$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
								$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
								$headers = substr($res, 0, $header_size);
								$res = substr($res, $header_size);
								$convRes = json_decode($res);
								if($http_code == 200){
									$cArr = json_decode($res);			
									$d = $cArr->data->paging->total;
									$data = (array)$cArr->data;
									$e = (isset($data['*elements']))?$data['*elements']:array();
									
									$includeddata= $cArr->included;
									$merged = array();
									$entityUrn_Arr = array_column($includeddata, 'entityUrn');
									for($i2=0; $i2<count($e); $i2++) {
										$eukey = array_search($e[$i2],$entityUrn_Arr);
										if($eukey !==""){
											$temp = (object) array_merge((array)$e[$i2], (array)$includeddata[$eukey]);
											array_push($merged, $temp);
										}
									}
									$merge2=array();
									if(!empty($merged)){ 
										$e = $merged;
										for($i2=0; $i2<count($e); $i2++) {
											$mn=(array)$e[$i2];
											$primaryActionResolutionResult=(isset($mn['profileStatefulProfileActions']) && !empty($mn['profileStatefulProfileActions']))?(array)$mn['profileStatefulProfileActions']->primaryActionResolutionResult:'';
											$composeOption=(!empty($primaryActionResolutionResult))?$primaryActionResolutionResult['*composeOption']:"";
											if(!empty($composeOption)){
												$eukey = array_search($composeOption,$entityUrn_Arr);
												if($eukey !==""){
													$temp = (object) array_merge((array)$e[$i2], (array)$includeddata[$eukey]);
													array_push($merge2, $temp);
												}
											}
										}
									}
									if(!empty($merge2)){	
									$threadidrow['threadId']=(isset($merge2[0]->composeNavigationContext->recipientUrns[0]))?end(explode(':',$merge2[0]->composeNavigationContext->recipientUrns[0])):"";
									}
								}
							}
						}
					} 
					//echo $threadidrow['threadId'];exit;
                    $threadIds .= $threadPad . $threadidrow['threadId'];
                    $threadPad = ",";
                    $threadId = str_replace('%3D%3D', '==', $threadidrow['threadId']);
                    $payload .= $pad . '"' . $threadId . '"' . ":{\"patch\":{\"\$set\":{\"read\":true}}}";
                    $pad = ",";
                }
			//exit; 
                $readUnreadyPayload = $entitiesPayload . $payload . $entitiesPayloadEnd;

                //echo $readUnreadyPayload; exit;
                //echo "https://www.linkedin.com/voyager/api/messaging/conversations?ids=List(".$threadIds.")";
                //exit; 

                //echo "https://www.linkedin.com/voyager/api/messaging/conversations?ids=List(".$threadIds.")";
                //echo "<br>".$readUnreadyPayload;exit;
                //echo '<pre>'; print_r($usrData); exit;
                //$readStatus=(isset($isRead) && !empty($isRead))? 'false' :'true';	
                //$payload = "{\"patch\":{\"\$set\":{\"read\":".$readStatus."}}}";
				//echo $threadIds;exit; 
                $curlMessage = curl_init();
                curl_setopt_array($curlMessage, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/messaging/conversations?ids=List(" . $threadIds . ")",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_HEADER => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_POSTFIELDS => $readUnreadyPayload,
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "authority:www.linkedin.com",
                        //"scheme:https",
                        "Accept: application/vnd.linkedin.normalized+json+2.1",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "Content-Length: " . strlen($readUnreadyPayload),
                        "Content-Type: application/json; charset=UTF-8",
                        "x-li-lang: en_US",
                        "user-agent: $userAgent",
                        "origin: https://www.linkedin.com",
                        //"referer: https://www.linkedin.com/messaging/thread/" . $threadId,
                        "x-restli-protocol-version: 2.0.0",
                        "x-li-lang: en_US"
                    )
                ));
                $resMessage = curl_exec($curlMessage);
                //print_r($resMessage);
                //exit; 
                $header_size = curl_getinfo($curlMessage, CURLINFO_HEADER_SIZE);
                $headers = substr($resMessage, 0, $header_size);
                $resMessage = substr($resMessage, $header_size);
                $http_code = curl_getinfo($curlMessage, CURLINFO_HTTP_CODE); 
                if ($http_code == 200 || $http_code ==204 || $http_code == 500) {
                    foreach ($delblkidslist as $ur) {
                        //echo "UPDATE conversations SET isRead = '1' WHERE id ='" . $ur . "'";
                        $sqlUpdate_task = Yii::$app->db->createCommand("UPDATE conversations SET isRead = '1' WHERE id ='" . $ur . "'")->execute();
                    }
                    echo 'Success';
                } else {
                    echo 'Something went wrong!';
                    return false;
                }
            }
        }
    }

    public function actionGetusertaglist() {

        $userid = Yii::$app->session->get('userid');
        $tagsdata = Yii::$app->db->createCommand("select  tagName,id from  tags  where userId=" . $userid)->queryAll();
        if (!empty($tagsdata)) {
            $options = '<option value="">Select Tags</option>';
            foreach ($tagsdata as $trow) {
                $options .= '<option value="' . $trow['id'] . '">' . $trow['tagName'] . '</option>';
            }
            echo $options;
        }
    }

}
