<?php

namespace app\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\db\Query;

class PipedriveController extends Controller {

    public $enableCsrfValidation = false;

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions() {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    //Developed by Ankit Sevak
    /**
     * Displays homepage.
     *
     * @return string
     */
    public function beforeAction($action) {
        if (empty(Yii::$app->session->get('userid'))) {
            $loginUrl = Yii::$app->request->baseUrl . "/login";
            return $this->redirect($loginUrl);
        }
        return parent::beforeAction($action);
    }

    public function actionIndex() {

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }
		
		include '../api/pipedrive/pipedrive-config.php';
		
		if(empty(Yii::$app->request->post())){
			$ownersArr = array();
			$stagesArr = array();
			
			$keyDetail = Yii::$app->db->createCommand("select * from  intigration  where user_id =" . Yii::$app->session->get('userid'))->queryOne();
			if(!empty($keyDetail) && isset($keyDetail['access_key'])){
				$dtls = (array)json_decode($keyDetail['access_key']);
				if(isset($dtls['pipedrive_api_key']) && !empty($dtls['pipedrive_api_key'])){
					$client = new \Pipedrive\Client(null, null, null, $dtls['pipedrive_api_key']);
					try {
						$users = $client->getUsers();
						$usrs = $users->getAllUsers();
						if(isset($usrs->success) && $usrs->success == 1){
							if(isset($usrs->data) && !empty($usrs->data)){
								$p=0;
								foreach($usrs->data as $dt){
									$ownersArr[$p]['id'] = $dt->id;
									$ownersArr[$p]['name'] = $dt->name . ' (' . $dt->email . ')';
									$p++;
								}
							}
						}
					} catch (\Pipedrive\APIException $e) {
						// Invalid API key
					}
					
					try {
						$stages = $client->getStages();
						$stgs = $stages->getAllStages(0);
						if(isset($stgs->success) && $stgs->success == 1){
							if(isset($stgs->data) && !empty($stgs->data)){
								$p=0;
								foreach($stgs->data as $dt){
									$stagesArr[$p]['id'] = $dt->id;
									$stagesArr[$p]['name'] = $dt->name;
									$p++;
								}
							}
						}
					} catch (\Pipedrive\APIException $e) {
						// Invalid API key
					}
				}
			}
		}
		
		if(!empty(Yii::$app->request->post())){
			$pipedrive_api_key = '';
			$pipedrive = 0;
			$pipedriveOwner = '';
			$pipedriveDefaultStage = '';
			$pipedriveContactPrivacy = '3';
			$ownersArr = array();
			$stagesArr = array();
			
			if(!empty(Yii::$app->request->post('pipedrive_api_key'))){

				$client = new \Pipedrive\Client(null, null, null, Yii::$app->request->post('pipedrive_api_key'));
				try {
					// For custom fields
					$personFields = $client->getPersonFields();
					$prsnFlds = $personFields->getAllPersonFields();

					if(isset($prsnFlds->success) && $prsnFlds->success == 1){
						$pipedriveFlds = $prsnFlds->data;
						if(isset($prsnFlds->data) && !empty($prsnFlds->data)){
							$pipedriveFldsArr = array();
							foreach($prsnFlds->data as $dt){
								$pipedriveFldsArr[] = $dt->name;
								if(isset($data[$dt->name])){
									$data[$dt->key] = $data[$dt->name];
									unset($data[$dt->name]);
								}		
							}
						}
						$customFields = array('linkedin_uid', 'linkedin', 'jobtitle', 'contact_source', 'contact_assigned_by', 'sequence_name', 'website');
						$fieldsToAdd = array_diff($customFields, $pipedriveFldsArr);

						if(!empty($fieldsToAdd)){
							foreach($fieldsToAdd as $newFld){
								$fieldToAdd = array('name' => $newFld, 'field_type' => 'varchar');
								$personFields->addANewPersonField($fieldToAdd);
							}
						}
					}
					$pipedrive_api_key = Yii::$app->request->post('pipedrive_api_key');
					$pipedrive = Yii::$app->request->post('pipedrive');
					
					// For owners
					$users = $client->getUsers();
					$usrs = $users->getAllUsers();
					if(isset($usrs->success) && $usrs->success == 1){
						if(isset($usrs->data) && !empty($usrs->data)){
							$q=0;
							foreach($usrs->data as $dt){
								$ownersArr[$q]['id'] = $dt->id;
								$ownersArr[$q]['name'] = $dt->name . ' (' . $dt->email . ')';
								$q++;
							}
						}
					}
					
					if(!empty(Yii::$app->request->post('pipedriveOwnerId'))){
						$pipedriveOwner = Yii::$app->request->post('pipedriveOwnerId');
					}else{
						$pipedriveOwner = $ownersArr[0]['id'];
					}
					
					//For stages
					$stages = $client->getStages();
					$stgs = $stages->getAllStages(0);
					if(isset($stgs->success) && $stgs->success == 1){
						if(isset($stgs->data) && !empty($stgs->data)){
							$q=0;
							foreach($stgs->data as $dt){
								$stagesArr[$q]['id'] = $dt->id;
								$stagesArr[$q]['name'] = $dt->name;
								$q++;
							}
						}
					}
					
					if(!empty(Yii::$app->request->post('pipedriveDefaultStage'))){
						$pipedriveDefaultStage = Yii::$app->request->post('pipedriveDefaultStage');
					}else{
						$pipedriveDefaultStage = $stagesArr[0]['id'];
					}
					
					Yii::$app->session->set('success_message', 'Settings have been saved successfully.');
				} catch (\Pipedrive\APIException $e) {
					Yii::$app->session->set('error_message', 'Looks like you have entered invalid API key or you don\'t have enough permissions.');
				}
			}else{
				$pipedrive_api_key = Yii::$app->request->post('pipedrive_api_key');
				$pipedrive = Yii::$app->request->post('pipedrive');
				if(!empty(Yii::$app->request->post('pipedriveOwnerId'))){
					$pipedriveOwner = Yii::$app->request->post('pipedriveOwnerId');
				}else{
					$pipedriveOwner = '';
				}
				
				if(!empty(Yii::$app->request->post('pipedriveDefaultStage'))){
					$pipedriveDefaultStage = Yii::$app->request->post('pipedriveDefaultStage');
				}else{
					$pipedriveDefaultStage = '';
				}
				Yii::$app->session->set('success_message', 'Settings have been saved successfully.');
			}
			
			if(!empty(Yii::$app->request->post('pipedriveContactPrivacy'))){
				$pipedriveContactPrivacy = Yii::$app->request->post('pipedriveContactPrivacy');
			}
			
			$keyDetail = Yii::$app->db->createCommand("select * from  intigration  where user_id =" . Yii::$app->session->get('userid'))->queryOne();
			if(!empty($keyDetail) && isset($keyDetail['access_key'])){
				$details = (array)json_decode($keyDetail['access_key']);
				$details['pipedrive_api_key']=$pipedrive_api_key;
				$details['pipedrive']=$pipedrive;
				$details['pipedriveOwner']=$pipedriveOwner;
				$details['pipedriveDefaultStage']=$pipedriveDefaultStage;
				$details['pipedriveContactPrivacy']=$pipedriveContactPrivacy;
				Yii::$app->db->createCommand("UPDATE `intigration` SET access_key='" . json_encode($details) . "' WHERE user_id = '". Yii::$app->session->get('userid') ."'")->execute();
			}else{
				$details = array();
				$details['pipedrive_api_key']=$pipedrive_api_key;
				$details['pipedrive']=$pipedrive;
				$details['pipedriveOwner']=$pipedriveOwner;
				$details['pipedriveDefaultStage']=$pipedriveDefaultStage;
				$details['pipedriveContactPrivacy']=$pipedriveContactPrivacy;
				Yii::$app->db->createCommand("INSERT INTO `intigration` SET user_id = '". Yii::$app->session->get('userid') ."', access_key='" . json_encode($details) . "'")->execute();
			}
		}
		
		$keyDetail = Yii::$app->db->createCommand("select * from  intigration  where user_id =" . Yii::$app->session->get('userid'))->queryOne();
        return $this->render('index', ['keyDetail' => $keyDetail, 'owners' => $ownersArr, 'stages' => $stagesArr]);
    }
}