<?php

namespace app\controllers;

use Yii;
use app\models\MyTemplateModel;
use app\models\User;
use app\models\MyTemplateSearchModel;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Blacklist;
use yii\data\Pagination;
use app\models\BlacklistSearch;
use yii\db\Query;

require '../vendor/autoload.php';

use Aws\S3\S3Client;
use Aws\DynamoDb\DynamoDbClient;
use Aws\Sqs\SqsClient;

//NR 30Apr2020 starts
include ('../phpseclib/vendor/autoload.php');
$loader = new \Composer\Autoload\ClassLoader();

use phpseclib\Net\SSH2;
use phpseclib\Crypt\RSA;

//NR 30Apr2020 ends
/**
 * MyTemplateController implements the CRUD actions for MyTemplateModel model.
 */
class MyTemplatenewController extends Controller {

    /**
     * @inheritdoc
     */
    public $enableCsrfValidation = false;

    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    public function unicodeString($str, $encoding = null) {
        if (is_null($encoding))
            $encoding = ini_get('mbstring.internal_encoding');
        return preg_replace_callback('/u([0-9a-fA-F]{4})/u', function($match) use ($encoding) {
            return mb_convert_encoding(pack('H*', $match[1]), $encoding, 'UTF-16BE');
        }, $str);
    }

    /**
     * Lists all MyTemplateModel models.
     * @return mixed
     */
    public function actionIndex() {
		
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }



        $searchModel = new MyTemplateSearchModel();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        // print_r(count($temptdata));exit;
        //   print_r($Yii::$app->session->get('userid'));

        /* return $this->render('index', [
          'searchModel' => $searchModel,
          'dataProvider' => $dataProvider,
          ]); */

        if (isset($_GET['searchname']) && $_GET['searchname'] != "") {
            $name = $_GET['searchname'];
            $pages = new Pagination(['totalCount' => count($dataProvider->query->all())]);
            $models = $dataProvider->query->offset($pages->offset)
                            ->where("templatename LIKE '%" . $name . "%' OR template LIKE '%" . $name . "%'")
                            ->andWhere(['teamid' => Yii::$app->session->get('userid')])
                            ->orWhere("sharewith LIKE '%" . Yii::$app->session->get('userid') . "%'")
                            ->limit($pages->limit)
                            ->orderBy(['templateid' => SORT_DESC])->all();
        } else {
            $pages = new Pagination(['totalCount' => count($dataProvider->query->all())]);
            $models = $dataProvider->query->offset($pages->offset)
                    ->where(['teamid' => Yii::$app->session->get('userid')])
                    ->orWhere("sharewith LIKE '%" . Yii::$app->session->get('userid') . "%'")
                    ->limit($pages->limit)
                    ->orderBy(['templateid' => SORT_DESC])
                    ->all();
//            echo $models->createCommand()->getRawSql();
//            exit;
        }
        $userid = Yii::$app->session->get('userid');
        $teamid = Yii::$app->session->get('teamid');
        $SubuserDetail = Yii::$app->db->createCommand("select  id,first_name,last_name,email,user_role,teamid  from  user  where id!=" . $userid . " and  is_deleted='0' and teamid =" . $teamid)->queryAll();

        return $this->render('index', [
                    'temptdata' => $models,
                    'SubuserDetail' => $SubuserDetail,
                    'pages' => $pages,
        ]);
    }

    public function actionSharetemplate() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $templateid = Yii::$app->request->post('id');
        $userids = Yii::$app->request->post('userids');
        if (Yii::$app->db->createCommand("UPDATE `templates` SET `sharewith` = '" . $userids . "' WHERE  `templateid` = '" . $templateid . "'")->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function actionGetteam() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $userid = Yii::$app->session->get('userid');
        $teamid = Yii::$app->session->get('teamid');
        $templateid = Yii::$app->request->post('id');
        $templateDetail = Yii::$app->db->createCommand("select  sharewith  from  templates  where templateid='$templateid'")->queryOne();
        if (!empty($templateDetail)) {
            return $templateDetail['sharewith'];
        } else {
            return false;
        }
    }

    public function actionViewtemplate() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $userid = Yii::$app->session->get('userid');
        $teamid = Yii::$app->session->get('teamid');
        $templateid = Yii::$app->request->post('id');
        $templateDetail = Yii::$app->db->createCommand("select  template  from  templates  where templateid='$templateid'")->queryOne();
        if (!empty($templateDetail)) {
            return nl2br($templateDetail['template']);
        } else {
            return false;
        }
    }

    public function actionClonetemplate() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $userid = Yii::$app->session->get('userid');
        $templateid = Yii::$app->request->post('id');
        $templateDetail = Yii::$app->db->createCommand("select  templatename,template  from  templates  where templateid='$templateid'")->queryOne();

        $templatename = $templateDetail['templatename'] . " Copy";
        $template = $templateDetail['template'];
        $sqlbulktask = Yii::$app->db->createCommand("INSERT INTO `templates`(`templatename`,`template`,`teamid`) VALUES ('" . $templatename . "','" . addslashes($template) . "','" . $userid . "')")->execute();

        return true;
    }

    // test new dashboard
    public function actionNewdashboard() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        return $this->render('newdashboard');
    }

    // end

    public function actionDashboard() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $SubuserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid'))->queryAll();

        //$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $time = new \DateTime('now');
        $today = $time->format('Y-m-d');
        $month = $time->format('Y-m-01');
        $userid = Yii::$app->session->get('userid');
        /* $result = [];
          $result['allReq'] = count(Blacklist::find()->select('id')->where(['=', 'teamid', Yii::$app->session->get('teamid')])->andWhere(['!=', 'seq_id', 0])->all());
          $result['allMonth'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $month], ['=', 'teamid', Yii::$app->session->get('teamid')]])->andWhere(['!=', 'seq_id', 0])->all());
          $result['allToday'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $today], ['=', 'teamid', Yii::$app->session->get('teamid')]])->andWhere(['!=', 'seq_id', 0])->all());



          $result['allMyToday'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $today], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
          $result['allMyMonth'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $month], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
          $result['allMy'] = count(Blacklist::find()->select('id')->where(['and', ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());



          $result['allMyAcceptedToday'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $today], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_accepted', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
          $result['allMyAcceptedMonth'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $month], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_accepted', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
          $result['allMyAccepted'] = count(Blacklist::find()->select('id')->where(['and', ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_accepted', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());

          $result['allMyRespondedToday'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $today], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_response', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
          $result['allMyRespondedMonth'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $month], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_response', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
          $result['allMyResponded'] = count(Blacklist::find()->select('id')->where(['and', ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_response', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all()); */


        $ssiData = array();
        $ssiHistoryData = array();
        $UserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid') . " AND id =" . Yii::$app->session->get('userid'))->queryOne();
        //if(Yii::$app->session->get('userid')=='16258'){
        $UserProfileDetail = Yii::$app->db->createCommand("select  *  from  user_profile  where user_id =" . Yii::$app->session->get('userid'))->queryOne();
        if (!empty($UserProfileDetail)) {
            if (!empty($UserProfileDetail['ssiData'])) {
                $ssiDataArr = json_decode($UserProfileDetail['ssiData']);

                $ssiData['memberScore_overall'] = $ssiDataArr->memberScore_overall; //44.64;
                $ssiData['valProfessionalBrand'] = $ssiDataArr->valProfessionalBrand; //5.75;
                $ssiData['valFindRightPeople'] = $ssiDataArr->valFindRightPeople; //17.28;
                $ssiData['valInsightEngagement'] = $ssiDataArr->valInsightEngagement; //8.03;
                $ssiData['valStrongRelationship'] = $ssiDataArr->valStrongRelationship; //13.58;				
            }

            if (!empty($UserProfileDetail['ssiHistoryData'])) {
                $ssiHistoryData = json_decode($UserProfileDetail['ssiHistoryData']);
            }
        }



        return $this->render('dashboard', [
                    'SubuserDetail' => $SubuserDetail,
                    //'report' => $result,
                    'ssiData' => $ssiData,
                    'ssiHistoryData' => $ssiHistoryData,
                    'UserDetail' => $UserDetail
                        // 'dataProvider' => $dataProvider,
        ]);
    }

    //26-Nov-2020 working
    public function actionDashboardNrtesting() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $SubuserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid'))->queryAll();

        //$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $time = new \DateTime('now');
        $today = $time->format('Y-m-d');
        $month = $time->format('Y-m-01');
        $userid = Yii::$app->session->get('userid');
        $result = [];
        //$result['allReq'] = count(Blacklist::find()->select('id')->where(['=', 'teamid', Yii::$app->session->get('teamid')])->all());
        $result['allReq'] = count(Blacklist::find()->select('id')->where(['=', 'teamid', Yii::$app->session->get('teamid')])->andWhere(['!=', 'seq_id', 0])->all());
        $result['allMonth'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $month], ['=', 'teamid', Yii::$app->session->get('teamid')]])->andWhere(['!=', 'seq_id', 0])->all());
        $result['allToday'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $today], ['=', 'teamid', Yii::$app->session->get('teamid')]])->andWhere(['!=', 'seq_id', 0])->all());



        $result['allMyToday'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $today], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
        $result['allMyMonth'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $month], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
        $result['allMy'] = count(Blacklist::find()->select('id')->where(['and', ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());



        $result['allMyAcceptedToday'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $today], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_accepted', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
        $result['allMyAcceptedMonth'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $month], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_accepted', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
        $result['allMyAccepted'] = count(Blacklist::find()->select('id')->where(['and', ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_accepted', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());

        $result['allMyRespondedToday'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $today], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_response', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
        $result['allMyRespondedMonth'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $month], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_response', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
        $result['allMyResponded'] = count(Blacklist::find()->select('id')->where(['and', ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_response', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());


        $ssiData = array();
        $ssiHistoryData = array();
        $UserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid') . " AND id =" . Yii::$app->session->get('userid'))->queryOne();
        //if(Yii::$app->session->get('userid')=='16258'){
        $UserProfileDetail = Yii::$app->db->createCommand("select  *  from  user_profile  where user_id =" . Yii::$app->session->get('userid'))->queryOne();
        if (!empty($UserProfileDetail)) {
            if (!empty($UserProfileDetail['ssiData'])) {
                $ssiDataArr = json_decode($UserProfileDetail['ssiData']);

                $ssiData['memberScore_overall'] = $ssiDataArr->memberScore_overall; //44.64;
                $ssiData['valProfessionalBrand'] = $ssiDataArr->valProfessionalBrand; //5.75;
                $ssiData['valFindRightPeople'] = $ssiDataArr->valFindRightPeople; //17.28;
                $ssiData['valInsightEngagement'] = $ssiDataArr->valInsightEngagement; //8.03;
                $ssiData['valStrongRelationship'] = $ssiDataArr->valStrongRelationship; //13.58;				
            }

            if (!empty($UserProfileDetail['ssiHistoryData'])) {
                $ssiHistoryData = json_decode($UserProfileDetail['ssiHistoryData']);
            }
        }



        return $this->render('dashboard_nrtesting', [
                    'SubuserDetail' => $SubuserDetail,
                    'report' => $result,
                    'ssiData' => $ssiData,
                    'ssiHistoryData' => $ssiHistoryData,
                    'UserDetail' => $UserDetail
                        // 'dataProvider' => $dataProvider,
        ]);
    }

    //27-11-2020
    public function actionAjxrefreshssi() {
        //include('../web/updateLinkedInCookie.php');
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $final_result = array();
        $final_result['success'] = 0;


        $UserDetail = Yii::$app->db->createCommand("select  *  from  user  where id =" . Yii::$app->session->get('userid') . " and popupstatus='1'")->queryOne();
        if (!empty($UserDetail)) {


            $user_id = $UserDetail['id'];
            $proxyIp = $UserDetail['proxyIp'];
            $proxyPort = $UserDetail['proxyPort'];
            $proxyUsername = $UserDetail['proxyUsername'];
            $proxyPassword = $UserDetail['proxyPassword'];
            $userAgent = $UserDetail['userAgent'];
            $cookie = $UserDetail['cookie'];
            $csrf = $UserDetail['csrf'];

            if ($proxyIp && $proxyPort && $proxyUsername && $proxyPassword && !empty($cookie) && !empty($csrf)) {

                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://www.linkedin.com/sales-api/salesApiSsi",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $curlResult = curl_exec($curl);
                $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                $headers = substr($curlResult, 0, $header_size);

                $curlResult = substr($curlResult, $header_size);

                if (!empty($curlResult)) {
                    $decodedRes = json_decode($curlResult);
                    //echo 'E:<pre>'; print_r($decodedRes);
                    $ssiData = array();
                    $ssiData['memberScore_overall'] = $decodedRes->memberScore->overall; //44.64;//
                    $ssiData['valProfessionalBrand'] = $decodedRes->memberScore->subScores[0]->score; //5.75;//
                    $ssiData['valFindRightPeople'] = $decodedRes->memberScore->subScores[1]->score; //17.28;//
                    $ssiData['valInsightEngagement'] = $decodedRes->memberScore->subScores[2]->score; //8.03;//
                    $ssiData['valStrongRelationship'] = $decodedRes->memberScore->subScores[3]->score; //13.58;//

                    $final_result['success'] = 1;
                    $final_result['ssiData'] = $ssiData;

                    $ssiStr = json_encode($ssiData);
                    $ssiLastUpdated = date('Y-m-d H:i:s');


                    //Yii::$app->db->createCommand("UPDATE `user_profile` SET `ssiData` = '".addslashes($ssiStr)."', `ssiLastUpdated` = '".$ssiLastUpdated."' WHERE `user_id` =".$user_id)->execute();
                }
            }
        }

        return json_encode($final_result);
    }

    public function actionExportchartdata() {
        $s_date = implode('-', array_reverse(explode('/', $_POST['cstart_date'])));
        $e_date = implode('-', array_reverse(explode('/', $_POST['cend_date'])));
        $userid = Yii::$app->session->get('userid');

        $res_arr = array();
        $rep_req_data = Yii::$app->db->createCommand("SELECT COUNT(id) as request, CAST(created_at AS DATE) as created_at FROM blacklist WHERE (DATE(created_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . Yii::$app->session->get('teamid') . "' AND userid = '" . $userid . "' AND seq_id != '0' GROUP BY CAST(created_at AS DATE)")->queryAll();

        $rep_acc_data = Yii::$app->db->createCommand("SELECT COUNT(id) as accepted, CAST(created_at AS DATE) as created_at FROM blacklist WHERE (DATE(created_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . Yii::$app->session->get('teamid') . "' AND is_accepted = 1 AND userid = '" . $userid . "' AND seq_id != '0' GROUP BY CAST(created_at AS DATE)")->queryAll();

        $rep_res_data = Yii::$app->db->createCommand("SELECT COUNT(id) as responded, CAST(created_at AS DATE) as created_at FROM blacklist WHERE (DATE(created_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . Yii::$app->session->get('teamid') . "' AND is_response = 1 AND userid = '" . $userid . "' AND seq_id != '0' GROUP BY CAST(created_at AS DATE)")->queryAll();
        //echo "<pre>";print_r($rep_acc_data);die;

        $dates = $this->getallDates($s_date, $e_date);
        $k = 0;
        foreach ($dates as $date_v) {
            $arr = [];
            $rkey = '';
            $akey = '';
            $reqkey = '';

            $reqkey = array_search($date_v, array_column($rep_req_data, 'created_at'));
            $rkey = array_search($date_v, array_column($rep_res_data, 'created_at'));
            $akey = array_search($date_v, array_column($rep_acc_data, 'created_at'));

            if ($rkey !== false && $reqkey !== false && $akey !== false) {
                $arr['res'] = $rep_res_data[$rkey]['responded'];
                $arr['acc'] = $rep_acc_data[$akey]['accepted'];
                $arr['req'] = $rep_req_data[$reqkey]['request'];
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($rkey !== false && $reqkey !== false && $akey === false) {
                $arr['res'] = $rep_res_data[$rkey]['responded'];
                $arr['acc'] = 0;
                $arr['req'] = $rep_req_data[$reqkey]['request'];
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($rkey !== false && $reqkey === false && $akey !== false) {
                $arr['res'] = $rep_res_data[$rkey]['responded'];
                $arr['acc'] = $rep_acc_data[$akey]['accepted'];
                $arr['req'] = 0;
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($rkey === false && $reqkey !== false && $akey !== false) {
                $arr['res'] = 0;
                $arr['acc'] = $rep_acc_data[$akey]['accepted'];
                $arr['req'] = $rep_req_data[$reqkey]['request'];
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($reqkey !== false && $akey === false && $rkey === false) {
                $arr['req'] = $rep_req_data[$reqkey]['request'];
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $arr['res'] = 0;
                $arr['acc'] = 0;
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($rkey !== false && $akey === false && $reqkey === false) {
                $arr['res'] = $rep_res_data[$rkey]['responded'];
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $arr['req'] = 0;
                $arr['acc'] = 0;
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($akey !== false && $rkey === false && $reqkey === false) {
                $arr['acc'] = $rep_acc_data[$akey]['accepted'];
                $arr['date'] = date('d/m/Y', strtotime($date_v));
                $arr['res'] = 0;
                $arr['req'] = 0;
                $res_arr[$k] = $arr;
                $k++;
            }
        }

        $data = ",,,," . Yii::$app->params['sitetitle'] . " Export data (" . $_POST['cstart_date'] . " - " . $_POST['cend_date'] . ") \r\n\r\nDate,Sent,Accepted,Response\r\n";

        foreach ($res_arr as $res) {

            $data .= $res['date'] .
                    ',' . $res['req'] .
                    ',' . $res['acc'] .
                    ',' . $res['res'] .
                    "\r\n";
        }

        header("Content-type: text/csv");
        header("Content-Disposition: attachment; filename=" . Yii::$app->params['sitetitle'] . ".csv");
        header("Content-Transfer-Encoding: ASCII\r\n");
        header("Pragma: no-cache");
        header("Expires: 0");

        echo $data . "\n";
        die;
    }

    // Ravi Bhuva Code Start --- 17-dec2019
    public function actionGetstepdata() {
        $session = Yii::$app->session;
        $session->get('userid');
        $stepsHtml = "";
        $query = new Query;
        $model = $query->select(['profile_steps.totalsteps', 'profile_steps.steps', 'sequences.local_seq_step'])
                ->from('profile_steps')
                ->leftJoin('sequences', 'profile_steps.seq_id = sequences.id')
                ->where(['profile_steps.linkedinpublicid' => $this->decode($_POST['linkedinpublicid']), 'profile_steps.userid' => $session->get('userid')])
                ->one();
//        echo $query->createCommand()->getRawSql();exit;
//        echo "<pre>";
//        print_r($model);exit;

        $query_profile = new Query;
        $model_profile = $query_profile->select(['basicInfo'])
                ->from('profileinfo')
                ->where(['id' => $this->decode($_POST['profileInfo_id'])])
                ->one();
//         echo $query_profile->createCommand()->getRawSql();
//        echo "<pre>";
//        print_r($model_profile);exit;

        $proinfo2 = preg_replace('/\s+/', ' ', $model_profile['basicInfo']);
        $proinfo2 = str_replace("'", "", $proinfo2);

        $profileInfo = json_decode($proinfo2);
//        echo $profileInfo->firstName;exit;
//        print_r($profileInfo);exit;
        $stepsHtml = '<ul>';
        $class = "";

        $proinfo_data = preg_replace('/\s+/', ' ', $model['local_seq_step']);
        $proinfo_data = str_replace("'", "", $proinfo_data);



        $proinfo_data = preg_replace_callback('#([^{:]*):([^,}]*)#i', function( $match ) {
            $key = trim($match[1]);
            $val = trim($match[2]);
            if ($val[0] == '"') {
                $val = '"' . addslashes(substr($val, 1, -1)) . '"';
                $position = stripos($val, '"', 1);
                $position_2 = stripos($val, 'fallback', 1);
                if ($position > 0 && $key == ',"message"' && $position_2 > 0) {
                    $val = str_replace('"', '\"', stripslashes($val));
                    $val = ltrim($val, "\\");
                }
            } else if ($val[0] == "'") {
                $val = "'" . addslashes(substr($val, 1, -1)) . "'";
            }
            return $key . ": " . $val;
        }, $proinfo_data);
        $userdb = json_decode($proinfo_data, true);
//        print_r($userdb);exit;

        $j = 0;
        for ($i = 1; $i <= $model['totalsteps']; $i++) {
            if ($model['steps'] == $i) {
                $class = 'class="active"';
            } else {
                $class = '';
            }
            if ($model['steps'] >= $i) {
                if (isset($profileInfo->firstName)) {
                    $title_firstname = preg_replace('/\{\s*first\s*name\s*\|\s*(.*?)\}/', $profileInfo->firstName, $userdb[$i - 1]['message']);
                } else {
                    $title_firstname = $userdb[$i - 1]['message'];
                }
                if (isset($profileInfo->lastName)) {
                    $title_lastname = preg_replace('/\{\s*last\s*name\s*\|\s*(.*?)\}/', $profileInfo->lastName, $title_firstname);
                } else {
                    $title_lastname = $title_firstname;
                }
                if (isset($profileInfo->firstName)) {
                    $title_fullname = preg_replace('/\{\*full\s*name\s*\|\s*(.*?)\}/', $profileInfo->firstName . ' ' . $profileInfo->lastName, $title_lastname);
                } else {
                    $title_fullname = $title_lastname;
                }
                if (isset($profileInfo->industryName)) {
                    $title_industries = preg_replace('/\{\s*indu\s*stries\s*\|\s*(.*?)\}/', $profileInfo->industryName, $title_fullname);
                } else {
                    $title_industries = $title_fullname;
                }
                if (isset($profileInfo->locationName)) {
                    $title_location = preg_replace('/\{\s*loca\s*tion\s*\|\s*(.*?)\}/', $profileInfo->locationName, $title_industries);
                } else {
                    $title_location = $title_industries;
                }
                if (isset($profileInfo->companyName)) {
                    $title_company = preg_replace('/{\s*company\s*(\d+)\s*\|\s*(.*?)}/', $profileInfo->companyName, $title_location);
                } else {
                    $title_company = $title_location;
                }
//               $title_Education = preg_replace('/{\s*edu(?:cation)?\s*(\d+)\s*\|\s*(.*?)}/', $profileInfo->industryName, $title_company);
//                $title = $userdb[$i - 1]['message'];
//               echo $title_company;exit;
                $title = $title_company;
            } else {
                $title = '';
            }

            $stepsHtml .= '<li title="' . htmlentities($title) . '" ' . $class . '>' . $i . '</li>';
            $j++;
        }
        if ($j == 0) {
            $stepsHtml .= '<li title="' . htmlentities($title) . '" ' . $class . '>' . $i . '</li>';
        }
        $stepsHtml .= '</ul>';
        return $stepsHtml;
    }

    public function getStepsCount($linkedinpublicid, $userid, $seq_id) {
        //echo $linkedinpublicid."-".$userid."-".$seq_id."<br/>";
        $query = new Query;
        $model = $query->select(['totalsteps', 'steps', 'local_seq_step'])
                ->from('profile_steps')
                ->where(['linkedinpublicid' => $linkedinpublicid, 'userid' => $userid, 'seq_id' => $seq_id])
                ->count();
        return $model;
    }

    // Ravi Bhuva Code End --- 17-dec2019

    public function actionGetdonutchartdata() {
        $s_date = implode('-', array_reverse(explode('/', $_POST['s_date'])));
        $e_date = implode('-', array_reverse(explode('/', $_POST['e_date'])));
        $userid = Yii::$app->session->get('userid');

        // $rep_req_data = Yii::$app->db->createCommand("SELECT COUNT(id) as request FROM blacklist WHERE (DATE(created_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . Yii::$app->session->get('teamid') . "' AND userid = '" . $userid . "' AND seq_id != '0'")->queryAll();

        $rep_req_data = Yii::$app->db->createCommand("SELECT COUNT(id) as request FROM completed_tasks where (DATE(completedOn) BETWEEN '" . $s_date . "' AND '" . $e_date . "')  AND status = 'Complete' AND type = 'Connect' AND userId = " . $userid)->queryAll();

        $rep_acc_data = Yii::$app->db->createCommand("SELECT COUNT(id) as accepted FROM blacklist WHERE (DATE(created_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . Yii::$app->session->get('teamid') . "' AND is_accepted = 1 AND userid = '" . $userid . "' AND seq_id != '0'")->queryAll();

        $rep_res_data = Yii::$app->db->createCommand("SELECT COUNT(id) as responded FROM blacklist WHERE (DATE(created_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . Yii::$app->session->get('teamid') . "' AND is_response = 1 AND userid = '" . $userid . "' AND seq_id != '0'")->queryAll();

        $sqltottask = "SELECT COUNT(id) as performedtasks FROM completed_tasks where (DATE(completedOn) BETWEEN '" . $s_date . "' AND '" . $e_date . "')  AND status = 'Complete' AND userId = " . $userid;
        $rowstottask = Yii::$app->db->createCommand($sqltottask)->queryAll();

        $sqltotwithdrown = "SELECT COUNT(id) as totwithdrawn FROM completed_tasks where (DATE(completedOn) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND triggerOnInvitationAccepted = '1' AND status = 'Complete' AND userId = " . Yii::$app->session->get('userid');
        $rowstotwithdrown = Yii::$app->db->createCommand($sqltotwithdrown)->queryAll();

        $res_arr = array();

        if ($rep_acc_data[0]['accepted'] > 0 || $rep_res_data[0]['responded'] > 0 || $rep_req_data[0]['request']) {
            $space = '&nbsp;';
            $res_arr[] = array('label' => 'Total Accepted', 'value' => $rep_acc_data[0]['accepted']);
            $res_arr[] = array('label' => 'Total Response', 'value' => $rep_res_data[0]['responded']);
            $res_arr[] = array('label' => 'Total Sent', 'value' => $rep_req_data[0]['request']);
            $res_arr[] = array('label' => 'Total Task Performed', 'value' => $rowstottask[0]['performedtasks']);
            $res_arr[] = array('label' => 'Total Task Withdrawn', 'value' => $rowstotwithdrown[0]['totwithdrawn']);
        }

        echo json_encode($res_arr);
    }

    public function actionGetchartdata() {
        $s_date = implode('-', array_reverse(explode('/', $_POST['s_date'])));
        $e_date = implode('-', array_reverse(explode('/', $_POST['e_date'])));
        $userid = Yii::$app->session->get('userid');

        $res_arr = array();
        $rep_acc_data = Yii::$app->db->createCommand("SELECT COUNT(id) as accepted, CAST(created_at AS DATE) as created_at FROM blacklist WHERE (DATE(created_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . Yii::$app->session->get('teamid') . "' AND is_accepted = 1 AND userid = '" . $userid . "' AND seq_id != '0' GROUP BY CAST(created_at AS DATE)")->queryAll();

        $rep_res_data = Yii::$app->db->createCommand("SELECT COUNT(id) as responded, CAST(created_at AS DATE) as created_at FROM blacklist WHERE (DATE(created_at) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND teamid = '" . Yii::$app->session->get('teamid') . "' AND is_response = 1 AND userid = '" . $userid . "' AND seq_id != '0' GROUP BY CAST(created_at AS DATE)")->queryAll();
        //echo "<pre>";print_r($rep_acc_data);die;

        $dates = $this->getallDates($s_date, $e_date);
        $k = 0;
        foreach ($dates as $date_v) {
            $arr = [];
            $rkey = '';
            $akey = '';

            $rkey = array_search($date_v, array_column($rep_res_data, 'created_at'));
            $akey = array_search($date_v, array_column($rep_acc_data, 'created_at'));

            if ($rkey !== false && $akey !== false) {
                $arr['b'] = $rep_res_data[$rkey]['responded'];
                $arr['a'] = $rep_acc_data[$akey]['accepted'];
                $arr['y'] = date('d/m', strtotime($date_v));
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($rkey !== false && $akey === false) {
                $arr['b'] = $rep_res_data[$rkey]['responded'];
                $arr['y'] = date('d/m', strtotime($date_v));
                $arr['a'] = 0;
                $res_arr[$k] = $arr;
                $k++;
            } elseif ($akey !== false && $rkey === false) {
                $arr['a'] = $rep_acc_data[$akey]['accepted'];
                $arr['y'] = date('d/m', strtotime($date_v));
                $arr['b'] = 0;
                $res_arr[$k] = $arr;
                $k++;
            }/* else{
              $arr['a'] = 0;
              $arr['b'] = 0;
              $arr['y'] = $date_v;
              } */
        }

        echo json_encode($res_arr);
    }

    public function getallDates($s_date, $e_date) {
        $dates = array();

        $d1 = strtotime($s_date);
        $d2 = strtotime($e_date);

        for ($currentDate = $d1; $currentDate <= $d2; $currentDate += (86400)) {
            $date = date('Y-m-d', $currentDate);
            $dates[] = $date;
        }
        return $dates;
    }

    public function actionPricing() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }
        if (Yii::$app->params['portal_url'] == 'https://app.cloudkennect.com') {
            $url = \Yii::$app->request->baseUrl . "/payment";
            return $this->redirect($url);
        }

        $SubuserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid'))->queryAll();

        //$dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('pricing', [
                    'message' => '',
                        // 'dataProvider' => $dataProvider,
        ]);
    }

    public function actionBlackfriday() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }
        if (Yii::$app->params['portal_url'] == 'https://app.cloudkennect.com') {
            $url = \Yii::$app->request->baseUrl . "/payment";
            return $this->redirect($url);
        }

        $SubuserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid'))->queryAll();

        //$dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('blackfriday', [
                    'message' => '',
                        // 'dataProvider' => $dataProvider,
        ]);
    }

    public function actionPayment() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }

        $SubuserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid'))->queryAll();
        //$dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('payment', [
                    'message' => '',
                    'SubuserDetail' => $SubuserDetail,
                        // 'dataProvider' => $dataProvider,
        ]);
    }

    public function actionIrpricing() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }

        $SubuserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid'))->queryAll();
        //$dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('irpricing', [
                    'message' => '',
                    'SubuserDetail' => $SubuserDetail,
                        // 'dataProvider' => $dataProvider,
        ]);
    }

    public function actionRushlinqpayment() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }

        $SubuserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid'))->queryAll();
        //$dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('rushlinq_payment', [
                    'message' => '',
                    'SubuserDetail' => $SubuserDetail,
                        // 'dataProvider' => $dataProvider,
        ]);
    }

    public function actionProspect1() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        /* $searchModel = new BlacklistSearch();
          $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
          $dataProvider->query->andWhere(['userid' => Yii::$app->session->get('userid')]);
          $dataProvider->query->andWhere("profileView   IS NOT NULL  and profileView != ''limit 10");
         */


        //$model = new Blacklist();
        $blacklistDetail = Yii::$app->db->createCommand("select  id,created_at,profileView,profileContactInfo  from  blacklist  where userid ='" . Yii::$app->session->get('userid') . "' and profileView   IS NOT NULL  and profileView != ''");

        $count = $blacklistDetail->count();

        /* $blacklistDetail = Blacklist::find()->select('profileView,profileContactInfo')
          ->where('userid='.Yii::$app->session->get('userid'))
          ->andWhere(['not', ['profileView' => null]])
          ->all(); */

        return $this->render('prospect', [
                    'blacklistDetail' => $blacklistDetail,
                    'message' => '',
                        // 'dataProvider' => $dataProvider,
        ]);
    }

    public function actionProspect2() {
        $query = BlacklistSearch::find()->where(['userid' => Yii::$app->session->get('userid')])
                ->andWhere("profileView   IS NOT NULL  and profileView != ''");
        $countQuery = clone $query;
        $pages = new Pagination(['totalCount' => $countQuery->count()]);
        $models = $query->offset($pages->offset)
                ->limit($pages->limit)
                ->all();
        return $this->render('prospect', [
                    'blacklistDetail' => $models,
                    'pages' => $pages,
        ]);
    }

    public function actionProspect() {
		//print_r($_GET);exit;
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $addfilter = "";
		$filter="";
        $keyDetail = Yii::$app->db->createCommand("select access_key from  intigration  where user_id =" . Yii::$app->session->get('userid'))->queryOne();

        if (isset($_REQUEST['sequ_id']) && $_REQUEST['sequ_id'] != "") {
            $whereClause = " (FIND_IN_SET(".$_REQUEST['sequ_id'].",seq_id)) ";
        } else {
            $whereClause = "";
        }
        //for sorting in pagination starts
        if (isset($_GET['sortby']) && $_GET['sortby'] != '') {
            $sortby = $_GET['sortby'];
        } else {
            $sortby = 'b.id'; //default column
        }

        if (isset($_GET['sortorder']) && $_GET['sortorder'] != '') {
            if ($_GET['sortorder'] == 'asc') {
                $sortorder = SORT_ASC;
            } else {
                $sortorder = SORT_DESC;
            }
        } else {
            $sortorder = SORT_DESC; //default sort order
        }
        //for sorting in pagination ends

        $query = new Query;

        $fullNamewhereClause = "";
        $emailwhereClause = "";
		
		$fullname = "";
		$firstName = "";
		$lastName = "";
		$email = "";
		if (isset($_GET['prospectsearchname'])) {
			$fullname = explode(" ", trim($_GET['prospectsearchname']));
		}
		if (isset($_GET['search'])) {
			$fullname = explode(" ", trim($_GET['search']));
		}
		
		if (isset($fullname[0])) {
			$firstName = trim($fullname[0]);
		}
		if (isset($fullname[1])) {
			$lastName = trim($fullname[1]);
		}
		
		if (isset($_GET['prospectsearchname'])) {
			$email = $_GET['prospectsearchname'];
		}
		if (isset($_GET['search'])) {
			$email = $_GET['search'];
		}
		
		$tagIds = "";
        if (isset($_REQUEST['tag_id']) && $_REQUEST['tag_id'] != "") {
			$tagIds = $_REQUEST['tag_id'];
        }
		
		$seqIds = "";
        if (isset($_REQUEST['sequ_id']) && $_REQUEST['sequ_id'] != "") {
			$seqIds = $_REQUEST['sequ_id'];
        }
		
		$filter = "";
		if (isset($_GET['filterprama']) && !empty($_GET['filterprama']) ) {
			$filter=$_GET['filterprama'];
		}
		if (isset($_GET['filter']) && !empty($_GET['filter'])) {
			$filter=$_GET['filter'];
		}
		
		if($filter=="accpet"){
			$query->select([
				'b.id', 'b.linkedinpublicid', 'b.firstName', 'b.lastName', 'b.is_accepted', 'b.is_response', 'b.url_publicIdentifier', 'b.profileInfo_id', 'b.companyInfo_id', 'b.created_at', 'b.updated_at', 'b.seq_id', 'b.seq_name', 'p.basicInfo', 'p.contactInfo', 'c.company_li_id', 'c.company_page_url', 'c.company_detail', 'b.tags']
			)
			->from('blacklist b')
			->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
			->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')
			->where(['userid' => Yii::$app->session->get('userid')])
			->andWhere("profileInfo_id !=0  and companyInfo_id != 0 ")
			->andWhere("b.is_accepted= 1");
			if(!empty($tagIds)){
				$query->andWhere('FIND_IN_SET(:tag_id,tags)')
				->addParams([':tag_id' => $tagIds]);
			}
			if(!empty($seqIds)){
				$query->andWhere('b.seq_id='.$seqIds.'');
			}
			
			
			if(!empty($firstName)){
				$qry=" (basicInfo LIKE'%" . $firstName . "%' or ";
			}
			
			if(!empty($lastName)){
				$qry.="basicInfo LIKE'%" . $lastName . "%' or ";
			}
			if(!empty($email)){
				$qry.="contactInfo LIKE'%" . $email . "%') ";
			}
			
			if(!empty($qry)){
				$query->andWhere($qry);
			}
			
			$query->orderBy(['b.created_at' => SORT_DESC]);
			
		}elseif($filter=="pending"){
			$query->select([
				'b.id', 'b.linkedinpublicid', 'b.firstName', 'b.lastName', 'b.is_accepted', 'b.is_response', 'b.url_publicIdentifier', 'b.profileInfo_id', 'b.companyInfo_id', 'b.created_at', 'b.updated_at', 'b.seq_id', 'b.seq_name', 'p.basicInfo', 'p.contactInfo', 'c.company_li_id', 'c.company_page_url', 'c.company_detail', 'b.tags']
			)
			->from('blacklist b')
			->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
			->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')
			->where(['userid' => Yii::$app->session->get('userid')])
			->andWhere("profileInfo_id !=0  and companyInfo_id != 0 ")
			->andWhere("b.is_accepted= 0");
			if(!empty($tagIds)){
				$query->andWhere('FIND_IN_SET(:tag_id,tags)')
				->addParams([':tag_id' => $tagIds]);
			}
			if(!empty($seqIds)){
				$query->andWhere('b.seq_id='.$seqIds.'');
			}
			
			if(!empty($firstName)){
				$qry=" (basicInfo LIKE'%" . $firstName . "%' or ";
			}
			
			if(!empty($lastName)){
				$qry.="basicInfo LIKE'%" . $lastName . "%' or ";
			}
			if(!empty($email)){
				$qry.="contactInfo LIKE'%" . $email . "%') ";
			}
			
			if(!empty($qry)){
				$query->andWhere($qry);
			}
			
			$query->orderBy(['b.created_at' => SORT_DESC]);
			
		}elseif($filter=="responded"){
			$query1 = (new \yii\db\Query())
				->select('`b`.`profileInfo_id`, `b`.`companyInfo_id`, `b`.`id`, CONVERT(`b`.`linkedinpublicid` USING utf8) AS `linkedinpublicid`, CONVERT(`b`.`firstName` USING utf8) AS `firstName`, CONVERT(`b`.`lastName` USING utf8) AS `lastName`, `b`.`is_accepted`, `b`.`is_response`, CONVERT("" USING utf8) AS `emailID`, CONVERT("" USING utf8) AS `phoneNumbers`, CONVERT("" USING utf8) AS `locationName`, CONVERT(`b`.`url_publicIdentifier` USING utf8) AS `url_publicIdentifier`, `b`.`created_at`, `b`.`updated_at`, CONVERT(`b`.`seq_id` USING utf8) AS `seq_id`, CONVERT(`b`.`seq_name` USING utf8) AS `seq_name`, CONVERT(`b`.`tags` USING utf8) AS tags, `c`.`company_li_id`, CONVERT(`c`.`company_page_url` USING utf8) AS `company_page_url`, CONVERT(`c`.`company_detail` USING utf8) AS `company_detail`, CONVERT(`p`.`basicInfo` USING utf8) AS `basicInfo`, CONVERT(`p`.`contactInfo` USING utf8) AS `contactInfo`, CONVERT("" USING utf8) AS `occupation`,CONVERT("{}" USING utf8) AS `response`')
				->from('blacklist b')
				->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
				->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')
				->where(['b.userid' => Yii::$app->session->get('userid')])
				->andWhere("b.is_response= 1");
 
			$query2 = (new \yii\db\Query())
				->select('0 as `profileInfo_id`, 0 as `companyInfo_id`, `st`.`id`, CONVERT(`st`.`linkedinpublicid` USING utf8) AS `linkedinpublicid`, CONVERT(`st`.`fullname` USING utf8) AS `firstName`, CONVERT("" USING utf8) AS `lastName`, 0 as `is_accepted`, 0 as `is_response`, CONVERT(`st`.`emailID` USING utf8) AS `emailID`, CONVERT(`st`.`phoneNumbers` USING utf8) AS `phoneNumbers`, CONVERT(`st`.`locationName` USING utf8) AS `locationName`, CONVERT(`st`.`url_publicIdentifier` USING utf8) AS `url_publicIdentifier`, "" as `created_at`, "" as `updated_at`, CONVERT(`st`.`sequenceIds` USING utf8) AS `seq_id`, CONVERT("" USING utf8) AS `seq_name`, CONVERT(`st`.`tags` USING utf8) AS tags, "-1" as `company_li_id`, CONVERT("" USING utf8) AS `company_page_url`, CONVERT(`st`.`companyDetail` USING utf8) AS `company_detail`, CONVERT("" USING utf8) AS `basicInfo`, CONVERT("" USING utf8) AS `contactInfo`, CONVERT(`st`.`occupation` USING utf8) AS `occupation`,CONVERT(`st`.`response` USING utf8) AS `response`') 
				->from('1stdegreedata st')
				->where(['st.userId' => Yii::$app->session->get('userid')]);
			$query = (new \yii\db\Query())
				->from(['dummy_name' => $query1->union($query2)])
				->orderBy(['created_at' =>SORT_DESC ])
				->groupBy(['linkedinpublicid'])
				->andWhere("response != ''");				
				
				if(!empty($tagIds)){
					$query->andWhere('FIND_IN_SET(:tag_id,tags)')
					->addParams([':tag_id' => $tagIds]);
				}
				if(!empty($seqIds)){
					$query->andWhere(' (FIND_IN_SET(:seq_id,seq_id))')
					->addParams([':seq_id' => $seqIds]);
				}
				
				if(!empty($firstName)){
					$qry=" (basicInfo LIKE'%" . $firstName . "%' or firstName LIKE'%" . $firstName . "%' or ";
				}
				
				if(!empty($lastName)){
					$qry.="basicInfo LIKE'%" . $lastName . "%' or lastName LIKE'%" . $lastName . "%'  or ";
				}
				if(!empty($email)){
					$qry.="contactInfo LIKE'%" . $email . "%' or emailID LIKE'%" . $email . "%' ) ";
				}
				
				if(!empty($qry)){
					$query->andWhere($qry);
				}
			
		}elseif($filter=="suppressed"){
			$query->select([
				'b.id', 'b.linkedinpublicid', 'st.id st_id', 'st.fullname st_firstName', 'st.emailID st_emailID', 'st.phoneNumbers st_phoneNumbers', 'st.locationName st_locationName', 'st.linkedinpublicid st_linkedinpublicid', 'st.url_publicIdentifier st_url_publicIdentifier', 'st.occupation st_occupation', 'st.companyDetail st_companyDetail', 'st.tags st_tags', 'st.sequenceIds st_sequenceIds', 'st.response response', 'b.firstName', 'b.lastName', 'b.is_accepted', 'b.is_response', 'b.url_publicIdentifier', 'b.profileInfo_id', 'b.companyInfo_id', 'sp.created', 'b.updated_at', 'b.seq_id', 'b.seq_name', 'p.basicInfo', 'p.contactInfo', 'c.company_li_id', 'c.company_page_url', 'c.company_detail', 'b.tags']
			)
			->from('suppressionlist sp')
			->join('LEFT OUTER JOIN', 'blacklist b', 'sp.personId = b.linkedinpublicid AND b.userid = sp.userId')
			->join('LEFT OUTER JOIN', '1stdegreedata st', 'sp.personId = st.linkedinpublicid AND st.userId = sp.userId')
			->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
			->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')
			->where(['sp.userId' => Yii::$app->session->get('userid')]); 
			/* ->andWhere("profileInfo_id !=0  and companyInfo_id != 0 ")
			->andWhere("b.userid = sp.userId"); */
			if(!empty($tagIds)){
				$query->andWhere('(FIND_IN_SET(:tag_id,b.tags) OR FIND_IN_SET(:tag_id,st.tags))')
				->addParams([':tag_id' => $tagIds]);
			}
			if(!empty($seqIds)){
				$query->andWhere('(b.seq_id='.$seqIds.' OR (FIND_IN_SET(:seq_id,st.sequenceIds)))')
				->addParams([':seq_id' => $seqIds]);
			}
			
			if(!empty($firstName)){
				$qry=" (basicInfo LIKE'%" . $firstName . "%' or firstName LIKE'%" . $firstName . "%' or ";
			}
			
			if(!empty($lastName)){
				$qry.="basicInfo LIKE'%" . $lastName . "%' or lastName LIKE'%" . $lastName . "%'  or ";
			}
			if(!empty($email)){
				$qry.="contactInfo LIKE'%" . $email . "%' or emailID LIKE'%" . $email . "%' ) ";
			}
			
			if(!empty($qry)){
				$query->andWhere($qry);
			}
			
			$query->orderBy(['sp.created' => SORT_DESC]);
			
			 /* echo $query->createCommand()->getRawSql();
            exit; */
		}else{
			$query1 = (new \yii\db\Query())
				->select('`b`.`profileInfo_id`, `b`.`companyInfo_id`, `b`.`id`, CONVERT(`b`.`linkedinpublicid` USING utf8) AS `linkedinpublicid`, CONVERT(`b`.`firstName` USING utf8) AS `firstName`, CONVERT(`b`.`lastName` USING utf8) AS `lastName`, `b`.`is_accepted`, `b`.`is_response`, CONVERT("" USING utf8) AS `emailID`, CONVERT("" USING utf8) AS `phoneNumbers`, CONVERT("" USING utf8) AS `locationName`, CONVERT(`b`.`url_publicIdentifier` USING utf8) AS `url_publicIdentifier`, `b`.`created_at`, `b`.`updated_at`, CONVERT(`b`.`seq_id` USING utf8) AS `seq_id`, CONVERT(`b`.`seq_name` USING utf8) AS `seq_name`, CONVERT(`b`.`tags` USING utf8) AS tags, `c`.`company_li_id`, CONVERT(`c`.`company_page_url` USING utf8) AS `company_page_url`, CONVERT(`c`.`company_detail` USING utf8) AS `company_detail`, CONVERT(`p`.`basicInfo` USING utf8) AS `basicInfo`, CONVERT(`p`.`contactInfo` USING utf8) AS `contactInfo`, CONVERT("" USING utf8) AS `occupation` , CONVERT("{}" USING utf8) AS `response`')
				->from('blacklist b')
				->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
				->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')
				->where(['b.userid' => Yii::$app->session->get('userid')]);
 
			$query2 = (new \yii\db\Query())
				->select('0 as `profileInfo_id`, 0 as `companyInfo_id`, `st`.`id`, CONVERT(`st`.`linkedinpublicid` USING utf8) AS `linkedinpublicid`, CONVERT(`st`.`fullname` USING utf8) AS `firstName`, CONVERT("" USING utf8) AS `lastName`, 0 as `is_accepted`, 0 as `is_response`, CONVERT(`st`.`emailID` USING utf8) AS `emailID`, CONVERT(`st`.`phoneNumbers` USING utf8) AS `phoneNumbers`, CONVERT(`st`.`locationName` USING utf8) AS `locationName`, CONVERT(`st`.`url_publicIdentifier` USING utf8) AS `url_publicIdentifier`, "" as `created_at`, "" as `updated_at`, CONVERT(`st`.`sequenceIds` USING utf8) AS `seq_id`, CONVERT("" USING utf8) AS `seq_name`, CONVERT(`st`.`tags` USING utf8) AS tags, "-1" as `company_li_id`, CONVERT("" USING utf8) AS `company_page_url`, CONVERT(`st`.`companyDetail` USING utf8) AS `company_detail`, CONVERT("" USING utf8) AS `basicInfo`, CONVERT("" USING utf8) AS `contactInfo`, CONVERT(`st`.`occupation` USING utf8) AS `occupation`,CONVERT(`st`.`response` USING utf8) AS `response`') 
				->from('1stdegreedata st')
				->where(['st.userId' => Yii::$app->session->get('userid')]);
				//->where("firstName LIKE'%" . $name . "%' $and $whereClause $tagAnd $tagwhereClause")
			$query = (new \yii\db\Query())
			->from(['dummy_name' => $query1->union($query2)])
			->from(['dummy_name' => $query1->union($query2)])
			->orderBy(['created_at' =>SORT_DESC ])
			->groupBy(['linkedinpublicid']); 
			if(!empty($tagIds)){
				$query->andWhere('FIND_IN_SET(:tag_id,tags)')
				->addParams([':tag_id' => $tagIds]);
			}
			if(!empty($seqIds)){
				$query->andWhere(' (FIND_IN_SET(:seq_id,seq_id))')
				->addParams([':seq_id' => $seqIds]);
			}
			
			if(!empty($firstName)){
				$qry=" (basicInfo LIKE'%" . $firstName . "%' or firstName LIKE'%" . $firstName . "%' or ";
			}
			
			if(!empty($lastName)){
				$qry.="basicInfo LIKE'%" . $lastName . "%' or lastName LIKE'%" . $lastName . "%'  or ";
			}
			if(!empty($email)){
				$qry.="contactInfo LIKE'%" . $email . "%' or emailID LIKE'%" . $email . "%' ) ";
			}
			
			if(!empty($qry)){
				$query->andWhere($qry);
			}
		}
		
		 /* if(Yii::$app->session->get('userid')==16222){
			 print_r($models);

		 } */
       /* echo $query->createCommand()->getRawSql();
            exit;  */
			 

        $countQuery = clone $query;
       
		$pages = new Pagination(['totalCount' => count($countQuery->select('*')->column())]);
		
        $pages->pageSize = 15;
        $models = $query->offset($pages->offset)
                ->limit($pages->limit)
                ->all();
				
        $model_sequ = Yii::$app->db->createCommand("select  id,name,status from  ext_sequences  where  user_id =" . Yii::$app->session->get('userid'))->queryAll();

        $extULSData = Yii::$app->db->createCommand("select  *  from  ext_userlocalstoragedata  where user_id =" . Yii::$app->session->get('userid'))->queryOne();
      
        $tagSData = Yii::$app->db->createCommand("select  *  from  tags  where userId =" . Yii::$app->session->get('userid'))->queryAll();

        return $this->render('prospectnew', [ 
                    'blacklistDetail' => $models,
                    'Allsequences' => $model_sequ,
                    'tagSData' => $tagSData,
                    'pages' => $pages,
                    'Apikey' => (isset(json_decode($keyDetail['access_key'])->hubspot_key)) ? json_decode($keyDetail['access_key'])->hubspot_key : '',
                    'portalId' => (isset(json_decode($keyDetail['access_key'])->hubportal_id)) ? json_decode($keyDetail['access_key'])->hubportal_id : '',
                    'pipedrive_api_key' => (isset(json_decode($keyDetail['access_key'])->pipedrive_api_key)) ? json_decode($keyDetail['access_key'])->pipedrive_api_key : '',
                    'pipedriveOwner' => (isset(json_decode($keyDetail['access_key'])->pipedriveOwner)) ? json_decode($keyDetail['access_key'])->pipedriveOwner : '',
                    'extULSData' => $extULSData
        ]);
    }
	
	public function actionProspectbackup() {
		
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $addfilter = "";
		$filter="";
        $keyDetail = Yii::$app->db->createCommand("select access_key from  intigration  where user_id =" . Yii::$app->session->get('userid'))->queryOne();

        if (isset($_REQUEST['sequ_id']) && $_REQUEST['sequ_id'] != "") {
            $whereClause = " (FIND_IN_SET(".$_REQUEST['sequ_id'].",seq_id)) ";
        } else {
            $whereClause = "";
        }
        //for sorting in pagination starts
        if (isset($_GET['sortby']) && $_GET['sortby'] != '') {
            $sortby = $_GET['sortby'];
        } else {
            $sortby = 'b.id'; //default column
        }

        if (isset($_GET['sortorder']) && $_GET['sortorder'] != '') {
            if ($_GET['sortorder'] == 'asc') {
                $sortorder = SORT_ASC;
            } else {
                $sortorder = SORT_DESC;
            }
        } else {
            $sortorder = SORT_DESC; //default sort order
        }
        //for sorting in pagination ends

        $query = new Query;

        $fullNamewhereClause = "";
        $emailwhereClause = "";

        if (isset($_GET['prospectsearchname']) || isset($_GET['search'])) {
            if (isset($_GET['prospectsearchname'])) {
                $fullname = explode(" ", trim($_GET['prospectsearchname']));
            }
            if (isset($_GET['search'])) {
                $fullname = explode(" ", trim($_GET['search']));
            }
            $firstName = "";
            $lastName = "";
            if (isset($fullname[0]) && isset($fullname[1])) {
                $firstName = trim($fullname[0]);
                $lastName = trim($fullname[1]);
                $stfullname = '';
                if (isset($_GET['filterprama']) && $_GET['filterprama'] == "suppressed") {
                    $stfullname = " or st_firstName LIKE '%" . $_GET['prospectsearchname'] . "%'";
                }

                $fullNamewhereClause = " and (basicInfo LIKE'%" . $firstName . "%' or basicInfo LIKE'%" . $lastName . "%' " . $stfullname.") ";
            }
            if (isset($_GET['prospectsearchname']) || isset($_GET['search'])) {
                if (isset($_GET['prospectsearchname'])) {
                    $email = $_GET['prospectsearchname'];
                }
                if (isset($_GET['search'])) {
                    $email = $_GET['search'];
                }
                if (!empty($email)) {
                    $emailwhereClause = "  contactInfo LIKE'%" . $email . "%'";
                }
            }
        }
        if (isset($_REQUEST['tag_id']) && $_REQUEST['tag_id'] != "") {
            //$tagwhereClause = " and b.tags LIKE '%" . $_REQUEST['tag_id'] . "%'";
			$tagwhereClause = " (FIND_IN_SET(".$_REQUEST['tag_id'].",tags)) ";
        } else {
            $tagwhereClause = "";
        }

        if (isset($_GET['prospectsearchname']) && $_GET['prospectsearchname'] != "") {
            $name = $_GET['prospectsearchname'];

            if (isset($_GET['filter']) && $_GET['filter'] == "accpet") {
                $query->select([
                            'b.id', 'b.linkedinpublicid', 'b.firstName', 'b.lastName', 'b.is_accepted', 'b.is_response', 'b.url_publicIdentifier', 'b.profileInfo_id', 'b.companyInfo_id', 'b.created_at', 'b.updated_at', 'b.seq_id', 'b.seq_name', 'p.basicInfo', 'p.contactInfo', 'c.company_li_id', 'c.company_page_url', 'c.company_detail', 'b.tags']
                        )
                        ->from('blacklist b')
                        ->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
                        ->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')->where(['userid' => Yii::$app->session->get('userid')])
                        ->andWhere("profileInfo_id !=0  and companyInfo_id != 0 ")
                        ->andWhere("b.is_accepted= 1")
                        ->orderBy(['b.created_at' => SORT_DESC]);
						if(!empty($addfilter) || !empty($whereClause)|| !empty($fullNamewhereClause)|| !empty($emailwhereClause)){
							 $query->andWhere($addfilter . $fullNamewhereClause . $emailwhereClause);
						}
						if( !empty($tagwhereClause)){
							$query->andWhere($tagwhereClause);
						}
						if( !empty($whereClause)){
							$query->andWhere($whereClause);
						}
						if( !empty($name )){
							$query->andWhere("basicInfo LIKE'%" . $name . "%'");
						}
						
				
            } else if (isset($_GET['filter']) && $_GET['filter'] == "pending") {
                $query->select([
                            'b.id', 'b.linkedinpublicid', 'b.firstName', 'b.lastName', 'b.is_accepted', 'b.is_response', 'b.url_publicIdentifier', 'b.profileInfo_id', 'b.companyInfo_id', 'b.created_at', 'b.updated_at', 'b.seq_id', 'b.seq_name', 'p.basicInfo', 'p.contactInfo', 'c.company_li_id', 'c.company_page_url', 'c.company_detail', 'b.tags']
                        )
                        ->from('blacklist b')
                        ->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
                        ->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')->where(['userid' => Yii::$app->session->get('userid')])
                        ->andWhere("profileInfo_id !=0  and companyInfo_id != 0 ")
                        ->andWhere("b.is_accepted= 0")
                        ->orderBy(['b.created_at' => SORT_DESC]);
						if(!empty($addfilter) || !empty($whereClause)|| !empty($fullNamewhereClause)|| !empty($emailwhereClause)){
							 $query->andWhere($addfilter . $fullNamewhereClause . $emailwhereClause);
						}
						if( !empty($tagwhereClause)){
							$query->andWhere($tagwhereClause);
						}
						if( !empty($whereClause)){
							$query->andWhere($whereClause);
						}
						if( !empty($name )){
							$query->andWhere("basicInfo LIKE'%" . $name . "%'");
						}
				
            } else if (isset($_GET['filter']) && $_GET['filter'] == "all") {
				if(!empty($whereClause)){
					$and=" and ";
				}else{
					$and="";
				}
				if(!empty($tagwhereClause)){
					$tagAnd=" and ";
				}else{
					$tagAnd="";
				}
                $query->select([
                            'b.id', 'b.linkedinpublicid', 'b.firstName', 'b.lastName', 'b.is_accepted', 'b.is_response', 'b.url_publicIdentifier', 'b.profileInfo_id', 'b.companyInfo_id', 'b.created_at', 'b.updated_at', 'b.seq_id', 'b.seq_name', 'p.basicInfo', 'p.contactInfo', 'c.company_li_id', 'c.company_page_url', 'c.company_detail', 'b.tags']
                        )
                        ->from('blacklist b')
                        ->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
                        ->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')->where(['userid' => Yii::$app->session->get('userid')])
                        ->andWhere("profileInfo_id !=0  and companyInfo_id != 0 and basicInfo LIKE'%" . $name . "%' $and  $whereClause $fullNamewhereClause $emailwhereClause  $tagAnd $tagwhereClause")
                        ->orderBy(['b.created_at' => SORT_DESC]);
            } else if (isset($_GET['filter']) && $_GET['filter'] == "suppressed") {
				
				if (isset($_GET['search']) && $_GET['search'] != "") {
					$addfilter = " basicInfo LIKE'%" . $_GET['search'] . "%' or `st`.`fullname` LIKE '%" . $_GET['search'] . "%' or ";
				}


                if (isset($_GET['prospectsearchname']) && $_GET['prospectsearchname'] != "") {
                    $stnamesearch = " or  basicInfo LIKE'%" . $_GET['prospectsearchname'] . "%' or st.fullname LIKE '%" . $_GET['prospectsearchname'] . "%' ";
                }


				$query->select([
					'b.id', 'b.linkedinpublicid', 'st.id st_id', 'st.fullname st_firstName', 'st.emailID st_emailID', 'st.phoneNumbers st_phoneNumbers', 'st.locationName st_locationName', 'st.linkedinpublicid st_linkedinpublicid', 'st.url_publicIdentifier st_url_publicIdentifier', 'st.occupation st_occupation', 'st.companyDetail st_companyDetail', 'st.tags st_tags', 'st.sequenceIds st_sequenceIds', 'st.response st_response', 'b.firstName', 'b.lastName', 'b.is_accepted', 'b.is_response', 'b.url_publicIdentifier', 'b.profileInfo_id', 'b.companyInfo_id', 'b.created_at', 'b.updated_at', 'b.seq_id', 'b.seq_name', 'p.basicInfo', 'p.contactInfo', 'c.company_li_id', 'c.company_page_url', 'c.company_detail', 'b.tags']
				)
				->from('suppressionlist sp')
				->join('LEFT OUTER JOIN', 'blacklist b', 'sp.personId = b.linkedinpublicid AND b.userid = sp.userId')
				->join('LEFT OUTER JOIN', '1stdegreedata st', 'sp.personId = st.linkedinpublicid AND st.userId = sp.userId')
				->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
				->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')
				->where(['sp.userId' => Yii::$app->session->get('userid')])
				->andWhere("profileInfo_id !=0  and companyInfo_id != 0 ")
				//->andWhere("b.userid = sp.userId")
				//->orderBy(['b.created_at' => SORT_DESC]);
				->orderBy([$sortby => $sortorder]);
				$fullNamewhereClause = " basicInfo LIKE'%" . $firstName . "%' or basicInfo LIKE'%" . $lastName . "%' " . $stfullname." or ";
				if(!empty($addfilter) || !empty($whereClause)|| !empty($fullNamewhereClause)|| !empty($emailwhereClause)|| !empty($stnamesearch)){
					 $query->andWhere($addfilter . $fullNamewhereClause . $emailwhereClause . $stnamesearch);
				}
				if( !empty($_REQUEST['tag_id'])){
					$query->andWhere("((FIND_IN_SET(".$_REQUEST['tag_id'].",b.tags)) or (FIND_IN_SET(".$_REQUEST['tag_id'].",st.tags)))");
				}
				if( !empty($whereClause)){
					$query->andWhere($whereClause);
				}
				 /* echo $query->createCommand()->getRawSql();
            exit; */
            } else {
				
					$filter="all";
					$query1 = (new \yii\db\Query())
						->select('`b`.`profileInfo_id`, `b`.`companyInfo_id`, `b`.`id`, CONVERT(`b`.`linkedinpublicid` USING utf8) AS `linkedinpublicid`, CONVERT(`b`.`firstName` USING utf8) AS `firstName`, CONVERT(`b`.`lastName` USING utf8) AS `lastName`, `b`.`is_accepted`, `b`.`is_response`, CONVERT("" USING utf8) AS `emailID`, CONVERT("" USING utf8) AS `phoneNumbers`, CONVERT("" USING utf8) AS `locationName`, CONVERT(`b`.`url_publicIdentifier` USING utf8) AS `url_publicIdentifier`, `b`.`created_at`, `b`.`updated_at`, CONVERT(`b`.`seq_id` USING utf8) AS `seq_id`, CONVERT(`b`.`seq_name` USING utf8) AS `seq_name`, CONVERT(`b`.`tags` USING utf8) AS tags, `c`.`company_li_id`, CONVERT(`c`.`company_page_url` USING utf8) AS `company_page_url`, CONVERT(`c`.`company_detail` USING utf8) AS `company_detail`, CONVERT(`p`.`basicInfo` USING utf8) AS `basicInfo`, CONVERT(`p`.`contactInfo` USING utf8) AS `contactInfo`, CONVERT("" USING utf8) AS `occupation`')
						->from('blacklist b')
						->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
						->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')
						->where(['b.userid' => Yii::$app->session->get('userid')]);
		 
					$query2 = (new \yii\db\Query())
						->select('0 as `profileInfo_id`, 0 as `companyInfo_id`, `st`.`id`, CONVERT(`st`.`linkedinpublicid` USING utf8) AS `linkedinpublicid`, CONVERT(`st`.`fullname` USING utf8) AS `firstName`, CONVERT("" USING utf8) AS `lastName`, 0 as `is_accepted`, 0 as `is_response`, CONVERT(`st`.`emailID` USING utf8) AS `emailID`, CONVERT(`st`.`phoneNumbers` USING utf8) AS `phoneNumbers`, CONVERT(`st`.`locationName` USING utf8) AS `locationName`, CONVERT(`st`.`url_publicIdentifier` USING utf8) AS `url_publicIdentifier`, "" as `created_at`, "" as `updated_at`, CONVERT(`st`.`sequenceIds` USING utf8) AS `seq_id`, CONVERT("" USING utf8) AS `seq_name`, CONVERT(`st`.`tags` USING utf8) AS tags, "-1" as `company_li_id`, CONVERT("" USING utf8) AS `company_page_url`, CONVERT(`st`.`companyDetail` USING utf8) AS `company_detail`, CONVERT("" USING utf8) AS `basicInfo`, CONVERT("" USING utf8) AS `contactInfo`, CONVERT(`st`.`occupation` USING utf8) AS `occupation`') 
						->from('1stdegreedata st')
						->where(['st.userId' => Yii::$app->session->get('userid')]);
						if(!empty($whereClause)){
							$and=" and ";
						}else{
							$and="";
						}
						if(!empty($tagwhereClause)){
							$tagAnd=" and ";
						}else{
							$tagAnd="";
						}
					$query = (new \yii\db\Query())
						->from(['dummy_name' => $query1->union($query2)])
						->where("firstName LIKE'%" . $name . "%' $and $whereClause $tagAnd $tagwhereClause")
						->orderBy(['created_at' =>SORT_DESC ])
						->groupBy(['linkedinpublicid']); 
            }
        } else if (isset($_GET['filterprama']) && $_GET['filterprama'] == "accpet") {
			/* OK */
            if (isset($_GET['search']) && $_GET['search'] != "") {
                $addfilter = " basicInfo LIKE'%" . $_GET['search'] . "%' or ";
            }
            $query->select([
                        'b.id', 'b.linkedinpublicid', 'b.firstName', 'b.lastName', 'b.is_accepted', 'b.is_response', 'b.url_publicIdentifier', 'b.profileInfo_id', 'b.companyInfo_id', 'b.created_at', 'b.updated_at', 'b.seq_id', 'b.seq_name', 'p.basicInfo', 'p.contactInfo', 'c.company_li_id', 'c.company_page_url', 'c.company_detail', 'b.tags']
                    )
                    ->from('blacklist b')
                    ->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
                    ->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')
					->where('userid='. Yii::$app->session->get('userid'))
                    ->andWhere("profileInfo_id !=0  and companyInfo_id != 0 ") 
                    ->andWhere("b.is_accepted= 1")
                    //->orderBy(['b.created_at' => SORT_DESC]);
                    ->orderBy([$sortby => $sortorder]);
					if(!empty($addfilter) || !empty($whereClause)|| !empty($fullNamewhereClause)|| !empty($emailwhereClause)){
						 $query->andWhere($addfilter . $fullNamewhereClause . $emailwhereClause);
					}
					if( !empty($tagwhereClause)){
						$query->andWhere($tagwhereClause);
					}
					if( !empty($whereClause)){
						$query->andWhere($whereClause);
					}
		echo $query->createCommand()->getRawSql();
            exit;
        } else if (isset($_GET['filterprama']) && $_GET['filterprama'] == "pending") {
		
            //$name=$_GET['filterprama'];
            if (isset($_GET['search']) && $_GET['search'] != "") {
                $addfilter = "  basicInfo LIKE '%" . $_GET['search'] . "%' or ";
            }
            $query->select([
                        'b.id', 'b.linkedinpublicid', 'b.firstName', 'b.lastName', 'b.is_accepted', 'b.is_response', 'b.url_publicIdentifier', 'b.profileInfo_id', 'b.companyInfo_id', 'b.created_at', 'b.updated_at', 'b.seq_id', 'b.seq_name', 'p.basicInfo', 'p.contactInfo', 'c.company_li_id', 'c.company_page_url', 'c.company_detail', 'b.tags']
                    )
                    ->from('blacklist b')
                    ->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
                    ->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')->where(['userid' => Yii::$app->session->get('userid')])
                    ->andWhere("profileInfo_id !=0  and companyInfo_id != 0 ")
                    ->andWhere("b.is_accepted= 0")
                    //->orderBy(['b.created_at' => SORT_DESC]);
                    ->orderBy([$sortby => $sortorder]);
					if(!empty($addfilter) || !empty($whereClause)|| !empty($fullNamewhereClause)|| !empty($emailwhereClause)){
						 $query->andWhere($addfilter . $fullNamewhereClause . $emailwhereClause);
					}
					if( !empty($tagwhereClause)){
						$query->andWhere($tagwhereClause);
					}
					if( !empty($whereClause)){
						$query->andWhere($whereClause);
					}
			
        } else if (isset($_GET['filterprama']) && $_GET['filterprama'] == "responded") {
            if (isset($_GET['search']) && $_GET['search'] != "") {
                $addfilter = "  basicInfo LIKE'%" . $_GET['search'] . "%' or ";
            }
            $query->select([
                        'b.id', 'b.linkedinpublicid', 'b.firstName', 'b.lastName', 'b.is_accepted', 'b.is_response', 'b.url_publicIdentifier', 'b.profileInfo_id', 'b.companyInfo_id', 'b.created_at', 'b.updated_at', 'b.seq_id', 'b.seq_name', 'p.basicInfo', 'p.contactInfo', 'c.company_li_id', 'c.company_page_url', 'c.company_detail', 'b.tags']
                    )
                    ->from('blacklist b')
                    ->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
                    ->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')->where(['userid' => Yii::$app->session->get('userid')])
                    ->andWhere("profileInfo_id !=0  and companyInfo_id != 0 ")
                    ->andWhere("b.is_response= 1")
                    //->orderBy(['b.created_at' => SORT_DESC]);
                    ->orderBy([$sortby => $sortorder]);
					if(!empty($addfilter) || !empty($whereClause)|| !empty($fullNamewhereClause)|| !empty($emailwhereClause)){
						 $query->andWhere($addfilter . $fullNamewhereClause . $emailwhereClause);
					}
					if( !empty($tagwhereClause)){
						$query->andWhere($tagwhereClause);
					}
					if( !empty($whereClause)){
						$query->andWhere($whereClause);
					}
        } else if (isset($_GET['filterprama']) && $_GET['filterprama'] == "suppressed") {


           /*  if (isset($_GET['search']) && $_GET['search'] != "") {
                $addfilter = "AND  (basicInfo LIKE'%" . $_GET['search'] . "%' or st_firstName LIKE '%" . $_GET['prospectsearchname'] . "%')";
            }

            if (isset($_GET['prospectsearchname']) && $_GET['prospectsearchname'] != "") {
                $stnamesearch = "AND  (basicInfo LIKE'%" . $_GET['search'] . "%' or st_firstName LIKE '%" . $_GET['prospectsearchname'] . "%')";
            }
 */
			if (isset($_GET['search']) && $_GET['search'] != "") {
				$addfilter = " (basicInfo LIKE'%" . $_GET['search'] . "%' or `st`.`fullname` LIKE '%" . $_GET['search'] . "%' or " . $fullNamewhereClause . $emailwhereClause.") ";
			}

			if (isset($_GET['prospectsearchname']) && $_GET['prospectsearchname'] != "") {
				$stnamesearch = " or  basicInfo LIKE'%" . $_GET['prospectsearchname'] . "%' or `st`.`fullname` LIKE '%" . $_GET['prospectsearchname'] . "%' ";
			}



            $query->select([
                        'b.id', 'b.linkedinpublicid', 'st.id st_id', 'st.fullname st_firstName', 'st.emailID st_emailID', 'st.phoneNumbers st_phoneNumbers', 'st.locationName st_locationName', 'st.linkedinpublicid st_linkedinpublicid', 'st.url_publicIdentifier st_url_publicIdentifier', 'st.occupation st_occupation', 'st.companyDetail st_companyDetail', 'st.tags st_tags', 'st.sequenceIds st_sequenceIds', 'st.response st_response', 'b.firstName', 'b.lastName', 'b.is_accepted', 'b.is_response', 'b.url_publicIdentifier', 'b.profileInfo_id', 'b.companyInfo_id', 'b.created_at', 'b.updated_at', 'b.seq_id', 'b.seq_name', 'p.basicInfo', 'p.contactInfo', 'c.company_li_id', 'c.company_page_url', 'c.company_detail', 'b.tags']
                    )
                    ->from('suppressionlist sp')
                    ->join('LEFT OUTER JOIN', 'blacklist b', 'sp.personId = b.linkedinpublicid AND b.userid = sp.userId')
                    ->join('LEFT OUTER JOIN', '1stdegreedata st', 'sp.personId = st.linkedinpublicid AND st.userId = sp.userId')
                    ->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
                    ->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')
                    ->where(['sp.userId' => Yii::$app->session->get('userid')])
                    ->andWhere("profileInfo_id !=0  and companyInfo_id != 0 ")
                    ->andWhere("b.userid = sp.userId")
                    //->orderBy(['b.created_at' => SORT_DESC]);
                    ->orderBy([$sortby => $sortorder]);
					if(!empty($addfilter) || !empty($whereClause)|| !empty($stnamesearch)){
						 $query->andWhere($addfilter  . $stnamesearch);
					}
					if( !empty($_REQUEST['tag_id'])){
						$query->andWhere("((FIND_IN_SET(".$_REQUEST['tag_id'].",b.tags)) or (FIND_IN_SET(".$_REQUEST['tag_id'].",st.tags)))");
					}
					if( !empty($whereClause)){
						$query->andWhere($whereClause);
					}
			/* echo $query->createCommand()->getRawSql();
            exit; 	 */ 
        } else {
			$filter="all";
            $query1 = (new \yii\db\Query())
				->select('`b`.`profileInfo_id`, `b`.`companyInfo_id`, `b`.`id`, CONVERT(`b`.`linkedinpublicid` USING utf8) AS `linkedinpublicid`, CONVERT(`b`.`firstName` USING utf8) AS `firstName`, CONVERT(`b`.`lastName` USING utf8) AS `lastName`, `b`.`is_accepted`, `b`.`is_response`, CONVERT("" USING utf8) AS `emailID`, CONVERT("" USING utf8) AS `phoneNumbers`, CONVERT("" USING utf8) AS `locationName`, CONVERT(`b`.`url_publicIdentifier` USING utf8) AS `url_publicIdentifier`, `b`.`created_at`, `b`.`updated_at`, CONVERT(`b`.`seq_id` USING utf8) AS `seq_id`, CONVERT(`b`.`seq_name` USING utf8) AS `seq_name`, CONVERT(`b`.`tags` USING utf8) AS tags, `c`.`company_li_id`, CONVERT(`c`.`company_page_url` USING utf8) AS `company_page_url`, CONVERT(`c`.`company_detail` USING utf8) AS `company_detail`, CONVERT(`p`.`basicInfo` USING utf8) AS `basicInfo`, CONVERT(`p`.`contactInfo` USING utf8) AS `contactInfo`, CONVERT("" USING utf8) AS `occupation`')
				->from('blacklist b')
				->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
				->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')
				->where(['b.userid' => Yii::$app->session->get('userid')]);
 
			$query2 = (new \yii\db\Query())
				->select('0 as `profileInfo_id`, 0 as `companyInfo_id`, `st`.`id`, CONVERT(`st`.`linkedinpublicid` USING utf8) AS `linkedinpublicid`, CONVERT(`st`.`fullname` USING utf8) AS `firstName`, CONVERT("" USING utf8) AS `lastName`, 0 as `is_accepted`, 0 as `is_response`, CONVERT(`st`.`emailID` USING utf8) AS `emailID`, CONVERT(`st`.`phoneNumbers` USING utf8) AS `phoneNumbers`, CONVERT(`st`.`locationName` USING utf8) AS `locationName`, CONVERT(`st`.`url_publicIdentifier` USING utf8) AS `url_publicIdentifier`, "" as `created_at`, "" as `updated_at`, CONVERT(`st`.`sequenceIds` USING utf8) AS `seq_id`, CONVERT("" USING utf8) AS `seq_name`, CONVERT(`st`.`tags` USING utf8) AS tags, "-1" as `company_li_id`, CONVERT("" USING utf8) AS `company_page_url`, CONVERT(`st`.`companyDetail` USING utf8) AS `company_detail`, CONVERT("" USING utf8) AS `basicInfo`, CONVERT("" USING utf8) AS `contactInfo`, CONVERT(`st`.`occupation` USING utf8) AS `occupation`') 
				->from('1stdegreedata st')
				->where(['st.userId' => Yii::$app->session->get('userid')]);
			$query = (new \yii\db\Query())
				->from(['dummy_name' => $query1->union($query2)])
				->orderBy(['created_at' =>SORT_DESC ])
				->groupBy(['linkedinpublicid']); 
				if(!empty($whereClause)){
					$query->where("$whereClause");
				}
				if(!empty($tagwhereClause) && !empty($whereClause)){
					$query->andWhere("$tagwhereClause");
				}elseif(!empty($tagwhereClause)){
					$query->where("$tagwhereClause");
				}
        }

        if (Yii::$app->session->get('userid') == '16838') {
           /*  echo $query->createCommand()->getRawSql();
            exit;   */
            //echo $_GET['filter'];
        }

        //if(Yii::$app->session->get('userid') == '14975'){
        //$qyrstr = $query->createCommand()->getRawSql();
        //$resultsData = Yii::$app->db->createCommand($qyrstr)->queryAll();
        //$pages = new Pagination(['totalCount' => count($resultsData)]);
        //} else{ 
		 
        $countQuery = clone $query;
        /* if(Yii::$app->session->get('userid') == '14975'){   */
		
		if($filter=="all"){
			$pages = new Pagination(['totalCount' => count($countQuery->select('id')->column())]);
		}else{
			$pages = new Pagination(['totalCount' => $countQuery->select('count(b.id)')->scalar()]);
		}
        /* } else{        
          $pages = new Pagination(['totalCount' => $countQuery->count()]);
          } */

        //}

        $pages->pageSize = 15;
        $models = $query->offset($pages->offset)
                ->limit($pages->limit)
                ->all();


        // $query_sequ = new Query;
  
        $model_sequ = Yii::$app->db->createCommand("select  id,name,status from  ext_sequences  where  user_id =" . Yii::$app->session->get('userid'))->queryAll();

        $extULSData = Yii::$app->db->createCommand("select  *  from  ext_userlocalstoragedata  where user_id =" . Yii::$app->session->get('userid'))->queryOne();
        //NR ends
        $tagSData = Yii::$app->db->createCommand("select  *  from  tags  where userId =" . Yii::$app->session->get('userid'))->queryAll();

        return $this->render('prospectnew', [ 
                    'blacklistDetail' => $models,
                    'Allsequences' => $model_sequ,
                    'tagSData' => $tagSData,
                    'pages' => $pages,
                    'Apikey' => (isset(json_decode($keyDetail['access_key'])->hubspot_key)) ? json_decode($keyDetail['access_key'])->hubspot_key : '',
                    'portalId' => (isset(json_decode($keyDetail['access_key'])->hubportal_id)) ? json_decode($keyDetail['access_key'])->hubportal_id : '',
                    'pipedrive_api_key' => (isset(json_decode($keyDetail['access_key'])->pipedrive_api_key)) ? json_decode($keyDetail['access_key'])->pipedrive_api_key : '',
                    'pipedriveOwner' => (isset(json_decode($keyDetail['access_key'])->pipedriveOwner)) ? json_decode($keyDetail['access_key'])->pipedriveOwner : '',
                    'extULSData' => $extULSData
        ]);
    }

    public function getpersoneblockid($personId) {
        $isblocked = 0;
        $keyDetail = Yii::$app->db->createCommand("select id from  suppressionlist  where teamId = " . Yii::$app->session->get('userid') . "  AND personId =" . $personId)->queryOne();
        if (isset($keyDetail['id']) && $keyDetail['id'] > 0) {
            $isblocked = $keyDetail['id'];
        }
        return $isblocked;
    }

    function getprospecttags($tags) { 
		$tags=str_replace(',,',',',$tags);
        $userData = Yii::$app->db->createCommand("SELECT id,tagName FROM `tags` WHERE id in($tags) and userId='" . Yii::$app->session->get('userid') . "'")->queryAll();
        return $userData;
    }

    public function actionGetseqnamesfromids() {
        $seqidshtml = '';
        if (isset($_POST['seqids'])) {
            $seqidsarr = explode(",", $_POST['seqids']);
            foreach ($seqidsarr as $key => $value) {
                $seqdeta = Yii::$app->db->createCommand("select  name  from  ext_sequences  where id =" . $value)->queryOne();
                $seqidshtml .= '<a href="javascript:;" onclick="viewseqfeedbyid(' . $value . ')" data-seq-id="' . $value . '">' . $seqdeta['name'] . '</a>,';
            }
        }

        echo rtrim($seqidshtml, ',');
    }

// Start: For Proscpect Export
	public function actionExport() {
		//print_r($_GET);exit;
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $addfilter = "";
		$filter="";
        $keyDetail = Yii::$app->db->createCommand("select access_key from  intigration  where user_id =" . Yii::$app->session->get('userid'))->queryOne();

        if (isset($_REQUEST['seqFilters']) && $_REQUEST['seqFilters'] != "") {
            $whereClause = " (FIND_IN_SET(".$_REQUEST['seqFilters'].",seq_id)) ";
        } else {
            $whereClause = "";
        }
		
       
		$sortby = 'b.id';
		$sortorder = SORT_DESC;
        $query = new Query;
        $fullNamewhereClause = "";
        $emailwhereClause = "";
		$fullname = "";
		$firstName = "";
		$lastName = "";
		$email = "";
		
		$export_option = $_GET['export_option'];
        if ($export_option == "all") {
            $lead_title = "All Data";
        } elseif ($export_option == "responded") {
            $lead_title = "Responded";
        } elseif ($export_option == "1") {
            $lead_title = "Accepted";
        } elseif ($export_option == "suppressed") {
            $lead_title = "Suppressed";
        } else {
            $lead_title = "Pending";
        }
		
		$s_date = implode('-', array_reverse(explode('/', $_GET['pstart_date'])));
		$e_date = implode('-', array_reverse(explode('/', $_GET['pend_date'])));
		$userData = Yii::$app->db->createCommand("select  TimeZone  from  user  where id =" . Yii::$app->session->get('userid'))->queryOne();
        $tz = timezone_open($userData['TimeZone']); //Asia/Kolkata
        $datetime = date_create("now", timezone_open("UTC"));
        $offset = timezone_offset_get($tz, $datetime);
        if ($offset >= 0) {
            $offset = $offset;
            $sign = "+";
        } else {
            $offset = abs($offset);
            $sign = "-";
        }
        $hour_min = $sign . gmdate("H:i", $offset);
		
		
		$tagIds = "";
        if (isset($_REQUEST['assign_tagExport']) && $_REQUEST['assign_tagExport'] != "") {
			$tagIds = $_REQUEST['assign_tagExport'];
        }
		
		$seqIds = "";
        if (isset($_REQUEST['seqFilters']) && $_REQUEST['seqFilters'] != "") {
			$seqIds = $_REQUEST['seqFilters'];
        }
		
		$filter = "";
		$export_option = $_GET['export_option'];
		if ($export_option == "all") {
			$filter = "All Data";
		} elseif ($export_option == "responded") {
			$filter = "responded";
		} elseif ($export_option == "1") {
			$filter = "accpet";
		} elseif ($export_option == "suppressed") {
			$filter = "suppressed";
		} else {
			$filter = "pending";
		}
		
		if($filter=="accpet"){
			$query->select([
				'b.id', 'b.linkedinpublicid', 'b.firstName', 'b.lastName', 'b.is_accepted', 'b.is_response', 'b.url_publicIdentifier', 'b.profileInfo_id', 'b.companyInfo_id', 'b.created_at', 'b.updated_at', 'b.seq_id', 'b.seq_name', 'p.basicInfo', 'p.contactInfo', 'c.company_li_id', 'c.company_page_url', 'c.company_detail', 'b.tags']
			)
			->from('blacklist b')
			->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
			->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')
			->where(['userid' => Yii::$app->session->get('userid')])
			->andWhere("profileInfo_id !=0  and companyInfo_id != 0 ")
			->andWhere("b.is_accepted= 1");
			if(!empty($s_date) && !empty($e_date) )
			{
				$query->andWhere("(DATE(convert_tz(b.created_at,'+00:00','" . $hour_min . "')) BETWEEN '" . $s_date . "' AND '" . $e_date . "')");
			}
			if(!empty($tagIds)){
				$query->andWhere('FIND_IN_SET(:tag_id,tags)')
				->addParams([':tag_id' => $tagIds]);
			}
			if(!empty($seqIds)){
				$query->andWhere('b.seq_id='.$seqIds.'');
			}
			
			
			if(!empty($firstName)){
				$qry=" (basicInfo LIKE'%" . $firstName . "%' or ";
			}
			
			if(!empty($lastName)){
				$qry.="basicInfo LIKE'%" . $lastName . "%' or ";
			}
			if(!empty($email)){
				$qry.="contactInfo LIKE'%" . $email . "%') ";
			}
			
			if(!empty($qry)){
				$query->andWhere($qry);
			}
			
			$query->orderBy(['b.created_at' => SORT_DESC]);
			
		}elseif($filter=="pending"){
			$query->select([
				'b.id', 'b.linkedinpublicid', 'b.firstName', 'b.lastName', 'b.is_accepted', 'b.is_response', 'b.url_publicIdentifier', 'b.profileInfo_id', 'b.companyInfo_id', 'b.created_at', 'b.updated_at', 'b.seq_id', 'b.seq_name', 'p.basicInfo', 'p.contactInfo', 'c.company_li_id', 'c.company_page_url', 'c.company_detail', 'b.tags']
			)
			->from('blacklist b')
			->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
			->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')
			->where(['userid' => Yii::$app->session->get('userid')])
			->andWhere("profileInfo_id !=0  and companyInfo_id != 0 ")
			->andWhere("b.is_accepted= 0");
			if(!empty($s_date) && !empty($e_date) )
			{
				$query->andWhere("(DATE(convert_tz(b.created_at,'+00:00','" . $hour_min . "')) BETWEEN '" . $s_date . "' AND '" . $e_date . "')");
			}
			if(!empty($tagIds)){
				$query->andWhere('FIND_IN_SET(:tag_id,tags)')
				->addParams([':tag_id' => $tagIds]);
			}
			if(!empty($seqIds)){
				$query->andWhere('b.seq_id='.$seqIds.'');
			}
			
			if(!empty($firstName)){
				$qry=" (basicInfo LIKE'%" . $firstName . "%' or ";
			}
			
			if(!empty($lastName)){
				$qry.="basicInfo LIKE'%" . $lastName . "%' or ";
			}
			if(!empty($email)){
				$qry.="contactInfo LIKE'%" . $email . "%') ";
			}
			
			if(!empty($qry)){
				$query->andWhere($qry);
			}
			
			$query->orderBy(['b.created_at' => SORT_DESC]);
			
		}elseif($filter=="responded"){
			$query1 = (new \yii\db\Query())
				->select('`b`.`profileInfo_id`, `b`.`companyInfo_id`, `b`.`id`, CONVERT(`b`.`linkedinpublicid` USING utf8) AS `linkedinpublicid`, CONVERT(`b`.`firstName` USING utf8) AS `firstName`, CONVERT(`b`.`lastName` USING utf8) AS `lastName`, `b`.`is_accepted`, `b`.`is_response`, CONVERT("" USING utf8) AS `emailID`, CONVERT("" USING utf8) AS `phoneNumbers`, CONVERT("" USING utf8) AS `locationName`, CONVERT(`b`.`url_publicIdentifier` USING utf8) AS `url_publicIdentifier`, `b`.`created_at`, `b`.`updated_at`, CONVERT(`b`.`seq_id` USING utf8) AS `seq_id`, CONVERT(`b`.`seq_name` USING utf8) AS `seq_name`, CONVERT(`b`.`tags` USING utf8) AS tags, `c`.`company_li_id`, CONVERT(`c`.`company_page_url` USING utf8) AS `company_page_url`, CONVERT(`c`.`company_detail` USING utf8) AS `company_detail`, CONVERT(`p`.`basicInfo` USING utf8) AS `basicInfo`, CONVERT(`p`.`contactInfo` USING utf8) AS `contactInfo`, CONVERT("" USING utf8) AS `occupation`,CONVERT("{}" USING utf8) AS `response`')
				->from('blacklist b')
				->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
				->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')
				->where(['b.userid' => Yii::$app->session->get('userid')])
				->andWhere("b.is_response= 1");
			if(!empty($s_date) && !empty($e_date) )
			{
				$query1->andWhere("(DATE(convert_tz(b.created_at,'+00:00','" . $hour_min . "')) BETWEEN '" . $s_date . "' AND '" . $e_date . "')");
			}
			$query2 = (new \yii\db\Query())
				->select('0 as `profileInfo_id`, 0 as `companyInfo_id`, `st`.`id`, CONVERT(`st`.`linkedinpublicid` USING utf8) AS `linkedinpublicid`, CONVERT(`st`.`fullname` USING utf8) AS `firstName`, CONVERT("" USING utf8) AS `lastName`, 0 as `is_accepted`, 0 as `is_response`, CONVERT(`st`.`emailID` USING utf8) AS `emailID`, CONVERT(`st`.`phoneNumbers` USING utf8) AS `phoneNumbers`, CONVERT(`st`.`locationName` USING utf8) AS `locationName`, CONVERT(`st`.`url_publicIdentifier` USING utf8) AS `url_publicIdentifier`, "" as `created_at`, "" as `updated_at`, CONVERT(`st`.`sequenceIds` USING utf8) AS `seq_id`, CONVERT("" USING utf8) AS `seq_name`, CONVERT(`st`.`tags` USING utf8) AS tags, "-1" as `company_li_id`, CONVERT("" USING utf8) AS `company_page_url`, CONVERT(`st`.`companyDetail` USING utf8) AS `company_detail`, CONVERT("" USING utf8) AS `basicInfo`, CONVERT("" USING utf8) AS `contactInfo`, CONVERT(`st`.`occupation` USING utf8) AS `occupation`,CONVERT(`st`.`response` USING utf8) AS `response`') 
				->from('1stdegreedata st')
				->where(['st.userId' => Yii::$app->session->get('userid')]);
			$query = (new \yii\db\Query())
				->from(['dummy_name' => $query1->union($query2)])
				->orderBy(['created_at' =>SORT_DESC ])
				->groupBy(['linkedinpublicid'])
				->andWhere("response != ''");				
				
				if(!empty($tagIds)){
					$query->andWhere('FIND_IN_SET(:tag_id,tags)')
					->addParams([':tag_id' => $tagIds]);
				}
				if(!empty($seqIds)){
					$query->andWhere(' (FIND_IN_SET(:seq_id,seq_id))')
					->addParams([':seq_id' => $seqIds]);
				}
				
				if(!empty($firstName)){
					$qry=" (basicInfo LIKE'%" . $firstName . "%' or firstName LIKE'%" . $firstName . "%' or ";
				}
				
				if(!empty($lastName)){
					$qry.="basicInfo LIKE'%" . $lastName . "%' or lastName LIKE'%" . $lastName . "%'  or ";
				}
				if(!empty($email)){
					$qry.="contactInfo LIKE'%" . $email . "%' or emailID LIKE'%" . $email . "%' ) ";
				}
				
				if(!empty($qry)){
					$query->andWhere($qry);
				}
			
		}elseif($filter=="suppressed"){
			$query->select([
				'b.id', 'b.linkedinpublicid', 'st.id st_id', 'st.fullname st_firstName', 'st.emailID st_emailID', 'st.phoneNumbers st_phoneNumbers', 'st.locationName st_locationName', 'st.linkedinpublicid st_linkedinpublicid', 'st.url_publicIdentifier st_url_publicIdentifier', 'st.occupation st_occupation', 'st.companyDetail st_companyDetail', 'st.tags st_tags', 'st.sequenceIds st_sequenceIds', 'st.response response', 'b.firstName', 'b.lastName', 'b.is_accepted', 'b.is_response', 'b.url_publicIdentifier', 'b.profileInfo_id', 'b.companyInfo_id', 'sp.created', 'b.updated_at', 'b.seq_id', 'b.seq_name', 'p.basicInfo', 'p.contactInfo', 'c.company_li_id', 'c.company_page_url', 'c.company_detail', 'b.tags']
			)
			->from('suppressionlist sp')
			->join('LEFT OUTER JOIN', 'blacklist b', 'sp.personId = b.linkedinpublicid AND b.userid = sp.userId')
			->join('LEFT OUTER JOIN', '1stdegreedata st', 'sp.personId = st.linkedinpublicid AND st.userId = sp.userId')
			->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
			->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')
			->where(['sp.userId' => Yii::$app->session->get('userid')]);
			/* ->andWhere("profileInfo_id !=0  and companyInfo_id != 0 ")
			->andWhere("b.userid = sp.userId"); */
			if(!empty($s_date) && !empty($e_date) )
			{
				$query->andWhere("((DATE(convert_tz(b.created_at,'+00:00','" . $hour_min . "')) BETWEEN '" . $s_date . "' AND '" . $e_date . "') OR b.created_at is NULL)");  
			}
			if(!empty($tagIds)){
				$query->andWhere('(FIND_IN_SET(:tag_id,b.tags) OR FIND_IN_SET(:tag_id,st.tags))')
				->addParams([':tag_id' => $tagIds]);
			}
			if(!empty($seqIds)){
				$query->andWhere('(b.seq_id='.$seqIds.' OR (FIND_IN_SET(:seq_id,st.sequenceIds)))')
				->addParams([':seq_id' => $seqIds]);
			}
			
			if(!empty($firstName)){
				$qry=" (basicInfo LIKE'%" . $firstName . "%' or firstName LIKE'%" . $firstName . "%' or ";
			}
			
			if(!empty($lastName)){
				$qry.="basicInfo LIKE'%" . $lastName . "%' or lastName LIKE'%" . $lastName . "%'  or ";
			}
			if(!empty($email)){
				$qry.="contactInfo LIKE'%" . $email . "%' or emailID LIKE'%" . $email . "%' ) ";
			}
			
			if(!empty($qry)){
				$query->andWhere($qry);
			}
			
			$query->orderBy(['sp.created' => SORT_DESC]);
			
			/* echo $query->createCommand()->getRawSql();
            exit; */
		}else{
			$query1 = (new \yii\db\Query())
				->select('`b`.`profileInfo_id`, `b`.`companyInfo_id`, `b`.`id`, CONVERT(`b`.`linkedinpublicid` USING utf8) AS `linkedinpublicid`, CONVERT(`b`.`firstName` USING utf8) AS `firstName`, CONVERT(`b`.`lastName` USING utf8) AS `lastName`, `b`.`is_accepted`, `b`.`is_response`, CONVERT("" USING utf8) AS `emailID`, CONVERT("" USING utf8) AS `phoneNumbers`, CONVERT("" USING utf8) AS `locationName`, CONVERT(`b`.`url_publicIdentifier` USING utf8) AS `url_publicIdentifier`, `b`.`created_at`, `b`.`updated_at`, CONVERT(`b`.`seq_id` USING utf8) AS `seq_id`, CONVERT(`b`.`seq_name` USING utf8) AS `seq_name`, CONVERT(`b`.`tags` USING utf8) AS tags, `c`.`company_li_id`, CONVERT(`c`.`company_page_url` USING utf8) AS `company_page_url`, CONVERT(`c`.`company_detail` USING utf8) AS `company_detail`, CONVERT(`p`.`basicInfo` USING utf8) AS `basicInfo`, CONVERT(`p`.`contactInfo` USING utf8) AS `contactInfo`, CONVERT("" USING utf8) AS `occupation` , CONVERT("{}" USING utf8) AS `response`')
				->from('blacklist b')
				->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
				->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')
				->where(['b.userid' => Yii::$app->session->get('userid')]);
			if(!empty($s_date) && !empty($e_date) )
			{
				$query1->andWhere("(DATE(convert_tz(b.created_at,'+00:00','" . $hour_min . "')) BETWEEN '" . $s_date . "' AND '" . $e_date . "')");
			}
			$query2 = (new \yii\db\Query())
				->select('0 as `profileInfo_id`, 0 as `companyInfo_id`, `st`.`id`, CONVERT(`st`.`linkedinpublicid` USING utf8) AS `linkedinpublicid`, CONVERT(`st`.`fullname` USING utf8) AS `firstName`, CONVERT("" USING utf8) AS `lastName`, 0 as `is_accepted`, 0 as `is_response`, CONVERT(`st`.`emailID` USING utf8) AS `emailID`, CONVERT(`st`.`phoneNumbers` USING utf8) AS `phoneNumbers`, CONVERT(`st`.`locationName` USING utf8) AS `locationName`, CONVERT(`st`.`url_publicIdentifier` USING utf8) AS `url_publicIdentifier`, "" as `created_at`, "" as `updated_at`, CONVERT(`st`.`sequenceIds` USING utf8) AS `seq_id`, CONVERT("" USING utf8) AS `seq_name`, CONVERT(`st`.`tags` USING utf8) AS tags, "-1" as `company_li_id`, CONVERT("" USING utf8) AS `company_page_url`, CONVERT(`st`.`companyDetail` USING utf8) AS `company_detail`, CONVERT("" USING utf8) AS `basicInfo`, CONVERT("" USING utf8) AS `contactInfo`, CONVERT(`st`.`occupation` USING utf8) AS `occupation`,CONVERT(`st`.`response` USING utf8) AS `response`') 
				->from('1stdegreedata st')
				->where(['st.userId' => Yii::$app->session->get('userid')]);
				//->where("firstName LIKE'%" . $name . "%' $and $whereClause $tagAnd $tagwhereClause")
			$query = (new \yii\db\Query())
			->from(['dummy_name' => $query1->union($query2)])
			->from(['dummy_name' => $query1->union($query2)])
			->orderBy(['created_at' =>SORT_DESC ])
			->groupBy(['linkedinpublicid']); 
			if(!empty($tagIds)){
				$query->andWhere('FIND_IN_SET(:tag_id,tags)')
				->addParams([':tag_id' => $tagIds]);
			}
			if(!empty($seqIds)){
				$query->andWhere(' (FIND_IN_SET(:seq_id,seq_id))')
				->addParams([':seq_id' => $seqIds]);
			}
			
			if(!empty($firstName)){
				$qry=" (basicInfo LIKE'%" . $firstName . "%' or firstName LIKE'%" . $firstName . "%' or ";
			}
			
			if(!empty($lastName)){
				$qry.="basicInfo LIKE'%" . $lastName . "%' or lastName LIKE'%" . $lastName . "%'  or ";
			}
			if(!empty($email)){
				$qry.="contactInfo LIKE'%" . $email . "%' or emailID LIKE'%" . $email . "%' ) ";
			}
			
			if(!empty($qry)){
				$query->andWhere($qry);
			}
			/* echo $query->createCommand()->getRawSql();
            exit; */
		}
		
		 
        /* echo $query->createCommand()->getRawSql();
            exit;   */
			 

        //$countQuery = clone $query;
		$exportData = $query->all();
		//print_r($models);exit;
		$data = ",,,," . Yii::$app->params['sitetitle'] . " Export data ,\r\nTime," . date('Y-m-d h:m:s') . " (UTC + 00),,Type," . $lead_title . "\r\n\r\nFirstName,LastName,Occupation,Company Name,Industry Name,Location,Country Code,Postal Code,Business email,Profile Email,Profile Phone,Company Page URL,LI Profile URL,Created At,Updated At ,Seq Name,Status,Responded,Tags\r\n";
		/* print_r($exportData);exit; */
		/* if(Yii::$app->session->get('userid')=='16839'){
			  print_r($exportData);exit; 
			}  */
        foreach ($exportData as $data_export) {
			if(isset($data_export['url_publicIdentifier'])){
				$url_publicIdentifier = $data_export['url_publicIdentifier'];
			}elseif(isset($data_export['st_url_publicIdentifier'])){
				$url_publicIdentifier = $data_export['st_url_publicIdentifier']; 
			}
			$updated_at = "NA";
			$created_at = "NA";
			if(isset($data_export['created_at']) && !empty($data_export['created_at'])){
				$created_at = $data_export['created_at'];
			}
			if(isset($data_export['updated_at']) && !empty($data_export['updated_at'])){
				$updated_at = $data_export['updated_at'];
			}
            $basicInfo = $data_export['basicInfo'];
            $contactInfo = $data_export['contactInfo'];
			if(isset($data_export['company_detail'])){
				$company_detail = $data_export['company_detail'];
			}elseif(isset($data_export['st_companyDetail'])){
				$company_detail = $data_export['st_companyDetail'];
			}
            $seq_name = $data_export['seq_name'];

            $tagnames = '';
			if(empty($data_export['lastName']) && !empty($data_export['seq_id'])){
				$seqIds=$data_export['seq_id'];
				$seqNames= Yii::$app->db->createCommand("SELECT name FROM `ext_sequences` WHERE id in($seqIds)")->queryColumn();
				$seq_name=implode(",",$seqNames);
			}
            if (isset($data_export['tags']) && $data_export['tags'] != '') {

                $tagnamesdata = explode(",", $data_export['tags']);
                foreach ($tagnamesdata as $key => $val) {
                    $intagdata = Yii::$app->db->createCommand("select  tagName  from  tags  where id =" . $val)->queryOne();
                    $tagnames .= $intagdata['tagName'] . ';';
                }

                $tagnames = trim($tagnames, ";");
            }
			
			$status = 'NA';
			
			if ($filter=="pending") {
				$status = 'Pending';
			}
            if ($data_export['is_accepted'] == '1') {
                $status = 'Accepted';
            }
			
			$responded = 'No';
			if(empty($data_export['lastName'])){
				$responded = 'NA';
			}            
            if ($data_export['is_response'] == '1') {
                $responded = 'Yes';
            }
			
            $basicInfo = preg_replace('/\s+/', ' ', $basicInfo);
            $basicInfo = str_replace("'", "", $basicInfo);

            $basicInfo = json_decode($basicInfo);
            $contactInfo = trim($contactInfo, '"');
            $contactInfo = preg_replace('/\s+/', ' ', $contactInfo);
            $contactInfo = str_replace("'", "", $contactInfo);
            $contactInfo = json_decode($contactInfo);
            //$company_detail = json_decode($company_detail);
			if(!empty($company_detail) && is_object($company_detail)){
				$company_detail = $company_detail;
			}elseif(!empty($company_detail) && !is_object($company_detail)){
				$company_detail = json_decode(preg_replace('/""[^,](.+?)""/','"$1"',$company_detail));
			}else{
				$company_detail = '';
			}
			/* if(Yii::$app->session->get('userid')=='16839'){
			  print_r($company_detail);exit;
			}  */
			$firstName = "NA";
			$lastName = "NA";
			$occupation = "NA";
			$companyName = "NA";
			$industryName = "NA";
			$countryCode = "NA";
			$postalCode = "NA";
			$bemail = "NA";
			$emailAddress = "NA";
			$phoneNumbers = 'NA';
			$companyPageUrl = "NA";
			$locationName ="NA";
			$url = "NA";
			
			if (isset($data_export['firstName'])) {
				$firstName = str_replace(",", "-", $this->unicodeString($data_export['firstName']));
			}
			if (isset($data_export['st_firstName'])) {
				$firstName = str_replace(",", "-", $this->unicodeString($data_export['st_firstName']));
			}
			if(empty($data_export['lastName'])){
				if (isset($data_export['firstName'])) {
					$name=explode(" ",$data_export['firstName']);
					$firstName = str_replace(",", "-", $this->unicodeString($name[0]));
					$lastName = str_replace(",", "-", $this->unicodeString($name[1]));
				}	
				if(!empty($data_export['st_firstName'])){
					$name=explode(" ",$data_export['st_firstName']);
					$firstName = str_replace(",", "-", $this->unicodeString($name[0]));
					$lastName = str_replace(",", "-", $this->unicodeString($name[1]));
				}					
			}
			if (isset($data_export['lastName'])) {
				$lastName = str_replace(",", "-", $this->unicodeString($data_export['lastName']));
			}
			if(empty($data_export['lastName'])){
				if (isset($data_export['firstName'])) {
					$name=explode(" ",$data_export['firstName']);
					$firstName = str_replace(",", "-", $this->unicodeString($name[0]));
					$lastName = str_replace(",", "-", $this->unicodeString($name[1]));
				}				
			}
			if(isset($data_export['occupation'])){
				$occupation = str_replace(",", "-", $this->unicodeString($data_export['occupation']));
			}
			if(isset($data_export['st_occupation'])){
				$occupation = str_replace(",", "-", $this->unicodeString($data_export['st_occupation']));
			}
            if (isset($basicInfo->occupation)) {
                $occupation = str_replace(",", "-", $this->unicodeString($basicInfo->occupation));
            }
			
			
			
			if(isset($basicInfo->locationName) && !empty($basicInfo->locationName)){
				$locationName = str_replace(",", "-", $this->unicodeString($basicInfo->locationName));
			}elseif(isset($data_export['locationName']) && !empty($data_export['locationName'])){
				$locationName = $data_export['locationName'];
			}elseif(isset($data_export['st_locationName']) && !empty($data_export['st_locationName'])){
				$locationName = $data_export['st_locationName'];
			}  
			
            if (isset($company_detail->companyName) && !empty($company_detail->companyName)) {
                $companyName = str_replace(",", "-", $this->unicodeString($company_detail->companyName));
            }
			if (isset($basicInfo->companyName) && !empty($basicInfo->companyName)) {
                $companyName = str_replace(",", "-", $this->unicodeString($basicInfo->companyName));
            } 
			
            if (isset($basicInfo->industryName) && !empty($basicInfo->industryName)) {
                $industryName = str_replace(",", "-", $this->unicodeString($basicInfo->industryName));
            }
			
            if (isset($basicInfo->countryCode) && !empty($basicInfo->countryCode)) {
                $countryCode = str_replace(",", "-", $basicInfo->countryCode);
            } 
			
            if (isset($basicInfo->postalCode) && !empty($basicInfo->postalCode)) {
                $postalCode = str_replace(",", "-", $basicInfo->postalCode);
            }
			
            if (isset($basicInfo->bemail) && !empty($basicInfo->bemail)) {
                $bemail = str_replace(",", "-", $basicInfo->bemail);
            }
			if (isset($data_export['emailID']) && !empty($data_export['emailID'])) {
                $emailAddress = $data_export['emailID'];
            }
			if (isset($data_export['st_emailID']) && !empty($data_export['st_emailID'])) {
                $emailAddress = $data_export['st_emailID'];
            }
            if (isset($contactInfo->emailAddress) && !empty($contactInfo->emailAddress)) {
                $emailAddress = str_replace(",", "-", $contactInfo->emailAddress);
            } 
			if (isset($data_export['phoneNumbers']) && !empty($data_export['phoneNumbers'])) {
                $phoneNumbers = $data_export['phoneNumbers'];
            }
			if (isset($data_export['st_phoneNumbers']) && !empty($data_export['st_phoneNumbers'])) {
                $phoneNumbers = $data_export['st_phoneNumbers'];
            }
            if (isset($contactInfo->phoneNumbers) && !empty($contactInfo->phoneNumbers)) {
                if (isset($contactInfo->phoneNumbers[0]->number)) {
                    $phoneNumbers = $contactInfo->phoneNumbers[0]->number;
                } 
            } 
			
			if (isset($data_export['company_page_url'])&& !empty($data_export['company_page_url'])) {
                $companyPageUrl = $data_export['company_page_url'];
            }
            if (isset($company_detail->companyPageUrl) && !empty($company_detail->companyPageUrl)) {
                $companyPageUrl = str_replace(",", "-", $company_detail->companyPageUrl);
            } 
			
            if (isset($url_publicIdentifier)) {
                $url = "https://www.linkedin.com/in/" . $url_publicIdentifier;
            } 
			
            if (isset($created_at)) {
                $created_at = $created_at;
            } 
            if (isset($updated_at)) {
                $updated_at = $updated_at;
            } 

            if (isset($seq_name) && $seq_name != '') {
				//seq name Query 
                $seq_name = str_replace(",", "-", $seq_name);
            } else {
                $seq_name = "NA";
            } 
				
            $data .= $firstName .
                    ',' . $lastName .
                    ',' . $occupation .
                    ',' . $companyName .
                    ',' . $industryName .
					',' . $locationName .
                    ',' . $countryCode .
                    ',' . $postalCode .
                    ',' . $bemail .
                    ',' . $emailAddress .
                    ',' . $phoneNumbers .
                    ',' . $companyPageUrl .
                    ',' . $url .
                    ',' . $created_at .
                    ',' . $updated_at .
                    ',' . $seq_name .
                    ',' . $status .
                    ',' . $responded .
                    ',' . $tagnames .
                    "\r\n";
        }

		
        header("Content-type: text/csv");
        header("Content-Disposition: attachment; filename=" . Yii::$app->params['sitetitle'] . ".csv");
        header("Pragma: no-cache");
        header("Expires: 0");

        echo $data . "\n";
        die;
        /* print_r($models);exit; */
    }
    public function actionExportold() {
        $addfilter = '';
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (isset($_GET['prospectsearchname']) && $_GET['prospectsearchname'] != "") {
            $addfilter = "AND  basicInfo LIKE'%" . $_GET['prospectsearchname'] . "%'";
        }

        $seqFilters = "";
        if (isset($_GET['seqFilters']) && $_GET['seqFilters'] != "") {
            $seqFilters = " AND  b.seq_id= '" . $_GET['seqFilters'] . "'";
        }

        if ($_GET['assign_tagExport'] != "") {
            $tsgfilter = " AND  b.tags LIKE'%" . $_GET['assign_tagExport'] . "%'";
        } else {
            $tsgfilter = "";
        }

        
		
        /*
          if ($_GET['start_point'] == 0) {
          $start_point = $_GET['start_point'];
          } else {
          $start_point = $_GET['start_point'] - 1;
          }
          if ($export_option == "all") {
          $exportData = Yii::$app->db->createCommand("SELECT `b`.`linkedinpublicid`, `b`.`url_publicIdentifier`,`b`.`is_accepted`,`b`.`seq_name`, `b`.`profileInfo_id`, `b`.`companyInfo_id`, `b`.`created_at`, `b`.`updated_at`, `p`.`basicInfo`, `p`.`contactInfo`, `c`.`company_li_id`, `c`.`company_page_url`, `c`.`company_detail`, `b`.`is_response` FROM `blacklist` `b` LEFT OUTER JOIN `companyinfo` `c` ON c.id =b.companyInfo_id LEFT OUTER JOIN `profileinfo` `p` ON p.id =b.profileInfo_id WHERE (`userid`=" . Yii::$app->session->get('userid') . ") AND (profileInfo_id !=0 and companyInfo_id != 0 ) " . $addfilter . "ORDER BY b.updated_at DESC LIMIT 300 OFFSET " . $start_point . "")->queryAll();
          } else {
          $exportData = Yii::$app->db->createCommand("SELECT `b`.`linkedinpublicid`, `b`.`url_publicIdentifier`,`b`.`is_accepted`, `b`.`seq_name`,`b`.`profileInfo_id`, `b`.`companyInfo_id`, `b`.`created_at`, `b`.`updated_at`, `p`.`basicInfo`, `p`.`contactInfo`, `c`.`company_li_id`, `c`.`company_page_url`, `c`.`company_detail`, `b`.`is_response` FROM `blacklist` `b` LEFT OUTER JOIN `companyinfo` `c` ON c.id =b.companyInfo_id LEFT OUTER JOIN `profileinfo` `p` ON p.id =b.profileInfo_id WHERE (`userid`=" . Yii::$app->session->get('userid') . ") AND (profileInfo_id !=0 and companyInfo_id != 0 ) And (is_accepted = '" . $export_option . "')  " . $addfilter . "ORDER BY b.updated_at DESC LIMIT 300 OFFSET " . $start_point . "")->queryAll();
          }
         */


        //NR starts
        $s_date = implode('-', array_reverse(explode('/', $_GET['pstart_date'])));
        $e_date = implode('-', array_reverse(explode('/', $_GET['pend_date'])));

		/* print_r($_GET);exit; */
        $userData = Yii::$app->db->createCommand("select  *  from  user  where id =" . Yii::$app->session->get('userid'))->queryOne();
        //$tz = timezone_open("America/New_York");//Asia/Kolkata
        $tz = timezone_open($userData['TimeZone']); //Asia/Kolkata
        //echo 'a1:<pre>'; print_r($tz);
        $datetime = date_create("now", timezone_open("UTC"));
        //echo '<br/>a2:<pre>'; print_r($datetime);
        $offset = timezone_offset_get($tz, $datetime);
        if ($offset >= 0) {
            $offset = $offset;
            $sign = "+";
        } else {
            $offset = abs($offset);
            $sign = "-";
        }
        $hour_min = $sign . gmdate("H:i", $offset);
        //echo '<br/>a5:'.date_default_timezone_get();
        //echo '<br/>a6:'.date('Y-m-d H:i:s');
        //echo '<br/>a6:'.gmdate('Y-m-d H:i:s');

        if ($export_option == "all") {
            $exportData = Yii::$app->db->createCommand("SELECT convert_tz(b.created_at,'+00:00','" . $hour_min . "') as user_timezone,`b`.`linkedinpublicid`, `b`.`url_publicIdentifier`,`b`.`is_accepted`,`b`.`seq_name`, `b`.`profileInfo_id`, `b`.`companyInfo_id`, `b`.`created_at`, `b`.`updated_at`, `p`.`basicInfo`, `p`.`contactInfo`, `c`.`company_li_id`, `c`.`company_page_url`, `c`.`company_detail`, `b`.`is_response`,`b`.`tags` FROM `blacklist` `b` LEFT OUTER JOIN `companyinfo` `c` ON c.id =b.companyInfo_id LEFT OUTER JOIN `profileinfo` `p` ON p.id =b.profileInfo_id WHERE (DATE(convert_tz(b.created_at,'+00:00','" . $hour_min . "')) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND (`userid`=" . Yii::$app->session->get('userid') . ") AND (profileInfo_id !=0 and companyInfo_id != 0 ) " . $addfilter . $tsgfilter . $seqFilters . " ORDER BY b.updated_at DESC")->queryAll();
        } elseif ($export_option == "responded") {
            $exportData = Yii::$app->db->createCommand("SELECT convert_tz(b.created_at,'+00:00','" . $hour_min . "') as user_timezone, `b`.`linkedinpublicid`, `b`.`url_publicIdentifier`,`b`.`is_accepted`, `b`.`seq_name`,`b`.`profileInfo_id`, `b`.`companyInfo_id`, `b`.`created_at`, `b`.`updated_at`, `p`.`basicInfo`, `p`.`contactInfo`, `c`.`company_li_id`, `c`.`company_page_url`, `c`.`company_detail`, `b`.`is_response`,`b`.`tags` FROM `blacklist` `b` LEFT OUTER JOIN `companyinfo` `c` ON c.id =b.companyInfo_id LEFT OUTER JOIN `profileinfo` `p` ON p.id =b.profileInfo_id WHERE (DATE(convert_tz(b.created_at,'+00:00','" . $hour_min . "')) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND (`userid`=" . Yii::$app->session->get('userid') . ") AND (profileInfo_id !=0 and companyInfo_id != 0 ) And (is_response = '1')  " . $addfilter . $tsgfilter . $seqFilters . " ORDER BY b.updated_at DESC")->queryAll();
        } else {
            $exportData = Yii::$app->db->createCommand("SELECT convert_tz(b.created_at,'+00:00','" . $hour_min . "') as user_timezone, `b`.`linkedinpublicid`, `b`.`url_publicIdentifier`,`b`.`is_accepted`, `b`.`seq_name`,`b`.`profileInfo_id`, `b`.`companyInfo_id`, `b`.`created_at`, `b`.`updated_at`, `p`.`basicInfo`, `p`.`contactInfo`, `c`.`company_li_id`, `c`.`company_page_url`, `c`.`company_detail`, `b`.`is_response`,`b`.`tags` FROM `blacklist` `b` LEFT OUTER JOIN `companyinfo` `c` ON c.id =b.companyInfo_id LEFT OUTER JOIN `profileinfo` `p` ON p.id =b.profileInfo_id WHERE (DATE(convert_tz(b.created_at,'+00:00','" . $hour_min . "')) BETWEEN '" . $s_date . "' AND '" . $e_date . "') AND (`userid`=" . Yii::$app->session->get('userid') . ") AND (profileInfo_id !=0 and companyInfo_id != 0 ) And (is_accepted = '" . $export_option . "')  " . $addfilter . $tsgfilter . $seqFilters . " ORDER BY b.updated_at DESC")->queryAll();
        }
        //NR ends

        $data = ",,,," . Yii::$app->params['sitetitle'] . " Export data ,\r\nTime," . date('Y-m-d h:m:s') . " (UTC + 00),,Type," . $lead_title . "\r\n\r\nFirstName,LastName,Occupation,Company Name,Industry Name,Country Code,Postal Code,Business email,Profile Email,Profile Phone,Company Page URL,LI Profile URL,Created At,Updated At ,Seq Name,Status,Responded,Tags\r\n";

        foreach ($exportData as $data_export) {

            $url_publicIdentifier = $data_export['url_publicIdentifier'];
            $basicInfo = $data_export['basicInfo'];
            $created_at = $data_export['created_at'];
            $updated_at = $data_export['updated_at'];
            $contactInfo = $data_export['contactInfo'];
            $company_detail = $data_export['company_detail'];

            $seq_name = $data_export['seq_name'];

            $tagnames = '';

            if (isset($data_export['tags']) && $data_export['tags'] != '') {

                $tagnamesdata = explode(",", $data_export['tags']);
                foreach ($tagnamesdata as $key => $val) {
                    $intagdata = Yii::$app->db->createCommand("select  tagName  from  tags  where id =" . $val)->queryOne();
                    $tagnames .= $intagdata['tagName'] . ';';
                }

                $tagnames = trim($tagnames, ";");
            }

            $status = 'Pending';
            if ($data_export['is_accepted'] == '1') {
                $status = 'Accepted';
            }

            $responded = 'No';
            if ($data_export['is_response'] == '1') {
                $responded = 'Yes';
            }
            $basicInfo = preg_replace('/\s+/', ' ', $basicInfo);
            $basicInfo = str_replace("'", "", $basicInfo);

            $basicInfo = json_decode($basicInfo);
            $contactInfo = trim($contactInfo, '"');
            $contactInfo = preg_replace('/\s+/', ' ', $contactInfo);
            $contactInfo = str_replace("'", "", $contactInfo);
            $contactInfo = json_decode($contactInfo);
            $company_detail = json_decode($company_detail);
            if (isset($basicInfo->firstName)) {
                $firstName = str_replace(",", "-", $this->unicodeString($basicInfo->firstName));
            } else {
                $firstName = "NA";
            }
            if (isset($basicInfo->lastName)) {
                $lastName = str_replace(",", "-", $this->unicodeString($basicInfo->lastName));
            } else {
                $lastName = "NA";
            }
            if (isset($basicInfo->occupation)) {
                $occupation = str_replace(",", "-", $this->unicodeString($basicInfo->occupation));
            } else {
                $occupation = "NA";
            }
            if (isset($basicInfo->companyName)) {
                $companyName = str_replace(",", "-", $this->unicodeString($basicInfo->companyName));
            } else {
                $companyName = "NA";
            }
            if (isset($basicInfo->industryName)) {
                $industryName = str_replace(",", "-", $this->unicodeString($basicInfo->industryName));
            } else {
                $industryName = "NA";
            }
            if (isset($basicInfo->countryCode)) {
                $countryCode = str_replace(",", "-", $basicInfo->countryCode);
            } else {
                $countryCode = "NA";
            }
            if (isset($basicInfo->postalCode)) {
                $postalCode = str_replace(",", "-", $basicInfo->postalCode);
            } else {
                $postalCode = "NA";
            }

            if (isset($basicInfo->bemail)) {
                $bemail = str_replace(",", "-", $basicInfo->bemail);
            } else {
                $bemail = "NA";
            }
            if (isset($contactInfo->emailAddress)) {
                $emailAddress = str_replace(",", "-", $contactInfo->emailAddress);
            } else {
                $emailAddress = "NA";
            }

            if (isset($contactInfo->phoneNumbers)) {

                if (isset($contactInfo->phoneNumbers[0]->number)) {
                    $phoneNumbers = $contactInfo->phoneNumbers[0]->number;
                } else {
                    $phoneNumbers = 'NA';
                }
            } else {
                $phoneNumbers = "NA";
            }

            if (isset($company_detail->companyPageUrl)) {
                $companyPageUrl = str_replace(",", "-", $company_detail->companyPageUrl);
            } else {
                $companyPageUrl = "NA";
            }
            if (isset($url_publicIdentifier)) {
                $url = "https://www.linkedin.com/in/" . $url_publicIdentifier;
            } else {
                $url = "NA";
            }
            if (isset($created_at)) {
                $created_at = $created_at;
            } else {
                $created_at = "NA";
            }
            if (isset($updated_at)) {
                $updated_at = $updated_at;
            } else {
                $updated_at = "NA";
            }


            if (isset($seq_name) && $seq_name != '') {
                $seq_name = str_replace(",", "-", $seq_name);
            } else {
                $seq_name = "NA";
            }



            $data .= $firstName .
                    ',' . $lastName .
                    ',' . $occupation .
                    ',' . $companyName .
                    ',' . $industryName .
                    ',' . $countryCode .
                    ',' . $postalCode .
                    ',' . $bemail .
                    ',' . $emailAddress .
                    ',' . $phoneNumbers .
                    ',' . $companyPageUrl .
                    ',' . $url .
                    ',' . $created_at .
                    ',' . $updated_at .
                    ',' . $seq_name .
                    ',' . $status .
                    ',' . $responded .
                    ',' . $tagnames .
                    "\r\n";
        }


        header("Content-type: text/csv");
        header("Content-Disposition: attachment; filename=" . Yii::$app->params['sitetitle'] . ".csv");
        header("Pragma: no-cache");
        header("Expires: 0");

        echo $data . "\n";
        die;
    }

// End: Prospect Export






    public function actionProfileSetting() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }

        $UserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid') . " AND id =" . Yii::$app->session->get('userid'))->queryOne();

        /*
          $proxyIp = $UserDetail['proxyIp'];
          $proxyPort = $UserDetail['proxyPort'];
          $proxyUsername = $UserDetail['proxyUsername'];
          $proxyPassword = $UserDetail['proxyPassword'];
          $cookie = $UserDetail['cookie'];
          $csrf = $UserDetail['csrf'];

          $profileData = array();


          //06June2020 starts
          $profileData['pic_100_100'] = '';
          $profileData['pic_400_400'] = '';
          $apiRes_me = '';

          $profileData['numConnections'] = 0;
          $profileData['pendingConnections'] = 0;
          $profileData['numTotalSentInvitations'] = 0;


          $apiRes_IdentityProfilesProfileView = '';
          $apiRes_IdentityProfilesProfileContactInfo = '';
          //06June2020 ends



          if ($proxyIp && $proxyPort && $proxyUsername && $proxyPassword){

          if (!empty($cookie) && !empty($csrf)) {
          $curl = curl_init();
          curl_setopt_array($curl, array(
          CURLOPT_URL => "https://www.linkedin.com/voyager/api/me",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_HTTPPROXYTUNNEL => 1,
          CURLOPT_PROXY => "$proxyIp",
          CURLOPT_PROXYPORT => "$proxyPort",
          CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_HTTPHEADER => array(
          "cookie: $cookie",
          "csrf-token: $csrf",
          "x-http-method-override: GET",
          "Host: www.linkedin.com",
          "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36",
          "Accept-Language: en-US,en;q=0.5",
          "Accept-Encoding: gzip, deflate, br",
          "content-type: application/x-www-form-urlencoded",
          "x-li-lang: en_US",
          "x-restli-protocol-version: 2.0.0",
          "Origin: https://www.linkedin.com",
          "TE: Trailers"
          ),
          ));
          $curlResult = curl_exec($curl);
          if (!empty($curlResult)) {
          $apiRes_me = $decodedRes = json_decode($curlResult);
          //echo 'C:<pre>'; print_r($decodedRes);
          $picture = (array) $decodedRes->miniProfile->picture;
          $profileData['pic_100_100'] = $picture['com.linkedin.common.VectorImage']->rootUrl . $picture['com.linkedin.common.VectorImage']->artifacts[0]->fileIdentifyingUrlPathSegment;
          $profileData['pic_400_400'] = $picture['com.linkedin.common.VectorImage']->rootUrl . $picture['com.linkedin.common.VectorImage']->artifacts[2]->fileIdentifyingUrlPathSegment;
          \Yii::$app->session->set('top_profile_pic', $profileData['pic_100_100']);
          } else {
          $profileData['pic_100_100'] = '';
          $profileData['pic_400_400'] = '';
          $apiRes_me = '';
          }
          }



          if (!empty($cookie) && !empty($csrf)) {
          $curlConnectionDetails = curl_init();
          curl_setopt_array($curlConnectionDetails, array(
          CURLOPT_URL => "https://www.linkedin.com/voyager/api/relationships/connectionsSummary/",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_HTTPPROXYTUNNEL => 1,
          CURLOPT_PROXY => "$proxyIp",
          CURLOPT_PROXYPORT => "$proxyPort",
          CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_HTTPHEADER => array(
          "cookie: $cookie",
          "csrf-token: $csrf",
          "x-http-method-override: GET",
          "Host: www.linkedin.com",
          "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36",
          "Accept-Language: en-US,en;q=0.5",
          "Accept-Encoding: gzip, deflate, br",
          "content-type: application/x-www-form-urlencoded",
          "x-li-lang: en_US",
          "x-restli-protocol-version: 2.0.0",
          "Origin: https://www.linkedin.com",
          "TE: Trailers"
          ),
          ));
          $connectionDetailsRes = curl_exec($curlConnectionDetails);
          if (!empty($connectionDetailsRes)) {
          $decodedJsonRes = json_decode($connectionDetailsRes);
          //echo 'AA:<pre>'; print_r($decodedJsonRes);
          $profileData['numConnections'] = $decodedJsonRes->numConnections;
          } else {
          $profileData['numConnections'] = 0;
          }
          $curlInvitationDetails = curl_init();
          curl_setopt_array($curlInvitationDetails, array(
          CURLOPT_URL => "https://www.linkedin.com/voyager/api/relationships/invitationsSummaryV2?types=List(SENT_INVITATION_COUNT,PENDING_INVITATION_COUNT,UNSEEN_INVITATION_COUNT,PENDING_INVITATION_BY_FACET_COUNT)",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_HTTPPROXYTUNNEL => 1,
          CURLOPT_PROXY => "$proxyIp",
          CURLOPT_PROXYPORT => "$proxyPort",
          CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_HTTPHEADER => array(
          "accept: application/vnd.linkedin.normalized+json+2.1",
          "cookie: $cookie",
          "csrf-token: $csrf",
          //"x-http-method-override: GET",
          "Host: www.linkedin.com",
          "User-Agent: Mozilla/5.0 (Windows NT 6.1; rv:75.0) Gecko/20100101 Firefox/75.0",

          "accept-language: en-US,en;q=0.9",
          //"Accept-Encoding: gzip, deflate, br",
          //"content-type: application/x-www-form-urlencoded",
          "content-type: application/vnd.linkedin.normalized+json+2.1",
          "x-li-lang: en_US",
          //'x-li-track: {"clientVersion":"1.6.3394","osName":"web","timezoneOffset":5.5,"deviceFormFactor":"DESKTOP","mpName":"voyager-web","displayDensity":1}',
          "x-restli-protocol-version: 2.0.0",
          "Origin: https://www.linkedin.com",
          //"TE: Trailers"
          ),
          ));
          $invitationDetailsRes = curl_exec($curlInvitationDetails);
          if (!empty($invitationDetailsRes)) {
          $decodedJsonResInvDtls = json_decode($invitationDetailsRes);
          $profileData['numTotalSentInvitations'] = $decodedJsonResInvDtls->data->numTotalSentInvitations;
          $profileData['pendingConnections'] = $decodedJsonResInvDtls->data->numPendingInvitations;
          //echo 'BBSDSD:<pre>'; print_r($decodedJsonResInvDtls);
          //$profileData['pendingConnections'] = $decodedJsonResInvDtls->elements[1]->count;
          } else {
          //$profileData['pendingConnections'] = 0;
          }
          }




          //NR starts
          if ($apiRes_me != '') {
          $publicIdentifier = $apiRes_me->miniProfile->publicIdentifier;
          $curl = curl_init();
          curl_setopt_array($curl, array(
          CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $publicIdentifier . "/profileView",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_HTTPPROXYTUNNEL => 1,
          CURLOPT_PROXY => "$proxyIp",
          CURLOPT_PROXYPORT => "$proxyPort",
          CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_HTTPHEADER => array(
          "cookie: $cookie",
          "csrf-token: $csrf",
          "x-http-method-override: GET",
          "Host: www.linkedin.com",
          "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36",
          "Accept-Language: en-US,en;q=0.5",
          "Accept-Encoding: gzip, deflate, br",
          "content-type: application/x-www-form-urlencoded",
          "x-li-lang: en_US",
          "x-restli-protocol-version: 2.0.0",
          "Origin: https://www.linkedin.com",
          "TE: Trailers"
          ),
          ));
          $curlResult = curl_exec($curl);
          //echo '<br/>LINE:'.__LINE__.':::'; echo $curlResult;
          $apiRes_IdentityProfilesProfileView = json_decode($curlResult);
          //echo 'C:<pre>'; print_r($apiRes_IdentityProfilesProfileView);die;
          curl_close($curl);

          $curl = curl_init();
          curl_setopt_array($curl, array(
          CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $publicIdentifier . "/profileContactInfo",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_HTTPPROXYTUNNEL => 1,
          CURLOPT_PROXY => "$proxyIp",
          CURLOPT_PROXYPORT => "$proxyPort",
          CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_HTTPHEADER => array(
          "cookie: $cookie",
          "csrf-token: $csrf",
          "x-http-method-override: GET",
          "Host: www.linkedin.com",
          "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36",
          "Accept-Language: en-US,en;q=0.5",
          "Accept-Encoding: gzip, deflate, br",
          "content-type: application/x-www-form-urlencoded",
          "x-li-lang: en_US",
          "x-restli-protocol-version: 2.0.0",
          "Origin: https://www.linkedin.com",
          "TE: Trailers"
          ),
          ));
          $curlResult = curl_exec($curl);
          //echo '<br/>LINE:'.__LINE__.':::'; echo $curlResult;
          $apiRes_IdentityProfilesProfileContactInfo = json_decode($curlResult);
          curl_close($curl);
          }
          //NR ends



          }

         */








//Arpan : adding temp fix
//$addBlaklist_OnAcceptance=Yii::$app->db->createCommand("select * from dynamic_setting where `key` = 'addBlaklist_OnAcceptance'")->queryOne();
/// 
        //  $sql =Yii::$app->db->createCommand("UPDATE `user` SET `addBlaklist_OnAcceptance` = '".$UserDetail['addBlaklist_OnAcceptance']."' WHERE `id` = ".Yii::$app->session->get('userid')." ")->execute();
        //$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        // Meera : $addBlaklist_OnAcceptance was wrong. Fixed.


        $user_payment_history = Yii::$app->db->createCommand("select  *  from  user_payment_history  where  userid ='" . Yii::$app->session->get('userid') . "' ORDER BY id DESC")->queryAll();
        $spreadsheet_token = Yii::$app->db->createCommand("select  *  from  spreadsheet_token  where  userId ='" . Yii::$app->session->get('userid') . "'")->queryOne();

        $userProfileData = Yii::$app->db->createCommand("select  *  from  user_profile  where user_id ='" . Yii::$app->session->get('userid') . "'")->queryOne();
        //echo '<pre>'; print_r($userProfileData);die;
        $getGoogleEmail = Yii::$app->db->createCommand("SELECT googleemail FROM spreadsheet_token where userId =  " . Yii::$app->session->get('userid'))->queryOne();
        $googleemail = $getGoogleEmail['googleemail'];


        return $this->render('profile', [
                    'UserDetail' => $UserDetail,
                    'user_payment_history' => $user_payment_history,
                    'addBlaklist_OnAcceptance' => $UserDetail['addBlaklist_OnAcceptance'],
                    'spreadsheet_token' => $spreadsheet_token,
                    'userProfileData' => $userProfileData,
                    'googleemail' => $googleemail,
                        //'profileData' => $profileData,
                        //'apiRes_me' => $apiRes_me,
                        //'apiRes_IdentityProfilesProfileView' => $apiRes_IdentityProfilesProfileView,
                        //'apiRes_IdentityProfilesProfileContactInfo' => $apiRes_IdentityProfilesProfileContactInfo,
                        // 'dataProvider' => $dataProvider, 
        ]);
    }

    //08June2020
    public function actionAjxprofile() {
        include('../web/updateLinkedInCookie.php');
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $UserDetail = Yii::$app->db->createCommand("select  *  from  user  where teamid =" . Yii::$app->session->get('teamid') . " AND id =" . Yii::$app->session->get('userid'))->queryOne();
        $proxyIp = $UserDetail['proxyIp'];
        $proxyPort = $UserDetail['proxyPort'];
        $proxyUsername = $UserDetail['proxyUsername'];
        $proxyPassword = $UserDetail['proxyPassword'];
        $userAgent = $UserDetail['userAgent'];
        $cookie = $UserDetail['cookie'];
        $csrf = $UserDetail['csrf'];

        $profileData = array();


        //06June2020 starts
        $profileData['pic_100_100'] = '';
        $profileData['pic_400_400'] = '';
        $apiRes_me = '';

        $profileData['numConnections'] = 0;
        $profileData['pendingConnections'] = 0;
        $profileData['numTotalSentInvitations'] = 0;


        $apiRes_IdentityProfilesProfileView = '';
        $apiRes_IdentityProfilesProfileContactInfo = '';
        //06June2020 ends



        if ($proxyIp && $proxyPort && $proxyUsername && $proxyPassword) {

            if (!empty($cookie) && !empty($csrf)) {
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/me",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    /* CURLOPT_VERBOSE=>true, */
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $curlResult = curl_exec($curl);
                $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                $headers = substr($curlResult, 0, $header_size);

                $curlResult = substr($curlResult, $header_size);
                $newCookie = getCookiesLdnFromHeaders($headers);
                if (!empty($newCookie)) {
                    updateUserLdnCookies($userId, $newCookie);
                }
                if (!empty($curlResult)) {
                    $apiRes_me = $decodedRes = json_decode($curlResult);
                    //echo 'C:<pre>'; print_r($decodedRes);
                    $picture = (array) $decodedRes->miniProfile->picture;
                    $profileData['pic_100_100'] = $picture['com.linkedin.common.VectorImage']->rootUrl . $picture['com.linkedin.common.VectorImage']->artifacts[0]->fileIdentifyingUrlPathSegment;
                    $profileData['pic_400_400'] = $picture['com.linkedin.common.VectorImage']->rootUrl . $picture['com.linkedin.common.VectorImage']->artifacts[2]->fileIdentifyingUrlPathSegment;
                    \Yii::$app->session->set('top_profile_pic', $profileData['pic_100_100']);
                } else {
                    $profileData['pic_100_100'] = '';
                    $profileData['pic_400_400'] = '';
                    $apiRes_me = '';
                }
            }


            if (!empty($cookie) && !empty($csrf)) {
                $curlConnectionDetails = curl_init();
                curl_setopt_array($curlConnectionDetails, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/relationships/connectionsSummary/",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    /* CURLOPT_VERBOSE=>true, */
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $connectionDetailsRes = curl_exec($curlConnectionDetails);
                $header_size = curl_getinfo($curlConnectionDetails, CURLINFO_HEADER_SIZE);
                $headers = substr($connectionDetailsRes, 0, $header_size);

                $connectionDetailsRes = substr($connectionDetailsRes, $header_size);
                $newCookie = getCookiesLdnFromHeaders($headers);
                if (!empty($newCookie)) {
                    updateUserLdnCookies($userId, $newCookie);
                }
                if (!empty($connectionDetailsRes)) {
                    $decodedJsonRes = json_decode($connectionDetailsRes);
                    //echo 'AA:<pre>'; print_r($decodedJsonRes);
                    $profileData['numConnections'] = $decodedJsonRes->numConnections;
                } else {
                    $profileData['numConnections'] = 0;
                }
                $curlInvitationDetails = curl_init();
                curl_setopt_array($curlInvitationDetails, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/relationships/invitationsSummaryV2?types=List(SENT_INVITATION_COUNT,PENDING_INVITATION_COUNT,UNSEEN_INVITATION_COUNT,PENDING_INVITATION_BY_FACET_COUNT)",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    /* CURLOPT_VERBOSE=>true, */
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        /* "cookie: $cookie",
                          "csrf-token: $csrf",
                          "x-http-method-override: GET",
                          "Host: www.linkedin.com",
                          "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36",
                          "accept: application/vnd.linkedin.normalized+json+2.1",
                          "Accept-Language: en-US,en;q=0.5",
                          "Accept-Encoding: gzip, deflate, br",
                          //"content-type: application/x-www-form-urlencoded",
                          "x-li-lang: en_US",
                          "x-restli-protocol-version: 2.0.0",
                          "Origin: https://www.linkedin.com",
                          "TE: Trailers" */

                        "accept: application/vnd.linkedin.normalized+json+2.1",
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        //"x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "accept-language: en-US,en;q=0.9",
                        //"Accept-Encoding: gzip, deflate, br",
                        //"content-type: application/x-www-form-urlencoded",
                        "content-type: application/vnd.linkedin.normalized+json+2.1",
                        "x-li-lang: en_US",
                        //'x-li-track: {"clientVersion":"1.6.3394","osName":"web","timezoneOffset":5.5,"deviceFormFactor":"DESKTOP","mpName":"voyager-web","displayDensity":1}',
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                    //"TE: Trailers"						
                    ),
                ));
                $invitationDetailsRes = curl_exec($curlInvitationDetails);
                $header_size = curl_getinfo($curlInvitationDetails, CURLINFO_HEADER_SIZE);
                $headers = substr($invitationDetailsRes, 0, $header_size);

                $invitationDetailsRes = substr($invitationDetailsRes, $header_size);
                $newCookie = getCookiesLdnFromHeaders($headers);
                if (!empty($newCookie)) {
                    updateUserLdnCookies($userId, $newCookie);
                }
                if (!empty($invitationDetailsRes)) {
                    $decodedJsonResInvDtls = json_decode($invitationDetailsRes);
                    $profileData['numTotalSentInvitations'] = $decodedJsonResInvDtls->data->numTotalSentInvitations;
                    $profileData['pendingConnections'] = $decodedJsonResInvDtls->data->numPendingInvitations;
                    //echo 'BBSDSD:<pre>'; print_r($decodedJsonResInvDtls);
                    //$profileData['pendingConnections'] = $decodedJsonResInvDtls->elements[1]->count;
                } else {
                    //$profileData['pendingConnections'] = 0;
                }
            }



            //NR starts
            if ($apiRes_me != '') {
                $publicIdentifier = $apiRes_me->miniProfile->publicIdentifier;
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $publicIdentifier . "/profileView",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    /* CURLOPT_VERBOSE=>true, */
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $curlResult = curl_exec($curl);
                $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                $headers = substr($curlResult, 0, $header_size);

                $curlResult = substr($curlResult, $header_size);
                $newCookie = getCookiesLdnFromHeaders($headers);
                if (!empty($newCookie)) {
                    updateUserLdnCookies($userId, $newCookie);
                }
                //echo '<br/>LINE:'.__LINE__.':::'; echo $curlResult;
                $apiRes_IdentityProfilesProfileView = json_decode($curlResult);
                //echo 'C:<pre>';  print_r($apiRes_IdentityProfilesProfileView->profile->summary);die;
                curl_close($curl);

                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $publicIdentifier . "/profileContactInfo",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    /* CURLOPT_VERBOSE=>true, */
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $curlResult = curl_exec($curl);
                $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                $headers = substr($curlResult, 0, $header_size);

                $curlResult = substr($curlResult, $header_size);
                $newCookie = getCookiesLdnFromHeaders($headers);
                if (!empty($newCookie)) {
                    updateUserLdnCookies($userId, $newCookie);
                }
                //echo '<br/>LINE:'.__LINE__.':::'; echo $curlResult;
                $apiRes_IdentityProfilesProfileContactInfo = json_decode($curlResult);
                curl_close($curl);
            }
            //NR ends
        }

        $final_result = array();
        $final_result['profileData'] = $profileData;



        $api_IPPV_profile_locationName = 'N/A';
        $api_IPPV_profile_summary_html = '<p>N/A</p>';
        if ($apiRes_IdentityProfilesProfileView != '') {
            if (isset($apiRes_IdentityProfilesProfileView->profile->locationName)) {
                $api_IPPV_profile_locationName = $apiRes_IdentityProfilesProfileView->profile->locationName;
            }

            if (isset($apiRes_IdentityProfilesProfileView->profile->summary)) {
                //01-07-2020:htmlentities added due to it was causing issue when summary contains html;
                if (strlen($apiRes_IdentityProfilesProfileView->profile->summary) > 325) {
                    $api_IPPV_profile_summary_html = '<p id="shortAbout">' . substr(htmlentities($apiRes_IdentityProfilesProfileView->profile->summary), 0, 325) . '... <a href="javascript:void(0);" id="aShortAbout">Read more</a></p>';
                    $api_IPPV_profile_summary_html .= '<p id="fullAbout" style="display:none;">' . htmlentities($apiRes_IdentityProfilesProfileView->profile->summary) . ' <a href="javascript:void(0);" id="aFullAbout">Read less</a></p>';
                } else {
                    $api_IPPV_profile_summary_html = '<p>' . htmlentities($apiRes_IdentityProfilesProfileView->profile->summary) . '</p>';
                }
            }
        }
        //print_r($api_IPPV_profile_summary_html); 
        $apiIPPCI_phoneNumbers = 'N/A';
        $apiIPPCI_emailAddress = 'N/A';
        if ($apiRes_IdentityProfilesProfileContactInfo != '') {
            if (isset($apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number)) {
                $apiIPPCI_phoneNumbers = $apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number;
            }

            if (isset($apiRes_IdentityProfilesProfileContactInfo->emailAddress)) {
                $apiIPPCI_emailAddress = $apiRes_IdentityProfilesProfileContactInfo->emailAddress;
            }
        }

        $api_me_miniProfile_Occupation = 'N/A';
        if ($apiRes_me != '') {
            if (isset($apiRes_me->miniProfile->occupation)) {
                $api_me_miniProfile_Occupation = $apiRes_me->miniProfile->occupation;
            }
        }

        $html_basicDetail = '';
        $html_basicDetail .= '<h5 class="card-title">Basic details</h5>';
        $html_basicDetail .= '<ul class="list-unstyled basicDetailsBlk">';
        $html_basicDetail .= '<li><i class="cursor-pointer bx bx-map mb-1 mr-50"></i>' . $api_IPPV_profile_locationName . '</li>';
        $html_basicDetail .= '<li><i class="cursor-pointer bx bx-phone-call mb-1 mr-50"></i>' . $apiIPPCI_phoneNumbers . '</li>';
        $html_basicDetail .= '<li><i class="cursor-pointer bx bx-envelope mb-1 mr-50"></i>' . $apiIPPCI_emailAddress . '</li></ul><div class="profilOccBlk"><h6><small class="text-muted">Occupation</small></h6><p>' . $api_me_miniProfile_Occupation . '</p></div><div class="profileAbtBlk"><h6><small class="text-muted">About</small></h6>';
        /* $api_IPPV_profile_summary_html = addslashes($api_IPPV_profile_summary_html);
          $api_IPPV_profile_summary_html = htmlspecialchars($api_IPPV_profile_summary_html); */
        $html_basicDetail .= $api_IPPV_profile_summary_html;
        $html_basicDetail .= '</div>';


        //print_r(htmlentities($html_basicDetail, NULL, 'UTF-8'));
        $final_result['html_basicDetail'] = $html_basicDetail;
        $final_result['apiRes_me'] = $apiRes_me;
        //print_r(json_encode($final_result,JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)); 
        return json_encode($final_result);
    }

    function mb_ord($char, $encoding = 'UTF-8') {
        if ($encoding === 'UCS-4BE') {
            list(, $ord) = (strlen($char) === 4) ? @unpack('N', $char) : @unpack('n', $char);
            return $ord;
        } else {
            return $this->mb_ord(mb_convert_encoding($char, 'UCS-4BE', $encoding), 'UCS-4BE');
        }
    }

    function mb_htmlentities($string, $hex = true, $encoding = 'UTF-8') {
        return preg_replace_callback('/[\x{80}-\x{10FFFF}]/u', function ($match) use ($hex) {
            return sprintf($hex ? '&#x%X;' : '&#%d;', $this->mb_ord($match[0]));
        }, $string);
    }

    //06-07-2020 old bkp this method is not in use now;
    public function actionAjxrefreshprofileOldBkpUnused() {
        include('../web/updateLinkedInCookie.php');
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $UserDetail = Yii::$app->db->createCommand("select  *  from  user  where id =" . Yii::$app->session->get('userid'))->queryOne();
        $proxyIp = $UserDetail['proxyIp'];
        $proxyPort = $UserDetail['proxyPort'];
        $proxyUsername = $UserDetail['proxyUsername'];
        $proxyPassword = $UserDetail['proxyPassword'];
        $userAgent = $UserDetail['userAgent'];
        $cookie = $UserDetail['cookie'];
        $csrf = $UserDetail['csrf'];
        $userId = $UserDetail['id'];

        $profileData = array();


        //06June2020 starts
        $profileData['pic_100_100'] = '';
        $profileData['pic_400_400'] = '';
        $apiRes_me = '';

        $profileData['numConnections'] = 0;
        $profileData['pendingConnections'] = 0;
        $profileData['numTotalSentInvitations'] = 0;


        $apiRes_IdentityProfilesProfileView = '';
        $apiRes_IdentityProfilesProfileContactInfo = '';
        //06June2020 ends



        if ($proxyIp && $proxyPort && $proxyUsername && $proxyPassword) {

            if (!empty($cookie) && !empty($csrf)) {
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/me",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    /* CURLOPT_VERBOSE=>true, */
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $curlResult = curl_exec($curl);
                $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                $headers = substr($curlResult, 0, $header_size);

                $curlResult = substr($curlResult, $header_size);
                $newCookie = getCookiesLdnFromHeaders($headers);
                if (!empty($newCookie)) {
                    updateUserLdnCookies($userId, $newCookie);
                }
                if (!empty($curlResult)) {
                    $apiRes_me = $decodedRes = json_decode($curlResult);
                    //echo 'C:<pre>'; print_r($decodedRes);
                    $picture = (array) $decodedRes->miniProfile->picture;
                    $profileData['pic_100_100'] = $picture['com.linkedin.common.VectorImage']->rootUrl . $picture['com.linkedin.common.VectorImage']->artifacts[0]->fileIdentifyingUrlPathSegment;
                    $profileData['pic_400_400'] = $picture['com.linkedin.common.VectorImage']->rootUrl . $picture['com.linkedin.common.VectorImage']->artifacts[2]->fileIdentifyingUrlPathSegment;
                    \Yii::$app->session->set('top_profile_pic', $profileData['pic_100_100']);
                } else {
                    $profileData['pic_100_100'] = '';
                    $profileData['pic_400_400'] = '';
                    $apiRes_me = '';
                }
            }


            if (!empty($cookie) && !empty($csrf)) {
                $curlConnectionDetails = curl_init();
                curl_setopt_array($curlConnectionDetails, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/relationships/connectionsSummary/",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    /* CURLOPT_VERBOSE=>true, */
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $connectionDetailsRes = curl_exec($curlConnectionDetails);
                $header_size = curl_getinfo($curlConnectionDetails, CURLINFO_HEADER_SIZE);
                $headers = substr($connectionDetailsRes, 0, $header_size);

                $connectionDetailsRes = substr($connectionDetailsRes, $header_size);
                $newCookie = getCookiesLdnFromHeaders($headers);
                if (!empty($newCookie)) {
                    updateUserLdnCookies($userId, $newCookie);
                }
                if (!empty($connectionDetailsRes)) {
                    $decodedJsonRes = json_decode($connectionDetailsRes);
                    //echo 'AA:<pre>'; print_r($decodedJsonRes);
                    $profileData['numConnections'] = $decodedJsonRes->numConnections;
                } else {
                    $profileData['numConnections'] = 0;
                }
                $curlInvitationDetails = curl_init();
                curl_setopt_array($curlInvitationDetails, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/relationships/invitationsSummaryV2?types=List(SENT_INVITATION_COUNT,PENDING_INVITATION_COUNT,UNSEEN_INVITATION_COUNT,PENDING_INVITATION_BY_FACET_COUNT)",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    /* CURLOPT_VERBOSE=>true, */
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        /* "cookie: $cookie",
                          "csrf-token: $csrf",
                          "x-http-method-override: GET",
                          "Host: www.linkedin.com",
                          "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36",
                          "accept: application/vnd.linkedin.normalized+json+2.1",
                          "Accept-Language: en-US,en;q=0.5",
                          "Accept-Encoding: gzip, deflate, br",
                          //"content-type: application/x-www-form-urlencoded",
                          "x-li-lang: en_US",
                          "x-restli-protocol-version: 2.0.0",
                          "Origin: https://www.linkedin.com",
                          "TE: Trailers" */

                        "accept: application/vnd.linkedin.normalized+json+2.1",
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        //"x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "accept-language: en-US,en;q=0.9",
                        //"Accept-Encoding: gzip, deflate, br",
                        //"content-type: application/x-www-form-urlencoded",
                        "content-type: application/vnd.linkedin.normalized+json+2.1",
                        "x-li-lang: en_US",
                        //'x-li-track: {"clientVersion":"1.6.3394","osName":"web","timezoneOffset":5.5,"deviceFormFactor":"DESKTOP","mpName":"voyager-web","displayDensity":1}',
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                    //"TE: Trailers"						
                    ),
                ));
                $invitationDetailsRes = curl_exec($curlInvitationDetails);
                $header_size = curl_getinfo($curlInvitationDetails, CURLINFO_HEADER_SIZE);
                $headers = substr($invitationDetailsRes, 0, $header_size);

                $invitationDetailsRes = substr($invitationDetailsRes, $header_size);
                $newCookie = getCookiesLdnFromHeaders($headers);
                if (!empty($newCookie)) {
                    updateUserLdnCookies($userId, $newCookie);
                }
                if (!empty($invitationDetailsRes)) {
                    $decodedJsonResInvDtls = json_decode($invitationDetailsRes);
                    $profileData['numTotalSentInvitations'] = $decodedJsonResInvDtls->data->numTotalSentInvitations;
                    $profileData['pendingConnections'] = $decodedJsonResInvDtls->data->numPendingInvitations;
                    //echo 'BBSDSD:<pre>'; print_r($decodedJsonResInvDtls);
                    //$profileData['pendingConnections'] = $decodedJsonResInvDtls->elements[1]->count;
                } else {
                    //$profileData['pendingConnections'] = 0;
                }
            }



            //NR starts
            if ($apiRes_me != '') {
                //$publicIdentifier = $apiRes_me->miniProfile->publicIdentifier;
                //17-08-2020 starts
                $exp_entityUrn = explode(':', $apiRes_me->miniProfile->entityUrn); //urn:li:fs_miniProfile:ACoAACk3C7UBq40T-fMQ4G2Y9pjfh0zsc4pAt48
                $publicIdentifier = $exp_entityUrn[3]; //ACoAACk3C7UBq40T-fMQ4G2Y9pjfh0zsc4pAt48
                //17-08-2020 ends

                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $publicIdentifier . "/profileView",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    /* CURLOPT_VERBOSE=>true, */
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $curlResult = curl_exec($curl);
                $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                $headers = substr($curlResult, 0, $header_size);

                $curlResult = substr($curlResult, $header_size);
                $newCookie = getCookiesLdnFromHeaders($headers);
                if (!empty($newCookie)) {
                    updateUserLdnCookies($userId, $newCookie);
                }
                //echo '<br/>LINE:'.__LINE__.':::'; echo $curlResult;
                $apiRes_IdentityProfilesProfileView = json_decode($curlResult);
                //echo 'C:<pre>';  print_r($apiRes_IdentityProfilesProfileView->profile->summary);die;
                curl_close($curl);

                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $publicIdentifier . "/profileContactInfo",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    /* CURLOPT_VERBOSE=>true, */
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent: $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $curlResult = curl_exec($curl);
                $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                $headers = substr($curlResult, 0, $header_size);

                $curlResult = substr($curlResult, $header_size);
                $newCookie = getCookiesLdnFromHeaders($headers);
                if (!empty($newCookie)) {
                    updateUserLdnCookies($userId, $newCookie);
                }
                //echo '<br/>LINE:'.__LINE__.':::'; echo $curlResult;
                $apiRes_IdentityProfilesProfileContactInfo = json_decode($curlResult);
                curl_close($curl);
            }
            //NR ends
        }

        $final_result = array();
        $final_result['profileData'] = $profileData;



        $api_IPPV_profile_locationName = 'N/A';
        $api_IPPV_profile_summary_html = '<p>N/A</p>';
        if ($apiRes_IdentityProfilesProfileView != '') {
            if (isset($apiRes_IdentityProfilesProfileView->profile->locationName)) {
                $api_IPPV_profile_locationName = $apiRes_IdentityProfilesProfileView->profile->locationName;
            }

            if (isset($apiRes_IdentityProfilesProfileView->profile->summary)) {
                //01-07-2020:htmlentities added due to it was causing issue when summary contains html;
                if (strlen($apiRes_IdentityProfilesProfileView->profile->summary) > 325) {
                    $api_IPPV_profile_summary_html = '<p id="shortAbout">' . substr(htmlentities($apiRes_IdentityProfilesProfileView->profile->summary), 0, 325) . '... <a href="javascript:void(0);" id="aShortAbout">Read more</a></p>';
                    $api_IPPV_profile_summary_html .= '<p id="fullAbout" style="display:none;">' . htmlentities($apiRes_IdentityProfilesProfileView->profile->summary) . ' <a href="javascript:void(0);" id="aFullAbout">Read less</a></p>';
                } else {
                    $api_IPPV_profile_summary_html = '<p>' . htmlentities($apiRes_IdentityProfilesProfileView->profile->summary) . '</p>';
                }
            }
        }
        //print_r($api_IPPV_profile_summary_html); 
        $apiIPPCI_phoneNumbers = 'N/A';
        $apiIPPCI_emailAddress = 'N/A';
        if ($apiRes_IdentityProfilesProfileContactInfo != '') {
            if (isset($apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number)) {
                $apiIPPCI_phoneNumbers = $apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number;
            }

            if (isset($apiRes_IdentityProfilesProfileContactInfo->emailAddress)) {
                $apiIPPCI_emailAddress = $apiRes_IdentityProfilesProfileContactInfo->emailAddress;
            }
        }

        $api_me_miniProfile_Occupation = 'N/A';
        if ($apiRes_me != '') {
            if (isset($apiRes_me->miniProfile->occupation)) {
                $api_me_miniProfile_Occupation = $apiRes_me->miniProfile->occupation;
            }
        }

        $html_basicDetail = '';
        $html_basicDetail .= '<ul class="list-unstyled basicDetailsBlk">';
        $html_basicDetail .= '<li><i class="cursor-pointer bx bx-map mb-1 mr-50"></i>' . $api_IPPV_profile_locationName . '</li>';
        $html_basicDetail .= '<li><i class="cursor-pointer bx bx-phone-call mb-1 mr-50"></i>' . $apiIPPCI_phoneNumbers . '</li>';
        $html_basicDetail .= '<li><i class="cursor-pointer bx bx-envelope mb-1 mr-50"></i>' . $apiIPPCI_emailAddress . '</li></ul><div class="profilOccBlk"><h6><small class="text-muted">Occupation</small></h6><p>' . $api_me_miniProfile_Occupation . '</p></div>';
        //<div class="profileAbtBlk"><h6><small class="text-muted">About</small></h6>
        /* $api_IPPV_profile_summary_html = addslashes($api_IPPV_profile_summary_html);
          $api_IPPV_profile_summary_html = htmlspecialchars($api_IPPV_profile_summary_html); */
        //$html_basicDetail .= $api_IPPV_profile_summary_html;
        //$html_basicDetail .= '</div>'; 
        //print_r(htmlentities($html_basicDetail, NULL, 'UTF-8'));
        $final_result['html_basicDetail'] = $html_basicDetail;
        $final_result['apiRes_me'] = $apiRes_me;
        //print_r(json_encode($final_result,JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)); 
        //updating data starts
        $ProfilePic400_400 = $profileData['pic_400_400'];
        $pdNumConnections = $profileData['numConnections'];
        $pdPendingConnections = $profileData['pendingConnections'];
        $pdNumTotalSentInvitations = $profileData['numTotalSentInvitations'];

        $api_IPPV_profile_locationName = 'N/A';
        $api_IPPV_profile_summary_html = 'N/A'; //'<p>N/A</p>';
        if ($apiRes_IdentityProfilesProfileView != '') {
            if (isset($apiRes_IdentityProfilesProfileView->profile->locationName)) {
                $api_IPPV_profile_locationName = $apiRes_IdentityProfilesProfileView->profile->locationName;
            }

            if (isset($apiRes_IdentityProfilesProfileView->profile->summary)) {
                //01-07-2020:htmlentities added due to it was causing issue when summary contains html;
                $api_IPPV_profile_summary_html = htmlentities($apiRes_IdentityProfilesProfileView->profile->summary);
            }
        }
        $IPPV_profileLocationName = $api_IPPV_profile_locationName;
        //$IPPV_profileSummary = $api_IPPV_profile_summary_html;
        $IPPV_profileSummary = str_replace("'", "`", $api_IPPV_profile_summary_html); //07-July-2020

        $apiIPPCI_phoneNumbers = 'N/A';
        if ($apiRes_IdentityProfilesProfileContactInfo != '') {
            if (isset($apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number)) {
                $apiIPPCI_phoneNumbers = $apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number;
            }
        }
        $IPPCI_phoneNumber = $apiIPPCI_phoneNumbers;

        $api_me_miniProfile_Occupation = 'N/A';
        $api_me_miniProfile_firstName = 'N/A';
        $api_me_miniProfile_lastName = 'N/A';
        if ($apiRes_me != '') {
            if (isset($apiRes_me->miniProfile->occupation)) {
                //$api_me_miniProfile_Occupation = $apiRes_me->miniProfile->occupation;
                $api_me_miniProfile_Occupation = addslashes($this->mb_htmlentities($apiRes_me->miniProfile->occupation));
            }
            if (isset($apiRes_me->miniProfile->firstName)) {
                //$api_me_miniProfile_firstName = $apiRes_me->miniProfile->firstName;
                $api_me_miniProfile_firstName = addslashes($this->mb_htmlentities($apiRes_me->miniProfile->firstName));
            }
            if (isset($apiRes_me->miniProfile->lastName)) {
                //$api_me_miniProfile_lastName = $apiRes_me->miniProfile->lastName;
                $api_me_miniProfile_lastName = addslashes($this->mb_htmlentities($apiRes_me->miniProfile->lastName));
            }
        }


        //, IPPV_profileSummary='".$IPPV_profileSummary."'
        //addslashes($api_me_miniProfile_firstName)
        //addslashes($api_me_miniProfile_lastName)
        //addslashes($api_me_miniProfile_Occupation)
        $update_user_data = "update user_profile set ProfilePic400_400='" . addslashes($ProfilePic400_400) . "', pdNumConnections='" . $pdNumConnections . "', pdPendingConnections='" . $pdPendingConnections . "', pdNumTotalSentInvitations='" . $pdNumTotalSentInvitations . "', IPPV_profileLocationName='" . addslashes($IPPV_profileLocationName) . "', IPPCI_phoneNumber='" . addslashes($IPPCI_phoneNumber) . "', firstName='" . $api_me_miniProfile_firstName . "', lastName='" . $api_me_miniProfile_lastName . "', occupation='" . $api_me_miniProfile_Occupation . "' where user_id='" . Yii::$app->session->get('userid') . "'";

        Yii::$app->db->createCommand($update_user_data)->execute();
        //updating data ends

        return json_encode($final_result);
    }

    public function actionDisconnectprofile() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $userId = Yii::$app->session->get('userid');
        /* $sequencesQry = Yii::$app->db->createCommand("select  id  from  ext_sequences where status='Active' AND user_id =" . $userId)->queryAll();

          if (count($sequencesQry) > 0) {
          foreach ($sequencesQry as $sequences) {
          Yii::$app->db->createCommand("UPDATE `ext_sequences` SET `status` = 'Stopped' WHERE user_id = '" . $userId . "' AND id = '" . $sequences['id'] . "'")->execute();
          Yii::$app->db->createCommand("UPDATE `ext_tasks` SET `status` = 'Skipped' WHERE userId = '" . $userId . "' AND seqId = '" . $sequences['id'] . "' AND status = 'Not Started'")->execute();
          Yii::$app->db->createCommand("INSERT INTO completed_tasks SELECT ext_tasks.*, NOW() FROM ext_tasks WHERE userId = '" . $userId . "' AND seqId = '" . $sequences['id'] . "' AND status = 'Skipped'")->execute();
          Yii::$app->db->createCommand("DELETE FROM ext_tasks WHERE userId = '" . $userId . "' AND seqId = '" . $sequences['id'] . "' AND status = 'Skipped'")->execute();
          Yii::$app->db->createCommand("UPDATE `ext_links` SET `status` = 'Not Started', pagesFetched = '0', fetchStarted = '', `start` = '0', voyagerLink = '', `total` = '0' WHERE userId = '" . $userId . "' AND seqId = '" . $sequences['id'] . "'")->execute();
          $textmsg = 'Your Account has been disconnected.';
          Yii::$app->db->createCommand("INSERT INTO ext_log (text,seqId,userId,errorLog) VALUES ('" . $textmsg . "','" . $sequences['id'] . "','" . $userId . "','0')")->execute();
          }
          } */
        if (Yii::$app->db->createCommand("UPDATE `user` SET `popupstatus` = '0' WHERE  `id` = '" . $userId . "'")->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function actionAjxrefreshprofile() {
        include('../web/updateLinkedInCookie.php');
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $UserDetail = Yii::$app->db->createCommand("select  *  from  user  where id =" . Yii::$app->session->get('userid'))->queryOne();
        //echo '<pre>'; print_r($UserDetail); die;
        $proxyIp = $UserDetail['proxyIp'];
        $proxyPort = $UserDetail['proxyPort'];
        $proxyUsername = $UserDetail['proxyUsername'];
        $proxyPassword = $UserDetail['proxyPassword'];
        $userAgent = $UserDetail['userAgent'];
        $cookie = $UserDetail['cookie'];
        $csrf = $UserDetail['csrf'];
        $userId = $UserDetail['id'];

        $profileData = array();


        //06June2020 starts
        $profileData['pic_100_100'] = '';
        $profileData['pic_400_400'] = '';
        $apiRes_me = '';



        $profileData['numConnections'] = 0;
        $profileData['pendingConnections'] = 0;
        $profileData['numTotalSentInvitations'] = 0;


        $apiRes_IdentityProfilesProfileView = '';
        $apiRes_IdentityProfilesProfileContactInfo = '';
        //06June2020 ends
        $api_ssiScore = ''; //04-12-2020



        if ($proxyIp && $proxyPort && $proxyUsername && $proxyPassword && !empty($cookie) && !empty($csrf)) {

            //if (!empty($cookie) && !empty($csrf)) {
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://www.linkedin.com/voyager/api/me",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_HEADER => true,
                /* CURLOPT_VERBOSE=>true, */
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_HTTPPROXYTUNNEL => 1,
                CURLOPT_PROXY => "$proxyIp",
                CURLOPT_PROXYPORT => "$proxyPort",
                CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => array(
                    "cookie: $cookie",
                    "csrf-token: $csrf",
                    "x-http-method-override: GET",
                    "Host: www.linkedin.com",
                    "User-Agent: $userAgent",
                    "Accept-Language: en-US,en;q=0.5",
                    "Accept-Encoding: gzip, deflate, br",
                    "content-type: application/x-www-form-urlencoded",
                    "x-li-lang: en_US",
                    "x-restli-protocol-version: 2.0.0",
                    "Origin: https://www.linkedin.com",
                    "TE: Trailers"
                ),
            ));
            $curlResult = curl_exec($curl);
            $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
            $headers = substr($curlResult, 0, $header_size);

            $curlResult = substr($curlResult, $header_size);
            $newCookie = getCookiesLdnFromHeaders($headers);
            if (!empty($newCookie)) {
                updateUserLdnCookies($userId, $newCookie);
            }
            //echo 'DFDFDF:<pre>'; print_r($curlResult);echo '</pre>';
            /* if (!empty($curlResult)) {
              echo '<br/>::::A';
              }else{
              echo '<br/>::::B';
              } */
//die;
            if (!empty($curlResult)) {
                $apiRes_me = $decodedRes = json_decode($curlResult);
                //echo 'C:<pre>'; print_r($decodedRes);
                $picture = (array) $decodedRes->miniProfile->picture;
                $profileData['pic_100_100'] = $picture['com.linkedin.common.VectorImage']->rootUrl . $picture['com.linkedin.common.VectorImage']->artifacts[0]->fileIdentifyingUrlPathSegment;
                $profileData['pic_400_400'] = $picture['com.linkedin.common.VectorImage']->rootUrl . $picture['com.linkedin.common.VectorImage']->artifacts[2]->fileIdentifyingUrlPathSegment;
                \Yii::$app->session->set('top_profile_pic', $profileData['pic_100_100']);




                if (!empty($cookie) && !empty($csrf)) {
                    $curlConnectionDetails = curl_init();
                    curl_setopt_array($curlConnectionDetails, array(
                        CURLOPT_URL => "https://www.linkedin.com/voyager/api/relationships/connectionsSummary/",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_HEADER => true,
                        /* CURLOPT_VERBOSE=>true, */
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_HTTPPROXYTUNNEL => 1,
                        CURLOPT_PROXY => "$proxyIp",
                        CURLOPT_PROXYPORT => "$proxyPort",
                        CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                        CURLOPT_CUSTOMREQUEST => "GET",
                        CURLOPT_HTTPHEADER => array(
                            "cookie: $cookie",
                            "csrf-token: $csrf",
                            "x-http-method-override: GET",
                            "Host: www.linkedin.com",
                            "User-Agent: $userAgent",
                            "Accept-Language: en-US,en;q=0.5",
                            "Accept-Encoding: gzip, deflate, br",
                            "content-type: application/x-www-form-urlencoded",
                            "x-li-lang: en_US",
                            "x-restli-protocol-version: 2.0.0",
                            "Origin: https://www.linkedin.com",
                            "TE: Trailers"
                        ),
                    ));
                    $connectionDetailsRes = curl_exec($curlConnectionDetails);
                    $header_size = curl_getinfo($curlConnectionDetails, CURLINFO_HEADER_SIZE);
                    $headers = substr($connectionDetailsRes, 0, $header_size);

                    $connectionDetailsRes = substr($connectionDetailsRes, $header_size);
                    $newCookie = getCookiesLdnFromHeaders($headers);
                    if (!empty($newCookie)) {
                        updateUserLdnCookies($userId, $newCookie);
                    }
                    if (!empty($connectionDetailsRes)) {
                        $decodedJsonRes = json_decode($connectionDetailsRes);
                        //echo 'AA:<pre>'; print_r($decodedJsonRes);
                        $profileData['numConnections'] = $decodedJsonRes->numConnections;
                    } else {
                        $profileData['numConnections'] = 0;
                    }
                    $curlInvitationDetails = curl_init();
                    curl_setopt_array($curlInvitationDetails, array(
                        CURLOPT_URL => "https://www.linkedin.com/voyager/api/relationships/invitationsSummaryV2?types=List(SENT_INVITATION_COUNT,PENDING_INVITATION_COUNT,UNSEEN_INVITATION_COUNT,PENDING_INVITATION_BY_FACET_COUNT)",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_HEADER => true,
                        /* CURLOPT_VERBOSE=>true, */
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_HTTPPROXYTUNNEL => 1,
                        CURLOPT_PROXY => "$proxyIp",
                        CURLOPT_PROXYPORT => "$proxyPort",
                        CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                        CURLOPT_CUSTOMREQUEST => "GET",
                        CURLOPT_HTTPHEADER => array(
                            /* "cookie: $cookie",
                              "csrf-token: $csrf",
                              "x-http-method-override: GET",
                              "Host: www.linkedin.com",
                              "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36",
                              "accept: application/vnd.linkedin.normalized+json+2.1",
                              "Accept-Language: en-US,en;q=0.5",
                              "Accept-Encoding: gzip, deflate, br",
                              //"content-type: application/x-www-form-urlencoded",
                              "x-li-lang: en_US",
                              "x-restli-protocol-version: 2.0.0",
                              "Origin: https://www.linkedin.com",
                              "TE: Trailers" */

                            "accept: application/vnd.linkedin.normalized+json+2.1",
                            "cookie: $cookie",
                            "csrf-token: $csrf",
                            //"x-http-method-override: GET",
                            "Host: www.linkedin.com",
                            "User-Agent: $userAgent",
                            "accept-language: en-US,en;q=0.9",
                            //"Accept-Encoding: gzip, deflate, br",
                            //"content-type: application/x-www-form-urlencoded",
                            "content-type: application/vnd.linkedin.normalized+json+2.1",
                            "x-li-lang: en_US",
                            //'x-li-track: {"clientVersion":"1.6.3394","osName":"web","timezoneOffset":5.5,"deviceFormFactor":"DESKTOP","mpName":"voyager-web","displayDensity":1}',
                            "x-restli-protocol-version: 2.0.0",
                            "Origin: https://www.linkedin.com",
                        //"TE: Trailers"						
                        ),
                    ));
                    $invitationDetailsRes = curl_exec($curlInvitationDetails);
                    $header_size = curl_getinfo($curlInvitationDetails, CURLINFO_HEADER_SIZE);
                    $headers = substr($invitationDetailsRes, 0, $header_size);

                    $invitationDetailsRes = substr($invitationDetailsRes, $header_size);
                    $newCookie = getCookiesLdnFromHeaders($headers);
                    if (!empty($newCookie)) {
                        updateUserLdnCookies($userId, $newCookie);
                    }
                    if (!empty($invitationDetailsRes)) {
                        $decodedJsonResInvDtls = json_decode($invitationDetailsRes);
                        $profileData['numTotalSentInvitations'] = $decodedJsonResInvDtls->data->numTotalSentInvitations;
                        $profileData['pendingConnections'] = $decodedJsonResInvDtls->data->numPendingInvitations;
                        //echo 'BBSDSD:<pre>'; print_r($decodedJsonResInvDtls);
                        //$profileData['pendingConnections'] = $decodedJsonResInvDtls->elements[1]->count;
                    } else {
                        //$profileData['pendingConnections'] = 0;
                    }
                }






                //NR starts
                if ($apiRes_me != '') {
                    //$publicIdentifier = $apiRes_me->miniProfile->publicIdentifier;
                    //17-08-2020 starts
                    $exp_entityUrn = explode(':', $apiRes_me->miniProfile->entityUrn); //urn:li:fs_miniProfile:ACoAACk3C7UBq40T-fMQ4G2Y9pjfh0zsc4pAt48
                    $publicIdentifier = $exp_entityUrn[3]; //ACoAACk3C7UBq40T-fMQ4G2Y9pjfh0zsc4pAt48
                    //17-08-2020 ends

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                        CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $publicIdentifier . "/profileView",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_HEADER => true,
                        /* CURLOPT_VERBOSE=>true, */
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_HTTPPROXYTUNNEL => 1,
                        CURLOPT_PROXY => "$proxyIp",
                        CURLOPT_PROXYPORT => "$proxyPort",
                        CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                        CURLOPT_CUSTOMREQUEST => "GET",
                        CURLOPT_HTTPHEADER => array(
                            "cookie: $cookie",
                            "csrf-token: $csrf",
                            "x-http-method-override: GET",
                            "Host: www.linkedin.com",
                            "User-Agent: $userAgent",
                            "Accept-Language: en-US,en;q=0.5",
                            "Accept-Encoding: gzip, deflate, br",
                            "content-type: application/x-www-form-urlencoded",
                            "x-li-lang: en_US",
                            "x-restli-protocol-version: 2.0.0",
                            "Origin: https://www.linkedin.com",
                            "TE: Trailers"
                        ),
                    ));
                    $curlResult = curl_exec($curl);
                    $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                    $headers = substr($curlResult, 0, $header_size);

                    $curlResult = substr($curlResult, $header_size);
                    $newCookie = getCookiesLdnFromHeaders($headers);
                    if (!empty($newCookie)) {
                        updateUserLdnCookies($userId, $newCookie);
                    }
                    //echo '<br/>LINE:'.__LINE__.':::'; echo $curlResult;
                    $apiRes_IdentityProfilesProfileView = json_decode($curlResult);
                    //echo 'C:<pre>';  print_r($apiRes_IdentityProfilesProfileView->profile->summary);die;
                    curl_close($curl);

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                        CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $publicIdentifier . "/profileContactInfo",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_HEADER => true,
                        /* CURLOPT_VERBOSE=>true, */
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_HTTPPROXYTUNNEL => 1,
                        CURLOPT_PROXY => "$proxyIp",
                        CURLOPT_PROXYPORT => "$proxyPort",
                        CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                        CURLOPT_CUSTOMREQUEST => "GET",
                        CURLOPT_HTTPHEADER => array(
                            "cookie: $cookie",
                            "csrf-token: $csrf",
                            "x-http-method-override: GET",
                            "Host: www.linkedin.com",
                            "User-Agent: $userAgent",
                            "Accept-Language: en-US,en;q=0.5",
                            "Accept-Encoding: gzip, deflate, br",
                            "content-type: application/x-www-form-urlencoded",
                            "x-li-lang: en_US",
                            "x-restli-protocol-version: 2.0.0",
                            "Origin: https://www.linkedin.com",
                            "TE: Trailers"
                        ),
                    ));
                    $curlResult = curl_exec($curl);
                    $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                    $headers = substr($curlResult, 0, $header_size);

                    $curlResult = substr($curlResult, $header_size);
                    $newCookie = getCookiesLdnFromHeaders($headers);
                    if (!empty($newCookie)) {
                        updateUserLdnCookies($userId, $newCookie);
                    }
                    //echo '<br/>LINE:'.__LINE__.':::'; echo $curlResult;
                    $apiRes_IdentityProfilesProfileContactInfo = json_decode($curlResult);
                    curl_close($curl);


                    //04-12-2020 starts
                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                        CURLOPT_URL => "https://www.linkedin.com/sales-api/salesApiSsi",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_HEADER => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_HTTPPROXYTUNNEL => 1,
                        CURLOPT_PROXY => "$proxyIp",
                        CURLOPT_PROXYPORT => "$proxyPort",
                        CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                        CURLOPT_CUSTOMREQUEST => "GET",
                        CURLOPT_HTTPHEADER => array(
                            "cookie: $cookie",
                            "csrf-token: $csrf",
                            "x-http-method-override: GET",
                            "Host: www.linkedin.com",
                            "User-Agent: $userAgent",
                            "Accept-Language: en-US,en;q=0.5",
                            "Accept-Encoding: gzip, deflate, br",
                            "content-type: application/x-www-form-urlencoded",
                            "x-li-lang: en_US",
                            "x-restli-protocol-version: 2.0.0",
                            "Origin: https://www.linkedin.com",
                            "TE: Trailers"
                        ),
                    ));
                    $curlResult = curl_exec($curl);
                    $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                    $headers = substr($curlResult, 0, $header_size);

                    $curlResult = substr($curlResult, $header_size);

                    if (!empty($curlResult)) {
                        $decodedRes = json_decode($curlResult);
                        //echo 'E:<pre>'; print_r($decodedRes);
                        $ssiData = array();
                        $api_ssiScore = $ssiData['memberScore_overall'] = $decodedRes->memberScore->overall; //44.64;//
                        $ssiData['valProfessionalBrand'] = $decodedRes->memberScore->subScores[0]->score; //5.75;//
                        $ssiData['valFindRightPeople'] = $decodedRes->memberScore->subScores[1]->score; //17.28;//
                        $ssiData['valInsightEngagement'] = $decodedRes->memberScore->subScores[2]->score; //8.03;//
                        $ssiData['valStrongRelationship'] = $decodedRes->memberScore->subScores[3]->score; //13.58;//


                        $ssiStr = json_encode($ssiData);
                        $ssiLastUpdated = date('Y-m-d H:i:s');


                        Yii::$app->db->createCommand("UPDATE `user_profile` SET `ssiData` = '" . addslashes($ssiStr) . "', `ssiLastUpdated` = '" . $ssiLastUpdated . "' WHERE `user_id` =" . $userId)->execute();
                    }
                    //04-12-2020 ends
                }
                //NR ends




                $final_result = array();
                $final_result['success'] = 1; //09-09-2020
                $final_result['profileData'] = $profileData;




                $api_IPPV_profile_locationName = 'N/A';
                $api_IPPV_profile_summary_html = '<p>N/A</p>';
                if ($apiRes_IdentityProfilesProfileView != '') {
                    if (isset($apiRes_IdentityProfilesProfileView->profile->locationName)) {
                        $api_IPPV_profile_locationName = $apiRes_IdentityProfilesProfileView->profile->locationName;
                    }

                    if (isset($apiRes_IdentityProfilesProfileView->profile->summary)) {
                        //01-07-2020:htmlentities added due to it was causing issue when summary contains html;
                        if (strlen($apiRes_IdentityProfilesProfileView->profile->summary) > 325) {
                            $api_IPPV_profile_summary_html = '<p id="shortAbout">' . substr(htmlentities($apiRes_IdentityProfilesProfileView->profile->summary), 0, 325) . '... <a href="javascript:void(0);" id="aShortAbout">Read more</a></p>';
                            $api_IPPV_profile_summary_html .= '<p id="fullAbout" style="display:none;">' . htmlentities($apiRes_IdentityProfilesProfileView->profile->summary) . ' <a href="javascript:void(0);" id="aFullAbout">Read less</a></p>';
                        } else {
                            $api_IPPV_profile_summary_html = '<p>' . htmlentities($apiRes_IdentityProfilesProfileView->profile->summary) . '</p>';
                        }
                    }
                }
                //print_r($api_IPPV_profile_summary_html); 
                $apiIPPCI_phoneNumbers = 'N/A';
                $apiIPPCI_emailAddress = 'N/A';
                if ($apiRes_IdentityProfilesProfileContactInfo != '') {
                    if (isset($apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number)) {
                        $apiIPPCI_phoneNumbers = $apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number;
                    }

                    if (isset($apiRes_IdentityProfilesProfileContactInfo->emailAddress)) {
                        $apiIPPCI_emailAddress = $apiRes_IdentityProfilesProfileContactInfo->emailAddress;
                    }
                }

                $api_me_miniProfile_Occupation = 'N/A';
                if ($apiRes_me != '') {
                    if (isset($apiRes_me->miniProfile->occupation)) {
                        $api_me_miniProfile_Occupation = $apiRes_me->miniProfile->occupation;
                    }
                }

                $html_basicDetail = '';
                $html_basicDetail .= '<ul class="list-unstyled basicDetailsBlk">';
                $html_basicDetail .= '<li><i class="cursor-pointer bx bx-map mb-1 mr-50"></i>' . $api_IPPV_profile_locationName . '</li>';
                $html_basicDetail .= '<li><i class="cursor-pointer bx bx-phone-call mb-1 mr-50"></i>' . $apiIPPCI_phoneNumbers . '</li>';
                $html_basicDetail .= '<li><i class="cursor-pointer bx bx-envelope mb-1 mr-50"></i>' . $apiIPPCI_emailAddress . '</li></ul><div class="profilOccBlk"><h6><small class="text-muted">Occupation</small></h6><p>' . $api_me_miniProfile_Occupation . '</p></div>';
                //<div class="profileAbtBlk"><h6><small class="text-muted">About</small></h6>
                /* $api_IPPV_profile_summary_html = addslashes($api_IPPV_profile_summary_html);
                  $api_IPPV_profile_summary_html = htmlspecialchars($api_IPPV_profile_summary_html); */
                //$html_basicDetail .= $api_IPPV_profile_summary_html;
                //$html_basicDetail .= '</div>'; 
                //print_r(htmlentities($html_basicDetail, NULL, 'UTF-8'));
                $final_result['html_basicDetail'] = $html_basicDetail;
                $final_result['apiRes_me'] = $apiRes_me;
                $final_result['api_ssiScore'] = $api_ssiScore; //04-12-2020
                //print_r(json_encode($final_result,JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)); 
                //updating data starts
                $ProfilePic400_400 = $profileData['pic_400_400'];
                $pdNumConnections = $profileData['numConnections'];
                $pdPendingConnections = $profileData['pendingConnections'];
                $pdNumTotalSentInvitations = $profileData['numTotalSentInvitations'];

                $api_IPPV_profile_locationName = 'N/A';
                $api_IPPV_profile_summary_html = 'N/A'; //'<p>N/A</p>';
                if ($apiRes_IdentityProfilesProfileView != '') {
                    if (isset($apiRes_IdentityProfilesProfileView->profile->locationName)) {
                        $api_IPPV_profile_locationName = $apiRes_IdentityProfilesProfileView->profile->locationName;
                    }

                    if (isset($apiRes_IdentityProfilesProfileView->profile->summary)) {
                        //01-07-2020:htmlentities added due to it was causing issue when summary contains html;
                        $api_IPPV_profile_summary_html = htmlentities($apiRes_IdentityProfilesProfileView->profile->summary);
                    }
                }
                $IPPV_profileLocationName = $api_IPPV_profile_locationName;
                //$IPPV_profileSummary = $api_IPPV_profile_summary_html;
                $IPPV_profileSummary = str_replace("'", "`", $api_IPPV_profile_summary_html); //07-July-2020

                $apiIPPCI_phoneNumbers = 'N/A';
                if ($apiRes_IdentityProfilesProfileContactInfo != '') {
                    if (isset($apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number)) {
                        $apiIPPCI_phoneNumbers = $apiRes_IdentityProfilesProfileContactInfo->phoneNumbers[0]->number;
                    }
                }
                $IPPCI_phoneNumber = $apiIPPCI_phoneNumbers;

                $api_me_miniProfile_Occupation = 'N/A';
                $api_me_miniProfile_firstName = 'N/A';
                $api_me_miniProfile_lastName = 'N/A';
                if ($apiRes_me != '') {
                    if (isset($apiRes_me->miniProfile->occupation)) {
                        //$api_me_miniProfile_Occupation = $apiRes_me->miniProfile->occupation;
                        $api_me_miniProfile_Occupation = addslashes($this->mb_htmlentities($apiRes_me->miniProfile->occupation));
                    }
                    if (isset($apiRes_me->miniProfile->firstName)) {
                        //$api_me_miniProfile_firstName = $apiRes_me->miniProfile->firstName;
                        $api_me_miniProfile_firstName = addslashes($this->mb_htmlentities($apiRes_me->miniProfile->firstName));
                    }
                    if (isset($apiRes_me->miniProfile->lastName)) {
                        //$api_me_miniProfile_lastName = $apiRes_me->miniProfile->lastName;
                        $api_me_miniProfile_lastName = addslashes($this->mb_htmlentities($apiRes_me->miniProfile->lastName));
                    }
                }


                //, IPPV_profileSummary='".$IPPV_profileSummary."'
                //addslashes($api_me_miniProfile_firstName)
                //addslashes($api_me_miniProfile_lastName)
                //addslashes($api_me_miniProfile_Occupation)
                $update_user_data = "update user_profile set ProfilePic400_400='" . addslashes($ProfilePic400_400) . "', pdNumConnections='" . $pdNumConnections . "', pdPendingConnections='" . $pdPendingConnections . "', pdNumTotalSentInvitations='" . $pdNumTotalSentInvitations . "', IPPV_profileLocationName='" . addslashes($IPPV_profileLocationName) . "', IPPCI_phoneNumber='" . addslashes($IPPCI_phoneNumber) . "', firstName='" . addslashes($api_me_miniProfile_firstName) . "', lastName='" . addslashes($api_me_miniProfile_lastName) . "', occupation='" . $api_me_miniProfile_Occupation . "' where user_id='" . Yii::$app->session->get('userid') . "'";

                //echo $update_user_data; die;

                Yii::$app->db->createCommand($update_user_data)->execute();
                //updating data ends

                return json_encode($final_result);
            } else {
                //$profileData['pic_100_100'] = '';
                //$profileData['pic_400_400'] = '';
                //$apiRes_me = '';
                //09-09-2020 added
                $final_result = array();
                $final_result['success'] = 0; //09-09-2020
                return json_encode($final_result);
            }
            //}
        } else {
            //09-09-2020 added
            $final_result = array();
            $final_result['success'] = 0; //09-09-2020
            return json_encode($final_result);
        }
    }

    public function actionUpdatelinkedinpassword() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (isset($_POST['linkedin_password']) && $_POST['linkedin_password'] != '') {
            $sql = "UPDATE `user_profile` SET `linkedin_password`='" . addslashes($_POST['linkedin_password']) . "' where `user_id`='" . Yii::$app->session->get('userid') . "'";
            Yii::$app->db->createCommand($sql)->execute();
        }
    }

    public function actionProfileUpdate() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        if (\Yii::$app->request->post()) {
            try {
                if (Yii::$app->session->get('first_name') == '')
                    $url = 'prospect';



                if (isset($_POST['linkedin_password']) && $_POST['linkedin_password'] != '') {
                    $sql = "UPDATE `user_profile` SET `linkedin_password`='" . addslashes($_POST['linkedin_password']) . "' where `user_id`='" . Yii::$app->session->get('userid') . "'";
                    Yii::$app->db->createCommand($sql)->execute();
                }

                if (\Yii::$app->request->post('ePwd')) {

                    // echo "pwd"; die();


                    $password = password_hash(\Yii::$app->request->post('ePwd'), PASSWORD_DEFAULT);
                    $sql = "UPDATE `user` SET `password_hash`='" . $password . "' where `email`='" . Yii::$app->session->get('useremail') . "'";
                    Yii::$app->db->createCommand($sql)->execute();
                    Yii::$app->session->set('google', '0');
                    Yii::$app->session->setFlash(
                            'info', Yii::t(
                                    'user', 'Password for Extension is set Successfully'
                            )
                    );
                } else {
                    if (strlen(\Yii::$app->request->post('first_name')) > 0) {
                        //echo "else"; die(); 


                        $first_name = addslashes(\Yii::$app->request->post('first_name'));
                        $first_name = htmlspecialchars($first_name);

                        $last_name = addslashes(\Yii::$app->request->post('last_name'));
                        $last_name = htmlspecialchars($last_name);

                        $companyname = addslashes(\Yii::$app->request->post('companyname'));
                        $companyname = htmlspecialchars($companyname);

                        $contactphone = addslashes(\Yii::$app->request->post('contactphone'));
                        $contactphone = htmlspecialchars($contactphone);

                        Yii::$app->session->set('first_name', $first_name);
                        $sql = Yii::$app->db->createCommand("UPDATE `user` SET `first_name`='" . $first_name . "',`last_name`='" . $last_name . "' , `companyname`='" . $companyname . "' ,`contactphone`='" . $contactphone . "' WHERE `id` ='" . \Yii::$app->request->post('id') . "'")->execute();
                        /* $email=Yii::$app->session->get('useremail');
                          $name=Yii::$app->request->post('first_name');
                          $Content =file_get_contents("../api/userregistr/WelcomeEmail");
                          $message = str_replace("FIRSTNAME",$name,$Content);
                          //$message = str_replace("FIRSTNAME",'',$message);


                          include("../api/userregistr/mail.php"); */
                        //Yii::$app->session->setFlash('success', "Profile Updated Successfully");
                    } elseif ((is_numeric(Yii::$app->request->post('sublevel')) || is_numeric(Yii::$app->request->post('trial_expired'))) && is_numeric(Yii::$app->request->post('trial_expired_at'))) {

                        $sublevel = Yii::$app->request->post('sublevel');
                        $trial_expired_at = Yii::$app->request->post('trial_expired_at');
                        $trial = !Yii::$app->request->post('trial_expired');

                        $sql = "UPDATE `user` SET `sublevel`='" . $sublevel . "', `trial`= '" . $trial . "' , `trial_expired_at`='" . $trial_expired_at . "' where `email`='" . Yii::$app->session->get('useremail') . "'";
                        Yii::$app->db->createCommand($sql)->execute();



                        if ($sublevel > 0) {
                            try {
                                $created_at = time();
                                $curl = curl_init();

                                curl_setopt_array($curl, array(
                                    CURLOPT_URL => "https://api.intercom.io/events",
                                    CURLOPT_RETURNTRANSFER => true,
                                    CURLOPT_ENCODING => "",
                                    CURLOPT_MAXREDIRS => 10,
                                    CURLOPT_TIMEOUT => 30,
                                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                    CURLOPT_CUSTOMREQUEST => "POST",
                                    CURLOPT_SSL_VERIFYPEER => FALSE,
                                    CURLOPT_POSTFIELDS => "{\r\n  \"event_name\" : \"trail_initialize\",\r\n  \"created_at\": " . $created_at . ",\r\n  \"email\" : \"" . Yii::$app->session->get('useremail') . "\",\r\n  \"metadata\": {\r\n    \"sublevel\": " . $sublevel . "\r\n\r\n \r\n  }\r\n}\r\n",
                                    CURLOPT_HTTPHEADER => array(
                                        "authorization: Bearer dG9rOmNlYmQ1YTM1XzM1MjdfNGEyOF9iY2Q2X2U4Y2Y2NTYzODExYzoxOjA=",
                                        "cache-control: no-cache",
                                        "content-type: application/json"
                                    ),
                                ));

                                $response = curl_exec($curl);
                                $err = curl_error($curl);

                                curl_close($curl);

                                if ($err) {
                                    echo "cURL Error #:" . $err;
                                } else {
                                    //  echo $response;
                                }


                                $subject = "Trial start";

                                $message = "Trail initialize for " . Yii::$app->session->get('useremail') . " and sublevel is:" . $sublevel;
                                include("../include/mailfordetails.php");
                            } catch (Exception $e) {
                                echo 'Caught exception: ', $e->getMessage(), "\n";
                            }
                        } else {


                            try {
                                $created_at = time();
                                $curl = curl_init();

                                curl_setopt_array($curl, array(
                                    CURLOPT_URL => "https://api.intercom.io/events",
                                    CURLOPT_RETURNTRANSFER => true,
                                    CURLOPT_ENCODING => "",
                                    CURLOPT_MAXREDIRS => 10,
                                    CURLOPT_TIMEOUT => 30,
                                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                    CURLOPT_CUSTOMREQUEST => "POST",
                                    CURLOPT_SSL_VERIFYPEER => FALSE,
                                    CURLOPT_POSTFIELDS => "{\r\n  \"event_name\" : \"trail_expire\",\r\n  \"created_at\": " . $created_at . ",\r\n  \"email\" : \"" . Yii::$app->session->get('useremail') . "\",\r\n  \"metadata\": {\r\n    \"sublevel\": " . $sublevel . "\r\n\r\n \r\n  }\r\n}\r\n",
                                    CURLOPT_HTTPHEADER => array(
                                        "authorization: Bearer dG9rOmNlYmQ1YTM1XzM1MjdfNGEyOF9iY2Q2X2U4Y2Y2NTYzODExYzoxOjA=",
                                        "cache-control: no-cache",
                                        "content-type: application/json"
                                    ),
                                ));

                                $response = curl_exec($curl);
                                $err = curl_error($curl);

                                curl_close($curl);

                                if ($err) {
                                    echo "cURL Error #:" . $err;
                                } else {
                                    //  echo $response;
                                }


                                $subject = "Trial End";

                                $message = "Trail expired for " . Yii::$app->session->get('useremail') . " and sublevel is:" . $sublevel;
                                include("../include/mailfordetails.php");
                            } catch (Exception $e) {
                                echo 'Caught exception: ', $e->getMessage(), "\n";
                            }
                        }

                        /*



                          if($sublevel == 0){
                          try{
                          $curl = curl_init();

                          curl_setopt_array($curl, array(
                          CURLOPT_URL => "https://api.intercom.io/events",
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => "",
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 30,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => "POST",
                          CURLOPT_SSL_VERIFYPEER=>FALSE,
                          CURLOPT_POSTFIELDS => "{\r\n  \"event_name\" : \"trail_expire\",\r\n  \"created_at\": ".$created_at.",\r\n  \"email\" : \"".Yii::$app->session->get('useremail')."\",\r\n  \"metadata\": {\r\n    \"sublevel\": ".$sublevel."\r\n\r\n \r\n  }\r\n}\r\n",
                          CURLOPT_HTTPHEADER => array(
                          "authorization: Bearer dG9rOmNlYmQ1YTM1XzM1MjdfNGEyOF9iY2Q2X2U4Y2Y2NTYzODExYzoxOjA=",
                          "cache-control: no-cache",
                          "content-type: application/json"
                          ),
                          ));

                          $response = curl_exec($curl);
                          $err = curl_error($curl);

                          curl_close($curl);

                          if ($err) {
                          echo "cURL Error #:" . $err;
                          } else {
                          //echo $response;
                          }

                          $subject = "Trial End";

                          $message="Trail expired for ".Yii::$app->session->get('useremail')." and sublevel is:".$sublevel;
                          include("../include/mailfordetails.php");

                          }catch(Exception $e){
                          echo 'Caught exception: ',  $e->getMessage(), "\n";
                          }

                          $trial = 0;
                          }else{
                          try{
                          $curl = curl_init();

                          curl_setopt_array($curl, array(
                          CURLOPT_URL => "https://api.intercom.io/events",
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => "",
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 30,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => "POST",
                          CURLOPT_SSL_VERIFYPEER=>FALSE,
                          CURLOPT_POSTFIELDS => "{\r\n  \"event_name\" : \"trail_initialize\",\r\n  \"created_at\": ".$created_at.",\r\n  \"email\" : \"".Yii::$app->session->get('useremail')."\",\r\n  \"metadata\": {\r\n    \"sublevel\": ".$sublevel."\r\n\r\n \r\n  }\r\n}\r\n",
                          CURLOPT_HTTPHEADER => array(
                          "authorization: Bearer dG9rOmNlYmQ1YTM1XzM1MjdfNGEyOF9iY2Q2X2U4Y2Y2NTYzODExYzoxOjA=",
                          "cache-control: no-cache",
                          "content-type: application/json"
                          ),
                          ));

                          $response = curl_exec($curl);
                          $err = curl_error($curl);

                          curl_close($curl);

                          if ($err) {
                          echo "cURL Error #:" . $err;
                          } else {
                          echo $response;
                          }

                          $subject = "Trial start";

                          $message="Trail initialize for ".Yii::$app->session->get('useremail')." and sublevel is:".$sublevel;
                          include("../include/mailfordetails.php");

                          }catch(Exception $e){
                          echo 'Caught exception: ',  $e->getMessage(), "\n";
                          }
                          }









                         */
                    }
                }

                if ((is_numeric(Yii::$app->request->post('sublevel')) || is_numeric(Yii::$app->request->post('trial_expired'))) && is_numeric(Yii::$app->request->post('trial_expired_at'))) {
                    echo "1";
                } else {
                    if (isset($url) && $url == 'prospectnew')
                        return $this->redirect(\Yii::$app->request->baseUrl . "/my-template/prospectnew");
                    else
                        return $this->redirect(\Yii::$app->request->baseUrl . "/my-template/profile-setting");
                }
            } catch (Exception $e) {
                echo 'Caught exception: ', $e->getMessage(), "\n";
            }
        }
    }

    public function actionChangepass() {
        $mypasskey = Yii::$app->request->post('newpass');
        if (preg_match('/^(?=.*[!@#$%^&*-])(?=.*[0-9])(?=.*[A-Z]).{6,20}$/', $mypasskey)) {
            $password = password_hash($mypasskey, PASSWORD_DEFAULT);
            $sql = "UPDATE `user` SET `password_hash`='" . $password . "' where `email`='" . Yii::$app->session->get('useremail') . "'";
            Yii::$app->db->createCommand($sql)->execute();
            Yii::$app->session->setFlash(
                    'info', Yii::t(
                            'user', 'You changed password successfully. please login again with new password'
                    )
            );
            return 3;
        } else {
            return 1;
        }
    }

    public function actionChangepass_old() {
        $mypasskey = Yii::$app->request->post('newpass');
        if (preg_match('/[^a-z_\-0-9]/i', $mypasskey)) {
            return 1;
        } elseif (strlen($mypasskey) < 6) {
            return 2;
        } elseif ($mypasskey) {
            $password = password_hash($mypasskey, PASSWORD_DEFAULT);
            $sql = "UPDATE `user` SET `password_hash`='" . $password . "' where `email`='" . Yii::$app->session->get('useremail') . "'";
            Yii::$app->db->createCommand($sql)->execute();
            Yii::$app->session->setFlash(
                    'info', Yii::t(
                            'user', 'You changed password successfully. please login again with new password'
                    )
            );
            return 3;
        }
    }

    public function actionDelateuser() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $userid = $_POST['id'];
        try {
            $sql = Yii::$app->db->createCommand("delete from  user  where id =" . $userid)->execute();
        } catch (Exception $e) {
            echo 'Caught exception: ', $e->getMessage(), "\n";
        }
        return $this->redirect('dashboard');
    }

    //for user use sequence  or not 
    public function actionUserdetail() {
        //  $maildata=Yii::$app->db->createCommand("SELECT user.id,user.first_name,user.contactphone,user.trial_expired_at,user.trial,user.sublevel, user.`email`, COUNT(blacklist.userid) AS Total FROM user LEFT JOIN blacklist ON user.id = blacklist.userid WHERE DATE(DATE_FORMAT(FROM_UNIXTIME(user.created_at), '%Y-%m-%d')) = DATE_SUB(CURDATE(), INTERVAL 1 DAY) GROUP BY user.id,user.email")->queryAll();

        $maildata = Yii::$app->db->createCommand("SELECT user.id,user.first_name,user.contactphone,user.trial_expired_at,user.trial,user.sublevel, user.`email`, COUNT(blacklist.userid) AS Total_old , COUNT(CASE WHEN blacklist.created_at <= DATE(DATE_FORMAT(FROM_UNIXTIME(user.created_at), '%Y-%m-%d')) + INTERVAL 1 DAY THEN 1 END) AS Total FROM user LEFT JOIN blacklist ON user.id = blacklist.userid WHERE DATE(DATE_FORMAT(FROM_UNIXTIME(user.created_at), '%Y-%m-%d')) = DATE_SUB(CURDATE(), INTERVAL 1 DAY) GROUP BY user.id,user.email ORDER BY `Total` DESC")->queryAll();

        // blacklist invite count added in cron 

        if (isset($maildata)) {


            //include("../include/mail.php");
            $message = "<table border='1'><tr style='text-align: center;'><td>sr no.</td><td >First name</td><td>Email</td><td>Contact No</td><td>Number of request sent</td><td>Trial Initialize</td><td>Plan</td></tr>";
            for ($i = 0; $i < sizeof($maildata); $i++) {
                $timestamp = intval($maildata[$i]['trial_expired_at'] / 1000);

                //$before_7day = date('Y-m-d', strtotime('-7 days', $timestamp));

                $fnamenew = $maildata[$i]['first_name'];
                $sublevel = $maildata[$i]['sublevel'];
                $trial = $maildata[$i]['trial'];
                if (!$trial)
                    $before_7day = '';
                else
                    $before_7day = "Yes";


                $plan = "";
                if ($sublevel == 0) {
                    //$plan="Free Forever";
                    $plan = "";
                } else if ($sublevel == 1) {
                    $plan = "Professional Monthly";
                } else if ($sublevel == 2) {
                    $plan = "Professional Quarterly";
                } else if ($sublevel == 3) {
                    $plan = "Grow Monthly";
                } else if ($sublevel == 4) {
                    $plan = "Grow Quarterly";
                } else if ($sublevel == 5) {
                    $plan = "Ultimate Monthly";
                } else if ($sublevel == 6) {
                    $plan = "Ultimate Quarterly";
                }

                $srno = $i + 1;

                $message .= "<tr style='text-align: center;'><td>" . $srno . "</td><td>" . $fnamenew . "</td><td>" . $maildata[$i]['email'] . "</td><td>" . $maildata[$i]['contactphone'] . "</td><td>" . $maildata[$i]['Total'] . "</td><td>" . $before_7day . "</td><td>" . $plan . "</td></tr>";
            }
            // echo $message;exit;
            $message .= "</table>";
            // echo $message; die(); 
            include("../include/mailfordetails.php");
        }
    }

    public function actionUpdatesettingskip() {
        $skipblacklist = Yii::$app->request->post('skipblacklist');

        try {
            $sql = Yii::$app->db->createCommand("UPDATE `user` SET `skip_Blacklist` = '" . $skipblacklist . "' WHERE `id` = " . Yii::$app->session->get('userid'))->execute();

            echo '1';
        } catch (Exception $e) {
            echo 'Caught exception: ', $e->getMessage(), "\n";
        }
    }

    public function actionUpdatesuppressionlist() {
        $suppressionlist = Yii::$app->request->post('suppressionlist');

        try {
            $sql = Yii::$app->db->createCommand("UPDATE `user` SET `isSuppressionlistOnTeam` = '" . $suppressionlist . "' WHERE `id` = " . Yii::$app->session->get('userid'))->execute();

            echo '1';
        } catch (Exception $e) {
            echo 'Caught exception: ', $e->getMessage(), "\n";
        }
    }

    public function actionUpdatesequencetodelete() {
        $id = Yii::$app->request->post('id');

        try {

            $sequences = Yii::$app->db->createCommand("SELECT sequences.local_seq_json  from sequences where sequences.id = " . $id)->queryOne();
            $sequences = json_decode($sequences['local_seq_json']);

            $sequences->status = 'Deleted';
            $data = json_encode($sequences);
            /* echo $data;
              print_r($sequences); */

            $sqlUpdate = Yii::$app->db->createCommand("UPDATE `sequences` SET  `local_seq_json` = '" . $data . "' WHERE `sequences`.`id` = " . $id)->execute();

            echo '1';
        } catch (Exception $e) {
            echo 'Caught exception: ', $e->getMessage(), "\n";
        }
    }

    public function actionUserone() {
        $maildata = Yii::$app->db->createCommand("SELECT user.id,user.companyname,user.first_name,user.contactphone, user.`email`, COUNT(blacklist.userid) AS Total FROM user LEFT JOIN blacklist ON user.id = blacklist.userid WHERE blacklist.created_at >= DATE_SUB(NOW(), INTERVAL 24 HOUR) GROUP BY user.id,user.email ORDER BY `Total` DESC")->queryAll();
        //	 print_r($maildata);exit;
        $created_at = time();
        /* $maildata['email']="sanju143@intricare.net";
          $maildata['first_name']="sanjay";
          $maildata['contactphone']="9924366245";
          $maildata['companyname']="intricare";
         */ if (isset($maildata)) {
            for ($i = 0; $i < sizeof($maildata); $i++) {
                try {
                    ini_set('max_execution_time', 0);
                    $curl = curl_init();

                    curl_setopt_array($curl, array(
                        CURLOPT_URL => "https://api.intercom.io/users",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 30,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => "POST",
                        CURLOPT_SSL_VERIFYPEER => FALSE,
                        CURLOPT_POSTFIELDS => "{\r\n  \"email\": \"" . $maildata[$i]['email'] . "\",\r\n  \"name\": \"" . $maildata[$i]['first_name'] . "\",\r\n  \"phone\": \"" . $maildata[$i]['contactphone'] . "\"\r\n}",
                        CURLOPT_HTTPHEADER => array(
                            "accept: application/json",
                            "authorization: Bearer dG9rOmNlYmQ1YTM1XzM1MjdfNGEyOF9iY2Q2X2U4Y2Y2NTYzODExYzoxOjA=",
                            "cache-control: no-cache",
                            "content-type: application/json"
                        ),
                    ));

                    $response = curl_exec($curl);
                    $err = curl_error($curl);

                    curl_close($curl);

                    if ($err) {
                        echo "cURL Error #:" . $err;
                    } else {
                        //echo $response;
                        $res = json_decode($response);
                        $email = $res->email;
                        try {
                            $curl = curl_init();

                            curl_setopt_array($curl, array(
                                CURLOPT_URL => "https://api.intercom.io/events",
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => "",
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 30,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_CUSTOMREQUEST => "POST",
                                CURLOPT_SSL_VERIFYPEER => FALSE,
                                CURLOPT_POSTFIELDS => "{\r\n  \"event_name\" : \"Daily_used\",\r\n  \"created_at\": " . $created_at . ",\r\n  \"email\" : \"" . $email . "\",\r\n  \"metadata\": {\r\n    \"daily_use\": " . $maildata[$i]['Total'] . "\r\n\r\n   \r\n  }\r\n}\r\n",
                                CURLOPT_HTTPHEADER => array(
                                    "authorization: Bearer dG9rOmNlYmQ1YTM1XzM1MjdfNGEyOF9iY2Q2X2U4Y2Y2NTYzODExYzoxOjA=",
                                    "cache-control: no-cache",
                                    "content-type: application/json"
                                ),
                            ));

                            $response = curl_exec($curl);
                            $err = curl_error($curl);

                            curl_close($curl);

                            if ($err) {
                                echo "cURL Error #:" . $err;
                            } else {
                                echo $response;
                            }
                        } catch (Exception $e) {
                            echo 'Caught exception: ', $e->getMessage(), "\n";
                        }
                    }
                } catch (Exception $e) {
                    echo 'Caught exception: ', $e->getMessage(), "\n";
                }
            }
        }
    }

    /**
     * Displays a single MyTemplateModel model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new MyTemplateModel model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $model = new MyTemplateModel();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        return $this->render('create', [
                    'model' => $model,
        ]);
    }

    /**
     * Updates an existing MyTemplateModel model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect('$url');
        }
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        return $this->render('update', [
                    'model' => $model,
        ]);
    }

    /**
     * Deletes an existing MyTemplateModel model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    public function actionUpdatesetting() {
        $addBlaklist_OnAcceptance = Yii::$app->request->post('addBlaklist_OnAcceptance');

        try {
            // Meera Tank : issue solved
            $sql = Yii::$app->db->createCommand("UPDATE `user` SET `addBlaklist_OnAcceptance` = '" . $addBlaklist_OnAcceptance . "' WHERE `id` = " . Yii::$app->session->get('userid') . " ")->execute();
            echo '1';
        } catch (Exception $e) {
            echo 'Caught exception: ', $e->getMessage(), "\n";
        }
    }

    public function actionUpdaterepstatus() {
        $Performance_Report = Yii::$app->request->post('Performance_Report');

        try {
            // Meera Tank : issue solved
            $sql = Yii::$app->db->createCommand("UPDATE `user` SET `Performance_Report` = '" . $Performance_Report . "' WHERE `id` = " . Yii::$app->session->get('userid') . " ")->execute();
            echo '1';
        } catch (Exception $e) {
            echo 'Caught exception: ', $e->getMessage(), "\n";
        }
    }

    public function actionUpdatereportday() {
        $day = Yii::$app->request->post('day');

        try {
            $sql = Yii::$app->db->createCommand("UPDATE `user` SET `Performance_Report_Day` = '" . $day . "' WHERE `id` = " . Yii::$app->session->get('userid') . " ")->execute();
            echo '1';
        } catch (Exception $e) {
            echo 'Caught exception: ', $e->getMessage(), "\n";
        }
    }

    public function actionUpdatereponseemailstatus() {
        $responseEmail = Yii::$app->request->post('responseEmail');
        try {
            $sql = Yii::$app->db->createCommand("UPDATE `user` SET `responseEmail` = '" . $responseEmail . "' WHERE `id` = " . Yii::$app->session->get('userid') . " ")->execute();
            echo '1';
        } catch (Exception $e) {
            echo 'Caught exception: ', $e->getMessage(), "\n";
        }
    }

    public function actionBretty() {

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://bpi.briteverify.com/emails.json?address=" . $_GET['address'] . "&apikey=" . $_GET['apikey'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_SSL_VERIFYPEER => FALSE,
                //CURLOPT_CUSTOMREQUEST => "GET",
                /* CURLOPT_HTTPHEADER => array(
                  //"cache-control: no-cache",
                  "apikey: df814ef8-2589-4d08-8670-562d3ca3a25b",
                  //"postman-token: e28395cd-e214-2f75-8f0a-2ba08a9498ed"
                  ), */
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            echo $response;
        }
    }

    public function actionFindthat() {

        //	echo "surename=".$_GET['name'];
        //echo "surename=".$_GET['surename'];
        //echo "surename=".$_GET['domain'];
        //echo "guuid=".$_GET['guuid'];


        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.findthatlead.com/api_guess_v2?name=" . urlencode($_GET['name']) . "&surname=" . urlencode($_GET['surname']) . "&domain=" . urlencode($_GET['domain']) . "&guuid=" . $_GET['guuid'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_SSL_VERIFYPEER => FALSE,
            //CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                //"cache-control: no-cache",
                "datatype: json",
            //"postman-token: e28395cd-e214-2f75-8f0a-2ba08a9498ed"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            echo $response;
        }
    }

    public function actionToofr() {

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://www.findemails.com/api/v1/guess_email.json",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_SSL_VERIFYPEER => FALSE,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_HTTPHEADER => array(
                //"cache-control: no-cache",
                "key:'" . $_GET['key'] . "'",
                "company_name: '" . $_GET['company_name'] . "'",
                "first_name: '" . $_GET['first_name'] . "'",
                "last_name: '" . $_GET['last_name'] . "'",
                "datatype: json",
            //"postman-token: 13dc25f5-f7e6-cfec-a6cc-5f1003bee8ee"
            ),
                //CURLOPT_CUSTOMREQUEST => "GET",
                /* CURLOPT_HTTPHEADER => array(
                  //"cache-control: no-cache",
                  "apikey: df814ef8-2589-4d08-8670-562d3ca3a25b",
                  //"postman-token: e28395cd-e214-2f75-8f0a-2ba08a9498ed"
                  ), */
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            echo $response;
        }
    }

    public function actionSkrapp() {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.skrapp.io/api/v2/find?fullName=" . urlencode($_GET['firstName'] . " " . $_GET['lastName']) . "&domain=" . $_GET['domain'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_SSL_VERIFYPEER => FALSE,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "x-access-key: " . $_GET['X-Access-Key'],
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        header('Access-Control-Allow-Origin: *');
        header('Content-Type: application/json');
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            echo $response;
        }
    }

    public function actionEmailfinder() {

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.hunter.io/v2/email-finder?domain=" . $_GET['domain'] . "&first_name=" . urlencode($_GET['first_name']) . "&last_name=" . urlencode($_GET['last_name']) . "&api_key=" . $_GET['api_key'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_SSL_VERIFYPEER => FALSE,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        header('Access-Control-Allow-Origin: *');
        header('Content-Type: application/json');

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            echo $response;
        }
    }

    public function actionEmailverifier() {

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.hunter.io/v2/email-verifier?email=" . $_GET['email'] . "&api_key=" . $_GET['api_key'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_SSL_VERIFYPEER => FALSE,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache"
            ),
        ));

        header('Access-Control-Allow-Origin: *');
        header('Content-Type: application/json');

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            echo $response;
        }
    }

    public function actionDomainsearch() {

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.hunter.io/v2/domain-search?domain=" . $_GET['domain'] . "&api_key=" . $_GET['api_key'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_SSL_VERIFYPEER => FALSE,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);


        header('Access-Control-Allow-Origin: *');
        header('Content-Type: application/json');


        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            echo $response;
        }
    }

    public function actionGuessemail() {

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://www.findemails.com/api/v1/guess_email.json",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => http_build_query($_POST),
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);


        header('Access-Control-Allow-Origin: *');
        header('Content-Type: application/json');

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            echo $response;
        }
    }

    public function actionPersonjson() {

        $curl = curl_init();
        //$key = $_POST['X-Api-Key'];
        $head = getallheaders();
        // print_r($head); die();
        $key = $head['x-api-key'];

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.anymailfinder.com/v3.0/search/person.json",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => http_build_query(array('domain' => $_POST['domain'], 'name' => $_POST['name'])),
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "X-Api-Key:$key"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        header('Access-Control-Allow-Origin: *');
        header('Content-Type: application/json');

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            echo $response;
        }
    }

    public function actionApiguessv2() {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.findthatlead.com/api_guess_v2?name=" . urlencode($_GET['name']) . "&surname=" . urlencode($_GET['surname']) . "&domain=" . urlencode($_GET['domain']) . "&guuid=" . urlencode($_GET['guuid']),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: dd87c91d-cb24-e2a5-05f8-7133484ffe94"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);
        header('Access-Control-Allow-Origin: *');
        header('Content-Type: application/json');
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            echo $response;
        }
    }

    public function actionEmailjson() {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://bpi.briteverify.com/emails.json?address=" . $_GET['address'] . "&apikey=" . $_GET['apikey'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "postman-token: 7a5b2956-3c35-5a7f-bf21-d78f2d7c576d"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);


        header('Access-Control-Allow-Origin: *');
        header('Content-Type: application/json');

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            echo $response;
        }
    }

    public function actionSavebemail($emailnew, $id) {
        if (Yii::$app->session->get('userid') == '9248') {
            echo $emailnew . '===' . $id;
            die;
        }

        $getid = Yii::$app->db->createCommand("select  profileInfo_id  from  blacklist  where id =" . $id)->queryAll();

        if (isset($getid)) {
            $profiledata = Yii::$app->db->createCommand("select  *  from  profileinfo  where id =" . $getid[0]['profileInfo_id'])->queryAll();


            if (isset($profiledata) && sizeof($profiledata)) {

                $basicInfodata = preg_replace('/\s+/', ' ', $profiledata['0']['basicInfo']);
                $basicInfodata = str_replace("'", "", $basicInfodata);
                $dataToAugment = (array) json_decode($basicInfodata);
                $dataToAugment['bemail'] = $emailnew;
                $data = json_encode((object) $dataToAugment);
                $sql = Yii::$app->db->createCommand("UPDATE `profileinfo` SET `basicInfo`='" . addslashes($data) . "' WHERE `id` ='" . $getid[0]['profileInfo_id'] . "'")->execute();
            }
        }
    }

    public function actionFindavl() {

        if ($_REQUEST['key'] != "") {
            $curl = curl_init();
            ini_set('max_execution_time', 0);

            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://app.findthatlead.com/api/stats",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_SSL_VERIFYPEER => FALSE,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => "token=" . $_GET['key'] . "",
                CURLOPT_HTTPHEADER => array(
                    "accept: application/json, text/plain, */*",
                    // "cache-control: no-cache",
                    "content-length: 38",
                    "content-type: application/x-www-form-urlencoded",
                //  "postman-token: d4bfd280-40e4-aa50-7a64-b7895f7705d7"
                ),
            ));

            $response = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);
        } else {
            $response = "Check Anymailfinder API key In";
        }

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            echo $response;
        }
    }

    public function actionBulkdatarequest() {
        $sqlbulktask = Yii::$app->db->createCommand("INSERT INTO `bulk_finder_tasks`(`isPending`,`total_count`,`email_address`,`finder_name`) VALUES ('1','" . $_GET['limit'] . "','" . Yii::$app->session->get('useremail') . "','" . $_GET['radioValue'] . "')")->execute();
        $lastidinserted = Yii::$app->db->getLastInsertID();


        $limit = $_GET['limit'];
        $offset = $_GET['offset'];
        $first = $_GET['offset'];
        $newQuery = '';
        $TotalTasks = 0;
        if ($limit > 20) {
            $b = $limit;
            $res = array();
            if ($b > 20) {
                $divided = $b / 20;
                for ($i = 1; $i <= ceil($divided); $i++) {

                    if ($b >= 20) {
                        $b = $b - 20;
                        $res[] = 20;
                    } else {

                        $res[] = $b;
                    }
                }
            }

            //echo '<prE>'; print_r($res); 
            $kj = 1;
            $totalcount = count($res);
            foreach ($res as $key => $valt) {
                if ($kj != 1 && $kj != $totalcount) {

                    $offset = $offset + $valt;
                    //echo '==='.$valt;

                    $_GET['offset'] = $offset;
                    $_GET['limit'] = $valt;
                    $jasonmeta_value = json_encode($_GET);
                    $sqlbulk = Yii::$app->db->createCommand("INSERT INTO `bulk_profile_finder`(`meta_value`,`user_id`,`user_email`,`task_id`) VALUES ('" . $jasonmeta_value . "','" . Yii::$app->session->get('userid') . "','" . Yii::$app->session->get('useremail') . "','" . $lastidinserted . "')")->execute();
                } else if ($kj == $totalcount) {

                    $offset = $offset + 20;
                    //echo '==='.$valt;
                    $_GET['offset'] = $offset;
                    $_GET['limit'] = $valt;
                    $jasonmeta_value = json_encode($_GET);
                    $sqlbulk = Yii::$app->db->createCommand("INSERT INTO `bulk_profile_finder`(`meta_value`,`user_id`,`user_email`,`task_id`) VALUES ('" . $jasonmeta_value . "','" . Yii::$app->session->get('userid') . "','" . Yii::$app->session->get('useremail') . "','" . $lastidinserted . "')")->execute();
                } else {

                    $offset = $first;
                    //echo '==='.$valt;
                    $_GET['offset'] = $first;
                    $_GET['limit'] = $valt;
                    $jasonmeta_value = json_encode($_GET);
                    $sqlbulk = Yii::$app->db->createCommand("INSERT INTO `bulk_profile_finder`(`meta_value`,`user_id`,`user_email`,`task_id`) VALUES ('" . $jasonmeta_value . "','" . Yii::$app->session->get('userid') . "','" . Yii::$app->session->get('useremail') . "','" . $lastidinserted . "')")->execute();
                }
                //echo '<br>';
                $kj++;
            }



            $TotalTasks = count($res);

            //$divided = $limit/20;
            /* for($i = 1; $i <= ceil($divided); $i++)
              {
              if($i != 1)
              {
              $offset = $offset + 20;
              $_GET['offset'] = $offset;
              $_GET['limit'] = 20;
              $jasonmeta_value =  json_encode($_GET);
              $sqlbulk =Yii::$app->db->createCommand("INSERT INTO `bulk_profile_finder`(`meta_value`,`user_id`,`user_email`,`task_id`) VALUES ('".$jasonmeta_value."','".Yii::$app->session->get('userid')."','".Yii::$app->session->get('useremail')."','".$lastidinserted."')")->execute();

              }
              else
              {
              $offset = $offset;
              $_GET['offset'] = $offset;
              $_GET['limit'] = 20;
              $jasonmeta_value =  json_encode($_GET);
              $sqlbulk =Yii::$app->db->createCommand("INSERT INTO `bulk_profile_finder`(`meta_value`,`user_id`,`user_email`,`task_id`) VALUES ('".$jasonmeta_value."','".Yii::$app->session->get('userid')."','".Yii::$app->session->get('useremail')."','".$lastidinserted."')")->execute();
              }

              $TotalTasks++;
              } */
        } else {

            $jasonmeta_value = json_encode($_GET);
            $sqlbulk = Yii::$app->db->createCommand("INSERT INTO `bulk_profile_finder`(`meta_value`,`user_id`,`user_email`,`task_id`) VALUES ('" . $jasonmeta_value . "','" . Yii::$app->session->get('userid') . "','" . Yii::$app->session->get('useremail') . "','" . $lastidinserted . "')")->execute();
            $TotalTasks = 1;
        }

        Yii::$app->db->createCommand("UPDATE `bulk_finder_tasks` SET `total_tasks`='" . $TotalTasks . "' WHERE `id` ='" . $lastidinserted . "'")->execute();

        /* $jasonmeta_value =  json_encode($_GET);
          $sqlbulk =Yii::$app->db->createCommand("INSERT INTO `bulk_profile_finder`(`meta_value`,`user_id`,`user_email`) VALUES ('".$jasonmeta_value."','".Yii::$app->session->get('userid')."','".Yii::$app->session->get('useremail')."')")->execute(); */
    }

    public function actionBulkdata() {
        if (Yii::$app->session->get('userid') == '9248') {
            $jasonmeta_value = json_encode($_GET);
            $sqlbulk = Yii::$app->db->createCommand("INSERT INTO `bulk_profile_finder`(`meta_value`,`user_id`,`user_email`) VALUES ('" . $jasonmeta_value . "','" . Yii::$app->session->get('userid') . "','" . Yii::$app->session->get('useremail') . "')")->execute();
        } else {

            $limit = $_GET['limit'] + 1;
            $offset = $_GET['offset'] - 1;
            $radioValue = $_GET['radioValue'];
            $key = $_GET['key'];
            $addfilter = '';
            $status = '';
            $today = date("d/m/Y h:m:s");
            $responsearray = [];
            if (isset($_GET['srname']) && $_GET['srname'] != "") {
                $addfilter = " AND  basicInfo LIKE'%" . $_GET['srname'] . "%'";
            } else if (isset($_GET['search']) && $_GET['search'] != "") {
                $addfilter = " AND  basicInfo LIKE'%" . $_GET['search'] . "%'";
            }
            if (isset($_GET['status']) && $_GET['status'] != "") {
                if ($_GET['status'] == "accept") {
                    $status = " AND  b.is_accepted LIKE'%1%'";
                } else if ($_GET['status'] == "pending") {
                    $status = " AND  b.is_accepted LIKE'%0%'";
                }
            }
            /*  $query = (new \yii\db\Query())->select(['b.id',
              'p.basicInfo','c.company_page_url']
              )
              ->from('blacklist b')
              ->join('LEFT OUTER JOIN', 'companyinfo c',
              'c.id =b.companyInfo_id')
              ->join('LEFT OUTER JOIN', 'profileinfo p',
              'p.id =b.profileInfo_id')->where(['userid' => Yii::$app->session->get('userid')])
              ->andWhere("profileInfo_id !=0  and companyInfo_id != 0 ".$addfilter)->offset($offset)
              ->limit($limit)
              ->all(); */
            $query = (new \yii\db\Query())->select(['b.id',
                        'p.basicInfo', 'c.company_page_url']
                    )
                    ->from('blacklist b')
                    ->join('LEFT OUTER JOIN', 'companyinfo c', 'c.id =b.companyInfo_id')
                    ->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id')->where(['userid' => Yii::$app->session->get('userid')])
                    ->andWhere("profileInfo_id !=0  and companyInfo_id != 0" . $addfilter . $status)->offset($offset)
                    ->limit($limit)
                    ->orderBy(['b.updated_at' => SORT_DESC])
                    ->all();
            /* $countQuery = clone $query;
              $pages = new Pagination(['totalCount' => $countQuery->count()]);
              $models = $query->offset($offset)
              ->limit($limit)
              ->all(); */
            // $bulkdata=json_encode($query);
            //echo $query;
            //print_r($query);die();


            $count = 0;
            foreach ($query as $data_detail_final) {


                //echo $data['company_detail'];
                //$temp= $data['company_detail'];
                $data_detail_final['basicInfo'] = preg_replace('/\\\\"/m', '"', $data_detail_final['basicInfo']);

                $data_detail_final['basicInfo'] = trim(preg_replace('/\s+/', ' ', $data_detail_final['basicInfo']));
                # code..
                $data_detail = json_decode($data_detail_final['basicInfo'], JSON_HEX_APOS);
                $data_detail = (object) $data_detail;
                // print_r($data_detail->firstName);die();

                if (isset($data_detail->bemail)) {
                    
                } else {

                    //print_r($data_detail); die;
                    //echo $radioValue; die;
                    //  print_r($data_detail_final);
                    //	echo "before all data</br>";
                    if (isset($key) && isset($data_detail->firstName) && isset($data_detail->lastName) && $data_detail_final['company_page_url'] != "NA"/* && $key!="NA" && $data_detail->firstName !="NA"  && $data_detail->lastName!="NA" && $data_detail_final['company_page_url']!="NA" */) {
                        //  echo $radioValue; die();
                        //echo "all data valid if";die();
                        $data_detail_final['company_page_url'];
                        $domainwww = parse_url($data_detail_final['company_page_url'], PHP_URL_HOST);
                        $domain = preg_replace("~^www\.~", "", $domainwww);

                        if ($radioValue == "bulkskrapp") {


                            $curl = curl_init();
                            ini_set('max_execution_time', 0);
                            curl_setopt_array($curl, array(
                                CURLOPT_URL => "https://api.skrapp.io/api/v2/find?fullName=" . urlencode($data_detail->firstName . " " . $data_detail->lastName) . "&domain=" . $domain,
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => "",
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 0,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_SSL_VERIFYPEER => FALSE,
                                // CURLOPT_CUSTOMREQUEST => "POST",
                                CURLOPT_HTTPHEADER => array(
                                    //"cache-control: no-cache",
                                    //"key:'".$_GET['key']."'",
                                    "Content-Type: application/json",
                                    "X-Access-Key: " . $_GET['key'] . ""
                                //"postman-token: 13dc25f5-f7e6-cfec-a6cc-5f1003bee8ee"
                                ),
                                    //CURLOPT_CUSTOMREQUEST => "GET",
                                    /* CURLOPT_HTTPHEADER => array(
                                      //"cache-control: no-cache",
                                      "apikey: df814ef8-2589-4d08-8670-562d3ca3a25b",
                                      //"postman-token: e28395cd-e214-2f75-8f0a-2ba08a9498ed"
                                      ), */
                            ));

                            $response = curl_exec($curl);
                            $err = curl_error($curl);

                            curl_close($curl);

                            if ($err) {
                                //$myfile = file_put_contents('../curlerrologs.txt', $err." ".$today.PHP_EOL , FILE_APPEND | LOCK_EX);

                                echo "cURL Error #:" . $err;
                            } else {
                                //echo $response;
                                $response = json_decode($response);
                                if (isset($response->email)) {
                                    // Yii::$app->runAction('controller/action');
                                    Yii::$app->runAction('my-template/savebemail', ['emailnew' => $response->email, 'id' => $data_detail_final['id']]);
                                    $responsearray[] = ['sucess' => true, 'emailnew' => $response->email];
                                    $count++;
                                } elseif (isset($response->message)) {
                                    $error = $response->message;
                                    $responsearray[] = ['sucess' => false, 'id' => $data_detail_final['id']];
                                } else {
                                    $errorresponse = json_encode($response);
                                    //$myfile = file_put_contents('../responseerrorlogs.txt', $errorresponse." ".$today.PHP_EOL , FILE_APPEND | LOCK_EX);
                                    $responsearray[] = ['sucess' => false, 'id' => $data_detail_final['id']];
                                }
                            }
                        } elseif ($radioValue == "Findthatlead") {
                            //echo "infindthat</br>";die();

                            $curl = curl_init();
                            ini_set('max_execution_time', 0);
                            curl_setopt_array($curl, array(
                                CURLOPT_URL => "https://api.findthatlead.com/api_guess_v2?name=" . urlencode($data_detail->firstName) . "&surname=" . urlencode($data_detail->lastName) . "&domain=" . urlencode($domain) . "&guuid=" . $_GET['key'],
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => "",
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 0,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_SSL_VERIFYPEER => FALSE,
                                //CURLOPT_CUSTOMREQUEST => "GET",
                                CURLOPT_HTTPHEADER => array(
                                    //"cache-control: no-cache",
                                    "datatype: json",
                                //"postman-token: e28395cd-e214-2f75-8f0a-2ba08a9498ed"
                                ),
                            ));

                            $response = curl_exec($curl);
                            $err = curl_error($curl);

                            curl_close($curl);

                            if ($err) {
                                echo "cURL Error #:" . $err;
                                //$myfile = file_put_contents('../curlerrologs.txt', $err." ".$today.PHP_EOL , FILE_APPEND | LOCK_EX);
                            } else {
                                //echo $response;
                                $response = json_decode($response);
                                //echo $response;
                                if ($response) {
                                    if (isset($response->email)) {
                                        // Yii::$app->runAction('controller/action');

                                        Yii::$app->runAction('my-template/savebemail', ['emailnew' => $response->email, 'id' => $data_detail_final['id']]);

                                        $responsearray[] = ['sucess' => true, 'emailnew' => $response->email];
                                        $count++;
                                    } else {

                                        if (isset($response->code) == 507) {
                                            $finalresult = "Error. Wrong API key?";
                                        } elseif (isset($response->code) == 508) {
                                            $finalresult = "You consume your plan credits.";
                                        } elseif (isset($response->code) == 510) {
                                            $finalresult = "You consume your credits.";
                                        } elseif (isset($response->code) == 404) {
                                            $finalresult = "Incorrect domain name.";
                                        } else {
                                            $finalresult = "We tried our best! But the email hasn't been found.";
                                        }
                                        $responsearray[] = ['sucess' => false, 'id' => $data_detail_final['id']];
                                    }
                                    // echo $finalresult;
                                }
                            }
                            # code...
                        } elseif ($radioValue == "Anymailfinder") {
                            // print_r($data_detail_final['company_page_url']);

                            /* if($data_detail_final['company_page_url']!="NA" && $data_detail->firstName!="" && $data_detail->lastName!=""){ */

                            $curl = curl_init();
                            ini_set('max_execution_time', 0);
                            curl_setopt_array($curl, array(
                                CURLOPT_URL => "https://api.anymailfinder.com/v3.0/search/person.json",
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => "",
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 0,
                                CURLOPT_SSL_VERIFYPEER => FALSE,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_CUSTOMREQUEST => "POST",
                                CURLOPT_POSTFIELDS => "------WebKitFormBoundary7MA4YWxkTrZu0gW\r\nContent-Disposition: form-data; name=\"domain\"\r\n\r\n" . $domain . "\r\n------WebKitFormBoundary7MA4YWxkTrZu0gW\r\nContent-Disposition: form-data; name=\"name\"\r\n\r\n" . $data_detail->firstName . " " . $data_detail->firstName . "\r\n------WebKitFormBoundary7MA4YWxkTrZu0gW--",
                                CURLOPT_HTTPHEADER => array(
                                    "cache-control: no-cache",
                                    "content-type: multipart/form-data; boundary=----WebKitFormBoundary7MA4YWxkTrZu0gW",
                                    "postman-token: ef87fb52-d5df-c6ad-81ea-a0b3106c38a6",
                                    "x-api-key: " . $_GET['key'] . ""
                                ),
                            ));

                            $response = curl_exec($curl);
                            $err = curl_error($curl);

                            curl_close($curl);

                            if ($err) {
                                echo "cURL Error #:" . $err;
                                //$myfile = file_put_contents('../curlerrologs.txt', $err." ".$today.PHP_EOL , FILE_APPEND | LOCK_EX);
                            } else {
                                $response = json_decode($response);
                                //echo $response->error;
                                if (isset($response->best_guess)) {

                                    // Yii::$app->runAction('controller/action');
                                    Yii::$app->runAction('my-template/savebemail', ['emailnew' => $response->best_guess, 'id' => $data_detail_final['id']]);
                                    $responsearray[] = ['sucess' => true, 'emailnew' => $response->best_guess];
                                    $count++;
                                } else {

                                    $responsearray[] = ['sucess' => false, 'id' => $data_detail_final['id']];
                                }
                            }
                        } elseif ($radioValue == "Emailhunter") {

                            $curl = curl_init();
                            ini_set('max_execution_time', 0);
                            curl_setopt_array($curl, array(
                                CURLOPT_URL => "https://api.hunter.io/v2/email-finder?domain=" . $domain . "&first_name=" . $data_detail->firstName . "&last_name=" . $data_detail->lastName . "&api_key=" . $_GET['key'],
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => "",
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 0,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_SSL_VERIFYPEER => FALSE,
                                //CURLOPT_CUSTOMREQUEST => "GET",
                                CURLOPT_HTTPHEADER => array(
                                    //"cache-control: no-cache",
                                    "datatype: json",
                                //"postman-token: e28395cd-e214-2f75-8f0a-2ba08a9498ed"
                                ),
                            ));

                            $response = curl_exec($curl);
                            $err = curl_error($curl);

                            curl_close($curl);

                            if ($err) {
                                echo "cURL Error #:" . $err;
                                //$myfile = file_put_contents('../curlerrologs.txt', $err." ".$today.PHP_EOL , FILE_APPEND | LOCK_EX);
                            } else {

                                $response = json_decode($response);

                                // echo $response->data->email;
                                if (isset($response->data->email)) {
                                    // Yii::$app->runAction('controller/action');
                                    Yii::$app->runAction('my-template/savebemail', ['emailnew' => $response->data->email, 'id' => $data_detail_final['id']]);
                                    $responsearray[] = ['sucess' => true, 'emailnew' => $response->data->email];
                                    $count++;
                                } else {
                                    $responsearray[] = ['sucess' => false, 'id' => $data_detail_final['id']];
                                }
                            }
                        }
                    } else {

                        //echo "else";
                    }
                }
            }


            echo $erron_in_response = json_encode(['count' => $count, 'data' => $responsearray]);
        }
        //include("../include/mailforbulkfind.php");
        //$myfile = file_put_contents('../responseerrorlogs.txt', $erron_in_response." ".$today.PHP_EOL , FILE_APPEND | LOCK_EX);
        // print_r($models);
        //  $SubuserDetail=Yii::$app->db->createCommand("SELECT * FROM blacklist LIMIT $limit OFFSET ".$offset)->queryAll();
        // print_r($SubuserDetail);exit;
    }

    public function actionSaveemail() {
        $result_email = $_GET['email'];
        $fname = $_GET['fname'];
        $lname = $_GET['lname'];


        $getid = Yii::$app->db->createCommand("select  profileInfo_id  from  blacklist  where id =" . $_GET['profileid'])->queryAll();
        //print($getid[0]['profileInfo_id']);exit;
        if (isset($getid)) {
            $profiledata = Yii::$app->db->createCommand("select  *  from  profileinfo  where id =" . $getid[0]['profileInfo_id'])->queryAll();


            if (isset($profiledata) && sizeof($profiledata)) {
                $dataToAugment = (array) json_decode($profiledata['0']['basicInfo']);
                $dataToAugment['bemail'] = $result_email;
                $dataToAugment['firstName'] = $fname;
                $dataToAugment['lastName'] = $lname;
                //$arr = array_map('utf8_encode', $dataToAugment);

                $data = json_encode((object) $dataToAugment, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE);
                $sql = Yii::$app->db->createCommand("UPDATE `profileinfo` SET `basicInfo`='" . $data . "' WHERE `id` ='" . $getid[0]['profileInfo_id'] . "'")->execute();

                //echo "<script>alert('Save');</script>";
            }
        }
    }

    public function actionIntegration() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        if (isset($_GET['result'])) {
            $result = $_GET['result'];
            if ($result == "insert") {
                Yii::$app->session->setFlash('success', "Saved Successfully");
            } elseif ($result == "update") {
                Yii::$app->session->setFlash('success', "Updated Successfully");
            }
        } else {

            //Yii::$app->session->setFlash('danger', "Intigration Fail");
        }
        $keyDetail = Yii::$app->db->createCommand("select  *  from  intigration  where user_id =" . Yii::$app->session->get('userid'))->queryAll();

        $userDetail = Yii::$app->db->createCommand("select * from user where id =" . Yii::$app->session->get('userid'))->queryOne();
        // return $this->render('intigration');
        return $this->render('integration', ['keyDetail' => $keyDetail, 'userDetail' => $userDetail]);
    }

    //NR
    public function actionProspectorSettings() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }


        $keyDetail = Yii::$app->db->createCommand("select  *  from  intigration  where user_id =" . Yii::$app->session->get('userid'))->queryAll();

        $userDetail = Yii::$app->db->createCommand("select * from user where id =" . Yii::$app->session->get('userid'))->queryOne();

        /*
          if (count($keyDetail) > 0) {
          $key_Detail = json_decode($keyDetail[0]['access_key']);
          if ($key_Detail->hubspot_key == '' || $key_Detail->hubportal_id == '') {
          Yii::$app->session->setFlash('error', "Error getting Hubspot properties.Please check Hubspot API key.");
          $url = \Yii::$app->request->baseUrl . "/integration";
          return $this->redirect($url);
          }
          }

          if (count($keyDetail) == 0) {
          Yii::$app->session->setFlash('error', "Error getting Hubspot properties.Please check Hubspot API key.");
          $url = \Yii::$app->request->baseUrl . "/integration";
          return $this->redirect($url);
          }

          $extULSData = Yii::$app->db->createCommand("select  *  from  ext_userlocalstoragedata  where user_id =" . Yii::$app->session->get('userid'))->queryOne();
          if (!$extULSData) {
          $url = \Yii::$app->request->baseUrl . "/integration";
          return $this->redirect($url);
          }
         */

        return $this->render('prospector_settings', ['keyDetail' => $keyDetail, 'userDetail' => $userDetail]);
    }

    public function actionIntegrationsave() {
        /* if(!Yii::$app->session->get('useremail')){
          $url = \Yii::$app->request->baseUrl."/login";
          return $this->redirect($url);
          }
         */

        /*
          header("Access-Control-Allow-Origin:*");
          header("Access-Control-Allow-Credentials:true");
          header("Access-Control-Allow-Methods: OPTIONS, GET, POST");
          header("Access-Control-Allow-Headers: Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
         */
        $session_id = $_POST['sessionId'];
        if ($session_id != '') {
            $session_id1 = base64_decode($session_id);
            $session_id1 = explode("/", $session_id1);
        }
        $data = $_POST['data'];
        //echo '<pre>'; print_r($data); die;
        if (isset($data)) {

            //$keyDetail = Yii::$app->db->createCommand("SELECT  *  from  intigration  where user_id =" . $session_id1[0])->queryAll();
            $keyDetail = Yii::$app->db->createCommand("SELECT  *  from  intigration  where user_id =" . $session_id1[0])->queryOne();
            //echo print_r(sizeof($keyDetail));die;
            //echo '<pre>';print_r($session_id1[0]);die;
            if (sizeof($keyDetail) > 1) {
                $row = (array) json_decode($keyDetail['access_key']);

                $row['hubportal_id'] = $data['hubportal_id'];
                $row['hubspot_key'] = $data['hubspot_key'];
                $row['hubspot_auto'] = $data['hubspot_auto'];
                $row['actUserID'] = $data['actUserID'];

                $row = json_encode($row);
                $sql = Yii::$app->db->createCommand("UPDATE intigration SET access_key='" . $row . "' where user_id='" . $session_id1[0] . "'")->execute();
            } else {
                $row = array();
                //$row['email_hunter_api_key'] = $data['emailHunterAPIKey'];
                //$row['any_mail_finder_api_key'] = $data['anyMailFinderAPIKey'];
                //$row['find_that_lead_api_key'] = $data['findThatLeadAPIKey'];
                $row['hubportal_id'] = $data['hubportal_id'];
                $row['hubspot_key'] = $data['hubspot_key'];
                //$row['toofr_api_key'] = $data['toofr_api_key'];
                //$row['briteverify_api_key'] = $data['briteverify_api_key'];
                //$row['skrapp_api_key'] = $data['skrapp_api_key'];
                //$row['Webhooks'] = $data['Webhooks'];//commented on 02June2020
                $row['hubspot_auto'] = $data['hubspot_auto']; //NR
                $row['actUserID'] = $data['actUserID']; //NR

                $row = json_encode($row);
                echo $row;
                $sql = Yii::$app->db->createCommand("INSERT INTO `intigration`(`user_id`,`access_key`) VALUES ('" . $session_id1[0] . "','" . $row . "')")->execute();
            }
        }


        // return $this->render('intigration');
        //  return $this->render('integration', [ 'keyDetail' => $keyDetail]);
    }

    /**
     * Finds the MyTemplateModel model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return MyTemplateModel the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = MyTemplateModel::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionGetreport() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        try {
            $time = new \DateTime('now');
            $today = $time->format('Y-m-d');
            $month = $time->format('Y-m-01');
            $result = [];

            $userid = $_POST['id'];


            $result['allReq'] = count(Blacklist::find()->select('id')->where(['=', 'teamid', Yii::$app->session->get('teamid')])->andWhere(['!=', 'seq_id', 0])->all());

            //$result['allReq'] = count(Blacklist::find()->select('id')->where(['and',['=', 'teamid', Yii::$app->session->get('teamid')],['!=','seq_id',0]])->all());
            $result['allMonth'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $month], ['=', 'teamid', Yii::$app->session->get('teamid')]])->andWhere(['!=', 'seq_id', 0])->all());
            $result['allToday'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $today], ['=', 'teamid', Yii::$app->session->get('teamid')]])->andWhere(['!=', 'seq_id', 0])->all());



            $result['allMyToday'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $today], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
            $result['allMyMonth'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $month], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
            $result['allMy'] = count(Blacklist::find()->select('id')->where(['and', ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->andWhere(['!=', 'seq_id', 0])->all());



            $result['allMyAcceptedToday'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $today], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_accepted', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
            $result['allMyAcceptedMonth'] = count(Blacklist::find()->select('id')->where(['and', ['>=', 'created_at', $month], ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_accepted', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
            $result['allMyAccepted'] = count(Blacklist::find()->select('id')->where(['and', ['=', 'teamid', Yii::$app->session->get('teamid')], ['=', 'is_accepted', 1], ['=', 'userid', $userid]])->andWhere(['!=', 'seq_id', 0])->all());
        } catch (Exception $e) {
            echo 'Caught exception: ', $e->getMessage(), "\n";
            exit;
        }

        echo json_encode($result);
        exit;
    }

    public function actionSequencelist() {
        //  echo "SELECT * , COUNT(blacklist.seq_id) as num FROM `sequences` RIGHT JOIN blacklist ON sequences.id = blacklist.seq_id where sequences.user_id =  ".Yii::$app->session->get('userid')." GROUP BY blacklist.seq_id ";  
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $hide_deleted = 1;
        if (isset($_GET['d']) && $_GET['d'] == 'false')
            $hide_deleted = 0;

        if (isset($_GET['id'])) {
            $id = $this->decode($_GET['id']);
            $sequences = Yii::$app->db->createCommand("SELECT sequences.*, count(blacklist.id) AS num , count(CASE WHEN blacklist.is_accepted THEN 1 END) as accepted, count(CASE WHEN blacklist.is_response THEN 1 END) as responded  FROM sequences LEFT JOIN blacklist  ON blacklist.seq_id = sequences.id where sequences.id =  " . $id . " GROUP BY sequences.id ORDER BY sequences.id DESC")->queryOne();

            $sequences['local_seq_step'] = preg_replace_callback('#([^{:]*):([^,}]*)#i', function( $match ) {
                $key = trim($match[1]);
                $val = trim($match[2]);
                if ($val[0] == '"') {
                    $val = '"' . addslashes(substr($val, 1, -1)) . '"';
                    $position = stripos($val, '"', 1);
                    $position_2 = stripos($val, 'fallback', 1);
                    if ($position > 0 && $key == ',"message"' && $position_2 > 0) {
                        $val = str_replace('"', '\"', stripslashes($val));
                        $val = ltrim($val, "\\");
                    }
                } else if ($val[0] == "'") {
                    $val = "'" . addslashes(substr($val, 1, -1)) . "'";
                }
                return $key . ": " . $val;
            }, $sequences['local_seq_step']);


            $string = $sequences['local_seq_json'];
            $string = trim($string, '[');
            $string = trim($string, ']');
            if (preg_match("/\[([^\]]+)\]/m", $string)) {
                preg_match('/\[([^\]]+)\]/m', $string, $matches);
                $string_1 = preg_replace('/"/m', "'", $matches[0]);
                $msgText = preg_replace('/\[([^\]]+)\]/m', $string_1, $string);
            }
            $sequences['local_seq_json'] = "[" . $msgText . "]";



            $seq_url = $sequences['seq_url'];
            $seq_url = trim($seq_url, '[["');
            $seq_url = trim($seq_url, '"]]');
            $url = explode("|lclcu|", $seq_url);
            $seqUrl = array();
            for ($i = 0; $i < count($url) - 1; $i++) {
                array_push($seqUrl, trim($url[$i]));
            }

            $sequences['seq_url'] = json_encode($seqUrl);

            $sequences = json_encode($sequences);
            echo $sequences;
        } else {
            //$sequences =Yii::$app->db->createCommand("SELECT sequences.created_at,sequences.updated_at,sequences.*, count(blacklist.id) AS num , count(CASE WHEN blacklist.is_accepted THEN 1 END) as accepted  FROM sequences LEFT JOIN blacklist  ON blacklist.seq_id = sequences.id where sequences.user_id =  ".Yii::$app->session->get('userid')." GROUP BY sequences.id ORDER BY sequences.id DESC")->queryAll();
            // query with Error , count is wromg
            // $sequences =Yii::$app->db->createCommand("SELECT sequences.created_at,sequences.updated_at,sequences.*,csvfiles.*, count(blacklist.id) AS num , count(CASE WHEN blacklist.is_accepted THEN 1 END) as accepted  FROM sequences LEFT JOIN blacklist  ON blacklist.seq_id = sequences.id LEFT JOIN csvfiles ON csvfiles.db_seq_id = sequences.id where sequences.user_id =  ".Yii::$app->session->get('userid')." GROUP BY sequences.id ORDER BY sequences.id DESC ")->queryAll();
            if ($hide_deleted) {
                $sequences = Yii::$app->db->createCommand("SELECT sequences.id as seq_id , sequences.created_at,sequences.updated_at,sequences.*,csvfiles.*, count( distinct blacklist.id) AS num , count(distinct (CASE WHEN blacklist.is_accepted THEN blacklist.id END) ) as accepted, count(distinct (CASE WHEN blacklist.is_response THEN blacklist.id END)) as responded  FROM sequences LEFT JOIN blacklist  ON blacklist.seq_id = sequences.id LEFT JOIN csvfiles ON csvfiles.db_seq_id = sequences.id where sequences.user_id =  " . Yii::$app->session->get('userid') . " AND `local_seq_json` NOT LIKE '%\"status\":\"Deleted\"%' GROUP BY sequences.id ORDER BY sequences.id DESC ")->queryAll();
            } else {
                $sequences = Yii::$app->db->createCommand("SELECT sequences.id as seq_id , sequences.created_at,sequences.updated_at,sequences.*,csvfiles.*, count( distinct blacklist.id) AS num , count(distinct (CASE WHEN blacklist.is_accepted THEN blacklist.id END) ) as accepted, count(distinct (CASE WHEN blacklist.is_response THEN blacklist.id END)) as responded  FROM sequences LEFT JOIN blacklist  ON blacklist.seq_id = sequences.id LEFT JOIN csvfiles ON csvfiles.db_seq_id = sequences.id where sequences.user_id =  " . Yii::$app->session->get('userid') . " GROUP BY sequences.id ORDER BY sequences.id DESC ")->queryAll();
            }

            return $this->render('sequence', [
                        'sequences' => $sequences,
            ]);
        }

//echo "123"; die();
    }

//    Ravi bhuva-- Code for add more csv  -- START
    public function actionCsv_file_info() {
        $query_profile = new Query;
        $model_profile = $query_profile->select(['*'])
                ->from('csvfiles')
                ->where(['id' => $_POST['id']])
                ->one();
        return json_encode($model_profile);
    }

    public function actionCsvfileadd() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $userid = Yii::$app->session->get('userid');

        $fileName = preg_replace('/[^A-Za-z0-9\-. ]/', '', $_FILES['CSV_FileAdd']['name']);
        $file_Csv = file_get_contents($_FILES['CSV_FileAdd']['tmp_name']);
        $Csv_Data = explode(PHP_EOL, $file_Csv);

        $sql = Yii::$app->db->createCommand("INSERT INTO `csvfiles`(`user_id`,`file_name`) VALUES ('" . $userid . "','" . $fileName . "')")->execute();
        $insert_id = Yii::$app->db->getLastInsertID();

        $file = fopen($_FILES['CSV_FileAdd']['tmp_name'], 'r');
        $i = 0;
        $c = 0;
        while (($column = fgetcsv($file, 10000, ',') ) !== FALSE) {
            if (count($column == 1)) {
                if (trim($column[$i]) == '') {
                    continue;
                }
                if (strpos($column[$i], '.linkedin.com') == false) {
                    continue;
                }
                $segments = explode('/', $column[$i]);
                $numSegments = count($segments);
                $pubid = '';
                if ($segments[3] == "in") {
                    $pubid = $segments[4];

                    if ($numSegments > 5) {
                        $column[$i] = implode('/', array_slice($segments, 0, 5));
                    }
                } else if ($segments[3] == "pub") {
                    $pubid = $segments[4] . "-"; //.$segments[7].$segments[6].$segments[5];
                    if (strlen($segments[7]) >= 3) {
                        $pubid = $pubid . $segments[7];
                    } else if (strlen($segments[7]) == 2) {
                        $pubid = $pubid . "0" . $segments[7];
                    } else if (strlen($segments[7]) == 1) {
                        $pubid = $pubid . "00" . $segments[7];
                    }

                    if (strlen($segments[6]) >= 3) {
                        $pubid = $pubid . $segments[6];
                    } else if (strlen($segments[6]) == 2) {
                        $pubid = $pubid . "0" . $segments[6];
                    } else if (strlen($segments[6]) == 1) {
                        $pubid = $pubid . "00" . $segments[6];
                    }

                    if (strlen($segments[5]) >= 2) {
                        $pubid = $pubid . $segments[5];
                    } else if (strlen($segments[5]) == 1) {
                        $pubid = $pubid . "0" . $segments[7];
                    }
                }
                if (strpos($column[$i], '.linkedin.com') == false) {
                    continue;
                }
                $FinalData = trim($column[$i]);
                $sql = Yii::$app->db->createCommand("INSERT INTO `csvprofiles`(`csvfile_id`,`csvprofile`) VALUES ('" . $insert_id . "','" . $FinalData . "')")->execute();
                $c++;
            }
//            $i++;
        }
        if ($c > 0) {
            return "CSV uploaded successfully";
        } else {
            return "Please select valid csv file";
        }
    }

    public function actionCsv_file_data_insert() {

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $file_Csv = file_get_contents($_FILES['CSV_File']['tmp_name']);
        $Csv_Data = explode(PHP_EOL, $file_Csv);

        $file = fopen($_FILES['CSV_File']['tmp_name'], 'r');
        $i = 0;
        $c = 0;
        $key = 1; //30-11-2020
        $values = []; //30-11-2020
        $customHeadings = ""; //30-11-2020
        $finalCustomField = ""; //30-11-2020
        $userid = Yii::$app->session->get('userid'); //08-12-2020
        while (($column = fgetcsv($file, 10000, ',') ) !== FALSE) {
            if (count($column == 1)) {

                //30-11-2020 starts
                if ($key == 1 && strpos($column[$i], 'linkedin.') === false) {
                    $firstHeading = $column;
                    unset($firstHeading[0]);
                    $customHeadings = json_encode(array_values($firstHeading), JSON_UNESCAPED_UNICODE);
                }
                if (strpos($column[$i], 'linkedin.') !== false) {
                    $customeFieldDetails = $column;
                    unset($customeFieldDetails[0]);

                    $customeFieldDetails = array_values($customeFieldDetails);
                    $firstHeading = array_values($firstHeading);

                    $customeFieldArr = array();

                    for ($x = 0; $x <= count($firstHeading); $x++) {
                        if (isset($customeFieldDetails[$x])) {
                            $customeFieldArr[$firstHeading[$x]] = $customeFieldDetails[$x];
                        }
                    }

                    $finalCustomField = json_encode($customeFieldArr, JSON_UNESCAPED_UNICODE);
//                                echo $finalCustomField;exit;
                }
                //30-11-2020 ends

                if (trim($column[$i]) == '') {
                    continue;
                }
                //if (strpos($column[$i], '.linkedin.com') == false)
                if (strpos($column[$i], 'linkedin.') === false) {
                    continue;
                }

                $segments = explode('/', $column[$i]);
                $numSegments = count($segments);
                $pubid = '';

                // Check if sale url or not
                $haystack = $column[$i];
                $needle = "sales/people";
                if (strpos($haystack, $needle) !== false) {
                    $is_sales_url = 1;
                } else {
                    $is_sales_url = 0;
                }
                //30-11-2020: new code starts

                if ($is_sales_url == 1) {
                    
                } else if ($is_sales_url == 0 && isset($segments[3]) && $segments[3] == "in" && isset($segments[4]) && $segments[4] != '') {
                    //DONE
                    //eg: http://www.linkedin.com/in/josephd1
                    //echo '<br/>A:checkData0='.$checkData[0];
                    //echo '<br/>A:numSegments='.$numSegments;

                    $pubid = $segments[4];
                    $column[$i] = 'https://www.linkedin.com/in/' . $pubid;
                    //echo '<br/>::A2::'.$checkData[0];
                } else if ($is_sales_url == 0 && isset($segments[1]) && $segments[1] == "in" && isset($segments[2]) && $segments[2] != '') {
                    //DONE
                    //eg: linkedin.com/in/arthur-borowski-2b115b7
                    //eg: www.linkedin.com/in/arthur-borowski-2b115b7
                    //echo '<br/>B:checkData0='.$checkData[0];
                    //echo '<br/>B:numSegments='.$numSegments;

                    $pubid = $segments[2];
                    $column[$i] = 'https://www.linkedin.com/in/' . $pubid;
                } else if ($is_sales_url == 0 && isset($segments[3]) && $segments[3] == "pub" && isset($segments[4]) && $segments[4] != '' && isset($segments[5]) && $segments[5] != '' && isset($segments[6]) && $segments[6] != '' && isset($segments[7]) && $segments[7] != '') {
                    //eg: https://www.linkedin.com/pub/april-bright/10/962/81
                    //echo '<br/>C:checkData0='.$checkData[0];
                    //echo '<br/>C:numSegments='.$numSegments;

                    $pubid = $segments[4];

                    $seg7Length = strlen($segments[7]);
                    if ($seg7Length == 1) {
                        $seg7Str = '00' . $segments[7];
                    } else if ($seg7Length == 2) {
                        $seg7Str = '0' . $segments[7];
                    } else {
                        $seg7Str = $segments[7];
                    }

                    $seg6Length = strlen($segments[6]);
                    if ($seg6Length == 1) {
                        $seg6Str = '00' . $segments[6];
                    } else if ($seg6Length == 2) {
                        $seg6Str = '0' . $segments[6];
                    } else {
                        $seg6Str = $segments[6];
                    }

                    if ($segments[5] == '0') {
                        $seg5Str = '';
                    } else {
                        $seg5Str = $segments[5];
                    }


                    $column[$i] = 'https://www.linkedin.com/in/' . $pubid . '-' . $seg7Str . $seg6Str . $seg5Str;

                    //https://www.linkedin.com/in/april-bright-08196210/

                    /* Array
                      (
                      [0] => https:
                      [1] =>
                      [2] => www.linkedin.com
                      [3] => pub
                      [4] => april-bright
                      [5] => 10
                      [6] => 962
                      [7] => 81
                      ) */
                }

                //30-11-2020: new code ends

                /* Old orig code before 30-11-2020
                  if ($segments[3] == "in") {
                  $pubid = $segments[4];

                  if ($numSegments > 5) {
                  $column[$i] = implode('/', array_slice($segments, 0, 5));
                  }
                  } else if ($segments[3] == "pub") {
                  $pubid = $segments[4] . "-"; //.$segments[7].$segments[6].$segments[5];
                  if (strlen($segments[7]) >= 3) {
                  $pubid = $pubid . $segments[7];
                  } else if (strlen($segments[7]) == 2) {
                  $pubid = $pubid . "0" . $segments[7];
                  } else if (strlen($segments[7]) == 1) {
                  $pubid = $pubid . "00" . $segments[7];
                  }

                  if (strlen($segments[6]) >= 3) {
                  $pubid = $pubid . $segments[6];
                  } else if (strlen($segments[6]) == 2) {
                  $pubid = $pubid . "0" . $segments[6];
                  } else if (strlen($segments[6]) == 1) {
                  $pubid = $pubid . "00" . $segments[6];
                  }

                  if (strlen($segments[5]) >= 2) {
                  $pubid = $pubid . $segments[5];
                  } else if (strlen($segments[5]) == 1) {
                  $pubid = $pubid . "0" . $segments[7];
                  }
                  }
                  if (strpos($column[$i], '.linkedin.com') == false) {
                  continue;
                  }


                  $FinalData = trim(str_replace("'", "\'", $column[$i]));
                  $sql = Yii::$app->db->createCommand("INSERT INTO `csvprofiles`(`csvfile_id`,`csvprofile`) VALUES ('" . $_POST['csvFileId'] . "','" . $FinalData . "')")->execute();
                 */

                //30-11-2020: new code starts
                //$values[] = "('csvfile_id', '".str_replace("'","\'",$column[$i])."')";
                $values[] = "('csvfile_id', '" . str_replace("'", "\'", $column[$i]) . "','" . addslashes($finalCustomField) . "')";
                //30-11-2020: new code ends


                $c++;
                $key++; //30-11-2020
            }
//            $i++;
        }

        //30-11-2020: new code starts

        $csvName = $_FILES['CSV_File']['name'];
        $csvName = addslashes($csvName);
        $csvName = htmlspecialchars($csvName);
        $proInfo_id = $_POST['csvFileId'];
        $sql = Yii::$app->db->createCommand("UPDATE csvfiles SET `customHeadings`= '" . $customHeadings . "' WHERE id = " . $proInfo_id)->execute();

        if ($proInfo_id && !empty($values)) {

            if (YII_ENV_PROD) {
                $connection = new \yii\db\Connection([
                    'charset' => 'utf8mb4',
                    'dsn' => 'mysql:host=restorelinkedfusion610.cuuwos9fpos4.us-east-2.rds.amazonaws.com;dbname=linkedfusion',
                    'username' => 'linkedfusion',
                    'password' => 'Admin2020',
                ]);
            } else {
                $connection = new \yii\db\Connection([
                    'charset' => 'utf8mb4',
                    'dsn' => 'mysql:host=database-1.cnzhmccff53s.us-east-2.rds.amazonaws.com;dbname=cloud_leadconnect_new',
                    'username' => 'admin',
                    'password' => 'Admin2020',
                ]);
            }
            $connection->open();

            $sql1 = $connection->createCommand("INSERT INTO `csvprofiles` (`csvfile_id`, `csvprofile`,`customFieldDetails`) VALUES " . str_replace('csvfile_id', $proInfo_id, implode(',', $values)))->execute();

            Yii::$app->db->createCommand("UPDATE csvfiles SET `local_db_id`= 0 WHERE id = " . $proInfo_id)->execute();
            if (isset($_POST['seq_id'])) {
                Yii::$app->db->createCommand("DELETE FROM `ext_nomoreprospect` WHERE userId = " . $userid . " and seqId=" . $_POST['seq_id'])->execute();
            }
        }
        //30-11-2020: new code ends

        if ($c > 0) {
            return "CSV uploaded successfully";
        } else {
            return "Please select valid csv file";
        }
    }

    //    Ravi bhuva-- Code for add more csv  -- END

    public function actionCsv_file() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        /* $query = new Query;
          $query->select('*')->from('csvprofiles')->where(['csvfile_id' => $_POST['id']]);

          //$SubuserDetail=Yii::$app->db->createCommand("select  *  from  csvprofiles  where csvfile_id =".$_POST['id'])->queryAll();
          $i = 0;
          $html = $pagination = '';
          $countQuery = clone $query;
          $pages = new Pagination(['totalCount' => $countQuery->count()]);
          $SubuserDetail = $query->offset($pages->offset)->limit($pages->limit)->all();

          if(count($SubuserDetail) > 0){
          foreach ($SubuserDetail as  $value) {
          /*$csv_arr[$i]['sr_no'] = $i+1;
          $csv_arr[$i]['name'] = $value['csvprofile'];
          $i++;
          $html .= "<tr><td>".$i."</td><td>".$value['csvprofile']."</td></tr>";
          }
          }else{
          $html = '<tr><td colspan="2" class="text-center">No records found</td></tr>';
          }

          if($pages->totalCount > 20){
          $pagination .= LinkPager::widget(['pagination' => $pages]);
          }
          echo json_encode(array('html'=>$html,'pagination'=>$pagination));
          exit; */

        $requestData = $_REQUEST;

        $columns = array(
            '0' => 'id',
            '1' => 'csvprofile'
        );

        $sql = "SELECT  * from csvprofiles where csvfile_id=" . $requestData['id'];

        $data = Yii::$app->db->createCommand($sql)->queryAll();

        $totalData = count($data);
        $totalFiltered = $totalData;

        if (!empty($requestData['search']['value'])) {
            $sql .= " AND csvprofile LIKE '%" . $requestData['search']['value'] . "%'";
        }
        //echo $sql;die;
        $data = Yii::$app->db->createCommand($sql)->queryAll();
        $totalFiltered = count($data);

        $sql .= " ORDER BY " . $columns[$requestData['order'][0]['column']] . "   " . $requestData['order'][0]['dir'] . "  LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "";

        $result = Yii::$app->db->createCommand($sql)->queryAll();

        $data = array();
        $i = $requestData['start'];
        foreach ($result as $key => $row) {
            if ($row["isDeleted"] == 1) {
                $status = 'Queued';
            } else {
                $status = 'Pending';
            }
            $csvData = array();
            $csvData[] = $i + 1;
            $csvData[] = $row["csvprofile"];
            $csvData[] = $status;
            $data[] = $csvData;
            $i++;
        }

        $json_data = array(
            "draw" => intval($requestData['draw']),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        echo json_encode($json_data);
    }

    public function actionCsv_filee() {

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        /* $query = new Query;
          $query->select('*')->from('csvprofiles')->where(['csvfile_id' => $_POST['id']]);
          //$SubuserDetail=Yii::$app->db->createCommand("select  *  from  csvprofiles  where csvfile_id =".$_POST['id'])->queryAll();
          $i = 0;
          $html = $pagination = '';
          $countQuery = clone $query;
          $pages = new Pagination(['totalCount' => $countQuery->count()]);
          $SubuserDetail = $query->offset($pages->offset)->limit($pages->limit)->all();
          if(count($SubuserDetail) > 0){
          foreach ($SubuserDetail as  $value) {
          /*$csv_arr[$i]['sr_no'] = $i+1;
          $csv_arr[$i]['name'] = $value['csvprofile'];
          $i++;
          $html .= "<tr><td>".$i."</td><td>".$value['csvprofile']."</td></tr>";
          }
          }else{
          $html = '<tr><td colspan="2" class="text-center">No records found</td></tr>';
          }
          if($pages->totalCount > 20){
          $pagination .= LinkPager::widget(['pagination' => $pages]);
          }
          echo json_encode(array('html'=>$html,'pagination'=>$pagination));
          exit; */
        $requestData = $_REQUEST;
        $columns = array(
            '0' => 'id',
            '1' => 'profile_link'
        );
        $sql = "SELECT  * from webhook_profiles  where seq_id=" . $requestData['id'];
        $data = Yii::$app->db->createCommand($sql)->queryAll();
        $totalData = count($data);
        $totalFiltered = $totalData;
        if (!empty($requestData['search']['value'])) {
            $sql .= " AND profile_link LIKE '%" . $requestData['search']['value'] . "%'";
        }
        $data = Yii::$app->db->createCommand($sql)->queryAll();
        $totalFiltered = count($data);
        $sql .= " ORDER BY " . $columns[$requestData['order'][0]['column']] . "   " . $requestData['order'][0]['dir'] . "  LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "";
        $result = Yii::$app->db->createCommand($sql)->queryAll();
        $data = array();
        $i = $requestData['start'];
        foreach ($result as $key => $row) {
            $csvData = array();
            $sr = $i + 1;
            if (isset($requestData['type']) && $requestData['type'] == 'webhook') {
                if ($row["status"] == '0') {
                    $csvData[] = '<input type="checkbox" value="' . $row["id"] . '" class="selbklid" style="clear: both;position: absolute;"><span style="margin-left: 20px;">' . $sr . '</span>';
                } else {
                    $csvData[] = '<input type="checkbox" value="" style="clear: both;position: absolute;" title="Can not select" class="selbklid" disabled><span style="margin-left: 20px;">' . $sr . '</span>';
                }
            } else {
                $csvData[] = $sr;
            }
            $csvData[] = $row["profile_link"];
            if ($row["status"] == '0') {
                $csvData[] = 'Pending';
//                $csvData[] = '<a href="javascript:;" title="Delete" onclick="deleteWebhook(' . $row["id"] . ')"><span>Delete</span></a>';
            } else {
                $csvData[] = 'Sent';
//                $csvData[] = '<a href="javascript:;" class="buttonDisabled" title="Can not delete" data-id="' . $row["id"] . '"><span>Delete</span></a>';
            }
            $data[] = $csvData;
            $i++;
        }
        $json_data = array(
            "draw" => intval($requestData['draw']),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }

    public function actionDeletewebhook() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $id = Yii::$app->request->post('id');
        if (!empty($id)) {
            $idsArr = array_filter(explode(',', $id));
            $ids = implode(',', $idsArr);
            Yii::$app->db->createCommand("DELETE from `webhook_profiles` where id IN ($ids)")->execute();
        }
    }

    public function actionCsv_viewer() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }

        $SubuserDetail = Yii::$app->db->createCommand("select c.*,s.name,COUNT(cp.id) as total_rem from csvfiles c LEFT JOIN ext_sequences s ON s.id = c.db_seq_id LEFT JOIN csvprofiles cp ON cp.csvfile_id = c.id where c.user_id =" . Yii::$app->session->get('userid') . " group by c.id")->queryAll();

        //$dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('csv_viewer', [
                    'SubuserDetail' => $SubuserDetail,
        ]);
    }

    public function actionUpdatecurrenttimezone() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        //echo '<pre>'; print_r($_POST); exit;
        if (isset($_POST['currentTimezoneval'])) {

            $sql = Yii::$app->db->createCommand("UPDATE user SET TimeZone='" . $_POST['currentTimezoneval'] . "' where id='" . Yii::$app->session->get('userid') . "'")->execute();
        }
    }

    public function actionUpdateallworkinghours() { // update All working hours
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        //echo '<prE>'; print_r($_POST); exit; 
        if (isset($_POST['newtimezone']) && $_POST['newtimezone'] != '') {
            $user_timezone = $_POST['newtimezone'];
        }

        $sqldata = "SELECT  id,server_start_time,server_end_time,start_time_iso,end_time_iso from ext_working_hours  where user_id=" . Yii::$app->session->get('userid');
        $dataarry = Yii::$app->db->createCommand($sqldata)->queryAll();

        foreach ($dataarry as $key => $row) {

            $whstarttime = $row['start_time_iso'];
            $whendtime = $row['end_time_iso'];

            if (isset($whstarttime)) {

                $ist_date = \DateTime::createFromFormat('H:i:s', $whstarttime, new \DateTimeZone($user_timezone));
                //print_r($ist_date);die;
                $gmt_date = clone $ist_date; // we don't want PHP's default pass object by reference here
                $gmt_date->setTimeZone(new \DateTimeZone('UTC'));

                //echo 'IST:  ' . $ist_date->format('H:i:s').'<br><br>';  // IST:  2011-04-27 2:45 AM

                $server_start_time = $gmt_date->format('H:i:s'); // GMT: 2011-04-27 12:15 PM
            }


            if (isset($whendtime)) {

                $ist_date1 = \DateTime::createFromFormat('H:i:s', $whendtime, new \DateTimeZone($user_timezone));

                $gmt_date1 = clone $ist_date1; // we don't want PHP's default pass object by reference here
                $gmt_date1->setTimeZone(new \DateTimeZone('UTC'));

                //echo 'IST:  ' . $ist_date->format('H:i:s').'<br><br>';  // IST:  2011-04-27 2:45 AM

                $server_end_time = $gmt_date1->format('H:i:s'); // GMT: 2011-04-27 12:15 PM
            }

            //echo 'Start Time: '.$server_start_time.' - End Time: '.$server_end_time; exit;  

            $sql = Yii::$app->db->createCommand("UPDATE ext_working_hours SET server_start_time = '" . $server_start_time . "', server_end_time = '" . $server_end_time . "' WHERE id =" . $row['id'] . " AND user_id=" . Yii::$app->session->get('userid'))->execute();
        }
    }

    public function actionUpdatefirstcurrenttimezone() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        if (isset($_POST['firstcurrentTimezoneval'])) {
            // Get timezone
            $timezone_offset_minutes = $_POST['firstcurrentTimezoneval'];
            $timezone_name = timezone_name_from_abbr("", $timezone_offset_minutes * 60, false);
            echo $timezone_name;
            $sql = Yii::$app->db->createCommand("UPDATE user SET TimeZone='" . $timezone_name . "' where id='" . Yii::$app->session->get('userid') . "'")->execute();
            // End get timezone
            //Addworkinghours starts
            $whtitle = 'Default Working Hour';
            $whstarttime = '09:00:00'; //$_POST['whstarttime'] . ':00';
            $whendtime = '17:00:00'; //$_POST['whendtime'] . ':00';
            $whstarttime_usr = '09.00 AM';
            $whendtime_usr = '05.00 PM';
            $chkDayStr = '1,2,3,4,5';
            $user_timezone = $timezone_name;
            if (isset($whstarttime)) {

                $ist_date = \DateTime::createFromFormat('H:i:s', $whstarttime, new \DateTimeZone($user_timezone));
                //print_r($ist_date);die;
                $gmt_date = clone $ist_date; // we don't want PHP's default pass object by reference here
                $gmt_date->setTimeZone(new \DateTimeZone('UTC'));

                //echo 'IST:  ' . $ist_date->format('H:i:s').'<br><br>';  // IST:  2011-04-27 2:45 AM

                $server_start_time = $gmt_date->format('H:i:s'); // GMT: 2011-04-27 12:15 PM
            }
            if (isset($whendtime)) {

                $ist_date1 = \DateTime::createFromFormat('H:i:s', $whendtime, new \DateTimeZone($user_timezone));

                $gmt_date1 = clone $ist_date1; // we don't want PHP's default pass object by reference here
                $gmt_date1->setTimeZone(new \DateTimeZone('UTC'));

                //echo 'IST:  ' . $ist_date->format('H:i:s').'<br><br>';  // IST:  2011-04-27 2:45 AM

                $server_end_time = $gmt_date1->format('H:i:s'); // GMT: 2011-04-27 12:15 PM
            }

            //echo 'Start Time: '.$server_start_time.' - End Time: '.$server_end_time; exit; 

            $sql = Yii::$app->db->createCommand("INSERT INTO ext_working_hours(name,start_time,end_time,start_time_iso,end_time_iso,server_start_time,server_end_time,user_id,days) 
			VALUES ('" . $whtitle . "',
			'" . $whstarttime_usr . "',
			'" . $whendtime_usr . "',
			'" . $whstarttime . "',
			'" . $whendtime . "',
			'" . $server_start_time . "',
			'" . $server_end_time . "',
			'" . Yii::$app->session->get('userid') . "',
			'" . $chkDayStr . "' ) ")->execute();
            //Addworkinghours ends
        }
    }

    public function actionAddworkinghours() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $whtitle = $_POST['whtitle'];
        $whtitle = addslashes($whtitle);
        $whtitle = htmlspecialchars($whtitle);
        $whstarttime = $_POST['whstarttime'] . ':00';
        $whendtime = $_POST['whendtime'] . ':00';
        //echo "<pre>"; print_r($_POST); exit;
        // Get user timezone
        $user_timezone = '';
        $getTimezone = Yii::$app->db->createCommand("SELECT TimeZone FROM user where id =  " . Yii::$app->session->get('userid'))->queryOne();
        $user_timezone = $getTimezone['TimeZone'];
        // End
        //$server_start_time = '00:00:00';
        //$server_end_time = '00:00:00';
        //echo $whstarttime.'===='.$whendtime.'</br>'; exit;
        if (isset($whstarttime)) {

            $ist_date = \DateTime::createFromFormat('H:i:s', $whstarttime, new \DateTimeZone($user_timezone));
            //print_r($ist_date);die;
            $gmt_date = clone $ist_date; // we don't want PHP's default pass object by reference here
            $gmt_date->setTimeZone(new \DateTimeZone('UTC'));

            //echo 'IST:  ' . $ist_date->format('H:i:s').'<br><br>';  // IST:  2011-04-27 2:45 AM

            $server_start_time = $gmt_date->format('H:i:s'); // GMT: 2011-04-27 12:15 PM
        }


        if (isset($whendtime)) {

            $ist_date1 = \DateTime::createFromFormat('H:i:s', $whendtime, new \DateTimeZone($user_timezone));

            $gmt_date1 = clone $ist_date1; // we don't want PHP's default pass object by reference here
            $gmt_date1->setTimeZone(new \DateTimeZone('UTC'));

            //echo 'IST:  ' . $ist_date->format('H:i:s').'<br><br>';  // IST:  2011-04-27 2:45 AM

            $server_end_time = $gmt_date1->format('H:i:s'); // GMT: 2011-04-27 12:15 PM
        }

        //echo 'Start Time: '.$server_start_time.' - End Time: '.$server_end_time; exit; 

        $sql = Yii::$app->db->createCommand("INSERT INTO ext_working_hours(name,start_time,end_time,start_time_iso,end_time_iso,server_start_time,server_end_time,user_id,days) 
		VALUES ('" . $whtitle . "',
		'" . $_POST['whstarttime_usr'] . "',
		'" . $_POST['whendtime_usr'] . "',
		'" . $whstarttime . "',
		'" . $whendtime . "',
		'" . $server_start_time . "',
		'" . $server_end_time . "',
		'" . Yii::$app->session->get('userid') . "',
		'" . $_POST['chkDayStr'] . "' ) ")->execute();
    }

    public function actionGetworkinghours() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }



        $sqldata = "SELECT  * from ext_working_hours  where user_id=" . Yii::$app->session->get('userid');
        $dataarry = Yii::$app->db->createCommand($sqldata)->queryAll();

        $whhtml = '';
        foreach ($dataarry as $key => $whrw) {

            //nr starts
            $daysA = explode(',', $whrw['days']);
            $daysAV = array();
            foreach ($daysA as $res) {
                if ($res == 1) {
                    $daysAV[] = 'Monday';
                } elseif ($res == 2) {
                    $daysAV[] = 'Tuesday';
                } elseif ($res == 3) {
                    $daysAV[] = 'Wednesday';
                } elseif ($res == 4) {
                    $daysAV[] = 'Thursday';
                } elseif ($res == 5) {
                    $daysAV[] = 'Friday';
                } elseif ($res == 6) {
                    $daysAV[] = 'Saturday';
                } elseif ($res == 7) {
                    $daysAV[] = 'Sunday';
                }
            }
            $daysAV = implode(", ", $daysAV);
            //nr ends

            $whhtml .= '<tr class="table-striped">
				<td class="nameWrp">' . $whrw['name'] . '</td>
				<td>' . $daysAV . ' - ' . $whrw['start_time'] . ' to ' . $whrw['end_time'] . '</td>
			  
				<td class="text-center py-1">
					<div class="dropdown">
						<span class="bx bx-dots-vertical-rounded font-medium-3 dropdown-toggle nav-hide-arrow cursor-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" role="menu"></span>
						<div class="dropdown-menu dropdown-menu-right">
					
							<a href="javascript:void(0);"  title="Edit" onclick="openModalFor_editwhitem(' . $whrw['id'] . ')" class="editWTCls_' . $whrw['id'] . '" data-id="' . $whrw['id'] . '" data-days="' . $whrw['days'] . '"  data-name="' . $whrw['name'] . '"  data-start_time="' . $whrw['start_time'] . '" data-end_time="' . $whrw['end_time'] . '" data-uid="' . $whrw['user_id'] . '"  data-server_start_time="' . $whrw['server_start_time'] . '"  data-server_end_time="' . $whrw['server_end_time'] . '"><i class="bx bx-edit-alt mr-1"></i>edit</a> <a href="javascript:void(0);" title="Delete" onclick="deletewhitem(' . $whrw['id'] . ')" data-del-id="' . $whrw['id'] . '"><i class="bx bx-trash mr-1"></i>delete</a>
						
						</div>
					</div>
				</td>
			  
			  
			 
			</tr>';
        }

        return $whhtml;
    }

    //working
    public function actionEditworkinghours() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $whtitle = $_POST['whtitle'];
        $whtitle = addslashes($whtitle);
        $whtitle = htmlspecialchars($whtitle);
        $whstarttime = $_POST['whstarttime'] . ':00';
        $whendtime = $_POST['whendtime'] . ':00';
        //echo "<pre>"; print_r($_POST); exit;
        // Get user timezone
        $user_timezone = '';
        $getTimezone = Yii::$app->db->createCommand("SELECT TimeZone FROM user where id =  " . Yii::$app->session->get('userid'))->queryOne();
        $user_timezone = $getTimezone['TimeZone'];
        // End
        //$server_start_time = '00:00:00';
        //$server_end_time = '00:00:00';
        //echo $whstarttime.'===='.$whendtime.'</br>'; exit;
        if (isset($whstarttime)) {

            $ist_date = \DateTime::createFromFormat('H:i:s', $whstarttime, new \DateTimeZone($user_timezone));
            //print_r($ist_date);die;
            $gmt_date = clone $ist_date; // we don't want PHP's default pass object by reference here
            $gmt_date->setTimeZone(new \DateTimeZone('UTC'));

            //echo 'IST:  ' . $ist_date->format('H:i:s').'<br><br>';  // IST:  2011-04-27 2:45 AM

            $server_start_time = $gmt_date->format('H:i:s'); // GMT: 2011-04-27 12:15 PM
        }


        if (isset($whendtime)) {

            $ist_date1 = \DateTime::createFromFormat('H:i:s', $whendtime, new \DateTimeZone($user_timezone));

            $gmt_date1 = clone $ist_date1; // we don't want PHP's default pass object by reference here
            $gmt_date1->setTimeZone(new \DateTimeZone('UTC'));

            //echo 'IST:  ' . $ist_date->format('H:i:s').'<br><br>';  // IST:  2011-04-27 2:45 AM

            $server_end_time = $gmt_date1->format('H:i:s'); // GMT: 2011-04-27 12:15 PM
        }

        //echo 'Start Time: '.$server_start_time.' - End Time: '.$server_end_time; exit; 

        $sql = Yii::$app->db->createCommand("UPDATE ext_working_hours SET name = '" . $whtitle . "', start_time = '" . $_POST['whstarttime_usr'] . "', end_time = '" . $_POST['whendtime_usr'] . "', start_time_iso = '" . $whstarttime . "', end_time_iso = '" . $whendtime . "', server_start_time = '" . $server_start_time . "', server_end_time = '" . $server_end_time . "', days = '" . $_POST['chkDayStr'] . "' WHERE id =" . $_POST['edt_wtid'] . " AND user_id=" . Yii::$app->session->get('userid'))->execute();
    }

    public function actionDeleteworkinghours() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $whitemid = $_POST['whitemid'];

        $sqldata = "SELECT  COUNT(id) as countrec from `ext_sequences`  where `working_hour_id`=" . $whitemid . "";
        $dataarry = Yii::$app->db->createCommand($sqldata)->queryOne();

        if ($dataarry['countrec'] > 0) {
            echo 'no';
        } else {
            $sql = Yii::$app->db->createCommand("DELETE FROM ext_working_hours where id='" . $whitemid . "'")->execute();
            echo 'yes';
        }
    }

    public function actionCheckintigration() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $userid = Yii::$app->session->get('userid');

        $intigrationdata = "SELECT  * from `intigration`  where `user_id`=" . $userid . "";
        $dataarry = Yii::$app->db->createCommand($intigrationdata)->queryOne();
        if (isset($dataarry) && !empty($dataarry)) {
            $access_key = json_decode($dataarry['access_key'], true);
            if (!empty($access_key['skrapp_api_key']) || !empty($access_key['find_that_lead_api_key']) || !empty($access_key['any_mail_finder_api_key']) || !empty($access_key['email_hunter_api_key'])) {
                echo 0;
            } else {
                echo 1;
            }
        } else {
            echo 1;
        }
    }

    public function actionCheckproxy() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $userid = Yii::$app->session->get('userid');
        $sqlUserdata = "SELECT proxyUsername from `user`  where `id`='" . $userid . "'";
        $dataUserarry = Yii::$app->db->createCommand($sqlUserdata)->queryOne();
        if ($dataUserarry['proxyUsername'] != "") {
            $userData = explode("-", $dataUserarry['proxyUsername']);
            $zoneName = $userData[4];
        } else {
            $zoneName = "";
        }
        return $zoneName;
    }

    public function actionUpdateproxy() {

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $userid = Yii::$app->session->get('userid');
        $zoneName = $_REQUEST['country'];

        $sqlUserdata = "SELECT  * from `user`  where `id`='" . $userid . "'";
        $dataUserarry = Yii::$app->db->createCommand($sqlUserdata)->queryOne();
//        print_r($dataUserarry);
//        exit;

        if (empty($dataUserarry['proxyIp']) && empty($dataUserarry['proxyPort']) && empty($dataUserarry['proxyUsername']) && empty($dataUserarry['proxyPassword']) && empty($dataUserarry['app_container_ip'])) {

            $ch_zoneStatus = curl_init();
            curl_setopt($ch_zoneStatus, CURLOPT_URL, 'https://luminati.io/api/zone/status?customer=halfpixel&zone=' . $zoneName);
            curl_setopt($ch_zoneStatus, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch_zoneStatus, CURLOPT_CUSTOMREQUEST, 'GET');
            curl_setopt($ch_zoneStatus, CURLOPT_USERPWD, 'arpan@halfpixel.co.in' . ':' . 'Asdf@123');
            $result_zoneStatus = curl_exec($ch_zoneStatus);
            if (curl_errno($ch_zoneStatus)) {
                echo 'Error:' . curl_error($ch_zoneStatus);
            }
            curl_close($ch_zoneStatus);
            $zoneStatus = json_decode($result_zoneStatus, true);

            if ($zoneStatus['status'] == 'disabled') {
                //Check if zone disabled then enable it
                $ch_zoneOn = curl_init();
                curl_setopt($ch_zoneOn, CURLOPT_URL, 'https://luminati.io/api/zone/change_disable');
                curl_setopt($ch_zoneOn, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch_zoneOn, CURLOPT_POST, 1);
                curl_setopt($ch_zoneOn, CURLOPT_POSTFIELDS, "{\"customer\":\"halfpixel\",\"zone\":\"$zoneName\",\"disable\":0}");
                curl_setopt($ch_zoneOn, CURLOPT_USERPWD, 'arpan@halfpixel.co.in' . ':' . 'Asdf@123');

                $headers = array();
                $headers[] = 'Content-Type: application/json';
                curl_setopt($ch_zoneOn, CURLOPT_HTTPHEADER, $headers);

                $result_zoneOn = curl_exec($ch_zoneOn);
                if (curl_errno($ch_zoneOn)) {
                    echo 'Error:' . curl_error($ch_zoneOn);
                }
                curl_close($ch_zoneOn);

                //Get zone ip
                $ch_FirstIp = curl_init();
                curl_setopt($ch_FirstIp, CURLOPT_URL, 'https://luminati.io/api/zone/ips?customer=halfpixel&zone=' . $zoneName);
                curl_setopt($ch_FirstIp, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch_FirstIp, CURLOPT_CUSTOMREQUEST, 'GET');
                curl_setopt($ch_FirstIp, CURLOPT_USERPWD, 'arpan@halfpixel.co.in' . ':' . 'Asdf@123');
                $result_FirstIp = curl_exec($ch_FirstIp);
                if (curl_errno($ch_FirstIp)) {
                    echo 'Error:' . curl_error($ch_FirstIp);
                }
                curl_close($ch_FirstIp);
                $FirstIp = json_decode($result_FirstIp, true);
                $Ip = $FirstIp['ips'][0]['ip'];

                //Check Risk level
                $ch_risklevel = curl_init();
                curl_setopt($ch_risklevel, CURLOPT_URL, 'https://signals.api.auth0.com/v2.0/ip/' . $Ip);
                curl_setopt($ch_risklevel, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch_risklevel, CURLOPT_CUSTOMREQUEST, 'GET');
                $headers = array();
                $headers[] = 'Accept: application/json';
                $headers[] = 'X-Auth-Token: fb71d712-faf3-4562-bb54-2b513c5cbbb0';
                curl_setopt($ch_risklevel, CURLOPT_HTTPHEADER, $headers);

                $result_risklevel = curl_exec($ch_risklevel);
                if (curl_errno($ch_risklevel)) {
                    echo 'Error:' . curl_error($ch_risklevel);
                }
                curl_close($ch_risklevel);
                $riskLevel = json_decode($result_risklevel, true);
                if ($riskLevel['fullip']['score'] < -1) {
                    //Check IP risklevel if score below -1 then refresh ip 
                    $ch_refresh = curl_init();
                    curl_setopt($ch_refresh, CURLOPT_URL, 'https://luminati.io/api/zone/ips/refresh');
                    curl_setopt($ch_refresh, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch_refresh, CURLOPT_POST, 1);
                    curl_setopt($ch_refresh, CURLOPT_POSTFIELDS, "{\"customer\":\"halfpixel\",\"zone\":\"$zoneName\",\"ips\":[\"$Ip\"]}");
                    curl_setopt($ch_refresh, CURLOPT_USERPWD, 'arpan@halfpixel.co.in' . ':' . 'Asdf@123');

                    $headers = array();
                    $headers[] = 'Content-Type: application/json';
                    curl_setopt($ch_refresh, CURLOPT_HTTPHEADER, $headers);

                    $result_refresh = curl_exec($ch_refresh);
                    if (curl_errno($ch_refresh)) {
                        echo 'Error:' . curl_error($ch_refresh);
                    }


                    curl_close($ch_refresh);
                    $refreshIp = json_decode($result_refresh, true);

                    $Ip = $refreshIp['new_ips'][0];

                    //Check Risk Level
                    $ch_risklevel = curl_init();
                    curl_setopt($ch_risklevel, CURLOPT_URL, 'https://signals.api.auth0.com/v2.0/ip/' . $Ip);
                    curl_setopt($ch_risklevel, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch_risklevel, CURLOPT_CUSTOMREQUEST, 'GET');
                    $headers = array();
                    $headers[] = 'Accept: application/json';
                    $headers[] = 'X-Auth-Token: fb71d712-faf3-4562-bb54-2b513c5cbbb0';
                    curl_setopt($ch_risklevel, CURLOPT_HTTPHEADER, $headers);

                    $result = curl_exec($ch_risklevel);
                    if (curl_errno($ch_risklevel)) {
                        echo 'Error:' . curl_error($ch_risklevel);
                    }
                    curl_close($ch_risklevel);
                    $riskLevel = json_decode($result, true);

                    if ($riskLevel['fullip']['score'] < -1) {
                        $AddRiskLevelIp = Yii::$app->db->createCommand("INSERT INTO `riskLevelIp`(`ip`,`zoneName`,`ipScore`,`userId`) VALUES ('" . $Ip . "','" . $zoneName . "','" . $riskLevel['fullip']['score'] . "','" . $userid . "')")->execute();
                        $html = $this->renderPartial('/../mail/risklevel_ip', ['Ip' => $Ip, 'zoneName' => $zoneName, 'riskLevel' => $riskLevel['fullip']['score'], 'userid' => $userid]);

                        $mail = Yii::$app->mailer->compose()
                                ->setTo('arpan@intricare.net')
//                    ->setBcc('ronit@leadconnect.io')
                                ->setFrom([Yii::$app->params['adminEmail'] => Yii::$app->params['emailFromName'] . ' payment initialized'])
                                //->setReplyTo()
                                ->setSubject('Risk Level IP Report')
                                ->setHtmlBody($html, 'text/html');
                        $mail->send();
                    } else {
                        //Get Zone info like password and other info
                        $ch_zoneinfo = curl_init();
                        curl_setopt($ch_zoneinfo, CURLOPT_URL, 'https://luminati.io/api/zone?customer=halfpixel&zone=' . $zoneName);
                        curl_setopt($ch_zoneinfo, CURLOPT_RETURNTRANSFER, 1);
                        curl_setopt($ch_zoneinfo, CURLOPT_CUSTOMREQUEST, 'GET');
                        curl_setopt($ch_zoneinfo, CURLOPT_USERPWD, 'arpan@halfpixel.co.in' . ':' . 'Asdf@123');
                        $result_zoneinfo = curl_exec($ch_zoneinfo);
                        if (curl_errno($ch_zoneinfo)) {
                            echo 'Error:' . curl_error($ch_zoneinfo);
                        }
                        curl_close($ch_zoneinfo);
                        $zoneinfo = json_decode($result_zoneinfo, true);
                        $proxyIp = "zproxy.lum-superproxy.io";
                        $proxyPort = "22225";
//                        $proxyUsername = 'lum-customer-halfpixel-zone-' . $zoneName . '-ip-' . $Ip;
                        $proxyUsername = 'lum-customer-c_5b864891-zone-' . $zoneName . '-ip-' . $Ip;
                        $proxyPassword = $zoneinfo['password'][0];

                        $app_container_port = rand(24000, 25000);

                        $sqldata = "SELECT  COUNT(id) as countrec from `user`  where `app_container_port`='" . $app_container_port . "'";
                        $dataarry = Yii::$app->db->createCommand($sqldata)->queryOne();
                        if ($dataarry['countrec'] < 0) {
//                        $sql = "UPDATE `user` SET `proxyIp`='" . $proxyIp . "',`proxyPort`='" . $proxyPort . "',`proxyUsername`='" . $proxyUsername . "',`proxyPassword`='" . $proxyPassword . "',`app_container_ip`='" . $Ip . "',`app_container_port`='" . $app_container_port . "' where `id`=" . $userid;
//                        Yii::$app->db->createCommand($sql)->execute();
                        } else {
                            $app_container_port = rand(24000, 25000);
                        }

                        $ch = curl_init();

                        //curl_setopt($ch, CURLOPT_URL, 'http://18.222.90.17:22999/api/proxies');
                        curl_setopt($ch, CURLOPT_URL, 'http://3.20.97.12:22999/api/proxies');
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                        curl_setopt($ch, CURLOPT_POST, 1);
                        //curl_setopt($ch, CURLOPT_POSTFIELDS, "{ \"proxy\": { \"ips\": [ \"$Ip\" ], \"multiply\": 1, \"multiply_ips\": true, \"pool_size\": 1, \"port\": $app_container_port, \"zone\": \"$zoneName\",\"customer\": \"halfpixel\",\"password\": \"$proxyPassword\",\"whitelist_ips\": [ \"18.222.90.17\" ] }}");
                        curl_setopt($ch, CURLOPT_POSTFIELDS, "{ \"proxy\": { \"ips\": [ \"$Ip\" ], \"multiply\": 1, \"multiply_ips\": true, \"pool_size\": 1, \"port\": $app_container_port, \"zone\": \"$zoneName\",\"customer\": \"halfpixel\",\"password\": \"$proxyPassword\",\"whitelist_ips\": [ \"3.20.97.12\" ] }}");

                        $headers = array();
                        $headers[] = 'Accept: application/json';
                        $headers[] = 'Content-Type: application/json';
                        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

                        $result = curl_exec($ch);
                        if (curl_errno($ch)) {
                            echo 'Error:' . curl_error($ch);
                            $proxy_error = $dataUserarry['proxy_error'];
                            $proxy_err = $proxy_error + 1;
                            $sql = "UPDATE `user` SET `proxy_error`='" . $proxy_err . "' where `id`=" . $userid;
                            Yii::$app->db->createCommand($sql)->execute();
                            if ($proxy_err >= 3) {
                                $Ip = $dataUserarry['app_container_ip'];
                                $email = $dataUserarry['email'];
                                $html = $this->renderPartial('/../mail/proxyError', ['Ip' => $Ip, 'email' => $email, 'userid' => $userid]);
                                $mail = Yii::$app->mailer->compose()
                                        ->setTo('arpan@intricare.net')
                                        ->setFrom([Yii::$app->params['adminEmail'] => Yii::$app->params['emailFromName'] . ' payment initialized'])
                                        ->setSubject('User having trouble to assign proxy')
                                        ->setHtmlBody($html, 'text/html');
                                $mail->send();
                            }
//                            $ch_deleteIp = curl_init();
//                            curl_setopt($ch_deleteIp, CURLOPT_URL, 'https://luminati.io/api/zone/ips');
//                            curl_setopt($ch_deleteIp, CURLOPT_RETURNTRANSFER, 1);
//                            curl_setopt($ch_deleteIp, CURLOPT_CUSTOMREQUEST, 'DELETE');
//                            curl_setopt($ch_deleteIp, CURLOPT_POSTFIELDS, "{\"customer\":\"halfpixel\",\"zone\":\"$zoneName\",\"ips\":[\"$Ip\"]}");
//                            curl_setopt($ch_deleteIp, CURLOPT_USERPWD, 'arpan@halfpixel.co.in' . ':' . 'Asdf@123');
//                            $headers = array();
//                            $headers[] = 'Content-Type: application/json';
//                            curl_setopt($ch_deleteIp, CURLOPT_HTTPHEADER, $headers);
//                            $result_deleteIp = curl_exec($ch_deleteIp);
//                            if (curl_errno($ch_deleteIp)) {
//                                echo 'Error:' . curl_error($ch_deleteIp);
//                            }
//                            curl_close($ch_deleteIp);
                        } else {
                            try {
                                $sql = "UPDATE `user` SET `proxyIp`='" . $proxyIp . "',`proxyPort`='" . $proxyPort . "',`proxyUsername`='" . $proxyUsername . "',`proxyPassword`='" . $proxyPassword . "',`app_container_ip`='" . $Ip . "',`app_container_port`='" . $app_container_port . "' where `id`=" . $userid;
                                Yii::$app->db->createCommand($sql)->execute();
                                $sql_LuminatiInfo = "INSERT INTO `Luminati_IP_Info` (`userId`,`Ip_address`, `Ip_AssignOn`) VALUES ('" . $userid . "', '" . $Ip . "', '" . date("Y-m-d H:i:s") . "')";
                                Yii::$app->db->createCommand($sql_LuminatiInfo)->execute();
                            } catch (\yii\db\Exception $e) {
                                return false;
                            }
                        }
                        curl_close($ch);
                    }
                } else {
                    //Get Zone info like password and other info
                    $ch_zoneinfo = curl_init();
                    curl_setopt($ch_zoneinfo, CURLOPT_URL, 'https://luminati.io/api/zone?customer=halfpixel&zone=' . $zoneName);
                    curl_setopt($ch_zoneinfo, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch_zoneinfo, CURLOPT_CUSTOMREQUEST, 'GET');
                    curl_setopt($ch_zoneinfo, CURLOPT_USERPWD, 'arpan@halfpixel.co.in' . ':' . 'Asdf@123');
                    $result_zoneinfo = curl_exec($ch_zoneinfo);
                    if (curl_errno($ch_zoneinfo)) {
                        echo 'Error:' . curl_error($ch_zoneinfo);
                    }
                    curl_close($ch_zoneinfo);
                    $zoneinfo = json_decode($result_zoneinfo, true);
                    $proxyIp = "zproxy.lum-superproxy.io";
                    $proxyPort = "22225";
//                    $proxyUsername = 'lum-customer-halfpixel-zone-' . $zoneName . '-ip-' . $Ip;
                    $proxyUsername = 'lum-customer-c_5b864891-zone-' . $zoneName . '-ip-' . $Ip;
                    $proxyPassword = $zoneinfo['password'][0];

                    $app_container_port = rand(24000, 25000);

                    $sqldata = "SELECT  COUNT(id) as countrec from `user`  where `app_container_port`='" . $app_container_port . "'";
                    $dataarry = Yii::$app->db->createCommand($sqldata)->queryOne();
                    if ($dataarry['countrec'] < 0) {
//                    $sql = "UPDATE `user` SET `proxyIp`='" . $proxyIp . "',`proxyPort`='" . $proxyPort . "',`proxyUsername`='" . $proxyUsername . "',`proxyPassword`='" . $proxyPassword . "',`app_container_ip`='" . $Ip . "',`app_container_port`='" . $app_container_port . "' where `id`=" . $userid;
//                    Yii::$app->db->createCommand($sql)->execute();
                    } else {
                        $app_container_port = rand(24000, 25000);
                    }

                    $ch = curl_init();

                    //curl_setopt($ch, CURLOPT_URL, 'http://18.222.90.17:22999/api/proxies');
                    curl_setopt($ch, CURLOPT_URL, 'http://3.20.97.12:22999/api/proxies');
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    //curl_setopt($ch, CURLOPT_POSTFIELDS, "{ \"proxy\": { \"ips\": [ \"$Ip\" ], \"multiply\": 1, \"multiply_ips\": true, \"pool_size\": 1, \"port\": $app_container_port, \"zone\": \"$zoneName\",\"customer\": \"halfpixel\",\"password\": \"$proxyPassword\",\"whitelist_ips\": [ \"18.222.90.17\" ] }}");
                    curl_setopt($ch, CURLOPT_POSTFIELDS, "{ \"proxy\": { \"ips\": [ \"$Ip\" ], \"multiply\": 1, \"multiply_ips\": true, \"pool_size\": 1, \"port\": $app_container_port, \"zone\": \"$zoneName\",\"customer\": \"halfpixel\",\"password\": \"$proxyPassword\",\"whitelist_ips\": [ \"3.20.97.12\" ] }}");

                    $headers = array();
                    $headers[] = 'Accept: application/json';
                    $headers[] = 'Content-Type: application/json';
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

                    $result = curl_exec($ch);
                    if (curl_errno($ch)) {
                        echo 'Error:' . curl_error($ch);
                        $proxy_error = $dataUserarry['proxy_error'];
                        $proxy_err = $proxy_error + 1;
                        $sql = "UPDATE `user` SET `proxy_error`='" . $proxy_err . "' where `id`=" . $userid;
                        Yii::$app->db->createCommand($sql)->execute();
                        if ($proxy_err >= 3) {
                            $Ip = $dataUserarry['app_container_ip'];
                            $email = $dataUserarry['email'];
                            $html = $this->renderPartial('/../mail/proxyError', ['Ip' => $Ip, 'email' => $email, 'userid' => $userid]);
                            $mail = Yii::$app->mailer->compose()
                                    ->setTo('arpan@intricare.net')
                                    ->setFrom([Yii::$app->params['adminEmail'] => Yii::$app->params['emailFromName'] . ' payment initialized'])
                                    ->setSubject('User having trouble to assign proxy')
                                    ->setHtmlBody($html, 'text/html');
                            $mail->send();
                        }
//                        $ch_deleteIp = curl_init();
//                        curl_setopt($ch_deleteIp, CURLOPT_URL, 'https://luminati.io/api/zone/ips');
//                        curl_setopt($ch_deleteIp, CURLOPT_RETURNTRANSFER, 1);
//                        curl_setopt($ch_deleteIp, CURLOPT_CUSTOMREQUEST, 'DELETE');
//                        curl_setopt($ch_deleteIp, CURLOPT_POSTFIELDS, "{\"customer\":\"halfpixel\",\"zone\":\"$zoneName\",\"ips\":[\"$Ip\"]}");
//                        curl_setopt($ch_deleteIp, CURLOPT_USERPWD, 'arpan@halfpixel.co.in' . ':' . 'Asdf@123');
//                        $headers = array();
//                        $headers[] = 'Content-Type: application/json';
//                        curl_setopt($ch_deleteIp, CURLOPT_HTTPHEADER, $headers);
//                        $result_deleteIp = curl_exec($ch_deleteIp);
//                        if (curl_errno($ch_deleteIp)) {
//                            echo 'Error:' . curl_error($ch_deleteIp);
//                        }
//                        curl_close($ch_deleteIp);
                    } else {
                        try {
                            $sql = "UPDATE `user` SET `proxyIp`='" . $proxyIp . "',`proxyPort`='" . $proxyPort . "',`proxyUsername`='" . $proxyUsername . "',`proxyPassword`='" . $proxyPassword . "',`app_container_ip`='" . $Ip . "',`app_container_port`='" . $app_container_port . "' where `id`=" . $userid;
                            Yii::$app->db->createCommand($sql)->execute();

                            $sql_LuminatiInfo = "INSERT INTO `Luminati_IP_Info` (`userId`,`Ip_address`, `Ip_AssignOn`) VALUES ('" . $userid . "', '" . $Ip . "', '" . date("Y-m-d H:i:s") . "')";
                            Yii::$app->db->createCommand($sql_LuminatiInfo)->execute();
                        } catch (\yii\db\Exception $e) {
                            return false;
                        }
                    }
                    curl_close($ch);
                }
            } else {
//Add New Ip to luminati if zone enable
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, 'https://luminati.io/api/zone/ips');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"customer\":\"halfpixel\",\"zone\":\"$zoneName\",\"count\":1}");
                curl_setopt($ch, CURLOPT_USERPWD, 'arpan@halfpixel.co.in' . ':' . 'Asdf@123');
                $headers = array();
                $headers[] = 'Content-Type: application/json';
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                $result = curl_exec($ch);
                if (curl_errno($ch)) {
                    echo 'Error:' . curl_error($ch);
                }
                curl_close($ch);

//        $result = '{"ips":["178.173.241.34","185.78.79.168","181.215.67.84","185.15.178.92"],"new_ips":["178.171.53.159"],"old_ip_cost":1.9500000000000002,"new_ip_cost":2.6,"pcost":{"precommit":0,"gb":0.1,"ip_bw":0,"ip":0.65,"unl_domain":2,"refresh":0.5,"cooling":2.65}}';
                $ipInfo = json_decode($result, true);
                $Ip = $ipInfo['new_ips'][0];

                //Check Risk level
                $ch_risklevel = curl_init();
                curl_setopt($ch_risklevel, CURLOPT_URL, 'https://signals.api.auth0.com/v2.0/ip/' . $Ip);
                curl_setopt($ch_risklevel, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch_risklevel, CURLOPT_CUSTOMREQUEST, 'GET');
                $headers = array();
                $headers[] = 'Accept: application/json';
                $headers[] = 'X-Auth-Token: fb71d712-faf3-4562-bb54-2b513c5cbbb0';
                curl_setopt($ch_risklevel, CURLOPT_HTTPHEADER, $headers);

                $result_risklevel = curl_exec($ch_risklevel);
                if (curl_errno($ch_risklevel)) {
                    echo 'Error:' . curl_error($ch_risklevel);
                }
                curl_close($ch_risklevel);
                $riskLevel = json_decode($result_risklevel, true);

                //Check IP risklevel if score below -1 then refresh ip 
                if ($riskLevel['fullip']['score'] < -1) {
                    $ch_refresh = curl_init();
                    curl_setopt($ch_refresh, CURLOPT_URL, 'https://luminati.io/api/zone/ips/refresh');
                    curl_setopt($ch_refresh, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch_refresh, CURLOPT_POST, 1);
                    curl_setopt($ch_refresh, CURLOPT_POSTFIELDS, "{\"customer\":\"halfpixel\",\"zone\":\"$zoneName\",\"ips\":[\"$Ip\"]}");
                    curl_setopt($ch_refresh, CURLOPT_USERPWD, 'arpan@halfpixel.co.in' . ':' . 'Asdf@123');

                    $headers = array();
                    $headers[] = 'Content-Type: application/json';
                    curl_setopt($ch_refresh, CURLOPT_HTTPHEADER, $headers);

                    $result_refresh = curl_exec($ch_refresh);
                    if (curl_errno($ch_refresh)) {
                        echo 'Error:' . curl_error($ch_refresh);
                    }

                    curl_close($ch_refresh);
                    $refreshIp = json_decode($result_refresh, true);
                    $Ip = $refreshIp['new_ips'][0];

                    $ch_risklevel = curl_init();
                    curl_setopt($ch_risklevel, CURLOPT_URL, 'https://signals.api.auth0.com/v2.0/ip/' . $Ip);
                    curl_setopt($ch_risklevel, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch_risklevel, CURLOPT_CUSTOMREQUEST, 'GET');
                    $headers = array();
                    $headers[] = 'Accept: application/json';
                    $headers[] = 'X-Auth-Token: fb71d712-faf3-4562-bb54-2b513c5cbbb0';
                    curl_setopt($ch_risklevel, CURLOPT_HTTPHEADER, $headers);

                    $result = curl_exec($ch_risklevel);
                    if (curl_errno($ch_risklevel)) {
                        echo 'Error:' . curl_error($ch_risklevel);
                    }
                    curl_close($ch_risklevel);
                    $riskLevel = json_decode($result, true);

                    if ($riskLevel['fullip']['score'] < -1) {
                        $AddRiskLevelIp = Yii::$app->db->createCommand("INSERT INTO `riskLevelIp`(`ip`,`zoneName`,`ipScore`,`userId`) VALUES ('" . $Ip . "','" . $zoneName . "','" . $riskLevel['fullip']['score'] . "','" . $userid . "')")->execute();

                        $html = $this->renderPartial('/../mail/risklevel_ip', ['Ip' => $Ip, 'zoneName' => $zoneName, 'riskLevel' => $riskLevel['fullip']['score'], 'userid' => $userid]);

                        $mail = Yii::$app->mailer->compose()
                                ->setTo('ravi@intricare.net')
//                    ->setBcc('ronit@leadconnect.io')
                                ->setFrom([Yii::$app->params['adminEmail'] => Yii::$app->params['emailFromName'] . ' payment initialized'])
                                //->setReplyTo()
                                ->setSubject('Risk Level IP Report')
                                ->setHtmlBody($html, 'text/html');
                        $mail->send();
                    } else {
                        //Get Zone info like password and other info
                        $ch_zoneinfo = curl_init();
                        curl_setopt($ch_zoneinfo, CURLOPT_URL, 'https://luminati.io/api/zone?customer=halfpixel&zone=' . $zoneName);
                        curl_setopt($ch_zoneinfo, CURLOPT_RETURNTRANSFER, 1);
                        curl_setopt($ch_zoneinfo, CURLOPT_CUSTOMREQUEST, 'GET');
                        curl_setopt($ch_zoneinfo, CURLOPT_USERPWD, 'arpan@halfpixel.co.in' . ':' . 'Asdf@123');
                        $result_zoneinfo = curl_exec($ch_zoneinfo);
                        if (curl_errno($ch_zoneinfo)) {
                            echo 'Error:' . curl_error($ch_zoneinfo);
                        }
                        curl_close($ch_zoneinfo);
                        $zoneinfo = json_decode($result_zoneinfo, true);
                        $proxyIp = "zproxy.lum-superproxy.io";
                        $proxyPort = "22225";
//                        $proxyUsername = 'lum-customer-halfpixel-zone-' . $zoneName . '-ip-' . $Ip;
                        $proxyUsername = 'lum-customer-c_5b864891-zone-' . $zoneName . '-ip-' . $Ip;
                        $proxyPassword = $zoneinfo['password'][0];

                        $app_container_port = rand(24000, 25000);

                        $sqldata = "SELECT  COUNT(id) as countrec from `user`  where `app_container_port`='" . $app_container_port . "'";
                        $dataarry = Yii::$app->db->createCommand($sqldata)->queryOne();
                        if ($dataarry['countrec'] < 0) {
//                        $sql = "UPDATE `user` SET `proxyIp`='" . $proxyIp . "',`proxyPort`='" . $proxyPort . "',`proxyUsername`='" . $proxyUsername . "',`proxyPassword`='" . $proxyPassword . "',`app_container_ip`='" . $Ip . "',`app_container_port`='" . $app_container_port . "' where `id`=" . $userid;
//                        Yii::$app->db->createCommand($sql)->execute();
                        } else {
                            $app_container_port = rand(24000, 25000);
                        }

                        $ch = curl_init();

                        //curl_setopt($ch, CURLOPT_URL, 'http://18.222.90.17:22999/api/proxies');
                        curl_setopt($ch, CURLOPT_URL, 'http://3.20.97.12:22999/api/proxies');
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                        curl_setopt($ch, CURLOPT_POST, 1);
                        //curl_setopt($ch, CURLOPT_POSTFIELDS, "{ \"proxy\": { \"ips\": [ \"$Ip\" ], \"multiply\": 1, \"multiply_ips\": true, \"pool_size\": 1, \"port\": $app_container_port, \"zone\": \"$zoneName\",\"customer\": \"halfpixel\",\"password\": \"$proxyPassword\",\"whitelist_ips\": [ \"18.222.90.17\" ] }}");
                        curl_setopt($ch, CURLOPT_POSTFIELDS, "{ \"proxy\": { \"ips\": [ \"$Ip\" ], \"multiply\": 1, \"multiply_ips\": true, \"pool_size\": 1, \"port\": $app_container_port, \"zone\": \"$zoneName\",\"customer\": \"halfpixel\",\"password\": \"$proxyPassword\",\"whitelist_ips\": [ \"3.20.97.12\" ] }}");

                        $headers = array();
                        $headers[] = 'Accept: application/json';
                        $headers[] = 'Content-Type: application/json';
                        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

                        $result = curl_exec($ch);
                        if (curl_errno($ch)) {
                            echo 'Error:' . curl_error($ch);
                            $proxy_error = $dataUserarry['proxy_error'];
                            $proxy_err = $proxy_error + 1;
                            $sql = "UPDATE `user` SET `proxy_error`='" . $proxy_err . "' where `id`=" . $userid;
                            Yii::$app->db->createCommand($sql)->execute();
                            if ($proxy_err >= 3) {
                                $Ip = $dataUserarry['app_container_ip'];
                                $email = $dataUserarry['email'];
                                $html = $this->renderPartial('/../mail/proxyError', ['Ip' => $Ip, 'email' => $email, 'userid' => $userid]);
                                $mail = Yii::$app->mailer->compose()
                                        ->setTo('arpan@intricare.net')
                                        ->setFrom([Yii::$app->params['adminEmail'] => Yii::$app->params['emailFromName'] . ' payment initialized'])
                                        ->setSubject('User having trouble to assign proxy')
                                        ->setHtmlBody($html, 'text/html');
                                $mail->send();
                            }
//                            $ch_deleteIp = curl_init();
//                            curl_setopt($ch_deleteIp, CURLOPT_URL, 'https://luminati.io/api/zone/ips');
//                            curl_setopt($ch_deleteIp, CURLOPT_RETURNTRANSFER, 1);
//                            curl_setopt($ch_deleteIp, CURLOPT_CUSTOMREQUEST, 'DELETE');
//                            curl_setopt($ch_deleteIp, CURLOPT_POSTFIELDS, "{\"customer\":\"halfpixel\",\"zone\":\"$zoneName\",\"ips\":[\"$Ip\"]}");
//                            curl_setopt($ch_deleteIp, CURLOPT_USERPWD, 'arpan@halfpixel.co.in' . ':' . 'Asdf@123');
//                            $headers = array();
//                            $headers[] = 'Content-Type: application/json';
//                            curl_setopt($ch_deleteIp, CURLOPT_HTTPHEADER, $headers);
//                            $result_deleteIp = curl_exec($ch_deleteIp);
//                            if (curl_errno($ch_deleteIp)) {
//                                echo 'Error:' . curl_error($ch_deleteIp);
//                            }
//                            curl_close($ch_deleteIp);
                        } else {
                            try {
                                $sql = "UPDATE `user` SET `proxyIp`='" . $proxyIp . "',`proxyPort`='" . $proxyPort . "',`proxyUsername`='" . $proxyUsername . "',`proxyPassword`='" . $proxyPassword . "',`app_container_ip`='" . $Ip . "',`app_container_port`='" . $app_container_port . "' where `id`=" . $userid;
                                Yii::$app->db->createCommand($sql)->execute();

                                $sql_LuminatiInfo = "INSERT INTO `Luminati_IP_Info` (`userId`,`Ip_address`, `Ip_AssignOn`) VALUES ('" . $userid . "', '" . $Ip . "', '" . date("Y-m-d H:i:s") . "')";
                                Yii::$app->db->createCommand($sql_LuminatiInfo)->execute();
                            } catch (\yii\db\Exception $e) {
                                return false;
                            }
                        }
                        curl_close($ch);
                    }
                } else {
                    //Get Zone info like password and other info
                    $ch_zoneinfo = curl_init();
                    curl_setopt($ch_zoneinfo, CURLOPT_URL, 'https://luminati.io/api/zone?customer=halfpixel&zone=' . $zoneName);
                    curl_setopt($ch_zoneinfo, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch_zoneinfo, CURLOPT_CUSTOMREQUEST, 'GET');
                    curl_setopt($ch_zoneinfo, CURLOPT_USERPWD, 'arpan@halfpixel.co.in' . ':' . 'Asdf@123');
                    $result_zoneinfo = curl_exec($ch_zoneinfo);
                    if (curl_errno($ch_zoneinfo)) {
                        echo 'Error:' . curl_error($ch_zoneinfo);
                    }
                    curl_close($ch_zoneinfo);
                    $zoneinfo = json_decode($result_zoneinfo, true);
                    $proxyIp = "zproxy.lum-superproxy.io";
                    $proxyPort = "22225";
//                    $proxyUsername = 'lum-customer-halfpixel-zone-' . $zoneName . '-ip-' . $Ip;
                    $proxyUsername = 'lum-customer-c_5b864891-zone-' . $zoneName . '-ip-' . $Ip;
                    $proxyPassword = $zoneinfo['password'][0];

                    $app_container_port = rand(24000, 25000);
                    $sqldata = "SELECT  COUNT(id) as countrec from `user`  where `app_container_port`='" . $app_container_port . "'";
                    $dataarry = Yii::$app->db->createCommand($sqldata)->queryOne();
                    if ($dataarry['countrec'] < 0) {
//                    $sql = "UPDATE `user` SET `proxyIp`='" . $proxyIp . "',`proxyPort`='" . $proxyPort . "',`proxyUsername`='" . $proxyUsername . "',`proxyPassword`='" . $proxyPassword . "',`app_container_ip`='" . $Ip . "',`app_container_port`='" . $app_container_port . "' where `id`=" . $userid;
//                    Yii::$app->db->createCommand($sql)->execute();
                    } else {
                        $app_container_port = rand(24000, 25000);
                    }

                    $ch = curl_init();

                    //curl_setopt($ch, CURLOPT_URL, 'http://18.222.90.17:22999/api/proxies');
                    curl_setopt($ch, CURLOPT_URL, 'http://3.20.97.12:22999/api/proxies');
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    //curl_setopt($ch, CURLOPT_POSTFIELDS, "{ \"proxy\": { \"ips\": [ \"$Ip\" ], \"multiply\": 1, \"multiply_ips\": true, \"pool_size\": 1, \"port\": $app_container_port, \"zone\": \"$zoneName\",\"customer\": \"halfpixel\",\"password\": \"$proxyPassword\",\"whitelist_ips\": [ \"18.222.90.17\" ] }}");
                    curl_setopt($ch, CURLOPT_POSTFIELDS, "{ \"proxy\": { \"ips\": [ \"$Ip\" ], \"multiply\": 1, \"multiply_ips\": true, \"pool_size\": 1, \"port\": $app_container_port, \"zone\": \"$zoneName\",\"customer\": \"halfpixel\",\"password\": \"$proxyPassword\",\"whitelist_ips\": [ \"3.20.97.12\" ] }}");

                    $headers = array();
                    $headers[] = 'Accept: application/json';
                    $headers[] = 'Content-Type: application/json';
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

                    $result = curl_exec($ch);
                    if (curl_errno($ch)) {
                        echo 'Error:' . curl_error($ch);
                        $proxy_error = $dataUserarry['proxy_error'];
                        $proxy_err = $proxy_error + 1;
                        $sql = "UPDATE `user` SET `proxy_error`='" . $proxy_err . "' where `id`=" . $userid;
                        Yii::$app->db->createCommand($sql)->execute();
                        if ($proxy_err >= 3) {
                            $Ip = $dataUserarry['app_container_ip'];
                            $email = $dataUserarry['email'];
                            $html = $this->renderPartial('/../mail/proxyError', ['Ip' => $Ip, 'email' => $email, 'userid' => $userid]);
                            $mail = Yii::$app->mailer->compose()
                                    ->setTo('arpan@intricare.net')
                                    ->setFrom([Yii::$app->params['adminEmail'] => Yii::$app->params['emailFromName'] . ' payment initialized'])
                                    ->setSubject('User having trouble to assign proxy')
                                    ->setHtmlBody($html, 'text/html');
                            $mail->send();
                        }
                        //Delete ips if error comes from luminati
//                        $ch_deleteIp = curl_init();
//                        curl_setopt($ch_deleteIp, CURLOPT_URL, 'https://luminati.io/api/zone/ips');
//                        curl_setopt($ch_deleteIp, CURLOPT_RETURNTRANSFER, 1);
//                        curl_setopt($ch_deleteIp, CURLOPT_CUSTOMREQUEST, 'DELETE');
//                        curl_setopt($ch_deleteIp, CURLOPT_POSTFIELDS, "{\"customer\":\"halfpixel\",\"zone\":\"$zoneName\",\"ips\":[\"$Ip\"]}");
//                        curl_setopt($ch_deleteIp, CURLOPT_USERPWD, 'arpan@halfpixel.co.in' . ':' . 'Asdf@123');
//                        $headers = array();
//                        $headers[] = 'Content-Type: application/json';
//                        curl_setopt($ch_deleteIp, CURLOPT_HTTPHEADER, $headers);
//                        $result_deleteIp = curl_exec($ch_deleteIp);
//                        if (curl_errno($ch_deleteIp)) {
//                            echo 'Error:' . curl_error($ch_deleteIp);
//                        }
//                        curl_close($ch_deleteIp);
                    } else {
                        try {
                            $sql = "UPDATE `user` SET `proxyIp`='" . $proxyIp . "',`proxyPort`='" . $proxyPort . "',`proxyUsername`='" . $proxyUsername . "',`proxyPassword`='" . $proxyPassword . "',`app_container_ip`='" . $Ip . "',`app_container_port`='" . $app_container_port . "' where `id`=" . $userid;
                            Yii::$app->db->createCommand($sql)->execute();

                            $sql_LuminatiInfo = "INSERT INTO `Luminati_IP_Info` (`userId`,`Ip_address`, `Ip_AssignOn`) VALUES ('" . $userid . "', '" . $Ip . "', '" . date("Y-m-d H:i:s") . "')";
                            Yii::$app->db->createCommand($sql_LuminatiInfo)->execute();
                        } catch (\yii\db\Exception $e) {
                            return false;
                        }
                    }
                    curl_close($ch);
                }
            }
        } else {
            if (!empty($dataUserarry['app_container_ip'])) {
                if (!empty($dataUserarry['app_container_port'])) {
                    $ch_deleteIpFromLPM = curl_init();
                    curl_setopt($ch_deleteIpFromLPM, CURLOPT_URL, 'http://3.20.97.12:22999/api/proxies/' . $dataUserarry['app_container_port']);
                    curl_setopt($ch_deleteIpFromLPM, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch_deleteIpFromLPM, CURLOPT_CUSTOMREQUEST, 'DELETE');
                    $headers = array();
                    $headers[] = 'Accept: application/json';
                    curl_setopt($ch_deleteIpFromLPM, CURLOPT_HTTPHEADER, $headers);

                    $result = curl_exec($ch_deleteIpFromLPM);
                    print_r($result);
                    if (curl_errno($ch_deleteIpFromLPM)) {
                        echo 'Error:' . curl_error($ch_deleteIpFromLPM);
                    }
                    curl_close($ch_deleteIpFromLPM);
                }

                $ch_zoneinfo = curl_init();
                curl_setopt($ch_zoneinfo, CURLOPT_URL, 'https://luminati.io/api/zone?customer=halfpixel&zone=' . $zoneName);
                curl_setopt($ch_zoneinfo, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch_zoneinfo, CURLOPT_CUSTOMREQUEST, 'GET');
                curl_setopt($ch_zoneinfo, CURLOPT_USERPWD, 'arpan@halfpixel.co.in' . ':' . 'Asdf@123');
                $result_zoneinfo = curl_exec($ch_zoneinfo);
                if (curl_errno($ch_zoneinfo)) {
                    echo 'Error:' . curl_error($ch_zoneinfo);
                }
                curl_close($ch_zoneinfo);
                $zoneinfo = json_decode($result_zoneinfo, true);
                $proxyPassword = $zoneinfo['password'][0];

                $Ip = $dataUserarry['app_container_ip'];
                $app_container_port = rand(24000, 25000);
                $sql = "UPDATE `user` SET `app_container_port`='" . $app_container_port . "' where `id`=" . $userid;
                Yii::$app->db->createCommand($sql)->execute();

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, 'http://3.20.97.12:22999/api/proxies');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, "{ \"proxy\": { \"ips\": [ \"$Ip\" ], \"multiply\": 1, \"multiply_ips\": true, \"pool_size\": 1, \"port\": $app_container_port, \"zone\": \"$zoneName\",\"customer\": \"halfpixel\",\"password\": \"$proxyPassword\",\"whitelist_ips\": [ \"3.20.97.12\" ] }}");

                $headers = array();
                $headers[] = 'Accept: application/json';
                $headers[] = 'Content-Type: application/json';
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

                $result = curl_exec($ch);
                if (curl_errno($ch)) {
                    echo 'Error:' . curl_error($ch);
                    $proxy_error = $dataUserarry['proxy_error'];
                    $proxy_err = $proxy_error + 1;
                    $sql = "UPDATE `user` SET `proxy_error`='" . $proxy_err . "' where `id`=" . $userid;
                    Yii::$app->db->createCommand($sql)->execute();
                    if ($proxy_err >= 3) {
                        $Ip = $dataUserarry['app_container_ip'];
                        $email = $dataUserarry['email'];
                        $html = $this->renderPartial('/../mail/proxyError', ['Ip' => $Ip, 'email' => $email, 'userid' => $userid]);
                        $mail = Yii::$app->mailer->compose()
                                ->setTo('arpan@intricare.net')
                                ->setFrom([Yii::$app->params['adminEmail'] => Yii::$app->params['emailFromName'] . ' payment initialized'])
                                ->setSubject('User having trouble to assign proxy')
                                ->setHtmlBody($html, 'text/html');
                        $mail->send();
                    }
                } else {


                    $ch_risklevel = curl_init();
                    curl_setopt($ch_risklevel, CURLOPT_URL, 'https://signals.api.auth0.com/v2.0/ip/' . $Ip);
                    curl_setopt($ch_risklevel, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch_risklevel, CURLOPT_CUSTOMREQUEST, 'GET');
                    $headers = array();
                    $headers[] = 'Accept: application/json';
                    $headers[] = 'X-Auth-Token: fb71d712-faf3-4562-bb54-2b513c5cbbb0';
                    curl_setopt($ch_risklevel, CURLOPT_HTTPHEADER, $headers);

                    $result = curl_exec($ch_risklevel);
                    //print_r($result);exit;
                    if (curl_errno($ch_risklevel)) {
                        echo 'Error:' . curl_error($ch_risklevel);
                    }
                    curl_close($ch_risklevel);
                    $riskLevel = json_decode($result, true);
                    //print_r($riskLevel);exit;
                }
            }
        }
        if (!empty($dataUserarry['app_container_ip'])) {

            $riskData = array();
            //print_r($riskLevel);exit;
            $riskData['country'] = $riskLevel['fullip']['geo']['country'];
            $riskData['city'] = $riskLevel['fullip']['geo']['city'];
            $riskData['score'] = $riskLevel['fullip']['score'];
            return json_encode($riskData);
        } else {
            return false;
        }
    }

    //NR 30Apr2020
    public function actionGetcontainer() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        //try {

        $userid = Yii::$app->session->get('userid');

        $time = new \DateTime('now');
        //$today = $time->format('Y-m-d');
        $timestamp = $time->getTimestamp();

        $result = [];



        $key = new RSA();
        $key->loadKey(file_get_contents('../phpseclib/AnkCM_NikAcc28Apr2020_PrivateKey.ppk'));

        //$ssh = new SSH2('3.135.221.23', 22);   // Domain or IP
        //$ssh = new SSH2('18.222.90.17', 22);   // Domain or IP
        $ssh = new SSH2('3.20.97.12', 22);   // Domain or IP
        if (!$ssh->login('ubuntu', $key)) {
            exit('Login Failed');
        }

        //echo $ssh->exec('pwd');
        //echo '<br/><br/>'.$ssh->exec('ls -a');
        //echo '<br/><br/>'.$ssh->exec('sudo docker ps');


        $getUser = Yii::$app->db->createCommand("SELECT * FROM user where id =  " . $userid)->queryOne();


        $app_p1 = $userid . '_' . $timestamp;
        $app_p2 = $app_p1; //password
        $app_p3 = $getUser['app_container_port']; //"24001";
        //$app_p4 = $getUser['userAgent'];
        //echo $ssh->exec('sudo /bin/bash /root/vncdocker/build.sh <container> <password>');//syntax
        //$return_str =  $ssh->exec('sudo /bin/bash /root/vncdocker/build.sh '.$app_p1.' '.$app_p1);
        $return_str = $ssh->exec('sudo /bin/bash /root/vncdocker/build.sh ' . $app_p1 . ' ' . $app_p2 . ' ' . $app_p3);
        //$return_str = $ssh->exec('sudo /bin/bash /root/vncdocker/build.sh ' . $app_p1 . ' ' . $app_p2 . ' ' . $app_p3 . '\"' . $app_p4.'\"');
        //echo 'sudo /bin/bash /root/vncdocker/build.sh ' . $app_p1 . ' ' . $app_p2 . ' ' . $app_p3 . ' ' . $app_p4;

        $result['success'] = 1;
        //$result['url'] = 'https://app39_12345.halfpixel.co.in/vnc_lite.html?password=headless';
        $result['url'] = 'https://app' . $app_p1 . '.halfpixel.co.in/vnc_lite.html?password=' . $app_p2;

        $result['return_str'] = $return_str;
        $result['app_p3'] = $app_p3;

        $sql = "UPDATE `user` SET `app_container`='" . $app_p1 . "' where `id`=" . $userid;
        Yii::$app->db->createCommand($sql)->execute();

        //$result['url'] = 'https://app1.halfpixel.co.in/vnc_lite.html?password=pass';


        /*
          //working lines but without proxy details
          //$app_p1 = '27_12345';
          $app_p1 = $userid.'_'.$timestamp;
          //$dr = $ssh->exec('sudo docker run -d  -v /home/ubuntu/Desktop/cloud_new/:/home/headless/extension  -l traefik.enable=true  -l traefik.frontend.rule="Host:app'.$app_p1.'.halfpixel.co.in"  -l traefik.frontend.entryPoints="https" -l traefik.port=6901    --network=web  --name app'.$app_p1.' chromium:latest ');



          echo '<br/><br/>'.$dr;
          $dr = explode(" ",$dr);
          if($dr[0]){
          $result['success'] = 1;

          $result['url'] = 'https://app'.$app_p1.'.halfpixel.co.in/vnc_lite.html?password=headless';
          }else{
          $result['success'] = 0;
          }
         */





        /* } catch (Exception $e) {
          echo 'Caught exception: ', $e->getMessage(), "\n";
          exit;
          } */

        //echo '<pre>'; print_r($result);die;
        return json_encode($result);
        //exit;
    }

    //NR 30Apr2020
    public function actionGetcontainertesting() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }


        $userid = Yii::$app->session->get('userid');

        $time = new \DateTime('now');
        //$today = $time->format('Y-m-d');
        $timestamp = $time->getTimestamp();

        $result = [];



        $key = new RSA();
        $key->loadKey(file_get_contents('../phpseclib/AnkCM_NikAcc28Apr2020_PrivateKey.ppk'));

        //$ssh = new SSH2('3.135.221.23', 22);   // Domain or IP
        //$ssh = new SSH2('18.222.90.17', 22);   // Domain or IP
        $ssh = new SSH2('3.20.97.12', 22);   // Domain or IP
        if (!$ssh->login('ubuntu', $key)) {
            exit('Login Failed');
        }

        echo $ssh->exec('pwd');
        echo '<br/><br/>' . $ssh->exec('ls -a');
        die;
        /*

          //echo '<br/><br/>'.$ssh->exec('ls -a');
          //echo '<br/><br/>'.$ssh->exec('sudo docker ps');


          $getUser = Yii::$app->db->createCommand("SELECT * FROM user where id =  " . $userid)->queryOne();


          $app_p1 = $userid . '_' . $timestamp;
          $app_p2 = $app_p1; //password
          $app_p3 = $getUser['app_container_port']; //"24001";
          //echo $ssh->exec('sudo /bin/bash /root/vncdocker/build.sh <container> <password>');//syntax
          //$return_str =  $ssh->exec('sudo /bin/bash /root/vncdocker/build.sh '.$app_p1.' '.$app_p1);
          $return_str = $ssh->exec('sudo /bin/bash /root/vncdocker/build.sh ' . $app_p1 . ' ' . $app_p2 . ' ' . $app_p3);

          $result['success'] = 1;
          //$result['url'] = 'https://app39_12345.halfpixel.co.in/vnc_lite.html?password=headless';
          $result['url'] = 'https://app' . $app_p1 . '.halfpixel.co.in/vnc_lite.html?password=' . $app_p2;

          $result['return_str'] = $return_str;
          $result['app_p3'] = $app_p3;

          $sql = "UPDATE `user` SET `app_container`='" . $app_p1 . "' where `id`=" . $userid;
          Yii::$app->db->createCommand($sql)->execute();

          //$result['url'] = 'https://app1.halfpixel.co.in/vnc_lite.html?password=pass';




          //echo '<pre>'; print_r($result);die;
          return json_encode($result);
          //exit;
         */
    }

    function encode($string, $key = "LEADCONNECTCLOUD2020") {
        $key = sha1($key);
        $strLen = strlen($string);
        $keyLen = strlen($key);
        $j = 0;
        $hash = "";
        for ($i = 0; $i < $strLen; $i++) {
            $ordStr = ord(substr($string, $i, 1));
            if ($j == $keyLen) {
                $j = 0;
            }
            $ordKey = ord(substr($key, $j, 1));
            $j++;
            $hash .= strrev(base_convert(dechex($ordStr + $ordKey), 16, 36));
        }
        return $hash;
    }

    function decode($string, $key = "LEADCONNECTCLOUD2020") {
        $key = sha1($key);
        $strLen = strlen($string);
        $keyLen = strlen($key);
        $j = 0;
        $hash = "";
        for ($i = 0; $i < $strLen; $i += 2) {
            $ordStr = hexdec(base_convert(strrev(substr($string, $i, 2)), 36, 16));
            if ($j == $keyLen) {
                $j = 0;
            }
            $ordKey = ord(substr($key, $j, 1));
            $j++;
            $hash .= chr($ordStr - $ordKey);
        }
        return $hash;
    }

    public function actionUpdatekillwordssuffix() {

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $userid = Yii::$app->session->get('userid');
        $killWordsSuffix = $_POST['killWordsSuffix'];

        $sql = "UPDATE `user` SET `killWordsSuffix`='" . $killWordsSuffix . "' where `id`=" . $userid;
        Yii::$app->db->createCommand($sql)->execute();
    }

    public function actionGetactivitylogdata() {
        $session = Yii::$app->session;
        $session->get('userid');
        $linkedinpublicid = Yii::$app->request->post('linkedinpublicid');
        /* $seqid = Yii::$app->request->post('seqid');
        $seq_name = Yii::$app->request->post('seq_name'); */
        $queryUsr = new Query();
        $queryUsr->select('TimeZone')->from('user')->where(['id' => Yii::$app->session->get('userid')]);
        $usrData = $queryUsr->one();

        $completedquery = new Query;
        $pendingquery = new Query;
        $blacklistquery = new Query;
        $completed_task = $completedquery->select(['`ext_sequences`.`id`,`ext_sequences`.`name`,`completed_tasks`.`type`', '`completed_tasks`.`result`', '`completed_tasks`.`completedOn`', '`completed_tasks`.`status`', '`completed_tasks`.`step`', '`completed_tasks`.`triggerOnInvitationAccepted`'])
                         ->from('completed_tasks')
                        ->where(['completed_tasks.userId' => $session->get('userid')])
						->join('INNER JOIN', 'ext_sequences', 'completed_tasks.seqId=ext_sequences.id')
                        ->andWhere(['completed_tasks.personId' => $linkedinpublicid])
                        ->orderBy(['completed_tasks.id' => SORT_DESC])->all();
        $pending_task = $pendingquery->select(['`ext_sequences`.`id`,`ext_sequences`.`name`,`ext_tasks`.`type`', '`ext_tasks`.`result`', '`ext_tasks`.`startTime`', '`ext_tasks`.`status`', '`ext_tasks`.`step`', '`ext_tasks`.`triggerOnInvitationAccepted`'])
                        ->from('ext_tasks')
						->join('INNER JOIN', 'ext_sequences', 'ext_tasks.seqId=ext_sequences.id')
                        ->where(['ext_tasks.userId' => $session->get('userid')])
                        ->andWhere(['ext_tasks.personId' => $linkedinpublicid])
                        ->orderBy(['ext_tasks.id' => SORT_DESC])->all();
        $is_response = $blacklistquery->select(['`blacklist`.`is_response`', '`blacklist`.`respond`'])
                        ->from('blacklist')
                        ->where(['blacklist.userid' => $session->get('userid')])
                        ->andWhere(['blacklist.linkedinpublicid' => $linkedinpublicid])
                        ->andWhere(['blacklist.seq_id' => $seqid])->one();
        //print_r($is_response); 
        $tempArray = array();
        foreach ($pending_task as $pactivitydata) {
			$seq_name=$pactivitydata['name'];
            $startTime = $pactivitydata['startTime'];
            $msg = $pactivitydata['result'];
            /* if (preg_match('/title="(.*?)"/', $msg, $display) === 1) {
              $msg = $display[1];
              $msg = strlen($msg) > 40 ? substr($msg, 0, 40) . "..." : $msg;
              } */
            if (preg_match('/title="(.*?)"/s', $msg, $display) === 1) {
                $msg = $display[1];
                $fullmsg = $msg;
                $msg = strlen($msg) > 40 ? substr($msg, 0, 40) . "..." : $msg;
            } else {
                $fullmsg = '';
            }
            $ist_date = \DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d H:i:s', $startTime / 1000), new \DateTimeZone('UTC'));
            $gmt_date = clone $ist_date;
            $gmt_date->setTimeZone(new \DateTimeZone($usrData['TimeZone']));
            $startTime = $gmt_date->format('d M Y h:i A');
            $type = $pactivitydata['type'];
            $step = $pactivitydata['step'];
            $triggerOnInvitationAccepted = $pactivitydata['triggerOnInvitationAccepted'];
            if ($pactivitydata['status'] == 'Skipped' && $type == 'Connect' && $step == 0) {
                $detailss = 'Invitation skipped ';
                $type = "Connection Message";
            } elseif ($pactivitydata['status'] == 'Skipped' && $type == 'Connect' && $step != 0) {
                $detailss = 'Follow-up skipped ';
                $type = "Follow-up Message";
            } elseif ($pactivitydata['status'] == 'Not Started' && $type == 'Connect' && $step == 0) {
                $detailss = 'Invite Scheduled ';
                $type = "Connection Message";
            } elseif ($pactivitydata['status'] == 'Not Started' && $type == 'Connect' && $step != 0) {
                $detailss = 'Follow-up Scheduled ';
                $type = "Follow-up Message";
            } elseif ($pactivitydata['status'] == 'Skipped' && $type == 'Message' && $step == 0) {
                $detailss = 'Message skipped ';
                $type = "First Message";
            } elseif ($pactivitydata['status'] == 'Skipped' && $type == 'Message' && $step != 0) {
                $detailss = 'Follow-up skipped ';
                $type = "Follow-up Message";
            } elseif ($pactivitydata['status'] == 'Not Started' && $type == 'Message' && $step == 0) {
                $detailss = 'Message Scheduled ';
                $type = "First Message";
            } elseif ($pactivitydata['status'] == 'Not Started' && $type == 'Message' && $step != 0 && $triggerOnInvitationAccepted == 1) {
                $detailss = 'Invite Withdrawal Task';
                $type = "";
            } elseif ($pactivitydata['status'] == 'Not Started' && $type == 'Message' && $step != 0) {
                $detailss = 'Message Scheduled ';
                $type = "Follow-up Message";
            } elseif ($pactivitydata['status'] == 'Paused' && $type == 'Message' && $step != 0 && $triggerOnInvitationAccepted == 1) {
                $detailss = 'Follow-up Paused ';
                $type = "Follow-up Message";
            } elseif ($pactivitydata['status'] == 'Paused' && $type == 'Message' && $step != 0) {
                $detailss = 'Follow-up Paused ';
                $type = "Follow-up Message";
            } elseif ($type == 'Zapier') {
                $detailss = 'Zapier Trigger Scheduled';
                $type = 'Zapier Message';
            }/* else{

              echo $type = $pactivitydata['type'];
              echo $step = $pactivitydata['step'];
              echo $pactivitydata['status'];
              $detailss='';
              } */

            if (!empty($msg)) {
                $div = "<div class='timeline-content'>  
                  <p class='timeline-text' title='" . $fullmsg . "'>" . $msg . "</p>
                </div>";
            } else {
                $div = "<div class='timeline-content' style='padding:0.5rem 0rem !important; '> 
                </div>";
            }
            $tmpArr = array();
            $tmpArr['time'] = $pactivitydata['startTime'];
            $tmpArr['result'] = "<li class='timeline-items timeline-icon-warning active'>
                <div class='timeline-time'>" . $startTime . "</div>
                <h6 class='timeline-title'>" . $detailss . "</h6>
                <p class='timeline-text'>" . $type . "<br>(" . $seq_name . ")</p>" . $div . "
              </li> ";
            array_push($tempArray, $tmpArr);
        }

        if (!empty($is_response['respond'])) {
            $respond = $is_response['respond'];
            $ist_date = \DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d H:i:s', $respond / 1000), new \DateTimeZone('UTC'));
            $gmt_date = clone $ist_date;
            $gmt_date->setTimeZone(new \DateTimeZone($usrData['TimeZone']));
            $respond = $gmt_date->format('d M Y h:i A');

            $tmpArr = array();
            $tmpArr['time'] = $is_response['respond'];
            $tmpArr['result'] = "<li class='timeline-items timeline-icon-warning active'>
			<div class='timeline-time'>" . $respond . "</div>
			<h6 class='timeline-title'>Responded At</h6>
			<p class='timeline-text'>(" . $seq_name . ")</p>
			</li> ";
            array_push($tempArray, $tmpArr);
        }
        foreach ($completed_task as $activitydata) {
			$seq_name=$activitydata['name'];
            $completedOn = strtotime($activitydata['completedOn']);
            $msg = $activitydata['result'];
            if (preg_match('/title="(.*?)"/s', $msg, $display) === 1) {
                $msg = $display[1];
                $fullmsg = $msg;
                $msg = strlen($msg) > 40 ? substr($msg, 0, 40) . "..." : $msg;
            } else {
                $fullmsg = '';
            }
            $ist_date = \DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d H:i:s', $completedOn), new \DateTimeZone('UTC'));
            $gmt_date = clone $ist_date;
            $gmt_date->setTimeZone(new \DateTimeZone($usrData['TimeZone']));
            $completedOn = $gmt_date->format('d M Y h:i A');
            $type = $activitydata['type'];
            $step = $activitydata['step'];
            $active = "";
            $details = "";
            if ($activitydata['status'] == 'Skipped' && $type == 'Connect' && $step == 0) {
                $details = 'Invite skipped ';
                $type = "Connection Message";
                $active = "<li class='timeline-items timeline-icon-success active'>";
            } elseif ($activitydata['status'] == 'Skipped' && $type == 'Connect' && $step != 0) {
                $details = 'Follow-up skipped ';
                $type = "Follow-up Message";
                $active = "<li class='timeline-items timeline-icon-primary active'>";
            } elseif ($activitydata['status'] == 'Skipped' && $type == 'Message' && $step == 0) {
                $details = 'Message skipped ';
                $type = "First Message";
                $active = "<li class='timeline-items timeline-icon-success active'>";
            } elseif ($activitydata['status'] == 'Skipped' && $type == 'Message' && $step != 0) {
                $details = 'Follow-up skipped ';
                $type = "Follow-up Message";
                $active = "<li class='timeline-items timeline-icon-danger active'>";
            } elseif ($activitydata['status'] == 'Complete' && $type == 'Connect' && $step == 0) {
                $details = 'Invite sent ';
                $type = "Connection Message";
                $active = "<li class='timeline-items timeline-icon-success active'>";
            } elseif ($activitydata['status'] == 'Complete' && $type == 'Connect' && $step != 0) {
                $details = 'Follow-up sent ';
                $type = "Follow-up Message";
                $active = "<li class='timeline-items timeline-icon-primary active'>";
            } elseif ($activitydata['status'] == 'Complete' && $type == 'Message' && $step == 0) {
                $details = 'Message sent ';
                $type = "First Message";
                $active = "<li class='timeline-items timeline-icon-danger active'>";
            } elseif ($activitydata['status'] == 'Complete' && $type == 'Message' && $step != 0) {
                $details = 'Follow-up sent ';
                $type = "Follow-up Message";
                $active = "<li class='timeline-items timeline-icon-primary active'>";
            } elseif ($activitydata['status'] == 'Paused' && $type == 'Connect' && $step == 0) {
                $details = 'Invite Skipped ';
                $type = "Connection Message";
                $active = "<li class='timeline-items timeline-icon-success active'>";
            } elseif ($activitydata['status'] == 'Paused' && $type == 'Connect' && $step != 0) {
                $details = 'Follow-up Skipped ';
                $type = "Follow-up Message";
                $active = "<li class='timeline-items timeline-icon-primary active'>";
            } elseif ($activitydata['status'] == 'Paused' && $type == 'Message' && $step == 0) {
                $details = 'Message Skipped ';
                $type = "First Message";
                $active = "<li class='timeline-items timeline-icon-danger active'>";
            } elseif ($activitydata['status'] == 'Paused' && $type == 'Message' && $step != 0) {
                $details = 'Follow-up Skipped ';
                $type = "Follow-up Message";
                $active = "<li class='timeline-items timeline-icon-primary active'>";
            } elseif ($type == 'Zapier') {
                $details = 'Message sent';
                $type = 'Zapier Message';
                $active = "<li class='timeline-items timeline-icon-success active'>";
            }

            if (!empty($msg)) {
                $div = "<div class='timeline-content'>  
                  <p class='timeline-text' title='" . $fullmsg . "'>" . $msg . "</p>
                </div>";
            } else {
                $div = "<div class='timeline-content' style='padding:0.5rem 0rem !important; '> 
                </div>";
            }

            $tmpArr = array();
            $tmpArr['time'] = strtotime($activitydata['completedOn']) * 1000;
            $tmpArr['result'] = $active . "
                <div class='timeline-time'>" . $completedOn . "</div>
                <h6 class='timeline-title'>" . $details . "</h6>
                <p class='timeline-text'>" . $type . "<br>(" . $seq_name . ")</p>" . $div . "
				</li> ";
            array_push($tempArray, $tmpArr);
        }

        /* print_r($tempArray); */
        $time = array_column($tempArray, 'time');
        array_multisort($time, SORT_DESC, $tempArray);
        if (!empty($tempArray)) {
            $results = "<div class='card-body'>
            <ul class='widget-timeline mb-0'>";
            foreach ($tempArray as $tempAy) {
                $results .= $tempAy['result'];
            }
            $results .= "</ul></div>";
        }

        echo $results;
    }

    public function actionGetalltag() {
        $userid = Yii::$app->session->get('userid');
        $queryTags = new Query();
        $resTags = $queryTags->select('*')->from('tags')->where(['userId' => $userid])->all();
        $html = '<option value="">Select Tag</option>';
        if (!empty($resTags)) {
            foreach ($resTags as $tags) {
                $html .= '<option value="' . $tags['id'] . '">' . $tags['tagName'] . '</option>';
            }
        }
        return $html;
    }

    public function actionGettagdetails() {
        $linkedinpublicid = Yii::$app->request->post('linkedinpublicid');
        $userid = Yii::$app->session->get('userid');
        $queryBlckLst = new Query();
        $restag = $queryBlckLst->select('id, tags')->from('blacklist')->where(['linkedinpublicid' => $linkedinpublicid, 'userid' => $userid])->one();
        $queryNotes = new Query();
        $resnotes = $queryNotes->select('note')->from('notes')->where(['personId' => $linkedinpublicid, 'userId' => $userid])->all();
        /* Tags */
        $tags = "<label class='app-file-label'>Tags</label>";
        $tags .= "<div  style='float:right'>";
        if (!empty($restag['tags'])) {
            $tagsArr = explode(',', $restag['tags']);
            foreach ($tagsArr as $onetag) {
                $tagquery = new Query();
                $tagResult = $tagquery->select('tagName')->from('tags')->where(['id' => $onetag, 'userId' => $userid])->one();
                $tags .= "<span class='badge badge-light-primary badge-pill'>" . $tagResult['tagName'] . "</span>";
            }
        } else {
            $tags .= "<span><b>No Tags</b></span><br>";
        }
        $tags .= '</div><br><br>';
        /* NOtes */
        $tags .= "<label class='app-file-label' style='margin-top:5px;'>Notes</label>";
        $tags .= "<div  style='float:right'>";
        if (!empty($resnotes)) {
            foreach ($resnotes as $notes) {
                $tags .= "<b>-<span>" . $notes['note'] . "</span></b><br>";
            }
        } else {
            $tags .= "<b><span>No Notes</span></b>";
        }
        $tags .= '</div>';
        echo $tags;
    }

    public function actionLoginwithadmin() {
        include('../web/updateLinkedInCookie.php');
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $UserID = $this->decode($_POST['UserID']);
        $sql = Yii::$app->db->createCommand("select * from user where id='$UserID'")->queryOne();
        if (!empty($sql)) {

            Yii::$app->session->remove('useremail');
            Yii::$app->session->remove('teamid');
            Yii::$app->session->remove('userid');
            Yii::$app->session->remove('username');
            Yii::$app->session->remove('__returnUrl');
            Yii::$app->session->remove('__id');
            Yii::$app->session->remove('loggedinwith_subusers');
            Yii::$app->session->remove('loggedinwith_superadmin');
            Yii::$app->session->remove('user_role');
            Yii::$app->session->remove('adminEmail');
            Yii::$app->session->remove('salesperson');


            $useremail = $sql['email'];
            $username = $sql['username'];
            $userid = $sql['id'];
            $teamid = $sql['teamid'];
            $first_name = $sql['first_name'];
            $last_name = $sql['last_name'];
            $companyname = $sql['companyname'];
            $last_login_at = $sql['last_login_at'];
            $portal_id = $sql['portal_id'];
            $userAgent = $sql['userAgent'];


            Yii::$app->session->set('useremail', $useremail);
            Yii::$app->session->set('username', $username);
            Yii::$app->session->set('userid', $userid);
            Yii::$app->session->set('teamid', $teamid);
            Yii::$app->session->set('first_name', $first_name);
            Yii::$app->session->set('last_name', $last_name);
            Yii::$app->session->set('companyname', $companyname);
//            Yii::$app->session->set('google', '1');
            Yii::$app->session->set('last_login_at', $last_login_at);
            Yii::$app->session->set('portal_id', $portal_id);
            Yii::$app->session->set('user_role', $sql['user_role']);
            Yii::$app->session->set('salesperson', $sql['salesperson']);

            $last_login_at = Yii::$app->db->createCommand("update `user` SET `last_login_at`=" . time() . " where `id`=" . $UserID)->execute();

            $proxyIp = $sql['proxyIp'];
            $proxyPort = $sql['proxyPort'];
            $proxyUsername = $sql['proxyUsername'];
            $proxyPassword = $sql['proxyPassword'];
            $cookie = $sql['cookie'];
            $csrf = $sql['csrf'];
            if (!empty($proxyIp) && !empty($proxyPort) && !empty($proxyUsername) && !empty($proxyPassword) && !empty($cookie) && !empty($csrf)) {
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://www.linkedin.com/voyager/api/me",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_HEADER => true,
                    /* CURLOPT_VERBOSE=>true, */
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_HTTPPROXYTUNNEL => 1,
                    CURLOPT_PROXY => "$proxyIp",
                    CURLOPT_PROXYPORT => "$proxyPort",
                    CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "cookie: $cookie",
                        "csrf-token: $csrf",
                        "x-http-method-override: GET",
                        "Host: www.linkedin.com",
                        "User-Agent:  $userAgent",
                        "Accept-Language: en-US,en;q=0.5",
                        "Accept-Encoding: gzip, deflate, br",
                        "content-type: application/x-www-form-urlencoded",
                        "x-li-lang: en_US",
                        "x-restli-protocol-version: 2.0.0",
                        "Origin: https://www.linkedin.com",
                        "TE: Trailers"
                    ),
                ));
                $curlResult = curl_exec($curl);
                $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                $headers = substr($curlResult, 0, $header_size);

                $curlResult = substr($curlResult, $header_size);
                $newCookie = getCookiesLdnFromHeaders($headers);
                if (!empty($newCookie)) {
                    updateUserLdnCookies($UserID, $newCookie);
                }
                //echo '<pre>';print_r($curlResult); die;
                if (!empty($curlResult)) {
                    $decodedRes = json_decode($curlResult);
                    if (!empty($decodedRes->miniProfile->picture)) {
                        $picture = (array) $decodedRes->miniProfile->picture;
                        $topProfilePic = $picture['com.linkedin.common.VectorImage']->rootUrl . $picture['com.linkedin.common.VectorImage']->artifacts[0]->fileIdentifyingUrlPathSegment;
                        Yii::$app->session->set('top_profile_pic', $topProfilePic);
                        Yii::$app->session->set('linkedin_firstname', $decodedRes->miniProfile->firstName);
                        Yii::$app->session->set('linkedin_lastname', $decodedRes->miniProfile->lastName);
                    } else {
                        Yii::$app->session->set('top_profile_pic', '');
                    }
                } else {
                    Yii::$app->session->set('top_profile_pic', '');
                }
            } else {
                Yii::$app->session->set('top_profile_pic', '');
            }
            return "1";
        } else {
            return "0";
        }
    }

    public function actionChecksublevel() {
        $userid = Yii::$app->session->get('userid');
        $sublevelDetail = Yii::$app->db->createCommand("select  sublevel,portal_id,entry_fee  from  user  where id =" . $userid)->queryOne();
        if ($sublevelDetail['entry_fee'] == '1' && $sublevelDetail['portal_id'] == '5' && $sublevelDetail['sublevel'] == 0) {
            return false;
        } elseif ($sublevelDetail['sublevel'] == 0 && $sublevelDetail['portal_id'] != '5') {
//            $update_user_sequences = "update ext_sequences set status='Paused' where status='Active' AND user_id='" . $userid . "'";
//            Yii::$app->db->createCommand($update_user_sequences)->execute();
            return false;
        } else {
            return true;
        }
    }

    public function actionAssignmultipletags() {
        $ids = Yii::$app->request->post('ids');
        $tagId = Yii::$app->request->post('tag');
        $userId = Yii::$app->session->get('userid');

        $blacklistDetail = Yii::$app->db->createCommand("select  id, tags  from  blacklist where id IN ($ids) AND userid=$userId")->queryAll();
        foreach ($blacklistDetail as $blacklist) {
            $tags = "";
            if (!empty($blacklist['tags'])) {
                $tagsArr = explode(',', $blacklist['tags']);
                if (!in_array($tagId, $tagsArr)) {
                    $tags = $blacklist['tags'] . ',' . $tagId;
                }
            } else {
                $tags = $tagId;
            }
            if (!empty($tags)) {
                echo $update_user_sequences = "update blacklist set tags='" . $tags . "' where userid='" . $userId . "' AND id='" . $blacklist['id'] . "'";
                Yii::$app->db->createCommand($update_user_sequences)->execute();
            }
        }
    }

    public function actionRemoveassigntagprospect() {
        $id = Yii::$app->request->post('id');
        $tagId = Yii::$app->request->post('tagId');
        $userId = Yii::$app->session->get('userid');
        $tbltype = Yii::$app->request->post('tbltype');

        if ($tbltype == 0) {
            $queryBlckLst = new Query();
            $res = $queryBlckLst->select('id, tags')->from('blacklist')->where(['id' => $id, 'userid' => $userId])->one();
            if (!empty($res)) {
                $tags = explode(",", $res['tags']);
                $pos = array_search($tagId, $tags);
                unset($tags[$pos]);
                $tags = implode(",", $tags);
                $update_user_sequences = "update blacklist set tags='" . $tags . "' where userid='" . $userId . "' AND id='" . $id . "'";
                Yii::$app->db->createCommand($update_user_sequences)->execute();
                return $tagId;
            } else {
                return false;
            }
        } else {

            $queryBlckLst = new Query();
            $res = $queryBlckLst->select('id, tags')->from('1stdegreedata')->where(['id' => $id, 'userId' => $userId])->one();
            if (!empty($res)) {
                $tags = explode(",", $res['tags']);
                $pos = array_search($tagId, $tags);
                unset($tags[$pos]);
                $tags = implode(",", $tags);
                $update_user_sequences = "update 1stdegreedata set tags='" . $tags . "' where userId='" . $userId . "' AND id='" . $id . "'";
                Yii::$app->db->createCommand($update_user_sequences)->execute();
                return $tagId;
            } else {
                return false;
            }
        }
    }

    public function actionAssignsingletagprospect() {
        $id = Yii::$app->request->post('id');
        $tagId = Yii::$app->request->post('tagId');
        $userId = Yii::$app->session->get('userid');
        $tbltype = Yii::$app->request->post('tbltype');
        if ($tbltype == 0) {
            $queryBlckLst = new Query();
            $res = $queryBlckLst->select('id, tags')->from('blacklist')->where(['id' => $id, 'userid' => $userId])->one();
            if (!empty($res['tags'])) {
                $tagsArr = explode(',', $res['tags']);
                if (!in_array($tagId, $tagsArr)) {
                    $tags = $res['tags'] . ',' . $tagId;
                } else {
                    $tags = "";
                }
            } else {
                $tags = $tagId;
            }
            if (!empty($tags)) {
                $update_user_sequences = "update blacklist set tags='" . $tags . "' where userid='" . $userId . "' AND id='" . $id . "'";
                Yii::$app->db->createCommand($update_user_sequences)->execute();
                return $tagId;
            } else {
                return false;
            }
        } else {

            $queryBlckLst = new Query();
            $res = $queryBlckLst->select('id, tags')->from('1stdegreedata')->where(['id' => $id, 'userId' => $userId])->one();
            if (!empty($res['tags'])) {
                $tagsArr = explode(',', $res['tags']);
                if (!in_array($tagId, $tagsArr)) {
                    $tags = $res['tags'] . ',' . $tagId;
                } else {
                    $tags = "";
                }
            } else {
                $tags = $tagId;
            }
            if (!empty($tags)) {
                $update_user_sequences = "update 1stdegreedata set tags='" . $tags . "' where userId='" . $userId . "' AND id='" . $id . "'";
                Yii::$app->db->createCommand($update_user_sequences)->execute();
                return $tagId;
            } else {
                return false;
            }
        }
    }

    public function actionSettagprospect() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        include('../web/config.php');
        $recordId = Yii::$app->request->post('id');
        $tagName = addslashes(Yii::$app->request->post('tagName'));
        $userId = Yii::$app->session->get('userid');
        $tbltype = Yii::$app->request->post('tbltype');

        $queryTagsCount = new Query();
        $TagsCount = $queryTagsCount->select('id')->from('tags')->where(['tagName' => $tagName, 'userId' => $userId])->count();

        if ($TagsCount > 0) {
            return false;
        } else {
            if (mysqli_query($con, "INSERT INTO tags (tagName, userId) values('" . $tagName . "','" . $userId . "')")) {
                $tagId = mysqli_insert_id($con);

                if ($tbltype == 0) {
                    $queryBlckLst = new Query();
                    $res = $queryBlckLst->select('id, tags')->from('blacklist')->where(['linkedinpublicid' => $recordId, 'userid' => $userId])->one();
                    if (!empty($res)) {
                        if (!empty($res['tags'])) {
                            $tags = $res['tags'] . ',' . $tagId;
                        } else {
                            $tags = $tagId;
                        }

                        mysqli_query($con, "UPDATE blacklist SET tags = '" . $tags . "' WHERE id =" . $res['id']);
                    }
                } else {
                    $queryBlckLst = new Query();
                    $res = $queryBlckLst->select('id, tags')->from('1stdegreedata')->where(['linkedinpublicid' => $recordId, 'userId' => $userId])->one();
                    if (!empty($res)) {
                        if (!empty($res['tags'])) {
                            $tags = $res['tags'] . ',' . $tagId;
                        } else {
                            $tags = $tagId;
                        }

                        mysqli_query($con, "UPDATE 1stdegreedata SET tags = '" . $tags . "' WHERE id =" . $res['id']);
                    }
                }

                return $tagId;
            } else {
                return false;
            }
        }
    }

    public function actionSettagmultiplaprospect() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        include('../web/config.php');
        $recordId = Yii::$app->request->post('id');
        $tagName = addslashes(Yii::$app->request->post('tagName'));
        $userId = Yii::$app->session->get('userid');

        $queryTagsCount = new Query();
        $TagsCount = $queryTagsCount->select('id')->from('tags')->where(['tagName' => $tagName, 'userId' => $userId])->count();

        if ($TagsCount > 0) {
            return false;
        } else {
            if (mysqli_query($con, "INSERT INTO tags (tagName, userId) values('" . $tagName . "','" . $userId . "')")) {
                $tagId = mysqli_insert_id($con);

                $blacklistDetail = Yii::$app->db->createCommand("select  id, tags  from  blacklist where linkedinpublicid IN ($recordId) AND userid=$userId")->queryAll();
                foreach ($blacklistDetail as $blacklist) {

                    $tags = "";
                    if (!empty($blacklist['tags'])) {
                        $tagsArr = explode(',', $blacklist['tags']);
                        if (!in_array($tagId, $tagsArr)) {
                            $tags = $blacklist['tags'] . ',' . $tagId;
                        }
                    } else {
                        $tags = $tagId;
                    }
                    if (!empty($tags)) {
                        $update_user_sequences = "update blacklist set tags='" . $tags . "' where userid='" . $userId . "' AND id='" . $blacklist['id'] . "'";
                        Yii::$app->db->createCommand($update_user_sequences)->execute();
                    }
                }
				
				$firstDegreeDetail = Yii::$app->db->createCommand("select  id, tags  from  1stdegreedata where linkedinpublicid IN ($recordId) AND userId=$userId")->queryAll();
                foreach ($firstDegreeDetail as $fsdata) {

                    $tags = "";
                    if (!empty($fsdata['tags'])) {
                        $tagsArr = explode(',', $fsdata['tags']);
                        if (!in_array($tagId, $tagsArr)) {
                            $tags = $fsdata['tags'] . ',' . $tagId;
                        }
                    } else {
                        $tags = $tagId;
                    }
                    if (!empty($tags)) {
                        $update_user_sequences = "update 1stdegreedata set tags='" . $tags . "' where userId='" . $userId . "' AND id='" . $fsdata['id'] . "'";
                        Yii::$app->db->createCommand($update_user_sequences)->execute();
                    }
                }
                return true;
            } else {
                return false;
            }
        }
    }

    public function actionGetthread($linkedinpublicid = "") {
//        include('../web/config.php');
        include('../web/updateLinkedInCookie.php');
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $timestamp = "";
        if (!empty(Yii::$app->request->post('linkedinpublicid'))) {
            $linkedinpublicid = Yii::$app->request->post('linkedinpublicid');
        } else {
            $linkedinpublicid = $linkedinpublicid;
        }
        $userId = Yii::$app->session->get('userid');
        $threadDetail = Yii::$app->db->createCommand("select threadId,thread from conversations where personId='$linkedinpublicid' AND userid=$userId")->queryOne();
        $userDetail = Yii::$app->db->createCommand("select csrf,cookie,proxyIp,proxyPort,proxyUsername,proxyPassword,popupstatus,userAgent from user where id=$userId")->queryOne();
        if (!empty($threadDetail)) {
            if (!empty($threadDetail['thread'])) {
                $thread = json_decode($threadDetail['thread'], true);
                $timestamp = substr($thread[0]['createdAt'], 0, -3);
            }
        }
        $threadID = $threadDetail['threadId'];
        $csrf = $userDetail['csrf'];
        $cookie = $userDetail['cookie'];
        $proxyIp = $userDetail['proxyIp'];
        $proxyPort = $userDetail['proxyPort'];
        $proxyUsername = $userDetail['proxyUsername'];
        $proxyPassword = $userDetail['proxyPassword'];
        $userAgent = $userDetail['userAgent'];
        if ($userDetail['popupstatus'] == 1 && !empty($threadDetail) && $timestamp != "") {
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://www.linkedin.com/voyager/api/messaging/conversations/" . $threadID . "/events?createdAfter\x3d$timestamp",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HEADER => true,
                /* CURLOPT_VERBOSE=>true, */
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_HTTPPROXYTUNNEL => 1,
                CURLOPT_PROXY => "$proxyIp",
                CURLOPT_PROXYPORT => "$proxyPort",
                CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => array(
                    "cookie: $cookie",
                    "csrf-token: $csrf",
                    "Host: www.linkedin.com",
                    "User-Agent: $userAgent",
                    "Accept-Language: en-US,en;q=0.5",
                    "Accept-Encoding: gzip, deflate, br",
                    "x-li-lang: en_US",
                    "x-restli-protocol-version: 2.0.0",
                    "Origin: https://www.linkedin.com",
                    "TE: Trailers"
                )
            ));
            $res = curl_exec($curl);
            $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
            $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
            $headers = substr($res, 0, $header_size);
            $newCookie = getCookiesLdnFromHeaders($headers);
            if (!empty($newCookie)) {
                updateUserLdnCookies($userId, $newCookie);
            }
            $res = substr($res, $header_size);
            $json_response = json_decode(mb_convert_encoding($res, 'UTF-8', 'UTF-8'));
            if (!empty($json_response->elements)) {
                $conversationDetails = array();
                $elemns = (array) $json_response->elements;
                for ($e = 0; $e < count($elemns); $e++) {
                    $f = (array) $elemns[$e];
                    if ("MEMBER_TO_MEMBER" == $f['subtype']) {
                        $conversation = array();
                        (preg_match('/fs_event:\(\d+,([SI].+)\)/', $f['entityUrn'], $matche)) ? $conversation['id'] = $matche[1] : $conversation['id'] = '';
                        $conversation['timestamp'] = $f['createdAt'];
                        $messageBody = (array) $f['eventContent'];
                        $messageBody = $messageBody["com.linkedin.voyager.messaging.event.MessageEvent"]->body;
                        if (empty($messageBody)) {
                            $messageBody = (array) $f['eventContent'];
                            $messageBody = str_replace('"', '', $messageBody["com.linkedin.voyager.messaging.event.MessageEvent"]->attributedBody->text);
                        }
                        if (!empty($f['from']) && !empty($f['eventContent'])) {
                            $from = (array) $f['from'];
                            $miniProf = $from['com.linkedin.voyager.messaging.MessagingMember']->miniProfile;
                            $eventContent = (array) $f['eventContent'];
                            $eventContent = $eventContent['com.linkedin.voyager.messaging.event.MessageEvent'];
                            if (!empty($miniProf) && !empty($eventContent)) {
                                $conversation['text'] = $miniProf->firstName . ' ' . $miniProf->lastName . ' said: ' . $messageBody;
                            }
                        }
                        array_push($conversationDetails, $conversation);
                    }
                }
                return json_encode($conversationDetails);
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    function actionCheckcontacthubspot() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $fullname = Yii::$app->request->post('fullname');
        $firstName = Yii::$app->request->post('firstName');
        $lastName = Yii::$app->request->post('lastName');
        $email = Yii::$app->request->post('email');
        if ($email == "N/A" || $email == "NA") {
            $email = "";
        }
        $Apikey = Yii::$app->request->post('Apikey');
        $portalId = Yii::$app->request->post('portalId');
        if ($Apikey != "" && $portalId != "") {
            $CheckVar = !empty($email) ? $email : (!empty($fullname) ? $fullname : '');
            $checkData = $this->unicodeString($CheckVar);

            $Url = "https://api.hubapi.com/contacts/v1/search/query?hapikey=" . $Apikey . "&q=" . $checkData;
            $RequestType = "GET";
            $PostFields = '';
            $Header = array();
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $Url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => $RequestType,
                CURLOPT_POSTFIELDS => $PostFields,
                CURLOPT_HTTPHEADER => $Header
            ));
            $response = curl_exec($curl);
            $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            $err = curl_error($curl);
            $hubspotContact = array();
            if ($httpcode == 200) {
                if (json_decode($response)->offset > 0) {
                    $vid = json_decode($response)->contacts[0]->vid;
                    $hubspotContact['vid'] = $vid;
                } else {
                    $hubspotContact['vid'] = "";
                }
                $response = array('vid' => $hubspotContact);
                return json_encode($response);
            } else {
                return false;
            }
        }
    }

    public function actionInvitationwithdrawal() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $userId = Yii::$app->session->get('userid');

        $postCount = Yii::$app->request->post('count');
        include('../web/config.php');
        $userQry = mysqli_query($con, "SELECT usrprfl.linkedin_email, usrprfl.linkedin_password, usrprfl.firstName, usrprfl.lastName, usr.first_name, usr.email, usr.csrf, usr.cookie, usr.portal_id, usr.proxyIp,usr.proxyPort, usr.proxyUsername, usr.proxyPassword, usr.userAgent from user_profile usrprfl, user usr where usrprfl.user_id = usr.id AND usr.id=" . $userId);
        $user = mysqli_fetch_assoc($userQry);
        $username = $user['linkedin_email'];
        $password = $user['linkedin_password'];
        $portalId = $user['portal_id'];
        $proxyIp = $user['proxyIp'];
        $proxyPort = $user['proxyPort'];
        $proxyUsername = $user['proxyUsername'];
        $proxyPassword = $user['proxyPassword'];
        $userAgent = $user['userAgent'];
        $cookie = $user['cookie'];
        $csrf = $user['csrf'];

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://www.linkedin.com/voyager/api/relationships/invitationsSummaryV2?types=List(SENT_INVITATION_COUNT,PENDING_INVITATION_COUNT,UNSEEN_INVITATION_COUNT,PENDING_INVITATION_BY_FACET_COUNT)",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_POSTFIELDS => $payload,
            CURLOPT_HTTPPROXYTUNNEL => 1,
            CURLOPT_HEADER => 1,
            CURLOPT_PROXY => "$proxyIp",
            CURLOPT_PROXYPORT => "$proxyPort",
            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
            CURLOPT_HTTPHEADER => array(
                "Authority: www.linkedin.com",
                "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:83.0) Gecko/20100101 Firefox/83.0",
                "Accept: application/vnd.linkedin.normalized+json+2.1",
                "Accept-Language: en-US,en;q=0.9",
                "Accept-Encoding: gzip, deflate, br",
                "Content-Type: application/json; charset=UTF-8",
                "Cookie: $cookie",
                "Csrf-token: $csrf",
                "Origin: https://www.linkedin.com",
                "Referer: https://www.linkedin.com/in/scottelser/",
                "X-Li-Lang: en_US",
                "x-restli-protocol-version: 2.0.0"
            ),
        ));

        $res = curl_exec($curl);
        $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
        $headers = substr($res, 0, $header_size);
        $resInvitation = substr($res, $header_size);
        $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        if ($http_code == 200) {
            $totObj = json_decode($resInvitation);
            $totalPendingInvitation = "";
            if (isset($totObj->data) && isset($totObj->data->numTotalSentInvitations) && !empty($totObj->data->numTotalSentInvitations)) {
                $totalPendingInvitation = $totObj->data->numTotalSentInvitations;
            }
            $last100 = array();
            $start = ((ceil($totalPendingInvitation / 100)) - 1) * 100;
            $count = 100;
            //$start= (($totalPendingInvitation-300) >0)?$totalPendingInvitation-300 : 0 ;
            $url = "https://www.linkedin.com/voyager/api/relationships/sentInvitationViewsV2?count=" . $count . "&invitationType=CONNECTION&q=invitationType&start=" . $start;
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_POSTFIELDS => $payload,
                CURLOPT_HTTPPROXYTUNNEL => 1,
                CURLOPT_HEADER => 1,
                CURLOPT_PROXY => "$proxyIp",
                CURLOPT_PROXYPORT => "$proxyPort",
                CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                CURLOPT_HTTPHEADER => array(
                    "Authority: www.linkedin.com",
                    "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:83.0) Gecko/20100101 Firefox/83.0",
                    "Accept: application/vnd.linkedin.normalized+json+2.1",
                    "Accept-Language: en-US,en;q=0.9",
                    "Accept-Encoding: gzip, deflate, br",
                    "Content-Type: application/json; charset=UTF-8",
                    "Cookie: $cookie",
                    "Csrf-token: $csrf",
                    "Origin: https://www.linkedin.com",
                    "Referer: https://www.linkedin.com/in/scottelser/",
                    "X-Li-Lang: en_US",
                    "x-restli-protocol-version: 2.0.0"
                ),
            ));

            $res = curl_exec($curl);
            $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
            $headers = substr($res, 0, $header_size);
            $resPendingInvitation = substr($res, $header_size);
            $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            if ($http_code == 200) {
                $eventResponse = json_decode($resPendingInvitation);
                $data = (array) $eventResponse->data;
                $requestIds = $data['*elements'];
                $reqCount = count($requestIds);
                $requestIds = array_reverse($requestIds);
                foreach ($requestIds as $requestId) {
                    if (count($last100) < $postCount) {
                        $last100[] = $requestId;
                    }
                }

                if (count($last100) < $postCount && $postCount < $totalPendingInvitation) {

                    $start = $start - 100;
                    $count = 100;
                    //$start= (($totalPendingInvitation-300) >0)?$totalPendingInvitation-300 : 0 ;
                    $url = "https://www.linkedin.com/voyager/api/relationships/sentInvitationViewsV2?count=" . $count . "&invitationType=CONNECTION&q=invitationType&start=" . $start;
                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                        CURLOPT_URL => $url,
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => "GET",
                        CURLOPT_POSTFIELDS => $payload,
                        CURLOPT_HTTPPROXYTUNNEL => 1,
                        CURLOPT_HEADER => 1,
                        CURLOPT_PROXY => "$proxyIp",
                        CURLOPT_PROXYPORT => "$proxyPort",
                        CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
                        CURLOPT_HTTPHEADER => array(
                            "Authority: www.linkedin.com",
                            "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:83.0) Gecko/20100101 Firefox/83.0",
                            "Accept: application/vnd.linkedin.normalized+json+2.1",
                            "Accept-Language: en-US,en;q=0.9",
                            "Accept-Encoding: gzip, deflate, br",
                            "Content-Type: application/json; charset=UTF-8",
                            "Cookie: $cookie",
                            "Csrf-token: $csrf",
                            "Origin: https://www.linkedin.com",
                            "Referer: https://www.linkedin.com/in/scottelser/",
                            "X-Li-Lang: en_US",
                            "x-restli-protocol-version: 2.0.0"
                        ),
                    ));

                    $res = curl_exec($curl);
                    $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
                    $headers = substr($res, 0, $header_size);
                    $resPendingInvitation = substr($res, $header_size);
                    $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
                    if ($http_code == 200) {
                        $eventResponse = json_decode($resPendingInvitation);
                        $data = (array) $eventResponse->data;
                        $requestIds = $data['*elements'];
                        $reqCount = count($requestIds);
                        $requestIds = array_reverse($requestIds);
                        foreach ($requestIds as $requestId) {
                            if (count($last100) < $postCount) {
                                $last100[] = $requestId;
                            }
                        }
                    }
                }
                $pad = "";
                $query = "INSERT INTO `withdrawals` (userId,requestId,status) values ";
                $checkcount = 0;
                foreach ($last100 as $reqId) {
                    if (!empty($reqId)) {
                        $reqId = str_replace("urn:li:fs_relSentInvitationView:", "", $reqId);
                        $reqId = str_replace("urn:li:invitation:", "", $reqId);
                        $query .= $pad . "(" . $userId . "," . $reqId . ",0)";
                        $pad = ",";
                    }
                }
                mysqli_query($con, $query);
                echo count($last100);
            }
        }
    }

    function actionDisconnecthubspot() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $userId = Yii::$app->session->get('userid');
        $keyDetail = Yii::$app->db->createCommand("SELECT  *  from  intigration  where user_id =" . $userId)->queryOne();
        if (sizeof($keyDetail) > 1) {
            $row = (array) json_decode($keyDetail['access_key']);
            $row['hubportal_id'] = "";
            $row['hubspot_key'] = "";
            $row['hubspot_auto'] = "";
            $row['actUserID'] = "";

            $row = json_encode($row);
            $sql = Yii::$app->db->createCommand("UPDATE intigration SET access_key='" . $row . "' where user_id='" . $userId . "'")->execute();
            if ($sql) {
                $sql = Yii::$app->db->createCommand("delete from  `ext_windowhubspotproperties`  where user_id =" . $userId)->execute();
                return true;
            } else {
                return false;
            }
        }
    }
	
	function actionDisconnectpipedrive() {
		if (!Yii::$app->session->get('useremail')) {
			$url = \Yii::$app->request->baseUrl . "/login"; 
			return $this->redirect($url); 
		}
		
		$userId= Yii::$app->session->get('userid');
		$keyDetail = Yii::$app->db->createCommand("SELECT  *  from  intigration  where user_id =" . $userId)->queryOne();
		if (!empty($keyDetail)) {
			$row = (array) json_decode($keyDetail['access_key']);
			$row['pipedrive_api_key'] = "";
			$row['pipedrive'] = "";
			$row['pipedriveOwner'] = "";
			$row['pipedriveDefaultStage'] = "";
			$row['pipedriveContactPrivacy'] = "";
			
			$row = json_encode($row);
			//echo "UPDATE intigration SET access_key='" . $row . "' where user_id='" . $userId . "'"; exit;
			$sql = Yii::$app->db->createCommand("UPDATE intigration SET access_key='" . $row . "' where user_id='" . $userId . "'")->execute();
			if($sql){
				return true;
			}else{
				return false; 
			}
		} 
	}
	
    function actionCheckcontactpipedrive() {
        include '../api/pipedrive/pipedrive-config.php';
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $fullname = Yii::$app->request->post('fullname');
        $firstName = Yii::$app->request->post('firstName');
        $lastName = Yii::$app->request->post('lastName');
        $email = Yii::$app->request->post('email');
        $pipedrive_api_key = Yii::$app->request->post('pipedrive_api_key');
        if ($email == "N/A" || $email == "NA") {
            $email = "";
        }
        $client = new \Pipedrive\Client(null, null, null, $pipedrive_api_key); // First 3 parameters are for OAuth2
        $persons = $client->getPersons();

        if (!empty($email)) {
            // Find person by email:
            $term = $email;
            $searchByEmail = 1; // Search only email field
        } else if (isset($firstName) && isset($lastName) && !empty($firstName) && !empty($lastName)) {
            // Find person by fullname:
            $term = $firstName . ' ' . $lastName;
            $searchByEmail = 0; // Search all field
        }

        if (!empty($term)) {
            $collect = array('term' => $term, 'start' => 0, 'searchByEmail' => $searchByEmail);
            $personSearch = $persons->findPersonsByName($collect);
            if (isset($personSearch->data) && !empty($personSearch->data)) {
                $response = array('id' => $personSearch->data[0]->id);
                return json_encode($response);
            } else {
                $response = array('id' => '');
                return json_encode($response);
            }
        }
    }

    public function actionPushtopipedrive() {
        include('../web/config.php');
        include '../api/pipedrive/pipedrive-config.php';
        $userId = Yii::$app->session->get('userid');


        $portalId = Yii::$app->db->createCommand("select portal_id from user where id=" . $userId)->queryScalar();
        $flag_pd = 0;
        $sitetitle = Yii::$app->db->createCommand("SELECT sitetitle FROM `portals` WHERE `id` = " . $portalId)->queryScalar();
        if (!empty($sitetitle)) {
            $flag_pd = 1;
        }
        if ($flag_pd == 0) {
            $sitetitle = Yii::$app->db->createCommand("SELECT sitetitle FROM `portals` WHERE `portal_url` LIKE '%app.linkedfusion.io%'")->queryScalar();
            if (!empty($sitetitle)) {
                $flag_pd = 1;
            }
        }

        if ($flag_pd == 1) {
            $GLOBALS['sitetitle'] = $sitetitle;
        } else {
            $GLOBALS['sitetitle'] = 'LinkedFusion';
        }

        $sitetitle = preg_replace('/\s+/', '', strtolower($GLOBALS['sitetitle']));
        $sitetitle_seq = $GLOBALS['sitetitle'] . '_sequence';
        $sitetitle_seq = preg_replace('/\s+/', '', strtolower($sitetitle_seq));

        if (Yii::$app->request->post('sequenceName') == 'N/A') {
            $sequenceName = "";
        } else {
            $sequenceName = Yii::$app->request->post('sequenceName');
        }

        if (!empty(Yii::$app->request->post('seq_id'))) {

            if (strpos(Yii::$app->request->post('seq_id'), ',') !== false) {
                $msgSeq = 1;
            } else {
                $msgSeq = 0;
            }

            $Seqqry = Yii::$app->db->createCommand("select msgSeq,name from ext_sequences where id IN (" . Yii::$app->request->post('seq_id') . ")")->queryAll();
            $seqenceArr = array();
            foreach ($Seqqry as $seqence) {
                array_push($seqenceArr, $seqence['name']);
            }
            $sequenceName = implode(",", $seqenceArr);
        } else {
            $msgSeq = 1;
        }
        $accessKeySql = $con->query("SELECT access_key FROM intigration where `user_id`='" . $userId . "'");
        $integrationAccessKey = $accessKeySql->fetch_assoc();
        if (!empty($integrationAccessKey)) {
            $accessKey = json_decode($integrationAccessKey['access_key']);
            (!empty($accessKey->pipedrive)) ? $pipedrive = $accessKey->pipedrive : $pipedrive = 0;
            (!empty($accessKey->pipedrive_api_key)) ? $pipedrive_api_key = $accessKey->pipedrive_api_key : $pipedrive_api_key = '';
            (!empty($accessKey->pipedriveOwner)) ? $pipedriveOwner = $accessKey->pipedriveOwner : $pipedriveOwner = '';
            (!empty($accessKey->pipedriveDefaultStage)) ? $pipedriveDefaultStage = $accessKey->pipedriveDefaultStage : $pipedriveDefaultStage = '';
            (!empty($accessKey->pipedriveContactPrivacy)) ? $pipedriveContactPrivacy = $accessKey->pipedriveContactPrivacy : $pipedriveContactPrivacy = '';
        } else {
            $pipedrive = 0;
            $pipedrive_api_key = '';
            $pipedriveOwner = '';
            $pipedriveDefaultStage = '';
            $pipedriveContactPrivacy = '';
        }
        if (!empty($pipedrive_api_key)) {
            $pipedriveContactId = '';
            $pipedriveOrgId = '';
            $email = Yii::$app->request->post('emailAddress');
            $phoneNumber = Yii::$app->request->post('phoneNumbers');
            $domain = '';
            
            if(Yii::$app->request->post('emailAddress') == 'NA' || Yii::$app->request->post('emailAddress') == 'N/A'){
                $email = "";
            }

            if (!empty($email)) {
                // Find person by email:
                $term = $email;
                $searchByEmail = 1; // Search only email field
            } else if (isset($_POST['profilefnamehub']) && isset($_POST['profilelnamehub']) && !empty($_POST['profilefnamehub']) && !empty($_POST['profilelnamehub'])) {
                // Find person by fullname:
                $term = $this->convertUnicodeString(Yii::$app->request->post('firstname')) . ' ' . $this->convertUnicodeString(Yii::$app->request->post('lastname'));
                $searchByEmail = 0; // Search all field
            }
            $client = new \Pipedrive\Client(null, null, null, $pipedrive_api_key); // First 3 parameters are for OAuth2
            $persons = $client->getPersons();
            if (!empty($term)) {
                $collect = array('term' => $term, 'start' => 0, 'searchByEmail' => $searchByEmail);
                $personSearch = $persons->findPersonsByName($collect);

                if (isset($personSearch->data) && !empty($personSearch->data)) {
                    if (1 <= count($personSearch->data) && count($personSearch->data) > 0) {
                        for ($f = count($personSearch->data) - 1; 0 <= $f; $f--) {
                            if (isset($personSearch->data[$f]->id) && !empty($personSearch->data[$f]->id)) {
                                $pipedriveContactId = $personSearch->data[$f]->id;
                                break;
                            }
                        }
                    }
                }

                $firstname = $this->convertUnicodeString(Yii::$app->request->post('firstname'));
                $lastname = $this->convertUnicodeString(Yii::$app->request->post('lastname'));
                $occupation = $this->convertUnicodeString(Yii::$app->request->post('occupation'));
                $domain = parse_url(Yii::$app->request->post('domain'), PHP_URL_HOST);
                $linkedin_company_page = Yii::$app->request->post('linkedin_company_page');
                $companyName = $this->convertUnicodeString(Yii::$app->request->post('name'));
                if (!empty($companyName)) {
                    $organizations = $client->getOrganizations();
                    $orgData['term'] = $companyName;
                    $orgData['start'] = 0;
                    $organization = $organizations->findOrganizationsByName($orgData);
                    if (isset($organization->data) && !empty($organization->data)) {
                        if (1 <= count($organization->data) && count($organization->data) > 0) {
                            for ($f = count($organization->data) - 1; 0 <= $f; $f--) {
                                if (isset($organization->data[$f]->id) && !empty($organization->data[$f]->id)) {
                                    $pipedriveOrgId = $organization->data[$f]->id;
                                    break;
                                }
                            }
                        }
                    }
                    if (empty($pipedriveOrgId)) {
                        $orgDataArr = array('name' => $companyName);
                        if (!empty($pipedriveOwner))
                            $orgDataArr['owner_id'] = array($pipedriveOwner);
                        if (!empty($pipedriveContactPrivacy))
                            $orgDataArr['visible_to'] = $pipedriveContactPrivacy;
                        $newOrganization = $organizations->addAnOrganization($orgDataArr);
                        if (isset($newOrganization->success) && $newOrganization->success == 1)
                            $pipedriveOrgId = $newOrganization->data->id;
                    }
                }

                $data = array(
                    'name' => $firstname . ' ' . $lastname,
                    'first_name' => $firstname,
                    'last_name' => $lastname,
                    'linkedin_uid' => Yii::$app->request->post('linkedin_uid'),
                    'linkedin' => Yii::$app->request->post('linkedInURL'),
                    'jobtitle' => $occupation,
                    'contact_source' => 'LinkedIn',
                    'contact_assigned_by' => Yii::$app->request->post('contact_assigned_by'),
                    //$userPrflArr['sequenceSiteTitle'] => $userPrflArr['sequenceName']
                    'sequence_name' => $sequenceName,
                );

                if (!empty($domain))
                    $data['website'] = $domain;
                if (!empty($pipedriveOrgId))
                    $data['org_id'] = $pipedriveOrgId;
                if (!empty($email)) {
                    $emls = array($email);
                    if (is_array($emls))
                        $data['email'] = $emls;
                }else {
                    $email = "";
                    $emls = array($email);
                    if (is_array($emls))
                        $data['email'] = $emls;
                }
                if (!empty($phoneNumber)) {
                    $phnNumber = array($phoneNumber);
                    if (is_array($phnNumber))
                        $data['phone'] = $phnNumber;
                }else {
                    $phoneNumber = "";
                    $phnNumber = array($phoneNumber);
                    if (is_array($phnNumber))
                        $data['phone'] = $phnNumber;
                }
                if (!empty($pipedriveOwner))
                    $data['owner_id'] = array($pipedriveOwner);

                $personFields = $client->getPersonFields();
                $prsnFlds = $personFields->getAllPersonFields();

                if (isset($prsnFlds->success) && $prsnFlds->success == 1) {
                    $pipedriveFlds = $prsnFlds->data;
                    if (isset($prsnFlds->data) && !empty($prsnFlds->data)) {
                        $pipedriveFldsArr = array();
                        foreach ($prsnFlds->data as $dt) {
                            $pipedriveFldsArr[] = $dt->name;
                            if (isset($data[$dt->name])) {
                                $data[$dt->key] = $data[$dt->name];
                                unset($data[$dt->name]);
                            }
                        }
                    }
                }
                if (!empty($pipedriveContactId)) {
                    $data['id'] = $pipedriveContactId;
                    try {
                        $updatePerson = $persons->updateAPerson($data);
                        if (isset($updatePerson->success) && $updatePerson->success == 1 && isset($updatePerson->data->id) && !empty($updatePerson->data->id)) {
                            $response = $updatePerson->data->id;
                        }
                    } catch (\Pipedrive\APIException $e) {
                        // Invalid API key
                    }
                } else {
                    try {
                        if (!empty($pipedriveContactPrivacy))
                            $data['visible_to'] = $pipedriveContactPrivacy;
                        $newPerson = $persons->addAPerson($data);
                        if (isset($newPerson->success) && $newPerson->success == 1){
                            $pipedriveContactId = $newPerson->data->id;
                            $response = $newPerson->data->id;
                        }
                        if (isset($msgSeq) && $msgSeq == '0') {
                            $deals = $client->getDeals();
                            $body = array('title' => $firstname . ' ' . $lastname . ' Deal', 'person_id' => $pipedriveContactId);
                            if (!empty($pipedriveOwner)) {
                                $body['creator_user_id'] = $pipedriveOwner;
                                $body['user_id'] = $pipedriveOwner;
                            }
                            if (!empty($pipedriveOrgId))
                                $body['org_id'] = $pipedriveOrgId;
                            if (!empty($pipedriveContactPrivacy))
                                $body['visible_to'] = $pipedriveContactPrivacy;
                            if (!empty($pipedriveDefaultStage))
                                $body['stage_id'] = $pipedriveDefaultStage;
                            $dl = $deals->addADeal($body);

                            if (isset($dl->success) && $dl->success == 1) {
                                $dealId = $dl->data->id;
                                $activities = $client->getActivities();
                                $collection = array(
                                    'subject' => 'Invitation Accepted',
                                    'type' => 'task',
                                    'done' => 1,
                                    'dealId' => $dealId,
                                    'personId' => $pipedriveContactId,
                                    'note' => ''
                                );

                                if (!empty($pipedriveOwner))
                                    $collection['userId'] = $pipedriveOwner;
                                if (!empty($pipedriveOrgId))
                                    $collection['orgId'] = $pipedriveOrgId;

                                $addActivity = $activities->addAnActivity($collection);
                            }
                        }
                        if (isset($newPerson->success) && $newPerson->success == 1 && isset($newPerson->data->id) && !empty($newPerson->data->id)) {
                            $response = $newPerson->data->id;
                        }
                    } catch (\Pipedrive\APIException $e) {
                        // Invalid API key
                    }
                }
            }
        }
        $thread = Yii::$app->db->createCommand("select thread from conversations where userId=$userId and personId=" . Yii::$app->request->post('personId'))->queryScalar();
        if (!empty($thread) && !empty($response)) {
            sleep(1);
            $this->logToPipedrive($userId, Yii::$app->request->post('personId'), json_decode($thread, TRUE));
        }
        if ($response) {
            return $response;
        } else {
            return false;
        }
    }

    function logToPipedrive($userId, $personIdForPipedrive, $thread) {
        include('../web/config.php');
        $accessKeySql = $con->query("SELECT access_key FROM intigration where `user_id`='" . $userId . "'");
        $integrationAccessKey = $accessKeySql->fetch_assoc();
        if (!empty($integrationAccessKey)) {
            $accessKey = json_decode($integrationAccessKey['access_key']);
            (!empty($accessKey->pipedrive)) ? $pipedrive = $accessKey->pipedrive : $pipedrive = 0;
            (!empty($accessKey->pipedrive_api_key)) ? $pipedrive_api_key = $accessKey->pipedrive_api_key : $pipedrive_api_key = '';
            (!empty($accessKey->pipedriveOwner)) ? $pipedriveOwner = $accessKey->pipedriveOwner : $pipedriveOwner = '';
            (!empty($accessKey->pipedriveDefaultStage)) ? $pipedriveDefaultStage = $accessKey->pipedriveDefaultStage : $pipedriveDefaultStage = '';
        } else {
            $pipedrive = 0;
            $pipedrive_api_key = '';
            $pipedriveOwner = '';
            $pipedriveDefaultStage = '';
        }

        if (!empty($pipedrive_api_key) && !empty($personIdForPipedrive)) {
            include '../api/pipedrive/pipedrive-config.php';
            $client = new \Pipedrive\Client(null, null, null, $pipedrive_api_key);
            try {
                $term = $personIdForPipedrive;
                $persons = $client->getPersons();
                $collect = array('term' => $term, 'start' => 0, 'searchByEmail' => 0);
                $personSearch = $persons->findPersonsByName($collect);

                if (isset($personSearch->success) && $personSearch->success == 1 && !empty($personSearch->data)) {
                    $personDeals = $persons->listDealsAssociatedWithAPerson(array('id' => $personSearch->data[0]->id, 'start' => 0));
                    if (isset($personDeals->success) && $personDeals->success == 1 && !empty($personSearch->data)) {
                        if (isset($personDeals->data[0]->id)) {
                            $dealId = $personDeals->data[0]->id;
                        } else {
                            $dealId = "";
                        }
                    } else {
                        $dealId = '';
                    }
                    if (!empty($thread)) {
                        $userSql = $con->query("SELECT firstName, lastName FROM user_profile where `user_id`='" . $userId . "'");
                        $userForFullNm = $userSql->fetch_assoc();
                        if (!empty($userForFullNm)) {
                            $nm = '';
                            if (isset($userForFullNm['firstName']) && !empty($userForFullNm['firstName']))
                                $nm .= $userForFullNm['firstName'] . ' ';
                            if (isset($userForFullNm['lastName']) && !empty($userForFullNm['lastName']))
                                $nm .= $userForFullNm['lastName'];
                        }

                        if (!empty($dealId))
                            $noteCollection['dealId'] = $dealId;
                        $noteCollection['personId'] = $personSearch->data[0]->id;

                        if (!empty($pipedriveOwner))
                            $noteCollection['userId'] = $pipedriveOwner;
                        if (isset($personSearch->data[0]->orgId) && !empty($personSearch->data[0]->orgId))
                            $noteCollection['orgId'] = $personSearch->data[0]->orgId;

                        foreach ($thread as $thrd) {
                            if (isset($thrd['msg']) && !empty($thrd['msg'])) {
                                if (isset($thrd['type']) && $thrd['type'] == 'I') {
                                    $prepend = $personSearch->data[0]->name . ' said: ';
                                } elseif (isset($thrd['type']) && $thrd['type'] == 'S') {
                                    $prepend = (!empty($nm)) ? $nm . ' said: ' : '';
                                } else {
                                    $prepend = '';
                                }

                                $noteCollection['content'] = $prepend . preg_replace("/\n\s+/", "\n", rtrim(html_entity_decode(strip_tags($thrd['msg']))));
                                $noteCollection['addTime'] = date('Y-m-d H:i:s', $thrd['createdAt'] / 1000);
                                $notes = $client->getNotes();
                                $thredTime = strtotime(date('Y-m-d H:i:s', $thrd['createdAt'] / 1000));

                                $allNotes = $notes->getAllNotes($noteCollection);
                                if (isset($allNotes->data) && !empty($allNotes->data)) {
                                    $lastTime = strtotime(end($allNotes->data)->addTime);
                                    if ($lastTime < $thredTime) {
                                        $nts = $notes->addANote($noteCollection);
                                    }
                                } else {
                                    $nts = $notes->addANote($noteCollection);
                                }
                            }
                        }
                    }
                }
            } catch (\Pipedrive\APIException $e) {
                // Invalid API key
            }
        }
    }

    function convertUnicodeString($str, $encoding = null) {
        if (is_null($encoding))
            $encoding = ini_get('mbstring.internal_encoding');
        return preg_replace_callback('/u([0-9a-fA-F]{4})/u', function($match) use ($encoding) {
            return mb_convert_encoding(pack('H*', $match[1]), $encoding, 'UTF-16BE');
        }, $str);
    }
	
	public function actionGetsequencesname(){
		 $seqid = Yii::$app->request->post('seqid');
		 $seqName = Yii::$app->db->createCommand("select name from  ext_sequences  where id in (" . $seqid.")")->queryColumn();
		 echo implode(',',$seqName);
	}

}
