<?php
namespace app\controllers;
use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\db\Query;

class MessageconfirmationController extends Controller
{
	public $enableCsrfValidation = false;
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
			'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }
	public function actionIndex() {
		$query = new Query();
		$data = $query->select('id,fullname,profileid,message,status,created_at')
		->from('apporval_messages')
		->where(['userid' => Yii::$app->session->get('userid')])
		->andWhere(['status' => 'waiting']);
		$responseTerm = Yii::$app->session->get('responseTerm');
		if(!empty($responseTerm)){
			$query->andFilterWhere ( [ 'OR' ,
				[ 'like' , 'fullname' , $responseTerm ],
				[ 'like' , 'status' , $responseTerm ],
				[ 'like' , 'created_at' , $responseTerm ],
				[ 'like' , 'sent_on' , $responseTerm ],
			] );
		}
        $dataProvider = new ActiveDataProvider([
            'query' => $data,
			'pagination' => [
				'pageSize' => 20,
			],
        ]);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
       
    }
	public function actionDeleteajax(){
		if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		$id = Yii::$app->request->post('id');
		if(Yii::$app->db->createCommand("DELETE from `apporval_messages` WHERE `id` = '" . $id . "'")->execute()){
			return true;
		}else{
			return false;
		}
    }
	public function actionSetresponsefilter(){
		if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		
		$responseTerm = Yii::$app->request->post('term');
		
		if(!empty($responseTerm)){
			Yii::$app->session->set('responseTerm', $responseTerm);
		}else{
			Yii::$app->session->remove('responseTerm');
		}
    }
	
	
	/* Start Sequence*/
	
	public function actionStartSequence(){
		$user_id=Yii::$app->session->get('userid');
		/* Update Status of Link */
			
		$read_all_data=Yii::$app->db->createCommand("select * from `ext_sequences` WHERE `id` = 3 and status in ('Active','Not Started','Fetching')")->queryOne();
		
		if($read_all_data){
			$update_status=Yii::$app->db->createCommand("UPDATE `ext_links` SET `status` = 'Active' WHERE `id` = 3")->execute();			
			$update_stat=Yii::$app->db->createCommand("UPDATE `ext_sequences` SET `status` = 'Active' WHERE `id` = 3")->execute();
			
			$read_all=Yii::$app->db->createCommand("select * from `ext_links` WHERE `id` = 3 and status='Active' ORDER BY `order` ASC")->queryOne();
			
			
			$read_all_seq=Yii::$app->db->createCommand("select * from `ext_sequences` WHERE `id` = 3 and status in ('Active','Not Started')")->queryOne();
		
			$link=$read_all['link'];
			$link_id=$read_all['id'];
			$webhookVal=$read_all_data['webhookVal'];
			if(empty($read_all))
			{
				echo "Status-Completed:mail Code";
			}
			
			if (strpos($link, "www.dummyorgin.dummy") !== false && $webhookVal != '1'){
				
				echo "1";
				$read_all_data=Yii::$app->db->createCommand("select * from `ext_sequences` WHERE `id` = 3 and status in ('Active','Not Started')")->queryOne();
				if($read_all_data){
					
				}
				
			}
			elseif($webhookVal == '1')
			{	
				echo "2";
			}
			elseif (strpos($link, "linkedin.com/mynetwork/invite-connect/connections/") !== false)
			{
				echo "3";
			}elseif ($read_all_seq['status'] == 'Active' || $read_all_seq['status'] == 'Not Started')
			{
				echo "4";
				if($read_all_seq['status'] == 'Active' &&  strpos($link, "www.dummyorgin.dummy") == false )
				{
					echo "5";
					echo "fdsfdsfds";
					$pagesFetched = 0;
					$status='Fetching';
					$fetchStarted=round(microtime(true) * 1000);
					
					$update_link_data=Yii::$app->db->createCommand("UPDATE `ext_links` SET `status` = '".$status."',pagesFetched='".$pagesFetched."',fetchStarted='".$fetchStarted."' WHERE `id` = '".$link_id."'")->execute();
					
					if($update_link_data){
						if (strpos($link, "www.dummyorgin.dummy") !== false && $webhookVal != '1')
						{
							echo "Dummy link & webhook not equal to 1";
						}else{
							
							if(strpos($link, "results/people/v2/?") == false)
							{	
								if($read_all['voyagerLink']){
									/* if voyagerLink*/
									echo "Voyagar link";
								}else{
									echo "Sequence Process ( Count,check blacklist ,send invitation , add into blacklilst,Zap)";
									
									
								}
							}
						}
					}
				}
			}
		
		}
	}	
	/* End Sequence */
	public function actionSend_message(){
		
		if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		
		$id = Yii::$app->request->post('id');
		/* $myCookie =Yii::$app->request->post('cookie');*/
		$myCookie =Yii::$app->request->post('cookie');  
        $profileID =Yii::$app->request->post('recipient');
        $message = str_replace('"', '', nl2br($_POST['message']));
        $cs = Yii::$app->request->post('csrf');
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://www.linkedin.com/voyager/api/messaging/conversations?action=create",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => '{"conversationCreate":{"eventCreate":{"value":{"com.linkedin.voyager.messaging.create.MessageCreate":{"body":"' . $message . '","attachments":[]}}},"recipients":["' . $profileID . '"],"subtype":"MEMBER_TO_MEMBER"},"keyVersion":"LEGACY_INBOX"}',
            CURLOPT_HTTPHEADER => array(
                ":authority:www.linkedin.com",
                "accept: application/json",
                "cookie: $myCookie",
                "csrf-token: $cs",
                "x-requested-with: XMLHttpRequest",
                "x-restli-protocol-version: 2.0.0"
            )
        ));
        $res = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
		
		$update_data=Yii::$app->db->createCommand("UPDATE `apporval_messages` SET `status` = 'sent' WHERE `id` = '".$id."'")->execute();

    }
	
}