<?php

namespace app\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\db\Query;

class InsightlyController extends Controller {

    public $enableCsrfValidation = false;
    public $company_array = ["name" => "Name", "domain" => "Domain", "linkedin_company_page" => "Linkedin Company Page"];
    public $contact_array = ["job_title" => "Job Title", "first_name" => "First Name", "last_name" => "Last Name", "email" => "Email", "linkedin_uid" => "Linkedin Uid", "linkedin" => "Linkedin",
        "contact_source" => "Contact Source", "contact_assigned_by" => "Contact Assigned By", "sequence_name" => "Sequence Name", "account_id" => "Account Id",
        "org_id" => "Org Id", "phone" => "Phone"];

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions() {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    //Developed by Dharmesh Tandel
    /**
     * Displays homepage.
     *
     * @return string
     */
    public function beforeAction($action) {
        if (empty(Yii::$app->session->get('userid'))) {
            $loginUrl = Yii::$app->request->baseUrl . "/login";
            return $this->redirect($loginUrl);
        }
        return parent::beforeAction($action);
    }

    public function actionIndex() {

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }
        $userid = Yii::$app->session->get('userid');


        $TokenData = Yii::$app->db->createCommand("select  insightly_api_key, insightly_status  from  crm_token where user_id=" . $userid)->queryOne();


        if (!empty($TokenData['insightly_api_key'])) {
            if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'edit') {

                $api_key = $TokenData['insightly_api_key'];
                $api_key = base64_encode($api_key);

                $is_valid_token = $this->is_valid_token($api_key);


                if (isset($is_valid_token['Message'])) {
                    //echo "Invalid Api key or Api key is expired.";
                    return $this->render('index', [
                                'contactRow' => '',
                                'companyRow' => '',
                                'contactfieldsCloseIo' => '',
                                'contactFieldsPortal' => '',
                                'companyfieldsCloseIo' => '',
                                'companyFieldsPortal' => '',
                                'loggedin' => false,
                                'TokenData' => '',
                    ]);
                }


                $MapingData = Yii::$app->db->createCommand("select  mapping_fileds  from  crm_field_mapping where crm_name='insightly' and user_id=" . $userid)->queryOne();




                $UserFields = json_decode($MapingData['mapping_fileds'], true);




                $contactRow = $UserFields['contact'];


                $companyRow = $UserFields['company'];



                $sobj = "Contacts";
                $contactfieldsCloseIo = $this->get_custom_fields($sobj, $api_key);



                $sobj = "Organisations";
                $companyfieldsCloseIo = $this->get_custom_fields($sobj, $api_key);

                $loggedin = true;
            } else {
                $contactRow = "";
                $companyRow = "";
                $contactfieldsCloseIo = "";
                $companyfieldsCloseIo = "";
                $loggedin = true;
            }
        } else {
            $contactRow = "";
            $companyRow = "";
            $contactfieldsCloseIo = "";
            $companyfieldsCloseIo = "";
            $loggedin = false;
        }



        return $this->render('index', [
                    'contactRow' => $contactRow,
                    'companyRow' => $companyRow,
                    'contactfieldsCloseIo' => $contactfieldsCloseIo,
                    'contactFieldsPortal' => $this->contact_array,
                    'companyfieldsCloseIo' => $companyfieldsCloseIo,
                    'companyFieldsPortal' => $this->company_array,
                    'loggedin' => $loggedin,
                    'TokenData' => $TokenData,
        ]);
    }

    public function actionAddfield() {


        $userid = Yii::$app->session->get('userid');
        $formData = $_REQUEST;

        $finalArr = array();

        $closeIoFields_contact = $formData['selContactProperty'];
        $portalFields_contact = $formData['selContactFormat'];
        $contactArr = array_combine($closeIoFields_contact, $portalFields_contact);
        $finalArr['contact'] = [];
        foreach ($contactArr as $key => $value) {
            if (!empty($key) && !empty($value)) {
                $finalArr['contact'][$key] = $value;
            }
        }

        $closeIoFields_company = $formData['selCompanyProperty'];
        $portalFields_company = $formData['selCompanyFormat'];
        $companyArr = array_combine($closeIoFields_company, $portalFields_company);

        //$finalArr['company'] = $companyArr;

        $finalArr['company'] = [];
        foreach ($companyArr as $key => $value) {
            if (!empty($key) && !empty($value)) {
                $finalArr['company'][$key] = $value;
            }
        }

        $maping_fileds = json_encode($finalArr);

        $MappingDetail = Yii::$app->db->createCommand("select  *  from  crm_field_mapping where user_id=" . $userid)->queryOne();
        if (empty($MappingDetail)) {

            $result = Yii::$app->db->createCommand("INSERT INTO `crm_field_mapping`(`crm_name`,`user_id`,`mapping_fileds`) VALUES ('insightly','" . $userid . "','" . $maping_fileds . "')")->execute();
        } else {

            $result = Yii::$app->db->createCommand("UPDATE `crm_field_mapping` SET `mapping_fileds`='" . $maping_fileds . "' WHERE  `user_id`='" . $userid . "' and crm_name='insightly'")->execute();
            $result = 1;
        }

        $response = array("status" => false, "message" => "Error in updating mapping data.");
        if ($result) {
            $response = array("status" => true, "message" => "Mapping data updated successfully.");
        }

        return json_encode($response);
    }

    public function actionUpdatestatus() {
        $userid = Yii::$app->session->get('userid');
        $formData = $_REQUEST;
        $status = $formData['id'];
        $result = Yii::$app->db->createCommand("UPDATE `crm_token` SET `insightly_status`='" . $status . "' WHERE  `user_id`='" . $userid . "'")->execute();
        $result = 1;

        $response = array("status" => false, "message" => "Error in updating status.");
        if ($result) {
            $response = array("status" => true, "message" => "Status updated successfully.");
        }
        return json_encode($response);
    }

    public function actionSaveapikey() {

        $response = array("status" => true, "message" => "Api key updated successfully.");

        $userid = Yii::$app->session->get('userid');
        $formData = $_REQUEST;
        $api_key = $formData['api_key'];

        $is_valid_token = $this->is_valid_token($api_key);
        if (isset($is_valid_token['error'])) {

            $response = array("status" => false, "message" => "Invalid api key or api key is expired.");
            return json_encode($response);
        }


        $default_data = array("contact" => array("TITLE" => "job_title", "FIRST_NAME" => "first_name", "LAST_NAME" => "last_name", "EMAIL_ADDRESS" => "email", "PHONE" => "phone", "SOCIAL_LINKEDIN" => "linkedin"), "company" => array("ORGANISATION_NAME" => "name", "WEBSITE" => "domain", "SOCIAL_LINKEDIN" => "linkedin_company_page"));


        $custom_contact_fields = array("LINKEDIN_UID" => "Linkedin Uid", "CONTACT_SOURCE" => "Contact Source", "CONTACT_ASSIGNED_BY" => "Contact Assigned By", "SEQUENCE_NAME" => "Sequence Name", "ACCOUNT_ID" => "Account Id", "ORG_ID" => "Org Id");

        if ($this->is_user_exist_in_token_table($userid)) {


            $result = Yii::$app->db->createCommand("UPDATE `crm_token` SET `insightly_api_key`='" . $api_key . "' WHERE  `user_id`='" . $userid . "'")->execute();
            $response = array("status" => true, "message" => "Api key updated successfully.");


            $all_custom_fields = $this->get_all_custom_fields('Contacts', $api_key);

            if (!$this->is_mapping_data_exist($userid)) {
                foreach ($custom_contact_fields as $cKey => $ctm_data) {
                    $temp_id = array_search($ctm_data, $all_custom_fields);
                    if (!$temp_id) {
                        $cfId = $this->create_custom_field('Contact', $ctm_data, 'text', $api_key);
                    } else {
                        $cfId = $temp_id;
                    }

                    if (isset($cfId) && !empty($cfId)) {
                        $default_data['contact'][$cfId] = $cKey;
                    }
                }
                $default_data = json_encode($default_data);
                $sqlInsertFields = Yii::$app->db->createCommand("INSERT INTO `crm_field_mapping`(`crm_name`,`user_id`,`mapping_fileds`) VALUES ('insightly','" . $userid . "','" . $default_data . "')")->execute();
            }


            return json_encode($response);
        } else {



            $result = Yii::$app->db->createCommand("INSERT INTO `crm_token`(`user_id`,`insightly_api_key`,`insightly_status`) VALUES ('" . $userid . "','" . $api_key . "','1')")->execute();
            $all_custom_fields = $this->get_all_custom_fields('Contact', $api_key);

            if ($result) {
                foreach ($custom_contact_fields as $cKey => $ctm_data) {
                    $temp_id = array_search($ctm_data, $all_custom_fields);
                    if (!$temp_id) {
                        $cfId = $this->create_custom_field('contact', $ctm_data, 'text', $api_key);
                    } else {
                        $cfId = $temp_id;
                    }

                    if (isset($cfId) && !empty($cfId)) {
                        $default_data['contact'][$cfId] = $cKey;
                    }
                }


                $default_data = json_encode($default_data);

                /*
                  if(!$this->check_is_custom_activity_exist($api_key)){
                  $this->create_default_activity_and_fields($api_key);
                  }
                 */

                $sqlInsertFields = Yii::$app->db->createCommand("INSERT INTO `crm_field_mapping`(`crm_name`,`user_id`,`mapping_fileds`) VALUES ('insightly','" . $userid . "','" . $default_data . "')")->execute();
            }




            //return $result;

            $response = array("status" => false, "message" => "Error in updating Api key.");
            if ($result) {
                $response = array("status" => true, "message" => "Api key updated successfully.");
            }
            return json_encode($response);
        }
    }

    function get_custom_fields($sobj, $api_key) {


        $company_array = array(array("name" => "ORGANISATION_NAME", "label" => "Name"), array("name" => "WEBSITE", "label" => "Domain"), array("name" => "SOCIAL_LINKEDIN", "label" => "Linkedin Url"));
        $contact_array = array(array("name" => "TITLE", "label" => "Title"), array("name" => "FIRST_NAME", "label" => "First Name"), array("name" => "LAST_NAME", "label" => "Last Name"), array("name" => "EMAIL_ADDRESS", "label" => "Email"), array("name" => "PHONE", "label" => "Phone"), array("name" => "SOCIAL_LINKEDIN", "label" => "Linkedin"));
        $dataArray = [];


        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://api.na1.insightly.com/v3.0/CustomFields/$sobj");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 0);
        $headers = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'X-Http-Method-Override: GET';
        $headers[] = 'Authorization: Basic ' . $api_key;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $datas = curl_exec($ch);
        curl_close($ch);

        $datas = json_decode($datas, true);




        if (isset($datas) && count($datas)) {
            foreach ($datas as $key => $data) {

                if (isset($data['FIELD_NAME']) && $data['FIELD_NAME'] != '') {
                    switch ($sobj) {
                        case "Organisations":
                            $company_array[] = array("name" => $data['FIELD_NAME'], "label" => $data['FIELD_LABEL'], "is_custom" => true);
                            break;
                        case "Contacts":
                            $contact_array[] = array("name" => $data['FIELD_NAME'], "label" => $data['FIELD_LABEL'], "is_custom" => true);
                            break;
                    }
                }
            }
        }


        if ($sobj == 'Contacts') {
            return $contact_array;
        }

        if ($sobj == 'Organisations') {
            return $company_array;
        }
    }

    public function actionAddcontactrow() {
        $userid = Yii::$app->session->get('userid');

        $TokenData = Yii::$app->db->createCommand("select  *  from  crm_token where user_id=" . $userid)->queryOne();
        $mappingFieldData = Yii::$app->db->createCommand("select  mapping_fileds  from  crm_field_mapping where crm_name='insightly' and user_id=" . $userid)->queryOne();
        $mappingFileds = json_decode($mappingFieldData['mapping_fileds'], true);


        $api_key = $TokenData['insightly_api_key'];
        $api_key = base64_encode($api_key);


        $sobj = "Contacts";
        $ContactfieldsCloseIo = $this->get_custom_fields($sobj, $api_key);




        $contactFieldsPortal = $this->contact_array;
        $html = '<tr class="contactRowNumber_1">
                    <td>
                        <select name="selContactProperty[]" class="select2 form-control contactFieldSelect" style="width: 300px;" data-group="Contact" data-width="fit"><option  value="" >Select Field</option>';
        foreach ($ContactfieldsCloseIo as $contactfields) {
            $disabeled = "";

            if (array_key_exists($contactfields['name'], $mappingFileds['contact'])) {
                $disabeled = "disabled";
            }
            $html .= '<option  value="' . $contactfields['name'] . '" ' . $disabeled . '>' . $contactfields['label'] . '</option>';
        }
        $html .= '</select></td>';
        $html .= '<td>
                    <select class="select2 form-control" name="selContactFormat[]"><option  value="" >Select Field</option>';
        foreach ($contactFieldsPortal as $key => $value) {
            $html .= '<option value="' . $key . '" >' . $value . '</option>';
        }
        $html .= '</select>
                    </td>
                    <td>
                    <span><i class="bx bxs-trash deleteRow" title="This property can not be edited or deleted."></i></span>
                    </td>
                    </tr>';
        echo $html;
        exit;
    }

    public function actionAddcompanyrow() {
        $userid = Yii::$app->session->get('userid');

        $TokenData = Yii::$app->db->createCommand("select  *  from  crm_token where user_id=" . $userid)->queryOne();
        $mappingFieldData = Yii::$app->db->createCommand("select  mapping_fileds  from  crm_field_mapping where crm_name='insightly' and user_id=" . $userid)->queryOne();

        $mappingFileds = json_decode($mappingFieldData['mapping_fileds'], true);

        $api_key = $TokenData['insightly_api_key'];
        $api_key = base64_encode($api_key);
        $sobj = "Organisations";
        $CompanyfieldsCloseIo = $this->get_custom_fields($sobj, $api_key);
        $companyFieldsPortal = $this->company_array;

        $html = '<tr class="companyRowNumber_1">
                    <td>
                        <select name="selCompanyProperty[]" class="select2 form-control" style="width: 300px;" data-group="Company" data-width="fit"><option  value="" >Select Field</option>';
        foreach ($CompanyfieldsCloseIo as $companyfields) {
            $disabeled = "";
            if (array_key_exists($companyfields['name'], $mappingFileds['company'])) {
                $disabeled = "disabled";
            }
            $html .= '<option  value="' . $companyfields['name'] . '" ' . $disabeled . '>' . $companyfields['label'] . '</option>';
        }
        $html .= '</select></td>';
        $html .= '<td>
                    <select class="select2 form-control" name="selCompanyFormat[]"><option  value="" >Select Field</option>';
        foreach ($companyFieldsPortal as $key => $value) {
            $html .= '<option value="' . $key . '" >' . $value . '</option>';
        }
        $html .= '</select>
                    </td>
                        <td>
                            <span><i class="bx bxs-trash deleteRow" title="This property can not be edited or deleted."></i></span>
                        </td>
                </tr>';
        echo $html;
        exit;
    }

    function is_mapping_data_exist($uid) {
        $result = Yii::$app->db->createCommand("select id from crm_field_mapping where crm_name='insightly' AND user_id=" . $uid)->queryOne();
        if ($result) {
            return true;
        } else {
            return false;
        }
        /*
          $sql1 = "select id from crm_field_mapping where crm_name='insightly' AND user_id=".$uid." limit 1";
          $result1 = $conn->query($sql1);

          return $result1->num_rows;
         */
        //return false;
    }

    function is_user_exist_in_token_table($uid) {

        $result = Yii::$app->db->createCommand("select id from crm_token where user_id=" . $uid)->queryOne();
        if (isset($result['id']) && !empty($result['id'])) {
            return true;
        } else {
            return false;
        }
    }

    function create_default_activity_and_fields($api_key) {

        $data = ["name" => "Linkedin Message", "description" => "Linkedin Message", "api_create_only" => false];

        $data = json_encode($data);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.close.com/api/v1/custom_activity/');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_USERPWD, $api_key);

        $headers = array();
        $headers[] = 'Content-Type: application/json';
        //$headers[] = 'X-Http-Method-Override: GET';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $json_response = curl_exec($ch);
        $response = json_decode($json_response, true);

        if (curl_errno($ch)) {
            //return curl_errno($ch);	   
        }
        curl_close($ch);

        if ($response['id']) {

            $data = ["name" => "Linkedin Message", "type" => "text", "accepts_multiple_values" => false, "custom_activity_type_id" => $response['id']];
            $data = json_encode($data);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://api.close.com/api/v1/custom_field/activity/');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_USERPWD, $api_key);

            $headers = array();
            $headers[] = 'Content-Type: application/json';
            //$headers[] = 'X-Http-Method-Override: GET';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $json_response = curl_exec($ch);
            $response1 = json_decode($json_response, true);

            if (curl_errno($ch)) {
                //return curl_errno($ch);	   
            }
            curl_close($ch);

            $data = ["name" => "User Id", "type" => "text", "accepts_multiple_values" => false, "custom_activity_type_id" => $response['id']];

            $data = json_encode($data);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://api.close.com/api/v1/custom_field/activity/');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_USERPWD, $api_key);

            $headers = array();
            $headers[] = 'Content-Type: application/json';
            //$headers[] = 'X-Http-Method-Override: GET';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $json_response = curl_exec($ch);
            $response2 = json_decode($json_response, true);

            if (curl_errno($ch)) {
                //return curl_errno($ch);	   
            }
            curl_close($ch);

            $data = ["name" => "Lead Id", "type" => "text", "accepts_multiple_values" => false, "custom_activity_type_id" => $response['id']];
            //$data = json_encode($data);

            $data = json_encode($data);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://api.close.com/api/v1/custom_field/activity/');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_USERPWD, $api_key);

            $headers = array();
            $headers[] = 'Content-Type: application/json';
            //$headers[] = 'X-Http-Method-Override: GET';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $json_response = curl_exec($ch);
            $response2 = json_decode($json_response, true);

            if (curl_errno($ch)) {
                //return curl_errno($ch);	   
            }
            curl_close($ch);
        }
    }

    function create_custom_field($obj, $custom_field_name, $custom_field_type, $api_key) {
        if (isset($custom_field_name) && !empty($custom_field_name) && isset($custom_field_type) && !empty($custom_field_type)) {
            $data = array("name" => $custom_field_name, "type" => $custom_field_type);
            $data = json_encode($data);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://api.close.com/api/v1/custom_field/' . $obj . '/');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_USERPWD, $api_key);

            $headers = array();
            $headers[] = 'Content-Type: application/json';
            //$headers[] = 'X-Http-Method-Override: GET';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $json_response = curl_exec($ch);
            $response = json_decode($json_response, true);

            if (isset($response['id']) && !empty($response['id'])) {
                return $response['id'];
            }
            return false;
            //if (curl_errno($ch)) {
            //return curl_errno($ch);	   
            //}
            curl_close($ch);
        }
        return false;
    }

    function get_all_custom_fields($sobj, $api_key) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://api.na1.insightly.com/v3.0/CustomFields/Contact");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 0);
        $headers = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'X-Http-Method-Override: GET';
        $headers[] = 'Authorization: Basic ' . $api_key;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $datas = curl_exec($ch);
        curl_close($ch);

        $datas = json_decode($datas, true);



        //if (curl_errno($ch)) {	
        //  return false;
        //}
        $finalArray = [];

        if (!empty($datas)) {
            foreach ($datas as $data) {
                $finalArray[$data['FIELD_NAME']] = $data['FIELD_LABEL'];
            }
        }
        return $finalArray;
        curl_close($ch);
    }

    function is_valid_token($api_key) {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://api.na1.insightly.com/v3.0/Organisations");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 0);
        $headers = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'X-Http-Method-Override: GET';
        $headers[] = 'Authorization: Basic ' . $api_key;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $datas = curl_exec($ch);
        curl_close($ch);

        $datas = json_decode($datas, true);

        if (isset($datas['Message'])) {
            return false;
        }

        return true;
    }

    //----

    function check_is_custom_activity_exist($api_key) {

        $status = false;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://api.close.com/api/v1/custom_activity/");

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        //curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_USERPWD, $api_key);

        $headers = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'X-Http-Method-Override: GET';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $datas = curl_exec($ch);

        $datas = json_decode($datas, true);

        if (curl_errno($ch)) {

            $status = false;
        }
        if (isset($datas['data']) && !empty($datas['data'])) {
            foreach ($datas['data'] as $key => $data) {

                if ($data['name'] == "Linkedin Message") {
                    $status = true;
                }
            }
        }

        return $status;
        curl_close($ch);
    }

    public function actionDisconnectinsightly() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $userid = Yii::$app->session->get('userid');
        Yii::$app->db->createCommand("UPDATE `crm_token` SET `insightly_api_key`=NUll WHERE  `user_id`='" . $userid . "'")->execute();
        return true;
    }

}
