<?php

namespace app\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\db\Query;

class HyperiseController extends Controller {
public $enableCsrfValidation = false;
    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions() {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    public function beforeAction($action) {
        if (empty(Yii::$app->session->get('userid'))) {
            $loginUrl = Yii::$app->request->baseUrl . "/login";
            return $this->redirect($loginUrl);
        }
        return parent::beforeAction($action);
    }

    public function actionIndex() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }
        $userid = Yii::$app->session->get('userid');

        $TokenData = Yii::$app->db->createCommand("select  id,userId,api_key  from  hyperise_integration where userId=" . $userid)->queryOne();

        $id = $TokenData['id'];
        $api_key = $TokenData['api_key'];

        return $this->render('index', [
                    'id' => $id,
                    'api_key' => $api_key,
                    'TokenData' => $TokenData,
        ]);
    }

    public function actionSaveapikey() {

        $response = array("status" => true, "message" => "Api key updated successfully.");
        $userid = Yii::$app->session->get('userid');
        $formData = $_REQUEST;
        $api_key = $formData['api_key'];
        $record_id = $formData['record_id'];
        if (isset($record_id) && empty($record_id)) {
            $sqlInsert = Yii::$app->db->createCommand("INSERT INTO `hyperise_integration`(`userId`,`api_key`) VALUES ('" . $userid . "','" . $api_key . "')")->execute();
            if ($sqlInsert) {
                $response = array("status" => true, "message" => "API key saved successfully.");
                return json_encode($response);
            }
        }
        if (isset($record_id) && !empty($record_id)) {
            $sqlUpdate = Yii::$app->db->createCommand("UPDATE `hyperise_integration` SET `api_key`='" . $api_key . "' WHERE  `id`='" . $record_id . "'")->execute();
            $response = array("status" => true, "message" => "API key updated successfully.");
            return json_encode($response);
        }
    }

    public function actionDisconnectinsightly() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $userid = Yii::$app->session->get('userid');
        Yii::$app->db->createCommand("DELETE FROM `hyperise_integration` WHERE `userId` = $userid")->execute();
        return true;
    }

}
