<?php

namespace app\controllers;

use Yii;
use yii\db\Query;
use yii\web\Controller;
use DateTime;
use yii\web\NotFoundHttpException;
use app\models\Webhook;
use yii\data\Pagination;

class HooksController extends Controller {

    /**
     * Lists all Webhhok models.
     * @return mixed
     */
    public function beforeAction($action) {
        $this->enableCsrfValidation = false;
        return parent::beforeAction($action);
    }

    public function actionIndex() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }

        $query = Webhook::find()->where(['w_user_id' => Yii::$app->session->get('userid')]);
        $countQuery = clone $query;
        $pages = new Pagination(['totalCount' => $countQuery->count()]);
        $models = $query->offset($pages->offset)
                ->limit($pages->limit)
                ->orderBy(['w_id' => SORT_DESC])
                ->all();
        $keyDetail = Yii::$app->db->createCommand("select access_key from  intigration  where user_id =" . Yii::$app->session->get('userid'))->queryOne();

        return $this->render('index', [
                    'webhooks' => $models,
                    'pages' => $pages,
                    'keyDetail' => json_decode($keyDetail['access_key']),
        ]);
    }

    public function actionAddwebhook() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $userid = Yii::$app->session->get('userid');
        $keyDetail = Yii::$app->db->createCommand("SELECT  *  from  intigration  where user_id =" . $userid)->queryAll();
        if (sizeof($keyDetail) > 0) {
            $keyData = json_decode($keyDetail[0]['access_key'], true);
            if (isset($keyData) && array_key_exists("Webhooks", $keyData)) {
                $keyData['Webhooks'] = $_POST['testzapurl'];
            } else {
                $keyData['Webhooks'] = $_POST['testzapurl'];
            }
            $row = json_encode($keyData);
            $sql = Yii::$app->db->createCommand("UPDATE intigration SET access_key='" . $row . "' where user_id='" . $userid . "'")->execute();
        } else {
            $row['Webhooks'] = $_POST['testzapurl'];
            $row = json_encode($row);
            $sql = Yii::$app->db->createCommand("INSERT INTO `intigration`(`user_id`,`access_key`) VALUES ('" . $userid . "','" . $row . "')")->execute();
        }
    }

    /**
     * Creates a new Webhook model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        //echo "<pre>";print_r($_POST);die;
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $model = new Webhook();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        return $this->render('create', [
                    'model' => $model,
        ]);
    }

    public function actionCheckseq() {
        $sid = $_POST['sid'];
        $uid = $_POST['uid'];

        $sql = "SELECT w_id FROM `webhooks` where w_seq_id ='" . $sid . "' and w_user_id = '" . $uid . "'";
        $data = Yii::$app->db->createCommand($sql)->queryOne();

        if (!empty($data)) {
            echo '1';
            die;
        } else {
            echo '0';
            die;
        }
    }

}
