<?php

namespace app\controllers;

use Yii;
use yii\db\Query;
use yii\web\Controller;
use DateTime;
use yii\web\NotFoundHttpException;
use app\models\Webhook;
use yii\data\Pagination;

class HooksController extends Controller {

    /**
     * Lists all Webhhok models.
     * @return mixed
     */
    public function beforeAction($action) {
        $this->enableCsrfValidation = false;
        return parent::beforeAction($action);
    }

    public function actionIndex() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }

        $query = Webhook::find()->where(['w_user_id' => Yii::$app->session->get('userid'), 'w_type' => '0']);
        $countQuery = clone $query;
        $pages = new Pagination(['totalCount' => $countQuery->count()]);
        $models = $query->offset($pages->offset)
                ->limit($pages->limit)
                ->orderBy(['w_id' => SORT_DESC])
                ->all();
        $keyDetail = Yii::$app->db->createCommand("select access_key from  intigration  where user_id =" . Yii::$app->session->get('userid'))->queryOne();
        $webHookGoogleDetail = Yii::$app->db->createCommand("select * from  webhooks as W LEFT JOIN spreadsheet_info as S ON W.w_seq_id=S.seqid  where W.w_type='1' and W.w_user_id =" . Yii::$app->session->get('userid') . " ORDER BY W.w_id DESC")->queryAll();
        $webHookzapapp = Yii::$app->db->createCommand("select S.name,S.zapier_action,S.status,S.id,W.w_id,W.created_at from  webhooks as W LEFT JOIN ext_sequences as S ON W.w_seq_id=S.id  where S.zapier_action='1' and W.w_user_id =" . Yii::$app->session->get('userid') . " ORDER BY W.w_id DESC")->queryAll();
        $getTimezone = Yii::$app->db->createCommand("SELECT TimeZone FROM user where id =  " . Yii::$app->session->get('userid'))->queryOne();
        $user_timezone = $getTimezone['TimeZone'];



        return $this->render('index', [
                    'webhooks' => $models,
                    'webHookGoogleDetail' => $webHookGoogleDetail,
                    'webHookzapdata' => $webHookzapapp,
                    'user_timezone' => $user_timezone,
                    'pages' => $pages,
                    'keyDetail' => json_decode($keyDetail['access_key']),
        ]);
    }

    public function getseqstatus($seqId) {
        $keyDetail = Yii::$app->db->createCommand("select status from  ext_sequences  where id =" . $seqId)->queryOne();
        return $keyDetail['status'];
    }

    public function getwebhookpro($seqId) {

        $keyDetail = Yii::$app->db->createCommand("select count(id) as countrec from  webhook_profiles  where seq_id =" . $seqId)->queryOne();
        return $keyDetail['countrec'];
    }

    public function getwebhookprocessed($seqId) {

        $keyDetail = Yii::$app->db->createCommand("select count(id) as countrec from  webhook_profiles  where  status='1' and seq_id =" . $seqId)->queryOne();
        return $keyDetail['countrec'];
    }

    public function actionGetwebhookprofiles() {
        $seqId = $_POST['seqId'];
        $userId = $_POST['userId'];
        $keyDetail = Yii::$app->db->createCommand("select profile_link,status from  webhook_profiles where seq_id =" . $seqId . " and user_id=$userId")->queryAll();
        echo json_encode($keyDetail);
    }

    public function actionUpdateautoimport() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $id = $_POST['id'];
        $autoimport = $_POST['autoimport'];
        $sql = Yii::$app->db->createCommand("UPDATE spreadsheet_info SET autoimport='" . $autoimport . "' where id='" . $id . "'")->execute();
    }

    public function actionAddwebhook() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $userid = Yii::$app->session->get('userid');
        $keyDetail = Yii::$app->db->createCommand("SELECT  *  from  intigration  where user_id =" . $userid)->queryAll();
        if (sizeof($keyDetail) > 0) {
            $keyData = json_decode($keyDetail[0]['access_key'], true);
            if (isset($keyData) && array_key_exists("Webhooks", $keyData)) {
                $keyData['Webhooks'] = $_POST['testzapurl'];
            } else {
                $keyData['Webhooks'] = $_POST['testzapurl'];
            }
            $row = json_encode($keyData);
            $sql = Yii::$app->db->createCommand("UPDATE intigration SET access_key='" . $row . "' where user_id='" . $userid . "'")->execute();
        } else {
            $row['Webhooks'] = $_POST['testzapurl'];
            $row = json_encode($row);
            $sql = Yii::$app->db->createCommand("INSERT INTO `intigration`(`user_id`,`access_key`) VALUES ('" . $userid . "','" . $row . "')")->execute();
        }
    }

    /**
     * Creates a new Webhook model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        //echo "<pre>";print_r($_POST);die;
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $model = new Webhook();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        return $this->render('create', [
                    'model' => $model,
        ]);
    }

    public function actionCheckseq() {
        $sid = $_POST['sid'];
        $uid = $_POST['uid'];

        $sql = "SELECT w_id FROM `webhooks` where w_seq_id ='" . $sid . "' and w_user_id = '" . $uid . "'";
        $data = Yii::$app->db->createCommand($sql)->queryOne();

        if (!empty($data)) {
            echo '1';
            die;
        } else {
            echo '0';
            die;
        }
    }

}
