<?php

namespace app\controllers;

use Yii;
use yii\web\User;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\Pagination;
use yii\db\Query;
use yii\web\JsonParser;

/**
 * BlacklistController implements the CRUD actions for Blacklist model.
 */
class FirstdegreeController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }


	 public function unicodeString($str, $encoding = null) {
        if (is_null($encoding))
            $encoding = ini_get('mbstring.internal_encoding');
        return preg_replace_callback('/u([0-9a-fA-F]{4})/u', function($match) use ($encoding) {
            return mb_convert_encoding(pack('H*', $match[1]), $encoding, 'UTF-16BE');
        }, $str);
    }

    /**
     * Lists all Blacklist models.
     * @return mixed
     */
    function actionIndex() {

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		
		$query = new Query;
		 $seq_filter = '';
		 if (isset($_GET['searchname']) && isset($_GET['searchname']) != "") {
			 $seq_filter = str_replace("'","\'", $_GET['searchname']);
		 }
		$query->select(['b.id', 'b.fullName', 'b.emailID', 'b.phoneNumbers','b.locationName', 'b.linkedinpublicid','b.url_publicIdentifier','b.occupation','b.companyDetail','b.sequenceIds','b.response','b.tags'])
				->from('1stdegreedata b')
				->where(['userId' => Yii::$app->session->get('userid')]);
		if($seq_filter != ''){
				$query->andWhere("b.fullName LIKE '%" . $seq_filter . "%'");
		}
				
		$countQuery = clone $query;
		
		 $pages = new Pagination(['totalCount' => $countQuery->select('count(b.id)')->scalar()]);
         $models = $query->offset($pages->offset)
			->limit($pages->limit)
			->orderBy(['id' => 'desc'])->all();
        
		
        return $this->render('index',['firstdegreedata' => $models,'pages' => $pages]);
    }
	
	public function actionExportdata()
	{
		
		if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		
		//echo '<pre>'; print_r($_REQUEST);
		
		  $OFFSET = $_REQUEST['from_number'];
		  $LIMIT  = $_REQUEST['to_number'];
		
	      $lead_title = 'FirstDegree';
		
		  $exportData = Yii::$app->db->createCommand("SELECT fullName,emailID,phoneNumbers,locationName,linkedinpublicid,url_publicIdentifier,occupation,companyDetail,sequenceIds FROM 1stdegreedata WHERE  userId =" . Yii::$app->session->get('userid') . " ORDER BY id ASC LIMIT ".$LIMIT." OFFSET ".$OFFSET."")->queryAll();
		  
		  //echo "SELECT fullName,emailID,phoneNumbers,locationName,linkedinpublicid,url_publicIdentifier,occupation,companyDetail,sequenceIds FROM 1stdegreedata WHERE  userId =" . Yii::$app->session->get('userid') . " ORDER BY id ASC LIMIT ".$LIMIT." OFFSET ".$OFFSET.""; exit;
		
		$data = ",,,," . Yii::$app->params['sitetitle'] . " Export data ,\r\nTime," . date('Y-m-d h:m:s') . " (UTC + 00),,Type," . $lead_title . "\r\n\r\nFullName,Profile Email,LI Profile URL,Occupation,Location Name,Profile Phone,Company Name,Job Title,Sequences\r\n";
		
		foreach ($exportData as $data_export) {
            //echo $val;
            $fullname = $data_export['fullName'];
            $emailID = $data_export['emailID'];
            $phoneNumbers = $data_export['phoneNumbers'];
            $locationName = $data_export['locationName'];
            $url_publicIdentifier = $data_export['url_publicIdentifier'];
			$occupation = $data_export['occupation'];
            $company_detail = $data_export['companyDetail'];
	        $company_detail = str_replace('""}', '"}', $company_detail);
	        $company_detail = str_replace('": ""', '": "', $company_detail);
	        $company_detail = str_replace('"", "', '", "', $company_detail);
	        $company_detail = str_replace(': ",', ': "",', $company_detail);
			$company_detail = json_decode($company_detail);
			//echo '<prE>'; print_r($company_detail); exit;
			
			
			
			$companyName = 'NA';
			if (isset($company_detail->companyName) && $company_detail->companyName != '') {
                $companyName = str_replace(",", "-", $company_detail->companyName);
            } else {
                $companyName = 'NA';
            }
			
			$jobtitle = 'NA';
			if (isset($company_detail->title) && $company_detail->title != '') {
                $jobtitle = str_replace(",", "-", $company_detail->title);
            } else {
                $jobtitle = 'NA';
            }
			 
			 
		   
		   $seqnamesarr = array();
		    if(isset($data_export['sequenceIds']) && $data_export['sequenceIds'] != '')
			{
				$seqidsarry = explode(",",$data_export['sequenceIds']);
				
				foreach($seqidsarry as $srow){
					
					$seqname = Yii::$app->db->createCommand("select name from ext_sequences where id =" . $srow)->queryOne();
					$seqnamesarr[] = $seqname['name'];
				}
			} 
			
			$seqnamestext = 'NA';
			
			if(empty($seqnamesarr)){
				$seqnamestext = 'NA';
			}else{
				$seqnamestext = implode("~",$seqnamesarr);	
			}

			//echo $seqnamestext; exit;

            if (isset($fullname)) {
               $fullname = str_replace(",", "-", $this->unicodeString($fullname));
                //$firstName = $basicInfo->firstName;
            } else {
                $fullname = "NA";
            }
           
            if (isset($occupation)) {
                $occupation = str_replace(",", "-", $this->unicodeString($occupation));
            } else {
                $occupation = "NA";
            }
           
           
            if (isset($locationName) && !empty($locationName)) {
                $locationName = str_replace(",", "-", $locationName);
            } else {
                $locationName = "NA";
            }

            if (isset($emailID) && $emailID != '') {
					$emailID = str_replace(",", "-", $emailID);
				
            } else{
				    
					$emailID = "NA";
			}
          

            if (isset( $phoneNumbers) &&  $phoneNumbers != '') {
                 $phoneNumbers =  $phoneNumbers;
            } else {
                 $phoneNumbers = "NA";
            }

            

          
            if (isset($url_publicIdentifier)) {
                $url_publicIdentifier = "https://www.linkedin.com/in/" . $url_publicIdentifier;
            } else {
                $url_publicIdentifier = "NA";
            }
			
            //echo 'here'; exit;

            $data .= $fullname .
					',' . $emailID .
					',' . $url_publicIdentifier .
                    ',' . $occupation .
                    ',' . $locationName .
                    ',' . $phoneNumbers .                    
                    ',' . $companyName .                    
                    ',' . $jobtitle .                    
                    ',' . $seqnamestext .                    
                    "\r\n";
        }




		header("Content-Encoding: UTF-8"); 
        //header("Content-type: text/csv");
		header('Content-Type: application/csv; charset=UTF-8');
        header("Content-Disposition: attachment; filename=" . $lead_title . ".csv");
        header("Pragma: no-cache");
        header("Expires: 0");

        echo $data . "\n";
        die;
		
	}

}
