<?php

namespace app\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\db\Query;

class ChannelpartnerController extends Controller {
    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions() {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

   
	   public function beforeAction($action) {
		$this->enableCsrfValidation = false;
		return parent::beforeAction($action);
	}
	   
    /**
     * Displays homepage.
     *
     * @return string
     */
    

    public function actionIndex() {
	
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		
		$portal_id = Yii::$app->session->get('portal_id');
		
		
		$channeldata = Yii::$app->db->createCommand("SELECT id from `channel_partners` where `channel_owners`='".\Yii::$app->session->get('userid')."' LIMIT 1")->queryOne();
		
		//echo "SELECT id from `channel_partners` where `channel_owners`='".\Yii::$app->session->get('userid')."' LIMIT 1"; exit;
		
		$channel_id = 0;
		if(!empty($channeldata)){
			$channel_id = $channeldata['id'];
		}
		
		
		$UserDetails = [];
		$lead_plans = [];
		
		if($channel_id > 0){
		
			if (\Yii::$app->request->post() && empty(\Yii::$app->request->post('teamid'))) {
				if (isset($_REQUEST['msg'])) {
					$SearchType = Yii::$app->request->post('SearchType');
					$customQuery = '';
					if ($SearchType == 'fname') {
						$customQuery = "WHERE first_name = '" . trim(\Yii::$app->request->post('search_user')) . "'";
					} else if ($SearchType == 'lname') {
						$customQuery = "WHERE last_name = '" . trim(\Yii::$app->request->post('search_user')) . "'";
					} else if ($SearchType == 'merchantid') {
						$customQuery = "WHERE merchant_id = '" . trim(\Yii::$app->request->post('search_user')) . "'";
					} else {
						$customQuery = "WHERE email LIKE '" . trim(\Yii::$app->request->post('search_user')) . "'";
					}
				}

				// dev005 - new search on 08 Jan 2020
				$SearchType = Yii::$app->request->post('SearchType');
				$customQuery = '';

				if ($SearchType == 'fname') {
					$customQuery = "WHERE first_name LIKE '%" . trim(\Yii::$app->request->post('search_user')) . "%'";
				} else if ($SearchType == 'lname') {
					$customQuery = "WHERE last_name LIKE '%" . trim(\Yii::$app->request->post('search_user')) . "%'";
				} else if ($SearchType == 'merchantid') {
					$customQuery = "WHERE merchant_id LIKE '%" . trim(\Yii::$app->request->post('search_user')) . "%'";
				} else {
					$customQuery = "WHERE email LIKE '%" . trim(\Yii::$app->request->post('search_user')) . "%'";
				}


				$srcbysublevel = Yii::$app->request->post('srcbysublevel');
				$customQuery2 = '';
				if ($srcbysublevel != '' && $customQuery != '') {
					$customQuery2 = " AND user.sublevel LIKE '%" . \Yii::$app->request->post('srcbysublevel') . "%'";
				}


				$UserDetails = Yii::$app->db->createCommand("SELECT `user`.* , `user_payment_history`.`status` , `user_payment_history`.`id` as user_payment_history_id FROM `user` LEFT JOIN user_payment_history ON `user_payment_history`.`userid` = `user`.`id` " . $customQuery . " " . $customQuery2 . " and user.portal_id='" . $portal_id . "' and user.channel_id = '".$channel_id."' GROUP BY `user`.`id` ")->queryAll();

			} else {
				if (!empty(\Yii::$app->request->post('teamid'))) {

					$UserDetails = Yii::$app->db->createCommand("SELECT * FROM `user` WHERE `teamid` = '" . \Yii::$app->request->post('teamid') . "' and portal_id='" . $portal_id . "' and channel_id = '".$channel_id."'")->queryAll();

				}
			}
			
		   $lead_plans = Yii::$app->db->createCommand("SELECT sublevel,name FROM `lead_plans` order by sublevel")->queryAll();
		}
		
        return $this->render('index',[
                    'users' => $UserDetails,
                    'lead_plans' => $lead_plans,
        ]);
    }

}
