<?php

namespace app\controllers;

use Yii;
use app\models\Blacklistcompany;
use app\models\BlacklistcompanySearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\Pagination;

/**
 * BlacklistcompanyController implements the CRUD actions for Blacklistcompany model.
 */
class BlacklistcompanyController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Blacklistcompany models.
     * @return mixed
     */
    public function actionIndex() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }
        $searchModel = new BlacklistcompanySearch();
        // $searchModel->user_id = Yii::$app->session->get('userid'); 
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        if (isset($_GET['searchname']) && $_GET['searchname'] != "") {
            $name = $_GET['searchname'];
            $pages = new Pagination(['totalCount' => count($dataProvider->query->all())]);
            $models = $dataProvider->query->offset($pages->offset)
                            ->where("company_name LIKE '%" . $name . "%' OR company_url LIKE '%" . $name . "%'")
                            ->andWhere(['user_id' => Yii::$app->session->get('userid')])
                            ->limit($pages->limit)
                            ->orderBy(['id' => SORT_DESC])->all();
        } else {
            $pages = new Pagination(['totalCount' => count($dataProvider->query->all())]);
            $models = $dataProvider->query->offset($pages->offset)
                            ->where(['user_id' => Yii::$app->session->get('userid')])
                            ->limit($pages->limit)
                            ->orderBy(['id' => SORT_DESC])->all();
        }

        // print_r($models);

        return $this->render('index', [
                    'blacklistcmp' => $models,
                    'pages' => $pages,
        ]);
        /* return $this->render('index', [
          'searchModel' => $searchModel,
          'dataProvider' => $dataProvider,
          ]); */
    }

    /**
     * Displays a single Blacklistcompany model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Blacklistcompany model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (Yii::$app->session->get('user_role') == 1) {
            $url = \Yii::$app->request->baseUrl . "/dashboard";
            return $this->redirect($url);
        }
        $model = new Blacklistcompany();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        return $this->render('create', [
                    'model' => $model,
        ]);
    }

    /**
     * Updates an existing Blacklistcompany model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        return $this->render('update', [
                    'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Blacklistcompany model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Blacklistcompany model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Blacklistcompany the loaded model
     * @throws NotFoundHttpException if the model cannot be found 
     */
    protected function findModel($id) {
        if (($model = Blacklistcompany::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionBlacklistcompanylist() {
        
    }

    public function actionImportcsv() {
        $error = array();
        $csv_arr = array();
        $filename = $_FILES["file"]["tmp_name"];
        if ($_FILES["file"]["size"] > 0) {
            $file = fopen($filename, "r");
            $i = 0;
            while (($data = fgetcsv($file, 10000, ",")) !== FALSE) {
                $link = $data[0];
                $url = explode('/', $link);
                if (strpos($link, "linkedin") > 0) {
                    if (isset($url[3]) && $url[3] == 'company' && isset($url[4]) && $url[4] != '') {
                        $csv_arr[] = [
                            'company_url' => $link,
                            'company_id' => $url[4],
                            'user_id' => Yii::$app->session->get('userid'),
                            'company_name' => 'N/A',
                        ];
                    } else {
                        $error[$i]['link'] = $link;
                        $error[$i]['error'] = 'Invalid LinkedIn Url';
                        $i++;
                    }
                } else {
                    $error[$i]['link'] = $link;
                    $error[$i]['error'] = 'Invalid LinkedIn Url';
                    $i++;
                }
            }

            if (count($csv_arr) > 0) {
                $columnNameArray = ['company_url', 'company_id', 'user_id', 'company_name'];
                $insertCount = Yii::$app->db->createCommand()->batchInsert('blacklistcompany', $columnNameArray, $csv_arr)->execute();
            }
        }
        echo json_encode($error);
    }

}
