<?php

namespace app\controllers;

use Yii;
use yii\web\User;
use app\models\Blacklist;
use app\models\BlacklistSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\Pagination;
use yii\db\Query;
use yii\web\JsonParser;

/**
 * BlacklistController implements the CRUD actions for Blacklist model.
 */
class BlacklistController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Blacklist models.
     * @return mixed
     */
    function actionIndex() {

        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if (Yii::$app->session->get('user_role') == 1) {
            $this->redirect('dashboard');
        }
        $UserDetail = Yii::$app->db->createCommand("select  `addBlaklist_OnAcceptance`  from  user  where id =" . Yii::$app->session->get('userid'))->queryOne();
        $addBlaklist_OnAcceptance = $UserDetail['addBlaklist_OnAcceptance'];
        $searchModel = new BlacklistSearch();
        if ($addBlaklist_OnAcceptance == 1) {
            $searchModel->is_accepted = 1;
        }
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $dataProvider->pagination->pageSize = 10;
        $dataProvider->sort = ['defaultOrder' => ['id' => 'DESC']];
        if (isset($_GET['sortby']) && $_GET['sortby'] != '') {
            $sortby = $_GET['sortby'];
        } else {
            $sortby = 'id'; 
        }
        if (isset($_GET['sortorder']) && $_GET['sortorder'] != '') {
            if ($_GET['sortorder'] == 'asc') {
                $sortorder = SORT_ASC;
            } else {
                $sortorder = SORT_DESC;
            }
        } else {
            $sortorder = SORT_DESC; 
        }
		
		$seq_filter = '';
		
		if(isset($_REQUEST['myselect']) && !empty($_REQUEST['myselect'])){
			
			$seq_filter = ' AND b.seq_id = '.$_REQUEST['myselect'];
			 
		}
		
        if (isset($_GET['searchname']) && isset($_GET['searchname']) != "") {
            $query = new Query;
			$name = str_replace("'","\'", $_GET['searchname']);
            if ($_GET['searchname'] == "Added By Sequence") {
                $type = 1;
            } elseif ($_GET['searchname'] == "Manually Added") {
                $type = 2;
            } else {
				$type = str_replace("'","\'", $_GET['searchname']);
            }

            if ($addBlaklist_OnAcceptance == 1) {
                $query->select(['b.id', 'b.linkedinpublicid', 'b.type', 'b.url_publicIdentifier', 'b.firstName','b.seq_name'])
				->from('blacklist b')
				/* ->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id') */
				->where(['userid' => Yii::$app->session->get('userid')])
				->andWhere("url_publicIdentifier LIKE '%" . $name . "%' OR type LIKE '%" . $type . "%' OR b.firstName LIKE'%" . $name . "%'")
				->andWhere("b.flag=0 AND ((b.type=1 and b.is_accepted =1 ) OR b.type=2) AND b.type !=3 ".$seq_filter." ");						
            } else {
                $query->select(['b.id', 'b.linkedinpublicid', 'b.type', 'b.url_publicIdentifier','b.firstName', 'b.seq_name'])
				->from('blacklist b')
				/* ->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id') */
				->where(['userid' => Yii::$app->session->get('userid')])
				->andWhere("url_publicIdentifier LIKE '%" . $name . "%' OR type LIKE '%" . $type . "%' OR b.firstName LIKE'%" . $name . "%' OR seq_name LIKE'%" . $name . "%'")
				->andWhere("type !=3") 
				->andWhere("b.flag=0 ".$seq_filter." ");
            }
			
			
			
            $countQuery = clone $query;
            $pages = new Pagination(['totalCount' => $countQuery->select('count(b.id)')->scalar()]);
            $models = $query->offset($pages->offset)
			->limit($pages->limit)
			->orderBy([$sortby => $sortorder])->all();
        } else {
            $query = new Query;

            if ($addBlaklist_OnAcceptance == 1) {
                $query->select(['b.id', 'b.linkedinpublicid', 'b.type', 'b.url_publicIdentifier','b.firstName', 'b.seq_name'])
				->from('blacklist b')
				/* ->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id') */
				->where(' userid='.Yii::$app->session->get('userid').' AND flag=0 AND ((b.type=1 and b.is_accepted =1 ) OR b.type=2) '.$seq_filter.'');
            } else {
                $query->select(['b.id', 'b.linkedinpublicid', 'b.type', 'b.url_publicIdentifier','b.firstName', 'b.seq_name'])
				->from('blacklist b')
				/* ->join('LEFT OUTER JOIN', 'profileinfo p', 'p.id =b.profileInfo_id') */
				->where(['userid' => Yii::$app->session->get('userid'), 'flag' => 0])
				->andWhere('type !=3 '.$seq_filter.'');   
            }
            $countQuery = clone $query;
            $pages = new Pagination(['totalCount' => $countQuery->select('count(b.id)')->scalar()]);
            $models = $query->offset($pages->offset)
			->limit($pages->limit)
			->orderBy([$sortby => $sortorder])->all();
        }
		
		/* if (Yii::$app->session->get('useremail') == 'dhaval.thakor+123@intricare.net') {
		echo $query->createCommand()->getRawSql(); exit;
		}  */ 
		
		$model_sequ = Yii::$app->db->createCommand("select  id,name,status from  ext_sequences  where msgSeq=0 AND  user_id =" . Yii::$app->session->get('userid'))->queryAll();
		
        return $this->render('index', ['blacklistDetail' => $models,'pages' => $pages,'Allsequences' => $model_sequ]);
    }


    public function actionCheckpublicidentifier() {
        $url_publicIdentifier = Yii::$app->request->post('url_publicIdentifier');
        $userid = Yii::$app->session->get('userid');
        $rep_req_data = Yii::$app->db->createCommand("SELECT * FROM blacklist WHERE  userid = '" . $userid . "'  AND url_publicIdentifier='" . $url_publicIdentifier . "'")->queryAll();
        if (empty($rep_req_data)) {
            return 0;
        } else {
            return 1;
        }
    }

    public function actionBlackdata() {
        echo "blacklist data";
    }

    /**
     * Displays a single Blacklist model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Blacklist model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
		
        $model = new Blacklist();
        //echo $model->seq_name; echo 'in save'; die;

		if ($model->load(Yii::$app->request->post()) && $model->save()) {
			//return $this->redirect(['view', 'id' => $model->id]);
			return $this->redirect(['index']);
		}
		


        if (Yii::$app->session->get('user_role') == 1) {
            $url = \Yii::$app->request->baseUrl . "/dashboard";
            return $this->redirect($url);
        }

        return $this->render('create', [
                    'model' => $model,
        ]);
    }

    /**
     * Updates an existing Blacklist model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            //return $this->redirect(['view', 'id' => $model->id]);
            return $this->redirect(['index']);
        }

        return $this->render('update', [
                    'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Blacklist model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        //        $this->findModel($id)->delete();
        $sql = Yii::$app->db->createCommand("UPDATE `blacklist` SET `deleted_at` = '" . date("Y-m-d H:i:s") . "' WHERE `blacklist`.`id` =" . $id)->execute();
        $sql = Yii::$app->db->createCommand("INSERT INTO `blacklistdeleted` SELECT * FROM `blacklist` WHERE `blacklist`.`id` =" . $id)->execute();
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Blacklist model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Blacklist the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = Blacklist::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    /* For delete manual or automatic balcklist entries */

    public function actionDeleteblacklistuser() {

        $teamid = $_POST['teamid'];
        $type = $_POST['type'];
        try {
            $sql = Yii::$app->db->createCommand("INSERT INTO `blacklistdeleted` SELECT * FROM `blacklist` where teamid ='" . $teamid . "' and type = '" . $type . "'")->execute();
            $sql = Yii::$app->db->createCommand("delete from  blacklist  where teamid ='" . $teamid . "' and type = '" . $type . "'")->execute();
            echo '1';
        } catch (Exception $e) {
            echo 'Caught exception: ', $e->getMessage(), "\n";
        }
    }

    public function actionDeleteblacklistuserrow() {
        try {
            $sql = Yii::$app->db->createCommand("INSERT INTO `blacklistdeleted` SELECT * FROM `blacklist` where id ='" . $_POST['blacklistid'] . "'")->execute();
            $sql = Yii::$app->db->createCommand("delete from  blacklist  where id ='" . $_POST['blacklistid'] . "'")->execute();
            echo '1';
        } catch (Exception $e) {
            echo 'Caught exception: ', $e->getMessage(), "\n";
        }
    }

    public function actionDeleteblacklistprofiles() {

        $blacklistids = $_POST['delblkidslist'];
        $blacklistids = explode(",", $blacklistids);
        foreach ($blacklistids as $key => $value) {
            try {
                $sql = Yii::$app->db->createCommand("INSERT INTO `blacklistdeleted` SELECT * FROM `blacklist` where id ='" . $value . "'")->execute();
                $sql = Yii::$app->db->createCommand("delete from  blacklist  where id ='" . $value . "'")->execute();
                echo '1';
            } catch (Exception $e) {
                echo 'Caught exception: ', $e->getMessage(), "\n";
            }
        }
    }
	
	public function actionAddsuppressedblacklistprofiles() {
		$pId='';
        $blacklistids = $_POST['delblkidslist'];
        $blacklistids = explode(",", $blacklistids);
        foreach ($blacklistids as $key => $value) {
            try {
				$blacklistData=Yii::$app->db->createCommand("select linkedinpublicid,url_publicIdentifier from  blacklist  where id ='" . $value . "'")->queryOne();
				if(empty($blacklistData['personId'])){
					$personId ='';
					$user=Yii::$app->db->createCommand("select csrf,cookie,proxyIp,proxyPort,proxyUsername,proxyPassword,userAgent from  user  where id ='" . Yii::$app->session->get('userid') . "'")->queryOne(); 
					$csrf = $user['csrf'];
					$cookie = $user['cookie'];
					$proxyIp = $user['proxyIp'];
					$proxyPort = $user['proxyPort'];
					$proxyUsername = $user['proxyUsername'];
					$proxyPassword = $user['proxyPassword'];
					$userAgent = $user['userAgent']; 
					$curl = curl_init();
					curl_setopt_array($curl, array(
						CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $blacklistData['url_publicIdentifier'] . "/profileView",
						CURLOPT_RETURNTRANSFER => true,
						CURLOPT_ENCODING => "",
						CURLOPT_MAXREDIRS => 10,
						CURLOPT_TIMEOUT => 0,
						/* CURLOPT_VERBOSE => 1, */
						CURLOPT_HEADER => 1,
						CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
						CURLOPT_HTTPPROXYTUNNEL => 1,
						CURLOPT_PROXY => "$proxyIp",
						CURLOPT_PROXYPORT => "$proxyPort",
						CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
						CURLOPT_CUSTOMREQUEST => "GET",
						CURLOPT_HTTPHEADER => array(
							"cookie: $cookie",
							"csrf-token: $csrf",
							"x-http-method-override: GET",
							"Host: www.linkedin.com",
							"User-Agent: $userAgent",  
							"Accept-Language: en-US,en;q=0.5",
							"Accept-Encoding: gzip, deflate, br",
							"content-type: application/x-www-form-urlencoded",
							"x-li-lang: en_US",
							"x-restli-protocol-version: 2.0.0",
							"Origin: https://www.linkedin.com",
							"TE: Trailers"
						),
					));
					$profileViewResponse = curl_exec($curl);//print_r($res);
					$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
					$headers = substr($profileViewResponse, 0, $header_size);
					$profileViewResponse = substr($profileViewResponse, $header_size); 

					if (curl_errno($curl)) {
						
					} else {
						$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
						if($http_code == 200){
						$profileView = json_decode($profileViewResponse, true);
						$profId = $profileView['positionGroupView']['profileId'];
						$personId = explode(':', $profileView['profile']['miniProfile']['objectUrn'])[3];
						Yii::$app->db->createCommand("UPDATE blacklist set linkedinpublicid=" . $personId . " where id=".$value)->execute(); 
						}
					}
					
				}else{
					$personId=$blacklistData['linkedinpublicid'];
				}
				if(!empty($personId)){
					//echo "select id from  suppressionlist  where personId ='" . $personId . "' and teamId='".Yii::$app->session->get('teamid')."' and userId='".Yii::$app->session->get('userid')."'";exit;
					$checkSuppressed=Yii::$app->db->createCommand("select id from  suppressionlist  where personId ='" . $personId . "' and teamId='".Yii::$app->session->get('teamid')."' and userId='".Yii::$app->session->get('userid')."'")->queryOne();
					if(!$checkSuppressed['id']){
					Yii::$app->db->createCommand("INSERT INTO suppressionlist (personId, publicidentifier, userId, teamId,flag) values('" . $personId . "','" . $blacklistData['url_publicIdentifier'] . "','" . Yii::$app->session->get('userid') . "','" . Yii::$app->session->get('teamid') . "',1)")->execute();
					}
				}
                /* $sql = Yii::$app->db->createCommand("INSERT INTO `blacklistdeleted` SELECT * FROM `blacklist` where id ='" . $value . "'")->execute();
                $sql = Yii::$app->db->createCommand("delete from  blacklist  where id ='" . $value . "'")->execute(); */
               
            } catch (Exception $e) {
                echo 'Caught exception: ', $e->getMessage(), "\n";
            }
        }
    }
	
	public function actionRemovesuppressedblacklistprofiles() {
		$pId='';
        $blacklistids = $_POST['delblkidslist'];
        $blacklistids = explode(",", $blacklistids);
        foreach ($blacklistids as $key => $value) {
            try {
				$blacklistData=Yii::$app->db->createCommand("select linkedinpublicid,url_publicIdentifier from  blacklist  where id ='" . $value . "'")->queryOne();
				if(empty($blacklistData['personId'])){
					$personId ='';
					$user=Yii::$app->db->createCommand("select csrf,cookie,proxyIp,proxyPort,proxyUsername,proxyPassword,userAgent from  user  where id ='" . Yii::$app->session->get('userid') . "'")->queryOne(); 
					$csrf = $user['csrf'];
					$cookie = $user['cookie'];
					$proxyIp = $user['proxyIp'];
					$proxyPort = $user['proxyPort'];
					$proxyUsername = $user['proxyUsername'];
					$proxyPassword = $user['proxyPassword'];
					$userAgent = $user['userAgent']; 
					$curl = curl_init();
					curl_setopt_array($curl, array(
						CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $blacklistData['url_publicIdentifier'] . "/profileView",
						CURLOPT_RETURNTRANSFER => true,
						CURLOPT_ENCODING => "",
						CURLOPT_MAXREDIRS => 10,
						CURLOPT_TIMEOUT => 0,
						/* CURLOPT_VERBOSE => 1, */
						CURLOPT_HEADER => 1,
						CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
						CURLOPT_HTTPPROXYTUNNEL => 1,
						CURLOPT_PROXY => "$proxyIp",
						CURLOPT_PROXYPORT => "$proxyPort",
						CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
						CURLOPT_CUSTOMREQUEST => "GET",
						CURLOPT_HTTPHEADER => array(
							"cookie: $cookie",
							"csrf-token: $csrf",
							"x-http-method-override: GET",
							"Host: www.linkedin.com",
							"User-Agent: $userAgent",  
							"Accept-Language: en-US,en;q=0.5",
							"Accept-Encoding: gzip, deflate, br",
							"content-type: application/x-www-form-urlencoded",
							"x-li-lang: en_US",
							"x-restli-protocol-version: 2.0.0",
							"Origin: https://www.linkedin.com",
							"TE: Trailers"
						),
					));
					$profileViewResponse = curl_exec($curl);//print_r($res);
					$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
					$headers = substr($profileViewResponse, 0, $header_size);
					$profileViewResponse = substr($profileViewResponse, $header_size); 

					if (curl_errno($curl)) {
						
					} else {
						$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
						if($http_code == 200){
						$profileView = json_decode($profileViewResponse, true);
						$profId = $profileView['positionGroupView']['profileId'];
						$personId = explode(':', $profileView['profile']['miniProfile']['objectUrn'])[3];
						Yii::$app->db->createCommand("UPDATE blacklist set linkedinpublicid=" . $personId . " where id=".$value)->execute(); 
						}
					}
					
				}else{
					$personId=$blacklistData['linkedinpublicid'];
				}
				if(!empty($personId)){
					//echo "select id from  suppressionlist  where personId ='" . $personId . "' and teamId='".Yii::$app->session->get('teamid')."' and userId='".Yii::$app->session->get('userid')."'";exit;
					$checkSuppressed=Yii::$app->db->createCommand("DELETE from  suppressionlist  where personId ='" . $personId . "' and userId='".Yii::$app->session->get('userid')."'")->execute();
				}
                /* $sql = Yii::$app->db->createCommand("INSERT INTO `blacklistdeleted` SELECT * FROM `blacklist` where id ='" . $value . "'")->execute();
                $sql = Yii::$app->db->createCommand("delete from  blacklist  where id ='" . $value . "'")->execute(); */
               
            } catch (Exception $e) {
                echo 'Caught exception: ', $e->getMessage(), "\n";
            }
        }
    }
	
	public function actionAddsuppressed() {
		$pId='';
        $value = $_POST['delblkidslist'];
		$blacklistData=Yii::$app->db->createCommand("select linkedinpublicid,url_publicIdentifier from  blacklist  where id ='" . $value . "'")->queryOne();
		if(empty($blacklistData['personId'])){
			$personId ='';
			$user=Yii::$app->db->createCommand("select csrf,cookie,proxyIp,proxyPort,proxyUsername,proxyPassword,userAgent from  user  where id ='" . Yii::$app->session->get('userid') . "'")->queryOne(); 
			$csrf = $user['csrf'];
			$cookie = $user['cookie'];
			$proxyIp = $user['proxyIp'];
			$proxyPort = $user['proxyPort'];
			$proxyUsername = $user['proxyUsername'];
			$proxyPassword = $user['proxyPassword'];
			$userAgent = $user['userAgent']; 
			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => "https://www.linkedin.com/voyager/api/identity/profiles/" . $blacklistData['url_publicIdentifier'] . "/profileView",
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				/* CURLOPT_VERBOSE => 1, */
				CURLOPT_HEADER => 1,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_HTTPPROXYTUNNEL => 1,
				CURLOPT_PROXY => "$proxyIp",
				CURLOPT_PROXYPORT => "$proxyPort",
				CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
				CURLOPT_CUSTOMREQUEST => "GET",
				CURLOPT_HTTPHEADER => array(
					"cookie: $cookie",
					"csrf-token: $csrf",
					"x-http-method-override: GET",
					"Host: www.linkedin.com",
					"User-Agent: $userAgent",  
					"Accept-Language: en-US,en;q=0.5",
					"Accept-Encoding: gzip, deflate, br",
					"content-type: application/x-www-form-urlencoded",
					"x-li-lang: en_US",
					"x-restli-protocol-version: 2.0.0",
					"Origin: https://www.linkedin.com",
					"TE: Trailers"
				),
			));
			$profileViewResponse = curl_exec($curl);//print_r($res);
			$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
			$headers = substr($profileViewResponse, 0, $header_size);
			$profileViewResponse = substr($profileViewResponse, $header_size); 

			if (curl_errno($curl)) {
				
			} else {
				$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
				if($http_code == 200){
				$profileView = json_decode($profileViewResponse, true);
				$profId = $profileView['positionGroupView']['profileId'];
				$personId = explode(':', $profileView['profile']['miniProfile']['objectUrn'])[3];
				Yii::$app->db->createCommand("UPDATE blacklist set linkedinpublicid=" . $personId . " where id=".$value)->execute(); 
				}
			}
			
		}else{
			$personId=$blacklistData['linkedinpublicid'];
		}
		if(!empty($personId)){
			//echo "select id from  suppressionlist  where personId ='" . $personId . "' and teamId='".Yii::$app->session->get('teamid')."' and userId='".Yii::$app->session->get('userid')."'";exit;
			$checkSuppressed=Yii::$app->db->createCommand("select id from  suppressionlist  where personId ='" . $personId . "' and teamId='".Yii::$app->session->get('teamid')."' and userId='".Yii::$app->session->get('userid')."'")->queryOne();
			if(!$checkSuppressed['id']){
			Yii::$app->db->createCommand("INSERT INTO suppressionlist (personId, publicidentifier, userId, teamId,flag) values('" . $personId . "','" . $blacklistData['url_publicIdentifier'] . "','" . Yii::$app->session->get('userid') . "','" . Yii::$app->session->get('teamid') . "',1)")->execute();
			return Yii::$app->db->getLastInsertID();
			}
		}
		return false;
    }
	public function getpersoneblockid($personId) {
        $isblocked = 0; 
		//echo "select id from  suppressionlist  where teamId = " . Yii::$app->session->get('teamid') . "  AND personId =" . $personId; 
        $keyDetail = Yii::$app->db->createCommand("select id from  suppressionlist  where teamId = " . Yii::$app->session->get('teamid') . "  AND personId =" . $personId)->queryOne();
        if (isset($keyDetail['id']) && $keyDetail['id'] > 0) {
            $isblocked = $keyDetail['id'];
        }
        return $isblocked;
    }
    public function actionImportcsv() {
        $error = array();
        $csv_arr = array();
        $filename = $_FILES["file"]["tmp_name"];
        if ($_FILES["file"]["size"] > 0) {
            $file = fopen($filename, "r");
            $i = 0;
            while (($data = fgetcsv($file, 10000, ",")) !== FALSE) {
                $link = $data[0];
                $url = explode('/', $link);
                if (strpos($link, "linkedin") > 0) {
                    if (strpos($link, "/sales/people") > 0) {
                        $error[$i]['link'] = $link;
                        $error[$i]['error'] = 'Please enter valid public id from non-sales navigator profile';
                        $i++;
                    } else if (strpos($link, "/company") > 0) {
                        $error[$i]['link'] = $link;
                        $error[$i]['error'] = 'Enter valid Profile LinkedIn Public Id, use Company blacklist to blacklist the whole company';
                        $i++;
                    } else if (!isset($url[4])) {
                        $error[$i]['link'] = $link;
                        $error[$i]['error'] = 'Invalid LinkedIn Public Id';
                        $i++;
                    } else {
                        $url = explode('/', $link);
                        $csv_arr[] = [
                            'url_publicIdentifier' => $url[4],
                            'type' => '2',
                            'linkedinpublicid' => '',
                            'userid' => Yii::$app->session->get('userid'),
                            'teamid' => Yii::$app->session->get('teamid'),
                            'seq_name' => ''
                        ];
                    }
                } else {
                    $error[$i]['link'] = $link;
                    $error[$i]['error'] = 'Invalid LinkedIn Public Id';
                    $i++;
                }
            }

            if (count($csv_arr) > 0) {
                $columnNameArray = ['url_publicIdentifier', 'type', 'linkedinpublicid', 'userid', 'teamid', 'seq_name'];
                $insertCount = Yii::$app->db->createCommand()->batchInsert('blacklist', $columnNameArray, $csv_arr)->execute();
            }
        }
        echo json_encode($error);
    }

}
